//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Persistence of Vision 3.1 Include File   XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// File: TOMTREE.inc                        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Desc: BAUMGENERATOR FR POVRAY           XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Date: 25.11.1999                         XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
// Auth: AUST                               XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
/*
#include "TOMLEAF.inc"
//XXXXXXXXXXXXXXXXXXXXX S E T T I N G S XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//LEAF
#declare LEAF_TYPE=HF_LEAF5//Name of leaf, you find in TOMLEAF.inc: Simple URBLATT,LINDENBLATT,PALMBLATT or take better HF-leaves - or - create your own
#declare LEAF_LENGTH=30;//Length of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_BREADTH=15;//Width of leaf (I recommend, you imagine a tree with real dimensions, in cm);
#declare LEAF_THICKNESS=5;//Height of leaf (in cm; normally a leaf is very thin; but at leaves like a palmleaf it means the height of arch; 
#declare MAX_LEAF_TILT=5;//Tilt of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_TURN=5;//Turn of leaf (in degree; this is the amplitude, I have build in a scope);
#declare MAX_LEAF_INCLINATION=5;//Inclination of leaf (in degree; this is the amplitude, I have build in a scope);
//BLOSSOM
#declare BLOSSOM=HF_BLOS4//Name of blossom;
#declare BLOSSOM_LENGTH=15;//Length of blossom
#declare BLOSSOM_WIDTH=30;//Width of blossom
#declare BLOSSOM_INCLINATION=0;//Inclination of blossom
#declare BLOSSOM_COLOR=<1,1,1>;//Color of blossom
//BUNCH
#declare BUNCH_MAJOR_RADIUS=0;//Inner radius of bunches in cm; distance of the innermost leaf of a bunch from the twig
#declare BUNCH_MINOR_RADIUS=0;//Outer radius of bunches in cm; distance of the innermost leaf from the outermost leaf of a bunch
#declare HORIZONTAL_BUNCH_FUNNEL=10;//Horizontal opening of bunch in degree
#declare VERTICAL_BUNCH_FUNNEL=10;//Vertical opening of bunch in degree
#declare HORIZONTAL_BUNCH_INCLINATION=0;//Horizontal inclination of whole bunch from twig alignment in degree;
#declare VERTICAL_BUNCH_INCLINATION=90;//Vertical inclination of whole bunch from twig alignment in degree;
#declare HORIZONTAL_BUNCH_INCLINATION_SCOPE=0;//Scope of horizontal inclination in degree 
#declare VERTICAL_BUNCH_INCLINATION_SCOPE=0;//Scope of vertical inclination in degree
#declare BUNCH_TURN_SWITCH=0;//To turn on (1) or turn off (0) the rotation of the bunch around the twig 
#declare BUNCH_ALTERNATE_SWITCH=1;//Here you can decide if bunches should alternate reciprocal at the twig (1=yes;0=no)
#declare BUNCH_INCLINATION_SWITCH=0;//To align (1) or not (0) the bunch with the twig to the end of the twig; horizontal... 
#declare VERTICAL_BUNCH_INCLINTION_SWITCH=0;//...and vertical 
#declare BUNCH_TAPER_OFF_AT_BRANCH=.0;//Adjustment to decrease the size of the outer bunches/twigs at the branch
#declare BUNCH_TAPER_OFF_AT_TREE=0.0;//Adjustment to decrease the size of the bunches at the top of the tree
#declare BUNCH_DEFORM=<1,1,1>;//Simple scale of the whole bunch
//TWIG
#declare BUNCH_START_AT_TWIG=50;//Distance from the branch to the first bunch at the twig
#declare TWIG_LENGTH=100;//The length of the twig;
#declare TWIG_STRENGTH=.5;//Strength of twig; 0=no twig; decrease this value for saving parsingtime or increase it if the twig falls in pieces 
#declare TWIG_THICKNESS_CHANGE=.9;//Use this factor to change the thickness of the twig, that normally(1) depends on the thickness of the branch
#declare HORIZONTAL_TWIG_INCLINATION=0;//Horizontal inclination of twig with bunches to the branch in degree
#declare VERTICAL_TWIG_INCLINATION=90;//Vertical inclination of twig with bunches to the branch in degree
#declare HORIZONTAL_TWIG_INCLINATION_SCOPE=0;//Scope of horizontal inclination in degree  
#declare VERTICAL_TWIG_INCLINATION_SCOPE=0;//Scope of vertical inclination in degree
#declare TWIG_INCLINATION_SWITCH=0;//To align(1) or not(0) the twig/bunches with the branch to the end of the branch horizontal...
#declare VERTICAL_TWIG_INCLINATION_SWITCH=0;//...and vertical 
#declare TWIG_TURN_SWITCH=0;//To turn on (1) or turn off (0) the rotation of the twig around its longitudinal axis
#declare TWIG_ALTERNATE_SWITCH=1;//here you can decide if twigs should alternate reciprocal at the branch (1=yes;0=no) and don't turn aroung the branch
#declare TWIG_CURVE_ADJUSTMENT=1;//Here you can reduce (or increase) the curves of the twig which normally(1) depends on the curves of the branch
//BRANCH
#declare TWIG_START_AT_BRANCH=100;//Distance from the first/innermost twig at the branch to the trunk
#declare TWIG_RANGE_AT_BRANCH=300;//Distance from the innermost to the outermost twig at the branch
#declare BRANCH_THICKNESS_CHANGE=.75;//Factor for changing the thickness of the branch that normally(1) depends on the thickness of the trunk 
#declare BRANCH_STRENGTH=.5;//decrease this strength of branch to save parsingtime or increase it if the branch falls in pieces; 
#declare BRANCH_BEND=0;//Width of the outer bend of the branch
#declare BRANCH_BEND_FREQUENCY=1.5;//Frequency of the outer bend of the branch
#declare HORIZONTAL_BRANCH_BEND_SWITCH=1;//switch on (1) or off (0) the horizontal outer bend 
#declare BRANCH_CURVE=0;//Width of the inner bend that fit into the outer bend of the branch
#declare BRANCH_CURVE_FREQUENCY=3;//Frequency of the inner bend of the branch 
#declare HORIZONTAL_BRANCH_CURVE_SWITCH=1;//switch on (1) or off (0) the horizontal inner bend 
#declare BRANCH_LONGITUDINAL_CURVE=.5;//To adjust the curves along the longitudinal axis of the branch; 0=no inner bend in longitudinal direction; 1=equal to lateral direction
#declare BRANCH_SNAG=0;//Width of the innermost bend (knots, gnarled) of the branch - fit into inner bend
#declare BRANCH_SNAG_FREQUENCY=10;//Frequency of the innermost bend
#declare BRANCH_REDUCTION=0.0;//This reduces the length of branches towards the top of the trunk (1=highest branch is 0 cm)(0=same length of highest and lowest branch) 
#declare BRANCH_TAPER_OFF=1;//Adjustment, how fast the thickness of the branch goes to 0 towards its end
#declare BRANCH_END=1;//If you want that the branch ends at the outermost twig than set to 0; if you set it to 1, the branch ends one twiglength after the last twig 
#declare BRANCH_TURN_SWITCH=0;//Switch on (1) or off (0) the turn of the branches around its longitudinal axis
#declare BRANCH_ALTERNATE_SWITCH=1;//Here you decide, that branches alternate reciprocal at the trunk and don't turn around the trunk
#declare BRANCH_SPIRAL=0;//Additional spiral in the branch (in degree: 360 = turn around once) 
#declare BRANCH_INCLINATION=0;//Inclination of the lowest branch to the trunk (upwards the branches will align with the trunk automatically)
//TRUNK
#declare BRANCH_START_AT_TRUNK=200;//Distance from the ground to the first/lowest branch at the trunk
#declare BRANCH_RANGE_AT_TRUNK=400;//Distance from the first/lowest to the last/highest branch at the trunk
#declare TRUNK_RADIUS=20;//Radius of the trunkthickness
#declare TRUNK_STRENGTH=.5;//Strength of the trunk; you can increase the value if the trunk falls in pieces to close the line
#declare TRUNK_BEND_X=0;//Width of bend in x-direction
#declare TRUNK_BEND_Z=0;//Width of bend in z-direction
#declare TRUNK_BEND_X_FREQUENCY=1.5;//Frequency of x-bend
#declare TRUNK_BEND_Z_FREQUENCY=1.5;//Frequency of z-bend
#declare TRUNK_CURVE=0;//Width of inner bend (fit into bend) of the trunk
#declare TRUNK_CURVE_FREQUENCY=3;//Frequency of inner bend
#declare TRUNK_SNAG=0;//Width of innermost bend of the trunk (fit into the inner bend)
#declare TRUNK_SNAG_FREQUENCY=20;//Frequency of the innermost bend
#declare TRUNK_SPIRAL=0;//Additional spiral of the trunk in degrees (360 = turn around once)
#declare TRUNK_TAPER_OFF=1;//How fast the thickness of the trunk decreases towards the top of the tree (1=no thickness at top of tree; 0=same thickness at bottom and top)
#declare TRUNK_LENGTHENING=0;//To make the trunk longer(cm); 0 means that the trunk ends at the highest branch;
#declare PALM_TRUNK=0;//Makes a trunk with more heavy, regular knots, like a trunk of a palm (look at palm.inc);
//ROOT
#declare ROOT_THICKNESS_CHANGE=.4;//Change the thickness of the root that normally depends on the thickness of the trunk;
#declare ROOT_STRENGTH=.5;//Strength of the roots; decrease this value to save parsingtime or increase it if the root falls in piesces; 
#declare ROOT_TURN_SWITCH=1;//Switch on (1) or off (0) the turn around the root around its longitudinal axis
#declare ROOT_LENGTH=200;//Length of the root
#declare ROOT_INCLINATION=30;//The inclination of the uppermost root to the trunk in degree; starts(0) at horizontale, increase downwards;
#declare ROOT_BEND=0;//Width of the bend of the root 
#declare ROOT_BEND_FREQUENCY=1;//Frequency of the bend
#declare ROOT_SNAG=0;//Width of the inner bend of the root 
#declare ROOT_SNAG_FREQUENCY=5;//Frequency of the inner bend
#declare ROOT_START_AT_TRUNK=50;//Height(cm) of the uppermost root at the trunk
//BARK
#declare TRUNK_COLOR_1=<.1,0,-.1>;//First color of the bark representing its "valleys"; value lower than 0 for more deep and width
#declare TRUNK_COLOR_2=<0.5,0.3,0>;//Second color of the bark representing its "ridges" and seems to be the color of the trunk 
#declare TRUNK_SCAR_WIDTH=3;//Width of grain of bark(cm)  
#declare TRUNK_SCAR_HEIGHT=20;//Height of grain of bark(cm)
#declare SCAR_DEPTH=.1;//Depth of gnarled bark (it's a value for normal{})
#declare BARK_PROFILE=.6;//This is a "real" bark; similar to "PALM_TRUNK" but vertical;
#declare BRANCH_BARK_PROFILE_CHANGE=.5;//Here you can change the "BARK_PROFILE" for the branches (1=same as trunk; 0=no "BARK_PROFILE")
#declare ROOT_BARK_PROFILE_CHANGE=.5;//The same for the roots; branches and roots fall in pieces if their bark_profile is too high;
//FOLIAGECOLOR
#declare BOTTOM_COLOR_1=<0.5,0.4,0>;//First color of the lower leaves
#declare BOTTOM_COLOR_2=<0.4,0.5,0>;//Second color of the lower leaves
#declare TOP_COLOR_1=<0.5,0.5,0>;//First color of the upper leaves
#declare TOP_COLOR_2=<0.2,.8,0>;//Second color of the upper leaves
#declare COLOR_TURB=1;//Turbulence of these colors
#declare TRANSITION_BOTTOM_TOP=0.5;//Where the changing of these colors should start in vertical direction; it's relative to the height of the tree (0.5 = height_of_tree/2)
#declare TRANSITION_TURB=.5;//Turbulence in this changing of colors
#declare FOLIAGE_GLOSS=0.5;//If you want glossy leaves, set the value higher than 0 (like phong)
//TREE
#declare BRANCH_NUMBER=4;//The quantity of all branches at the tree
#declare TWIG_NUMBER=8;//The quantity of all twigs at the tree (the quantity of twigs at the branch is ZWEIGZAHL/ASTZAHL)
#declare BUNCH_NUMBER=24;//The quantity of all bunches at the tree (the quantity of bunches at the twig is STAUDENZAHL/ZWEIGZAHL)
#declare LEAF_NUMBER=48;//The quantity of all leaves at the tree
#declare BLOSSOM_NUMBER=0;//The quantity of all blossoms at the tree
#declare ROOT_NUMBER=4;//The quantity of all roots at the tree
#declare BRANCH_RANDOM=2917.3797;//Each value results in a new variation/arrangement of the equal branches and twigs/bunches - play with it! 
#declare ROOT_RANDOM=13;//The same for the roots
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
*/
#declare M_BL=LEAF_LENGTH+0.000001;
#declare M_BH=LEAF_THICKNESS+0.000001; 
#declare M_BB=LEAF_BREADTH+0.000001;
#declare M_BN_X=MAX_LEAF_TILT;
#declare M_BN_Y=MAX_LEAF_TURN;
#declare M_BN_Z=MAX_LEAF_INCLINATION; 
#declare BL_N_Z=BLOSSOM_INCLINATION;
#declare M_BL_L=BLOSSOM_LENGTH+0.000001;
#declare M_BL_B=BLOSSOM_WIDTH+0.000001;
#declare BL_F=BLOSSOM_COLOR;
#declare S_MA_R=BUNCH_MAJOR_RADIUS+0.000001;
#declare S_MI_R=BUNCH_MINOR_RADIUS+0.000001;
#declare V_S_T=VERTICAL_BUNCH_FUNNEL; 
#declare H_S_T=HORIZONTAL_BUNCH_FUNNEL;
#declare BL_Z=BLOSSOM_NUMBER;
#declare BZ=LEAF_NUMBER;  
#declare SZ=BUNCH_NUMBER+1;
#declare ZWZ=TWIG_NUMBER+1;
#declare ZWEIGLAENGE=TWIG_LENGTH+2;
#declare S_VJ_A=BUNCH_TAPER_OFF_AT_BRANCH;
#declare S_VJ_B=BUNCH_TAPER_OFF_AT_TREE;
#declare S_W_S=BUNCH_ALTERNATE_SWITCH;
#declare S_VF=BUNCH_DEFORM;
#declare S_A=BUNCH_START_AT_TWIG+0.000001;
#declare Z_A=TWIG_START_AT_BRANCH+0.000001; 
#declare Z_B=TWIG_RANGE_AT_BRANCH+0.000001;
#declare H_S_N=HORIZONTAL_BUNCH_INCLINATION; 
#declare V_S_N=VERTICAL_BUNCH_INCLINATION*-1;
#declare H_S_N_SP=HORIZONTAL_BUNCH_INCLINATION_SCOPE; 
#declare V_S_N_SP=VERTICAL_BUNCH_INCLINATION_SCOPE;
#declare S_NEIG=BUNCH_INCLINATION_SWITCH;
#declare V_S_NEIG=VERTICAL_BUNCH_INCLINTION_SWITCH;
#declare S_DREH=BUNCH_TURN_SWITCH;
#declare H_ZW_N=HORIZONTAL_TWIG_INCLINATION; 
#declare V_ZW_N=VERTICAL_TWIG_INCLINATION;
#declare H_ZW_N_SP=HORIZONTAL_TWIG_INCLINATION_SCOPE; 
#declare V_ZW_N_SP=VERTICAL_TWIG_INCLINATION_SCOPE;
#declare ZW_NEIG=TWIG_INCLINATION_SWITCH;
#declare V_ZW_NEIG=VERTICAL_TWIG_INCLINATION_SWITCH;
#declare ZW_W_S=TWIG_ALTERNATE_SWITCH;   
#declare ZW_DREH=TWIG_TURN_SWITCH;
#declare AA=BRANCH_START_AT_TRUNK;
#declare AB=BRANCH_RANGE_AT_TRUNK*((BRANCH_NUMBER+1)/BRANCH_NUMBER);
#declare BG_X=TRUNK_BEND_X;
#declare BG_Z=TRUNK_BEND_Z;
#declare FZ_X=TRUNK_BEND_X_FREQUENCY; 
#declare FZ_Z=TRUNK_BEND_Z_FREQUENCY;
#declare SW=TRUNK_CURVE;
#declare SWFZ=TRUNK_CURVE_FREQUENCY;
#declare KK=TRUNK_SNAG;
#declare SKKFZ=TRUNK_SNAG_FREQUENCY;
#declare S_VL=TRUNK_LENGTHENING;
#declare AW=BRANCH_CURVE;
#declare A_KK=BRANCH_SNAG; 
#declare A_BG=BRANCH_BEND;
#declare ABFZ=BRANCH_BEND_FREQUENCY; 
#declare H_ABG_S=HORIZONTAL_BRANCH_BEND_SWITCH;
#declare AKKFZ=BRANCH_SNAG_FREQUENCY;
#declare AWFZ=BRANCH_CURVE_FREQUENCY;
#declare ZW_L=TWIG_LENGTH+S_MA_R+S_MI_R+0.01;
#declare AST_L=(Z_A+Z_B+ZW_L); 
#declare AST_ST=BRANCH_THICKNESS_CHANGE;
#declare AST_VK=BRANCH_REDUCTION; 
#declare AST_VJ=BRANCH_TAPER_OFF; 
#declare AST_DREH=BRANCH_TURN_SWITCH;
#declare A_W_S=BRANCH_ALTERNATE_SWITCH;
#declare BH=(AA+AB+AST_L);
#declare B_F_1=BOTTOM_COLOR_1; 
#declare B_F_2=BOTTOM_COLOR_2;
#declare K_F_1=TOP_COLOR_1;  
#declare K_F_2=TOP_COLOR_2; 
#declare UE_B_K=TRANSITION_BOTTOM_TOP;
#declare UE_T=TRANSITION_TURB;
#declare ST_F_1=TRUNK_COLOR_1;
#declare ST_F_2=TRUNK_COLOR_2;  
#declare ST_VJ=TRUNK_TAPER_OFF;
#declare WA=ROOT_START_AT_TRUNK;
#declare W_BG=ROOT_BEND; 
#declare WBFZ=ROOT_BEND_FREQUENCY;
#declare W_KK=ROOT_SNAG;  
#declare WKKFZ=ROOT_SNAG_FREQUENCY;
#declare W_ST=ROOT_THICKNESS_CHANGE;  
#declare W_L=ROOT_LENGTH+0.000001;
#declare W_DREH=ROOT_TURN_SWITCH;
#declare ZW_VST=TWIG_THICKNESS_CHANGE; 
#declare AST_E=BRANCH_END;
#declare H_AW_S=HORIZONTAL_BRANCH_CURVE_SWITCH; 
#declare A_L_W=BRANCH_LONGITUDINAL_CURVE;
#declare ZW_K_A=TWIG_CURVE_ADJUSTMENT;
#declare AST_SPIEL=BRANCH_RANDOM;
#declare ASTZAHL=BRANCH_NUMBER;
#declare ASTNEIGUNG=BRANCH_INCLINATION;
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
#declare TREE=		
union
{
	#declare STAUDE =
	union
	{ 
		#declare A=1;
		#while (A<100*BZ)
			object
			{
				LEAF_TYPE
				scale <M_BL*(sin(A*511.73378)+4)/4,M_BH*(sin(A*331.16643)+4)/4,M_BB*(sin(A*117.99095)+4)/4>
				rotate <M_BN_X*sin(237.1111*A),0,M_BN_Z*(1+sin(719.31906*A))/2>
				rotate <0,M_BN_Y*sin(317.17754*A),0>
				translate <S_MA_R+(S_MI_R*(1+sin(578.92279*A))/2),0,0>
				rotate <0,0,V_S_T/2*sin(177.7391*A)>
				rotate <0,H_S_T/2*sin(211.3783*A),0>
			}
		#declare A=A+100*SZ;
		#end
	}
	#declare A=1;
	#while (A<BH+2) 
		#declare B=1;
		#while (B<100)
			#declare C=1;
			#while (C<ZWEIGLAENGE)
				object
				{
					STAUDE
					rotate <0,0,V_S_N_SP*sin(391.77*C*C)>+<0,0,(V_S_N-(V_S_N*C/ZWEIGLAENGE*V_S_NEIG))>
					rotate <0,H_S_N_SP*sin(437.77*C*C),0>+<0,(H_S_N-(H_S_N*C/ZWEIGLAENGE*S_NEIG)),0>*<0,(1-S_W_S)+S_W_S*sin((C/(ZWEIGLAENGE/(SZ/ZWZ))-1/(ZWEIGLAENGE/(SZ/ZWZ)))*pi-pi/2),0>
					rotate <1234*sin(1234.77*C),0,0>*S_DREH
					rotate <1234*sin(1234.77*A),0,0>*S_DREH
					scale 1/(1-B/100*AST_VK)
					scale S_VF*(1.01-S_VJ_B*B/100)			    
					rotate <0,0,90>
					rotate <0,-1234*sin(1234.77*A),0>*ZW_DREH
					translate <A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/7.31),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/3.71),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/9.17)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/17.3),AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/21.1),AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/33.9)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <A_BG*sin(5.371*ABFZ*1*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH),((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L)),A_BG*sin(5.937*ABFZ*1*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH)>*(ZW_L/BH)*<ZW_K_A,1,ZW_K_A>
					rotate <0,BRANCH_SPIRAL*sin(((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH*(pi/2)),0>
					rotate <0,1234*sin(1234.77*A),0>*ZW_DREH
					rotate <0,0,-90>
					scale (1.01-S_VJ_A*A/BH)*BH/AST_L
					rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
					rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))			
					rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>
					rotate <0,0,90>
					rotate <0,1234*sin(1234.77*B),0>*(1-ZW_W_S)
		      rotate <0,-1234*sin(1234.77*B),0>*AST_DREH
					translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH
		  		translate <AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>
		      translate <A_BG*sin(5.371*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*sin(5.937*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH)>*<-1,1,H_ABG_S>
		      rotate <0,BRANCH_SPIRAL*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
					rotate <0,1234*sin(1234.77*B),0>*AST_DREH
					rotate <0,0,-90>					
					scale <AST_L/BH,AST_L/BH,AST_L/BH>*(1-B/100*AST_VK)			 
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,TRUNK_SPIRAL*sin((AA+(B*AB/100))/(BH*3/5)),0>	
				}
			#declare C=C+ZWEIGLAENGE/SZ*ZWZ;
			#end
		#declare B=B+100/ASTZAHL;
		#end
	#declare A=A+BH/ZWZ*ASTZAHL;
	#end
	#declare B_STAUDE =
	union
	{ 
		#declare A=1;
		#while (A<100*BL_Z)
			object
			{
				BLOSSOM
				scale <M_BL_L*(sin(A*511.777)+4)/4,M_BL_B*(sin(A*331.111)+4)/4,M_BL_B*(sin(A*117.999)+4)/4>
				rotate <M_BN_X*sin(237.111*A),0,BL_N_Z*(1+sin(719.333*A))/2>
				rotate <0,M_BN_Y*sin(317.111*A),0>
				translate <S_MA_R+(S_MI_R),0,0>
				rotate <0,0,V_S_T/2*sin(177.7391*A)>
				rotate <0,H_S_T/2*sin(211.3783*A),0>
				pigment{color rgb BL_F}
				finish{diffuse 1 ambient .4}
			}
		#declare A=A+100*SZ;
		#end
	}
	#declare A=1;
	#while (A<BH+2) 
		#declare B=1;
		#while (B<100)
			#declare C=1;
			#while (C<ZWEIGLAENGE)
				object
				{
					B_STAUDE
					rotate <0,0,V_S_N_SP*sin(391.77*C*C)>+<0,0,(V_S_N-(V_S_N*C/ZWEIGLAENGE*V_S_NEIG))>
					rotate <0,H_S_N_SP*sin(437.77*C*C),0>+<0,(H_S_N-(H_S_N*C/ZWEIGLAENGE*S_NEIG)),0>
					rotate <1234*sin(1234.77*C),0,0>*S_DREH
					rotate <1234*sin(1234.77*A),0,0>*S_DREH
					scale 1/(1-B/100*AST_VK)
					scale S_VF*(1.01-S_VJ_B*B/100)			    
					rotate <0,0,90>
					rotate <0,-1234*sin(1234.77*A),0>*ZW_DREH
					translate <A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/7.31),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/3.71),A_KK*sin(.05*AKKFZ*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/9.17)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A
					translate <AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/17.3),AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/21.1),AW*sin(.2*AWFZ*.75*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/33.9)>*((BH-(ZWEIGLAENGE*(BH/ZW_L)))/BH)*(ZW_L/BH)*ZW_K_A 
					translate <A_BG*sin(5.371*ABFZ*1*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH),((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L)),A_BG*sin(5.937*ABFZ*1*((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH)>*(ZW_L/BH)*<ZW_K_A,1,ZW_K_A>
					rotate <0,BRANCH_SPIRAL*sin(((S_A+((ZWEIGLAENGE-S_A)/ZWEIGLAENGE*C))*(BH/ZW_L))/BH*(pi/2)),0>
					rotate <0,1234*sin(1234.77*A),0>*ZW_DREH
					rotate <0,0,-90>
					scale (1.01-S_VJ_A*A/BH)*BH/AST_L
					rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
					rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))
					rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>			
					rotate <0,0,90>
					rotate <0,1234*sin(1234.77*B),0>*(1-ZW_W_S)
		      rotate <0,-1234*sin(1234.77*B),0>*AST_DREH
					translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH
		  		translate <AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>
		      translate <A_BG*sin(5.371*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*sin(5.937*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH)>*<-1,1,H_ABG_S>
		      rotate <0,BRANCH_SPIRAL*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
					rotate <0,1234*sin(1234.77*B),0>*AST_DREH
					rotate <0,0,-90>					
					scale <AST_L/BH,AST_L/BH,AST_L/BH>*(1-B/100*AST_VK)			 
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,TRUNK_SPIRAL*sin((AA+(B*AB/100))/(BH*3/5)),0>	
				}
			#declare C=C+ZWEIGLAENGE/SZ*ZWZ;
			#end
		#declare B=B+100/ASTZAHL;
		#end
	#declare A=A+BH/ZWZ*ASTZAHL;
	#end
  blob
	{
		threshold TRUNK_RADIUS*3
		#declare A=1;
		#while (A<(AA+((ASTZAHL-1)/ASTZAHL)*AB+S_VL))
			sphere
			{
				<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10
				scale TRUNK_RADIUS/90
				scale (BH-A*ST_VJ)/BH
				scale 1-(A/(AA+AB))*(1-AST_ST)
				#if (PALM_TRUNK=0)
					scale <1,1,1>+<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>
					rotate <0,0,20.3*sin(13.123*A)>
					rotate <0,12347.3*sin(123.77*A),0>
				#else 
					scale <1,1,1>+<0,-PALM_TRUNK*.9,PALM_TRUNK*.5> 
					rotate <35,12347.3*sin(1234.77*A),0>
				#end
				#if (A>AA)
 					scale (1-(A-AA)/AB*AST_VK)
				#else
          scale 1
				#end
				translate <KK*sin(.05*SKKFZ*A/7.31),KK*sin(.05*SKKFZ*A/3.71),KK*sin(.05*SKKFZ*A/9.17)>*((BH-A)/BH)
				translate <SW*sin(.2*SWFZ*A/17.3),SW*sin(.2*SWFZ*A/21.1),SW*sin(.2*SWFZ*A/33.9)>*((BH-A)/BH)
				translate <BG_X*sin(5.371*FZ_X*1.5*A/BH),A,BG_Z*sin(5.937*FZ_Z*1.5*A/BH)>
				rotate <0,TRUNK_SPIRAL*sin(A/(BH*3/5)),0>
			}			
    #declare A=A+BH/(TRUNK_STRENGTH+0.00001)/1000;
		#end
		#declare A=1;
		#while (A<(Z_A+Z_B+AST_E*ZW_L)/(Z_A+Z_B+ZW_L)*BH)		
			#declare B=1;
			#while (B<100)
				sphere
				{
					<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10 
					scale TRUNK_RADIUS/90
					scale (BH-A*AST_VJ)/BH					
					scale (BH-((AA+((ASTZAHL-1)/ASTZAHL)*AB)*(B/100))*ST_VJ)/BH 
					scale 1-(A/BH)*(1-ZW_VST)
					scale <1,1,1>+<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>*BRANCH_BARK_PROFILE_CHANGE
					rotate <0,12347.3*sin(123.77*A),0>
					scale 1-S_VJ_A*(A/BH)
					scale (BH-AA*ST_VJ)/BH					
					scale 1/(AST_L/BH)
					scale AST_ST
					translate <A_KK*sin(.05*AKKFZ*A/7.31),A_KK*sin(.05*AKKFZ*A/3.71),A_KK*sin(.05*AKKFZ*A/9.17)>*((BH-A)/BH)
					translate <AW*sin(.2*AWFZ*A/17.3),AW*sin(.2*AWFZ*A/21.1),AW*sin(.2*AWFZ*A/33.9)>*((BH-A)/BH)*<1,A_L_W,H_AW_S>
					translate <A_BG*sin(5.371*ABFZ*.75*A/BH),A,A_BG*sin(5.937*ABFZ*.75*A/BH)>*<-1,1,H_ABG_S>
					rotate <0,BRANCH_SPIRAL*sin(A/BH*(pi/2)),0>
					rotate <0,1234*sin(1234.77*B),0>*AST_DREH
					rotate <0,0,-90>					
					scale (AST_L/BH)*(1-B/100*AST_VK) 					
					rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
					rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
					translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
					translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)					
					translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
					rotate <0,TRUNK_SPIRAL*sin((AA+(B*AB/100))/(BH*3/5)),0>
				}
			#declare B=B+100/ASTZAHL;
			#end
    #declare A=A+BH/(BRANCH_STRENGTH+0.00001)/200;
		#end
		#declare A=1;
		#while (A<BH+2)
			#declare B=1;
			#while (B<100)
				#declare C=1;
				#while (C<BH)
					sphere
					{
						<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10
						scale TRUNK_RADIUS/90
						scale (BH-C*0.8)/BH					
						scale (BH-((AA+((ASTZAHL-1)/ASTZAHL)*AB)*(B/100))*ST_VJ)/BH
						scale (BH-AA*ST_VJ)/BH					
						scale (AST_L-(A/(BH+2))*(Z_A+Z_B)*AST_VJ)/AST_L
						scale (AST_L-Z_A)/AST_L
						scale BH/AST_L
						scale AST_L/ZW_L
						scale ZW_VST*AST_ST
						scale <1,1,1>+<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>*BRANCH_BARK_PROFILE_CHANGE
						rotate <0,12347.3*sin(123.77*C),0>
						translate <A_KK*sin(.05*AKKFZ*C/7.31),A_KK*sin(.05*AKKFZ*C/3.71),A_KK*sin(.05*AKKFZ*C/9.17)>*((BH-C)/BH)*ZW_K_A
						translate <AW*sin(.2*AWFZ*.75*C/17.3),AW*sin(.2*AWFZ*.75*C/21.1),1*AW*sin(.2*AWFZ*.75*C/33.9)>*((BH-C)/BH)*ZW_K_A
	          translate <A_BG*sin(5.371*ABFZ*1*C/BH),C,A_BG*sin(5.937*ABFZ*1*C/BH)>*<ZW_K_A,1,ZW_K_A>
	          rotate <0,BRANCH_SPIRAL*sin(C/BH*(pi/2)),0>
	          rotate <0,1234*sin(1234.77*A),0>*ZW_DREH
						rotate <0,0,-90>
						scale ZW_L/BH	
						scale (1.01-S_VJ_A*A/BH)*BH/AST_L
						rotate <0,0,V_ZW_N_SP*sin(391.77*A*A)>+<0,0,(V_ZW_N-(V_ZW_N*A/BH*V_ZW_NEIG))>
						rotate <0,H_ZW_N_SP*sin(437.77*A*A),0>+<0,(H_ZW_N-(H_ZW_N*A/BH*ZW_NEIG)),0>*(ZW_W_S*sin((A/(BH/ZWZ*ASTZAHL)-1/(BH/ZWZ*ASTZAHL))*pi-pi/2))
						rotate <1456*cos(AST_SPIEL*71.19/A)*(1-ZW_W_S),0,0>			
						rotate <0,0,90>	
						rotate <0,1234*sin(1234.77*B),0>*(1-ZW_W_S)					
			      rotate <0,-1234*sin(1234.77*B),0>*AST_DREH
						translate <A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/7.31),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/3.71),A_KK*sin(.05*AKKFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/9.17)>*(BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH	      
			  		translate <AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/17.3),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/21.1),AW*sin(.2*AWFZ*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/33.9)>*((BH-(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)))/BH)*<1,A_L_W,H_AW_S>	
						translate <A_BG*sin(5.371*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH),(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH)),A_BG*sin(5.937*ABFZ*.75*(Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH)>*<-1,1,H_ABG_S>
						rotate <0,BRANCH_SPIRAL*sin((Z_A/AST_L*BH+(A*(Z_B/AST_L*BH)/BH))/BH*(pi/2)),0>
						rotate <0,1234*sin(1234.77*B),0>*AST_DREH
						rotate <0,0,-90>					
						scale (AST_L/BH)*(1-B/100*AST_VK)			 
						rotate <0,0,ASTNEIGUNG+((B*B/100)*((90-ASTNEIGUNG)/100))>
						rotate <0,1456*cos(AST_SPIEL*71.19/B)*(1-A_W_S)+90*A_W_S*sin((B/(100/ASTZAHL)-1/(100/ASTZAHL))*pi-pi/2)+90,0>
						translate <KK*sin(.05*SKKFZ*(AA+(B*AB/100))/7.31),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/3.71),KK*sin(.05*SKKFZ*(AA+(B*AB/100))/9.17)>*((BH-(AA+(B*AB/100)))/BH)
						translate <SW*sin(.2*SWFZ*(AA+(B*AB/100))/17.3),SW*sin(.2*SWFZ*(AA+(B*AB/100))/21.1),SW*sin(.2*SWFZ*(AA+(B*AB/100))/33.9)>*((BH-(AA+(B*AB/100)))/BH)			
						translate <BG_X*sin(5.371*FZ_X*1.5*(AA+(B*AB/100))/BH),(AA+(B*AB/100)),BG_Z*sin(5.937*FZ_Z*1.5*(AA+(B*AB/100))/BH)>
						rotate <0,TRUNK_SPIRAL*sin((AA+(B*AB/100))/(BH*3/5)),0>
					}
				#declare C=C+BH/200/(TWIG_STRENGTH+0.00001);
				#end 
			#declare B=B+100/ASTZAHL;
			#end
		#declare A=A+BH/ZWZ*ASTZAHL;
		#end		
		#declare A=1;
		#while (A<BH)		
			#declare B=1;
			#while (B<100)
				sphere
				{
					<0,0,0>,TRUNK_RADIUS*5,TRUNK_RADIUS*10
					scale (BH-A)/BH
					scale TRUNK_RADIUS/90
					scale W_ST 
					scale BH/W_L
					scale <1,1,1>+<-BARK_PROFILE*.9,BARK_PROFILE*.25,BARK_PROFILE*.25>*ROOT_BARK_PROFILE_CHANGE
					rotate <0,12347.3*sin(123.77*A),0>
					translate <W_KK*sin(.1*WKKFZ*A/7.31),W_KK*sin(.1*WKKFZ*A/3.71),W_KK*sin(.1*WKKFZ*A/9.17)>*((BH-A)/BH)
					translate <W_BG*sin(5.371*WBFZ*A/BH),A,W_BG*sin(5.937*WBFZ*A/BH)> 
					rotate <0,1234.773*sin(1.77*B),0>*W_DREH
					rotate <0,0,-90>
					rotate <0,180,0>					
					scale W_L/BH 					
					rotate <0,0,ROOT_INCLINATION+((B*B/100)*((90-ROOT_INCLINATION)/100))>
					rotate <0,1456.371*sin(ROOT_RANDOM*71.19/B)+180,0>
					translate <KK*sin(.05*SKKFZ*(WA-(WA*B/100))/7.31),KK*sin(.05*SKKFZ*(WA-(WA*B/100))/3.71),KK*sin(.05*SKKFZ*(WA-(WA*B/100))/9.17)>*((BH-(WA-(WA*B/100)))/BH)
					translate <SW*sin(.2*SWFZ*(WA-(WA*B/100))/17.3),SW*sin(.2*SWFZ*(WA-(WA*B/100))/21.1),SW*sin(.2*SWFZ*(WA-(WA*B/100))/33.9)>*((BH-(WA-(WA*B/100)))/BH)				
					translate <BG_X*sin(5.371*FZ_X*1.5*(WA-(WA*B/100))/BH),(WA-(WA*B/100)),BG_Z*sin(5.937*FZ_Z*1.5*(WA-(WA*B/100))/BH)>
					rotate <0,TRUNK_SPIRAL*sin((WA-(WA*B/100))/(BH*3/5)),0>	
				}
			#declare B=B+100/(ROOT_NUMBER+1);
			#end
    #declare A=A+BH/150/(ROOT_STRENGTH+0.00001);
		#end		
		pigment
		{
			granite
			cubic_wave
			color_map
			{  
				[0 color rgb ST_F_1]
				[0.35 color rgb ST_F_2]
				[.5 color rgb ST_F_2*2]
				[0.65 color rgb ST_F_2]
				[1 color rgb ST_F_1]
			}
			scale <TRUNK_SCAR_WIDTH,TRUNK_SCAR_HEIGHT,TRUNK_SCAR_WIDTH>*3
		}
		normal
		{
			granite SCAR_DEPTH*10
			rotate <0,0,0>
			scale <TRUNK_SCAR_WIDTH,TRUNK_SCAR_HEIGHT,TRUNK_SCAR_WIDTH>*3
		}	
		finish
		{
			phong SCAR_DEPTH/5 phong_size 4 
		}
	}
		
	#declare BOZO1 =
	pigment
	{
		bozo
		color_map
		{
			[0 color rgb B_F_1]
			[1 color rgb B_F_2]
		}
		scale BH/(250*(COLOR_TURB+.1)*BH)
	}   
	#declare BOZO2 =
	pigment
	{
		bozo
		color_map
		{
			[0 color rgb K_F_1]
			[1 color rgb K_F_2]
		}
		scale BH/(250*(COLOR_TURB+.1)*BH)
	}
	
	texture
	{
		pigment
		{
			gradient y 
			cubic_wave 
			turbulence UE_T
			omega UE_T
			pigment_map
			{
				[0 BOZO2]
				[UE_B_K BOZO1]
				[1 BOZO2]
			}
			scale BH
		}
		finish
		{ 
			phong 0.4*FOLIAGE_GLOSS
			phong_size 20*FOLIAGE_GLOSS
		}
	}
	scale 1/(AA+((ASTZAHL-1)/ASTZAHL)*AB+(Z_A*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(Z_B*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(ZWEIGLAENGE*(1-S_VJ_A)*(1-((ASTZAHL-1)/ASTZAHL)*AST_VK))+(S_MA_R*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A))+(S_MI_R*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A))+(M_BL*(1-((ASTZAHL-1)/ASTZAHL)*S_VJ_B)*(1-S_VJ_A)))
} 
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX END
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX