// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio
#include "patiotex.inc"
//texture{chif1} //hoja
//texture {chif2}   //tallo

#declare chiflera = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.3306, 9.5192, 0.3306>, 2.8826 }
		cylinder { <-0.3306, 9.5192, 0.3306>, <-0.9912, 19.00403, 0.9912>, 2.8826 }
		cylinder { <-0.9912, 19.00403, 0.9912>, <-1.98, 28.4315, 1.98>, 2.8826 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.98, 28.4315, 1.98>, <-2.4847, 31.01066, 2.4847>, 0.3759 }
			cylinder { <-2.4847, 31.01066, 2.4847>, <-3.2088, 33.4829, 3.2088>, 0.3759 }
			cylinder { <-3.2088, 33.4829, 3.2088>, <-4.1415, 35.8113, 4.1415>, 0.3759 }
			texture{chif1}}
		mesh { // seedling leaf
			triangle { <-4.1415, 35.8113, 4.1415>, <-15.3622, 56.638, 13.9109>, <-3.1148, 34.8878, 5.04099> }
			triangle { <-3.1148, 34.8878, 5.04099>, <-14.855, 55.938, 16.1657>, <-15.3622, 56.638, 13.9109> }
			triangle { <-14.855, 55.938, 16.1657>, <-26.3054, 64.3398, 23.4755>, <-15.3622, 56.638, 13.9109> }
			triangle { <-15.3622, 56.638, 13.9109>, <-26.3054, 64.3398, 23.4755>, <-26.02758, 64.7794, 21.03414> }
			triangle { <-26.3054, 64.3398, 23.4755>, <-41.666, 58.2059, 29.9153>, <-26.02758, 64.7794, 21.03414> }
			triangle { <-41.666, 58.2059, 29.9153>, <-27.7169, 65.3001, 20.4775>, <-26.02758, 64.7794, 21.03414> }
			triangle { <-26.02758, 64.7794, 21.03414>, <-27.7169, 65.3001, 20.4775>, <-15.3622, 56.638, 13.9109> }
			triangle { <-15.3622, 56.638, 13.9109>, <-27.7169, 65.3001, 20.4775>, <-16.8514, 57.04693, 12.2118> }
			triangle { <-16.8514, 57.04693, 12.2118>, <-4.1415, 35.8113, 4.1415>, <-15.3622, 56.638, 13.9109> }
			triangle { <-4.1415, 35.8113, 4.1415>, <-16.8514, 57.04693, 12.2118>, <-4.3324, 34.9763, 2.7915> }
			texture{chif1}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.98, 28.4315, 1.98>, <-2.02652, 31.1067, 2.02652>, 0.3759 }
			cylinder { <-2.02652, 31.1067, 2.02652>, <-1.841, 33.7699, 1.841>, 0.3759 }
			cylinder { <-1.841, 33.7699, 1.841>, <-1.4264, 36.3809, 1.4264>, 0.3759 }
			texture{chif1}}
		mesh { // seedling leaf
			triangle { <-1.4264, 36.3809, 1.4264>, <5.06732, 60.6192, -3.616>, <-2.2608, 35.471, 0.3347> }
			triangle { <-2.2608, 35.471, 0.3347>, <4.6662, 60.3081, -5.9768>, <5.06732, 60.6192, -3.616> }
			triangle { <4.6662, 60.3081, -5.9768>, <13.9881, 72.1989, -11.1581>, <5.06732, 60.6192, -3.616> }
			triangle { <5.06732, 60.6192, -3.616>, <13.9881, 72.1989, -11.1581>, <13.6785, 72.06145, -8.6851> }
			triangle { <13.9881, 72.1989, -11.1581>, <30.1384, 70.8039, -18.3877>, <13.6785, 72.06145, -8.6851> }
			triangle { <30.1384, 70.8039, -18.3877>, <15.2366, 72.7922, -7.9973>, <13.6785, 72.06145, -8.6851> }
			triangle { <13.6785, 72.06145, -8.6851>, <15.2366, 72.7922, -7.9973>, <5.06732, 60.6192, -3.616> }
			triangle { <5.06732, 60.6192, -3.616>, <15.2366, 72.7922, -7.9973>, <6.4771, 60.9674, -1.8375> }
			triangle { <6.4771, 60.9674, -1.8375>, <-1.4264, 36.3809, 1.4264>, <5.06732, 60.6192, -3.616> }
			triangle { <-1.4264, 36.3809, 1.4264>, <6.4771, 60.9674, -1.8375>, <-1.0392, 35.3439, 2.58> }
			texture{chif1}}
		}
	union { // internode
		cylinder { <-1.98, 28.4315, 1.98>, <-2.267, 35.9012, 2.5116>, 2.2666 }
		cylinder { <-2.267, 35.9012, 2.5116>, <-2.06201, 43.387, 2.7943>, 2.2666 }
		cylinder { <-2.06201, 43.387, 2.7943>, <-1.3659, 50.8486, 2.8267>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.3659, 50.8486, 2.8267>, <-0.6392, 54.8305, 2.6637>, 0.2845 }
			cylinder { <-0.6392, 54.8305, 2.6637>, <0.4308, 58.7225, 2.3217>, 0.2845 }
			cylinder { <0.4308, 58.7225, 2.3217>, <1.8341, 62.4872, 1.8042>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <2.1526, 65.8547, -0.4247>, 0.2845 }
				cylinder { <2.1526, 65.8547, -0.4247>, <1.3035, 67.9501, -3.786>, 0.2845 }
				cylinder { <1.3035, 67.9501, -3.786>, <-0.4925, 68.2288, -7.4063>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-0.4925, 68.2288, -7.4063>, <0.8617, 64.8489, -15.4055>, <1.4445, 71.5461, -15.1789> }
				triangle { <0.8617, 64.8489, -15.4055>, <-2.116, 65.3545, -22.3241>, <1.4445, 71.5461, -15.1789> }
				triangle { <1.4445, 71.5461, -15.1789>, <-2.116, 65.3545, -22.3241>, <-1.837, 73.08064, -21.8676> }
				triangle { <-1.837, 73.08064, -21.8676>, <-2.116, 65.3545, -22.3241>, <-8.812, 69.3586, -25.07701> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <3.8856, 65.8107, 2.8793>, 0.2845 }
				cylinder { <3.8856, 65.8107, 2.8793>, <6.1912, 68.05492, 5.3405>, 0.2845 }
				cylinder { <6.1912, 68.05492, 5.3405>, <8.3084, 68.7888, 8.7153>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <8.3084, 68.7888, 8.7153>, <16.8175, 69.4417, 10.8162>, <13.666, 64.3611, 13.8982> }
				triangle { <16.8175, 69.4417, 10.8162>, <21.04163, 70.5416, 16.9756>, <13.666, 64.3611, 13.8982> }
				triangle { <13.666, 64.3611, 13.8982>, <21.04163, 70.5416, 16.9756>, <17.1067, 64.9771, 20.6543> }
				triangle { <17.1067, 64.9771, 20.6543>, <21.04163, 70.5416, 16.9756>, <18.9145, 72.2162, 24.7934> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <2.5385, 66.09467, 0.1012>, 0.2845 }
				cylinder { <2.5385, 66.09467, 0.1012>, <2.4617, 69.1231, -2.588>, 0.2845 }
				cylinder { <2.4617, 69.1231, -2.588>, <1.6125, 71.2184, -5.9494>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <1.6125, 71.2184, -5.9494>, <4.1325, 70.9496, -14.365>, <5.8166, 76.6584, -11.2318> }
				triangle { <4.1325, 70.9496, -14.365>, <2.9404, 74.8144, -20.7394>, <5.8166, 76.6584, -11.2318> }
				triangle { <5.8166, 76.6584, -11.2318>, <2.9404, 74.8144, -20.7394>, <4.4622, 81.4251, -17.00294> }
				triangle { <4.4622, 81.4251, -17.00294>, <2.9404, 74.8144, -20.7394>, <-2.1442, 81.1273, -22.3945> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <3.6749, 66.06582, 2.2679>, 0.2845 }
				cylinder { <3.6749, 66.06582, 2.2679>, <5.8199, 69.199, 3.6792>, 0.2845 }
				cylinder { <5.8199, 69.199, 3.6792>, <8.1137, 71.6599, 5.9359>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <8.1137, 71.6599, 5.9359>, <16.38, 74.6301, 5.6322>, <15.06492, 70.8796, 11.05879> }
				triangle { <16.38, 74.6301, 5.6322>, <20.9721, 78.9721, 9.7613>, <15.06492, 70.8796, 11.05879> }
				triangle { <15.06492, 70.8796, 11.05879>, <20.9721, 78.9721, 9.7613>, <19.1095, 74.9086, 16.08571> }
				triangle { <19.1095, 74.9086, 16.08571>, <20.9721, 78.9721, 9.7613>, <19.5569, 83.4141, 16.5959> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <2.9037, 66.2283, 0.6774>, 0.2845 }
				cylinder { <2.9037, 66.2283, 0.6774>, <3.6081, 69.8358, -1.02557>, 0.2845 }
				cylinder { <3.6081, 69.8358, -1.02557>, <3.9265, 73.2033, -3.2545>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <3.9265, 73.2033, -3.2545>, <8.2045, 75.5596, -10.5616>, <10.1095, 78.994, -5.1008> }
				triangle { <8.2045, 75.5596, -10.5616>, <9.1899, 81.7429, -14.7789>, <10.1095, 78.994, -5.1008> }
				triangle { <10.1095, 78.994, -5.1008>, <9.1899, 81.7429, -14.7789>, <10.961, 85.7871, -8.416> }
				triangle { <10.961, 85.7871, -8.416>, <9.1899, 81.7429, -14.7789>, <5.8051, 89.2737, -14.2525> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <1.8341, 62.4872, 1.8042>, <3.2374, 66.2519, 1.2867>, 0.2845 }
				cylinder { <3.2374, 66.2519, 1.2867>, <4.6407, 70.01662, 0.7692>, 0.2845 }
				cylinder { <4.6407, 70.01662, 0.7692>, <6.04403, 73.7813, 0.2516>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.04403, 73.7813, 0.2516>, <12.2156, 77.5947, -4.7096>, <13.4038, 78.05975, 1.8945> }
				triangle { <12.2156, 77.5947, -4.7096>, <15.2043, 84.4534, -5.7177>, <13.4038, 78.05975, 1.8945> }
				triangle { <13.4038, 78.05975, 1.8945>, <15.2043, 84.4534, -5.7177>, <16.1665, 85.1468, 1.9355> }
				triangle { <16.1665, 85.1468, 1.9355>, <15.2043, 84.4534, -5.7177>, <13.1664, 91.7947, -2.4928> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-1.3659, 50.8486, 2.8267>, <1.6761, 57.5923, 1.6315>, 2.2666 }
		cylinder { <1.6761, 57.5923, 1.6315>, <6.6567, 62.7143, -0.631>, 2.2666 }
		cylinder { <6.6567, 62.7143, -0.631>, <12.9082, 65.5283, -3.6576>, 2.2666 }
		 texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <12.9082, 65.5283, -3.6576>, <16.3724, 66.7695, -5.3513>, 0.2845 }
			cylinder { <16.3724, 66.7695, -5.3513>, <19.9029, 67.7239, -7.09341>, 0.2845 }
			cylinder { <19.9029, 67.7239, -7.09341>, <23.4804, 68.3865, -8.8744>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <25.6907, 69.05489, -12.2028>, 0.2845 }
				cylinder { <25.6907, 69.05489, -12.2028>, <25.9594, 69.5554, -16.2137>, 0.2845 }
				cylinder { <25.9594, 69.5554, -16.2137>, <24.2166, 69.758, -19.865>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <24.2166, 69.758, -19.865>, <21.1562, 63.9741, -25.7323>, <26.3298, 67.6264, -27.9989> }
				triangle { <21.1562, 63.9741, -25.7323>, <18.1152, 64.01658, -32.6418>, <26.3298, 67.6264, -27.9989> }
				triangle { <26.3298, 67.6264, -27.9989>, <18.1152, 64.01658, -32.6418>, <23.8555, 68.5823, -35.1281> }
				triangle { <23.8555, 68.5823, -35.1281>, <18.1152, 64.01658, -32.6418>, <15.8507, 70.286, -37.542> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <27.4974, 68.9057, -8.9416>, 0.2845 }
				cylinder { <27.4974, 68.9057, -8.9416>, <31.1824, 69.1819, -7.2819>, 0.2845 }
				cylinder { <31.1824, 69.1819, -7.2819>, <33.8279, 69.162, -4.2142>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <33.8279, 69.162, -4.2142>, <39.6182, 63.438, -0.9047>, <34.6765, 65.04224, 3.3671> }
				triangle { <39.6182, 63.438, -0.9047>, <44.4572, 63.00845, 4.8737>, <34.6765, 65.04224, 3.3671> }
				triangle { <34.6765, 65.04224, 3.3671>, <44.4572, 63.00845, 4.8737>, <38.8569, 65.278, 9.7177> }
				triangle { <38.8569, 65.278, 9.7177>, <44.4572, 63.00845, 4.8737>, <46.6652, 68.6189, 10.5388> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <26.232, 69.07315, -11.7671>, 0.2845 }
				cylinder { <26.232, 69.07315, -11.7671>, <27.8359, 69.7036, -15.4332>, 0.2845 }
				cylinder { <27.8359, 69.7036, -15.4332>, <28.1045, 70.2041, -19.444>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <28.1045, 70.2041, -19.444>, <28.0626, 64.9406, -26.4825>, <33.8275, 68.3109, -25.6758> }
				triangle { <28.0626, 64.9406, -26.4825>, <28.7812, 65.5294, -33.9743>, <33.8275, 68.3109, -25.6758> }
				triangle { <33.8275, 68.3109, -25.6758>, <28.7812, 65.5294, -33.9743>, <35.1843, 69.7789, -33.01514> }
				triangle { <35.1843, 69.7789, -33.01514>, <28.7812, 65.5294, -33.9743>, <29.449, 72.1708, -38.8623> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <27.4168, 68.9753, -9.6285>, 0.2845 }
				cylinder { <27.4168, 68.9753, -9.6285>, <31.4267, 69.4477, -9.3009>, 0.2845 }
				cylinder { <31.4267, 69.4477, -9.3009>, <35.2197, 69.7696, -7.9154>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <35.2197, 69.7696, -7.9154>, <42.2862, 64.5542, -7.5836>, <39.927, 66.2795, -1.5255> }
				triangle { <42.2862, 64.5542, -7.5836>, <49.3335, 64.7639, -4.8852>, <39.927, 66.2795, -1.5255> }
				triangle { <39.927, 66.2795, -1.5255>, <49.3335, 64.7639, -4.8852>, <46.6286, 67.1693, 1.9613> }
				triangle { <46.6286, 67.1693, 1.9613>, <49.3335, 64.7639, -4.8852>, <53.5934, 70.8761, -1.2877> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <26.6923, 69.07119, -11.2462>, 0.2845 }
				cylinder { <26.6923, 69.07119, -11.2462>, <29.4438, 69.7578, -14.1388>, 0.2845 }
				cylinder { <29.4438, 69.7578, -14.1388>, <31.6541, 70.4262, -17.4672>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <31.6541, 70.4262, -17.4672>, <34.8367, 65.5175, -24.02637>, <39.6073, 68.4189, -20.2757> }
				triangle { <34.8367, 65.5175, -24.02637>, <39.1402, 66.4054, -30.1649>, <39.6073, 68.4189, -20.2757> }
				triangle { <39.6073, 68.4189, -20.2757>, <39.1402, 66.4054, -30.1649>, <44.4286, 70.1293, -25.9052> }
				triangle { <44.4286, 70.1293, -25.9052>, <39.1402, 66.4054, -30.1649>, <42.3744, 73.204, -33.5949> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.4804, 68.3865, -8.8744>, <27.05803, 69.04906, -10.6555>, 0.2845 }
				cylinder { <27.05803, 69.04906, -10.6555>, <30.6355, 69.7116, -12.4365>, 0.2845 }
				cylinder { <30.6355, 69.7116, -12.4365>, <34.2131, 70.3741, -14.2176>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <34.2131, 70.3741, -14.2176>, <39.9886, 65.5625, -18.7713>, <42.4376, 67.93, -12.9713> }
				triangle { <39.9886, 65.5625, -18.7713>, <46.7709, 66.4244, -21.9726>, <42.4376, 67.93, -12.9713> }
				triangle { <42.4376, 67.93, -12.9713>, <46.7709, 66.4244, -21.9726>, <49.4565, 69.5497, -15.4153> }
				triangle { <49.4565, 69.5497, -15.4153>, <46.7709, 66.4244, -21.9726>, <51.5387, 73.1247, -22.8778> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <12.9082, 65.5283, -3.6576>, <17.4322, 65.4912, -5.9551>, 1.5347 }
		cylinder { <17.4322, 65.4912, -5.9551>, <21.5588, 63.5171, -8.1509>, 1.5347 }
		cylinder { <21.5588, 63.5171, -8.1509>, <24.6596, 59.9068, -9.9109>, 1.5347 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.6596, 59.9068, -9.9109>, <26.1597, 57.6523, -10.7885>, 0.1999 }
			cylinder { <26.1597, 57.6523, -10.7885>, <27.3976, 55.2026, -11.5432>, 0.1999 }
			cylinder { <27.3976, 55.2026, -11.5432>, <28.3549, 52.5946, -12.1637>, 0.1999 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <28.5536, 50.3899, -13.9535>, 0.1999 }
				cylinder { <28.5536, 50.3899, -13.9535>, <27.9422, 49.1615, -16.4475>, 0.1999 }
				cylinder { <27.9422, 49.1615, -16.4475>, <26.6793, 49.2285, -18.9978>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <26.6793, 49.2285, -18.9978>, <20.8659, 49.07296, -21.07713>, <23.4703, 45.3803, -22.4637> }
				triangle { <20.8659, 49.07296, -21.07713>, <18.3184, 49.01228, -25.7299>, <23.4703, 45.3803, -22.4637> }
				triangle { <23.4703, 45.3803, -22.4637>, <18.3184, 49.01228, -25.7299>, <21.5299, 44.9595, -27.4265> }
				triangle { <21.5299, 44.9595, -27.4265>, <18.3184, 49.01228, -25.7299>, <20.3028, 49.4757, -31.1747> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <29.7705, 50.1809, -11.6404>, 0.1999 }
				cylinder { <29.7705, 50.1809, -11.6404>, <31.3724, 48.4251, -10.07388>, 0.1999 }
				cylinder { <31.3724, 48.4251, -10.07388>, <32.8531, 47.6643, -7.7648>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <32.8531, 47.6643, -7.7648>, <32.145, 43.5826, -3.1841>, <32.1776, 48.078, -1.7239> }
				triangle { <32.145, 43.5826, -3.1841>, <34.656, 42.1308, 1.2574>, <32.1776, 48.078, -1.7239> }
				triangle { <32.1776, 48.078, -1.7239>, <34.656, 42.1308, 1.2574>, <34.9565, 47.3461, 2.7831> }
				triangle { <34.9565, 47.3461, 2.7831>, <34.656, 42.1308, 1.2574>, <39.7534, 43.8182, 3.4864> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <28.8228, 50.1831, -13.6022>, 0.1999 }
				cylinder { <28.8228, 50.1831, -13.6022>, <28.7465, 48.2502, -15.6906>, 0.1999 }
				cylinder { <28.7465, 48.2502, -15.6906>, <28.135, 47.02185, -18.1846>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <28.135, 47.02185, -18.1846>, <23.08221, 44.6887, -20.8621>, <26.4784, 41.4867, -20.1177> }
				triangle { <23.08221, 44.6887, -20.8621>, <21.7612, 42.2264, -25.3714>, <26.4784, 41.4867, -20.1177> }
				triangle { <26.4784, 41.4867, -20.1177>, <21.7612, 42.2264, -25.3714>, <25.8689, 38.729, -24.656> }
				triangle { <25.8689, 38.729, -24.656>, <21.7612, 42.2264, -25.3714>, <24.8938, 41.00888, -30.1151> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <29.6207, 50.04611, -12.08543>, 0.1999 }
				cylinder { <29.6207, 50.04611, -12.08543>, <31.1033, 47.7417, -11.3139>, 0.1999 }
				cylinder { <31.1033, 47.7417, -11.3139>, <32.6953, 45.8485, -9.9052>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <32.6953, 45.8485, -9.9052>, <31.7427, 40.3621, -7.2339>, <33.07347, 43.7362, -4.2031> }
				triangle { <31.7427, 40.3621, -7.2339>, <34.4845, 36.7825, -4.439>, <33.07347, 43.7362, -4.2031> }
				triangle { <33.07347, 43.7362, -4.2031>, <34.4845, 36.7825, -4.439>, <36.2542, 40.7287, -1.1356> }
				triangle { <36.2542, 40.7287, -1.1356>, <34.4845, 36.7825, -4.439>, <40.1173, 36.548, -3.01956> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <29.0782, 50.04738, -13.2086>, 0.1999 }
				cylinder { <29.0782, 50.04738, -13.2086>, <29.546, 47.6359, -14.6471>, 0.1999 }
				cylinder { <29.546, 47.6359, -14.6471>, <29.7447, 45.4313, -16.4369>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <29.7447, 45.4313, -16.4369>, <25.8989, 41.1093, -18.5989>, <29.4695, 39.3576, -16.0448> }
				triangle { <25.8989, 41.1093, -18.5989>, <26.08885, 36.8569, -21.7647>, <29.4695, 39.3576, -16.0448> }
				triangle { <29.4695, 39.3576, -16.0448>, <26.08885, 36.8569, -21.7647>, <30.3939, 35.00112, -19.00081> }
				triangle { <30.3939, 35.00112, -19.00081>, <26.08885, 36.8569, -21.7647>, <30.4133, 34.6879, -24.9884> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <28.3549, 52.5946, -12.1637>, <29.3122, 49.9865, -12.7842>, 0.1999 }
				cylinder { <29.3122, 49.9865, -12.7842>, <30.2695, 47.3785, -13.4047>, 0.1999 }
				cylinder { <30.2695, 47.3785, -13.4047>, <31.2268, 44.7705, -14.02522>, 0.1999 }
				texture{chif1}}
			mesh { // leaf
				triangle { <31.2268, 44.7705, -14.02522>, <28.7209, 39.1652, -14.6919>, <31.8031, 39.4466, -11.1195> }
				triangle { <28.7209, 39.1652, -14.6919>, <30.3135, 34.1991, -15.6632>, <31.8031, 39.4466, -11.1195> }
				triangle { <31.8031, 39.4466, -11.1195>, <30.3135, 34.1991, -15.6632>, <34.06587, 34.6446, -11.7468> }
				triangle { <34.06587, 34.6446, -11.7468>, <30.3135, 34.1991, -15.6632>, <35.5637, 32.05544, -16.9432> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <24.6596, 59.9068, -9.9109>, <26.4805, 58.2003, -11.04113>, 0.8286 }
		cylinder { <26.4805, 58.2003, -11.04113>, <28.4209, 56.7622, -12.3343>, 0.8286 }
		cylinder { <28.4209, 56.7622, -12.3343>, <30.4514, 55.6142, -13.7711>, 0.8286 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <30.4514, 55.6142, -13.7711>, <31.7188, 55.06407, -14.7068>, 0.1172 }
			cylinder { <31.7188, 55.06407, -14.7068>, <33.00458, 54.6682, -15.694>, 0.1172 }
			cylinder { <33.00458, 54.6682, -15.694>, <34.2963, 54.4305, -16.7233>, 0.1172 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.9409, 54.3687, -16.9988>, 0.1172 }
				cylinder { <35.9409, 54.3687, -16.9988>, <37.511, 54.4987, -16.449>, 0.1172 }
				cylinder { <37.511, 54.4987, -16.449>, <38.5987, 54.7869, -15.2168>, 0.1172 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.01245, 54.08995, -18.1915>, 0.1172 }
				cylinder { <35.01245, 54.08995, -18.1915>, <35.01539, 53.7118, -19.8167>, 0.1172 }
				cylinder { <35.01539, 53.7118, -19.8167>, <34.3046, 53.3688, -21.287>, 0.1172 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.8684, 54.3058, -17.2686>, 0.1172 }
				cylinder { <35.8684, 54.3058, -17.2686>, <37.5371, 54.3086, -17.2662>, 0.1172 }
				cylinder { <37.5371, 54.3086, -17.2662>, <39.1072, 54.4387, -16.7165>, 0.1172 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.2595, 54.123, -18.05074>, 0.1172 }
				cylinder { <35.2595, 54.123, -18.05074>, <35.8245, 53.7679, -19.5802>, 0.1172 }
				cylinder { <35.8245, 53.7679, -19.5802>, <35.9502, 53.3911, -21.2008>, 0.1172 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.7496, 54.2466, -17.5223>, 0.1172 }
				cylinder { <35.7496, 54.2466, -17.5223>, <37.3217, 54.1219, -18.06765>, 0.1172 }
				cylinder { <37.3217, 54.1219, -18.06765>, <38.9663, 54.06008, -18.3431>, 0.1172 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <34.2963, 54.4305, -16.7233>, <35.5881, 54.1928, -17.7525>, 0.1172 }
				cylinder { <35.5881, 54.1928, -17.7525>, <36.8798, 53.9551, -18.7817>, 0.1172 }
				cylinder { <36.8798, 53.9551, -18.7817>, <38.1716, 53.7175, -19.811>, 0.1172 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <12.9082, 65.5283, -3.6576>, <18.1679, 69.8848, -6.7426>, 2.2666 }
		cylinder { <18.1679, 69.8848, -6.7426>, <22.1206, 75.5226, -9.7009>, 2.2666 }
		cylinder { <22.1206, 75.5226, -9.7009>, <24.5295, 82.1038, -12.3552>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.5295, 82.1038, -12.3552>, <25.4729, 85.8068, -13.6995>, 0.2845 }
			cylinder { <25.4729, 85.8068, -13.6995>, <26.04858, 89.6199, -14.9403>, 0.2845 }
			cylinder { <26.04858, 89.6199, -14.9403>, <26.2509, 93.5061, -16.06575>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <27.08612, 97.3799, -15.2256>, 0.2845 }
				cylinder { <27.08612, 97.3799, -15.2256>, <28.3371, 100.2349, -12.6383>, 0.2845 }
				cylinder { <28.3371, 100.2349, -12.6383>, <29.6789, 101.3292, -8.976>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <29.6789, 101.3292, -8.976>, <26.1911, 102.1159, -0.9472>, <28.413, 107.9295, -3.4984> }
				triangle { <26.1911, 102.1159, -0.9472>, <28.332, 104.3356, 5.9432>, <28.413, 107.9295, -3.4984> }
				triangle { <28.413, 107.9295, -3.4984>, <28.332, 104.3356, 5.9432>, <31.2735, 110.8327, 2.9242> }
				triangle { <31.2735, 110.8327, 2.9242>, <28.332, 104.3356, 5.9432>, <35.7286, 106.6227, 8.8599> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <25.8621, 96.5919, -18.6611>, 0.2845 }
				cylinder { <25.8621, 96.5919, -18.6611>, <24.9568, 98.2849, -22.2282>, 0.2845 }
				cylinder { <24.9568, 98.2849, -22.2282>, <23.7088, 98.2599, -26.08211>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <23.7088, 98.2599, -26.08211>, <16.4912, 100.8107, -30.4002>, <17.6221, 94.1879, -30.7234> }
				triangle { <16.4912, 100.8107, -30.4002>, <13.7896, 100.6808, -37.4482>, <17.6221, 94.1879, -30.7234> }
				triangle { <17.6221, 94.1879, -30.7234>, <13.7896, 100.6808, -37.4482>, <15.4999, 93.1443, -37.9531> }
				triangle { <15.4999, 93.1443, -37.9531>, <13.7896, 100.6808, -37.4482>, <17.2641, 98.2552, -44.5539> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <26.8919, 97.5017, -15.8818>, 0.2845 }
				cylinder { <26.8919, 97.5017, -15.8818>, <27.8967, 101.1397, -14.4102>, 0.2845 }
				cylinder { <27.8967, 101.1397, -14.4102>, <29.1477, 103.9947, -11.8229>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <29.1477, 103.9947, -11.8229>, <25.8229, 107.9904, -4.7358>, <26.9654, 112.1597, -9.8889> }
				triangle { <25.8229, 107.9904, -4.7358>, <27.7718, 113.4512, 0.09846>, <26.9654, 112.1597, -9.8889> }
				triangle { <26.9654, 112.1597, -9.8889>, <27.7718, 113.4512, 0.09846>, <29.4952, 118.0929, -5.8566> }
				triangle { <29.4952, 118.0929, -5.8566>, <27.7718, 113.4512, 0.09846>, <34.7683, 117.803, 0.8451> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <26.08932, 96.985, -18.1348>, 0.2845 }
				cylinder { <26.08932, 96.985, -18.1348>, <25.5754, 99.8046, -20.9976>, 0.2845 }
				cylinder { <25.5754, 99.8046, -20.9976>, <24.7464, 101.7606, -24.4468>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <24.7464, 101.7606, -24.4468>, <18.4261, 107.1731, -27.276>, <18.6923, 101.3544, -30.6398> }
				triangle { <18.4261, 107.1731, -27.276>, <16.4858, 110.7469, -33.6363>, <18.6923, 101.3544, -30.6398> }
				triangle { <18.6923, 101.3544, -30.6398>, <16.4858, 110.7469, -33.6363>, <17.2203, 104.1176, -37.5723> }
				triangle { <17.2203, 104.1176, -37.5723>, <16.4858, 110.7469, -33.6363>, <20.3322, 111.3138, -40.939> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <26.6789, 97.5059, -16.5435>, 0.2845 }
				cylinder { <26.6789, 97.5059, -16.5435>, <27.3199, 101.5016, -16.3596>, 0.2845 }
				cylinder { <27.3199, 101.5016, -16.3596>, <28.1551, 105.3754, -15.5195>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <28.1551, 105.3754, -15.5195>, <24.4272, 111.7501, -10.7539>, <24.7011, 113.118, -17.3339> }
				triangle { <24.4272, 111.7501, -10.7539>, <25.5836, 119.0469, -9.2014>, <24.7011, 113.118, -17.3339> }
				triangle { <24.7011, 113.118, -17.3339>, <25.5836, 119.0469, -9.2014>, <26.3268, 120.5273, -16.7668> }
				triangle { <26.3268, 120.5273, -16.7668>, <25.5836, 119.0469, -9.2014>, <31.7755, 124.127, -11.275> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <26.2509, 93.5061, -16.06575>, <26.4533, 97.3923, -17.1911>, 0.2845 }
				cylinder { <26.4533, 97.3923, -17.1911>, <26.6556, 101.2785, -18.3165>, 0.2845 }
				cylinder { <26.6556, 101.2785, -18.3165>, <26.858, 105.1647, -19.4418>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <26.858, 105.1647, -19.4418>, <22.2653, 112.4703, -17.7741>, <22.1072, 110.6074, -24.2353> }
				triangle { <22.2653, 112.4703, -17.7741>, <22.2349, 119.7207, -19.8765>, <22.1072, 110.6074, -24.2353> }
				triangle { <22.1072, 110.6074, -24.2353>, <22.2349, 119.7207, -19.8765>, <22.4907, 117.5554, -27.3079> }
				triangle { <22.4907, 117.5554, -27.3079>, <22.2349, 119.7207, -19.8765>, <27.4267, 124.0034, -24.688> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <24.5295, 82.1038, -12.3552>, <24.9879, 84.7029, -13.2249>, 0.8404 }
		cylinder { <24.9879, 84.7029, -13.2249>, <24.998, 87.3842, -13.9545>, 0.8404 }
		cylinder { <24.998, 87.3842, -13.9545>, <24.5595, 90.0688, -14.5224>, 0.8404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <24.5595, 90.0688, -14.5224>, <24.1014, 91.6767, -14.7917>, 0.1189 }
			cylinder { <24.1014, 91.6767, -14.7917>, <23.4592, 93.2324, -14.9802>, 0.1189 }
			cylinder { <23.4592, 93.2324, -14.9802>, <22.6426, 94.7124, -15.08508>, 0.1189 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <22.2077, 96.206, -14.4157>, 0.1189 }
				cylinder { <22.2077, 96.206, -14.4157>, <22.2674, 97.3252, -13.146>, 0.1189 }
				cylinder { <22.2674, 97.3252, -13.146>, <22.8063, 97.7791, -11.606>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <21.6655, 95.8717, -15.8395>, 0.1189 }
				cylinder { <21.6655, 95.8717, -15.8395>, <20.7153, 96.4876, -17.09889>, 0.1189 }
				cylinder { <20.7153, 96.4876, -17.09889>, <19.9746, 96.442, -18.6211>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <22.0622, 96.2466, -14.6639>, 0.1189 }
				cylinder { <22.0622, 96.2466, -14.6639>, <21.7856, 97.6556, -13.766>, 0.1189 }
				cylinder { <21.7856, 97.6556, -13.766>, <21.8453, 98.7748, -12.4964>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <21.7066, 96.02739, -15.5976>, 0.1189 }
				cylinder { <21.7066, 96.02739, -15.5976>, <20.7188, 97.08205, -16.4808>, 0.1189 }
				cylinder { <20.7188, 97.08205, -16.4808>, <19.7509, 97.8, -17.6707>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <21.9337, 96.242, -14.9245>, 0.1189 }
				cylinder { <21.9337, 96.242, -14.9245>, <21.3532, 97.7762, -14.5034>, 0.1189 }
				cylinder { <21.3532, 97.7762, -14.5034>, <20.9183, 99.2698, -13.834>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <22.6426, 94.7124, -15.08508>, <21.8261, 96.1924, -15.1899>, 0.1189 }
				cylinder { <21.8261, 96.1924, -15.1899>, <21.00958, 97.6723, -15.2947>, 0.1189 }
				cylinder { <21.00958, 97.6723, -15.2947>, <20.193, 99.1523, -15.3995>, 0.1189 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <24.5295, 82.1038, -12.3552>, <27.9527, 88.271, -14.8865>, 2.2666 }
		cylinder { <27.9527, 88.271, -14.8865>, <32.3164, 93.8906, -17.2398>, 2.2666 }
		cylinder { <32.3164, 93.8906, -17.2398>, <37.5259, 98.8411, -19.3643>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <37.5259, 98.8411, -19.3643>, <40.6768, 101.1712, -20.3905>, 0.2845 }
			cylinder { <40.6768, 101.1712, -20.3905>, <44.1152, 103.12, -21.279>, 0.2845 }
			cylinder { <44.1152, 103.12, -21.279>, <47.7893, 104.6585, -22.01663>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <50.9161, 105.2727, -24.5177>, 0.2845 }
				cylinder { <50.9161, 105.2727, -24.5177>, <52.6833, 104.8032, -28.1325>, 0.2845 }
				cylinder { <52.6833, 104.8032, -28.1325>, <52.6316, 103.3719, -31.9218>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <52.6316, 103.3719, -31.9218>, <53.2141, 95.4533, -35.6905>, <58.262, 99.5888, -37.3215> }
				triangle { <53.2141, 95.4533, -35.6905>, <53.3962, 92.5103, -42.64>, <58.262, 99.5888, -37.3215> }
				triangle { <58.262, 99.5888, -37.3215>, <53.3962, 92.5103, -42.64>, <58.9095, 97.5731, -44.6277> }
				triangle { <58.9095, 97.5731, -44.6277>, <53.3962, 92.5103, -42.64>, <52.5115, 96.05213, -50.0643> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <51.1714, 106.6775, -21.0705>, 0.2845 }
				cylinder { <51.1714, 106.6775, -21.0705>, <53.6119, 108.7894, -18.6223>, 0.2845 }
				cylinder { <53.6119, 108.7894, -18.6223>, <54.6423, 110.5887, -15.1423>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <54.6423, 110.5887, -15.1423>, <60.3779, 109.0101, -8.6725>, <53.956, 108.8331, -6.6795> }
				triangle { <60.3779, 109.0101, -8.6725>, <62.3463, 111.9932, -2.02301>, <53.956, 108.8331, -6.6795> }
				triangle { <53.956, 108.8331, -6.6795>, <62.3463, 111.9932, -2.02301>, <54.8966, 112.1822, 0.0851> }
				triangle { <54.8966, 112.1822, 0.0851>, <62.3463, 111.9932, -2.02301>, <59.8638, 118.9107, 1.7758> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <51.2008, 105.6119, -23.9819>, 0.2845 }
				cylinder { <51.2008, 105.6119, -23.9819>, <53.9509, 105.8689, -26.9451>, 0.2845 }
				cylinder { <53.9509, 105.8689, -26.9451>, <55.7181, 105.3994, -30.5599>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <55.7181, 105.3994, -30.5599>, <59.3538, 98.7394, -34.9953>, <63.6821, 103.6723, -33.5201> }
				triangle { <59.3538, 98.7394, -34.9953>, <62.9063, 97.6019, -41.5585>, <63.6821, 103.6723, -33.5201> }
				triangle { <63.6821, 103.6723, -33.5201>, <62.9063, 97.6019, -41.5585>, <67.6062, 103.566, -40.03561> }
				triangle { <67.6062, 103.566, -40.03561>, <62.9063, 97.6019, -41.5585>, <64.387, 102.7152, -47.8916> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <51.3682, 106.5331, -21.7213>, 0.2845 }
				cylinder { <51.3682, 106.5331, -21.7213>, <54.5926, 108.6082, -20.4145>, 0.2845 }
				cylinder { <54.5926, 108.6082, -20.4145>, <57.2288, 110.7333, -18.191>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <57.2288, 110.7333, -18.191>, <65.00321, 109.1652, -14.4034>, <60.1196, 110.6346, -10.01767> }
				triangle { <65.00321, 109.1652, -14.4034>, <69.9904, 112.7873, -10.04468>, <60.1196, 110.6346, -10.01767> }
				triangle { <60.1196, 110.6346, -10.01767>, <69.9904, 112.7873, -10.04468>, <64.2791, 114.8369, -5.2322> }
				triangle { <64.2791, 114.8369, -5.2322>, <69.9904, 112.7873, -10.04468>, <70.1878, 120.6117, -7.364> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <51.3851, 105.923, -23.3882>, 0.2845 }
				cylinder { <51.3851, 105.923, -23.3882>, <54.7966, 106.8765, -25.3535>, 0.2845 }
				cylinder { <54.7966, 106.8765, -25.3535>, <57.9234, 107.4908, -27.8546>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <57.9234, 107.4908, -27.8546>, <64.2995, 102.5389, -31.3289>, <66.5746, 107.411, -27.2879> }
				triangle { <64.2995, 102.5389, -31.3289>, <70.3416, 103.4169, -35.7688>, <66.5746, 107.411, -27.2879> }
				triangle { <66.5746, 107.411, -27.2879>, <70.3416, 103.4169, -35.7688>, <72.721, 109.3124, -31.3461> }
				triangle { <72.721, 109.3124, -31.3461>, <70.3416, 103.4169, -35.7688>, <73.1782, 110.0399, -39.8353> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <47.7893, 104.6585, -22.01663>, <51.4634, 106.1969, -22.7541>, 0.2845 }
				cylinder { <51.4634, 106.1969, -22.7541>, <55.1375, 107.7354, -23.4917>, 0.2845 }
				cylinder { <55.1375, 107.7354, -23.4917>, <58.8117, 109.2738, -24.2292>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <58.8117, 109.2738, -24.2292>, <66.9031, 106.0357, -25.3645>, <66.3251, 110.0048, -19.9649> }
				triangle { <66.9031, 106.0357, -25.3645>, <73.907, 108.6157, -26.4958>, <66.3251, 110.0048, -19.9649> }
				triangle { <66.3251, 110.0048, -19.9649>, <73.907, 108.6157, -26.4958>, <73.06194, 113.4904, -20.5375> }
				triangle { <73.06194, 113.4904, -20.5375>, <73.907, 108.6157, -26.4958>, <76.7378, 116.2943, -27.709> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <37.5259, 98.8411, -19.3643>, <40.8857, 99.9767, -19.9331>, 1.08639 }
		cylinder { <40.8857, 99.9767, -19.9331>, <44.4632, 99.657, -19.9431>, 1.08639 }
		cylinder { <44.4632, 99.657, -19.9431>, <47.5716, 97.9434, -19.3926>, 1.08639 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <47.5716, 97.9434, -19.3926>, <49.2868, 96.6518, -18.9539>, 0.1539 }
			cylinder { <49.2868, 96.6518, -18.9539>, <50.7837, 95.142, -18.4221>, 0.1539 }
			cylinder { <50.7837, 95.142, -18.4221>, <52.02986, 93.4468, -17.8086>, 0.1539 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.07621, 91.58, -18.2808>, 0.1539 }
				cylinder { <53.07621, 91.58, -18.2808>, <53.6509, 90.0266, -19.7158>, 0.1539 }
				cylinder { <53.6509, 90.0266, -19.7158>, <53.6047, 89.1902, -21.741>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.1891, 92.2543, -16.3815>, 0.1539 }
				cylinder { <53.1891, 92.2543, -16.3815>, <54.03899, 91.7934, -14.4147>, 0.1539 }
				cylinder { <54.03899, 91.7934, -14.4147>, <54.4162, 92.1526, -12.286>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.1772, 91.5829, -17.9185>, 0.1539 }
				cylinder { <53.1772, 91.5829, -17.9185>, <54.09175, 89.7681, -18.739>, 0.1539 }
				cylinder { <54.09175, 89.7681, -18.739>, <54.6665, 88.2147, -20.1741>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.2512, 92.02508, -16.6731>, 0.1539 }
				cylinder { <53.2512, 92.02508, -16.6731>, <54.3595, 90.9797, -15.09771>, 0.1539 }
				cylinder { <54.3595, 90.9797, -15.09771>, <55.2743, 90.3866, -13.1966>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.2444, 91.6406, -17.5531>, 0.1539 }
				cylinder { <53.2444, 91.6406, -17.5531>, <54.3918, 89.7767, -17.663>, 0.1539 }
				cylinder { <54.3918, 89.7767, -17.663>, <55.4381, 87.9098, -18.1351>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <52.02986, 93.4468, -17.8086>, <53.2759, 91.7516, -17.1951>, 0.1539 }
				cylinder { <53.2759, 91.7516, -17.1951>, <54.522, 90.05641, -16.5817>, 0.1539 }
				cylinder { <54.522, 90.05641, -16.5817>, <55.7681, 88.3611, -15.9682>, 0.1539 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <37.5259, 98.8411, -19.3643>, <41.135, 103.776, -21.8563>, 1.9968 }
		cylinder { <41.135, 103.776, -21.8563>, <43.6249, 109.0946, -24.8729>, 1.9968 }
		cylinder { <43.6249, 109.0946, -24.8729>, <44.8999, 114.5927, -28.2982>, 1.9968 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <44.8999, 114.5927, -28.2982>, <45.3934, 117.9742, -30.4736>, 0.2845 }
			cylinder { <45.3934, 117.9742, -30.4736>, <45.5954, 121.3453, -32.7108>, 0.2845 }
			cylinder { <45.5954, 121.3453, -32.7108>, <45.5047, 124.6877, -34.9977>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.04259, 128.6953, -35.3654>, 0.2845 }
				cylinder { <45.04259, 128.6953, -35.3654>, <44.329, 132.3269, -33.7184>, 0.2845 }
				cylinder { <44.329, 132.3269, -33.7184>, <43.5494, 134.6388, -30.4846>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <43.5494, 134.6388, -30.4846>, <36.4803, 136.492, -25.602>, <39.01115, 141.8342, -28.8112> }
				triangle { <36.4803, 136.492, -25.602>, <34.6652, 140.8888, -19.74>, <39.01115, 141.8342, -28.8112> }
				triangle { <39.01115, 141.8342, -28.8112>, <34.6652, 140.8888, -19.74>, <37.9715, 146.9386, -23.2681> }
				triangle { <37.9715, 146.9386, -23.2681>, <34.6652, 140.8888, -19.74>, <39.3387, 145.7354, -14.9321> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.7552, 126.7555, -38.4721>, 0.2845 }
				cylinder { <45.7552, 126.7555, -38.4721>, <46.2988, 127.1517, -42.4667>, 0.2845 }
				cylinder { <46.2988, 127.1517, -42.4667>, <47.03108, 125.8001, -46.2147>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <47.03108, 125.8001, -46.2147>, <42.2138, 124.0791, -53.3616>, <45.2748, 118.6605, -50.8095> }
				triangle { <42.2138, 124.0791, -53.3616>, <43.2269, 121.3546, -60.3287>, <45.2748, 118.6605, -50.8095> }
				triangle { <45.2748, 118.6605, -50.8095>, <43.2269, 121.3546, -60.3287>, <47.1277, 115.3403, -57.3977> }
				triangle { <47.1277, 115.3403, -57.3977>, <43.2269, 121.3546, -60.3287>, <50.1189, 119.2262, -64.3804> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.1574, 128.5862, -36.04227>, 0.2845 }
				cylinder { <45.1574, 128.5862, -36.04227>, <44.594, 132.585, -35.7223>, 0.2845 }
				cylinder { <44.594, 132.585, -35.7223>, <43.8804, 136.2165, -34.07537>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <43.8804, 136.2165, -34.07537>, <36.7953, 140.6007, -31.2777>, <39.925, 143.559, -36.4447> }
				triangle { <36.7953, 140.6007, -31.2777>, <35.1199, 147.3859, -28.4239>, <39.925, 143.559, -36.4447> }
				triangle { <39.925, 143.559, -36.4447>, <35.1199, 147.3859, -28.4239>, <39.09769, 150.7629, -34.1468> }
				triangle { <39.09769, 150.7629, -34.1468>, <35.1199, 147.3859, -28.4239>, <39.9875, 153.6884, -26.1809> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.6247, 127.3141, -38.07951>, 0.2845 }
				cylinder { <45.6247, 127.3141, -38.07951>, <45.9467, 129.0343, -41.7329>, 0.2845 }
				cylinder { <45.9467, 129.0343, -41.7329>, <46.4474, 129.7236, -45.6932>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <46.4474, 129.7236, -45.6932>, <41.1707, 131.2371, -52.5571>, <44.7263, 125.5529, -53.09692> }
				triangle { <41.1707, 131.2371, -52.5571>, <41.7669, 132.3029, -60.00687>, <44.7263, 125.5529, -53.09692> }
				triangle { <44.7263, 125.5529, -53.09692>, <41.7669, 132.3029, -60.00687>, <46.2221, 125.9907, -60.5422> }
				triangle { <46.2221, 125.9907, -60.5422>, <41.7669, 132.3029, -60.00687>, <48.4162, 133.0036, -64.8794> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.2824, 128.3623, -36.6883>, 0.2845 }
				cylinder { <45.2824, 128.3623, -36.6883>, <44.9351, 132.2608, -37.7328>, 0.2845 }
				cylinder { <44.9351, 132.2608, -37.7328>, <44.4729, 136.2684, -38.1006>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <44.4729, 136.2684, -38.1006>, <37.6861, 141.8475, -38.3422>, <41.2874, 141.7417, -44.02232> }
				triangle { <37.6861, 141.8475, -38.3422>, <36.4919, 149.246, -39.2519>, <41.2874, 141.7417, -44.02232> }
				triangle { <41.2874, 141.7417, -44.02232>, <36.4919, 149.246, -39.2519>, <40.9984, 149.1877, -45.5501> }
				triangle { <40.9984, 149.1877, -45.5501>, <36.4919, 149.246, -39.2519>, <41.7931, 155.561, -39.9328> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <45.5047, 124.6877, -34.9977>, <45.414, 128.0301, -37.2846>, 0.2845 }
				cylinder { <45.414, 128.0301, -37.2846>, <45.3234, 131.3726, -39.5715>, 0.2845 }
				cylinder { <45.3234, 131.3726, -39.5715>, <45.2327, 134.715, -41.8584>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <45.2327, 134.715, -41.8584>, <38.981, 139.8426, -45.3037>, <42.8041, 136.7885, -49.919> }
				triangle { <38.981, 139.8426, -45.3037>, <38.4843, 145.9198, -49.7546>, <42.8041, 136.7885, -49.919> }
				triangle { <42.8041, 136.7885, -49.919>, <38.4843, 145.9198, -49.7546>, <43.2394, 142.5564, -54.859> }
				triangle { <43.2394, 142.5564, -54.859>, <38.4843, 145.9198, -49.7546>, <44.3461, 150.8006, -52.9584> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <44.8999, 114.5927, -28.2982>, <46.1571, 118.4225, -30.4245>, 1.3784 }
		cylinder { <46.1571, 118.4225, -30.4245>, <47.7791, 122.25, -32.2922>, 1.3784 }
		cylinder { <47.7791, 122.25, -32.2922>, <49.7503, 126.0383, -33.8833>, 1.3784 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <49.7503, 126.0383, -33.8833>, <51.05675, 128.2352, -34.6912>, 0.1883 }
			cylinder { <51.05675, 128.2352, -34.6912>, <52.5028, 130.3888, -35.3667>, 0.1883 }
			cylinder { <52.5028, 130.3888, -35.3667>, <54.08093, 132.4874, -35.9061>, 0.1883 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <56.0936, 133.5989, -37.2843>, 0.1883 }
				cylinder { <56.0936, 133.5989, -37.2843>, <58.01793, 133.4344, -39.1432>, 0.1883 }
				cylinder { <58.01793, 133.4344, -39.1432>, <59.3539, 132.0366, -40.9998>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <54.9526, 135.0044, -35.6053>, 0.1883 }
				cylinder { <54.9526, 135.0044, -35.6053>, <54.9506, 137.4564, -34.5221>, 0.1883 }
				cylinder { <54.9506, 137.4564, -34.5221>, <54.07533, 139.3726, -32.8645>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <56.00391, 133.975, -37.03518>, 0.1883 }
				cylinder { <56.00391, 133.975, -37.03518>, <58.047, 134.6776, -38.6219>, 0.1883 }
				cylinder { <58.047, 134.6776, -38.6219>, <59.9713, 134.5131, -40.4808>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <55.2557, 134.8967, -35.9341>, 0.1883 }
				cylinder { <55.2557, 134.8967, -35.9341>, <55.9421, 137.4421, -35.4488>, 0.1883 }
				cylinder { <55.9421, 137.4421, -35.4488>, <56.09045, 139.9391, -34.4853>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <55.8576, 134.3074, -36.7528>, 0.1883 }
				cylinder { <55.8576, 134.3074, -36.7528>, <57.7805, 135.7949, -37.8818>, 0.1883 }
				cylinder { <57.7805, 135.7949, -37.8818>, <59.7932, 136.9064, -39.26>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <54.08093, 132.4874, -35.9061>, <55.6589, 134.5861, -36.4455>, 0.1883 }
				cylinder { <55.6589, 134.5861, -36.4455>, <57.237, 136.6847, -36.9849>, 0.1883 }
				cylinder { <57.237, 136.6847, -36.9849>, <58.8151, 138.7834, -37.5243>, 0.1883 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <49.7503, 126.0383, -33.8833>, <50.5481, 127.5254, -34.4711>, 0.5404 }
		cylinder { <50.5481, 127.5254, -34.4711>, <51.3701, 129.0132, -35.02233>, 0.5404 }
		cylinder { <51.3701, 129.0132, -35.02233>, <52.216, 130.5008, -35.5367>, 0.5404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <52.216, 130.5008, -35.5367>, <52.6853, 131.4028, -35.9155>, 0.07621 }
			cylinder { <52.6853, 131.4028, -35.9155>, <53.1078, 132.2984, -36.3587>, 0.07621 }
			cylinder { <53.1078, 132.2984, -36.3587>, <53.4812, 133.183, -36.864>, 0.07621 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <53.4327, 134.2488, -37.06108>, 0.07621 }
				cylinder { <53.4327, 134.2488, -37.06108>, <52.9749, 135.219, -36.8987>, 0.07621 }
				cylinder { <52.9749, 135.219, -36.8987>, <52.2267, 135.8414, -36.4192>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <54.1427, 133.7257, -37.5311>, 0.07621 }
				cylinder { <54.1427, 133.7257, -37.5311>, <54.9653, 133.8224, -38.232>, 0.07621 }
				cylinder { <54.9653, 133.8224, -38.232>, <55.7909, 133.4544, -38.8322>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <53.5776, 134.2183, -37.1739>, 0.07621 }
				cylinder { <53.5776, 134.2183, -37.1739>, <53.3857, 135.2833, -37.2523>, 0.07621 }
				cylinder { <53.3857, 135.2833, -37.2523>, <52.9278, 136.2535, -37.09001>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <54.04324, 133.8753, -37.4822>, 0.07621 }
				cylinder { <54.04324, 133.8753, -37.4822>, <54.753, 134.3251, -38.1685>, 0.07621 }
				cylinder { <54.753, 134.3251, -38.1685>, <55.5592, 134.4998, -38.8733>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <53.7196, 134.1573, -37.2777>, 0.07621 }
				cylinder { <53.7196, 134.1573, -37.2777>, <53.816, 135.1926, -37.5876>, 0.07621 }
				cylinder { <53.816, 135.1926, -37.5876>, <53.7675, 136.2584, -37.7847>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <53.4812, 133.183, -36.864>, <53.8547, 134.0676, -37.3692>, 0.07621 }
				cylinder { <53.8547, 134.0676, -37.3692>, <54.2281, 134.9521, -37.8745>, 0.07621 }
				cylinder { <54.2281, 134.9521, -37.8745>, <54.6015, 135.8367, -38.3797>, 0.07621 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-1.3659, 50.8486, 2.8267>, <-1.7596, 58.3296, 3.02579>, 2.2666 }
		cylinder { <-1.7596, 58.3296, 3.02579>, <-3.2345, 65.6682, 3.3873>, 2.2666 }
		cylinder { <-3.2345, 65.6682, 3.3873>, <-5.7587, 72.7054, 3.9034>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.7587, 72.7054, 3.9034>, <-7.3964, 76.3968, 4.222>, 0.2845 }
			cylinder { <-7.3964, 76.3968, 4.222>, <-9.2985, 79.9555, 4.5786>, 0.2845 }
			cylinder { <-9.2985, 79.9555, 4.5786>, <-11.4547, 83.3624, 4.9711>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.02948, 86.29, 7.2861>, 0.2845 }
				cylinder { <-13.02948, 86.29, 7.2861>, <-13.6136, 87.9777, 10.9221>, 0.2845 }
				cylinder { <-13.6136, 87.9777, 10.9221>, <-13.0554, 87.9869, 14.9344>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-13.0554, 87.9869, 14.9344>, <-16.3044, 83.5239, 21.7733>, <-17.6879, 90.104, 21.9506> }
				triangle { <-16.3044, 83.5239, 21.7733>, <-15.6627, 83.4687, 29.295>, <-17.6879, 90.104, 21.9506> }
				triangle { <-17.6879, 90.104, 21.9506>, <-15.6627, 83.4687, 29.295>, <-16.8287, 91.1237, 29.4395> }
				triangle { <-16.8287, 91.1237, 29.4395>, <-15.6627, 83.4687, 29.295>, <-10.7214, 87.7587, 34.3571> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.6652, 86.474, 3.614>, 0.2845 }
				cylinder { <-13.6652, 86.474, 3.614>, <-15.5057, 88.6928, 0.768>, 0.2845 }
				cylinder { <-15.5057, 88.6928, 0.768>, <-16.6226, 89.5927, -3.02038>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-16.6226, 89.5927, -3.02038>, <-24.02373, 89.02515, -7.7265>, <-19.02055, 85.2116, -10.1074> }
				triangle { <-24.02373, 89.02515, -7.7265>, <-26.3409, 90.3697, -14.7843>, <-19.02055, 85.2116, -10.1074> }
				triangle { <-19.02055, 85.2116, -10.1074>, <-26.3409, 90.3697, -14.7843>, <-20.3228, 86.3335, -17.5174> }
				triangle { <-20.3228, 86.3335, -17.5174>, <-26.3409, 90.3697, -14.7843>, <-22.4093, 93.7183, -21.2477> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.2789, 86.5451, 6.6895>, 0.2845 }
				cylinder { <-13.2789, 86.5451, 6.6895>, <-14.5578, 89.1314, 9.5329>, 0.2845 }
				cylinder { <-14.5578, 89.1314, 9.5329>, <-15.142, 90.8191, 13.1689>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-15.142, 90.8191, 13.1689>, <-20.1746, 89.1404, 20.1761>, <-21.5475, 95.02612, 17.2236> }
				triangle { <-20.1746, 89.1404, 20.1761>, <-21.6585, 92.1913, 26.92>, <-21.5475, 95.02612, 17.2236> }
				triangle { <-21.5475, 95.02612, 17.2236>, <-21.6585, 92.1913, 26.92>, <-22.8125, 99.06521, 23.544> }
				triangle { <-22.8125, 99.06521, 23.544>, <-21.6585, 92.1913, 26.92>, <-18.3236, 98.6982, 30.7911> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.6958, 86.6657, 4.2815>, 0.2845 }
				cylinder { <-13.6958, 86.6657, 4.2815>, <-15.8595, 89.6261, 2.5598>, 0.2845 }
				cylinder { <-15.8595, 89.6261, 2.5598>, <-17.7891, 92.02917, -0.06928>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-17.7891, 92.02917, -0.06928>, <-26.1564, 93.479, -2.3344>, <-22.3999, 91.01718, -7.3416> }
				triangle { <-26.1564, 93.479, -2.3344>, <-30.01678, 97.6542, -7.3>, <-22.3999, 91.01718, -7.3416> }
				triangle { <-22.3999, 91.01718, -7.3416>, <-30.01678, 97.6542, -7.3>, <-25.4009, 95.1383, -12.9871> }
				triangle { <-25.4009, 95.1383, -12.9871>, <-30.01678, 97.6542, -7.3>, <-27.4928, 103.405, -12.6855> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.4746, 86.7064, 6.04236>, 0.2845 }
				cylinder { <-13.4746, 86.7064, 6.04236>, <-15.2988, 89.889, 7.7607>, 0.2845 }
				cylinder { <-15.2988, 89.889, 7.7607>, <-16.8736, 92.8167, 10.07579>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-16.8736, 92.8167, 10.07579>, <-23.6637, 93.5266, 15.6107>, <-24.1532, 97.5237, 10.223> }
				triangle { <-23.6637, 93.5266, 15.6107>, <-26.9691, 98.838, 19.836>, <-24.1532, 97.5237, 10.223> }
				triangle { <-24.1532, 97.5237, 10.223>, <-26.9691, 98.838, 19.836>, <-27.1293, 103.5875, 13.7208> }
				triangle { <-27.1293, 103.5875, 13.7208>, <-26.9691, 98.838, 19.836>, <-24.8426, 106.6921, 21.3324> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.4547, 83.3624, 4.9711>, <-13.6109, 86.7693, 5.3636>, 0.2845 }
				cylinder { <-13.6109, 86.7693, 5.3636>, <-15.7671, 90.1761, 5.7561>, 0.2845 }
				cylinder { <-15.7671, 90.1761, 5.7561>, <-17.9233, 93.583, 6.1486>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-17.9233, 93.583, 6.1486>, <-25.9882, 95.6653, 8.9534>, <-24.9509, 97.07027, 2.4578> }
				triangle { <-25.9882, 95.6653, 8.9534>, <-30.3377, 101.8044, 9.5738>, <-24.9509, 97.07027, 2.4578> }
				triangle { <-24.9509, 97.07027, 2.4578>, <-30.3377, 101.8044, 9.5738>, <-28.7805, 103.638, 2.2123> }
				triangle { <-28.7805, 103.638, 2.2123>, <-30.3377, 101.8044, 9.5738>, <-28.7074, 109.7857, 8.1289> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-5.7587, 72.7054, 3.9034>, <-11.1448, 77.8345, 4.8211>, 2.2666 }
		cylinder { <-11.1448, 77.8345, 4.8211>, <-18.2427, 79.9601, 5.9443>, 2.2666 }
		cylinder { <-18.2427, 79.9601, 5.9443>, <-25.5366, 78.6284, 7.0333>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-25.5366, 78.6284, 7.0333>, <-29.3917, 77.5213, 7.6013>, 0.2845 }
			cylinder { <-29.3917, 77.5213, 7.6013>, <-33.122, 76.03767, 8.1433>, 0.2845 }
			cylinder { <-33.122, 76.03767, 8.1433>, <-36.6916, 74.1917, 8.654>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-39.4961, 72.549, 11.07195>, 0.2845 }
				cylinder { <-39.4961, 72.549, 11.07195>, <-40.8068, 71.5362, 14.7687>, 0.2845 }
				cylinder { <-40.8068, 71.5362, 14.7687>, <-40.2833, 71.4166, 18.7838>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-40.2833, 71.4166, 18.7838>, <-35.3616, 66.7517, 24.3751>, <-41.9744, 65.8479, 25.2104> }
				triangle { <-35.3616, 66.7517, 24.3751>, <-34.3468, 66.1239, 31.8294>, <-41.9744, 65.8479, 25.2104> }
				triangle { <-41.9744, 65.8479, 25.2104>, <-34.3468, 66.1239, 31.8294>, <-42.00525, 65.519, 32.8099> }
				triangle { <-42.00525, 65.519, 32.8099>, <-34.3468, 66.1239, 31.8294>, <-37.5139, 70.455, 38.1268> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-40.1798, 72.5549, 7.4039>, 0.2845 }
				cylinder { <-40.1798, 72.5549, 7.4039>, <-42.9169, 71.4414, 4.6329>, 0.2845 }
				cylinder { <-42.9169, 71.4414, 4.6329>, <-44.3772, 71.06503, 0.8731>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-44.3772, 71.06503, 0.8731>, <-45.3781, 64.5017, -4.8859>, <-41.1854, 69.3193, -6.9967> }
				triangle { <-45.3781, 64.5017, -4.8859>, <-47.8053, 63.5285, -11.9677>, <-41.1854, 69.3193, -6.9967> }
				triangle { <-41.1854, 69.3193, -6.9967>, <-47.8053, 63.5285, -11.9677>, <-43.2896, 69.3696, -14.3064> }
				triangle { <-43.2896, 69.3696, -14.3064>, <-47.8053, 63.5285, -11.9677>, <-51.2603, 68.8249, -17.3023> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-39.8465, 72.4287, 10.4838>, 0.2845 }
				cylinder { <-39.8465, 72.4287, 10.4838>, <-42.218, 70.9546, 13.4186>, 0.2845 }
				cylinder { <-42.218, 70.9546, 13.4186>, <-43.5288, 69.9418, 17.1154>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-43.5288, 69.9418, 17.1154>, <-41.5521, 63.7621, 23.04407>, <-47.8398, 63.3259, 20.6951> }
				triangle { <-41.5521, 63.7621, 23.04407>, <-43.9431, 61.4832, 29.8322>, <-47.8398, 63.3259, 20.6951> }
				triangle { <-47.8398, 63.3259, 20.6951>, <-43.9431, 61.4832, 29.8322>, <-51.2353, 61.4051, 27.2252> }
				triangle { <-51.2353, 61.4051, 27.2252>, <-43.9431, 61.4832, 29.8322>, <-49.618, 64.665, 34.9428> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-40.2949, 72.4326, 8.07844>, 0.2845 }
				cylinder { <-40.2949, 72.4326, 8.07844>, <-43.6709, 70.8875, 6.4581>, 0.2845 }
				cylinder { <-43.6709, 70.8875, 6.4581>, <-46.575, 69.6686, 3.9105>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-46.575, 69.6686, 3.9105>, <-49.355, 61.9641, 0.7232>, <-46.9643, 66.123, -3.9918> }
				triangle { <-49.355, 61.9641, 0.7232>, <-54.5104, 59.4077, -4.1631>, <-46.9643, 66.123, -3.9918> }
				triangle { <-46.9643, 66.123, -3.9918>, <-54.5104, 59.4077, -4.1631>, <-52.02515, 64.5067, -9.4359> }
				triangle { <-52.02515, 64.5067, -9.4359>, <-54.5104, 59.4077, -4.1631>, <-60.4166, 63.3648, -8.3946> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-40.1041, 72.3603, 9.8418>, 0.2845 }
				cylinder { <-40.1041, 72.3603, 9.8418>, <-43.259, 70.5973, 11.6715>, 0.2845 }
				cylinder { <-43.259, 70.5973, 11.6715>, <-46.06357, 68.9545, 14.0894>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-46.06357, 68.9545, 14.0894>, <-46.8607, 61.5054, 18.6852>, <-51.4492, 62.1657, 13.8115> }
				triangle { <-46.8607, 61.5054, 18.6852>, <-51.9921, 58.07965, 23.03524>, <-51.4492, 62.1657, 13.8115> }
				triangle { <-51.4492, 62.1657, 13.8115>, <-51.9921, 58.07965, 23.03524>, <-57.3699, 59.2368, 17.5837> }
				triangle { <-57.3699, 59.2368, 17.5837>, <-51.9921, 58.07965, 23.03524>, <-59.3764, 60.6286, 25.7593> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-36.6916, 74.1917, 8.654>, <-40.2611, 72.3459, 9.1648>, 0.2845 }
				cylinder { <-40.2611, 72.3459, 9.1648>, <-43.8307, 70.5, 9.6755>, 0.2845 }
				cylinder { <-43.8307, 70.5, 9.6755>, <-47.4003, 68.6541, 10.1862>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-47.4003, 68.6541, 10.1862>, <-50.07943, 60.5111, 12.1253>, <-52.0361, 62.6118, 6.04244> }
				triangle { <-50.07943, 60.5111, 12.1253>, <-56.5736, 56.7405, 12.8985>, <-52.0361, 62.6118, 6.04244> }
				triangle { <-52.0361, 62.6118, 6.04244>, <-56.5736, 56.7405, 12.8985>, <-58.9862, 59.5206, 6.08461> }
				triangle { <-58.9862, 59.5206, 6.08461>, <-56.5736, 56.7405, 12.8985>, <-64.425, 59.3374, 12.6565> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-25.5366, 78.6284, 7.0333>, <-26.6157, 77.7664, 7.182>, 0.4201 }
		cylinder { <-26.6157, 77.7664, 7.182>, <-27.167, 76.4928, 7.2425>, 0.4201 }
		cylinder { <-27.167, 76.4928, 7.2425>, <-27.06049, 75.1085, 7.2005>, 0.4201 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-27.06049, 75.1085, 7.2005>, <-26.9336, 74.2673, 7.1655>, 0.0598 }
			cylinder { <-26.9336, 74.2673, 7.1655>, <-26.7458, 73.4381, 7.1215>, 0.0598 }
			cylinder { <-26.7458, 73.4381, 7.1215>, <-26.4982, 72.6253, 7.0686>, 0.0598 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.2195, 71.9103, 7.4373>, 0.0598 }
				cylinder { <-26.2195, 71.9103, 7.4373>, <-25.982, 71.479, 8.1318>, 0.0598 }
				cylinder { <-25.982, 71.479, 8.1318>, <-25.8475, 71.4434, 8.9718>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.3293, 71.8971, 6.661>, 0.0598 }
				cylinder { <-26.3293, 71.8971, 6.661>, <-26.2716, 71.3936, 5.9769>, 0.0598 }
				cylinder { <-26.2716, 71.3936, 5.9769>, <-26.3361, 71.2112, 5.1478>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.2218, 71.8547, 7.3022>, 0.0598 }
				cylinder { <-26.2218, 71.8547, 7.3022>, <-25.9489, 71.2164, 7.7952>, 0.0598 }
				cylinder { <-25.9489, 71.2164, 7.7952>, <-25.7114, 70.7851, 8.4897>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.2939, 71.846, 6.7931>, 0.0598 }
				cylinder { <-26.2939, 71.846, 6.7931>, <-26.1476, 71.1569, 6.3152>, 0.0598 }
				cylinder { <-26.1476, 71.1569, 6.3152>, <-26.06993, 70.6077, 5.6692>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.2323, 71.8217, 7.1603>, 0.0598 }
				cylinder { <-26.2323, 71.8217, 7.1603>, <-25.9559, 71.05116, 7.394>, 0.0598 }
				cylinder { <-25.9559, 71.05116, 7.394>, <-25.6772, 70.3362, 7.7627>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-26.4982, 72.6253, 7.0686>, <-26.2506, 71.8124, 7.0157>, 0.0598 }
				cylinder { <-26.2506, 71.8124, 7.0157>, <-26.00308, 70.9996, 6.9627>, 0.0598 }
				cylinder { <-26.00308, 70.9996, 6.9627>, <-25.7554, 70.1867, 6.9098>, 0.0598 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-25.5366, 78.6284, 7.0333>, <-32.8801, 78.332, 8.498>, 2.2666 }
		cylinder { <-32.8801, 78.332, 8.498>, <-40.1143, 79.07747, 10.3068>, 2.2666 }
		cylinder { <-40.1143, 79.07747, 10.3068>, <-47.0825, 80.8485, 12.4205>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-47.0825, 80.8485, 12.4205>, <-50.6238, 82.3396, 13.7032>, 0.2845 }
			cylinder { <-50.6238, 82.3396, 13.7032>, <-53.8633, 84.3321, 15.09827>, 0.2845 }
			cylinder { <-53.8633, 84.3321, 15.09827>, <-56.7306, 86.7829, 16.5754>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-59.6199, 89.5664, 16.01478>, 0.2845 }
				cylinder { <-59.6199, 89.5664, 16.01478>, <-61.7804, 91.9593, 13.562>, 0.2845 }
				cylinder { <-61.7804, 91.9593, 13.562>, <-62.6508, 93.3399, 9.8544>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-62.6508, 93.3399, 9.8544>, <-58.4656, 98.0456, 3.7235>, <-63.9713, 101.0616, 6.1391> }
				triangle { <-58.4656, 98.0456, 3.7235>, <-59.8784, 100.9568, -3.09692>, <-63.9713, 101.0616, 6.1391> }
				triangle { <-63.9713, 101.0616, 6.1391>, <-59.8784, 100.9568, -3.09692>, <-66.4408, 104.0618, -0.4> }
				triangle { <-66.4408, 104.0618, -0.4>, <-59.8784, 100.9568, -3.09692>, <-66.4764, 100.2617, -8.03963> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-58.9805, 88.4336, 19.5119>, 0.2845 }
				cylinder { <-58.9805, 88.4336, 19.5119>, <-60.1809, 88.9674, 23.3439>, 0.2845 }
				cylinder { <-60.1809, 88.9674, 23.3439>, <-60.1013, 88.2815, 27.3355>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-60.1013, 88.2815, 27.3355>, <-58.03825, 92.9313, 34.5028>, <-54.05072, 87.6064, 33.5084> }
				triangle { <-58.03825, 92.9313, 34.5028>, <-57.5549, 91.8844, 41.9634>, <-54.05072, 87.6064, 33.5084> }
				triangle { <-54.05072, 87.6064, 33.5084>, <-57.5549, 91.8844, 41.9634>, <-53.3238, 85.506, 40.7832> }
				triangle { <-53.3238, 85.506, 40.7832>, <-57.5549, 91.8844, 41.9634>, <-59.4976, 85.3645, 46.6713> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-59.6999, 89.5354, 16.7045>, 0.2845 }
				cylinder { <-59.6999, 89.5354, 16.7045>, <-62.4241, 92.2679, 15.4706>, 0.2845 }
				cylinder { <-62.4241, 92.2679, 15.4706>, <-64.5846, 94.6608, 13.01788>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-64.5846, 94.6608, 13.01788>, <-62.9052, 101.5602, 7.8386>, <-67.1084, 102.9547, 12.9014> }
				triangle { <-62.9052, 101.5602, 7.8386>, <-66.7012, 106.3332, 3.3889>, <-67.1084, 102.9547, 12.9014> }
				triangle { <-67.1084, 102.9547, 12.9014>, <-66.7012, 106.3332, 3.3889>, <-71.7827, 107.5946, 9.09564> }
				triangle { <-71.7827, 107.5946, 9.09564>, <-66.7012, 106.3332, 3.3889>, <-74.6607, 106.497, 1.1384> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-59.2806, 88.7926, 18.9978>, 0.2845 }
				cylinder { <-59.2806, 88.7926, 18.9978>, <-61.3286, 90.2157, 22.1901>, 0.2845 }
				cylinder { <-61.3286, 90.2157, 22.1901>, <-62.7261, 90.9489, 25.921>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-62.7261, 90.9489, 25.921>, <-62.7511, 97.8034, 31.4221>, <-59.3299, 92.4989, 33.7462> }
				triangle { <-62.7511, 97.8034, 31.4221>, <-65.02421, 99.3975, 38.4422>, <-59.3299, 92.4989, 33.7462> }
				triangle { <-59.3299, 92.4989, 33.7462>, <-65.02421, 99.3975, 38.4422>, <-61.437, 93.04239, 41.03503> }
				triangle { <-61.437, 93.04239, 41.03503>, <-65.02421, 99.3975, 38.4422>, <-69.2449, 94.8832, 43.9424> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-59.6925, 89.4234, 17.3905>, 0.2845 }
				cylinder { <-59.6925, 89.4234, 17.3905>, <-62.6619, 92.176, 17.5197>, 0.2845 }
				cylinder { <-62.6619, 92.176, 17.5197>, <-65.5511, 94.9594, 16.959>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-65.5511, 94.9594, 16.959>, <-65.8316, 103.312, 14.2383>, <-67.8648, 102.4821, 20.596> }
				triangle { <-65.8316, 103.312, 14.2383>, <-70.9543, 108.7817, 13.3271>, <-67.8648, 102.4821, 20.596> }
				triangle { <-67.8648, 102.4821, 20.596>, <-70.9543, 108.7817, 13.3271>, <-73.5686, 107.514, 20.5061> }
				triangle { <-73.5686, 107.514, 20.5061>, <-70.9543, 108.7817, 13.3271>, <-79.1818, 108.7181, 14.1936> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-56.7306, 86.7829, 16.5754>, <-59.5979, 89.2337, 18.05256>, 0.2845 }
				cylinder { <-59.5979, 89.2337, 18.05256>, <-62.4653, 91.6845, 19.5297>, 0.2845 }
				cylinder { <-62.4653, 91.6845, 19.5297>, <-65.3326, 94.1353, 21.00686>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-65.3326, 94.1353, 21.00686>, <-66.5178, 102.8229, 21.6127>, <-66.07728, 99.7437, 27.5766> }
				triangle { <-66.5178, 102.8229, 21.6127>, <-71.5662, 107.6432, 24.4882>, <-66.07728, 99.7437, 27.5766> }
				triangle { <-66.07728, 99.7437, 27.5766>, <-71.5662, 107.6432, 24.4882>, <-71.368, 103.8181, 31.2193> }
				triangle { <-71.368, 103.8181, 31.2193>, <-71.5662, 107.6432, 24.4882>, <-78.8983, 106.3251, 28.08674> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-47.0825, 80.8485, 12.4205>, <-49.7413, 82.8909, 13.7091>, 1.08639 }
		cylinder { <-49.7413, 82.8909, 13.7091>, <-51.3144, 85.8159, 15.07694>, 1.08639 }
		cylinder { <-51.3144, 85.8159, 15.07694>, <-51.5622, 89.1782, 16.3158>, 1.08639 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-51.5622, 89.1782, 16.3158>, <-51.5027, 91.2481, 17.03318>, 0.1539 }
			cylinder { <-51.5027, 91.2481, 17.03318>, <-51.2329, 93.3166, 17.7051>, 0.1539 }
			cylinder { <-51.2329, 93.3166, 17.7051>, <-50.7556, 95.3637, 18.3251>, 0.1539 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.5536, 97.4971, 17.8659>, 0.1539 }
				cylinder { <-50.5536, 97.4971, 17.8659>, <-50.6796, 99.1624, 16.4469>, 0.1539 }
				cylinder { <-50.6796, 99.1624, 16.4469>, <-51.1007, 99.927, 14.4367>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.1389, 96.9087, 19.7518>, 0.1539 }
				cylinder { <-50.1389, 96.9087, 19.7518>, <-49.5014, 97.655, 21.7113>, 0.1539 }
				cylinder { <-49.5014, 97.655, 21.7113>, <-48.9655, 97.4592, 23.8272>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.452, 97.5319, 18.2263>, 0.1539 }
				cylinder { <-50.452, 97.5319, 18.2263>, <-50.3576, 99.5676, 17.4203>, 0.1539 }
				cylinder { <-50.3576, 99.5676, 17.4203>, <-50.4836, 101.233, 16.0013>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.18, 97.146, 19.463>, 0.1539 }
				cylinder { <-50.18, 97.146, 19.463>, <-49.548, 98.5345, 21.03643>, 0.1539 }
				cylinder { <-49.548, 98.5345, 21.03643>, <-48.9053, 99.4285, 22.9313>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.3593, 97.5028, 18.5896>, 0.1539 }
				cylinder { <-50.3593, 97.5028, 18.5896>, <-50.05571, 99.671, 18.4908>, 0.1539 }
				cylinder { <-50.05571, 99.671, 18.4908>, <-49.8537, 101.8044, 18.03171>, 0.1539 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-50.7556, 95.3637, 18.3251>, <-50.2782, 97.4108, 18.9451>, 0.1539 }
				cylinder { <-50.2782, 97.4108, 18.9451>, <-49.8009, 99.4579, 19.5651>, 0.1539 }
				cylinder { <-49.8009, 99.4579, 19.5651>, <-49.3235, 101.505, 20.1851>, 0.1539 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-47.0825, 80.8485, 12.4205>, <-52.9754, 81.7063, 13.7291>, 1.8441 }
		cylinder { <-52.9754, 81.7063, 13.7291>, <-59.00331, 81.968, 14.6069>, 1.8441 }
		cylinder { <-59.00331, 81.968, 14.6069>, <-65.07555, 81.6297, 15.04063>, 1.8441 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-65.07555, 81.6297, 15.04063>, <-68.7426, 81.2079, 15.1398>, 0.2594 }
			cylinder { <-68.7426, 81.2079, 15.1398>, <-72.3794, 80.5715, 15.07491>, 0.2594 }
			cylinder { <-72.3794, 80.5715, 15.07491>, <-75.9662, 79.7239, 14.8463>, 0.2594 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-78.9228, 77.9004, 16.09871>, 0.2594 }
				cylinder { <-78.9228, 77.9004, 16.09871>, <-80.4811, 75.5746, 18.5066>, 0.2594 }
				cylinder { <-80.4811, 75.5746, 18.5066>, <-80.2361, 73.351, 21.4444>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-80.2361, 73.351, 21.4444>, <-77.4436, 65.9778, 22.8671>, <-83.4787, 66.5371, 23.7937> }
				triangle { <-77.4436, 65.9778, 22.8671>, <-77.05961, 61.5465, 28.1179>, <-83.4787, 66.5371, 23.7937> }
				triangle { <-83.4787, 66.5371, 23.7937>, <-77.05961, 61.5465, 28.1179>, <-83.9319, 62.5062, 29.4173> }
				triangle { <-83.9319, 62.5062, 29.4173>, <-77.05961, 61.5465, 28.1179>, <-78.9435, 62.3, 35.3813> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-79.351, 79.8999, 13.3808>, 0.2594 }
				cylinder { <-79.351, 79.8999, 13.3808>, <-81.8839, 81.06555, 10.9598>, 0.2594 }
				cylinder { <-81.8839, 81.06555, 10.9598>, <-83.0785, 82.997, 8.04821>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-83.0785, 82.997, 8.04821>, <-84.897, 81.3742, 0.4163>, <-80.1803, 85.2408, 1.04624> }
				triangle { <-84.897, 81.3742, 0.4163>, <-86.9067, 84.7628, -5.2257>, <-80.1803, 85.2408, 1.04624> }
				triangle { <-80.1803, 85.2408, 1.04624>, <-86.9067, 84.7628, -5.2257>, <-81.7048, 89.4366, -4.2594> }
				triangle { <-81.7048, 89.4366, -4.2594>, <-86.9067, 84.7628, -5.2257>, <-88.7727, 91.9968, -6.256> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-79.2311, 78.1836, 15.623>, 0.2594 }
				cylinder { <-79.2311, 78.1836, 15.623>, <-81.7924, 76.1305, 17.3142>, 0.2594 }
				cylinder { <-81.7924, 76.1305, 17.3142>, <-83.3506, 73.8047, 19.7221>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-83.3506, 73.8047, 19.7221>, <-83.4866, 65.8665, 20.7955>, <-88.9895, 68.2697, 19.5555> }
				triangle { <-83.4866, 65.8665, 20.7955>, <-86.4441, 61.2941, 25.00282>, <-88.9895, 68.2697, 19.5555> }
				triangle { <-88.9895, 68.2697, 19.5555>, <-86.4441, 61.2941, 25.00282>, <-92.7186, 64.3244, 23.8691> }
				triangle { <-92.7186, 64.3244, 23.8691>, <-86.4441, 61.2941, 25.00282>, <-90.7661, 62.2545, 31.1078> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-79.5118, 79.4948, 13.8407>, 0.2594 }
				cylinder { <-79.5118, 79.4948, 13.8407>, <-82.7595, 79.9006, 12.131>, 0.2594 }
				cylinder { <-82.7595, 79.9006, 12.131>, <-85.474, 80.9121, 9.8409>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-85.474, 80.9121, 9.8409>, <-89.3133, 77.5922, 3.6422>, <-86.181, 82.6516, 2.164> }
				triangle { <-89.3133, 77.5922, 3.6422>, <-94.1933, 79.3002, -0.8989>, <-86.181, 82.6516, 2.164> }
				triangle { <-86.181, 82.6516, 2.164>, <-94.1933, 79.3002, -0.8989>, <-90.7705, 85.3135, -2.3001> }
				triangle { <-90.7705, 85.3135, -2.3001>, <-94.1933, 79.3002, -0.8989>, <-98.5009, 85.4654, -1.4549> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-79.4432, 78.5121, 15.1244>, 0.2594 }
				cylinder { <-79.4432, 78.5121, 15.1244>, <-82.7081, 76.9717, 15.9011>, 0.2594 }
				cylinder { <-82.7081, 76.9717, 15.9011>, <-85.6647, 75.1482, 17.1535>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-85.6647, 75.1482, 17.1535>, <-88.3836, 67.6228, 16.7519>, <-92.05669, 71.7076, 14.02845> }
				triangle { <-88.3836, 67.6228, 16.7519>, <-93.8947, 64.02943, 18.7695>, <-92.05669, 71.7076, 14.02845> }
				triangle { <-92.05669, 71.7076, 14.02845>, <-93.8947, 64.02943, 18.7695>, <-98.1143, 68.9482, 15.9699> }
				triangle { <-98.1143, 68.9482, 15.9699>, <-93.8947, 64.02943, 18.7695>, <-99.8378, 66.01693, 22.9651> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-75.9662, 79.7239, 14.8463>, <-79.5529, 78.8764, 14.6177>, 0.2594 }
				cylinder { <-79.5529, 78.8764, 14.6177>, <-83.1397, 78.02882, 14.3891>, 0.2594 }
				cylinder { <-83.1397, 78.02882, 14.3891>, <-86.7265, 77.1812, 14.1606>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-86.7265, 77.1812, 14.1606>, <-91.01162, 70.9392, 11.5413>, <-92.03271, 76.1066, 8.4029> }
				triangle { <-91.01162, 70.9392, 11.5413>, <-97.6249, 69.1907, 10.7921>, <-92.03271, 76.1066, 8.4029> }
				triangle { <-92.03271, 76.1066, 8.4029>, <-97.6249, 69.1907, 10.7921>, <-98.8664, 75.3252, 7.5266> }
				triangle { <-98.8664, 75.3252, 7.5266>, <-97.6249, 69.1907, 10.7921>, <-103.951, 72.7585, 12.8233> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-65.07555, 81.6297, 15.04063>, <-68.9456, 81.8012, 15.8732>, 1.1984 }
		cylinder { <-68.9456, 81.8012, 15.8732>, <-72.6256, 82.359, 17.2321>, 1.1984 }
		cylinder { <-72.6256, 82.359, 17.2321>, <-76.00719, 83.2866, 19.07724>, 1.1984 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-76.00719, 83.2866, 19.07724>, <-77.9011, 84.00342, 20.3939>, 0.1696 }
			cylinder { <-77.9011, 84.00342, 20.3939>, <-79.599, 84.8606, 21.8827>, 0.1696 }
			cylinder { <-79.599, 84.8606, 21.8827>, <-81.07551, 85.8453, 23.5212>, 0.1696 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.4627, 87.6756, 24.2693>, 0.1696 }
				cylinder { <-82.4627, 87.6756, 24.2693>, <-83.4004, 89.876, 23.9326>, 0.1696 }
				cylinder { <-83.4004, 89.876, 23.9326>, <-83.6448, 91.8748, 22.5986>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.3211, 85.891, 25.5902>, 0.1696 }
				cylinder { <-82.3211, 85.891, 25.5902>, <-83.09685, 84.9889, 27.6923>, 0.1696 }
				cylinder { <-83.09685, 84.9889, 27.6923>, <-83.2536, 83.3122, 29.4239>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.5357, 87.4379, 24.6009>, 0.1696 }
				cylinder { <-82.5357, 87.4379, 24.6009>, <-83.8092, 89.4521, 24.9954>, 0.1696 }
				cylinder { <-83.8092, 89.4521, 24.9954>, <-84.7468, 91.6525, 24.6587>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.4429, 86.2675, 25.4671>, 0.1696 }
				cylinder { <-82.4429, 86.2675, 25.4671>, <-83.6022, 86.09678, 27.5792>, 0.1696 }
				cylinder { <-83.6022, 86.09678, 27.5792>, <-84.4695, 85.3452, 29.7046>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.5658, 87.1532, 24.9006>, 0.1696 }
				cylinder { <-82.5658, 87.1532, 24.9006>, <-84.02609, 88.7458, 25.9803>, 0.1696 }
				cylinder { <-84.02609, 88.7458, 25.9803>, <-85.4133, 90.5761, 26.7284>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-81.07551, 85.8453, 23.5212>, <-82.5519, 86.83, 25.1598>, 0.1696 }
				cylinder { <-82.5519, 86.83, 25.1598>, <-84.02839, 87.8148, 26.7983>, 0.1696 }
				cylinder { <-84.02839, 87.8148, 26.7983>, <-85.5048, 88.7995, 28.4368>, 0.1696 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-5.7587, 72.7054, 3.9034>, <-7.05442, 80.04929, 4.6443>, 2.2666 }
		cylinder { <-7.05442, 80.04929, 4.6443>, <-7.08355, 87.4835, 5.5881>, 2.2666 }
		cylinder { <-7.08355, 87.4835, 5.5881>, <-5.8452, 94.7894, 6.707>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-5.8452, 94.7894, 6.707>, <-4.6035, 98.5863, 7.379>, 0.2845 }
			cylinder { <-4.6035, 98.5863, 7.379>, <-2.8163, 102.1488, 8.1034>, 0.2845 }
			cylinder { <-2.8163, 102.1488, 8.1034>, <-0.5225, 105.3997, 8.8647>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.7693, 108.4781, 7.5683>, 0.2845 }
				cylinder { <1.7693, 108.4781, 7.5683>, <3.4637, 110.5842, 4.551>, 0.2845 }
				cylinder { <3.4637, 110.5842, 4.551>, <4.1203, 111.1707, 0.597>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <4.1203, 111.1707, 0.597>, <8.2537, 106.8298, -5.8309>, <10.9352, 112.8515, -4.4924> }
				triangle { <8.2537, 106.8298, -5.8309>, <9.8481, 107.7606, -13.1508>, <10.9352, 112.8515, -4.4924> }
				triangle { <10.9352, 112.8515, -4.4924>, <9.8481, 107.7606, -13.1508>, <12.5352, 114.8674, -11.6505> }
				triangle { <12.5352, 114.8674, -11.6505>, <9.8481, 107.7606, -13.1508>, <7.5875, 113.6569, -18.4959> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.2943, 108.1218, 11.2519>, 0.2845 }
				cylinder { <1.2943, 108.1218, 11.2519>, <2.2854, 109.7924, 14.8068>, 0.2845 }
				cylinder { <2.2854, 109.7924, 14.8068>, <2.2602, 110.0906, 18.8467>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.2602, 110.0906, 18.8467>, <8.2079, 109.3314, 25.2728>, <3.309, 104.7326, 25.5818> }
				triangle { <8.2079, 109.3314, 25.2728>, <8.4312, 109.5822, 32.8145>, <3.309, 104.7326, 25.5818> }
				triangle { <3.309, 104.7326, 25.5818>, <8.4312, 109.5822, 32.8145>, <2.4995, 104.6138, 33.1444> }
				triangle { <2.4995, 104.6138, 33.1444>, <8.4312, 109.5822, 32.8145>, <2.5615, 111.3612, 38.3669> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.8396, 108.6314, 8.2426>, 0.2845 }
				cylinder { <1.8396, 108.6314, 8.2426>, <3.9937, 111.4659, 6.31>, 0.2845 }
				cylinder { <3.9937, 111.4659, 6.31>, <5.6881, 113.572, 3.2928>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <5.6881, 113.572, 3.2928>, <11.8228, 112.0394, -2.8114>, <13.4941, 116.9041, 1.5227> }
				triangle { <11.8228, 112.0394, -2.8114>, <15.3347, 115.7822, -8.3474>, <13.4941, 116.9041, 1.5227> }
				triangle { <13.4941, 116.9041, 1.5227>, <15.3347, 115.7822, -8.3474>, <16.8732, 121.5736, -3.441> }
				triangle { <16.8732, 121.5736, -3.441>, <15.3347, 115.7822, -8.3474>, <14.1825, 123.4141, -11.3263> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.5281, 108.3977, 10.6583>, 0.2845 }
				cylinder { <1.5281, 108.3977, 10.6583>, <3.1869, 110.9255, 13.3543>, 0.2845 }
				cylinder { <3.1869, 110.9255, 13.3543>, <4.3337, 112.8001, 16.7573>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <4.3337, 112.8001, 16.7573>, <11.9256, 114.1441, 20.9767>, <7.5087, 110.479, 24.4841> }
				triangle { <11.9256, 114.1441, 20.9767>, <14.3362, 117.3409, 27.3767>, <7.5087, 110.479, 24.4841> }
				triangle { <7.5087, 110.479, 24.4841>, <14.3362, 117.3409, 27.3767>, <8.9526, 113.434, 31.343> }
				triangle { <8.9526, 113.434, 31.343>, <14.3362, 117.3409, 27.3767>, <10.2854, 121.6659, 33.15> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.8402, 108.6895, 8.9353>, 0.2845 }
				cylinder { <1.8402, 108.6895, 8.9353>, <4.2023, 111.9211, 8.3133>, 0.2845 }
				cylinder { <4.2023, 111.9211, 8.3133>, <6.4942, 114.9995, 7.01695>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.4942, 114.9995, 7.01695>, <14.2107, 115.8285, 2.892>, <14.169, 118.4653, 9.07985> }
				triangle { <14.2107, 115.8285, 2.892>, <18.8113, 121.3507, 0.5832>, <14.169, 118.4653, 9.07985> }
				triangle { <14.169, 118.4653, 9.07985>, <18.8113, 121.3507, 0.5832>, <18.4021, 124.609, 7.5971> }
				triangle { <18.4021, 124.609, 7.5971>, <18.8113, 121.3507, 0.5832>, <17.9019, 129.5733, 0.6754> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-0.5225, 105.3997, 8.8647>, <1.7713, 108.6507, 9.6259>, 0.2845 }
				cylinder { <1.7713, 108.6507, 9.6259>, <4.06527, 111.9016, 10.3872>, 0.2845 }
				cylinder { <4.06527, 111.9016, 10.3872>, <6.3591, 115.1525, 11.1485>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <6.3591, 115.1525, 11.1485>, <14.8267, 117.2828, 10.1444>, <12.8145, 117.1998, 16.5621> }
				triangle { <14.8267, 117.2828, 10.1444>, <19.4044, 123.0892, 11.6677>, <12.8145, 117.1998, 16.5621> }
				triangle { <12.8145, 117.1998, 16.5621>, <19.4044, 123.0892, 11.6677>, <16.7548, 123.2551, 18.9431> }
				triangle { <16.7548, 123.2551, 18.9431>, <19.4044, 123.0892, 11.6677>, <17.8092, 130.6042, 14.7379> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-5.8452, 94.7894, 6.707>, <-0.756, 100.0969, 8.153>, 2.2666 }
		cylinder { <-0.756, 100.0969, 8.153>, <6.4686, 101.6171, 9.4386>, 2.2666 }
		cylinder { <6.4686, 101.6171, 9.4386>, <13.3937, 98.8376, 10.1306>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <13.3937, 98.8376, 10.1306>, <16.9342, 96.8902, 10.4172>, 0.2845 }
			cylinder { <16.9342, 96.8902, 10.4172>, <20.2186, 94.527, 10.6121>, 0.2845 }
			cylinder { <20.2186, 94.527, 10.6121>, <23.1975, 91.7837, 10.7123>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <26.08549, 89.6466, 8.8408>, 0.2845 }
				cylinder { <26.08549, 89.6466, 8.8408>, <28.132, 88.671, 5.4837>, 0.2845 }
				cylinder { <28.132, 88.671, 5.4837>, <28.8054, 89.1103, 1.5134>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <28.8054, 89.1103, 1.5134>, <24.5286, 87.05223, -5.8837>, <30.4398, 83.9102, -5.2287> }
				triangle { <24.5286, 87.05223, -5.8837>, <25.6104, 87.5067, -13.3411>, <30.4398, 83.9102, -5.2287> }
				triangle { <30.4398, 83.9102, -5.2287>, <25.6104, 87.5067, -13.3411>, <32.6016, 84.2793, -12.5124> }
				triangle { <32.6016, 84.2793, -12.5124>, <25.6104, 87.5067, -13.3411>, <31.7038, 90.9583, -17.746> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <25.6337, 89.08707, 12.5021>, 0.2845 }
				cylinder { <25.6337, 89.08707, 12.5021>, <27.05936, 86.9549, 15.6376>, 0.2845 }
				cylinder { <27.05936, 86.9549, 15.6376>, <27.2006, 85.7966, 19.5168>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <27.2006, 85.7966, 19.5168>, <25.189, 78.5169, 24.01188>, <21.4852, 83.8585, 25.7416> }
				triangle { <25.189, 78.5169, 24.01188>, <25.1055, 76.1529, 31.1809>, <21.4852, 83.8585, 25.7416> }
				triangle { <21.4852, 83.8585, 25.7416>, <25.1055, 76.1529, 31.1809>, <21.2132, 82.5283, 33.2262> }
				triangle { <21.2132, 82.5283, 33.2262>, <25.1055, 76.1529, 31.1809>, <27.6434, 79.8307, 38.1436> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <26.2046, 89.3715, 9.4679>, 0.2845 }
				cylinder { <26.2046, 89.3715, 9.4679>, <28.8883, 87.5724, 7.02441>, 0.2845 }
				cylinder { <28.8883, 87.5724, 7.02441>, <30.9349, 86.5968, 3.6673>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <30.9349, 86.5968, 3.6673>, <29.1687, 82.2596, -3.77>, <33.9309, 79.3441, -0.01966> }
				triangle { <29.1687, 82.2596, -3.77>, <32.7848, 80.08512, -10.02992>, <33.9309, 79.3441, -0.01966> }
				triangle { <33.9309, 79.3441, -0.01966>, <32.7848, 80.08512, -10.02992>, <38.4753, 77.1142, -5.6974> }
				triangle { <38.4753, 77.1142, -5.6974>, <32.7848, 80.08512, -10.02992>, <40.4765, 81.6102, -12.6677> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <25.9084, 89.00458, 11.8689>, 0.2845 }
				cylinder { <25.9084, 89.00458, 11.8689>, <28.1548, 86.3909, 13.9979>, 0.2845 }
				cylinder { <28.1548, 86.3909, 13.9979>, <29.7739, 84.1322, 16.9451>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <29.7739, 84.1322, 16.9451>, <29.8271, 75.6013, 19.05891>, <26.867, 79.4994, 23.6725> }
				triangle { <29.8271, 75.6013, 19.05891>, <32.5072, 71.1632, 24.5462>, <26.867, 79.4994, 23.6725> }
				triangle { <26.867, 79.4994, 23.6725>, <32.5072, 71.1632, 24.5462>, <29.4568, 75.9046, 29.8558> }
				triangle { <29.4568, 75.9046, 29.8558>, <32.5072, 71.1632, 24.5462>, <37.3433, 72.87, 31.03815> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <26.2353, 89.1674, 10.1317>, 0.2845 }
				cylinder { <26.2353, 89.1674, 10.1317>, <29.2424, 86.7552, 8.8873>, 0.2845 }
				cylinder { <29.2424, 86.7552, 8.8873>, <32.1303, 84.618, 7.01581>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <32.1303, 84.618, 7.01581>, <32.3469, 78.04674, 1.1834>, <35.02448, 76.4462, 7.1426> }
				triangle { <32.3469, 78.04674, 1.1834>, <37.4906, 73.7347, -2.2718>, <35.02448, 76.4462, 7.1426> }
				triangle { <35.02448, 76.4462, 7.1426>, <37.4906, 73.7347, -2.2718>, <40.8216, 72.2523, 4.5608> }
				triangle { <40.8216, 72.2523, 4.5608>, <37.4906, 73.7347, -2.2718>, <45.7587, 74.00808, -2.173> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.1975, 91.7837, 10.7123>, <26.1765, 89.04038, 10.8126>, 0.2845 }
				cylinder { <26.1765, 89.04038, 10.8126>, <29.1554, 86.297, 10.9128>, 0.2845 }
				cylinder { <29.1554, 86.297, 10.9128>, <32.1343, 83.5536, 11.01312>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <32.1343, 83.5536, 11.01312>, <33.2906, 75.3735, 8.0141>, <33.4897, 75.8348, 14.7216> }
				triangle { <33.2906, 75.3735, 8.0141>, <38.5585, 69.971, 8.2416>, <33.4897, 75.8348, 14.7216> }
				triangle { <33.4897, 75.8348, 14.7216>, <38.5585, 69.971, 8.2416>, <39.0841, 70.8223, 15.9213> }
				triangle { <39.0841, 70.8223, 15.9213>, <38.5585, 69.971, 8.2416>, <46.2315, 69.9923, 11.3355> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <13.3937, 98.8376, 10.1306>, <16.3591, 96.2359, 10.2469>, 1.1937 }
		cylinder { <16.3591, 96.2359, 10.2469>, <18.2963, 92.8004, 10.1014>, 1.1937 }
		cylinder { <18.2963, 92.8004, 10.1014>, <18.9787, 88.9327, 9.7112>, 1.1937 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.9787, 88.9327, 9.7112>, <19.1048, 86.5466, 9.4259>, 0.169 }
			cylinder { <19.1048, 86.5466, 9.4259>, <18.9391, 84.1684, 9.09759>, 0.169 }
			cylinder { <18.9391, 84.1684, 9.09759>, <18.484, 81.8339, 8.731>, 0.169 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <18.2638, 79.9511, 7.2485>, 0.169 }
				cylinder { <18.2638, 79.9511, 7.2485>, <18.3358, 79.00932, 5.03523>, 0.169 }
				cylinder { <18.3358, 79.00932, 5.03523>, <18.6813, 79.253, 2.6661>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <17.92, 79.5949, 9.4091>, 0.169 }
				cylinder { <17.92, 79.5949, 9.4091>, <17.3555, 77.8811, 11.00147>, 0.169 }
				cylinder { <17.3555, 77.8811, 11.00147>, <16.8989, 77.02188, 13.2024>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <18.1756, 79.7374, 7.5906>, 0.169 }
				cylinder { <18.1756, 79.7374, 7.5906>, <18.05019, 78.1238, 5.8096>, 0.169 }
				cylinder { <18.05019, 78.1238, 5.8096>, <18.1221, 77.182, 3.5963>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <17.9502, 79.5037, 9.007477>, 0.169 }
				cylinder { <17.9502, 79.5037, 9.007477>, <17.3764, 77.3466, 9.9067>, 0.169 }
				cylinder { <17.3764, 77.3466, 9.9067>, <16.8042, 75.5188, 11.3638>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <18.09659, 79.5853, 7.9663>, 0.169 }
				cylinder { <18.09659, 79.5853, 7.9663>, <17.7882, 77.4888, 6.8259>, 0.169 }
				cylinder { <17.7882, 77.4888, 6.8259>, <17.5681, 75.606, 5.3434>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.484, 81.8339, 8.731>, <18.0289, 79.4995, 8.3645>, 0.169 }
				cylinder { <18.0289, 79.4995, 8.3645>, <17.5737, 77.165, 7.998>, 0.169 }
				cylinder { <17.5737, 77.165, 7.998>, <17.1186, 74.8306, 7.6315>, 0.169 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <13.3937, 98.8376, 10.1306>, <20.3187, 96.05826, 10.8225>, 2.2666 }
		cylinder { <20.3187, 96.05826, 10.8225>, <27.2438, 93.2788, 11.5145>, 2.2666 }
		cylinder { <27.2438, 93.2788, 11.5145>, <34.1688, 90.4993, 12.2064>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <34.1688, 90.4993, 12.2064>, <38.04547, 89.3667, 12.5208>, 0.2845 }
			cylinder { <38.04547, 89.3667, 12.5208>, <42.01802, 88.6146, 12.7724>, 0.2845 }
			cylinder { <42.01802, 88.6146, 12.7724>, <46.04823, 88.2505, 12.959>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <49.4944, 88.2729, 15.08812>, 0.2845 }
				cylinder { <49.4944, 88.2729, 15.08812>, <51.4612, 88.6758, 18.6065>, 0.2845 }
				cylinder { <51.4612, 88.6758, 18.6065>, <51.4376, 89.3547, 22.6>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <51.4376, 89.3547, 22.6>, <50.1663, 96.3133, 27.8161>, <56.3356, 93.6772, 28.3007> }
				triangle { <50.1663, 96.3133, 27.8161>, <50.296, 97.9403, 35.1867>, <56.3356, 93.6772, 28.3007> }
				triangle { <56.3356, 93.6772, 28.3007>, <50.296, 97.9403, 35.1867>, <57.2132, 94.5135, 35.8101> }
				triangle { <57.2132, 94.5135, 35.8101>, <50.296, 97.9403, 35.1867>, <51.313, 93.08152, 41.8052> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <49.7438, 87.6272, 11.4216>, 0.2845 }
				cylinder { <49.7438, 87.6272, 11.4216>, <52.3953, 86.8644, 8.4555>, 0.2845 }
				cylinder { <52.3953, 86.8644, 8.4555>, <53.4934, 86.1085, 4.6302>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <53.4934, 86.1085, 4.6302>, <57.4974, 90.5775, -1.7916>, <51.1693, 88.8368, -3.2643> }
				triangle { <57.4974, 90.5775, -1.7916>, <59.4464, 89.5537, -9.01274>, <51.1693, 88.8368, -3.2643> }
				triangle { <51.1693, 88.8368, -3.2643>, <59.4464, 89.5537, -9.01274>, <52.2612, 87.1375, -10.5979> }
				triangle { <52.2612, 87.1375, -10.5979>, <59.4464, 89.5537, -9.01274>, <58.8912, 82.9003, -13.8984> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <49.8015, 88.1395, 14.4789>, 0.2845 }
				cylinder { <49.8015, 88.1395, 14.4789>, <52.8392, 88.2945, 17.1545>, 0.2845 }
				cylinder { <52.8392, 88.2945, 17.1545>, <54.806, 88.6975, 20.6729>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <54.806, 88.6975, 20.6729>, <56.8663, 95.353, 26.03063>, <62.2264, 92.2664, 23.3877> }
				triangle { <56.8663, 95.353, 26.03063>, <60.6825, 96.4568, 32.45>, <62.2264, 92.2664, 23.3877> }
				triangle { <62.2264, 92.2664, 23.3877>, <60.6825, 96.4568, 32.45>, <66.6868, 92.5218, 29.5442> }
				triangle { <66.6868, 92.5218, 29.5442>, <60.6825, 96.4568, 32.45>, <64.2984, 91.09588, 37.6106> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <49.9651, 87.7161, 12.07461>, 0.2845 }
				cylinder { <49.9651, 87.7161, 12.07461>, <53.4849, 87.05013, 10.1832>, 0.2845 }
				cylinder { <53.4849, 87.05013, 10.1832>, <56.3527, 86.3007, 7.422>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <56.3527, 86.3007, 7.422>, <62.6497, 90.9567, 3.4327>, <57.9728, 88.5893, -0.7821> }
				triangle { <62.6497, 90.9567, 3.4327>, <67.9271, 89.9316, -1.8671>, <57.9728, 88.5893, -0.7821> }
				triangle { <57.9728, 88.5893, -0.7821>, <67.9271, 89.9316, -1.8671>, <62.6051, 86.8082, -6.5467> }
				triangle { <62.6051, 86.8082, -6.5467>, <67.9271, 89.9316, -1.8671>, <70.2804, 83.1293, -5.946> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <49.9981, 88.00946, 13.825>, 0.2845 }
				cylinder { <49.9981, 88.00946, 13.825>, <53.7514, 87.8984, 15.3449>, 0.2845 }
				cylinder { <53.7514, 87.8984, 15.3449>, <57.1977, 87.9207, 17.474>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <57.1977, 87.9207, 17.474>, <62.2004, 94.0328, 21.329>, <65.3069, 90.7691, 16.3349> }
				triangle { <62.2004, 94.0328, 21.329>, <68.7212, 94.4244, 25.1126>, <65.3069, 90.7691, 16.3349> }
				triangle { <65.3069, 90.7691, 16.3349>, <68.7212, 94.4244, 25.1126>, <72.1824, 90.2896, 19.5536> }
				triangle { <72.1824, 90.2896, 19.5536>, <68.7212, 94.4244, 25.1126>, <73.852, 88.4828, 27.7238> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <46.04823, 88.2505, 12.959>, <50.07843, 87.8864, 13.1456>, 0.2845 }
				cylinder { <50.07843, 87.8864, 13.1456>, <54.1086, 87.5223, 13.3321>, 0.2845 }
				cylinder { <54.1086, 87.5223, 13.3321>, <58.1388, 87.1582, 13.5187>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <58.1388, 87.1582, 13.5187>, <64.9303, 92.6276, 14.6172>, <64.9241, 89.5063, 8.659> }
				triangle { <64.9303, 92.6276, 14.6172>, <72.4711, 92.3032, 14.7654>, <64.9241, 89.5063, 8.659> }
				triangle { <64.9241, 89.5063, 8.659>, <72.4711, 92.3032, 14.7654>, <72.4197, 88.329, 8.1184> }
				triangle { <72.4197, 88.329, 8.1184>, <72.4711, 92.3032, 14.7654>, <77.6393, 85.8533, 14.3979> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <34.1688, 90.4993, 12.2064>, <38.08488, 90.0497, 12.4042>, 1.1937 }
		cylinder { <38.08488, 90.0497, 12.4042>, <41.9861, 90.6466, 12.4211>, 1.1937 }
		cylinder { <41.9861, 90.6466, 12.4211>, <45.59, 92.2471, 12.2558>, 1.1937 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <45.59, 92.2471, 12.2558>, <47.6809, 93.4301, 12.116>, 0.169 }
			cylinder { <47.6809, 93.4301, 12.116>, <49.6453, 94.8088, 11.9386>, 0.169 }
			cylinder { <49.6453, 94.8088, 11.9386>, <51.4641, 96.3701, 11.7253>, 0.169 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.01079, 97.93, 12.708>, 0.169 }
				cylinder { <53.01079, 97.93, 12.708>, <53.8834, 99.08322, 14.6315>, 0.169 }
				cylinder { <53.8834, 99.08322, 14.6315>, <53.8552, 99.5301, 16.9959>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.1394, 97.6067, 10.5189>, 0.169 }
				cylinder { <53.1394, 97.6067, 10.5189>, <54.3495, 98.2812, 8.5512>, 0.169 }
				cylinder { <54.3495, 98.2812, 8.5512>, <54.8621, 98.264, 6.2001>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.1521, 97.9778, 12.323>, 0.169 }
				cylinder { <53.1521, 97.9778, 12.323>, <54.5118, 99.4439, 13.6618>, 0.169 }
				cylinder { <54.5118, 99.4439, 13.6618>, <55.3845, 100.5972, 15.5853>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.2364, 97.7658, 10.8874>, 0.169 }
				cylinder { <53.2364, 97.7658, 10.8874>, <54.8339, 98.8948, 9.4858>, 0.169 }
				cylinder { <54.8339, 98.8948, 9.4858>, <56.1408, 99.6753, 7.622>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.2437, 97.9782, 11.9203>, 0.169 }
				cylinder { <53.2437, 97.9782, 11.9203>, <54.9317, 99.5859, 12.518>, 0.169 }
				cylinder { <54.9317, 99.5859, 12.518>, <56.4783, 101.1458, 13.5007>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <51.4641, 96.3701, 11.7253>, <53.2829, 97.9313, 11.5119>, 0.169 }
				cylinder { <53.2829, 97.9313, 11.5119>, <55.1017, 99.4926, 11.2986>, 0.169 }
				cylinder { <55.1017, 99.4926, 11.2986>, <56.9205, 101.0539, 11.08527>, 0.169 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <34.1688, 90.4993, 12.2064>, <39.9237, 87.4116, 13.1729>, 1.9968 }
		cylinder { <39.9237, 87.4116, 13.1729>, <45.2461, 83.731, 14.4819>, 1.9968 }
		cylinder { <45.2461, 83.731, 14.4819>, <50.05608, 79.5132, 16.1136>, 1.9968 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <50.05608, 79.5132, 16.1136>, <52.7235, 76.6892, 17.2625>, 0.2845 }
			cylinder { <52.7235, 76.6892, 17.2625>, <55.0815, 73.6565, 18.548>, 0.2845 }
			cylinder { <55.0815, 73.6565, 18.548>, <57.1072, 70.4442, 19.9578>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <58.6885, 66.7554, 19.4082>, 0.2845 }
				cylinder { <58.6885, 66.7554, 19.4082>, <59.4145, 63.5485, 17.04209>, 0.2845 }
				cylinder { <59.4145, 63.5485, 17.04209>, <59.09661, 61.6567, 13.4741>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <59.09661, 61.6567, 13.4741>, <52.7009, 57.5757, 9.03721>, <57.8078, 53.536, 10.7239> }
				triangle { <52.7009, 57.5757, 9.03721>, <51.8555, 53.7836, 2.5645>, <57.8078, 53.536, 10.7239> }
				triangle { <57.8078, 53.536, 10.7239>, <51.8555, 53.7836, 2.5645>, <58.00911, 49.4243, 4.3275> }
				triangle { <58.00911, 49.4243, 4.3275>, <51.8555, 53.7836, 2.5645>, <57.149, 52.3696, -3.6342> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <59.0958, 68.3157, 22.7729>, 0.2845 }
				cylinder { <59.0958, 68.3157, 22.7729>, <60.6652, 67.6797, 26.4529>, 0.2845 }
				cylinder { <60.6652, 67.6797, 26.4529>, <61.5142, 68.6583, 30.2911>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <61.5142, 68.6583, 30.2911>, <58.5418, 66.2944, 38.2172>, <57.5235, 72.7875, 36.7869> }
				triangle { <58.5418, 66.2944, 38.2172>, <59.7264, 68.0871, 45.4541>, <57.5235, 72.7875, 36.7869> }
				triangle { <57.5235, 72.7875, 36.7869>, <59.7264, 68.0871, 45.4541>, <58.979, 75.5945, 43.7053> }
				triangle { <58.979, 75.5945, 43.7053>, <59.7264, 68.0871, 45.4541>, <65.2428, 73.1577, 48.9618> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <58.8907, 66.8088, 20.07117>, 0.2845 }
				cylinder { <58.8907, 66.8088, 20.07117>, <60.2233, 63.1752, 18.8748>, 0.2845 }
				cylinder { <60.2233, 63.1752, 18.8748>, <60.9493, 59.9683, 16.5086>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <60.9493, 59.9683, 16.5086>, <56.2254, 53.2855, 13.3038>, <61.1637, 51.3511, 17.4408> }
				triangle { <56.2254, 53.2855, 13.3038>, <57.3187, 47.09486, 9.1241>, <61.1637, 51.3511, 17.4408> }
				triangle { <61.1637, 51.3511, 17.4408>, <57.3187, 47.09486, 9.1241>, <63.2825, 45.1073, 13.6476> }
				triangle { <63.2825, 45.1073, 13.6476>, <57.3187, 47.09486, 9.1241>, <64.04333, 44.317, 5.1858> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <59.1577, 67.832, 22.2776>, 0.2845 }
				cylinder { <59.1577, 67.832, 22.2776>, <61.0844, 66.00909, 25.3395>, 0.2845 }
				cylinder { <61.0844, 66.00909, 25.3395>, <62.7476, 65.1075, 28.9215>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <62.7476, 65.1075, 28.9215>, <60.7731, 59.8038, 35.6459>, <60.7921, 66.3287, 37.2794> }
				triangle { <60.7731, 59.8038, 35.6459>, <63.4967, 58.09845, 42.477>, <60.7921, 66.3287, 37.2794> }
				triangle { <60.7921, 66.3287, 37.2794>, <63.4967, 58.09845, 42.477>, <63.9181, 65.6417, 44.18> }
				triangle { <63.9181, 65.6417, 44.18>, <63.4967, 58.09845, 42.477>, <70.4004, 60.5287, 46.3345> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <59.04034, 66.9692, 20.7307>, 0.2845 }
				cylinder { <59.04034, 66.9692, 20.7307>, <60.8238, 63.3338, 20.8441>, 0.2845 }
				cylinder { <60.8238, 63.3338, 20.8441>, <62.4051, 59.645, 20.2945>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <62.4051, 59.645, 20.2945>, <59.2642, 51.4653, 19.6066>, <63.2498, 52.3781, 24.9475> }
				triangle { <59.2642, 51.4653, 19.6066>, <61.9271, 44.4436, 18.8351>, <63.2498, 52.3781, 24.9475> }
				triangle { <63.2498, 52.3781, 24.9475>, <61.9271, 44.4436, 18.8351>, <66.8175, 45.664, 24.715> }
				triangle { <66.8175, 45.664, 24.715>, <61.9271, 44.4436, 18.8351>, <69.6352, 41.6474, 17.7341> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <57.1072, 70.4442, 19.9578>, <59.133, 67.232, 21.3676>, 0.2845 }
				cylinder { <59.133, 67.232, 21.3676>, <61.1588, 64.01972, 22.7773>, 0.2845 }
				cylinder { <61.1588, 64.01972, 22.7773>, <63.1845, 60.8074, 24.1871>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <63.1845, 60.8074, 24.1871>, <61.1266, 52.6245, 26.6471>, <63.6229, 56.3869, 31.6327> }
				triangle { <61.1266, 52.6245, 26.6471>, <64.5822, 46.5555, 29.5134>, <63.6229, 56.3869, 31.6327> }
				triangle { <63.6229, 56.3869, 31.6327>, <64.5822, 46.5555, 29.5134>, <67.7946, 50.9863, 34.9932> }
				triangle { <67.7946, 50.9863, 34.9932>, <64.5822, 46.5555, 29.5134>, <72.5708, 45.09119, 31.08938> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <50.05608, 79.5132, 16.1136>, <50.5777, 78.4659, 16.5874>, 0.3818 }
		cylinder { <50.5777, 78.4659, 16.5874>, <50.622, 77.3371, 17.1509>, 0.3818 }
		cylinder { <50.622, 77.3371, 17.1509>, <50.1821, 76.2988, 17.7183>, 0.3818 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <50.1821, 76.2988, 17.7183>, <49.8047, 75.7017, 18.05738>, 0.05504 }
			cylinder { <49.8047, 75.7017, 18.05738>, <49.3312, 75.1647, 18.3759>, 0.05504 }
			cylinder { <49.3312, 75.1647, 18.3759>, <48.7718, 74.6996, 18.667>, 0.05504 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2501, 74.1221, 18.5767>, 0.05504 }
				cylinder { <48.2501, 74.1221, 18.5767>, <47.9015, 73.5821, 18.1286>, 0.05504 }
				cylinder { <47.9015, 73.5821, 18.1286>, <47.8166, 73.22, 17.4389>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2966, 74.4292, 19.2282>, 0.05504 }
				cylinder { <48.2966, 74.4292, 19.2282>, <47.9967, 74.4053, 19.9517>, 0.05504 }
				cylinder { <47.9967, 74.4053, 19.9517>, <47.9298, 74.6326, 20.6986>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2212, 74.1436, 18.7063>, 0.05504 }
				cylinder { <48.2212, 74.1436, 18.7063>, <47.7437, 73.5615, 18.4892>, 0.05504 }
				cylinder { <47.7437, 73.5615, 18.4892>, <47.3951, 73.02162, 18.04101>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2517, 74.345, 19.1335>, 0.05504 }
				cylinder { <48.2517, 74.345, 19.1335>, <47.8085, 74.1264, 19.7416>, 0.05504 }
				cylinder { <47.8085, 74.1264, 19.7416>, <47.4743, 74.05979, 20.4471>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2085, 74.1814, 18.8347>, 0.05504 }
				cylinder { <48.2085, 74.1814, 18.8347>, <47.6579, 73.6254, 18.874>, 0.05504 }
				cylinder { <47.6579, 73.6254, 18.874>, <47.1361, 73.04787, 18.7837>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <48.7718, 74.6996, 18.667>, <48.2125, 74.2346, 18.9581>, 0.05504 }
				cylinder { <48.2125, 74.2346, 18.9581>, <47.6531, 73.7695, 19.2493>, 0.05504 }
				cylinder { <47.6531, 73.7695, 19.2493>, <47.09377, 73.3044, 19.5404>, 0.05504 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <50.05608, 79.5132, 16.1136>, <53.9108, 77.1254, 16.5697>, 1.3784 }
		cylinder { <53.9108, 77.1254, 16.5697>, <58.1129, 75.3774, 16.3334>, 1.3784 }
		cylinder { <58.1129, 75.3774, 16.3334>, <62.458, 74.3541, 15.4163>, 1.3784 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <62.458, 74.3541, 15.4163>, <65.00698, 74.00307, 14.6644>, 0.1883 }
			cylinder { <65.00698, 74.00307, 14.6644>, <67.5106, 73.9081, 13.7115>, 0.1883 }
			cylinder { <67.5106, 73.9081, 13.7115>, <69.9315, 74.07075, 12.5718>, 0.1883 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <72.4331, 75.03318, 12.5371>, 0.1883 }
				cylinder { <72.4331, 75.03318, 12.5371>, <74.3655, 76.5453, 13.6162>, 0.1883 }
				cylinder { <74.3655, 76.5453, 13.6162>, <75.2267, 78.2143, 15.5289>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <71.7769, 73.5056, 10.7116>, 0.1883 }
				cylinder { <71.7769, 73.5056, 10.7116>, <72.6927, 72.3213, 8.488>, 0.1883 }
				cylinder { <72.6927, 72.3213, 8.488>, <72.503, 70.7452, 6.328>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <72.4809, 74.7849, 12.1528>, 0.1883 }
				cylinder { <72.4809, 74.7849, 12.1528>, <74.861, 75.9672, 12.5033>, 0.1883 }
				cylinder { <74.861, 75.9672, 12.5033>, <76.7935, 77.4794, 13.5825>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <72.05071, 73.7832, 10.9557>, 0.1883 }
				cylinder { <72.05071, 73.7832, 10.9557>, <73.7148, 73.06648, 8.9802>, 0.1883 }
				cylinder { <73.7148, 73.06648, 8.9802>, <74.8032, 71.9723, 6.7884>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <72.4537, 74.5157, 11.7808>, 0.1883 }
				cylinder { <72.4537, 74.5157, 11.7808>, <75.00327, 75.2299, 11.3618>, 0.1883 }
				cylinder { <75.00327, 75.2299, 11.3618>, <77.5048, 76.1923, 11.327>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.9315, 74.07075, 12.5718>, <72.3523, 74.2333, 11.4322>, 0.1883 }
				cylinder { <72.3523, 74.2333, 11.4322>, <74.7731, 74.3959, 10.2925>, 0.1883 }
				cylinder { <74.7731, 74.3959, 10.2925>, <77.1939, 74.5586, 9.1528>, 0.1883 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <62.458, 74.3541, 15.4163>, <64.1545, 73.8005, 15.3227>, 0.5404 }
		cylinder { <64.1545, 73.8005, 15.3227>, <65.7937, 73.1109, 15.4978>, 0.5404 }
		cylinder { <65.7937, 73.1109, 15.4978>, <67.3273, 72.3057, 15.9367>, 0.5404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <67.3273, 72.3057, 15.9367>, <68.2095, 71.7829, 16.2913>, 0.07621 }
			cylinder { <68.2095, 71.7829, 16.2913>, <69.03407, 71.2314, 16.7308>, 0.07621 }
			cylinder { <69.03407, 71.2314, 16.7308>, <69.7931, 70.6565, 17.2509>, 0.07621 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.2953, 69.7148, 17.4463>, 0.07621 }
				cylinder { <70.2953, 69.7148, 17.4463>, <70.4101, 68.651, 17.2663>, 0.07621 }
				cylinder { <70.4101, 68.651, 17.2663>, <70.1078, 67.7415, 16.7577>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.6165, 70.5196, 17.9441>, 0.07621 }
				cylinder { <70.6165, 70.5196, 17.9441>, <71.3461, 70.8472, 18.6772>, 0.07621 }
				cylinder { <71.3461, 70.8472, 18.6772>, <71.842, 71.5762, 19.3095>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.3996, 69.8134, 17.5649>, 0.07621 }
				cylinder { <70.3996, 69.8134, 17.5649>, <70.7827, 68.8008, 17.636>, 0.07621 }
				cylinder { <70.7827, 68.8008, 17.636>, <70.8976, 67.737, 17.456>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.6102, 70.3412, 17.8913>, 0.07621 }
				cylinder { <70.6102, 70.3412, 17.8913>, <71.4263, 70.3085, 18.6055>, 0.07621 }
				cylinder { <71.4263, 70.3085, 18.6055>, <72.1822, 70.5607, 19.3419>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.486, 69.9369, 17.6742>, 0.07621 }
				cylinder { <70.486, 69.9369, 17.6742>, <71.09261, 69.09383, 17.9881>, 0.07621 }
				cylinder { <71.09261, 69.09383, 17.9881>, <71.5948, 68.1521, 18.1836>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <69.7931, 70.6565, 17.2509>, <70.5521, 70.08154, 17.771>, 0.07621 }
				cylinder { <70.5521, 70.08154, 17.771>, <71.3111, 69.5065, 18.2911>, 0.07621 }
				cylinder { <71.3111, 69.5065, 18.2911>, <72.07021, 68.9316, 18.8112>, 0.07621 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-5.8452, 94.7894, 6.707>, <-5.7517, 102.2621, 7.2646>, 2.2666 }
		cylinder { <-5.7517, 102.2621, 7.2646>, <-6.8058, 109.6815, 7.2444>, 2.2666 }
		cylinder { <-6.8058, 109.6815, 7.2444>, <-8.9764, 116.8294, 6.6469>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.9764, 116.8294, 6.6469>, <-10.6402, 120.4765, 6.06381>, 0.2845 }
			cylinder { <-10.6402, 120.4765, 6.06381>, <-12.7585, 123.828, 5.233>, 0.2845 }
			cylinder { <-12.7585, 123.828, 5.233>, <-15.2854, 126.8114, 4.1727>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-18.3758, 129.2854, 5.03246>, 0.2845 }
				cylinder { <-18.3758, 129.2854, 5.03246>, <-21.2267, 130.6071, 7.5889>, 0.2845 }
				cylinder { <-21.2267, 130.6071, 7.5889>, <-23.0974, 130.4332, 11.1778>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-23.0974, 130.4332, 11.1778>, <-27.9298, 124.4995, 15.5003>, <-31.2807, 130.1425, 14.0271> }
				triangle { <-27.9298, 124.4995, 15.5003>, <-31.7158, 123.9653, 22.00959>, <-31.2807, 130.1425, 14.0271> }
				triangle { <-31.2807, 130.1425, 14.0271>, <-31.7158, 123.9653, 22.00959>, <-35.2464, 130.6899, 20.4951> }
				triangle { <-35.2464, 130.6899, 20.4951>, <-31.7158, 123.9653, 22.00959>, <-32.3373, 129.2089, 28.3786> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-16.7962, 129.614, 1.6681>, 0.2845 }
				cylinder { <-16.7962, 129.614, 1.6681>, <-17.00076, 131.6977, -1.7997>, 0.2845 }
				cylinder { <-17.00076, 131.6977, -1.7997>, <-15.8597, 132.6623, -5.5651>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-15.8597, 132.6623, -5.5651>, <-19.5018, 132.3022, -13.5558>, <-14.05472, 128.4105, -12.9022> }
				triangle { <-19.5018, 132.3022, -13.5558>, <-17.5782, 133.7724, -20.7062>, <-14.05472, 128.4105, -12.9022> }
				triangle { <-14.05472, 128.4105, -12.9022>, <-17.5782, 133.7724, -20.7062>, <-11.09107, 129.6405, -19.799> }
				triangle { <-11.09107, 129.6405, -19.799>, <-17.5782, 133.7724, -20.7062>, <-10.7186, 137.108, -23.9103> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-18.2741, 129.5371, 4.3925>, 0.2845 }
				cylinder { <-18.2741, 129.5371, 4.3925>, <-21.3752, 131.6865, 5.8668>, 0.2845 }
				cylinder { <-21.3752, 131.6865, 5.8668>, <-24.2261, 133.0082, 8.4233>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-24.2261, 133.0082, 8.4233>, <-31.3986, 129.6036, 12.1928>, <-32.7117, 134.7513, 8.06711> }
				triangle { <-31.3986, 129.6036, 12.1928>, <-36.9843, 131.8467, 16.749>, <-32.7117, 134.7513, 8.06711> }
				triangle { <-32.7117, 134.7513, 8.06711>, <-36.9843, 131.8467, 16.749>, <-38.1944, 138.0072, 12.2144> }
				triangle { <-38.1944, 138.0072, 12.2144>, <-36.9843, 131.8467, 16.749>, <-38.2357, 139.014, 20.6872> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-17.2383, 129.7526, 2.1863>, 0.2845 }
				cylinder { <-17.2383, 129.7526, 2.1863>, <-18.4755, 132.4386, -0.5821>, 0.2845 }
				cylinder { <-18.4755, 132.4386, -0.5821>, <-18.9076, 134.6747, -3.9322>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-18.9076, 134.6747, -3.9322>, <-25.1242, 135.7466, -10.05203>, <-19.3711, 133.2364, -12.4696> }
				triangle { <-25.1242, 135.7466, -10.05203>, <-26.1242, 139.5995, -16.4665>, <-19.3711, 133.2364, -12.4696> }
				triangle { <-19.3711, 133.2364, -12.4696>, <-26.1242, 139.5995, -16.4665>, <-19.2887, 137.0406, -19.05621> }
				triangle { <-19.2887, 137.0406, -19.05621>, <-26.1242, 139.5995, -16.4665>, <-21.3671, 145.2344, -20.2168> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-18.08448, 129.7086, 3.7461>, 0.2845 }
				cylinder { <-18.08448, 129.7086, 3.7461>, <-21.07317, 132.4343, 3.966>, 0.2845 }
				cylinder { <-21.07317, 132.4343, 3.966>, <-24.1635, 134.9082, 4.8257>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-24.1635, 134.9082, 4.8257>, <-32.7311, 133.9527, 6.5373>, <-31.4797, 137.462, 0.9371> }
				triangle { <-32.7311, 133.9527, 6.5373>, <-38.7317, 138.3202, 7.9185>, <-31.4797, 137.462, 0.9371> }
				triangle { <-31.4797, 137.462, 0.9371>, <-38.7317, 138.3202, 7.9185>, <-37.02198, 142.6153, 1.705> }
				triangle { <-37.02198, 142.6153, 1.705>, <-38.7317, 138.3202, 7.9185>, <-39.3759, 146.5068, 8.9244> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.2854, 126.8114, 4.1727>, <-17.8123, 129.7948, 3.1123>, 0.2845 }
				cylinder { <-17.8123, 129.7948, 3.1123>, <-20.3392, 132.7781, 2.05202>, 0.2845 }
				cylinder { <-20.3392, 132.7781, 2.05202>, <-22.8661, 135.7615, 0.9916>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-22.8661, 135.7615, 0.9916>, <-31.5211, 136.5386, -0.3248>, <-27.8452, 137.6924, -5.8384> }
				triangle { <-31.5211, 136.5386, -0.3248>, <-36.4442, 141.8258, -2.5156>, <-27.8452, 137.6924, -5.8384> }
				triangle { <-27.8452, 137.6924, -5.8384>, <-36.4442, 141.8258, -2.5156>, <-31.9738, 143.4388, -8.6305> }
				triangle { <-31.9738, 143.4388, -8.6305>, <-36.4442, 141.8258, -2.5156>, <-35.402, 149.8622, -4.1817> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-8.9764, 116.8294, 6.6469>, <-12.772, 122.0056, 5.1017>, 1.9968 }
		cylinder { <-12.772, 122.0056, 5.1017>, <-17.9422, 125.3673, 2.7447>, 1.9968 }
		cylinder { <-17.9422, 125.3673, 2.7447>, <-23.7942, 126.4639, -0.1082>, 1.9968 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-23.7942, 126.4639, -0.1082>, <-27.416, 126.7427, -1.9012>, 0.2845 }
			cylinder { <-27.416, 126.7427, -1.9012>, <-31.0341, 126.6247, -3.7194>, 0.2845 }
			cylinder { <-31.0341, 126.6247, -3.7194>, <-34.6135, 126.1112, -5.5454>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-38.6196, 125.5426, -5.3518>, 0.2845 }
				cylinder { <-38.6196, 125.5426, -5.3518>, <-42.01162, 125.0666, -3.189>, 0.2845 }
				cylinder { <-42.01162, 125.0666, -3.189>, <-43.9081, 124.8069, 0.3811>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-43.9081, 124.8069, 0.3811>, <-44.5879, 118.7868, 6.7483>, <-50.4377, 120.1995, 3.7437> }
				triangle { <-44.5879, 118.7868, 6.7483>, <-48.1915, 117.9088, 13.3236>, <-50.4377, 120.1995, 3.7437> }
				triangle { <-50.4377, 120.1995, 3.7437>, <-48.1915, 117.9088, 13.3236>, <-54.8474, 119.9602, 9.9371> }
				triangle { <-54.8474, 119.9602, 9.9371>, <-48.1915, 117.9088, 13.3236>, <-52.963, 123.1095, 17.64> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-37.07571, 125.7527, -8.7421>, 0.2845 }
				cylinder { <-37.07571, 125.7527, -8.7421>, <-37.9479, 125.618, -12.6957>, 0.2845 }
				cylinder { <-37.9479, 125.618, -12.6957>, <-37.06269, 125.733, -16.6471>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-37.06269, 125.733, -16.6471>, <-36.4598, 119.86, -23.1579>, <-30.6454, 122.9418, -21.7655> }
				triangle { <-36.4598, 119.86, -23.1579>, <-34.6174, 119.7178, -30.4774>, <-30.6454, 122.9418, -21.7655> }
				triangle { <-30.6454, 122.9418, -21.7655>, <-34.6174, 119.7178, -30.4774>, <-28.1319, 123.6497, -28.91> }
				triangle { <-28.1319, 123.6497, -28.91>, <-34.6174, 119.7178, -30.4774>, <-32.7667, 125.8332, -35.7331> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-38.5931, 125.5445, -6.04646>, 0.2845 }
				cylinder { <-38.5931, 125.5445, -6.04646>, <-42.5078, 124.9907, -5.1639>, 0.2845 }
				cylinder { <-42.5078, 124.9907, -5.1639>, <-45.8998, 124.5147, -3.00113>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-45.8998, 124.5147, -3.00113>, <-49.483, 118.0778, 1.7918>, <-53.1491, 119.7943, -3.5799> }
				triangle { <-49.483, 118.0778, 1.7918>, <-55.819, 116.8044, 5.6936>, <-53.1491, 119.7943, -3.5799> }
				triangle { <-53.1491, 119.7943, -3.5799>, <-55.819, 116.8044, 5.6936>, <-60.01481, 119.198, -0.3598> }
				triangle { <-60.01481, 119.198, -0.3598>, <-55.819, 116.8044, 5.6936>, <-62.1901, 121.7709, 7.4793> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-37.5807, 125.6823, -8.2697>, 0.2845 }
				cylinder { <-37.5807, 125.6823, -8.2697>, <-39.7207, 125.3689, -11.6949>, 0.2845 }
				cylinder { <-39.7207, 125.3689, -11.6949>, <-40.8786, 125.1938, -15.5728>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-40.8786, 125.1938, -15.5728>, <-43.4316, 118.8751, -21.1228>, <-37.7297, 121.9321, -22.9632> }
				triangle { <-43.4316, 118.8751, -21.1228>, <-45.3937, 118.1925, -28.3805>, <-37.7297, 121.9321, -22.9632> }
				triangle { <-37.7297, 121.9321, -22.9632>, <-45.3937, 118.1925, -28.3805>, <-39.03503, 122.0965, -30.4552> }
				triangle { <-39.03503, 122.0965, -30.4552>, <-45.3937, 118.1925, -28.3805>, <-46.4462, 123.8937, -34.2826> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-38.4495, 125.563, -6.7263>, 0.2845 }
				cylinder { <-38.4495, 125.563, -6.7263>, <-42.4291, 124.9963, -7.2273>, 0.2845 }
				cylinder { <-42.4291, 124.9963, -7.2273>, <-46.4353, 124.4277, -7.03376>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-46.4353, 124.4277, -7.03376>, <-51.7759, 117.7334, -5.05622>, <-52.3874, 119.8812, -11.401> }
				triangle { <-51.7759, 117.7334, -5.05622>, <-59.1842, 116.2975, -4.8414>, <-52.3874, 119.8812, -11.401> }
				triangle { <-52.3874, 119.8812, -11.401>, <-59.1842, 116.2975, -4.8414>, <-59.9384, 119.1771, -11.9911> }
				triangle { <-59.9384, 119.1771, -11.9911>, <-59.1842, 116.2975, -4.8414>, <-65.7118, 121.2337, -6.05448> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-34.6135, 126.1112, -5.5454>, <-38.1929, 125.5977, -7.3714>, 0.2845 }
				cylinder { <-38.1929, 125.5977, -7.3714>, <-41.7723, 125.0842, -9.1973>, 0.2845 }
				cylinder { <-41.7723, 125.0842, -9.1973>, <-45.3517, 124.5707, -11.02335>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-45.3517, 124.5707, -11.02335>, <-50.8471, 117.8454, -12.3709>, <-48.3265, 120.44, -18.04177> }
				triangle { <-50.8471, 117.8454, -12.3709>, <-57.3889, 116.5224, -15.8987>, <-48.3265, 120.44, -18.04177> }
				triangle { <-48.3265, 120.44, -18.04177>, <-57.3889, 116.5224, -15.8987>, <-54.6144, 119.9054, -22.289> }
				triangle { <-54.6144, 119.9054, -22.289>, <-57.3889, 116.5224, -15.8987>, <-62.5892, 121.6398, -19.7994> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-23.7942, 126.4639, -0.1082>, <-25.00399, 126.1871, -0.7323>, 0.4201 }
		cylinder { <-25.00399, 126.1871, -0.7323>, <-26.03001, 125.4399, -1.2967>, 0.4201 }
		cylinder { <-26.03001, 125.4399, -1.2967>, <-26.7348, 124.3224, -1.7258>, 0.4201 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-26.7348, 124.3224, -1.7258>, <-27.1032, 123.5916, -1.9601>, 0.0598 }
			cylinder { <-27.1032, 123.5916, -1.9601>, <-27.4045, 122.8217, -2.1634>, 0.0598 }
			cylinder { <-27.4045, 122.8217, -2.1634>, <-27.6358, 122.0203, -2.3339>, 0.0598 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-28.02444, 121.2974, -2.1077>, 0.0598 }
				cylinder { <-28.02444, 121.2974, -2.1077>, <-28.4694, 120.8408, -1.5435>, 0.0598 }
				cylinder { <-28.4694, 120.8408, -1.5435>, <-28.8552, 120.7692, -0.7879>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-27.6823, 121.318, -2.813>, 0.0598 }
				cylinder { <-27.6823, 121.318, -2.813>, <-27.535, 120.8497, -3.5086>, 0.0598 }
				cylinder { <-27.535, 120.8497, -3.5086>, <-27.2224, 120.7054, -4.2872>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-27.9816, 121.2482, -2.2384>, 0.0598 }
				cylinder { <-27.9816, 121.2482, -2.2384>, <-28.4016, 120.5957, -1.8881>, 0.0598 }
				cylinder { <-28.4016, 120.5957, -1.8881>, <-28.8466, 120.1392, -1.3239>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-27.7572, 121.2617, -2.7009>, 0.0598 }
				cylinder { <-27.7572, 121.2617, -2.7009>, <-27.7601, 120.6011, -3.2378>, 0.0598 }
				cylinder { <-27.7601, 120.6011, -3.2378>, <-27.6442, 120.0861, -3.9058>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-27.9286, 121.2218, -2.372>, 0.0598 }
				cylinder { <-27.9286, 121.2218, -2.372>, <-28.2745, 120.4497, -2.2765>, 0.0598 }
				cylinder { <-28.2745, 120.4497, -2.2765>, <-28.6631, 119.7268, -2.05026>, 0.0598 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-27.6358, 122.0203, -2.3339>, <-27.867, 121.2188, -2.5044>, 0.0598 }
				cylinder { <-27.867, 121.2188, -2.5044>, <-28.09834, 120.4174, -2.6749>, 0.0598 }
				cylinder { <-28.09834, 120.4174, -2.6749>, <-28.3296, 119.616, -2.8454>, 0.0598 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-23.7942, 126.4639, -0.1082>, <-27.7778, 128.0201, -1.6824>, 1.3784 }
		cylinder { <-27.7778, 128.0201, -1.6824>, <-31.5522, 130.3159, -2.8011>, 1.3784 }
		cylinder { <-31.5522, 130.3159, -2.8011>, <-34.9726, 133.263, -3.4212>, 1.3784 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-34.9726, 133.263, -3.4212>, <-36.777, 135.2407, -3.5562>, 0.1883 }
			cylinder { <-36.777, 135.2407, -3.5562>, <-38.3348, 137.42, -3.4585>, 0.1883 }
			cylinder { <-38.3348, 137.42, -3.4585>, <-39.6123, 139.7536, -3.1302>, 0.1883 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-40.113, 142.2686, -3.9113>, 0.1883 }
				cylinder { <-40.113, 142.2686, -3.9113>, <-39.7068, 144.3113, -5.5988>, 0.1883 }
				cylinder { <-39.7068, 144.3113, -5.5988>, <-38.4993, 145.3512, -7.7543>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-41.297, 141.443, -1.9081>, 0.1883 }
				cylinder { <-41.297, 141.443, -1.9081>, <-43.06546, 142.1636, -0.02694>, 0.1883 }
				cylinder { <-43.06546, 142.1636, -0.02694>, <-44.5779, 141.7772, 2.1521>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-40.3976, 142.282, -3.5502>, 0.1883 }
				cylinder { <-40.3976, 142.282, -3.5502>, <-40.599, 144.7094, -4.6694>, 0.1883 }
				cylinder { <-40.599, 144.7094, -4.6694>, <-40.1928, 146.7522, -6.3569>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-41.1741, 141.7406, -2.2366>, 0.1883 }
				cylinder { <-41.1741, 141.7406, -2.2366>, <-42.9069, 143.2369, -0.8424>, 0.1883 }
				cylinder { <-42.9069, 143.2369, -0.8424>, <-44.6854, 144.1342, 0.9513>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-40.6591, 142.2209, -3.1767>, 0.1883 }
				cylinder { <-40.6591, 142.2209, -3.1767>, <-41.4445, 144.7493, -3.5967>, 0.1883 }
				cylinder { <-41.4445, 144.7493, -3.5967>, <-41.9452, 147.2642, -4.3778>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-39.6123, 139.7536, -3.1302>, <-40.8898, 142.0873, -2.8019>, 0.1883 }
				cylinder { <-40.8898, 142.0873, -2.8019>, <-42.1673, 144.4209, -2.4736>, 0.1883 }
				cylinder { <-42.1673, 144.4209, -2.4736>, <-43.4448, 146.7545, -2.1453>, 0.1883 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-34.9726, 133.263, -3.4212>, <-36.3605, 134.3219, -3.8031>, 0.5404 }
		cylinder { <-36.3605, 134.3219, -3.8031>, <-37.7816, 135.2739, -4.3199>, 0.5404 }
		cylinder { <-37.7816, 135.2739, -4.3199>, <-39.2224, 136.11, -4.9668>, 0.5404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-39.2224, 136.11, -4.9668>, <-40.1007, 136.5423, -5.4347>, 0.07621 }
			cylinder { <-40.1007, 136.5423, -5.4347>, <-40.974, 136.895, -5.9733>, 0.07621 }
			cylinder { <-40.974, 136.895, -5.9733>, <-41.8339, 137.1649, -6.5773>, 0.07621 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.8961, 137.1013, -6.7892>, 0.07621 }
				cylinder { <-42.8961, 137.1013, -6.7892>, <-43.8846, 136.7208, -6.5539>, 0.07621 }
				cylinder { <-43.8846, 136.7208, -6.5539>, <-44.5425, 136.1223, -5.9326>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.3389, 137.6677, -7.3954>, 0.07621 }
				cylinder { <-42.3389, 137.6677, -7.3954>, <-42.3921, 138.3069, -8.2705>, 0.07621 }
				cylinder { <-42.3921, 138.3069, -8.2705>, <-41.9831, 138.9597, -9.03464>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.8582, 137.2151, -6.9317>, 0.07621 }
				cylinder { <-42.8582, 137.2151, -6.9317>, <-43.927, 137.0396, -6.9949>, 0.07621 }
				cylinder { <-43.927, 137.0396, -6.9949>, <-44.9155, 136.6591, -6.7596>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.4928, 137.5865, -7.3292>, 0.07621 }
				cylinder { <-42.4928, 137.5865, -7.3292>, <-42.9029, 138.1292, -8.1744>, 0.07621 }
				cylinder { <-42.9029, 138.1292, -8.1744>, <-43.03458, 138.7538, -9.05188>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.7901, 137.3273, -7.06371>, 0.07621 }
				cylinder { <-42.7901, 137.3273, -7.06371>, <-43.8143, 137.3775, -7.418>, 0.07621 }
				cylinder { <-43.8143, 137.3775, -7.418>, <-44.8765, 137.3139, -7.6299>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-41.8339, 137.1649, -6.5773>, <-42.6938, 137.4348, -7.1814>, 0.07621 }
				cylinder { <-42.6938, 137.4348, -7.1814>, <-43.5538, 137.7047, -7.7854>, 0.07621 }
				cylinder { <-43.5538, 137.7047, -7.7854>, <-44.4137, 137.9746, -8.3894>, 0.07621 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-8.9764, 116.8294, 6.6469>, <-10.135, 124.2203, 7.08627>, 2.2666 }
		cylinder { <-10.135, 124.2203, 7.08627>, <-10.2369, 131.5702, 8.5454>, 2.2666 }
		cylinder { <-10.2369, 131.5702, 8.5454>, <-9.2783, 138.5966, 10.9684>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2783, 138.5966, 10.9684>, <-8.4796, 142.252, 12.5209>, 0.2845 }
			cylinder { <-8.4796, 142.252, 12.5209>, <-7.4081, 145.7293, 14.3013>, 0.2845 }
			cylinder { <-7.4081, 145.7293, 14.3013>, <-6.07413, 148.9952, 16.2924>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-3.5364, 152.1367, 16.6103>, 0.2845 }
				cylinder { <-3.5364, 152.1367, 16.6103>, <-0.4544, 154.3376, 15.1724>, 0.2845 }
				cylinder { <-0.4544, 154.3376, 15.1724>, <2.3709, 155.0261, 12.3524>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.3709, 155.0261, 12.3524>, <9.9784, 151.3093, 9.9947>, <10.6396, 157.6293, 12.2> }
				triangle { <9.9784, 151.3093, 9.9947>, <15.5265, 152.481, 5.01117>, <10.6396, 157.6293, 12.2> }
				triangle { <10.6396, 157.6293, 12.2>, <15.5265, 152.481, 5.01117>, <15.9756, 159.8763, 7.2665> }
				triangle { <15.9756, 159.8763, 7.2665>, <15.5265, 152.481, 5.01117>, <16.2875, 158.0474, -1.06191> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-6.06259, 151.6873, 19.3193>, 0.2845 }
				cylinder { <-6.06259, 151.6873, 19.3193>, <-7.3757, 153.2888, 22.8008>, 0.2845 }
				cylinder { <-7.3757, 153.2888, 22.8008>, <-9.7614, 153.4921, 26.06836>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-9.7614, 153.4921, 26.06836>, <-8.8356, 151.9455, 34.6704>, <-13.289, 147.8941, 31.671> }
				triangle { <-8.8356, 151.9455, 34.6704>, <-13.09452, 151.9919, 40.9034>, <-13.289, 147.8941, 31.671> }
				triangle { <-13.289, 147.8941, 31.671>, <-13.09452, 151.9919, 40.9034>, <-18.4169, 147.6837, 37.2854> }
				triangle { <-18.4169, 147.6837, 37.2854>, <-13.09452, 151.9919, 40.9034>, <-20.9618, 154.2595, 42.0904> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-3.8769, 152.2751, 17.2002>, 0.2845 }
				cylinder { <-3.8769, 152.2751, 17.2002>, <-1.0735, 155.1857, 16.9188>, 0.2845 }
				cylinder { <-1.0735, 155.1857, 16.9188>, <2.008466, 157.3866, 15.4809>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <2.008466, 157.3866, 15.4809>, <10.7097, 156.3674, 14.778>, <8.9114, 161.4845, 18.7561> }
				triangle { <10.7097, 156.3674, 14.778>, <16.6824, 160.3277, 12.4045>, <8.9114, 161.4845, 18.7561> }
				triangle { <8.9114, 161.4845, 18.7561>, <16.6824, 160.3277, 12.4045>, <14.3561, 166.3656, 16.6603> }
				triangle { <14.3561, 166.3656, 16.6603>, <16.6824, 160.3277, 12.4045>, <17.1843, 167.7206, 8.7249> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-5.5335, 151.9805, 18.9767>, 0.2845 }
				cylinder { <-5.5335, 151.9805, 18.9767>, <-5.8254, 154.4689, 22.1599>, 0.2845 }
				cylinder { <-5.8254, 154.4689, 22.1599>, <-6.9288, 156.2801, 25.6112>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-6.9288, 156.2801, 25.6112>, <-3.5937, 157.0038, 33.7106>, <-9.4998, 153.7912, 33.5084> }
				triangle { <-3.5937, 157.0038, 33.7106>, <-5.4975, 160.0604, 40.3456>, <-9.4998, 153.7912, 33.5084> }
				triangle { <-9.4998, 153.7912, 33.5084>, <-5.4975, 160.0604, 40.3456>, <-12.4592, 156.6987, 39.8842> }
				triangle { <-12.4592, 156.6987, 39.8842>, <-5.4975, 160.0604, 40.3456>, <-11.9254, 164.8039, 42.4968> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-4.2821, 152.317, 17.7635>, 0.2845 }
				cylinder { <-4.2821, 152.317, 17.7635>, <-2.08496, 155.597, 18.6714>, 0.2845 }
				cylinder { <-2.08496, 155.597, 18.6714>, <0.4527, 158.7385, 18.9893>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <0.4527, 158.7385, 18.9893>, <8.9656, 159.8134, 20.8922>, <4.8276, 162.7062, 25.3366> }
				triangle { <8.9656, 159.8134, 20.8922>, <13.8752, 165.4763, 21.796>, <4.8276, 162.7062, 25.3366> }
				triangle { <4.8276, 162.7062, 25.3366>, <13.8752, 165.4763, 21.796>, <8.9087, 169.0043, 26.5779> }
				triangle { <8.9087, 169.0043, 26.5779>, <13.8752, 165.4763, 21.796>, <13.02062, 173.6328, 20.7065> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-6.07413, 148.9952, 16.2924>, <-4.7401, 152.2611, 18.2834>, 0.2845 }
				cylinder { <-4.7401, 152.2611, 18.2834>, <-3.406, 155.5269, 20.2745>, 0.2845 }
				cylinder { <-3.406, 155.5269, 20.2745>, <-2.07204, 158.7928, 22.2656>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-2.07204, 158.7928, 22.2656>, <5.01911, 160.8143, 27.04844>, <-0.7307, 161.0395, 30.5314> }
				triangle { <5.01911, 160.8143, 27.04844>, <7.6543, 166.6514, 31.04512>, <-0.7307, 161.0395, 30.5314> }
				triangle { <-0.7307, 161.0395, 30.5314>, <7.6543, 166.6514, 31.04512>, <0.8688, 167.1691, 34.7422> }
				triangle { <0.8688, 167.1691, 34.7422>, <7.6543, 166.6514, 31.04512>, <4.6982, 174.3103, 32.06937> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-9.2783, 138.5966, 10.9684>, <-6.8104, 144.6383, 14.6518>, 2.2666 }
		cylinder { <-6.8104, 144.6383, 14.6518>, <-3.04579, 149.175, 19.2784>, 2.2666 }
		cylinder { <-3.04579, 149.175, 19.2784>, <1.6914, 151.8159, 24.4499>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.6914, 151.8159, 24.4499>, <4.4591, 152.5828, 27.3067>, 0.2845 }
			cylinder { <4.4591, 152.5828, 27.3067>, <7.3524, 152.6663, 30.1409>, 0.2845 }
			cylinder { <7.3524, 152.6663, 30.1409>, <10.2859, 152.0641, 32.8688>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <14.2153, 151.84, 33.8279>, 0.2845 }
				cylinder { <14.2153, 151.84, 33.8279>, <18.1195, 152.0523, 32.7688>, 0.2845 }
				cylinder { <18.1195, 152.0523, 32.7688>, <20.9843, 152.6458, 29.9669>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <20.9843, 152.6458, 29.9669>, <23.4644, 148.6725, 22.5299>, <28.1764, 148.5855, 27.3291> }
				triangle { <23.4644, 148.6725, 22.5299>, <28.8428, 149.374, 17.2791>, <28.1764, 148.5855, 27.3291> }
				triangle { <28.1764, 148.5855, 27.3291>, <28.8428, 149.374, 17.2791>, <34.2177, 149.7073, 22.845> }
				triangle { <34.2177, 149.7073, 22.845>, <28.8428, 149.374, 17.2791>, <34.7212, 155.1049, 16.2558> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <11.7434, 151.2595, 36.5618>, 0.2845 }
				cylinder { <11.7434, 151.2595, 36.5618>, <11.4449, 150.407, 40.5108>, 0.2845 }
				cylinder { <11.4449, 150.407, 40.5108>, <9.4478, 149.6705, 43.9574>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <9.4478, 149.6705, 43.9574>, <8.7278, 142.9013, 49.5167>, <2.9382, 144.5458, 46.5135> }
				triangle { <8.7278, 142.9013, 49.5167>, <4.9492, 141.1457, 55.812>, <2.9382, 144.5458, 46.5135> }
				triangle { <2.9382, 144.5458, 46.5135>, <4.9492, 141.1457, 55.812>, <-1.6505, 143.4535, 52.481> }
				triangle { <-1.6505, 143.4535, 52.481>, <4.9492, 141.1457, 55.812>, <-0.08214, 145.6736, 60.5691> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <13.9891, 151.702, 34.4705>, 0.2845 }
				cylinder { <13.9891, 151.702, 34.4705>, <18.029, 151.6225, 34.7587>, 0.2845 }
				cylinder { <18.029, 151.6225, 34.7587>, <21.9332, 151.8348, 33.6996>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <21.9332, 151.8348, 33.6996>, <27.2572, 147.4128, 28.2824>, <29.03654, 146.9766, 34.7544> }
				triangle { <27.2572, 147.4128, 28.2824>, <34.5394, 147.4012, 26.2924>, <29.03654, 146.9766, 34.7544> }
				triangle { <29.03654, 146.9766, 34.7544>, <34.5394, 147.4012, 26.2924>, <36.5701, 147.3364, 33.7658> }
				triangle { <36.5701, 147.3364, 33.7658>, <34.5394, 147.4012, 26.2924>, <40.7469, 152.4601, 28.3708> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <12.3681, 151.3214, 36.2634>, 0.2845 }
				cylinder { <12.3681, 151.3214, 36.2634>, <13.4481, 150.492, 40.07859>, 0.2845 }
				cylinder { <13.4481, 150.492, 40.07859>, <13.4476, 149.636, 44.03805>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <13.4476, 149.636, 44.03805>, <16.2014, 142.9684, 49.05864>, <9.5463, 143.923, 49.2642> }
				triangle { <16.2014, 142.9684, 49.05864>, <16.1292, 140.9835, 56.3418>, <9.5463, 143.923, 49.2642> }
				triangle { <9.5463, 143.923, 49.2642>, <16.1292, 140.9835, 56.3418>, <8.5425, 142.5045, 56.6697> }
				triangle { <8.5425, 142.5045, 56.6697>, <16.1292, 140.9835, 56.3418>, <13.5746, 145.0762, 63.06267> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <13.6538, 151.5747, 35.06602>, 0.2845 }
				cylinder { <13.6538, 151.5747, 35.06602>, <17.357, 151.2126, 36.6677>, 0.2845 }
				cylinder { <17.357, 151.2126, 36.6677>, <21.2864, 150.9886, 37.6267>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <21.2864, 150.9886, 37.6267>, <28.06512, 145.884, 35.3378>, <26.4503, 145.453, 41.8531> }
				triangle { <28.06512, 145.884, 35.3378>, <35.3585, 145.0604, 37.1036>, <26.4503, 145.453, 41.8531> }
				triangle { <26.4503, 145.453, 41.8531>, <35.3585, 145.0604, 37.1036>, <33.519, 145.0015, 44.6264> }
				triangle { <33.519, 145.0015, 44.6264>, <35.3585, 145.0604, 37.1036>, <40.2881, 149.5069, 42.04071> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <10.2859, 152.0641, 32.8688>, <13.2194, 151.4618, 35.5968>, 0.2845 }
				cylinder { <13.2194, 151.4618, 35.5968>, <16.1529, 150.8596, 38.3247>, 0.2845 }
				cylinder { <16.1529, 150.8596, 38.3247>, <19.08652, 150.2573, 41.05271>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <19.08652, 150.2573, 41.05271>, <25.5527, 144.4139, 42.1878>, <20.9644, 144.3409, 47.1058> }
				triangle { <25.5527, 144.4139, 42.1878>, <30.9618, 142.8903, 47.2287>, <20.9644, 144.3409, 47.1058> }
				triangle { <20.9644, 144.3409, 47.1058>, <30.9618, 142.8903, 47.2287>, <25.7318, 143.2397, 52.9299> }
				triangle { <25.7318, 143.2397, 52.9299>, <30.9618, 142.8903, 47.2287>, <33.3386, 146.9428, 54.03865> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <1.6914, 151.8159, 24.4499>, <2.5993, 151.7807, 25.3262>, 0.3818 }
		cylinder { <2.5993, 151.7807, 25.3262>, <3.479, 151.2708, 26.07442>, 0.3818 }
		cylinder { <3.479, 151.2708, 26.07442>, <4.1964, 150.3637, 26.5804>, 0.3818 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.1964, 150.3637, 26.5804>, <4.6051, 149.7513, 26.8484>, 0.05504 }
			cylinder { <4.6051, 149.7513, 26.8484>, <4.9732, 149.0953, 27.06775>, 0.05504 }
			cylinder { <4.9732, 149.0953, 27.06775>, <5.2973, 148.402, 27.2362>, 0.05504 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.8456, 147.8569, 27.1092>, 0.05504 }
				cylinder { <5.8456, 147.8569, 27.1092>, <6.4757, 147.6015, 26.7196>, 0.05504 }
				cylinder { <6.4757, 147.6015, 26.7196>, <7.02384, 147.7021, 26.1689>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.3592, 147.7251, 27.6258>, 0.05504 }
				cylinder { <5.3592, 147.7251, 27.6258>, <5.1471, 147.1943, 28.1618>, 0.05504 }
				cylinder { <5.1471, 147.1943, 28.1618>, <4.7017, 146.9117, 28.7411>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.7844, 147.789, 27.2078>, 0.05504 }
				cylinder { <5.7844, 147.789, 27.2078>, <6.3777, 147.3278, 26.9859>, 0.05504 }
				cylinder { <6.3777, 147.3278, 26.9859>, <7.007852, 147.0723, 26.5964>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.4655, 147.7025, 27.5466>, 0.05504 }
				cylinder { <5.4655, 147.7025, 27.5466>, <5.4656, 147.0474, 27.9765>, 0.05504 }
				cylinder { <5.4656, 147.0474, 27.9765>, <5.2977, 146.4842, 28.4946>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.709, 147.7391, 27.3073>, 0.05504 }
				cylinder { <5.709, 147.7391, 27.3073>, <6.1961, 147.1261, 27.2789>, 0.05504 }
				cylinder { <6.1961, 147.1261, 27.2789>, <6.7444, 146.5809, 27.1518>, 0.05504 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <5.2973, 148.402, 27.2362>, <5.6213, 147.7088, 27.4046>, 0.05504 }
				cylinder { <5.6213, 147.7088, 27.4046>, <5.9454, 147.0156, 27.5731>, 0.05504 }
				cylinder { <5.9454, 147.0156, 27.5731>, <6.2694, 146.3224, 27.7416>, 0.05504 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <1.6914, 151.8159, 24.4499>, <5.4559, 154.5066, 28.4203>, 1.8441 }
		cylinder { <5.4559, 154.5066, 28.4203>, <9.09432, 157.7133, 32.1153>, 1.8441 }
		cylinder { <9.09432, 157.7133, 32.1153>, <12.5716, 161.4052, 35.4995>, 1.8441 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <12.5716, 161.4052, 35.4995>, <14.5911, 163.8475, 37.3948>, 0.2594 }
			cylinder { <14.5911, 163.8475, 37.3948>, <16.5131, 166.4831, 39.1255>, 0.2594 }
			cylinder { <16.5131, 166.4831, 39.1255>, <18.3273, 169.2975, 40.6823>, 0.2594 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <18.5122, 172.014, 43.1766>, 0.2594 }
				cylinder { <18.5122, 172.014, 43.1766>, <17.01988, 173.9269, 45.9604>, 0.2594 }
				cylinder { <17.01988, 173.9269, 45.9604>, <14.238, 174.5391, 48.3103>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <14.238, 174.5391, 48.3103>, <7.008934, 177.9687, 47.9057>, <10.8651, 180.8158, 51.729> }
				triangle { <7.008934, 177.9687, 47.9057>, <1.768, 179.4361, 52.1169>, <10.8651, 180.8158, 51.729> }
				triangle { <10.8651, 180.8158, 51.729>, <1.768, 179.4361, 52.1169>, <6.2776, 182.3615, 56.6933> }
				triangle { <6.2776, 182.3615, 56.6933>, <1.768, 179.4361, 52.1169>, <0.6247, 177.7417, 59.3761> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <21.176, 171.6094, 41.1009>, 0.2594 }
				cylinder { <21.176, 171.6094, 41.1009>, <24.5123, 172.9748, 40.301>, 0.2594 }
				cylinder { <24.5123, 172.9748, 40.301>, <27.6956, 173.1317, 38.4362>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <27.6956, 173.1317, 38.4362>, <30.7671, 177.7679, 32.6693>, <30.07838, 171.9083, 31.00072> }
				triangle { <30.7671, 177.7679, 32.6693>, <36.506, 178.1572, 28.892>, <30.07838, 171.9083, 31.00072> }
				triangle { <30.07838, 171.9083, 31.00072>, <36.506, 178.1572, 28.892>, <35.9116, 171.3049, 27.3009> }
				triangle { <35.9116, 171.3049, 27.3009>, <36.506, 178.1572, 28.892>, <42.8984, 174.1654, 29.1713> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <19.08292, 172.1304, 42.9271>, 0.2594 }
				cylinder { <19.08292, 172.1304, 42.9271>, <18.6916, 174.6506, 45.5975>, 0.2594 }
				cylinder { <18.6916, 174.6506, 45.5975>, <17.1993, 176.5634, 48.3812>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <17.1993, 176.5634, 48.3812>, <11.5994, 182.2462, 49.111>, <17.1878, 184.07, 50.8537> }
				triangle { <11.5994, 182.2462, 49.111>, <8.804, 186.1069, 54.07454>, <17.1878, 184.07, 50.8537> }
				triangle { <17.1878, 184.07, 50.8537>, <8.804, 186.1069, 54.07454>, <15.2589, 187.8831, 56.3144> }
				triangle { <15.2589, 187.8831, 56.3144>, <8.804, 186.1069, 54.07454>, <9.8061, 186.0495, 61.5489> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <20.8297, 171.865, 41.5659>, 0.2594 }
				cylinder { <20.8297, 171.865, 41.5659>, <23.8392, 173.9997, 41.7124>, 0.2594 }
				cylinder { <23.8392, 173.9997, 41.7124>, <27.1377, 175.5469, 41.1111>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <27.1377, 175.5469, 41.1111>, <29.8107, 182.1987, 37.5343>, <31.7488, 177.0297, 34.8661> }
				triangle { <29.8107, 182.1987, 37.5343>, <35.8336, 185.1935, 36.08177>, <31.7488, 177.0297, 34.8661> }
				triangle { <31.7488, 177.0297, 34.8661>, <35.8336, 185.1935, 36.08177>, <38.1893, 179.1168, 33.3683> }
				triangle { <38.1893, 179.1168, 33.3683>, <35.8336, 185.1935, 36.08177>, <42.8879, 183.291, 37.9502> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <19.6313, 172.1633, 42.6115>, 0.2594 }
				cylinder { <19.6313, 172.1633, 42.6115>, <20.3869, 174.9962, 44.8563>, 0.2594 }
				cylinder { <20.3869, 174.9962, 44.8563>, <20.5719, 177.7128, 47.3506>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <20.5719, 177.7128, 47.3506>, <17.4703, 185.0615, 48.1>, <23.5886, 185.009, 47.7036> }
				triangle { <17.4703, 185.0615, 48.1>, <17.8101, 190.368, 52.4682>, <23.5886, 185.009, 47.7036> }
				triangle { <23.5886, 185.009, 47.7036>, <17.8101, 190.368, 52.4682>, <24.8601, 190.0372, 52.3058> }
				triangle { <24.8601, 190.0372, 52.3058>, <17.8101, 190.368, 52.4682>, <21.2749, 191.0855, 59.128> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <18.3273, 169.2975, 40.6823>, <20.1414, 172.1118, 42.2391>, 0.2594 }
				cylinder { <20.1414, 172.1118, 42.2391>, <21.9555, 174.9262, 43.7959>, 0.2594 }
				cylinder { <21.9555, 174.9262, 43.7959>, <23.7696, 177.7406, 45.3526>, 0.2594 }
				texture{chif1}}
			mesh { // leaf
				triangle { <23.7696, 177.7406, 45.3526>, <23.3865, 185.7354, 45.0018>, <28.6946, 183.4413, 42.9635> }
				triangle { <23.3865, 185.7354, 45.0018>, <26.7365, 191.1645, 47.5818>, <28.6946, 183.4413, 42.9635> }
				triangle { <28.6946, 183.4413, 42.9635>, <26.7365, 191.1645, 47.5818>, <32.8767, 188.3163, 45.5756> }
				triangle { <32.8767, 188.3163, 45.5756>, <26.7365, 191.1645, 47.5818>, <32.3415, 191.5934, 52.6091> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <12.5716, 161.4052, 35.4995>, <14.837, 163.6662, 37.8354>, 1.1984 }
		cylinder { <14.837, 163.6662, 37.8354>, <17.1024, 165.7834, 40.3022>, 1.1984 }
		cylinder { <17.1024, 165.7834, 40.3022>, <19.3624, 167.7517, 42.8942>, 1.1984 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <19.3624, 167.7517, 42.8942>, <20.7289, 168.8102, 44.5813>, 0.1696 }
			cylinder { <20.7289, 168.8102, 44.5813>, <22.07691, 169.7214, 46.3665>, 0.1696 }
			cylinder { <22.07691, 169.7214, 46.3665>, <23.399, 170.4805, 48.2401>, 0.1696 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <25.526, 170.6826, 49.3668>, 0.1696 }
				cylinder { <25.526, 170.6826, 49.3668>, <27.9052, 170.2752, 49.4539>, 0.1696 }
				cylinder { <27.9052, 170.2752, 49.4539>, <29.9185, 169.3641, 48.4787>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <23.7469, 171.5644, 50.3704>, 0.1696 }
				cylinder { <23.7469, 171.5644, 50.3704>, <23.05405, 172.7649, 52.3486>, 0.1696 }
				cylinder { <23.05405, 172.7649, 52.3486>, <21.4532, 173.8515, 53.7946>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <25.3113, 170.882, 49.66>, 0.1696 }
				cylinder { <25.3113, 170.882, 49.66>, <27.5903, 170.8788, 50.4603>, 0.1696 }
				cylinder { <27.5903, 170.8788, 50.4603>, <29.9695, 170.4713, 50.5474>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <24.1447, 171.4602, 50.3182>, 0.1696 }
				cylinder { <24.1447, 171.4602, 50.3182>, <24.26, 172.5895, 52.4503>, 0.1696 }
				cylinder { <24.26, 172.5895, 52.4503>, <23.7366, 173.7865, 54.4819>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <25.04039, 171.0695, 49.9114>, 0.1696 }
				cylinder { <25.04039, 171.0695, 49.9114>, <26.9527, 171.4709, 51.3313>, 0.1696 }
				cylinder { <26.9527, 171.4709, 51.3313>, <29.07972, 171.673, 52.458>, 0.1696 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <23.399, 170.4805, 48.2401>, <24.7211, 171.2397, 50.1136>, 0.1696 }
				cylinder { <24.7211, 171.2397, 50.1136>, <26.0432, 171.9988, 51.9872>, 0.1696 }
				cylinder { <26.0432, 171.9988, 51.9872>, <27.3653, 172.7579, 53.8607>, 0.1696 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-9.2783, 138.5966, 10.9684>, <-8.8365, 145.9262, 12.4657>, 2.2666 }
		cylinder { <-8.8365, 145.9262, 12.4657>, <-8.9209, 153.4003, 13.00502>, 2.2666 }
		cylinder { <-8.9209, 153.4003, 13.00502>, <-9.5299, 160.8571, 12.5746>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.5299, 160.8571, 12.5746>, <-10.04448, 164.8332, 11.9945>, 0.2845 }
			cylinder { <-10.04448, 164.8332, 11.9945>, <-10.7395, 168.7161, 11.07281>, 0.2845 }
			cylinder { <-10.7395, 168.7161, 11.07281>, <-11.6083, 172.4686, 9.8181>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-14.1181, 175.6451, 9.6766>, 0.2845 }
				cylinder { <-14.1181, 175.6451, 9.6766>, <-17.6168, 177.4205, 10.685>, 0.2845 }
				cylinder { <-17.6168, 177.4205, 10.685>, <-21.1954, 177.3333, 12.5814>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-21.1954, 177.3333, 12.5814>, <-28.9664, 173.4563, 11.2301>, <-29.238, 180.174, 11.02646> }
				triangle { <-28.9664, 173.4563, 11.2301>, <-35.8163, 173.2878, 14.3989>, <-29.238, 180.174, 11.02646> }
				triangle { <-29.238, 180.174, 11.02646>, <-35.8163, 173.2878, 14.3989>, <-35.9239, 181.0302, 14.5517> }
				triangle { <-35.9239, 181.0302, 14.5517>, <-35.8163, 173.2878, 14.3989>, <-38.6587, 176.7026, 21.3779> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-10.8723, 175.9374, 7.8597>, 0.2845 }
				cylinder { <-10.8723, 175.9374, 7.8597>, <-8.6728, 178.4565, 5.5736>, 0.2845 }
				cylinder { <-8.6728, 178.4565, 5.5736>, <-5.4322, 179.5422, 3.3987>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-5.4322, 179.5422, 3.3987>, <-3.5924, 180.5097, -5.1408>, <0.03457, 175.7098, -2.1326> }
				triangle { <-3.5924, 180.5097, -5.1408>, <2.3373, 182.2576, -9.4736>, <0.03457, 175.7098, -2.1326> }
				triangle { <0.03457, 175.7098, -2.1326>, <2.3373, 182.2576, -9.4736>, <6.6219, 177.0235, -5.7022> }
				triangle { <6.6219, 177.0235, -5.7022>, <2.3373, 182.2576, -9.4736>, <10.00183, 184.6531, -7.4828> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-13.6251, 175.9413, 9.2862>, 0.2845 }
				cylinder { <-13.6251, 175.9413, 9.2862>, <-16.554, 178.7282, 9.5392>, 0.2845 }
				cylinder { <-16.554, 178.7282, 9.5392>, <-20.05281, 180.5036, 10.5477>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-20.05281, 180.5036, 10.5477>, <-28.4645, 179.7129, 8.1262>, <-25.8138, 185.7336, 6.723> }
				triangle { <-28.4645, 179.7129, 8.1262>, <-35.09829, 182.9942, 9.6149>, <-25.8138, 185.7336, 6.723> }
				triangle { <-25.8138, 185.7336, 6.723>, <-35.09829, 182.9942, 9.6149>, <-31.9135, 189.9512, 8.4164> }
				triangle { <-31.9135, 189.9512, 8.4164>, <-35.09829, 182.9942, 9.6149>, <-37.1505, 188.8701, 15.06546> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-11.4965, 176.1329, 8.09475>, 0.2845 }
				cylinder { <-11.4965, 176.1329, 8.09475>, <-10.4124, 179.4437, 6.02753>, 0.2845 }
				cylinder { <-10.4124, 179.4437, 6.02753>, <-8.4344, 182.161, 3.7662>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-8.4344, 182.161, 3.7662>, <-9.1272, 185.2612, -4.4285>, <-3.3454, 182.0315, -3.252> }
				triangle { <-9.1272, 185.2612, -4.4285>, <-5.4971, 190.0816, -8.9646>, <-3.3454, 182.0315, -3.252> }
				triangle { <-3.3454, 182.0315, -3.252>, <-5.4971, 190.0816, -8.9646>, <1.2152, 186.6166, -7.2568> }
				triangle { <1.2152, 186.6166, -7.2568>, <-5.4971, 190.0816, -8.9646>, <0.8891, 195.1389, -7.5204> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-13.07267, 176.1351, 8.9114>, 0.2845 }
				cylinder { <-13.07267, 176.1351, 8.9114>, <-15.08945, 179.6078, 8.3795>, 0.2845 }
				cylinder { <-15.08945, 179.6078, 8.3795>, <-17.5992, 182.7844, 8.238>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-17.5992, 182.7844, 8.238>, <-25.1188, 184.7138, 4.1174>, <-19.9872, 188.6898, 2.3563> }
				triangle { <-25.1188, 184.7138, 4.1174>, <-29.855, 190.5553, 3.458>, <-19.9872, 188.6898, 2.3563> }
				triangle { <-19.9872, 188.6898, 2.3563>, <-29.855, 190.5553, 3.458>, <-23.8751, 195.2087, 1.8562> }
				triangle { <-23.8751, 195.2087, 1.8562>, <-29.855, 190.5553, 3.458>, <-29.9394, 197.9303, 7.2061> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-11.6083, 172.4686, 9.8181>, <-12.4771, 176.221, 8.5634>, 0.2845 }
				cylinder { <-12.4771, 176.221, 8.5634>, <-13.3459, 179.9735, 7.3087>, 0.2845 }
				cylinder { <-13.3459, 179.9735, 7.3087>, <-14.2147, 183.7259, 6.0541>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-14.2147, 183.7259, 6.0541>, <-19.541, 187.3023, 0.04697>, <-13.01444, 188.4173, -1.1376> }
				triangle { <-19.541, 187.3023, 0.04697>, <-21.1913, 194.1493, -2.6705>, <-13.01444, 188.4173, -1.1376> }
				triangle { <-13.01444, 188.4173, -1.1376>, <-21.1913, 194.1493, -2.6705>, <-13.6397, 195.5793, -3.6228> }
				triangle { <-13.6397, 195.5793, -3.6228>, <-21.1913, 194.1493, -2.6705>, <-18.6412, 201.6718, -0.3563> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-9.5299, 160.8571, 12.5746>, <-10.2666, 163.2846, 11.4404>, 0.8404 }
		cylinder { <-10.2666, 163.2846, 11.4404>, <-11.388, 164.958, 9.5262>, 0.8404 }
		cylinder { <-11.388, 164.958, 9.5262>, <-12.7015, 165.5902, 7.1604>, 0.8404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.7015, 165.5902, 7.1604>, <-13.5109, 165.7296, 5.6793>, 0.1189 }
			cylinder { <-13.5109, 165.7296, 5.6793>, <-14.3116, 165.62, 4.1911>, 0.1189 }
			cylinder { <-14.3116, 165.62, 4.1911>, <-15.0864, 165.264, 2.7279>, 0.1189 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-16.4937, 164.9172, 1.852>, 0.1189 }
				cylinder { <-16.4937, 164.9172, 1.852>, <-18.168, 164.6699, 1.791>, 0.1189 }
				cylinder { <-18.168, 164.6699, 1.791>, <-19.6741, 164.5862, 2.5607>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-15.1507, 164.9742, 1.0606>, 0.1189 }
				cylinder { <-15.1507, 164.9742, 1.0606>, <-14.4923, 164.8062, -0.4906>, 0.1189 }
				cylinder { <-14.4923, 164.8062, -0.4906>, <-13.2375, 164.7924, -1.6279>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-16.317, 164.9035, 1.6217>, 0.1189 }
				cylinder { <-16.317, 164.9035, 1.6217>, <-17.8596, 164.5807, 1.001902>, 0.1189 }
				cylinder { <-17.8596, 164.5807, 1.001902>, <-19.5339, 164.3333, 0.9409>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-15.4363, 164.9408, 1.1027>, 0.1189 }
				cylinder { <-15.4363, 164.9408, 1.1027>, <-15.336, 164.6739, -0.5666>, 0.1189 }
				cylinder { <-15.336, 164.6739, -0.5666>, <-14.7929, 164.4827, -2.1592>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-16.104, 164.9003, 1.424>, 0.1189 }
				cylinder { <-16.104, 164.9003, 1.424>, <-17.3347, 164.5398, 0.3178>, 0.1189 }
				cylinder { <-17.3347, 164.5398, 0.3178>, <-18.742, 164.1931, -0.558>, 0.1189 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-15.0864, 165.264, 2.7279>, <-15.8611, 164.9079, 1.2646>, 0.1189 }
				cylinder { <-15.8611, 164.9079, 1.2646>, <-16.6359, 164.5518, -0.1985>, 0.1189 }
				cylinder { <-16.6359, 164.5518, -0.1985>, <-17.4106, 164.1958, -1.6617>, 0.1189 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-9.5299, 160.8571, 12.5746>, <-10.04254, 168.3327, 12.687>, 2.2666 }
		cylinder { <-10.04254, 168.3327, 12.687>, <-10.4561, 175.7867, 13.3417>, 2.2666 }
		cylinder { <-10.4561, 175.7867, 13.3417>, <-10.7683, 183.1784, 14.5352>, 2.2666 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.7683, 183.1784, 14.5352>, <-10.8627, 187.0957, 15.5629>, 0.2845 }
			cylinder { <-10.8627, 187.0957, 15.5629>, <-10.8819, 190.8968, 16.9632>, 0.2845 }
			cylinder { <-10.8819, 190.8968, 16.9632>, <-10.8255, 194.5452, 18.7228>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-8.8161, 197.8594, 19.9012>, 0.2845 }
				cylinder { <-8.8161, 197.8594, 19.9012>, <-5.3758, 199.9782, 20.1923>, 0.2845 }
				cylinder { <-5.3758, 199.9782, 20.1923>, <-1.3984, 200.3511, 19.5205>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-1.3984, 200.3511, 19.5205>, <5.9336, 196.9165, 22.9395>, <5.4467, 203.5757, 23.7533> }
				triangle { <5.9336, 196.9165, 22.9395>, <13.4054, 197.5793, 22.08952>, <5.4467, 203.5757, 23.7533> }
				triangle { <5.4467, 203.5757, 23.7533>, <13.4054, 197.5793, 22.08952>, <12.7689, 205.281, 22.5962> }
				triangle { <12.7689, 205.281, 22.5962>, <13.4054, 197.5793, 22.08952>, <17.8913, 201.9182, 16.6584> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-12.475, 197.7221, 20.6192>, 0.2845 }
				cylinder { <-12.475, 197.7221, 20.6192>, <-15.5137, 199.8175, 22.2883>, 0.2845 }
				cylinder { <-15.5137, 199.8175, 22.2883>, <-19.358, 200.429, 23.4096>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-19.358, 200.429, 23.4096>, <-23.8187, 200.3397, 30.9819>, <-25.8406, 195.6438, 26.611> }
				triangle { <-23.8187, 200.3397, 30.9819>, <-30.9374, 201.1839, 33.3488>, <-25.8406, 195.6438, 26.611> }
				triangle { <-25.8406, 195.6438, 26.611>, <-30.9374, 201.1839, 33.3488>, <-33.3033, 196.0925, 28.01416> }
				triangle { <-33.3033, 196.0925, 28.01416>, <-30.9374, 201.1839, 33.3488>, <-37.8221, 203.2256, 29.2405> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-9.4326, 198.0759, 20.1385>, 0.2845 }
				cylinder { <-9.4326, 198.0759, 20.1385>, <-6.8659, 201.076, 21.04498>, 0.2845 }
				cylinder { <-6.8659, 201.076, 21.04498>, <-3.4256, 203.1948, 21.3361>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-3.4256, 203.1948, 21.3361>, <3.8711, 202.7515, 26.2152>, <0.3214, 208.3818, 27.1862> }
				triangle { <3.8711, 202.7515, 26.2152>, <10.2728, 206.6393, 27.1607>, <0.3214, 208.3818, 27.1862> }
				triangle { <0.3214, 208.3818, 27.1862>, <10.2728, 206.6393, 27.1607>, <6.1855, 213.1819, 27.8445> }
				triangle { <6.1855, 213.1819, 27.8445>, <10.2728, 206.6393, 27.1607>, <13.2921, 213.1982, 23.1221> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-11.832, 197.9859, 20.6093>, 0.2845 }
				cylinder { <-11.832, 197.9859, 20.6093>, <-13.8283, 200.9695, 22.4862>, 0.2845 }
				cylinder { <-13.8283, 200.9695, 22.4862>, <-16.6699, 203.2798, 24.2175>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-16.6699, 203.2798, 24.2175>, <-18.8445, 205.5233, 32.4324>, <-23.6269, 202.034, 29.2393> }
				triangle { <-18.8445, 205.5233, 32.4324>, <-24.161, 209.5569, 35.9615>, <-23.6269, 202.034, 29.2393> }
				triangle { <-23.6269, 202.034, 29.2393>, <-24.161, 209.5569, 35.9615>, <-29.6372, 205.8247, 31.9538> }
				triangle { <-29.6372, 205.8247, 31.9538>, <-24.161, 209.5569, 35.9615>, <-30.2739, 214.2708, 32.9853> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-10.09007, 198.1884, 20.3341>, 0.2845 }
				cylinder { <-10.09007, 198.1884, 20.3341>, <-8.6971, 201.719, 21.7499>, 0.2845 }
				cylinder { <-8.6971, 201.719, 21.7499>, <-6.6877, 205.0332, 22.9283>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-6.6877, 205.0332, 22.9283>, <-1.03269, 207.041, 29.3498>, <-6.8326, 210.428, 29.714> }
				triangle { <-1.03269, 207.041, 29.3498>, <2.6542, 213.1013, 31.9323>, <-6.8326, 210.428, 29.714> }
				triangle { <-6.8326, 210.428, 29.714>, <2.6542, 213.1013, 31.9323>, <-3.9682, 217.1165, 31.9325> }
				triangle { <-3.9682, 217.1165, 31.9325>, <2.6542, 213.1013, 31.9323>, <3.1366, 220.8233, 29.00257> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.8255, 194.5452, 18.7228>, <-10.7691, 198.1936, 20.4823>, 0.2845 }
				cylinder { <-10.7691, 198.1936, 20.4823>, <-10.7128, 201.842, 22.2419>, 0.2845 }
				cylinder { <-10.7128, 201.842, 22.2419>, <-10.6564, 205.4904, 24.00145>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-10.6564, 205.4904, 24.00145>, <-7.823, 208.7722, 31.6465>, <-14.4759, 209.2843, 30.7976> }
				triangle { <-7.823, 208.7722, 31.6465>, <-7.7901, 215.388, 35.2824>, <-14.4759, 209.2843, 30.7976> }
				triangle { <-14.4759, 209.2843, 30.7976>, <-7.7901, 215.388, 35.2824>, <-15.3735, 216.1642, 33.9159> }
				triangle { <-15.3735, 216.1642, 33.9159>, <-7.7901, 215.388, 35.2824>, <-10.2558, 222.914, 32.8896> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-10.7683, 183.1784, 14.5352>, <-10.6586, 186.5988, 16.5013>, 1.1937 }
		cylinder { <-10.6586, 186.5988, 16.5013>, <-10.2893, 189.0883, 19.5414>, 1.1937 }
		cylinder { <-10.2893, 189.0883, 19.5414>, <-9.7101, 190.3134, 23.2482>, 1.1937 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.7101, 190.3134, 23.2482>, <-9.3181, 190.7175, 25.5879>, 0.169 }
			cylinder { <-9.3181, 190.7175, 25.5879>, <-8.8959, 190.77, 27.9565>, 0.169 }
			cylinder { <-8.8959, 190.77, 27.9565>, <-8.4526, 190.4698, 30.3027>, 0.169 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-6.9023, 190.2916, 32.1346>, 0.169 }
				cylinder { <-6.9023, 190.2916, 32.1346>, <-4.6479, 190.2817, 32.9763>, 0.169 }
				cylinder { <-4.6479, 190.2817, 32.9763>, <-2.2751, 190.4427, 32.6092>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-9.06209, 190.1264, 32.6052>, 0.169 }
				cylinder { <-9.06209, 190.1264, 32.6052>, <-10.6072, 189.8058, 34.4221>, 0.169 }
				cylinder { <-10.6072, 189.8058, 34.4221>, <-12.7913, 189.5695, 35.4043>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-7.2393, 190.2439, 32.3685>, 0.169 }
				cylinder { <-7.2393, 190.2439, 32.3685>, <-5.3977, 190.1187, 33.9126>, 0.169 }
				cylinder { <-5.3977, 190.1187, 33.9126>, <-3.1433, 190.1088, 34.7543>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-8.6555, 190.1356, 32.6772>, 0.169 }
				cylinder { <-8.6555, 190.1356, 32.6772>, <-9.4899, 189.7915, 34.908>, 0.169 }
				cylinder { <-9.4899, 189.7915, 34.908>, <-10.8954, 189.4625, 36.8334>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-7.6119, 190.2028, 32.5416>, 0.169 }
				cylinder { <-7.6119, 190.2028, 32.5416>, <-6.3986, 189.9769, 34.6075>, 0.169 }
				cylinder { <-6.3986, 189.9769, 34.6075>, <-4.8483, 189.7987, 36.4395>, 0.169 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-8.4526, 190.4698, 30.3027>, <-8.009357, 190.1696, 32.6488>, 0.169 }
				cylinder { <-8.009357, 190.1696, 32.6488>, <-7.566, 189.8694, 34.995>, 0.169 }
				cylinder { <-7.566, 189.8694, 34.995>, <-7.1227, 189.5692, 37.3411>, 0.169 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-10.7683, 183.1784, 14.5352>, <-10.8234, 189.7575, 13.9867>, 1.9968 }
		cylinder { <-10.8234, 189.7575, 13.9867>, <-10.6551, 196.0092, 11.8712>, 1.9968 }
		cylinder { <-10.6551, 196.0092, 11.8712>, <-10.2735, 201.5589, 8.3155>, 1.9968 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.2735, 201.5589, 8.3155>, <-10.00261, 204.7935, 5.892>, 0.2845 }
			cylinder { <-10.00261, 204.7935, 5.892>, <-9.6962, 207.8401, 3.2397>, 0.2845 }
			cylinder { <-9.6962, 207.8401, 3.2397>, <-9.3561, 210.6821, 0.3731>, 0.2845 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-11.03771, 213.1156, -2.3946>, 0.2845 }
				cylinder { <-11.03771, 213.1156, -2.3946>, <-14.304, 214.5082, -4.3444>, 0.2845 }
				cylinder { <-14.304, 214.5082, -4.3444>, <-18.3063, 214.4981, -4.9698>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-18.3063, 214.4981, -4.9698>, <-24.03906, 209.2773, -9.108>, <-23.6443, 215.4571, -11.7342> }
				triangle { <-24.03906, 209.2773, -9.108>, <-31.4279, 209.109, -10.6461>, <-23.6443, 215.4571, -11.7342> }
				triangle { <-23.6443, 215.4571, -11.7342>, <-31.4279, 209.109, -10.6461>, <-31.03677, 216.386, -13.2673> }
				triangle { <-31.03677, 216.386, -13.2673>, <-31.4279, 209.109, -10.6461>, <-37.5825, 214.1104, -8.2895> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-7.3334, 213.2854, -1.9808>, 0.2845 }
				cylinder { <-7.3334, 213.2854, -1.9808>, <-4.0164, 215.1501, -3.3702>, 0.2845 }
				cylinder { <-4.0164, 215.1501, -3.3702>, <-0.04209, 215.9181, -3.5282>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-0.04209, 215.9181, -3.5282>, <6.5916, 213.7993, -8.89>, <7.3039, 211.3981, -2.6474> }
				triangle { <6.5916, 213.7993, -8.89>, <14.05462, 214.8515, -9.3234>, <7.3039, 211.3981, -2.6474> }
				triangle { <7.3039, 211.3981, -2.6474>, <14.05462, 214.8515, -9.3234>, <14.8023, 212.492, -1.985> }
				triangle { <14.8023, 212.492, -1.985>, <14.05462, 214.8515, -9.3234>, <19.1932, 219.3163, -4.6218> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-10.3875, 213.3311, -2.5128>, 0.2845 }
				cylinder { <-10.3875, 213.3311, -2.5128>, <-12.6697, 215.4774, -5.08091>, 0.2845 }
				cylinder { <-12.6697, 215.4774, -5.08091>, <-15.936, 216.8699, -7.03079>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-15.936, 216.8699, -7.03079>, <-21.1695, 213.9594, -13.4638>, <-17.8289, 219.5789, -15.04634> }
				triangle { <-21.1695, 213.9594, -13.4638>, <-27.1107, 216.3864, -17.4391>, <-17.8289, 219.5789, -15.04634> }
				triangle { <-17.8289, 219.5789, -15.04634>, <-27.1107, 216.3864, -17.4391>, <-23.4112, 223.0342, -18.8882> }
				triangle { <-23.4112, 223.0342, -18.8882>, <-27.1107, 216.3864, -17.4391>, <-31.6683, 223.2565, -16.7492> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-7.9583, 213.4425, -2.2414>, 0.2845 }
				cylinder { <-7.9583, 213.4425, -2.2414>, <-5.6041, 215.9212, -4.4148>, 0.2845 }
				cylinder { <-5.6041, 215.9212, -4.4148>, <-2.4639, 217.9388, -5.9893>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-2.4639, 217.9388, -5.9893>, <2.2345, 217.5195, -13.4052>, <5.8301, 216.2472, -7.8647> }
				triangle { <2.2345, 217.5195, -13.4052>, <8.2215, 220.9268, -16.4932>, <5.8301, 216.2472, -7.8647> }
				triangle { <5.8301, 216.2472, -7.8647>, <8.2215, 220.9268, -16.4932>, <12.2073, 219.835, -9.9433> }
				triangle { <12.2073, 219.835, -9.9433>, <8.2215, 220.9268, -16.4932>, <12.7339, 227.3659, -13.9199> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-9.7069, 213.4687, -2.546>, 0.2845 }
				cylinder { <-9.7069, 213.4687, -2.546>, <-10.7383, 216.1176, -5.4321>, 0.2845 }
				cylinder { <-10.7383, 216.1176, -5.4321>, <-12.4198, 218.5511, -8.1999>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-12.4198, 218.5511, -8.1999>, <-15.624, 217.6046, -16.329>, <-10.2781, 221.6735, -15.9995> }
				triangle { <-15.624, 217.6046, -16.329>, <-18.563, 221.9274, -21.7756>, <-10.2781, 221.6735, -15.9995> }
				triangle { <-10.2781, 221.6735, -15.9995>, <-18.563, 221.9274, -21.7756>, <-12.6117, 226.8338, -21.07768> }
				triangle { <-12.6117, 226.8338, -21.07768>, <-18.563, 221.9274, -21.7756>, <-20.5076, 229.9683, -21.8739> }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3561, 210.6821, 0.3731>, <-9.01606, 213.5242, -2.4933>, 0.2845 }
				cylinder { <-9.01606, 213.5242, -2.4933>, <-8.6759, 216.3662, -5.3599>, 0.2845 }
				cylinder { <-8.6759, 216.3662, -5.3599>, <-8.3358, 219.2082, -8.2265>, 0.2845 }
				texture{chif1}}
			mesh { // leaf
				triangle { <-8.3358, 219.2082, -8.2265>, <-8.5078, 219.3693, -17.01236>, <-2.6182, 221.3002, -14.3993> }
				triangle { <-8.5078, 219.3693, -17.01236>, <-7.6704, 224.3958, -22.5822>, <-2.6182, 221.3002, -14.3993> }
				triangle { <-2.6182, 221.3002, -14.3993>, <-7.6704, 224.3958, -22.5822>, <-1.1085, 226.9012, -19.3198> }
				triangle { <-1.1085, 226.9012, -19.3198>, <-7.6704, 224.3958, -22.5822>, <-6.6646, 232.6053, -22.3852> }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-10.2735, 201.5589, 8.3155>, <-10.1118, 202.3652, 7.03042>, 0.4614 }
		cylinder { <-10.1118, 202.3652, 7.03042>, <-9.9074, 202.5404, 5.5286>, 0.4614 }
		cylinder { <-9.9074, 202.5404, 5.5286>, <-9.6998, 202.0509, 4.09853>, 0.4614 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.6998, 202.0509, 4.09853>, <-9.5769, 201.6698, 3.2651>, 0.06495 }
			cylinder { <-9.5769, 201.6698, 3.2651>, <-9.4581, 201.2081, 2.4729>, 0.06495 }
			cylinder { <-9.4581, 201.2081, 2.4729>, <-9.3445, 200.6701, 1.7296>, 0.06495 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-9.6971, 200.193, 1.0204>, 0.06495 }
				cylinder { <-9.6971, 200.193, 1.0204>, <-10.4241, 199.9007, 0.5295>, 0.06495 }
				cylinder { <-10.4241, 199.9007, 0.5295>, <-11.3367, 199.8693, 0.3846>, 0.06495 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-8.8503, 200.1915, 1.1118>, 0.06495 }
				cylinder { <-8.8503, 200.1915, 1.1118>, <-8.07051, 199.8643, 0.7382>, 0.06495 }
				cylinder { <-8.07051, 199.8643, 0.7382>, <-7.1546, 199.7512, 0.6805>, 0.06495 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-9.5461, 200.1574, 0.987>, 0.06495 }
				cylinder { <-9.5461, 200.1574, 0.987>, <-10.03926, 199.7299, 0.332>, 0.06495 }
				cylinder { <-10.03926, 199.7299, 0.332>, <-10.7662, 199.4377, -0.1587>, 0.06495 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-8.9908, 200.1564, 1.04701>, 0.06495 }
				cylinder { <-8.9908, 200.1564, 1.04701>, <-8.4227, 199.7043, 0.4745>, 0.06495 }
				cylinder { <-8.4227, 199.7043, 0.4745>, <-7.6812, 199.3465, 0.05381>, 0.06495 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-9.3892, 200.1369, 0.9755>, 0.06495 }
				cylinder { <-9.3892, 200.1369, 0.9755>, <-9.5907, 199.6241, 0.233>, 0.06495 }
				cylinder { <-9.5907, 199.6241, 0.233>, <-9.9433, 199.147, -0.4761>, 0.06495 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-9.3445, 200.6701, 1.7296>, <-9.231, 200.132, 0.9862>, 0.06495 }
				cylinder { <-9.231, 200.132, 0.9862>, <-9.1174, 199.594, 0.2429>, 0.06495 }
				cylinder { <-9.1174, 199.594, 0.2429>, <-9.003875, 199.056, -0.5003>, 0.06495 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-10.2735, 201.5589, 8.3155>, <-10.1067, 205.4987, 6.03103>, 1.3784 }
		cylinder { <-10.1067, 205.4987, 6.03103>, <-10.03673, 209.5379, 3.9218>, 1.3784 }
		cylinder { <-10.03673, 209.5379, 3.9218>, <-10.06382, 213.6668, 1.9931>, 1.3784 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.06382, 213.6668, 1.9931>, <-10.1652, 216.1636, 1.0229>, 0.1883 }
			cylinder { <-10.1652, 216.1636, 1.0229>, <-10.3517, 218.715, 0.2221>, 0.1883 }
			cylinder { <-10.3517, 218.715, 0.2221>, <-10.6221, 221.3072, -0.4046>, 0.1883 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-9.667, 223.8117, -0.4336>, 0.1883 }
				cylinder { <-9.667, 223.8117, -0.4336>, <-7.7346, 225.5778, 0.1428>, 0.1883 }
				cylinder { <-7.7346, 225.5778, 0.1428>, <-5.327, 226.1466, 1.175>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-11.8991, 223.4344, -1.4193>, 0.1883 }
				cylinder { <-11.8991, 223.4344, -1.4193>, <-13.9375, 224.6883, -2.627>, 0.1883 }
				cylinder { <-13.9375, 224.6883, -2.627>, <-16.3458, 224.828, -3.7958>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-10.06317, 223.9181, -0.6418>, 0.1883 }
				cylinder { <-10.06317, 223.9181, -0.6418>, <-8.7401, 226.2425, -0.4616>, 0.1883 }
				cylinder { <-8.7401, 226.2425, -0.4616>, <-6.8077, 228.0086, 0.1148>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-11.5268, 223.6707, -1.2883>, 0.1883 }
				cylinder { <-11.5268, 223.6707, -1.2883>, <-13.00038, 225.6343, -2.3647>, 0.1883 }
				cylinder { <-13.00038, 225.6343, -2.3647>, <-14.9358, 227.0558, -3.5558>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-10.4757, 223.9476, -0.8431>, 0.1883 }
				cylinder { <-10.4757, 223.9476, -0.8431>, <-9.9167, 226.5585, -1.08037>, 0.1883 }
				cylinder { <-9.9167, 226.5585, -1.08037>, <-8.9616, 229.063, -1.1093>, 0.1883 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-10.6221, 221.3072, -0.4046>, <-10.8925, 223.8994, -1.03154>, 0.1883 }
				cylinder { <-10.8925, 223.8994, -1.03154>, <-11.1629, 226.4916, -1.6584>, 0.1883 }
				cylinder { <-11.1629, 226.4916, -1.6584>, <-11.4333, 229.0838, -2.2852>, 0.1883 }
				texture{chif1}}
			}
		}
	union { // internode
		cylinder { <-10.06382, 213.6668, 1.9931>, <-9.862, 215.1701, 1.04834>, 0.5404 }
		cylinder { <-9.862, 215.1701, 1.04834>, <-9.4538, 216.5134, -0.05712>, 0.5404 }
		cylinder { <-9.4538, 216.5134, -0.05712>, <-8.8513, 217.6572, -1.2907>, 0.5404 }
		texture{chif2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.8513, 217.6572, -1.2907>, <-8.3926, 218.2314, -2.08894>, 0.07621 }
			cylinder { <-8.3926, 218.2314, -2.08894>, <-7.8512, 218.673, -2.919>, 0.07621 }
			cylinder { <-7.8512, 218.673, -2.919>, <-7.2388, 218.9722, -3.7631>, 0.07621 }
			texture{chif1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-7.09057, 219.0733, -4.8332>, 0.07621 }
				cylinder { <-7.09057, 219.0733, -4.8332>, <-7.4451, 218.95, -5.8512>, 0.07621 }
				cylinder { <-7.4451, 218.95, -5.8512>, <-8.2103, 218.6342, -6.5526>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-6.3514, 219.381, -4.235>, 0.07621 }
				cylinder { <-6.3514, 219.381, -4.235>, <-5.3595, 219.8207, -4.2442>, 0.07621 }
				cylinder { <-5.3595, 219.8207, -4.2442>, <-4.4536, 220.2069, -3.7888>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-6.925, 219.1452, -4.7873>, 0.07621 }
				cylinder { <-6.925, 219.1452, -4.7873>, <-6.9467, 219.1715, -5.8717>, 0.07621 }
				cylinder { <-6.9467, 219.1715, -5.8717>, <-7.3012, 219.0481, -6.8897>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-6.4403, 219.3469, -4.395>, 0.07621 }
				cylinder { <-6.4403, 219.3469, -4.395>, <-5.5137, 219.7697, -4.769>, 0.07621 }
				cylinder { <-5.5137, 219.7697, -4.769>, <-4.5261, 220.2102, -4.8579>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-6.7687, 219.2119, -4.7112>, 0.07621 }
				cylinder { <-6.7687, 219.2119, -4.7112>, <-6.455, 219.3848, -5.7353>, 0.07621 }
				cylinder { <-6.455, 219.3848, -5.7353>, <-6.3067, 219.4859, -6.8054>, 0.07621 }
				texture{chif1}}
			union { // compound leaf petiolet
				cylinder { <-7.2388, 218.9722, -3.7631>, <-6.6263, 219.2715, -4.6072>, 0.07621 }
				cylinder { <-6.6263, 219.2715, -4.6072>, <-6.01382, 219.5708, -5.4513>, 0.07621 }
				cylinder { <-6.01382, 219.5708, -5.4513>, <-5.4013, 219.8701, -6.2954>, 0.07621 }
				texture{chif1}}
			}
		}
} // end thin_shrub

