// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare hojas7 = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.002701, 0.1734, 0.003291>, 0.7188 }
		cylinder { <0.002701, 0.1734, 0.003291>, <0.008102, 0.3467, 0.009872>, 0.7188 }
		cylinder { <0.008102, 0.3467, 0.009872>, <0.01619, 0.5197, 0.01973>, 0.7188 }
		cylinder { <0.01619, 0.5197, 0.01973>, <0.02698, 0.6924, 0.03288>, 0.7188 }
		cylinder { <0.02698, 0.6924, 0.03288>, <0.04046, 0.8646, 0.0493>, 0.7188 }
		cylinder { <0.04046, 0.8646, 0.0493>, <0.05661, 1.03628, 0.06898>, 0.7188 }
		cylinder { <0.05661, 1.03628, 0.06898>, <0.07543, 1.2072, 0.09191>, 0.7188 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // internode
		cylinder { <0.07543, 1.2072, 0.09191>, <0.0777, 1.2276, 0.09414>, 0.08575 }
		cylinder { <0.0777, 1.2276, 0.09414>, <0.08, 1.2481, 0.09587>, 0.08575 }
		cylinder { <0.08, 1.2481, 0.09587>, <0.08232, 1.2687, 0.09709>, 0.08575 }
		cylinder { <0.08232, 1.2687, 0.09709>, <0.08467, 1.2892, 0.0978>, 0.08575 }
		cylinder { <0.08467, 1.2892, 0.0978>, <0.08704, 1.3098, 0.098>, 0.08575 }
		cylinder { <0.08704, 1.3098, 0.098>, <0.08943, 1.3303, 0.0977>, 0.08575 }
		cylinder { <0.08943, 1.3303, 0.0977>, <0.09184, 1.3509, 0.09689>, 0.08575 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.09184, 1.3509, 0.09689>, <0.885, 8.5565, 1.06339>, 0.897 }
			cylinder { <0.885, 8.5565, 1.06339>, <1.5965, 15.4977, 3.2539>, 0.897 }
			cylinder { <1.5965, 15.4977, 3.2539>, <2.2053, 21.97, 6.6039>, 0.897 }
			cylinder { <2.2053, 21.97, 6.6039>, <2.6937, 27.7829, 11.01485>, 0.897 }
			cylinder { <2.6937, 27.7829, 11.01485>, <3.04709, 32.7653, 16.3567>, 0.897 }
			cylinder { <3.04709, 32.7653, 16.3567>, <3.2551, 36.7703, 22.4723>, 0.897 }
			cylinder { <3.2551, 36.7703, 22.4723>, <3.3117, 39.6802, 29.1816>, 0.897 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <3.3117, 39.6802, 29.1816>, <7.4805, 34.4385, 25.3623>, <11.7636, 38.7324, 30.9752> }
			triangle { <3.3117, 39.6802, 29.1816>, <11.7636, 38.7324, 30.9752>, <10.9326, 41.8701, 36.1634> }
			triangle { <7.4805, 34.4385, 25.3623>, <11.4114, 32.5034, 24.7146>, <11.7636, 38.7324, 30.9752> }
			triangle { <11.4114, 32.5034, 24.7146>, <14.01151, 33.3984, 28.6659>, <11.7636, 38.7324, 30.9752> }
			triangle { <14.01151, 33.3984, 28.6659>, <14.8945, 35.8445, 35.1089>, <11.7636, 38.7324, 30.9752> }
			triangle { <14.8945, 35.8445, 35.1089>, <14.7438, 38.837, 41.8081>, <10.9326, 41.8701, 36.1634> }
			triangle { <11.7636, 38.7324, 30.9752>, <14.8945, 35.8445, 35.1089>, <10.9326, 41.8701, 36.1634> }
			triangle { <10.9326, 41.8701, 36.1634>, <10.9181, 43.1467, 42.6366>, <6.5074, 44.7993, 40.9878> }
			triangle { <10.9181, 43.1467, 42.6366>, <10.6996, 42.78, 48.128>, <7.5232, 45.3525, 46.7968> }
			triangle { <10.9181, 43.1467, 42.6366>, <7.5232, 45.3525, 46.7968>, <6.5074, 44.7993, 40.9878> }
			triangle { <6.5074, 44.7993, 40.9878>, <7.5232, 45.3525, 46.7968>, <3.2044, 45.9201, 45.1333> }
			triangle { <10.6996, 42.78, 48.128>, <5.2223, 44.4249, 53.7606>, <7.5232, 45.3525, 46.7968> }
			triangle { <7.5232, 45.3525, 46.7968>, <5.2223, 44.4249, 53.7606>, <3.2044, 45.9201, 45.1333> }
			triangle { <3.3117, 39.6802, 29.1816>, <10.9326, 41.8701, 36.1634>, <3.5264, 42.8905, 35.541> }
			triangle { <3.5264, 42.8905, 35.541>, <10.9326, 41.8701, 36.1634>, <6.5074, 44.7993, 40.9878> }
			triangle { <3.5264, 42.8905, 35.541>, <6.5074, 44.7993, 40.9878>, <3.5694, 45.1016, 40.6392> }
			triangle { <6.5074, 44.7993, 40.9878>, <3.2044, 45.9201, 45.1333>, <3.5694, 45.1016, 40.6392> }
			triangle { <14.7438, 38.837, 41.8081>, <10.9181, 43.1467, 42.6366>, <10.9326, 41.8701, 36.1634> }
			triangle { <14.7438, 38.837, 41.8081>, <10.6996, 42.78, 48.128>, <10.9181, 43.1467, 42.6366> }
			triangle { <-4.001337, 44.3502, 28.6717>, <-2.06135, 37.8387, 23.9681>, <3.3117, 39.6802, 29.1816> }
			triangle { <-2.7579, 46.7487, 34.163>, <-4.001337, 44.3502, 28.6717>, <3.3117, 39.6802, 29.1816> }
			triangle { <-4.001337, 44.3502, 28.6717>, <-6.0129, 38.7125, 22.1686>, <-2.06135, 37.8387, 23.9681> }
			triangle { <-4.001337, 44.3502, 28.6717>, <-8.3912, 41.3816, 25.3925>, <-6.0129, 38.7125, 22.1686> }
			triangle { <-4.001337, 44.3502, 28.6717>, <-9.1677, 44.419, 31.593>, <-8.3912, 41.3816, 25.3925> }
			triangle { <-2.7579, 46.7487, 34.163>, <-8.9035, 47.2637, 38.3528>, <-9.1677, 44.419, 31.593> }
			triangle { <-2.7579, 46.7487, 34.163>, <-9.1677, 44.419, 31.593>, <-4.001337, 44.3502, 28.6717> }
			triangle { <1.1141, 46.7212, 40.1998>, <-3.04312, 49.6515, 39.9331>, <-2.7579, 46.7487, 34.163> }
			triangle { <-0.8539, 48.1192, 45.6675>, <-5.0653, 48.3978, 45.8245>, <-3.04312, 49.6515, 39.9331> }
			triangle { <1.1141, 46.7212, 40.1998>, <-0.8539, 48.1192, 45.6675>, <-3.04312, 49.6515, 39.9331> }
			triangle { <3.2044, 45.9201, 45.1333>, <-0.8539, 48.1192, 45.6675>, <1.1141, 46.7212, 40.1998> }
			triangle { <-0.8539, 48.1192, 45.6675>, <-1.3356, 46.9804, 52.7076>, <-5.0653, 48.3978, 45.8245> }
			triangle { <3.2044, 45.9201, 45.1333>, <-1.3356, 46.9804, 52.7076>, <-0.8539, 48.1192, 45.6675> }
			triangle { <3.5264, 42.8905, 35.541>, <-2.7579, 46.7487, 34.163>, <3.3117, 39.6802, 29.1816> }
			triangle { <1.1141, 46.7212, 40.1998>, <-2.7579, 46.7487, 34.163>, <3.5264, 42.8905, 35.541> }
			triangle { <3.5694, 45.1016, 40.6392>, <1.1141, 46.7212, 40.1998>, <3.5264, 42.8905, 35.541> }
			triangle { <3.5694, 45.1016, 40.6392>, <3.2044, 45.9201, 45.1333>, <1.1141, 46.7212, 40.1998> }
			triangle { <-2.7579, 46.7487, 34.163>, <-3.04312, 49.6515, 39.9331>, <-8.9035, 47.2637, 38.3528> }
			triangle { <-3.04312, 49.6515, 39.9331>, <-5.0653, 48.3978, 45.8245>, <-8.9035, 47.2637, 38.3528> }
			triangle { <3.2044, 45.9201, 45.1333>, <5.2223, 44.4249, 53.7606>, <1.9849, 45.8862, 53.3964> }
			triangle { <5.2223, 44.4249, 53.7606>, <0.573, 43.7916, 57.9512>, <1.9849, 45.8862, 53.3964> }
			triangle { <3.2044, 45.9201, 45.1333>, <1.9849, 45.8862, 53.3964>, <-1.3356, 46.9804, 52.7076> }
			triangle { <1.9849, 45.8862, 53.3964>, <0.573, 43.7916, 57.9512>, <-1.3356, 46.9804, 52.7076> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.09184, 1.3509, 0.09689>, <0.1889, 2.1788, 0.06427>, 0.3888 }
			cylinder { <0.1889, 2.1788, 0.06427>, <0.2861, 3.00686, 0.03164>, 0.3888 }
			cylinder { <0.2861, 3.00686, 0.03164>, <0.3832, 3.8348, -0.0009761>, 0.3888 }
			cylinder { <0.3832, 3.8348, -0.0009761>, <0.4803, 4.6627, -0.0336>, 0.3888 }
			cylinder { <0.4803, 4.6627, -0.0336>, <0.5775, 5.4907, -0.06622>, 0.3888 }
			cylinder { <0.5775, 5.4907, -0.06622>, <0.6746, 6.3187, -0.09884>, 0.3888 }
			cylinder { <0.6746, 6.3187, -0.09884>, <0.7718, 7.1467, -0.1314>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.7718, 7.1467, -0.1314>, <1.7918, 11.03853, -0.856>, 0.3888 }
				cylinder { <1.7918, 11.03853, -0.856>, <3.3167, 14.6155, -2.1174>, 0.3888 }
				cylinder { <3.3167, 14.6155, -2.1174>, <5.288, 17.7403, -3.8673>, 0.3888 }
				cylinder { <5.288, 17.7403, -3.8673>, <7.6297, 20.2927, -6.03829>, 0.3888 }
				cylinder { <7.6297, 20.2927, -6.03829>, <10.252, 22.1747, -8.5469>, 0.3888 }
				cylinder { <10.252, 22.1747, -8.5469>, <13.05403, 23.314, -11.2969>, 0.3888 }
				cylinder { <13.05403, 23.314, -11.2969>, <15.9281, 23.6667, -14.1826>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <15.9281, 23.6667, -14.1826>, <16.2215, 23.5372, -14.7683>, <16.305, 23.8131, -14.7745> }
					triangle { <16.2215, 23.5372, -14.7683>, <16.4774, 23.45, -15.2015>, <16.305, 23.8131, -14.7745> }
					triangle { <16.305, 23.8131, -14.7745>, <16.5704, 23.7053, -15.3855>, <16.6488, 23.9304, -15.2799> }
					triangle { <16.5704, 23.7053, -15.3855>, <16.3046, 24.04071, -16.2251>, <16.6488, 23.9304, -15.2799> }
					triangle { <16.305, 23.8131, -14.7745>, <16.4774, 23.45, -15.2015>, <16.5704, 23.7053, -15.3855> }
					triangle { <16.4774, 23.45, -15.2015>, <16.1825, 23.7742, -16.3176>, <16.5704, 23.7053, -15.3855> }
					triangle { <16.5704, 23.7053, -15.3855>, <16.1825, 23.7742, -16.3176>, <16.3046, 24.04071, -16.2251> }
					triangle { <16.6488, 23.9304, -15.2799>, <16.3046, 24.04071, -16.2251>, <16.3967, 24.4254, -16.1478> }
					triangle { <16.1825, 23.7742, -16.3176>, <16.2404, 23.9348, -16.9177>, <16.3046, 24.04071, -16.2251> }
					triangle { <16.2404, 23.9348, -16.9177>, <15.7765, 24.7696, -17.7088>, <16.4192, 24.2801, -16.8206> }
					triangle { <16.3046, 24.04071, -16.2251>, <16.2404, 23.9348, -16.9177>, <16.4192, 24.2801, -16.8206> }
					triangle { <16.3967, 24.4254, -16.1478>, <16.3046, 24.04071, -16.2251>, <16.4192, 24.2801, -16.8206> }
					triangle { <16.3967, 24.4254, -16.1478>, <16.4192, 24.2801, -16.8206>, <16.4808, 24.6611, -16.7127> }
					triangle { <16.4192, 24.2801, -16.8206>, <15.7765, 24.7696, -17.7088>, <15.6863, 25.4651, -17.8368> }
					triangle { <16.4808, 24.6611, -16.7127>, <16.4192, 24.2801, -16.8206>, <15.6863, 25.4651, -17.8368> }
					triangle { <16.305, 23.8131, -14.7745>, <16.4675, 23.9735, -14.5931>, <15.9281, 23.6667, -14.1826> }
					triangle { <16.305, 23.8131, -14.7745>, <16.6391, 24.2025, -14.8868>, <16.4675, 23.9735, -14.5931> }
					triangle { <16.6488, 23.9304, -15.2799>, <16.8288, 24.05707, -15.1468>, <16.305, 23.8131, -14.7745> }
					triangle { <16.6488, 23.9304, -15.2799>, <16.5293, 24.704, -15.9817>, <16.8288, 24.05707, -15.1468> }
					triangle { <16.8288, 24.05707, -15.1468>, <16.6391, 24.2025, -14.8868>, <16.305, 23.8131, -14.7745> }
					triangle { <16.8288, 24.05707, -15.1468>, <16.6269, 25.05029, -15.719>, <16.6391, 24.2025, -14.8868> }
					triangle { <16.5293, 24.704, -15.9817>, <16.6269, 25.05029, -15.719>, <16.8288, 24.05707, -15.1468> }
					triangle { <16.3967, 24.4254, -16.1478>, <16.5293, 24.704, -15.9817>, <16.6488, 23.9304, -15.2799> }
					triangle { <16.5293, 24.704, -15.9817>, <16.6506, 25.4005, -16.2685>, <16.6269, 25.05029, -15.719> }
					triangle { <16.5555, 25.07967, -16.5871>, <16.02181, 25.7981, -17.4004>, <16.6506, 25.4005, -16.2685> }
					triangle { <16.5555, 25.07967, -16.5871>, <16.6506, 25.4005, -16.2685>, <16.5293, 24.704, -15.9817> }
					triangle { <16.5555, 25.07967, -16.5871>, <16.5293, 24.704, -15.9817>, <16.3967, 24.4254, -16.1478> }
					triangle { <16.4808, 24.6611, -16.7127>, <16.5555, 25.07967, -16.5871>, <16.3967, 24.4254, -16.1478> }
					triangle { <15.6863, 25.4651, -17.8368>, <16.02181, 25.7981, -17.4004>, <16.5555, 25.07967, -16.5871> }
					triangle { <15.6863, 25.4651, -17.8368>, <16.5555, 25.07967, -16.5871>, <16.4808, 24.6611, -16.7127> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <15.9281, 23.6667, -14.1826>, <16.179, 23.8565, -14.7716>, <16.4316, 23.8963, -14.6383> }
					triangle { <16.179, 23.8565, -14.7716>, <16.396, 23.9751, -15.2183>, <16.4316, 23.8963, -14.6383> }
					triangle { <16.4316, 23.8963, -14.6383>, <16.6861, 24.1286, -15.2185>, <16.8703, 24.07614, -15.04155> }
					triangle { <16.6861, 24.1286, -15.2185>, <16.9685, 24.9981, -15.4468>, <16.8703, 24.07614, -15.04155> }
					triangle { <16.4316, 23.8963, -14.6383>, <16.396, 23.9751, -15.2183>, <16.6861, 24.1286, -15.2185> }
					triangle { <16.396, 23.9751, -15.2183>, <16.723, 25.05564, -15.6227>, <16.6861, 24.1286, -15.2185> }
					triangle { <16.6861, 24.1286, -15.2185>, <16.723, 25.05564, -15.6227>, <16.9685, 24.9981, -15.4468> }
					triangle { <16.8703, 24.07614, -15.04155>, <16.9685, 24.9981, -15.4468>, <17.2826, 25.00809, -15.1943> }
					triangle { <16.723, 25.05564, -15.6227>, <17.03046, 25.4961, -15.94>, <16.9685, 24.9981, -15.4468> }
					triangle { <17.03046, 25.4961, -15.94>, <17.5264, 26.615, -15.7403>, <17.3678, 25.4249, -15.7358> }
					triangle { <16.9685, 24.9981, -15.4468>, <17.03046, 25.4961, -15.94>, <17.3678, 25.4249, -15.7358> }
					triangle { <17.2826, 25.00809, -15.1943>, <16.9685, 24.9981, -15.4468>, <17.3678, 25.4249, -15.7358> }
					triangle { <17.2826, 25.00809, -15.1943>, <17.3678, 25.4249, -15.7358>, <17.6514, 25.431, -15.4527> }
					triangle { <17.3678, 25.4249, -15.7358>, <17.5264, 26.615, -15.7403>, <17.9958, 26.9842, -15.3508> }
					triangle { <17.6514, 25.431, -15.4527>, <17.3678, 25.4249, -15.7358>, <17.9958, 26.9842, -15.3508> }
					triangle { <16.4316, 23.8963, -14.6383>, <16.6049, 23.7167, -14.4877>, <15.9281, 23.6667, -14.1826> }
					triangle { <16.4316, 23.8963, -14.6383>, <16.9559, 23.8901, -14.6094>, <16.6049, 23.7167, -14.4877> }
					triangle { <16.8703, 24.07614, -15.04155>, <17.0435, 23.9089, -14.951>, <16.4316, 23.8963, -14.6383> }
					triangle { <16.8703, 24.07614, -15.04155>, <17.5245, 24.8957, -14.9671>, <17.0435, 23.9089, -14.951> }
					triangle { <17.0435, 23.9089, -14.951>, <16.9559, 23.8901, -14.6094>, <16.4316, 23.8963, -14.6383> }
					triangle { <17.0435, 23.9089, -14.951>, <17.7668, 24.7584, -14.6194>, <16.9559, 23.8901, -14.6094> }
					triangle { <17.5245, 24.8957, -14.9671>, <17.7668, 24.7584, -14.6194>, <17.0435, 23.9089, -14.951> }
					triangle { <17.2826, 25.00809, -15.1943>, <17.5245, 24.8957, -14.9671>, <16.8703, 24.07614, -15.04155> }
					triangle { <17.5245, 24.8957, -14.9671>, <18.1736, 25.2449, -14.7705>, <17.7668, 24.7584, -14.6194> }
					triangle { <17.9656, 25.4284, -15.14>, <18.3389, 26.5699, -14.9981>, <18.1736, 25.2449, -14.7705> }
					triangle { <17.9656, 25.4284, -15.14>, <18.1736, 25.2449, -14.7705>, <17.5245, 24.8957, -14.9671> }
					triangle { <17.9656, 25.4284, -15.14>, <17.5245, 24.8957, -14.9671>, <17.2826, 25.00809, -15.1943> }
					triangle { <17.6514, 25.431, -15.4527>, <17.9656, 25.4284, -15.14>, <17.2826, 25.00809, -15.1943> }
					triangle { <17.9958, 26.9842, -15.3508>, <18.3389, 26.5699, -14.9981>, <17.9656, 25.4284, -15.14> }
					triangle { <17.9958, 26.9842, -15.3508>, <17.9656, 25.4284, -15.14>, <17.6514, 25.431, -15.4527> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <15.9281, 23.6667, -14.1826>, <16.3794, 23.9873, -14.556>, <16.5382, 23.7467, -14.5504> }
					triangle { <16.3794, 23.9873, -14.556>, <16.7211, 24.2056, -14.8664>, <16.5382, 23.7467, -14.5504> }
					triangle { <16.5382, 23.7467, -14.5504>, <17.01982, 24.07236, -14.8931>, <17.05695, 23.8142, -14.8876> }
					triangle { <17.01982, 24.07236, -14.8931>, <17.8822, 24.3339, -14.6179>, <17.05695, 23.8142, -14.8876> }
					triangle { <16.5382, 23.7467, -14.5504>, <16.7211, 24.2056, -14.8664>, <17.01982, 24.07236, -14.8931> }
					triangle { <16.7211, 24.2056, -14.8664>, <17.8084, 24.6313, -14.5935>, <17.01982, 24.07236, -14.8931> }
					triangle { <17.01982, 24.07236, -14.8931>, <17.8084, 24.6313, -14.5935>, <17.8822, 24.3339, -14.6179> }
					triangle { <17.05695, 23.8142, -14.8876>, <17.8822, 24.3339, -14.6179>, <18.02911, 23.9606, -14.5788> }
					triangle { <17.8084, 24.6313, -14.5935>, <18.4047, 24.8036, -14.6558>, <17.8822, 24.3339, -14.6179> }
					triangle { <18.4047, 24.8036, -14.6558>, <19.4735, 24.7069, -14.03428>, <18.5215, 24.424, -14.7091> }
					triangle { <17.8822, 24.3339, -14.6179>, <18.4047, 24.8036, -14.6558>, <18.5215, 24.424, -14.7091> }
					triangle { <18.02911, 23.9606, -14.5788>, <17.8822, 24.3339, -14.6179>, <18.5215, 24.424, -14.7091> }
					triangle { <18.02911, 23.9606, -14.5788>, <18.5215, 24.424, -14.7091>, <18.6378, 24.04689, -14.6394> }
					triangle { <18.5215, 24.424, -14.7091>, <19.4735, 24.7069, -14.03428>, <19.942, 24.2532, -13.7462> }
					triangle { <18.6378, 24.04689, -14.6394>, <18.5215, 24.424, -14.7091>, <19.942, 24.2532, -13.7462> }
					triangle { <16.5382, 23.7467, -14.5504>, <16.4845, 23.4736, -14.6373>, <15.9281, 23.6667, -14.1826> }
					triangle { <16.5382, 23.7467, -14.5504>, <16.8687, 23.3946, -14.7569>, <16.4845, 23.4736, -14.6373> }
					triangle { <17.05695, 23.8142, -14.8876>, <17.02759, 23.5879, -15.00616>, <16.5382, 23.7467, -14.5504> }
					triangle { <17.05695, 23.8142, -14.8876>, <18.04832, 23.6114, -14.6024>, <17.02759, 23.5879, -15.00616> }
					triangle { <17.02759, 23.5879, -15.00616>, <16.8687, 23.3946, -14.7569>, <16.5382, 23.7467, -14.5504> }
					triangle { <17.02759, 23.5879, -15.00616>, <18.01879, 23.1688, -14.5627>, <16.8687, 23.3946, -14.7569> }
					triangle { <18.04832, 23.6114, -14.6024>, <18.01879, 23.1688, -14.5627>, <17.02759, 23.5879, -15.00616> }
					triangle { <18.02911, 23.9606, -14.5788>, <18.04832, 23.6114, -14.6024>, <17.05695, 23.8142, -14.8876> }
					triangle { <18.04832, 23.6114, -14.6024>, <18.6699, 23.1753, -14.5292>, <18.01879, 23.1688, -14.5627> }
					triangle { <18.7602, 23.6267, -14.5688>, <19.7799, 23.6553, -13.9192>, <18.6699, 23.1753, -14.5292> }
					triangle { <18.7602, 23.6267, -14.5688>, <18.6699, 23.1753, -14.5292>, <18.04832, 23.6114, -14.6024> }
					triangle { <18.7602, 23.6267, -14.5688>, <18.04832, 23.6114, -14.6024>, <18.02911, 23.9606, -14.5788> }
					triangle { <18.6378, 24.04689, -14.6394>, <18.7602, 23.6267, -14.5688>, <18.02911, 23.9606, -14.5788> }
					triangle { <19.942, 24.2532, -13.7462>, <19.7799, 23.6553, -13.9192>, <18.7602, 23.6267, -14.5688> }
					triangle { <19.942, 24.2532, -13.7462>, <18.7602, 23.6267, -14.5688>, <18.6378, 24.04689, -14.6394> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <15.9281, 23.6667, -14.1826>, <16.5476, 23.7501, -14.4175>, <16.4786, 23.5696, -14.6315> }
					triangle { <16.5476, 23.7501, -14.4175>, <17.00643, 23.8251, -14.6287>, <16.4786, 23.5696, -14.6315> }
					triangle { <16.4786, 23.5696, -14.6315>, <17.1134, 23.6137, -14.8558>, <16.9525, 23.5043, -15.02952> }
					triangle { <17.1134, 23.6137, -14.8558>, <17.7916, 22.9598, -14.8761>, <16.9525, 23.5043, -15.02952> }
					triangle { <16.4786, 23.5696, -14.6315>, <17.00643, 23.8251, -14.6287>, <17.1134, 23.6137, -14.8558> }
					triangle { <17.00643, 23.8251, -14.6287>, <17.9488, 23.08376, -14.6428>, <17.1134, 23.6137, -14.8558> }
					triangle { <17.1134, 23.6137, -14.8558>, <17.9488, 23.08376, -14.6428>, <17.7916, 22.9598, -14.8761> }
					triangle { <16.9525, 23.5043, -15.02952>, <17.7916, 22.9598, -14.8761>, <17.6116, 22.7208, -15.1462> }
					triangle { <17.9488, 23.08376, -14.6428>, <18.4769, 22.808, -14.8279>, <17.7916, 22.9598, -14.8761> }
					triangle { <18.4769, 22.808, -14.8279>, <18.9451, 21.6644, -14.9324>, <18.2967, 22.6513, -15.1497> }
					triangle { <17.7916, 22.9598, -14.8761>, <18.4769, 22.808, -14.8279>, <18.2967, 22.6513, -15.1497> }
					triangle { <17.6116, 22.7208, -15.1462>, <17.7916, 22.9598, -14.8761>, <18.2967, 22.6513, -15.1497> }
					triangle { <17.6116, 22.7208, -15.1462>, <18.2967, 22.6513, -15.1497>, <18.08616, 22.4085, -15.3891> }
					triangle { <18.2967, 22.6513, -15.1497>, <18.9451, 21.6644, -14.9324>, <18.8535, 21.02094, -15.2254> }
					triangle { <18.08616, 22.4085, -15.3891>, <18.2967, 22.6513, -15.1497>, <18.8535, 21.02094, -15.2254> }
					triangle { <16.4786, 23.5696, -14.6315>, <16.2715, 23.578, -14.8366>, <15.9281, 23.6667, -14.1826> }
					triangle { <16.4786, 23.5696, -14.6315>, <16.4971, 23.3961, -15.1269>, <16.2715, 23.578, -14.8366> }
					triangle { <16.9525, 23.5043, -15.02952>, <16.8029, 23.5346, -15.2364>, <16.4786, 23.5696, -14.6315> }
					triangle { <16.9525, 23.5043, -15.02952>, <17.3817, 22.6141, -15.3882>, <16.8029, 23.5346, -15.2364> }
					triangle { <16.8029, 23.5346, -15.2364>, <16.4971, 23.3961, -15.1269>, <16.4786, 23.5696, -14.6315> }
					triangle { <16.8029, 23.5346, -15.2364>, <17.03706, 22.4634, -15.6268>, <16.4971, 23.3961, -15.1269> }
					triangle { <17.3817, 22.6141, -15.3882>, <17.03706, 22.4634, -15.6268>, <16.8029, 23.5346, -15.2364> }
					triangle { <17.6116, 22.7208, -15.1462>, <17.3817, 22.6141, -15.3882>, <16.9525, 23.5043, -15.02952> }
					triangle { <17.3817, 22.6141, -15.3882>, <17.4581, 22.03245, -15.8758>, <17.03706, 22.4634, -15.6268> }
					triangle { <17.8487, 22.1475, -15.6575>, <18.3667, 21.05494, -15.6445>, <17.4581, 22.03245, -15.8758> }
					triangle { <17.8487, 22.1475, -15.6575>, <17.4581, 22.03245, -15.8758>, <17.3817, 22.6141, -15.3882> }
					triangle { <17.8487, 22.1475, -15.6575>, <17.3817, 22.6141, -15.3882>, <17.6116, 22.7208, -15.1462> }
					triangle { <18.08616, 22.4085, -15.3891>, <17.8487, 22.1475, -15.6575>, <17.6116, 22.7208, -15.1462> }
					triangle { <18.8535, 21.02094, -15.2254>, <18.3667, 21.05494, -15.6445>, <17.8487, 22.1475, -15.6575> }
					triangle { <18.8535, 21.02094, -15.2254>, <17.8487, 22.1475, -15.6575>, <18.08616, 22.4085, -15.3891> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <15.9281, 23.6667, -14.1826>, <16.4485, 23.4677, -14.5507>, <16.3323, 23.6113, -14.7721> }
					triangle { <16.4485, 23.4677, -14.5507>, <16.8535, 23.351, -14.839>, <16.3323, 23.6113, -14.7721> }
					triangle { <16.3323, 23.6113, -14.7721>, <16.8315, 23.3835, -15.1648>, <16.6965, 23.5772, -15.2756> }
					triangle { <16.8315, 23.3835, -15.1648>, <16.8018, 22.7758, -15.8844>, <16.6965, 23.5772, -15.2756> }
					triangle { <16.3323, 23.6113, -14.7721>, <16.8535, 23.351, -14.839>, <16.8315, 23.3835, -15.1648> }
					triangle { <16.8535, 23.351, -14.839>, <16.9287, 22.546, -15.7245>, <16.8315, 23.3835, -15.1648> }
					triangle { <16.8315, 23.3835, -15.1648>, <16.9287, 22.546, -15.7245>, <16.8018, 22.7758, -15.8844> }
					triangle { <16.6965, 23.5772, -15.2756>, <16.8018, 22.7758, -15.8844>, <16.5875, 23.01243, -16.1305> }
					triangle { <16.9287, 22.546, -15.7245>, <17.1191, 22.2629, -16.2469>, <16.8018, 22.7758, -15.8844> }
					triangle { <17.1191, 22.2629, -16.2469>, <16.6257, 21.7037, -17.2377>, <16.9778, 22.561, -16.4744> }
					triangle { <16.8018, 22.7758, -15.8844>, <17.1191, 22.2629, -16.2469>, <16.9778, 22.561, -16.4744> }
					triangle { <16.5875, 23.01243, -16.1305>, <16.8018, 22.7758, -15.8844>, <16.9778, 22.561, -16.4744> }
					triangle { <16.5875, 23.01243, -16.1305>, <16.9778, 22.561, -16.4744>, <16.7329, 22.7939, -16.6898> }
					triangle { <16.9778, 22.561, -16.4744>, <16.6257, 21.7037, -17.2377>, <16.1837, 21.7812, -17.7917> }
					triangle { <16.7329, 22.7939, -16.6898>, <16.9778, 22.561, -16.4744>, <16.1837, 21.7812, -17.7917> }
					triangle { <16.3323, 23.6113, -14.7721>, <16.2609, 23.8916, -14.8089>, <15.9281, 23.6667, -14.1826> }
					triangle { <16.3323, 23.6113, -14.7721>, <16.3531, 23.903, -15.2083>, <16.2609, 23.8916, -14.8089> }
					triangle { <16.6965, 23.5772, -15.2756>, <16.6782, 23.8289, -15.3246>, <16.3323, 23.6113, -14.7721> }
					triangle { <16.6965, 23.5772, -15.2756>, <16.4287, 23.2995, -16.2536>, <16.6782, 23.8289, -15.3246> }
					triangle { <16.6782, 23.8289, -15.3246>, <16.3531, 23.903, -15.2083>, <16.3323, 23.6113, -14.7721> }
					triangle { <16.6782, 23.8289, -15.3246>, <16.1638, 23.6438, -16.3522>, <16.3531, 23.903, -15.2083> }
					triangle { <16.4287, 23.2995, -16.2536>, <16.1638, 23.6438, -16.3522>, <16.6782, 23.8289, -15.3246> }
					triangle { <16.5875, 23.01243, -16.1305>, <16.4287, 23.2995, -16.2536>, <16.6965, 23.5772, -15.2756> }
					triangle { <16.4287, 23.2995, -16.2536>, <16.1913, 23.4284, -16.967>, <16.1638, 23.6438, -16.3522> }
					triangle { <16.4655, 23.05911, -16.9237>, <16.00908, 22.3992, -17.8285>, <16.1913, 23.4284, -16.967> }
					triangle { <16.4655, 23.05911, -16.9237>, <16.1913, 23.4284, -16.967>, <16.4287, 23.2995, -16.2536> }
					triangle { <16.4655, 23.05911, -16.9237>, <16.4287, 23.2995, -16.2536>, <16.5875, 23.01243, -16.1305> }
					triangle { <16.7329, 22.7939, -16.6898>, <16.4655, 23.05911, -16.9237>, <16.5875, 23.01243, -16.1305> }
					triangle { <16.1837, 21.7812, -17.7917>, <16.00908, 22.3992, -17.8285>, <16.4655, 23.05911, -16.9237> }
					triangle { <16.1837, 21.7812, -17.7917>, <16.4655, 23.05911, -16.9237>, <16.7329, 22.7939, -16.6898> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <0.7718, 7.1467, -0.1314>, <0.8689, 7.9746, -0.164>, 0.3888 }
			cylinder { <0.8689, 7.9746, -0.164>, <0.966, 8.8026, -0.1967>, 0.3888 }
			cylinder { <0.966, 8.8026, -0.1967>, <1.06322, 9.6306, -0.2293>, 0.3888 }
			cylinder { <1.06322, 9.6306, -0.2293>, <1.1603, 10.4585, -0.2619>, 0.3888 }
			cylinder { <1.1603, 10.4585, -0.2619>, <1.2574, 11.2865, -0.2945>, 0.3888 }
			cylinder { <1.2574, 11.2865, -0.2945>, <1.3546, 12.1145, -0.3272>, 0.3888 }
			cylinder { <1.3546, 12.1145, -0.3272>, <1.4517, 12.9425, -0.3598>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.4517, 12.9425, -0.3598>, <1.1279, 17.01613, -0.4714>, 0.3888 }
				cylinder { <1.1279, 17.01613, -0.4714>, <0.01687, 20.9497, -0.5305>, 0.3888 }
				cylinder { <0.01687, 20.9497, -0.5305>, <-1.8388, 24.5923, -0.5348>, 0.3888 }
				cylinder { <-1.8388, 24.5923, -0.5348>, <-4.3678, 27.8037, -0.4841>, 0.3888 }
				cylinder { <-4.3678, 27.8037, -0.4841>, <-7.473, 30.4606, -0.3805>, 0.3888 }
				cylinder { <-7.473, 30.4606, -0.3805>, <-11.035, 32.4608, -0.2277>, 0.3888 }
				cylinder { <-11.035, 32.4608, -0.2277>, <-14.9168, 33.7276, -0.03191>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-14.9168, 33.7276, -0.03191>, <-15.4927, 33.7374, 0.1827>, <-15.4938, 33.9989, 0.1378> }
					triangle { <-15.4927, 33.7374, 0.1827>, <-15.9425, 33.7585, 0.3174>, <-15.4938, 33.9989, 0.1378> }
					triangle { <-15.4938, 33.9989, 0.1378>, <-16.06205, 34.02698, 0.3872>, <-16.00266, 34.2272, 0.2689> }
					triangle { <-16.06205, 34.02698, 0.3872>, <-16.3252, 34.3974, 1.126>, <-16.00266, 34.2272, 0.2689> }
					triangle { <-15.4938, 33.9989, 0.1378>, <-15.9425, 33.7585, 0.3174>, <-16.06205, 34.02698, 0.3872> }
					triangle { <-15.9425, 33.7585, 0.3174>, <-16.3565, 34.1513, 1.2621>, <-16.06205, 34.02698, 0.3872> }
					triangle { <-16.06205, 34.02698, 0.3872>, <-16.3565, 34.1513, 1.2621>, <-16.3252, 34.3974, 1.126> }
					triangle { <-16.00266, 34.2272, 0.2689>, <-16.3252, 34.3974, 1.126>, <-16.2587, 34.7467, 1.02009> }
					triangle { <-16.3565, 34.1513, 1.2621>, <-16.7248, 34.3851, 1.6355>, <-16.3252, 34.3974, 1.126> }
					triangle { <-16.7248, 34.3851, 1.6355>, <-16.7233, 35.1648, 2.4693>, <-16.7117, 34.7104, 1.4619> }
					triangle { <-16.3252, 34.3974, 1.126>, <-16.7248, 34.3851, 1.6355>, <-16.7117, 34.7104, 1.4619> }
					triangle { <-16.2587, 34.7467, 1.02009>, <-16.3252, 34.3974, 1.126>, <-16.7117, 34.7104, 1.4619> }
					triangle { <-16.2587, 34.7467, 1.02009>, <-16.7117, 34.7104, 1.4619>, <-16.6072, 35.04733, 1.354> }
					triangle { <-16.7117, 34.7104, 1.4619>, <-16.7233, 35.1648, 2.4693>, <-16.5957, 35.7908, 2.619> }
					triangle { <-16.6072, 35.04733, 1.354>, <-16.7117, 34.7104, 1.4619>, <-16.5957, 35.7908, 2.619> }
					triangle { <-15.4938, 33.9989, 0.1378>, <-15.4576, 34.1445, -0.08474>, <-14.9168, 33.7276, -0.03191> }
					triangle { <-15.4938, 33.9989, 0.1378>, <-15.701, 34.4168, 0.01051>, <-15.4576, 34.1445, -0.08474> }
					triangle { <-16.00266, 34.2272, 0.2689>, <-16.01429, 34.3518, 0.06801>, <-15.4938, 33.9989, 0.1378> }
					triangle { <-16.00266, 34.2272, 0.2689>, <-16.1872, 34.9955, 0.8276>, <-16.01429, 34.3518, 0.06801> }
					triangle { <-16.01429, 34.3518, 0.06801>, <-15.701, 34.4168, 0.01051>, <-15.4938, 33.9989, 0.1378> }
					triangle { <-16.01429, 34.3518, 0.06801>, <-16.01998, 35.2863, 0.5919>, <-15.701, 34.4168, 0.01051> }
					triangle { <-16.1872, 34.9955, 0.8276>, <-16.01998, 35.2863, 0.5919>, <-16.01429, 34.3518, 0.06801> }
					triangle { <-16.2587, 34.7467, 1.02009>, <-16.1872, 34.9955, 0.8276>, <-16.00266, 34.2272, 0.2689> }
					triangle { <-16.1872, 34.9955, 0.8276>, <-16.2953, 35.6777, 0.954>, <-16.01998, 35.2863, 0.5919> }
					triangle { <-16.4928, 35.4176, 1.2264>, <-16.483, 36.08472, 2.1174>, <-16.2953, 35.6777, 0.954> }
					triangle { <-16.4928, 35.4176, 1.2264>, <-16.2953, 35.6777, 0.954>, <-16.1872, 34.9955, 0.8276> }
					triangle { <-16.4928, 35.4176, 1.2264>, <-16.1872, 34.9955, 0.8276>, <-16.2587, 34.7467, 1.02009> }
					triangle { <-16.6072, 35.04733, 1.354>, <-16.4928, 35.4176, 1.2264>, <-16.2587, 34.7467, 1.02009> }
					triangle { <-16.5957, 35.7908, 2.619>, <-16.483, 36.08472, 2.1174>, <-16.4928, 35.4176, 1.2264> }
					triangle { <-16.5957, 35.7908, 2.619>, <-16.4928, 35.4176, 1.2264>, <-16.6072, 35.04733, 1.354> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-14.9168, 33.7276, -0.03191>, <-15.3998, 34.01714, 0.2144>, <-15.4774, 34.07566, -0.03249> }
					triangle { <-15.3998, 34.01714, 0.2144>, <-15.789, 34.2183, 0.3845>, <-15.4774, 34.07566, -0.03249> }
					triangle { <-15.4774, 34.07566, -0.03249>, <-15.9486, 34.4026, 0.206>, <-15.9739, 34.3614, -0.02908> }
					triangle { <-15.9486, 34.4026, 0.206>, <-16.09139, 35.258, 0.1943>, <-15.9739, 34.3614, -0.02908> }
					triangle { <-15.4774, 34.07566, -0.03249>, <-15.789, 34.2183, 0.3845>, <-15.9486, 34.4026, 0.206> }
					triangle { <-15.789, 34.2183, 0.3845>, <-16.0239, 35.2936, 0.4668>, <-15.9486, 34.4026, 0.206> }
					triangle { <-15.9486, 34.4026, 0.206>, <-16.0239, 35.2936, 0.4668>, <-16.09139, 35.258, 0.1943> }
					triangle { <-15.9739, 34.3614, -0.02908>, <-16.09139, 35.258, 0.1943>, <-16.1436, 35.2836, -0.172> }
					triangle { <-16.0239, 35.2936, 0.4668>, <-16.327, 35.7805, 0.4959>, <-16.09139, 35.258, 0.1943> }
					triangle { <-16.327, 35.7805, 0.4959>, <-16.2992, 36.8364, 0.06333>, <-16.4409, 35.7436, 0.147> }
					triangle { <-16.09139, 35.258, 0.1943>, <-16.327, 35.7805, 0.4959>, <-16.4409, 35.7436, 0.147> }
					triangle { <-16.1436, 35.2836, -0.172>, <-16.09139, 35.258, 0.1943>, <-16.4409, 35.7436, 0.147> }
					triangle { <-16.1436, 35.2836, -0.172>, <-16.4409, 35.7436, 0.147>, <-16.4552, 35.7568, -0.2212> }
					triangle { <-16.4409, 35.7436, 0.147>, <-16.2992, 36.8364, 0.06333>, <-16.2957, 37.1906, -0.489> }
					triangle { <-16.4552, 35.7568, -0.2212>, <-16.4409, 35.7436, 0.147>, <-16.2957, 37.1906, -0.489> }
					triangle { <-15.4774, 34.07566, -0.03249>, <-15.5381, 33.9223, -0.2442>, <-14.9168, 33.7276, -0.03191> }
					triangle { <-15.4774, 34.07566, -0.03249>, <-15.8075, 34.1506, -0.3777>, <-15.5381, 33.9223, -0.2442> }
					triangle { <-15.9739, 34.3614, -0.02908>, <-16.06841, 34.2273, -0.1996>, <-15.4774, 34.07566, -0.03249> }
					triangle { <-15.9739, 34.3614, -0.02908>, <-16.1892, 35.1914, -0.4777>, <-16.06841, 34.2273, -0.1996> }
					triangle { <-16.06841, 34.2273, -0.1996>, <-15.8075, 34.1506, -0.3777>, <-15.4774, 34.07566, -0.03249> }
					triangle { <-16.06841, 34.2273, -0.1996>, <-16.1671, 35.0607, -0.8657>, <-15.8075, 34.1506, -0.3777> }
					triangle { <-16.1892, 35.1914, -0.4777>, <-16.1671, 35.0607, -0.8657>, <-16.06841, 34.2273, -0.1996> }
					triangle { <-16.1436, 35.2836, -0.172>, <-16.1892, 35.1914, -0.4777>, <-15.9739, 34.3614, -0.02908> }
					triangle { <-16.1892, 35.1914, -0.4777>, <-16.4255, 35.5825, -1.01088>, <-16.1671, 35.0607, -0.8657> }
					triangle { <-16.4737, 35.7631, -0.6288>, <-16.3952, 36.8272, -0.9458>, <-16.4255, 35.5825, -1.01088> }
					triangle { <-16.4737, 35.7631, -0.6288>, <-16.4255, 35.5825, -1.01088>, <-16.1892, 35.1914, -0.4777> }
					triangle { <-16.4737, 35.7631, -0.6288>, <-16.1892, 35.1914, -0.4777>, <-16.1436, 35.2836, -0.172> }
					triangle { <-16.4552, 35.7568, -0.2212>, <-16.4737, 35.7631, -0.6288>, <-16.1436, 35.2836, -0.172> }
					triangle { <-16.2957, 37.1906, -0.489>, <-16.3952, 36.8272, -0.9458>, <-16.4737, 35.7631, -0.6288> }
					triangle { <-16.2957, 37.1906, -0.489>, <-16.4737, 35.7631, -0.6288>, <-16.4552, 35.7568, -0.2212> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-14.9168, 33.7276, -0.03191>, <-15.374, 34.1377, -0.05514>, <-15.5259, 33.9469, -0.1599> }
					triangle { <-15.374, 34.1377, -0.05514>, <-15.7421, 34.43, -0.05421>, <-15.5259, 33.9469, -0.1599> }
					triangle { <-15.5259, 33.9469, -0.1599>, <-15.9834, 34.3622, -0.2228>, <-16.05868, 34.1361, -0.252> }
					triangle { <-15.9834, 34.3622, -0.2228>, <-16.3313, 34.6986, -0.9426>, <-16.05868, 34.1361, -0.252> }
					triangle { <-15.5259, 33.9469, -0.1599>, <-15.7421, 34.43, -0.05421>, <-15.9834, 34.3622, -0.2228> }
					triangle { <-15.7421, 34.43, -0.05421>, <-16.2055, 34.95, -0.9104>, <-15.9834, 34.3622, -0.2228> }
					triangle { <-15.9834, 34.3622, -0.2228>, <-16.2055, 34.95, -0.9104>, <-16.3313, 34.6986, -0.9426> }
					triangle { <-16.05868, 34.1361, -0.252>, <-16.3313, 34.6986, -0.9426>, <-16.4827, 34.3824, -1.06394> }
					triangle { <-16.2055, 34.95, -0.9104>, <-16.601, 35.2088, -1.2365>, <-16.3313, 34.6986, -0.9426> }
					triangle { <-16.601, 35.2088, -1.2365>, <-16.9501, 35.2108, -2.3233>, <-16.7898, 34.8945, -1.2766> }
					triangle { <-16.3313, 34.6986, -0.9426>, <-16.601, 35.2088, -1.2365>, <-16.7898, 34.8945, -1.2766> }
					triangle { <-16.4827, 34.3824, -1.06394>, <-16.3313, 34.6986, -0.9426>, <-16.7898, 34.8945, -1.2766> }
					triangle { <-16.4827, 34.3824, -1.06394>, <-16.7898, 34.8945, -1.2766>, <-16.9033, 34.5658, -1.3998> }
					triangle { <-16.7898, 34.8945, -1.2766>, <-16.9501, 35.2108, -2.3233>, <-17.1798, 34.841, -2.8143> }
					triangle { <-16.9033, 34.5658, -1.3998>, <-16.7898, 34.8945, -1.2766>, <-17.1798, 34.841, -2.8143> }
					triangle { <-15.5259, 33.9469, -0.1599>, <-15.6002, 33.7051, -0.07016>, <-14.9168, 33.7276, -0.03191> }
					triangle { <-15.5259, 33.9469, -0.1599>, <-15.943, 33.7122, -0.2281>, <-15.6002, 33.7051, -0.07016> }
					triangle { <-16.05868, 34.1361, -0.252>, <-16.1584, 33.9444, -0.1555>, <-15.5259, 33.9469, -0.1599> }
					triangle { <-16.05868, 34.1361, -0.252>, <-16.5828, 34.07576, -1.06329>, <-16.1584, 33.9444, -0.1555> }
					triangle { <-16.1584, 33.9444, -0.1555>, <-15.943, 33.7122, -0.2281>, <-15.5259, 33.9469, -0.1599> }
					triangle { <-16.1584, 33.9444, -0.1555>, <-16.6319, 33.6689, -1.07623>, <-15.943, 33.7122, -0.2281> }
					triangle { <-16.5828, 34.07576, -1.06329>, <-16.6319, 33.6689, -1.07623>, <-16.1584, 33.9444, -0.1555> }
					triangle { <-16.4827, 34.3824, -1.06394>, <-16.5828, 34.07576, -1.06329>, <-16.05868, 34.1361, -0.252> }
					triangle { <-16.5828, 34.07576, -1.06329>, <-17.0402, 33.7751, -1.5031>, <-16.6319, 33.6689, -1.07623> }
					triangle { <-17.02935, 34.1995, -1.5279>, <-17.3028, 34.3021, -2.602>, <-17.0402, 33.7751, -1.5031> }
					triangle { <-17.02935, 34.1995, -1.5279>, <-17.0402, 33.7751, -1.5031>, <-16.5828, 34.07576, -1.06329> }
					triangle { <-17.02935, 34.1995, -1.5279>, <-16.5828, 34.07576, -1.06329>, <-16.4827, 34.3824, -1.06394> }
					triangle { <-16.9033, 34.5658, -1.3998>, <-17.02935, 34.1995, -1.5279>, <-16.4827, 34.3824, -1.06394> }
					triangle { <-17.1798, 34.841, -2.8143>, <-17.3028, 34.3021, -2.602>, <-17.02935, 34.1995, -1.5279> }
					triangle { <-17.1798, 34.841, -2.8143>, <-17.02935, 34.1995, -1.5279>, <-16.9033, 34.5658, -1.3998> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-14.9168, 33.7276, -0.03191>, <-15.4508, 33.9336, -0.256>, <-15.5727, 33.7894, -0.06953> }
					triangle { <-15.4508, 33.9336, -0.256>, <-15.8661, 34.103, -0.3965>, <-15.5727, 33.7894, -0.06953> }
					triangle { <-15.5727, 33.7894, -0.06953>, <-16.1187, 33.9613, -0.3107>, <-16.1406, 33.8606, -0.09391> }
					triangle { <-16.1187, 33.9613, -0.3107>, <-16.7156, 33.487, -0.7243>, <-16.1406, 33.8606, -0.09391> }
					triangle { <-15.5727, 33.7894, -0.06953>, <-15.8661, 34.103, -0.3965>, <-16.1187, 33.9613, -0.3107> }
					triangle { <-15.8661, 34.103, -0.3965>, <-16.6521, 33.5921, -0.9791>, <-16.1187, 33.9613, -0.3107> }
					triangle { <-16.1187, 33.9613, -0.3107>, <-16.6521, 33.5921, -0.9791>, <-16.7156, 33.487, -0.7243> }
					triangle { <-16.1406, 33.8606, -0.09391>, <-16.7156, 33.487, -0.7243>, <-16.8105, 33.2801, -0.4313> }
					triangle { <-16.6521, 33.5921, -0.9791>, <-17.1707, 33.4549, -1.184>, <-16.7156, 33.487, -0.7243> }
					triangle { <-17.1707, 33.4549, -1.184>, <-17.7826, 32.5192, -1.4147>, <-17.2796, 33.3286, -0.8549> }
					triangle { <-16.7156, 33.487, -0.7243>, <-17.1707, 33.4549, -1.184>, <-17.2796, 33.3286, -0.8549> }
					triangle { <-16.8105, 33.2801, -0.4313>, <-16.7156, 33.487, -0.7243>, <-17.2796, 33.3286, -0.8549> }
					triangle { <-16.8105, 33.2801, -0.4313>, <-17.2796, 33.3286, -0.8549>, <-17.3364, 33.1092, -0.5639> }
					triangle { <-17.2796, 33.3286, -0.8549>, <-17.7826, 32.5192, -1.4147>, <-18.03448, 31.9671, -1.1651> }
					triangle { <-17.3364, 33.1092, -0.5639>, <-17.2796, 33.3286, -0.8549>, <-18.03448, 31.9671, -1.1651> }
					triangle { <-15.5727, 33.7894, -0.06953>, <-15.5586, 33.7911, 0.1984>, <-14.9168, 33.7276, -0.03191> }
					triangle { <-15.5727, 33.7894, -0.06953>, <-15.9215, 33.7034, 0.2539>, <-15.5586, 33.7911, 0.1984> }
					triangle { <-16.1406, 33.8606, -0.09391>, <-16.1608, 33.8914, 0.1398>, <-15.5727, 33.7894, -0.06953> }
					triangle { <-16.1406, 33.8606, -0.09391>, <-16.8278, 33.1799, -0.1252>, <-16.1608, 33.8914, 0.1398> }
					triangle { <-16.1608, 33.8914, 0.1398>, <-15.9215, 33.7034, 0.2539>, <-15.5727, 33.7894, -0.06953> }
					triangle { <-16.1608, 33.8914, 0.1398>, <-16.7763, 33.02143, 0.2493>, <-15.9215, 33.7034, 0.2539> }
					triangle { <-16.8278, 33.1799, -0.1252>, <-16.7763, 33.02143, 0.2493>, <-16.1608, 33.8914, 0.1398> }
					triangle { <-16.8105, 33.2801, -0.4313>, <-16.8278, 33.1799, -0.1252>, <-16.1406, 33.8606, -0.09391> }
					triangle { <-16.8278, 33.1799, -0.1252>, <-17.2956, 32.7363, 0.153>, <-16.7763, 33.02143, 0.2493> }
					triangle { <-17.397, 32.8731, -0.2367>, <-17.9599, 31.9754, -0.5777>, <-17.2956, 32.7363, 0.153> }
					triangle { <-17.397, 32.8731, -0.2367>, <-17.2956, 32.7363, 0.153>, <-16.8278, 33.1799, -0.1252> }
					triangle { <-17.397, 32.8731, -0.2367>, <-16.8278, 33.1799, -0.1252>, <-16.8105, 33.2801, -0.4313> }
					triangle { <-17.3364, 33.1092, -0.5639>, <-17.397, 32.8731, -0.2367>, <-16.8105, 33.2801, -0.4313> }
					triangle { <-18.03448, 31.9671, -1.1651>, <-17.9599, 31.9754, -0.5777>, <-17.397, 32.8731, -0.2367> }
					triangle { <-18.03448, 31.9671, -1.1651>, <-17.397, 32.8731, -0.2367>, <-17.3364, 33.1092, -0.5639> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-14.9168, 33.7276, -0.03191>, <-15.5252, 33.6824, -0.1067>, <-15.5526, 33.8221, 0.1172> }
					triangle { <-15.5252, 33.6824, -0.1067>, <-15.9918, 33.6817, -0.1633>, <-15.5526, 33.8221, 0.1172> }
					triangle { <-15.5526, 33.8221, 0.1172>, <-16.168, 33.7509, 0.07199>, <-16.1054, 33.9177, 0.2329> }
					triangle { <-16.168, 33.7509, 0.07199>, <-16.7118, 33.298, 0.5734>, <-16.1054, 33.9177, 0.2329> }
					triangle { <-15.5526, 33.8221, 0.1172>, <-15.9918, 33.6817, -0.1633>, <-16.168, 33.7509, 0.07199> }
					triangle { <-15.9918, 33.6817, -0.1633>, <-16.7468, 33.09114, 0.3837>, <-16.168, 33.7509, 0.07199> }
					triangle { <-16.168, 33.7509, 0.07199>, <-16.7468, 33.09114, 0.3837>, <-16.7118, 33.298, 0.5734> }
					triangle { <-16.1054, 33.9177, 0.2329>, <-16.7118, 33.298, 0.5734>, <-16.67, 33.5086, 0.8761> }
					triangle { <-16.7468, 33.09114, 0.3837>, <-17.2484, 32.9381, 0.6178>, <-16.7118, 33.298, 0.5734> }
					triangle { <-17.2484, 32.9381, 0.6178>, <-17.6403, 32.4904, 1.592>, <-17.2306, 33.2131, 0.8631> }
					triangle { <-16.7118, 33.298, 0.5734>, <-17.2484, 32.9381, 0.6178>, <-17.2306, 33.2131, 0.8631> }
					triangle { <-16.67, 33.5086, 0.8761>, <-16.7118, 33.298, 0.5734>, <-17.2306, 33.2131, 0.8631> }
					triangle { <-16.67, 33.5086, 0.8761>, <-17.2306, 33.2131, 0.8631>, <-17.1507, 33.4113, 1.1637> }
					triangle { <-17.2306, 33.2131, 0.8631>, <-17.6403, 32.4904, 1.592>, <-17.668, 32.563, 2.2435> }
					triangle { <-17.1507, 33.4113, 1.1637>, <-17.2306, 33.2131, 0.8631>, <-17.668, 32.563, 2.2435> }
					triangle { <-15.5526, 33.8221, 0.1172>, <-15.4691, 34.06678, 0.1893>, <-14.9168, 33.7276, -0.03191> }
					triangle { <-15.5526, 33.8221, 0.1172>, <-15.7697, 34.1454, 0.4036>, <-15.4691, 34.06678, 0.1893> }
					triangle { <-16.1054, 33.9177, 0.2329>, <-16.07042, 34.147, 0.2801>, <-15.5526, 33.8221, 0.1172> }
					triangle { <-16.1054, 33.9177, 0.2329>, <-16.5796, 33.757, 1.06109>, <-16.07042, 34.147, 0.2801> }
					triangle { <-16.07042, 34.147, 0.2801>, <-15.7697, 34.1454, 0.4036>, <-15.5526, 33.8221, 0.1172> }
					triangle { <-16.07042, 34.147, 0.2801>, <-16.3924, 34.03613, 1.2959>, <-15.7697, 34.1454, 0.4036> }
					triangle { <-16.5796, 33.757, 1.06109>, <-16.3924, 34.03613, 1.2959>, <-16.07042, 34.147, 0.2801> }
					triangle { <-16.67, 33.5086, 0.8761>, <-16.5796, 33.757, 1.06109>, <-16.1054, 33.9177, 0.2329> }
					triangle { <-16.5796, 33.757, 1.06109>, <-16.8283, 33.9299, 1.6945>, <-16.3924, 34.03613, 1.2959> }
					triangle { <-17.06047, 33.6372, 1.4912>, <-17.4456, 33.09378, 2.383>, <-16.8283, 33.9299, 1.6945> }
					triangle { <-17.06047, 33.6372, 1.4912>, <-16.8283, 33.9299, 1.6945>, <-16.5796, 33.757, 1.06109> }
					triangle { <-17.06047, 33.6372, 1.4912>, <-16.5796, 33.757, 1.06109>, <-16.67, 33.5086, 0.8761> }
					triangle { <-17.1507, 33.4113, 1.1637>, <-17.06047, 33.6372, 1.4912>, <-16.67, 33.5086, 0.8761> }
					triangle { <-17.668, 32.563, 2.2435>, <-17.4456, 33.09378, 2.383>, <-17.06047, 33.6372, 1.4912> }
					triangle { <-17.668, 32.563, 2.2435>, <-17.06047, 33.6372, 1.4912>, <-17.1507, 33.4113, 1.1637> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <1.4517, 12.9425, -0.3598>, <1.5489, 13.7704, -0.3924>, 0.3888 }
			cylinder { <1.5489, 13.7704, -0.3924>, <1.646, 14.5984, -0.425>, 0.3888 }
			cylinder { <1.646, 14.5984, -0.425>, <1.7431, 15.4264, -0.4577>, 0.3888 }
			cylinder { <1.7431, 15.4264, -0.4577>, <1.8403, 16.2543, -0.4903>, 0.3888 }
			cylinder { <1.8403, 16.2543, -0.4903>, <1.9374, 17.08234, -0.5229>, 0.3888 }
			cylinder { <1.9374, 17.08234, -0.5229>, <2.03459, 17.9103, -0.5555>, 0.3888 }
			cylinder { <2.03459, 17.9103, -0.5555>, <2.1317, 18.7382, -0.5882>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.1317, 18.7382, -0.5882>, <3.2169, 22.6645, -0.2441>, 0.3888 }
				cylinder { <3.2169, 22.6645, -0.2441>, <4.8697, 26.3091, 0.5906>, 0.3888 }
				cylinder { <4.8697, 26.3091, 0.5906>, <7.02652, 29.5321, 1.884>, 0.3888 }
				cylinder { <7.02652, 29.5321, 1.884>, <9.6044, 32.2094, 3.5863>, 0.3888 }
				cylinder { <9.6044, 32.2094, 3.5863>, <12.5044, 34.2383, 5.6321>, 0.3888 }
				cylinder { <12.5044, 34.2383, 5.6321>, <15.6151, 35.5407, 7.9428>, 0.3888 }
				cylinder { <15.6151, 35.5407, 7.9428>, <18.8168, 36.06675, 10.4295>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <18.8168, 36.06675, 10.4295>, <19.3735, 35.9442, 10.6595>, <19.4042, 36.2052, 10.6963> }
					triangle { <19.3735, 35.9442, 10.6595>, <19.7897, 35.8664, 10.8637>, <19.4042, 36.2052, 10.6963> }
					triangle { <19.4042, 36.2052, 10.6963>, <19.9824, 36.09685, 10.8956>, <19.9075, 36.3195, 10.945> }
					triangle { <19.9824, 36.09685, 10.8956>, <20.742, 36.3038, 10.5315>, <19.9075, 36.3195, 10.945> }
					triangle { <19.4042, 36.2052, 10.6963>, <19.7897, 35.8664, 10.8637>, <19.9824, 36.09685, 10.8956> }
					triangle { <19.7897, 35.8664, 10.8637>, <20.7981, 36.03896, 10.4496>, <19.9824, 36.09685, 10.8956> }
					triangle { <19.9824, 36.09685, 10.8956>, <20.7981, 36.03896, 10.4496>, <20.742, 36.3038, 10.5315> }
					triangle { <19.9075, 36.3195, 10.945>, <20.742, 36.3038, 10.5315>, <20.704, 36.671, 10.5686> }
					triangle { <20.7981, 36.03896, 10.4496>, <21.3614, 36.1477, 10.4248>, <20.742, 36.3038, 10.5315> }
					triangle { <21.3614, 36.1477, 10.4248>, <22.08677, 36.7856, 9.8165>, <21.3117, 36.492, 10.5476> }
					triangle { <20.742, 36.3038, 10.5315>, <21.3614, 36.1477, 10.4248>, <21.3117, 36.492, 10.5476> }
					triangle { <20.704, 36.671, 10.5686>, <20.742, 36.3038, 10.5315>, <21.3117, 36.492, 10.5476> }
					triangle { <20.704, 36.671, 10.5686>, <21.3117, 36.492, 10.5476>, <21.2423, 36.8541, 10.5603> }
					triangle { <21.3117, 36.492, 10.5476>, <22.08677, 36.7856, 9.8165>, <22.2362, 37.3957, 9.6266> }
					triangle { <21.2423, 36.8541, 10.5603>, <21.3117, 36.492, 10.5476>, <22.2362, 37.3957, 9.6266> }
					triangle { <19.4042, 36.2052, 10.6963>, <19.2648, 36.3858, 10.8377>, <18.8168, 36.06675, 10.4295> }
					triangle { <19.4042, 36.2052, 10.6963>, <19.564, 36.5944, 10.9344>, <19.2648, 36.3858, 10.8377> }
					triangle { <19.9075, 36.3195, 10.945>, <19.8118, 36.468, 11.1025>, <19.4042, 36.2052, 10.6963> }
					triangle { <19.9075, 36.3195, 10.945>, <20.5826, 36.9539, 10.6652>, <19.8118, 36.468, 11.1025> }
					triangle { <19.8118, 36.468, 11.1025>, <19.564, 36.5944, 10.9344>, <19.4042, 36.2052, 10.6963> }
					triangle { <19.8118, 36.468, 11.1025>, <20.3735, 37.3006, 10.7295>, <19.564, 36.5944, 10.9344> }
					triangle { <20.5826, 36.9539, 10.6652>, <20.3735, 37.3006, 10.7295>, <19.8118, 36.468, 11.1025> }
					triangle { <20.704, 36.671, 10.5686>, <20.5826, 36.9539, 10.6652>, <19.9075, 36.3195, 10.945> }
					triangle { <20.5826, 36.9539, 10.6652>, <20.8985, 37.5808, 10.652>, <20.3735, 37.3006, 10.7295> }
					triangle { <21.1604, 37.2532, 10.5813>, <21.8919, 37.7747, 9.9239>, <20.8985, 37.5808, 10.652> }
					triangle { <21.1604, 37.2532, 10.5813>, <20.8985, 37.5808, 10.652>, <20.5826, 36.9539, 10.6652> }
					triangle { <21.1604, 37.2532, 10.5813>, <20.5826, 36.9539, 10.6652>, <20.704, 36.671, 10.5686> }
					triangle { <21.2423, 36.8541, 10.5603>, <21.1604, 37.2532, 10.5813>, <20.704, 36.671, 10.5686> }
					triangle { <22.2362, 37.3957, 9.6266>, <21.8919, 37.7747, 9.9239>, <21.1604, 37.2532, 10.5813> }
					triangle { <22.2362, 37.3957, 9.6266>, <21.1604, 37.2532, 10.5813>, <21.2423, 36.8541, 10.5603> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <18.8168, 36.06675, 10.4295>, <19.3914, 36.2282, 10.5764>, <19.2977, 36.3076, 10.8117> }
					triangle { <19.3914, 36.2282, 10.5764>, <19.8283, 36.3313, 10.7155>, <19.2977, 36.3076, 10.8117> }
					triangle { <19.2977, 36.3076, 10.8117>, <19.8672, 36.5088, 10.9568>, <19.7211, 36.4986, 11.1471> }
					triangle { <19.8672, 36.5088, 10.9568>, <20.1565, 37.3186, 11.07087>, <19.7211, 36.4986, 11.1471> }
					triangle { <19.2977, 36.3076, 10.8117>, <19.8283, 36.3313, 10.7155>, <19.8672, 36.5088, 10.9568> }
					triangle { <19.8283, 36.3313, 10.7155>, <20.2956, 37.3253, 10.8246>, <19.8672, 36.5088, 10.9568> }
					triangle { <19.8672, 36.5088, 10.9568>, <20.2956, 37.3253, 10.8246>, <20.1565, 37.3186, 11.07087> }
					triangle { <19.7211, 36.4986, 11.1471>, <20.1565, 37.3186, 11.07087>, <19.9585, 37.3877, 11.3769> }
					triangle { <20.2956, 37.3253, 10.8246>, <20.643, 37.7421, 11.01268>, <20.1565, 37.3186, 11.07087> }
					triangle { <20.643, 37.7421, 11.01268>, <20.5782, 38.8382, 11.3245>, <20.4865, 37.7371, 11.3466> }
					triangle { <20.1565, 37.3186, 11.07087>, <20.643, 37.7421, 11.01268>, <20.4865, 37.7371, 11.3466> }
					triangle { <19.9585, 37.3877, 11.3769>, <20.1565, 37.3186, 11.07087>, <20.4865, 37.7371, 11.3466> }
					triangle { <19.9585, 37.3877, 11.3769>, <20.4865, 37.7371, 11.3466>, <20.2572, 37.8011, 11.6284> }
					triangle { <20.4865, 37.7371, 11.3466>, <20.5782, 38.8382, 11.3245>, <20.2925, 39.2642, 11.7338> }
					triangle { <20.2572, 37.8011, 11.6284>, <20.4865, 37.7371, 11.3466>, <20.2925, 39.2642, 11.7338> }
					triangle { <19.2977, 36.3076, 10.8117>, <19.167, 36.1785, 11.00741>, <18.8168, 36.06675, 10.4295> }
					triangle { <19.2977, 36.3076, 10.8117>, <19.3242, 36.3732, 11.29>, <19.167, 36.1785, 11.00741> }
					triangle { <19.7211, 36.4986, 11.1471>, <19.6461, 36.3764, 11.3353>, <19.2977, 36.3076, 10.8117> }
					triangle { <19.7211, 36.4986, 11.1471>, <19.7688, 37.3345, 11.6323>, <19.6461, 36.3764, 11.3353> }
					triangle { <19.6461, 36.3764, 11.3353>, <19.3242, 36.3732, 11.29>, <19.2977, 36.3076, 10.8117> }
					triangle { <19.6461, 36.3764, 11.3353>, <19.4678, 37.2676, 11.9025>, <19.3242, 36.3732, 11.29> }
					triangle { <19.7688, 37.3345, 11.6323>, <19.4678, 37.2676, 11.9025>, <19.6461, 36.3764, 11.3353> }
					triangle { <19.9585, 37.3877, 11.3769>, <19.7688, 37.3345, 11.6323>, <19.7211, 36.4986, 11.1471> }
					triangle { <19.7688, 37.3345, 11.6323>, <19.6762, 37.7517, 12.1895>, <19.4678, 37.2676, 11.9025> }
					triangle { <20.00354, 37.8634, 11.9418>, <19.9805, 38.9595, 12.1343>, <19.6762, 37.7517, 12.1895> }
					triangle { <20.00354, 37.8634, 11.9418>, <19.6762, 37.7517, 12.1895>, <19.7688, 37.3345, 11.6323> }
					triangle { <20.00354, 37.8634, 11.9418>, <19.7688, 37.3345, 11.6323>, <19.9585, 37.3877, 11.3769> }
					triangle { <20.2572, 37.8011, 11.6284>, <20.00354, 37.8634, 11.9418>, <19.9585, 37.3877, 11.3769> }
					triangle { <20.2925, 39.2642, 11.7338>, <19.9805, 38.9595, 12.1343>, <20.00354, 37.8634, 11.9418> }
					triangle { <20.2925, 39.2642, 11.7338>, <20.00354, 37.8634, 11.9418>, <20.2572, 37.8011, 11.6284> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <18.8168, 36.06675, 10.4295>, <19.2228, 36.3895, 10.7594>, <19.2193, 36.1924, 10.9371> }
					triangle { <19.2228, 36.3895, 10.7594>, <19.5539, 36.6096, 11.01007>, <19.2193, 36.1924, 10.9371> }
					triangle { <19.2193, 36.1924, 10.9371>, <19.6006, 36.5259, 11.2965>, <19.5838, 36.2969, 11.3665> }
					triangle { <19.6006, 36.5259, 11.2965>, <19.4526, 36.8976, 12.0662>, <19.5838, 36.2969, 11.3665> }
					triangle { <19.2193, 36.1924, 10.9371>, <19.5539, 36.6096, 11.01007>, <19.6006, 36.5259, 11.2965> }
					triangle { <19.5539, 36.6096, 11.01007>, <19.4407, 37.1597, 11.9602>, <19.6006, 36.5259, 11.2965> }
					triangle { <19.6006, 36.5259, 11.2965>, <19.4407, 37.1597, 11.9602>, <19.4526, 36.8976, 12.0662> }
					triangle { <19.5838, 36.2969, 11.3665>, <19.4526, 36.8976, 12.0662>, <19.4094, 36.5808, 12.2545> }
					triangle { <19.4407, 37.1597, 11.9602>, <19.5685, 37.39, 12.4705>, <19.4526, 36.8976, 12.0662> }
					triangle { <19.5685, 37.39, 12.4705>, <19.1037, 37.4893, 13.5083>, <19.6061, 37.05683, 12.6241> }
					triangle { <19.4526, 36.8976, 12.0662>, <19.5685, 37.39, 12.4705>, <19.6061, 37.05683, 12.6241> }
					triangle { <19.4094, 36.5808, 12.2545>, <19.4526, 36.8976, 12.0662>, <19.6061, 37.05683, 12.6241> }
					triangle { <19.4094, 36.5808, 12.2545>, <19.6061, 37.05683, 12.6241>, <19.5316, 36.7349, 12.7881> }
					triangle { <19.6061, 37.05683, 12.6241>, <19.1037, 37.4893, 13.5083>, <18.861, 37.1606, 14.02187> }
					triangle { <19.5316, 36.7349, 12.7881>, <19.6061, 37.05683, 12.6241>, <18.861, 37.1606, 14.02187> }
					triangle { <19.2193, 36.1924, 10.9371>, <19.2768, 35.9309, 10.9184>, <18.8168, 36.06675, 10.4295> }
					triangle { <19.2193, 36.1924, 10.9371>, <19.4202, 35.9008, 11.2663>, <19.2768, 35.9309, 10.9184> }
					triangle { <19.5838, 36.2969, 11.3665>, <19.6754, 36.07876, 11.3605>, <19.2193, 36.1924, 10.9371> }
					triangle { <19.5838, 36.2969, 11.3665>, <19.4119, 36.2646, 12.3182>, <19.6754, 36.07876, 11.3605> }
					triangle { <19.6754, 36.07876, 11.3605>, <19.4202, 35.9008, 11.2663>, <19.2193, 36.1924, 10.9371> }
					triangle { <19.6754, 36.07876, 11.3605>, <19.3461, 35.8618, 12.3566>, <19.4202, 35.9008, 11.2663> }
					triangle { <19.4119, 36.2646, 12.3182>, <19.3461, 35.8618, 12.3566>, <19.6754, 36.07876, 11.3605> }
					triangle { <19.4094, 36.5808, 12.2545>, <19.4119, 36.2646, 12.3182>, <19.5838, 36.2969, 11.3665> }
					triangle { <19.4119, 36.2646, 12.3182>, <19.3819, 35.956, 12.9482>, <19.3461, 35.8618, 12.3566> }
					triangle { <19.4543, 36.3748, 12.9637>, <18.9665, 36.5834, 13.9423>, <19.3819, 35.956, 12.9482> }
					triangle { <19.4543, 36.3748, 12.9637>, <19.3819, 35.956, 12.9482>, <19.4119, 36.2646, 12.3182> }
					triangle { <19.4543, 36.3748, 12.9637>, <19.4119, 36.2646, 12.3182>, <19.4094, 36.5808, 12.2545> }
					triangle { <19.5316, 36.7349, 12.7881>, <19.4543, 36.3748, 12.9637>, <19.4094, 36.5808, 12.2545> }
					triangle { <18.861, 37.1606, 14.02187>, <18.9665, 36.5834, 13.9423>, <19.4543, 36.3748, 12.9637> }
					triangle { <18.861, 37.1606, 14.02187>, <19.4543, 36.3748, 12.9637>, <19.5316, 36.7349, 12.7881> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <18.8168, 36.06675, 10.4295>, <19.09917, 36.2066, 10.9573>, <19.2766, 36.01771, 10.9003> }
					triangle { <19.09917, 36.2066, 10.9573>, <19.343, 36.3194, 11.3429>, <19.2766, 36.01771, 10.9003> }
					triangle { <19.2766, 36.01771, 10.9003>, <19.5485, 36.1247, 11.4484>, <19.6841, 35.9912, 11.302> }
					triangle { <19.5485, 36.1247, 11.4484>, <19.5965, 35.6188, 12.1513>, <19.6841, 35.9912, 11.302> }
					triangle { <19.2766, 36.01771, 10.9003>, <19.343, 36.3194, 11.3429>, <19.5485, 36.1247, 11.4484> }
					triangle { <19.343, 36.3194, 11.3429>, <19.407, 35.7694, 12.2977>, <19.5485, 36.1247, 11.4484> }
					triangle { <19.5485, 36.1247, 11.4484>, <19.407, 35.7694, 12.2977>, <19.5965, 35.6188, 12.1513> }
					triangle { <19.6841, 35.9912, 11.302>, <19.5965, 35.6188, 12.1513>, <19.8105, 35.3579, 11.9968> }
					triangle { <19.407, 35.7694, 12.2977>, <19.6129, 35.5749, 12.7972>, <19.5965, 35.6188, 12.1513> }
					triangle { <19.6129, 35.5749, 12.7972>, <19.6871, 34.5904, 13.3703>, <19.879, 35.3849, 12.6264> }
					triangle { <19.5965, 35.6188, 12.1513>, <19.6129, 35.5749, 12.7972>, <19.879, 35.3849, 12.6264> }
					triangle { <19.8105, 35.3579, 11.9968>, <19.5965, 35.6188, 12.1513>, <19.879, 35.3849, 12.6264> }
					triangle { <19.8105, 35.3579, 11.9968>, <19.879, 35.3849, 12.6264>, <20.06161, 35.1189, 12.4475> }
					triangle { <19.879, 35.3849, 12.6264>, <19.6871, 34.5904, 13.3703>, <19.9066, 33.9723, 13.35> }
					triangle { <20.06161, 35.1189, 12.4475>, <19.879, 35.3849, 12.6264>, <19.9066, 33.9723, 13.35> }
					triangle { <19.2766, 36.01771, 10.9003>, <19.4434, 35.9827, 10.6929>, <18.8168, 36.06675, 10.4295> }
					triangle { <19.2766, 36.01771, 10.9003>, <19.7203, 35.8257, 10.8958>, <19.4434, 35.9827, 10.6929> }
					triangle { <19.6841, 35.9912, 11.302>, <19.8596, 35.9836, 11.1434>, <19.2766, 36.01771, 10.9003> }
					triangle { <19.6841, 35.9912, 11.302>, <20.00169, 35.2128, 11.7813>, <19.8596, 35.9836, 11.1434> }
					triangle { <19.8596, 35.9836, 11.1434>, <19.7203, 35.8257, 10.8958>, <19.2766, 36.01771, 10.9003> }
					triangle { <19.8596, 35.9836, 11.1434>, <20.1754, 35.01286, 11.4684>, <19.7203, 35.8257, 10.8958> }
					triangle { <20.00169, 35.2128, 11.7813>, <20.1754, 35.01286, 11.4684>, <19.8596, 35.9836, 11.1434> }
					triangle { <19.8105, 35.3579, 11.9968>, <20.00169, 35.2128, 11.7813>, <19.6841, 35.9912, 11.302> }
					triangle { <20.00169, 35.2128, 11.7813>, <20.4196, 34.6584, 11.8867>, <20.1754, 35.01286, 11.4684> }
					triangle { <20.2668, 34.8307, 12.2443>, <20.2418, 33.9079, 12.8662>, <20.4196, 34.6584, 11.8867> }
					triangle { <20.2668, 34.8307, 12.2443>, <20.4196, 34.6584, 11.8867>, <20.00169, 35.2128, 11.7813> }
					triangle { <20.2668, 34.8307, 12.2443>, <20.00169, 35.2128, 11.7813>, <19.8105, 35.3579, 11.9968> }
					triangle { <20.06161, 35.1189, 12.4475>, <20.2668, 34.8307, 12.2443>, <19.8105, 35.3579, 11.9968> }
					triangle { <19.9066, 33.9723, 13.35>, <20.2418, 33.9079, 12.8662>, <20.2668, 34.8307, 12.2443> }
					triangle { <19.9066, 33.9723, 13.35>, <20.2668, 34.8307, 12.2443>, <20.06161, 35.1189, 12.4475> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <18.8168, 36.06675, 10.4295>, <19.1937, 35.9273, 10.8946>, <19.3926, 36.02579, 10.7492> }
					triangle { <19.1937, 35.9273, 10.8946>, <19.4909, 35.8531, 11.2511>, <19.3926, 36.02579, 10.7492> }
					triangle { <19.3926, 36.02579, 10.7492>, <19.7881, 35.8555, 11.1969>, <19.8872, 36.00537, 11.03767> }
					triangle { <19.7881, 35.8555, 11.1969>, <20.4055, 35.2463, 11.1886>, <19.8872, 36.00537, 11.03767> }
					triangle { <19.3926, 36.02579, 10.7492>, <19.4909, 35.8531, 11.2511>, <19.7881, 35.8555, 11.1969> }
					triangle { <19.4909, 35.8531, 11.2511>, <20.2586, 35.06631, 11.35>, <19.7881, 35.8555, 11.1969> }
					triangle { <19.7881, 35.8555, 11.1969>, <20.2586, 35.06631, 11.35>, <20.4055, 35.2463, 11.1886> }
					triangle { <19.8872, 36.00537, 11.03767>, <20.4055, 35.2463, 11.1886>, <20.6226, 35.4145, 10.9392> }
					triangle { <20.2586, 35.06631, 11.35>, <20.7377, 34.7955, 11.5139>, <20.4055, 35.2463, 11.1886> }
					triangle { <20.7377, 34.7955, 11.5139>, <21.5586, 34.149, 11.05422>, <20.949, 35.0306, 11.3237> }
					triangle { <20.4055, 35.2463, 11.1886>, <20.7377, 34.7955, 11.5139>, <20.949, 35.0306, 11.3237> }
					triangle { <20.6226, 35.4145, 10.9392>, <20.4055, 35.2463, 11.1886>, <20.949, 35.0306, 11.3237> }
					triangle { <20.6226, 35.4145, 10.9392>, <20.949, 35.0306, 11.3237>, <21.1348, 35.1937, 11.04998> }
					triangle { <20.949, 35.0306, 11.3237>, <21.5586, 34.149, 11.05422>, <22.02409, 34.1199, 10.5926> }
					triangle { <21.1348, 35.1937, 11.04998>, <20.949, 35.0306, 11.3237>, <22.02409, 34.1199, 10.5926> }
					triangle { <19.3926, 36.02579, 10.7492>, <19.4359, 36.2681, 10.6423>, <18.8168, 36.06675, 10.4295> }
					triangle { <19.3926, 36.02579, 10.7492>, <19.8105, 36.2609, 10.6876>, <19.4359, 36.2681, 10.6423> }
					triangle { <19.8872, 36.00537, 11.03767>, <19.9452, 36.2278, 10.9816>, <19.3926, 36.02579, 10.7492> }
					triangle { <19.8872, 36.00537, 11.03767>, <20.7361, 35.6452, 10.7443>, <19.9452, 36.2278, 10.9816> }
					triangle { <19.9452, 36.2278, 10.9816>, <19.8105, 36.2609, 10.6876>, <19.3926, 36.02579, 10.7492> }
					triangle { <19.9452, 36.2278, 10.9816>, <20.8199, 35.9155, 10.4476>, <19.8105, 36.2609, 10.6876> }
					triangle { <20.7361, 35.6452, 10.7443>, <20.8199, 35.9155, 10.4476>, <19.9452, 36.2278, 10.9816> }
					triangle { <20.6226, 35.4145, 10.9392>, <20.7361, 35.6452, 10.7443>, <19.8872, 36.00537, 11.03767> }
					triangle { <20.7361, 35.6452, 10.7443>, <21.371, 35.6778, 10.4461>, <20.8199, 35.9155, 10.4476> }
					triangle { <21.3371, 35.3818, 10.7497>, <22.07713, 34.6552, 10.3453>, <21.371, 35.6778, 10.4461> }
					triangle { <21.3371, 35.3818, 10.7497>, <21.371, 35.6778, 10.4461>, <20.7361, 35.6452, 10.7443> }
					triangle { <21.3371, 35.3818, 10.7497>, <20.7361, 35.6452, 10.7443>, <20.6226, 35.4145, 10.9392> }
					triangle { <21.1348, 35.1937, 11.04998>, <21.3371, 35.3818, 10.7497>, <20.6226, 35.4145, 10.9392> }
					triangle { <22.02409, 34.1199, 10.5926>, <22.07713, 34.6552, 10.3453>, <21.3371, 35.3818, 10.7497> }
					triangle { <22.02409, 34.1199, 10.5926>, <21.3371, 35.3818, 10.7497>, <21.1348, 35.1937, 11.04998> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		}
	union { // internode
		cylinder { <0.09184, 1.3509, 0.09689>, <0.09978, 1.4471, 0.09649>, 0.4 }
		cylinder { <0.09978, 1.4471, 0.09649>, <0.1044, 1.5435, 0.09947>, 0.4 }
		cylinder { <0.1044, 1.5435, 0.09947>, <0.1057, 1.6398, 0.1058>, 0.4 }
		cylinder { <0.1057, 1.6398, 0.1058>, <0.1036, 1.7358, 0.1155>, 0.4 }
		cylinder { <0.1036, 1.7358, 0.1155>, <0.09829, 1.8313, 0.1285>, 0.4 }
		cylinder { <0.09829, 1.8313, 0.1285>, <0.0896, 1.9261, 0.1449>, 0.4 }
		cylinder { <0.0896, 1.9261, 0.1449>, <0.07762, 2.01992, 0.1645>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.07762, 2.01992, 0.1645>, <0.0497, 9.2049, 0.7642>, 0.8843 }
			cylinder { <0.0497, 9.2049, 0.7642>, <0.8891, 16.3605, 0.4823>, 0.8843 }
			cylinder { <0.8891, 16.3605, 0.4823>, <2.5713, 23.2758, -0.673>, 0.8843 }
			cylinder { <2.5713, 23.2758, -0.673>, <5.04674, 29.7472, -2.6677>, 0.8843 }
			cylinder { <5.04674, 29.7472, -2.6677>, <8.2423, 35.5842, -5.4431>, 0.8843 }
			cylinder { <8.2423, 35.5842, -5.4431>, <12.06421, 40.615, -8.9175>, 0.8843 }
			cylinder { <12.06421, 40.615, -8.9175>, <16.3997, 44.6913, -12.9885>, 0.8843 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <16.3997, 44.6913, -12.9885>, <11.06292, 39.4258, -14.2411>, <11.5557, 45.1226, -20.04419> }
			triangle { <16.3997, 44.6913, -12.9885>, <11.5557, 45.1226, -20.04419>, <15.4994, 49.02348, -22.4179> }
			triangle { <11.06292, 39.4258, -14.2411>, <7.881, 37.9099, -16.8187>, <11.5557, 45.1226, -20.04419> }
			triangle { <7.881, 37.9099, -16.8187>, <8.621, 39.8283, -21.09622>, <11.5557, 45.1226, -20.04419> }
			triangle { <8.621, 39.8283, -21.09622>, <12.2026, 43.5065, -25.631>, <11.5557, 45.1226, -20.04419> }
			triangle { <12.2026, 43.5065, -25.631>, <16.6771, 47.6358, -29.5395>, <15.4994, 49.02348, -22.4179> }
			triangle { <11.5557, 45.1226, -20.04419>, <12.2026, 43.5065, -25.631>, <15.4994, 49.02348, -22.4179> }
			triangle { <15.4994, 49.02348, -22.4179>, <19.7997, 51.4784, -26.636>, <21.7978, 52.2295, -22.2033> }
			triangle { <19.7997, 51.4784, -26.636>, <23.6604, 52.1447, -30.3962>, <24.9417, 53.9856, -26.8001> }
			triangle { <19.7997, 51.4784, -26.636>, <24.9417, 53.9856, -26.8001>, <21.7978, 52.2295, -22.2033> }
			triangle { <21.7978, 52.2295, -22.2033>, <24.9417, 53.9856, -26.8001>, <26.9116, 53.7031, -22.6563> }
			triangle { <23.6604, 52.1447, -30.3962>, <31.3163, 54.147, -30.3294>, <24.9417, 53.9856, -26.8001> }
			triangle { <24.9417, 53.9856, -26.8001>, <31.3163, 54.147, -30.3294>, <26.9116, 53.7031, -22.6563> }
			triangle { <16.3997, 44.6913, -12.9885>, <15.4994, 49.02348, -22.4179>, <20.373, 49.00837, -16.8546> }
			triangle { <20.373, 49.00837, -16.8546>, <15.4994, 49.02348, -22.4179>, <21.7978, 52.2295, -22.2033> }
			triangle { <20.373, 49.00837, -16.8546>, <21.7978, 52.2295, -22.2033>, <23.6674, 52.1058, -19.9481> }
			triangle { <21.7978, 52.2295, -22.2033>, <26.9116, 53.7031, -22.6563>, <23.6674, 52.1058, -19.9481> }
			triangle { <16.6771, 47.6358, -29.5395>, <19.7997, 51.4784, -26.636>, <15.4994, 49.02348, -22.4179> }
			triangle { <16.6771, 47.6358, -29.5395>, <23.6604, 52.1447, -30.3962>, <19.7997, 51.4784, -26.636> }
			triangle { <21.1205, 48.2126, -6.7638>, <16.8521, 41.296, -6.2029>, <16.3997, 44.6913, -12.9885> }
			triangle { <23.8057, 51.7069, -10.885>, <21.1205, 48.2126, -6.7638>, <16.3997, 44.6913, -12.9885> }
			triangle { <21.1205, 48.2126, -6.7638>, <18.4527, 41.3251, -2.1404>, <16.8521, 41.296, -6.2029> }
			triangle { <21.1205, 48.2126, -6.7638>, <22.2131, 44.2194, -2.2241>, <18.4527, 41.3251, -2.1404> }
			triangle { <21.1205, 48.2126, -6.7638>, <26.8016, 48.2229, -5.361>, <22.2131, 44.2194, -2.2241> }
			triangle { <23.8057, 51.7069, -10.885>, <31.02437, 52.2709, -9.619>, <26.8016, 48.2229, -5.361> }
			triangle { <23.8057, 51.7069, -10.885>, <26.8016, 48.2229, -5.361>, <21.1205, 48.2126, -6.7638> }
			triangle { <25.07004, 53.2867, -17.66>, <27.7571, 55.5574, -14.07719>, <23.8057, 51.7069, -10.885> }
			triangle { <30.09765, 55.4358, -19.8572>, <33.2252, 55.2348, -17.1158>, <27.7571, 55.5574, -14.07719> }
			triangle { <25.07004, 53.2867, -17.66>, <30.09765, 55.4358, -19.8572>, <27.7571, 55.5574, -14.07719> }
			triangle { <26.9116, 53.7031, -22.6563>, <30.09765, 55.4358, -19.8572>, <25.07004, 53.2867, -17.66> }
			triangle { <30.09765, 55.4358, -19.8572>, <35.2219, 55.6242, -24.691>, <33.2252, 55.2348, -17.1158> }
			triangle { <26.9116, 53.7031, -22.6563>, <35.2219, 55.6242, -24.691>, <30.09765, 55.4358, -19.8572> }
			triangle { <20.373, 49.00837, -16.8546>, <23.8057, 51.7069, -10.885>, <16.3997, 44.6913, -12.9885> }
			triangle { <25.07004, 53.2867, -17.66>, <23.8057, 51.7069, -10.885>, <20.373, 49.00837, -16.8546> }
			triangle { <23.6674, 52.1058, -19.9481>, <25.07004, 53.2867, -17.66>, <20.373, 49.00837, -16.8546> }
			triangle { <23.6674, 52.1058, -19.9481>, <26.9116, 53.7031, -22.6563>, <25.07004, 53.2867, -17.66> }
			triangle { <23.8057, 51.7069, -10.885>, <27.7571, 55.5574, -14.07719>, <31.02437, 52.2709, -9.619> }
			triangle { <27.7571, 55.5574, -14.07719>, <33.2252, 55.2348, -17.1158>, <31.02437, 52.2709, -9.619> }
			triangle { <26.9116, 53.7031, -22.6563>, <31.3163, 54.147, -30.3294>, <33.34, 55.09763, -27.6106> }
			triangle { <31.3163, 54.147, -30.3294>, <37.5081, 53.7857, -30.3073>, <33.34, 55.09763, -27.6106> }
			triangle { <26.9116, 53.7031, -22.6563>, <33.34, 55.09763, -27.6106>, <35.2219, 55.6242, -24.691> }
			triangle { <33.34, 55.09763, -27.6106>, <37.5081, 53.7857, -30.3073>, <35.2219, 55.6242, -24.691> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.07762, 2.01992, 0.1645>, <0.01239, 2.8418, 0.292>, 0.3888 }
			cylinder { <0.01239, 2.8418, 0.292>, <-0.01421, 3.6713, 0.377>, 0.3888 }
			cylinder { <-0.01421, 3.6713, 0.377>, <-0.002009, 4.5044, 0.4193>, 0.3888 }
			cylinder { <-0.002009, 4.5044, 0.4193>, <0.049, 5.3371, 0.4186>, 0.3888 }
			cylinder { <0.049, 5.3371, 0.4186>, <0.1386, 6.1654, 0.375>, 0.3888 }
			cylinder { <0.1386, 6.1654, 0.375>, <0.2664, 6.9854, 0.2887>, 0.3888 }
			cylinder { <0.2664, 6.9854, 0.2887>, <0.432, 7.7929, 0.1603>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.432, 7.7929, 0.1603>, <0.7476, 11.8233, -0.4464>, 0.3888 }
				cylinder { <0.7476, 11.8233, -0.4464>, <0.563, 15.8664, -1.02155>, 0.3888 }
				cylinder { <0.563, 15.8664, -1.02155>, <-0.1189, 19.8615, -1.5562>, 0.3888 }
				cylinder { <-0.1189, 19.8615, -1.5562>, <-1.288, 23.7485, -2.04256>, 0.3888 }
				cylinder { <-1.288, 23.7485, -2.04256>, <-2.9268, 27.4688, -2.4731>, 0.3888 }
				cylinder { <-2.9268, 27.4688, -2.4731>, <-5.01044, 30.9666, -2.8414>, 0.3888 }
				cylinder { <-5.01044, 30.9666, -2.8414>, <-7.5076, 34.1892, -3.142>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-7.5076, 34.1892, -3.142>, <-8.01945, 34.5809, -2.9672>, <-7.8605, 34.8065, -3.05082> }
					triangle { <-8.01945, 34.5809, -2.9672>, <-8.4108, 34.8934, -2.8678>, <-7.8605, 34.8065, -3.05082> }
					triangle { <-7.8605, 34.8065, -3.05082>, <-8.3543, 35.2155, -2.8403>, <-8.1783, 35.338, -2.9887> }
					triangle { <-8.3543, 35.2155, -2.8403>, <-8.366, 35.8249, -2.1216>, <-8.1783, 35.338, -2.9887> }
					triangle { <-7.8605, 34.8065, -3.05082>, <-8.4108, 34.8934, -2.8678>, <-8.3543, 35.2155, -2.8403> }
					triangle { <-8.4108, 34.8934, -2.8678>, <-8.5448, 35.6476, -1.9453>, <-8.3543, 35.2155, -2.8403> }
					triangle { <-8.3543, 35.2155, -2.8403>, <-8.5448, 35.6476, -1.9453>, <-8.366, 35.8249, -2.1216> }
					triangle { <-8.1783, 35.338, -2.9887>, <-8.366, 35.8249, -2.1216>, <-8.09255, 36.07756, -2.2762> }
					triangle { <-8.5448, 35.6476, -1.9453>, <-8.7336, 36.1391, -1.6106>, <-8.366, 35.8249, -2.1216> }
					triangle { <-8.7336, 36.1391, -1.6106>, <-8.2576, 36.9676, -0.82>, <-8.5227, 36.3914, -1.8395> }
					triangle { <-8.366, 35.8249, -2.1216>, <-8.7336, 36.1391, -1.6106>, <-8.5227, 36.3914, -1.8395> }
					triangle { <-8.09255, 36.07756, -2.2762>, <-8.366, 35.8249, -2.1216>, <-8.5227, 36.3914, -1.8395> }
					triangle { <-8.09255, 36.07756, -2.2762>, <-8.5227, 36.3914, -1.8395>, <-8.2227, 36.6098, -1.9909> }
					triangle { <-8.5227, 36.3914, -1.8395>, <-8.2576, 36.9676, -0.82>, <-7.7608, 37.4712, -0.7315> }
					triangle { <-8.2227, 36.6098, -1.9909>, <-8.5227, 36.3914, -1.8395>, <-7.7608, 37.4712, -0.7315> }
					triangle { <-7.8605, 34.8065, -3.05082>, <-7.7385, 34.8773, -3.306>, <-7.5076, 34.1892, -3.142> }
					triangle { <-7.8605, 34.8065, -3.05082>, <-7.7909, 35.2818, -3.2633>, <-7.7385, 34.8773, -3.306> }
					triangle { <-8.1783, 35.338, -2.9887>, <-8.1121, 35.4227, -3.2224>, <-7.8605, 34.8065, -3.05082> }
					triangle { <-8.1783, 35.338, -2.9887>, <-7.8758, 36.2237, -2.5096>, <-8.1121, 35.4227, -3.2224> }
					triangle { <-8.1121, 35.4227, -3.2224>, <-7.7909, 35.2818, -3.2633>, <-7.8605, 34.8065, -3.05082> }
					triangle { <-8.1121, 35.4227, -3.2224>, <-7.5473, 36.3421, -2.7861>, <-7.7909, 35.2818, -3.2633> }
					triangle { <-7.8758, 36.2237, -2.5096>, <-7.5473, 36.3421, -2.7861>, <-8.1121, 35.4227, -3.2224> }
					triangle { <-8.09255, 36.07756, -2.2762>, <-7.8758, 36.2237, -2.5096>, <-8.1783, 35.338, -2.9887> }
					triangle { <-7.8758, 36.2237, -2.5096>, <-7.5563, 36.9155, -2.4759>, <-7.5473, 36.3421, -2.7861> }
					triangle { <-7.8933, 36.8486, -2.167>, <-7.4788, 37.5816, -1.299>, <-7.5563, 36.9155, -2.4759> }
					triangle { <-7.8933, 36.8486, -2.167>, <-7.5563, 36.9155, -2.4759>, <-7.8758, 36.2237, -2.5096> }
					triangle { <-7.8933, 36.8486, -2.167>, <-7.8758, 36.2237, -2.5096>, <-8.09255, 36.07756, -2.2762> }
					triangle { <-8.2227, 36.6098, -1.9909>, <-7.8933, 36.8486, -2.167>, <-8.09255, 36.07756, -2.2762> }
					triangle { <-7.7608, 37.4712, -0.7315>, <-7.4788, 37.5816, -1.299>, <-7.8933, 36.8486, -2.167> }
					triangle { <-7.7608, 37.4712, -0.7315>, <-7.8933, 36.8486, -2.167>, <-8.2227, 36.6098, -1.9909> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-7.5076, 34.1892, -3.142>, <-7.7651, 34.7785, -2.962>, <-7.7985, 34.8367, -3.2424> }
					triangle { <-7.7651, 34.7785, -2.962>, <-7.9921, 35.2202, -2.8433>, <-7.7985, 34.8367, -3.2424> }
					triangle { <-7.7985, 34.8367, -3.2424>, <-8.02247, 35.4508, -3.07479>, <-8.06976, 35.3909, -3.3241> }
					triangle { <-8.02247, 35.4508, -3.07479>, <-7.6278, 36.2948, -3.216>, <-8.06976, 35.3909, -3.3241> }
					triangle { <-7.7985, 34.8367, -3.2424>, <-7.9921, 35.2202, -2.8433>, <-8.02247, 35.4508, -3.07479> }
					triangle { <-7.9921, 35.2202, -2.8433>, <-7.5461, 36.3304, -2.9218>, <-8.02247, 35.4508, -3.07479> }
					triangle { <-8.02247, 35.4508, -3.07479>, <-7.5461, 36.3304, -2.9218>, <-7.6278, 36.2948, -3.216> }
					triangle { <-8.06976, 35.3909, -3.3241>, <-7.6278, 36.2948, -3.216>, <-7.6583, 36.2888, -3.6179> }
					triangle { <-7.5461, 36.3304, -2.9218>, <-7.5209, 36.9506, -2.9847>, <-7.6278, 36.2948, -3.216> }
					triangle { <-7.5209, 36.9506, -2.9847>, <-6.8496, 37.8005, -3.5889>, <-7.6449, 36.9293, -3.3651> }
					triangle { <-7.6278, 36.2948, -3.216>, <-7.5209, 36.9506, -2.9847>, <-7.6449, 36.9293, -3.3651> }
					triangle { <-7.6583, 36.2888, -3.6179>, <-7.6278, 36.2948, -3.216>, <-7.6449, 36.9293, -3.3651> }
					triangle { <-7.6583, 36.2888, -3.6179>, <-7.6449, 36.9293, -3.3651>, <-7.6489, 36.8891, -3.7638> }
					triangle { <-7.6449, 36.9293, -3.3651>, <-6.8496, 37.8005, -3.5889>, <-6.6288, 38.02214, -4.2295> }
					triangle { <-7.6489, 36.8891, -3.7638>, <-7.6449, 36.9293, -3.3651>, <-6.6288, 38.02214, -4.2295> }
					triangle { <-7.7985, 34.8367, -3.2424>, <-7.9463, 34.7024, -3.4549>, <-7.5076, 34.1892, -3.142> }
					triangle { <-7.7985, 34.8367, -3.2424>, <-8.04838, 35.04584, -3.6544>, <-7.9463, 34.7024, -3.4549> }
					triangle { <-8.06976, 35.3909, -3.3241>, <-8.2362, 35.3008, -3.4982>, <-7.7985, 34.8367, -3.2424> }
					triangle { <-8.06976, 35.3909, -3.3241>, <-7.7549, 36.1841, -3.9381>, <-8.2362, 35.3008, -3.4982> }
					triangle { <-8.2362, 35.3008, -3.4982>, <-8.04838, 35.04584, -3.6544>, <-7.7985, 34.8367, -3.2424> }
					triangle { <-8.2362, 35.3008, -3.4982>, <-7.8141, 35.9909, -4.335>, <-8.04838, 35.04584, -3.6544> }
					triangle { <-7.7549, 36.1841, -3.9381>, <-7.8141, 35.9909, -4.335>, <-8.2362, 35.3008, -3.4982> }
					triangle { <-7.6583, 36.2888, -3.6179>, <-7.7549, 36.1841, -3.9381>, <-8.06976, 35.3909, -3.3241> }
					triangle { <-7.7549, 36.1841, -3.9381>, <-7.7269, 36.5866, -4.5855>, <-7.8141, 35.9909, -4.335> }
					triangle { <-7.6607, 36.8388, -4.2041>, <-6.9392, 37.6844, -4.6804>, <-7.7269, 36.5866, -4.5855> }
					triangle { <-7.6607, 36.8388, -4.2041>, <-7.7269, 36.5866, -4.5855>, <-7.7549, 36.1841, -3.9381> }
					triangle { <-7.6607, 36.8388, -4.2041>, <-7.7549, 36.1841, -3.9381>, <-7.6583, 36.2888, -3.6179> }
					triangle { <-7.6489, 36.8891, -3.7638>, <-7.6607, 36.8388, -4.2041>, <-7.6583, 36.2888, -3.6179> }
					triangle { <-6.6288, 38.02214, -4.2295>, <-6.9392, 37.6844, -4.6804>, <-7.6607, 36.8388, -4.2041> }
					triangle { <-6.6288, 38.02214, -4.2295>, <-7.6607, 36.8388, -4.2041>, <-7.6489, 36.8891, -3.7638> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-7.5076, 34.1892, -3.142>, <-7.6676, 34.8257, -3.2654>, <-7.9204, 34.7307, -3.3665> }
					triangle { <-7.6676, 34.8257, -3.2654>, <-7.8196, 35.3077, -3.3385>, <-7.9204, 34.7307, -3.3665> }
					triangle { <-7.9204, 34.7307, -3.3665>, <-8.0774, 35.3655, -3.5332>, <-8.283, 35.2053, -3.5412> }
					triangle { <-8.0774, 35.3655, -3.5332>, <-8.1826, 35.7559, -4.3843>, <-8.283, 35.2053, -3.5412> }
					triangle { <-7.9204, 34.7307, -3.3665>, <-7.8196, 35.3077, -3.3385>, <-8.0774, 35.3655, -3.5332> }
					triangle { <-7.8196, 35.3077, -3.3385>, <-7.9161, 35.9085, -4.3717>, <-8.0774, 35.3655, -3.5332> }
					triangle { <-8.0774, 35.3655, -3.5332>, <-7.9161, 35.9085, -4.3717>, <-8.1826, 35.7559, -4.3843> }
					triangle { <-8.283, 35.2053, -3.5412>, <-8.1826, 35.7559, -4.3843>, <-8.5116, 35.5466, -4.4863> }
					triangle { <-7.9161, 35.9085, -4.3717>, <-8.1124, 36.3235, -4.7942>, <-8.1826, 35.7559, -4.3843> }
					triangle { <-8.1124, 36.3235, -4.7942>, <-8.4223, 36.3574, -5.9945>, <-8.474, 36.1518, -4.8127> }
					triangle { <-8.1826, 35.7559, -4.3843>, <-8.1124, 36.3235, -4.7942>, <-8.474, 36.1518, -4.8127> }
					triangle { <-8.5116, 35.5466, -4.4863>, <-8.1826, 35.7559, -4.3843>, <-8.474, 36.1518, -4.8127> }
					triangle { <-8.5116, 35.5466, -4.4863>, <-8.474, 36.1518, -4.8127>, <-8.7765, 35.9082, -4.9114> }
					triangle { <-8.474, 36.1518, -4.8127>, <-8.4223, 36.3574, -5.9945>, <-8.8535, 36.08697, -6.4937> }
					triangle { <-8.7765, 35.9082, -4.9114>, <-8.474, 36.1518, -4.8127>, <-8.8535, 36.08697, -6.4937> }
					triangle { <-7.9204, 34.7307, -3.3665>, <-8.1351, 34.5756, -3.2446>, <-7.5076, 34.1892, -3.142> }
					triangle { <-7.9204, 34.7307, -3.3665>, <-8.4383, 34.7629, -3.4475>, <-8.1351, 34.5756, -3.2446> }
					triangle { <-8.283, 35.2053, -3.5412>, <-8.4901, 35.1112, -3.4212>, <-7.9204, 34.7307, -3.3665> }
					triangle { <-8.283, 35.2053, -3.5412>, <-8.7889, 35.3347, -4.4538>, <-8.4901, 35.1112, -3.4212> }
					triangle { <-8.4901, 35.1112, -3.4212>, <-8.4383, 34.7629, -3.4475>, <-7.9204, 34.7307, -3.3665> }
					triangle { <-8.4901, 35.1112, -3.4212>, <-9.08168, 35.00105, -4.4175>, <-8.4383, 34.7629, -3.4475> }
					triangle { <-8.7889, 35.3347, -4.4538>, <-9.08168, 35.00105, -4.4175>, <-8.4901, 35.1112, -3.4212> }
					triangle { <-8.5116, 35.5466, -4.4863>, <-8.7889, 35.3347, -4.4538>, <-8.283, 35.2053, -3.5412> }
					triangle { <-8.7889, 35.3347, -4.4538>, <-9.3825, 35.2716, -4.9288>, <-9.08168, 35.00105, -4.4175> }
					triangle { <-9.1133, 35.6379, -5.0116>, <-9.2938, 35.7176, -6.2047>, <-9.3825, 35.2716, -4.9288> }
					triangle { <-9.1133, 35.6379, -5.0116>, <-9.3825, 35.2716, -4.9288>, <-8.7889, 35.3347, -4.4538> }
					triangle { <-9.1133, 35.6379, -5.0116>, <-8.7889, 35.3347, -4.4538>, <-8.5116, 35.5466, -4.4863> }
					triangle { <-8.7765, 35.9082, -4.9114>, <-9.1133, 35.6379, -5.0116>, <-8.5116, 35.5466, -4.4863> }
					triangle { <-8.8535, 36.08697, -6.4937>, <-9.2938, 35.7176, -6.2047>, <-9.1133, 35.6379, -5.0116> }
					triangle { <-8.8535, 36.08697, -6.4937>, <-9.1133, 35.6379, -5.0116>, <-8.7765, 35.9082, -4.9114> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-7.5076, 34.1892, -3.142>, <-7.8608, 34.6577, -3.4609>, <-8.05893, 34.634, -3.2527> }
					triangle { <-7.8608, 34.6577, -3.4609>, <-8.13, 35.03588, -3.6738>, <-8.05893, 34.634, -3.2527> }
					triangle { <-8.05893, 34.634, -3.2527>, <-8.4437, 35.07667, -3.5863>, <-8.5254, 35.03611, -3.342> }
					triangle { <-8.4437, 35.07667, -3.5863>, <-9.2688, 34.9479, -4.02305>, <-8.5254, 35.03611, -3.342> }
					triangle { <-8.05893, 34.634, -3.2527>, <-8.13, 35.03588, -3.6738>, <-8.4437, 35.07667, -3.5863> }
					triangle { <-8.13, 35.03588, -3.6738>, <-9.1469, 34.961, -4.3048>, <-8.4437, 35.07667, -3.5863> }
					triangle { <-8.4437, 35.07667, -3.5863>, <-9.1469, 34.961, -4.3048>, <-9.2688, 34.9479, -4.02305> }
					triangle { <-8.5254, 35.03611, -3.342>, <-9.2688, 34.9479, -4.02305>, <-9.4812, 34.8696, -3.6895> }
					triangle { <-9.1469, 34.961, -4.3048>, <-9.6961, 35.1185, -4.5553>, <-9.2688, 34.9479, -4.02305> }
					triangle { <-9.6961, 35.1185, -4.5553>, <-10.817, 34.6192, -4.7348>, <-9.8719, 35.1262, -4.1952> }
					triangle { <-9.2688, 34.9479, -4.02305>, <-9.6961, 35.1185, -4.5553>, <-9.8719, 35.1262, -4.1952> }
					triangle { <-9.4812, 34.8696, -3.6895>, <-9.2688, 34.9479, -4.02305>, <-9.8719, 35.1262, -4.1952> }
					triangle { <-9.4812, 34.8696, -3.6895>, <-9.8719, 35.1262, -4.1952>, <-10.05773, 35.01368, -3.8584> }
					triangle { <-9.8719, 35.1262, -4.1952>, <-10.817, 34.6192, -4.7348>, <-11.3813, 34.3219, -4.4161> }
					triangle { <-10.05773, 35.01368, -3.8584>, <-9.8719, 35.1262, -4.1952>, <-11.3813, 34.3219, -4.4161> }
					triangle { <-8.05893, 34.634, -3.2527>, <-8.04587, 34.671, -2.9637>, <-7.5076, 34.1892, -3.142> }
					triangle { <-8.05893, 34.634, -3.2527>, <-8.4255, 34.8214, -2.9266>, <-8.04587, 34.671, -2.9637> }
					triangle { <-8.5254, 35.03611, -3.342>, <-8.5253, 35.1142, -3.09706>, <-8.05893, 34.634, -3.2527> }
					triangle { <-8.5254, 35.03611, -3.342>, <-9.5586, 34.8414, -3.3488>, <-8.5253, 35.1142, -3.09706> }
					triangle { <-8.5253, 35.1142, -3.09706>, <-8.4255, 34.8214, -2.9266>, <-8.05893, 34.634, -3.2527> }
					triangle { <-8.5253, 35.1142, -3.09706>, <-9.6101, 34.7311, -2.9204>, <-8.4255, 34.8214, -2.9266> }
					triangle { <-9.5586, 34.8414, -3.3488>, <-9.6101, 34.7311, -2.9204>, <-8.5253, 35.1142, -3.09706> }
					triangle { <-9.4812, 34.8696, -3.6895>, <-9.5586, 34.8414, -3.3488>, <-8.5254, 35.03611, -3.342> }
					triangle { <-9.5586, 34.8414, -3.3488>, <-10.2505, 34.7756, -3.03451>, <-9.6101, 34.7311, -2.9204> }
					triangle { <-10.2571, 34.8943, -3.481>, <-11.3106, 34.3809, -3.7795>, <-10.2505, 34.7756, -3.03451> }
					triangle { <-10.2571, 34.8943, -3.481>, <-10.2505, 34.7756, -3.03451>, <-9.5586, 34.8414, -3.3488> }
					triangle { <-10.2571, 34.8943, -3.481>, <-9.5586, 34.8414, -3.3488>, <-9.4812, 34.8696, -3.6895> }
					triangle { <-10.05773, 35.01368, -3.8584>, <-10.2571, 34.8943, -3.481>, <-9.4812, 34.8696, -3.6895> }
					triangle { <-11.3813, 34.3219, -4.4161>, <-11.3106, 34.3809, -3.7795>, <-10.2571, 34.8943, -3.481> }
					triangle { <-11.3813, 34.3219, -4.4161>, <-10.2571, 34.8943, -3.481>, <-10.05773, 35.01368, -3.8584> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-7.5076, 34.1892, -3.142>, <-8.08156, 34.5042, -3.2738>, <-8.02137, 34.6816, -3.05464> }
					triangle { <-8.08156, 34.5042, -3.2738>, <-8.501, 34.7759, -3.3785>, <-8.02137, 34.6816, -3.05464> }
					triangle { <-8.02137, 34.6816, -3.05464>, <-8.6174, 34.9825, -3.1517>, <-8.4597, 35.1193, -2.9954> }
					triangle { <-8.6174, 34.9825, -3.1517>, <-9.3838, 34.9912, -2.6035>, <-8.4597, 35.1193, -2.9954> }
					triangle { <-8.02137, 34.6816, -3.05464>, <-8.501, 34.7759, -3.3785>, <-8.6174, 34.9825, -3.1517> }
					triangle { <-8.501, 34.7759, -3.3785>, <-9.5413, 34.7973, -2.7826>, <-8.6174, 34.9825, -3.1517> }
					triangle { <-8.6174, 34.9825, -3.1517>, <-9.5413, 34.7973, -2.7826>, <-9.3838, 34.9912, -2.6035> }
					triangle { <-8.4597, 35.1193, -2.9954>, <-9.3838, 34.9912, -2.6035>, <-9.2182, 35.2027, -2.3029> }
					triangle { <-9.5413, 34.7973, -2.7826>, <-10.08591, 35.00287, -2.558>, <-9.3838, 34.9912, -2.6035> }
					triangle { <-10.08591, 35.00287, -2.558>, <-10.7137, 35.00207, -1.4885>, <-9.9024, 35.2766, -2.33> }
					triangle { <-9.3838, 34.9912, -2.6035>, <-10.08591, 35.00287, -2.558>, <-9.9024, 35.2766, -2.33> }
					triangle { <-9.2182, 35.2027, -2.3029>, <-9.3838, 34.9912, -2.6035>, <-9.9024, 35.2766, -2.33> }
					triangle { <-9.2182, 35.2027, -2.3029>, <-9.9024, 35.2766, -2.33>, <-9.7102, 35.4538, -2.02626> }
					triangle { <-9.9024, 35.2766, -2.33>, <-10.7137, 35.00207, -1.4885>, <-10.6957, 35.1904, -0.8012> }
					triangle { <-9.7102, 35.4538, -2.02626>, <-9.9024, 35.2766, -2.33>, <-10.6957, 35.1904, -0.8012> }
					triangle { <-8.02137, 34.6816, -3.05464>, <-7.797, 34.8603, -3.002292>, <-7.5076, 34.1892, -3.142> }
					triangle { <-8.02137, 34.6816, -3.05464>, <-8.01942, 35.1469, -2.8111>, <-7.797, 34.8603, -3.002292> }
					triangle { <-8.4597, 35.1193, -2.9954>, <-8.2882, 35.3095, -2.9723>, <-8.02137, 34.6816, -3.05464> }
					triangle { <-8.4597, 35.1193, -2.9954>, <-8.9857, 35.3991, -2.1292>, <-8.2882, 35.3095, -2.9723> }
					triangle { <-8.2882, 35.3095, -2.9723>, <-8.01942, 35.1469, -2.8111>, <-8.02137, 34.6816, -3.05464> }
					triangle { <-8.2882, 35.3095, -2.9723>, <-8.6475, 35.5725, -1.8969>, <-8.01942, 35.1469, -2.8111> }
					triangle { <-8.9857, 35.3991, -2.1292>, <-8.6475, 35.5725, -1.8969>, <-8.2882, 35.3095, -2.9723> }
					triangle { <-9.2182, 35.2027, -2.3029>, <-8.9857, 35.3991, -2.1292>, <-8.4597, 35.1193, -2.9954> }
					triangle { <-8.9857, 35.3991, -2.1292>, <-9.1048, 35.807, -1.4956>, <-8.6475, 35.5725, -1.8969> }
					triangle { <-9.4918, 35.6538, -1.6964>, <-10.172, 35.5504, -0.7019>, <-9.1048, 35.807, -1.4956> }
					triangle { <-9.4918, 35.6538, -1.6964>, <-9.1048, 35.807, -1.4956>, <-8.9857, 35.3991, -2.1292> }
					triangle { <-9.4918, 35.6538, -1.6964>, <-8.9857, 35.3991, -2.1292>, <-9.2182, 35.2027, -2.3029> }
					triangle { <-9.7102, 35.4538, -2.02626>, <-9.4918, 35.6538, -1.6964>, <-9.2182, 35.2027, -2.3029> }
					triangle { <-10.6957, 35.1904, -0.8012>, <-10.172, 35.5504, -0.7019>, <-9.4918, 35.6538, -1.6964> }
					triangle { <-10.6957, 35.1904, -0.8012>, <-9.4918, 35.6538, -1.6964>, <-9.7102, 35.4538, -2.02626> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <0.432, 7.7929, 0.1603>, <0.5408, 8.6108, 0.03702>, 0.3888 }
			cylinder { <0.5408, 8.6108, 0.03702>, <0.5923, 9.4352, -0.08061>, 0.3888 }
			cylinder { <0.5923, 9.4352, -0.08061>, <0.5863, 10.2619, -0.192>, 0.3888 }
			cylinder { <0.5863, 10.2619, -0.192>, <0.5229, 11.08723, -0.2969>, 0.3888 }
			cylinder { <0.5229, 11.08723, -0.2969>, <0.4022, 11.9069, -0.3947>, 0.3888 }
			cylinder { <0.4022, 11.9069, -0.3947>, <0.2249, 12.7171, -0.485>, 0.3888 }
			cylinder { <0.2249, 12.7171, -0.485>, <-0.008056, 13.5139, -0.5674>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.008056, 13.5139, -0.5674>, <-0.7662, 17.5297, -0.6688>, 0.3888 }
				cylinder { <-0.7662, 17.5297, -0.6688>, <-1.1292, 21.5965, -0.4657>, 0.3888 }
				cylinder { <-1.1292, 21.5965, -0.4657>, <-1.09167, 25.6531, 0.03852>, 0.3888 }
				cylinder { <-1.09167, 25.6531, 0.03852>, <-0.654, 29.6385, 0.8365>, 0.3888 }
				cylinder { <-0.654, 29.6385, 0.8365>, <0.177, 33.4928, 1.9161>, 0.3888 }
				cylinder { <0.177, 33.4928, 1.9161>, <1.3891, 37.1579, 3.2613>, 0.3888 }
				cylinder { <1.3891, 37.1579, 3.2613>, <2.9639, 40.5789, 4.8516>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <2.9639, 40.5789, 4.8516>, <3.4124, 40.968, 5.01019>, <3.2458, 41.1667, 4.9535> }
					triangle { <3.4124, 40.968, 5.01019>, <3.7342, 41.279, 5.154>, <3.2458, 41.1667, 4.9535> }
					triangle { <3.2458, 41.1667, 4.9535>, <3.7031, 41.5689, 5.07531>, <3.488, 41.6745, 5.06113> }
					triangle { <3.7031, 41.5689, 5.07531>, <4.1325, 42.09866, 4.5391>, <3.488, 41.6745, 5.06113> }
					triangle { <3.2458, 41.1667, 4.9535>, <3.7342, 41.279, 5.154>, <3.7031, 41.5689, 5.07531> }
					triangle { <3.7342, 41.279, 5.154>, <4.3681, 41.9419, 4.5401>, <3.7031, 41.5689, 5.07531> }
					triangle { <3.7031, 41.5689, 5.07531>, <4.3681, 41.9419, 4.5401>, <4.1325, 42.09866, 4.5391> }
					triangle { <3.488, 41.6745, 5.06113>, <4.1325, 42.09866, 4.5391>, <3.8429, 42.3166, 4.4599> }
					triangle { <4.3681, 41.9419, 4.5401>, <4.6888, 42.3923, 4.385>, <4.1325, 42.09866, 4.5391> }
					triangle { <4.6888, 42.3923, 4.385>, <4.8199, 43.08434, 3.4867>, <4.3969, 42.6177, 4.3949> }
					triangle { <4.1325, 42.09866, 4.5391>, <4.6888, 42.3923, 4.385>, <4.3969, 42.6177, 4.3949> }
					triangle { <3.8429, 42.3166, 4.4599>, <4.1325, 42.09866, 4.5391>, <4.3969, 42.6177, 4.3949> }
					triangle { <3.8429, 42.3166, 4.4599>, <4.3969, 42.6177, 4.3949>, <4.09195, 42.8022, 4.3> }
					triangle { <4.3969, 42.6177, 4.3949>, <4.8199, 43.08434, 3.4867>, <4.5176, 43.5059, 3.08487> }
					triangle { <4.09195, 42.8022, 4.3>, <4.3969, 42.6177, 4.3949>, <4.5176, 43.5059, 3.08487> }
					triangle { <3.2458, 41.1667, 4.9535>, <3.004225, 41.2332, 5.04973>, <2.9639, 40.5789, 4.8516> }
					triangle { <3.2458, 41.1667, 4.9535>, <3.05527, 41.606, 5.02002>, <3.004225, 41.2332, 5.04973> }
					triangle { <3.488, 41.6745, 5.06113>, <3.2977, 41.7569, 5.1752>, <3.2458, 41.1667, 4.9535> }
					triangle { <3.488, 41.6745, 5.06113>, <3.5473, 42.4444, 4.4777>, <3.2977, 41.7569, 5.1752> }
					triangle { <3.2977, 41.7569, 5.1752>, <3.05527, 41.606, 5.02002>, <3.2458, 41.1667, 4.9535> }
					triangle { <3.2977, 41.7569, 5.1752>, <3.1491, 42.5404, 4.4597>, <3.05527, 41.606, 5.02002> }
					triangle { <3.5473, 42.4444, 4.4777>, <3.1491, 42.5404, 4.4597>, <3.2977, 41.7569, 5.1752> }
					triangle { <3.8429, 42.3166, 4.4599>, <3.5473, 42.4444, 4.4777>, <3.488, 41.6745, 5.06113> }
					triangle { <3.5473, 42.4444, 4.4777>, <3.3286, 43.05389, 4.2061>, <3.1491, 42.5404, 4.4597> }
					triangle { <3.751, 43.00437, 4.2028>, <3.9743, 43.61, 3.296>, <3.3286, 43.05389, 4.2061> }
					triangle { <3.751, 43.00437, 4.2028>, <3.3286, 43.05389, 4.2061>, <3.5473, 42.4444, 4.4777> }
					triangle { <3.751, 43.00437, 4.2028>, <3.5473, 42.4444, 4.4777>, <3.8429, 42.3166, 4.4599> }
					triangle { <4.09195, 42.8022, 4.3>, <3.751, 43.00437, 4.2028>, <3.8429, 42.3166, 4.4599> }
					triangle { <4.5176, 43.5059, 3.08487>, <3.9743, 43.61, 3.296>, <3.751, 43.00437, 4.2028> }
					triangle { <4.5176, 43.5059, 3.08487>, <3.751, 43.00437, 4.2028>, <4.09195, 42.8022, 4.3> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <2.9639, 40.5789, 4.8516>, <3.2348, 41.1303, 4.8368>, <3.08541, 41.1978, 5.04556> }
					triangle { <3.2348, 41.1303, 4.8368>, <3.4516, 41.5469, 4.8575>, <3.08541, 41.1978, 5.04556> }
					triangle { <3.08541, 41.1978, 5.04556>, <3.3251, 41.7701, 5.01702>, <3.2073, 41.7289, 5.2221> }
					triangle { <3.3251, 41.7701, 5.01702>, <2.9439, 42.5207, 4.8082>, <3.2073, 41.7289, 5.2221> }
					triangle { <3.08541, 41.1978, 5.04556>, <3.4516, 41.5469, 4.8575>, <3.3251, 41.7701, 5.01702> }
					triangle { <3.4516, 41.5469, 4.8575>, <3.06593, 42.5352, 4.5533>, <3.3251, 41.7701, 5.01702> }
					triangle { <3.3251, 41.7701, 5.01702>, <3.06593, 42.5352, 4.5533>, <2.9439, 42.5207, 4.8082> }
					triangle { <3.2073, 41.7289, 5.2221>, <2.9439, 42.5207, 4.8082>, <2.7201, 42.5341, 5.1039> }
					triangle { <3.06593, 42.5352, 4.5533>, <2.9932, 43.1045, 4.5321>, <2.9439, 42.5207, 4.8082> }
					triangle { <2.9932, 43.1045, 4.5321>, <2.139, 43.8594, 4.4741>, <2.8474, 43.1097, 4.8709> }
					triangle { <2.9439, 42.5207, 4.8082>, <2.9932, 43.1045, 4.5321>, <2.8474, 43.1097, 4.8709> }
					triangle { <2.7201, 42.5341, 5.1039>, <2.9439, 42.5207, 4.8082>, <2.8474, 43.1097, 4.8709> }
					triangle { <2.7201, 42.5341, 5.1039>, <2.8474, 43.1097, 4.8709>, <2.6082, 43.08967, 5.151> }
					triangle { <2.8474, 43.1097, 4.8709>, <2.139, 43.8594, 4.4741>, <1.5903, 44.07298, 4.7638> }
					triangle { <2.6082, 43.08967, 5.151>, <2.8474, 43.1097, 4.8709>, <1.5903, 44.07298, 4.7638> }
					triangle { <3.08541, 41.1978, 5.04556>, <3.06147, 41.09426, 5.292>, <2.9639, 40.5789, 4.8516> }
					triangle { <3.08541, 41.1978, 5.04556>, <3.000799, 41.4247, 5.4639>, <3.06147, 41.09426, 5.292> }
					triangle { <3.2073, 41.7289, 5.2221>, <3.2184, 41.6657, 5.4499>, <3.08541, 41.1978, 5.04556> }
					triangle { <3.2073, 41.7289, 5.2221>, <2.5944, 42.4584, 5.3911>, <3.2184, 41.6657, 5.4499> }
					triangle { <3.2184, 41.6657, 5.4499>, <3.000799, 41.4247, 5.4639>, <3.08541, 41.1978, 5.04556> }
					triangle { <3.2184, 41.6657, 5.4499>, <2.3986, 42.3021, 5.7156>, <3.000799, 41.4247, 5.4639> }
					triangle { <2.5944, 42.4584, 5.3911>, <2.3986, 42.3021, 5.7156>, <3.2184, 41.6657, 5.4499> }
					triangle { <2.7201, 42.5341, 5.1039>, <2.5944, 42.4584, 5.3911>, <3.2073, 41.7289, 5.2221> }
					triangle { <2.5944, 42.4584, 5.3911>, <2.1694, 42.852, 5.788>, <2.3986, 42.3021, 5.7156> }
					triangle { <2.3494, 43.06271, 5.4653>, <1.5386, 43.8047, 5.2891>, <2.1694, 42.852, 5.788> }
					triangle { <2.3494, 43.06271, 5.4653>, <2.1694, 42.852, 5.788>, <2.5944, 42.4584, 5.3911> }
					triangle { <2.3494, 43.06271, 5.4653>, <2.5944, 42.4584, 5.3911>, <2.7201, 42.5341, 5.1039> }
					triangle { <2.6082, 43.08967, 5.151>, <2.3494, 43.06271, 5.4653>, <2.7201, 42.5341, 5.1039> }
					triangle { <1.5903, 44.07298, 4.7638>, <1.5386, 43.8047, 5.2891>, <2.3494, 43.06271, 5.4653> }
					triangle { <1.5903, 44.07298, 4.7638>, <2.3494, 43.06271, 5.4653>, <2.6082, 43.08967, 5.151> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <2.9639, 40.5789, 4.8516>, <2.9815, 41.1791, 4.9829>, <3.09672, 41.1146, 5.2132> }
					triangle { <2.9815, 41.1791, 4.9829>, <3.0285, 41.635, 5.08708>, <3.09672, 41.1146, 5.2132> }
					triangle { <3.09672, 41.1146, 5.2132>, <3.08593, 41.7148, 5.3726>, <3.2271, 41.5834, 5.5155> }
					triangle { <3.08593, 41.7148, 5.3726>, <2.6289, 42.1156, 5.9914>, <3.2271, 41.5834, 5.5155> }
					triangle { <3.09672, 41.1146, 5.2132>, <3.0285, 41.635, 5.08708>, <3.08593, 41.7148, 5.3726> }
					triangle { <3.0285, 41.635, 5.08708>, <2.4487, 42.2355, 5.8092>, <3.08593, 41.7148, 5.3726> }
					triangle { <3.08593, 41.7148, 5.3726>, <2.4487, 42.2355, 5.8092>, <2.6289, 42.1156, 5.9914> }
					triangle { <3.2271, 41.5834, 5.5155>, <2.6289, 42.1156, 5.9914>, <2.7993, 41.952, 6.2776> }
					triangle { <2.4487, 42.2355, 5.8092>, <2.3152, 42.6477, 6.186>, <2.6289, 42.1156, 5.9914> }
					triangle { <2.3152, 42.6477, 6.186>, <1.7962, 42.7511, 7.1975>, <2.5578, 42.5175, 6.4314> }
					triangle { <2.6289, 42.1156, 5.9914>, <2.3152, 42.6477, 6.186>, <2.5578, 42.5175, 6.4314> }
					triangle { <2.7993, 41.952, 6.2776>, <2.6289, 42.1156, 5.9914>, <2.5578, 42.5175, 6.4314> }
					triangle { <2.7993, 41.952, 6.2776>, <2.5578, 42.5175, 6.4314>, <2.7128, 42.3204, 6.702> }
					triangle { <2.5578, 42.5175, 6.4314>, <1.7962, 42.7511, 7.1975>, <1.7966, 42.5554, 7.8238> }
					triangle { <2.7128, 42.3204, 6.702>, <2.5578, 42.5175, 6.4314>, <1.7966, 42.5554, 7.8238> }
					triangle { <3.09672, 41.1146, 5.2132>, <3.3232, 40.9831, 5.2716>, <2.9639, 40.5789, 4.8516> }
					triangle { <3.09672, 41.1146, 5.2132>, <3.4034, 41.1853, 5.5801>, <3.3232, 40.9831, 5.2716> }
					triangle { <3.2271, 41.5834, 5.5155>, <3.4456, 41.5073, 5.5657>, <3.09672, 41.1146, 5.2132> }
					triangle { <3.2271, 41.5834, 5.5155>, <3.01608, 41.7768, 6.4399>, <3.4456, 41.5073, 5.5657> }
					triangle { <3.4456, 41.5073, 5.5657>, <3.4034, 41.1853, 5.5801>, <3.09672, 41.1146, 5.2132> }
					triangle { <3.4456, 41.5073, 5.5657>, <3.249, 41.4907, 6.6188>, <3.4034, 41.1853, 5.5801> }
					triangle { <3.01608, 41.7768, 6.4399>, <3.249, 41.4907, 6.6188>, <3.4456, 41.5073, 5.5657> }
					triangle { <2.7993, 41.952, 6.2776>, <3.01608, 41.7768, 6.4399>, <3.2271, 41.5834, 5.5155> }
					triangle { <3.01608, 41.7768, 6.4399>, <3.1373, 41.7819, 7.1315>, <3.249, 41.4907, 6.6188> }
					triangle { <2.8913, 42.1014, 6.9964>, <2.2863, 42.237, 7.9209>, <3.1373, 41.7819, 7.1315> }
					triangle { <2.8913, 42.1014, 6.9964>, <3.1373, 41.7819, 7.1315>, <3.01608, 41.7768, 6.4399> }
					triangle { <2.8913, 42.1014, 6.9964>, <3.01608, 41.7768, 6.4399>, <2.7993, 41.952, 6.2776> }
					triangle { <2.7128, 42.3204, 6.702>, <2.8913, 42.1014, 6.9964>, <2.7993, 41.952, 6.2776> }
					triangle { <1.7966, 42.5554, 7.8238>, <2.2863, 42.237, 7.9209>, <2.8913, 42.1014, 6.9964> }
					triangle { <1.7966, 42.5554, 7.8238>, <2.8913, 42.1014, 6.9964>, <2.7128, 42.3204, 6.702> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <2.9639, 40.5789, 4.8516>, <3.000171, 41.04736, 5.2479>, <3.2642, 41.03142, 5.2264> }
					triangle { <3.000171, 41.04736, 5.2479>, <3.04556, 41.4224, 5.5275>, <3.2642, 41.03142, 5.2264> }
					triangle { <3.2642, 41.03142, 5.2264>, <3.3139, 41.479, 5.6541>, <3.5202, 41.4377, 5.5386> }
					triangle { <3.3139, 41.479, 5.6541>, <3.6199, 41.4394, 6.4647>, <3.5202, 41.4377, 5.5386> }
					triangle { <3.2642, 41.03142, 5.2264>, <3.04556, 41.4224, 5.5275>, <3.3139, 41.479, 5.6541> }
					triangle { <3.04556, 41.4224, 5.5275>, <3.3638, 41.4541, 6.5839>, <3.3139, 41.479, 5.6541> }
					triangle { <3.3139, 41.479, 5.6541>, <3.3638, 41.4541, 6.5839>, <3.6199, 41.4394, 6.4647> }
					triangle { <3.5202, 41.4377, 5.5386>, <3.6199, 41.4394, 6.4647>, <3.9717, 41.3693, 6.3699> }
					triangle { <3.3638, 41.4541, 6.5839>, <3.5853, 41.649, 7.07654>, <3.6199, 41.4394, 6.4647> }
					triangle { <3.5853, 41.649, 7.07654>, <4.2621, 41.2806, 7.9187>, <3.9257, 41.654, 6.9344> }
					triangle { <3.6199, 41.4394, 6.4647>, <3.5853, 41.649, 7.07654>, <3.9257, 41.654, 6.9344> }
					triangle { <3.9717, 41.3693, 6.3699>, <3.6199, 41.4394, 6.4647>, <3.9257, 41.654, 6.9344> }
					triangle { <3.9717, 41.3693, 6.3699>, <3.9257, 41.654, 6.9344>, <4.2621, 41.5505, 6.8241> }
					triangle { <3.9257, 41.654, 6.9344>, <4.2621, 41.2806, 7.9187>, <4.8534, 41.03629, 8.06469> }
					triangle { <4.2621, 41.5505, 6.8241>, <3.9257, 41.654, 6.9344>, <4.8534, 41.03629, 8.06469> }
					triangle { <3.2642, 41.03142, 5.2264>, <3.4303, 41.05249, 5.01665>, <2.9639, 40.5789, 4.8516> }
					triangle { <3.2642, 41.03142, 5.2264>, <3.7104, 41.2165, 5.2091>, <3.4303, 41.05249, 5.01665> }
					triangle { <3.5202, 41.4377, 5.5386>, <3.6673, 41.4992, 5.3636>, <3.2642, 41.03142, 5.2264> }
					triangle { <3.5202, 41.4377, 5.5386>, <4.2335, 41.335, 6.1845>, <3.6673, 41.4992, 5.3636> }
					triangle { <3.6673, 41.4992, 5.3636>, <3.7104, 41.2165, 5.2091>, <3.2642, 41.03142, 5.2264> }
					triangle { <3.6673, 41.4992, 5.3636>, <4.5332, 41.22, 5.9295>, <3.7104, 41.2165, 5.2091> }
					triangle { <4.2335, 41.335, 6.1845>, <4.5332, 41.22, 5.9295>, <3.6673, 41.4992, 5.3636> }
					triangle { <3.9717, 41.3693, 6.3699>, <4.2335, 41.335, 6.1845>, <3.5202, 41.4377, 5.5386> }
					triangle { <4.2335, 41.335, 6.1845>, <4.9038, 41.3123, 6.3924>, <4.5332, 41.22, 5.9295> }
					triangle { <4.6329, 41.44, 6.6945>, <5.1911, 41.05885, 7.5788>, <4.9038, 41.3123, 6.3924> }
					triangle { <4.6329, 41.44, 6.6945>, <4.9038, 41.3123, 6.3924>, <4.2335, 41.335, 6.1845> }
					triangle { <4.6329, 41.44, 6.6945>, <4.2335, 41.335, 6.1845>, <3.9717, 41.3693, 6.3699> }
					triangle { <4.2621, 41.5505, 6.8241>, <4.6329, 41.44, 6.6945>, <3.9717, 41.3693, 6.3699> }
					triangle { <4.8534, 41.03629, 8.06469>, <5.1911, 41.05885, 7.5788>, <4.6329, 41.44, 6.6945> }
					triangle { <4.8534, 41.03629, 8.06469>, <4.6329, 41.44, 6.6945>, <4.2621, 41.5505, 6.8241> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <2.9639, 40.5789, 4.8516>, <3.2704, 40.9149, 5.2649>, <3.3577, 41.06409, 5.06352> }
					triangle { <3.2704, 40.9149, 5.2649>, <3.4883, 41.199, 5.5695>, <3.3577, 41.06409, 5.06352> }
					triangle { <3.3577, 41.06409, 5.06352>, <3.7011, 41.3875, 5.4675>, <3.6839, 41.4949, 5.2535> }
					triangle { <3.7011, 41.3875, 5.4675>, <4.5632, 41.4287, 5.5536>, <3.6839, 41.4949, 5.2535> }
					triangle { <3.3577, 41.06409, 5.06352>, <3.4883, 41.199, 5.5695>, <3.7011, 41.3875, 5.4675> }
					triangle { <3.4883, 41.199, 5.5695>, <4.5679, 41.2699, 5.7877>, <3.7011, 41.3875, 5.4675> }
					triangle { <3.7011, 41.3875, 5.4675>, <4.5679, 41.2699, 5.7877>, <4.5632, 41.4287, 5.5536> }
					triangle { <3.6839, 41.4949, 5.2535>, <4.5632, 41.4287, 5.5536>, <4.6265, 41.5981, 5.2296> }
					triangle { <4.5679, 41.2699, 5.7877>, <5.07449, 41.4888, 5.9466>, <4.5632, 41.4287, 5.5536> }
					triangle { <5.07449, 41.4888, 5.9466>, <6.159, 41.4897, 5.5907>, <5.07953, 41.7169, 5.6567> }
					triangle { <4.5632, 41.4287, 5.5536>, <5.07449, 41.4888, 5.9466>, <5.07953, 41.7169, 5.6567> }
					triangle { <4.6265, 41.5981, 5.2296>, <4.5632, 41.4287, 5.5536>, <5.07953, 41.7169, 5.6567> }
					triangle { <4.6265, 41.5981, 5.2296>, <5.07953, 41.7169, 5.6567>, <5.1273, 41.8527, 5.3172> }
					triangle { <5.07953, 41.7169, 5.6567>, <6.159, 41.4897, 5.5907>, <6.5604, 41.6326, 5.09161> }
					triangle { <5.1273, 41.8527, 5.3172>, <5.07953, 41.7169, 5.6567>, <6.5604, 41.6326, 5.09161> }
					triangle { <3.3577, 41.06409, 5.06352>, <3.2301, 41.2093, 4.8774>, <2.9639, 40.5789, 4.8516> }
					triangle { <3.3577, 41.06409, 5.06352>, <3.492, 41.4804, 4.8577>, <3.2301, 41.2093, 4.8774> }
					triangle { <3.6839, 41.4949, 5.2535>, <3.5746, 41.6558, 5.1186>, <3.3577, 41.06409, 5.06352> }
					triangle { <3.6839, 41.4949, 5.2535>, <4.5668, 41.7539, 4.9535>, <3.5746, 41.6558, 5.1186> }
					triangle { <3.5746, 41.6558, 5.1186>, <3.492, 41.4804, 4.8577>, <3.3577, 41.06409, 5.06352> }
					triangle { <3.5746, 41.6558, 5.1186>, <4.4705, 41.8786, 4.575>, <3.492, 41.4804, 4.8577> }
					triangle { <4.5668, 41.7539, 4.9535>, <4.4705, 41.8786, 4.575>, <3.5746, 41.6558, 5.1186> }
					triangle { <4.6265, 41.5981, 5.2296>, <4.5668, 41.7539, 4.9535>, <3.6839, 41.4949, 5.2535> }
					triangle { <4.5668, 41.7539, 4.9535>, <5.02384, 42.1103, 4.5571>, <4.4705, 41.8786, 4.575> }
					triangle { <5.1723, 42.00652, 4.9419>, <6.2501, 41.9202, 4.6774>, <5.02384, 42.1103, 4.5571> }
					triangle { <5.1723, 42.00652, 4.9419>, <5.02384, 42.1103, 4.5571>, <4.5668, 41.7539, 4.9535> }
					triangle { <5.1723, 42.00652, 4.9419>, <4.5668, 41.7539, 4.9535>, <4.6265, 41.5981, 5.2296> }
					triangle { <5.1273, 41.8527, 5.3172>, <5.1723, 42.00652, 4.9419>, <4.6265, 41.5981, 5.2296> }
					triangle { <6.5604, 41.6326, 5.09161>, <6.2501, 41.9202, 4.6774>, <5.1723, 42.00652, 4.9419> }
					triangle { <6.5604, 41.6326, 5.09161>, <5.1723, 42.00652, 4.9419>, <5.1273, 41.8527, 5.3172> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.008056, 13.5139, -0.5674>, <-0.1955, 14.3253, -0.6173>, 0.3888 }
			cylinder { <-0.1955, 14.3253, -0.6173>, <-0.3365, 15.1474, -0.6343>, 0.3888 }
			cylinder { <-0.3365, 15.1474, -0.6343>, <-0.4305, 15.9763, -0.6183>, 0.3888 }
			cylinder { <-0.4305, 15.9763, -0.6183>, <-0.477, 16.8078, -0.5693>, 0.3888 }
			cylinder { <-0.477, 16.8078, -0.5693>, <-0.4758, 17.6381, -0.4874>, 0.3888 }
			cylinder { <-0.4758, 17.6381, -0.4874>, <-0.427, 18.463, -0.3731>, 0.3888 }
			cylinder { <-0.427, 18.463, -0.3731>, <-0.3309, 19.2787, -0.2267>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.3309, 19.2787, -0.2267>, <0.05009, 23.3425, 0.001704>, 0.3888 }
				cylinder { <0.05009, 23.3425, 0.001704>, <0.3352, 27.4121, -0.2619>, 0.3888 }
				cylinder { <0.3352, 27.4121, -0.2619>, <0.5201, 31.4261, -1.01362>, 0.3888 }
				cylinder { <0.5201, 31.4261, -1.01362>, <0.6022, 35.3243, -2.2421>, 0.3888 }
				cylinder { <0.6022, 35.3243, -2.2421>, <0.58, 39.048, -3.9289>, 0.3888 }
				cylinder { <0.58, 39.048, -3.9289>, <0.454, 42.5411, -6.04878>, 0.3888 }
				cylinder { <0.454, 42.5411, -6.04878>, <0.226, 45.7513, -8.5696>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <0.226, 45.7513, -8.5696>, <-0.01642, 46.09618, -9.01695>, <0.06493, 46.3097, -8.882> }
					triangle { <-0.01642, 46.09618, -9.01695>, <-0.1713, 46.3737, -9.3631>, <0.06493, 46.3097, -8.882> }
					triangle { <0.06493, 46.3097, -8.882>, <-0.2088, 46.6685, -9.3088>, <-0.06036, 46.7914, -9.1657> }
					triangle { <-0.2088, 46.6685, -9.3088>, <-0.9011, 47.186, -9.236>, <-0.06036, 46.7914, -9.1657> }
					triangle { <0.06493, 46.3097, -8.882>, <-0.1713, 46.3737, -9.3631>, <-0.2088, 46.6685, -9.3088> }
					triangle { <-0.1713, 46.3737, -9.3631>, <-1.07223, 47.01126, -9.3782>, <-0.2088, 46.6685, -9.3088> }
					triangle { <-0.2088, 46.6685, -9.3088>, <-1.07223, 47.01126, -9.3782>, <-0.9011, 47.186, -9.236> }
					triangle { <-0.06036, 46.7914, -9.1657>, <-0.9011, 47.186, -9.236>, <-0.7433, 47.4296, -9.004936> }
					triangle { <-1.07223, 47.01126, -9.3782>, <-1.4284, 47.4413, -9.5121>, <-0.9011, 47.186, -9.236> }
					triangle { <-1.4284, 47.4413, -9.5121>, <-2.1421, 48.1603, -8.986>, <-1.2101, 47.6884, -9.3468> }
					triangle { <-0.9011, 47.186, -9.236>, <-1.4284, 47.4413, -9.5121>, <-1.2101, 47.6884, -9.3468> }
					triangle { <-0.7433, 47.4296, -9.004936>, <-0.9011, 47.186, -9.236>, <-1.2101, 47.6884, -9.3468> }
					triangle { <-0.7433, 47.4296, -9.004936>, <-1.2101, 47.6884, -9.3468>, <-1.05005, 47.9007, -9.0911> }
					triangle { <-1.2101, 47.6884, -9.3468>, <-2.1421, 48.1603, -8.986>, <-2.1944, 48.6222, -8.5228> }
					triangle { <-1.05005, 47.9007, -9.0911>, <-1.2101, 47.6884, -9.3468>, <-2.1944, 48.6222, -8.5228> }
					triangle { <0.06493, 46.3097, -8.882>, <0.3075, 46.3908, -8.8007>, <0.226, 45.7513, -8.5696> }
					triangle { <0.06493, 46.3097, -8.882>, <0.2385, 46.7593, -8.8442>, <0.3075, 46.3908, -8.8007> }
					triangle { <-0.06036, 46.7914, -9.1657>, <0.1552, 46.8834, -9.1329>, <0.06493, 46.3097, -8.882> }
					triangle { <-0.06036, 46.7914, -9.1657>, <-0.5139, 47.5796, -8.8347>, <0.1552, 46.8834, -9.1329> }
					triangle { <0.1552, 46.8834, -9.1329>, <0.2385, 46.7593, -8.8442>, <0.06493, 46.3097, -8.882> }
					triangle { <0.1552, 46.8834, -9.1329>, <-0.2305, 47.7076, -8.5675>, <0.2385, 46.7593, -8.8442> }
					triangle { <-0.5139, 47.5796, -8.8347>, <-0.2305, 47.7076, -8.5675>, <0.1552, 46.8834, -9.1329> }
					triangle { <-0.7433, 47.4296, -9.004936>, <-0.5139, 47.5796, -8.8347>, <-0.06036, 46.7914, -9.1657> }
					triangle { <-0.5139, 47.5796, -8.8347>, <-0.5482, 48.216, -8.5402>, <-0.2305, 47.7076, -8.5675> }
					triangle { <-0.8652, 48.1333, -8.8115>, <-1.6508, 48.7595, -8.3323>, <-0.5482, 48.216, -8.5402> }
					triangle { <-0.8652, 48.1333, -8.8115>, <-0.5482, 48.216, -8.5402>, <-0.5139, 47.5796, -8.8347> }
					triangle { <-0.8652, 48.1333, -8.8115>, <-0.5139, 47.5796, -8.8347>, <-0.7433, 47.4296, -9.004936> }
					triangle { <-1.05005, 47.9007, -9.0911>, <-0.8652, 48.1333, -8.8115>, <-0.7433, 47.4296, -9.004936> }
					triangle { <-2.1944, 48.6222, -8.5228>, <-1.6508, 48.7595, -8.3323>, <-0.8652, 48.1333, -8.8115> }
					triangle { <-2.1944, 48.6222, -8.5228>, <-0.8652, 48.1333, -8.8115>, <-1.05005, 47.9007, -9.0911> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.226, 45.7513, -8.5696>, <-0.003069, 46.2796, -8.7844>, <0.245, 46.3493, -8.848> }
					triangle { <-0.003069, 46.2796, -8.7844>, <-0.164, 46.6763, -8.9785>, <0.245, 46.3493, -8.848> }
					triangle { <0.245, 46.3493, -8.848>, <0.02958, 46.9014, -9.03375>, <0.2547, 46.8606, -9.1061> }
					triangle { <0.02958, 46.9014, -9.03375>, <0.1543, 47.6886, -8.6914>, <0.2547, 46.8606, -9.1061> }
					triangle { <0.245, 46.3493, -8.848>, <-0.164, 46.6763, -8.9785>, <0.02958, 46.9014, -9.03375> }
					triangle { <-0.164, 46.6763, -8.9785>, <-0.1061, 47.7048, -8.5823>, <0.02958, 46.9014, -9.03375> }
					triangle { <0.02958, 46.9014, -9.03375>, <-0.1061, 47.7048, -8.5823>, <0.1543, 47.6886, -8.6914> }
					triangle { <0.2547, 46.8606, -9.1061>, <0.1543, 47.6886, -8.6914>, <0.5173, 47.7064, -8.7665> }
					triangle { <-0.1061, 47.7048, -8.5823>, <-0.08271, 48.2784, -8.5677>, <0.1543, 47.6886, -8.6914> }
					triangle { <-0.08271, 48.2784, -8.5677>, <0.4959, 49.1006, -8.02724>, <0.2506, 48.28, -8.7256> }
					triangle { <0.1543, 47.6886, -8.6914>, <-0.08271, 48.2784, -8.5677>, <0.2506, 48.28, -8.7256> }
					triangle { <0.5173, 47.7064, -8.7665>, <0.1543, 47.6886, -8.6914>, <0.2506, 48.28, -8.7256> }
					triangle { <0.5173, 47.7064, -8.7665>, <0.2506, 48.28, -8.7256>, <0.6158, 48.2664, -8.776> }
					triangle { <0.2506, 48.28, -8.7256>, <0.4959, 49.1006, -8.02724>, <1.09232, 49.3438, -7.9012> }
					triangle { <0.6158, 48.2664, -8.776>, <0.2506, 48.28, -8.7256>, <1.09232, 49.3438, -7.9012> }
					triangle { <0.245, 46.3493, -8.848>, <0.4292, 46.237, -9.00768>, <0.226, 45.7513, -8.5696> }
					triangle { <0.245, 46.3493, -8.848>, <0.5786, 46.5632, -9.1248>, <0.4292, 46.237, -9.00768> }
					triangle { <0.2547, 46.8606, -9.1061>, <0.3992, 46.7865, -9.2784>, <0.245, 46.3493, -8.848> }
					triangle { <0.2547, 46.8606, -9.1061>, <0.8039, 47.6281, -8.8921>, <0.3992, 46.7865, -9.2784> }
					triangle { <0.3992, 46.7865, -9.2784>, <0.5786, 46.5632, -9.1248>, <0.245, 46.3493, -8.848> }
					triangle { <0.3992, 46.7865, -9.2784>, <1.17, 47.4734, -8.9924>, <0.5786, 46.5632, -9.1248> }
					triangle { <0.8039, 47.6281, -8.8921>, <1.17, 47.4734, -8.9924>, <0.3992, 46.7865, -9.2784> }
					triangle { <0.5173, 47.7064, -8.7665>, <0.8039, 47.6281, -8.8921>, <0.2547, 46.8606, -9.1061> }
					triangle { <0.8039, 47.6281, -8.8921>, <1.3732, 48.03601, -8.9432>, <1.17, 47.4734, -8.9924> }
					triangle { <1.01851, 48.2459, -8.8384>, <1.4868, 49.05718, -8.2371>, <1.3732, 48.03601, -8.9432> }
					triangle { <1.01851, 48.2459, -8.8384>, <1.3732, 48.03601, -8.9432>, <0.8039, 47.6281, -8.8921> }
					triangle { <1.01851, 48.2459, -8.8384>, <0.8039, 47.6281, -8.8921>, <0.5173, 47.7064, -8.7665> }
					triangle { <0.6158, 48.2664, -8.776>, <1.01851, 48.2459, -8.8384>, <0.5173, 47.7064, -8.7665> }
					triangle { <1.09232, 49.3438, -7.9012>, <1.4868, 49.05718, -8.2371>, <1.01851, 48.2459, -8.8384> }
					triangle { <1.09232, 49.3438, -7.9012>, <1.01851, 48.2459, -8.8384>, <0.6158, 48.2664, -8.776> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.226, 45.7513, -8.5696>, <0.2819, 46.3417, -8.7312>, <0.35, 46.258, -8.9737> }
					triangle { <0.2819, 46.3417, -8.7312>, <0.3021, 46.7873, -8.8793>, <0.35, 46.258, -8.9737> }
					triangle { <0.35, 46.258, -8.9737>, <0.4458, 46.8494, -9.1376>, <0.4386, 46.7009, -9.326> }
					triangle { <0.4458, 46.8494, -9.1376>, <1.1858, 47.257, -9.3343>, <0.4386, 46.7009, -9.326> }
					triangle { <0.35, 46.258, -8.9737>, <0.3021, 46.7873, -8.8793>, <0.4458, 46.8494, -9.1376> }
					triangle { <0.3021, 46.7873, -8.8793>, <1.1964, 47.3989, -9.08978>, <0.4458, 46.8494, -9.1376> }
					triangle { <0.4458, 46.8494, -9.1376>, <1.1964, 47.3989, -9.08978>, <1.1858, 47.257, -9.3343> }
					triangle { <0.4386, 46.7009, -9.326>, <1.1858, 47.257, -9.3343>, <1.2525, 47.06772, -9.6463> }
					triangle { <1.1964, 47.3989, -9.08978>, <1.5337, 47.803, -9.3192>, <1.1858, 47.257, -9.3343> }
					triangle { <1.5337, 47.803, -9.3192>, <2.5889, 47.9017, -9.7433>, <1.5184, 47.6431, -9.6513> }
					triangle { <1.1858, 47.257, -9.3343>, <1.5337, 47.803, -9.3192>, <1.5184, 47.6431, -9.6513> }
					triangle { <1.2525, 47.06772, -9.6463>, <1.1858, 47.257, -9.3343>, <1.5184, 47.6431, -9.6513> }
					triangle { <1.2525, 47.06772, -9.6463>, <1.5184, 47.6431, -9.6513>, <1.5874, 47.4224, -9.9387> }
					triangle { <1.5184, 47.6431, -9.6513>, <2.5889, 47.9017, -9.7433>, <3.009266, 47.6786, -10.1951> }
					triangle { <1.5874, 47.4224, -9.9387>, <1.5184, 47.6431, -9.6513>, <3.009266, 47.6786, -10.1951> }
					triangle { <0.35, 46.258, -8.9737>, <0.223, 46.1065, -9.1551>, <0.226, 45.7513, -8.5696> }
					triangle { <0.35, 46.258, -8.9737>, <0.3612, 46.2876, -9.4561>, <0.223, 46.1065, -9.1551> }
					triangle { <0.4386, 46.7009, -9.326>, <0.3105, 46.6055, -9.5008>, <0.35, 46.258, -8.9737> }
					triangle { <0.4386, 46.7009, -9.326>, <1.203, 46.8686, -9.8953>, <0.3105, 46.6055, -9.5008> }
					triangle { <0.3105, 46.6055, -9.5008>, <0.3612, 46.2876, -9.4561>, <0.35, 46.258, -8.9737> }
					triangle { <0.3105, 46.6055, -9.5008>, <1.1554, 46.5573, -10.1577>, <0.3612, 46.2876, -9.4561> }
					triangle { <1.203, 46.8686, -9.8953>, <1.1554, 46.5573, -10.1577>, <0.3105, 46.6055, -9.5008> }
					triangle { <1.2525, 47.06772, -9.6463>, <1.203, 46.8686, -9.8953>, <0.4386, 46.7009, -9.326> }
					triangle { <1.203, 46.8686, -9.8953>, <1.5699, 46.8331, -10.4929>, <1.1554, 46.5573, -10.1577> }
					triangle { <1.6552, 47.1768, -10.2574>, <2.7163, 47.3183, -10.5625>, <1.5699, 46.8331, -10.4929> }
					triangle { <1.6552, 47.1768, -10.2574>, <1.5699, 46.8331, -10.4929>, <1.203, 46.8686, -9.8953> }
					triangle { <1.6552, 47.1768, -10.2574>, <1.203, 46.8686, -9.8953>, <1.2525, 47.06772, -9.6463> }
					triangle { <1.5874, 47.4224, -9.9387>, <1.6552, 47.1768, -10.2574>, <1.2525, 47.06772, -9.6463> }
					triangle { <3.009266, 47.6786, -10.1951>, <2.7163, 47.3183, -10.5625>, <1.6552, 47.1768, -10.2574> }
					triangle { <3.009266, 47.6786, -10.1951>, <1.6552, 47.1768, -10.2574>, <1.5874, 47.4224, -9.9387> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.226, 45.7513, -8.5696>, <0.4473, 46.1971, -8.9303>, <0.2358, 46.1612, -9.08662> }
					triangle { <0.4473, 46.1971, -8.9303>, <0.5873, 46.5544, -9.2016>, <0.2358, 46.1612, -9.08662> }
					triangle { <0.2358, 46.1612, -9.08662>, <0.4685, 46.5839, -9.4778>, <0.2387, 46.5315, -9.5237> }
					triangle { <0.4685, 46.5839, -9.4778>, <0.7773, 46.4837, -10.2822>, <0.2387, 46.5315, -9.5237> }
					triangle { <0.2358, 46.1612, -9.08662>, <0.5873, 46.5544, -9.2016>, <0.4685, 46.5839, -9.4778> }
					triangle { <0.5873, 46.5544, -9.2016>, <1.04759, 46.5133, -10.204>, <0.4685, 46.5839, -9.4778> }
					triangle { <0.4685, 46.5839, -9.4778>, <1.04759, 46.5133, -10.204>, <0.7773, 46.4837, -10.2822> }
					triangle { <0.2387, 46.5315, -9.5237>, <0.7773, 46.4837, -10.2822>, <0.4532, 46.3902, -10.4367> }
					triangle { <1.04759, 46.5133, -10.204>, <1.202, 46.6677, -10.7351>, <0.7773, 46.4837, -10.2822> }
					triangle { <1.202, 46.6677, -10.7351>, <1.2639, 46.2092, -11.7787>, <0.8529, 46.652, -10.8532> }
					triangle { <0.7773, 46.4837, -10.2822>, <1.202, 46.6677, -10.7351>, <0.8529, 46.652, -10.8532> }
					triangle { <0.4532, 46.3902, -10.4367>, <0.7773, 46.4837, -10.2822>, <0.8529, 46.652, -10.8532> }
					triangle { <0.4532, 46.3902, -10.4367>, <0.8529, 46.652, -10.8532>, <0.531, 46.5271, -10.9831> }
					triangle { <0.8529, 46.652, -10.8532>, <1.2639, 46.2092, -11.7787>, <0.9251, 45.9123, -12.2558> }
					triangle { <0.531, 46.5271, -10.9831>, <0.8529, 46.652, -10.8532>, <0.9251, 45.9123, -12.2558> }
					triangle { <0.2358, 46.1612, -9.08662>, <-0.02803, 46.1785, -9.04081>, <0.226, 45.7513, -8.5696> }
					triangle { <0.2358, 46.1612, -9.08662>, <-0.1152, 46.3109, -9.3833>, <-0.02803, 46.1785, -9.04081> }
					triangle { <0.2387, 46.5315, -9.5237>, <0.01093, 46.5889, -9.4949>, <0.2358, 46.1612, -9.08662> }
					triangle { <0.2387, 46.5315, -9.5237>, <0.1354, 46.3436, -10.4673>, <0.01093, 46.5889, -9.4949> }
					triangle { <0.01093, 46.5889, -9.4949>, <-0.1152, 46.3109, -9.3833>, <0.2358, 46.1612, -9.08662> }
					triangle { <0.01093, 46.5889, -9.4949>, <-0.2543, 46.2168, -10.4639>, <-0.1152, 46.3109, -9.3833> }
					triangle { <0.1354, 46.3436, -10.4673>, <-0.2543, 46.2168, -10.4639>, <0.01093, 46.5889, -9.4949> }
					triangle { <0.4532, 46.3902, -10.4367>, <0.1354, 46.3436, -10.4673>, <0.2387, 46.5315, -9.5237> }
					triangle { <0.1354, 46.3436, -10.4673>, <-0.228, 46.2585, -11.06202>, <-0.2543, 46.2168, -10.4639> }
					triangle { <0.1709, 46.3935, -11.1207>, <0.3499, 45.9298, -12.1166>, <-0.228, 46.2585, -11.06202> }
					triangle { <0.1709, 46.3935, -11.1207>, <-0.228, 46.2585, -11.06202>, <0.1354, 46.3436, -10.4673> }
					triangle { <0.1709, 46.3935, -11.1207>, <0.1354, 46.3436, -10.4673>, <0.4532, 46.3902, -10.4367> }
					triangle { <0.531, 46.5271, -10.9831>, <0.1709, 46.3935, -11.1207>, <0.4532, 46.3902, -10.4367> }
					triangle { <0.9251, 45.9123, -12.2558>, <0.3499, 45.9298, -12.1166>, <0.1709, 46.3935, -11.1207> }
					triangle { <0.9251, 45.9123, -12.2558>, <0.1709, 46.3935, -11.1207>, <0.531, 46.5271, -10.9831> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.226, 45.7513, -8.5696>, <0.2601, 46.0431, -9.1095>, <0.05698, 46.1937, -9.02913> }
					triangle { <0.2601, 46.0431, -9.1095>, <0.2903, 46.295, -9.5052>, <0.05698, 46.1937, -9.02913> }
					triangle { <0.05698, 46.1937, -9.02913>, <0.05776, 46.4704, -9.5852>, <-0.07427, 46.5883, -9.423> }
					triangle { <0.05776, 46.4704, -9.5852>, <-0.5319, 46.4391, -10.2205>, <-0.07427, 46.5883, -9.423> }
					triangle { <0.05698, 46.1937, -9.02913>, <0.2903, 46.295, -9.5052>, <0.05776, 46.4704, -9.5852> }
					triangle { <0.2903, 46.295, -9.5052>, <-0.3757, 46.2701, -10.3849>, <0.05776, 46.4704, -9.5852> }
					triangle { <0.05776, 46.4704, -9.5852>, <-0.3757, 46.2701, -10.3849>, <-0.5319, 46.4391, -10.2205> }
					triangle { <-0.07427, 46.5883, -9.423>, <-0.5319, 46.4391, -10.2205>, <-0.7989, 46.6173, -10.03436> }
					triangle { <-0.3757, 46.2701, -10.3849>, <-0.6563, 46.4407, -10.856>, <-0.5319, 46.4391, -10.2205> }
					triangle { <-0.6563, 46.4407, -10.856>, <-1.7041, 46.3715, -11.3036>, <-0.8588, 46.6805, -10.6622> }
					triangle { <-0.5319, 46.4391, -10.2205>, <-0.6563, 46.4407, -10.856>, <-0.8588, 46.6805, -10.6622> }
					triangle { <-0.7989, 46.6173, -10.03436>, <-0.5319, 46.4391, -10.2205>, <-0.8588, 46.6805, -10.6622> }
					triangle { <-0.7989, 46.6173, -10.03436>, <-0.8588, 46.6805, -10.6622>, <-1.1235, 46.8272, -10.4514> }
					triangle { <-0.8588, 46.6805, -10.6622>, <-1.7041, 46.3715, -11.3036>, <-2.3394, 46.5044, -11.2067> }
					triangle { <-1.1235, 46.8272, -10.4514>, <-0.8588, 46.6805, -10.6622>, <-2.3394, 46.5044, -11.2067> }
					triangle { <0.05698, 46.1937, -9.02913>, <0.02496, 46.3569, -8.8184>, <0.226, 45.7513, -8.5696> }
					triangle { <0.05698, 46.1937, -9.02913>, <-0.1922, 46.6069, -8.9995>, <0.02496, 46.3569, -8.8184> }
					triangle { <-0.07427, 46.5883, -9.423>, <-0.08651, 46.7632, -9.2641>, <0.05698, 46.1937, -9.02913> }
					triangle { <-0.07427, 46.5883, -9.423>, <-0.9416, 46.7896, -9.802>, <-0.08651, 46.7632, -9.2641> }
					triangle { <-0.08651, 46.7632, -9.2641>, <-0.1922, 46.6069, -8.9995>, <0.05698, 46.1937, -9.02913> }
					triangle { <-0.08651, 46.7632, -9.2641>, <-1.1239, 46.9384, -9.4662>, <-0.1922, 46.6069, -8.9995> }
					triangle { <-0.9416, 46.7896, -9.802>, <-1.1239, 46.9384, -9.4662>, <-0.08651, 46.7632, -9.2641> }
					triangle { <-0.7989, 46.6173, -10.03436>, <-0.9416, 46.7896, -9.802>, <-0.07427, 46.5883, -9.423> }
					triangle { <-0.9416, 46.7896, -9.802>, <-1.5569, 47.1261, -9.8369>, <-1.1239, 46.9384, -9.4662> }
					triangle { <-1.4103, 46.9936, -10.2135>, <-2.3898, 46.834, -10.7175>, <-1.5569, 47.1261, -9.8369> }
					triangle { <-1.4103, 46.9936, -10.2135>, <-1.5569, 47.1261, -9.8369>, <-0.9416, 46.7896, -9.802> }
					triangle { <-1.4103, 46.9936, -10.2135>, <-0.9416, 46.7896, -9.802>, <-0.7989, 46.6173, -10.03436> }
					triangle { <-1.1235, 46.8272, -10.4514>, <-1.4103, 46.9936, -10.2135>, <-0.7989, 46.6173, -10.03436> }
					triangle { <-2.3394, 46.5044, -11.2067>, <-2.3898, 46.834, -10.7175>, <-1.4103, 46.9936, -10.2135> }
					triangle { <-2.3394, 46.5044, -11.2067>, <-1.4103, 46.9936, -10.2135>, <-1.1235, 46.8272, -10.4514> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		}
	union { // internode
		cylinder { <0.07762, 2.01992, 0.1645>, <0.068, 2.1139, 0.184>, 0.4 }
		cylinder { <0.068, 2.1139, 0.184>, <0.06073, 2.2082, 0.2034>, 0.4 }
		cylinder { <0.06073, 2.2082, 0.2034>, <0.05581, 2.3027, 0.2227>, 0.4 }
		cylinder { <0.05581, 2.3027, 0.2227>, <0.05327, 2.3973, 0.2418>, 0.4 }
		cylinder { <0.05327, 2.3973, 0.2418>, <0.05308, 2.4919, 0.2609>, 0.4 }
		cylinder { <0.05308, 2.4919, 0.2609>, <0.05526, 2.5866, 0.2798>, 0.4 }
		cylinder { <0.05526, 2.5866, 0.2798>, <0.05981, 2.6812, 0.2985>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.05981, 2.6812, 0.2985>, <-0.7958, 9.3796, 1.6986>, 0.8459 }
			cylinder { <-0.7958, 9.3796, 1.6986>, <-2.8064, 15.8215, 3.1201>, 0.8459 }
			cylinder { <-2.8064, 15.8215, 3.1201>, <-5.913, 21.8172, 4.521>, 0.8459 }
			cylinder { <-5.913, 21.8172, 4.521>, <-10.02394, 27.1902, 5.8601>, 0.8459 }
			cylinder { <-10.02394, 27.1902, 5.8601>, <-15.01821, 31.7821, 7.09805>, 0.8459 }
			cylinder { <-15.01821, 31.7821, 7.09805>, <-20.7487, 35.458, 8.1982>, 0.8459 }
			cylinder { <-20.7487, 35.458, 8.1982>, <-27.04688, 38.1094, 9.1284>, 0.8459 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <-27.04688, 38.1094, 9.1284>, <-23.03947, 32.9047, 12.2446>, <-27.9027, 36.5414, 17.1279> }
			triangle { <-27.04688, 38.1094, 9.1284>, <-27.9027, 36.5414, 17.1279>, <-32.8614, 39.4937, 17.09918> }
			triangle { <-23.03947, 32.9047, 12.2446>, <-22.04214, 30.7886, 15.7045>, <-27.9027, 36.5414, 17.1279> }
			triangle { <-22.04214, 30.7886, 15.7045>, <-25.4983, 31.3815, 18.5873>, <-27.9027, 36.5414, 17.1279> }
			triangle { <-25.4983, 31.3815, 18.5873>, <-31.4645, 33.536, 20.2279>, <-27.9027, 36.5414, 17.1279> }
			triangle { <-31.4645, 33.536, 20.2279>, <-37.7737, 36.2814, 20.9698>, <-32.8614, 39.4937, 17.09918> }
			triangle { <-27.9027, 36.5414, 17.1279>, <-31.4645, 33.536, 20.2279>, <-32.8614, 39.4937, 17.09918> }
			triangle { <-32.8614, 39.4937, 17.09918>, <-38.939, 40.6187, 17.8119>, <-37.8281, 42.5335, 13.6592> }
			triangle { <-38.939, 40.6187, 17.8119>, <-44.1097, 40.2267, 18.1101>, <-43.1797, 42.9064, 15.214> }
			triangle { <-38.939, 40.6187, 17.8119>, <-43.1797, 42.9064, 15.214>, <-37.8281, 42.5335, 13.6592> }
			triangle { <-37.8281, 42.5335, 13.6592>, <-43.1797, 42.9064, 15.214>, <-42.04205, 43.7946, 11.06076> }
			triangle { <-44.1097, 40.2267, 18.1101>, <-49.9321, 42.1318, 13.6642>, <-43.1797, 42.9064, 15.214> }
			triangle { <-43.1797, 42.9064, 15.214>, <-49.9321, 42.1318, 13.6642>, <-42.04205, 43.7946, 11.06076> }
			triangle { <-27.04688, 38.1094, 9.1284>, <-32.8614, 39.4937, 17.09918>, <-33.00256, 41.03506, 10.1961> }
			triangle { <-33.00256, 41.03506, 10.1961>, <-32.8614, 39.4937, 17.09918>, <-37.8281, 42.5335, 13.6592> }
			triangle { <-33.00256, 41.03506, 10.1961>, <-37.8281, 42.5335, 13.6592>, <-37.7883, 43.04979, 10.9029> }
			triangle { <-37.8281, 42.5335, 13.6592>, <-42.04205, 43.7946, 11.06076>, <-37.7883, 43.04979, 10.9029> }
			triangle { <-37.7737, 36.2814, 20.9698>, <-38.939, 40.6187, 17.8119>, <-32.8614, 39.4937, 17.09918> }
			triangle { <-37.7737, 36.2814, 20.9698>, <-44.1097, 40.2267, 18.1101>, <-38.939, 40.6187, 17.8119> }
			triangle { <-27.2977, 43.0718, 2.6096>, <-22.6732, 36.8573, 3.4572>, <-27.04688, 38.1094, 9.1284> }
			triangle { <-32.336, 45.1648, 4.4911>, <-27.2977, 43.0718, 2.6096>, <-27.04688, 38.1094, 9.1284> }
			triangle { <-27.2977, 43.0718, 2.6096>, <-21.3734, 38.00635, -0.3419>, <-22.6732, 36.8573, 3.4572> }
			triangle { <-27.2977, 43.0718, 2.6096>, <-24.6386, 40.6614, -2.04393>, <-21.3734, 38.00635, -0.3419> }
			triangle { <-27.2977, 43.0718, 2.6096>, <-30.5411, 43.5034, -1.9316>, <-24.6386, 40.6614, -2.04393> }
			triangle { <-32.336, 45.1648, 4.4911>, <-36.8662, 46.07693, -0.8076>, <-30.5411, 43.5034, -1.9316> }
			triangle { <-32.336, 45.1648, 4.4911>, <-30.5411, 43.5034, -1.9316>, <-27.2977, 43.0718, 2.6096> }
			triangle { <-37.6211, 44.7675, 8.6924>, <-37.7865, 47.8471, 5.01051>, <-32.336, 45.1648, 4.4911> }
			triangle { <-42.9463, 46.17, 7.4913>, <-43.5047, 46.757, 3.5918>, <-37.7865, 47.8471, 5.01051> }
			triangle { <-37.6211, 44.7675, 8.6924>, <-42.9463, 46.17, 7.4913>, <-37.7865, 47.8471, 5.01051> }
			triangle { <-42.04205, 43.7946, 11.06076>, <-42.9463, 46.17, 7.4913>, <-37.6211, 44.7675, 8.6924> }
			triangle { <-42.9463, 46.17, 7.4913>, <-49.5923, 45.0548, 7.6327>, <-43.5047, 46.757, 3.5918> }
			triangle { <-42.04205, 43.7946, 11.06076>, <-49.5923, 45.0548, 7.6327>, <-42.9463, 46.17, 7.4913> }
			triangle { <-33.00256, 41.03506, 10.1961>, <-32.336, 45.1648, 4.4911>, <-27.04688, 38.1094, 9.1284> }
			triangle { <-37.6211, 44.7675, 8.6924>, <-32.336, 45.1648, 4.4911>, <-33.00256, 41.03506, 10.1961> }
			triangle { <-37.7883, 43.04979, 10.9029>, <-37.6211, 44.7675, 8.6924>, <-33.00256, 41.03506, 10.1961> }
			triangle { <-37.7883, 43.04979, 10.9029>, <-42.04205, 43.7946, 11.06076>, <-37.6211, 44.7675, 8.6924> }
			triangle { <-32.336, 45.1648, 4.4911>, <-37.7865, 47.8471, 5.01051>, <-36.8662, 46.07693, -0.8076> }
			triangle { <-37.7865, 47.8471, 5.01051>, <-43.5047, 46.757, 3.5918>, <-36.8662, 46.07693, -0.8076> }
			triangle { <-42.04205, 43.7946, 11.06076>, <-49.9321, 42.1318, 13.6642>, <-49.9111, 43.7605, 10.7175> }
			triangle { <-49.9321, 42.1318, 13.6642>, <-54.3132, 41.8485, 9.674>, <-49.9111, 43.7605, 10.7175> }
			triangle { <-42.04205, 43.7946, 11.06076>, <-49.9111, 43.7605, 10.7175>, <-49.5923, 45.0548, 7.6327> }
			triangle { <-49.9111, 43.7605, 10.7175>, <-54.3132, 41.8485, 9.674>, <-49.5923, 45.0548, 7.6327> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <0.05981, 2.6812, 0.2985>, <0.1278, 3.4975, 0.4568>, 0.3888 }
			cylinder { <0.1278, 3.4975, 0.4568>, <0.2244, 4.3116, 0.6114>, 0.3888 }
			cylinder { <0.2244, 4.3116, 0.6114>, <0.3495, 5.1226, 0.7622>, 0.3888 }
			cylinder { <0.3495, 5.1226, 0.7622>, <0.5031, 5.9294, 0.9089>, 0.3888 }
			cylinder { <0.5031, 5.9294, 0.9089>, <0.6848, 6.731, 1.05153>, 0.3888 }
			cylinder { <0.6848, 6.731, 1.05153>, <0.8944, 7.5266, 1.1897>, 0.3888 }
			cylinder { <0.8944, 7.5266, 1.1897>, <1.1318, 8.3152, 1.3233>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.1318, 8.3152, 1.3233>, <2.8711, 11.8468, 2.4254>, 0.3888 }
				cylinder { <2.8711, 11.8468, 2.4254>, <5.1195, 14.9104, 3.9324>, 0.3888 }
				cylinder { <5.1195, 14.9104, 3.9324>, <7.7906, 17.3882, 5.7864>, 0.3888 }
				cylinder { <7.7906, 17.3882, 5.7864>, <10.7819, 19.185, 7.9161>, 0.3888 }
				cylinder { <10.7819, 19.185, 7.9161>, <13.9783, 20.2318, 10.2397>, 0.3888 }
				cylinder { <13.9783, 20.2318, 10.2397>, <17.257, 20.4883, 12.6679>, 0.3888 }
				cylinder { <17.257, 20.4883, 12.6679>, <20.492, 19.9447, 15.1073>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <20.492, 19.9447, 15.1073>, <21.06422, 19.6633, 15.3057>, <21.1454, 19.9228, 15.4014> }
					triangle { <21.06422, 19.6633, 15.3057>, <21.4944, 19.4601, 15.4912>, <21.1454, 19.9228, 15.4014> }
					triangle { <21.1454, 19.9228, 15.4014>, <21.7434, 19.659, 15.5695>, <21.7043, 19.8948, 15.6738> }
					triangle { <21.7434, 19.659, 15.5695>, <22.5964, 19.8186, 15.2022>, <21.7043, 19.8948, 15.6738> }
					triangle { <21.1454, 19.9228, 15.4014>, <21.4944, 19.4601, 15.4912>, <21.7434, 19.659, 15.5695> }
					triangle { <21.4944, 19.4601, 15.4912>, <22.6076, 19.5493, 15.0546>, <21.7434, 19.659, 15.5695> }
					triangle { <21.7434, 19.659, 15.5695>, <22.6076, 19.5493, 15.0546>, <22.5964, 19.8186, 15.2022> }
					triangle { <21.7043, 19.8948, 15.6738>, <22.5964, 19.8186, 15.2022>, <22.6237, 20.2019, 15.3242> }
					triangle { <22.6076, 19.5493, 15.0546>, <23.2309, 19.5659, 15.03303>, <22.5964, 19.8186, 15.2022> }
					triangle { <23.2309, 19.5659, 15.03303>, <24.1282, 20.2378, 14.5026>, <23.2411, 19.9081, 15.2414> }
					triangle { <22.5964, 19.8186, 15.2022>, <23.2309, 19.5659, 15.03303>, <23.2411, 19.9081, 15.2414> }
					triangle { <22.6237, 20.2019, 15.3242>, <22.5964, 19.8186, 15.2022>, <23.2411, 19.9081, 15.2414> }
					triangle { <22.6237, 20.2019, 15.3242>, <23.2411, 19.9081, 15.2414>, <23.234, 20.2971, 15.3374> }
					triangle { <23.2411, 19.9081, 15.2414>, <24.1282, 20.2378, 14.5026>, <24.4023, 20.892, 14.4305> }
					triangle { <23.234, 20.2971, 15.3374>, <23.2411, 19.9081, 15.2414>, <24.4023, 20.892, 14.4305> }
					triangle { <21.1454, 19.9228, 15.4014>, <21.02912, 20.1057, 15.5965>, <20.492, 19.9447, 15.1073> }
					triangle { <21.1454, 19.9228, 15.4014>, <21.3878, 20.2479, 15.7352>, <21.02912, 20.1057, 15.5965> }
					triangle { <21.7043, 19.8948, 15.6738>, <21.6289, 20.03266, 15.8774>, <21.1454, 19.9228, 15.4014> }
					triangle { <21.7043, 19.8948, 15.6738>, <22.5459, 20.4986, 15.4936>, <21.6289, 20.03266, 15.8774> }
					triangle { <21.6289, 20.03266, 15.8774>, <21.3878, 20.2479, 15.7352>, <21.1454, 19.9228, 15.4014> }
					triangle { <21.6289, 20.03266, 15.8774>, <22.3862, 20.8855, 15.6459>, <21.3878, 20.2479, 15.7352> }
					triangle { <22.5459, 20.4986, 15.4936>, <22.3862, 20.8855, 15.6459>, <21.6289, 20.03266, 15.8774> }
					triangle { <22.6237, 20.2019, 15.3242>, <22.5459, 20.4986, 15.4936>, <21.7043, 19.8948, 15.6738> }
					triangle { <22.5459, 20.4986, 15.4936>, <23.00064, 21.1005, 15.6074>, <22.3862, 20.8855, 15.6459> }
					triangle { <23.2204, 20.7254, 15.4509>, <24.1029, 21.2851, 14.8423>, <23.00064, 21.1005, 15.6074> }
					triangle { <23.2204, 20.7254, 15.4509>, <23.00064, 21.1005, 15.6074>, <22.5459, 20.4986, 15.4936> }
					triangle { <23.2204, 20.7254, 15.4509>, <22.5459, 20.4986, 15.4936>, <22.6237, 20.2019, 15.3242> }
					triangle { <23.234, 20.2971, 15.3374>, <23.2204, 20.7254, 15.4509>, <22.6237, 20.2019, 15.3242> }
					triangle { <24.4023, 20.892, 14.4305>, <24.1029, 21.2851, 14.8423>, <23.2204, 20.7254, 15.4509> }
					triangle { <24.4023, 20.892, 14.4305>, <23.2204, 20.7254, 15.4509>, <23.234, 20.2971, 15.3374> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <20.492, 19.9447, 15.1073>, <21.1364, 19.9761, 15.2795>, <21.05002, 20.02368, 15.5505> }
					triangle { <21.1364, 19.9761, 15.2795>, <21.6227, 19.973, 15.4352>, <21.05002, 20.02368, 15.5505> }
					triangle { <21.05002, 20.02368, 15.5505>, <21.6963, 20.09789, 15.7297>, <21.5372, 20.07132, 15.9347> }
					triangle { <21.6963, 20.09789, 15.7297>, <22.1559, 20.8675, 16.0202>, <21.5372, 20.07132, 15.9347> }
					triangle { <21.05002, 20.02368, 15.5505>, <21.6227, 19.973, 15.4352>, <21.6963, 20.09789, 15.7297> }
					triangle { <21.6227, 19.973, 15.4352>, <22.307, 20.9043, 15.7551>, <21.6963, 20.09789, 15.7297> }
					triangle { <21.6963, 20.09789, 15.7297>, <22.307, 20.9043, 15.7551>, <22.1559, 20.8675, 16.0202> }
					triangle { <21.5372, 20.07132, 15.9347>, <22.1559, 20.8675, 16.0202>, <21.9555, 20.9076, 16.3676> }
					triangle { <22.307, 20.9043, 15.7551>, <22.7555, 21.2353, 16.03537>, <22.1559, 20.8675, 16.0202> }
					triangle { <22.7555, 21.2353, 16.03537>, <22.8886, 22.3253, 16.6117>, <22.5858, 21.1839, 16.3947> }
					triangle { <22.1559, 20.8675, 16.0202>, <22.7555, 21.2353, 16.03537>, <22.5858, 21.1839, 16.3947> }
					triangle { <21.9555, 20.9076, 16.3676>, <22.1559, 20.8675, 16.0202>, <22.5858, 21.1839, 16.3947> }
					triangle { <21.9555, 20.9076, 16.3676>, <22.5858, 21.1839, 16.3947>, <22.351, 21.2297, 16.7162> }
					triangle { <22.5858, 21.1839, 16.3947>, <22.8886, 22.3253, 16.6117>, <22.6602, 22.732, 17.1509> }
					triangle { <22.351, 21.2297, 16.7162>, <22.5858, 21.1839, 16.3947>, <22.6602, 22.732, 17.1509> }
					triangle { <21.05002, 20.02368, 15.5505>, <20.8852, 19.8685, 15.7344>, <20.492, 19.9447, 15.1073> }
					triangle { <21.05002, 20.02368, 15.5505>, <21.08854, 19.9804, 16.07253>, <20.8852, 19.8685, 15.7344> }
					triangle { <21.5372, 20.07132, 15.9347>, <21.4334, 19.9148, 16.1104>, <21.05002, 20.02368, 15.5505> }
					triangle { <21.5372, 20.07132, 15.9347>, <21.7416, 20.8293, 16.6339>, <21.4334, 19.9148, 16.1104> }
					triangle { <21.4334, 19.9148, 16.1104>, <21.08854, 19.9804, 16.07253>, <21.05002, 20.02368, 15.5505> }
					triangle { <21.4334, 19.9148, 16.1104>, <21.4058, 20.7538, 16.9167>, <21.08854, 19.9804, 16.07253> }
					triangle { <21.7416, 20.8293, 16.6339>, <21.4058, 20.7538, 16.9167>, <21.4334, 19.9148, 16.1104> }
					triangle { <21.9555, 20.9076, 16.3676>, <21.7416, 20.8293, 16.6339>, <21.5372, 20.07132, 15.9347> }
					triangle { <21.7416, 20.8293, 16.6339>, <21.7177, 21.1585, 17.3217>, <21.4058, 20.7538, 16.9167> }
					triangle { <22.08978, 21.2711, 17.07197>, <22.2679, 22.3802, 17.5198>, <21.7177, 21.1585, 17.3217> }
					triangle { <22.08978, 21.2711, 17.07197>, <21.7177, 21.1585, 17.3217>, <21.7416, 20.8293, 16.6339> }
					triangle { <22.08978, 21.2711, 17.07197>, <21.7416, 20.8293, 16.6339>, <21.9555, 20.9076, 16.3676> }
					triangle { <22.351, 21.2297, 16.7162>, <22.08978, 21.2711, 17.07197>, <21.9555, 20.9076, 16.3676> }
					triangle { <22.6602, 22.732, 17.1509>, <22.2679, 22.3802, 17.5198>, <22.08978, 21.2711, 17.07197> }
					triangle { <22.6602, 22.732, 17.1509>, <22.08978, 21.2711, 17.07197>, <22.351, 21.2297, 16.7162> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <20.492, 19.9447, 15.1073>, <20.9851, 20.1347, 15.5155>, <20.9441, 19.8892, 15.6609> }
					triangle { <20.9851, 20.1347, 15.5155>, <21.3794, 20.2487, 15.8193>, <20.9441, 19.8892, 15.6609> }
					triangle { <20.9441, 19.8892, 15.6609>, <21.4126, 20.08848, 16.1038>, <21.3519, 19.836, 16.128> }
					triangle { <21.4126, 20.08848, 16.1038>, <21.3201, 20.3324, 17.00931>, <21.3519, 19.836, 16.128> }
					triangle { <20.9441, 19.8892, 15.6609>, <21.3794, 20.2487, 15.8193>, <21.4126, 20.08848, 16.1038> }
					triangle { <21.3794, 20.2487, 15.8193>, <21.3565, 20.6327, 16.955>, <21.4126, 20.08848, 16.1038> }
					triangle { <21.4126, 20.08848, 16.1038>, <21.3565, 20.6327, 16.955>, <21.3201, 20.3324, 17.00931> }
					triangle { <21.3519, 19.836, 16.128>, <21.3201, 20.3324, 17.00931>, <21.2143, 19.9664, 17.1409> }
					triangle { <21.3565, 20.6327, 16.955>, <21.534, 20.7364, 17.5441>, <21.3201, 20.3324, 17.00931> }
					triangle { <21.534, 20.7364, 17.5441>, <21.05065, 20.6929, 18.6853>, <21.5117, 20.3462, 17.6323> }
					triangle { <21.3201, 20.3324, 17.00931>, <21.534, 20.7364, 17.5441>, <21.5117, 20.3462, 17.6323> }
					triangle { <21.2143, 19.9664, 17.1409>, <21.3201, 20.3324, 17.00931>, <21.5117, 20.3462, 17.6323> }
					triangle { <21.2143, 19.9664, 17.1409>, <21.5117, 20.3462, 17.6323>, <21.3715, 19.9859, 17.738> }
					triangle { <21.5117, 20.3462, 17.6323>, <21.05065, 20.6929, 18.6853>, <20.7277, 20.278, 19.1668> }
					triangle { <21.3715, 19.9859, 17.738>, <21.5117, 20.3462, 17.6323>, <20.7277, 20.278, 19.1668> }
					triangle { <20.9441, 19.8892, 15.6609>, <20.9571, 19.609, 15.5812>, <20.492, 19.9447, 15.1073> }
					triangle { <20.9441, 19.8892, 15.6609>, <21.1036, 19.4734, 15.9395>, <20.9571, 19.609, 15.5812> }
					triangle { <21.3519, 19.836, 16.128>, <21.4095, 19.5921, 16.07026>, <20.9441, 19.8892, 15.6609> }
					triangle { <21.3519, 19.836, 16.128>, <21.1579, 19.6205, 17.1386>, <21.4095, 19.5921, 16.07026> }
					triangle { <21.4095, 19.5921, 16.07026>, <21.1036, 19.4734, 15.9395>, <20.9441, 19.8892, 15.6609> }
					triangle { <21.4095, 19.5921, 16.07026>, <21.01254, 19.202, 17.09251>, <21.1036, 19.4734, 15.9395> }
					triangle { <21.1579, 19.6205, 17.1386>, <21.01254, 19.202, 17.09251>, <21.4095, 19.5921, 16.07026> }
					triangle { <21.2143, 19.9664, 17.1409>, <21.1579, 19.6205, 17.1386>, <21.3519, 19.836, 16.128> }
					triangle { <21.1579, 19.6205, 17.1386>, <21.06598, 19.1617, 17.741>, <21.01254, 19.202, 17.09251> }
					triangle { <21.2212, 19.5836, 17.8477>, <20.7337, 19.6721, 18.9509>, <21.06598, 19.1617, 17.741> }
					triangle { <21.2212, 19.5836, 17.8477>, <21.06598, 19.1617, 17.741>, <21.1579, 19.6205, 17.1386> }
					triangle { <21.2212, 19.5836, 17.8477>, <21.1579, 19.6205, 17.1386>, <21.2143, 19.9664, 17.1409> }
					triangle { <21.3715, 19.9859, 17.738>, <21.2212, 19.5836, 17.8477>, <21.2143, 19.9664, 17.1409> }
					triangle { <20.7277, 20.278, 19.1668>, <20.7337, 19.6721, 18.9509>, <21.2212, 19.5836, 17.8477> }
					triangle { <20.7277, 20.278, 19.1668>, <21.2212, 19.5836, 17.8477>, <21.3715, 19.9859, 17.738> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <20.492, 19.9447, 15.1073>, <20.818, 19.9215, 15.6897>, <20.9731, 19.704, 15.5812> }
					triangle { <20.818, 19.9215, 15.6897>, <21.09847, 19.9087, 16.1162>, <20.9731, 19.704, 15.5812> }
					triangle { <20.9731, 19.704, 15.5812>, <21.2818, 19.6437, 16.1782>, <21.4027, 19.5119, 15.9884> }
					triangle { <21.2818, 19.6437, 16.1782>, <21.2363, 18.9477, 16.8119>, <21.4027, 19.5119, 15.9884> }
					triangle { <20.9731, 19.704, 15.5812>, <21.09847, 19.9087, 16.1162>, <21.2818, 19.6437, 16.1782> }
					triangle { <21.09847, 19.9087, 16.1162>, <21.06082, 19.1073, 17.00739>, <21.2818, 19.6437, 16.1782> }
					triangle { <21.2818, 19.6437, 16.1782>, <21.06082, 19.1073, 17.00739>, <21.2363, 18.9477, 16.8119> }
					triangle { <21.4027, 19.5119, 15.9884>, <21.2363, 18.9477, 16.8119>, <21.4175, 18.6701, 16.5826> }
					triangle { <21.06082, 19.1073, 17.00739>, <21.243, 18.7541, 17.4883>, <21.2363, 18.9477, 16.8119> }
					triangle { <21.243, 18.7541, 17.4883>, <21.1372, 17.5813, 17.8771>, <21.4932, 18.5448, 17.2555> }
					triangle { <21.2363, 18.9477, 16.8119>, <21.243, 18.7541, 17.4883>, <21.4932, 18.5448, 17.2555> }
					triangle { <21.4175, 18.6701, 16.5826>, <21.2363, 18.9477, 16.8119>, <21.4932, 18.5448, 17.2555> }
					triangle { <21.4175, 18.6701, 16.5826>, <21.4932, 18.5448, 17.2555>, <21.64, 18.273, 17.00029> }
					triangle { <21.4932, 18.5448, 17.2555>, <21.1372, 17.5813, 17.8771>, <21.2574, 16.8984, 17.7112> }
					triangle { <21.64, 18.273, 17.00029>, <21.4932, 18.5448, 17.2555>, <21.2574, 16.8984, 17.7112> }
					triangle { <20.9731, 19.704, 15.5812>, <21.146, 19.6833, 15.3473>, <20.492, 19.9447, 15.1073> }
					triangle { <20.9731, 19.704, 15.5812>, <21.4124, 19.423, 15.5187>, <21.146, 19.6833, 15.3473> }
					triangle { <21.4027, 19.5119, 15.9884>, <21.5899, 19.5074, 15.8121>, <20.9731, 19.704, 15.5812> }
					triangle { <21.4027, 19.5119, 15.9884>, <21.5961, 18.5314, 16.3148>, <21.5899, 19.5074, 15.8121> }
					triangle { <21.5899, 19.5074, 15.8121>, <21.4124, 19.423, 15.5187>, <20.9731, 19.704, 15.5812> }
					triangle { <21.5899, 19.5074, 15.8121>, <21.7462, 18.3603, 15.932>, <21.4124, 19.423, 15.5187> }
					triangle { <21.5961, 18.5314, 16.3148>, <21.7462, 18.3603, 15.932>, <21.5899, 19.5074, 15.8121> }
					triangle { <21.4175, 18.6701, 16.5826>, <21.5961, 18.5314, 16.3148>, <21.4027, 19.5119, 15.9884> }
					triangle { <21.5961, 18.5314, 16.3148>, <21.94, 17.8509, 16.2899>, <21.7462, 18.3603, 15.932> }
					triangle { <21.807, 17.9792, 16.7134>, <21.6063, 16.878, 17.1712>, <21.94, 17.8509, 16.2899> }
					triangle { <21.807, 17.9792, 16.7134>, <21.94, 17.8509, 16.2899>, <21.5961, 18.5314, 16.3148> }
					triangle { <21.807, 17.9792, 16.7134>, <21.5961, 18.5314, 16.3148>, <21.4175, 18.6701, 16.5826> }
					triangle { <21.64, 18.273, 17.00029>, <21.807, 17.9792, 16.7134>, <21.4175, 18.6701, 16.5826> }
					triangle { <21.2574, 16.8984, 17.7112>, <21.6063, 16.878, 17.1712>, <21.807, 17.9792, 16.7134> }
					triangle { <21.2574, 16.8984, 17.7112>, <21.807, 17.9792, 16.7134>, <21.64, 18.273, 17.00029> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <20.492, 19.9447, 15.1073>, <20.8676, 19.6257, 15.558>, <21.09947, 19.7251, 15.4184> }
					triangle { <20.8676, 19.6257, 15.558>, <21.1705, 19.414, 15.9103>, <21.09947, 19.7251, 15.4184> }
					triangle { <21.09947, 19.7251, 15.4184>, <21.4893, 19.3743, 15.843>, <21.6238, 19.5488, 15.7035> }
					triangle { <21.4893, 19.3743, 15.843>, <22.03703, 18.6254, 15.6782>, <21.6238, 19.5488, 15.7035> }
					triangle { <21.09947, 19.7251, 15.4184>, <21.1705, 19.414, 15.9103>, <21.4893, 19.3743, 15.843> }
					triangle { <21.1705, 19.414, 15.9103>, <21.8456, 18.4276, 15.8151>, <21.4893, 19.3743, 15.843> }
					triangle { <21.4893, 19.3743, 15.843>, <21.8456, 18.4276, 15.8151>, <22.03703, 18.6254, 15.6782> }
					triangle { <21.6238, 19.5488, 15.7035>, <22.03703, 18.6254, 15.6782>, <22.3017, 18.8178, 15.4429> }
					triangle { <21.8456, 18.4276, 15.8151>, <22.3075, 18.01985, 15.9129>, <22.03703, 18.6254, 15.6782> }
					triangle { <22.3075, 18.01985, 15.9129>, <23.06803, 17.2957, 15.253>, <22.5781, 18.27, 15.7555> }
					triangle { <22.03703, 18.6254, 15.6782>, <22.3075, 18.01985, 15.9129>, <22.5781, 18.27, 15.7555> }
					triangle { <22.3017, 18.8178, 15.4429>, <22.03703, 18.6254, 15.6782>, <22.5781, 18.27, 15.7555> }
					triangle { <22.3017, 18.8178, 15.4429>, <22.5781, 18.27, 15.7555>, <22.8085, 18.4682, 15.4942> }
					triangle { <22.5781, 18.27, 15.7555>, <23.06803, 17.2957, 15.253>, <23.5627, 17.2836, 14.7399> }
					triangle { <22.8085, 18.4682, 15.4942>, <22.5781, 18.27, 15.7555>, <23.5627, 17.2836, 14.7399> }
					triangle { <21.09947, 19.7251, 15.4184>, <21.1912, 19.995, 15.3568>, <20.492, 19.9447, 15.1073> }
					triangle { <21.09947, 19.7251, 15.4184>, <21.5907, 19.9088, 15.3906>, <21.1912, 19.995, 15.3568> }
					triangle { <21.6238, 19.5488, 15.7035>, <21.7275, 19.7838, 15.6912>, <21.09947, 19.7251, 15.4184> }
					triangle { <21.6238, 19.5488, 15.7035>, <22.4668, 19.08234, 15.2828>, <21.7275, 19.7838, 15.6912> }
					triangle { <21.7275, 19.7838, 15.6912>, <21.5907, 19.9088, 15.3906>, <21.09947, 19.7251, 15.4184> }
					triangle { <21.7275, 19.7838, 15.6912>, <22.608, 19.4165, 15.02447>, <21.5907, 19.9088, 15.3906> }
					triangle { <22.4668, 19.08234, 15.2828>, <22.608, 19.4165, 15.02447>, <21.7275, 19.7838, 15.6912> }
					triangle { <22.3017, 18.8178, 15.4429>, <22.4668, 19.08234, 15.2828>, <21.6238, 19.5488, 15.7035> }
					triangle { <22.4668, 19.08234, 15.2828>, <23.1537, 19.0673, 14.9513>, <22.608, 19.4165, 15.02447> }
					triangle { <23.06126, 18.6955, 15.2097>, <23.72, 17.89, 14.5936>, <23.1537, 19.0673, 14.9513> }
					triangle { <23.06126, 18.6955, 15.2097>, <23.1537, 19.0673, 14.9513>, <22.4668, 19.08234, 15.2828> }
					triangle { <23.06126, 18.6955, 15.2097>, <22.4668, 19.08234, 15.2828>, <22.3017, 18.8178, 15.4429> }
					triangle { <22.8085, 18.4682, 15.4942>, <23.06126, 18.6955, 15.2097>, <22.3017, 18.8178, 15.4429> }
					triangle { <23.5627, 17.2836, 14.7399>, <23.72, 17.89, 14.5936>, <23.06126, 18.6955, 15.2097> }
					triangle { <23.5627, 17.2836, 14.7399>, <23.06126, 18.6955, 15.2097>, <22.8085, 18.4682, 15.4942> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <1.1318, 8.3152, 1.3233>, <1.3465, 9.1127, 1.4413>, 0.3888 }
			cylinder { <1.3465, 9.1127, 1.4413>, <1.5383, 9.9182, 1.5436>, 0.3888 }
			cylinder { <1.5383, 9.9182, 1.5436>, <1.7069, 10.7307, 1.63>, 0.3888 }
			cylinder { <1.7069, 10.7307, 1.63>, <1.8522, 11.5492, 1.7003>, 0.3888 }
			cylinder { <1.8522, 11.5492, 1.7003>, <1.9739, 12.3728, 1.7546>, 0.3888 }
			cylinder { <1.9739, 12.3728, 1.7546>, <2.07202, 13.2004, 1.7927>, 0.3888 }
			cylinder { <2.07202, 13.2004, 1.7927>, <2.1462, 14.03113, 1.8145>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.1462, 14.03113, 1.8145>, <2.3553, 18.0571, 1.1366>, 0.3888 }
				cylinder { <2.3553, 18.0571, 1.1366>, <2.4016, 21.8839, -0.3002>, 0.3888 }
				cylinder { <2.4016, 21.8839, -0.3002>, <2.2833, 25.3646, -2.4409>, 0.3888 }
				cylinder { <2.2833, 25.3646, -2.4409>, <2.004934, 28.3654, -5.2031>, 0.3888 }
				cylinder { <2.004934, 28.3654, -5.2031>, <1.5771, 30.7709, -8.4807>, 0.3888 }
				cylinder { <1.5771, 30.7709, -8.4807>, <1.01647, 32.4887, -12.1476>, 0.3888 }
				cylinder { <1.01647, 32.4887, -12.1476>, <0.3444, 33.4528, -16.06309>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <0.3444, 33.4528, -16.06309>, <0.05471, 33.4269, -16.6045>, <0.1081, 33.6852, -16.6336> }
					triangle { <0.05471, 33.4269, -16.6045>, <-0.1384, 33.4186, -17.03296>, <0.1081, 33.6852, -16.6336> }
					triangle { <0.1081, 33.6852, -16.6336>, <-0.2142, 33.6797, -17.1645>, <-0.08219, 33.8784, -17.1382> }
					triangle { <-0.2142, 33.6797, -17.1645>, <-0.9684, 34.06175, -17.3587>, <-0.08219, 33.8784, -17.1382> }
					triangle { <0.1081, 33.6852, -16.6336>, <-0.1384, 33.4186, -17.03296>, <-0.2142, 33.6797, -17.1645> }
					triangle { <-0.1384, 33.4186, -17.03296>, <-1.1159, 33.8204, -17.351>, <-0.2142, 33.6797, -17.1645> }
					triangle { <-0.2142, 33.6797, -17.1645>, <-1.1159, 33.8204, -17.351>, <-0.9684, 34.06175, -17.3587> }
					triangle { <-0.08219, 33.8784, -17.1382>, <-0.9684, 34.06175, -17.3587>, <-0.8423, 34.41, -17.3364> }
					triangle { <-1.1159, 33.8204, -17.351>, <-1.5271, 34.04135, -17.6856>, <-0.9684, 34.06175, -17.3587> }
					triangle { <-1.5271, 34.04135, -17.6856>, <-2.3254, 34.856, -17.6403>, <-1.3421, 34.3583, -17.7228> }
					triangle { <-0.9684, 34.06175, -17.3587>, <-1.5271, 34.04135, -17.6856>, <-1.3421, 34.3583, -17.7228> }
					triangle { <-0.8423, 34.41, -17.3364>, <-0.9684, 34.06175, -17.3587>, <-1.3421, 34.3583, -17.7228> }
					triangle { <-0.8423, 34.41, -17.3364>, <-1.3421, 34.3583, -17.7228>, <-1.2095, 34.6971, -17.6622> }
					triangle { <-1.3421, 34.3583, -17.7228>, <-2.3254, 34.856, -17.6403>, <-2.4346, 35.4964, -17.5475> }
					triangle { <-1.2095, 34.6971, -17.6622>, <-1.3421, 34.3583, -17.7228>, <-2.4346, 35.4964, -17.5475> }
					triangle { <0.1081, 33.6852, -16.6336>, <0.3385, 33.8228, -16.6393>, <0.3444, 33.4528, -16.06309> }
					triangle { <0.1081, 33.6852, -16.6336>, <0.2209, 34.0792, -16.8902>, <0.3385, 33.8228, -16.6393> }
					triangle { <-0.08219, 33.8784, -17.1382>, <0.1195, 33.9924, -17.1866>, <0.1081, 33.6852, -16.6336> }
					triangle { <-0.08219, 33.8784, -17.1382>, <-0.6334, 34.6545, -17.312>, <0.1195, 33.9924, -17.1866> }
					triangle { <0.1195, 33.9924, -17.1866>, <0.2209, 34.0792, -16.8902>, <0.1081, 33.6852, -16.6336> }
					triangle { <0.1195, 33.9924, -17.1866>, <-0.3674, 34.9465, -17.2022>, <0.2209, 34.0792, -16.8902> }
					triangle { <-0.6334, 34.6545, -17.312>, <-0.3674, 34.9465, -17.2022>, <0.1195, 33.9924, -17.1866> }
					triangle { <-0.8423, 34.41, -17.3364>, <-0.6334, 34.6545, -17.312>, <-0.08219, 33.8784, -17.1382> }
					triangle { <-0.6334, 34.6545, -17.312>, <-0.7494, 35.3312, -17.4597>, <-0.3674, 34.9465, -17.2022> }
					triangle { <-1.05484, 35.06904, -17.5971>, <-1.9126, 35.7749, -17.5267>, <-0.7494, 35.3312, -17.4597> }
					triangle { <-1.05484, 35.06904, -17.5971>, <-0.7494, 35.3312, -17.4597>, <-0.6334, 34.6545, -17.312> }
					triangle { <-1.05484, 35.06904, -17.5971>, <-0.6334, 34.6545, -17.312>, <-0.8423, 34.41, -17.3364> }
					triangle { <-1.2095, 34.6971, -17.6622>, <-1.05484, 35.06904, -17.5971>, <-0.8423, 34.41, -17.3364> }
					triangle { <-2.4346, 35.4964, -17.5475>, <-1.9126, 35.7749, -17.5267>, <-1.05484, 35.06904, -17.5971> }
					triangle { <-2.4346, 35.4964, -17.5475>, <-1.05484, 35.06904, -17.5971>, <-1.2095, 34.6971, -17.6622> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.3444, 33.4528, -16.06309>, <0.04554, 33.7143, -16.5322>, <0.2816, 33.7551, -16.6462> }
					triangle { <0.04554, 33.7143, -16.5322>, <-0.1682, 33.8917, -16.9113>, <0.2816, 33.7551, -16.6462> }
					triangle { <0.2816, 33.7551, -16.6462>, <-0.00654, 34.05447, -17.1079>, <0.2215, 34.00076, -17.1602> }
					triangle { <-0.00654, 34.05447, -17.1079>, <0.01566, 34.8945, -17.3225>, <0.2215, 34.00076, -17.1602> }
					triangle { <0.2816, 33.7551, -16.6462>, <-0.1682, 33.8917, -16.9113>, <-0.00654, 34.05447, -17.1079> }
					triangle { <-0.1682, 33.8917, -16.9113>, <-0.2438, 34.9478, -17.2231>, <-0.00654, 34.05447, -17.1079> }
					triangle { <-0.00654, 34.05447, -17.1079>, <-0.2438, 34.9478, -17.2231>, <0.01566, 34.8945, -17.3225> }
					triangle { <0.2215, 34.00076, -17.1602>, <0.01566, 34.8945, -17.3225>, <0.3724, 34.8991, -17.4244> }
					triangle { <-0.2438, 34.9478, -17.2231>, <-0.2964, 35.41, -17.5598>, <0.01566, 34.8945, -17.3225> }
					triangle { <-0.2964, 35.41, -17.5598>, <0.1725, 36.4439, -17.6781>, <0.03241, 35.3483, -17.715> }
					triangle { <0.01566, 34.8945, -17.3225>, <-0.2964, 35.41, -17.5598>, <0.03241, 35.3483, -17.715> }
					triangle { <0.3724, 34.8991, -17.4244>, <0.01566, 34.8945, -17.3225>, <0.03241, 35.3483, -17.715> }
					triangle { <0.3724, 34.8991, -17.4244>, <0.03241, 35.3483, -17.715>, <0.3957, 35.3434, -17.7785> }
					triangle { <0.03241, 35.3483, -17.715>, <0.1725, 36.4439, -17.6781>, <0.7324, 36.7716, -17.7771> }
					triangle { <0.3957, 35.3434, -17.7785>, <0.03241, 35.3483, -17.715>, <0.7324, 36.7716, -17.7771> }
					triangle { <0.2816, 33.7551, -16.6462>, <0.4778, 33.5879, -16.7211>, <0.3444, 33.4528, -16.06309> }
					triangle { <0.2816, 33.7551, -16.6462>, <0.5817, 33.7879, -17.02388>, <0.4778, 33.5879, -16.7211> }
					triangle { <0.2215, 34.00076, -17.1602>, <0.373, 33.8519, -17.2647>, <0.2816, 33.7551, -16.6462> }
					triangle { <0.2215, 34.00076, -17.1602>, <0.6658, 34.7896, -17.5017>, <0.373, 33.8519, -17.2647> }
					triangle { <0.373, 33.8519, -17.2647>, <0.5817, 33.7879, -17.02388>, <0.2816, 33.7551, -16.6462> }
					triangle { <0.373, 33.8519, -17.2647>, <1.04842, 34.6434, -17.5199>, <0.5817, 33.7879, -17.02388> }
					triangle { <0.6658, 34.7896, -17.5017>, <1.04842, 34.6434, -17.5199>, <0.373, 33.8519, -17.2647> }
					triangle { <0.3724, 34.8991, -17.4244>, <0.6658, 34.7896, -17.5017>, <0.2215, 34.00076, -17.1602> }
					triangle { <0.6658, 34.7896, -17.5017>, <1.1756, 35.1361, -17.8381>, <1.04842, 34.6434, -17.5199> }
					triangle { <0.797, 35.3296, -17.8508>, <1.1586, 36.3809, -17.9047>, <1.1756, 35.1361, -17.8381> }
					triangle { <0.797, 35.3296, -17.8508>, <1.1756, 35.1361, -17.8381>, <0.6658, 34.7896, -17.5017> }
					triangle { <0.797, 35.3296, -17.8508>, <0.6658, 34.7896, -17.5017>, <0.3724, 34.8991, -17.4244> }
					triangle { <0.3957, 35.3434, -17.7785>, <0.797, 35.3296, -17.8508>, <0.3724, 34.8991, -17.4244> }
					triangle { <0.7324, 36.7716, -17.7771>, <1.1586, 36.3809, -17.9047>, <0.797, 35.3296, -17.8508> }
					triangle { <0.7324, 36.7716, -17.7771>, <0.797, 35.3296, -17.8508>, <0.3957, 35.3434, -17.7785> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.3444, 33.4528, -16.06309>, <0.3202, 33.824, -16.5523>, <0.3968, 33.6172, -16.6999> }
					triangle { <0.3202, 33.824, -16.5523>, <0.2799, 34.08618, -16.9404>, <0.3968, 33.6172, -16.6999> }
					triangle { <0.3968, 33.6172, -16.6999>, <0.412, 33.9919, -17.1951>, <0.423, 33.7594, -17.2542> }
					triangle { <0.412, 33.9919, -17.1951>, <1.08986, 34.2664, -17.6616>, <0.423, 33.7594, -17.2542> }
					triangle { <0.3968, 33.6172, -16.6999>, <0.2799, 34.08618, -16.9404>, <0.412, 33.9919, -17.1951> }
					triangle { <0.2799, 34.08618, -16.9404>, <1.08365, 34.5281, -17.5543>, <0.412, 33.9919, -17.1951> }
					triangle { <0.412, 33.9919, -17.1951>, <1.08365, 34.5281, -17.5543>, <1.08986, 34.2664, -17.6616> }
					triangle { <0.423, 33.7594, -17.2542>, <1.08986, 34.2664, -17.6616>, <1.1785, 33.934, -17.8004> }
					triangle { <1.08365, 34.5281, -17.5543>, <1.3624, 34.7397, -18.00961>, <1.08986, 34.2664, -17.6616> }
					triangle { <1.3624, 34.7397, -18.00961>, <2.3918, 34.6644, -18.4972>, <1.3657, 34.41, -18.1749> }
					triangle { <1.08986, 34.2664, -17.6616>, <1.3624, 34.7397, -18.00961>, <1.3657, 34.41, -18.1749> }
					triangle { <1.1785, 33.934, -17.8004>, <1.08986, 34.2664, -17.6616>, <1.3657, 34.41, -18.1749> }
					triangle { <1.1785, 33.934, -17.8004>, <1.3657, 34.41, -18.1749>, <1.461, 34.06816, -18.2754> }
					triangle { <1.3657, 34.41, -18.1749>, <2.3918, 34.6644, -18.4972>, <2.8342, 34.2555, -18.7574> }
					triangle { <1.461, 34.06816, -18.2754>, <1.3657, 34.41, -18.1749>, <2.8342, 34.2555, -18.7574> }
					triangle { <0.3968, 33.6172, -16.6999>, <0.2895, 33.3747, -16.7412>, <0.3444, 33.4528, -16.06309> }
					triangle { <0.3968, 33.6172, -16.6999>, <0.4001, 33.3475, -17.1011>, <0.2895, 33.3747, -16.7412> }
					triangle { <0.423, 33.7594, -17.2542>, <0.3073, 33.5651, -17.324>, <0.3968, 33.6172, -16.6999> }
					triangle { <0.423, 33.7594, -17.2542>, <1.1537, 33.6207, -17.8733>, <0.3073, 33.5651, -17.324> }
					triangle { <0.3073, 33.5651, -17.324>, <0.4001, 33.3475, -17.1011>, <0.3968, 33.6172, -16.6999> }
					triangle { <0.3073, 33.5651, -17.324>, <1.1457, 33.2112, -17.8893>, <0.4001, 33.3475, -17.1011> }
					triangle { <1.1537, 33.6207, -17.8733>, <1.1457, 33.2112, -17.8893>, <0.3073, 33.5651, -17.324> }
					triangle { <1.1785, 33.934, -17.8004>, <1.1537, 33.6207, -17.8733>, <0.423, 33.7594, -17.2542> }
					triangle { <1.1537, 33.6207, -17.8733>, <1.5173, 33.2651, -18.3575>, <1.1457, 33.2112, -17.8893> }
					triangle { <1.5581, 33.6875, -18.3858>, <2.5886, 33.7189, -18.8056>, <1.5173, 33.2651, -18.3575> }
					triangle { <1.5581, 33.6875, -18.3858>, <1.5173, 33.2651, -18.3575>, <1.1537, 33.6207, -17.8733> }
					triangle { <1.5581, 33.6875, -18.3858>, <1.1537, 33.6207, -17.8733>, <1.1785, 33.934, -17.8004> }
					triangle { <1.461, 34.06816, -18.2754>, <1.5581, 33.6875, -18.3858>, <1.1785, 33.934, -17.8004> }
					triangle { <2.8342, 34.2555, -18.7574>, <2.5886, 33.7189, -18.8056>, <1.5581, 33.6875, -18.3858> }
					triangle { <2.8342, 34.2555, -18.7574>, <1.5581, 33.6875, -18.3858>, <1.461, 34.06816, -18.2754> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.3444, 33.4528, -16.06309>, <0.5016, 33.6055, -16.6373>, <0.2955, 33.4609, -16.721> }
					triangle { <0.5016, 33.6055, -16.6373>, <0.5908, 33.735, -17.08024>, <0.2955, 33.4609, -16.721> }
					triangle { <0.2955, 33.4609, -16.721>, <0.4669, 33.5779, -17.3065>, <0.2457, 33.4858, -17.2912> }
					triangle { <0.4669, 33.5779, -17.3065>, <0.7796, 33.0396, -17.9104>, <0.2457, 33.4858, -17.2912> }
					triangle { <0.2955, 33.4609, -16.721>, <0.5908, 33.735, -17.08024>, <0.4669, 33.5779, -17.3065> }
					triangle { <0.5908, 33.735, -17.08024>, <1.04428, 33.1376, -17.89>, <0.4669, 33.5779, -17.3065> }
					triangle { <0.4669, 33.5779, -17.3065>, <1.04428, 33.1376, -17.89>, <0.7796, 33.0396, -17.9104> }
					triangle { <0.2457, 33.4858, -17.2912>, <0.7796, 33.0396, -17.9104>, <0.4695, 32.8394, -17.9483> }
					triangle { <1.04428, 33.1376, -17.89>, <1.1725, 32.9506, -18.4175>, <0.7796, 33.0396, -17.9104> }
					triangle { <1.1725, 32.9506, -18.4175>, <1.286, 31.96, -18.9733>, <0.8276, 32.8313, -18.4712> }
					triangle { <0.7796, 33.0396, -17.9104>, <1.1725, 32.9506, -18.4175>, <0.8276, 32.8313, -18.4712> }
					triangle { <0.4695, 32.8394, -17.9483>, <0.7796, 33.0396, -17.9104>, <0.8276, 32.8313, -18.4712> }
					triangle { <0.4695, 32.8394, -17.9483>, <0.8276, 32.8313, -18.4712>, <0.5241, 32.6217, -18.4708> }
					triangle { <0.8276, 32.8313, -18.4712>, <1.286, 31.96, -18.9733>, <0.9857, 31.4017, -19.1428> }
					triangle { <0.5241, 32.6217, -18.4708>, <0.8276, 32.8313, -18.4712>, <0.9857, 31.4017, -19.1428> }
					triangle { <0.2955, 33.4609, -16.721>, <0.0321, 33.4759, -16.6721>, <0.3444, 33.4528, -16.06309> }
					triangle { <0.2955, 33.4609, -16.721>, <-0.07469, 33.3625, -17.01595>, <0.0321, 33.4759, -16.6721> }
					triangle { <0.2457, 33.4858, -17.2912>, <0.0126, 33.5256, -17.2831>, <0.2955, 33.4609, -16.721> }
					triangle { <0.2457, 33.4858, -17.2912>, <0.1605, 32.7523, -17.9167>, <0.0126, 33.5256, -17.2831> }
					triangle { <0.0126, 33.5256, -17.2831>, <-0.07469, 33.3625, -17.01595>, <0.2955, 33.4609, -16.721> }
					triangle { <0.0126, 33.5256, -17.2831>, <-0.2089, 32.6157, -17.8033>, <-0.07469, 33.3625, -17.01595> }
					triangle { <0.1605, 32.7523, -17.9167>, <-0.2089, 32.6157, -17.8033>, <0.0126, 33.5256, -17.2831> }
					triangle { <0.4695, 32.8394, -17.9483>, <0.1605, 32.7523, -17.9167>, <0.2457, 33.4858, -17.2912> }
					triangle { <0.1605, 32.7523, -17.9167>, <-0.1933, 32.2864, -18.3048>, <-0.2089, 32.6157, -17.8033> }
					triangle { <0.1837, 32.3967, -18.4677>, <0.4143, 31.4428, -18.9928>, <-0.1933, 32.2864, -18.3048> }
					triangle { <0.1837, 32.3967, -18.4677>, <-0.1933, 32.2864, -18.3048>, <0.1605, 32.7523, -17.9167> }
					triangle { <0.1837, 32.3967, -18.4677>, <0.1605, 32.7523, -17.9167>, <0.4695, 32.8394, -17.9483> }
					triangle { <0.5241, 32.6217, -18.4708>, <0.1837, 32.3967, -18.4677>, <0.4695, 32.8394, -17.9483> }
					triangle { <0.9857, 31.4017, -19.1428>, <0.4143, 31.4428, -18.9928>, <0.1837, 32.3967, -18.4677> }
					triangle { <0.9857, 31.4017, -19.1428>, <0.1837, 32.3967, -18.4677>, <0.5241, 32.6217, -18.4708> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <0.3444, 33.4528, -16.06309>, <0.3351, 33.3564, -16.67>, <0.1144, 33.5035, -16.6795> }
					triangle { <0.3351, 33.3564, -16.67>, <0.3283, 33.3162, -17.1383>, <0.1144, 33.5035, -16.6795> }
					triangle { <0.1144, 33.5035, -16.6795>, <0.07398, 33.3821, -17.2872>, <-0.07118, 33.5604, -17.2184> }
					triangle { <0.07398, 33.3821, -17.2872>, <-0.5116, 32.9111, -17.7204>, <-0.07118, 33.5604, -17.2184> }
					triangle { <0.1144, 33.5035, -16.6795>, <0.3283, 33.3162, -17.1383>, <0.07398, 33.3821, -17.2872> }
					triangle { <0.3283, 33.3162, -17.1383>, <-0.3356, 32.6936, -17.7624>, <0.07398, 33.3821, -17.2872> }
					triangle { <0.07398, 33.3821, -17.2872>, <-0.3356, 32.6936, -17.7624>, <-0.5116, 32.9111, -17.7204> }
					triangle { <-0.07118, 33.5604, -17.2184>, <-0.5116, 32.9111, -17.7204>, <-0.7983, 33.138, -17.6571> }
					triangle { <-0.3356, 32.6936, -17.7624>, <-0.6402, 32.5124, -18.2143>, <-0.5116, 32.9111, -17.7204> }
					triangle { <-0.6402, 32.5124, -18.2143>, <-1.6733, 32.08027, -18.4358>, <-0.8711, 32.7988, -18.1876> }
					triangle { <-0.5116, 32.9111, -17.7204>, <-0.6402, 32.5124, -18.2143>, <-0.8711, 32.7988, -18.1876> }
					triangle { <-0.7983, 33.138, -17.6571>, <-0.5116, 32.9111, -17.7204>, <-0.8711, 32.7988, -18.1876> }
					triangle { <-0.7983, 33.138, -17.6571>, <-0.8711, 32.7988, -18.1876>, <-1.1512, 33.01631, -18.08606> }
					triangle { <-0.8711, 32.7988, -18.1876>, <-1.6733, 32.08027, -18.4358>, <-2.3198, 32.1802, -18.3837> }
					triangle { <-1.1512, 33.01631, -18.08606>, <-0.8711, 32.7988, -18.1876>, <-2.3198, 32.1802, -18.3837> }
					triangle { <0.1144, 33.5035, -16.6795>, <0.06282, 33.7571, -16.6082>, <0.3444, 33.4528, -16.06309> }
					triangle { <0.1144, 33.5035, -16.6795>, <-0.1871, 33.8215, -16.8836>, <0.06282, 33.7571, -16.6082> }
					triangle { <-0.07118, 33.5604, -17.2184>, <-0.1051, 33.7937, -17.1969>, <0.1144, 33.5035, -16.6795> }
					triangle { <-0.07118, 33.5604, -17.2184>, <-0.9606, 33.4009, -17.5645>, <-0.1051, 33.7937, -17.1969> }
					triangle { <-0.1051, 33.7937, -17.1969>, <-0.1871, 33.8215, -16.8836>, <0.1144, 33.5035, -16.6795> }
					triangle { <-0.1051, 33.7937, -17.1969>, <-1.1582, 33.7044, -17.3723>, <-0.1871, 33.8215, -16.8836> }
					triangle { <-0.9606, 33.4009, -17.5645>, <-1.1582, 33.7044, -17.3723>, <-0.1051, 33.7937, -17.1969> }
					triangle { <-0.7983, 33.138, -17.6571>, <-0.9606, 33.4009, -17.5645>, <-0.07118, 33.5604, -17.2184> }
					triangle { <-0.9606, 33.4009, -17.5645>, <-1.6154, 33.5825, -17.7416>, <-1.1582, 33.7044, -17.3723> }
					triangle { <-1.4555, 33.2634, -17.9729>, <-2.4094, 32.7327, -18.1905>, <-1.6154, 33.5825, -17.7416> }
					triangle { <-1.4555, 33.2634, -17.9729>, <-1.6154, 33.5825, -17.7416>, <-0.9606, 33.4009, -17.5645> }
					triangle { <-1.4555, 33.2634, -17.9729>, <-0.9606, 33.4009, -17.5645>, <-0.7983, 33.138, -17.6571> }
					triangle { <-1.1512, 33.01631, -18.08606>, <-1.4555, 33.2634, -17.9729>, <-0.7983, 33.138, -17.6571> }
					triangle { <-2.3198, 32.1802, -18.3837>, <-2.4094, 32.7327, -18.1905>, <-1.4555, 33.2634, -17.9729> }
					triangle { <-2.3198, 32.1802, -18.3837>, <-1.4555, 33.2634, -17.9729>, <-1.1512, 33.01631, -18.08606> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <2.1462, 14.03113, 1.8145>, <2.2272, 14.8599, 1.8645>, 0.3888 }
			cylinder { <2.2272, 14.8599, 1.8645>, <2.3148, 15.6859, 1.9425>, 0.3888 }
			cylinder { <2.3148, 15.6859, 1.9425>, <2.4088, 16.5081, 2.04855>, 0.3888 }
			cylinder { <2.4088, 16.5081, 2.04855>, <2.5092, 17.3254, 2.1823>, 0.3888 }
			cylinder { <2.5092, 17.3254, 2.1823>, <2.6158, 18.137, 2.3438>, 0.3888 }
			cylinder { <2.6158, 18.137, 2.3438>, <2.7286, 18.9417, 2.5328>, 0.3888 }
			cylinder { <2.7286, 18.9417, 2.5328>, <2.8472, 19.7387, 2.749>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.8472, 19.7387, 2.749>, <2.9856, 23.4541, 4.4486>, 0.3888 }
				cylinder { <2.9856, 23.4541, 4.4486>, <2.6754, 26.8367, 6.7231>, 0.3888 }
				cylinder { <2.6754, 26.8367, 6.7231>, <1.9288, 29.7567, 9.485>, 0.3888 }
				cylinder { <1.9288, 29.7567, 9.485>, <0.7743, 32.1018, 12.6281>, 0.3888 }
				cylinder { <0.7743, 32.1018, 12.6281>, <-0.7436, 33.7819, 16.03184>, 0.3888 }
				cylinder { <-0.7436, 33.7819, 16.03184>, <-2.5668, 34.7323, 19.5651>, 0.3888 }
				cylinder { <-2.5668, 34.7323, 19.5651>, <-4.625, 34.9167, 23.09244>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-4.625, 34.9167, 23.09244>, <-4.8021, 34.7234, 23.6483>, <-4.8112, 34.9781, 23.7224> }
					triangle { <-4.8021, 34.7234, 23.6483>, <-4.9651, 34.5949, 24.07006>, <-4.8112, 34.9781, 23.7224> }
					triangle { <-4.8112, 34.9781, 23.7224>, <-4.9543, 34.793, 24.2978>, <-4.9912, 35.02781, 24.264> }
					triangle { <-4.9543, 34.793, 24.2978>, <-4.491, 34.8481, 25.02905>, <-4.9912, 35.02781, 24.264> }
					triangle { <-4.8112, 34.9781, 23.7224>, <-4.9651, 34.5949, 24.07006>, <-4.9543, 34.793, 24.2978> }
					triangle { <-4.9651, 34.5949, 24.07006>, <-4.4278, 34.5724, 25.03393>, <-4.9543, 34.793, 24.2978> }
					triangle { <-4.9543, 34.793, 24.2978>, <-4.4278, 34.5724, 25.03393>, <-4.491, 34.8481, 25.02905> }
					triangle { <-4.9912, 35.02781, 24.264>, <-4.491, 34.8481, 25.02905>, <-4.4984, 35.2184, 25.05175> }
					triangle { <-4.4278, 34.5724, 25.03393>, <-4.331, 34.5872, 25.5997>, <-4.491, 34.8481, 25.02905> }
					triangle { <-4.331, 34.5872, 25.5997>, <-3.5903, 35.05428, 26.3321>, <-4.4265, 34.943, 25.6181> }
					triangle { <-4.491, 34.8481, 25.02905>, <-4.331, 34.5872, 25.5997>, <-4.4265, 34.943, 25.6181> }
					triangle { <-4.4984, 35.2184, 25.05175>, <-4.491, 34.8481, 25.02905>, <-4.4265, 34.943, 25.6181> }
					triangle { <-4.4984, 35.2184, 25.05175>, <-4.4265, 34.943, 25.6181>, <-4.4138, 35.3115, 25.6063> }
					triangle { <-4.4265, 34.943, 25.6181>, <-3.5903, 35.05428, 26.3321>, <-3.3301, 35.6169, 26.5473> }
					triangle { <-4.4138, 35.3115, 25.6063>, <-4.4265, 34.943, 25.6181>, <-3.3301, 35.6169, 26.5473> }
					triangle { <-4.8112, 34.9781, 23.7224>, <-4.9501, 35.1885, 23.6304>, <-4.625, 34.9167, 23.09244> }
					triangle { <-4.8112, 34.9781, 23.7224>, <-4.9936, 35.3529, 23.9674>, <-4.9501, 35.1885, 23.6304> }
					triangle { <-4.9912, 35.02781, 24.264>, <-5.1441, 35.2008, 24.2121>, <-4.8112, 34.9781, 23.7224> }
					triangle { <-4.9912, 35.02781, 24.264>, <-4.5815, 35.5234, 24.9873>, <-5.1441, 35.2008, 24.2121> }
					triangle { <-5.1441, 35.2008, 24.2121>, <-4.9936, 35.3529, 23.9674>, <-4.8112, 34.9781, 23.7224> }
					triangle { <-5.1441, 35.2008, 24.2121>, <-4.6367, 35.9029, 24.8425>, <-4.9936, 35.3529, 23.9674> }
					triangle { <-4.5815, 35.5234, 24.9873>, <-4.6367, 35.9029, 24.8425>, <-5.1441, 35.2008, 24.2121> }
					triangle { <-4.4984, 35.2184, 25.05175>, <-4.5815, 35.5234, 24.9873>, <-4.9912, 35.02781, 24.264> }
					triangle { <-4.5815, 35.5234, 24.9873>, <-4.4762, 36.08876, 25.3901>, <-4.6367, 35.9029, 24.8425> }
					triangle { <-4.4071, 35.7191, 25.5888>, <-3.6279, 36.06694, 26.3036>, <-4.4762, 36.08876, 25.3901> }
					triangle { <-4.4071, 35.7191, 25.5888>, <-4.4762, 36.08876, 25.3901>, <-4.5815, 35.5234, 24.9873> }
					triangle { <-4.4071, 35.7191, 25.5888>, <-4.5815, 35.5234, 24.9873>, <-4.4984, 35.2184, 25.05175> }
					triangle { <-4.4138, 35.3115, 25.6063>, <-4.4071, 35.7191, 25.5888>, <-4.4984, 35.2184, 25.05175> }
					triangle { <-3.3301, 35.6169, 26.5473>, <-3.6279, 36.06694, 26.3036>, <-4.4071, 35.7191, 25.5888> }
					triangle { <-3.3301, 35.6169, 26.5473>, <-4.4071, 35.7191, 25.5888>, <-4.4138, 35.3115, 25.6063> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-4.625, 34.9167, 23.09244>, <-4.6919, 34.9941, 23.6985>, <-4.9279, 35.1044, 23.6477> }
					triangle { <-4.6919, 34.9941, 23.6985>, <-4.7718, 35.03546, 24.1598>, <-4.9279, 35.1044, 23.6477> }
					triangle { <-4.9279, 35.1044, 23.6477>, <-4.9901, 35.2215, 24.2546>, <-5.1954, 35.2488, 24.1333> }
					triangle { <-4.9901, 35.2215, 24.2546>, <-4.9969, 35.9803, 24.6746>, <-5.1954, 35.2488, 24.1333> }
					triangle { <-4.9279, 35.1044, 23.6477>, <-4.7718, 35.03546, 24.1598>, <-4.9901, 35.2215, 24.2546> }
					triangle { <-4.7718, 35.03546, 24.1598>, <-4.7371, 35.9467, 24.7816>, <-4.9901, 35.2215, 24.2546> }
					triangle { <-4.9901, 35.2215, 24.2546>, <-4.7371, 35.9467, 24.7816>, <-4.9969, 35.9803, 24.6746> }
					triangle { <-5.1954, 35.2488, 24.1333>, <-4.9969, 35.9803, 24.6746>, <-5.3154, 36.1025, 24.5287> }
					triangle { <-4.7371, 35.9467, 24.7816>, <-4.8467, 36.3148, 25.2085>, <-4.9969, 35.9803, 24.6746> }
					triangle { <-4.8467, 36.3148, 25.2085>, <-5.06245, 37.4269, 25.3491>, <-5.195, 36.3594, 25.09567> }
					triangle { <-4.9969, 35.9803, 24.6746>, <-4.8467, 36.3148, 25.2085>, <-5.195, 36.3594, 25.09567> }
					triangle { <-5.3154, 36.1025, 24.5287>, <-4.9969, 35.9803, 24.6746>, <-5.195, 36.3594, 25.09567> }
					triangle { <-5.3154, 36.1025, 24.5287>, <-5.195, 36.3594, 25.09567>, <-5.4934, 36.4798, 24.9152> }
					triangle { <-5.195, 36.3594, 25.09567>, <-5.06245, 37.4269, 25.3491>, <-5.4602, 37.9219, 25.1838> }
					triangle { <-5.4934, 36.4798, 24.9152>, <-5.195, 36.3594, 25.09567>, <-5.4602, 37.9219, 25.1838> }
					triangle { <-4.9279, 35.1044, 23.6477>, <-5.1478, 35.01264, 23.5242>, <-4.625, 34.9167, 23.09244> }
					triangle { <-4.9279, 35.1044, 23.6477>, <-5.3923, 35.1995, 23.7428>, <-5.1478, 35.01264, 23.5242> }
					triangle { <-5.1954, 35.2488, 24.1333>, <-5.4012, 35.1542, 24.06456>, <-4.9279, 35.1044, 23.6477> }
					triangle { <-5.1954, 35.2488, 24.1333>, <-5.5941, 36.0993, 24.3663>, <-5.4012, 35.1542, 24.06456> }
					triangle { <-5.4012, 35.1542, 24.06456>, <-5.3923, 35.1995, 23.7428>, <-4.9279, 35.1044, 23.6477> }
					triangle { <-5.4012, 35.1542, 24.06456>, <-5.9009, 36.1015, 24.09445>, <-5.3923, 35.1995, 23.7428> }
					triangle { <-5.5941, 36.0993, 24.3663>, <-5.9009, 36.1015, 24.09445>, <-5.4012, 35.1542, 24.06456> }
					triangle { <-5.3154, 36.1025, 24.5287>, <-5.5941, 36.0993, 24.3663>, <-5.1954, 35.2488, 24.1333> }
					triangle { <-5.5941, 36.0993, 24.3663>, <-6.1176, 36.5654, 24.4074>, <-5.9009, 36.1015, 24.09445> }
					triangle { <-5.826, 36.6047, 24.7146>, <-5.9189, 37.7014, 24.8813>, <-6.1176, 36.5654, 24.4074> }
					triangle { <-5.826, 36.6047, 24.7146>, <-6.1176, 36.5654, 24.4074>, <-5.5941, 36.0993, 24.3663> }
					triangle { <-5.826, 36.6047, 24.7146>, <-5.5941, 36.0993, 24.3663>, <-5.3154, 36.1025, 24.5287> }
					triangle { <-5.4934, 36.4798, 24.9152>, <-5.826, 36.6047, 24.7146>, <-5.3154, 36.1025, 24.5287> }
					triangle { <-5.4602, 37.9219, 25.1838>, <-5.9189, 37.7014, 24.8813>, <-5.826, 36.6047, 24.7146> }
					triangle { <-5.4602, 37.9219, 25.1838>, <-5.826, 36.6047, 24.7146>, <-5.4934, 36.4798, 24.9152> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-4.625, 34.9167, 23.09244>, <-4.877, 35.1932, 23.5801>, <-5.07126, 35.01273, 23.5689> }
					triangle { <-4.877, 35.1932, 23.5801>, <-5.06826, 35.3749, 23.9691>, <-5.07126, 35.01273, 23.5689> }
					triangle { <-5.07126, 35.01273, 23.5689>, <-5.3542, 35.3059, 24.0377>, <-5.4462, 35.08833, 23.9954> }
					triangle { <-5.3542, 35.3059, 24.0377>, <-6.09836, 35.7516, 24.04391>, <-5.4462, 35.08833, 23.9954> }
					triangle { <-5.07126, 35.01273, 23.5689>, <-5.06826, 35.3749, 23.9691>, <-5.3542, 35.3059, 24.0377> }
					triangle { <-5.06826, 35.3749, 23.9691>, <-5.9708, 36.0038, 24.05874>, <-5.3542, 35.3059, 24.0377> }
					triangle { <-5.3542, 35.3059, 24.0377>, <-5.9708, 36.0038, 24.05874>, <-6.09836, 35.7516, 24.04391> }
					triangle { <-5.4462, 35.08833, 23.9954>, <-6.09836, 35.7516, 24.04391>, <-6.3184, 35.4605, 23.977> }
					triangle { <-5.9708, 36.0038, 24.05874>, <-6.4406, 36.2472, 24.2819>, <-6.09836, 35.7516, 24.04391> }
					triangle { <-6.4406, 36.2472, 24.2819>, <-7.5102, 36.4952, 23.9695>, <-6.6189, 35.9243, 24.2875> }
					triangle { <-6.09836, 35.7516, 24.04391>, <-6.4406, 36.2472, 24.2819>, <-6.6189, 35.9243, 24.2875> }
					triangle { <-6.3184, 35.4605, 23.977>, <-6.09836, 35.7516, 24.04391>, <-6.6189, 35.9243, 24.2875> }
					triangle { <-6.3184, 35.4605, 23.977>, <-6.6189, 35.9243, 24.2875>, <-6.8188, 35.6313, 24.1862> }
					triangle { <-6.6189, 35.9243, 24.2875>, <-7.5102, 36.4952, 23.9695>, <-8.07529, 36.248, 23.7454> }
					triangle { <-6.8188, 35.6313, 24.1862>, <-6.6189, 35.9243, 24.2875>, <-8.07529, 36.248, 23.7454> }
					triangle { <-5.07126, 35.01273, 23.5689>, <-5.07031, 34.7447, 23.5835>, <-4.625, 34.9167, 23.09244> }
					triangle { <-5.07126, 35.01273, 23.5689>, <-5.4013, 34.7174, 23.7627>, <-5.07031, 34.7447, 23.5835> }
					triangle { <-5.4462, 35.08833, 23.9954>, <-5.45, 34.8584, 24.05154>, <-5.07126, 35.01273, 23.5689> }
					triangle { <-5.4462, 35.08833, 23.9954>, <-6.4101, 35.1535, 23.9396>, <-5.45, 34.8584, 24.05154> }
					triangle { <-5.45, 34.8584, 24.05154>, <-5.4013, 34.7174, 23.7627>, <-5.07126, 35.01273, 23.5689> }
					triangle { <-5.45, 34.8584, 24.05154>, <-6.4921, 34.7703, 23.819>, <-5.4013, 34.7174, 23.7627> }
					triangle { <-6.4101, 35.1535, 23.9396>, <-6.4921, 34.7703, 23.819>, <-5.45, 34.8584, 24.05154> }
					triangle { <-6.3184, 35.4605, 23.977>, <-6.4101, 35.1535, 23.9396>, <-5.4462, 35.08833, 23.9954> }
					triangle { <-6.4101, 35.1535, 23.9396>, <-7.0651, 34.9004, 23.9416>, <-6.4921, 34.7703, 23.819> }
					triangle { <-7.03418, 35.3021, 24.07778>, <-8.03758, 35.6572, 23.7519>, <-7.0651, 34.9004, 23.9416> }
					triangle { <-7.03418, 35.3021, 24.07778>, <-7.0651, 34.9004, 23.9416>, <-6.4101, 35.1535, 23.9396> }
					triangle { <-7.03418, 35.3021, 24.07778>, <-6.4101, 35.1535, 23.9396>, <-6.3184, 35.4605, 23.977> }
					triangle { <-6.8188, 35.6313, 24.1862>, <-7.03418, 35.3021, 24.07778>, <-6.3184, 35.4605, 23.977> }
					triangle { <-8.07529, 36.248, 23.7454>, <-8.03758, 35.6572, 23.7519>, <-7.03418, 35.3021, 24.07778> }
					triangle { <-8.07529, 36.248, 23.7454>, <-7.03418, 35.3021, 24.07778>, <-6.8188, 35.6313, 24.1862> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-4.625, 34.9167, 23.09244>, <-5.1032, 35.04751, 23.4557>, <-5.04444, 34.8288, 23.5942> }
					triangle { <-5.1032, 35.04751, 23.4557>, <-5.4475, 35.1474, 23.7596>, <-5.04444, 34.8288, 23.5942> }
					triangle { <-5.04444, 34.8288, 23.5942>, <-5.5469, 34.9304, 23.9448>, <-5.3992, 34.7666, 24.03961> }
					triangle { <-5.5469, 34.9304, 23.9448>, <-6.2834, 34.4759, 24.00257>, <-5.3992, 34.7666, 24.03961> }
					triangle { <-5.04444, 34.8288, 23.5942>, <-5.4475, 35.1474, 23.7596>, <-5.5469, 34.9304, 23.9448> }
					triangle { <-5.4475, 35.1474, 23.7596>, <-6.4356, 34.6653, 23.8575>, <-5.5469, 34.9304, 23.9448> }
					triangle { <-5.5469, 34.9304, 23.9448>, <-6.4356, 34.6653, 23.8575>, <-6.2834, 34.4759, 24.00257> }
					triangle { <-5.3992, 34.7666, 24.03961>, <-6.2834, 34.4759, 24.00257>, <-6.1306, 34.1736, 24.1539> }
					triangle { <-6.4356, 34.6653, 23.8575>, <-6.9249, 34.4771, 24.09193>, <-6.2834, 34.4759, 24.00257> }
					triangle { <-6.9249, 34.4771, 24.09193>, <-7.5737, 33.5379, 24.08701>, <-6.7437, 34.2349, 24.303> }
					triangle { <-6.2834, 34.4759, 24.00257>, <-6.9249, 34.4771, 24.09193>, <-6.7437, 34.2349, 24.303> }
					triangle { <-6.1306, 34.1736, 24.1539>, <-6.2834, 34.4759, 24.00257>, <-6.7437, 34.2349, 24.303> }
					triangle { <-6.1306, 34.1736, 24.1539>, <-6.7437, 34.2349, 24.303>, <-6.5707, 33.9308, 24.4198> }
					triangle { <-6.7437, 34.2349, 24.303>, <-7.5737, 33.5379, 24.08701>, <-7.5857, 32.8928, 24.2064> }
					triangle { <-6.5707, 33.9308, 24.4198>, <-6.7437, 34.2349, 24.303>, <-7.5857, 32.8928, 24.2064> }
					triangle { <-5.04444, 34.8288, 23.5942>, <-4.8239, 34.7525, 23.7268>, <-4.625, 34.9167, 23.09244> }
					triangle { <-5.04444, 34.8288, 23.5942>, <-5.008385, 34.5683, 23.9998>, <-4.8239, 34.7525, 23.7268> }
					triangle { <-5.3992, 34.7666, 24.03961>, <-5.2235, 34.7193, 24.1909>, <-5.04444, 34.8288, 23.5942> }
					triangle { <-5.3992, 34.7666, 24.03961>, <-5.9095, 33.9843, 24.2928>, <-5.2235, 34.7193, 24.1909> }
					triangle { <-5.2235, 34.7193, 24.1909>, <-5.008385, 34.5683, 23.9998>, <-5.04444, 34.8288, 23.5942> }
					triangle { <-5.2235, 34.7193, 24.1909>, <-5.5988, 33.7367, 24.3943>, <-5.008385, 34.5683, 23.9998> }
					triangle { <-5.9095, 33.9843, 24.2928>, <-5.5988, 33.7367, 24.3943>, <-5.2235, 34.7193, 24.1909> }
					triangle { <-6.1306, 34.1736, 24.1539>, <-5.9095, 33.9843, 24.2928>, <-5.3992, 34.7666, 24.03961> }
					triangle { <-5.9095, 33.9843, 24.2928>, <-6.01814, 33.3791, 24.632>, <-5.5988, 33.7367, 24.3943> }
					triangle { <-6.3732, 33.5993, 24.5524>, <-7.07574, 32.7402, 24.4656>, <-6.01814, 33.3791, 24.632> }
					triangle { <-6.3732, 33.5993, 24.5524>, <-6.01814, 33.3791, 24.632>, <-5.9095, 33.9843, 24.2928> }
					triangle { <-6.3732, 33.5993, 24.5524>, <-5.9095, 33.9843, 24.2928>, <-6.1306, 34.1736, 24.1539> }
					triangle { <-6.5707, 33.9308, 24.4198>, <-6.3732, 33.5993, 24.5524>, <-6.1306, 34.1736, 24.1539> }
					triangle { <-7.5857, 32.8928, 24.2064>, <-7.07574, 32.7402, 24.4656>, <-6.3732, 33.5993, 24.5524> }
					triangle { <-7.5857, 32.8928, 24.2064>, <-6.3732, 33.5993, 24.5524>, <-6.5707, 33.9308, 24.4198> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-4.625, 34.9167, 23.09244>, <-5.05629, 34.7528, 23.4985>, <-4.8813, 34.8071, 23.6905> }
					triangle { <-5.05629, 34.7528, 23.4985>, <-5.3828, 34.658, 23.823>, <-4.8813, 34.8071, 23.6905> }
					triangle { <-4.8813, 34.8071, 23.6905>, <-5.296, 34.6086, 24.108>, <-5.1138, 34.7286, 24.2081> }
					triangle { <-5.296, 34.6086, 24.108>, <-5.2751, 33.9091, 24.6206>, <-5.1138, 34.7286, 24.2081> }
					triangle { <-4.8813, 34.8071, 23.6905>, <-5.3828, 34.658, 23.823>, <-5.296, 34.6086, 24.108> }
					triangle { <-5.3828, 34.658, 23.823>, <-5.4675, 33.7673, 24.4693>, <-5.296, 34.6086, 24.108> }
					triangle { <-5.296, 34.6086, 24.108>, <-5.4675, 33.7673, 24.4693>, <-5.2751, 33.9091, 24.6206> }
					triangle { <-5.1138, 34.7286, 24.2081>, <-5.2751, 33.9091, 24.6206>, <-4.9888, 34.02174, 24.8281> }
					triangle { <-5.4675, 33.7673, 24.4693>, <-5.6013, 33.4357, 24.9186>, <-5.2751, 33.9091, 24.6206> }
					triangle { <-5.6013, 33.4357, 24.9186>, <-5.1145, 32.634, 25.5692>, <-5.3683, 33.6193, 25.1378> }
					triangle { <-5.2751, 33.9091, 24.6206>, <-5.6013, 33.4357, 24.9186>, <-5.3683, 33.6193, 25.1378> }
					triangle { <-4.9888, 34.02174, 24.8281>, <-5.2751, 33.9091, 24.6206>, <-5.3683, 33.6193, 25.1378> }
					triangle { <-4.9888, 34.02174, 24.8281>, <-5.3683, 33.6193, 25.1378>, <-5.06191, 33.7301, 25.3108> }
					triangle { <-5.3683, 33.6193, 25.1378>, <-5.1145, 32.634, 25.5692>, <-4.6088, 32.4969, 25.9642> }
					triangle { <-5.06191, 33.7301, 25.3108>, <-5.3683, 33.6193, 25.1378>, <-4.6088, 32.4969, 25.9642> }
					triangle { <-4.8813, 34.8071, 23.6905>, <-4.7485, 35.031, 23.7563>, <-4.625, 34.9167, 23.09244> }
					triangle { <-4.8813, 34.8071, 23.6905>, <-4.7525, 34.967, 24.1282>, <-4.7485, 35.031, 23.7563> }
					triangle { <-5.1138, 34.7286, 24.2081>, <-5.0316, 34.9342, 24.2917>, <-4.8813, 34.8071, 23.6905> }
					triangle { <-5.1138, 34.7286, 24.2081>, <-4.7623, 34.2163, 24.9501>, <-5.0316, 34.9342, 24.2917> }
					triangle { <-5.0316, 34.9342, 24.2917>, <-4.7525, 34.967, 24.1282>, <-4.8813, 34.8071, 23.6905> }
					triangle { <-5.0316, 34.9342, 24.2917>, <-4.4348, 34.4473, 25.03643>, <-4.7525, 34.967, 24.1282> }
					triangle { <-4.7623, 34.2163, 24.9501>, <-4.4348, 34.4473, 25.03643>, <-5.0316, 34.9342, 24.2917> }
					triangle { <-4.9888, 34.02174, 24.8281>, <-4.7623, 34.2163, 24.9501>, <-5.1138, 34.7286, 24.2081> }
					triangle { <-4.7623, 34.2163, 24.9501>, <-4.3939, 34.1246, 25.5408>, <-4.4348, 34.4473, 25.03643> }
					triangle { <-4.7251, 33.8609, 25.5004>, <-4.3093, 32.9973, 26.06649>, <-4.3939, 34.1246, 25.5408> }
					triangle { <-4.7251, 33.8609, 25.5004>, <-4.3939, 34.1246, 25.5408>, <-4.7623, 34.2163, 24.9501> }
					triangle { <-4.7251, 33.8609, 25.5004>, <-4.7623, 34.2163, 24.9501>, <-4.9888, 34.02174, 24.8281> }
					triangle { <-5.06191, 33.7301, 25.3108>, <-4.7251, 33.8609, 25.5004>, <-4.9888, 34.02174, 24.8281> }
					triangle { <-4.6088, 32.4969, 25.9642>, <-4.3093, 32.9973, 26.06649>, <-4.7251, 33.8609, 25.5004> }
					triangle { <-4.6088, 32.4969, 25.9642>, <-4.7251, 33.8609, 25.5004>, <-5.06191, 33.7301, 25.3108> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		}
	union { // internode
		cylinder { <0.05981, 2.6812, 0.2985>, <0.06065, 2.7764, 0.3143>, 0.4 }
		cylinder { <0.06065, 2.7764, 0.3143>, <0.05779, 2.8721, 0.3272>, 0.4 }
		cylinder { <0.05779, 2.8721, 0.3272>, <0.05123, 2.9679, 0.3372>, 0.4 }
		cylinder { <0.05123, 2.9679, 0.3372>, <0.041, 3.06366, 0.3441>, 0.4 }
		cylinder { <0.041, 3.06366, 0.3441>, <0.0271, 3.1591, 0.3481>, 0.4 }
		cylinder { <0.0271, 3.1591, 0.3481>, <0.009593, 3.254, 0.3491>, 0.4 }
		cylinder { <0.009593, 3.254, 0.3491>, <-0.0115, 3.3482, 0.347>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0115, 3.3482, 0.347>, <-0.07337, 9.2048, 1.2289>, 0.7265 }
			cylinder { <-0.07337, 9.2048, 1.2289>, <1.1015, 14.7153, 3.05523>, 0.7265 }
			cylinder { <1.1015, 14.7153, 3.05523>, <3.4282, 19.4804, 5.6937>, 0.7265 }
			cylinder { <3.4282, 19.4804, 5.6937>, <6.738, 23.155, 8.9532>, 0.7265 }
			cylinder { <6.738, 23.155, 8.9532>, <10.7912, 25.4728, 12.5975>, 0.7265 }
			cylinder { <10.7912, 25.4728, 12.5975>, <15.294, 26.2658, 16.3627>, 0.7265 }
			cylinder { <15.294, 26.2658, 16.3627>, <19.9204, 25.4767, 19.976>, 0.7265 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <19.9204, 25.4767, 19.976>, <19.09363, 27.2229, 14.03832>, <24.3991, 30.02302, 17.005> }
			triangle { <19.9204, 25.4767, 19.976>, <24.3991, 30.02302, 17.005>, <27.5905, 29.1982, 20.7065> }
			triangle { <19.09363, 27.2229, 14.03832>, <20.2195, 29.1848, 11.2544>, <24.3991, 30.02302, 17.005> }
			triangle { <20.2195, 29.1848, 11.2544>, <23.9512, 30.05195, 11.9778>, <24.3991, 30.02302, 17.005> }
			triangle { <23.9512, 30.05195, 11.9778>, <28.725, 29.6911, 14.935>, <24.3991, 30.02302, 17.005> }
			triangle { <28.725, 29.6911, 14.935>, <33.2617, 28.8039, 18.671>, <27.5905, 29.1982, 20.7065> }
			triangle { <24.3991, 30.02302, 17.005>, <28.725, 29.6911, 14.935>, <27.5905, 29.1982, 20.7065> }
			triangle { <27.5905, 29.1982, 20.7065>, <32.1366, 27.7904, 23.1364>, <29.2065, 26.08252, 25.3346> }
			triangle { <32.1366, 27.7904, 23.1364>, <36.01936, 25.8933, 24.243>, <33.7084, 25.2491, 26.766> }
			triangle { <32.1366, 27.7904, 23.1364>, <33.7084, 25.2491, 26.766>, <29.2065, 26.08252, 25.3346> }
			triangle { <29.2065, 26.08252, 25.3346>, <33.7084, 25.2491, 26.766>, <30.8783, 23.1781, 28.1667> }
			triangle { <36.01936, 25.8933, 24.243>, <37.9164, 21.3574, 28.4962>, <33.7084, 25.2491, 26.766> }
			triangle { <33.7084, 25.2491, 26.766>, <37.9164, 21.3574, 28.4962>, <30.8783, 23.1781, 28.1667> }
			triangle { <19.9204, 25.4767, 19.976>, <27.5905, 29.1982, 20.7065>, <24.3332, 25.01043, 23.6674> }
			triangle { <24.3332, 25.01043, 23.6674>, <27.5905, 29.1982, 20.7065>, <29.2065, 26.08252, 25.3346> }
			triangle { <24.3332, 25.01043, 23.6674>, <29.2065, 26.08252, 25.3346>, <27.8486, 24.4108, 26.413> }
			triangle { <29.2065, 26.08252, 25.3346>, <30.8783, 23.1781, 28.1667>, <27.8486, 24.4108, 26.413> }
			triangle { <33.2617, 28.8039, 18.671>, <32.1366, 27.7904, 23.1364>, <27.5905, 29.1982, 20.7065> }
			triangle { <33.2617, 28.8039, 18.671>, <36.01936, 25.8933, 24.243>, <32.1366, 27.7904, 23.1364> }
			triangle { <16.5205, 22.7509, 25.5045>, <14.3249, 22.8214, 19.1828>, <19.9204, 25.4767, 19.976> }
			triangle { <20.7485, 22.883, 28.08773>, <16.5205, 22.7509, 25.5045>, <19.9204, 25.4767, 19.976> }
			triangle { <16.5205, 22.7509, 25.5045>, <11.5116, 21.1473, 20.6487>, <14.3249, 22.8214, 19.1828> }
			triangle { <16.5205, 22.7509, 25.5045>, <12.7552, 19.718, 24.05617>, <11.5116, 21.1473, 20.6487> }
			triangle { <16.5205, 22.7509, 25.5045>, <16.6997, 18.5917, 27.908>, <12.7552, 19.718, 24.05617> }
			triangle { <20.7485, 22.883, 28.08773>, <21.4437, 17.8959, 31.4203>, <16.6997, 18.5917, 27.908> }
			triangle { <20.7485, 22.883, 28.08773>, <16.6997, 18.5917, 27.908>, <16.5205, 22.7509, 25.5045> }
			triangle { <26.5112, 23.5947, 28.2423>, <24.5756, 22.1466, 31.5848>, <20.7485, 22.883, 28.08773> }
			triangle { <29.6052, 21.2711, 31.1509>, <28.1407, 18.6212, 32.7425>, <24.5756, 22.1466, 31.5848> }
			triangle { <26.5112, 23.5947, 28.2423>, <29.6052, 21.2711, 31.1509>, <24.5756, 22.1466, 31.5848> }
			triangle { <30.8783, 23.1781, 28.1667>, <29.6052, 21.2711, 31.1509>, <26.5112, 23.5947, 28.2423> }
			triangle { <29.6052, 21.2711, 31.1509>, <34.5556, 18.4461, 32.1635>, <28.1407, 18.6212, 32.7425> }
			triangle { <30.8783, 23.1781, 28.1667>, <34.5556, 18.4461, 32.1635>, <29.6052, 21.2711, 31.1509> }
			triangle { <24.3332, 25.01043, 23.6674>, <20.7485, 22.883, 28.08773>, <19.9204, 25.4767, 19.976> }
			triangle { <26.5112, 23.5947, 28.2423>, <20.7485, 22.883, 28.08773>, <24.3332, 25.01043, 23.6674> }
			triangle { <27.8486, 24.4108, 26.413>, <26.5112, 23.5947, 28.2423>, <24.3332, 25.01043, 23.6674> }
			triangle { <27.8486, 24.4108, 26.413>, <30.8783, 23.1781, 28.1667>, <26.5112, 23.5947, 28.2423> }
			triangle { <20.7485, 22.883, 28.08773>, <24.5756, 22.1466, 31.5848>, <21.4437, 17.8959, 31.4203> }
			triangle { <24.5756, 22.1466, 31.5848>, <28.1407, 18.6212, 32.7425>, <21.4437, 17.8959, 31.4203> }
			triangle { <30.8783, 23.1781, 28.1667>, <37.9164, 21.3574, 28.4962>, <36.3548, 19.9531, 30.4839> }
			triangle { <37.9164, 21.3574, 28.4962>, <39.2466, 16.8826, 30.5374>, <36.3548, 19.9531, 30.4839> }
			triangle { <30.8783, 23.1781, 28.1667>, <36.3548, 19.9531, 30.4839>, <34.5556, 18.4461, 32.1635> }
			triangle { <36.3548, 19.9531, 30.4839>, <39.2466, 16.8826, 30.5374>, <34.5556, 18.4461, 32.1635> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // inflorescence
		union { // inflor. internode
			cylinder { <-0.0115, 3.3482, 0.347>, <-0.1938, 4.1621, 0.3292>, 0.3888 }
			cylinder { <-0.1938, 4.1621, 0.3292>, <-0.3761, 4.9761, 0.3114>, 0.3888 }
			cylinder { <-0.3761, 4.9761, 0.3114>, <-0.5583, 5.79, 0.2935>, 0.3888 }
			cylinder { <-0.5583, 5.79, 0.2935>, <-0.7406, 6.6039, 0.2757>, 0.3888 }
			cylinder { <-0.7406, 6.6039, 0.2757>, <-0.9229, 7.4179, 0.2579>, 0.3888 }
			cylinder { <-0.9229, 7.4179, 0.2579>, <-1.1052, 8.2318, 0.2401>, 0.3888 }
			cylinder { <-1.1052, 8.2318, 0.2401>, <-1.2875, 9.04576, 0.2223>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.2875, 9.04576, 0.2223>, <-2.2635, 12.9387, -0.555>, 0.3888 }
				cylinder { <-2.2635, 12.9387, -0.555>, <-3.2934, 16.6217, -1.9995>, 0.3888 }
				cylinder { <-3.2934, 16.6217, -1.9995>, <-4.3469, 19.9863, -4.06864>, 0.3888 }
				cylinder { <-4.3469, 19.9863, -4.06864>, <-5.393, 22.9335, -6.7014>, 0.3888 }
				cylinder { <-5.393, 22.9335, -6.7014>, <-6.4008, 25.3764, -9.8204>, 0.3888 }
				cylinder { <-6.4008, 25.3764, -9.8204>, <-7.3408, 27.2432, -13.3337>, 0.3888 }
				cylinder { <-7.3408, 27.2432, -13.3337>, <-8.1853, 28.4788, -17.1379>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-8.1853, 28.4788, -17.1379>, <-8.4693, 28.4411, -17.741>, <-8.4911, 28.7285, -17.7363> }
					triangle { <-8.4693, 28.4411, -17.741>, <-8.6602, 28.4345, -18.2146>, <-8.4911, 28.7285, -17.7363> }
					triangle { <-8.4911, 28.7285, -17.7363>, <-8.8157, 28.7007, -18.3272>, <-8.7384, 28.9421, -18.266> }
					triangle { <-8.8157, 28.7007, -18.3272>, <-9.7142, 28.899, -18.5304>, <-8.7384, 28.9421, -18.266> }
					triangle { <-8.4911, 28.7285, -17.7363>, <-8.6602, 28.4345, -18.2146>, <-8.8157, 28.7007, -18.3272> }
					triangle { <-8.6602, 28.4345, -18.2146>, <-9.7954, 28.6042, -18.5615>, <-8.8157, 28.7007, -18.3272> }
					triangle { <-8.8157, 28.7007, -18.3272>, <-9.7954, 28.6042, -18.5615>, <-9.7142, 28.899, -18.5304> }
					triangle { <-8.7384, 28.9421, -18.266>, <-9.7142, 28.899, -18.5304>, <-9.6883, 29.2941, -18.4546> }
					triangle { <-9.7954, 28.6042, -18.5615>, <-10.2847, 28.7572, -18.917>, <-9.7142, 28.899, -18.5304> }
					triangle { <-10.2847, 28.7572, -18.917>, <-11.3647, 29.3573, -18.8093>, <-10.1867, 29.1456, -18.906> }
					triangle { <-9.7142, 28.899, -18.5304>, <-10.2847, 28.7572, -18.917>, <-10.1867, 29.1456, -18.906> }
					triangle { <-9.6883, 29.2941, -18.4546>, <-9.7142, 28.899, -18.5304>, <-10.1867, 29.1456, -18.906> }
					triangle { <-9.6883, 29.2941, -18.4546>, <-10.1867, 29.1456, -18.906>, <-10.1519, 29.5275, -18.7897> }
					triangle { <-10.1867, 29.1456, -18.906>, <-11.3647, 29.3573, -18.8093>, <-11.6739, 29.9751, -18.6334> }
					triangle { <-10.1519, 29.5275, -18.7897>, <-10.1867, 29.1456, -18.906>, <-11.6739, 29.9751, -18.6334> }
					triangle { <-8.4911, 28.7285, -17.7363>, <-8.2922, 28.9403, -17.7116>, <-8.1853, 28.4788, -17.1379> }
					triangle { <-8.4911, 28.7285, -17.7363>, <-8.4875, 29.2057, -17.9558>, <-8.2922, 28.9403, -17.7116> }
					triangle { <-8.7384, 28.9421, -18.266>, <-8.5613, 29.1268, -18.292>, <-8.4911, 28.7285, -17.7363> }
					triangle { <-8.7384, 28.9421, -18.266>, <-9.5447, 29.6061, -18.3851>, <-8.5613, 29.1268, -18.292> }
					triangle { <-8.5613, 29.1268, -18.292>, <-8.4875, 29.2057, -17.9558>, <-8.4911, 28.7285, -17.7363> }
					triangle { <-8.5613, 29.1268, -18.292>, <-9.3574, 29.9724, -18.2143>, <-8.4875, 29.2057, -17.9558> }
					triangle { <-9.5447, 29.6061, -18.3851>, <-9.3574, 29.9724, -18.2143>, <-8.5613, 29.1268, -18.292> }
					triangle { <-9.6883, 29.2941, -18.4546>, <-9.5447, 29.6061, -18.3851>, <-8.7384, 28.9421, -18.266> }
					triangle { <-9.5447, 29.6061, -18.3851>, <-9.8673, 30.2929, -18.4641>, <-9.3574, 29.9724, -18.2143> }
					triangle { <-10.1041, 29.9497, -18.6632>, <-11.2137, 30.416, -18.5457>, <-9.8673, 30.2929, -18.4641> }
					triangle { <-10.1041, 29.9497, -18.6632>, <-9.8673, 30.2929, -18.4641>, <-9.5447, 29.6061, -18.3851> }
					triangle { <-10.1041, 29.9497, -18.6632>, <-9.5447, 29.6061, -18.3851>, <-9.6883, 29.2941, -18.4546> }
					triangle { <-10.1519, 29.5275, -18.7897>, <-10.1041, 29.9497, -18.6632>, <-9.6883, 29.2941, -18.4546> }
					triangle { <-11.6739, 29.9751, -18.6334>, <-11.2137, 30.416, -18.5457>, <-10.1041, 29.9497, -18.6632> }
					triangle { <-11.6739, 29.9751, -18.6334>, <-10.1041, 29.9497, -18.6632>, <-10.1519, 29.5275, -18.7897> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-8.1853, 28.4788, -17.1379>, <-8.5671, 28.7259, -17.6268>, <-8.3309, 28.8542, -17.731> }
					triangle { <-8.5671, 28.7259, -17.6268>, <-8.8365, 28.8988, -18.02475>, <-8.3309, 28.8542, -17.731> }
					triangle { <-8.3309, 28.8542, -17.731>, <-8.7132, 29.1427, -18.2064>, <-8.458, 29.1621, -18.2567> }
					triangle { <-8.7132, 29.1427, -18.2064>, <-8.9397, 30.0492, -18.3288>, <-8.458, 29.1621, -18.2567> }
					triangle { <-8.3309, 28.8542, -17.731>, <-8.8365, 28.8988, -18.02475>, <-8.7132, 29.1427, -18.2064> }
					triangle { <-8.8365, 28.8988, -18.02475>, <-9.2284, 30.01337, -18.2296>, <-8.7132, 29.1427, -18.2064> }
					triangle { <-8.7132, 29.1427, -18.2064>, <-9.2284, 30.01337, -18.2296>, <-8.9397, 30.0492, -18.3288> }
					triangle { <-8.458, 29.1621, -18.2567>, <-8.9397, 30.0492, -18.3288>, <-8.5669, 30.1741, -18.4177> }
					triangle { <-9.2284, 30.01337, -18.2296>, <-9.4166, 30.5231, -18.5361>, <-8.9397, 30.0492, -18.3288> }
					triangle { <-9.4166, 30.5231, -18.5361>, <-9.2373, 31.7499, -18.5044>, <-9.05183, 30.5786, -18.6925> }
					triangle { <-8.9397, 30.0492, -18.3288>, <-9.4166, 30.5231, -18.5361>, <-9.05183, 30.5786, -18.6925> }
					triangle { <-8.5669, 30.1741, -18.4177>, <-8.9397, 30.0492, -18.3288>, <-9.05183, 30.5786, -18.6925> }
					triangle { <-8.5669, 30.1741, -18.4177>, <-9.05183, 30.5786, -18.6925>, <-8.67, 30.6904, -18.7409> }
					triangle { <-9.05183, 30.5786, -18.6925>, <-9.2373, 31.7499, -18.5044>, <-8.7502, 32.2694, -18.5372> }
					triangle { <-8.67, 30.6904, -18.7409>, <-9.05183, 30.5786, -18.6925>, <-8.7502, 32.2694, -18.5372> }
					triangle { <-8.3309, 28.8542, -17.731>, <-8.07429, 28.7498, -17.8219>, <-8.1853, 28.4788, -17.1379> }
					triangle { <-8.3309, 28.8542, -17.731>, <-8.02047, 29.02988, -18.1166>, <-8.07429, 28.7498, -17.8219> }
					triangle { <-8.458, 29.1621, -18.2567>, <-8.2529, 29.06758, -18.3797>, <-8.3309, 28.8542, -17.731> }
					triangle { <-8.458, 29.1621, -18.2567>, <-8.2262, 30.1587, -18.4983>, <-8.2529, 29.06758, -18.3797> }
					triangle { <-8.2529, 29.06758, -18.3797>, <-8.02047, 29.02988, -18.1166>, <-8.3309, 28.8542, -17.731> }
					triangle { <-8.2529, 29.06758, -18.3797>, <-7.7825, 30.1235, -18.5148>, <-8.02047, 29.02988, -18.1166> }
					triangle { <-8.2262, 30.1587, -18.4983>, <-7.7825, 30.1235, -18.5148>, <-8.2529, 29.06758, -18.3797> }
					triangle { <-8.5669, 30.1741, -18.4177>, <-8.2262, 30.1587, -18.4983>, <-8.458, 29.1621, -18.2567> }
					triangle { <-8.2262, 30.1587, -18.4983>, <-7.7925, 30.7158, -18.7873>, <-7.7825, 30.1235, -18.5148> }
					triangle { <-8.2457, 30.8054, -18.7977>, <-8.185, 32.00931, -18.7004>, <-7.7925, 30.7158, -18.7873> }
					triangle { <-8.2457, 30.8054, -18.7977>, <-7.7925, 30.7158, -18.7873>, <-8.2262, 30.1587, -18.4983> }
					triangle { <-8.2457, 30.8054, -18.7977>, <-8.2262, 30.1587, -18.4983>, <-8.5669, 30.1741, -18.4177> }
					triangle { <-8.67, 30.6904, -18.7409>, <-8.2457, 30.8054, -18.7977>, <-8.5669, 30.1741, -18.4177> }
					triangle { <-8.7502, 32.2694, -18.5372>, <-8.185, 32.00931, -18.7004>, <-8.2457, 30.8054, -18.7977> }
					triangle { <-8.7502, 32.2694, -18.5372>, <-8.2457, 30.8054, -18.7977>, <-8.67, 30.6904, -18.7409> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-8.1853, 28.4788, -17.1379>, <-8.3133, 28.924, -17.6188>, <-8.168, 28.7532, -17.8> }
					triangle { <-8.3133, 28.924, -17.6188>, <-8.427, 29.2374, -18.00563>, <-8.168, 28.7532, -17.8> }
					triangle { <-8.168, 28.7532, -17.8>, <-8.2558, 29.2144, -18.2846>, <-8.173, 28.9852, -18.3774> }
					triangle { <-8.2558, 29.2144, -18.2846>, <-7.6226, 29.7651, -18.7134>, <-8.173, 28.9852, -18.3774> }
					triangle { <-8.168, 28.7532, -17.8>, <-8.427, 29.2374, -18.00563>, <-8.2558, 29.2144, -18.2846> }
					triangle { <-8.427, 29.2374, -18.00563>, <-7.7102, 30.01946, -18.5646>, <-8.2558, 29.2144, -18.2846> }
					triangle { <-8.2558, 29.2144, -18.2846>, <-7.7102, 30.01946, -18.5646>, <-7.6226, 29.7651, -18.7134> }
					triangle { <-8.173, 28.9852, -18.3774>, <-7.6226, 29.7651, -18.7134>, <-7.427, 29.4665, -18.9005> }
					triangle { <-7.7102, 30.01946, -18.5646>, <-7.4745, 30.3847, -19.01219>, <-7.6226, 29.7651, -18.7134> }
					triangle { <-7.4745, 30.3847, -19.01219>, <-6.3684, 30.6804, -19.4886>, <-7.3683, 30.06715, -19.2323> }
					triangle { <-7.6226, 29.7651, -18.7134>, <-7.4745, 30.3847, -19.01219>, <-7.3683, 30.06715, -19.2323> }
					triangle { <-7.427, 29.4665, -18.9005>, <-7.6226, 29.7651, -18.7134>, <-7.3683, 30.06715, -19.2323> }
					triangle { <-7.427, 29.4665, -18.9005>, <-7.3683, 30.06715, -19.2323>, <-7.1637, 29.7553, -19.379> }
					triangle { <-7.3683, 30.06715, -19.2323>, <-6.3684, 30.6804, -19.4886>, <-5.7782, 30.4246, -19.7961> }
					triangle { <-7.1637, 29.7553, -19.379>, <-7.3683, 30.06715, -19.2323>, <-5.7782, 30.4246, -19.7961> }
					triangle { <-8.168, 28.7532, -17.8>, <-8.2059, 28.4758, -17.8817>, <-8.1853, 28.4788, -17.1379> }
					triangle { <-8.168, 28.7532, -17.8>, <-8.07548, 28.5304, -18.2666>, <-8.2059, 28.4758, -17.8817> }
					triangle { <-8.173, 28.9852, -18.3774>, <-8.2337, 28.7592, -18.4841>, <-8.168, 28.7532, -17.8> }
					triangle { <-8.173, 28.9852, -18.3774>, <-7.3568, 29.1448, -19.02065>, <-8.2337, 28.7592, -18.4841> }
					triangle { <-8.2337, 28.7592, -18.4841>, <-8.07548, 28.5304, -18.2666>, <-8.168, 28.7532, -17.8> }
					triangle { <-8.2337, 28.7592, -18.4841>, <-7.2411, 28.7204, -19.09075>, <-8.07548, 28.5304, -18.2666> }
					triangle { <-7.3568, 29.1448, -19.02065>, <-7.2411, 28.7204, -19.09075>, <-8.2337, 28.7592, -18.4841> }
					triangle { <-7.427, 29.4665, -18.9005>, <-7.3568, 29.1448, -19.02065>, <-8.173, 28.9852, -18.3774> }
					triangle { <-7.3568, 29.1448, -19.02065>, <-6.8608, 28.9518, -19.5671>, <-7.2411, 28.7204, -19.09075> }
					triangle { <-6.9452, 29.4053, -19.5412>, <-5.8715, 29.8025, -19.9308>, <-6.8608, 28.9518, -19.5671> }
					triangle { <-6.9452, 29.4053, -19.5412>, <-6.8608, 28.9518, -19.5671>, <-7.3568, 29.1448, -19.02065> }
					triangle { <-6.9452, 29.4053, -19.5412>, <-7.3568, 29.1448, -19.02065>, <-7.427, 29.4665, -18.9005> }
					triangle { <-7.1637, 29.7553, -19.379>, <-6.9452, 29.4053, -19.5412>, <-7.427, 29.4665, -18.9005> }
					triangle { <-5.7782, 30.4246, -19.7961>, <-5.8715, 29.8025, -19.9308>, <-6.9452, 29.4053, -19.5412> }
					triangle { <-5.7782, 30.4246, -19.7961>, <-6.9452, 29.4053, -19.5412>, <-7.1637, 29.7553, -19.379> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-8.1853, 28.4788, -17.1379>, <-8.05635, 28.7635, -17.728>, <-8.226, 28.564, -17.8485> }
					triangle { <-8.05635, 28.7635, -17.728>, <-7.9939, 28.9856, -18.1835>, <-8.226, 28.564, -17.8485> }
					triangle { <-8.226, 28.564, -17.8485>, <-8.07141, 28.8175, -18.4545>, <-8.2746, 28.6542, -18.4624> }
					triangle { <-8.07141, 28.8175, -18.4545>, <-7.5708, 28.4368, -19.1563>, <-8.2746, 28.6542, -18.4624> }
					triangle { <-8.226, 28.564, -17.8485>, <-7.9939, 28.9856, -18.1835>, <-8.07141, 28.8175, -18.4545> }
					triangle { <-7.9939, 28.9856, -18.1835>, <-7.3248, 28.6141, -19.1067>, <-8.07141, 28.8175, -18.4545> }
					triangle { <-8.07141, 28.8175, -18.4545>, <-7.3248, 28.6141, -19.1067>, <-7.5708, 28.4368, -19.1563> }
					triangle { <-8.2746, 28.6542, -18.4624>, <-7.5708, 28.4368, -19.1563>, <-7.8332, 28.1426, -19.2404> }
					triangle { <-7.3248, 28.6141, -19.1067>, <-7.1243, 28.5319, -19.6917>, <-7.5708, 28.4368, -19.1563> }
					triangle { <-7.1243, 28.5319, -19.6917>, <-6.6959, 27.6169, -20.4109>, <-7.4471, 28.3132, -19.7845> }
					triangle { <-7.5708, 28.4368, -19.1563>, <-7.1243, 28.5319, -19.6917>, <-7.4471, 28.3132, -19.7845> }
					triangle { <-7.8332, 28.1426, -19.2404>, <-7.5708, 28.4368, -19.1563>, <-7.4471, 28.3132, -19.7845> }
					triangle { <-7.8332, 28.1426, -19.2404>, <-7.4471, 28.3132, -19.7845>, <-7.7005, 28.0059, -19.8281> }
					triangle { <-7.4471, 28.3132, -19.7845>, <-6.6959, 27.6169, -20.4109>, <-6.8374, 26.9729, -20.6821> }
					triangle { <-7.7005, 28.0059, -19.8281>, <-7.4471, 28.3132, -19.7845>, <-6.8374, 26.9729, -20.6821> }
					triangle { <-8.226, 28.564, -17.8485>, <-8.5064, 28.4945, -17.8089>, <-8.1853, 28.4788, -17.1379> }
					triangle { <-8.226, 28.564, -17.8485>, <-8.577, 28.393, -18.1999>, <-8.5064, 28.4945, -17.8089> }
					triangle { <-8.2746, 28.6542, -18.4624>, <-8.5301, 28.625, -18.4619>, <-8.226, 28.564, -17.8485> }
					triangle { <-8.2746, 28.6542, -18.4624>, <-8.1299, 27.9561, -19.2351>, <-8.5301, 28.625, -18.4619> }
					triangle { <-8.5301, 28.625, -18.4619>, <-8.577, 28.393, -18.1999>, <-8.226, 28.564, -17.8485> }
					triangle { <-8.5301, 28.625, -18.4619>, <-8.4764, 27.689, -19.1515>, <-8.577, 28.393, -18.1999> }
					triangle { <-8.1299, 27.9561, -19.2351>, <-8.4764, 27.689, -19.1515>, <-8.5301, 28.625, -18.4619> }
					triangle { <-7.8332, 28.1426, -19.2404>, <-8.1299, 27.9561, -19.2351>, <-8.2746, 28.6542, -18.4624> }
					triangle { <-8.1299, 27.9561, -19.2351>, <-8.351, 27.4222, -19.7331>, <-8.4764, 27.689, -19.1515> }
					triangle { <-7.9878, 27.6713, -19.873>, <-7.4488, 26.8248, -20.5478>, <-8.351, 27.4222, -19.7331> }
					triangle { <-7.9878, 27.6713, -19.873>, <-8.351, 27.4222, -19.7331>, <-8.1299, 27.9561, -19.2351> }
					triangle { <-7.9878, 27.6713, -19.873>, <-8.1299, 27.9561, -19.2351>, <-7.8332, 28.1426, -19.2404> }
					triangle { <-7.7005, 28.0059, -19.8281>, <-7.9878, 27.6713, -19.873>, <-7.8332, 28.1426, -19.2404> }
					triangle { <-6.8374, 26.9729, -20.6821>, <-7.4488, 26.8248, -20.5478>, <-7.9878, 27.6713, -19.873> }
					triangle { <-6.8374, 26.9729, -20.6821>, <-7.9878, 27.6713, -19.873>, <-7.7005, 28.0059, -19.8281> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-8.1853, 28.4788, -17.1379>, <-8.1542, 28.4605, -17.8047>, <-8.4287, 28.5486, -17.8086> }
					triangle { <-8.1542, 28.4605, -17.8047>, <-8.1401, 28.4819, -18.3147>, <-8.4287, 28.5486, -17.8086> }
					triangle { <-8.4287, 28.5486, -17.8086>, <-8.4226, 28.4952, -18.4812>, <-8.6293, 28.6272, -18.3925> }
					triangle { <-8.4226, 28.4952, -18.4812>, <-8.883, 27.8935, -19.0416>, <-8.6293, 28.6272, -18.3925> }
					triangle { <-8.4287, 28.5486, -17.8086>, <-8.1401, 28.4819, -18.3147>, <-8.4226, 28.4952, -18.4812> }
					triangle { <-8.1401, 28.4819, -18.3147>, <-8.6329, 27.7263, -19.1047>, <-8.4226, 28.4952, -18.4812> }
					triangle { <-8.4226, 28.4952, -18.4812>, <-8.6329, 27.7263, -19.1047>, <-8.883, 27.8935, -19.0416> }
					triangle { <-8.6293, 28.6272, -18.3925>, <-8.883, 27.8935, -19.0416>, <-9.2519, 28.03445, -18.9606> }
					triangle { <-8.6329, 27.7263, -19.1047>, <-8.8873, 27.5108, -19.632>, <-8.883, 27.8935, -19.0416> }
					triangle { <-8.8873, 27.5108, -19.632>, <-9.8304, 26.7869, -19.9848>, <-9.2153, 27.7351, -19.5798> }
					triangle { <-8.883, 27.8935, -19.0416>, <-8.8873, 27.5108, -19.632>, <-9.2153, 27.7351, -19.5798> }
					triangle { <-9.2519, 28.03445, -18.9606>, <-8.883, 27.8935, -19.0416>, <-9.2153, 27.7351, -19.5798> }
					triangle { <-9.2519, 28.03445, -18.9606>, <-9.2153, 27.7351, -19.5798>, <-9.5752, 27.8629, -19.4584> }
					triangle { <-9.2153, 27.7351, -19.5798>, <-9.8304, 26.7869, -19.9848>, <-10.5361, 26.691, -19.9527> }
					triangle { <-9.5752, 27.8629, -19.4584>, <-9.2153, 27.7351, -19.5798>, <-10.5361, 26.691, -19.9527> }
					triangle { <-8.4287, 28.5486, -17.8086>, <-8.5605, 28.7859, -17.7022>, <-8.1853, 28.4788, -17.1379> }
					triangle { <-8.4287, 28.5486, -17.8086>, <-8.8355, 28.8166, -18.00494>, <-8.5605, 28.7859, -17.7022> }
					triangle { <-8.6293, 28.6272, -18.3925>, <-8.7356, 28.8557, -18.3413>, <-8.4287, 28.5486, -17.8086> }
					triangle { <-8.6293, 28.6272, -18.3925>, <-9.5025, 28.2455, -18.8364>, <-8.7356, 28.8557, -18.3413> }
					triangle { <-8.7356, 28.8557, -18.3413>, <-8.8355, 28.8166, -18.00494>, <-8.4287, 28.5486, -17.8086> }
					triangle { <-8.7356, 28.8557, -18.3413>, <-9.8041, 28.4744, -18.6017>, <-8.8355, 28.8166, -18.00494> }
					triangle { <-9.5025, 28.2455, -18.8364>, <-9.8041, 28.4744, -18.6017>, <-8.7356, 28.8557, -18.3413> }
					triangle { <-9.2519, 28.03445, -18.9606>, <-9.5025, 28.2455, -18.8364>, <-8.6293, 28.6272, -18.3925> }
					triangle { <-9.5025, 28.2455, -18.8364>, <-10.2372, 28.2636, -19.04119>, <-9.8041, 28.4744, -18.6017> }
					triangle { <-9.9695, 28.0128, -19.3222>, <-10.8003, 27.2096, -19.6789>, <-10.2372, 28.2636, -19.04119> }
					triangle { <-9.9695, 28.0128, -19.3222>, <-10.2372, 28.2636, -19.04119>, <-9.5025, 28.2455, -18.8364> }
					triangle { <-9.9695, 28.0128, -19.3222>, <-9.5025, 28.2455, -18.8364>, <-9.2519, 28.03445, -18.9606> }
					triangle { <-9.5752, 27.8629, -19.4584>, <-9.9695, 28.0128, -19.3222>, <-9.2519, 28.03445, -18.9606> }
					triangle { <-10.5361, 26.691, -19.9527>, <-10.8003, 27.2096, -19.6789>, <-9.9695, 28.0128, -19.3222> }
					triangle { <-10.5361, 26.691, -19.9527>, <-9.9695, 28.0128, -19.3222>, <-9.5752, 27.8629, -19.4584> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.2875, 9.04576, 0.2223>, <-1.4698, 9.8596, 0.2044>, 0.3888 }
			cylinder { <-1.4698, 9.8596, 0.2044>, <-1.6521, 10.6736, 0.1866>, 0.3888 }
			cylinder { <-1.6521, 10.6736, 0.1866>, <-1.8344, 11.4875, 0.1688>, 0.3888 }
			cylinder { <-1.8344, 11.4875, 0.1688>, <-2.01679, 12.3014, 0.151>, 0.3888 }
			cylinder { <-2.01679, 12.3014, 0.151>, <-2.199, 13.1154, 0.1332>, 0.3888 }
			cylinder { <-2.199, 13.1154, 0.1332>, <-2.3813, 13.9293, 0.1154>, 0.3888 }
			cylinder { <-2.3813, 13.9293, 0.1154>, <-2.5636, 14.7432, 0.09758>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.5636, 14.7432, 0.09758>, <-3.8262, 18.5998, 0.5919>, 0.3888 }
				cylinder { <-3.8262, 18.5998, 0.5919>, <-5.4209, 22.2112, 1.6534>, 0.3888 }
				cylinder { <-5.4209, 22.2112, 1.6534>, <-7.3008, 25.471, 3.2507>, 0.3888 }
				cylinder { <-7.3008, 25.471, 3.2507>, <-9.4105, 28.2832, 5.3369>, 0.3888 }
				cylinder { <-9.4105, 28.2832, 5.3369>, <-11.6879, 30.5651, 7.8505>, 0.3888 }
				cylinder { <-11.6879, 30.5651, 7.8505>, <-14.06604, 32.2495, 10.7175>, 0.3888 }
				cylinder { <-14.06604, 32.2495, 10.7175>, <-16.4747, 33.2867, 13.8534>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-16.4747, 33.2867, 13.8534>, <-16.6585, 33.2943, 14.4399>, <-16.7369, 33.5449, 14.4012> }
					triangle { <-16.6585, 33.2943, 14.4399>, <-16.83, 33.3084, 14.8773>, <-16.7369, 33.5449, 14.4012> }
					triangle { <-16.7369, 33.5449, 14.4012>, <-16.892, 33.5765, 15.00182>, <-16.9807, 33.7589, 14.8733> }
					triangle { <-16.892, 33.5765, 15.00182>, <-16.5371, 34.04198, 15.642>, <-16.9807, 33.7589, 14.8733> }
					triangle { <-16.7369, 33.5449, 14.4012>, <-16.83, 33.3084, 14.8773>, <-16.892, 33.5765, 15.00182> }
					triangle { <-16.83, 33.3084, 14.8773>, <-16.4101, 33.819, 15.7611>, <-16.892, 33.5765, 15.00182> }
					triangle { <-16.892, 33.5765, 15.00182>, <-16.4101, 33.819, 15.7611>, <-16.5371, 34.04198, 15.642> }
					triangle { <-16.9807, 33.7589, 14.8733>, <-16.5371, 34.04198, 15.642>, <-16.6362, 34.3736, 15.5083> }
					triangle { <-16.4101, 33.819, 15.7611>, <-16.3811, 34.08549, 16.269>, <-16.5371, 34.04198, 15.642> }
					triangle { <-16.3811, 34.08549, 16.269>, <-15.8585, 34.9856, 16.7377>, <-16.5613, 34.3793, 16.1377> }
					triangle { <-16.5371, 34.04198, 15.642>, <-16.3811, 34.08549, 16.269>, <-16.5613, 34.3793, 16.1377> }
					triangle { <-16.6362, 34.3736, 15.5083>, <-16.5371, 34.04198, 15.642>, <-16.5613, 34.3793, 16.1377> }
					triangle { <-16.6362, 34.3736, 15.5083>, <-16.5613, 34.3793, 16.1377>, <-16.6368, 34.7008, 15.9734> }
					triangle { <-16.5613, 34.3793, 16.1377>, <-15.8585, 34.9856, 16.7377>, <-15.7668, 35.6342, 16.698> }
					triangle { <-16.6368, 34.7008, 15.9734>, <-16.5613, 34.3793, 16.1377>, <-15.7668, 35.6342, 16.698> }
					triangle { <-16.7369, 33.5449, 14.4012>, <-16.9118, 33.6555, 14.2302>, <-16.4747, 33.2867, 13.8534> }
					triangle { <-16.7369, 33.5449, 14.4012>, <-17.02979, 33.9237, 14.4682>, <-16.9118, 33.6555, 14.2302> }
					triangle { <-16.9807, 33.7589, 14.8733>, <-17.1644, 33.8492, 14.7545>, <-16.7369, 33.5449, 14.4012> }
					triangle { <-16.9807, 33.7589, 14.8733>, <-16.7832, 34.5928, 15.3229>, <-17.1644, 33.8492, 14.7545> }
					triangle { <-17.1644, 33.8492, 14.7545>, <-17.02979, 33.9237, 14.4682>, <-16.7369, 33.5449, 14.4012> }
					triangle { <-17.1644, 33.8492, 14.7545>, <-16.9126, 34.8525, 15.03331>, <-17.02979, 33.9237, 14.4682> }
					triangle { <-16.7832, 34.5928, 15.3229>, <-16.9126, 34.8525, 15.03331>, <-17.1644, 33.8492, 14.7545> }
					triangle { <-16.6362, 34.3736, 15.5083>, <-16.7832, 34.5928, 15.3229>, <-16.9807, 33.7589, 14.8733> }
					triangle { <-16.7832, 34.5928, 15.3229>, <-16.8617, 35.2783, 15.4531>, <-16.9126, 34.8525, 15.03331> }
					triangle { <-16.7271, 35.05274, 15.7876>, <-16.1366, 35.8515, 16.2899>, <-16.8617, 35.2783, 15.4531> }
					triangle { <-16.7271, 35.05274, 15.7876>, <-16.8617, 35.2783, 15.4531>, <-16.7832, 34.5928, 15.3229> }
					triangle { <-16.7271, 35.05274, 15.7876>, <-16.7832, 34.5928, 15.3229>, <-16.6362, 34.3736, 15.5083> }
					triangle { <-16.6368, 34.7008, 15.9734>, <-16.7271, 35.05274, 15.7876>, <-16.6362, 34.3736, 15.5083> }
					triangle { <-15.7668, 35.6342, 16.698>, <-16.1366, 35.8515, 16.2899>, <-16.7271, 35.05274, 15.7876> }
					triangle { <-15.7668, 35.6342, 16.698>, <-16.7271, 35.05274, 15.7876>, <-16.6368, 34.7008, 15.9734> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-16.4747, 33.2867, 13.8534>, <-16.6231, 33.5808, 14.3723>, <-16.8719, 33.5946, 14.281> }
					triangle { <-16.6231, 33.5808, 14.3723>, <-16.7597, 33.7817, 14.7747>, <-16.8719, 33.5946, 14.281> }
					triangle { <-16.8719, 33.5946, 14.281>, <-17.02546, 33.9251, 14.784>, <-17.217, 33.8459, 14.663> }
					triangle { <-17.02546, 33.9251, 14.784>, <-17.2607, 34.7574, 14.8496>, <-17.217, 33.8459, 14.663> }
					triangle { <-16.8719, 33.5946, 14.281>, <-16.7597, 33.7817, 14.7747>, <-17.02546, 33.9251, 14.784> }
					triangle { <-16.7597, 33.7817, 14.7747>, <-17.0136, 34.8397, 14.96>, <-17.02546, 33.9251, 14.784> }
					triangle { <-17.02546, 33.9251, 14.784>, <-17.0136, 34.8397, 14.96>, <-17.2607, 34.7574, 14.8496> }
					triangle { <-17.217, 33.8459, 14.663>, <-17.2607, 34.7574, 14.8496>, <-17.5817, 34.7215, 14.667> }
					triangle { <-17.0136, 34.8397, 14.96>, <-17.2542, 35.3052, 15.195>, <-17.2607, 34.7574, 14.8496> }
					triangle { <-17.2542, 35.3052, 15.195>, <-17.7463, 36.2792, 14.8599>, <-17.5887, 35.2066, 15.07494> }
					triangle { <-17.2607, 34.7574, 14.8496>, <-17.2542, 35.3052, 15.195>, <-17.5887, 35.2066, 15.07494> }
					triangle { <-17.5817, 34.7215, 14.667>, <-17.2607, 34.7574, 14.8496>, <-17.5887, 35.2066, 15.07494> }
					triangle { <-17.5817, 34.7215, 14.667>, <-17.5887, 35.2066, 15.07494>, <-17.8862, 35.1605, 14.8617> }
					triangle { <-17.5887, 35.2066, 15.07494>, <-17.7463, 36.2792, 14.8599>, <-18.2318, 36.5412, 14.5047> }
					triangle { <-17.8862, 35.1605, 14.8617>, <-17.5887, 35.2066, 15.07494>, <-18.2318, 36.5412, 14.5047> }
					triangle { <-16.8719, 33.5946, 14.281>, <-17.04855, 33.4062, 14.2077>, <-16.4747, 33.2867, 13.8534> }
					triangle { <-16.8719, 33.5946, 14.281>, <-17.353, 33.5933, 14.3292>, <-17.04855, 33.4062, 14.2077> }
					triangle { <-17.217, 33.8459, 14.663>, <-17.3852, 33.6809, 14.6406>, <-16.8719, 33.5946, 14.281> }
					triangle { <-17.217, 33.8459, 14.663>, <-17.8322, 34.5794, 14.5216>, <-17.3852, 33.6809, 14.6406> }
					triangle { <-17.3852, 33.6809, 14.6406>, <-17.353, 33.5933, 14.3292>, <-16.8719, 33.5946, 14.281> }
					triangle { <-17.3852, 33.6809, 14.6406>, <-18.09941, 34.3907, 14.2745>, <-17.353, 33.5933, 14.3292> }
					triangle { <-17.8322, 34.5794, 14.5216>, <-18.09941, 34.3907, 14.2745>, <-17.3852, 33.6809, 14.6406> }
					triangle { <-17.5817, 34.7215, 14.667>, <-17.8322, 34.5794, 14.5216>, <-17.217, 33.8459, 14.663> }
					triangle { <-17.8322, 34.5794, 14.5216>, <-18.4542, 34.8659, 14.3664>, <-18.09941, 34.3907, 14.2745> }
					triangle { <-18.2156, 35.1012, 14.6283>, <-18.5883, 36.1047, 14.3231>, <-18.4542, 34.8659, 14.3664> }
					triangle { <-18.2156, 35.1012, 14.6283>, <-18.4542, 34.8659, 14.3664>, <-17.8322, 34.5794, 14.5216> }
					triangle { <-18.2156, 35.1012, 14.6283>, <-17.8322, 34.5794, 14.5216>, <-17.5817, 34.7215, 14.667> }
					triangle { <-17.8862, 35.1605, 14.8617>, <-18.2156, 35.1012, 14.6283>, <-17.5817, 34.7215, 14.667> }
					triangle { <-18.2318, 36.5412, 14.5047>, <-18.5883, 36.1047, 14.3231>, <-18.2156, 35.1012, 14.6283> }
					triangle { <-18.2318, 36.5412, 14.5047>, <-18.2156, 35.1012, 14.6283>, <-17.8862, 35.1605, 14.8617> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-16.4747, 33.2867, 13.8534>, <-16.837, 33.6587, 14.1823>, <-16.9795, 33.4446, 14.248> }
					triangle { <-16.837, 33.6587, 14.1823>, <-17.1072, 33.9239, 14.4608>, <-16.9795, 33.4446, 14.248> }
					triangle { <-16.9795, 33.4446, 14.248>, <-17.3737, 33.8154, 14.5528>, <-17.4052, 33.5833, 14.6053> }
					triangle { <-17.3737, 33.8154, 14.5528>, <-18.1997, 34.01155, 14.375>, <-17.4052, 33.5833, 14.6053> }
					triangle { <-16.9795, 33.4446, 14.248>, <-17.1072, 33.9239, 14.4608>, <-17.3737, 33.8154, 14.5528> }
					triangle { <-17.1072, 33.9239, 14.4608>, <-18.1394, 34.2721, 14.283>, <-17.3737, 33.8154, 14.5528> }
					triangle { <-17.3737, 33.8154, 14.5528>, <-18.1394, 34.2721, 14.283>, <-18.1997, 34.01155, 14.375> }
					triangle { <-17.4052, 33.5833, 14.6053>, <-18.1997, 34.01155, 14.375>, <-18.3344, 33.6712, 14.4363> }
					triangle { <-18.1394, 34.2721, 14.283>, <-18.6752, 34.451, 14.386>, <-18.1997, 34.01155, 14.375> }
					triangle { <-18.6752, 34.451, 14.386>, <-19.733, 34.2594, 14.00201>, <-18.7697, 34.1231, 14.5262> }
					triangle { <-18.1997, 34.01155, 14.375>, <-18.6752, 34.451, 14.386>, <-18.7697, 34.1231, 14.5262> }
					triangle { <-18.3344, 33.6712, 14.4363>, <-18.1997, 34.01155, 14.375>, <-18.7697, 34.1231, 14.5262> }
					triangle { <-18.3344, 33.6712, 14.4363>, <-18.7697, 34.1231, 14.5262>, <-18.8808, 33.7727, 14.5568> }
					triangle { <-18.7697, 34.1231, 14.5262>, <-19.733, 34.2594, 14.00201>, <-20.1941, 33.8031, 13.9031> }
					triangle { <-18.8808, 33.7727, 14.5568>, <-18.7697, 34.1231, 14.5262>, <-20.1941, 33.8031, 13.9031> }
					triangle { <-16.9795, 33.4446, 14.248>, <-16.9153, 33.2159, 14.3729>, <-16.4747, 33.2867, 13.8534> }
					triangle { <-16.9795, 33.4446, 14.248>, <-17.2472, 33.1765, 14.5483>, <-16.9153, 33.2159, 14.3729> }
					triangle { <-17.4052, 33.5833, 14.6053>, <-17.3593, 33.4034, 14.7522>, <-16.9795, 33.4446, 14.248> }
					triangle { <-17.4052, 33.5833, 14.6053>, <-18.3445, 33.3629, 14.5305>, <-17.3593, 33.4034, 14.7522> }
					triangle { <-17.3593, 33.4034, 14.7522>, <-17.2472, 33.1765, 14.5483>, <-16.9795, 33.4446, 14.248> }
					triangle { <-17.3593, 33.4034, 14.7522>, <-18.318, 32.9569, 14.5808>, <-17.2472, 33.1765, 14.5483> }
					triangle { <-18.3445, 33.3629, 14.5305>, <-18.318, 32.9569, 14.5808>, <-17.3593, 33.4034, 14.7522> }
					triangle { <-18.3344, 33.6712, 14.4363>, <-18.3445, 33.3629, 14.5305>, <-17.4052, 33.5833, 14.6053> }
					triangle { <-18.3445, 33.3629, 14.5305>, <-18.9151, 32.9686, 14.6399>, <-18.318, 32.9569, 14.5808> }
					triangle { <-18.9971, 33.3836, 14.5961>, <-20.01558, 33.2979, 14.1551>, <-18.9151, 32.9686, 14.6399> }
					triangle { <-18.9971, 33.3836, 14.5961>, <-18.9151, 32.9686, 14.6399>, <-18.3445, 33.3629, 14.5305> }
					triangle { <-18.9971, 33.3836, 14.5961>, <-18.3445, 33.3629, 14.5305>, <-18.3344, 33.6712, 14.4363> }
					triangle { <-18.8808, 33.7727, 14.5568>, <-18.9971, 33.3836, 14.5961>, <-18.3344, 33.6712, 14.4363> }
					triangle { <-20.1941, 33.8031, 13.9031>, <-20.01558, 33.2979, 14.1551>, <-18.9971, 33.3836, 14.5961> }
					triangle { <-20.1941, 33.8031, 13.9031>, <-18.9971, 33.3836, 14.5961>, <-18.8808, 33.7727, 14.5568> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-16.4747, 33.2867, 13.8534>, <-17.0066, 33.421, 14.1307>, <-16.9119, 33.3008, 14.3475> }
					triangle { <-17.0066, 33.421, 14.1307>, <-17.3954, 33.5398, 14.3664>, <-16.9119, 33.3008, 14.3475> }
					triangle { <-16.9119, 33.3008, 14.3475>, <-17.4587, 33.398, 14.6255>, <-17.2869, 33.3316, 14.7795> }
					triangle { <-17.4587, 33.398, 14.6255>, <-18.06531, 32.828, 14.8697>, <-17.2869, 33.3316, 14.7795> }
					triangle { <-16.9119, 33.3008, 14.3475>, <-17.3954, 33.5398, 14.3664>, <-17.4587, 33.398, 14.6255> }
					triangle { <-17.3954, 33.5398, 14.3664>, <-18.2422, 32.8953, 14.6594>, <-17.4587, 33.398, 14.6255> }
					triangle { <-17.4587, 33.398, 14.6255>, <-18.2422, 32.8953, 14.6594>, <-18.06531, 32.828, 14.8697> }
					triangle { <-17.2869, 33.3316, 14.7795>, <-18.06531, 32.828, 14.8697>, <-17.8611, 32.6645, 15.1328> }
					triangle { <-18.2422, 32.8953, 14.6594>, <-18.6937, 32.6953, 14.9525>, <-18.06531, 32.828, 14.8697> }
					triangle { <-18.6937, 32.6953, 14.9525>, <-19.09179, 31.6987, 15.3415>, <-18.4831, 32.6161, 15.2448> }
					triangle { <-18.06531, 32.828, 14.8697>, <-18.6937, 32.6953, 14.9525>, <-18.4831, 32.6161, 15.2448> }
					triangle { <-17.8611, 32.6645, 15.1328>, <-18.06531, 32.828, 14.8697>, <-18.4831, 32.6161, 15.2448> }
					triangle { <-17.8611, 32.6645, 15.1328>, <-18.4831, 32.6161, 15.2448>, <-18.2553, 32.4424, 15.4772> }
					triangle { <-18.4831, 32.6161, 15.2448>, <-19.09179, 31.6987, 15.3415>, <-18.9602, 31.1783, 15.719> }
					triangle { <-18.2553, 32.4424, 15.4772>, <-18.4831, 32.6161, 15.2448>, <-18.9602, 31.1783, 15.719> }
					triangle { <-16.9119, 33.3008, 14.3475>, <-16.695, 33.3457, 14.4992>, <-16.4747, 33.2867, 13.8534> }
					triangle { <-16.9119, 33.3008, 14.3475>, <-16.8577, 33.2454, 14.8247>, <-16.695, 33.3457, 14.4992> }
					triangle { <-17.2869, 33.3316, 14.7795>, <-17.1223, 33.3977, 14.9362>, <-16.9119, 33.3008, 14.3475> }
					triangle { <-17.2869, 33.3316, 14.7795>, <-17.617, 32.6131, 15.3373>, <-17.1223, 33.3977, 14.9362> }
					triangle { <-17.1223, 33.3977, 14.9362>, <-16.8577, 33.2454, 14.8247>, <-16.9119, 33.3008, 14.3475> }
					triangle { <-17.1223, 33.3977, 14.9362>, <-17.2684, 32.5193, 15.5317>, <-16.8577, 33.2454, 14.8247> }
					triangle { <-17.617, 32.6131, 15.3373>, <-17.2684, 32.5193, 15.5317>, <-17.1223, 33.3977, 14.9362> }
					triangle { <-17.8611, 32.6645, 15.1328>, <-17.617, 32.6131, 15.3373>, <-17.2869, 33.3316, 14.7795> }
					triangle { <-17.617, 32.6131, 15.3373>, <-17.6118, 32.1907, 15.8982>, <-17.2684, 32.5193, 15.5317> }
					triangle { <-17.9989, 32.2576, 15.7352>, <-18.4593, 31.284, 16.01663>, <-17.6118, 32.1907, 15.8982> }
					triangle { <-17.9989, 32.2576, 15.7352>, <-17.6118, 32.1907, 15.8982>, <-17.617, 32.6131, 15.3373> }
					triangle { <-17.9989, 32.2576, 15.7352>, <-17.617, 32.6131, 15.3373>, <-17.8611, 32.6645, 15.1328> }
					triangle { <-18.2553, 32.4424, 15.4772>, <-17.9989, 32.2576, 15.7352>, <-17.8611, 32.6645, 15.1328> }
					triangle { <-18.9602, 31.1783, 15.719>, <-18.4593, 31.284, 16.01663>, <-17.9989, 32.2576, 15.7352> }
					triangle { <-18.9602, 31.1783, 15.719>, <-17.9989, 32.2576, 15.7352>, <-18.2553, 32.4424, 15.4772> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <-16.4747, 33.2867, 13.8534>, <-16.8946, 33.1924, 14.2923>, <-16.7597, 33.3637, 14.4436> }
					triangle { <-16.8946, 33.1924, 14.2923>, <-17.2215, 33.1536, 14.6277>, <-16.7597, 33.3637, 14.4436> }
					triangle { <-16.7597, 33.3637, 14.4436>, <-17.1565, 33.2481, 14.9072>, <-17.02058, 33.4418, 14.9476> }
					triangle { <-17.1565, 33.2481, 14.9072>, <-17.02226, 32.8471, 15.6645>, <-17.02058, 33.4418, 14.9476> }
					triangle { <-16.7597, 33.3637, 14.4436>, <-17.2215, 33.1536, 14.6277>, <-17.1565, 33.2481, 14.9072> }
					triangle { <-17.2215, 33.1536, 14.6277>, <-17.1573, 32.611, 15.5867>, <-17.1565, 33.2481, 14.9072> }
					triangle { <-17.1565, 33.2481, 14.9072>, <-17.1573, 32.611, 15.5867>, <-17.02226, 32.8471, 15.6645> }
					triangle { <-17.02058, 33.4418, 14.9476>, <-17.02226, 32.8471, 15.6645>, <-16.7957, 33.1051, 15.8054> }
					triangle { <-17.1573, 32.611, 15.5867>, <-17.2544, 32.466, 16.1338>, <-17.02226, 32.8471, 15.6645> }
					triangle { <-17.2544, 32.466, 16.1338>, <-16.661, 32.1543, 17.05785>, <-17.09767, 32.7768, 16.2558> }
					triangle { <-17.02226, 32.8471, 15.6645>, <-17.2544, 32.466, 16.1338>, <-17.09767, 32.7768, 16.2558> }
					triangle { <-16.7957, 33.1051, 15.8054>, <-17.02226, 32.8471, 15.6645>, <-17.09767, 32.7768, 16.2558> }
					triangle { <-16.7957, 33.1051, 15.8054>, <-17.09767, 32.7768, 16.2558>, <-16.8476, 33.02466, 16.3659> }
					triangle { <-17.09767, 32.7768, 16.2558>, <-16.661, 32.1543, 17.05785>, <-16.1826, 32.3271, 17.4724> }
					triangle { <-16.8476, 33.02466, 16.3659>, <-17.09767, 32.7768, 16.2558>, <-16.1826, 32.3271, 17.4724> }
					triangle { <-16.7597, 33.3637, 14.4436>, <-16.6928, 33.6214, 14.4097>, <-16.4747, 33.2867, 13.8534> }
					triangle { <-16.7597, 33.3637, 14.4436>, <-16.7212, 33.7141, 14.7745>, <-16.6928, 33.6214, 14.4097> }
					triangle { <-17.02058, 33.4418, 14.9476>, <-17.00001, 33.6774, 14.9376>, <-16.7597, 33.3637, 14.4436> }
					triangle { <-17.02058, 33.4418, 14.9476>, <-16.6375, 33.3847, 15.8344>, <-17.00001, 33.6774, 14.9376> }
					triangle { <-17.00001, 33.6774, 14.9376>, <-16.7212, 33.7141, 14.7745>, <-16.7597, 33.3637, 14.4436> }
					triangle { <-17.00001, 33.6774, 14.9376>, <-16.3868, 33.7085, 15.8156>, <-16.7212, 33.7141, 14.7745> }
					triangle { <-16.6375, 33.3847, 15.8344>, <-16.3868, 33.7085, 15.8156>, <-17.00001, 33.6774, 14.9376> }
					triangle { <-16.7957, 33.1051, 15.8054>, <-16.6375, 33.3847, 15.8344>, <-17.02058, 33.4418, 14.9476> }
					triangle { <-16.6375, 33.3847, 15.8344>, <-16.3236, 33.6397, 16.4084>, <-16.3868, 33.7085, 15.8156> }
					triangle { <-16.5748, 33.3047, 16.4827>, <-16.02587, 32.886, 17.3558>, <-16.3236, 33.6397, 16.4084> }
					triangle { <-16.5748, 33.3047, 16.4827>, <-16.3236, 33.6397, 16.4084>, <-16.6375, 33.3847, 15.8344> }
					triangle { <-16.5748, 33.3047, 16.4827>, <-16.6375, 33.3847, 15.8344>, <-16.7957, 33.1051, 15.8054> }
					triangle { <-16.8476, 33.02466, 16.3659>, <-16.5748, 33.3047, 16.4827>, <-16.7957, 33.1051, 15.8054> }
					triangle { <-16.1826, 32.3271, 17.4724>, <-16.02587, 32.886, 17.3558>, <-16.5748, 33.3047, 16.4827> }
					triangle { <-16.1826, 32.3271, 17.4724>, <-16.5748, 33.3047, 16.4827>, <-16.8476, 33.02466, 16.3659> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.5636, 14.7432, 0.09758>, <-2.7459, 15.5572, 0.07976>, 0.3888 }
			cylinder { <-2.7459, 15.5572, 0.07976>, <-2.9282, 16.3711, 0.06194>, 0.3888 }
			cylinder { <-2.9282, 16.3711, 0.06194>, <-3.1105, 17.185, 0.04413>, 0.3888 }
			cylinder { <-3.1105, 17.185, 0.04413>, <-3.2928, 17.999, 0.02631>, 0.3888 }
			cylinder { <-3.2928, 17.999, 0.02631>, <-3.4751, 18.8129, 0.008494>, 0.3888 }
			cylinder { <-3.4751, 18.8129, 0.008494>, <-3.6574, 19.6268, -0.009323>, 0.3888 }
			cylinder { <-3.6574, 19.6268, -0.009323>, <-3.8397, 20.4407, -0.02714>, 0.3888 }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.8397, 20.4407, -0.02714>, <-4.0573, 24.515, -0.2819>, 0.3888 }
				cylinder { <-4.0573, 24.515, -0.2819>, <-3.5926, 28.5553, -0.6966>, 0.3888 }
				cylinder { <-3.5926, 28.5553, -0.6966>, <-2.4595, 32.4426, -1.2591>, 0.3888 }
				cylinder { <-2.4595, 32.4426, -1.2591>, <-0.6913, 36.06261, -1.9528>, 0.3888 }
				cylinder { <-0.6913, 36.06261, -1.9528>, <1.6598, 39.3085, -2.7573>, 0.3888 }
				cylinder { <1.6598, 39.3085, -2.7573>, <4.5249, 42.08496, -3.6489>, 0.3888 }
				cylinder { <4.5249, 42.08496, -3.6489>, <7.8194, 44.31, -4.6013>, 0.3888 }
				pigment { color rgb <0.19, 0.39, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <7.8194, 44.31, -4.6013>, <8.3266, 44.4527, -4.9178>, <8.263, 44.7081, -4.8843> }
					triangle { <8.3266, 44.4527, -4.9178>, <8.7245, 44.5799, -5.1332>, <8.263, 44.7081, -4.8843> }
					triangle { <8.263, 44.7081, -4.8843>, <8.7522, 44.8632, -5.2342>, <8.6602, 45.05033, -5.1152> }
					triangle { <8.7522, 44.8632, -5.2342>, <8.7773, 45.2235, -6.02291>, <8.6602, 45.05033, -5.1152> }
					triangle { <8.263, 44.7081, -4.8843>, <8.7245, 44.5799, -5.1332>, <8.7522, 44.8632, -5.2342> }
					triangle { <8.7245, 44.5799, -5.1332>, <8.8523, 44.9835, -6.1525>, <8.7522, 44.8632, -5.2342> }
					triangle { <8.7522, 44.8632, -5.2342>, <8.8523, 44.9835, -6.1525>, <8.7773, 45.2235, -6.02291> }
					triangle { <8.6602, 45.05033, -5.1152>, <8.7773, 45.2235, -6.02291>, <8.6355, 45.5508, -5.9205> }
					triangle { <8.8523, 44.9835, -6.1525>, <9.07509, 45.2725, -6.5959>, <8.7773, 45.2235, -6.02291> }
					triangle { <9.07509, 45.2725, -6.5959>, <8.721, 45.9475, -7.4457>, <9.00169, 45.5967, -6.4359> }
					triangle { <8.7773, 45.2235, -6.02291>, <9.07509, 45.2725, -6.5959>, <9.00169, 45.5967, -6.4359> }
					triangle { <8.6355, 45.5508, -5.9205>, <8.7773, 45.2235, -6.02291>, <9.00169, 45.5967, -6.4359> }
					triangle { <8.6355, 45.5508, -5.9205>, <9.00169, 45.5967, -6.4359>, <8.8276, 45.9021, -6.3242> }
					triangle { <9.00169, 45.5967, -6.4359>, <8.721, 45.9475, -7.4457>, <8.4029, 46.5018, -7.5943> }
					triangle { <8.8276, 45.9021, -6.3242>, <9.00169, 45.5967, -6.4359>, <8.4029, 46.5018, -7.5943> }
					triangle { <8.263, 44.7081, -4.8843>, <8.2253, 44.8579, -4.6648>, <7.8194, 44.31, -4.6013> }
					triangle { <8.263, 44.7081, -4.8843>, <8.365, 45.1754, -4.8137>, <8.2253, 44.8579, -4.6648> }
					triangle { <8.6602, 45.05033, -5.1152>, <8.6701, 45.1907, -4.9249>, <8.263, 44.7081, -4.8843> }
					triangle { <8.6602, 45.05033, -5.1152>, <8.531, 45.7878, -5.7283>, <8.6701, 45.1907, -4.9249> }
					triangle { <8.6701, 45.1907, -4.9249>, <8.365, 45.1754, -4.8137>, <8.263, 44.7081, -4.8843> }
					triangle { <8.6701, 45.1907, -4.9249>, <8.3314, 46.04364, -5.4777>, <8.365, 45.1754, -4.8137> }
					triangle { <8.531, 45.7878, -5.7283>, <8.3314, 46.04364, -5.4777>, <8.6701, 45.1907, -4.9249> }
					triangle { <8.6355, 45.5508, -5.9205>, <8.531, 45.7878, -5.7283>, <8.6602, 45.05033, -5.1152> }
					triangle { <8.531, 45.7878, -5.7283>, <8.4245, 46.4604, -5.8994>, <8.3314, 46.04364, -5.4777> }
					triangle { <8.6383, 46.2388, -6.1927>, <8.298, 46.7984, -7.09277>, <8.4245, 46.4604, -5.8994> }
					triangle { <8.6383, 46.2388, -6.1927>, <8.4245, 46.4604, -5.8994>, <8.531, 45.7878, -5.7283> }
					triangle { <8.6383, 46.2388, -6.1927>, <8.531, 45.7878, -5.7283>, <8.6355, 45.5508, -5.9205> }
					triangle { <8.8276, 45.9021, -6.3242>, <8.6383, 46.2388, -6.1927>, <8.6355, 45.5508, -5.9205> }
					triangle { <8.4029, 46.5018, -7.5943>, <8.298, 46.7984, -7.09277>, <8.6383, 46.2388, -6.1927> }
					triangle { <8.4029, 46.5018, -7.5943>, <8.6383, 46.2388, -6.1927>, <8.8276, 45.9021, -6.3242> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <7.8194, 44.31, -4.6013>, <8.1563, 44.694, -4.9431>, <8.2544, 44.7925, -4.717> }
					triangle { <8.1563, 44.694, -4.9431>, <8.4413, 44.9751, -5.1893>, <8.2544, 44.7925, -4.717> }
					triangle { <8.2544, 44.7925, -4.717>, <8.5711, 45.2099, -5.05054>, <8.6452, 45.1978, -4.8225> }
					triangle { <8.5711, 45.2099, -5.05054>, <8.4724, 46.07038, -5.09918>, <8.6452, 45.1978, -4.8225> }
					triangle { <8.2544, 44.7925, -4.717>, <8.4413, 44.9751, -5.1893>, <8.5711, 45.2099, -5.05054> }
					triangle { <8.4413, 44.9751, -5.1893>, <8.3537, 46.06272, -5.3558>, <8.5711, 45.2099, -5.05054> }
					triangle { <8.5711, 45.2099, -5.05054>, <8.3537, 46.06272, -5.3558>, <8.4724, 46.07038, -5.09918> }
					triangle { <8.6452, 45.1978, -4.8225>, <8.4724, 46.07038, -5.09918>, <8.5753, 46.141, -4.7497> }
					triangle { <8.3537, 46.06272, -5.3558>, <8.5018, 46.6078, -5.4593>, <8.4724, 46.07038, -5.09918> }
					triangle { <8.5018, 46.6078, -5.4593>, <8.2558, 47.6527, -5.07118>, <8.6774, 46.6332, -5.1359> }
					triangle { <8.4724, 46.07038, -5.09918>, <8.5018, 46.6078, -5.4593>, <8.6774, 46.6332, -5.1359> }
					triangle { <8.5753, 46.141, -4.7497>, <8.4724, 46.07038, -5.09918>, <8.6774, 46.6332, -5.1359> }
					triangle { <8.5753, 46.141, -4.7497>, <8.6774, 46.6332, -5.1359>, <8.7481, 46.6821, -4.7771> }
					triangle { <8.6774, 46.6332, -5.1359>, <8.2558, 47.6527, -5.07118>, <8.2461, 48.04067, -4.5419> }
					triangle { <8.7481, 46.6821, -4.7771>, <8.6774, 46.6332, -5.1359>, <8.2461, 48.04067, -4.5419> }
					triangle { <8.2544, 44.7925, -4.717>, <8.3892, 44.6798, -4.514>, <7.8194, 44.31, -4.6013> }
					triangle { <8.2544, 44.7925, -4.717>, <8.6033, 44.982, -4.4412>, <8.3892, 44.6798, -4.514> }
					triangle { <8.6452, 45.1978, -4.8225>, <8.7998, 45.109, -4.6668>, <8.2544, 44.7925, -4.717> }
					triangle { <8.6452, 45.1978, -4.8225>, <8.6944, 46.09138, -4.4541>, <8.7998, 45.109, -4.6668> }
					triangle { <8.7998, 45.109, -4.6668>, <8.6033, 44.982, -4.4412>, <8.2544, 44.7925, -4.717> }
					triangle { <8.7998, 45.109, -4.6668>, <8.7736, 45.9941, -4.06376>, <8.6033, 44.982, -4.4412> }
					triangle { <8.6944, 46.09138, -4.4541>, <8.7736, 45.9941, -4.06376>, <8.7998, 45.109, -4.6668> }
					triangle { <8.5753, 46.141, -4.7497>, <8.6944, 46.09138, -4.4541>, <8.6452, 45.1978, -4.8225> }
					triangle { <8.6944, 46.09138, -4.4541>, <8.8983, 46.5764, -3.9891>, <8.7736, 45.9941, -4.06376> }
					triangle { <8.8311, 46.7289, -4.3804>, <8.5158, 47.7581, -4.09703>, <8.8983, 46.5764, -3.9891> }
					triangle { <8.8311, 46.7289, -4.3804>, <8.8983, 46.5764, -3.9891>, <8.6944, 46.09138, -4.4541> }
					triangle { <8.8311, 46.7289, -4.3804>, <8.6944, 46.09138, -4.4541>, <8.5753, 46.141, -4.7497> }
					triangle { <8.7481, 46.6821, -4.7771>, <8.8311, 46.7289, -4.3804>, <8.5753, 46.141, -4.7497> }
					triangle { <8.2461, 48.04067, -4.5419>, <8.5158, 47.7581, -4.09703>, <8.8311, 46.7289, -4.3804> }
					triangle { <8.2461, 48.04067, -4.5419>, <8.8311, 46.7289, -4.3804>, <8.7481, 46.6821, -4.7771> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <7.8194, 44.31, -4.6013>, <8.1431, 44.8267, -4.6783>, <8.3568, 44.6928, -4.5956> }
					triangle { <8.1431, 44.8267, -4.6783>, <8.4109, 45.2047, -4.7581>, <8.3568, 44.6928, -4.5956> }
					triangle { <8.3568, 44.6928, -4.5956>, <8.686, 45.2182, -4.6339>, <8.8244, 45.02353, -4.61> }
					triangle { <8.686, 45.2182, -4.6339>, <9.04154, 45.6966, -4.00383>, <8.8244, 45.02353, -4.61> }
					triangle { <8.3568, 44.6928, -4.5956>, <8.4109, 45.2047, -4.7581>, <8.686, 45.2182, -4.6339> }
					triangle { <8.4109, 45.2047, -4.7581>, <8.8478, 45.9019, -4.02248>, <8.686, 45.2182, -4.6339> }
					triangle { <8.686, 45.2182, -4.6339>, <8.8478, 45.9019, -4.02248>, <9.04154, 45.6966, -4.00383> }
					triangle { <8.8244, 45.02353, -4.61>, <9.04154, 45.6966, -4.00383>, <9.2921, 45.4435, -3.8997> }
					triangle { <8.8478, 45.9019, -4.02248>, <9.2048, 46.2837, -3.7846>, <9.04154, 45.6966, -4.00383> }
					triangle { <9.2048, 46.2837, -3.7846>, <9.7143, 46.4735, -2.7809>, <9.4769, 46.03528, -3.7673> }
					triangle { <9.04154, 45.6966, -4.00383>, <9.2048, 46.2837, -3.7846>, <9.4769, 46.03528, -3.7673> }
					triangle { <9.2921, 45.4435, -3.8997>, <9.04154, 45.6966, -4.00383>, <9.4769, 46.03528, -3.7673> }
					triangle { <9.2921, 45.4435, -3.8997>, <9.4769, 46.03528, -3.7673>, <9.6953, 45.7604, -3.6539> }
					triangle { <9.4769, 46.03528, -3.7673>, <9.7143, 46.4735, -2.7809>, <10.1148, 46.2223, -2.3259> }
					triangle { <9.6953, 45.7604, -3.6539>, <9.4769, 46.03528, -3.7673>, <10.1148, 46.2223, -2.3259> }
					triangle { <8.3568, 44.6928, -4.5956>, <8.4791, 44.4724, -4.6877>, <7.8194, 44.31, -4.6013> }
					triangle { <8.3568, 44.6928, -4.5956>, <8.8278, 44.5836, -4.5955>, <8.4791, 44.4724, -4.6877> }
					triangle { <8.8244, 45.02353, -4.61>, <8.9558, 44.8573, -4.7154>, <8.3568, 44.6928, -4.5956> }
					triangle { <8.8244, 45.02353, -4.61>, <9.4713, 45.1754, -3.9065>, <8.9558, 44.8573, -4.7154> }
					triangle { <8.9558, 44.8573, -4.7154>, <8.8278, 44.5836, -4.5955>, <8.3568, 44.6928, -4.5956> }
					triangle { <8.9558, 44.8573, -4.7154>, <9.6321, 44.7988, -3.8866>, <8.8278, 44.5836, -4.5955> }
					triangle { <9.4713, 45.1754, -3.9065>, <9.6321, 44.7988, -3.8866>, <8.9558, 44.8573, -4.7154> }
					triangle { <9.2921, 45.4435, -3.8997>, <9.4713, 45.1754, -3.9065>, <8.8244, 45.02353, -4.61> }
					triangle { <9.4713, 45.1754, -3.9065>, <10.05995, 45.04623, -3.5461>, <9.6321, 44.7988, -3.8866> }
					triangle { <9.9367, 45.4532, -3.5366>, <10.3448, 45.7185, -2.5355>, <10.05995, 45.04623, -3.5461> }
					triangle { <9.9367, 45.4532, -3.5366>, <10.05995, 45.04623, -3.5461>, <9.4713, 45.1754, -3.9065> }
					triangle { <9.9367, 45.4532, -3.5366>, <9.4713, 45.1754, -3.9065>, <9.2921, 45.4435, -3.8997> }
					triangle { <9.6953, 45.7604, -3.6539>, <9.9367, 45.4532, -3.5366>, <9.2921, 45.4435, -3.8997> }
					triangle { <10.1148, 46.2223, -2.3259>, <10.3448, 45.7185, -2.5355>, <9.9367, 45.4532, -3.5366> }
					triangle { <10.1148, 46.2223, -2.3259>, <9.9367, 45.4532, -3.5366>, <9.6953, 45.7604, -3.6539> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <7.8194, 44.31, -4.6013>, <8.3052, 44.6687, -4.4869>, <8.4297, 44.546, -4.6867> }
					triangle { <8.3052, 44.6687, -4.4869>, <8.675, 44.9535, -4.4315>, <8.4297, 44.546, -4.6867> }
					triangle { <8.4297, 44.546, -4.6867>, <8.9391, 44.8766, -4.5564>, <8.9518, 44.7665, -4.7694> }
					triangle { <8.9391, 44.8766, -4.5564>, <9.7034, 44.6152, -4.2403>, <8.9518, 44.7665, -4.7694> }
					triangle { <8.4297, 44.546, -4.6867>, <8.675, 44.9535, -4.4315>, <8.9391, 44.8766, -4.5564> }
					triangle { <8.675, 44.9535, -4.4315>, <9.6563, 44.7218, -3.9825>, <8.9391, 44.8766, -4.5564> }
					triangle { <8.9391, 44.8766, -4.5564>, <9.6563, 44.7218, -3.9825>, <9.7034, 44.6152, -4.2403> }
					triangle { <8.9518, 44.7665, -4.7694>, <9.7034, 44.6152, -4.2403>, <9.802, 44.4157, -4.5373> }
					triangle { <9.6563, 44.7218, -3.9825>, <10.2191, 44.745, -3.8707>, <9.7034, 44.6152, -4.2403> }
					triangle { <10.2191, 44.745, -3.8707>, <11.0946, 44.02849, -3.7186>, <10.3027, 44.6236, -4.2088> }
					triangle { <9.7034, 44.6152, -4.2403>, <10.2191, 44.745, -3.8707>, <10.3027, 44.6236, -4.2088> }
					triangle { <9.802, 44.4157, -4.5373>, <9.7034, 44.6152, -4.2403>, <10.3027, 44.6236, -4.2088> }
					triangle { <9.802, 44.4157, -4.5373>, <10.3027, 44.6236, -4.2088>, <10.369, 44.4023, -4.4964> }
					triangle { <10.3027, 44.6236, -4.2088>, <11.0946, 44.02849, -3.7186>, <11.4441, 43.5427, -3.988> }
					triangle { <10.369, 44.4023, -4.4964>, <10.3027, 44.6236, -4.2088>, <11.4441, 43.5427, -3.988> }
					triangle { <8.4297, 44.546, -4.6867>, <8.3716, 44.5203, -4.9474>, <7.8194, 44.31, -4.6013> }
					triangle { <8.4297, 44.546, -4.6867>, <8.7303, 44.5271, -5.06481>, <8.3716, 44.5203, -4.9474> }
					triangle { <8.9518, 44.7665, -4.7694>, <8.9239, 44.781, -5.004009>, <8.4297, 44.546, -4.6867> }
					triangle { <8.9518, 44.7665, -4.7694>, <9.7954, 44.2972, -4.8372>, <8.9239, 44.781, -5.004009> }
					triangle { <8.9239, 44.781, -5.004009>, <8.7303, 44.5271, -5.06481>, <8.4297, 44.546, -4.6867> }
					triangle { <8.9239, 44.781, -5.004009>, <9.7285, 44.09837, -5.1894>, <8.7303, 44.5271, -5.06481> }
					triangle { <9.7954, 44.2972, -4.8372>, <9.7285, 44.09837, -5.1894>, <8.9239, 44.781, -5.004009> }
					triangle { <9.802, 44.4157, -4.5373>, <9.7954, 44.2972, -4.8372>, <8.9518, 44.7665, -4.7694> }
					triangle { <9.7954, 44.2972, -4.8372>, <10.3148, 43.9702, -5.1783>, <9.7285, 44.09837, -5.1894> }
					triangle { <10.4374, 44.1627, -4.8195>, <11.2743, 43.4793, -4.5516>, <10.3148, 43.9702, -5.1783> }
					triangle { <10.4374, 44.1627, -4.8195>, <10.3148, 43.9702, -5.1783>, <9.7954, 44.2972, -4.8372> }
					triangle { <10.4374, 44.1627, -4.8195>, <9.7954, 44.2972, -4.8372>, <9.802, 44.4157, -4.5373> }
					triangle { <10.369, 44.4023, -4.4964>, <10.4374, 44.1627, -4.8195>, <9.802, 44.4157, -4.5373> }
					triangle { <11.4441, 43.5427, -3.988>, <11.2743, 43.4793, -4.5516>, <10.4374, 44.1627, -4.8195> }
					triangle { <11.4441, 43.5427, -3.988>, <10.4374, 44.1627, -4.8195>, <10.369, 44.4023, -4.4964> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				mesh { // flower petal
					triangle { <7.8194, 44.31, -4.6013>, <8.4203, 44.434, -4.6371>, <8.3708, 44.5556, -4.8678> }
					triangle { <8.4203, 44.434, -4.6371>, <8.8717, 44.5615, -4.6668>, <8.3708, 44.5556, -4.8678> }
					triangle { <8.3708, 44.5556, -4.8678>, <8.9806, 44.6539, -4.933>, <8.8489, 44.7834, -5.08634> }
					triangle { <8.9806, 44.6539, -4.933>, <9.5377, 44.3185, -5.507>, <8.8489, 44.7834, -5.08634> }
					triangle { <8.3708, 44.5556, -4.8678>, <8.8717, 44.5615, -4.6668>, <8.9806, 44.6539, -4.933> }
					triangle { <8.8717, 44.5615, -4.6668>, <9.6592, 44.1456, -5.3188>, <8.9806, 44.6539, -4.933> }
					triangle { <8.9806, 44.6539, -4.933>, <9.6592, 44.1456, -5.3188>, <9.5377, 44.3185, -5.507> }
					triangle { <8.8489, 44.7834, -5.08634>, <9.5377, 44.3185, -5.507>, <9.3901, 44.483, -5.805> }
					triangle { <9.6592, 44.1456, -5.3188>, <10.1377, 44.1106, -5.6344>, <9.5377, 44.3185, -5.507> }
					triangle { <10.1377, 44.1106, -5.6344>, <10.4714, 43.6984, -6.6452>, <10.0046, 44.3484, -5.883> }
					triangle { <9.5377, 44.3185, -5.507>, <10.1377, 44.1106, -5.6344>, <10.0046, 44.3484, -5.883> }
					triangle { <9.3901, 44.483, -5.805>, <9.5377, 44.3185, -5.507>, <10.0046, 44.3484, -5.883> }
					triangle { <9.3901, 44.483, -5.805>, <10.0046, 44.3484, -5.883>, <9.8247, 44.4912, -6.1716> }
					triangle { <10.0046, 44.3484, -5.883>, <10.4714, 43.6984, -6.6452>, <10.3701, 43.7181, -7.2932> }
					triangle { <9.8247, 44.4912, -6.1716>, <10.0046, 44.3484, -5.883>, <10.3701, 43.7181, -7.2932> }
					triangle { <8.3708, 44.5556, -4.8678>, <8.2124, 44.7622, -4.9331>, <7.8194, 44.31, -4.6013> }
					triangle { <8.3708, 44.5556, -4.8678>, <8.44, 44.8983, -5.2017>, <8.2124, 44.7622, -4.9331> }
					triangle { <8.8489, 44.7834, -5.08634>, <8.7447, 44.9902, -5.1353>, <8.3708, 44.5556, -4.8678> }
					triangle { <8.8489, 44.7834, -5.08634>, <9.2055, 44.6814, -5.9801>, <8.7447, 44.9902, -5.1353> }
					triangle { <8.7447, 44.9902, -5.1353>, <8.44, 44.8983, -5.2017>, <8.3708, 44.5556, -4.8678> }
					triangle { <8.7447, 44.9902, -5.1353>, <8.9125, 44.8793, -6.1876>, <8.44, 44.8983, -5.2017> }
					triangle { <9.2055, 44.6814, -5.9801>, <8.9125, 44.8793, -6.1876>, <8.7447, 44.9902, -5.1353> }
					triangle { <9.3901, 44.483, -5.805>, <9.2055, 44.6814, -5.9801>, <8.8489, 44.7834, -5.08634> }
					triangle { <9.2055, 44.6814, -5.9801>, <9.2887, 44.8574, -6.6547>, <8.9125, 44.8793, -6.1876> }
					triangle { <9.6228, 44.6555, -6.4858>, <9.9902, 44.1568, -7.4107>, <9.2887, 44.8574, -6.6547> }
					triangle { <9.6228, 44.6555, -6.4858>, <9.2887, 44.8574, -6.6547>, <9.2055, 44.6814, -5.9801> }
					triangle { <9.6228, 44.6555, -6.4858>, <9.2055, 44.6814, -5.9801>, <9.3901, 44.483, -5.805> }
					triangle { <9.8247, 44.4912, -6.1716>, <9.6228, 44.6555, -6.4858>, <9.3901, 44.483, -5.805> }
					triangle { <10.3701, 43.7181, -7.2932>, <9.9902, 44.1568, -7.4107>, <9.6228, 44.6555, -6.4858> }
					triangle { <10.3701, 43.7181, -7.2932>, <9.6228, 44.6555, -6.4858>, <9.8247, 44.4912, -6.1716> }
					pigment { color rgb <0.647,0.388,0.776> } finish {ambient 0.2 phong 0.5}}
				}
			}
		}
	union { // internode
		cylinder { <-0.0115, 3.3482, 0.347>, <-0.03226, 3.4425, 0.3473>, 0.4 }
		cylinder { <-0.03226, 3.4425, 0.3473>, <-0.05268, 3.5368, 0.3499>, 0.4 }
		cylinder { <-0.05268, 3.5368, 0.3499>, <-0.07275, 3.6311, 0.3549>, 0.4 }
		cylinder { <-0.07275, 3.6311, 0.3549>, <-0.09244, 3.7253, 0.3622>, 0.4 }
		cylinder { <-0.09244, 3.7253, 0.3622>, <-0.1117, 3.8194, 0.3718>, 0.4 }
		cylinder { <-0.1117, 3.8194, 0.3718>, <-0.1306, 3.9134, 0.3838>, 0.4 }
		cylinder { <-0.1306, 3.9134, 0.3838>, <-0.1492, 4.00707, 0.3981>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1492, 4.00707, 0.3981>, <-1.003722, 7.6984, 0.1327>, 0.4658 }
			cylinder { <-1.003722, 7.6984, 0.1327>, <-1.9425, 11.2167, -0.9474>, 0.4658 }
			cylinder { <-1.9425, 11.2167, -0.9474>, <-2.9199, 14.391, -2.7901>, 0.4658 }
			cylinder { <-2.9199, 14.391, -2.7901>, <-3.8885, 17.06701, -5.3056>, 0.4658 }
			cylinder { <-3.8885, 17.06701, -5.3056>, <-4.8012, 19.1146, -8.3716>, 0.4658 }
			cylinder { <-4.8012, 19.1146, -8.3716>, <-5.6137, 20.4345, -11.8393>, 0.4658 }
			cylinder { <-5.6137, 20.4345, -11.8393>, <-6.2864, 20.9623, -15.5401>, 0.4658 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <-6.2864, 20.9623, -15.5401>, <-8.2489, 19.3327, -12.4536>, <-10.7959, 21.1215, -15.4086> }
			triangle { <-6.2864, 20.9623, -15.5401>, <-10.7959, 21.1215, -15.4086>, <-10.8179, 21.8757, -18.4962> }
			triangle { <-8.2489, 19.3327, -12.4536>, <-10.2631, 18.8734, -11.442>, <-10.7959, 21.1215, -15.4086> }
			triangle { <-10.2631, 18.8734, -11.442>, <-11.9969, 19.04569, -13.2351>, <-10.7959, 21.1215, -15.4086> }
			triangle { <-11.9969, 19.04569, -13.2351>, <-13.08065, 19.4666, -16.6512>, <-10.7959, 21.1215, -15.4086> }
			triangle { <-13.08065, 19.4666, -16.6512>, <-13.6429, 20.01518, -20.3809>, <-10.8179, 21.8757, -18.4962> }
			triangle { <-10.7959, 21.1215, -15.4086>, <-13.08065, 19.4666, -16.6512>, <-10.8179, 21.8757, -18.4962> }
			triangle { <-10.8179, 21.8757, -18.4962>, <-11.5389, 21.6265, -21.8369>, <-9.01515, 22.2081, -21.7387> }
			triangle { <-11.5389, 21.6265, -21.8369>, <-12.1484, 20.6822, -24.4675>, <-10.2166, 21.7991, -24.5409> }
			triangle { <-11.5389, 21.6265, -21.8369>, <-10.2166, 21.7991, -24.5409>, <-9.01515, 22.2081, -21.7387> }
			triangle { <-9.01515, 22.2081, -21.7387>, <-10.2166, 21.7991, -24.5409>, <-7.8123, 21.8595, -24.2584> }
			triangle { <-12.1484, 20.6822, -24.4675>, <-10.01191, 20.1671, -28.01011>, <-10.2166, 21.7991, -24.5409> }
			triangle { <-10.2166, 21.7991, -24.5409>, <-10.01191, 20.1671, -28.01011>, <-7.8123, 21.8595, -24.2584> }
			triangle { <-6.2864, 20.9623, -15.5401>, <-10.8179, 21.8757, -18.4962>, <-6.973, 21.7012, -19.1015> }
			triangle { <-6.973, 21.7012, -19.1015>, <-10.8179, 21.8757, -18.4962>, <-9.01515, 22.2081, -21.7387> }
			triangle { <-6.973, 21.7012, -19.1015>, <-9.01515, 22.2081, -21.7387>, <-7.4841, 22.1023, -21.9136> }
			triangle { <-9.01515, 22.2081, -21.7387>, <-7.8123, 21.8595, -24.2584>, <-7.4841, 22.1023, -21.9136> }
			triangle { <-13.6429, 20.01518, -20.3809>, <-11.5389, 21.6265, -21.8369>, <-10.8179, 21.8757, -18.4962> }
			triangle { <-13.6429, 20.01518, -20.3809>, <-12.1484, 20.6822, -24.4675>, <-11.5389, 21.6265, -21.8369> }
			triangle { <-2.2483, 22.5737, -16.7552>, <-3.07541, 20.2116, -13.2686>, <-6.2864, 20.9623, -15.5401> }
			triangle { <-3.395, 23.1368, -19.6656>, <-2.2483, 22.5737, -16.7552>, <-6.2864, 20.9623, -15.5401> }
			triangle { <-2.2483, 22.5737, -16.7552>, <-0.8158, 20.4784, -12.9303>, <-3.07541, 20.2116, -13.2686> }
			triangle { <-2.2483, 22.5737, -16.7552>, <0.1495, 21.1092, -15.1487>, <-0.8158, 20.4784, -12.9303> }
			triangle { <-2.2483, 22.5737, -16.7552>, <-0.03438, 21.683, -18.7065>, <0.1495, 21.1092, -15.1487> }
			triangle { <-3.395, 23.1368, -19.6656>, <-0.8215, 22.1934, -22.4008>, <-0.03438, 21.683, -18.7065> }
			triangle { <-3.395, 23.1368, -19.6656>, <-0.03438, 21.683, -18.7065>, <-2.2483, 22.5737, -16.7552> }
			triangle { <-6.09098, 22.7049, -22.1994>, <-3.7792, 23.753, -22.9441>, <-3.395, 23.1368, -19.6656> }
			triangle { <-5.7017, 22.4507, -25.2686>, <-3.6008, 22.1343, -25.8141>, <-3.7792, 23.753, -22.9441> }
			triangle { <-6.09098, 22.7049, -22.1994>, <-5.7017, 22.4507, -25.2686>, <-3.7792, 23.753, -22.9441> }
			triangle { <-7.8123, 21.8595, -24.2584>, <-5.7017, 22.4507, -25.2686>, <-6.09098, 22.7049, -22.1994> }
			triangle { <-5.7017, 22.4507, -25.2686>, <-6.429, 20.8912, -28.558>, <-3.6008, 22.1343, -25.8141> }
			triangle { <-7.8123, 21.8595, -24.2584>, <-6.429, 20.8912, -28.558>, <-5.7017, 22.4507, -25.2686> }
			triangle { <-6.973, 21.7012, -19.1015>, <-3.395, 23.1368, -19.6656>, <-6.2864, 20.9623, -15.5401> }
			triangle { <-6.09098, 22.7049, -22.1994>, <-3.395, 23.1368, -19.6656>, <-6.973, 21.7012, -19.1015> }
			triangle { <-7.4841, 22.1023, -21.9136>, <-6.09098, 22.7049, -22.1994>, <-6.973, 21.7012, -19.1015> }
			triangle { <-7.4841, 22.1023, -21.9136>, <-7.8123, 21.8595, -24.2584>, <-6.09098, 22.7049, -22.1994> }
			triangle { <-3.395, 23.1368, -19.6656>, <-3.7792, 23.753, -22.9441>, <-0.8215, 22.1934, -22.4008> }
			triangle { <-3.7792, 23.753, -22.9441>, <-3.6008, 22.1343, -25.8141>, <-0.8215, 22.1934, -22.4008> }
			triangle { <-7.8123, 21.8595, -24.2584>, <-10.01191, 20.1671, -28.01011>, <-8.249, 20.6015, -28.387> }
			triangle { <-10.01191, 20.1671, -28.01011>, <-8.2649, 18.8133, -30.4165>, <-8.249, 20.6015, -28.387> }
			triangle { <-7.8123, 21.8595, -24.2584>, <-8.249, 20.6015, -28.387>, <-6.429, 20.8912, -28.558> }
			triangle { <-8.249, 20.6015, -28.387>, <-8.2649, 18.8133, -30.4165>, <-6.429, 20.8912, -28.558> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // internode
		cylinder { <-0.1492, 4.00707, 0.3981>, <-0.1664, 4.1012, 0.4104>, 0.4 }
		cylinder { <-0.1664, 4.1012, 0.4104>, <-0.1825, 4.1958, 0.4208>, 0.4 }
		cylinder { <-0.1825, 4.1958, 0.4208>, <-0.1972, 4.2909, 0.4292>, 0.4 }
		cylinder { <-0.1972, 4.2909, 0.4292>, <-0.2108, 4.3863, 0.4357>, 0.4 }
		cylinder { <-0.2108, 4.3863, 0.4357>, <-0.223, 4.4819, 0.4401>, 0.4 }
		cylinder { <-0.223, 4.4819, 0.4401>, <-0.2339, 4.5778, 0.4426>, 0.4 }
		cylinder { <-0.2339, 4.5778, 0.4426>, <-0.2436, 4.6739, 0.4431>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.2436, 4.6739, 0.4431>, <-0.6372, 6.4099, 0.7843>, 0.2223 }
			cylinder { <-0.6372, 6.4099, 0.7843>, <-1.2242, 7.9941, 1.4405>, 0.2223 }
			cylinder { <-1.2242, 7.9941, 1.4405>, <-1.9761, 9.3497, 2.3798>, 0.2223 }
			cylinder { <-1.9761, 9.3497, 2.3798>, <-2.8562, 10.4107, 3.5566>, 0.2223 }
			cylinder { <-2.8562, 10.4107, 3.5566>, <-3.8219, 11.1254, 4.9136>, 0.2223 }
			cylinder { <-3.8219, 11.1254, 4.9136>, <-4.8262, 11.4594, 6.385>, 0.2223 }
			cylinder { <-4.8262, 11.4594, 6.385>, <-5.8203, 11.3961, 7.8993>, 0.2223 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <-5.8203, 11.3961, 7.8993>, <-3.9601, 11.3226, 7.4689>, <-4.3682, 12.1848, 9.2812> }
			triangle { <-5.8203, 11.3961, 7.8993>, <-4.3682, 12.1848, 9.2812>, <-5.4291, 12.1852, 10.3651> }
			triangle { <-3.9601, 11.3226, 7.4689>, <-2.9259, 11.5455, 7.7615>, <-4.3682, 12.1848, 9.2812> }
			triangle { <-2.9259, 11.5455, 7.7615>, <-2.9415, 11.6984, 8.9446>, <-4.3682, 12.1848, 9.2812> }
			triangle { <-2.9415, 11.6984, 8.9446>, <-3.6986, 11.6833, 10.4911>, <-4.3682, 12.1848, 9.2812> }
			triangle { <-3.6986, 11.6833, 10.4911>, <-4.7406, 11.6088, 11.98>, <-5.4291, 12.1852, 10.3651> }
			triangle { <-4.3682, 12.1848, 9.2812>, <-3.6986, 11.6833, 10.4911>, <-5.4291, 12.1852, 10.3651> }
			triangle { <-5.4291, 12.1852, 10.3651>, <-6.1535, 11.8282, 11.7869>, <-7.04096, 11.6989, 10.9351> }
			triangle { <-6.1535, 11.8282, 11.7869>, <-6.5699, 11.2262, 12.9391>, <-7.42, 11.4053, 12.3225> }
			triangle { <-6.1535, 11.8282, 11.7869>, <-7.42, 11.4053, 12.3225>, <-7.04096, 11.6989, 10.9351> }
			triangle { <-7.04096, 11.6989, 10.9351>, <-7.42, 11.4053, 12.3225>, <-8.1159, 11.08648, 11.4567> }
			triangle { <-6.5699, 11.2262, 12.9391>, <-8.219, 10.2844, 13.5316>, <-7.42, 11.4053, 12.3225> }
			triangle { <-7.42, 11.4053, 12.3225>, <-8.219, 10.2844, 13.5316>, <-8.1159, 11.08648, 11.4567> }
			triangle { <-5.8203, 11.3961, 7.8993>, <-5.4291, 12.1852, 10.3651>, <-6.8079, 11.4425, 9.363> }
			triangle { <-6.8079, 11.4425, 9.363>, <-5.4291, 12.1852, 10.3651>, <-7.04096, 11.6989, 10.9351> }
			triangle { <-6.8079, 11.4425, 9.363>, <-7.04096, 11.6989, 10.9351>, <-7.5632, 11.3945, 10.5136> }
			triangle { <-7.04096, 11.6989, 10.9351>, <-8.1159, 11.08648, 11.4567>, <-7.5632, 11.3945, 10.5136> }
			triangle { <-4.7406, 11.6088, 11.98>, <-6.1535, 11.8282, 11.7869>, <-5.4291, 12.1852, 10.3651> }
			triangle { <-4.7406, 11.6088, 11.98>, <-6.5699, 11.2262, 12.9391>, <-6.1535, 11.8282, 11.7869> }
			triangle { <-7.7798, 11.3393, 7.00619>, <-6.02506, 10.8108, 6.09195>, <-5.8203, 11.3961, 7.8993> }
			triangle { <-8.3918, 11.4509, 8.3894>, <-7.7798, 11.3393, 7.00619>, <-5.8203, 11.3961, 7.8993> }
			triangle { <-7.7798, 11.3393, 7.00619>, <-6.6966, 10.611, 5.247>, <-6.02506, 10.8108, 6.09195> }
			triangle { <-7.7798, 11.3393, 7.00619>, <-7.7895, 10.4968, 5.7117>, <-6.6966, 10.611, 5.247> }
			triangle { <-7.7798, 11.3393, 7.00619>, <-8.9057, 10.3928, 7.01876>, <-7.7895, 10.4968, 5.7117> }
			triangle { <-8.3918, 11.4509, 8.3894>, <-9.8579, 10.3405, 8.5675>, <-8.9057, 10.3928, 7.01876> }
			triangle { <-8.3918, 11.4509, 8.3894>, <-8.9057, 10.3928, 7.01876>, <-7.7798, 11.3393, 7.00619> }
			triangle { <-8.208, 11.4097, 10.1568>, <-9.3682, 11.4268, 9.6597>, <-8.3918, 11.4509, 8.3894> }
			triangle { <-9.2053, 10.9063, 11.1297>, <-9.9815, 10.3806, 10.6641>, <-9.3682, 11.4268, 9.6597> }
			triangle { <-8.208, 11.4097, 10.1568>, <-9.2053, 10.9063, 11.1297>, <-9.3682, 11.4268, 9.6597> }
			triangle { <-8.1159, 11.08648, 11.4567>, <-9.2053, 10.9063, 11.1297>, <-8.208, 11.4097, 10.1568> }
			triangle { <-9.2053, 10.9063, 11.1297>, <-9.6658, 9.9823, 12.5692>, <-9.9815, 10.3806, 10.6641> }
			triangle { <-8.1159, 11.08648, 11.4567>, <-9.6658, 9.9823, 12.5692>, <-9.2053, 10.9063, 11.1297> }
			triangle { <-6.8079, 11.4425, 9.363>, <-8.3918, 11.4509, 8.3894>, <-5.8203, 11.3961, 7.8993> }
			triangle { <-8.208, 11.4097, 10.1568>, <-8.3918, 11.4509, 8.3894>, <-6.8079, 11.4425, 9.363> }
			triangle { <-7.5632, 11.3945, 10.5136>, <-8.208, 11.4097, 10.1568>, <-6.8079, 11.4425, 9.363> }
			triangle { <-7.5632, 11.3945, 10.5136>, <-8.1159, 11.08648, 11.4567>, <-8.208, 11.4097, 10.1568> }
			triangle { <-8.3918, 11.4509, 8.3894>, <-9.3682, 11.4268, 9.6597>, <-9.8579, 10.3405, 8.5675> }
			triangle { <-9.3682, 11.4268, 9.6597>, <-9.9815, 10.3806, 10.6641>, <-9.8579, 10.3405, 8.5675> }
			triangle { <-8.1159, 11.08648, 11.4567>, <-8.219, 10.2844, 13.5316>, <-8.9777, 10.1584, 13.09421> }
			triangle { <-8.219, 10.2844, 13.5316>, <-9.2449, 9.159, 13.8662>, <-8.9777, 10.1584, 13.09421> }
			triangle { <-8.1159, 11.08648, 11.4567>, <-8.9777, 10.1584, 13.09421>, <-9.6658, 9.9823, 12.5692> }
			triangle { <-8.9777, 10.1584, 13.09421>, <-9.2449, 9.159, 13.8662>, <-9.6658, 9.9823, 12.5692> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
	union { // internode
		cylinder { <-0.2436, 4.6739, 0.4431>, <-0.2555, 4.7697, 0.4442>, 0.4 }
		cylinder { <-0.2555, 4.7697, 0.4442>, <-0.2697, 4.8651, 0.4459>, 0.4 }
		cylinder { <-0.2697, 4.8651, 0.4459>, <-0.2862, 4.9602, 0.4482>, 0.4 }
		cylinder { <-0.2862, 4.9602, 0.4482>, <-0.3049, 5.05496, 0.4511>, 0.4 }
		cylinder { <-0.3049, 5.05496, 0.4511>, <-0.3258, 5.1491, 0.4546>, 0.4 }
		cylinder { <-0.3258, 5.1491, 0.4546>, <-0.349, 5.2427, 0.4586>, 0.4 }
		cylinder { <-0.349, 5.2427, 0.4586>, <-0.3744, 5.3358, 0.4633>, 0.4 }
		pigment { color rgb <0.19, 0.39, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3744, 5.3358, 0.4633>, <-0.3833, 7.09642, 0.4294>, 0.216 }
			cylinder { <-0.3833, 7.09642, 0.4294>, <0.06286, 8.7933, 0.2795>, 0.216 }
			cylinder { <0.06286, 8.7933, 0.2795>, <0.9319, 10.3035, 0.02459>, 0.216 }
			cylinder { <0.9319, 10.3035, 0.02459>, <2.1608, 11.5176, -0.3169>, 0.216 }
			cylinder { <2.1608, 11.5176, -0.3169>, <3.6605, 12.3477, -0.7204>, 0.216 }
			cylinder { <3.6605, 12.3477, -0.7204>, <5.3224, 12.7336, -1.1565>, 0.216 }
			cylinder { <5.3224, 12.7336, -1.1565>, <7.02613, 12.6474, -1.5937>, 0.216 }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		mesh { // leaf
			triangle { <7.02613, 12.6474, -1.5937>, <5.4135, 12.7492, -2.5079>, <6.9346, 13.6326, -3.4379> }
			triangle { <7.02613, 12.6474, -1.5937>, <6.9346, 13.6326, -3.4379>, <8.4051, 13.5782, -3.5182> }
			triangle { <5.4135, 12.7492, -2.5079>, <4.8785, 13.08805, -3.366>, <6.9346, 13.6326, -3.4379> }
			triangle { <4.8785, 13.08805, -3.366>, <5.6756, 13.2956, -4.1816>, <6.9346, 13.6326, -3.4379> }
			triangle { <5.6756, 13.2956, -4.1816>, <7.2336, 13.2823, -4.7909>, <6.9346, 13.6326, -3.4379> }
			triangle { <7.2336, 13.2823, -4.7909>, <8.9543, 13.1788, -5.18>, <8.4051, 13.5782, -3.5182> }
			triangle { <6.9346, 13.6326, -3.4379>, <7.2336, 13.2823, -4.7909>, <8.4051, 13.5782, -3.5182> }
			triangle { <8.4051, 13.5782, -3.5182>, <9.8433, 13.2321, -4.09749>, <9.9092, 12.9699, -2.9266> }
			triangle { <9.8433, 13.2321, -4.09749>, <10.8741, 12.6679, -4.7124>, <11.08134, 12.7192, -3.6996> }
			triangle { <9.8433, 13.2321, -4.09749>, <11.08134, 12.7192, -3.6996>, <9.9092, 12.9699, -2.9266> }
			triangle { <9.9092, 12.9699, -2.9266>, <11.08134, 12.7192, -3.6996>, <10.9934, 12.2935, -2.6644> }
			triangle { <10.8741, 12.6679, -4.7124>, <12.4005, 11.6175, -4.1625>, <11.08134, 12.7192, -3.6996> }
			triangle { <11.08134, 12.7192, -3.6996>, <12.4005, 11.6175, -4.1625>, <10.9934, 12.2935, -2.6644> }
			triangle { <7.02613, 12.6474, -1.5937>, <8.4051, 13.5782, -3.5182>, <8.6964, 12.6649, -1.9871> }
			triangle { <8.6964, 12.6649, -1.9871>, <8.4051, 13.5782, -3.5182>, <9.9092, 12.9699, -2.9266> }
			triangle { <8.6964, 12.6649, -1.9871>, <9.9092, 12.9699, -2.9266>, <9.991, 12.5994, -2.3193> }
			triangle { <9.9092, 12.9699, -2.9266>, <10.9934, 12.2935, -2.6644>, <9.991, 12.5994, -2.3193> }
			triangle { <8.9543, 13.1788, -5.18>, <9.8433, 13.2321, -4.09749>, <8.4051, 13.5782, -3.5182> }
			triangle { <8.9543, 13.1788, -5.18>, <10.8741, 12.6679, -4.7124>, <9.8433, 13.2321, -4.09749> }
			triangle { <7.8318, 12.3403, 0.3133>, <5.9566, 11.9671, -0.2373>, <7.02613, 12.6474, -1.5937> }
			triangle { <9.1842, 12.4559, -0.2604>, <7.8318, 12.3403, 0.3133>, <7.02613, 12.6474, -1.5937> }
			triangle { <7.8318, 12.3403, 0.3133>, <5.8702, 11.6597, 0.7802>, <5.9566, 11.9671, -0.2373> }
			triangle { <7.8318, 12.3403, 0.3133>, <6.9506, 11.4592, 1.1492>, <5.8702, 11.6597, 0.7802> }
			triangle { <7.8318, 12.3403, 0.3133>, <8.603, 11.3099, 0.9347>, <6.9506, 11.4592, 1.1492> }
			triangle { <9.1842, 12.4559, -0.2604>, <10.3001, 11.2404, 0.4468>, <8.603, 11.3099, 0.9347> }
			triangle { <9.1842, 12.4559, -0.2604>, <8.603, 11.3099, 0.9347>, <7.8318, 12.3403, 0.3133> }
			triangle { <10.2161, 12.5278, -1.6433>, <10.7162, 12.3966, -0.5312>, <9.1842, 12.4559, -0.2604> }
			triangle { <11.5469, 11.9884, -1.7411>, <11.7713, 11.3756, -0.9611>, <10.7162, 12.3966, -0.5312> }
			triangle { <10.2161, 12.5278, -1.6433>, <11.5469, 11.9884, -1.7411>, <10.7162, 12.3966, -0.5312> }
			triangle { <10.9934, 12.2935, -2.6644>, <11.5469, 11.9884, -1.7411>, <10.2161, 12.5278, -1.6433> }
			triangle { <11.5469, 11.9884, -1.7411>, <12.7849, 11.124, -2.5671>, <11.7713, 11.3756, -0.9611> }
			triangle { <10.9934, 12.2935, -2.6644>, <12.7849, 11.124, -2.5671>, <11.5469, 11.9884, -1.7411> }
			triangle { <8.6964, 12.6649, -1.9871>, <9.1842, 12.4559, -0.2604>, <7.02613, 12.6474, -1.5937> }
			triangle { <10.2161, 12.5278, -1.6433>, <9.1842, 12.4559, -0.2604>, <8.6964, 12.6649, -1.9871> }
			triangle { <9.991, 12.5994, -2.3193>, <10.2161, 12.5278, -1.6433>, <8.6964, 12.6649, -1.9871> }
			triangle { <9.991, 12.5994, -2.3193>, <10.9934, 12.2935, -2.6644>, <10.2161, 12.5278, -1.6433> }
			triangle { <9.1842, 12.4559, -0.2604>, <10.7162, 12.3966, -0.5312>, <10.3001, 11.2404, 0.4468> }
			triangle { <10.7162, 12.3966, -0.5312>, <11.7713, 11.3756, -0.9611>, <10.3001, 11.2404, 0.4468> }
			triangle { <10.9934, 12.2935, -2.6644>, <12.4005, 11.6175, -4.1625>, <12.6478, 11.3935, -3.3701> }
			triangle { <12.4005, 11.6175, -4.1625>, <13.3051, 10.4419, -3.8551>, <12.6478, 11.3935, -3.3701> }
			triangle { <10.9934, 12.2935, -2.6644>, <12.6478, 11.3935, -3.3701>, <12.7849, 11.124, -2.5671> }
			triangle { <12.6478, 11.3935, -3.3701>, <13.3051, 10.4419, -3.8551>, <12.7849, 11.124, -2.5671> }
			pigment { color rgb <0.306,0.416,0.278> } finish {crand 0.4 phong 0.5}}
		}
} // end Copy_of_violet

