// Persistence of Vision Ray Tracer Scene Description File
// File: patiotex.inc
// Vers: 3.1
// Desc: textures for mg_patio.pov
// Date: 
// Auth: 
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions




#declare perola=
  
cylinder
        {
        -1*y,  0.75*y,  0.45
        open
        texture { 
                pigment{ rgb <0.34375, 0.39453, 0.44531>} 
                normal {granite  0.6 bump_size 2.5 } 
                finish{ Metal }
                }
        }

//textura tiles patio
#declare piso=
texture
                        {
                        pigment
                                {
                                image_map { tga "pared1b.tga" map_type 0 interpolate 2 }//once }
                                rotate x*90 
                                }
                        finish {specular 0.3}        
                        } 

//textura caja de tierra

#declare tierratex=
texture{
  pigment
	        {
		granite
		color_map
		{
			[0.0 color rgb <0.8,0.75,0.65>]
			[0.2 color rgbf <0.44531, 0.45313, 0.44922,0.5>]   
			[0.4 color rgbf <0.44531, 0.45313, 0.44922,0.5>]
			[0.8 color rgbf <0.7,0.5,0.4,0.3>]
			[0.9 color rgbf <0.6,0.5,0.4,0.3>]
			[1.0 color rgbf <0.6,0.4,0.2,0.3>]
		}
		scale <1,2,1>
		turbulence 0.5
		octaves 10
		omega 0.7
	} 
 
                        

                normal{
                        
                        bump_map
                        { tga  "stone1.tga" map_type 0   interpolate 4  once  bump_size 9.0 }   //"brck2.tga"
        
                }
                finish { crand 0.4 ambient 0.5}//0.3
  
  
  }
  
  

#declare superf=
texture{

        pigment {
        image_map
                { tga "pared1.tga"   map_type 1   interpolate 2    }
                }

        normal{ bumps 0.5}  
        finish {ambient 0.4 crand 0.4}



} 


#declare textura1=
texture{tiles
{
  texture{

        pigment {
        image_map
                { tga "pared1.tga"   map_type 1   interpolate 2    }
                }

        normal{ bumps 0.5}  
        finish {ambient 0.4 crand 0.4}



}
  
  tile2
  texture{

        pigment {
        image_map
                { tga "pared1b.tga" //"suelo.tga"  
                map_type 1   interpolate 2    }
                }

        normal{ bumps 0.5}  
        finish {crand 0.4}
  }
}

}

//Objects
#declare vertical=
cone
        {
        2.0*y,  0.6,
        -0.5*y, 0.35
        open
        texture { textura1}
        }
 


#declare agua=
 texture{
 
 pigment { 
 
 
CornflowerBlue 
 
 
filter 0.60 transmit 0.400}
   normal {
      waves 0.08
      frequency 300.0
      scale 50}
   finish {
      ambient 0.1
      diffuse 0.1
      reflection 0.6
   }
   
 
   
 
 }
 
 
 #declare chif1=//hojas
texture{
    pigment{rgb <0.5, 0.5, 0.25> } //rgb <0.43359, 0.40625, 0.26563>
    finish{phong 0.5 ambient 0.5 diffuse 0.2}
    
    }   
    
    
#declare chif2= //tallo
texture{
    pigment{rgb <0.38672, 0.26172, 0.00391> } //rgb <0.43359, 0.40625, 0.26563>
    normal{bumps 0.6 bump_size 10}
    finish{phong 0.5 ambient 0.5 diffuse 0.2}
    
    } 
    
    
#declare helecho=
texture{
pigment{
    wood//gradient y
    frequency 0.50
    //turbulence 0.5
    rotate <0,15,0>
    scale 1.10 
    color_map{
        [0.0, 0.1    color rgb <0.22266, 0.35938, 0.20313> color rgb <0.47266, 0.47266, 0>]
        [0.1, 0.6    color  rgb <0.47266, 0.47266, 0>  color rgb <0.57813, 0.41406, 0.32031>]
        [0.6, 1.0    color rgb <0.57813, 0.41406, 0.32031> color rgb <0.22266, 0.35938, 0.20313>]
        //[0.8,  1.0  color Very_Light_Purple color Orchid]
    }

}
//normal{radial 12 scale 20}
finish{ambient 0.6 diffuse 0.3}
}



