// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio
#declare ros=
texture{
    pigment{rgb <0.47266, 0.47266, 0> } //rgb <0.43359, 0.40625, 0.26563>
    finish{phong 0.7 ambient 0.5 diffuse 0.2}
    
    } 
#declare rosal= union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.2505, 10.3581, -0.04347>, 0.1554 }
		cylinder { <0.2505, 10.3581, -0.04347>, <0.7514, 20.7069, -0.1303>, 0.1554 }
		cylinder { <0.7514, 20.7069, -0.1303>, <1.5024, 31.0401, -0.2607>, 0.1554 }
		texture {ros}}
	union { // internode
		cylinder { <1.5024, 31.0401, -0.2607>, <1.8292, 41.5553, -0.6695>, 0.1579 }
		cylinder { <1.8292, 41.5553, -0.6695>, <1.7188, 52.0608, -1.3537>, 0.1579 }
		cylinder { <1.7188, 52.0608, -1.3537>, <1.1715, 62.5311, -2.3117>, 0.1579 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.1715, 62.5311, -2.3117>, <0.3324, 64.9755, -2.9845>, 0.2002 }
			cylinder { <0.3324, 64.9755, -2.9845>, <-1.1223, 66.9617, -4.01919>, 0.2002 }
			cylinder { <-1.1223, 66.9617, -4.01919>, <-3.04597, 68.2892, -5.3113>, 0.2002 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.04597, 68.2892, -5.3113>, <-4.007767, 68.9529, -5.9573>, 0.2002 }
				cylinder { <-4.007767, 68.9529, -5.9573>, <-4.9695, 69.6167, -6.6034>, 0.2002 }
				cylinder { <-4.9695, 69.6167, -6.6034>, <-5.9313, 70.2804, -7.2494>, 0.2002 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-5.9313, 70.2804, -7.2494>, <-6.04946, 70.3801, -7.3974>, 0.01604 }
				cylinder { <-6.04946, 70.3801, -7.3974>, <-6.123, 70.4659, -7.5791>, 0.01604 }
				cylinder { <-6.123, 70.4659, -7.5791>, <-6.1466, 70.5316, -7.7814>, 0.01604 }
				texture {ros}}
			mesh { // leaf
				triangle { <-6.1466, 70.5316, -7.7814>, <-8.3074, 73.7207, -12.8498>, <-6.5437, 72.8102, -13.5211> }
				triangle { <-8.3074, 73.7207, -12.8498>, <-8.884, 74.6534, -15.9545>, <-6.5437, 72.8102, -13.5211> }
				triangle { <-8.884, 74.6534, -15.9545>, <-6.9866, 73.7044, -16.7387>, <-6.5437, 72.8102, -13.5211> }
				triangle { <-8.884, 74.6534, -15.9545>, <-7.2967, 74.2296, -18.8203>, <-6.9866, 73.7044, -16.7387> }
				triangle { <-6.9866, 73.7044, -16.7387>, <-7.2967, 74.2296, -18.8203>, <-5.1789, 73.01171, -16.9207> }
				triangle { <-6.5437, 72.8102, -13.5211>, <-6.9866, 73.7044, -16.7387>, <-5.1789, 73.01171, -16.9207> }
				triangle { <-6.5437, 72.8102, -13.5211>, <-5.1789, 73.01171, -16.9207>, <-4.9942, 72.1674, -13.7415> }
				triangle { <-6.5437, 72.8102, -13.5211>, <-4.9942, 72.1674, -13.7415>, <-6.1466, 70.5316, -7.7814> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-5.9313, 70.2804, -7.2494>, <-6.8931, 70.9442, -7.8955>, 0.2002 }
				cylinder { <-6.8931, 70.9442, -7.8955>, <-7.8549, 71.6079, -8.5416>, 0.2002 }
				cylinder { <-7.8549, 71.6079, -8.5416>, <-8.8167, 72.2717, -9.1876>, 0.2002 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-8.8167, 72.2717, -9.1876>, <-8.9957, 72.377, -9.2392>, 0.01604 }
				cylinder { <-8.9957, 72.377, -9.2392>, <-9.1865, 72.4737, -9.2351>, 0.01604 }
				cylinder { <-9.1865, 72.4737, -9.2351>, <-9.3754, 72.5547, -9.1756>, 0.01604 }
				texture {ros}}
			mesh { // leaf
				triangle { <-9.3754, 72.5547, -9.1756>, <-14.08743, 74.7316, -5.4896>, <-14.6207, 75.3324, -7.4248> }
				triangle { <-14.08743, 74.7316, -5.4896>, <-17.03382, 75.784, -4.4636>, <-14.6207, 75.3324, -7.4248> }
				triangle { <-17.03382, 75.784, -4.4636>, <-17.6625, 76.4674, -6.526>, <-14.6207, 75.3324, -7.4248> }
				triangle { <-17.03382, 75.784, -4.4636>, <-19.6434, 77.1474, -5.9614>, <-17.6625, 76.4674, -6.526> }
				triangle { <-17.6625, 76.4674, -6.526>, <-19.6434, 77.1474, -5.9614>, <-17.6754, 77.1419, -8.3496> }
				triangle { <-14.6207, 75.3324, -7.4248>, <-17.6625, 76.4674, -6.526>, <-17.6754, 77.1419, -8.3496> }
				triangle { <-14.6207, 75.3324, -7.4248>, <-17.6754, 77.1419, -8.3496>, <-14.7028, 75.8896, -9.02039> }
				triangle { <-14.6207, 75.3324, -7.4248>, <-14.7028, 75.8896, -9.02039>, <-9.3754, 72.5547, -9.1756> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-8.8167, 72.2717, -9.1876>, <-9.7785, 72.9354, -9.8337>, 0.2002 }
				cylinder { <-9.7785, 72.9354, -9.8337>, <-10.7403, 73.5992, -10.4798>, 0.2002 }
				cylinder { <-10.7403, 73.5992, -10.4798>, <-11.7021, 74.2629, -11.1258>, 0.2002 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-11.7021, 74.2629, -11.1258>, <-11.8202, 74.3626, -11.2738>, 0.01604 }
				cylinder { <-11.8202, 74.3626, -11.2738>, <-11.8937, 74.4484, -11.4555>, 0.01604 }
				cylinder { <-11.8937, 74.4484, -11.4555>, <-11.9174, 74.5141, -11.6577>, 0.01604 }
				texture {ros}}
			mesh { // leaf
				triangle { <-11.9174, 74.5141, -11.6577>, <-14.07826, 77.7032, -16.7261>, <-12.3145, 76.7927, -17.3975> }
				triangle { <-14.07826, 77.7032, -16.7261>, <-14.6548, 78.6359, -19.8308>, <-12.3145, 76.7927, -17.3975> }
				triangle { <-14.6548, 78.6359, -19.8308>, <-12.7574, 77.6869, -20.6151>, <-12.3145, 76.7927, -17.3975> }
				triangle { <-14.6548, 78.6359, -19.8308>, <-13.06756, 78.2121, -22.6967>, <-12.7574, 77.6869, -20.6151> }
				triangle { <-12.7574, 77.6869, -20.6151>, <-13.06756, 78.2121, -22.6967>, <-10.9497, 76.9942, -20.7971> }
				triangle { <-12.3145, 76.7927, -17.3975>, <-12.7574, 77.6869, -20.6151>, <-10.9497, 76.9942, -20.7971> }
				triangle { <-12.3145, 76.7927, -17.3975>, <-10.9497, 76.9942, -20.7971>, <-10.765, 76.1499, -17.6179> }
				triangle { <-12.3145, 76.7927, -17.3975>, <-10.765, 76.1499, -17.6179>, <-11.9174, 74.5141, -11.6577> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-11.7021, 74.2629, -11.1258>, <-11.8562, 74.3693, -11.2293>, 0.01604 }
				cylinder { <-11.8562, 74.3693, -11.2293>, <-12.01037, 74.4756, -11.3329>, 0.01604 }
				cylinder { <-12.01037, 74.4756, -11.3329>, <-12.1644, 74.582, -11.4364>, 0.01604 }
				texture {ros}}
			mesh { // leaf
				triangle { <-12.1644, 74.582, -11.4364>, <-17.2761, 78.2231, -12.505>, <-16.3519, 78.06104, -14.3785> }
				triangle { <-17.2761, 78.2231, -12.505>, <-19.7987, 79.725, -13.9958>, <-16.3519, 78.06104, -14.3785> }
				triangle { <-19.7987, 79.725, -13.9958>, <-18.8467, 79.5948, -16.04342>, <-16.3519, 78.06104, -14.3785> }
				triangle { <-19.7987, 79.725, -13.9958>, <-20.476, 80.5313, -17.1268>, <-18.8467, 79.5948, -16.04342> }
				triangle { <-18.8467, 79.5948, -16.04342>, <-20.476, 80.5313, -17.1268>, <-17.5773, 79.5192, -17.5142> }
				triangle { <-16.3519, 78.06104, -14.3785>, <-18.8467, 79.5948, -16.04342>, <-17.5773, 79.5192, -17.5142> }
				triangle { <-16.3519, 78.06104, -14.3785>, <-17.5773, 79.5192, -17.5142>, <-15.3039, 77.9676, -15.7035> }
				triangle { <-16.3519, 78.06104, -14.3785>, <-15.3039, 77.9676, -15.7035>, <-12.1644, 74.582, -11.4364> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <1.1715, 62.5311, -2.3117>, <-6.4863, 76.1359, -7.9424>, 0.2489 }
		cylinder { <-6.4863, 76.1359, -7.9424>, <-18.9498, 83.3056, -16.2307>, 0.2489 }
		cylinder { <-18.9498, 83.3056, -16.2307>, <-32.9806, 82.1774, -25.02306>, 0.2489 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-32.9806, 82.1774, -25.02306>, <-37.818, 79.8767, -27.9426>, 0.4575 }
			cylinder { <-37.818, 79.8767, -27.9426>, <-41.847, 75.9223, -30.255>, 0.4575 }
			cylinder { <-41.847, 75.9223, -30.255>, <-44.6609, 70.7134, -31.7268>, 0.4575 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-44.6609, 70.7134, -31.7268>, <-46.06791, 68.1089, -32.4628>, 0.4575 }
				cylinder { <-46.06791, 68.1089, -32.4628>, <-47.4748, 65.5044, -33.1987>, 0.4575 }
				cylinder { <-47.4748, 65.5044, -33.1987>, <-48.8818, 62.9, -33.9346>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-48.8818, 62.9, -33.9346>, <-49.2193, 61.9665, -34.4458>, 0.08373 }
				cylinder { <-49.2193, 61.9665, -34.4458>, <-49.355, 61.1204, -35.1616>, 0.08373 }
				cylinder { <-49.355, 61.1204, -35.1616>, <-49.279, 60.4231, -36.03032>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-49.279, 60.4231, -36.03032>, <-52.593, 49.9357, -45.5446>, <-48.9693, 52.2979, -47.594> }
				triangle { <-52.593, 49.9357, -45.5446>, <-52.07913, 44.8458, -51.05854>, <-48.9693, 52.2979, -47.594> }
				triangle { <-52.07913, 44.8458, -51.05854>, <-48.1861, 47.3076, -53.3995>, <-48.9693, 52.2979, -47.594> }
				triangle { <-52.07913, 44.8458, -51.05854>, <-47.5899, 44.03179, -57.06913>, <-48.1861, 47.3076, -53.3995> }
				triangle { <-48.1861, 47.3076, -53.3995>, <-47.5899, 44.03179, -57.06913>, <-45.4008, 50.4067, -54.9377> }
				triangle { <-48.9693, 52.2979, -47.594>, <-48.1861, 47.3076, -53.3995>, <-45.4008, 50.4067, -54.9377> }
				triangle { <-48.9693, 52.2979, -47.594>, <-45.4008, 50.4067, -54.9377>, <-46.427, 54.8671, -48.9633> }
				triangle { <-48.9693, 52.2979, -47.594>, <-46.427, 54.8671, -48.9633>, <-49.279, 60.4231, -36.03032> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-48.8818, 62.9, -33.9346>, <-50.2887, 60.2955, -34.6706>, 0.4575 }
				cylinder { <-50.2887, 60.2955, -34.6706>, <-51.6957, 57.6911, -35.4065>, 0.4575 }
				cylinder { <-51.6957, 57.6911, -35.4065>, <-53.1027, 55.08665, -36.1425>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-53.1027, 55.08665, -36.1425>, <-53.7578, 54.1825, -36.1506>, 0.08373 }
				cylinder { <-53.7578, 54.1825, -36.1506>, <-54.5056, 53.3932, -35.8969>, 0.08373 }
				cylinder { <-54.5056, 53.3932, -35.8969>, <-55.2919, 52.7758, -35.3997>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-55.2919, 52.7758, -35.3997>, <-66.1504, 48.9294, -26.5233>, <-65.9887, 45.4326, -29.7879> }
				triangle { <-66.1504, 48.9294, -26.5233>, <-71.1874, 44.8292, -22.7299>, <-65.9887, 45.4326, -29.7879> }
				triangle { <-71.1874, 44.8292, -22.7299>, <-71.1423, 40.9924, -26.1901>, <-65.9887, 45.4326, -29.7879> }
				triangle { <-71.1874, 44.8292, -22.7299>, <-74.3626, 38.07021, -23.8147>, <-71.1423, 40.9924, -26.1901> }
				triangle { <-71.1423, 40.9924, -26.1901>, <-74.3626, 38.07021, -23.8147>, <-70.8676, 38.6198, -29.935> }
				triangle { <-65.9887, 45.4326, -29.7879>, <-71.1423, 40.9924, -26.1901>, <-70.8676, 38.6198, -29.935> }
				triangle { <-65.9887, 45.4326, -29.7879>, <-70.8676, 38.6198, -29.935>, <-65.7315, 43.2223, -32.9482> }
				triangle { <-65.9887, 45.4326, -29.7879>, <-65.7315, 43.2223, -32.9482>, <-55.2919, 52.7758, -35.3997> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-53.1027, 55.08665, -36.1425>, <-54.5096, 52.4821, -36.8784>, 0.4575 }
				cylinder { <-54.5096, 52.4821, -36.8784>, <-55.9166, 49.8777, -37.6143>, 0.4575 }
				cylinder { <-55.9166, 49.8777, -37.6143>, <-57.3235, 47.2732, -38.3503>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-57.3235, 47.2732, -38.3503>, <-57.6611, 46.3397, -38.8614>, 0.08373 }
				cylinder { <-57.6611, 46.3397, -38.8614>, <-57.7968, 45.4937, -39.5772>, 0.08373 }
				cylinder { <-57.7968, 45.4937, -39.5772>, <-57.7207, 44.7963, -40.4459>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-57.7207, 44.7963, -40.4459>, <-61.03478, 34.3089, -49.9602>, <-57.4111, 36.6711, -52.00967> }
				triangle { <-61.03478, 34.3089, -49.9602>, <-60.5208, 29.219, -55.4741>, <-57.4111, 36.6711, -52.00967> }
				triangle { <-60.5208, 29.219, -55.4741>, <-56.6279, 31.6808, -57.8151>, <-57.4111, 36.6711, -52.00967> }
				triangle { <-60.5208, 29.219, -55.4741>, <-56.03169, 28.405, -61.4847>, <-56.6279, 31.6808, -57.8151> }
				triangle { <-56.6279, 31.6808, -57.8151>, <-56.03169, 28.405, -61.4847>, <-53.8425, 34.78, -59.3533> }
				triangle { <-57.4111, 36.6711, -52.00967>, <-56.6279, 31.6808, -57.8151>, <-53.8425, 34.78, -59.3533> }
				triangle { <-57.4111, 36.6711, -52.00967>, <-53.8425, 34.78, -59.3533>, <-54.8688, 39.2403, -53.3789> }
				triangle { <-57.4111, 36.6711, -52.00967>, <-54.8688, 39.2403, -53.3789>, <-57.7207, 44.7963, -40.4459> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-57.3235, 47.2732, -38.3503>, <-57.8385, 46.3199, -38.6196>, 0.08373 }
				cylinder { <-57.8385, 46.3199, -38.6196>, <-58.3535, 45.3666, -38.889>, 0.08373 }
				cylinder { <-58.3535, 45.3666, -38.889>, <-58.8685, 44.4132, -39.1584>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-58.8685, 44.4132, -39.1584>, <-68.6779, 33.6779, -39.3059>, <-66.04991, 32.9406, -43.2379> }
				triangle { <-68.6779, 33.6779, -39.3059>, <-72.07461, 27.09937, -40.6322>, <-66.04991, 32.9406, -43.2379> }
				triangle { <-72.07461, 27.09937, -40.6322>, <-69.3358, 26.1877, -44.9175>, <-66.04991, 32.9406, -43.2379> }
				triangle { <-72.07461, 27.09937, -40.6322>, <-71.3555, 21.7788, -45.9347>, <-69.3358, 26.1877, -44.9175> }
				triangle { <-69.3358, 26.1877, -44.9175>, <-71.3555, 21.7788, -45.9347>, <-67.00012, 26.6292, -48.6696> }
				triangle { <-66.04991, 32.9406, -43.2379>, <-69.3358, 26.1877, -44.9175>, <-67.00012, 26.6292, -48.6696> }
				triangle { <-66.04991, 32.9406, -43.2379>, <-67.00012, 26.6292, -48.6696>, <-63.9615, 33.1581, -46.483> }
				triangle { <-66.04991, 32.9406, -43.2379>, <-63.9615, 33.1581, -46.483>, <-58.8685, 44.4132, -39.1584> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-32.9806, 82.1774, -25.02306>, <-34.2087, 81.1376, -25.7376>, 0.02641 }
		cylinder { <-34.2087, 81.1376, -25.7376>, <-34.7955, 79.5003, -26.01231>, 0.02641 }
		cylinder { <-34.7955, 79.5003, -26.01231>, <-34.5587, 77.7736, -25.7617>, 0.02641 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-34.5587, 77.7736, -25.7617>, <-34.3805, 77.375, -25.6259>, 0.03429 }
			cylinder { <-34.3805, 77.375, -25.6259>, <-34.1036, 77.06656, -25.4331>, 0.03429 }
			cylinder { <-34.1036, 77.06656, -25.4331>, <-33.756, 76.8792, -25.2027>, 0.03429 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-33.756, 76.8792, -25.2027>, <-33.5822, 76.7855, -25.08749>, 0.03429 }
				cylinder { <-33.5822, 76.7855, -25.08749>, <-33.4084, 76.6918, -24.9722>, 0.03429 }
				cylinder { <-33.4084, 76.6918, -24.9722>, <-33.2346, 76.5981, -24.857>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-33.2346, 76.5981, -24.857>, <-33.2291, 76.5956, -24.8554>, 0.0004703 }
				cylinder { <-33.2291, 76.5956, -24.8554>, <-33.2233, 76.5932, -24.8554>, 0.0004703 }
				cylinder { <-33.2233, 76.5932, -24.8554>, <-33.2176, 76.5912, -24.857>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-33.2176, 76.5912, -24.857>, <-32.2589, 76.07375, -24.8238>, <-32.289, 76.1836, -25.1639> }
				triangle { <-32.2589, 76.07375, -24.8238>, <-31.7317, 75.9125, -24.9413>, <-32.289, 76.1836, -25.1639> }
				triangle { <-31.7317, 75.9125, -24.9413>, <-31.7544, 76.02529, -25.3111>, <-32.289, 76.1836, -25.1639> }
				triangle { <-31.7317, 75.9125, -24.9413>, <-31.407, 75.9323, -25.4039>, <-31.7544, 76.02529, -25.3111> }
				triangle { <-31.7544, 76.02529, -25.3111>, <-31.407, 75.9323, -25.4039>, <-31.8623, 76.09988, -25.6171> }
				triangle { <-32.289, 76.1836, -25.1639>, <-31.7544, 76.02529, -25.3111>, <-31.8623, 76.09988, -25.6171> }
				triangle { <-32.289, 76.1836, -25.1639>, <-31.8623, 76.09988, -25.6171>, <-32.3718, 76.2556, -25.432> }
				triangle { <-32.289, 76.1836, -25.1639>, <-32.3718, 76.2556, -25.432>, <-33.2176, 76.5912, -24.857> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-33.2346, 76.5981, -24.857>, <-33.0608, 76.5045, -24.7418>, 0.03429 }
				cylinder { <-33.0608, 76.5045, -24.7418>, <-32.8869, 76.4108, -24.6266>, 0.03429 }
				cylinder { <-32.8869, 76.4108, -24.6266>, <-32.7131, 76.3171, -24.5114>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-32.7131, 76.3171, -24.5114>, <-32.7094, 76.3147, -24.5069>, 0.0004703 }
				cylinder { <-32.7094, 76.3147, -24.5069>, <-32.7071, 76.3127, -24.5015>, 0.0004703 }
				cylinder { <-32.7071, 76.3127, -24.5015>, <-32.7062, 76.3111, -24.4955>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-32.7062, 76.3111, -24.4955>, <-32.9197, 76.07081, -23.4541>, <-32.5783, 75.971, -23.5003> }
				triangle { <-32.9197, 76.07081, -23.4541>, <-32.8571, 75.966, -22.9037>, <-32.5783, 75.971, -23.5003> }
				triangle { <-32.8571, 75.966, -22.9037>, <-32.4886, 75.8538, -22.9428>, <-32.5783, 75.971, -23.5003> }
				triangle { <-32.8571, 75.966, -22.9037>, <-32.4272, 75.7874, -22.5826>, <-32.4886, 75.8538, -22.9428> }
				triangle { <-32.4886, 75.8538, -22.9428>, <-32.4272, 75.7874, -22.5826>, <-32.2021, 75.7301, -23.05877> }
				triangle { <-32.5783, 75.971, -23.5003>, <-32.4886, 75.8538, -22.9428>, <-32.2021, 75.7301, -23.05877> }
				triangle { <-32.5783, 75.971, -23.5003>, <-32.2021, 75.7301, -23.05877>, <-32.3226, 75.87, -23.5917> }
				triangle { <-32.5783, 75.971, -23.5003>, <-32.3226, 75.87, -23.5917>, <-32.7062, 76.3111, -24.4955> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-32.7131, 76.3171, -24.5114>, <-32.5393, 76.2234, -24.3962>, 0.03429 }
				cylinder { <-32.5393, 76.2234, -24.3962>, <-32.3655, 76.1298, -24.2809>, 0.03429 }
				cylinder { <-32.3655, 76.1298, -24.2809>, <-32.1917, 76.03614, -24.1657>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-32.1917, 76.03614, -24.1657>, <-32.1862, 76.03358, -24.1641>, 0.0004703 }
				cylinder { <-32.1862, 76.03358, -24.1641>, <-32.1804, 76.03122, -24.1641>, 0.0004703 }
				cylinder { <-32.1804, 76.03122, -24.1641>, <-32.1747, 76.02922, -24.1658>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-32.1747, 76.02922, -24.1658>, <-31.2161, 75.5117, -24.1325>, <-31.2462, 75.6216, -24.4726> }
				triangle { <-31.2161, 75.5117, -24.1325>, <-30.6889, 75.3504, -24.2501>, <-31.2462, 75.6216, -24.4726> }
				triangle { <-30.6889, 75.3504, -24.2501>, <-30.7115, 75.4632, -24.6198>, <-31.2462, 75.6216, -24.4726> }
				triangle { <-30.6889, 75.3504, -24.2501>, <-30.3642, 75.3703, -24.7127>, <-30.7115, 75.4632, -24.6198> }
				triangle { <-30.7115, 75.4632, -24.6198>, <-30.3642, 75.3703, -24.7127>, <-30.8194, 75.5378, -24.9258> }
				triangle { <-31.2462, 75.6216, -24.4726>, <-30.7115, 75.4632, -24.6198>, <-30.8194, 75.5378, -24.9258> }
				triangle { <-31.2462, 75.6216, -24.4726>, <-30.8194, 75.5378, -24.9258>, <-31.329, 75.6935, -24.7407> }
				triangle { <-31.2462, 75.6216, -24.4726>, <-31.329, 75.6935, -24.7407>, <-32.1747, 76.02922, -24.1658> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-32.1917, 76.03614, -24.1657>, <-32.1869, 76.03357, -24.1626>, 0.0004703 }
				cylinder { <-32.1869, 76.03357, -24.1626>, <-32.1822, 76.031, -24.1594>, 0.0004703 }
				cylinder { <-32.1822, 76.031, -24.1594>, <-32.1774, 76.02843, -24.1562>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-32.1774, 76.02843, -24.1562>, <-31.6188, 75.5238, -23.368>, <-31.3976, 75.52, -23.6504> }
				triangle { <-31.6188, 75.5238, -23.368>, <-31.1957, 75.3197, -23.05651>, <-31.3976, 75.52, -23.6504> }
				triangle { <-31.1957, 75.3197, -23.05651>, <-30.9494, 75.3089, -23.3551>, <-31.3976, 75.52, -23.6504> }
				triangle { <-31.1957, 75.3197, -23.05651>, <-30.6577, 75.1821, -23.1635>, <-30.9494, 75.3089, -23.3551> }
				triangle { <-30.9494, 75.3089, -23.3551>, <-30.6577, 75.1821, -23.1635>, <-30.8154, 75.2845, -23.6588> }
				triangle { <-31.3976, 75.52, -23.6504>, <-30.9494, 75.3089, -23.3551>, <-30.8154, 75.2845, -23.6588> }
				triangle { <-31.3976, 75.52, -23.6504>, <-30.8154, 75.2845, -23.6588>, <-31.27, 75.5045, -23.91> }
				triangle { <-31.3976, 75.52, -23.6504>, <-31.27, 75.5045, -23.91>, <-32.1774, 76.02843, -24.1562> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-32.9806, 82.1774, -25.02306>, <-45.6804, 81.7353, -32.4411>, 0.2207 }
		cylinder { <-45.6804, 81.7353, -32.4411>, <-58.6099, 81.8525, -39.4642>, 0.2207 }
		cylinder { <-58.6099, 81.8525, -39.4642>, <-71.7379, 82.5288, -46.07545>, 0.2207 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-71.7379, 82.5288, -46.07545>, <-75.1194, 83.5731, -46.9666>, 0.2737 }
			cylinder { <-75.1194, 83.5731, -46.9666>, <-78.285, 85.3887, -47.01937>, 0.2737 }
			cylinder { <-78.285, 85.3887, -47.01937>, <-80.915, 87.7922, -46.2282>, 0.2737 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-80.915, 87.7922, -46.2282>, <-82.23, 88.9939, -45.8326>, 0.2737 }
				cylinder { <-82.23, 88.9939, -45.8326>, <-83.545, 90.1957, -45.437>, 0.2737 }
				cylinder { <-83.545, 90.1957, -45.437>, <-84.86, 91.3974, -45.0415>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-84.86, 91.3974, -45.0415>, <-85.1773, 91.5836, -44.8857>, 0.02996 }
				cylinder { <-85.1773, 91.5836, -44.8857>, <-85.5012, 91.6794, -44.6721>, 0.02996 }
				cylinder { <-85.5012, 91.6794, -44.6721>, <-85.808, 91.6778, -44.4161>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <-85.808, 91.6778, -44.4161>, <-93.347, 93.7871, -40.6208>, <-92.6359, 91.276, -39.4425> }
				triangle { <-93.347, 93.7871, -40.6208>, <-96.7238, 94.05821, -37.6593>, <-92.6359, 91.276, -39.4425> }
				triangle { <-96.7238, 94.05821, -37.6593>, <-96.03905, 91.3467, -36.3428>, <-92.6359, 91.276, -39.4425> }
				triangle { <-96.7238, 94.05821, -37.6593>, <-98.181, 91.424, -34.2953>, <-96.03905, 91.3467, -36.3428> }
				triangle { <-96.03905, 91.3467, -36.3428>, <-98.181, 91.424, -34.2953>, <-95.221, 88.8593, -35.8908> }
				triangle { <-92.6359, 91.276, -39.4425>, <-96.03905, 91.3467, -36.3428>, <-95.221, 88.8593, -35.8908> }
				triangle { <-92.6359, 91.276, -39.4425>, <-95.221, 88.8593, -35.8908>, <-91.9248, 89.1327, -38.9455> }
				triangle { <-92.6359, 91.276, -39.4425>, <-91.9248, 89.1327, -38.9455>, <-85.808, 91.6778, -44.4161> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-84.86, 91.3974, -45.0415>, <-86.175, 92.5992, -44.6459>, 0.2737 }
				cylinder { <-86.175, 92.5992, -44.6459>, <-87.4899, 93.8009, -44.2503>, 0.2737 }
				cylinder { <-87.4899, 93.8009, -44.2503>, <-88.8049, 95.00269, -43.8547>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-88.8049, 95.00269, -43.8547>, <-89.04264, 95.3237, -43.8435>, 0.02996 }
				cylinder { <-89.04264, 95.3237, -43.8435>, <-89.2127, 95.6793, -43.9085>, 0.02996 }
				cylinder { <-89.2127, 95.6793, -43.9085>, <-89.303, 96.04391, -44.04512>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <-89.303, 96.04391, -44.04512>, <-89.5352, 103.0663, -49.1756>, <-91.6769, 103.4714, -47.3185> }
				triangle { <-89.5352, 103.0663, -49.1756>, <-90.2509, 107.2417, -50.6923>, <-91.6769, 103.4714, -47.3185> }
				triangle { <-90.2509, 107.2417, -50.6923>, <-92.5881, 107.7556, -48.7359>, <-91.6769, 103.4714, -47.3185> }
				triangle { <-90.2509, 107.2417, -50.6923>, <-93.1283, 110.5417, -49.5922>, <-92.5881, 107.7556, -48.7359> }
				triangle { <-92.5881, 107.7556, -48.7359>, <-93.1283, 110.5417, -49.5922>, <-94.691, 107.4739, -47.1362> }
				triangle { <-91.6769, 103.4714, -47.3185>, <-92.5881, 107.7556, -48.7359>, <-94.691, 107.4739, -47.1362> }
				triangle { <-91.6769, 103.4714, -47.3185>, <-94.691, 107.4739, -47.1362>, <-93.4844, 103.3208, -45.8844> }
				triangle { <-91.6769, 103.4714, -47.3185>, <-93.4844, 103.3208, -45.8844>, <-89.303, 96.04391, -44.04512> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-88.8049, 95.00269, -43.8547>, <-90.1199, 96.2044, -43.4592>, 0.2737 }
				cylinder { <-90.1199, 96.2044, -43.4592>, <-91.4349, 97.4061, -43.06364>, 0.2737 }
				cylinder { <-91.4349, 97.4061, -43.06364>, <-92.7499, 98.6079, -42.668>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.7499, 98.6079, -42.668>, <-93.06736, 98.7941, -42.5123>, 0.02996 }
				cylinder { <-93.06736, 98.7941, -42.5123>, <-93.3912, 98.8898, -42.2987>, 0.02996 }
				cylinder { <-93.3912, 98.8898, -42.2987>, <-93.698, 98.8882, -42.04271>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <-93.698, 98.8882, -42.04271>, <-101.237, 100.9976, -38.2474>, <-100.5259, 98.4865, -37.06915> }
				triangle { <-101.237, 100.9976, -38.2474>, <-104.6138, 101.2687, -35.2858>, <-100.5259, 98.4865, -37.06915> }
				triangle { <-104.6138, 101.2687, -35.2858>, <-103.929, 98.5571, -33.9694>, <-100.5259, 98.4865, -37.06915> }
				triangle { <-104.6138, 101.2687, -35.2858>, <-106.0711, 98.6345, -31.9218>, <-103.929, 98.5571, -33.9694> }
				triangle { <-103.929, 98.5571, -33.9694>, <-106.0711, 98.6345, -31.9218>, <-103.111, 96.06976, -33.5174> }
				triangle { <-100.5259, 98.4865, -37.06915>, <-103.929, 98.5571, -33.9694>, <-103.111, 96.06976, -33.5174> }
				triangle { <-100.5259, 98.4865, -37.06915>, <-103.111, 96.06976, -33.5174>, <-99.8148, 96.3431, -36.5721> }
				triangle { <-100.5259, 98.4865, -37.06915>, <-99.8148, 96.3431, -36.5721>, <-93.698, 98.8882, -42.04271> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.7499, 98.6079, -42.668>, <-93.03793, 98.871, -42.5814>, 0.02996 }
				cylinder { <-93.03793, 98.871, -42.5814>, <-93.3258, 99.1342, -42.4948>, 0.02996 }
				cylinder { <-93.3258, 99.1342, -42.4948>, <-93.6138, 99.3973, -42.4082>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <-93.6138, 99.3973, -42.4082>, <-99.01865, 106.1797, -43.09945>, <-100.1136, 104.6124, -40.9677> }
				triangle { <-99.01865, 106.1797, -43.09945>, <-102.0438, 109.3638, -42.121>, <-100.1136, 104.6124, -40.9677> }
				triangle { <-102.0438, 109.3638, -42.121>, <-103.2995, 107.7301, -39.8171>, <-100.1136, 104.6124, -40.9677> }
				triangle { <-102.0438, 109.3638, -42.121>, <-105.302, 109.7662, -39.02251>, <-103.2995, 107.7301, -39.8171> }
				triangle { <-103.2995, 107.7301, -39.8171>, <-105.302, 109.7662, -39.02251>, <-104.1737, 105.7623, -38.26> }
				triangle { <-100.1136, 104.6124, -40.9677>, <-103.2995, 107.7301, -39.8171>, <-104.1737, 105.7623, -38.26> }
				triangle { <-100.1136, 104.6124, -40.9677>, <-104.1737, 105.7623, -38.26>, <-100.8798, 102.9691, -39.5328> }
				triangle { <-100.1136, 104.6124, -40.9677>, <-100.8798, 102.9691, -39.5328>, <-93.6138, 99.3973, -42.4082> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-71.7379, 82.5288, -46.07545>, <-74.3949, 83.7704, -46.3829>, 0.04423 }
		cylinder { <-74.3949, 83.7704, -46.3829>, <-76.3875, 85.7955, -45.5931>, 0.04423 }
		cylinder { <-76.3875, 85.7955, -45.5931>, <-77.198, 88.07806, -43.9111>, 0.04423 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-77.198, 88.07806, -43.9111>, <-77.1855, 88.6181, -43.4005>, 0.05575 }
			cylinder { <-77.1855, 88.6181, -43.4005>, <-76.9574, 89.0683, -42.8547>, 0.05575 }
			cylinder { <-76.9574, 89.0683, -42.8547>, <-76.5368, 89.3832, -42.3289>, 0.05575 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-76.5368, 89.3832, -42.3289>, <-76.3265, 89.5406, -42.06607>, 0.05575 }
				cylinder { <-76.3265, 89.5406, -42.06607>, <-76.1162, 89.6981, -41.8031>, 0.05575 }
				cylinder { <-76.1162, 89.6981, -41.8031>, <-75.9058, 89.8555, -41.5402>, 0.05575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-75.9058, 89.8555, -41.5402>, <-75.8985, 89.8595, -41.5259>, 0.001243 }
				cylinder { <-75.8985, 89.8595, -41.5259>, <-75.8936, 89.8601, -41.5101>, 0.001243 }
				cylinder { <-75.8936, 89.8601, -41.5101>, <-75.8916, 89.8574, -41.4939>, 0.001243 }
				texture {ros}}
			mesh { // leaf
				triangle { <-75.8916, 89.8574, -41.4939>, <-75.4509, 90.1096, -39.7962>, <-75.8, 89.6425, -39.7873> }
				triangle { <-75.4509, 90.1096, -39.7962>, <-75.2794, 89.962, -38.9081>, <-75.8, 89.6425, -39.7873> }
				triangle { <-75.2794, 89.962, -38.9081>, <-75.6556, 89.4581, -38.8794>, <-75.8, 89.6425, -39.7873> }
				triangle { <-75.2794, 89.962, -38.9081>, <-75.551, 89.3292, -38.2989>, <-75.6556, 89.4581, -38.8794> }
				triangle { <-75.6556, 89.4581, -38.8794>, <-75.551, 89.3292, -38.2989>, <-76.05378, 89.1004, -38.9599> }
				triangle { <-75.8, 89.6425, -39.7873>, <-75.6556, 89.4581, -38.8794>, <-76.05378, 89.1004, -38.9599> }
				triangle { <-75.8, 89.6425, -39.7873>, <-76.05378, 89.1004, -38.9599>, <-76.1345, 89.3164, -39.8474> }
				triangle { <-75.8, 89.6425, -39.7873>, <-76.1345, 89.3164, -39.8474>, <-75.8916, 89.8574, -41.4939> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-75.9058, 89.8555, -41.5402>, <-75.6955, 90.01303, -41.2773>, 0.05575 }
				cylinder { <-75.6955, 90.01303, -41.2773>, <-75.4852, 90.1704, -41.0145>, 0.05575 }
				cylinder { <-75.4852, 90.1704, -41.0145>, <-75.2749, 90.3279, -40.7516>, 0.05575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-75.2749, 90.3279, -40.7516>, <-75.2642, 90.3375, -40.7433>, 0.001243 }
				cylinder { <-75.2642, 90.3375, -40.7433>, <-75.253, 90.3489, -40.739>, 0.001243 }
				cylinder { <-75.253, 90.3489, -40.739>, <-75.242, 90.3613, -40.739>, 0.001243 }
				texture {ros}}
			mesh { // leaf
				triangle { <-75.242, 90.3613, -40.739>, <-74.352, 91.8039, -41.2555>, <-74.2017, 91.7335, -40.6964> }
				triangle { <-74.352, 91.8039, -41.2555>, <-73.7215, 92.4668, -41.3112>, <-74.2017, 91.7335, -40.6964> }
				triangle { <-73.7215, 92.4668, -41.3112>, <-73.5497, 92.4073, -40.7085>, <-74.2017, 91.7335, -40.6964> }
				triangle { <-73.7215, 92.4668, -41.3112>, <-73.1188, 92.8301, -40.7194>, <-73.5497, 92.4073, -40.7085> }
				triangle { <-73.5497, 92.4073, -40.7085>, <-73.1188, 92.8301, -40.7194>, <-73.5454, 92.3167, -40.1749> }
				triangle { <-74.2017, 91.7335, -40.6964>, <-73.5497, 92.4073, -40.7085>, <-73.5454, 92.3167, -40.1749> }
				triangle { <-74.2017, 91.7335, -40.6964>, <-73.5454, 92.3167, -40.1749>, <-74.1764, 91.6539, -40.2329> }
				triangle { <-74.2017, 91.7335, -40.6964>, <-74.1764, 91.6539, -40.2329>, <-75.242, 90.3613, -40.739> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-75.2749, 90.3279, -40.7516>, <-75.06461, 90.4854, -40.4887>, 0.05575 }
				cylinder { <-75.06461, 90.4854, -40.4887>, <-74.8542, 90.6428, -40.2258>, 0.05575 }
				cylinder { <-74.8542, 90.6428, -40.2258>, <-74.6439, 90.8003, -39.9629>, 0.05575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-74.6439, 90.8003, -39.9629>, <-74.6365, 90.8042, -39.9486>, 0.001243 }
				cylinder { <-74.6365, 90.8042, -39.9486>, <-74.6317, 90.8049, -39.9327>, 0.001243 }
				cylinder { <-74.6317, 90.8049, -39.9327>, <-74.6297, 90.8021, -39.9165>, 0.001243 }
				texture {ros}}
			mesh { // leaf
				triangle { <-74.6297, 90.8021, -39.9165>, <-74.189, 91.05438, -38.2188>, <-74.5381, 90.5872, -38.21> }
				triangle { <-74.189, 91.05438, -38.2188>, <-74.01748, 90.9068, -37.3307>, <-74.5381, 90.5872, -38.21> }
				triangle { <-74.01748, 90.9068, -37.3307>, <-74.3937, 90.4028, -37.302>, <-74.5381, 90.5872, -38.21> }
				triangle { <-74.01748, 90.9068, -37.3307>, <-74.2891, 90.2739, -36.7215>, <-74.3937, 90.4028, -37.302> }
				triangle { <-74.3937, 90.4028, -37.302>, <-74.2891, 90.2739, -36.7215>, <-74.7918, 90.0452, -37.3825> }
				triangle { <-74.5381, 90.5872, -38.21>, <-74.3937, 90.4028, -37.302>, <-74.7918, 90.0452, -37.3825> }
				triangle { <-74.5381, 90.5872, -38.21>, <-74.7918, 90.0452, -37.3825>, <-74.8726, 90.2611, -38.2701> }
				triangle { <-74.5381, 90.5872, -38.21>, <-74.8726, 90.2611, -38.2701>, <-74.6297, 90.8021, -39.9165> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-74.6439, 90.8003, -39.9629>, <-74.6345, 90.8073, -39.9512>, 0.001243 }
				cylinder { <-74.6345, 90.8073, -39.9512>, <-74.6252, 90.8143, -39.9394>, 0.001243 }
				cylinder { <-74.6252, 90.8143, -39.9394>, <-74.6158, 90.8213, -39.9277>, 0.001243 }
				texture {ros}}
			mesh { // leaf
				triangle { <-74.6158, 90.8213, -39.9277>, <-73.5918, 91.9982, -39.08721>, <-73.7507, 91.6214, -38.6713> }
				triangle { <-73.5918, 91.9982, -39.08721>, <-73.02505, 92.3848, -38.4796>, <-73.7507, 91.6214, -38.6713> }
				triangle { <-73.02505, 92.3848, -38.4796>, <-73.188, 91.9893, -38.01777>, <-73.7507, 91.6214, -38.6713> }
				triangle { <-73.02505, 92.3848, -38.4796>, <-72.8145, 92.2154, -37.6007>, <-73.188, 91.9893, -38.01777> }
				triangle { <-73.188, 91.9893, -38.01777>, <-72.8145, 92.2154, -37.6007>, <-73.4588, 91.6513, -37.6932> }
				triangle { <-73.7507, 91.6214, -38.6713>, <-73.188, 91.9893, -38.01777>, <-73.4588, 91.6513, -37.6932> }
				triangle { <-73.7507, 91.6214, -38.6713>, <-73.4588, 91.6513, -37.6932>, <-73.9676, 91.3207, -38.3808> }
				triangle { <-73.7507, 91.6214, -38.6713>, <-73.9676, 91.3207, -38.3808>, <-74.6158, 90.8213, -39.9277> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-71.7379, 82.5288, -46.07545>, <-79.1055, 82.8011, -50.7321>, 0.1308 }
		cylinder { <-79.1055, 82.8011, -50.7321>, <-85.9897, 82.9423, -56.08266>, 0.1308 }
		cylinder { <-85.9897, 82.9423, -56.08266>, <-92.3242, 82.9511, -62.07552>, 0.1308 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-92.3242, 82.9511, -62.07552>, <-93.3166, 82.8518, -63.9023>, 0.1561 }
			cylinder { <-93.3166, 82.8518, -63.9023>, <-93.6894, 82.6613, -65.9411>, 0.1561 }
			cylinder { <-93.6894, 82.6613, -65.9411>, <-93.4048, 82.3988, -67.9862>, 0.1561 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-93.4048, 82.3988, -67.9862>, <-93.2625, 82.2675, -69.00871>, 0.1561 }
				cylinder { <-93.2625, 82.2675, -69.00871>, <-93.1202, 82.1362, -70.03123>, 0.1561 }
				cylinder { <-93.1202, 82.1362, -70.03123>, <-92.978, 82.00497, -71.05374>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.978, 82.00497, -71.05374>, <-92.9571, 82.02341, -71.1806>, 0.009747 }
				cylinder { <-92.9571, 82.02341, -71.1806>, <-92.9347, 82.07536, -71.2976>, 0.009747 }
				cylinder { <-92.9347, 82.07536, -71.2976>, <-92.9124, 82.157, -71.3962>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-92.9124, 82.157, -71.3962>, <-92.5599, 83.9393, -76.01324>, <-92.4561, 85.2608, -75.05944> }
				triangle { <-92.5599, 83.9393, -76.01324>, <-91.9936, 85.4406, -78.01588>, <-92.4561, 85.2608, -75.05944> }
				triangle { <-91.9936, 85.4406, -78.01588>, <-91.8822, 86.8978, -77.03021>, <-92.4561, 85.2608, -75.05944> }
				triangle { <-91.9936, 85.4406, -78.01588>, <-91.4694, 87.9462, -78.2905>, <-91.8822, 86.8978, -77.03021> }
				triangle { <-91.8822, 86.8978, -77.03021>, <-91.4694, 87.9462, -78.2905>, <-92.07503, 87.9491, -75.9559> }
				triangle { <-92.4561, 85.2608, -75.05944>, <-91.8822, 86.8978, -77.03021>, <-92.07503, 87.9491, -75.9559> }
				triangle { <-92.4561, 85.2608, -75.05944>, <-92.07503, 87.9491, -75.9559>, <-92.572, 86.201, -74.142> }
				triangle { <-92.4561, 85.2608, -75.05944>, <-92.572, 86.201, -74.142>, <-92.9124, 82.157, -71.3962> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-92.978, 82.00497, -71.05374>, <-92.8357, 81.8737, -72.07626>, 0.1561 }
				cylinder { <-92.8357, 81.8737, -72.07626>, <-92.6934, 81.7424, -73.09877>, 0.1561 }
				cylinder { <-92.6934, 81.7424, -73.09877>, <-92.5511, 81.6111, -74.1212>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.5511, 81.6111, -74.1212>, <-92.5377, 81.5611, -74.2404>, 0.009747 }
				cylinder { <-92.5377, 81.5611, -74.2404>, <-92.5296, 81.481, -74.3425>, 0.009747 }
				cylinder { <-92.5296, 81.481, -74.3425>, <-92.5275, 81.3767, -74.42>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-92.5275, 81.3767, -74.42>, <-93.2117, 76.7429, -76.05618>, <-92.8058, 77.589, -77.3926> }
				triangle { <-93.2117, 76.7429, -76.05618>, <-93.06785, 74.6036, -77.466>, <-92.8058, 77.589, -77.3926> }
				triangle { <-93.06785, 74.6036, -77.466>, <-92.6393, 75.4732, -78.9382>, <-92.8058, 77.589, -77.3926> }
				triangle { <-93.06785, 74.6036, -77.466>, <-92.4883, 74.1091, -79.9252>, <-92.6393, 75.4732, -78.9382> }
				triangle { <-92.6393, 75.4732, -78.9382>, <-92.4883, 74.1091, -79.9252>, <-92.5062, 76.5187, -80.02715> }
				triangle { <-92.8058, 77.589, -77.3926>, <-92.6393, 75.4732, -78.9382>, <-92.5062, 76.5187, -80.02715> }
				triangle { <-92.8058, 77.589, -77.3926>, <-92.5062, 76.5187, -80.02715>, <-92.6426, 78.4683, -78.3617> }
				triangle { <-92.8058, 77.589, -77.3926>, <-92.6426, 78.4683, -78.3617>, <-92.5275, 81.3767, -74.42> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-92.5511, 81.6111, -74.1212>, <-92.4088, 81.4798, -75.1438>, 0.1561 }
				cylinder { <-92.4088, 81.4798, -75.1438>, <-92.2665, 81.3485, -76.1663>, 0.1561 }
				cylinder { <-92.2665, 81.3485, -76.1663>, <-92.1243, 81.2173, -77.1888>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.1243, 81.2173, -77.1888>, <-92.1034, 81.2357, -77.3157>, 0.009747 }
				cylinder { <-92.1034, 81.2357, -77.3157>, <-92.08106, 81.2876, -77.4327>, 0.009747 }
				cylinder { <-92.08106, 81.2876, -77.4327>, <-92.05872, 81.3693, -77.5313>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-92.05872, 81.3693, -77.5313>, <-91.7062, 83.1517, -82.1483>, <-91.6025, 84.4731, -81.1945> }
				triangle { <-91.7062, 83.1517, -82.1483>, <-91.1399, 84.6529, -84.1509>, <-91.6025, 84.4731, -81.1945> }
				triangle { <-91.1399, 84.6529, -84.1509>, <-91.02859, 86.1101, -83.1653>, <-91.6025, 84.4731, -81.1945> }
				triangle { <-91.1399, 84.6529, -84.1509>, <-90.6157, 87.1585, -84.4256>, <-91.02859, 86.1101, -83.1653> }
				triangle { <-91.02859, 86.1101, -83.1653>, <-90.6157, 87.1585, -84.4256>, <-91.2213, 87.1614, -82.09101> }
				triangle { <-91.6025, 84.4731, -81.1945>, <-91.02859, 86.1101, -83.1653>, <-91.2213, 87.1614, -82.09101> }
				triangle { <-91.6025, 84.4731, -81.1945>, <-91.2213, 87.1614, -82.09101>, <-91.7183, 85.4133, -80.2771> }
				triangle { <-91.6025, 84.4731, -81.1945>, <-91.7183, 85.4133, -80.2771>, <-92.05872, 81.3693, -77.5313> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-92.1243, 81.2173, -77.1888>, <-92.1065, 81.2009, -77.3165>, 0.009747 }
				cylinder { <-92.1065, 81.2009, -77.3165>, <-92.08878, 81.1845, -77.4442>, 0.009747 }
				cylinder { <-92.08878, 81.1845, -77.4442>, <-92.07101, 81.1681, -77.5719>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-92.07101, 81.1681, -77.5719>, <-92.09008, 79.08018, -82.07274>, <-91.7759, 80.657, -82.3585> }
				triangle { <-92.09008, 79.08018, -82.07274>, <-91.6304, 78.6226, -84.5555>, <-91.7759, 80.657, -82.3585> }
				triangle { <-91.6304, 78.6226, -84.5555>, <-91.2943, 80.3149, -84.9167>, <-91.7759, 80.657, -82.3585> }
				triangle { <-91.6304, 78.6226, -84.5555>, <-90.9409, 80.09101, -86.5546>, <-91.2943, 80.3149, -84.9167> }
				triangle { <-91.2943, 80.3149, -84.9167>, <-90.9409, 80.09101, -86.5546>, <-91.2822, 81.8302, -84.9189> }
				triangle { <-91.7759, 80.657, -82.3585>, <-91.2943, 80.3149, -84.9167>, <-91.2822, 81.8302, -84.9189> }
				triangle { <-91.7759, 80.657, -82.3585>, <-91.2822, 81.8302, -84.9189>, <-91.7138, 81.9738, -82.3919> }
				triangle { <-91.7759, 80.657, -82.3585>, <-91.7138, 81.9738, -82.3919>, <-92.07101, 81.1681, -77.5719> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-92.3242, 82.9511, -62.07552>, <-95.1631, 82.9033, -64.653>, 0.05752 }
		cylinder { <-95.1631, 82.9033, -64.653>, <-98.05365, 82.8039, -67.1711>, 0.05752 }
		cylinder { <-98.05365, 82.8039, -67.1711>, <-100.994, 82.653, -69.6281>, 0.05752 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-100.994, 82.653, -69.6281>, <-101.8146, 82.4605, -69.9989>, 0.06906 }
			cylinder { <-101.8146, 82.4605, -69.9989>, <-102.667, 82.1313, -70.113>, 0.06906 }
			cylinder { <-102.667, 82.1313, -70.113>, <-103.465, 81.6984, -69.959>, 0.06906 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-103.465, 81.6984, -69.959>, <-103.864, 81.482, -69.8819>, 0.06906 }
				cylinder { <-103.864, 81.482, -69.8819>, <-104.2631, 81.2656, -69.8049>, 0.06906 }
				cylinder { <-104.2631, 81.2656, -69.8049>, <-104.6621, 81.04926, -69.7279>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-104.6621, 81.04926, -69.7279>, <-104.6808, 81.03207, -69.7265>, 0.001907 }
				cylinder { <-104.6808, 81.03207, -69.7265>, <-104.6948, 81.01088, -69.728>, 0.001907 }
				cylinder { <-104.6948, 81.01088, -69.728>, <-104.703, 80.9872, -69.7324>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-104.703, 80.9872, -69.7324>, <-106.0615, 79.2866, -70.01783>, <-105.4241, 79.05012, -70.2623> }
				triangle { <-106.0615, 79.2866, -70.01783>, <-106.4605, 78.2311, -70.1428>, <-105.4241, 79.05012, -70.2623> }
				triangle { <-106.4605, 78.2311, -70.1428>, <-105.7831, 77.9558, -70.4139>, <-105.4241, 79.05012, -70.2623> }
				triangle { <-106.4605, 78.2311, -70.1428>, <-106.0074, 77.2468, -70.4937>, <-105.7831, 77.9558, -70.4139> }
				triangle { <-105.7831, 77.9558, -70.4139>, <-106.0074, 77.2468, -70.4937>, <-105.186, 77.8919, -70.7122> }
				triangle { <-105.4241, 79.05012, -70.2623>, <-105.7831, 77.9558, -70.4139>, <-105.186, 77.8919, -70.7122> }
				triangle { <-105.4241, 79.05012, -70.2623>, <-105.186, 77.8919, -70.7122>, <-104.9005, 78.9723, -70.5075> }
				triangle { <-105.4241, 79.05012, -70.2623>, <-104.9005, 78.9723, -70.5075>, <-104.703, 80.9872, -69.7324> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-104.6621, 81.04926, -69.7279>, <-105.0611, 80.8328, -69.6508>, 0.06906 }
				cylinder { <-105.0611, 80.8328, -69.6508>, <-105.4601, 80.6164, -69.5738>, 0.06906 }
				cylinder { <-105.4601, 80.6164, -69.5738>, <-105.8592, 80.4, -69.4968>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-105.8592, 80.4, -69.4968>, <-105.883, 80.3941, -69.4899>, 0.001907 }
				cylinder { <-105.883, 80.3941, -69.4899>, <-105.9068, 80.3948, -69.4811>, 0.001907 }
				cylinder { <-105.9068, 80.3948, -69.4811>, <-105.9289, 80.402, -69.4708>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-105.9289, 80.402, -69.4708>, <-107.5501, 81.6809, -68.7258>, <-107.8445, 81.02224, -68.7642> }
				triangle { <-107.5501, 81.6809, -68.7258>, <-108.4973, 82.03471, -68.2094>, <-107.8445, 81.02224, -68.7642> }
				triangle { <-108.4973, 82.03471, -68.2094>, <-108.836, 81.3331, -68.2452>, <-107.8445, 81.02224, -68.7642> }
				triangle { <-108.4973, 82.03471, -68.2094>, <-109.467, 81.5274, -67.8938>, <-108.836, 81.3331, -68.2452> }
				triangle { <-108.836, 81.3331, -68.2452>, <-109.467, 81.5274, -67.8938>, <-109.0261, 80.7175, -68.4307> }
				triangle { <-107.8445, 81.02224, -68.7642>, <-108.836, 81.3331, -68.2452>, <-109.0261, 80.7175, -68.4307> }
				triangle { <-107.8445, 81.02224, -68.7642>, <-109.0261, 80.7175, -68.4307>, <-108.019, 80.4825, -68.9008> }
				triangle { <-107.8445, 81.02224, -68.7642>, <-108.019, 80.4825, -68.9008>, <-105.9289, 80.402, -69.4708> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-105.8592, 80.4, -69.4968>, <-106.2582, 80.1836, -69.4197>, 0.06906 }
				cylinder { <-106.2582, 80.1836, -69.4197>, <-106.6572, 79.9672, -69.3427>, 0.06906 }
				cylinder { <-106.6572, 79.9672, -69.3427>, <-107.0562, 79.7508, -69.2656>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-107.0562, 79.7508, -69.2656>, <-107.0749, 79.7336, -69.2643>, 0.001907 }
				cylinder { <-107.0749, 79.7336, -69.2643>, <-107.0889, 79.7124, -69.2658>, 0.001907 }
				cylinder { <-107.0889, 79.7124, -69.2658>, <-107.0972, 79.6887, -69.2702>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-107.0972, 79.6887, -69.2702>, <-108.4556, 77.9882, -69.5556>, <-107.8182, 77.7516, -69.8> }
				triangle { <-108.4556, 77.9882, -69.5556>, <-108.8546, 76.9327, -69.6806>, <-107.8182, 77.7516, -69.8> }
				triangle { <-108.8546, 76.9327, -69.6806>, <-108.1772, 76.6574, -69.9517>, <-107.8182, 77.7516, -69.8> }
				triangle { <-108.8546, 76.9327, -69.6806>, <-108.4015, 75.9483, -70.03152>, <-108.1772, 76.6574, -69.9517> }
				triangle { <-108.1772, 76.6574, -69.9517>, <-108.4015, 75.9483, -70.03152>, <-107.5801, 76.5935, -70.25> }
				triangle { <-107.8182, 77.7516, -69.8>, <-108.1772, 76.6574, -69.9517>, <-107.5801, 76.5935, -70.25> }
				triangle { <-107.8182, 77.7516, -69.8>, <-107.5801, 76.5935, -70.25>, <-107.2946, 77.6738, -70.04534> }
				triangle { <-107.8182, 77.7516, -69.8>, <-107.2946, 77.6738, -70.04534>, <-107.0972, 79.6887, -69.2702> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-107.0562, 79.7508, -69.2656>, <-107.0783, 79.7388, -69.2614>, 0.001907 }
				cylinder { <-107.0783, 79.7388, -69.2614>, <-107.1003, 79.7269, -69.2571>, 0.001907 }
				cylinder { <-107.1003, 79.7269, -69.2571>, <-107.1224, 79.7149, -69.2529>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-107.1224, 79.7149, -69.2529>, <-109.2503, 79.381, -68.8299>, <-109.0098, 78.7389, -69.0575> }
				triangle { <-109.2503, 79.381, -68.8299>, <-110.2346, 78.8792, -68.5685>, <-109.0098, 78.7389, -69.0575> }
				triangle { <-110.2346, 78.8792, -68.5685>, <-109.9972, 78.1779, -68.8135>, <-109.0098, 78.7389, -69.0575> }
				triangle { <-110.2346, 78.8792, -68.5685>, <-110.6256, 77.8117, -68.6389>, <-109.9972, 78.1779, -68.8135> }
				triangle { <-109.9972, 78.1779, -68.8135>, <-110.6256, 77.8117, -68.6389>, <-109.6939, 77.6781, -69.1418> }
				triangle { <-109.0098, 78.7389, -69.0575>, <-109.9972, 78.1779, -68.8135>, <-109.6939, 77.6781, -69.1418> }
				triangle { <-109.0098, 78.7389, -69.0575>, <-109.6939, 77.6781, -69.1418>, <-108.7526, 78.2876, -69.3231> }
				triangle { <-109.0098, 78.7389, -69.0575>, <-108.7526, 78.2876, -69.3231>, <-107.1224, 79.7149, -69.2529> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-100.994, 82.653, -69.6281>, <-102.1509, 82.7019, -70.6319>, 0.02298 }
		cylinder { <-102.1509, 82.7019, -70.6319>, <-103.2834, 82.8596, -71.6522>, 0.02298 }
		cylinder { <-103.2834, 82.8596, -71.6522>, <-104.3854, 83.1254, -72.6835>, 0.02298 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-104.3854, 83.1254, -72.6835>, <-104.6321, 83.3194, -72.9604>, 0.03138 }
			cylinder { <-104.6321, 83.3194, -72.9604>, <-104.7997, 83.615, -73.2046>, 0.03138 }
			cylinder { <-104.7997, 83.615, -73.2046>, <-104.8713, 83.9826, -73.3915>, 0.03138 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-104.8713, 83.9826, -73.3915>, <-104.9071, 84.1664, -73.485>, 0.03138 }
				cylinder { <-104.9071, 84.1664, -73.485>, <-104.9429, 84.3502, -73.5784>, 0.03138 }
				cylinder { <-104.9429, 84.3502, -73.5784>, <-104.9787, 84.5339, -73.6719>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-104.9787, 84.5339, -73.6719>, <-104.9804, 84.5387, -73.6731>, 0.0003941 }
				cylinder { <-104.9804, 84.5387, -73.6731>, <-104.9829, 84.5434, -73.6731>, 0.0003941 }
				cylinder { <-104.9829, 84.5434, -73.6731>, <-104.9859, 84.5475, -73.6719>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-104.9859, 84.5475, -73.6719>, <-105.5045, 85.394, -73.7718>, <-105.6007, 85.2731, -73.4821> }
				triangle { <-105.5045, 85.394, -73.7718>, <-105.7725, 85.8215, -73.6639>, <-105.6007, 85.2731, -73.4821> }
				triangle { <-105.7725, 85.8215, -73.6639>, <-105.8837, 85.6989, -73.3505>, <-105.6007, 85.2731, -73.4821> }
				triangle { <-105.7725, 85.8215, -73.6639>, <-106.0589, 85.9763, -73.2614>, <-105.8837, 85.6989, -73.3505> }
				triangle { <-105.8837, 85.6989, -73.3505>, <-106.0589, 85.9763, -73.2614>, <-105.9744, 85.5197, -73.1213> }
				triangle { <-105.6007, 85.2731, -73.4821>, <-105.8837, 85.6989, -73.3505>, <-105.9744, 85.5197, -73.1213> }
				triangle { <-105.6007, 85.2731, -73.4821>, <-105.9744, 85.5197, -73.1213>, <-105.6774, 85.1263, -73.275> }
				triangle { <-105.6007, 85.2731, -73.4821>, <-105.6774, 85.1263, -73.275>, <-104.9859, 84.5475, -73.6719> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-104.9787, 84.5339, -73.6719>, <-105.0144, 84.7177, -73.7653>, 0.03138 }
				cylinder { <-105.0144, 84.7177, -73.7653>, <-105.0502, 84.9015, -73.8588>, 0.03138 }
				cylinder { <-105.0502, 84.9015, -73.8588>, <-105.086, 85.08534, -73.9522>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-105.086, 85.08534, -73.9522>, <-105.086, 85.08944, -73.9555>, 0.0003941 }
				cylinder { <-105.086, 85.08944, -73.9555>, <-105.0851, 85.09272, -73.9595>, 0.0003941 }
				cylinder { <-105.0851, 85.09272, -73.9595>, <-105.0833, 85.09494, -73.9639>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-105.0833, 85.09494, -73.9639>, <-104.6674, 85.1982, -74.8649>, <-104.8217, 85.4835, -74.8131> }
				triangle { <-104.6674, 85.1982, -74.8649>, <-104.4608, 85.4059, -75.2897>, <-104.8217, 85.4835, -74.8131> }
				triangle { <-104.4608, 85.4059, -75.2897>, <-104.6249, 85.7167, -75.2439>, <-104.8217, 85.4835, -74.8131> }
				triangle { <-104.4608, 85.4059, -75.2897>, <-104.4916, 85.8704, -75.5163>, <-104.6249, 85.7167, -75.2439> }
				triangle { <-104.6249, 85.7167, -75.2439>, <-104.4916, 85.8704, -75.5163>, <-104.8245, 85.9346, -75.1695> }
				triangle { <-104.8217, 85.4835, -74.8131>, <-104.6249, 85.7167, -75.2439>, <-104.8245, 85.9346, -75.1695> }
				triangle { <-104.8217, 85.4835, -74.8131>, <-104.8245, 85.9346, -75.1695>, <-104.9865, 85.6813, -74.7498> }
				triangle { <-104.8217, 85.4835, -74.8131>, <-104.9865, 85.6813, -74.7498>, <-105.0833, 85.09494, -73.9639> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-105.086, 85.08534, -73.9522>, <-105.1218, 85.2691, -74.04573>, 0.03138 }
				cylinder { <-105.1218, 85.2691, -74.04573>, <-105.1576, 85.4529, -74.1391>, 0.03138 }
				cylinder { <-105.1576, 85.4529, -74.1391>, <-105.1933, 85.6367, -74.2326>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-105.1933, 85.6367, -74.2326>, <-105.1951, 85.6414, -74.2338>, 0.0003941 }
				cylinder { <-105.1951, 85.6414, -74.2338>, <-105.1976, 85.6461, -74.2338>, 0.0003941 }
				cylinder { <-105.1976, 85.6461, -74.2338>, <-105.2006, 85.6502, -74.2327>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-105.2006, 85.6502, -74.2327>, <-105.7191, 86.4967, -74.3325>, <-105.8154, 86.3758, -74.04282> }
				triangle { <-105.7191, 86.4967, -74.3325>, <-105.9872, 86.9242, -74.2246>, <-105.8154, 86.3758, -74.04282> }
				triangle { <-105.9872, 86.9242, -74.2246>, <-106.0984, 86.8016, -73.9112>, <-105.8154, 86.3758, -74.04282> }
				triangle { <-105.9872, 86.9242, -74.2246>, <-106.2736, 87.07901, -73.8221>, <-106.0984, 86.8016, -73.9112> }
				triangle { <-106.0984, 86.8016, -73.9112>, <-106.2736, 87.07901, -73.8221>, <-106.1891, 86.6224, -73.6821> }
				triangle { <-105.8154, 86.3758, -74.04282>, <-106.0984, 86.8016, -73.9112>, <-106.1891, 86.6224, -73.6821> }
				triangle { <-105.8154, 86.3758, -74.04282>, <-106.1891, 86.6224, -73.6821>, <-105.8921, 86.229, -73.8357> }
				triangle { <-105.8154, 86.3758, -74.04282>, <-105.8921, 86.229, -73.8357>, <-105.2006, 85.6502, -74.2327> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-105.1933, 85.6367, -74.2326>, <-105.1942, 85.6413, -74.2349>, 0.0003941 }
				cylinder { <-105.1942, 85.6413, -74.2349>, <-105.1951, 85.6459, -74.2373>, 0.0003941 }
				cylinder { <-105.1951, 85.6459, -74.2373>, <-105.196, 85.6505, -74.2396>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-105.196, 85.6505, -74.2396>, <-105.2362, 86.3576, -74.9423>, <-105.4264, 86.4721, -74.7005> }
				triangle { <-105.2362, 86.3576, -74.9423>, <-105.2893, 86.8136, -75.1779>, <-105.4264, 86.4721, -74.7005> }
				triangle { <-105.2893, 86.8136, -75.1779>, <-105.4975, 86.9455, -74.9232>, <-105.4264, 86.4721, -74.7005> }
				triangle { <-105.2893, 86.8136, -75.1779>, <-105.5364, 87.2534, -75.06184>, <-105.4975, 86.9455, -74.9232> }
				triangle { <-105.4975, 86.9455, -74.9232>, <-105.5364, 87.2534, -75.06184>, <-105.6994, 86.9781, -74.6973> }
				triangle { <-105.4264, 86.4721, -74.7005>, <-105.4975, 86.9455, -74.9232>, <-105.6994, 86.9781, -74.6973> }
				triangle { <-105.4264, 86.4721, -74.7005>, <-105.6994, 86.9781, -74.6973>, <-105.5973, 86.5114, -74.5015> }
				triangle { <-105.4264, 86.4721, -74.7005>, <-105.5973, 86.5114, -74.5015>, <-105.196, 85.6505, -74.2396> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <1.1715, 62.5311, -2.3117>, <0.5464, 78.6202, -3.0187>, 0.2417 }
		cylinder { <0.5464, 78.6202, -3.0187>, <0.1354, 94.7317, -2.9645>, 0.2417 }
		cylinder { <0.1354, 94.7317, -2.9645>, <-0.06043, 110.8267, -2.1492>, 0.2417 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.06043, 110.8267, -2.1492>, <0.3595, 116.1367, -0.1621>, 0.4263 }
			cylinder { <0.3595, 116.1367, -0.1621>, <1.2262, 120.5433, 3.3239>, 0.4263 }
			cylinder { <1.2262, 120.5433, 3.3239>, <2.4521, 123.6015, 7.957>, 0.4263 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.4521, 123.6015, 7.957>, <3.0651, 125.1307, 10.2735>, 0.4263 }
				cylinder { <3.0651, 125.1307, 10.2735>, <3.678, 126.6598, 12.5901>, 0.4263 }
				cylinder { <3.678, 126.6598, 12.5901>, <4.291, 128.1889, 14.9066>, 0.4263 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <4.291, 128.1889, 14.9066>, <4.2437, 128.685, 15.7384>, 0.07272 }
				cylinder { <4.2437, 128.685, 15.7384>, <3.9434, 129.1198, 16.5514>, 0.07272 }
				cylinder { <3.9434, 129.1198, 16.5514>, <3.4119, 129.4615, 17.2869>, 0.07272 }
				texture {ros}}
			mesh { // leaf
				triangle { <3.4119, 129.4615, 17.2869>, <-0.3324, 136.8562, 28.00923>, <-4.09704, 134.8835, 26.6551> }
				triangle { <-0.3324, 136.8562, 28.00923>, <-3.829, 139.1725, 33.6253>, <-4.09704, 134.8835, 26.6551> }
				triangle { <-3.829, 139.1725, 33.6253>, <-7.9666, 137.1211, 32.2631>, <-4.09704, 134.8835, 26.6551> }
				triangle { <-3.829, 139.1725, 33.6253>, <-10.4339, 138.4569, 35.9305>, <-7.9666, 137.1211, 32.2631> }
				triangle { <-7.9666, 137.1211, 32.2631>, <-10.4339, 138.4569, 35.9305>, <-11.09797, 135.5616, 30.05035> }
				triangle { <-4.09704, 134.8835, 26.6551>, <-7.9666, 137.1211, 32.2631>, <-11.09797, 135.5616, 30.05035> }
				triangle { <-4.09704, 134.8835, 26.6551>, <-11.09797, 135.5616, 30.05035>, <-6.874, 133.4487, 24.8653> }
				triangle { <-4.09704, 134.8835, 26.6551>, <-6.874, 133.4487, 24.8653>, <3.4119, 129.4615, 17.2869> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <4.291, 128.1889, 14.9066>, <4.9039, 129.718, 17.2232>, 0.4263 }
				cylinder { <4.9039, 129.718, 17.2232>, <5.5169, 131.2472, 19.5397>, 0.4263 }
				cylinder { <5.5169, 131.2472, 19.5397>, <6.1298, 132.7763, 21.8563>, 0.4263 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <6.1298, 132.7763, 21.8563>, <6.5802, 133.2856, 22.5476>, 0.07272 }
				cylinder { <6.5802, 133.2856, 22.5476>, <7.2391, 133.7457, 23.09019>, 0.07272 }
				cylinder { <7.2391, 133.7457, 23.09019>, <8.059, 134.1232, 23.4444>, 0.07272 }
				texture {ros}}
			mesh { // leaf
				triangle { <8.059, 134.1232, 23.4444>, <20.8098, 138.6672, 24.1051>, <18.9057, 140.1624, 27.8515> }
				triangle { <20.8098, 138.6672, 24.1051>, <26.9522, 140.9756, 26.5697>, <18.9057, 140.1624, 27.8515> }
				triangle { <26.9522, 140.9756, 26.5697>, <25.01931, 142.6641, 30.6436>, <18.9057, 140.1624, 27.8515> }
				triangle { <26.9522, 140.9756, 26.5697>, <28.9697, 144.1697, 32.5009>, <25.01931, 142.6641, 30.6436> }
				triangle { <25.01931, 142.6641, 30.6436>, <28.9697, 144.1697, 32.5009>, <22.4534, 144.2752, 33.4639> }
				triangle { <18.9057, 140.1624, 27.8515>, <25.01931, 142.6641, 30.6436>, <22.4534, 144.2752, 33.4639> }
				triangle { <18.9057, 140.1624, 27.8515>, <22.4534, 144.2752, 33.4639>, <16.772, 141.5058, 30.4238> }
				triangle { <18.9057, 140.1624, 27.8515>, <16.772, 141.5058, 30.4238>, <8.059, 134.1232, 23.4444> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <6.1298, 132.7763, 21.8563>, <6.7428, 134.3054, 24.1728>, 0.4263 }
				cylinder { <6.7428, 134.3054, 24.1728>, <7.3557, 135.8346, 26.4894>, 0.4263 }
				cylinder { <7.3557, 135.8346, 26.4894>, <7.9687, 137.3637, 28.8059>, 0.4263 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <7.9687, 137.3637, 28.8059>, <7.9214, 137.8598, 29.6377>, 0.07272 }
				cylinder { <7.9214, 137.8598, 29.6377>, <7.6211, 138.2945, 30.4507>, 0.07272 }
				cylinder { <7.6211, 138.2945, 30.4507>, <7.08963, 138.6363, 31.1862>, 0.07272 }
				texture {ros}}
			mesh { // leaf
				triangle { <7.08963, 138.6363, 31.1862>, <3.3452, 146.031, 41.9085>, <-0.4193, 144.0583, 40.5544> }
				triangle { <3.3452, 146.031, 41.9085>, <-0.1513, 148.3473, 47.5246>, <-0.4193, 144.0583, 40.5544> }
				triangle { <-0.1513, 148.3473, 47.5246>, <-4.2889, 146.2959, 46.1623>, <-0.4193, 144.0583, 40.5544> }
				triangle { <-0.1513, 148.3473, 47.5246>, <-6.7562, 147.6317, 49.8298>, <-4.2889, 146.2959, 46.1623> }
				triangle { <-4.2889, 146.2959, 46.1623>, <-6.7562, 147.6317, 49.8298>, <-7.4202, 144.7363, 43.9496> }
				triangle { <-0.4193, 144.0583, 40.5544>, <-4.2889, 146.2959, 46.1623>, <-7.4202, 144.7363, 43.9496> }
				triangle { <-0.4193, 144.0583, 40.5544>, <-7.4202, 144.7363, 43.9496>, <-3.1963, 142.6235, 38.7646> }
				triangle { <-0.4193, 144.0583, 40.5544>, <-3.1963, 142.6235, 38.7646>, <7.08963, 138.6363, 31.1862> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <7.9687, 137.3637, 28.8059>, <8.1778, 137.8853, 29.5961>, 0.07272 }
				cylinder { <8.1778, 137.8853, 29.5961>, <8.3868, 138.4069, 30.3863>, 0.07272 }
				cylinder { <8.3868, 138.4069, 30.3863>, <8.5959, 138.9285, 31.1765>, 0.07272 }
				texture {ros}}
			mesh { // leaf
				triangle { <8.5959, 138.9285, 31.1765>, <15.2292, 147.0678, 39.7451>, <11.0931, 146.851, 41.4012> }
				triangle { <15.2292, 147.0678, 39.7451>, <17.1221, 150.5507, 45.5259>, <11.0931, 146.851, 41.4012> }
				triangle { <17.1221, 150.5507, 45.5259>, <12.6946, 150.417, 47.4136>, <11.0931, 146.851, 41.4012> }
				triangle { <17.1221, 150.5507, 45.5259>, <13.7444, 152.6068, 51.3411>, <12.6946, 150.417, 47.4136> }
				triangle { <12.6946, 150.417, 47.4136>, <13.7444, 152.6068, 51.3411>, <8.589, 150.325, 47.9328> }
				triangle { <11.0931, 146.851, 41.4012>, <12.6946, 150.417, 47.4136>, <8.589, 150.325, 47.9328> }
				triangle { <11.0931, 146.851, 41.4012>, <8.589, 150.325, 47.9328>, <7.545, 146.72, 42.00794> }
				triangle { <11.0931, 146.851, 41.4012>, <7.545, 146.72, 42.00794>, <8.5959, 138.9285, 31.1765> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-0.06043, 110.8267, -2.1492>, <2.009206, 124.1366, 6.4368>, 0.2396 }
		cylinder { <2.009206, 124.1366, 6.4368>, <5.7537, 131.0172, 20.3577>, 0.2396 }
		cylinder { <5.7537, 131.0172, 20.3577>, <10.1076, 129.5106, 35.6525>, 0.2396 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <10.1076, 129.5106, 35.6525>, <11.2624, 127.7156, 39.578>, 0.3351 }
			cylinder { <11.2624, 127.7156, 39.578>, <12.2373, 124.7281, 42.7544>, 0.3351 }
			cylinder { <12.2373, 124.7281, 42.7544>, <12.9342, 120.8498, 44.861>, 0.3351 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <12.9342, 120.8498, 44.861>, <13.2826, 118.9106, 45.9143>, 0.3351 }
				cylinder { <13.2826, 118.9106, 45.9143>, <13.631, 116.9714, 46.9676>, 0.3351 }
				cylinder { <13.631, 116.9714, 46.9676>, <13.9794, 115.0323, 48.02099>, 0.3351 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <13.9794, 115.0323, 48.02099>, <13.9157, 114.5272, 48.3365>, 0.04492 }
				cylinder { <13.9157, 114.5272, 48.3365>, <13.6996, 114.0734, 48.6622>, 0.04492 }
				cylinder { <13.6996, 114.0734, 48.6622>, <13.3466, 113.7039, 48.9747>, 0.04492 }
				texture {ros}}
			mesh { // leaf
				triangle { <13.3466, 113.7039, 48.9747>, <10.2637, 105.9854, 55.636>, <7.34, 107.8168, 55.01309> }
				triangle { <10.2637, 105.9854, 55.636>, <7.1732, 102.298, 58.3194>, <7.34, 107.8168, 55.01309> }
				triangle { <7.1732, 102.298, 58.3194>, <3.9624, 104.2105, 57.7249>, <7.34, 107.8168, 55.01309> }
				triangle { <7.1732, 102.298, 58.3194>, <1.7696, 101.8447, 59.3879>, <3.9624, 104.2105, 57.7249> }
				triangle { <3.9624, 104.2105, 57.7249>, <1.7696, 101.8447, 59.3879>, <1.7616, 106.5575, 57.2436> }
				triangle { <7.34, 107.8168, 55.01309>, <3.9624, 104.2105, 57.7249>, <1.7616, 106.5575, 57.2436> }
				triangle { <7.34, 107.8168, 55.01309>, <1.7616, 106.5575, 57.2436>, <5.3424, 109.7689, 54.5512> }
				triangle { <7.34, 107.8168, 55.01309>, <5.3424, 109.7689, 54.5512>, <13.3466, 113.7039, 48.9747> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <13.9794, 115.0323, 48.02099>, <14.3278, 113.0931, 49.0743>, 0.3351 }
				cylinder { <14.3278, 113.0931, 49.0743>, <14.6762, 111.1539, 50.1276>, 0.3351 }
				cylinder { <14.6762, 111.1539, 50.1276>, <15.02466, 109.2148, 51.1809>, 0.3351 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <15.02466, 109.2148, 51.1809>, <15.2683, 108.7178, 51.4097>, 0.04492 }
				cylinder { <15.2683, 108.7178, 51.4097>, <15.6447, 108.2797, 51.5683>, 0.04492 }
				cylinder { <15.6447, 108.2797, 51.5683>, <16.1265, 107.9323, 51.6453>, 0.04492 }
				texture {ros}}
			mesh { // leaf
				triangle { <16.1265, 107.9323, 51.6453>, <26.2976, 104.7979, 52.06618>, <24.5347, 102.2573, 53.7179> }
				triangle { <26.2976, 104.7979, 52.06618>, <30.8059, 101.6501, 52.406>, <24.5347, 102.2573, 53.7179> }
				triangle { <30.8059, 101.6501, 52.406>, <29.00331, 98.8585, 54.2167>, <24.5347, 102.2573, 53.7179> }
				triangle { <30.8059, 101.6501, 52.406>, <31.8545, 96.6261, 54.457>, <29.00331, 98.8585, 54.2167> }
				triangle { <29.00331, 98.8585, 54.2167>, <31.8545, 96.6261, 54.457>, <26.9688, 97.1459, 56.09051> }
				triangle { <24.5347, 102.2573, 53.7179>, <29.00331, 98.8585, 54.2167>, <26.9688, 97.1459, 56.09051> }
				triangle { <24.5347, 102.2573, 53.7179>, <26.9688, 97.1459, 56.09051>, <22.7994, 100.6603, 55.2839> }
				triangle { <24.5347, 102.2573, 53.7179>, <22.7994, 100.6603, 55.2839>, <16.1265, 107.9323, 51.6453> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <15.02466, 109.2148, 51.1809>, <15.373, 107.2756, 52.2342>, 0.3351 }
				cylinder { <15.373, 107.2756, 52.2342>, <15.7214, 105.3364, 53.2875>, 0.3351 }
				cylinder { <15.7214, 105.3364, 53.2875>, <16.06989, 103.3973, 54.3408>, 0.3351 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <16.06989, 103.3973, 54.3408>, <16.00621, 102.8922, 54.6563>, 0.04492 }
				cylinder { <16.00621, 102.8922, 54.6563>, <15.79, 102.4384, 54.9821>, 0.04492 }
				cylinder { <15.79, 102.4384, 54.9821>, <15.4371, 102.0689, 55.2946>, 0.04492 }
				texture {ros}}
			mesh { // leaf
				triangle { <15.4371, 102.0689, 55.2946>, <12.3542, 94.3504, 61.9559>, <9.4304, 96.1818, 61.3329> }
				triangle { <12.3542, 94.3504, 61.9559>, <9.2637, 90.663, 64.6392>, <9.4304, 96.1818, 61.3329> }
				triangle { <9.2637, 90.663, 64.6392>, <6.05286, 92.5755, 64.04486>, <9.4304, 96.1818, 61.3329> }
				triangle { <9.2637, 90.663, 64.6392>, <3.8601, 90.2096, 65.7078>, <6.05286, 92.5755, 64.04486> }
				triangle { <6.05286, 92.5755, 64.04486>, <3.8601, 90.2096, 65.7078>, <3.852, 94.9224, 63.5635> }
				triangle { <9.4304, 96.1818, 61.3329>, <6.05286, 92.5755, 64.04486>, <3.852, 94.9224, 63.5635> }
				triangle { <9.4304, 96.1818, 61.3329>, <3.852, 94.9224, 63.5635>, <7.4329, 98.1339, 60.8711> }
				triangle { <9.4304, 96.1818, 61.3329>, <7.4329, 98.1339, 60.8711>, <15.4371, 102.0689, 55.2946> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <16.06989, 103.3973, 54.3408>, <16.1633, 102.8774, 54.6232>, 0.04492 }
				cylinder { <16.1633, 102.8774, 54.6232>, <16.2567, 102.3575, 54.9056>, 0.04492 }
				cylinder { <16.2567, 102.3575, 54.9056>, <16.3501, 101.8377, 55.188>, 0.04492 }
				texture {ros}}
			mesh { // leaf
				triangle { <16.3501, 101.8377, 55.188>, <21.3819, 93.7285, 59.9183>, <18.01059, 93.2741, 60.7655> }
				triangle { <21.3819, 93.7285, 59.9183>, <22.437, 88.8321, 62.2117>, <18.01059, 93.2741, 60.7655> }
				triangle { <22.437, 88.8321, 62.2117>, <18.8286, 88.2545, 63.1949>, <18.01059, 93.2741, 60.7655> }
				triangle { <22.437, 88.8321, 62.2117>, <19.3331, 84.9801, 64.6764>, <18.8286, 88.2545, 63.1949> }
				triangle { <18.8286, 88.2545, 63.1949>, <19.3331, 84.9801, 64.6764>, <15.7305, 88.6546, 64.1034> }
				triangle { <18.01059, 93.2741, 60.7655>, <18.8286, 88.2545, 63.1949>, <15.7305, 88.6546, 64.1034> }
				triangle { <18.01059, 93.2741, 60.7655>, <15.7305, 88.6546, 64.1034>, <15.2903, 93.5017, 61.5156> }
				triangle { <18.01059, 93.2741, 60.7655>, <15.2903, 93.5017, 61.5156>, <16.3501, 101.8377, 55.188> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <10.1076, 129.5106, 35.6525>, <10.6379, 128.227, 37.4122>, 0.03362 }
		cylinder { <10.6379, 128.227, 37.4122>, <10.9497, 126.2047, 38.3278>, 0.03362 }
		cylinder { <10.9497, 126.2047, 38.3278>, <10.962, 123.9693, 38.1616>, 0.03362 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <10.962, 123.9693, 38.1616>, <10.9151, 123.4293, 37.9448>, 0.04378 }
			cylinder { <10.9151, 123.4293, 37.9448>, <10.8229, 122.986, 37.5763>, 0.04378 }
			cylinder { <10.8229, 122.986, 37.5763>, <10.6947, 122.6841, 37.09342>, 0.04378 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <10.6947, 122.6841, 37.09342>, <10.6306, 122.5332, 36.8519>, 0.04378 }
				cylinder { <10.6306, 122.5332, 36.8519>, <10.5664, 122.3823, 36.6104>, 0.04378 }
				cylinder { <10.5664, 122.3823, 36.6104>, <10.5023, 122.2313, 36.369>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <10.5023, 122.2313, 36.369>, <10.4975, 122.2262, 36.3616>, 0.0007667 }
				cylinder { <10.4975, 122.2262, 36.3616>, <10.4906, 122.2215, 36.3557>, 0.0007667 }
				cylinder { <10.4906, 122.2215, 36.3557>, <10.4819, 122.2177, 36.3519>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <10.4819, 122.2177, 36.3519>, <9.6111, 121.449, 35.5855>, <9.3461, 121.6283, 35.9132> }
				triangle { <9.6111, 121.449, 35.5855>, <9.01407, 121.1972, 35.2723>, <9.3461, 121.6283, 35.9132> }
				triangle { <9.01407, 121.1972, 35.2723>, <8.7165, 121.3825, 35.621>, <9.3461, 121.6283, 35.9132> }
				triangle { <9.01407, 121.1972, 35.2723>, <8.3097, 121.2351, 35.4269>, <8.7165, 121.3825, 35.621> }
				triangle { <8.7165, 121.3825, 35.621>, <8.3097, 121.2351, 35.4269>, <8.5547, 121.5222, 35.9883> }
				triangle { <9.3461, 121.6283, 35.9132>, <8.7165, 121.3825, 35.621>, <8.5547, 121.5222, 35.9883> }
				triangle { <9.3461, 121.6283, 35.9132>, <8.5547, 121.5222, 35.9883>, <9.1931, 121.7578, 36.2241> }
				triangle { <9.3461, 121.6283, 35.9132>, <9.1931, 121.7578, 36.2241>, <10.4819, 122.2177, 36.3519> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <10.5023, 122.2313, 36.369>, <10.4382, 122.0804, 36.1275>, 0.04378 }
				cylinder { <10.4382, 122.0804, 36.1275>, <10.3741, 121.9295, 35.8861>, 0.04378 }
				cylinder { <10.3741, 121.9295, 35.8861>, <10.31, 121.7785, 35.6446>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <10.31, 121.7785, 35.6446>, <10.3104, 121.7735, 35.6357>, 0.0007667 }
				cylinder { <10.3104, 121.7735, 35.6357>, <10.3136, 121.7691, 35.627>, 0.0007667 }
				cylinder { <10.3136, 121.7691, 35.627>, <10.3191, 121.7656, 35.6192>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <10.3191, 121.7656, 35.6192>, <11.4182, 121.3733, 34.8611>, <11.05717, 121.2129, 34.6294> }
				triangle { <11.4182, 121.3733, 34.8611>, <11.8329, 121.1742, 34.3076>, <11.05717, 121.2129, 34.6294> }
				triangle { <11.8329, 121.1742, 34.3076>, <11.4526, 120.9942, 34.04805>, <11.05717, 121.2129, 34.6294> }
				triangle { <11.8329, 121.1742, 34.3076>, <11.7048, 120.8643, 33.6681>, <11.4526, 120.9942, 34.04805> }
				triangle { <11.4526, 120.9942, 34.04805>, <11.7048, 120.8643, 33.6681>, <11.08394, 120.8172, 33.9324> }
				triangle { <11.05717, 121.2129, 34.6294>, <11.4526, 120.9942, 34.04805>, <11.08394, 120.8172, 33.9324> }
				triangle { <11.05717, 121.2129, 34.6294>, <11.08394, 120.8172, 33.9324>, <10.7383, 121.0656, 34.5133> }
				triangle { <11.05717, 121.2129, 34.6294>, <10.7383, 121.0656, 34.5133>, <10.3191, 121.7656, 35.6192> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <10.31, 121.7785, 35.6446>, <10.2459, 121.6276, 35.4031>, 0.04378 }
				cylinder { <10.2459, 121.6276, 35.4031>, <10.1818, 121.4767, 35.1617>, 0.04378 }
				cylinder { <10.1818, 121.4767, 35.1617>, <10.1176, 121.3257, 34.9202>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <10.1176, 121.3257, 34.9202>, <10.1129, 121.3206, 34.9128>, 0.0007667 }
				cylinder { <10.1129, 121.3206, 34.9128>, <10.1059, 121.3159, 34.907>, 0.0007667 }
				cylinder { <10.1059, 121.3159, 34.907>, <10.09724, 121.3121, 34.9031>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <10.09724, 121.3121, 34.9031>, <9.2264, 120.5434, 34.1367>, <8.9614, 120.7227, 34.4644> }
				triangle { <9.2264, 120.5434, 34.1367>, <8.6293, 120.2916, 33.8235>, <8.9614, 120.7227, 34.4644> }
				triangle { <8.6293, 120.2916, 33.8235>, <8.3318, 120.4769, 34.1722>, <8.9614, 120.7227, 34.4644> }
				triangle { <8.6293, 120.2916, 33.8235>, <7.925, 120.3295, 33.9782>, <8.3318, 120.4769, 34.1722> }
				triangle { <8.3318, 120.4769, 34.1722>, <7.925, 120.3295, 33.9782>, <8.17, 120.6167, 34.5395> }
				triangle { <8.9614, 120.7227, 34.4644>, <8.3318, 120.4769, 34.1722>, <8.17, 120.6167, 34.5395> }
				triangle { <8.9614, 120.7227, 34.4644>, <8.17, 120.6167, 34.5395>, <8.8085, 120.8522, 34.7753> }
				triangle { <8.9614, 120.7227, 34.4644>, <8.8085, 120.8522, 34.7753>, <10.09724, 121.3121, 34.9031> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <10.1176, 121.3257, 34.9202>, <10.1154, 121.3204, 34.9118>, 0.0007667 }
				cylinder { <10.1154, 121.3204, 34.9118>, <10.1131, 121.3152, 34.9033>, 0.0007667 }
				cylinder { <10.1131, 121.3152, 34.9033>, <10.1109, 121.3099, 34.8948>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <10.1109, 121.3099, 34.8948>, <10.2662, 120.522, 33.7584>, <9.8148, 120.5222, 33.8357> }
				triangle { <10.2662, 120.522, 33.7584>, <10.1366, 120.1815, 33.1376>, <9.8148, 120.5222, 33.8357> }
				triangle { <10.1366, 120.1815, 33.1376>, <9.6476, 120.1719, 33.21>, <9.8148, 120.5222, 33.8357> }
				triangle { <10.1366, 120.1815, 33.1376>, <9.5381, 119.9573, 32.8016>, <9.6476, 120.1719, 33.21> }
				triangle { <9.6476, 120.1719, 33.21>, <9.5381, 119.9573, 32.8016>, <9.2604, 120.1584, 33.3848> }
				triangle { <9.8148, 120.5222, 33.8357>, <9.6476, 120.1719, 33.21>, <9.2604, 120.1584, 33.3848> }
				triangle { <9.8148, 120.5222, 33.8357>, <9.2604, 120.1584, 33.3848>, <9.4715, 120.516, 33.9731> }
				triangle { <9.8148, 120.5222, 33.8357>, <9.4715, 120.516, 33.9731>, <10.1109, 121.3099, 34.8948> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <10.1076, 129.5106, 35.6525>, <13.664, 129.0813, 46.1938>, 0.1669 }
		cylinder { <13.664, 129.0813, 46.1938>, <17.7227, 129.2752, 56.5591>, 0.1669 }
		cylinder { <17.7227, 129.2752, 56.5591>, <22.2619, 130.0911, 66.6922>, 0.1669 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <22.2619, 130.0911, 66.6922>, <23.7983, 130.9238, 68.7667>, 0.2034 }
			cylinder { <23.7983, 130.9238, 68.7667>, <25.6102, 132.3064, 70.2374>, 0.2034 }
			cylinder { <25.6102, 132.3064, 70.2374>, <27.5146, 134.0992, 70.956>, 0.2034 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <27.5146, 134.0992, 70.956>, <28.4667, 134.9956, 71.3153>, 0.2034 }
				cylinder { <28.4667, 134.9956, 71.3153>, <29.4189, 135.892, 71.6746>, 0.2034 }
				cylinder { <29.4189, 135.892, 71.6746>, <30.3711, 136.7885, 72.03388>, 0.2034 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <30.3711, 136.7885, 72.03388>, <30.5624, 136.8908, 72.07454>, 0.01655 }
				cylinder { <30.5624, 136.8908, 72.07454>, <30.7761, 136.9423, 72.09443>, 0.01655 }
				cylinder { <30.7761, 136.9423, 72.09443>, <30.9968, 136.9391, 72.09212>, 0.01655 }
				texture {ros}}
			mesh { // leaf
				triangle { <30.9968, 136.9391, 72.09212>, <37.1371, 138.4901, 73.3958>, <37.2621, 136.5886, 72.4483> }
				triangle { <37.1371, 138.4901, 73.3958>, <40.475, 138.6533, 73.2712>, <37.2621, 136.5886, 72.4483> }
				triangle { <40.475, 138.6533, 73.2712>, <40.6785, 136.5998, 72.2617>, <37.2621, 136.5886, 72.4483> }
				triangle { <40.475, 138.6533, 73.2712>, <42.8745, 136.6288, 72.08791>, <40.6785, 136.5998, 72.2617> }
				triangle { <40.6785, 136.5998, 72.2617>, <42.8745, 136.6288, 72.08791>, <40.401, 134.7327, 71.6812> }
				triangle { <37.2621, 136.5886, 72.4483>, <40.6785, 136.5998, 72.2617>, <40.401, 134.7327, 71.6812> }
				triangle { <37.2621, 136.5886, 72.4483>, <40.401, 134.7327, 71.6812>, <37.0699, 134.977, 71.8833> }
				triangle { <37.2621, 136.5886, 72.4483>, <37.0699, 134.977, 71.8833>, <30.9968, 136.9391, 72.09212> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <30.3711, 136.7885, 72.03388>, <31.3233, 137.6849, 72.3931>, 0.2034 }
				cylinder { <31.3233, 137.6849, 72.3931>, <32.2755, 138.5813, 72.7524>, 0.2034 }
				cylinder { <32.2755, 138.5813, 72.7524>, <33.2277, 139.4777, 73.1117>, 0.2034 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <33.2277, 139.4777, 73.1117>, <33.3351, 139.6566, 73.1837>, 0.01655 }
				cylinder { <33.3351, 139.6566, 73.1837>, <33.3872, 139.8554, 73.2642>, 0.01655 }
				cylinder { <33.3872, 139.8554, 73.2642>, <33.3802, 140.0598, 73.3471>, 0.01655 }
				texture {ros}}
			mesh { // leaf
				triangle { <33.3802, 140.0598, 73.3471>, <31.1568, 145.4046, 76.2277>, <33.2656, 145.6819, 76.1549> }
				triangle { <31.1568, 145.4046, 76.2277>, <30.8881, 148.5507, 77.3294>, <33.2656, 145.6819, 76.1549> }
				triangle { <30.8881, 148.5507, 77.3294>, <33.157, 148.9083, 77.2885>, <33.2656, 145.6819, 76.1549> }
				triangle { <30.8881, 148.5507, 77.3294>, <33.0869, 151.0043, 77.9634>, <33.157, 148.9083, 77.2885> }
				triangle { <33.157, 148.9083, 77.2885>, <33.0869, 151.0043, 77.9634>, <35.1173, 148.6813, 77.3631> }
				triangle { <33.2656, 145.6819, 76.1549>, <33.157, 148.9083, 77.2885>, <35.1173, 148.6813, 77.3631> }
				triangle { <33.2656, 145.6819, 76.1549>, <35.1173, 148.6813, 77.3631>, <34.9791, 145.5533, 76.1828> }
				triangle { <33.2656, 145.6819, 76.1549>, <34.9791, 145.5533, 76.1828>, <33.3802, 140.0598, 73.3471> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <33.2277, 139.4777, 73.1117>, <34.1798, 140.3742, 73.471>, 0.2034 }
				cylinder { <34.1798, 140.3742, 73.471>, <35.132, 141.2706, 73.8303>, 0.2034 }
				cylinder { <35.132, 141.2706, 73.8303>, <36.08427, 142.167, 74.1895>, 0.2034 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <36.08427, 142.167, 74.1895>, <36.2755, 142.2694, 74.2302>, 0.01655 }
				cylinder { <36.2755, 142.2694, 74.2302>, <36.4892, 142.3208, 74.2501>, 0.01655 }
				cylinder { <36.4892, 142.3208, 74.2501>, <36.7099, 142.3176, 74.2478>, 0.01655 }
				texture {ros}}
			mesh { // leaf
				triangle { <36.7099, 142.3176, 74.2478>, <42.8502, 143.8686, 75.5515>, <42.9752, 141.9671, 74.604> }
				triangle { <42.8502, 143.8686, 75.5515>, <46.1881, 144.0318, 75.4269>, <42.9752, 141.9671, 74.604> }
				triangle { <46.1881, 144.0318, 75.4269>, <46.3916, 141.9783, 74.4174>, <42.9752, 141.9671, 74.604> }
				triangle { <46.1881, 144.0318, 75.4269>, <48.5877, 142.0074, 74.2436>, <46.3916, 141.9783, 74.4174> }
				triangle { <46.3916, 141.9783, 74.4174>, <48.5877, 142.0074, 74.2436>, <46.1141, 140.1112, 73.8369> }
				triangle { <42.9752, 141.9671, 74.604>, <46.3916, 141.9783, 74.4174>, <46.1141, 140.1112, 73.8369> }
				triangle { <42.9752, 141.9671, 74.604>, <46.1141, 140.1112, 73.8369>, <42.783, 140.3556, 74.03905> }
				triangle { <42.9752, 141.9671, 74.604>, <42.783, 140.3556, 74.03905>, <36.7099, 142.3176, 74.2478> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <36.08427, 142.167, 74.1895>, <36.2392, 142.3129, 74.248>, 0.01655 }
				cylinder { <36.2392, 142.3129, 74.248>, <36.3942, 142.4588, 74.3065>, 0.01655 }
				cylinder { <36.3942, 142.4588, 74.3065>, <36.5491, 142.6047, 74.365>, 0.01655 }
				texture {ros}}
			mesh { // leaf
				triangle { <36.5491, 142.6047, 74.365>, <39.3881, 147.7152, 77.1275>, <41.00826, 146.5098, 76.4556> }
				triangle { <39.3881, 147.7152, 77.1275>, <41.6139, 150.0872, 77.9039>, <41.00826, 146.5098, 76.4556> }
				triangle { <41.6139, 150.0872, 77.9039>, <43.407, 148.83, 77.2101>, <41.00826, 146.5098, 76.4556> }
				triangle { <41.6139, 150.0872, 77.9039>, <44.9489, 150.3433, 77.6414>, <43.407, 148.83, 77.2101> }
				triangle { <43.407, 148.83, 77.2101>, <44.9489, 150.3433, 77.6414>, <44.627, 147.339, 76.7755> }
				triangle { <41.00826, 146.5098, 76.4556>, <43.407, 148.83, 77.2101>, <44.627, 147.339, 76.7755> }
				triangle { <41.00826, 146.5098, 76.4556>, <44.627, 147.339, 76.7755>, <42.1111, 145.2618, 76.03218> }
				triangle { <41.00826, 146.5098, 76.4556>, <42.1111, 145.2618, 76.03218>, <36.5491, 142.6047, 74.365> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <22.2619, 130.0911, 66.6922>, <24.09234, 130.4294, 71.3788>, 0.07563 }
		cylinder { <24.09234, 130.4294, 71.3788>, <25.6927, 130.7356, 76.1509>, 0.07563 }
		cylinder { <25.6927, 130.7356, 76.1509>, <27.05922, 131.0089, 80.9971>, 0.07563 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <27.05922, 131.0089, 80.9971>, <27.00937, 131.0203, 82.2048>, 0.09065 }
			cylinder { <27.00937, 131.0203, 82.2048>, <26.5871, 130.9765, 83.3365>, 0.09065 }
			cylinder { <26.5871, 130.9765, 83.3365>, <25.8351, 130.8817, 84.2781>, 0.09065 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <25.8351, 130.8817, 84.2781>, <25.4591, 130.8344, 84.7489>, 0.09065 }
				cylinder { <25.4591, 130.8344, 84.7489>, <25.08318, 130.787, 85.2197>, 0.09065 }
				cylinder { <25.08318, 130.787, 85.2197>, <24.7071, 130.7397, 85.6905>, 0.09065 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <24.7071, 130.7397, 85.6905>, <24.6792, 130.748, 85.7232>, 0.003287 }
				cylinder { <24.6792, 130.748, 85.7232>, <24.6526, 130.7673, 85.7521>, 0.003287 }
				cylinder { <24.6526, 130.7673, 85.7521>, <24.6292, 130.7963, 85.7752>, 0.003287 }
				texture {ros}}
			mesh { // leaf
				triangle { <24.6292, 130.7963, 85.7752>, <23.08406, 131.9637, 87.9088>, <23.3209, 132.6997, 87.3596> }
				triangle { <23.08406, 131.9637, 87.9088>, <22.2101, 132.8864, 88.6871>, <23.3209, 132.6997, 87.3596> }
				triangle { <22.2101, 132.8864, 88.6871>, <22.4532, 133.7, 88.1154>, <23.3209, 132.6997, 87.3596> }
				triangle { <22.2101, 132.8864, 88.6871>, <21.8754, 134.34, 88.585>, <22.4532, 133.7, 88.1154> }
				triangle { <22.4532, 133.7, 88.1154>, <21.8754, 134.34, 88.585>, <22.8728, 134.2799, 87.6034> }
				triangle { <23.3209, 132.6997, 87.3596>, <22.4532, 133.7, 88.1154>, <22.8728, 134.2799, 87.6034> }
				triangle { <23.3209, 132.6997, 87.3596>, <22.8728, 134.2799, 87.6034>, <23.6551, 133.2188, 86.9065> }
				triangle { <23.3209, 132.6997, 87.3596>, <23.6551, 133.2188, 86.9065>, <24.6292, 130.7963, 85.7752> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <24.7071, 130.7397, 85.6905>, <24.3312, 130.6924, 86.1612>, 0.09065 }
				cylinder { <24.3312, 130.6924, 86.1612>, <23.9552, 130.645, 86.632>, 0.09065 }
				cylinder { <23.9552, 130.645, 86.632>, <23.5792, 130.5977, 87.1028>, 0.09065 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <23.5792, 130.5977, 87.1028>, <23.5546, 130.5828, 87.1359>, 0.003287 }
				cylinder { <23.5546, 130.5828, 87.1359>, <23.5344, 130.5575, 87.1655>, 0.003287 }
				cylinder { <23.5344, 130.5575, 87.1655>, <23.5202, 130.5238, 87.1896>, 0.003287 }
				texture {ros}}
			mesh { // leaf
				triangle { <23.5202, 130.5238, 87.1896>, <23.3582, 127.896, 88.3604>, <22.7606, 128.4211, 88.8767> }
				triangle { <23.3582, 127.896, 88.3604>, <22.8593, 126.696, 89.0899>, <22.7606, 128.4211, 88.8767> }
				triangle { <22.8593, 126.696, 89.0899>, <22.21, 127.2385, 89.6662>, <22.7606, 128.4211, 88.8767> }
				triangle { <22.8593, 126.696, 89.0899>, <21.8361, 126.4752, 90.1574>, <22.21, 127.2385, 89.6662> }
				triangle { <22.21, 127.2385, 89.6662>, <21.8361, 126.4752, 90.1574>, <21.8228, 127.8756, 90.1338> }
				triangle { <22.7606, 128.4211, 88.8767>, <22.21, 127.2385, 89.6662>, <21.8228, 127.8756, 90.1338> }
				triangle { <22.7606, 128.4211, 88.8767>, <21.8228, 127.8756, 90.1338>, <22.3935, 128.9577, 89.2813> }
				triangle { <22.7606, 128.4211, 88.8767>, <22.3935, 128.9577, 89.2813>, <23.5202, 130.5238, 87.1896> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <23.5792, 130.5977, 87.1028>, <23.2032, 130.5503, 87.5736>, 0.09065 }
				cylinder { <23.2032, 130.5503, 87.5736>, <22.8272, 130.503, 88.04443>, 0.09065 }
				cylinder { <22.8272, 130.503, 88.04443>, <22.4512, 130.4556, 88.5152>, 0.09065 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <22.4512, 130.4556, 88.5152>, <22.4232, 130.4639, 88.5479>, 0.003287 }
				cylinder { <22.4232, 130.4639, 88.5479>, <22.3966, 130.4832, 88.5768>, 0.003287 }
				cylinder { <22.3966, 130.4832, 88.5768>, <22.3732, 130.5123, 88.5999>, 0.003287 }
				texture {ros}}
			mesh { // leaf
				triangle { <22.3732, 130.5123, 88.5999>, <20.8281, 131.6796, 90.7335>, <21.06499, 132.4156, 90.1843> }
				triangle { <20.8281, 131.6796, 90.7335>, <19.9542, 132.6023, 91.5118>, <21.06499, 132.4156, 90.1843> }
				triangle { <19.9542, 132.6023, 91.5118>, <20.1972, 133.4159, 90.9401>, <21.06499, 132.4156, 90.1843> }
				triangle { <19.9542, 132.6023, 91.5118>, <19.6195, 134.0559, 91.4097>, <20.1972, 133.4159, 90.9401> }
				triangle { <20.1972, 133.4159, 90.9401>, <19.6195, 134.0559, 91.4097>, <20.6169, 133.9958, 90.4281> }
				triangle { <21.06499, 132.4156, 90.1843>, <20.1972, 133.4159, 90.9401>, <20.6169, 133.9958, 90.4281> }
				triangle { <21.06499, 132.4156, 90.1843>, <20.6169, 133.9958, 90.4281>, <21.3991, 132.9347, 89.7313> }
				triangle { <21.06499, 132.4156, 90.1843>, <21.3991, 132.9347, 89.7313>, <22.3732, 130.5123, 88.5999> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <22.4512, 130.4556, 88.5152>, <22.4239, 130.4522, 88.5493>, 0.003287 }
				cylinder { <22.4239, 130.4522, 88.5493>, <22.3967, 130.4487, 88.5835>, 0.003287 }
				cylinder { <22.3967, 130.4487, 88.5835>, <22.3694, 130.4453, 88.6176>, 0.003287 }
				texture {ros}}
			mesh { // leaf
				triangle { <22.3694, 130.4453, 88.6176>, <21.03107, 129.3704, 90.9318>, <20.7946, 130.2888, 90.9285> }
				triangle { <21.03107, 129.3704, 90.9318>, <20.06074, 129.1734, 92.04568>, <20.7946, 130.2888, 90.9285> }
				triangle { <20.06074, 129.1734, 92.04568>, <19.7912, 130.1607, 92.06944>, <20.7946, 130.2888, 90.9285> }
				triangle { <20.06074, 129.1734, 92.04568>, <19.1263, 130.0752, 92.7866>, <19.7912, 130.1607, 92.06944> }
				triangle { <19.7912, 130.1607, 92.06944>, <19.1263, 130.0752, 92.7866>, <19.7896, 131.0392, 92.01687> }
				triangle { <20.7946, 130.2888, 90.9285>, <19.7912, 130.1607, 92.06944>, <19.7896, 131.0392, 92.01687> }
				triangle { <20.7946, 130.2888, 90.9285>, <19.7896, 131.0392, 92.01687>, <20.7581, 131.0524, 90.8831> }
				triangle { <20.7946, 130.2888, 90.9285>, <20.7581, 131.0524, 90.8831>, <22.3694, 130.4453, 88.6176> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <27.05922, 131.0089, 80.9971>, <27.8399, 131.0057, 83.09853>, 0.03362 }
		cylinder { <27.8399, 131.0057, 83.09853>, <28.7863, 130.8777, 85.1265>, 0.03362 }
		cylinder { <28.7863, 130.8777, 85.1265>, <29.8894, 130.6262, 87.06184>, 0.03362 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <29.8894, 130.6262, 87.06184>, <30.2882, 130.4621, 87.4552>, 0.04378 }
			cylinder { <30.2882, 130.4621, 87.4552>, <30.7584, 130.2159, 87.6984>, 0.04378 }
			cylinder { <30.7584, 130.2159, 87.6984>, <31.2525, 129.9125, 87.7667>, 0.04378 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <31.2525, 129.9125, 87.7667>, <31.4995, 129.7608, 87.8009>, 0.04378 }
				cylinder { <31.4995, 129.7608, 87.8009>, <31.7465, 129.6092, 87.835>, 0.04378 }
				cylinder { <31.7465, 129.6092, 87.835>, <31.9935, 129.4575, 87.8692>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <31.9935, 129.4575, 87.8692>, <32.00045, 129.4501, 87.8709>, 0.0007667 }
				cylinder { <32.00045, 129.4501, 87.8709>, <32.00507, 129.4412, 87.873>, 0.0007667 }
				cylinder { <32.00507, 129.4412, 87.873>, <32.0071, 129.4315, 87.8752>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <32.0071, 129.4315, 87.8752>, <32.6968, 128.2935, 88.2825>, <32.2572, 128.165, 88.2793> }
				triangle { <32.6968, 128.2935, 88.2825>, <32.873, 127.6068, 88.4068>, <32.2572, 128.165, 88.2793> }
				triangle { <32.873, 127.6068, 88.4068>, <32.4025, 127.4549, 88.4093>, <32.2572, 128.165, 88.2793> }
				triangle { <32.873, 127.6068, 88.4068>, <32.4958, 126.9955, 88.4808>, <32.4025, 127.4549, 88.4093> }
				triangle { <32.4025, 127.4549, 88.4093>, <32.4958, 126.9955, 88.4808>, <31.9803, 127.4327, 88.4531> }
				triangle { <32.2572, 128.165, 88.2793>, <32.4025, 127.4549, 88.4093>, <31.9803, 127.4327, 88.4531> }
				triangle { <32.2572, 128.165, 88.2793>, <31.9803, 127.4327, 88.4531>, <31.8899, 128.1321, 88.3072> }
				triangle { <32.2572, 128.165, 88.2793>, <31.8899, 128.1321, 88.3072>, <32.0071, 129.4315, 87.8752> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <31.9935, 129.4575, 87.8692>, <32.2405, 129.3058, 87.9034>, 0.04378 }
				cylinder { <32.2405, 129.3058, 87.9034>, <32.4876, 129.1541, 87.9376>, 0.04378 }
				cylinder { <32.4876, 129.1541, 87.9376>, <32.7346, 129.0024, 87.9717>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <32.7346, 129.0024, 87.9717>, <32.7444, 128.9995, 87.9724>, 0.0007667 }
				cylinder { <32.7444, 128.9995, 87.9724>, <32.7546, 128.9993, 87.9723>, 0.0007667 }
				cylinder { <32.7546, 128.9993, 87.9723>, <32.7645, 129.0017, 87.9717>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <32.7645, 129.0017, 87.9717>, <33.931, 129.7595, 87.9306>, <34.07662, 129.33, 87.9947> }
				triangle { <33.931, 129.7595, 87.9306>, <34.6182, 129.9553, 87.8445>, <34.07662, 129.33, 87.9947> }
				triangle { <34.6182, 129.9553, 87.8445>, <34.7894, 129.4969, 87.9152>, <34.07662, 129.33, 87.9947> }
				triangle { <34.6182, 129.9553, 87.8445>, <35.2475, 129.6013, 87.852>, <34.7894, 129.4969, 87.9152> }
				triangle { <34.7894, 129.4969, 87.9152>, <35.2475, 129.6013, 87.852>, <34.8419, 129.0957, 88.04522> }
				triangle { <34.07662, 129.33, 87.9947>, <34.7894, 129.4969, 87.9152>, <34.8419, 129.0957, 88.04522> }
				triangle { <34.07662, 129.33, 87.9947>, <34.8419, 129.0957, 88.04522>, <34.1331, 128.9785, 88.09498> }
				triangle { <34.07662, 129.33, 87.9947>, <34.1331, 128.9785, 88.09498>, <32.7645, 129.0017, 87.9717> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <32.7346, 129.0024, 87.9717>, <32.9816, 128.8507, 88.00595>, 0.04378 }
				cylinder { <32.9816, 128.8507, 88.00595>, <33.2286, 128.699, 88.04012>, 0.04378 }
				cylinder { <33.2286, 128.699, 88.04012>, <33.4756, 128.5473, 88.0743>, 0.04378 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <33.4756, 128.5473, 88.0743>, <33.4825, 128.54, 88.07598>, 0.0007667 }
				cylinder { <33.4825, 128.54, 88.07598>, <33.4872, 128.5311, 88.07804>, 0.0007667 }
				cylinder { <33.4872, 128.5311, 88.07804>, <33.4892, 128.5213, 88.08032>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <33.4892, 128.5213, 88.08032>, <34.1789, 127.3834, 88.4875>, <33.7393, 127.2549, 88.4844> }
				triangle { <34.1789, 127.3834, 88.4875>, <34.3551, 126.6967, 88.6118>, <33.7393, 127.2549, 88.4844> }
				triangle { <34.3551, 126.6967, 88.6118>, <33.8846, 126.5448, 88.6144>, <33.7393, 127.2549, 88.4844> }
				triangle { <34.3551, 126.6967, 88.6118>, <33.9779, 126.0854, 88.6858>, <33.8846, 126.5448, 88.6144> }
				triangle { <33.8846, 126.5448, 88.6144>, <33.9779, 126.0854, 88.6858>, <33.4624, 126.5226, 88.6581> }
				triangle { <33.7393, 127.2549, 88.4844>, <33.8846, 126.5448, 88.6144>, <33.4624, 126.5226, 88.6581> }
				triangle { <33.7393, 127.2549, 88.4844>, <33.4624, 126.5226, 88.6581>, <33.372, 127.222, 88.5123> }
				triangle { <33.7393, 127.2549, 88.4844>, <33.372, 127.222, 88.5123>, <33.4892, 128.5213, 88.08032> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <33.4756, 128.5473, 88.0743>, <33.4843, 128.542, 88.07549>, 0.0007667 }
				cylinder { <33.4843, 128.542, 88.07549>, <33.4929, 128.5367, 88.07669>, 0.0007667 }
				cylinder { <33.4929, 128.5367, 88.07669>, <33.5016, 128.5314, 88.07789>, 0.0007667 }
				texture {ros}}
			mesh { // leaf
				triangle { <33.5016, 128.5314, 88.07789>, <34.8472, 128.2413, 88.2819>, <34.6341, 127.8403, 88.3414> }
				triangle { <34.8472, 128.2413, 88.2819>, <35.4734, 127.889, 88.325>, <34.6341, 127.8403, 88.3414> }
				triangle { <35.4734, 127.889, 88.325>, <35.2564, 127.45, 88.3935>, <34.6341, 127.8403, 88.3414> }
				triangle { <35.4734, 127.889, 88.325>, <35.6564, 127.1963, 88.4147>, <35.2564, 127.45, 88.3935> }
				triangle { <35.2564, 127.45, 88.3935>, <35.6564, 127.1963, 88.4147>, <34.9883, 127.1393, 88.5041> }
				triangle { <34.6341, 127.8403, 88.3414>, <35.2564, 127.45, 88.3935>, <34.9883, 127.1393, 88.5041> }
				triangle { <34.6341, 127.8403, 88.3414>, <34.9883, 127.1393, 88.5041>, <34.4087, 127.5597, 88.4267> }
				triangle { <34.6341, 127.8403, 88.3414>, <34.4087, 127.5597, 88.4267>, <33.5016, 128.5314, 88.07789> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-0.06043, 110.8267, -2.1492>, <0.2823, 127.4879, -2.405>, 0.25 }
		cylinder { <0.2823, 127.4879, -2.405>, <1.1686, 144.0759, -3.7583>, 0.25 }
		cylinder { <1.1686, 144.0759, -3.7583>, <2.5937, 160.5007, -6.2018>, 0.25 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.5937, 160.5007, -6.2018>, <4.02846, 166.3091, -8.9422>, 0.4935 }
			cylinder { <4.02846, 166.3091, -8.9422>, <6.1904, 170.8543, -13.1816>, 0.4935 }
			cylinder { <6.1904, 170.8543, -13.1816>, <8.8615, 173.6776, -18.492>, 0.4935 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <8.8615, 173.6776, -18.492>, <10.197, 175.0892, -21.1472>, 0.4935 }
				cylinder { <10.197, 175.0892, -21.1472>, <11.5325, 176.5008, -23.8024>, 0.4935 }
				cylinder { <11.5325, 176.5008, -23.8024>, <12.8681, 177.9124, -26.4577>, 0.4935 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <12.8681, 177.9124, -26.4577>, <13.6867, 178.4456, -27.3141>, 0.09743 }
				cylinder { <13.6867, 178.4456, -27.3141>, <14.7372, 178.9159, -27.9165>, 0.09743 }
				cylinder { <14.7372, 178.9159, -27.9165>, <15.9437, 179.2893, -28.2213>, 0.09743 }
				texture {ros}}
			mesh { // leaf
				triangle { <15.9437, 179.2893, -28.2213>, <27.8096, 186.5446, -35.4773>, <29.9094, 184.6655, -31.1508> }
				triangle { <27.8096, 186.5446, -35.4773>, <35.27, 188.6402, -37.8815>, <29.9094, 184.6655, -31.1508> }
				triangle { <35.27, 188.6402, -37.8815>, <37.6809, 186.692, -33.2496>, <29.9094, 184.6655, -31.1508> }
				triangle { <35.27, 188.6402, -37.8815>, <42.7024, 187.8674, -34.6536>, <37.6809, 186.692, -33.2496> }
				triangle { <37.6809, 186.692, -33.2496>, <42.7024, 187.8674, -34.6536>, <38.593, 185.3683, -28.736> }
				triangle { <29.9094, 184.6655, -31.1508>, <37.6809, 186.692, -33.2496>, <38.593, 185.3683, -28.736> }
				triangle { <29.9094, 184.6655, -31.1508>, <38.593, 185.3683, -28.736>, <30.8489, 183.409, -27.288> }
				triangle { <29.9094, 184.6655, -31.1508>, <30.8489, 183.409, -27.288>, <15.9437, 179.2893, -28.2213> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <12.8681, 177.9124, -26.4577>, <14.2036, 179.3241, -29.1129>, 0.4935 }
				cylinder { <14.2036, 179.3241, -29.1129>, <15.5391, 180.7357, -31.7681>, 0.4935 }
				cylinder { <15.5391, 180.7357, -31.7681>, <16.8746, 182.1473, -34.4233>, 0.4935 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <16.8746, 182.1473, -34.4233>, <17.0725, 182.6885, -35.5877>, 0.09743 }
				cylinder { <17.0725, 182.6885, -35.5877>, <16.9265, 183.1743, -36.7837>, 0.09743 }
				cylinder { <16.9265, 183.1743, -36.7837>, <16.4472, 183.5696, -37.9247>, 0.09743 }
				texture {ros}}
			mesh { // leaf
				triangle { <16.4472, 183.5696, -37.9247>, <6.1998, 188.0067, -48.9425>, <10.8051, 189.324, -50.8699> }
				triangle { <6.1998, 188.0067, -48.9425>, <2.9256, 189.993, -56.09535>, <10.8051, 189.324, -50.8699> }
				triangle { <2.9256, 189.993, -56.09535>, <7.818, 191.4899, -58.3059>, <10.8051, 189.324, -50.8699> }
				triangle { <2.9256, 189.993, -56.09535>, <5.9234, 192.755, -63.1411>, <7.818, 191.4899, -58.3059> }
				triangle { <7.818, 191.4899, -58.3059>, <5.9234, 192.755, -63.1411>, <12.2843, 193.1007, -58.9495> }
				triangle { <10.8051, 189.324, -50.8699>, <7.818, 191.4899, -58.3059>, <12.2843, 193.1007, -58.9495> }
				triangle { <10.8051, 189.324, -50.8699>, <12.2843, 193.1007, -58.9495>, <14.6944, 190.6372, -51.599> }
				triangle { <10.8051, 189.324, -50.8699>, <14.6944, 190.6372, -51.599>, <16.4472, 183.5696, -37.9247> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <16.8746, 182.1473, -34.4233>, <18.2101, 183.5589, -37.07852>, 0.4935 }
				cylinder { <18.2101, 183.5589, -37.07852>, <19.5457, 184.9705, -39.7337>, 0.4935 }
				cylinder { <19.5457, 184.9705, -39.7337>, <20.8812, 186.3822, -42.3889>, 0.4935 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <20.8812, 186.3822, -42.3889>, <21.6998, 186.9153, -43.2453>, 0.09743 }
				cylinder { <21.6998, 186.9153, -43.2453>, <22.7504, 187.3856, -43.8477>, 0.09743 }
				cylinder { <22.7504, 187.3856, -43.8477>, <23.9568, 187.759, -44.1525>, 0.09743 }
				texture {ros}}
			mesh { // leaf
				triangle { <23.9568, 187.759, -44.1525>, <35.8227, 195.0143, -51.4085>, <37.9225, 193.1352, -47.08206> }
				triangle { <35.8227, 195.0143, -51.4085>, <43.2831, 197.11, -53.8128>, <37.9225, 193.1352, -47.08206> }
				triangle { <43.2831, 197.11, -53.8128>, <45.694, 195.1618, -49.1808>, <37.9225, 193.1352, -47.08206> }
				triangle { <43.2831, 197.11, -53.8128>, <50.7155, 196.3372, -50.5849>, <45.694, 195.1618, -49.1808> }
				triangle { <45.694, 195.1618, -49.1808>, <50.7155, 196.3372, -50.5849>, <46.6062, 193.838, -44.6673> }
				triangle { <37.9225, 193.1352, -47.08206>, <45.694, 195.1618, -49.1808>, <46.6062, 193.838, -44.6673> }
				triangle { <37.9225, 193.1352, -47.08206>, <46.6062, 193.838, -44.6673>, <38.8621, 191.8787, -43.2192> }
				triangle { <37.9225, 193.1352, -47.08206>, <38.8621, 191.8787, -43.2192>, <23.9568, 187.759, -44.1525> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <20.8812, 186.3822, -42.3889>, <21.4085, 186.9395, -43.4373>, 0.09743 }
				cylinder { <21.4085, 186.9395, -43.4373>, <21.9358, 187.4969, -44.4857>, 0.09743 }
				cylinder { <21.9358, 187.4969, -44.4857>, <22.4632, 188.0543, -45.534>, 0.09743 }
				texture {ros}}
			mesh { // leaf
				triangle { <22.4632, 188.0543, -45.534>, <23.7656, 195.8904, -59.06139>, <28.5954, 195.6436, -57.2526> }
				triangle { <23.7656, 195.8904, -59.06139>, <26.7689, 199.0109, -65.9222>, <28.5954, 195.6436, -57.2526> }
				triangle { <26.7689, 199.0109, -65.9222>, <32.03252, 198.8442, -64.09734>, <28.5954, 195.6436, -57.2526> }
				triangle { <26.7689, 199.0109, -65.9222>, <34.2676, 200.7744, -68.5523>, <32.03252, 198.8442, -64.09734> }
				triangle { <32.03252, 198.8442, -64.09734>, <34.2676, 200.7744, -68.5523>, <35.9647, 198.8918, -61.3602> }
				triangle { <28.5954, 195.6436, -57.2526>, <32.03252, 198.8442, -64.09734>, <35.9647, 198.8918, -61.3602> }
				triangle { <28.5954, 195.6436, -57.2526>, <35.9647, 198.8918, -61.3602>, <32.113, 195.6044, -55.01485> }
				triangle { <28.5954, 195.6436, -57.2526>, <32.113, 195.6044, -55.01485>, <22.4632, 188.0543, -45.534> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <2.5937, 160.5007, -6.2018>, <6.7078, 170.9827, -14.2212>, 0.2073 }
		cylinder { <6.7078, 170.9827, -14.2212>, <12.5835, 175.3405, -25.9512>, 0.2073 }
		cylinder { <12.5835, 175.3405, -25.9512>, <18.5488, 172.334, -38.0543>, 0.2073 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.5488, 172.334, -38.0543>, <19.8051, 170.6222, -40.6314>, 0.2504 }
			cylinder { <19.8051, 170.6222, -40.6314>, <20.75, 168.0975, -42.602>, 0.2504 }
			cylinder { <20.75, 168.0975, -42.602>, <21.2881, 165.0148, -43.7672>, 0.2504 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <21.2881, 165.0148, -43.7672>, <21.5572, 163.4734, -44.3498>, 0.2504 }
				cylinder { <21.5572, 163.4734, -44.3498>, <21.8262, 161.9321, -44.9324>, 0.2504 }
				cylinder { <21.8262, 161.9321, -44.9324>, <22.0953, 160.3907, -45.515>, 0.2504 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <22.0953, 160.3907, -45.515>, <22.2271, 160.0921, -45.5878>, 0.02508 }
				cylinder { <22.2271, 160.0921, -45.5878>, <22.4274, 159.8252, -45.6115>, 0.02508 }
				cylinder { <22.4274, 159.8252, -45.6115>, <22.6816, 159.6095, -45.5844>, 0.02508 }
				texture {ros}}
			mesh { // leaf
				triangle { <22.6816, 159.6095, -45.5844>, <27.4681, 153.417, -47.03565>, <28.8421, 154.9315, -45.3977> }
				triangle { <27.4681, 153.417, -47.03565>, <30.4057, 150.5586, -46.6487>, <28.8421, 154.9315, -45.3977> }
				triangle { <30.4057, 150.5586, -46.6487>, <31.9562, 152.1408, -44.8906>, <28.8421, 154.9315, -45.3977> }
				triangle { <30.4057, 150.5586, -46.6487>, <33.9284, 150.3193, -44.5056>, <31.9562, 152.1408, -44.8906> }
				triangle { <31.9562, 152.1408, -44.8906>, <33.9284, 150.3193, -44.5056>, <33.01527, 153.9999, -43.736> }
				triangle { <28.8421, 154.9315, -45.3977>, <31.9562, 152.1408, -44.8906>, <33.01527, 153.9999, -43.736> }
				triangle { <28.8421, 154.9315, -45.3977>, <33.01527, 153.9999, -43.736>, <29.7852, 156.4889, -44.3204> }
				triangle { <28.8421, 154.9315, -45.3977>, <29.7852, 156.4889, -44.3204>, <22.6816, 159.6095, -45.5844> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <22.0953, 160.3907, -45.515>, <22.3643, 158.8494, -46.09764>, 0.2504 }
				cylinder { <22.3643, 158.8494, -46.09764>, <22.6334, 157.308, -46.6802>, 0.2504 }
				cylinder { <22.6334, 157.308, -46.6802>, <22.9024, 155.7667, -47.2628>, 0.2504 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <22.9024, 155.7667, -47.2628>, <22.8744, 155.4701, -47.4149>, 0.02508 }
				cylinder { <22.8744, 155.4701, -47.4149>, <22.7666, 155.2072, -47.5915>, 0.02508 }
				cylinder { <22.7666, 155.2072, -47.5915>, <22.5868, 154.9971, -47.7796>, 0.02508 }
				texture {ros}}
			mesh { // leaf
				triangle { <22.5868, 154.9971, -47.7796>, <17.04032, 152.2799, -52.8012>, <18.7623, 150.3148, -52.6087> }
				triangle { <17.04032, 152.2799, -52.8012>, <14.602, 149.7585, -54.9567>, <18.7623, 150.3148, -52.6087> }
				triangle { <14.602, 149.7585, -54.9567>, <16.4172, 147.5949, -54.8098>, <18.7623, 150.3148, -52.6087> }
				triangle { <14.602, 149.7585, -54.9567>, <14.8801, 145.8189, -56.1658>, <16.4172, 147.5949, -54.8098> }
				triangle { <16.4172, 147.5949, -54.8098>, <14.8801, 145.8189, -56.1658>, <18.4274, 146.2339, -54.677> }
				triangle { <18.7623, 150.3148, -52.6087>, <16.4172, 147.5949, -54.8098>, <18.4274, 146.2339, -54.677> }
				triangle { <18.7623, 150.3148, -52.6087>, <18.4274, 146.2339, -54.677>, <20.4564, 149.0558, -52.4657> }
				triangle { <18.7623, 150.3148, -52.6087>, <20.4564, 149.0558, -52.4657>, <22.5868, 154.9971, -47.7796> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <22.9024, 155.7667, -47.2628>, <23.1715, 154.2253, -47.8454>, 0.2504 }
				cylinder { <23.1715, 154.2253, -47.8454>, <23.4405, 152.684, -48.428>, 0.2504 }
				cylinder { <23.4405, 152.684, -48.428>, <23.7096, 151.1426, -49.01064>, 0.2504 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <23.7096, 151.1426, -49.01064>, <23.8414, 150.844, -49.08348>, 0.02508 }
				cylinder { <23.8414, 150.844, -49.08348>, <24.04177, 150.5771, -49.1071>, 0.02508 }
				cylinder { <24.04177, 150.5771, -49.1071>, <24.2959, 150.3613, -49.08001>, 0.02508 }
				texture {ros}}
			mesh { // leaf
				triangle { <24.2959, 150.3613, -49.08001>, <29.08245, 144.1689, -50.5312>, <30.4564, 145.6833, -48.8933> }
				triangle { <29.08245, 144.1689, -50.5312>, <32.02003, 141.3105, -50.1443>, <30.4564, 145.6833, -48.8933> }
				triangle { <32.02003, 141.3105, -50.1443>, <33.5705, 142.8927, -48.3862>, <30.4564, 145.6833, -48.8933> }
				triangle { <32.02003, 141.3105, -50.1443>, <35.5427, 141.0712, -48.00124>, <33.5705, 142.8927, -48.3862> }
				triangle { <33.5705, 142.8927, -48.3862>, <35.5427, 141.0712, -48.00124>, <34.6295, 144.7518, -47.2316> }
				triangle { <30.4564, 145.6833, -48.8933>, <33.5705, 142.8927, -48.3862>, <34.6295, 144.7518, -47.2316> }
				triangle { <30.4564, 145.6833, -48.8933>, <34.6295, 144.7518, -47.2316>, <31.3995, 147.2408, -47.816> }
				triangle { <30.4564, 145.6833, -48.8933>, <31.3995, 147.2408, -47.816>, <24.2959, 150.3613, -49.08001> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <23.7096, 151.1426, -49.01064>, <23.7635, 150.8338, -49.1273>, 0.02508 }
				cylinder { <23.7635, 150.8338, -49.1273>, <23.8174, 150.525, -49.244>, 0.02508 }
				cylinder { <23.8174, 150.525, -49.244>, <23.8713, 150.2162, -49.3608>, 0.02508 }
				texture {ros}}
			mesh { // leaf
				triangle { <23.8713, 150.2162, -49.3608>, <23.1707, 143.6171, -53.7566>, <25.4531, 143.3249, -52.5038> }
				triangle { <23.1707, 143.6171, -53.7566>, <23.5701, 139.7507, -55.1135>, <25.4531, 143.3249, -52.5038> }
				triangle { <23.5701, 139.7507, -55.1135>, <26.04811, 139.3637, -53.8066>, <25.4531, 143.3249, -52.5038> }
				triangle { <23.5701, 139.7507, -55.1135>, <26.4009, 136.7898, -54.5851>, <26.04811, 139.3637, -53.8066> }
				triangle { <26.04811, 139.3637, -53.8066>, <26.4009, 136.7898, -54.5851>, <28.2363, 139.6902, -52.7987> }
				triangle { <25.4531, 143.3249, -52.5038>, <26.04811, 139.3637, -53.8066>, <28.2363, 139.6902, -52.7987> }
				triangle { <25.4531, 143.3249, -52.5038>, <28.2363, 139.6902, -52.7987>, <27.3467, 143.5239, -51.5817> }
				triangle { <25.4531, 143.3249, -52.5038>, <27.3467, 143.5239, -51.5817>, <23.8713, 150.2162, -49.3608> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <18.5488, 172.334, -38.0543>, <18.8225, 171.7363, -38.6217>, 0.01302 }
		cylinder { <18.8225, 171.7363, -38.6217>, <18.9174, 170.8998, -38.8347>, 0.01302 }
		cylinder { <18.9174, 170.8998, -38.8347>, <18.8063, 170.0625, -38.6328>, 0.01302 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <18.8063, 170.0625, -38.6328>, <18.7379, 169.8391, -38.5007>, 0.02012 }
			cylinder { <18.7379, 169.8391, -38.5007>, <18.6423, 169.6737, -38.3122>, 0.02012 }
			cylinder { <18.6423, 169.6737, -38.3122>, <18.5291, 169.5828, -38.08652>, 0.02012 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <18.5291, 169.5828, -38.08652>, <18.4725, 169.5374, -37.9736>, 0.02012 }
				cylinder { <18.4725, 169.5374, -37.9736>, <18.4159, 169.492, -37.8607>, 0.02012 }
				cylinder { <18.4159, 169.492, -37.8607>, <18.3594, 169.4466, -37.7478>, 0.02012 }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <18.3594, 169.4466, -37.7478>, <18.3028, 169.4012, -37.635>, 0.02012 }
				cylinder { <18.3028, 169.4012, -37.635>, <18.2462, 169.3558, -37.5221>, 0.02012 }
				cylinder { <18.2462, 169.3558, -37.5221>, <18.1896, 169.3104, -37.4092>, 0.02012 }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <18.1896, 169.3104, -37.4092>, <18.133, 169.265, -37.2963>, 0.02012 }
				cylinder { <18.133, 169.265, -37.2963>, <18.07645, 169.2196, -37.1834>, 0.02012 }
				cylinder { <18.07645, 169.2196, -37.1834>, <18.01987, 169.1741, -37.07059>, 0.02012 }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <18.5488, 172.334, -38.0543>, <21.4809, 171.1137, -44.8284>, 0.1122 }
		cylinder { <21.4809, 171.1137, -44.8284>, <24.1009, 170.3067, -51.7897>, 0.1122 }
		cylinder { <24.1009, 170.3067, -51.7897>, <26.3945, 169.9173, -58.9004>, 0.1122 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <26.3945, 169.9173, -58.9004>, <26.57, 170.2443, -60.5879>, 0.1295 }
			cylinder { <26.57, 170.2443, -60.5879>, <26.3735, 170.9552, -62.1504>, 0.1295 }
			cylinder { <26.3735, 170.9552, -62.1504>, <25.8249, 171.9783, -63.4302>, 0.1295 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <25.8249, 171.9783, -63.4302>, <25.5506, 172.4898, -64.07007>, 0.1295 }
				cylinder { <25.5506, 172.4898, -64.07007>, <25.2763, 173.0013, -64.7099>, 0.1295 }
				cylinder { <25.2763, 173.0013, -64.7099>, <25.002, 173.5128, -65.3498>, 0.1295 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <25.002, 173.5128, -65.3498>, <24.957, 173.5484, -65.4185>, 0.006716 }
				cylinder { <24.957, 173.5484, -65.4185>, <24.8987, 173.5641, -65.4847>, 0.006716 }
				cylinder { <24.8987, 173.5641, -65.4847>, <24.8314, 173.5587, -65.5435>, 0.006716 }
				texture {ros}}
			mesh { // leaf
				triangle { <24.8314, 173.5587, -65.5435>, <22.5169, 174.2591, -68.8778>, <22.00351, 173.1237, -68.344> }
				triangle { <22.5169, 174.2591, -68.8778>, <20.8864, 174.2717, -70.2485>, <22.00351, 173.1237, -68.344> }
				triangle { <20.8864, 174.2717, -70.2485>, <20.3052, 173.0424, -69.7076>, <22.00351, 173.1237, -68.344> }
				triangle { <20.8864, 174.2717, -70.2485>, <19.1913, 173.008, -70.5605>, <20.3052, 173.0424, -69.7076> }
				triangle { <20.3052, 173.0424, -69.7076>, <19.1913, 173.008, -70.5605>, <20.1393, 171.9136, -69.1777> }
				triangle { <22.00351, 173.1237, -68.344>, <20.3052, 173.0424, -69.7076>, <20.1393, 171.9136, -69.1777> }
				triangle { <22.00351, 173.1237, -68.344>, <20.1393, 171.9136, -69.1777>, <21.8107, 172.1527, -67.8767> }
				triangle { <22.00351, 173.1237, -68.344>, <21.8107, 172.1527, -67.8767>, <24.8314, 173.5587, -65.5435> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <25.002, 173.5128, -65.3498>, <24.7276, 174.0243, -65.9896>, 0.1295 }
				cylinder { <24.7276, 174.0243, -65.9896>, <24.4533, 174.5358, -66.6295>, 0.1295 }
				cylinder { <24.4533, 174.5358, -66.6295>, <24.179, 175.0473, -67.2694>, 0.1295 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <24.179, 175.0473, -67.2694>, <24.1692, 175.1138, -67.3285>, 0.006716 }
				cylinder { <24.1692, 175.1138, -67.3285>, <24.1787, 175.1891, -67.3761>, 0.006716 }
				cylinder { <24.1787, 175.1891, -67.3761>, <24.2068, 175.2676, -67.4087>, 0.006716 }
				texture {ros}}
			mesh { // leaf
				triangle { <24.2068, 175.2676, -67.4087>, <26.6296, 178.499, -68.2163>, <25.6067, 178.6165, -69.0982> }
				triangle { <26.6296, 178.499, -68.2163>, <27.3107, 180.4139, -68.8546>, <25.6067, 178.6165, -69.0982> }
				triangle { <27.3107, 180.4139, -68.8546>, <26.2276, 180.5751, -69.8254>, <25.6067, 178.6165, -69.0982> }
				triangle { <27.3107, 180.4139, -68.8546>, <26.6046, 181.8519, -70.2692>, <26.2276, 180.5751, -69.8254> }
				triangle { <26.2276, 180.5751, -69.8254>, <26.6046, 181.8519, -70.2692>, <25.324, 180.3675, -70.6756> }
				triangle { <25.6067, 178.6165, -69.0982>, <26.2276, 180.5751, -69.8254>, <25.324, 180.3675, -70.6756> }
				triangle { <25.6067, 178.6165, -69.0982>, <25.324, 180.3675, -70.6756>, <24.8029, 178.482, -69.829> }
				triangle { <25.6067, 178.6165, -69.0982>, <24.8029, 178.482, -69.829>, <24.2068, 175.2676, -67.4087> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <24.179, 175.0473, -67.2694>, <23.9047, 175.5588, -67.9092>, 0.1295 }
				cylinder { <23.9047, 175.5588, -67.9092>, <23.6304, 176.0703, -68.5491>, 0.1295 }
				cylinder { <23.6304, 176.0703, -68.5491>, <23.3561, 176.5818, -69.189>, 0.1295 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <23.3561, 176.5818, -69.189>, <23.3111, 176.6175, -69.2577>, 0.006716 }
				cylinder { <23.3111, 176.6175, -69.2577>, <23.2529, 176.6332, -69.3239>, 0.006716 }
				cylinder { <23.2529, 176.6332, -69.3239>, <23.1856, 176.6278, -69.3827>, 0.006716 }
				texture {ros}}
			mesh { // leaf
				triangle { <23.1856, 176.6278, -69.3827>, <20.8711, 177.3281, -72.717>, <20.3576, 176.1927, -72.1832> }
				triangle { <20.8711, 177.3281, -72.717>, <19.2405, 177.3407, -74.08778>, <20.3576, 176.1927, -72.1832> }
				triangle { <19.2405, 177.3407, -74.08778>, <18.6593, 176.1115, -73.5469>, <20.3576, 176.1927, -72.1832> }
				triangle { <19.2405, 177.3407, -74.08778>, <17.5454, 176.077, -74.3997>, <18.6593, 176.1115, -73.5469> }
				triangle { <18.6593, 176.1115, -73.5469>, <17.5454, 176.077, -74.3997>, <18.4935, 174.9827, -73.01696> }
				triangle { <20.3576, 176.1927, -72.1832>, <18.6593, 176.1115, -73.5469>, <18.4935, 174.9827, -73.01696> }
				triangle { <20.3576, 176.1927, -72.1832>, <18.4935, 174.9827, -73.01696>, <20.1649, 175.2217, -71.7159> }
				triangle { <20.3576, 176.1927, -72.1832>, <20.1649, 175.2217, -71.7159>, <23.1856, 176.6278, -69.3827> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <23.3561, 176.5818, -69.189>, <23.3277, 176.6348, -69.2553>, 0.006716 }
				cylinder { <23.3277, 176.6348, -69.2553>, <23.2992, 176.6879, -69.3217>, 0.006716 }
				cylinder { <23.2992, 176.6879, -69.3217>, <23.2708, 176.7409, -69.388>, 0.006716 }
				texture {ros}}
			mesh { // leaf
				triangle { <23.2708, 176.7409, -69.388>, <23.2377, 179.6816, -72.2717>, <22.1515, 178.9211, -72.554> }
				triangle { <23.2377, 179.6816, -72.2717>, <22.577, 181.0568, -73.7584>, <22.1515, 178.9211, -72.554> }
				triangle { <22.577, 181.0568, -73.7584>, <21.3982, 180.2599, -74.1>, <22.1515, 178.9211, -72.554> }
				triangle { <22.577, 181.0568, -73.7584>, <20.8918, 181.1384, -75.07022>, <21.3982, 180.2599, -74.1> }
				triangle { <21.3982, 180.2599, -74.1>, <20.8918, 181.1384, -75.07022>, <20.5948, 179.3133, -74.3023> }
				triangle { <22.1515, 178.9211, -72.554>, <21.3982, 180.2599, -74.1>, <20.5948, 179.3133, -74.3023> }
				triangle { <22.1515, 178.9211, -72.554>, <20.5948, 179.3133, -74.3023>, <21.4149, 178.1307, -72.7301> }
				triangle { <22.1515, 178.9211, -72.554>, <21.4149, 178.1307, -72.7301>, <23.2708, 176.7409, -69.388> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <26.3945, 169.9173, -58.9004>, <27.7177, 169.7027, -61.9483>, 0.04994 }
		cylinder { <27.7177, 169.7027, -61.9483>, <29.3304, 169.4487, -64.8501>, 0.04994 }
		cylinder { <29.3304, 169.4487, -64.8501>, <31.2173, 169.1579, -67.578>, 0.04994 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <31.2173, 169.1579, -67.578>, <31.8482, 169.0648, -68.05388>, 0.05967 }
			cylinder { <31.8482, 169.0648, -68.05388>, <32.5953, 168.9574, -68.3057>, 0.05967 }
			cylinder { <32.5953, 168.9574, -68.3057>, <33.3832, 168.8467, -68.3081>, 0.05967 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <33.3832, 168.8467, -68.3081>, <33.7772, 168.7914, -68.3093>, 0.05967 }
				cylinder { <33.7772, 168.7914, -68.3093>, <34.1711, 168.736, -68.3105>, 0.05967 }
				cylinder { <34.1711, 168.736, -68.3105>, <34.5651, 168.6806, -68.3117>, 0.05967 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <34.5651, 168.6806, -68.3117>, <34.5839, 168.6831, -68.3118>, 0.001424 }
				cylinder { <34.5839, 168.6831, -68.3118>, <34.6014, 168.6905, -68.3119>, 0.001424 }
				cylinder { <34.6014, 168.6905, -68.3119>, <34.6163, 168.7023, -68.3121>, 0.001424 }
				texture {ros}}
			mesh { // leaf
				triangle { <34.6163, 168.7023, -68.3121>, <36.3891, 169.3452, -68.5163>, <36.04115, 169.8616, -68.4716> }
				triangle { <36.3891, 169.3452, -68.5163>, <37.1858, 169.9162, -68.477>, <36.04115, 169.8616, -68.4716> }
				triangle { <37.1858, 169.9162, -68.477>, <36.8269, 170.4848, -68.4328>, <36.04115, 169.8616, -68.4716> }
				triangle { <37.1858, 169.9162, -68.477>, <37.3321, 170.8856, -68.3907>, <36.8269, 170.4848, -68.4328> }
				triangle { <36.8269, 170.4848, -68.4328>, <37.3321, 170.8856, -68.3907>, <36.4147, 170.8888, -68.4823> }
				triangle { <36.04115, 169.8616, -68.4716>, <36.8269, 170.4848, -68.4328>, <36.4147, 170.8888, -68.4823> }
				triangle { <36.04115, 169.8616, -68.4716>, <36.4147, 170.8888, -68.4823>, <35.6922, 170.2245, -68.4972> }
				triangle { <36.04115, 169.8616, -68.4716>, <35.6922, 170.2245, -68.4972>, <34.6163, 168.7023, -68.3121> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <34.5651, 168.6806, -68.3117>, <34.9591, 168.6253, -68.3129>, 0.05967 }
				cylinder { <34.9591, 168.6253, -68.3129>, <35.353, 168.5699, -68.3141>, 0.05967 }
				cylinder { <35.353, 168.5699, -68.3141>, <35.747, 168.5146, -68.3153>, 0.05967 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <35.747, 168.5146, -68.3153>, <35.7644, 168.507, -68.3153>, 0.001424 }
				cylinder { <35.7644, 168.507, -68.3153>, <35.7792, 168.4951, -68.3152>, 0.001424 }
				cylinder { <35.7792, 168.4951, -68.3152>, <35.7902, 168.4796, -68.3151>, 0.001424 }
				texture {ros}}
			mesh { // leaf
				triangle { <35.7902, 168.4796, -68.3151>, <36.3463, 166.6749, -68.4926>, <36.8789, 166.9977, -68.4499> }
				triangle { <36.3463, 166.6749, -68.4926>, <36.8773, 165.8517, -68.4398>, <36.8789, 166.9977, -68.4499> }
				triangle { <36.8773, 165.8517, -68.4398>, <37.4627, 166.1829, -68.3975>, <36.8789, 166.9977, -68.4499> }
				triangle { <36.8773, 165.8517, -68.4398>, <37.838, 165.6593, -68.3467>, <37.4627, 166.1829, -68.3975> }
				triangle { <37.4627, 166.1829, -68.3975>, <37.838, 165.6593, -68.3467>, <37.8866, 166.5742, -68.4505> }
				triangle { <36.8789, 166.9977, -68.4499>, <37.4627, 166.1829, -68.3975>, <37.8866, 166.5742, -68.4505> }
				triangle { <36.8789, 166.9977, -68.4499>, <37.8866, 166.5742, -68.4505>, <37.2586, 167.3281, -68.4784> }
				triangle { <36.8789, 166.9977, -68.4499>, <37.2586, 167.3281, -68.4784>, <35.7902, 168.4796, -68.3151> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <35.747, 168.5146, -68.3153>, <36.141, 168.4592, -68.3165>, 0.05967 }
				cylinder { <36.141, 168.4592, -68.3165>, <36.5349, 168.4039, -68.3177>, 0.05967 }
				cylinder { <36.5349, 168.4039, -68.3177>, <36.9289, 168.3485, -68.3189>, 0.05967 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <36.9289, 168.3485, -68.3189>, <36.9477, 168.351, -68.319>, 0.001424 }
				cylinder { <36.9477, 168.351, -68.319>, <36.9652, 168.3584, -68.3191>, 0.001424 }
				cylinder { <36.9652, 168.3584, -68.3191>, <36.9801, 168.3702, -68.3193>, 0.001424 }
				texture {ros}}
			mesh { // leaf
				triangle { <36.9801, 168.3702, -68.3193>, <38.7529, 169.013, -68.5235>, <38.4049, 169.5294, -68.4788> }
				triangle { <38.7529, 169.013, -68.5235>, <39.5496, 169.584, -68.4842>, <38.4049, 169.5294, -68.4788> }
				triangle { <39.5496, 169.584, -68.4842>, <39.1907, 170.1526, -68.44>, <38.4049, 169.5294, -68.4788> }
				triangle { <39.5496, 169.584, -68.4842>, <39.6959, 170.5534, -68.3979>, <39.1907, 170.1526, -68.44> }
				triangle { <39.1907, 170.1526, -68.44>, <39.6959, 170.5534, -68.3979>, <38.7785, 170.5566, -68.4895> }
				triangle { <38.4049, 169.5294, -68.4788>, <39.1907, 170.1526, -68.44>, <38.7785, 170.5566, -68.4895> }
				triangle { <38.4049, 169.5294, -68.4788>, <38.7785, 170.5566, -68.4895>, <38.05601, 169.8923, -68.5044> }
				triangle { <38.4049, 169.5294, -68.4788>, <38.05601, 169.8923, -68.5044>, <36.9801, 168.3702, -68.3193> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <36.9289, 168.3485, -68.3189>, <36.9477, 168.3459, -68.3189>, 0.001424 }
				cylinder { <36.9477, 168.3459, -68.3189>, <36.9665, 168.3432, -68.319>, 0.001424 }
				cylinder { <36.9665, 168.3432, -68.319>, <36.9853, 168.3406, -68.319>, 0.001424 }
				texture {ros}}
			mesh { // leaf
				triangle { <36.9853, 168.3406, -68.319>, <38.6743, 167.4988, -68.5098>, <38.8081, 168.1072, -68.468> }
				triangle { <38.6743, 167.4988, -68.5098>, <39.637, 167.3158, -68.4645>, <38.8081, 168.1072, -68.468> }
				triangle { <39.637, 167.3158, -68.4645>, <39.8011, 167.9681, -68.4233>, <38.8081, 168.1072, -68.468> }
				triangle { <39.637, 167.3158, -68.4645>, <40.4396, 167.8788, -68.3775>, <39.8011, 167.9681, -68.4233> }
				triangle { <39.8011, 167.9681, -68.4233>, <40.4396, 167.8788, -68.3775>, <39.8097, 168.5449, -68.4761> }
				triangle { <38.8081, 168.1072, -68.468>, <39.8011, 167.9681, -68.4233>, <39.8097, 168.5449, -68.4761> }
				triangle { <38.8081, 168.1072, -68.468>, <39.8097, 168.5449, -68.4761>, <38.8305, 168.61, -68.4964> }
				triangle { <38.8081, 168.1072, -68.468>, <38.8305, 168.61, -68.4964>, <36.9853, 168.3406, -68.319> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <31.2173, 169.1579, -67.578>, <31.849, 169.0202, -68.5741>, 0.01781 }
		cylinder { <31.849, 169.0202, -68.5741>, <32.4378, 168.849, -69.591>, 0.01781 }
		cylinder { <32.4378, 168.849, -69.591>, <32.9824, 168.6445, -70.6263>, 0.01781 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <32.9824, 168.6445, -70.6263>, <33.04594, 168.5327, -70.9282>, 0.0246 }
			cylinder { <33.04594, 168.5327, -70.9282>, <33.01614, 168.3768, -71.2154>, 0.0246 }
			cylinder { <33.01614, 168.3768, -71.2154>, <32.896, 168.1926, -71.4589>, 0.0246 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <32.896, 168.1926, -71.4589>, <32.8359, 168.1006, -71.5807>, 0.0246 }
				cylinder { <32.8359, 168.1006, -71.5807>, <32.7758, 168.0085, -71.7025>, 0.0246 }
				cylinder { <32.7758, 168.0085, -71.7025>, <32.7158, 167.9164, -71.8242>, 0.0246 }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <32.7158, 167.9164, -71.8242>, <32.6557, 167.8243, -71.946>, 0.0246 }
				cylinder { <32.6557, 167.8243, -71.946>, <32.5956, 167.7322, -72.06779>, 0.0246 }
				cylinder { <32.5956, 167.7322, -72.06779>, <32.5356, 167.6401, -72.1895>, 0.0246 }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <32.5356, 167.6401, -72.1895>, <32.4755, 167.548, -72.3113>, 0.0246 }
				cylinder { <32.4755, 167.548, -72.3113>, <32.4154, 167.4559, -72.433>, 0.0246 }
				cylinder { <32.4154, 167.4559, -72.433>, <32.3554, 167.3639, -72.5548>, 0.0246 }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <2.5937, 160.5007, -6.2018>, <2.5015, 176.9943, -8.04361>, 0.2489 }
		cylinder { <2.5015, 176.9943, -8.04361>, <0.899, 193.4671, -9.2761>, 0.2489 }
		cylinder { <0.899, 193.4671, -9.2761>, <-2.1983, 209.7604, -9.8875>, 0.2489 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.1983, 209.7604, -9.8875>, <-5.02048, 215.1439, -9.3668>, 0.4575 }
			cylinder { <-5.02048, 215.1439, -9.3668>, <-9.2412, 219.3783, -8.1533>, 0.4575 }
			cylinder { <-9.2412, 219.3783, -8.1533>, <-14.4346, 222.0361, -6.3694>, 0.4575 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-14.4346, 222.0361, -6.3694>, <-17.03133, 223.365, -5.4774>, 0.4575 }
				cylinder { <-17.03133, 223.365, -5.4774>, <-19.628, 224.6939, -4.5855>, 0.4575 }
				cylinder { <-19.628, 224.6939, -4.5855>, <-22.2247, 226.0228, -3.6935>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-22.2247, 226.0228, -3.6935>, <-23.2511, 226.4603, -3.6536>, 0.08373 }
				cylinder { <-23.2511, 226.4603, -3.6536>, <-24.2792, 226.8172, -3.9033>, 0.08373 }
				cylinder { <-24.2792, 226.8172, -3.9033>, <-25.2344, 227.0676, -4.4243>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-25.2344, 227.0676, -4.4243>, <-38.08527, 233.2303, -7.3173>, <-36.817, 231.1389, -11.4317> }
				triangle { <-38.08527, 233.2303, -7.3173>, <-44.7728, 234.728, -10.4168>, <-36.817, 231.1389, -11.4317> }
				triangle { <-44.7728, 234.728, -10.4168>, <-43.5291, 232.5356, -14.9271>, <-36.817, 231.1389, -11.4317> }
				triangle { <-44.7728, 234.728, -10.4168>, <-47.8925, 233.3167, -17.1413>, <-43.5291, 232.5356, -14.9271> }
				triangle { <-43.5291, 232.5356, -14.9271>, <-47.8925, 233.3167, -17.1413>, <-41.3383, 231.0354, -18.4878> }
				triangle { <-36.817, 231.1389, -11.4317>, <-43.5291, 232.5356, -14.9271>, <-41.3383, 231.0354, -18.4878> }
				triangle { <-36.817, 231.1389, -11.4317>, <-41.3383, 231.0354, -18.4878>, <-35.0489, 229.7291, -14.5663> }
				triangle { <-36.817, 231.1389, -11.4317>, <-35.0489, 229.7291, -14.5663>, <-25.2344, 227.0676, -4.4243> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-22.2247, 226.0228, -3.6935>, <-24.8214, 227.3517, -2.8015>, 0.4575 }
				cylinder { <-24.8214, 227.3517, -2.8015>, <-27.418, 228.6806, -1.9096>, 0.4575 }
				cylinder { <-27.418, 228.6806, -1.9096>, <-30.01479, 230.0095, -1.01767>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-30.01479, 230.0095, -1.01767>, <-30.8204, 230.5096, -0.4282>, 0.08373 }
				cylinder { <-30.8204, 230.5096, -0.4282>, <-31.4228, 230.9872, 0.3814>, 0.08373 }
				cylinder { <-31.4228, 230.9872, 0.3814>, <-31.7784, 231.4076, 1.3528>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-31.7784, 231.4076, 1.3528>, <-31.6156, 236.7728, 14.8687>, <-36.01849, 237.7399, 13.259> }
				triangle { <-31.6156, 236.7728, 14.8687>, <-33.8221, 239.182, 21.6437>, <-36.01849, 237.7399, 13.259> }
				triangle { <-33.8221, 239.182, 21.6437>, <-38.6024, 240.307, 20.03795>, <-36.01849, 237.7399, 13.259> }
				triangle { <-33.8221, 239.182, 21.6437>, <-40.3121, 241.8404, 24.4286>, <-38.6024, 240.307, 20.03795> }
				triangle { <-38.6024, 240.307, 20.03795>, <-40.3121, 241.8404, 24.4286>, <-42.1227, 241.4951, 17.6038> }
				triangle { <-36.01849, 237.7399, 13.259>, <-38.6024, 240.307, 20.03795>, <-42.1227, 241.4951, 17.6038> }
				triangle { <-36.01849, 237.7399, 13.259>, <-42.1227, 241.4951, 17.6038>, <-39.1861, 238.6998, 11.2631> }
				triangle { <-36.01849, 237.7399, 13.259>, <-39.1861, 238.6998, 11.2631>, <-31.7784, 231.4076, 1.3528> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-30.01479, 230.0095, -1.01767>, <-32.6114, 231.3384, -0.1257>, 0.4575 }
				cylinder { <-32.6114, 231.3384, -0.1257>, <-35.2081, 232.6673, 0.7662>, 0.4575 }
				cylinder { <-35.2081, 232.6673, 0.7662>, <-37.8048, 233.9962, 1.6582>, 0.4575 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-37.8048, 233.9962, 1.6582>, <-38.8313, 234.4337, 1.698>, 0.08373 }
				cylinder { <-38.8313, 234.4337, 1.698>, <-39.8594, 234.7906, 1.4484>, 0.08373 }
				cylinder { <-39.8594, 234.7906, 1.4484>, <-40.8146, 235.041, 0.9273>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-40.8146, 235.041, 0.9273>, <-53.6654, 241.2037, -1.9655>, <-52.3971, 239.1123, -6.08001> }
				triangle { <-53.6654, 241.2037, -1.9655>, <-60.353, 242.7014, -5.06509>, <-52.3971, 239.1123, -6.08001> }
				triangle { <-60.353, 242.7014, -5.06509>, <-59.1092, 240.509, -9.5753>, <-52.3971, 239.1123, -6.08001> }
				triangle { <-60.353, 242.7014, -5.06509>, <-63.4727, 241.2901, -11.7895>, <-59.1092, 240.509, -9.5753> }
				triangle { <-59.1092, 240.509, -9.5753>, <-63.4727, 241.2901, -11.7895>, <-56.9184, 239.0088, -13.136> }
				triangle { <-52.3971, 239.1123, -6.08001>, <-59.1092, 240.509, -9.5753>, <-56.9184, 239.0088, -13.136> }
				triangle { <-52.3971, 239.1123, -6.08001>, <-56.9184, 239.0088, -13.136>, <-50.629, 237.7025, -9.2145> }
				triangle { <-52.3971, 239.1123, -6.08001>, <-50.629, 237.7025, -9.2145>, <-40.8146, 235.041, 0.9273> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-37.8048, 233.9962, 1.6582>, <-38.7553, 234.4826, 1.9846>, 0.08373 }
				cylinder { <-38.7553, 234.4826, 1.9846>, <-39.7058, 234.969, 2.3111>, 0.08373 }
				cylinder { <-39.7058, 234.969, 2.3111>, <-40.6563, 235.4555, 2.6376>, 0.08373 }
				texture {ros}}
			mesh { // leaf
				triangle { <-40.6563, 235.4555, 2.6376>, <-50.1014, 243.2253, 10.506>, <-52.3131, 242.5574, 6.314> }
				triangle { <-50.1014, 243.2253, 10.506>, <-56.4894, 246.2056, 13.1299>, <-52.3131, 242.5574, 6.314> }
				triangle { <-56.4894, 246.2056, 13.1299>, <-58.9927, 245.579, 8.6536>, <-52.3131, 242.5574, 6.314> }
				triangle { <-56.4894, 246.2056, 13.1299>, <-63.3352, 247.4046, 10.1904>, <-58.9927, 245.579, 8.6536> }
				triangle { <-58.9927, 245.579, 8.6536>, <-63.3352, 247.4046, 10.1904>, <-60.01797, 245.2053, 4.348> }
				triangle { <-52.3131, 242.5574, 6.314>, <-58.9927, 245.579, 8.6536>, <-60.01797, 245.2053, 4.348> }
				triangle { <-52.3131, 242.5574, 6.314>, <-60.01797, 245.2053, 4.348>, <-53.3586, 242.1575, 2.6145> }
				triangle { <-52.3131, 242.5574, 6.314>, <-53.3586, 242.1575, 2.6145>, <-40.6563, 235.4555, 2.6376> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-2.1983, 209.7604, -9.8875>, <-5.05964, 213.0665, -9.1145>, 0.0666 }
		cylinder { <-5.05964, 213.0665, -9.1145>, <-9.06566, 214.2939, -7.6447>, 0.0666 }
		cylinder { <-9.06566, 214.2939, -7.6447>, <-12.9734, 213.0616, -5.9342>, 0.0666 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-12.9734, 213.0616, -5.9342>, <-13.7758, 212.4532, -5.5425>, 0.08103 }
			cylinder { <-13.7758, 212.4532, -5.5425>, <-14.3487, 211.5976, -5.2149>, 0.08103 }
			cylinder { <-14.3487, 211.5976, -5.2149>, <-14.6342, 210.5814, -4.9844>, 0.08103 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-14.6342, 210.5814, -4.9844>, <-14.777, 210.0732, -4.8691>, 0.08103 }
				cylinder { <-14.777, 210.0732, -4.8691>, <-14.9198, 209.5651, -4.7539>, 0.08103 }
				cylinder { <-14.9198, 209.5651, -4.7539>, <-15.06259, 209.057, -4.6386>, 0.08103 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.06259, 209.057, -4.6386>, <-15.07498, 209.0242, -4.6401>, 0.002626 }
				cylinder { <-15.07498, 209.0242, -4.6401>, <-15.08959, 208.9941, -4.6503>, 0.002626 }
				cylinder { <-15.08959, 208.9941, -4.6503>, <-15.1053, 208.9687, -4.6685>, 0.002626 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.1053, 208.9687, -4.6685>, <-16.38, 206.7974, -5.2116>, <-16.4056, 207.2425, -5.9326> }
				triangle { <-16.38, 206.7974, -5.2116>, <-16.9171, 205.7739, -5.8738>, <-16.4056, 207.2425, -5.9326> }
				triangle { <-16.9171, 205.7739, -5.8738>, <-16.9616, 206.235, -6.663>, <-16.4056, 207.2425, -5.9326> }
				triangle { <-16.9171, 205.7739, -5.8738>, <-17.2983, 205.5798, -7.14>, <-16.9616, 206.235, -6.663> }
				triangle { <-16.9616, 206.235, -6.663>, <-17.2983, 205.5798, -7.14>, <-17.02548, 206.7999, -7.2067> }
				triangle { <-16.4056, 207.2425, -5.9326>, <-16.9616, 206.235, -6.663>, <-17.02548, 206.7999, -7.2067> }
				triangle { <-16.4056, 207.2425, -5.9326>, <-17.02548, 206.7999, -7.2067>, <-16.449, 207.7143, -6.4267> }
				triangle { <-16.4056, 207.2425, -5.9326>, <-16.449, 207.7143, -6.4267>, <-15.1053, 208.9687, -4.6685> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-15.06259, 209.057, -4.6386>, <-15.2053, 208.5488, -4.5234>, 0.08103 }
				cylinder { <-15.2053, 208.5488, -4.5234>, <-15.3481, 208.0407, -4.4081>, 0.08103 }
				cylinder { <-15.3481, 208.0407, -4.4081>, <-15.4909, 207.5326, -4.2929>, 0.08103 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.4909, 207.5326, -4.2929>, <-15.4963, 207.5018, -4.2771>, 0.002626 }
				cylinder { <-15.4963, 207.5018, -4.2771>, <-15.4976, 207.4754, -4.2541>, 0.002626 }
				cylinder { <-15.4976, 207.4754, -4.2541>, <-15.4946, 207.4554, -4.2255>, 0.002626 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.4946, 207.4554, -4.2255>, <-15.1534, 206.7583, -1.7695>, <-15.4668, 206.065, -2.1435> }
				triangle { <-15.1534, 206.7583, -1.7695>, <-14.952, 206.0254, -0.6754>, <-15.4668, 206.065, -2.1435> }
				triangle { <-14.952, 206.0254, -0.6754>, <-15.2916, 205.2648, -1.05426>, <-15.4668, 206.065, -2.1435> }
				triangle { <-14.952, 206.0254, -0.6754>, <-15.1584, 204.7429, -0.3614>, <-15.2916, 205.2648, -1.05426> }
				triangle { <-15.2916, 205.2648, -1.05426>, <-15.1584, 204.7429, -0.3614>, <-15.7055, 204.7551, -1.4875> }
				triangle { <-15.4668, 206.065, -2.1435>, <-15.2916, 205.2648, -1.05426>, <-15.7055, 204.7551, -1.4875> }
				triangle { <-15.4668, 206.065, -2.1435>, <-15.7055, 204.7551, -1.4875>, <-15.8056, 205.5996, -2.5139> }
				triangle { <-15.4668, 206.065, -2.1435>, <-15.8056, 205.5996, -2.5139>, <-15.4946, 207.4554, -4.2255> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-15.4909, 207.5326, -4.2929>, <-15.6336, 207.0244, -4.1777>, 0.08103 }
				cylinder { <-15.6336, 207.0244, -4.1777>, <-15.7764, 206.5163, -4.06245>, 0.08103 }
				cylinder { <-15.7764, 206.5163, -4.06245>, <-15.9192, 206.0082, -3.9472>, 0.08103 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.9192, 206.0082, -3.9472>, <-15.9316, 205.9754, -3.9486>, 0.002626 }
				cylinder { <-15.9316, 205.9754, -3.9486>, <-15.9462, 205.9453, -3.9588>, 0.002626 }
				cylinder { <-15.9462, 205.9453, -3.9588>, <-15.962, 205.9199, -3.977>, 0.002626 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.962, 205.9199, -3.977>, <-17.2366, 203.7486, -4.5201>, <-17.2623, 204.1937, -5.2412> }
				triangle { <-17.2366, 203.7486, -4.5201>, <-17.7738, 202.7251, -5.1824>, <-17.2623, 204.1937, -5.2412> }
				triangle { <-17.7738, 202.7251, -5.1824>, <-17.8182, 203.1862, -5.9716>, <-17.2623, 204.1937, -5.2412> }
				triangle { <-17.7738, 202.7251, -5.1824>, <-18.155, 202.531, -6.4485>, <-17.8182, 203.1862, -5.9716> }
				triangle { <-17.8182, 203.1862, -5.9716>, <-18.155, 202.531, -6.4485>, <-17.8821, 203.7511, -6.5153> }
				triangle { <-17.2623, 204.1937, -5.2412>, <-17.8182, 203.1862, -5.9716>, <-17.8821, 203.7511, -6.5153> }
				triangle { <-17.2623, 204.1937, -5.2412>, <-17.8821, 203.7511, -6.5153>, <-17.3056, 204.6655, -5.7353> }
				triangle { <-17.2623, 204.1937, -5.2412>, <-17.3056, 204.6655, -5.7353>, <-15.962, 205.9199, -3.977> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.9192, 206.0082, -3.9472>, <-15.9284, 205.9752, -3.9397>, 0.002626 }
				cylinder { <-15.9284, 205.9752, -3.9397>, <-15.9377, 205.9423, -3.9322>, 0.002626 }
				cylinder { <-15.9377, 205.9423, -3.9322>, <-15.947, 205.9093, -3.9247>, 0.002626 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.947, 205.9093, -3.9247>, <-16.5199, 203.7917, -2.5751>, <-16.7918, 203.6212, -3.3598> }
				triangle { <-16.5199, 203.7917, -2.5751>, <-16.7893, 202.5275, -2.2526>, <-16.7918, 203.6212, -3.3598> }
				triangle { <-16.7893, 202.5275, -2.2526>, <-17.09387, 202.3197, -3.09023>, <-16.7918, 203.6212, -3.3598> }
				triangle { <-16.7893, 202.5275, -2.2526>, <-17.2674, 201.4756, -2.9243>, <-17.09387, 202.3197, -3.09023> }
				triangle { <-17.09387, 202.3197, -3.09023>, <-17.2674, 201.4756, -2.9243>, <-17.4143, 202.3504, -3.808> }
				triangle { <-16.7918, 203.6212, -3.3598>, <-17.09387, 202.3197, -3.09023>, <-17.4143, 202.3504, -3.808> }
				triangle { <-16.7918, 203.6212, -3.3598>, <-17.4143, 202.3504, -3.808>, <-17.0559, 203.6211, -3.9914> }
				triangle { <-16.7918, 203.6212, -3.3598>, <-17.0559, 203.6211, -3.9914>, <-15.947, 205.9093, -3.9247> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-12.9734, 213.0616, -5.9342>, <-14.515, 212.675, -5.1765>, 0.02641 }
		cylinder { <-14.515, 212.675, -5.1765>, <-16.04039, 212.3926, -4.3434>, 0.02641 }
		cylinder { <-16.04039, 212.3926, -4.3434>, <-17.5411, 212.216, -3.4396>, 0.02641 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-17.5411, 212.216, -3.4396>, <-17.8793, 212.2901, -3.141>, 0.03429 }
			cylinder { <-17.8793, 212.2901, -3.141>, <-18.132, 212.4766, -2.8088>, 0.03429 }
			cylinder { <-18.132, 212.4766, -2.8088>, <-18.2737, 212.7568, -2.4764>, 0.03429 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-18.2737, 212.7568, -2.4764>, <-18.3445, 212.8968, -2.3102>, 0.03429 }
				cylinder { <-18.3445, 212.8968, -2.3102>, <-18.4153, 213.0369, -2.144>, 0.03429 }
				cylinder { <-18.4153, 213.0369, -2.144>, <-18.4861, 213.177, -1.9778>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.4861, 213.177, -1.9778>, <-18.4872, 213.1797, -1.9722>, 0.0004703 }
				cylinder { <-18.4872, 213.1797, -1.9722>, <-18.4874, 213.1812, -1.9661>, 0.0004703 }
				cylinder { <-18.4874, 213.1812, -1.9661>, <-18.4866, 213.1813, -1.9599>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.4866, 213.1813, -1.9599>, <-18.6327, 213.4207, -0.9067>, <-18.41, 213.1395, -0.9041> }
				triangle { <-18.6327, 213.4207, -0.9067>, <-18.5523, 213.4669, -0.3507>, <-18.41, 213.1395, -0.9041> }
				triangle { <-18.5523, 213.4669, -0.3507>, <-18.3127, 213.1631, -0.3361>, <-18.41, 213.1395, -0.9041> }
				triangle { <-18.5523, 213.4669, -0.3507>, <-18.2421, 213.1836, 0.02786>, <-18.3127, 213.1631, -0.3361> }
				triangle { <-18.3127, 213.1631, -0.3361>, <-18.2421, 213.1836, 0.02786>, <-18.1592, 212.8733, -0.3934> }
				triangle { <-18.41, 213.1395, -0.9041>, <-18.3127, 213.1631, -0.3361>, <-18.1592, 212.8733, -0.3934> }
				triangle { <-18.41, 213.1395, -0.9041>, <-18.1592, 212.8733, -0.3934>, <-18.2661, 212.8918, -0.9469> }
				triangle { <-18.41, 213.1395, -0.9041>, <-18.2661, 212.8918, -0.9469>, <-18.4866, 213.1813, -1.9599> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-18.4861, 213.177, -1.9778>, <-18.557, 213.3171, -1.8115>, 0.03429 }
				cylinder { <-18.557, 213.3171, -1.8115>, <-18.6278, 213.4571, -1.6453>, 0.03429 }
				cylinder { <-18.6278, 213.4571, -1.6453>, <-18.6986, 213.5972, -1.4791>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.6986, 213.5972, -1.4791>, <-18.7013, 213.6019, -1.4759>, 0.0004703 }
				cylinder { <-18.7013, 213.6019, -1.4759>, <-18.7045, 213.607, -1.4741>, 0.0004703 }
				cylinder { <-18.7045, 213.607, -1.4741>, <-18.708, 213.6122, -1.4741>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.708, 213.6122, -1.4741>, <-19.4064, 214.3868, -1.7904>, <-19.3625, 214.4445, -1.4391> }
				triangle { <-19.4064, 214.3868, -1.7904>, <-19.6997, 214.8676, -1.8145>, <-19.3625, 214.4445, -1.4391> }
				triangle { <-19.6997, 214.8676, -1.8145>, <-19.6607, 214.9382, -1.4358>, <-19.3625, 214.4445, -1.4391> }
				triangle { <-19.6997, 214.8676, -1.8145>, <-19.8443, 215.261, -1.4348>, <-19.6607, 214.9382, -1.4358> }
				triangle { <-19.6607, 214.9382, -1.4358>, <-19.8443, 215.261, -1.4348>, <-19.6267, 214.907, -1.1061> }
				triangle { <-19.3625, 214.4445, -1.4391>, <-19.6607, 214.9382, -1.4358>, <-19.6267, 214.907, -1.1061> }
				triangle { <-19.3625, 214.4445, -1.4391>, <-19.6267, 214.907, -1.1061>, <-19.329, 214.43, -1.1517> }
				triangle { <-19.3625, 214.4445, -1.4391>, <-19.329, 214.43, -1.1517>, <-18.708, 213.6122, -1.4741> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-18.6986, 213.5972, -1.4791>, <-18.7694, 213.7373, -1.3129>, 0.03429 }
				cylinder { <-18.7694, 213.7373, -1.3129>, <-18.8403, 213.8774, -1.1467>, 0.03429 }
				cylinder { <-18.8403, 213.8774, -1.1467>, <-18.9111, 214.0174, -0.9805>, 0.03429 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.9111, 214.0174, -0.9805>, <-18.9122, 214.0202, -0.975>, 0.0004703 }
				cylinder { <-18.9122, 214.0202, -0.975>, <-18.9123, 214.0217, -0.9689>, 0.0004703 }
				cylinder { <-18.9123, 214.0217, -0.9689>, <-18.9115, 214.0218, -0.9627>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.9115, 214.0218, -0.9627>, <-19.05765, 214.2612, 0.09047>, <-18.8349, 213.98, 0.09312> }
				triangle { <-19.05765, 214.2612, 0.09047>, <-18.9772, 214.3073, 0.6465>, <-18.8349, 213.98, 0.09312> }
				triangle { <-18.9772, 214.3073, 0.6465>, <-18.7376, 214.0035, 0.6611>, <-18.8349, 213.98, 0.09312> }
				triangle { <-18.9772, 214.3073, 0.6465>, <-18.667, 214.0241, 1.02511>, <-18.7376, 214.0035, 0.6611> }
				triangle { <-18.7376, 214.0035, 0.6611>, <-18.667, 214.0241, 1.02511>, <-18.5841, 213.7137, 0.6037> }
				triangle { <-18.8349, 213.98, 0.09312>, <-18.7376, 214.0035, 0.6611>, <-18.5841, 213.7137, 0.6037> }
				triangle { <-18.8349, 213.98, 0.09312>, <-18.5841, 213.7137, 0.6037>, <-18.691, 213.7323, 0.05025> }
				triangle { <-18.8349, 213.98, 0.09312>, <-18.691, 213.7323, 0.05025>, <-18.9115, 214.0218, -0.9627> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.9111, 214.0174, -0.9805>, <-18.913, 214.0213, -0.9759>, 0.0004703 }
				cylinder { <-18.913, 214.0213, -0.9759>, <-18.915, 214.0251, -0.9714>, 0.0004703 }
				cylinder { <-18.915, 214.0251, -0.9714>, <-18.9169, 214.029, -0.9668>, 0.0004703 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.9169, 214.029, -0.9668>, <-19.4886, 214.7917, -0.4382>, <-19.3054, 214.6228, -0.1801> }
				triangle { <-19.4886, 214.7917, -0.4382>, <-19.6532, 215.1669, -0.05116>, <-19.3054, 214.6228, -0.1801> }
				triangle { <-19.6532, 215.1669, -0.05116>, <-19.4613, 214.9909, 0.2354>, <-19.3054, 214.6228, -0.1801> }
				triangle { <-19.6532, 215.1669, -0.05116>, <-19.5534, 215.233, 0.5015>, <-19.4613, 214.9909, 0.2354> }
				triangle { <-19.4613, 214.9909, 0.2354>, <-19.5534, 215.233, 0.5015>, <-19.3152, 214.765, 0.4315> }
				triangle { <-19.3054, 214.6228, -0.1801>, <-19.4613, 214.9909, 0.2354>, <-19.3152, 214.765, 0.4315> }
				triangle { <-19.3054, 214.6228, -0.1801>, <-19.3152, 214.765, 0.4315>, <-19.1717, 214.4361, -0.003607> }
				triangle { <-19.3054, 214.6228, -0.1801>, <-19.1717, 214.4361, -0.003607>, <-18.9169, 214.029, -0.9668> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-2.1983, 209.7604, -9.8875>, <-4.6103, 224.2696, -10.3083>, 0.2207 }
		cylinder { <-4.6103, 224.2696, -10.3083>, <-6.6867, 238.8335, -10.6076>, 0.2207 }
		cylinder { <-6.6867, 238.8335, -10.6076>, <-8.4262, 253.4435, -10.7851>, 0.2207 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-8.4262, 253.4435, -10.7851>, <-7.7662, 257.0164, -10.4408>, 0.2737 }
			cylinder { <-7.7662, 257.0164, -10.4408>, <-6.08153, 260.1778, -9.7429>, 0.2737 }
			cylinder { <-6.08153, 260.1778, -9.7429>, <-3.542, 262.6085, -8.762>, 0.2737 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.542, 262.6085, -8.762>, <-2.2723, 263.8239, -8.2715>, 0.2737 }
				cylinder { <-2.2723, 263.8239, -8.2715>, <-1.002637, 265.0392, -7.781>, 0.2737 }
				cylinder { <-1.002637, 265.0392, -7.781>, <0.267, 266.2546, -7.2905>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <0.267, 266.2546, -7.2905>, <0.4992, 266.5081, -7.08672>, 0.02996 }
				cylinder { <0.4992, 266.5081, -7.08672>, <0.6686, 266.7305, -6.8012>, 0.02996 }
				cylinder { <0.6686, 266.7305, -6.8012>, <0.763, 266.9057, -6.4547>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <0.763, 266.9057, -6.4547>, <4.1612, 272.534, -0.757>, <2.2573, 271.0375, 0.7711> }
				triangle { <4.1612, 272.534, -0.757>, <5.5219, 274.4494, 3.08057>, <2.2573, 271.0375, 0.7711> }
				triangle { <5.5219, 274.4494, 3.08057>, <3.4827, 272.891, 4.8031>, <2.2573, 271.0375, 0.7711> }
				triangle { <5.5219, 274.4494, 3.08057>, <4.3201, 274.0241, 7.4111>, <3.4827, 272.891, 4.8031> }
				triangle { <3.4827, 272.891, 4.8031>, <4.3201, 274.0241, 7.4111>, <1.3326, 271.5908, 5.6677> }
				triangle { <2.2573, 271.0375, 0.7711>, <3.4827, 272.891, 4.8031>, <1.3326, 271.5908, 5.6677> }
				triangle { <2.2573, 271.0375, 0.7711>, <1.3326, 271.5908, 5.6677>, <0.4443, 269.8687, 1.6037> }
				triangle { <2.2573, 271.0375, 0.7711>, <0.4443, 269.8687, 1.6037>, <0.763, 266.9057, -6.4547> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <0.267, 266.2546, -7.2905>, <1.5368, 267.47, -6.8>, 0.2737 }
				cylinder { <1.5368, 267.47, -6.8>, <2.8065, 268.6853, -6.3095>, 0.2737 }
				cylinder { <2.8065, 268.6853, -6.3095>, <4.07625, 269.9007, -5.819>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <4.07625, 269.9007, -5.819>, <4.38, 270.1602, -5.8159>, 0.02996 }
				cylinder { <4.38, 270.1602, -5.8159>, <4.6876, 270.3944, -5.9171>, 0.02996 }
				cylinder { <4.6876, 270.3944, -5.9171>, <4.9766, 270.5862, -6.1155>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <4.9766, 270.5862, -6.1155>, <9.6157, 273.914, -12.6801>, <10.6875, 275.1729, -10.3422> }
				triangle { <9.6157, 273.914, -12.6801>, <12.9421, 275.804, -15.04868>, <10.6875, 275.1729, -10.3422> }
				triangle { <12.9421, 275.804, -15.04868>, <14.1527, 277.2168, -12.5803>, <10.6875, 275.1729, -10.3422> }
				triangle { <12.9421, 275.804, -15.04868>, <16.43, 278.4724, -14.00319>, <14.1527, 277.2168, -12.5803> }
				triangle { <14.1527, 277.2168, -12.5803>, <16.43, 278.4724, -14.00319>, <14.4911, 278.4381, -10.2448> }
				triangle { <10.6875, 275.1729, -10.3422>, <14.1527, 277.2168, -12.5803>, <14.4911, 278.4381, -10.2448> }
				triangle { <10.6875, 275.1729, -10.3422>, <14.4911, 278.4381, -10.2448>, <11.08529, 276.2132, -8.3159> }
				triangle { <10.6875, 275.1729, -10.3422>, <11.08529, 276.2132, -8.3159>, <4.9766, 270.5862, -6.1155> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <4.07625, 269.9007, -5.819>, <5.3459, 271.1161, -5.3286>, 0.2737 }
				cylinder { <5.3459, 271.1161, -5.3286>, <6.6157, 272.3314, -4.8381>, 0.2737 }
				cylinder { <6.6157, 272.3314, -4.8381>, <7.8854, 273.5468, -4.3476>, 0.2737 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <7.8854, 273.5468, -4.3476>, <8.1175, 273.8002, -4.1437>, 0.02996 }
				cylinder { <8.1175, 273.8002, -4.1437>, <8.2869, 274.0226, -3.8582>, 0.02996 }
				cylinder { <8.2869, 274.0226, -3.8582>, <8.3813, 274.1979, -3.5118>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <8.3813, 274.1979, -3.5118>, <11.7795, 279.8262, 2.1858>, <9.8756, 278.3297, 3.714> }
				triangle { <11.7795, 279.8262, 2.1858>, <13.1402, 281.7415, 6.02349>, <9.8756, 278.3297, 3.714> }
				triangle { <13.1402, 281.7415, 6.02349>, <11.101, 280.1831, 7.746>, <9.8756, 278.3297, 3.714> }
				triangle { <13.1402, 281.7415, 6.02349>, <11.9384, 281.3163, 10.354>, <11.101, 280.1831, 7.746> }
				triangle { <11.101, 280.1831, 7.746>, <11.9384, 281.3163, 10.354>, <8.951, 278.883, 8.6106> }
				triangle { <9.8756, 278.3297, 3.714>, <11.101, 280.1831, 7.746>, <8.951, 278.883, 8.6106> }
				triangle { <9.8756, 278.3297, 3.714>, <8.951, 278.883, 8.6106>, <8.06266, 277.1609, 4.5466> }
				triangle { <9.8756, 278.3297, 3.714>, <8.06266, 277.1609, 4.5466>, <8.3813, 274.1979, -3.5118> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <7.8854, 273.5468, -4.3476>, <8.1634, 273.8129, -4.2402>, 0.02996 }
				cylinder { <8.1634, 273.8129, -4.2402>, <8.4415, 274.0791, -4.1328>, 0.02996 }
				cylinder { <8.4415, 274.0791, -4.1328>, <8.7195, 274.3452, -4.02542>, 0.02996 }
				texture {ros}}
			mesh { // leaf
				triangle { <8.7195, 274.3452, -4.02542>, <14.7978, 280.5455, -4.5735>, <14.1319, 280.4467, -1.7903> }
				triangle { <14.7978, 280.5455, -4.5735>, <18.1339, 283.3784, -3.5284>, <14.1319, 280.4467, -1.7903> }
				triangle { <18.1339, 283.3784, -3.5284>, <17.4706, 283.3463, -0.5096>, <14.1319, 280.4467, -1.7903> }
				triangle { <18.1339, 283.3784, -3.5284>, <19.6665, 285.1519, 0.3296>, <17.4706, 283.3463, -0.5096> }
				triangle { <17.4706, 283.3463, -0.5096>, <19.6665, 285.1519, 0.3296>, <16.2195, 283.2155, 1.8309> }
				triangle { <14.1319, 280.4467, -1.7903>, <17.4706, 283.3463, -0.5096>, <16.2195, 283.2155, 1.8309> }
				triangle { <14.1319, 280.4467, -1.7903>, <16.2195, 283.2155, 1.8309>, <13.1369, 280.3167, 0.2928> }
				triangle { <14.1319, 280.4467, -1.7903>, <13.1369, 280.3167, 0.2928>, <8.7195, 274.3452, -4.02542> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-8.4262, 253.4435, -10.7851>, <-9.7535, 262.0359, -11.4558>, 0.1308 }
		cylinder { <-9.7535, 262.0359, -11.4558>, <-11.37, 270.5157, -12.6885>, 0.1308 }
		cylinder { <-11.37, 270.5157, -12.6885>, <-13.2671, 278.8371, -14.4764>, 0.1308 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.2671, 278.8371, -14.4764>, <-13.9773, 280.5388, -15.4417>, 0.1561 }
			cylinder { <-13.9773, 280.5388, -15.4417>, <-14.8732, 281.7842, -16.8483>, 0.1561 }
			cylinder { <-14.8732, 281.7842, -16.8483>, <-15.8643, 282.4476, -18.554>, 0.1561 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-15.8643, 282.4476, -18.554>, <-16.3599, 282.7794, -19.4069>, 0.1561 }
				cylinder { <-16.3599, 282.7794, -19.4069>, <-16.8554, 283.1111, -20.2597>, 0.1561 }
				cylinder { <-16.8554, 283.1111, -20.2597>, <-17.351, 283.4428, -21.1126>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-17.351, 283.4428, -21.1126>, <-17.3803, 283.4861, -21.2316>, 0.009747 }
				cylinder { <-17.3803, 283.4861, -21.2316>, <-17.3748, 283.5283, -21.3544>, 0.009747 }
				cylinder { <-17.3748, 283.5283, -21.3544>, <-17.335, 283.5661, -21.4722>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-17.335, 283.5661, -21.4722>, <-17.3468, 285.6551, -25.9725>, <-15.776, 285.3094, -25.6901> }
				triangle { <-17.3468, 285.6551, -25.9725>, <-16.6893, 286.3033, -28.3668>, <-15.776, 285.3094, -25.6901> }
				triangle { <-16.6893, 286.3033, -28.3668>, <-14.9808, 285.9554, -28.1074>, <-15.776, 285.3094, -25.6901> }
				triangle { <-16.6893, 286.3033, -28.3668>, <-14.4727, 286.3287, -29.676>, <-14.9808, 285.9554, -28.1074> }
				triangle { <-14.9808, 285.9554, -28.1074>, <-14.4727, 286.3287, -29.676>, <-13.6069, 285.7746, -27.4942> }
				triangle { <-15.776, 285.3094, -25.6901>, <-14.9808, 285.9554, -28.1074>, <-13.6069, 285.7746, -27.4942> }
				triangle { <-15.776, 285.3094, -25.6901>, <-13.6069, 285.7746, -27.4942>, <-14.5651, 285.1183, -25.2041> }
				triangle { <-15.776, 285.3094, -25.6901>, <-14.5651, 285.1183, -25.2041>, <-17.335, 283.5661, -21.4722> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-17.351, 283.4428, -21.1126>, <-17.8466, 283.7745, -21.9655>, 0.1561 }
				cylinder { <-17.8466, 283.7745, -21.9655>, <-18.3422, 284.1063, -22.8183>, 0.1561 }
				cylinder { <-18.3422, 284.1063, -22.8183>, <-18.8377, 284.438, -23.6712>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.8377, 284.438, -23.6712>, <-18.9278, 284.4745, -23.7575>, 0.009747 }
				cylinder { <-18.9278, 284.4745, -23.7575>, <-19.03945, 284.5034, -23.8174>, 0.009747 }
				cylinder { <-19.03945, 284.5034, -23.8174>, <-19.1646, 284.5227, -23.8465>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-19.1646, 284.5227, -23.8465>, <-24.0461, 285.2218, -23.2989>, <-23.7536, 285.6078, -24.8584> }
				triangle { <-24.0461, 285.2218, -23.2989>, <-26.5531, 285.4465, -23.7984>, <-23.7536, 285.6078, -24.8584> }
				triangle { <-26.5531, 285.4465, -23.7984>, <-26.2884, 285.8792, -25.4866>, <-23.7536, 285.6078, -24.8584> }
				triangle { <-26.5531, 285.4465, -23.7984>, <-27.9209, 286.0115, -25.905>, <-26.2884, 285.8792, -25.4866> }
				triangle { <-26.2884, 285.8792, -25.4866>, <-27.9209, 286.0115, -25.905>, <-25.7103, 286.417, -26.78> }
				triangle { <-23.7536, 285.6078, -24.8584>, <-26.2884, 285.8792, -25.4866>, <-25.7103, 286.417, -26.78> }
				triangle { <-23.7536, 285.6078, -24.8584>, <-25.7103, 286.417, -26.78>, <-23.2886, 286.0401, -26.01428> }
				triangle { <-23.7536, 285.6078, -24.8584>, <-23.2886, 286.0401, -26.01428>, <-19.1646, 284.5227, -23.8465> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-18.8377, 284.438, -23.6712>, <-19.3333, 284.7697, -24.5241>, 0.1561 }
				cylinder { <-19.3333, 284.7697, -24.5241>, <-19.8289, 285.1014, -25.3769>, 0.1561 }
				cylinder { <-19.8289, 285.1014, -25.3769>, <-20.3244, 285.4332, -26.2298>, 0.1561 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-20.3244, 285.4332, -26.2298>, <-20.3537, 285.4765, -26.3488>, 0.009747 }
				cylinder { <-20.3537, 285.4765, -26.3488>, <-20.3482, 285.5186, -26.4716>, 0.009747 }
				cylinder { <-20.3482, 285.5186, -26.4716>, <-20.3084, 285.5565, -26.5894>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-20.3084, 285.5565, -26.5894>, <-20.3203, 287.6454, -31.08976>, <-18.7494, 287.2997, -30.8073> }
				triangle { <-20.3203, 287.6454, -31.08976>, <-19.6628, 288.2937, -33.484>, <-18.7494, 287.2997, -30.8073> }
				triangle { <-19.6628, 288.2937, -33.484>, <-17.9542, 287.9458, -33.2246>, <-18.7494, 287.2997, -30.8073> }
				triangle { <-19.6628, 288.2937, -33.484>, <-17.4461, 288.3191, -34.7932>, <-17.9542, 287.9458, -33.2246> }
				triangle { <-17.9542, 287.9458, -33.2246>, <-17.4461, 288.3191, -34.7932>, <-16.5803, 287.765, -32.6113> }
				triangle { <-18.7494, 287.2997, -30.8073>, <-17.9542, 287.9458, -33.2246>, <-16.5803, 287.765, -32.6113> }
				triangle { <-18.7494, 287.2997, -30.8073>, <-16.5803, 287.765, -32.6113>, <-17.5386, 287.1087, -30.3213> }
				triangle { <-18.7494, 287.2997, -30.8073>, <-17.5386, 287.1087, -30.3213>, <-20.3084, 285.5565, -26.5894> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-20.3244, 285.4332, -26.2298>, <-20.3863, 285.4746, -26.3363>, 0.009747 }
				cylinder { <-20.3863, 285.4746, -26.3363>, <-20.4482, 285.516, -26.4428>, 0.009747 }
				cylinder { <-20.4482, 285.516, -26.4428>, <-20.5101, 285.5574, -26.5493>, 0.009747 }
				texture {ros}}
			mesh { // leaf
				triangle { <-20.5101, 285.5574, -26.5493>, <-24.074, 287.3671, -29.4889>, <-22.7189, 287.4493, -30.3967> }
				triangle { <-24.074, 287.3671, -29.4889>, <-25.4112, 288.0531, -31.5689>, <-22.7189, 287.4493, -30.3967> }
				triangle { <-25.4112, 288.0531, -31.5689>, <-23.9764, 288.1675, -32.5866>, <-22.7189, 287.4493, -30.3967> }
				triangle { <-25.4112, 288.0531, -31.5689>, <-24.7879, 288.5872, -34.00909>, <-23.9764, 288.1675, -32.5866> }
				triangle { <-23.9764, 288.1675, -32.5866>, <-24.7879, 288.5872, -34.00909>, <-22.5649, 288.3734, -33.09824> }
				triangle { <-22.7189, 287.4493, -30.3967>, <-23.9764, 288.1675, -32.5866>, <-22.5649, 288.3734, -33.09824> }
				triangle { <-22.7189, 287.4493, -30.3967>, <-22.5649, 288.3734, -33.09824>, <-21.5057, 287.5977, -30.8915> }
				triangle { <-22.7189, 287.4493, -30.3967>, <-21.5057, 287.5977, -30.8915>, <-20.5101, 285.5574, -26.5493> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-13.2671, 278.8371, -14.4764>, <-14.1754, 282.5269, -14.9919>, 0.05752 }
		cylinder { <-14.1754, 282.5269, -14.9919>, <-15.1529, 286.227, -15.234>, 0.05752 }
		cylinder { <-15.1529, 286.227, -15.234>, <-16.1943, 289.9175, -15.2012>, 0.05752 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-16.1943, 289.9175, -15.2012>, <-16.4943, 290.7389, -14.9125>, 0.06906 }
			cylinder { <-16.4943, 290.7389, -14.9125>, <-16.8139, 291.4125, -14.372>, 0.06906 }
			cylinder { <-16.8139, 291.4125, -14.372>, <-17.1208, 291.8703, -13.6343>, 0.06906 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-17.1208, 291.8703, -13.6343>, <-17.2742, 292.0992, -13.2654>, 0.06906 }
				cylinder { <-17.2742, 292.0992, -13.2654>, <-17.4277, 292.3281, -12.8966>, 0.06906 }
				cylinder { <-17.4277, 292.3281, -12.8966>, <-17.5812, 292.557, -12.5278>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-17.5812, 292.557, -12.5278>, <-17.5957, 292.5674, -12.5097>, 0.001907 }
				cylinder { <-17.5957, 292.5674, -12.5097>, <-17.6152, 292.5748, -12.4952>, 0.001907 }
				cylinder { <-17.6152, 292.5748, -12.4952>, <-17.6383, 292.5787, -12.4853>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-17.6383, 292.5787, -12.4853>, <-19.2634, 293.4514, -11.2952>, <-19.5993, 293.0255, -11.7724> }
				triangle { <-19.2634, 293.4514, -11.2952>, <-20.2652, 293.6085, -10.7846>, <-19.5993, 293.0255, -11.7724> }
				triangle { <-20.2652, 293.6085, -10.7846>, <-20.6486, 293.1569, -11.2918>, <-19.5993, 293.0255, -11.7724> }
				triangle { <-20.2652, 293.6085, -10.7846>, <-21.3212, 293.225, -10.972>, <-20.6486, 293.1569, -11.2918> }
				triangle { <-20.6486, 293.1569, -11.2918>, <-21.3212, 293.225, -10.972>, <-20.8473, 292.8311, -11.8431> }
				triangle { <-19.5993, 293.0255, -11.7724>, <-20.6486, 293.1569, -11.2918>, <-20.8473, 292.8311, -11.8431> }
				triangle { <-19.5993, 293.0255, -11.7724>, <-20.8473, 292.8311, -11.8431>, <-19.7868, 292.726, -12.2366> }
				triangle { <-19.5993, 293.0255, -11.7724>, <-19.7868, 292.726, -12.2366>, <-17.6383, 292.5787, -12.4853> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-17.5812, 292.557, -12.5278>, <-17.7346, 292.7859, -12.1589>, 0.06906 }
				cylinder { <-17.7346, 292.7859, -12.1589>, <-17.8881, 293.0148, -11.7901>, 0.06906 }
				cylinder { <-17.8881, 293.0148, -11.7901>, <-18.04157, 293.2437, -11.4212>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.04157, 293.2437, -11.4212>, <-18.04338, 293.2577, -11.4001>, 0.001907 }
				cylinder { <-18.04338, 293.2577, -11.4001>, <-18.03839, 293.272, -11.3796>, 0.001907 }
				cylinder { <-18.03839, 293.272, -11.3796>, <-18.02696, 293.2856, -11.3614>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.02696, 293.2856, -11.3614>, <-16.5041, 294.449, -10.2908>, <-17.1117, 294.5613, -9.9164> }
				triangle { <-16.5041, 294.449, -10.2908>, <-15.9407, 294.9971, -9.4716>, <-17.1117, 294.5613, -9.9164> }
				triangle { <-15.9407, 294.9971, -9.4716>, <-16.585, 295.1341, -9.05404>, <-17.1117, 294.5613, -9.9164> }
				triangle { <-15.9407, 294.9971, -9.4716>, <-16.2444, 295.4859, -8.4887>, <-16.585, 295.1341, -9.05404> }
				triangle { <-16.585, 295.1341, -9.05404>, <-16.2444, 295.4859, -8.4887>, <-17.2164, 295.2542, -8.8632> }
				triangle { <-17.1117, 294.5613, -9.9164>, <-16.585, 295.1341, -9.05404>, <-17.2164, 295.2542, -8.8632> }
				triangle { <-17.1117, 294.5613, -9.9164>, <-17.2164, 295.2542, -8.8632>, <-17.6544, 294.6586, -9.7256> }
				triangle { <-17.1117, 294.5613, -9.9164>, <-17.6544, 294.6586, -9.7256>, <-18.02696, 293.2856, -11.3614> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-18.04157, 293.2437, -11.4212>, <-18.195, 293.4727, -11.05244>, 0.06906 }
				cylinder { <-18.195, 293.4727, -11.05244>, <-18.3484, 293.7016, -10.6836>, 0.06906 }
				cylinder { <-18.3484, 293.7016, -10.6836>, <-18.5019, 293.9305, -10.3147>, 0.06906 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.5019, 293.9305, -10.3147>, <-18.5164, 293.9409, -10.2966>, 0.001907 }
				cylinder { <-18.5164, 293.9409, -10.2966>, <-18.536, 293.9483, -10.2821>, 0.001907 }
				cylinder { <-18.536, 293.9483, -10.2821>, <-18.5591, 293.9522, -10.2722>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.5591, 293.9522, -10.2722>, <-20.1841, 294.8249, -9.08221>, <-20.52, 294.399, -9.5594> }
				triangle { <-20.1841, 294.8249, -9.08221>, <-21.1859, 294.982, -8.5716>, <-20.52, 294.399, -9.5594> }
				triangle { <-21.1859, 294.982, -8.5716>, <-21.5693, 294.5303, -9.07885>, <-20.52, 294.399, -9.5594> }
				triangle { <-21.1859, 294.982, -8.5716>, <-22.242, 294.5985, -8.7589>, <-21.5693, 294.5303, -9.07885> }
				triangle { <-21.5693, 294.5303, -9.07885>, <-22.242, 294.5985, -8.7589>, <-21.7681, 294.2046, -9.6301> }
				triangle { <-20.52, 294.399, -9.5594>, <-21.5693, 294.5303, -9.07885>, <-21.7681, 294.2046, -9.6301> }
				triangle { <-20.52, 294.399, -9.5594>, <-21.7681, 294.2046, -9.6301>, <-20.7076, 294.0994, -10.02364> }
				triangle { <-20.52, 294.399, -9.5594>, <-20.7076, 294.0994, -10.02364>, <-18.5591, 293.9522, -10.2722> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-18.5019, 293.9305, -10.3147>, <-18.5104, 293.9431, -10.2943>, 0.001907 }
				cylinder { <-18.5104, 293.9431, -10.2943>, <-18.5189, 293.9557, -10.274>, 0.001907 }
				cylinder { <-18.5189, 293.9557, -10.274>, <-18.5273, 293.9684, -10.2536>, 0.001907 }
				texture {ros}}
			mesh { // leaf
				triangle { <-18.5273, 293.9684, -10.2536>, <-18.5918, 295.3626, -8.5593>, <-19.2784, 295.1557, -8.6476> }
				triangle { <-18.5918, 295.3626, -8.5593>, <-18.9121, 295.8945, -7.6088>, <-19.2784, 295.1557, -8.6476> }
				triangle { <-18.9121, 295.8945, -7.6088>, <-19.6597, 295.6869, -7.6875>, <-19.2784, 295.1557, -8.6476> }
				triangle { <-18.9121, 295.8945, -7.6088>, <-19.9029, 296.012, -7.05945>, <-19.6597, 295.6869, -7.6875> }
				triangle { <-19.6597, 295.6869, -7.6875>, <-19.9029, 296.012, -7.05945>, <-20.2592, 295.5172, -7.9351> }
				triangle { <-19.2784, 295.1557, -8.6476>, <-19.6597, 295.6869, -7.6875>, <-20.2592, 295.5172, -7.9351> }
				triangle { <-19.2784, 295.1557, -8.6476>, <-20.2592, 295.5172, -7.9351>, <-19.8067, 294.9987, -8.839> }
				triangle { <-19.2784, 295.1557, -8.6476>, <-19.8067, 294.9987, -8.839>, <-18.5273, 293.9684, -10.2536> }
				texture {ros}}
			}
		}
	union { // internode
		cylinder { <-16.1943, 289.9175, -15.2012>, <-16.5807, 291.4005, -15.2095>, 0.02298 }
		cylinder { <-16.5807, 291.4005, -15.2095>, <-16.9369, 292.8907, -15.2392>, 0.02298 }
		cylinder { <-16.9369, 292.8907, -15.2392>, <-17.2629, 294.3873, -15.2903>, 0.02298 }
		texture {ros}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-17.2629, 294.3873, -15.2903>, <-17.2413, 294.7959, -15.3782>, 0.03138 }
			cylinder { <-17.2413, 294.7959, -15.3782>, <-17.1114, 295.1632, -15.531>, 0.03138 }
			cylinder { <-17.1114, 295.1632, -15.531>, <-16.8862, 295.4521, -15.7334>, 0.03138 }
			texture {ros}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-16.8862, 295.4521, -15.7334>, <-16.7736, 295.5966, -15.8346>, 0.03138 }
				cylinder { <-16.7736, 295.5966, -15.8346>, <-16.661, 295.7411, -15.9358>, 0.03138 }
				cylinder { <-16.661, 295.7411, -15.9358>, <-16.5484, 295.8855, -16.03705>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-16.5484, 295.8855, -16.03705>, <-16.5449, 295.8892, -16.03835>, 0.0003941 }
				cylinder { <-16.5449, 295.8892, -16.03835>, <-16.541, 295.8927, -16.03831>, 0.0003941 }
				cylinder { <-16.541, 295.8927, -16.03831>, <-16.5369, 295.8958, -16.03693>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-16.5369, 295.8958, -16.03693>, <-15.8736, 296.6409, -16.04795>, <-15.8417, 296.5078, -15.7494> }
				triangle { <-15.8736, 296.6409, -16.04795>, <-15.4614, 296.9332, -15.9436>, <-15.8417, 296.5078, -15.7494> }
				triangle { <-15.4614, 296.9332, -15.9436>, <-15.4202, 296.7975, -15.6187>, <-15.8417, 296.5078, -15.7494> }
				triangle { <-15.4614, 296.9332, -15.9436>, <-15.1434, 296.9773, -15.5374>, <-15.4202, 296.7975, -15.6187> }
				triangle { <-15.4202, 296.7975, -15.6187>, <-15.1434, 296.9773, -15.5374>, <-15.4684, 296.6733, -15.3447> }
				triangle { <-15.8417, 296.5078, -15.7494>, <-15.4202, 296.7975, -15.6187>, <-15.4684, 296.6733, -15.3447> }
				triangle { <-15.8417, 296.5078, -15.7494>, <-15.4684, 296.6733, -15.3447>, <-15.8719, 296.3971, -15.5104> }
				triangle { <-15.8417, 296.5078, -15.7494>, <-15.8719, 296.3971, -15.5104>, <-16.5369, 295.8958, -16.03693> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-16.5484, 295.8855, -16.03705>, <-16.4358, 296.03, -16.1382>, 0.03138 }
				cylinder { <-16.4358, 296.03, -16.1382>, <-16.3232, 296.1745, -16.2394>, 0.03138 }
				cylinder { <-16.3232, 296.1745, -16.2394>, <-16.2106, 296.3189, -16.3406>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-16.2106, 296.3189, -16.3406>, <-16.2086, 296.3222, -16.3442>, 0.0003941 }
				cylinder { <-16.2086, 296.3222, -16.3442>, <-16.2077, 296.325, -16.3486>, 0.0003941 }
				cylinder { <-16.2077, 296.325, -16.3486>, <-16.2078, 296.3269, -16.3535>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-16.2078, 296.3269, -16.3535>, <-16.5387, 296.5566, -17.2663>, <-16.2724, 296.7445, -17.2264> }
				triangle { <-16.5387, 296.5566, -17.2663>, <-16.5558, 296.7137, -17.7575>, <-16.2724, 296.7445, -17.2264> }
				triangle { <-16.5558, 296.7137, -17.7575>, <-16.2705, 296.9214, -17.7238>, <-16.2724, 296.7445, -17.2264> }
				triangle { <-16.5558, 296.7137, -17.7575>, <-16.2636, 297.0287, -18.04636>, <-16.2705, 296.9214, -17.7238> }
				triangle { <-16.2705, 296.9214, -17.7238>, <-16.2636, 297.0287, -18.04636>, <-16.05399, 297.1066, -17.616> }
				triangle { <-16.2724, 296.7445, -17.2264>, <-16.2705, 296.9214, -17.7238>, <-16.05399, 297.1066, -17.616> }
				triangle { <-16.2724, 296.7445, -17.2264>, <-16.05399, 297.1066, -17.616>, <-16.0771, 296.9029, -17.1421> }
				triangle { <-16.2724, 296.7445, -17.2264>, <-16.0771, 296.9029, -17.1421>, <-16.2078, 296.3269, -16.3535> }
				texture {ros}}
			union { // compound leaf internode
				cylinder { <-16.2106, 296.3189, -16.3406>, <-16.09801, 296.4634, -16.4418>, 0.03138 }
				cylinder { <-16.09801, 296.4634, -16.4418>, <-15.9854, 296.6079, -16.543>, 0.03138 }
				cylinder { <-15.9854, 296.6079, -16.543>, <-15.8728, 296.7523, -16.6442>, 0.03138 }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.8728, 296.7523, -16.6442>, <-15.8693, 296.756, -16.6455>, 0.0003941 }
				cylinder { <-15.8693, 296.756, -16.6455>, <-15.8654, 296.7596, -16.6455>, 0.0003941 }
				cylinder { <-15.8654, 296.7596, -16.6455>, <-15.8613, 296.7626, -16.6441>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.8613, 296.7626, -16.6441>, <-15.198, 297.5077, -16.6551>, <-15.1661, 297.3746, -16.3566> }
				triangle { <-15.198, 297.5077, -16.6551>, <-14.7858, 297.8, -16.5508>, <-15.1661, 297.3746, -16.3566> }
				triangle { <-14.7858, 297.8, -16.5508>, <-14.7445, 297.6643, -16.226>, <-15.1661, 297.3746, -16.3566> }
				triangle { <-14.7858, 297.8, -16.5508>, <-14.4678, 297.8441, -16.1447>, <-14.7445, 297.6643, -16.226> }
				triangle { <-14.7445, 297.6643, -16.226>, <-14.4678, 297.8441, -16.1447>, <-14.7928, 297.5402, -15.9519> }
				triangle { <-15.1661, 297.3746, -16.3566>, <-14.7445, 297.6643, -16.226>, <-14.7928, 297.5402, -15.9519> }
				triangle { <-15.1661, 297.3746, -16.3566>, <-14.7928, 297.5402, -15.9519>, <-15.1963, 297.2639, -16.1176> }
				triangle { <-15.1661, 297.3746, -16.3566>, <-15.1963, 297.2639, -16.1176>, <-15.8613, 296.7626, -16.6441> }
				texture {ros}}
			union { // compound leaf petiolet
				cylinder { <-15.8728, 296.7523, -16.6442>, <-15.8699, 296.756, -16.6468>, 0.0003941 }
				cylinder { <-15.8699, 296.756, -16.6468>, <-15.8671, 296.7596, -16.6493>, 0.0003941 }
				cylinder { <-15.8671, 296.7596, -16.6493>, <-15.8643, 296.7632, -16.6519>, 0.0003941 }
				texture {ros}}
			mesh { // leaf
				triangle { <-15.8643, 296.7632, -16.6519>, <-15.5943, 297.4381, -17.3353>, <-15.3853, 297.4858, -17.08657> }
				triangle { <-15.5943, 297.4381, -17.3353>, <-15.315, 297.7719, -17.6124>, <-15.3853, 297.4858, -17.08657> }
				triangle { <-15.315, 297.7719, -17.6124>, <-15.08554, 297.8321, -17.3491>, <-15.3853, 297.4858, -17.08657> }
				triangle { <-15.315, 297.7719, -17.6124>, <-14.887, 298.0483, -17.5206>, <-15.08554, 297.8321, -17.3491> }
				triangle { <-15.08554, 297.8321, -17.3491>, <-14.887, 298.0483, -17.5206>, <-14.9562, 297.8684, -17.07559> }
				triangle { <-15.3853, 297.4858, -17.08657>, <-15.08554, 297.8321, -17.3491>, <-14.9562, 297.8684, -17.07559> }
				triangle { <-15.3853, 297.4858, -17.08657>, <-14.9562, 297.8684, -17.07559>, <-15.262, 297.5164, -16.8538> }
				triangle { <-15.3853, 297.4858, -17.08657>, <-15.262, 297.5164, -16.8538>, <-15.8643, 296.7632, -16.6519> }
				texture {ros}}
			}
		}
} // end Copy_of_New_plant_4

