//Standard include files
#include "colors.inc"
#include "textures.inc"
#include "stoneold.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"


global_settings{max_trace_level 64}
//-------------------------------------------------------------------------------------------------------------------
#declare T_Spiegel_Glass =
texture
{
 pigment{rgb<1,1,1>}
 finish
 {
  ambient 0
  diffuse 0
  reflection 1
 }
}
//----------------------------------------------------------------------------------------------------
#declare Blatt =
prism
{
  linear_sweep
	linear_spline
  -0.05,
   0.05,
  4,
  <-0.5,0>,
  < 0.5,0>,
	< 0,-10>,
	<-0.5,0>
	pigment{colour rgb<0.1,0.8,0>}
	rotate<-84,0,0>
}
//----------------------------------------------------------------------------------------------------

#declare Pusteblumenkopf =
union
{
 sphere{<0,0,0> 0.13 pigment{colour rgb<0.1,0.8,0> } }
 #declare Whilei = 0 ;
 #while(Whilei<360)
	object{ Blatt	scale 0.04 translate<0.08,0.08,0> rotate<0,Whilei,0>}
 	#declare Whilei = Whilei+20 ;
 #end
 #declare Whilei = -90 ;
 #declare Rotton = 0 ;
 #while(Whilei<90)
 	#declare Whilej = 0 ;
	#if( cos(Whilei) = 0)
		#declare Increment = 360 ;
	#else
		#declare Increment = abs(18/cos(Whilei)) ;
	#end
        #declare Color_Seide =color<1,1-Rotton,1-Rotton> ;
        #include "Same.inc"
	#while( Whilej<360 )
 		object{SameTau translate<0.07,0,0> rotate<0,0,Whilej> rotate<0,Whilei,0> }
		#declare Whilej = Whilej+Increment ;
	#end
  #declare Whilei = Whilei+18;
  #declare Rotton = Rotton + 0.01 ;
 #end
}
//---------------------------------------------------------------------------------------------------
#declare Pusteblume =
union
{
	object{Pusteblumenkopf}
	cylinder
	{<0,0,0>,<0,-4,0>,0.04
		texture
		{
			pigment
			{
				radial
				frequency 10
				color_map
				{
					[0.0,0.3 colour rgb<0.05,0.95,0.05> colour rgb<0.05,0.85,0.1>]
					[0.3,0.6 colour rgb<0.2,0.6,0.2> colour rgb<0.1,0.7,0.2>]
					[0.6,1.0 colour rgb<0,0.7,0.4> colour rgb<0,0.6,0.5>]
				}
			}
            finish
            {
            	brilliance 1.5
							reflection 0.1
            }
		}
	}
	translate<0,4,0>
}
//--------------------------------------------------------------------------------------------------

#declare Schmetterling_Fuehler =
union
{
 cylinder{<0,0,0><0,0,-0.25>,0.01}
 sphere{<0,0,-0.25>, 0.025}
 rotate<0,0,20>
}
#declare Schmetterling_Koerper =
union
{
 sphere{<0,0,0>,1  scale<0.05,0.05,1> }
 object{Schmetterling_Fuehler rotate<0,18,0> translate<0,0,-0.95>}
 object{Schmetterling_Fuehler rotate<0,-18,0> translate<0,0,-0.95>}
 texture
 {
  pigment{color rgb<0.4,0.25,0.1>}
 }
 normal
 {
  bumps 0.4
  scale<0.1,1,0.1>
 }
 finish
 {
  diffuse 0.8
  brilliance 0.4
  ambient 0.3
 }
}
#declare Schmetterling_Fluegel_Shape_1 =
union
{
 cylinder{<1,0,0><1,0.015,0>,1  scale<1,1,0.6> rotate<0,20,0>}
 cylinder{<1,0,0><1,0.015,0>,1  scale<0.8,1,0.5> rotate<0,-20,0>}
}
#declare Schmetterling_Fluegel_Shape_2 =
union
{
 cylinder{<-1,0,0><-1,0.015,0>,1  scale<1,1,0.6> rotate<0,-20,0>}
 cylinder{<-1,0,0><-1,0.015,0>,1  scale<0.8,1,0.5> rotate<0,20,0>}
}
//------------------------------------------------------------------------------------------------------------
#declare T_Schmetterling =
texture
{
 pigment
 {
  crackle
  color_map
	{
	 [0.05 rgbt<0,0.2,0.5,0>]
	 [0.1 rgbt<0.3,0.3,0.7,0.3>]
	 [0.15 rgbt<0.5,0.5,1,0.4>]
	 [0.2 rgbt<0.7,0.7,1,0.6>]
	 [1 rgbt<0.8,0.6,1,0.7>]
	}
	scale 0.2
 }
 finish
 {
  specular 1
  roughness 0.001
  ambient 0.3
  diffuse 0.95
  reflection 0.05
  irid{ 0.2 thickness 0.2 turbulence 0.5 }
 }
}
#declare I_Schmetterling=
interior
{
 ior 1.5
}
//--------------------------------------------------------------------------------------------------------------------
#declare Fluegel_Schlag = 25 ;
#declare Schmetterling =
union
{
 object{Schmetterling_Koerper}
 object{Schmetterling_Fluegel_Shape_1 texture{T_Schmetterling translate<0.8,0,0>} interior{I_Schmetterling} rotate<0,0,Fluegel_Schlag> }
 object{Schmetterling_Fluegel_Shape_2 texture{T_Schmetterling translate<-0.8,0,0>} interior{I_Schmetterling} rotate<0,0,-Fluegel_Schlag>}
}
//------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------------------------
camera
{
  location  <0,4.8,-3.7> // position of camera <X Y Z>
  look_at <0,4.9,120000>
  rotate<0,-10,0>
}
//--------------------------------------------------------------------------------------------------------------------

light_source
{
  0*x                     // light's position (translated below)
  color rgb 2             // light's color
  spotlight               // this kind of light source
  translate <0, 8, 0> // <x y z> position of light
  point_at <0.1,5.3,0>    // direction of spotlight
  radius 3               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 70               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb 2             // light's color
  spotlight               // this kind of light source
  translate <0, 2, -2> // <x y z> position of light
  point_at <0,0,0>    // direction of spotlight
  radius 3               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 70               // intensity falloff radius (outer, in degrees)
}

//#declare T_Spiegel_Glass = texture{pigment{color White}}
union
{
 difference
 {
  box{<-8,-1,-8><8,21,8>}
  box{<-4,0,-4><4,9,4>}
 }
 plane{<0,0,1>,0 rotate<0,0.75,0> translate<0,0,-3.8> }
 plane{<0,-1,0>,0 rotate<0,0,0.75> translate<0,8.5,0> }
 texture{T_Spiegel_Glass}
}
//---------------------------------------------------------------------------------------------------------------------
media
{
  intervals 10
  scattering { 2, rgb 0.01}
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
}

//----------------------------------------------------------------------------------------------------------------------

object{Pusteblume translate<0,0,0>}
object{Schmetterling rotate<0,0,0> translate<0.1,5.3,0> }

//---------------------------------------------------------------------------------------------
