 
plants.mcr      Ȁ 8"`D  Pdxó   ȀJTEXTMPS           (  6hTU                      3L  // Persistence Of Vision MACRO file
// File:        plants.mcr
// Vers:        3.14159 Mac PPC unofficial superpatch
// Project:     Lindenmayer systems for plants
// Desc:        support macros for growing plants
// Auth:        Peter Murray

#debug "\r  plants.mcr - define macros for Lindenmayer-system plants\r"

// There probably aren't enough comments to understand this without
// reading "The Algorithmic Beauty of Plants" by Przemyslaw Prusinkiewicz
// and Aristid Lindenmayer (Springer-Verlag 1990).

/* Macro list:
	DrawLS(pLocn,pRotn,pObject,pDelta)
	Rewrite(pObject,pRules)
*/

/* Standardised parameters:
	g*      global
		gColour turtle colour
		gLength turtle length
		gLocn   turtle location
		gRotn   turtle heading
		gTurtle turtle pointer
		gWidth  turtle width
	p*      parameter
		pDelta  delta angle for "turtle"
		pLocn   Location to start "turtle"
		pObject array[*] of strings representing an object definition
		pRotn   Initial heading of "turtle"
		pRules  array[*,2] of "axiom","production"
		        Note: The first matched axiom will be used, so if you need
		        both "A" and "AB", put "AB" first in the list.
	r*      returned value
		rObject array[*] of strings representing an object definition
*/

#macro Rewrite(pObject,pRules)
	// Non-iterative, non-recursive; it rewrites one level only.
	// Returns rObject
	#local jj=0;
	//#write(DebugFile,"Input  is ")
	#while (jj<dimension_size(pObject,1))
		//#write(DebugFile,pObject[jj])
		#local jj=jj+1;
	#end
	//#write(DebugFile,"\n")
	#local InputObject=concat(pObject[0],pObject[1])
	#local IObjectN=0;
	#local IObjectL=dimension_size(pObject,1);
	#declare rObject=array[360]{
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","","",
		"","","","","","","","","","","","","","","","","","","",""
	}
	#local rObjectN=0;
	#local rObjectL=dimension_size(rObject,1);
	#local NRules=dimension_size(pRules,1);
	#while (strlen(InputObject)>0)
		#if ((strlen(InputObject)<10)&(IObjectN<IObjectL))
			#local InputObject=concat(InputObject,pObject[IObjectN+1])
			#local IObjectN=IObjectN+1;
		#end
		#local TryRule=0;
		//#write(DebugFile,"TryRule is ",TryRule," of ",NRules,"\n")
		#while (TryRule<NRules)
			//#write(DebugFile,"blorkle\n")
			//#write(DebugFile,"Trying rule #",TryRule," against ",InputObject,"\n")
			//#write(DebugFile,"  ",pRules[TryRule][0],"->",pRules[TryRule][1],"\n")
			//The axiom might actually be longer than the remaining object!
			#local AxiomL=strlen(pRules[TryRule][0]);
			#if (AxiomL<=strlen(InputObject))
				#if (strcmp(pRules[TryRule][0],substr(InputObject,1,AxiomL))!=0)
					//oh well - go on to the next one
					#local TryRule=TryRule+1;
				#else
					//If the axiom matches the beginning of the object, replace it
					#declare rObject[rObjectN]=concat(rObject[rObjectN],pRules[TryRule][1])
					//and jump to the end
					#local TryRule=NRules+1;
					// split the result if necessary
					#if ((strlen(rObject[rObjectN])>60)&(rObjectN<rObjectL))
						#declare rObject[rObjectN+1]=substr(rObject[rObjectN],60,strlen(rObject[rObjectN])-60)
						#declare rObject[rObjectN]=substr(rObject[rObjectN],1,60)
						#local rObjectN=rObjectN+1;
					#end
					#local Length=strlen(InputObject);
					//empty it if the last axiom's removed, or remove the axiom
					#if (AxiomL=Length)
						#local InputObject=""
					#else
						#local InputObject=substr(InputObject,1+AxiomL,Length-AxiomL)
					#end
				#end
			#end
		#end
	#end
	#local jj=0;
	#write(DebugFile,"Output is ")
	#while (jj<dimension_size(rObject,1))
		#write(DebugFile,rObject[jj])
		#local jj=jj+1;
	#end
	#write(DebugFile,"\n")
#end

#macro PushStack()
	#if (gTurtle>=TurtleStack)
		#debug "\nIncrease TurtleStack value\n  PushStack call failed\n"
	#end
	//#write(DebugFile,"\n//PushStack(",gTurtle,")\n")
	//#write(DebugFile,"//  ",gLocn,",",gRotn,",",gLength,",",gWidth,"\n")
	//#declare gColourS[gTurtle]=gColour;
	#declare gLengthS[gTurtle]=gLength;
	#declare gLocnS[gTurtle]=gLocn;
	#declare gRotnS[gTurtle]=gRotn;
	#declare gWidthS[gTurtle]=gWidth;
	#declare gTurtle=gTurtle+1;
	#if (gTurtle>=TurtleStack)
		#debug "\nIncrease TurtleStack value\n  PushStack call failed\n"
	#end
#end

#macro PopStack()
	//#write(DebugFile,"\n//PopStack(",gTurtle,")\n")
	//#write(DebugFile,"//  ",gLocn,",",gRotn,",",gLength,",",gWidth,"\n")
	#declare gTurtle=gTurtle-1;
	#if (gTurtle<0)
		#debug "\nPopStack call failed\n  Probably caused by an earlier error\n"
		#declare gTurtle=0;
	#else
		//#declare gColour=gColourS[gTurtle];
		#declare gLength=gLengthS[gTurtle];
		#declare gLocn=gLocnS[gTurtle];
		#declare gRotn=gRotnS[gTurtle];
		#declare gWidth=gWidthS[gTurtle];
	#end
#end

#macro DrawLS(pLocn,pRotn,pObject,pDelta,pLength,pWidth)
	#ifndef (gTurtle)
		#local gTurtle=0;
		#local TurtleStack=320;
		#local gColourS=array[TurtleStack]//<0,0,0>
		#local gLengthS=array[TurtleStack]//0
		#local gLocnS=array[TurtleStack]//<0,0,0>
		#local gRotnS=array[TurtleStack]//<0,0,0>
		#local gWidthS=array[TurtleStack]//0
	#end
	#declare gRotn=pRotn;
	#declare gLocn=pLocn;
	#declare gLength=pLength;
	#declare gWidth=pWidth;
	PushStack()
	#local InputObject=concat(pObject[0],pObject[1])
	#local IObjectN=0;
	#local IObjectL=dimension_size(pObject,1);
	#write(DebugFile,"\n")
	#while (strlen(InputObject)>0)
		#if ((strlen(InputObject)<10)&(IObjectN<IObjectL))
			#local InputObject=concat(InputObject,pObject[IObjectN+1])
			#local IObjectN=IObjectN+1;
		#end
		//Note the turtle command
		#local TCommand=substr(InputObject,1,1)
		//#write(DebugFile,TCommand)
		//and remove it from the list
		#if (strlen(InputObject)>1)
			#local InputObject=substr(InputObject,2,strlen(InputObject)-1)
		#else
			#local InputObject=""
		#end
		//Now act on the command
		#if (strcmp(TCommand,"F")=0)
			#local Temp=vrotate(<0,gLength,0>,x*gRotn);
			#local Temp=vrotate(Temp,y*gRotn);
			#local Temp=gLocn+vrotate(Temp,z*gRotn);
			sphere{
				gLocn,0.125//gWidth*0.5
				texture{gTexture}
			}
			#write(DebugFile,"  sphere{\n    ",gLocn,",",gWidth,"*0.5\n")
			#write(DebugFile,"    texture{gTexture}\n  }\n")
			cylinder{
				gLocn,Temp,0.125//gWidth*0.5
				texture{gTexture}
			}
			#write(DebugFile,"  cylinder{\n    ",gLocn,",",Temp,",",gWidth,"*0.5\n")
			#write(DebugFile,"    texture{gTexture}\n  }\n")
			#declare gLocn=Temp;
			//#write(DebugFile,"//gLocn=",gLocn,"\n")
		#end
		#if (strcmp(TCommand,"f")=0)
			#declare gLocn=gLocn+vrotate(<0,gLength,0>,gRotn);
			//#write(DebugFile,"//gLocn=",gLocn,"\n")
		#end
		#if (strcmp(TCommand,"+")=0)
			#declare gRotn=gRotn-y*pDelta;
		#end
		#if (strcmp(TCommand,"-")=0)
			#declare gRotn=gRotn+y*pDelta;
		#end
		#if (strcmp(TCommand,"&")=0)
			#declare gRotn=gRotn+x*pDelta;
		#end
		#if (strcmp(TCommand,"^")=0)
			#declare gRotn=gRotn-x*pDelta;
		#end
		#if (strcmp(TCommand,"`")=0)
			#declare gRotn=gRotn+z*pDelta;
		#end
		#if (strcmp(TCommand,"/")=0)
			#declare gRotn=gRotn-z*pDelta;
		#end
		#if (strcmp(TCommand,"|")=0)
			#declare gRotn=gRotn+y*180;
		#end
		#if (strcmp(TCommand,"[")=0)
			PushStack()
			#declare gLength=max(0.75*gLength,0.5);
			#declare gWidth=max(0.75*gWidth,0.5);
		#end
		#if (strcmp(TCommand,"]")=0)
			PopStack()
		#end
	#end
	#write(DebugFile,"\n")
#end
                                                                                                   z j .                       
plants.mcren(EX)pictt 1999e705m`TEXTMPS   ? >                hT   (  6     +` ^   m             z 
~p             ^  
+ ~           
    
Ă 
l         `         	  	         
 
    
         $  6 ` /k"                         H 	Monaco _2  te y*-90 translate      U      S          S                     z6D    z MPSR  "SELc   :styl   FNwPo   R   N       5                   &                                                                              