#if(MiniMushes = true)

#include "MiniShroom01.inc"
#include "MiniShroom02.inc"

//This file contains all the small, silvery mushrooms in the scene
//They are designed not to collide with other objects in the scene
//It's a horrible algorithm, but it was done on short notice
// so I'm stuck with it

#declare MushSet = array [2] { MiniShroom01, MiniShroom02 }

#declare R1 = seed(456);

#declare Iter = 0;

#declare NumObjects = 8;

#declare ObjPositions = array[NumObjects][3] //postions of all the large mushrooms
                                             //and anything else that might pop up
{                                            //goes here
 { 7, 0.05, 5.2 }, //XYZ style
 { 5.5, 0, 7.5 },
 { 3.5, 1, 6.5 },
 { 2.6, 0, 3.5 },
 { 3.5, 0, 1.5 },
 { 5.4, 0, 1.6 },
 { 6.8, 0, 3.3 },
 { 4.5, 0, 4.7 }
}

#declare MushPositions = array[Minimush_density][2] //array to store the positions of all the minimushrooms

#while (Iter < Minimush_density) // Main while loop, generate lots of mushrooms!
 
 #declare XPos = 2.75+(rand(R1)*6); //Random X Position, within bounds
 #declare YPos = 0.25;                //Standard Y Position (ground)
 #declare ZPos = 0+(rand(R1)*9.5); //Random Z Position, within bounds

 #declare ShroomSize = 0.35+(rand(R1)*0.05); //Random size, within bounds

 //rough estimates
 #declare RadMin = 0.6; //radius from large mushoom stems
 #declare RadMin2 = 0.4; //radius from each other

 #declare VTIter = 0; //Vector Test Iterator

 #declare Useable = true; //Variable stating coords are useable

 #while(VTIter < NumObjects) //Vector Test while loop starts

 #declare Distance = sqrt( pow(XPos-ObjPositions[VTIter][0],2) + pow(ZPos-ObjPositions[VTIter][2],2) );

 ////////////////////////
  #if(Distance < RadMin)         //If the distance between the random coords 
                                 //and any objects position is too close, declare the coords unusable
   #declare Useable = false;     

  #end
 ////////////////////////
  #declare VTIter = VTIter + 1; //Increment the Vector Test Iterator
 #end

 #declare VTIter = 1;
 
 #while(VTIter <= Iter)
  #declare Distance = sqrt( pow(XPos-MushPositions[VTIter-1][0],2) + pow(ZPos-MushPositions[VTIter-1][1],2) );  
  #if(Distance < RadMin2)
   #declare Useable = false;
  #end
  #declare VTIter = VTIter + 1;
 #end


 #if(Useable = true) //If the coords have been determined to be useable
                     //plot a mushroom at that point
  object { MushSet[floor(rand(R1)*2)]
           scale ShroomSize
           translate <XPos, YPos, ZPos>
           texture { MiniMush_Texture01 }
  }

  #declare MushPositions[Iter][0] = XPos;
  #declare MushPositions[Iter][1] = ZPos;

  #declare Iter = Iter + 1; //Increment the main iterator variable
                                        //only if the coords have been used
 #end
 
#end //end main loop

//////////////////////////////////////////////
#end