#include "colors.inc" 
#include "woods.inc"


global_settings {

ambient_light 0

#declare high_quality=yes; // or yes
#if(high_quality)
  // High Quality - slow rendering
  ini_option "+QR"
  ini_option "Preview_Start_Size=8"
  ini_option "Preview_End_Size=4"
  
  radiosity{
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16 (or 8 for high quality)
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1.2         // leave this
    
    max_sample 1.2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+QR"
  ini_option "Preview_Start_Size=16"
  ini_option "Preview_End_Size=8"
  
  radiosity{
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 2.25     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1.2         // leave this
    
    max_sample 1.2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end 

}
  
    

camera {location 2*<100, 150, -155> look_at 80*y angle 40}

light_source {<100, 200, -50> color White
fade_distance 300 fade_power 1.5
area_light <10, 0, 0>, <0, 0, 10>, 8, 8
adaptive 3
jitter 

 }

height_field { 
tga "dirt.tga"  
water_level .05
translate <-.5, 0, -.5>
scale <43*2, 1, 43*2>
translate 110*y
pigment {color rgb 1.3*<.4, .33, .2>} 
finish {phong .2 phong_size 30}
}

                      
box {<-150, -200, -1000>, <-150, 1000, 1000>
pigment {color White} 
finish {brilliance .8}
normal {
bump_map {
tga "wall.tga"
interpolate 4
}
rotate 90*y
}

}

box {<-160, -200, 150>, <1000, 1000, 160>
pigment {color White}
finish {brilliance .8}
normal {
bump_map {
tga "wall.tga"
interpolate 4
}
}

} 

superellipsoid {<1, .25> 
 
texture {
pigment { 
gradient z
turbulence .2
omega .6
color_map {
[0 color rgb <1, 1, 1>]
[.8 color rgb <1, 1, 1>]
[.8 color rgbt <1, 1, 1, 1>]
[1 color rgbt <1, 1, 1, 1>]
}
scale 3
translate -1.5*z
}
} 

texture {
pigment {
image_map {
tga "cover.tga" 
once
interpolate 4
}
translate <-.5, -.5, 0>
rotate 90*x 
scale <1.5, 1, 1.8>
}
} 

scale <30, 3, 40>
rotate 30*y
translate <70, 1, 60>
}

#declare cutter =
box {<-150, -5, -140>, <150, 1, -125>} 

difference {

superellipsoid {<.15, .15> 
translate -1*y
scale <140, 140, 140>
}

object {cutter}
object {cutter rotate 90*y}
object {cutter rotate 180*y}
object {cutter rotate 270*y}

texture {T_Wood31 scale 40 rotate 60 translate 50*x}
} 

    
#include "styrocup.inc" 

#include "plant.inc"  

#include "seed.inc"

#declare creater = 0;

#declare R1 = seed(123);

#while (creater < 20)

object {Seed 
rotate rand(R1)*360*y
translate -90*z
scale 1- (.1*rand(R1))
translate <rand(R1)*50, 0, rand(R1)*50>
translate -70*x
}

#declare creater = creater + 1;
#end