// PRIMARY SYSTEM FUNCTIONS

// SYSTEM GLOBAL VARIABLES
#declare System_Rand = seed(13);

// MATRIX FUNCTION
// MACRO VERSION OF THE CORE POVRAY COMMAND  
// NO ERROR CHECKING
// EXPECTS AN ARRAY OF FOUR VECTORS   

#macro MATRIX (Val00, Val01, Val02, 
               Val10, Val11, Val12, 
               Val20, Val21, Val22, 
               Val30, Val31, Val32,
               Point)
    
	#local qx = (Val00 * Point.x + Val10 * Point.y + Val20 * Point.z + Val30);
	#local qy = (Val01 * Point.x + Val11 * Point.y + Val21 * Point.z + Val31);
	#local qz = (Val02 * Point.x + Val12 * Point.y + Val22 * Point.z + Val32); 

	// RETURN VALUE
	<qx,qy,qz>;	    

#end                                                               

// AXIS_OBJECT
// FUNCTION WILL CHANGE AN OBJECT FROM ONE COORDINATE SYSTEM TO ANOTHER
// A COORDINATE SYSTEM IS DEFINED BY ITS NORMAL
// THE DEFAULT POV COORDINATE SYSTEM IS <0,1,0>

#macro AXIS_OBJECT (Axis1,Axis2)
	#local vX1=vnormalize(Axis1);
	#local vX2=vnormalize(Axis2);
	#local vY=vnormalize(vcross(vX1,vX2));
	#local vZ1=vnormalize(vcross(vX1,vY));
	#local vZ2=vnormalize(vcross(vX2,vY));
	matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
	matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end

// ALTERNATE VERSION DESIGNED TO WRITE OUTPUT TO FILE
#macro AXIS_OBJECT2 (Axis1,Axis2,File_Name)
	#local vX1=vnormalize(Axis1);
	#local vX2=vnormalize(Axis2);
	#local vY=vnormalize(vcross(vX1,vX2));
	#local vZ1=vnormalize(vcross(vX1,vY));
	#local vZ2=vnormalize(vcross(vX2,vY));
	
	#fopen TEMPFILE File_Name append 

	#write (TEMPFILE, "\nmatrix <")
	#write (TEMPFILE, vX1.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ1.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vX1.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ1.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vX1.z) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.z) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ1.z) #write (TEMPFILE ",")
	#write (TEMPFILE, " 0,0,0>")
	#write (TEMPFILE, "\nmatrix <")
	#write (TEMPFILE, vX2.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vX2.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vX2.z) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vY.z) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ2.x) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ2.y) #write (TEMPFILE ",")
	#write (TEMPFILE, vZ2.z) #write (TEMPFILE ",")
	#write (TEMPFILE, " 0,0,0>")

	#fclose TEMPFILE
#end


// AXIS_POINT
// FUNCTION WILL CHANGE A POINT FROM ONE COORDINATE SYSTEM TO ANOTHER
// A COORDINATE SYSTEM IS DEFINED BY ITS NORMAL
// THE DEFAULT POV COORDINATE SYSTEM IS <0,1,0>

#macro AXIS_POINT (Axis1,Axis2,Point)
	#local vX1=vnormalize(Axis1);
	#local vX2=vnormalize(Axis2);
	#local vY=vnormalize(vcross(vX1,vX2));
	#local vZ1=vnormalize(vcross(vX1,vY));
	#local vZ2=vnormalize(vcross(vX2,vY));
	#local Point2 = MATRIX ( vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0, Point )
	#local Point3 = MATRIX ( vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0, Point2 )

	// RETURN VALUE
	Point3;

#end

// COMPARES TWO VECTORS
// VECTOR1 = VECTOR2
// RETURNS TRUE OR FALSE 
// TYPICAL USE 
// #if (VEQUAL(V1,V2))

#macro VEQUAL (Vector1,Vector2)

	#local V1x = Vector1.x;
	#local V1y = Vector1.y; 
	#local V1z = Vector1.z;
	 
	#local V2x = Vector2.x; 
	#local V2y = Vector2.y; 
	#local V2z = Vector2.z;
	
	#if (V1x = V2x)
		#if (V1y = V2y)
			#if (V1z = V2z)
				#local Result = true;
			#else
				#local Result = false;
			#end
		#else
			#local Result = false;
		#end
	#else
		#local Result = false;
	#end
	
	Result
				     
#end

// DISTANCE BETWEEN TWO POINTS
#macro DIST (V1,V2)
	vlength(V2-V1)
#end

// INTERSECTION POINT OF TWO LINES
// LINE 1 = POINT1 POINT2
// LINE 2 = POINT3 POINT4

// GENERATES A RANDOM UNIT NORMAL

#macro RANDOM_NORMAL ()

	#local S1 = rand(System_Rand);
	#if (S1 <= .5) #local S1 = 1; #else #local S1 = -1; #end
	#local S2 = rand(System_Rand);
	#if (S2 <= .5) #local S2 = 1; #else #local S2 = -1; #end
	#local S3 = rand(System_Rand);
	#if (S3 <= .5) #local S3 = 1; #else #local S3 = -1; #end
	
	vnormalize (<(rand(System_Rand) * S1),(rand(System_Rand) * S2),(rand(System_Rand) * S3)>);

#end

// INITIALIZES TURBULENCE STREAM
// ARRAY VALUE
// TURBULENCE.OCTAVES.LAMBDA.OMEGA
#macro INIT_TURB (Turb_Value,Stream)
	
	#local StreamData = concat (
		"#declare System_Turb", 
		str(Stream,0,0),
		" = array[4]{",
		str(Turb_Value,0,4),
		",6,2,.5}"
	)
	#fopen  TEMPFILE "temp.txt" write
	#write (TEMPFILE StreamData)
	#fclose TEMPFILE
	#include "temp.txt"
#end	

// ASSIGN TURBULENCE STREAM VALUES TO THE GLOBAL SETTINGS
#macro SET_TURB (Stream)

	#local Turb_Data1 = concat ("#declare SYSTurb = System_Turb",str(Stream,0,0),"[0];")
	#local Turb_Data2 = concat ("#declare SYSOct = System_Turb",str(Stream,0,0),"[1];")
	#local Turb_Data3 = concat ("#declare SYSLam = System_Turb",str(Stream,0,0),"[2];")
	#local Turb_Data4 = concat ("#declare SYSOmg = System_Turb",str(Stream,0,0),"[3];") 
	#fopen  TEMPFILE "temp.txt" write
	#write (TEMPFILE Turb_Data1)
	#write (TEMPFILE Turb_Data2)
	#write (TEMPFILE Turb_Data3)
	#write (TEMPFILE Turb_Data4)
	#fclose TEMPFILE
	#include "temp.txt"

#end

// MODIFIED TURBULENCE FUNCTION
// STRENGTH OF TURBULENCE IS ASSOCIATIVE TO "SCALE
// TURBULENCE IS APPLIED TO A SINGLE POINT
// CALCULATES RESULTANT POINT

#macro CALC_TURB (Point,Scale)
        
	// size of 1st step
	// inverse square relationship where Turbulence 1 = 1/2 Scale 
	#local Step = (SYSTurb * sqrt(Scale));

	// set Lamda ratios
	// 1 = small deviation, 2 = fairly random, 3 = totally random
	#local Ratio1 = ((SYSLam * SYSLam) * 0.1);
	#local Ratio2 = (1 - Ratio1);
	#if (Ratio1 < 0)
		#local Ratio1 = 0;
		#local Ratio2 = 1;
	#end   

	// initiate turbulence loop
	#local Turb_Point = Point;
	#local Count1 = 0;				// loop counter

	#while (Count1 < SYSOct)  

		// step one. calculate normal
		#local Temp_Normal = RANDOM_NORMAL()
		#if (Count1 = 0)
			#local Final_Normal = Temp_Normal;
		#else
			#local Temp_Normal2 = (Temp_Normal * Ratio2);
			#local Temp_Normal3 = (Final_Normal * Ratio1);
			#local Final_Normal = vnormalize(Temp_Normal2 + Temp_Normal3);
		#end
		
		// step two. get new point
		#local Step2 = (Step * Final_Normal);
		#local Turb_Point = (Turb_Point + Step2);

		// step three. calculate new step
		#local Step = (Step * SYSOmg);

		#local Count1 = (Count1 + 1);
	#end

	Turb_Point;	
#end

// CONVERSION FUNCTIONS

// VECTOR TO STRING	= VTOS
#macro VTOS (Vector,Precision)

	#local VX = str(Vector.x,0,Precision);
	#local VY = str(Vector.y,0,Precision);
	#local VZ = str(Vector.z,0,Precision);

	concat ("<",VX,",",VY,","VZ,">");
#end

// STRING TO VECTOR	= STOV
// ARRAY TO STRING	= ATOS
// STRING TO ARRAY	= STOA
// ARRAY TO VECTOR	= ATOV
#macro ATOV (Array)
	<Array[0],Array[1],Array[2]>;
#end
// VECTOR TO ARRAY	= VTOA
#macro VTOA(Vector)
	array[3]{Vector.x,Vector.y,Vector.z}
#end

// ARRAY FUNCTIONS
// APPEND ONE ARRAY TO ANOTHER	= CONCAT_ARRAY
// CREATE A SUB ARRAY			= SUB_ARRAY
// FIND AN ARRAY MEMBER			= SEARCH_ARRAY

// FILE HANDLING FUNCTIONS

// EOF
