// wall texture and placement macros

#include "stones.inc"

#declare Wall_Rand = seed(13);

#macro rand_texture ()  
	#local TT = int(rand(Wall_Rand) * 6);
	#if (TT = 0) texture{STONE1 scale .2} #end 
	#if (TT = 1) texture{STONE2 scale .1} #end
	#if (TT = 2) texture{STONE3 scale .5} #end
	#if (TT = 3) texture{STONE4 scale .2} #end
	#if (TT = 4) texture{STONE5 scale .3} #end
	#if (TT = 5) texture{STONE6 scale .1} #end
	#if (TT = 6) texture{STONE7 scale .4} #end
	
#end 

#declare Max_Wall_Step = .025;
#declare Max_Wall_Step2 = .25;

#macro rand_translate ( Value )
	#if (Value > 0)
		#if (Value = 1) 
			#local S1 = rand(Wall_Rand);
			#if (S1 > .5) #local S1 = 1; #else #local S1 = -1; #end
			#local TX = (rand(Wall_Rand) * Max_Wall_Step * S1);
			translate <TX,0,0>
		#end 
		#if (Value = 2) 
			#local S1 = rand(Wall_Rand);
			#if (S1 > .5) #local S1 = 1; #else #local S1 = -1; #end
			#local TY = (rand(Wall_Rand) * Max_Wall_Step2 * S1);
			translate <0,TY,0>
		#end
		#if (Value = 3) 
			#local S1 = rand(Wall_Rand);
			#if (S1 > .5) #local S1 = 1; #else #local S1 = -1; #end
			#local TZ = (rand(Wall_Rand) * Max_Wall_Step * S1);
			translate <0,0,TZ>
		#end
	#end	
#end
