//Mick's Grass.inc
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Date: dd/mm/99
// Auth: Mick Hazelgrove
/*
#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 15
}

// ----------------------------------------
#declare Image_Length = 640;
#declare Image_Height = 480;

camera
{
  location  <0.0, 0.15, -12.0>
  direction 1.5*z
  right Image_Length/Image_Height*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y turbulence .3 lambda 3
    color_map { [0.0 color rgb <0,.45,.65>] [1.0 color rgb 1] }
  }
}

light_source{<0, 93000000,0> color rgb<1,1,.875>*2 rotate z*-45}

// ----------------------------------------
*/
   
#declare R = seed(3243);
 
#declare blade = mesh {

 #declare No_Segs = 15;
 #declare C = 0;
 #declare Seg_length = .35;
 #declare Rot = 90-(15+(rand(R)*20));
 #declare Ox = 0;
 #declare Oy =0;
 #declare Nx = Seg_length;
 #declare Ny = Seg_length;
 #declare Z= 0.125;  
  
    #while (C<No_Segs)

                #declare xdist = sin(radians(90-Rot))*Seg_length;
                #declare ydist = cos(radians(90-Rot))*Seg_length;
                   #declare No_Segs = 15+(rand(R)*10); 
                    #declare Nx = Ox+xdist; 
                    #declare Ny = Oy+ydist;
                    
                    
               #if (C<(No_Segs-1))
                 triangle{<Ox,Oy,Z> <Ox,Oy,-Z> <Nx,Ny,Z> }
                 triangle{<Ox,Oy,-Z> <Nx,Ny,Z> <Nx,Ny,-Z>}
               #else
                 triangle{<Ox,Oy,Z> <Ox,Oy,-Z> <Nx,Ny,0>}
               #end           
                  #declare Rot = Rot-pow(1.75+(rand(R)),2);
                  #declare Ox = Nx;
                  #declare Oy = Ny;
                  
                #declare Z=Z-0.005;
                #declare Seg_length = Seg_length +.01;   
                #declare C=C+1;
    #end
}//end mesh    

#declare Hor = -3;
#declare Ver = -3;
#declare Rd = seed(123);
#declare C=0;
  
#declare Patch = union{

    #while (Hor<3)
    #declare Rd = seed(123)+C;
       #while (Ver<3)
    object{blade rotate y*-((Ver*20)*rand(R)*120)
        scale y*1+(rand(R)*1.5)
        translate<Hor*1.25,0,Ver*1.25>
        pigment{color rgb<.1+rand(Rd),.1+rand(Rd),0>}
            finish{specular 1 roughness.01}
        }

        #declare Ver = Ver +.75;
        #end
      #declare Ver= -3;
      #declare Hor = Hor+.75;
      #declare C=C+.1;   
    #end               
}//end of union

//object{Patch rotate y*40 scale .5 translate y*-3}
