//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 8 materials and 58 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 01/27/2000    (27.01.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      6.000,     -22.000,       1.000>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight003
  <0.050, -5.000, 10.000>
  color rgb <1.000, 1.000, 1.000>*1.0000
  spotlight
    point_at  <-3.187, 1.943, 3.572>
    falloff    50.000  // outer radius (in deg)
    radius     30.000  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Spotlight001
  <-0.300, 3.500, -12.000>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-0.300, 3.500, -4.000>
    falloff    70.000  // outer radius (in deg)
    radius     50.000  // inner radius
    tightness  20.000
}

light_source {   // Light1
  <0.000, -20.000, 20.000>
  color rgb <1.000, 1.000, 1.000>
}


//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "blfriday.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//





#declare gegenstandA = intersection {
  box { // gegenstand3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-3.3, -5.45, -2.0>
  }
  torus { // Gegenstand2
    1.5, 0.5  rotate -x*90
    hollow
    translate  <-4.3, -4.45, -2.55>
  }
  hollow
  translate  0.05*y
}
#include "D:\3dmodelle\r_schraube.inc"

#declare Helix_Ref = object {
  Helix
  scale 0.02
  rotate <90.0, -45.0, -145.0>
  translate  <5.05, 7.65, -2.3>
}
union { // gesgegenstaende
  cylinder { // Gegenstand1
    <0,0,1>, <0,0,0>, 1 open
    hollow
    scale <0.5, 0.5, 5.0>
    rotate <55.0, -90.0, 0.0>
    translate  <6.7, -2.85, -2.5>
  }
  object { gegenstandA }
  cylinder { // Gegenstand4
    <0,0,1>, <0,0,0>, 1 open
    hollow
    scale <0.5, 0.5, 5.0>
    rotate <-20.0, -90.0, 0.0>
    translate  <-4.65, -1.5, -2.5>
  }
  object { Helix_Ref }
  material {
    texRust
  }
}


plane { // Himmel
  z,0
  material {
    texBlue_Sky
  }
  translate  25.0*z
}


#declare LtgKurve = intersection {
  torus { // LtgKurve1
    1.5, 0.5  rotate -x*90
    scale 0.2
    translate  <4.0, 16.8, 0.0>
  }
  box { // LtgKurve2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.2
    translate  <4.2, 16.6, 0.0>
  }
}
union { // Industrie
  cylinder { // Tonne
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <4.0, 20.0, 0.0>
  }
  sphere { // Tonnenende1
    <0,0,0>,1
    scale <1.0, 2.0, 2.0>
    translate  <4.0, 20.0, 0.0>
  }
  sphere { // Tonnenende2
    <0,0,0>,1
    scale <1.0, 2.0, 2.0>
    translate  <9.0, 20.0, 0.0>
  }
  cone { // Turm
    <0,0,0>, 0.8, <0,0,1>, 1.0
    open
    scale <1.0, 1.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  <1.5, 16.5, 9.0>
  }
  box { // lager1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.5, 1.0>
    translate  <4.0, 20.0, -2.0>
  }
  box { // lager2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.5, 1.0>
    translate  <9.0, 20.0, -2.0>
  }
  cylinder { // Leitung1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate <90.0, -0.0, 90.0>
    translate  <2.0, 16.5, 0.0>
  }
  cylinder { // Leitung2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate <90.0, -0.0, 0.0>
    translate  <4.3, 18.8, 0.0>
  }
  object { LtgKurve }
  cylinder { // Rohr1
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 7.0>
    rotate -90.0*x
    translate  <1.5, 16.5, -1.7>
  }
  superellipsoid { // Kolonne1
    <1.0, 0.25>
    scale <2.0, 2.0, 4.0>
    translate  <1.5, 25.0, 1.0>
  }
  superellipsoid { // Kolonne2
    <1.0, 0.25>
    scale <2.0, 2.0, 4.0>
    translate  <-3.0, 25.0, 1.0>
  }
  cylinder { // KolVdg
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.5>
    rotate -90.0*y
    translate  <1.45, 25.0, 3.5>
  }
  material {
    texRust
  }
}


cylinder { // Stuetze
  <0,0,1>, <0,0,0>, 1 
  material {
    texHolz
  }
  scale <0.25, 0.25, 9.0>
  rotate 45.0*x
  translate  <-0.5, 11.3, -3.2>
}


#declare SchnittA = intersection {
  box { // schnitt2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.5, 10.0>
    rotate -5.0*z
    translate  <-6.5, 5.0, -12.5>
  }
  box { // schnitt3
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 10.0>
    translate  <-6.75, 3.5, -12.5>
  }
}
#declare SchnittB = intersection {
  box { // schnitt4
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 10.0>
    rotate 20.0*z
    translate  <-6.4, 1.35, -12.5>
  }
  box { // schnitt5
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 10.0>
    rotate 10.0*z
    translate  <-6.75, 2.5, -12.5>
  }
}
#declare SchnittC = intersection {
  box { // schnitt6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate -35.0*z
    translate  <-3.85, -1.75, -12.5>
  }
  box { // schnitt7
    <-1, -1, -1>, <1, 1, 1>
    scale <6.5, 1.0, 10.0>
    rotate 45.0*z
    translate  <-4.5, -1.1, -12.5>
  }
}
#declare SchnittD = intersection {
  box { // schnitt8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate -5.0*z
    translate  <-0.8, -2.65, -12.5>
  }
  box { // schnitt9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate <-0.0, -0.0, 5.0>
    translate  <0.2, -2.65, -12.5>
  }
}
#declare SchnittE = intersection {
  box { // schnitt10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate <-0.0, -0.0, 50.0>
    translate  <3.55, -0.5, -12.5>
  }
  box { // schnitt11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate 35.0*z
    translate  <2.95, -1.25, -12.5>
  }
}
#declare SchnittF = intersection {
  box { // schnitt12
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 10.0>
    rotate <-0.0, 0.0, -10.0>
    translate  <6.25, 2.5, -12.5>
  }
  box { // schnitt13
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 10.0>
    translate  <6.25, 3.5, -12.5>
  }
}
#declare SchnittG = intersection {
  box { // schnitt14
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 10.0>
    rotate <-0.0, 0.0, 45.0>
    translate  <4.6, 7.4, -12.5>
  }
  box { // schnitt15
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 10.0>
    rotate 55.0*z
    translate  <3.75, 7.8, -12.5>
  }
}
#declare SchnittH = intersection {
  box { // schnitt16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate 5.0*z
    translate  <1.05, -3.6, -12.5>
  }
  box { // schnitt17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 10.0>
    rotate <-0.0, -0.0, 15.0>
    translate  <2.0, -3.45, -12.5>
  }
}
#declare schnitt = union {
  box { // schnitt1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 10.0>
    translate  <-0.3, 3.5, -12.5>
  }
  object { SchnittA }
  object { SchnittB }
  object { SchnittC }
  object { SchnittD }
  object { SchnittE }
  object { SchnittF }
  object { SchnittG }
  object { SchnittH }
  material {
    texfire
  }
}
difference { // bodenfertig
  plane { // boden
    z,0
    material {
      texboden
    }
    translate  -3.0*z
  }
  object { schnitt }
}


#declare Gitterschnitt = union {
  box { // spalte7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-13.0, 4.59, 1.0>
  }
  box { // spalte6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-11.0, 4.59, 1.0>
  }
  box { // spalte5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-9.0, 4.59, 1.0>
  }
  box { // spalte4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-7.0, 4.59, 1.0>
  }
  box { // spalte3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-5.0, 4.59, 1.0>
  }
  box { // spalte2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-3.0, 4.59, 1.0>
  }
  box { // spalte1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 3.0>
    translate  <-1.0, 4.59, 1.0>
  }
  box { // Zeile7
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, 4.0>
  }
  box { // Zeile6
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, 3.0>
  }
  box { // Zeile5
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, 2.0>
  }
  box { // Zeile4
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, 1.0>
  }
  box { // Zeile3
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, 0.0>
  }
  box { // Zeile2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, -1.0>
  }
  box { // Zeile1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.1, 0.1, 0.1>
    translate  <-7.0, 4.59, -2.0>
  }
  material {
    texgraph
  }
}
difference { // wandfertig
  box { // WandHG
    <-1, -1, -1>, <1, 1, 1>
    material {
      texHGWand
    }
    scale <7.0, 0.25, 4.0>
    translate  <-7.0, 4.75, 1.0>
  }
  object { Gitterschnitt }
}




union { // Gewinn
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.001270, 0.000000, -6.500003>, <15.000509, 0.074999, -6.575000>, <14.999491, 0.174998, -6.674996>, <14.998730, 0.249997, -6.749993>, 
      <14.401270, 0.000000, -5.000003>, <14.400507, 0.074999, -5.075000>, <14.399491, 0.174998, -5.174996>, <14.398730, 0.249997, -5.249993>, 
      <13.601270, 0.000000, -3.000003>, <13.600509, 0.074999, -3.075000>, <13.599493, 0.174998, -3.174996>, <13.598730, 0.249997, -3.249993>, 
      <13.001270, 0.000000, -1.500003>, <13.000508, 0.074999, -1.575000>, <12.999492, 0.174998, -1.674996>, <12.998730, 0.249997, -1.749993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.001270, -0.249997, -6.750007>, <15.001270, -0.174998, -6.675006>, <15.001270, -0.074999, -6.575004>, <15.001270, 0.000000, -6.500003>, 
      <14.401270, -0.249997, -5.250007>, <14.401270, -0.174998, -5.175006>, <14.401270, -0.074999, -5.075004>, <14.401270, 0.000000, -5.000003>, 
      <13.601270, -0.249997, -3.250007>, <13.601270, -0.174998, -3.175006>, <13.601270, -0.074999, -3.075004>, <13.601270, 0.000000, -3.000003>, 
      <13.001270, -0.249997, -1.750007>, <13.001270, -0.174998, -1.675006>, <13.001270, -0.074999, -1.575004>, <13.001270, 0.000000, -1.500003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.998730, 0.000000, -6.999997>, <14.999491, -0.074999, -6.925000>, <15.000509, -0.174998, -6.825004>, <15.001270, -0.249997, -6.750007>, 
      <14.398730, 0.000000, -5.499997>, <14.399491, -0.074999, -5.425000>, <14.400507, -0.174998, -5.325004>, <14.401270, -0.249997, -5.250007>, 
      <13.598730, 0.000000, -3.499997>, <13.599493, -0.074999, -3.425000>, <13.600509, -0.174998, -3.325004>, <13.601270, -0.249997, -3.250007>, 
      <12.998730, 0.000000, -1.999997>, <12.999492, -0.074999, -1.925000>, <13.000508, -0.174998, -1.825004>, <13.001270, -0.249997, -1.750007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.998730, 0.000000, -6.999997>, <14.398730, 0.000000, -5.499997>, <13.598730, 0.000000, -3.499997>, <12.998730, 0.000000, -1.999997>, 
      <14.998730, 0.074999, -6.924996>, <14.398730, 0.074999, -5.424996>, <13.598730, 0.074999, -3.424996>, <12.998730, 0.074999, -1.924996>, 
      <14.998730, 0.174998, -6.824994>, <14.398730, 0.174998, -5.324994>, <13.598730, 0.174998, -3.324994>, <12.998730, 0.174998, -1.824994>, 
      <14.998730, 0.249997, -6.749993>, <14.398730, 0.249997, -5.249993>, <13.598730, 0.249997, -3.249993>, <12.998730, 0.249997, -1.749993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <11.001270, 0.000000, 2.499997>, <11.601270, 0.000000, 1.299997>, <12.401270, 0.000000, -0.300003>, <13.001270, 0.000000, -1.500003>, 
      <11.000508, 0.074999, 2.425000>, <11.600509, 0.074999, 1.225000>, <12.400508, 0.074999, -0.375000>, <13.000508, 0.074999, -1.575000>, 
      <10.999492, 0.174998, 2.325004>, <11.599492, 0.174998, 1.125004>, <12.399491, 0.174998, -0.474996>, <12.999492, 0.174998, -1.674996>, 
      <10.998730, 0.249997, 2.250007>, <11.598730, 0.249997, 1.050007>, <12.398730, 0.249997, -0.549993>, <12.998730, 0.249997, -1.749993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <11.001270, -0.249997, 2.249993>, <11.601270, -0.249997, 1.049993>, <12.401270, -0.249997, -0.550007>, <13.001270, -0.249997, -1.750007>, 
      <11.001270, -0.174998, 2.324994>, <11.601270, -0.174998, 1.124994>, <12.401270, -0.174998, -0.475006>, <13.001270, -0.174998, -1.675006>, 
      <11.001270, -0.074999, 2.424996>, <11.601270, -0.074999, 1.224996>, <12.401270, -0.074999, -0.375004>, <13.001270, -0.074999, -1.575004>, 
      <11.001270, 0.000000, 2.499997>, <11.601270, 0.000000, 1.299997>, <12.401270, 0.000000, -0.300003>, <13.001270, 0.000000, -1.500003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.998730, 0.000000, 2.000003>, <11.598730, 0.000000, 0.800003>, <12.398730, 0.000000, -0.799997>, <12.998730, 0.000000, -1.999997>, 
      <10.999492, -0.074999, 2.075000>, <11.599492, -0.074999, 0.875000>, <12.399491, -0.074999, -0.725000>, <12.999492, -0.074999, -1.925000>, 
      <11.000508, -0.174998, 2.174996>, <11.600509, -0.174998, 0.974996>, <12.400508, -0.174998, -0.625004>, <13.000508, -0.174998, -1.825004>, 
      <11.001270, -0.249997, 2.249993>, <11.601270, -0.249997, 1.049993>, <12.401270, -0.249997, -0.550007>, <13.001270, -0.249997, -1.750007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.998730, 0.000000, 2.000003>, <10.998730, 0.074999, 2.075004>, <10.998730, 0.174998, 2.175006>, <10.998730, 0.249997, 2.250007>, 
      <11.598730, 0.000000, 0.800003>, <11.598730, 0.074999, 0.875004>, <11.598730, 0.174998, 0.975006>, <11.598730, 0.249997, 1.050007>, 
      <12.398730, 0.000000, -0.799997>, <12.398730, 0.074999, -0.724996>, <12.398730, 0.174998, -0.624994>, <12.398730, 0.249997, -0.549993>, 
      <12.998730, 0.000000, -1.999997>, <12.998730, 0.074999, -1.924996>, <12.998730, 0.174998, -1.824994>, <12.998730, 0.249997, -1.749993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.001270, 0.000000, 3.499997>, <10.301270, 0.000000, 3.199997>, <10.701270, 0.000000, 2.799997>, <11.001270, 0.000000, 2.499997>, 
      <10.000508, 0.074999, 3.425000>, <10.300509, 0.074999, 3.125000>, <10.700508, 0.074999, 2.725000>, <11.000508, 0.074999, 2.425000>, 
      <9.999492, 0.174998, 3.325004>, <10.299492, 0.174998, 3.025004>, <10.699491, 0.174998, 2.625004>, <10.999492, 0.174998, 2.325004>, 
      <9.998730, 0.249997, 3.250007>, <10.298730, 0.249997, 2.950007>, <10.698730, 0.249997, 2.550007>, <10.998730, 0.249997, 2.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.001270, -0.249997, 3.249993>, <10.301270, -0.249997, 2.949993>, <10.701270, -0.249997, 2.549993>, <11.001270, -0.249997, 2.249993>, 
      <10.001270, -0.174998, 3.324994>, <10.301270, -0.174998, 3.024994>, <10.701270, -0.174998, 2.624994>, <11.001270, -0.174998, 2.324994>, 
      <10.001270, -0.074999, 3.424996>, <10.301270, -0.074999, 3.124996>, <10.701270, -0.074999, 2.724996>, <11.001270, -0.074999, 2.424996>, 
      <10.001270, 0.000000, 3.499997>, <10.301270, 0.000000, 3.199997>, <10.701270, 0.000000, 2.799997>, <11.001270, 0.000000, 2.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.998730, 0.000000, 3.000003>, <10.298730, 0.000000, 2.700003>, <10.698730, 0.000000, 2.300003>, <10.998730, 0.000000, 2.000003>, 
      <9.999492, -0.074999, 3.075000>, <10.299492, -0.074999, 2.775000>, <10.699491, -0.074999, 2.375000>, <10.999492, -0.074999, 2.075000>, 
      <10.000508, -0.174998, 3.174996>, <10.300509, -0.174998, 2.874996>, <10.700508, -0.174998, 2.474996>, <11.000508, -0.174998, 2.174996>, 
      <10.001270, -0.249997, 3.249993>, <10.301270, -0.249997, 2.949993>, <10.701270, -0.249997, 2.549993>, <11.001270, -0.249997, 2.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.998730, 0.000000, 3.000003>, <9.998730, 0.074999, 3.075004>, <9.998730, 0.174998, 3.175006>, <9.998730, 0.249997, 3.250007>, 
      <10.298730, 0.000000, 2.700003>, <10.298730, 0.074999, 2.775004>, <10.298730, 0.174998, 2.875006>, <10.298730, 0.249997, 2.950007>, 
      <10.698730, 0.000000, 2.300003>, <10.698730, 0.074999, 2.375004>, <10.698730, 0.174998, 2.475006>, <10.698730, 0.249997, 2.550007>, 
      <10.998730, 0.000000, 2.000003>, <10.998730, 0.074999, 2.075004>, <10.998730, 0.174998, 2.175006>, <10.998730, 0.249997, 2.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.001270, 0.000000, 5.499997>, <9.301270, 0.000000, 4.899997>, <9.701270, 0.000000, 4.099997>, <10.001270, 0.000000, 3.499997>, 
      <9.000508, 0.074999, 5.425000>, <9.300509, 0.074999, 4.825000>, <9.700508, 0.074999, 4.025000>, <10.000508, 0.074999, 3.425000>, 
      <8.999492, 0.174998, 5.325004>, <9.299492, 0.174998, 4.725004>, <9.699491, 0.174998, 3.925004>, <9.999492, 0.174998, 3.325004>, 
      <8.998730, 0.249997, 5.250007>, <9.298730, 0.249997, 4.650007>, <9.698730, 0.249997, 3.850007>, <9.998730, 0.249997, 3.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.001270, -0.249997, 5.249993>, <9.301270, -0.249997, 4.649993>, <9.701270, -0.249997, 3.849993>, <10.001270, -0.249997, 3.249993>, 
      <9.001270, -0.174998, 5.324994>, <9.301270, -0.174998, 4.724994>, <9.701270, -0.174998, 3.924994>, <10.001270, -0.174998, 3.324994>, 
      <9.001270, -0.074999, 5.424996>, <9.301270, -0.074999, 4.824996>, <9.701270, -0.074999, 4.024996>, <10.001270, -0.074999, 3.424996>, 
      <9.001270, 0.000000, 5.499997>, <9.301270, 0.000000, 4.899997>, <9.701270, 0.000000, 4.099997>, <10.001270, 0.000000, 3.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.998730, 0.000000, 5.000003>, <9.298730, 0.000000, 4.400003>, <9.698730, 0.000000, 3.600003>, <9.998730, 0.000000, 3.000003>, 
      <8.999492, -0.074999, 5.075000>, <9.299492, -0.074999, 4.475000>, <9.699491, -0.074999, 3.675000>, <9.999492, -0.074999, 3.075000>, 
      <9.000508, -0.174998, 5.174996>, <9.300509, -0.174998, 4.574996>, <9.700508, -0.174998, 3.774996>, <10.000508, -0.174998, 3.174996>, 
      <9.001270, -0.249997, 5.249993>, <9.301270, -0.249997, 4.649993>, <9.701270, -0.249997, 3.849993>, <10.001270, -0.249997, 3.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.998730, 0.000000, 5.000003>, <8.998730, 0.074999, 5.075004>, <8.998730, 0.174998, 5.175006>, <8.998730, 0.249997, 5.250007>, 
      <9.298730, 0.000000, 4.400003>, <9.298730, 0.074999, 4.475004>, <9.298730, 0.174998, 4.575006>, <9.298730, 0.249997, 4.650007>, 
      <9.698730, 0.000000, 3.600003>, <9.698730, 0.074999, 3.675004>, <9.698730, 0.174998, 3.775006>, <9.698730, 0.249997, 3.850007>, 
      <9.998730, 0.000000, 3.000003>, <9.998730, 0.074999, 3.075004>, <9.998730, 0.174998, 3.175006>, <9.998730, 0.249997, 3.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.001270, 0.000000, 6.499997>, <7.601270, 0.000000, 6.199997>, <8.401270, 0.000000, 5.799997>, <9.001270, 0.000000, 5.499997>, 
      <7.000508, 0.074999, 6.425000>, <7.600508, 0.074999, 6.125000>, <8.400508, 0.074999, 5.725000>, <9.000508, 0.074999, 5.425000>, 
      <6.999492, 0.174998, 6.325004>, <7.599491, 0.174998, 6.025004>, <8.399491, 0.174998, 5.625004>, <8.999492, 0.174998, 5.325004>, 
      <6.998730, 0.249997, 6.250007>, <7.598729, 0.249997, 5.950007>, <8.398730, 0.249997, 5.550007>, <8.998730, 0.249997, 5.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.001270, -0.249997, 6.249993>, <7.601270, -0.249997, 5.949993>, <8.401270, -0.249997, 5.549993>, <9.001270, -0.249997, 5.249993>, 
      <7.001270, -0.174998, 6.324994>, <7.601270, -0.174998, 6.024994>, <8.401270, -0.174998, 5.624994>, <9.001270, -0.174998, 5.324994>, 
      <7.001270, -0.074999, 6.424996>, <7.601270, -0.074999, 6.124996>, <8.401270, -0.074999, 5.724996>, <9.001270, -0.074999, 5.424996>, 
      <7.001270, 0.000000, 6.499997>, <7.601270, 0.000000, 6.199997>, <8.401270, 0.000000, 5.799997>, <9.001270, 0.000000, 5.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.998730, 0.000000, 6.000003>, <7.598729, 0.000000, 5.700003>, <8.398730, 0.000000, 5.300003>, <8.998730, 0.000000, 5.000003>, 
      <6.999492, -0.074999, 6.075000>, <7.599491, -0.074999, 5.775000>, <8.399491, -0.074999, 5.375000>, <8.999492, -0.074999, 5.075000>, 
      <7.000508, -0.174998, 6.174996>, <7.600508, -0.174998, 5.874996>, <8.400508, -0.174998, 5.474996>, <9.000508, -0.174998, 5.174996>, 
      <7.001270, -0.249997, 6.249993>, <7.601270, -0.249997, 5.949993>, <8.401270, -0.249997, 5.549993>, <9.001270, -0.249997, 5.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.998730, 0.000000, 6.000003>, <6.998730, 0.074999, 6.075004>, <6.998730, 0.174998, 6.175006>, <6.998730, 0.249997, 6.250007>, 
      <7.598729, 0.000000, 5.700003>, <7.598729, 0.074999, 5.775004>, <7.598729, 0.174998, 5.875006>, <7.598729, 0.249997, 5.950007>, 
      <8.398730, 0.000000, 5.300003>, <8.398730, 0.074999, 5.375004>, <8.398730, 0.174998, 5.475006>, <8.398730, 0.249997, 5.550007>, 
      <8.998730, 0.000000, 5.000003>, <8.998730, 0.074999, 5.075004>, <8.998730, 0.174998, 5.175006>, <8.998730, 0.249997, 5.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.001271, 0.000000, 4.499997>, <6.301271, 0.000000, 5.099997>, <6.701270, 0.000000, 5.899997>, <7.001270, 0.000000, 6.499997>, 
      <6.000508, 0.074999, 4.425000>, <6.300508, 0.074999, 5.025000>, <6.700508, 0.074999, 5.825000>, <7.000508, 0.074999, 6.425000>, 
      <5.999492, 0.174998, 4.325004>, <6.299492, 0.174998, 4.925004>, <6.699492, 0.174998, 5.725004>, <6.999492, 0.174998, 6.325004>, 
      <5.998729, 0.249997, 4.250007>, <6.298730, 0.249997, 4.850007>, <6.698729, 0.249997, 5.650007>, <6.998730, 0.249997, 6.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.001271, -0.249997, 4.249993>, <6.301271, -0.249997, 4.849993>, <6.701270, -0.249997, 5.649993>, <7.001270, -0.249997, 6.249993>, 
      <6.001271, -0.174998, 4.324994>, <6.301271, -0.174998, 4.924994>, <6.701270, -0.174998, 5.724994>, <7.001270, -0.174998, 6.324994>, 
      <6.001271, -0.074999, 4.424996>, <6.301271, -0.074999, 5.024996>, <6.701270, -0.074999, 5.824996>, <7.001270, -0.074999, 6.424996>, 
      <6.001271, 0.000000, 4.499997>, <6.301271, 0.000000, 5.099997>, <6.701270, 0.000000, 5.899997>, <7.001270, 0.000000, 6.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.998729, 0.000000, 4.000003>, <6.298730, 0.000000, 4.600003>, <6.698729, 0.000000, 5.400003>, <6.998730, 0.000000, 6.000003>, 
      <5.999492, -0.074999, 4.075000>, <6.299492, -0.074999, 4.675000>, <6.699492, -0.074999, 5.475000>, <6.999492, -0.074999, 6.075000>, 
      <6.000508, -0.174998, 4.174996>, <6.300508, -0.174998, 4.774996>, <6.700508, -0.174998, 5.574996>, <7.000508, -0.174998, 6.174996>, 
      <6.001271, -0.249997, 4.249993>, <6.301271, -0.249997, 4.849993>, <6.701270, -0.249997, 5.649993>, <7.001270, -0.249997, 6.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.998729, 0.000000, 4.000003>, <5.998729, 0.074999, 4.075004>, <5.998729, 0.174998, 4.175006>, <5.998729, 0.249997, 4.250007>, 
      <6.298730, 0.000000, 4.600003>, <6.298730, 0.074999, 4.675004>, <6.298730, 0.174998, 4.775006>, <6.298730, 0.249997, 4.850007>, 
      <6.698729, 0.000000, 5.400003>, <6.698729, 0.074999, 5.475004>, <6.698729, 0.174998, 5.575006>, <6.698729, 0.249997, 5.650007>, 
      <6.998730, 0.000000, 6.000003>, <6.998730, 0.074999, 6.075004>, <6.998730, 0.174998, 6.175006>, <6.998730, 0.249997, 6.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.001271, 0.000000, 5.499997>, <5.301271, 0.000000, 5.199997>, <5.701270, 0.000000, 4.799997>, <6.001271, 0.000000, 4.499997>, 
      <5.000508, 0.074999, 5.425000>, <5.300508, 0.074999, 5.125000>, <5.700508, 0.074999, 4.725000>, <6.000508, 0.074999, 4.425000>, 
      <4.999492, 0.174998, 5.325004>, <5.299492, 0.174998, 5.025004>, <5.699492, 0.174998, 4.625004>, <5.999492, 0.174998, 4.325004>, 
      <4.998729, 0.249997, 5.250007>, <5.298730, 0.249997, 4.950007>, <5.698729, 0.249997, 4.550007>, <5.998729, 0.249997, 4.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.001271, -0.249997, 5.249993>, <5.301271, -0.249997, 4.949993>, <5.701270, -0.249997, 4.549993>, <6.001271, -0.249997, 4.249993>, 
      <5.001271, -0.174998, 5.324994>, <5.301271, -0.174998, 5.024994>, <5.701270, -0.174998, 4.624994>, <6.001271, -0.174998, 4.324994>, 
      <5.001271, -0.074999, 5.424996>, <5.301271, -0.074999, 5.124996>, <5.701270, -0.074999, 4.724996>, <6.001271, -0.074999, 4.424996>, 
      <5.001271, 0.000000, 5.499997>, <5.301271, 0.000000, 5.199997>, <5.701270, 0.000000, 4.799997>, <6.001271, 0.000000, 4.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.998729, 0.000000, 5.000003>, <5.298730, 0.000000, 4.700003>, <5.698729, 0.000000, 4.300003>, <5.998729, 0.000000, 4.000003>, 
      <4.999492, -0.074999, 5.075000>, <5.299492, -0.074999, 4.775000>, <5.699492, -0.074999, 4.375000>, <5.999492, -0.074999, 4.075000>, 
      <5.000508, -0.174998, 5.174996>, <5.300508, -0.174998, 4.874996>, <5.700508, -0.174998, 4.474996>, <6.000508, -0.174998, 4.174996>, 
      <5.001271, -0.249997, 5.249993>, <5.301271, -0.249997, 4.949993>, <5.701270, -0.249997, 4.549993>, <6.001271, -0.249997, 4.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.998729, 0.000000, 5.000003>, <4.998729, 0.074999, 5.075004>, <4.998729, 0.174998, 5.175006>, <4.998729, 0.249997, 5.250007>, 
      <5.298730, 0.000000, 4.700003>, <5.298730, 0.074999, 4.775004>, <5.298730, 0.174998, 4.875006>, <5.298730, 0.249997, 4.950007>, 
      <5.698729, 0.000000, 4.300003>, <5.698729, 0.074999, 4.375004>, <5.698729, 0.174998, 4.475006>, <5.698729, 0.249997, 4.550007>, 
      <5.998729, 0.000000, 4.000003>, <5.998729, 0.074999, 4.075004>, <5.998729, 0.174998, 4.175006>, <5.998729, 0.249997, 4.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.001271, 0.000000, 4.499997>, <4.301271, 0.000000, 4.799997>, <4.701270, 0.000000, 5.199997>, <5.001271, 0.000000, 5.499997>, 
      <4.000508, 0.074999, 4.425000>, <4.300508, 0.074999, 4.725000>, <4.700508, 0.074999, 5.125000>, <5.000508, 0.074999, 5.425000>, 
      <3.999492, 0.174998, 4.325004>, <4.299492, 0.174998, 4.625004>, <4.699492, 0.174998, 5.025004>, <4.999492, 0.174998, 5.325004>, 
      <3.998729, 0.249997, 4.250007>, <4.298729, 0.249997, 4.550007>, <4.698729, 0.249997, 4.950007>, <4.998729, 0.249997, 5.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.001271, -0.249997, 4.249993>, <4.301271, -0.249997, 4.549993>, <4.701270, -0.249997, 4.949993>, <5.001271, -0.249997, 5.249993>, 
      <4.001271, -0.174998, 4.324994>, <4.301271, -0.174998, 4.624994>, <4.701270, -0.174998, 5.024994>, <5.001271, -0.174998, 5.324994>, 
      <4.001271, -0.074999, 4.424996>, <4.301271, -0.074999, 4.724996>, <4.701270, -0.074999, 5.124996>, <5.001271, -0.074999, 5.424996>, 
      <4.001271, 0.000000, 4.499997>, <4.301271, 0.000000, 4.799997>, <4.701270, 0.000000, 5.199997>, <5.001271, 0.000000, 5.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.998729, 0.000000, 4.000003>, <4.298729, 0.000000, 4.300003>, <4.698729, 0.000000, 4.700003>, <4.998729, 0.000000, 5.000003>, 
      <3.999492, -0.074999, 4.075000>, <4.299492, -0.074999, 4.375000>, <4.699492, -0.074999, 4.775000>, <4.999492, -0.074999, 5.075000>, 
      <4.000508, -0.174998, 4.174996>, <4.300508, -0.174998, 4.474996>, <4.700508, -0.174998, 4.874996>, <5.000508, -0.174998, 5.174996>, 
      <4.001271, -0.249997, 4.249993>, <4.301271, -0.249997, 4.549993>, <4.701270, -0.249997, 4.949993>, <5.001271, -0.249997, 5.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.998729, 0.000000, 4.000003>, <3.998729, 0.074999, 4.075004>, <3.998729, 0.174998, 4.175006>, <3.998729, 0.249997, 4.250007>, 
      <4.298729, 0.000000, 4.300003>, <4.298729, 0.074999, 4.375004>, <4.298729, 0.174998, 4.475006>, <4.298729, 0.249997, 4.550007>, 
      <4.698729, 0.000000, 4.700003>, <4.698729, 0.074999, 4.775004>, <4.698729, 0.174998, 4.875006>, <4.698729, 0.249997, 4.950007>, 
      <4.998729, 0.000000, 5.000003>, <4.998729, 0.074999, 5.075004>, <4.998729, 0.174998, 5.175006>, <4.998729, 0.249997, 5.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.001271, 0.000000, 2.499997>, <3.301271, 0.000000, 3.099997>, <3.701271, 0.000000, 3.899997>, <4.001271, 0.000000, 4.499997>, 
      <3.000508, 0.074999, 2.425000>, <3.300508, 0.074999, 3.025000>, <3.700508, 0.074999, 3.825000>, <4.000508, 0.074999, 4.425000>, 
      <2.999492, 0.174998, 2.325003>, <3.299492, 0.174998, 2.925004>, <3.699492, 0.174998, 3.725004>, <3.999492, 0.174998, 4.325004>, 
      <2.998729, 0.249997, 2.250006>, <3.298729, 0.249997, 2.850006>, <3.698729, 0.249997, 3.650007>, <3.998729, 0.249997, 4.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.001271, -0.249997, 2.249994>, <3.301271, -0.249997, 2.849994>, <3.701271, -0.249997, 3.649993>, <4.001271, -0.249997, 4.249993>, 
      <3.001271, -0.174998, 2.324995>, <3.301271, -0.174998, 2.924994>, <3.701271, -0.174998, 3.724994>, <4.001271, -0.174998, 4.324994>, 
      <3.001271, -0.074999, 2.424996>, <3.301271, -0.074999, 3.024996>, <3.701271, -0.074999, 3.824996>, <4.001271, -0.074999, 4.424996>, 
      <3.001271, 0.000000, 2.499997>, <3.301271, 0.000000, 3.099997>, <3.701271, 0.000000, 3.899997>, <4.001271, 0.000000, 4.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.998729, 0.000000, 2.000003>, <3.298729, 0.000000, 2.600003>, <3.698729, 0.000000, 3.400003>, <3.998729, 0.000000, 4.000003>, 
      <2.999492, -0.074999, 2.075000>, <3.299492, -0.074999, 2.675000>, <3.699492, -0.074999, 3.475000>, <3.999492, -0.074999, 4.075000>, 
      <3.000508, -0.174998, 2.174997>, <3.300508, -0.174998, 2.774997>, <3.700508, -0.174998, 3.574996>, <4.000508, -0.174998, 4.174996>, 
      <3.001271, -0.249997, 2.249994>, <3.301271, -0.249997, 2.849994>, <3.701271, -0.249997, 3.649993>, <4.001271, -0.249997, 4.249993>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.998729, 0.000000, 2.000003>, <2.998729, 0.074999, 2.075004>, <2.998729, 0.174998, 2.175005>, <2.998729, 0.249997, 2.250006>, 
      <3.298729, 0.000000, 2.600003>, <3.298729, 0.074999, 2.675004>, <3.298729, 0.174998, 2.775006>, <3.298729, 0.249997, 2.850006>, 
      <3.698729, 0.000000, 3.400003>, <3.698729, 0.074999, 3.475004>, <3.698729, 0.174998, 3.575006>, <3.698729, 0.249997, 3.650007>, 
      <3.998729, 0.000000, 4.000003>, <3.998729, 0.074999, 4.075004>, <3.998729, 0.174998, 4.175006>, <3.998729, 0.249997, 4.250007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.001271, 0.000000, 1.499997>, <1.601271, 0.000000, 1.799997>, <2.401271, 0.000000, 2.199997>, <3.001271, 0.000000, 2.499997>, 
      <1.000508, 0.074999, 1.425000>, <1.600508, 0.074999, 1.725000>, <2.400508, 0.074999, 2.125000>, <3.000508, 0.074999, 2.425000>, 
      <0.999492, 0.174998, 1.325003>, <1.599492, 0.174998, 1.625003>, <2.399492, 0.174998, 2.025003>, <2.999492, 0.174998, 2.325003>, 
      <0.998729, 0.249997, 1.250006>, <1.598729, 0.249997, 1.550006>, <2.398729, 0.249997, 1.950006>, <2.998729, 0.249997, 2.250006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.001271, -0.249997, 1.249994>, <1.601271, -0.249997, 1.549994>, <2.401271, -0.249997, 1.949994>, <3.001271, -0.249997, 2.249994>, 
      <1.001271, -0.174998, 1.324995>, <1.601271, -0.174998, 1.624995>, <2.401271, -0.174998, 2.024995>, <3.001271, -0.174998, 2.324995>, 
      <1.001271, -0.074999, 1.424996>, <1.601271, -0.074999, 1.724996>, <2.401271, -0.074999, 2.124996>, <3.001271, -0.074999, 2.424996>, 
      <1.001271, 0.000000, 1.499997>, <1.601271, 0.000000, 1.799997>, <2.401271, 0.000000, 2.199997>, <3.001271, 0.000000, 2.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.998729, 0.000000, 1.000003>, <1.598729, 0.000000, 1.300003>, <2.398729, 0.000000, 1.700003>, <2.998729, 0.000000, 2.000003>, 
      <0.999492, -0.074999, 1.075000>, <1.599492, -0.074999, 1.375000>, <2.399492, -0.074999, 1.775000>, <2.999492, -0.074999, 2.075000>, 
      <1.000508, -0.174998, 1.174997>, <1.600508, -0.174998, 1.474997>, <2.400508, -0.174998, 1.874997>, <3.000508, -0.174998, 2.174997>, 
      <1.001271, -0.249997, 1.249994>, <1.601271, -0.249997, 1.549994>, <2.401271, -0.249997, 1.949994>, <3.001271, -0.249997, 2.249994>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.998729, 0.000000, 1.000003>, <0.998729, 0.074999, 1.075004>, <0.998729, 0.174998, 1.175005>, <0.998729, 0.249997, 1.250006>, 
      <1.598729, 0.000000, 1.300003>, <1.598729, 0.074999, 1.375004>, <1.598729, 0.174998, 1.475005>, <1.598729, 0.249997, 1.550006>, 
      <2.398729, 0.000000, 1.700003>, <2.398729, 0.074999, 1.775004>, <2.398729, 0.174998, 1.875005>, <2.398729, 0.249997, 1.950006>, 
      <2.998729, 0.000000, 2.000003>, <2.998729, 0.074999, 2.075004>, <2.998729, 0.174998, 2.175005>, <2.998729, 0.249997, 2.250006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001271, 0.000000, 0.499997>, <0.301271, 0.000000, 0.799997>, <0.701271, 0.000000, 1.199997>, <1.001271, 0.000000, 1.499997>, 
      <0.000508, 0.074999, 0.425000>, <0.300508, 0.074999, 0.725000>, <0.700508, 0.074999, 1.125000>, <1.000508, 0.074999, 1.425000>, 
      <-0.000508, 0.174998, 0.325003>, <0.299492, 0.174998, 0.625003>, <0.699492, 0.174998, 1.025003>, <0.999492, 0.174998, 1.325003>, 
      <-0.001271, 0.249997, 0.250006>, <0.298729, 0.249997, 0.550006>, <0.698729, 0.249997, 0.950006>, <0.998729, 0.249997, 1.250006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001271, -0.249997, 0.249994>, <0.301271, -0.249997, 0.549994>, <0.701271, -0.249997, 0.949994>, <1.001271, -0.249997, 1.249994>, 
      <0.001271, -0.174998, 0.324995>, <0.301271, -0.174998, 0.624995>, <0.701271, -0.174998, 1.024995>, <1.001271, -0.174998, 1.324995>, 
      <0.001271, -0.074999, 0.424996>, <0.301271, -0.074999, 0.724996>, <0.701271, -0.074999, 1.124996>, <1.001271, -0.074999, 1.424996>, 
      <0.001271, 0.000000, 0.499997>, <0.301271, 0.000000, 0.799997>, <0.701271, 0.000000, 1.199997>, <1.001271, 0.000000, 1.499997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001271, 0.000000, 0.000003>, <0.298729, 0.000000, 0.300003>, <0.698729, 0.000000, 0.700003>, <0.998729, 0.000000, 1.000003>, 
      <-0.000508, -0.074999, 0.075000>, <0.299492, -0.074999, 0.375000>, <0.699492, -0.074999, 0.775000>, <0.999492, -0.074999, 1.075000>, 
      <0.000508, -0.174998, 0.174997>, <0.300508, -0.174998, 0.474997>, <0.700508, -0.174998, 0.874997>, <1.000508, -0.174998, 1.174997>, 
      <0.001271, -0.249997, 0.249994>, <0.301271, -0.249997, 0.549994>, <0.701271, -0.249997, 0.949994>, <1.001271, -0.249997, 1.249994>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001271, 0.000000, 0.000003>, <-0.001271, 0.074999, 0.075004>, <-0.001271, 0.174998, 0.175005>, <-0.001271, 0.249997, 0.250006>, 
      <0.298729, 0.000000, 0.300003>, <0.298729, 0.074999, 0.375004>, <0.298729, 0.174998, 0.475005>, <0.298729, 0.249997, 0.550006>, 
      <0.698729, 0.000000, 0.700003>, <0.698729, 0.074999, 0.775004>, <0.698729, 0.174998, 0.875005>, <0.698729, 0.249997, 0.950006>, 
      <0.998729, 0.000000, 1.000003>, <0.998729, 0.074999, 1.075004>, <0.998729, 0.174998, 1.175005>, <0.998729, 0.249997, 1.250006>
    }
  }
  material {
    texkurve
  }
  scale <0.95, 1.0, 1.0>
  translate  <-13.0, 4.0, -2.25>
}


