#include "iso_util.inc"

#ifndef (Detail_Chateau)
	#declare Detail_Chateau = 1;
#end

#declare T_Sable = texture {
	pigment {
		gradient y
		scale 3.2
		rotate 5*x
		color_map {
			[ 0.0 color rgb <255, 204, 150>/550 ]
			[ 0.2 color rgb <255, 204, 150>/400 ]
			[ 0.4 color rgb <255, 204, 150>/300 ]
			[ 1.0 color rgb <255, 204, 150>/300 ]
		}
	}
	normal { granite .4 scale .05 }
	finish { ambient .4 diffuse .6 }
}

#declare T_Sable2 = texture {
	pigment {
		gradient y
		scale 3.2
		rotate 5*x
		color_map {
			[ 0.0 color rgb <255, 204, 150>/550 ]
			[ 0.2 color rgb <255, 204, 150>/450 ]
			[ 0.4 color rgb <255, 204, 150>/350 ]
			[ 1.0 color rgb <255, 204, 150>/350 ]
		}	
	}
	normal { granite .4 scale .05 }
	finish { ambient .4 diffuse .5 specular .1 }
}


#macro Sand_Rounded_Tower(MajRayon1, MajRayon2, MinRayon2, Taille)

union {
	cylinder { <0,Taille - MajRayon2 -.1,0>, <0,Taille,0>, MajRayon2 }
	torus { MajRayon2, MinRayon2 translate y*(Taille - MinRayon2) }
	cone { <0,0,0>, MajRayon1, <0,Taille - MinRayon2,0>, MajRayon2+MinRayon2 }
}

#end


#macro Sand_Rounded_Wall(Longueur, Largeur, Angle, Rayon, Taille)

union {
	box { <0, -Taille/cos(radians(Angle)), -Rayon>, <Longueur, 0, Largeur*.5>
		rotate Angle*x
		translate <-Longueur/2, Taille-Rayon, -Largeur*.5+Rayon>
	}
	box { <0, -Taille/cos(radians(Angle)), -Largeur*.5>, <Longueur, 0, Rayon>
		rotate -Angle*x
		translate <-Longueur/2, Taille-Rayon, Largeur*.5-Rayon>
	}
	cylinder { <0, 0, 0>,  <Longueur, 0, 0>, Rayon
		translate <-Longueur/2, Taille-Rayon, -Largeur*.5+Rayon>
	}
	cylinder { <0, 0, 0>,  <Longueur, 0, 0>, Rayon
		translate <-Longueur/2, Taille-Rayon, Largeur*.5-Rayon>
	}
	box { <-Longueur/2, 0, -(Largeur*.5-Rayon)>, <Longueur/2, Taille, (Largeur*.5-Rayon)> }
}

#end


#macro Noise_Isosphere(Rayon, Scale, Amount, PTurb)
#local cx = (Scale.x)*(Scale.x);
#local cy = (Scale.y)*(Scale.y);
#local cz = (Scale.z)*(Scale.z);
isosurface {
	function { sqrt(x*x/cx+y*y/cy+z*z/cz) - 1 - (noise3d(x*PTurb,y*PTurb,z*PTurb)^2)*Amount
				- (noise3d(x*PTurb*5,y*PTurb*5,z*PTurb*5)^2)*Amount*.2 }
	threshold 0
	bounded_by { sphere { 0, max(max(Scale.x, Scale.y), Scale.z) + Amount*1.1 } }
	max_trace 4
}
#end


#macro Chateau_Sable()

union {
	object {
		isosurface {
			function { sqrt(x*x/4+y*y+z*z/4) - 1 - (noise3d(x*3,y*3,z*3)^2)*.2
					- (noise3d(x*15,y*15,z*15)*.4*(max(y-.5, 0)))^2 }
			bounded_by { box { <-2.5, .1, -2.5>, <2.5, 1.5, 2.5> } }
			max_trace 2
		}
		rotate 5*x
		translate -3*x -.3*y
		texture { T_Sable2 scale .8 translate -.1*y}
	}
	intersection {
		isosurface {
			function { sqrt(x*x/16+y*y/9+z*z/9) - 1 - (noise3d(x*3,y*3,z*3)^2)*.06
						- (noise3d(x*15,y*15,z*15)^2)*.01 }
			threshold 0
			bounded_by { box { <-3, 0, -5>, <5,2.8,3> } }
			max_trace 4
			normal off
			translate <-1,0,2>
			texture { T_Sable2 }
		}
		object {
			#if (Detail_Chateau = 1)
			IsoCone(1.2, .8, .2, 2.5, .05)
			#else
			Sand_Rounded_Tower(1.2, .8, .1, 2)
			#end
			texture {T_Sable}
		}
		rotate x - z
		translate 3*x
	}
	object {
		#if (Detail_Chateau = 1)
		IsoCone(1.2, .8, .2, 2.5, .05)
		#else
		Sand_Rounded_Tower(1.2, .8, .1, 2)
		#end
		rotate x*2 + -z
		translate -3*x + 3*z
		texture {T_Sable}
	}
	object {
		#if (Detail_Chateau = 1)
		IsoCone(1.2, .8, .2, 2.5, .05)
		#else
		Sand_Rounded_Tower(1.2, .8, .1, 2)
		#end
		rotate x*3 + 2*z
		translate 3*x + 3*z
		texture {T_Sable}
	}
	difference {
		object {
			#if (Detail_Chateau = 1)
			IsoWall(6, 1.5, 4, 1.7, .05)
			#else
			Sand_Rounded_Wall(6, 1.2, 15, .2, 1.5)
			#end
			rotate -y
			texture {T_Sable}
		}
		object {
			isosurface {
				function { -y - (noise3d(x*3, y*3, z*3)^2)*.15 + (noise3d(x*15, y*15, z*15)^2)*.05 }
				bounded_by {box{<-3.1, -1, -1>, <3.1, 2, 2>}}
			}
			rotate -95*x
			translate -.65*z
			texture { T_Sable2 }
		}
		object {
			isosurface {
				function { y + (noise3d(x*3, y*3, z*3)^2)*.2 + (noise3d(x*15, y*15, z*15)^2)*.05 }
				bounded_by {box{<-1.2, -3.5, -3>, <1.2, .5, 1>}}
			}
			rotate 115*x
			rotate 60*y
			translate -2*x
			texture { T_Sable2 }
		}
	}
	object {
		#if (Detail_Chateau = 1)
		IsoWall(6, 1.5, 4, 1.7, .05)
		#else
		Sand_Rounded_Wall(6, 1.2, 15, .2, 1.5)
		#end
		rotate 2*y
		translate 3*z
		texture {T_Sable}
	}
	difference {
		object {
			#if (Detail_Chateau = 1)
			IsoWall(3, 1.5, 4, 1.7, .05)
			#else
			Sand_Rounded_Wall(3, 1.5, 15, .2, 1.5)
			#end
			rotate y*89
			translate -3*x +2*z
			texture {T_Sable}
		}
		object {
			isosurface {
				function { y + (noise3d(x*3, y*3, z*3)^2)*.2 + (noise3d(x*15, y*15, z*15)^2)*.05 }
				bounded_by {box{<-1, -3, -3>, <1, .5, 1>}}
			}
			rotate 115*x
			translate -3*x + z
			texture { T_Sable2 }
		}
	}
	object {
		#if (Detail_Chateau = 1)
		IsoWall(3, 1.5, 4, 1.7, .05)
		#else
		Sand_Rounded_Wall(3, 1.2, 15, .2, 1.5)
		#end
		rotate y*92
		rotate -2*x
		translate 3*x + 1.5*z
		texture {T_Sable}
	}
}

#end
