
#declare Place_Chateau = on;
#declare Place_Galets = on;
#declare Detail_Chateau = 1;
#declare Place_Mer = on;
#declare Detail_Mer = 3;
#declare Place_Plage = on;
#declare Detail_Plage = 3;
#declare Place_Seau = on;
#declare Place_Signature = off;
#declare Detail_Signature = 1;


#declare Use_Rad = on;

#include "csable.inc"
#include "seau.inc"


global_settings { max_trace_level 10 }


#if (Use_Rad)
global_settings {
	ini_option "+QR"
	radiosity {
		brightness .7
		count 20      
		recursion_limit 4
	}
	ambient_light .6
}


light_source { <-200, 40, -50> color .3 shadowless }

#else
light_source { <-200, 40, -50> color .3 shadowless }

#end


#declare cam_position = <-7, 3, -3>*1.2;
#declare cam_look = <1, 0, 1>;

camera {
	location cam_position
	right x*320/240
	up y
	angle 30
	look_at cam_look
}

light_source {
	<-cam_position.x, cam_position.y+1, cam_position.z>*1000
	color rgb <1, 1, 1>*1
}



background { color rgb <.6, .8, 1> }


	

#declare T_Sable_Sec = texture {
	pigment { color rgb <255, 204, 150>/255 }
	#if (Detail_Plage < 3)
	normal { granite .4 scale .05 }
	#end
	finish { ambient .4 diffuse .5 specular .1 }
}

#declare T_Sable_Humide = texture {
	pigment { color rgb <255, 204, 150>/400 }
	#if (Detail_Plage < 3)
	normal { granite .2 scale .05 }
	#end
	finish { ambient .4 diffuse .5 specular .1 }
}

#declare T_Sable_Humide2 = texture {
	pigment { color rgb <255, 204, 150>/500 }
	#if (Detail_Plage < 3)
	normal { granite .2 scale .05 }
	#end
	finish { ambient .4 diffuse .5 specular .1 }
}

#declare T_Sable_Mouille = texture {
	pigment { color rgb <255, 204, 150>/500 }
	#if (Detail_Plage < 3)
	normal { granite .1 scale .05 }
	#end
	finish { ambient .4 diffuse .5 specular .5 roughness .1 }
}



#macro Plage(PAngle, PTurb1, PAmount1, PTurb2, PAmount2)

#local FBase = function { y - PAngle*z }
#local Fb1 = function { PAmount1*noise3d(x*PTurb1+10, y*PTurb1+30, z*PTurb1+12)*sqrt(max(0, min(-2*((z+2)*.2)^3 + 3*((z+2)*.2)^2, 1))) }
#local Fb2 = function { PAmount2*noise3d(x*PTurb2, y*PTurb2, z*PTurb2) }
#local Fb3 = function { PAmount2*noise3d(x*PTurb2*12, y*PTurb2*12, z*PTurb2*12)^2*.03 }
#local Fa1 = function { if(z-4,1,sqrt(max(0, min(-2*((z+1)*.2)^3 + 3*((z+1)*.2)^2, 1)))) }

object {
	isosurface {
		#switch (Detail_Plage)
			#case (0)
			function { FBase(x,y,z)
			}
			#break
			
			#case (1)
			function { FBase(x,y,z)
					- Fb1(x,y,z)
			}
			#break
			
			#case (2)
			function { FBase(x,y,z)
					- Fb1(x,y,z)
					- Fb2(x,y,z)*Fa1(x,y,z)
			}
			#break
			#case (3)
			function { FBase(x,y,z)
					- Fb1(x,y,z)
					- (Fb2(x,y,z) + Fb3(x,y,z))*Fa1(x,y,z)
			}
			#break
		#end
		threshold 0
		eval
		max_gradient 2
		bounded_by { box{<-10, -3, -20>, <40,7,20>} }
	}
	

	#if (Detail_Plage > 0)
	texture {
		function { min(max (0, .5 + PAngle*z
					+ PAmount1*noise3d(x*PTurb1+10, y*PTurb1+30, z*PTurb1+12)*sqrt(max(0, min(-2*((z+2)*.2)^3 + 3*((z+2)*.2)^2, 1)))
					), 1)
		}
		texture_map {
			[0.00 T_Sable_Humide2 ]
			[0.40 T_Sable_Humide2 ]
			[0.50 T_Sable_Mouille ]
			[0.62 T_Sable_Mouille ]
			[0.65 T_Sable_Humide ]
			[0.79 T_Sable_Sec ]
			[1.00 T_Sable_Sec ]
		}
	}
	#else
	pigment { color rgb<255, 204, 150>/255 }
	finish { ambient .4 diffuse .5 specular .1 }
	#end
}
#end


#macro Mer(PAngle, PTurb1, PAmount1)

#local FunBord = function {
	min(max (0,
		.08 - PAngle*z
			- PAmount1*noise3d(x*PTurb1+10, y*PTurb1+30, z*PTurb1+12)*sqrt(max(0, min(-2*((z+2)*.2)^3 + 3*((z+2)*.2)^2, 1)))
	), 1)
}

#local Sp = spline {
	cubic_spline
	0.00, <-0.3, -0.3, -0.3>
	0.01, <0.9, 0.9, 0.9>
	0.10, <0.5, 0.5, 0.5>
	0.30, <0.0, 0.0, 0.0>
	1.00, <0.0, 0.0, 0.0>
}

#local Fun1 = function {
	pigment {
		function { FunBord(x,y,z) }
		color_map {
			[0.00 rgb Sp(0)]
			[0.005 rgb Sp(0.005)]
			[0.01 rgb Sp(0.01)]
			[0.02 rgb Sp(0.02)]
			[0.10 rgb Sp(0.10)]
			[0.15 rgb Sp(0.15)]
			[0.20 rgb Sp(0.20)]
			[0.30 rgb Sp(0.30)]
		}
	}
}

#local FGranite = function {
	pigment {
		granite
		scale .5
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}


#local Fun2 = function {
	pigment {
		function { FunBord(x,y,z) }
		color_map {
			[0 rgb 0.0]
			[0.07 rgb 0.0]
			[0.15 rgb 1.0]
			[1.0 rgb 1.0]
		}
	}
}

#local Fun3 = function {
	pigment {
		function { FunBord(x,y,z) }
/*		warp { black_hole <-1.5, 0, -.25>, 3 strength 1.2 inverse } */
		color_map {
			[0.0 rgb 1.0]
			[0.04 rgb 1.0]
			[0.07 rgb 0.5]
			[0.23 rgb 0.0]
			[1.0 rgb 0.0]
		}
	}
}


#local T_Eau = texture {
	pigment { color rgbf <1, 1, 1, 0.99>}
	normal { granite .1 scale <.9,.9,.6> }
	finish { ambient 0 diffuse 0
		reflection_type 1
	}
}

#local T_Ecume = texture {
	pigment { color rgbf <1, 1, 1, 0.99>}
	normal { granite .4 scale .2 }
	finish { ambient 0 diffuse 0
		specular .5 roughness 0.005
	}
}

object {

	#if (Detail_Mer > 0)
	isosurface {
		#switch (Detail_Mer)
			#case (1)
				function { y - .08
					+ .1*noise3d(x*.8, y*3, z*2)
				}
			#break

			#else
				function { y - .08
					+ .1*Fun2(x,0.08,z)*noise3d(x*.8, 0.08, z*2)
					- .03*Fun1(x,0.08,z)*(.2 + noise3d(8*x, 0.08, 15*z)^.5)
				}
			#break
		#end
		bounded_by { box { < -10, -5, -5>, <30, 0.40, .5> } }
		eval
		max_gradient 9
		max_trace 2
	}
	#else
	box { < -10, -5, -5>, <30, 0.08, 1> }
	#end
	
	#if (Detail_Mer > 2)
	texture {
		function { Fun3(x,y,z) }
		texture_map {
			[0.0  T_Eau]
			[0.3  T_Eau]
			[0.9  T_Ecume]
			[1.0  T_Ecume]
	 	}
	}
	interior {
		ior 1.3
		media {
			emission 4
			intervals 1
			samples 1,1
			method 1
			jitter 1
			confidence .5
			variance 1/50
			density {
				function { Fun3(x,y,z) }
				density_map {
					[0.0 rgb <0,0,0>]
					[0.5 bozo turbulence 1 octaves 2 scale .1 color_map {[0 rgb 0] [.4 rgb 0] [.7 rgb .7] [1 rgb .7]}]
					[0.7 bozo turbulence 1 octaves 2 scale .1 color_map {[0 rgb 0] [.2 rgb 0] [.4 rgb .7] [1 rgb .9]}]
					[0.9 bozo turbulence 1 octaves 2 scale .1 color_map {[0 rgb 0] [.1 rgb 0] [.3 rgb .5] [1 rgb 1]}]
					[1.0 bozo turbulence 1 octaves 2 scale .1 color_map {[0 rgb 0] [.2 rgb .5] [1 rgb 1]}]
				}
				warp { reset_children }
				warp { turbulence .7 octaves 2 lambda 5 }
			}
		}
	}
	hollow
	#else
	pigment {
		function { FGranite(x,y,z) }
		color_map{
			[0.0 rgb 0.0]
			[1.0 rgb 1.0]
		}
	}
	finish { ambient .5 diffuse .5 }
	#end
}

#end




#if (Place_Chateau)
#declare Chateau_En_Place = object {
	Chateau_Sable()
	translate -1.5*z
	rotate  -5*x
	scale .5
	translate .5*z-.07*y
}

object { Chateau_En_Place }

#if (Place_Galets)

#include "galets.inc"

/* galets tour ecroulee */
	#declare Pos = -1.5*x -.25*z;
	#declare i = 5;
	#declare Str = seed(1235);
	#while (i > 0)
		#declare dec = vaxis_rotate(.3*x, y, 360*i/5 + rand(Str)*20);
		PlaceGaletSur(Chateau_En_Place, Pos + dec, .7, .5, .3, rand(Str)*123, .15)
		#declare i = i - 1;
	#end

/* galets tour 1 */
	#declare Pos = -1.5*x +1.2*z;
	#declare i = 4;
	#declare Str = seed(3214);
	#while (i > 0)
		#declare dec = vaxis_rotate(.2*x, y, 360*i/4 + rand(Str)*20);
		PlaceGaletSur(Chateau_En_Place, Pos + dec, .7, .5, .3, rand(Str)*1234, .15)
		#declare i = i - 1;
	#end

/* galets tour 2 */
	#declare Pos = 1.5*x +1.2*z;
	#declare i = 4;
	#declare Str = seed(652);
	#while (i > 0)
		#declare dec = vaxis_rotate(.2*x, y, 360*i/4 + rand(Str)*20);
		PlaceGaletSur(Chateau_En_Place, Pos + dec, .7, .5, .3, rand(Str)*2345, .15)
		#declare i = i - 1;
	#end

/* galets tour 3 */
	#declare Pos = 1.5*x -.25*z;
	#declare i = 4;
	#declare Str = seed(5412);
	#while (i > 0)
		#declare dec = vaxis_rotate(.2*x, y, 360*i/4 + rand(Str)*20);
		PlaceGaletSur(Chateau_En_Place, Pos + dec, .7, .5, .3, rand(Str)*3456, .15)
		#declare i = i - 1;
	#end



#end
#end


#if (Place_Seau)

object {
	Seau(1.2,.8, 2.5)
	scale .5
	rotate x*90
	rotate z*45
	rotate -x*9.2
	rotate -y*80
	translate <3,.89,3>
}

#end


#if (Place_Plage)
	#declare O_Plage = Plage(.1, .5, .3, 3, .1)
	object { O_Plage } 
#end
#if (Place_Mer)
	#declare O_Mer = Mer(.1, .5, .3)
	object { O_Mer }
#end

#if (Place_Signature)

#include "sign.inc"

#declare save_DM = Detail_Mer;
#declare Detail_Mer = 1;

#declare Pseudo_Mer = Mer(.1, .5, .3)

object {
	union {
		Signature(
			"BOUF",
			"comics__.ttf",
			Pseudo_Mer,
			<.08, .12, .02>,
			<0,63,0>
			<-1.5, 0, -2.1>,
			12
		)
	}
#if (Detail_Signature > 0)
	texture {
		pigment {color rgb <24, 124, 38>/255}
		normal { wrinkles scale .01 }
		finish { ambient .4 diffuse .6
			phong .3 phong_size 100
		}
	}
#else
	pigment { color rgb <24, 124, 38>/255 }
	finish { ambient .4 diffuse .6 }
#end	

#declare Detail_Mer = save_DM;
#undef save_DM

}

#end

