#declare S_Test = off;



#macro Seau(Rayon1, Rayon2, Hauteur)

#local N_Dents = normal {
	dents 1
	scale .05
	warp { turbulence .3 octaves 2 lambda 5 omega .7 }
}

#local T_Seau = texture {
	pigment {
		color rgb<36,27,207>/255
	}
	normal {
		N_Dents
	}
	finish {
		phong .3 phong_size 20
		ambient .4 diffuse .6
	}
}

#local T_Anse = texture {
	pigment {
		color rgb<241,236,7>/255
	}
	normal {
		N_Dents
	}
	finish {
		phong .4 phong_size 20
		ambient .4 diffuse .6
	}
}


#local O_Seau = union {
	difference {
		union {
			cone { y*Hauteur, Rayon1*1.02, 0, Rayon2*1.02 }
			cylinder { y*Hauteur, y*Hauteur*.96, Rayon1*1.1 }
		}
		cone { y*Hauteur*1.05, Rayon1, y*Hauteur*.02, Rayon2 }
	}
	torus { Rayon1*1.05, Rayon1*.05
		scale <1,.8,1>
		translate y*Hauteur
	}
	texture { T_Seau }
}

#local O_Anse = union {
	cylinder { <Rayon1*1.05, 0, 0>, <Rayon1*1.25, 0, 0>, Hauteur*.015 }
	cylinder { <-Rayon1*1.05, 0, 0>, <-Rayon1*1.25, 0, 0>, Hauteur*.015 }
	intersection {
		sphere { <-Rayon2*.35,0,0>, Rayon2*.37 }
		box {<0,-Rayon2*.2, -Rayon2*.2>, <Rayon2*.05,Rayon2*.2, Rayon2*.2>}
		translate x*Rayon1*1.25
	}
	intersection {
		sphere { <Rayon2*.35,0,0>, Rayon2*.37 }
		box {<-Rayon2*.05,-Rayon2*.2, -Rayon2*.2>, <0,Rayon2*.2, Rayon2*.2>}
		translate -x*Rayon1*1.25
	}
	difference {
		cylinder { -z*Hauteur*.02, z*Hauteur*.02, Rayon1*1.2 }
		cylinder { -z*Hauteur*.03, z*Hauteur*.03, Rayon1*1.15 }
		box { <-Rayon1*1.25, -Rayon1*1.25, -Hauteur*.025>, <Rayon1*1.25, 0, Hauteur*.025> }
	}
	difference {
		cylinder { x*Rayon1*1.15, x*Rayon1*1.2, Hauteur*.02 }
		box { <Rayon1*1.1,0,-Hauteur*.25>, <Rayon1*1.25,Hauteur*.25,Hauteur*.25> }
	}
	difference {
		cylinder { -x*Rayon1*1.2, -x*Rayon1*1.15, Hauteur*.02 }
		box { <-Rayon1*1.25,0,-Hauteur*.25>, <-Rayon1*1.1,Hauteur*.25,Hauteur*.25> }
	}
	
	texture { T_Anse }
}

union {
	object { O_Seau }
	object { O_Anse
		rotate -x*125
		translate y*Hauteur*.98
	}
}

#end



#if (S_Test)

camera
{
	location  <5.0, 5.0, -8.0>
	up        y
	right     320/200*x
	look_at   <0, 2,  0.0>
	angle 40
}

light_source { <15, 15, -15>  color rgb 1 }

Seau(1.2,.8, 2.5)

#end

