//------------------------------------------------------------------------
//
//  Childhod.pov
//
//  Author:  Robert J Becraft
//  Created:  February, 2000
//------------------------------------------------------------------------
#include "kolors.inc"  // uncle Ken's file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "textures.inc"

//*** Custom Textures ------------------------------------------


//************************* CAMERA ***********************************
camera {

  location  <.5,.35,-2.5>  look_at <0,0,0>       // South, center looking up main canal
}
light_source { <0,1,-5 >  color Wheat/2 }      
light_source { <-1.5,1.5,2.5 >  color Wheat }
//------------------------------------------------------------------------

#declare Block_Wood=texture{T_Wood7 scale .15}

#declare Block1=union{
      box{<-.01,-.020,-.06><.01,.020,.06>  }
      box{<-.005,-.025,-.06><.005,.025,.06> }
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,-.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,-.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,.020,0>}
            
      texture{Block_Wood}
    }

#declare Block1_Arch=difference{
  union{
      box{<-.01,-.020,-.06><.01,.020,.06>  }
      box{<-.005,-.025,-.06><.005,.025,.06> }
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,-.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,-.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,.020,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,.020,0>}
    } // union
  cylinder{<-.011,-.021,0><.011,-.021,0> .03  }
              
  texture{Block_Wood}
} // differene

#declare Block2=union{
      box{<-.01,-.020,-.025><.01,.020,.025>  }
      box{<-.005,-.025,-.025><.005,.025,.025> }
      cylinder{<0,0,-.025><0,0,.025> .005 translate<-.005,-.020,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<.005,-.020,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<-.005,.020,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<.005,.020,0>}
            
      texture{Block_Wood}
    }

#declare Block3=union{
      box{<-.01,-.005,-.06><.01,.005,.06>  }
      box{<-.005,-.01,-.06><.005,.01,.06> }
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,-.005,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,-.005,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<-.005,.005,0>}
      cylinder{<0,0,-.06><0,0,.06> .005 translate<.005,.005,0>}
            
      texture{Block_Wood}
    }

#declare Block4=union{
      box{<-.01,-.005,-.025><.01,.005,.025>  }
      box{<-.005,-.01,-.025><.005,.01,.025> }
      cylinder{<0,0,-.025><0,0,.025> .005 translate<-.005,-.005,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<.005,-.005,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<-.005,.005,0>}
      cylinder{<0,0,-.025><0,0,.025> .005 translate<.005,.005,0>}
            
      texture{Block_Wood}
    }        

#declare Block5=cylinder{<0,-.025,0><0,.025,0> .01 texture{Block_Wood rotate<90,0,0>}}
#declare Block6=cylinder{<0,-.06,0><0,.06,0> .01 texture{Block_Wood rotate<90,0,0>}} 

#declare Wall1=union{
   #declare WR=seed(993);                             
   #declare C1=-.65;
   #while (C1<.6)      
    #declare ROY=rand(WR)*10-5;
    #declare RZ=rand(WR)*.02-.01;
    object{Block1 rotate<90,90+ROY,0> translate<0,0,C1>} 
 
    #declare ROY2=rand(WR)*10-5;
    object{Block2 rotate<90,90+ROY,0> translate<0,.105,C1>} // second floor
    
    #if (C1<.5) // don't leave an overhanging block at the end
      #declare ROY=rand(WR)*5-2.5;
      object{Block1 rotate<0,0,90> rotate<0,WR,0> translate<0,.07,C1+.0565>}  // toppers  
      object{Block1_Arch rotate<0,0+ROY,0> translate<0,.15,C1+.0565>}         
    #end
    #declare C1=C1+.113+RZ;
   #end
}

#declare Wall2=union{
   #declare WR=seed(993);                             
   #declare C1=-.65;
   #while (C1<0)      
    #declare ROY=rand(WR)*.05;
    #declare RZ=rand(WR)*.02-.01;
    object{Block3 rotate<90,90+ROY,0> translate<0,0,C1>}
    
    #if (C1<-.1) // don't leave an overhanging block at the end
      #declare ROY=rand(WR)*.05;
      object{Block3 rotate<0,0,90> rotate<0,WR,0> translate<0,.07,C1+.056>}  // toppers        
    #end
    #declare C1=C1+.113+RZ;
   #end
}

#declare Center=union{
   object{Block1 rotate<90,0,0> translate<0,.06,-.06>}
   object{Block1 rotate<90,0,0> translate<0,.06,.06>}
//   object{Block1 rotate<0,0,90> translate<0,.13,0>} // topper 
   object{Block1_Arch translate<0,.145,0>} 
   object{Block5 translate<0,.145,-.072>}  // cylinders
   object{Block5 translate<0,.145,.073>}
}

#declare Center2=union{
   object{Center translate<-.055,0,0>}
   object{Center rotate<0,180,0> translate<.055,0,0>}
   object{Block1 rotate<0,90,0> translate<0,.195,.04>}
   object{Block1 rotate<0,-90,0> translate<0,.195,-.04>} 
   
   object{Block1 rotate<90,0,90> translate<0,.18,-.075>}
   object{Block1 rotate<90,0,90> translate<0,.18,.075>}
   
   object{Block5 translate<.05,.215,-.076>}  // cylinders
   object{Block5 translate<.051,.215,.0765>}
   object{Block5 translate<-.0505,.215,-.074>}
   object{Block5 translate<-.055,.215,.075>}  
   
   object{Block1 rotate<0,90,90> rotate<90,0,0> translate<0,.2275,0>}
   
   object{Block3 rotate<0,50,0> translate<.04,.2475,.04>  }
   object{Block3 rotate<0,-40,0> translate<.055,.2475,-.065>}
   object{Block3 rotate<0,50,0> translate<-.045,.2475,-.045>}
   object{Block3 rotate<0,-40,0> translate<-.055,.2475,.065>} 
   
   object{Block2 rotate<90,0,90> translate<0,.2675,0>} // center top  
   object{Block1 rotate<0,90,90> rotate<90,0,0> translate<.028,.2875,0>}   
   object{Block1 rotate<0,90,90> rotate<90,0,0> translate<-.028,.2875,0>}                  
   object{Block1 rotate<0,90,90> rotate<90,90,0> translate<0,.3075,.028>}   
   object{Block1 rotate<0,90,90> rotate<90,90,0> translate<0,.3075,-.028>}         

}

#declare StoneBlock=union{  

   object{Block2 rotate<90,0,0> translate<0,.01,0> rotate<0,40,0>}
   
   object{Block1 rotate<90,0,0> rotate<0,20,0> translate<.18,.030,0> }
   object{Block1 rotate<90,0,0> rotate<0,-50,0> translate<.2,.030,0> rotate<0,40,0> }
   object{Block1 rotate<90,0,0> translate<.2,.030,0> rotate<0,60,0> }
   object{Block1 rotate<90,0,0> rotate<0,16,0> translate<.23,.030,0> rotate<0,93,0> }
   object{Block1 rotate<90,0,0> translate<.22,.030,0> rotate<0,130,0>}
   object{Block1 rotate<90,0,0> translate<.21,.030,0> rotate<0,160,0>}
   object{Block1 rotate<0,0,90> rotate<0,50,0> translate<.19,.01,0> rotate<0,185,0>}
   object{Block1 rotate<90,0,0> translate<.2,.030,0> rotate<0,222,0>}
   object{Block1 rotate<0,0,90> translate<.2,.01,0> rotate<0,250,0>}   
   
      object{Block1 rotate<0,0,90> translate<.2,.10,0> rotate<0,145,0>}  // topper
      object{Block1 rotate<0,0,90> translate<.19,.10,0> rotate<0,18,0>}
      object{Block1 rotate<0,0,90> translate<.2,.10,0> rotate<0,52,0>}
}                             

#declare Wall2Right=union{
   object{Block3 rotate<90,0,0> translate<0,.06,.1>}
   object{Block3 rotate<90,20,0> translate<0,.06,.2>}
      object{Block3 rotate<0,0,90> rotate<0,0,0> translate<0,.13,.156>}  // toppers       
   object{Block3 rotate<0,30,0> translate<0,.01,.34>}
      object{Block3 rotate<0,30,15> rotate<0,0,0> translate<0,.017,.34+.056>}  // toppers       
   object{Block3 rotate<0,-40,0> translate<0,.01,.46>} 
      object{Block3 rotate<0,-70,15> rotate<0,0,0> translate<0,.017,.47+.056>}  // toppers        
   object{Block3 rotate<0,-60,0> translate<.05,.01,.68>}
   object{Block3 rotate<0,-40,0> translate<0,.01,.56>}    
      object{Block3 rotate<0,70,15> rotate<0,0,0> translate<0,.017,.65>}  // toppers        
}

object{Center2 rotate<0,90,0> translate<0,0,-.75>}
                   
object{Wall2 rotate<0,90,0> translate<0,.06,-.85>} // translate<-.35,.03,-.75>}                   
object{Wall2Right rotate<0,90,0> translate<0,0,-.85>}  // translate<-.35,.03,-.75>}
object{Wall1 rotate<0,90,0> translate<0,0,-.6>} // translate<-.45,.03,-.75>}

object{StoneBlock translate<.35,0,-1.5>}
    
        
//object{Block1 rotate<0,40,0>}
//object{Block2 rotate<90,0,0> rotate<0,40,0> translate<0,0,.2>}
//object{Block1 rotate<90,0,0> rotate<0,90,0> translate<-.05,0,.1>}
//object{Block3 translate<.2,0,.2>}
//object{Block4 translate<.15,0,.25>}    

#include "../legos/lego00.inc"
#include "../legos/lego_bricks.inc"  

#macro Lego_Color()  
   #declare NC=8;
   #declare C=int(rand(RC)*NC+1);
   #switch (C)
      #case (1) LegoRed #break;
      #case (2) LegoYellow #break;
      #case (3) LegoBlack #break;
      #case (4) LegoBlue #break;
      #case (5) LegoWhite #break;
      #case (6) LegoGreen #break;
      #case (7) LegoGray #break;
      #case (8) LegoBrown #break;
    #end
#end // macro

#macro Lego_Pile(RLX,RLY,RLZ,RML,RMC,Num_Legos)

   #declare Count=1;
   #declare RL=seed(RML); //init seed
   #declare RC=seed(RMC); //init color seed
   #while (Count<Num_Legos)
      #declare RX=rand(RL)*RLX-RLX/2; 
      #declare RY=rand(RL)*RLY; 
      #declare RZ=rand(RL)*RLZ-RLZ/2;
      #declare ROY=rand(RL)*360;
      #declare ROX=rand(RL)*180-90;
      #declare Lego=int(rand(RL)*16)+1;
      object{
         #switch (Lego)
           #range (1,4)   brick2x2   #break
           #case (5)   brick2x3   #break
           #range (6,11)   brick2x4   #break
           #case (12)   brick2x6   #break
           #case (13)   brick2x8   #break
           #case (14)   brick2x10  #break
           #case (15)   brick2x2r  #break
           #case (16)   brick2x2c  #break                                                           
         #end
        scale .01 texture{Lego_Color()} 
        rotate<ROX,0,0> 
        translate<RX,RY,RZ> rotate<0,ROY,0>
       } // object
       
      #declare Count=Count+1;
   #end // while
#end // macro Lego_Pile

union{Lego_Pile(.4,.05,.075,142,382,180) translate<.5,0,.15>}    
union{Lego_Pile(.6,.03,.2,1242,332,80) translate<-.5,0,.35>}
union{Lego_Pile(.6,.02,.2,333,333,40) translate<.5,0,-.85>}  
 
#macro Lego_Pile2(RLX,RLY,RLZ,RML,RMC,Num_Legos)

   #declare Count=1;
   #declare RL=seed(RML); //init seed
   #declare RC=seed(RMC); //init color seed
   #while (Count<Num_Legos)
      #declare RX=rand(RL)*RLX-RLX/2; 
      #declare RY=rand(RL)*RLY; 
      #declare RZ=int(rand(RL)*4+1);
      #declare ROY=rand(RL)*360;
      #declare ROX=rand(RL)*180-90;
      #declare Lego=int(rand(RL)*16)+1;
      object{
         #switch (Lego)
           #range (1,4)   brick2x2   #break
           #case (5)   brick2x3   #break
           #range (6,11)   brick2x4   #break
           #case (12)   brick2x6   #break
           #case (13)   brick2x8   #break
           #case (14)   brick2x10  #break
           #case (15)   brick2x2r  #break
           #case (16)   brick2x2c  #break                                                           
         #end
        scale .01 texture{Lego_Color()} 
        rotate<0,0,RZ*90>
      //  rotate<ROX,0,0> 
        translate<RX,RY,0> rotate<0,ROY,0>
       } // object
       
      #declare Count=Count+1;
   #end // while
#end // macro Lego_Pile2
 
union{Lego_Pile2(1.5,0,.5,223,133,40) translate<0,0,-1.5>}  

#declare Rug=union{
  cylinder{<0,0,0><0,.0001,0> 1 translate<0,0,-1> }
  cylinder{<0,0,0><0,.0001,0> 1 translate<0,0,1>  }
  box{<-1,0,-1><1,.0001,1> }
//texture{pigment{color Gray} normal{bumps .25}}
               texture{pigment{image_map { gif "..\graphics\cloth014.gif" } scale .1 rotate<90,0,0>}}
}   

object{Rug} 

#declare Wood_Floor=union{
  #declare C1=-3;
  #while (C1<=3)
     #declare RX=rand(RC)*1;
     box{<-.0245,0,-3><.0245,.00005,3> texture{T_Wood3 translate<RX,0,0> scale .15} translate<C1,0,0>}
     #declare C1=C1+.05;
  #end
}
object{Wood_Floor}

#declare Room_Walls=union{
   box{<-2,0,-3><-1.9,2,3>}
   box{<-3,0,2.9><3,2,3>}
   box{<1.9,0,-3><2,2,3>}
   box{<-3,0,-3><-.35,2,-2.9>}
   box{<.35,0,-3><3,2,-2.9>}
   box{<-.5,1.5,-3><.5,2,-2.9>} // top of door
   
   box{<-3,2,-3><3,2.1,3>}  // roof
   
   texture{pigment{color White}}
}

object{Room_Walls} 

#declare Door=box{<0,.02,-.015><.7,1.5,.015> texture{pigment{color Brown}}}

object{Door rotate<0,-65,0> translate<-.35,0,-2.95>}

// Wall pictures
#declare Abusimbel=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\abusimbel.gif" }  rotate<0,0,0>}} scale <.6,.75,1>}     

#declare Colosseum=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\colosseum.gif" }  rotate<0,0,0>}} scale <.6,.75,1>}  

#declare Pisa=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\Pisa.gif" }  rotate<0,0,0>}} scale <.6,.75,1>}  

#declare Parthenon=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\parthenon.gif" }  rotate<0,0,0>}} scale <.75,.5,1>}                                   

#declare Stonehenge=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\stonehenge.gif" }  rotate<0,0,0>}} scale <.6,.75,1>}  

#declare GreatWall=
     box{<0,0,0><1,1,.001> texture{pigment{image_map { gif "..\graphics\Greatwall.gif" }  rotate<0,0,0>}} scale <.6,.75,1>}  
                                      
object{Abusimbel translate<-1.7,.75,2.895>}
object{Colosseum translate<-.7,.75,2.895>}
object{Pisa translate<1.2,.75,2.895>}
object{Parthenon translate<.1,.9,2.895>}
object{Stonehenge rotate<0,90,0> translate<-1.895,.75,.5>}
object{GreatWall  rotate<0,90,0> translate<-1.895,.75,1.5>}


#declare CCArm=union{
   box{<-.1,.5,-.30><.1,.52,.35> texture{T_Wood1 scale .15}}
   cylinder{<0,.5,-.30><0,.52,-.30> .1 texture{T_Wood1 scale .15}}
   box{<-.05,0,-.3><.05,.5,-.25> texture{T_Wood1 scale .15 rotate<90,0,0>}}
   box{<-.05,0,.3><.05,.5,.25> texture{T_Wood1 scale .15 rotate<90,0,0>}}
   box{<-.045,.2,-.3><.045,.22,.3> texture{T_Wood1 scale .15}}  
   
   #declare C1=-.15;
   #while (C1<=.15)
      box{<-.043,.22,C1+.01><.043,.5,C1-.01> texture{T_Wood1 scale .15 rotate<90,0,0>}}
      #declare C1=C1+.05;
   #end
}

#declare CCCoshin= superellipsoid { <0.5, 0.1> scale <.36, .08, .32> texture{pigment{color Red}} }

#declare Couch=union{                               
   object{ CCArm translate<-1.1,0,0>}                               
   object{ CCCoshin translate<-.73,.20,0>}
   object{ CCCoshin translate<0,.20,0>}
   object{ CCCoshin translate<.73,.20,0>}
   object{ CCArm translate<1.1,0,0>}

   box{<-1.1,.1,-.32><1.1,.2,-.25> texture{T_Wood1 rotate<0,90,0> scale .15}} // front couch rail

   object{ CCCoshin translate<-.73,0,0> rotate<108,0,0> translate<0,.4,.35>}
   object{ CCCoshin translate<0,0,0> rotate<110,0,0> translate<0,.4,.35>}
   object{ CCCoshin translate<.73,0,0> rotate<109,0,0> translate<0,.4,.35>}
 } 
 
#declare Chair=union{                               
   object{ CCArm translate<-.42,0,0>}                               
   object{ CCCoshin translate<0,.20,0>}
   object{ CCArm translate<.42,0,0>}

   box{<-.42,.1,-.32><.42,.2,-.25> texture{T_Wood1 rotate<0,90,0> scale .15}} // front couch rail

   object{ CCCoshin translate<0,0,0> rotate<110,0,0> translate<0,.4,.35>}
 }
 
 object{Chair rotate<0,40,0> translate<1.3,0,1.5>} 
 object{Chair rotate<0,100,0> translate<1.3,0,-.4>} 
 
object{Couch rotate<0,-90,0> translate<-1.4,0,.5>} 

#declare Lamp=union{
   cylinder{<0,0,0><0,.02,0> .2 texture{pigment{color Gray}}}
   cylinder{<0,.02,0><0,.04,0> .1 texture{pigment{color Gray}}}
   cylinder{<0,.04,0><0,.05,0> .03 texture{pigment{color Gray}}}
   cylinder{<0,.05,0><0,1.4,0> .015 texture{pigment{color Gray}}}
   cylinder{<0,1.4,0><0,1.42,0> .03 texture{pigment{color Gray}}} 
   sphere{<0,1.5,0> .045 texture{T_Old_Glass}}
   difference{
      sphere{<0,0,0> .3}
      box{<-.31,-.31,-.31><.31,0,.31>}
      sphere{<0,0,0> .29}
      cylinder{<0,0,0><0,.31,0> .05}
      texture{pigment{color rgbt <0.8470, .74700,0.7400,.65>}}
      translate<0,1.35,0>
    } // difference
}

object{Lamp translate<-1.5,0,2.5 >}

#declare Shelf=union{
union { 
box {<0,0,0>,<1.8,0.04,0.5> translate <0,1.5,0>} //top of case
box {<0,0,0>,<1.8,0.04,0.5> translate <0,1.0,0>} //top shelf
box {<0,0,0>,<1.8,0.04,0.5> translate <0,0.5,0>} //middle shelf
box {<0,0,0>,<1.8,0.04,0.5> } // bottom shelf  
box{<0,0,.495><1.8,1.54,0.5>} // back of shelf
texture {T_Wood17 rotate <4,90,0>} 
}
 
union { 
box {<0,0,0>,<0.05,1.54,0.5> translate <0,0,0>} //left side
box {<0,0,0>,<0.05,1.54,0.5> translate <1.8,0,0>} //right side
texture {T_Wood17 rotate <4,0,90>} 
}
#declare RowLength=1.6;
object { 
#declare NumBooks=16; // change variables before including books.inc 
#include "books.inc" // top shelf 
translate <0.05,1.04,0.05>
}
object{
#declare NumBooks=20;
#include "books.inc" // middle
translate <0.05,0.54,0.05> 
}
object{
#declare NumBooks=14;
#include "books.inc" // bottom shelf
translate <0.05,0.04,0.05> 
}
}// union shelf

#declare Shelf1=union{
   object{Shelf translate<0,.075,0>}
   box{<.02,0,.01><1.78,.075,.48> texture{T_Wood17 rotate<0,90,0>}} // base      
}

object{Shelf1 scale .5 translate<.1,0,2.5>}   