// dmruins.pov
// David Morgan-Mar

#declare ShowWindmill = 1;
#declare ShowHomestead = 1;
#declare ShowStraw = 1;
#declare ShowRocks = 1;

#declare Bright = 2;

#declare camera1 = camera {
    location <5,1.5,-10>
    look_at <0,2,0>
}
#declare camera1a = camera {
    location <5,1.5,-10>
    look_at <0,2,0>
    angle 90
}
#declare camera2 = camera {
    location <6,1.5,-12>
    look_at <0,2,0>
}

camera { camera1a }

light_source { <-10,20,-50>, rgb <Bright,Bright,Bright>
}

sky_sphere{
    pigment { gradient y
        colour_map {
            [0.0 rgb <1, 1, 1> ]
            [0.5 rgb <0.9, 0.95, 1> ]
            [0.75 rgb <0.03, 0.0, 0.2> ]
            [1.0 rgb <0.0, 0.0, 0.1> ]
        }
        scale 2
        translate -1
        turbulence 0.06
        rotate <0,70,0>
    }
}

#declare Pigment_Rust = pigment { bozo
    colour_map {
        [ 0.0 rgbt <1,1,1,1> ]
        [ 0.5 rgbt <0.8,0.3,0.0,0.5> ]
        [ 1.0 rgbt <0.8,0.3,0.0,0> ]
    }
    turbulence 0.6
    omega 0.7
    scale 0.8
}

#declare Pigment_Rust2 = pigment { bozo
    colour_map {
        [ 0.0 rgbt <1,1,1,1> ]
        [ 0.5 rgbt <0.8,0.3,0.0,0.5> ]
        [ 1.0 rgbt <0.7,0.1,0.0,0> ]
    }
    turbulence 0.6
    omega 0.7
    scale 0.5
}

#if (ShowHomestead)
#include "homestead.inc"
Homestead(0,0,0)
#end

#if (ShowWindmill)
#include "windmill.inc"
Windmill(-30,0,10,0,-20,true)
#end

// The ground, made up of several pieces:
// foreground heightfield
height_field { gif "ground.gif"
    smooth
    scale <30,0.05,20>
    translate <-15,0,-10>
    texture {
        pigment { granite
            colour_map {
                [ 0.0 rgb <1,0.3,0.1> ]
                [ 0.6 rgb <1,0.3,0.1> ]
                [ 1.0 rgb <1,0.8,0.5> ]
            }
            turbulence 0.1
        }
        normal { granite 0.5
            turbulence 0.1
        }
    }    
}

// midground textured plane
plane { y, 0
    texture {
        pigment { rgb <1,0.3,0.1> }
        normal { onion 0.8
            sine_wave
            scale 1
            scale 0.05
            warp { turbulence 0.15 }
            scale 10
        }
    }
}

// background hills heightfield tiles
union {
    height_field { gif "hills.gif"
        translate <-0.5,0,-0.5>
        scale <100,5,100>
        translate <-50,0,100>
    }
    height_field { gif "hills.gif"
        translate <-0.5,0,-0.5>
        scale <100,5,100>
        translate <-150,0,100>
    }
    height_field { gif "hills.gif"
        translate <-0.5,0,-0.5>
        scale <100,5,100>
        translate <-250,0,100>
    }
    texture {
        pigment { rgb <1,0.8,0.5> }
        finish {
            ambient 0.3
        }
    }    
}
height_field { gif "hills.gif"
    translate <-0.5,0,-0.5>
    scale <100,10,100>
    translate <-300,1,150>
    texture {
        pigment { rgb <0.9,0.5,0.2> }
        finish {
            ambient 0.1
        }
    }    
}

