
// Persistence of Vision Ray Tracer Scene Description File
// File: IRTC.pov
// Vers: 3.1
// Desc: IRTC 01-02/2000 ruines
// Date: 16 janvier 2000 
// Auth: Franck Becquart
 
#include "colors.inc" 
#include "makewall.pov"
#include "textures.inc"	
#include "facade_brick.pov" 
#include "stones1.inc"	
#include "woods.inc"
#include "glass.inc"
#include "skies.inc"    
#include "ciel3.pov"
#include "fenetre.inc"

global_settings { assumed_gamma 1.5 }
 
 
#declare PdV=<0, 20, 10>;
#declare PdA=<40, 00,  20.0>; 
 
 
camera { location <4.51,1.5,-1> look_at <5,1.5,5> } 
      

light_source{<90,25,90> color rgb <0.9, 0.9, 0.7>*1.5 } 
 
 
plane{y,0 pigment{Grey}}
           
background{SkyBlue}  
 
                          
fog { 
  distance 1 
  colour rgbf<0.5, 0.5, 0.5, 0.5> 
  fog_type 2
  fog_offset 0.1
  fog_alt 0.3 
  up <0,10,0>
  turbulence 0.5
}

                               
//=========================================
//             Wall 
//-----------------------------------------

//-----------------------------------------
//           Parameter 
//-----------------------------------------
#declare typeWall=2;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;        // usual ellipsoid parameter
#declare xWall=30;             // wall length in x
#declare yWall=4;              // wall height in y
#declare eMortar=0.005;           // mortar thickness
#declare eWall=-0.98;             // mortar depth
#declare xBrickMin=0.09;             // min brick size
#declare xBrickMax=0.11;             // max brick size
#declare yBrickMin=0.09;             // min brick height
#declare yBrickMax=0.11;             // max brick height
#declare seedWall=200;              // seed wall
#declare srd1=0.5;                  // randomness amount for brick position (0=no random) // choix au hazard de la position des briques
#declare srd2=0.07;                  // randomness amount for brick rotation (0=no random) // choix au hazard de la rotation des briques
#declare srdcol=0.8;                // randomness amount for color (0=no random)          // choix au hazard de la couleur  des briques
#declare patternWall=1;             // y color gradient for wall texture
                                    // 0=uniform color
                                    // 1=no color gradient
                                    // 2=from dark to light
                                    // 3=from light to dark

#declare pigWall=rgb<0.89,0.9,0.95>*1.2;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.8,0.8,0.8>}} // mortar texture

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) rotate <90,0,0> translate <-10,-0.9,0>}

//-----------------------------------------
//           Parameter 
//-----------------------------------------
#declare typeWall=2;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.05;        // usual ellipsoid parameter
#declare xWall=30;             // wall length in x
#declare yWall=0.2;              // wall height in y
#declare eMortar=0.0025;           // mortar thickness
#declare eWall=-0.98;             // mortar depth
#declare xBrickMin=0.55;             // min brick size
#declare xBrickMax=0.45;             // max brick size
#declare yBrickMin=0.05;             // min brick height
#declare yBrickMax=0.15;             // max brick height
#declare seedWall=200;              // seed wall
#declare srd1=1;                  // randomness amount for brick position (0=no random) // choix au hazard de la position des briques
#declare srd2=0.00;                  // randomness amount for brick rotation (0=no random) // choix au hazard de la rotation des briques
#declare srdcol=1;                // randomness amount for color (0=no random)          // choix au hazard de la couleur  des briques
#declare patternWall=1;             // y color gradient for wall texture
                                    // 0=uniform color
                                    // 1=no color gradient
                                    // 2=from dark to light
                                    // 3=from light to dark

#declare pigWall=rgb<0.89,0.9,0.95>*1.2;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.8,0.8,0.8>}} // mortar texture

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) rotate <90,0,0> translate <-10,-0.75,4>}

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) rotate <90,0,0> translate <-10,-0.75,-0.2>}

//-----------------------------------------
//           Parameter 
//-----------------------------------------
#declare typeWall=1;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;        // usual ellipsoid parameter
#declare xWall=30;             // wall length in x
#declare yWall=2;              // wall height in y
#declare eMortar=0.005;           // mortar thickness
#declare eWall=-0.98;             // mortar depth
#declare xBrickMin=0.35;             // min brick size
#declare xBrickMax=0.40;             // max brick size
#declare yBrickMin=0.35;             // min brick height
#declare yBrickMax=0.45;             // max brick height
#declare seedWall=200;              // seed wall
#declare srd1=0;                  // randomness amount for brick position (0=no random) // choix au hazard de la position des briques
#declare srd2=0.00;                  // randomness amount for brick rotation (0=no random) // choix au hazard de la rotation des briques
#declare srdcol=1;                // randomness amount for color (0=no random)          // choix au hazard de la couleur  des briques
#declare patternWall=1;             // y color gradient for wall texture
                                    // 0=uniform color
                                    // 1=no color gradient
                                    // 2=from dark to light
                                    // 3=from light to dark

#declare pigWall=rgb<0.89,0.9,0.95>;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.8,0.8,0.8>}} // mortar texture

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) rotate <90,0,0> translate <-10,-0.75,4.2>}

object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar) rotate <90,0,0> translate <-10,-0.75,-2.2>}

                                                    
                                 

object { facade_B translate <0,0.2,6.2> }    

object { fenetre_C translate <0.08,-0.01,-0.7> }
        

                                





