// Persistence of Vision Ray Tracer Scene Description File
// File: blinde.pov
// Vers: 3.1
// Desc: IRTC 01-02/2000 ruines
// Date: 16 janvier 2000 
// Auth: Franck Becquart 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

//========objet========//

#declare camouflage = texture {
  pigment {
    marble
    turbulence 1
    color_map {
      [0.000, 0.900 color rgb <0.26, 0.41, 0.31>
      color rgb <0.260000, 0.510000, 0.310000>]
      [0.000, 0.922 color rgb <0.26, 0.41, 0.31>
      color rgb <0.260000, 0.500000, 0.310000>]
      [0.000, 0.901 color rgb <0.26, 0.41, 0.31>
      color rgb <0.260000, 0.480000, 0.310000>]
    }
  }
  finish {
    crand 0.02
  }
}

//---boulon---//
#declare boulon= 
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.02,        
   7,        
  < 0.034641, 0>, < 0.017321, 0.03>, < -0.017321, 0.03>, < -0.034641, 0>, < -0.017321, -0.03>, < 0.017321, -0.03>, < 0.034641, 0>
  texture { Rust }  
}       
//---caisse---//

#declare caisse=
union { 
difference {
cylinder { <0,0,0>,<0,0.05,0>,1.3  texture { camouflage scale 5} }      
cylinder { <0,0,0>,<0,0.11,0>,1.27  texture { camouflage scale 5} }                                
translate <2.25,1.3,4.3> 
}  
difference {
box { < 0, 0.01, 0.9>,< 4.5, 1.299, 7.899> texture { camouflage scale 5} }
prism {
  linear_sweep 
  linear_spline 
   0,       
   5,        
   4,        
  < 0, 0>, < 0.5,  0>, < 0, 1>, < 0,  0> 
  rotate <-90,-270,-180>
  translate <-0.1,1.3,7.9>
  texture { camouflage scale 5} 
}  
prism {
  linear_sweep 
  linear_spline 
   0,       
   8,        
   4,        
  < 0, 0>, < 0.8, 0>, < 0, 1>, < 0, 0> 
  rotate <-90,-0,-180>
  translate <4.51,1.3,7.9>
  texture { camouflage scale 5} 
}  
prism {
  linear_sweep 
  linear_spline 
   0,       
   8,        
   4,        
  < 0, 0>, < 0.8, 0>, < 0, 1>, < 0, 0> 
  rotate <-90,-180,-180>
  translate <-0.01,1.3,0>
texture { camouflage scale 5} }
prism {
  linear_sweep 
  linear_spline 
   0,       
   5,        
   4,        
  < 0, 0>, < 1, 0>, < 0, 1.5>, < 0, 0> 
  rotate <0,0,-90>
  translate <-0.01,1.3,0.89>
texture { camouflage scale 5} }  
prism {
  linear_sweep 
  linear_spline 
   -10,       
   8,        
   4,        
  < 0, 0>, < -0.3, 0>, < 0, 0.3>, < 0, 0> 
  rotate <0,0,-90>
  translate <-1,0,7.9>
texture { camouflage scale 5} }
prism {
  linear_sweep 
  linear_spline 
   -1,       
   8,        
   4,        
  < 0, 0>, < -0.3, 0>, < 0, 0.3>, < 0, 0> 
  rotate <-90,-180,-270>
  translate <4.51,0,0.89>
texture { camouflage scale 5} } 
prism {
  linear_sweep 
  linear_spline 
   -1,       
   8,        
   4,        
  < 0, 0>, < -0.3, 0>, < 0, 0.3>, < 0, 0> 
  rotate <-90,-180,-0>
  translate <-0.01,0,0.89>
texture { camouflage scale 5} }
union {
cylinder { <0,0,0>,<0,1,0>,0.12 translate <0.27,0.5,2.5> texture { camouflage scale 5} }
box { <-0.12,0,-0.12>,<0,1,0.12> translate <0.27,0.5,2.5> texture { camouflage scale 5} }
}
}
difference {
union { 
box { <0,0.01,0.5>,<0.9,0.3,0.9> texture { camouflage scale 5} }
box { <3.6,0.01,0.5>,<4.5,0.3,0.9> texture { camouflage scale 5} }
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.9,        
   6,        
  < 0.05, 0.01>, < 0.45, 0.01>, < 0.45, 0.3>, < 0.3, 0.25>,<0.15,0.14>,<0.05,0.01>
  rotate <-90,-90,0>
  translate <0,0.00,0.05>
texture { camouflage scale 5} } 
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.9,        
   6,        
  < 0.05, 0.01>, < 0.45, 0.01>, < 0.45, 0.3>, < 0.3, 0.25>,<0.15,0.14>,<0.05,0.01>
  rotate <-90,-90,0>
  translate <3.6,0.00,0.05>
texture { camouflage scale 5} }
}
prism {
  linear_sweep 
  linear_spline 
   -1,       
   8,        
   4,        
  < 0, 0>, < -0.3, 0>, < 0, 0.3>, < 0, 0> 
  rotate <-90,-180,-270>
  translate <4.51,0.,0.89>
texture { camouflage scale 5} } 
prism {
  linear_sweep 
  linear_spline 
   -1,       
   8,        
   4,        
  < 0, 0>, < -0.3, 0>, < 0, 0.3>, < 0, 0> 
  rotate <-90,-180,-0>
  translate <-0.01,0,0.89>
texture { camouflage scale 5} }
}   
prism {
  linear_sweep 
  linear_spline 
   0,       
   -2.7,        
   5,        
  < 0, 0>, < 6.5, 0>, < 7, 0.7>, < 0, 0.7>, <0, 0> 
  rotate <-90,-90,0>
  translate <3.6,-0.7,0.9>
texture { camouflage scale 5} }
//---avant caisse---//
#declare avant_caisse=

union {
difference {
blob {
threshold 0.21  
cylinder { <0.9,-0.2,0.9>,<1.3,0-0.2,0.9>,0.5 2 texture { camouflage scale 5} }
cylinder { <3.2,-0.2,0.9>,<3.6,-0.2,0.9>,0.5 2  texture { camouflage scale 5} }
cylinder { <1.6,-0.11,0.9>,<2.9,-0.11,0.9>,0.4  2 texture { camouflage scale 5} }
}
cylinder { <0.9,-0.2,0.9>,<-1.3,0-0.2,0.9>,0.6  texture { camouflage scale 5} }
cylinder { <3.6,-0.2,0.9>,<5,-0.2,0.9>,0.6   texture { camouflage scale 5} }
translate z*-0.31
}


#declare ac=
box { <0,0,0>,<2.7,0.6,1.4> rotate <-34,0,0> translate <0.9,-0.1,0.9> texture { camouflage scale 5} }
object { ac translate <0,-0.27,-0.2> } 
}
}
//====anneaux===///
#declare anneaux=
union {
intersection {  
box { <0,0,0>,<0.05,0.1,0.1> translate y*0.02 texture { camouflage scale 5} }
torus{ 0.035, 0.0075 rotate z*90 translate <0.025,0.02,0.05> texture { camouflage scale 5} }
translate y*0.03
}
box { <0,0,0>,<0.05,0.01,0.1>  texture { camouflage scale 5} }
cylinder { <0,0,0>,<0,0.04,0>,0.0075 translate <0.025,0.01,0.015> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0,0.04,0>,0.0075 translate <0.025,0.01,0.085> texture { camouflage scale 5} }
scale 2  
}
//---grille---//
#declare grille=
union {
#declare trape=
union {            
#declare event=
union {
difference {
union {
cylinder { <0,0,0.01>,<0,0,0.25>,0.01 texture { camouflage scale 5} }
sphere { <0,0,0.01>,0.01 texture { camouflage scale 5} }
sphere { <0,0,0.25>,0.01 texture { camouflage scale 5} }
} 
union {
cylinder { <0,0,0.01>,<0,0,0.25>,0.008 texture { camouflage scale 5} }
sphere { <0,0,0.01>,0.008 texture { camouflage scale 5} }
sphere { <0,0,0.25>,0.008 texture { camouflage scale 5} }
}
box { <-0.1,0,-0.1>,<0.1,-0.1,0.3> texture { camouflage scale 5} }
box { <-0.1,-0.1,-0.1>,<0,0.1,0.3> texture { camouflage scale 5} }
}                                  
}
difference {
box { <0,0,0>,<1.1,0.02,1.2>  texture { camouflage scale 5} }
union {
box { <0.01,0.01,0.01>,<0.99,0.021,0.29>  texture { camouflage scale 5} }
box { <0.01,0.01,0.01>,<0.99,0.021,0.29> translate z*0.3 texture { camouflage scale 5} }
box { <0.01,0.01,0.01>,<0.99,0.021,0.29> translate z*0.6 texture { camouflage scale 5} }
box { <0.01,0.01,0.01>,<0.99,0.021,0.29> translate z*0.9 texture { camouflage scale 5} }
box { <1.01,0.01,0.01>,<1.09,0.021,1.19>  texture { camouflage scale 5} }
}
}
#declare e_g= 
union {
object { event translate <0.02,0.01,0.02> }
object { event translate <0.04,0.01,0.02> }
object { event translate <0.06,0.01,0.02> }
object { event translate <0.08,0.01,0.02> }
object { event translate <0.10,0.01,0.02> }
object { event translate <0.12,0.01,0.02> }
object { event translate <0.14,0.01,0.02> }
object { event translate <0.16,0.01,0.02> }
}
#declare g_e=
union {
object { e_g  }
object { e_g translate x*0.16 }
object { e_g translate x*0.32 }
object { e_g translate x*0.48 }
object { e_g translate x*0.64 }
object { e_g translate x*0.80 }
}
object { g_e }
object { g_e translate z*0.3}
object { g_e translate z*0.6}
object { g_e translate z*0.9}   
#declare poigne=
union {
difference {
union {
torus { 0.065,0.01 rotate z*90 texture { camouflage scale 5} }
torus { 0.065,0.01 rotate z*90 translate z*0.1 texture { camouflage scale 5} }
}
box { <-0.1,0,0>,<0.1,0.2,0.1>texture { camouflage scale 5} }
box { <-0.1,0,-0.1>,<0.1,-0.2,0.2> texture { camouflage scale 5} }
}
cylinder { <0,0.065,0>,<0,0.065,0.1>,0.01 texture { camouflage scale 5} }
}  
object { poigne translate <1.05,0.01,0.13> }
object { poigne translate <1.05,0.01,1.00> }
cylinder { <-0.005,0.01,0.27>,<-0.005,0.01,0.33>,0.01 texture { camouflage scale 5} }
cylinder { <-0.005,0.01,0.87>,<-0.005,0.01,0.93>,0.01texture { camouflage scale 5} }
box { <-0.045,0,0.27>,<0,0.01,0.33> texture { camouflage scale 5} }
box { <-0.045,0,0.87>,<0,0.01,0.93> texture { camouflage scale 5} }
}
object { trape }
object { trape rotate y*180 translate <2.205,0,1.2> }
box { <-0.08,0,-0.02>,<2.285,-0.01,1.22>texture { camouflage scale 5} }
translate <0,0.01,0.02>
 scale 0.8
}
//---porte_objet---//
#declare t_c=
difference {
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.08,        
   5,        
  < 0, 0>, < 1.1, 0>, < 1.1, 0.1>, < 0.2, 0.1>, < 0, 0> 
 texture { camouflage scale 5}  
}
box { <-0.01,0.02,0.02>,<1.2,0.06,0.2> texture { camouflage scale 5} }
rotate <-90,-90,0> 
}
    

#declare t_l=

difference {
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.08,        
   5,        
  < 0, 0>, < 1.2, 0>, < 1.2, 0.1>, < 0.2, 0.1>, < 0, 0> 
  texture { camouflage scale 5} 
}    
box { <-0.01,0.02,0.02>,<1.3,0.06,0.2> texture { camouflage scale 5} } 
rotate <-90,-90,0> 
}

#declare bosse=
union {
difference {
merge {
torus { 0.04,0.01 texture { camouflage scale 5} }
cylinder { <0,0,0>,<0,0.01,0>,0.04  texture { camouflage scale 5} } 
}
box { <-0.1,0,-0.1>,<0.1,-0.1,0.1>  texture { camouflage scale 5} }
}
cylinder { <0,0,0>,<0,-0.01,0>,0.05 texture { camouflage scale 5} }
translate y*-0.03 
}
#declare porte_objetg= 
union {
object { t_c }
object { t_c translate x*0.585 }
object { t_c translate x*1.755 }
object { t_c translate x*2.46 }
object { t_l translate x*0.885 }
object { t_l translate x*1.455 }
box { <0,0,0>,<2.5,-0.02,0.08> texture { camouflage scale 5} }
box { <0,0,1.02>,<2.5,-0.02,1.1> texture { camouflage scale 5} }
object { boulon translate <0.15,0,0.04> }
object { boulon translate <2.35,0,0.04> }
object { boulon translate <0.15,0,1.06> }
object { boulon translate <2.35,0,1.06> }
object { boulon translate <1.355,0,0.04> }
object { boulon translate <1.355,0,1.06> }
object { bosse translate <0.15,0,0.04> }
object { bosse translate <2.35,0,0.04> }
object { bosse translate <0.15,0,1.06> }
object { bosse translate <2.35,0,1.06> }
object { bosse translate <1.355,0,0.04> }
object { bosse translate <1.355,0,1.06> }
rotate x*-51
}                  
#declare porte_objetd= 
union {
object { t_c }
object { t_c translate x*0.585 }
object { t_c translate x*1.755 }
object { t_c translate x*2.46 }
object { t_l translate x*0.885 }
object { t_l translate x*1.455 }
box { <0,0,0>,<2.5,-0.02,0.08> texture { camouflage scale 5} }
box { <0,0,1.02>,<2.5,-0.02,1.1> texture { camouflage scale 5} }
object { boulon translate <0.15,0,0.04> }
object { boulon translate <2.35,0,0.04> }
object { boulon translate <0.15,0,1.06> }
object { boulon translate <2.35,0,1.06> }
object { boulon translate <1.355,0,0.04> }
object { boulon translate <1.355,0,1.06> }
object { bosse translate <0.15,0,0.04> }
object { bosse translate <2.35,0,0.04> }
object { bosse translate <0.15,0,1.06> }
object { bosse translate <2.35,0,1.06> }
object { bosse translate <1.355,0,0.04> }
object { bosse translate <1.355,0,1.06> }
rotate x*-51
}
//---antenne---//
#declare antenne=
union {
cylinder { <0,0,0>,<0,0.1,0>,0.075 translate <0.25,0.5,2.5> texture { camouflage scale 5} }
cone{ <0.25,0.6,2.5>,0.075,<0.25,0.63,2.5>,0.04 texture { camouflage scale 5} }
cone{ <0.25,0.63,2.5>,0.04,<0.25,0.68,2.5>,0.03 texture { camouflage scale 5} }
cone{ <0.25,0.68,2.5>,0.01,<0.25,1,2.5>,0.009 texture { camouflage scale 5} }
cone{ <0.25,1.01,2.5>,0.01,<0.2,0,-0.5>,0 texture { camouflage scale 5} }
}
//---porte_bagage---//
#declare porte_bagage=
union {
box { <0,0,0>,<0.04,0.08,0.01>  texture { camouflage scale 5} }
box { <0,0,0>,<0.04,0.08,0.01>  translate z*0.79 texture { camouflage scale 5} }
box { <0,0,0>,<0.04,0.08,0.01>  translate <0.41,0,0> texture { camouflage scale 5} }
box { <0,0,0>,<0.04,0.08,0.01>  translate <0.41,0,0.79> texture { camouflage scale 5} }
box { <0,0.07,0>,<0.04,0.08,0.8>  translate x*0.41 texture { camouflage scale 5} }
box { <0.59,0,0.1>,<0.6,0.08,0.14>  texture { camouflage scale 5} }
box { <0.59,0,0.1>,<0.6,0.08,0.14>  translate z*0.56 texture { camouflage scale 5} }
box { <0,0.07,0>,<0.04,0.08,0.16>  texture { camouflage scale 5} }
box { <0,0.07,0.64>,<0.04,0.08,0.8>  texture { camouflage scale 5} }
box { <0,0.07,0.1>,<0.6,0.08,0.14>  texture { camouflage scale 5} }
box { <0,0.07,0.1>,<0.6,0.08,0.14>  translate z*0.56 texture { camouflage scale 5} }
box { <0,0.08,0.12>,<0.04,0.09,0.68>  translate x*0.13 texture { camouflage scale 5} }
box { <0,0.08,0.12>,<0.04,0.09,0.68>  translate x*0.23 texture { camouflage scale 5} }
box { <0,0.08,0.12>,<0.04,0.09,0.68>  translate x*0.33 texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.35,0,0.12> texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.35,0,0.67>texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.25,0,0.12> texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.25,0,0.67> texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.15,0,0.12> texture { camouflage scale 5} }
cylinder { <0,0.08,0>,<0,0.09,0>,0.02 translate <0.15,0,0.67> texture { camouflage scale 5} }
box { <0,0.07,0.14>,<0.04,0.08,0.3573>   rotate x*-14 translate <0,-0.0335,0.03>texture { camouflage scale 5} }
box { <0,0.07,0.14>,<0.04,0.08,0.3573>   rotate x*14 translate <0,0.085,0.295>texture { camouflage scale 5} }
box { <0,0.12,0.35>,<0.04,0.13,0.45>   texture { camouflage scale 5} }
rotate z*-51
}
//---ecoutilles---//
#declare ecoutille=
union {
difference {
union {       
torus { 0.1,0.05 translate <0.15,0,0.35> texture { camouflage scale 5} }        
sphere { <0,0,0>,0.05  translate <0.75,0,0.45> texture { camouflage scale 5} }
sphere { <0,0,0>,0.05  translate <0.75,0,0.05> texture { camouflage scale 5} }
sphere { <0,0,0>,0.05  translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0.6,0,0>,0.05 translate <0.15,0,0.45> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0.7,0,0>,0.05 translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0,0,0.4>,0.05 translate <0.75,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0,0,0.3>,0.05 translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0,0.05,0>,0.1 translate <0.15,0,0.35> texture { camouflage scale 5} }
box { <0,0,0>,<0.7,0.05,0.3> translate <0.05,0,0.05> texture { camouflage scale 5} }
box { <0,0,0>,<0.6,0.05,0.15> translate <0.15,0,0.3> texture { camouflage scale 5} }
}
box { <-1,0,-1>,<1,-0.06,1>  texture { camouflage scale 5} }
}
#declare poign=
union {
cylinder { <0,-0.05,0>, <0,0.052,0>,0.01 translate <0.1,0.05,0.1> texture { camouflage scale 5} }
cylinder { <0,-0.05,0>, <0,0.052,0>,0.01 translate <0.1,0.05,0.2> texture { camouflage scale 5} }

#declare tt1=
difference {
torus { 0.0125,0.01 translate <0,0,0> texture { camouflage scale 5} }
union {
box { <-0.1,0.1,0>,<0.1,-0.1,-0.1>  texture { camouflage scale 5} }
box { <-0.1,0.1,-0.1>,<0,-0.1,0.1>  texture { camouflage scale 5} }
}
rotate <180,0,90>

}  


#declare tt2=
difference {
torus { 0.0125,0.01 translate <0,0,0> texture { camouflage scale 5} }
union {
box { <-0.1,0.1,0>,<0.1,-0.1,-0.1>  texture { camouflage scale 5} }
box { <-0.1,0.1,-0.1>,<0,-0.1,0.1>  texture { camouflage scale 5} }
}
 rotate <0,0,90>
}  

object { tt1 translate <0.1,0.1,0.1125> }
object { tt2 translate <0.1,0.1,0.1875> }
cylinder { <0,0,0>, <0,0,0.08>,0.01 translate <0.1,0.1125,0.1125> texture { camouflage scale 5} }
}
object { poign rotate y*30 translate <-0.05,-0.02,0.05>}
object { poign  translate <0.225,0,0.05>}
object { poign  translate <0.355,0,0.05>}
cylinder { <0,0,0>,<0.14,0,0>,0.01 translate <0.32,0.11,0.2> texture { camouflage scale 5} } 
}
//------------------------------//
#declare ecoutille2=
union {
difference {
union {       
torus { 0.1,0.05 translate <0.65,0,0.35> texture { camouflage scale 5} }        
sphere { <0,0,0>,0.05  translate <0.05,0,0.45> texture { camouflage scale 5} }
sphere { <0,0,0>,0.05  translate <0.75,0,0.05> texture { camouflage scale 5} }
sphere { <0,0,0>,0.05  translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0.6,0,0>,0.05 translate <0.05,0,0.45> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0.7,0,0>,0.05 translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0,0,0.4>,0.05 translate <0.05,0,0.05> texture { camouflage scale 5} }
cylinder { <0,0,0>, <0,0,0.3>,0.05 translate <0.75,0,0.05> texture { camouflage scale 5} } 
cylinder { <0,0,0>, <0,0.05,0>,0.1 translate <0.65,0,0.35> texture { camouflage scale 5} }
box { <0,0,0>,<0.7,0.05,0.3> translate <0.05,0,0.05> texture { camouflage scale 5} } 
box { <0,0,0>,<0.6,0.05,0.15> translate <0.05,0,0.3> texture { camouflage scale 5} }
}
box { <-1,0,-1>,<1,-0.06,1>  texture { camouflage scale 5} }
}
#declare poign=
union {
cylinder { <0,-0.05,0>, <0,0.052,0>,0.01 translate <0.1,0.05,0.1> texture { camouflage scale 5} }
cylinder { <0,-0.05,0>, <0,0.052,0>,0.01 translate <0.1,0.05,0.2> texture { camouflage scale 5} }

#declare tt1=

difference {
torus { 0.0125,0.01 translate <0,0,0> texture { camouflage scale 5} }
union {
box { <-0.1,0.1,0>,<0.1,-0.1,-0.1>  texture { camouflage scale 5} }
box { <-0.1,0.1,-0.1>,<0,-0.1,0.1>  texture { camouflage scale 5} }
}
rotate <180,0,90>
}  


#declare tt2=
difference {
torus { 0.0125,0.01 translate <0,0,0> texture { camouflage scale 5} }
union {
box { <-0.1,0.1,0>,<0.1,-0.1,-0.1> texture { camouflage scale 5} }
box { <-0.1,0.1,-0.1>,<0,-0.1,0.1>  texture { camouflage scale 5} }
}
rotate <0,0,90>
}  
object { tt1 translate <0.1,0.1,0.1125> }
object { tt2 translate <0.1,0.1,0.1875> }
cylinder { <0,0,0>, <0,0,0.08>,0.01 translate <0.1,0.1125,0.1125> texture { camouflage scale 5} }
}
object { poign rotate y*-30 translate <0.7,-0.02,-0.05>}
object { poign  translate <0.225,0,0.05>}
object { poign  translate <0.355,0,0.05>}
cylinder { <0,0,0>,<0.14,0,0>,0.01 translate <0.32,0.11,0.2> texture { camouflage scale 5} }
}
//---porte_canon---//
#declare porte_canon=
union {
union {
merge {
cylinder { <0,0,0>,<0,0.03,0>,0.05  translate z*0.05 texture { camouflage scale 5} }
box { <-0.05,0,-0.05>,<0.05,0.03,0.05>  texture { camouflage scale 5} }
}
merge {
cylinder { <0,0,0>,<0,0.03,0>,0.05  translate z*0.05 texture { camouflage scale 5} }
box { <-0.05,0,-0.05>,<0.05,0.03,0.05>  texture { camouflage scale 5} }
translate y*0.08
}
}
union {
merge {
cylinder { <0,0,0>,<0,0.03,0>,0.05  translate z*0.05 texture { camouflage scale 5} }
box { <-0.05,0,-0.05>,<0.05,0.03,0.05>  texture { camouflage scale 5} }
}
merge {
cylinder { <0,0,0>,<0,0.03,0>,0.05  translate z*0.05 texture { camouflage scale 5} }
box { <-0.05,0,-0.05>,<0.05,0.03,0.05>  texture { camouflage scale 5} }
translate y*0.08
}
translate y*0.69
}
rotate <0,-34,-90>
}
//---phare avant---//
#declare phare_avant=
union {
#declare entourage_phare=
union {
union {
union {
difference {
cylinder { <0,0,0>,<0,0.01,0>,0.1   texture { camouflage scale 5} }
cylinder { <0,-0.01,0>,<0,0.02,0>,0.08   texture { camouflage scale 5} }
union {  
box { <-0.15,-0.01,0>,<0.15,0.02,-0.15>   texture { camouflage scale 5} }
box { <0,-0.01,-0.15>,<0.15,0.02,0.15>   rotate y*-60 texture { camouflage scale 5} }
}    
}
box { <-0.1,0,-0.15>,<-0.08,0.01,0>  texture { camouflage scale 5} }
}

union {
difference {
cylinder { <0,0,0>,<0,0.01,0>,0.1   texture { camouflage scale 5} }
cylinder { <0,-0.01,0>,<0,0.02,0>,0.08   texture { camouflage scale 5} }
union {  
box { <-0.15,-0.01,0>,<0.15,0.02,-0.15>   texture { camouflage scale 5} }
box { <0,-0.01,-0.15>,<0.15,0.02,0.15>   rotate y*-60 texture { camouflage scale 5} }
}   
}  
box { <-0.1,0,-0.15>,<-0.08,0.01,0>  texture { camouflage scale 5} }
translate y*0.19   
}

#declare qc=     
difference {  
cylinder { <0,0,0>,<0.02,0,0>,0.1   texture { camouflage scale 5} }
cylinder { <-0.01,0,0>,<0.03,0,0>,0.09   texture { camouflage scale 5} }
box { <-0.1,0.15,-0.15>,<0.1,-0.15,0>  texture { camouflage scale 5} } 
rotate y*30 
}    
object { qc translate <-0.0865,0.1,0.0499>}
translate z*0.15
rotate y*-35 
}
rotate <-90,-90,0>
}       

object { entourage_phare translate  <-0.01,0.06,0.08>}
box { <0,0,0>,<-0.01,0.02,-0.4>  rotate x*20 translate <-0.005,0.05,0.27> texture { camouflage scale 5} }
box { <0,0,0>,<-0.01,0.02,-0.4>  rotate x*20 translate <0.195,0.05,0.27> texture { camouflage scale 5} }

union { 
difference {
sphere { <0,0,0>,0.075 texture { camouflage scale 5} }
box { <-0.1,-0.1,0>,<0.1,0.1,-0.1> texture { camouflage scale 5} }
}
difference {
cone { <0,0,0>, 0.076 <0,0,-0.04>,0.072 texture { camouflage scale 5} }
cylinder { <0,0,0>,<0,0,-0.05>,0.06 texture { camouflage scale 5} }                      
}                                 
cylinder { <0,0,-0.01>,<0,0,-0.033>,0.06 texture  { Yellow_Glass } }                                   
cylinder { <0,0,0>,<0,0,-0.01>,0.06 pigment  {color White } }                                  
cylinder { <0,0.07,0>,<0,0.11,0>,0.01 texture { camouflage scale 5} }                              
sphere { <0,0.12,0>,0.018 texture { camouflage scale 5} }                        
cylinder { <0,-0.07,0>,<0,-0.18,0>,0.025 texture { camouflage scale 5} }
translate <0.09,0.14,0.02>                                    
}                                 
}                                 
//---boulon de caisse---//
#declare bouloncaissed=
union {
object { boulon }                              
cylinder { <0,0.001,0>,<0,-0.005,0>,0.05  texture { Rust } }                                
cylinder { <0,0.001,0>,<0,0.03,0>,0.015  texture { Rust } } 
rotate z*-51                                
}                                 
#declare bouloncaisseg=
union {
object { boulon }                              
cylinder { <0,0.001,0>,<0,-0.005,0>,0.05  texture { Rust } }                              
cylinder { <0,0.001,0>,<0,0.03,0>,0.015  texture { Rust } } 
rotate z*51                                
}   
#declare bouloncaissef=
union {
object { boulon }                              
cylinder { <0,0.001,0>,<0,-0.005,0>,0.05  texture { Rust } }                               
cylinder { <0,0.001,0>,<0,0.03,0>,0.015  texture { Rust } } 
rotate x*-34                                
}   
//---roue avant---//
#declare roue_avant=
union {
#declare galet=
union {
difference {
cylinder { <0,0,0>,<0.50,0,0>,0.29 texture { camouflage scale 5} }
cylinder { <-0.01,0,0>,<0.51,0,0>,0.25 texture { camouflage scale 5} }
}    
cylinder { <0.03,0,0>,<0.47,0,0>,0.29 texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,0.18528,0> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,-0.18528,0> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,0,0.18528> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,0,-0.18528> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,0.12989,0.12989> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,-0.12989,-0.12989> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,0.12989,-0.12989> texture { camouflage scale 5} }
cylinder { <0.47,0,0>,<0.5,0,0>,0.02 translate <0,-0.12989,0.12989> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,0.18528,0> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,-0.18528,0> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,0,0.18528> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,0,-0.18528> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,0.12989,0.12989> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,-0.12989,-0.12989> texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,0.12989,-0.12989> texture { camouflage scale 5} }  
cylinder { <0,0,0>,<0.03,0,0>,0.02 translate <0,-0.12989,0.12989> texture { camouflage scale 5} }                              
}
#declare couronne=
union {
difference {
cylinder {<0,0,0>,<0.03,0,0>,0.45  texture { camouflage scale 5} } 
cylinder {<-0.01,0,0>,<0.031,0,0>,0.25  texture { camouflage scale 5} }   
#declare tr1=
union {
prism {
       linear_spline
       linear_sweep
       0.01,
       -0.031,
       5,
       <-0.1,0>,<0.1,0>,<0.02996,0.3156>,<-0.02996,0.3156>,<-0.1,0>
       texture { camouflage scale 5} 
       rotate z*90 
       }

cylinder {<-0.01,0,0>,<0.031,0,0>,0.03 translate z*0.3156 texture { camouflage scale 5} }
}
union {
object { tr1 rotate x*15 }
object { tr1 rotate x*45 }
object { tr1 rotate x*75 }
object { tr1 rotate x*105}
object { tr1 rotate x*135}
object { tr1 rotate x*165}
object { tr1 rotate x*195}
object { tr1 rotate x*225}
object { tr1 rotate x*255}
object { tr1 rotate x*285}
object { tr1 rotate x*315}
object { tr1 rotate x*345}
}
#declare tr3=
union {
cylinder { <-0.01,0,0>,<0.031,0,0>,0.10 translate y*0.48049 texture { camouflage scale 5} }
cylinder { <-0.01,0,0>,<0.031,0,0>,0.04 translate y*0.40506 texture { camouflage scale 5} }
}
object { tr3 rotate x*30 }
object { tr3 rotate x*60 }
object { tr3 rotate x*90 }
object { tr3 rotate x*120}
object { tr3 rotate x*150}
object { tr3 rotate x*180}
object { tr3 rotate x*210}
object { tr3 rotate x*240}
object { tr3 rotate x*270}
object { tr3 rotate x*300}
object { tr3 rotate x*330}
object { tr3 rotate x*360}
}
#declare tr2=
cylinder { <0,0,0>,<0.03,0,0>,0.01952  translate y*0.25049 texture { camouflage scale 5} }
object { tr2 rotate x*30 }
object { tr2 rotate x*60 }
object { tr2 rotate x*90 }
object { tr2 rotate x*120}
object { tr2 rotate x*150}
object { tr2 rotate x*180}
object { tr2 rotate x*210}
object { tr2 rotate x*240}
object { tr2 rotate x*270}
object { tr2 rotate x*300}
object { tr2 rotate x*330}
object { tr2 rotate x*360}
#declare tr4=
cylinder { <0,0,0>,<0.03,0,0>,0.02512  translate y*0.45051 texture { camouflage scale 5} }
object { tr4 rotate x*15 }
object { tr4 rotate x*45 }
object { tr4 rotate x*75 }
object { tr4 rotate x*105}
object { tr4 rotate x*135}
object { tr4 rotate x*165}
object { tr4 rotate x*195}
object { tr4 rotate x*225}
object { tr4 rotate x*255}
object { tr4 rotate x*285}
object { tr4 rotate x*315}
object { tr4 rotate x*345}
}
object { galet }
object { couronne translate x*0.5 }
object { couronne translate x*-0.03}
#declare tr5=
union {
sphere { <0,0,0>,0.015 translate <0.530,0.27,0> texture { camouflage scale 5} }
sphere { <0,0,0>,0.015 translate <-0.03,0.27,0> texture { camouflage scale 5} }
}
object { tr5 rotate x*30 }
object { tr5 rotate x*60 }
object { tr5 rotate x*90 }
object { tr5 rotate x*120}
object { tr5 rotate x*150}
object { tr5 rotate x*180}
object { tr5 rotate x*210}
object { tr5 rotate x*240}
object { tr5 rotate x*270}
object { tr5 rotate x*300}
object { tr5 rotate x*330}
object { tr5 rotate x*360}
}
//---roue---//
#declare roue=
union {
difference {
merge { cylinder { <0,0,0>,<0.4,0,0>,0.35 texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.35,0,0>,0.325 texture { camouflage scale 5} }
}
cylinder { <0,0,0>,<0.41,0,0>,0.3 texture { camouflage scale 5} }
}
cylinder { <0,0,0>,<0.3,0,0>,0.3 texture { camouflage scale 5} }
cylinder { <0,0,0>,<0.35,0,0>,0.1 texture { camouflage scale 5} }
#declare re1=
union {
sphere { <0.3,0,-0.3>,0.025 texture { camouflage scale 5} }
cylinder { <0.3,0,0>,<0.3,0,-0.3>,0.02 texture { camouflage scale 5} }
}
object { re1}
object { re1 rotate x*60}
object { re1 rotate x*120}
object { re1 rotate x*180}
object { re1 rotate x*240}
object { re1 rotate x*300}
}
//---boggie---//
#declare boggie_g=
union {         
#declare bog1=
union {
difference {
union { 
cylinder  { <0,0,0>,<0,0,0.07>,0.05 texture { camouflage scale 5} }
box { <0,-0.05,0>,<0.4,0.05,0.07> texture { camouflage scale 5} }
}
union {
cylinder  { <0,0,-0.01>,<0,0,0.02>,0.03 texture { camouflage scale 5} }
box { <0,-0.03,-0.01>,<0.4,0.03,0.02> texture { camouflage scale 5} }
}
translate <-0.03,0.07,0>
}  
difference {
cylinder  { <-0.05,0,-0.01>,<-0.05,0,0.02>,0.1 texture { camouflage scale 5} }
union {                                                                                                             
box { <-0.05,-0.11,-0.1>,<0.4,0.11,0.1> texture { camouflage scale 5} }                                                                                                                                                                                                                
box { <-0.15,0,-0.1>,<0.15,-0.11,0.1> texture { camouflage scale 5} }                                                                                                          
}                                                                                                             
}                                                                                                             
}  
#declare bog2=
union {
difference {
union { 
cylinder  { <0.4,0,0>,<0.4,0,0.07>,0.05 texture { camouflage scale 5} }
box { <0,-0.05,0>,<0.4,0.05,0.07> texture { camouflage scale 5} }
}
union {
cylinder  { <0.4,0,-0.01>,<0.4,0,0.02>,0.03 texture { camouflage scale 5} }
box { <0,-0.03,-0.01>,<0.4,0.03,0.02> texture { camouflage scale 5} }
}
translate <-0.03,0.07,0>
}  
difference {
cylinder  { <-0.05,0,-0.01>,<-0.05,0,0.02>,0.1 texture { camouflage scale 5} }
union {                                                                                                             
box { <-0.05,-0.11,-0.1>,<0.4,0.11,0.1> texture { camouflage scale 5} }                                                                                                                                                                                                                  
box { <-0.15,0,-0.1>,<0.15,-0.11,0.1> texture { camouflage scale 5} }                                                                                                           
}
rotate y*180
translate <0.35,-0.01,0.02>                                                                                                             
}                                                                                                             
}
union {
object { bog1 translate <0.3,0.08,0> }           
union {
box { <0,0,0>,<0.7,0.02,0.1> texture { camouflage scale 5} }
box { <0,0.13,0>,<0.7,0.15,0.1> texture { camouflage scale 5} }
box { <0,0.02,0.04>,<0.7,0.13,0.06> texture { camouflage scale 5} }
box { <0.08,0.15,0>,<0.25,0.17,0.1> texture { camouflage scale 5} }
cylinder { <0,0.075,-0.02>,<0,0.075,0.11>,0.085 texture { camouflage scale 5} }
cylinder { <0,0.075,-0.01>,<0,0.075,-0.04>,0.065 texture { camouflage scale 5} }
translate y*-0.08
}
union{
object { boulon }                              
cylinder { <0,0.001,0>,<0,-0.005,0>,0.05  texture { Rust } }                                
cylinder { <0,0.001,0>,<0,0.03,0>,0.015  texture { Rust } }
rotate x*-90
translate <0,0,-0.04>                                 
}
rotate z*15
}
object {roue translate <-0.5,0,-0> rotate y*90}  
//---------------------
union {
union {
union {
union {
box { <0,0,0>,<0.7,0.02,0.1> texture { camouflage scale 5} }
box { <0,0.13,0>,<0.7,0.15,0.1> texture { camouflage scale 5} }
box { <0,0.02,0.04>,<0.7,0.13,0.06> texture { camouflage scale 5} }
box { <0.45,0.15,0>,<0.62,0.17,0.1> texture { camouflage scale 5} }
translate <0.7,-0.08,0>
}
object { bog2 translate <0.75,0.08,0> }
}
cylinder { <0,0.075,-0.02>,<0,0.075,0.11>,0.085 translate <1.4,-0.08,0> texture { camouflage scale 5} }
cylinder { <0,0.075,-0.01>,<0,0.075,-0.04>,0.065 translate <1.4,-0.08,0> texture { camouflage scale 5} }
union{
object { boulon }                               
cylinder { <0,0.001,0>,<0,-0.005,0>,0.05  texture { Rust } }                                
cylinder { <0,0.001,0>,<0,0.03,0>,0.015  texture { Rust } }
rotate x*-90
translate <1.4,0,-0.04>                                 
}
translate x*-1.4    
rotate z*-15
}
object {roue translate <-0.5,0,-0> rotate y*90} 
translate x*1.4
}   
//---------------------------- 
#declare bog3=
union {   
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.3,        
   7,        
   < 0,-0.35>, < 0.3,-0.35>, < 0.6,-0.2>, < 0.6,0.2>, < 0.3,0.35>, < 0,0.35>, < 0,-0.35>
texture { camouflage scale 5} }              
union {      
difference {
prism {
  linear_sweep 
  linear_spline 
   0,       
   0.10,        
   9,        
   < 0,-0.2>, < 0.3,-0.2>, < 0.7,-0.12>, <0.78,-0.12>, <0.78,0.12>,  < 0.7,0.12>, < 0.3,0.2>, < 0,0.2>, < 0,-0.2>
texture { camouflage scale 5} }                                                                                                         
prism {
  linear_sweep 
  linear_spline 
   0.07,       
   0.11,        
   7,        
   < -0.1,-0.18>, < 0.3,-0.18>, < 0.6,-0.12>, < 0.6,0.12>, < 0.3,0.18>, < 0,0.18>, < -0.1,-0.18>
texture { camouflage scale 5} }
box { <0.70,0.09,-0.5>,<0.715,0.11,0.5>   texture { camouflage scale 5} }
cylinder { <0.7075,0.07,-0.06>,<0.7075,0.11,-0.06>,0.025 texture { camouflage scale 5} }                                                                                                         
cylinder { <0.7075,0.07,0.06>,<0.7075,0.11,0.06>,0.025 texture { camouflage scale 5} }               
}                                                                                                              
box { <0,0.06,-0.01>,<0.65,0.10,0.01>   translate z*-0.055 texture { camouflage scale 5} }                                                                                                           
box { <0,0.06,-0.01>,<0.65,0.10,0.01>   translate z*0.055 texture { camouflage scale 5} }                                                                                                              
cylinder { <0.7075,0.07,-0.06>,<0.7075,0.1,-0.06>,0.015 texture { camouflage scale 5} }                                                                                                           
cylinder { <0.7075,0.07,0.06>,<0.7075,0.1,0.06>,0.015 texture { camouflage scale 5} }                                                                                                                
rotate z*-90
translate <0.6,0.3,0>
}
rotate y*90                                                                                                   
}
object { bog3 translate <0.7,0.58,0.6>  }
rotate y*90
scale 0.95                                                                                                             
}
#declare boggie_d=                                                                                                            
object {  boggie_g rotate y*180 scale 0.95}                                                                                                             
//--- barre avant ---//                                                                                                              
#declare barre_avant=
union { 
difference { 
box { <0,0,0>,<2.7,0.04,0.1> texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.075 texture { camouflage scale 5} }  
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.225 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.375 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.525 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.675 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.825 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*0.975 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.125 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.275 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.425 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.575 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.725 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*1.875 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*2.025 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*2.175 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*2.325 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*2.475 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.05,0.05>,0.025 translate x*2.625 texture { camouflage scale 5} }
}
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.075 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.225 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.375 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.525 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.675 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.825 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*0.975 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.125 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.275 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.425 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.575 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.725 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*1.875 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*2.025 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*2.175 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*2.325 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*2.475 texture { camouflage scale 5} }
cylinder { <0,0.02,0.05>,<0,0.04,0.05>,0.015 translate x*2.625 texture { camouflage scale 5} }
rotate x*-34 
}  
//--- tourelle ---//                                                                                                             
                  
#declare tourel= 
union {
difference {
box { <-1.35,0,0>,<1.35,1.1,3.4> texture { camouflage scale 5} }
union {
box { <-1.8,-1,0>,<1.8,1.5,1>    rotate <-38.6598,16.5044,0>  translate <0,0.6,3.4> texture { camouflage scale 5} }
box { <-1.8,-1,0>,<1.8,1.5,1>    rotate <-38.6598,-16.5044,0> translate <0,0.6,3.4> texture { camouflage scale 5} }
box { <-1.8,-2,0>,<1.8,1.5,1>    rotate <53.1301,16.5044,0>  translate <0,0.6,3.4> texture { camouflage scale 5} }
box { <-1.8,-2,0>,<1.8,1.5,1>    rotate <53.1301,-16.5044,0> translate <0,0.6,3.4> texture { camouflage scale 5} }
box { <-1.8,-1,3>,<0,1.5,-3>     rotate <0,-10.3048,-21.8014> translate <-1.35,0,2.2> texture { camouflage scale 5} }
box { < 1.8,-1,3>,<0,1.5,-3>     rotate <0,10.3048,21.8014>   translate <1.35,0,2.2>  texture { camouflage scale 5} }
box { <-0.65,-1,1>,<0.65,0.5,-2> texture { camouflage scale 5} }
box { <-2,0,0>,<2,1,-1>          rotate <54.4623,0,0> translate <0,0.6,0> texture { camouflage scale 5} }
box { <-2,-1.0,1>,<0,1,-2>       rotate <0,-31.8014,26.5651> translate <-1.35,0.45,1> texture { camouflage scale 5} }
box { < 0,-1.0,1>,<2,1,-2>       rotate <0,31.8014,-26.5651> translate <1.35,0.45,1>  texture { camouflage scale 5} }
box { <-2,-0.1,5>,<2,0.1,0>      texture { camouflage scale 5} }
}
}
cylinder { <-0.65,0.6,0>,<0.65,0.6,0>,0.4  texture { camouflage scale 5} }
difference {
cylinder { <-0.65,-2.7198,0.877>,<0.65,-2.7198,0.877>,3.8217  texture { camouflage scale 5} }
box { <-0.66,-10,-5>,<0.66,2,0>      texture { camouflage scale 5} }
box { <-0.66,-10,0.877>,<0.66,2,5>   texture { camouflage scale 5} }
box { <-0.66,-10,-0.1>,<0.66,0.6,5>  texture { camouflage scale 5} }
}
difference {
cylinder { <-0.65,3.9198,0.877>,<0.65,3.9198,0.877>,3.8217  texture { camouflage scale 5} }
box { <-0.66,10,-5>,<0.66,-2,0>      texture { camouflage scale 5} }
box { <-0.66,10,0.877>,<0.66,-2,5>   texture { camouflage scale 5} }
box { <-0.66,10,-0.1>,<0.66,0.6,5>  texture { camouflage scale 5} }
}                                    
#declare trl1=
union {
cylinder { <0,-0.1,-0.3>,<0,0.1,0.3>,0.015    texture { camouflage scale 5} }            
cylinder { <0,-0.1,-0.3>,<0,0.1,0.3>,0.015    texture { camouflage scale 5} }                              
box      { <-0.015,-0.1,-0.3>,<0.015,0.1,0.3> texture { camouflage scale 5} }                                    
}                                     
object { trl1 rotate x*-4        translate <  0.0,1.02,0.6>   }                                     
object { trl1 rotate <-4,15,0>   translate <  0.5,1.02,0.6>   }                                         
object { trl1 rotate <-4,-15,0>  translate < -0.5,1.02,0.6>   }
translate z*-1.75    
}                                                        
//---canon---//
#declare canon=
union {
difference {
union {        
cylinder { <-0.75,0.6,0>,<0.75,0.6,0>,0.5  texture { camouflage scale 5} }
prism {  
        linear_spline
        linear_sweep
        -0.75,
        0.75,
        5,
        <-0.3536,-0.3536>,<0.3536,-0.3536>,<0.03,-0.6>,<-0.03,-0.6>,<-0.3536,-0.3536>
        texture { camouflage scale 5} 
        rotate z*90
        translate y*0.6 
}
}
union { 
cylinder { <-0.76,0.6,0.15>,<0.76,0.6,0.15>,0.5  texture { camouflage scale 5} }
box { <-0.8,-0.5,-0.15>,<0.8,1.5,1>  texture { camouflage scale 5} }
box { <0,1.5,-1>,<1,-1.5,1>  rotate y*45 translate x*1.18 texture { camouflage scale 5} }
box { <0,1.5,-1>,<-1,-1.5,1>  rotate y*-45 translate x*-1.18 texture { camouflage scale 5} }
} 
}
difference {
        union {
cylinder { <0,0.6,0>,<0,0.6,-0.65>,0.15 texture { camouflage scale 5} }
cone { <0,0.6,-0.5>,0.12 <0,0.6,-3.15>,0.07 texture { camouflage scale 5} }
}
cylinder { <0,0.6,-1>,<0,0.6,-4>,0.05 texture { camouflage scale 5} }
}
rotate x*-10
translate z*-1.65
}

#declare tourelle=
union {
object { tourel    }
object { canon     }
rotate y*45
translate <2.25,1.3,4.3>
}


#declare blinde=
union {                              
object { tourelle }                                    
object { caisse }
object { avant_caisse translate y*-0.18}    
object { barre_avant  translate <0.9,0.3,0.9> }                                                 
object { roue_avant translate <3.7,-0.35,0.65>  } 
object { roue_avant translate <0.3,-0.35,0.65>  }  
object { boggie_d   translate <4, -1, 1.4> }
object { boggie_d   translate <4, -1, 3.5> } 
object { boggie_d   translate <4, -1, 5.6> } 
object { boggie_g   translate <0.5, -1, 2.75> }
object { boggie_g   translate <0.5, -1, 4.85> } 
object { boggie_g   translate <0.5, -1, 6.95> }
object { phare_avant   translate <0.60,0.350,0.80> scale 1.5       }
object { phare_avant   translate <2.30,0.350,0.80> scale 1.5       }
object { anneaux       translate <3.80,-0.255,2.0> rotate x*-34    }
object { anneaux       translate <0.70,-0.255,2.0> rotate x*-34    } 
object { anneaux       translate <3.300,7.24,2.30> rotate x*64.5   } 
object { anneaux       translate <1.200,7.24,2.30> rotate x*64.5   }  
object { porte_objetg  translate <-7.0,0.40,-0.00> rotate  <0,90,0>}
object { porte_objetd  translate <4.500,0.40,-4.5> rotate <0,-90,0>} 
object { grille        translate <1.4,1.3,5.80>       }          
object { antenne                                  }  
object { porte_bagage  translate <3.950,1.00,2.80>}  
object { ecoutille     translate <2.650,1.30,2.45>}  
object { ecoutille2    translate <1.150,1.30,2.45>}                       
object { porte_canon   translate <1.850,0.80,7.70>}
object { bouloncaissed translate <3.794,1.20,2.80>}                                 
object { bouloncaissed translate <3.794,1.20,4.00>}                                   
object { bouloncaissed translate <3.794,1.20,7.20>}                                   
object { bouloncaissed translate <4.397,0.45,2.80>}                                 
object { bouloncaissed translate <4.397,0.45,4.00>}                                   
object { bouloncaissed translate <4.397,0.45,7.00>}                                  
object { bouloncaisseg translate <0.705,1.20,2.80>}                                 
object { bouloncaisseg translate <0.705,1.20,4.00>}                                   
object { bouloncaisseg translate <0.705,1.20,7.20>}                                                                     
object { bouloncaisseg translate <0.104,0.45,2.80>}                                 
object { bouloncaisseg translate <0.104,0.45,4.00>}                                   
object { bouloncaisseg translate <0.104,0.45,7.00>}
object { bouloncaissef translate <1.85,1.20,2.225>} 
object { bouloncaissef translate <2.65,1.20,2.225>} 
object { bouloncaissef translate <0.95,1.20,2.225>} 
object { bouloncaissef translate <3.55,1.20,2.225>}                                                                                              
object { bouloncaissef translate <1.25,0.45,1.1>}                                                   
object { bouloncaissef translate <2.05,0.45,1.1>} 
object { bouloncaissef translate <2.45,0.45,1.1>}  
object { bouloncaissef translate <3.25,0.45,1.1>} 
}                      






                      