camera {
	location <0, 5, -16>
	look_at <0, 6.6, 0>
}

light_source { < 0, 5, -16 > color rgb <0.85, 0.7, 0.7>}
light_source { <5, 20, -15 > color rgb <0.4, 0.4, 0.5> shadowless}

/*
light_source {
    <0, 5, -16> color rgb 0.7
    area_light x, y, 15, 15
    //adaptive 0                                                   
                                                               
    spotlight
    point_at <0, 6.6, 0>
    tightness 0
    radius 30
    falloff 50
}
*/
sky_sphere {
    pigment {
        gradient y
        color_map {
            [0 0.3 color rgb <1, 0.97, 1> color <0.6, 0.5, 1>]
            [0.3 1 color rgb <0.6, 0.5, 1> color rgb <0.6, 0.5, 1>]
        }
    }                                               
}                                                          

#declare Wall = texture {
    pigment {
        image_map {
            tga "map2.tga"
            map_type 0
            interpolate 2
        }
        scale 10
    }
    finish {ambient 0.6}
}
texture {
    pigment {color rgbf <1, 1, 1, 0.65>}
    finish {ambient 0.2}
}
texture {
    pigment {
        granite
        color_map {
            [0 0.5 color rgb <1, 0.9, 0.85> color rgb <0.9, 0.8, 0.7>]
            [0.5 0.6 color rgb <1, 0.93, 0.88> color rgbf 1]
            [0.6 1 color rgbf 1 color rgbf 1]
        }
    }
    normal {
        granite
        normal_map {
            [0 bumps 0.3 scale 0.003]
            [0.6 bumps 0]
        }
    }
    finish {ambient 0.22}
    scale 23
}

#declare House = height_field {   
    tga "wall.tga"    
    water_level 0.3
        
    translate <-0.5, -1, 0>
    rotate -x*90 
    scale x*4/3    
    scale <24, 24, 0.8>      
    translate <0, -3, 3>
        
    texture {Wall}
}         
   
#declare Ground = height_field {
    tga "bricks.tga" 
    texture { 
        pigment {
            image_map {tga "brickMap.tga"}
        }
        finish {phong 0.2 ambient 0.4}
        rotate x*90
    }
    translate <-0.5, -1, -1>   
    scale <25, 0.16, 25>
    translate z*3.5
}

object {House translate z*3}
object {Ground}

#include "shell.inc"
#include "shelltop.inc"
#include "egg.inc"

union {
    object {Shell translate <-7.5, 0, 1.5>}
    object {ShellTop translate <-7.5, 0, 1.5>}
    object {Egg scale 1.3 translate <-8.3, 6.6, 1.3>}

    scale 1.5 
    translate x*4.5
}

union {
    union {
        object {Shell}
        object {ShellTop}
    
        scale 1.2
        rotate y*180
        rotate x*5 
        translate <7, 0, -2>            
    }

    #include "girl2.inc"
    object {Girl2 rotate y*15 scale 1.3 translate <9, 4.8, 1>}       
    
    
}    
       
#include "eye.inc"
object {Eye rotate z*10 scale 3.5 translate <1, 14.5, 6> texture {Wall}}
   
#declare Sign = height_field {
    tga "sign.tga"      
    water_level 0.6  
    smooth
    #include "metals.inc"
    texture {T_Gold_4C}
    
    translate <-0.5, -1, 0>
       
    scale <3.6, 0.3, 5>
    scale 1.4
    rotate -x*90
    translate <0.3, 4, 3>
}
    
object {Sign}          


