#declare ForClip = box {<0, 0, -2>, <1, 1, 2> rotate z*45}
#declare ClipUnion1 = merge {
         object {ForClip scale <0.7, 1, 1> translate -y*0.1}
         object {ForClip scale <0.5, 1, 1> rotate y*10 translate -y*0.2}
         object {ForClip scale <1.4, 1, 1> rotate y*24 translate -y*0.15}
         object {ForClip scale <1.6, 1, 1> rotate y*35 translate -y*0.1}
         object {ForClip scale <0.7, 1, 1> rotate y*45 translate -y*0.15}
         object {ForClip scale <1, 1, 1> rotate y*52 translate -y*0.1}
         object {ForClip scale <0.8, 1, 1> rotate y*66 translate -y*0.15}
         object {ForClip scale <0.5, 1, 1> rotate y*73 translate -y*0.12}
         object {ForClip scale <1.2, 1, 1> rotate y*85 translate -y*0.15}
         object {ForClip scale <1.2, 1, 1> rotate y*95 translate -y*0.11}
         object {ForClip scale <0.7, 1, 1> rotate y*112 translate -y*0.14}
         object {ForClip scale <1.5, 1, 1> rotate y*125 translate -y*0.12}
         object {ForClip scale <1, 1, 1> rotate y*135 translate -y*0.16}
         object {ForClip scale <0.5, 1, 1> rotate y*142 translate -y*0.18}
         object {ForClip scale <1, 1, 1> rotate y*152 translate -y*0.12}
         object {ForClip scale <0.9, 1, 1> rotate y*165 translate -y*0.15}

         inverse
}

#declare ClipUnion2 = object {ClipUnion1 inverse}

#declare Cracks = texture {
         pigment {
                 crackle
                 color_map {
                   [0 0.018 color rgb 0.8 color rgb 0.8]
                   [0.018 1 color rgb 1 color rgb 1]
                 }
                 scale 0.18
         }
         finish {phong 0.2 ambient 0.3}
         normal {
                 crackle
                 scale 0.18
         }
}
texture {
        pigment {
                gradient -y
                color_map {
                          [0 0.3 color rgbf 1 color rgb 1]
                          [0.3 1 color rgb 1 color rgb 1]
                }
        }
        finish {phong 0.2 ambient 0.3}
        normal {bumps 0.04 scale 0.03}
}

#declare EggLow = sphere {
         0, 1
         clipped_by {plane {y, 0}}
         clipped_by {ClipUnion1}

         texture {Cracks}
}

#declare EggHigh = sphere {
         0, 1 scale <1, 1.5, 1>
         clipped_by {plane {-y, 0}}
         clipped_by {ClipUnion2 translate y*0.22}

         texture {Cracks rotate z*180 scale <1, 1.5, 1>}
}

#declare Water = texture {
	pigment {rgbf <0.98, 0.98, 1, 0.98>}
	finish {
		ambient 0.15
		phong 1
		reflection 0.2
		refraction 1
		ior 1.2
	}
}

#declare Drop = blob {
	threshold 0.7

	component 1, 1.6, <0, 0.98, 0>
	component 1, 1.6, <0, -0.98, 0>

	texture {Water}

	scale <1.15, 1, 1.15>
    translate y*0.3
}

#declare YellowCenter = sphere {
         0, 0.5
         scale <1, 0.9, 1>

         pigment {rgb <1, 0.8, 0.2>}
         finish {phong 0.3 ambient 0.3}

         translate -y*0.75
}

#declare EggSupport = union {
         torus {1.2, 0.05 translate y*2.1}
         torus {1.2, 0.05 translate -y*1.6}
         torus {0.5, 0.03 translate y*0.25}
         
         union {
               torus {0.5, 0.03 translate y*2.1}
               torus {0.5, 0.03 translate -y*1.6}
               
               union {
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*90}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*180}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*270}
                     
                     rotate y*45
                     translate y*2.1
               }
               union {
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*90}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*180}
                     cylinder {<-1.2, 0, 0>, <-0.5, 0, 0>, 0.02 rotate y*270}
                     
                     rotate y*45
                     translate -y*1.6
               }
         }
         
         cylinder {<-1.2, 0.25, 0>, <-0.5, 0.25, 0>, 0.02}
         cylinder {<-1.2, 0.25, 0>, <-0.5, 0.25, 0>, 0.02 rotate y*180}
         
         cylinder {<-1.2, -1.6, 0>, <-1.2, 2.1, 0>, 0.04}
         cylinder {<1.2, -1.6, 0>, <1.2, 2.1, 0>, 0.04}
         cylinder {<-1.2, 1.7, 0>, <1.2, 1.7, 0>, 0.02}
         cylinder {<-1.2, -1.2, 0>, <1.2, -1.2, 0>, 0.02}
         
         #include "metals.inc"
         texture {T_Gold_4D}
}

#declare Egg = union {
         object {EggLow translate -y*0.6}
         object {EggHigh translate y*0.6}

         object {Drop}
         object {YellowCenter}
         
         object {EggSupport}
}
