/***************************************************************************
 * THE DAWN AFTER WAR
 * ------------------
 * Image description in jthdawar.txt
 * Contribution to IRTC (www.irtc.org) Jan-Feb 2000 round, topic Ruins.
 * If you wish to use objects from this scene, please contact the author first.
 * 
 * (C) Jouni T. Heikniemi, 28th February 2000
 * Contact: jouni@mikrobitti.fi 
 **********************************************************************/

#include "colors.inc"
#include "textures.inc"

#local Lego_Finish = finish {

        phong 0.1
        phong_size 200        
}

#local LegoCannonPipe_Finish = finish {

        reflection 0.05
        phong 0.25
        phong_size 70
}

// -----------------------------------------------------------------------
#local LegoHeight = 1.4;
#local LegoXZGap = 0.02;
#local LegoYGap = 0.02;
#local LegoWallThickness = 0.22;                                           
                                           
#local Connector = cylinder { 0, 0.2*y, 0.25 } 
                                        
#local LegoGround = union {

        box { <-21, -0.01, -21>, <21, 0, 21> }
        
        #local LGx = -18;
        #while (LGx <= 20) 
                #local LGy = -20;
                #while (LGy <= 20) 
                    object { Connector translate <LGx, 0, LGy> }
                    #local LGy = LGy+1;
                #end
                #local LGx = LGx+1;
        #end                       
        #undef LGx
        #undef LGy
        
        texture {
                pigment { Green*0.8 }
        }
}                                           

#local Lego2x2 = union {

        box { <-0.5+LegoXZGap, 0, -0.5+LegoXZGap>, <1.5-LegoXZGap, LegoHeight-LegoYGap, 1.5-LegoXZGap> }
        object { Connector translate <0,LegoHeight-LegoYGap,0> }
        object { Connector translate <1,LegoHeight-LegoYGap,0> }
        object { Connector translate <0,LegoHeight-LegoYGap,1> }
        object { Connector translate <1,LegoHeight-LegoYGap,1> }
}                                                 

#local Lego4x2 = union {

        box { <-0.5+LegoXZGap, 0, -0.5+LegoXZGap>, <3.5-LegoXZGap, LegoHeight-LegoYGap, 1.5-LegoXZGap> }
        object { Connector translate <0,LegoHeight-LegoYGap,0> }
        object { Connector translate <1,LegoHeight-LegoYGap,0> }
        object { Connector translate <0,LegoHeight-LegoYGap,1> }
        object { Connector translate <1,LegoHeight-LegoYGap,1> }
        object { Connector translate <2,LegoHeight-LegoYGap,0> }
        object { Connector translate <3,LegoHeight-LegoYGap,0> }
        object { Connector translate <2,LegoHeight-LegoYGap,1> }
        object { Connector translate <3,LegoHeight-LegoYGap,1> }
}

#local Lego4x2Detailed = union {

        difference {
                object { Lego4x2 }
                box { <-0.5+LegoWallThickness, -0.01, -0.5+LegoWallThickness>, <3.5-LegoWallThickness, LegoHeight-LegoWallThickness, 1.5-LegoWallThickness> }
        }                       
        
        #local P = -1;
        #while (P < 2)
            difference { 
                cylinder { 0, (LegoHeight-LegoWallThickness)*y, 0.4 }
                cylinder { -0.01*y, (LegoHeight-LegoWallThickness+0.01)*y, 0.34 }
                translate <1.5+(P*0.93), 0, 0.5>
            }
            #local P = P+1;
        #end
        #undef P
}


#local LegoWall = union {
        #local Layers = 0;       
        #while (Layers < 4)
                #if (mod(Layers,2) = 0)
                        #local Sx = -18;
                #else 
                        #local Sx = -16;
                #end
                #while (Sx < 18)
                        object { Lego4x2 translate <Sx, LegoHeight*Layers, 0> }
                        #local Sx = Sx + 4;
                #end              
                #local Layers = Layers + 1;
        #end
        #undef Layers                      
        #undef Sx
}

#local Lego4x2x5Pillar = union {

        object { Lego4x2 }
        object { Lego4x2 translate 1*LegoHeight*y }
        object { Lego4x2 translate 2*LegoHeight*y }
        object { Lego4x2 translate 3*LegoHeight*y }
        object { Lego4x2 translate 4*LegoHeight*y }
}

#local Lego4x2x3Pillar = union {

        object { Lego4x2 }
        object { Lego4x2 translate 1*LegoHeight*y }
        object { Lego4x2 translate 2*LegoHeight*y }
}

#local Lego4x2x5Stairs = union { 
        #local Sy = 0;
        #while (Sy < 5)
            #local Sx = 0;
            #while (Sx <= Sy) 
                object { Lego4x2 translate <0, (4-Sy)*LegoHeight, Sx*2> }
                #local Sx = Sx+1;
            #end
            #local Sy = Sy+1;
        #end
        #undef Sy
        #undef Sx                        
}                                                                

#local Lego8x4Flat = union {

        box { <-0.5+LegoXZGap, 0, -0.5+LegoXZGap>, <7.5-LegoXZGap, LegoHeight/4-LegoYGap, 3.5-LegoXZGap> }
        
        union {
                #local LGx = 0;
                #while (LGx <= 7) 
                        #local LGy = 0;
                        #while (LGy <= 3) 
                            object { Connector translate <LGx, 0, LGy> }
                            #local LGy = LGy+1;
                        #end
                        #local LGx = LGx+1;
                #end                       
                #undef LGx
                #undef LGy
                translate (LegoHeight/4-LegoYGap)*y
        }
}                               

#local Lego2x4Flat = union {

        box { <-0.5+LegoXZGap, 0, -0.5+LegoXZGap>, <1.5-LegoXZGap, LegoHeight/4-LegoYGap, 3.5-LegoXZGap> }
        
        union {
                #local LGx = 0;
                #while (LGx <= 1) 
                        #local LGy = 0;
                        #while (LGy <= 3) 
                            object { Connector translate <LGx, 0, LGy> }
                            #local LGy = LGy+1;
                        #end
                        #local LGx = LGx+1;
                #end                       
                #undef LGx
                #undef LGy
                translate (LegoHeight/4-LegoYGap)*y
        }
}                               

#local Lego2x2DiagonalSupport = intersection {
        // Technically not a lego element though :-(
        object { Lego2x2 }
        plane { y, 0 inverse  
                rotate -37*x
        }
}                                                                    

#local LegoCannonPipe = lathe { 
  quadratic_spline
  10  // control points
  <-0.000355, -0.00029>,
  <0.000341, -0.001677>,
  <0.9026, -0.001662>,
  <1.256651, 0.546948>,
  <1.254257, 4.953178>,
  <0.844381, 9.226879>,
  <0.697578, 10.986157>,
  <0.579714, 10.998059>,
  <0.252554, 11.0033>,
  <0.003328, 11.001382>
                    
  rotate 90*x
  scale (5/11)
}                                               

#local LegoCannonPipeSupport = intersection {

        box { <0, -0.1, -1>, <LegoWallThickness, 0.4, 1> }
        
        plane { y, 0 rotate -45*x translate -0.7*z }
        plane { y, 0 rotate 45*x translate 0.7*z }
        
        cylinder { -1*x, 1*x, 0.15 scale <1, 1.4, 1> translate 0.4*y inverse }
                
}

#local LegoCannon = union {

        // Core
        difference {
                box { <-0.5, 0, -0.5>, <3.5, 0.6, 1.5> }
                box { <-0.5+LegoWallThickness, -0.01, -0.5+LegoWallThickness>, <3.5-LegoWallThickness, LegoHeight-LegoWallThickness, 1.5-LegoWallThickness> }
                
                pigment { Brown }
        } 
        union {
                object { LegoCannonPipeSupport rotate 90*y translate <1.5, 0.7, -0.5+LegoWallThickness> }
                object { LegoCannonPipeSupport rotate 90*y translate <1.5, 0.7, 1.5> }
                
                cylinder { <1.5, 0.74+0.3, -0.55>, <1.5, 0.74+0.3, 1.55>, 0.10 pigment { Gray75 } }

                pigment { Brown }
        }
        union {
                object { LegoCannonPipe } 
                cone { 0, 0.2, -0.3*z, 0.1 }
                sphere { -0.35*z, 0.15 }    
                
                rotate 90*y
                rotate 6*z

                translate <0.3, 1.0, 0.5>
                
                texture {
                        pigment { Gray75 }
                        finish { LegoCannonPipe_Finish }
                }
        }
        rotate -90*y   
        translate 0.5*x
}
                                        
// -----------------------------------------------------------------------
                  
object { LegoGround }                  
  
#local Castle = union {  
  
// Castle walls

union {
        // The first 4 layers
        object { LegoWall translate 18*z }
//        object { LegoWall rotate 180*y translate <1, 0, -17> }
        object { LegoWall rotate 90*y translate <18,0,1> }
        object { LegoWall rotate -90*y translate <-17,0,0> }
       
        // The next layers, with some tiles fallen off

        // North wall, layer 5
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                //object { Lego4x2 translate 3*x }
                object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                translate <-1, 4*LegoHeight, 18>
        }               
        
        // Left wall, layer 5
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                object { Lego4x2 translate 3*x }
                object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <-18, 4*LegoHeight, 0>
        }               

        // Right wall, layer 5
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                object { Lego4x2 translate 3*x }
                object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <18, 4*LegoHeight, 2>
        }               
        
        // North wall, layer 6
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                //object { Lego4x2 translate 3*x }
                //object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                translate <1, 5*LegoHeight, 18>
        }               

        // Left wall, layer 6
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                object { Lego4x2 translate 3*x }
   //             object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <-18, 5*LegoHeight, 2>
        }               

        // Right wall, layer 6
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                object { Lego4x2 translate 3*x }
                //object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <18, 5*LegoHeight, 0>
        }               

        // North wall, layer 7
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                //object { Lego4x2 translate 7*x }
                //object { Lego4x2 translate 3*x }
                //object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                
                // The ledge
                #local tX = -17;
                #while (tX < 18) 
                    object { Lego2x2DiagonalSupport translate <tX,0,2> }
                    #local tX = tX+2;
                    #if (tX = -1)
                        #local tX = 11;
                    #end
                #end
                #undef tX
                
                // Plating
                //object { Lego8x4Flat translate <9, LegoHeight, 0> }                
                //object { Lego8x4Flat translate <1, LegoHeight, 0> }                
                object { Lego8x4Flat translate <-7, LegoHeight, 0> }                
                object { Lego8x4Flat translate <-15, LegoHeight, 0> }                
                object { Lego2x4Flat translate <17, LegoHeight, 0> }                
                
                translate <-1, 6*LegoHeight, 18>
        }
        
        // Left wall, layer 7
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x}
                object { Lego4x2 translate 7*x }
  //              object { Lego4x2 translate 3*x }
  //              object { Lego4x2 translate -1*x }
  //              object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <-18, 6*LegoHeight, 0>
        }               

        // Right wall, layer 7
        union { 
                object { Lego4x2 translate 15*x }
                object { Lego4x2 translate 11*x }
                object { Lego4x2 translate 7*x }
                //object { Lego4x2 translate 3*x }
                //object { Lego4x2 translate -1*x }
                object { Lego4x2 translate -5*x }
                object { Lego4x2 translate -9*x }
                object { Lego4x2 translate -13*x }
                object { Lego4x2 translate -17*x }
                rotate 90*y
                translate <18, 6*LegoHeight, 2>
        }         
        
        // And then some blasted stuff...
        
        object { Lego8x4Flat rotate <-72, -33, 0> translate <8.3, 0.65, 11.5> }
        
        object { Lego4x2Detailed rotate <90, 25, 0> translate <8.2, 1.65, 7.3> }
        object { Lego4x2 rotate <0, -17, 0> translate <8.55, 5.25*LegoHeight+0.2, 13.6> }
        object { Lego4x2Detailed rotate <180, 15, 60> translate <2.5, 1.7, 15.2> }
        object { Lego4x2Detailed rotate <90, -59, 0> translate <10.2, 1.65, -1.4> }
        object { Lego4x2Detailed rotate <90, -10, 0> translate <13.6, 2*LegoHeight+1.65, -1.5> }
        
        texture {
                pigment { Yellow }        
                finish { Lego_Finish }
        }
}

union {
        // Pillars for the northern & eastern ledge
        
        object { Lego4x2x5Pillar rotate 90*y translate <16, 0, 17> }
        object { Lego4x2x5Pillar rotate 90*y translate <8, 0, 17> }
        object { Lego4x2x3Pillar rotate 90*y translate <0, 0, 17> }
        object { Lego4x2x5Pillar rotate 90*y translate <-8, 0, 17> }
        object { Lego4x2x5Pillar rotate 90*y translate <-16, 0, 17> }

        object { Lego4x2x5Pillar translate <14, 0, 11> }
        object { Lego4x2x5Stairs rotate 180*y translate <17, 0, 6> }
        
        object { Lego8x4Flat translate <-15, 5*LegoHeight, 14> }
        object { Lego8x4Flat translate <9, 5*LegoHeight, 14> }
        object { Lego8x4Flat rotate 90*y translate <14, 5*LegoHeight, 13> }
        
        // Crash boom bang, the fallen pillar and the bridges
        object { Lego8x4Flat rotate -22*z translate <-6.4, 5*LegoHeight, 14> }
        object { Lego8x4Flat rotate 180*y rotate 65*z translate <7.5, 4.97*LegoHeight, 17> }
        
        object { Lego4x2Detailed rotate 90*y rotate -90*z rotate 35*y translate <2, 1.7-LegoXZGap, 12> }
        object { Lego4x2 rotate 90*y rotate -10*y translate <-2.5, 0.2, 15> }

        texture {
                pigment { Gray80 }
                finish { Lego_Finish }
        }
}                      

// Cannons and stuff (tm)

object { LegoCannon 
         translate <-7.4, 7.25*LegoHeight, 18> }
         
object { LegoCannon 
         translate <-15.4, 7.25*LegoHeight, 18> }

// Cannonballs :)         
union { 
         sphere { <-14.45, 5.25*LegoHeight+0.3, 15.45>, 0.3 }
         sphere { <-13.35, 5.25*LegoHeight+0.3, 15.55>, 0.3 }
         sphere { <-13.6, 5.25*LegoHeight+0.3, 16.35>, 0.3 }
         sphere { <-13.65, 7.25*LegoHeight+0.3, 18.5>, 0.3 }
         
         sphere { <-8.57, 5.25*LegoHeight+0.3, 14.39>, 0.3 }
         sphere { <-10.42, 7.25*LegoHeight+0.3, 18.44>, 0.3 }
         sphere { <-7.41, 5.25*LegoHeight+0.25, 14.61>, 0.3 }
        
         sphere { <6.57, 0.3, 12.39>, 0.3 }
         sphere { <4.42, 0.3, 7.44>, 0.3 }
         sphere { <-0.41, 0.3, 9.61>, 0.3 }
         
         pigment { Gray85 }
}        
                       
object { LegoCannonPipe  
         rotate 2*x
         rotate 155.1*y
         translate <4.3, 0.25+(5/11), 11> 
         texture {
                pigment { Gray70 } 
                finish { 
                        phong 0.07
                        phong_size 110
                }
         }                       
}                                

// The Dead
#include "legodude.inc"
object { 
        LegoDude
        rotate <90, 145, 0>
        translate <-12.5, 0.7, 12>
}                     

object { LegoDudeLower 
         rotate 90*y
         translate <15-0.5, 5.25*LegoHeight, 11+0.5>
         texture {
                t_LegoDudeLeg
                finish { ambient 0.15 }
         }
}                                          

object { LegoDudeTorso 
         rotate <90, -80, 0> 
         translate <10.3, 0.7, 10.3> }

object { LegoDudeHead  
         rotate <25, 25, 90>
         translate <14.8, 5.25*LegoHeight + 0.55, 12.5> }
                         
}   // END OF CASTLE UNION

object { Castle }

// Sky
sky_sphere {                          
          pigment { 
                bozo 
                turbulence 0.4
                frequency 1.5
                color_map {
                     [0.0    color White ]
                     [0.1    color (Blue*0.7+White)/2]
                     [0.5    color ((Blue*0.5+White)/2 + (Red*0.5+White)/2)/2]
                     [0.7    color (Red*0.5+White)/2]
                     [0.9    color (Red*0.1+White)/2]
                     [1      color White ]
                }
                scale 0.7
                rotate 15*y
                rotate 30*z
          }
          pigment { Clouds scale 0.4 rotate -25*z }
}
                                           
// The ground                                        

height_field
{
  gif               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "lw.ghf"     // the file name to read
  water_level 0.4 // truncate/clip below N (0.0 ... 1.0)
  smooth

  texture {
        pigment {
                gradient y
                turbulence 0.4
                color_map {
                        [0.0  color OrangeRed ]
                        [0.2  color (Orange+MediumSeaGreen)/2 ]
                        [0.3  color (Tan+MediumSeaGreen)/2 ]
                        [0.45 color MediumSeaGreen ]
                        [1.0  color Green ]                        
                }     
        }
  }                 
  #local GroundtranslateY = 45.5;

  scale <1200, 50, 800>
  translate <-600, -GroundtranslateY, -400>
  rotate 180*y
  translate <(12/5)*20, 0, (8/5)*240>
  rotate 25*y
}                

plane { y, (-GroundtranslateY + 0.4*50) 

        texture {        
                pigment { 
                        bozo
                        turbulence 3.25
                        color_map {
                                [0      color Aquamarine ]
                                [0.5    color (CornflowerBlue+Aquamarine)/2 ]
                                [1.0    color Aquamarine ]
                        }
                        scale 25
                }                               
                normal {
                      waves 0.035
                      frequency 3000.0
                      scale 1000.0
                }
                finish {
                      ambient 0.1
                      diffuse 0.1
                      reflection 0.55
                }
        }

        clipped_by { plane { z, 650 } }
} 

                                                                                     
                                       
// -----------------------------------------------------------------------
            
camera {
  location  <-18.5, 14, -10>
  look_at   <-2.5, 5, 15>
}             
     
light_source { <0, 40, 0> color White }
light_source { <0, 5, 12> color 0.03*White shadowless }
light_source { <-19, 7*LegoHeight, -1> color Gray20 shadowless }
//light_source { <-19, 3.2*LegoHeight, 4> color Gray30 }
light_source { <100, 300, 500> color Gray20 shadowless }
