/***************************************************************************
 * THE DAWN AFTER WAR (include file)
 * ------------------
 * Image description in jthdawar.txt
 * Contribution to IRTC (www.irtc.org) Jan-Feb 2000 round, topic Ruins.
 * If you wish to use objects from this file, please contact the author first.
 * 
 * (C) Jouni T. Heikniemi, 28th February 2000
 * Contact: jouni@mikrobitti.fi 
 **********************************************************************/

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"

// -----------------------------------------------------------------------
                                          
#local LegoHeight = 1.4;
#local LegoXZGap = 0.02;
#local LegoYGap = 0.02;
#local LegoWallThickness = 0.22;                                           
                                           
#local Connector = cylinder { 0, 0.2*y, 0.25 } 
                                        
#local Lego2x2 = union {

        box { <-0.5+LegoXZGap, 0, -0.5+LegoXZGap>, <1.5-LegoXZGap, LegoHeight-LegoYGap, 1.5-LegoXZGap> }
        object { Connector translate <0,LegoHeight-LegoYGap,0> }
        object { Connector translate <1,LegoHeight-LegoYGap,0> }
        object { Connector translate <0,LegoHeight-LegoYGap,1> }
        object { Connector translate <1,LegoHeight-LegoYGap,1> }
}                                                 
        
#declare t_LegoDudeLeg = texture {

        pigment { LightBlue }
}

#local t_LegoDudeTorso = texture {

        pigment { Red }
}

#local t_LegoDudeArms = texture { t_LegoDudeLeg }
                   
// -----------------------------------------------------------------------
                                            
#local LegoDudeLeg = difference { 
        
        union {
                box { <0.05, 0, 0.05>, <0.95, 0.25, 0.95> }
                box { <0.05, 0, 0.2>, <0.95, LegoHeight+0.2, 0.95> }           
                cylinder { <0.05, LegoHeight+0.2, 0.55>, <0.95, LegoHeight+0.2, 0.55>, 0.4 }
        }
        union {
                box { <0.05+LegoWallThickness/2, -0.01, 0.2+LegoWallThickness>, <0.95-LegoWallThickness/2, 0.5*(LegoHeight+0.1), 0.95-LegoWallThickness> }
                cylinder { <0.5, 1.6, 1>, <0.5, 1.6, 0.5>, 0.5-LegoWallThickness/2 }
                cylinder { <0.5, 0.5, 1>, <0.5, 0.5, 0.5>, 0.5-LegoWallThickness/2 }
        }
}                                

#local LegoDudeWaistConnectorCone = difference {

        cone { 0, 0.3, 0.5*y, 0.23 }
        cylinder { 0, 0.51*y, 0.17 }
}             

#local LegoDudeArm = union {

        sphere { 0, 0.2 }
        cylinder { 0, <0, -0.4, -0.5>, 0.2 }
        sphere { <0, -0.4, -0.5>, 0.2 } 
        difference {
                cylinder { <0, -0.4, -0.5>, <0, -0.4, -1.2>, 0.2 }
                cylinder { <0, -0.4, -0.5>, <0, -0.4, -1.21>, 0.13 }
        }                                                         
        
        union {
                cylinder { -0.1*z, 0.3*z, 0.12 }
                difference {
                        cylinder { 0, 0.2*y, 0.18 }
                        cylinder { -0.01*y, 0.21*y, 0.12 }
                        cylinder { -0.11*y, 0.31*y, 0.13 rotate -7*z translate -0.06*z }
                        
                        translate <0, -0.10, -0.25> 
                }
                                        
                translate <0, -0.4, -1.2> 
                texture { pigment { Yellow } }
        }
        
        texture { t_LegoDudeArms } 
}
                                                  
#declare LegoDudeTorso = union {

        intersection {
                box { <-0.95, 0, -0.4>, <0.95, LegoHeight+0.2, 0.4> }
                
                plane { x, 0 rotate 10*z translate 0.95*x }
                plane { -x, 0 rotate -10*z translate -0.95*x }
        }       
        cylinder { 0, 0.5*y, 0.3 translate (LegoHeight+0.2)*y } // Neck
        
        object { LegoDudeArm rotate -13*z translate <-0.95, 1.15, 0> rotate -10*z }
        object { LegoDudeArm rotate 13*z translate <0.95, 1.15, 0> rotate 10*z }
        
        texture { t_LegoDudeTorso }
}       

#declare LegoDudeHead = union {

        cylinder { 0, 1*y, 0.35 }
        cylinder { 0.1*y, 0.2*y, 0.4 }
        torus { 0.2, 0.1 scale <2, 1, 2> translate 0.9*y }
        torus { 0.2, 0.1 scale <2, 1, 2> translate 0.2*y }
        cylinder { 0.2*y, 0.9*y, 0.6 }
        object { Connector translate 1*y }
                     
        // Eyes and mouth
        cylinder { 0.6*y, <0, 0.6, -0.600001>, 0.06 pigment { Black } rotate 18*y no_shadow }                            
        cylinder { 0.6*y, <0, 0.6, -0.600001>, 0.06 pigment { Black } rotate -18*y no_shadow }

        difference {
                cylinder { 0.55*y, <0, 0.55, -0.600001>, 0.2 }
                cylinder { 0.55*y, <0, 0.55, -0.600002>, 0.165 }
                cylinder { 0.25*y, <0, 0.25, -0.600002>, 0.22 inverse }
                
                pigment { Black }
                no_shadow                                              
                translate -0.05*y
        }        
                     
        pigment { Yellow } 
}                                           
                                                  
#declare LegoDudeLower = union {

        difference {
                union { 
                        object { LegoDudeLeg }
                        object { LegoDudeLeg translate 1*x }
                }
                box { <0.93, -0.01, -1>, <1.07, 10, 1> }
        }
        
        // Groin and waist:)        
        union {
                cylinder { -0.1*x, 0.1*x, 0.37 translate <1, LegoHeight+0.2, 0.55> }
                union {
                        difference { 
                                box { <-0.95, 0.35, -0.4>, <0.95, 0.5, 0.4> }
                                cylinder { -0.97*x, 0.97*x, 0.42 }                                
                        }               
                        object { LegoDudeWaistConnectorCone translate <-0.5, 0.5, 0> }
                        object { LegoDudeWaistConnectorCone translate <0.5, 0.5, 0> }

                        translate <1, LegoHeight+0.2, 0.55>
                }
        }                       
}        

#declare LegoDude = union {

        object { LegoDudeLower texture { t_LegoDudeLeg } }        
        object { LegoDudeTorso translate <1, LegoHeight+0.7, 0.55> }
        object { LegoDudeHead translate <1, 2*(LegoHeight+0.7)-0.5, 0.55> }
                
        translate <-0.5, 0, -0.5> 
}                   
                   
// -----------------------------------------------------------------------
