// Persistence of Vision Ray Tracer Scene Description File                      
// File: MyCity.pov
// Vers: 3.1
// Desc: declare objects for MyCity?.pov files
// Date: 10/27/99
// Auth: rjchase
 
/*INDEX:  
          #local "colors.inc"
          Camera Declares
            Zooom
            Top_View
            Left_Hand
          Referenced objects
            Cube001 = object
            Support_Fin = prism
            Cloud_Plane = plane image map
            Needle objects:
                Support_Structure = union
                Fan_Structure = union
                Glass_House = lathe
                Top_Swp = lathe
                Glass_House2 = lathe
                View_Platform = lathe
                Top_Cube = cube
                Elevator_Ring 
                Ring_Group
          Mt_Rainier = height_field
          City = union
          Space_Needle = union 
            cylinder
            Support_Structure
            Fan_Structure 
            Glass_House
            Top_Swp
            Glass_House2
            View_Platform
            Top_Cube
            Ring_Grp
         Clouds, Smoke, Lightning            
            Cone_Cloud = union
            Cloud4_Blb
            Cloud7_Blb
            Cloud9_Blb
                        
*/  //  end INDEX

//#version unofficial MegaPov 0.4;

#include "colors.inc"

//                          //     
//   CAMERA DECLARATIONS    //
//                          //
#declare Zooom = // check textures, etc.. 
     camera {
        location  <0, 20, -1000> // city y=10    needle y=20
        direction <0, 0, 2>      // city z=3     needle z=2 
        up <0, 1, 0> // yup 
        look_at <300, 40, 320>   // city x=-250  needle x=300
        }
        
#declare Top_View =  //  for placement
     camera {
        location <0, 700, 1>
        direction <0, 3, 0>  // yup
        up <0, 1, 0>
        right 4/3*x
        look_at <-30, 400, -320>
        } // Top view
        
#declare Left_Hand =  //  main cam
     camera {
        location <0, 15, -1000>  // 0, 10, -1000
        up <0, 1, 0> // y is up
        right  4/3*x  // left-hand coords
        look_at <5, 1, 1>
        //  focal_blur
        aperture 0.8 // 0.125
        blur_samples 4
        focal_point <18, -19, -950> // on needle
        }

//                                       //
// ********  REFERENCED OBJECTS  ******* //
//                                       //

//
// Cube for Fan Support object
//

#declare Cube001 = object {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {  Aluminum  }
    scale <0.05, 3.45, 0.15>
    translate  <0.0, -0.03259, 19.902231>
  }
}

#declare Support_Fin = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  14  // control points
  <-0.615385, -2.039886>,
  <0.501425, -2.039886>,
  <0.508547, -1.310399>,
  <0.712309, 0.012569>,
  <1.449848, 2.153846>,
  <0.955661, 2.153846>,
  <0.192749, 0.002514>,
  <0.002233, -0.072901>,
  <-0.215501, 0.002514>,
  <-0.993827, 2.153846>,
  <-1.449848, 2.153846>,
  <-0.791412, 0.025138>,
  <-0.605413, -1.368661>,
  <-0.615385, -2.039886>
  rotate -x*90
  material {  Rusty_Iron  }
  scale <1.0, 3.0, 0.24>
  rotate 95.0*x
  translate  <0.0, -1.6, 13.5>
}

// Cloud_Plane
#declare Cloud_Plane = plane {
    y, 50
    material { Cloud_Layer 
      }  // end material
    hollow
    rotate 180*z
    }  // end Cloud_Plane


    
//                    //
//   NEEDLE OBJECTS   //
//                    //
#declare Support_Structure = union { 
  object { Support_Fin }
  object { // Support_Fin2->Support_Fin
    Support_Fin
    rotate <0.0, 0.0, -120.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Support_fin3->Support_fin1
    Support_Fin
    rotate <0.0, 0.0, 120.0>
    translate  <0.0, -0.0, -0.0>
  }
}  //  end Support_Structure

//
// needle fan structure
#declare Fan_Structure = union {
#local Index = 0;
#while (Index > -171) // complete loop 17 times
      object { 
        Cube001  // from MRY Cube001
        rotate Index*z
        }
    #local Index = Index - 10;  // countdown to Index < -180
    #end
        material { Column_Texture  }
} // end Fan_Structure

//
//  Glass House     with broken windows
#declare Glass_House = lathe {
  linear_spline
  4  // control points
  <2.225071, -1.014245>,
  <3.225071, -0.514245>,
  <3.225071, 0.485755>,
  <3.022792, 0.94302>
  rotate <90,0,90>
  material { Broken_Glass  }
  translate  21.0*z
}

//
//  View Platform
#declare View_Platform = lathe
     { linear_spline
      4  // control points
      <4.022792, 0.257835>,
      <4.806268, 0.257835>,
      <4.817949, -0.615527>,
      <3.987578, -0.627123>
      rotate <90,0,90>
      material { RJMarble  }
      scale <0.75, 0.75, 0.3>
      translate  21.2*z
    }

//
//  Top for Glass House
#declare Top_Swp = lathe {
  linear_spline
  6  // control points
  <2.381766, -0.273504>,
  <0.632479, 0.539886>,
  <0.565527, 0.649288>,
  <0.641168, 0.774017>,
  <0.817664, 0.998575>,
  <0.045584, 1.0>
  rotate <90,0,90>
  material { Aluminum  }
  scale <1.3, 1.3, 1.0>
  translate  22.23259*z
}

//
//  Concrete lower half of Glass House
#declare Glass_House2 = lathe {
  linear_spline
  3  // control points
  <2.239316, -1.042735>,
  <3.253561, -0.52849>,
  <3.253561, 0.115385>
  rotate <90,0,90>
  material { RJMarble  }
  translate  21.0*z
}

// Top of the needle, there's this little thingie, n' stuff...
#declare Top_Cube =  box  // Top_Cube
    { <-1, -1, -1>, <1, 1, 1>
    material { Chrome_Texture  }
    scale <0.1, 0.1, 0.3>
    translate  23.472496*z
  }

// Elevator_Ring    //
#declare Elevator_Ring = cylinder
     { <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 0.25>
    rotate -90.0*x
    }

//
//  Rings around Main Support
#declare Ring_Grp = union {
#local Index = 1;
#while (Index < 11)
  object { Elevator_Ring  
    translate  Index*y
    }
    #local Index = Index + 1;
    #end
        material { Column_Texture  }
        rotate 90.0*x
        translate  <0.0, 0.0, 9.0>
} // end Ring_Grp

//
//  MOUNTAIN OBJECT
//
#declare Mt_Rainier =  height_field {
        gif
     "C:\Program Files\POV-Ray for Windows v3.1\include\MtRain01.gif"
        smooth
        rotate    <-90, 0, 0> 
        scale     <  2, 2, -2> 
        translate < -1, -1, -1> 
        material { Mountains_Snow  }
    }  // end height_field

//                  
//  CITY OBJECT    
//  
#declare City = union {
    object {MyCity  // large city
        scale <0.8, 0.6, 0.9>
        rotate <0, -50, 0>
        translate <-100, -12, -700> 
        }
    object {MyCity  // snall city
        scale <0.7, 0.4, 0.6>
        rotate <0, 70, 0>
        translate <-20, -25, -770> 
        }
    } // end union City

//
//    Space_Needle
//
#declare Space_Needle = union {
    cylinder { // Main_Support
        <0,0,1>, <0,0,0>, 1 
    material { Aluminum }
    scale <0.5, 0.5, 20.0>  // twenty POV units high
  }
    object { Support_Structure }
    object { Fan_Structure }
    object { Glass_House }
    object { Top_Swp }
    object { Glass_House2 }
    object { View_Platform }
    object { Top_Cube }
    object { Ring_Grp }
}

//
//  Cloud4_Blb  --  dragged by prevailing winds   
//  used Blob Sculptor
#declare Cloud4 = blob {
  threshold 0.6
      component 1.0, 1.060293, <-0.006131, 0.0, 0.012266>
      component 1.0, 0.51654, <0.340823, -0.472079, -0.894006>
      component 1.0, 0.51605, <-1.258426, -0.209813, -0.525886>
      component 1.0, 0.567073, <-0.591396, -0.256933, -0.420708>
      component 2.0, 0.558789, <-0.026218, 0.865478, -0.539725>
      component 1.0, 0.41727, <0.760298, -0.629438, -0.55218>
      component 3.0, 0.301222, <1.232208, 0.104906, -0.341826>
      component 2.0, 0.666905, <1.651683, -0.367172, -0.236649>
      component 1.0, 0.495215, <2.4382, -0.393399, -0.262943>
      component 1.0, 0.402028, <-0.565111, 0.445852, 0.210355>
      component 1.0, 0.390476, <1.101122, -0.550758, -0.709946>
      component 1.0, 0.39825, <0.393258, 1.101517, 0.105177>
      component 1.0, 0.55376, <-0.801669, 0.0, -0.604769>
      component 1.0, 0.349262, <0.314606, 0.550759, 0.0>
      component 1.0, 0.349363, <-0.052435, -0.576985, 0.0>
      component 1.0, 0.247028, <0.157303, 1.363783, 0.0>
      component 1.0, 0.322023, <0.576778, -0.183586, 0.0>
      component 1.0, 0.336882, <-1.669049, 0.0, -0.657357>
      component 1.0, 0.322907, <2.752806, -0.262266, -0.36812>
      component 3.0, 0.29042, <-1.989338, -0.305419, -0.772277>
   material {  T_Cloud1  //Thin_Glass - scattering not realistic enough
        }
      hollow
      scale 10.0
      rotate <-90.0, 0.0, -180.0>
    }  // end declare cloud4 object                

//
// Cloud7_Blb  --  over Mt_Rainier
// used Blob Sculptor
#declare Cloud7_Blb = blob {   // Cloud7
   threshold 0.6
      component 1.0, 2.940815, <-0.776542, 0.0, 0.372883>
      component 1.0, 1.091135, <-1.74256, 2.226274, -0.410171>
      component 1.0, 1.164707, <-0.272003, 2.176802, -1.02001>
      component 1.0, 1.864336, <-3.400034, -1.292476, -0.310735>
      component 1.0, 0.792037, <-2.101839, -1.174978, 0.0>
      component 1.0, 1.179096, <-4.883685, -0.989455, 0.0>
      component 1.0, 0.911462, <-6.305518, -1.051296, 0.0>
      component 1.0, 1.200486, <0.680007, 1.020376, 0.0>
      component 1.0, 0.413801, <-5.625511, -1.360501, -0.248588>
      component 1.0, 1.073752, <0.528048, 3.401252, -0.497177>
      component 1.0, 1.289232, <-0.432732, 3.957821, 0.0>
      component 1.0, 0.792037, <-1.469217, 3.129152, -1.298874>
      component 1.0, 0.991696, <-1.05092, 1.546024, -0.370913>
      component 1.0, 0.87353, <-0.185456, 4.761753, 0.0>
      component 1.0, 1.402461, <-2.410933, 4.452548, 0.0>
      component 1.0, 0.991696, <-1.421832, 4.638071, 0.0>
      component 1.0, 0.701231, <-3.894584, 4.328867, 0.0>
      component 1.0, 0.939053, <-3.450951, 4.019662, -0.478533>
      component 1.0, 0.701231, <1.156012, 4.217553, -0.273447>
      component 1.0, 0.411771, <1.360014, 4.761753, 0.0>
      component 1.0, 0.823542, <-4.945504, 4.328867, 0.0>
      component 1.0, 0.368352, <-4.450953, 4.081503, 0.0>
      component 1.0, 1.384354, <-0.922532, 5.646079, -0.75198>
      component 1.0, 0.736704, <-1.810895, 5.305954, -0.410171>
      component 1.0, 0.51655, <-5.712057, 4.149528, 0.0>
      component 1.0, 0.429843, <-6.594392, 4.081503, -0.410171>
      component 1.0, 1.281177, <0.748008, 2.380877, 0.0>
      component 1.0, 1.091135, <0.444182, 4.965828, 0.136724>
      component 1.0, 0.716405, <-0.922532, 2.993102, -0.478533>
      component 1.0, 0.965843, <-5.508055, -1.972726, -0.683618>
      component 1.0, 0.716313, <-4.407651, -1.768651, -0.957065>
      component 1.0, 2.025937, <0.034168, -1.428526, -0.952009>
      component 1.0, 1.281177, <-0.717525, -0.340125, -1.914131>
      component 1.0, 1.154761, <-6.528065, -2.040752, 0.0>
      component 1.0, 0.771554, <-0.204002, 5.850154, -1.224012>
      component 1.0, 0.906156, <0.136002, 0.2721, -1.777407>
      component 1.0, 0.405187, <-6.188062, 4.149528, 0.0>
      component 1.0, 0.640589, <-7.356949, 4.293091, 0.0>
      component 1.0, 0.405187, <-0.204002, 3.197177, 0.0>
      component 1.0, 0.753274, <-6.901903, 3.884225, -0.683618>
      component 1.0, 0.761058, <-6.23297, 3.935333, 0.0>
      component 1.0, 0.443699, <-7.970028, 4.03755, 0.0>
   material { DD_Cloud2 }
   scale 10.0
    } // end Cloud7_Blb
                   
//
// Cloud9_Blb  --  over horizon
// used Blob Sculptor
#declare Cloud9 = blob {   // Cloud9_Blb
  threshold 0.6
      component 1.0, 2.940815, <-0.776542, 0.0, 0.372883>
      component 1.0, 1.455796, <0.900788, 1.917069, 0.803645>
      component 1.0, 1.164707, <-0.309094, 2.473638, 0.0>
      component 1.0, 1.35946, <-2.702365, 0.927614, 0.621471>
      component 1.0, 1.864336, <-3.572092, -0.556569, -0.310735>
      component 1.0, 0.792037, <-2.101839, -1.174978, 0.0>
      component 1.0, 1.179096, <-4.883685, -0.989455, 0.0>
      component 1.0, 0.911462, <-6.305518, -1.051296, 0.0>
      component 1.0, 1.200486, <0.865463, -0.803932, 0.0>
      component 1.0, 1.049783, <2.287296, -0.927614, 0.0>
      component 1.0, 0.651128, <2.967303, -1.360501, 0.0>
      component 1.0, 0.651044, <3.509968, -1.051296, -0.248588>
      component 1.0, 0.413801, <-5.625511, -1.360501, -0.248588>
      component 1.0, 1.073752, <0.528048, 3.401252, -0.497177>
      component 1.0, 1.289232, <-0.432732, 3.957821, 0.0>
      component 1.0, 0.792037, <-1.360014, 3.153889, 0.0>
      component 1.0, 0.520835, <4.018222, -0.989455, 0.0>
      component 1.0, 0.991696, <4.628188, -1.051296, 0.497177>
      component 1.0, 0.701231, <5.872786, -1.051296, 0.0>
      component 1.0, 0.92088, <1.149282, 4.143344, -0.124294>
      component 1.0, 0.991696, <-1.05092, 1.546024, -0.370913>
      component 1.0, 0.667218, <2.950858, 0.0, -0.43503>
      component 1.0, 0.92088, <3.09094, -0.432887, 0.0>
      component 1.5, 0.585359, <5.378236, -0.556569, -0.248588>
      component 1.0, 0.701413, <6.552793, -0.927614, 0.0>
      component 1.0, 0.411771, <1.54547, 4.514389, 0.0>
      component 1.0, 0.87353, <-0.185456, 4.761753, 0.0>
  material { DD_Cloud2  }
}  //  end Cloud9_Blb storm cloud

//
// ********  Cloud_Plane  *******  //
//  Cloud texture projected onto   //
//          Bezier patches           //
#declare Cloud_Plane1 = union { // BezPtch001 2 by 2 patch
  object { bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.0, -3.0, 0.0>, <-2.0, -3.0, 0.0>, <-1.0, -3.0, 0.0>, <0.0, -3.0, 0.0>, 
      <-3.0, -2.0, 0.0>, <-2.0, -2.0, 0.0>, <-1.0, -2.0, 0.0>, <0.0, -2.0, 0.0>, 
      <-3.0, -1.0, 0.0>, <-2.0, -1.0, 0.0>, <-1.0, -1.0, 0.0>, <0.0, -1.0, 0.0>, 
      <-3.0, -0.151488, -0.363023>, <-2.0, -0.151488, -0.363023>, <-1.0, -0.151488, -0.363023>, <0.0, -0.147380, -0.359035>
    }
  }
  object { bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.0, -0.151488, -0.363023>, <-2.0, -0.151488, -0.363023>, <-1.0, -0.151488, -0.363023>, <0.0, -0.147380, -0.359035>, 
      <-3.0, 0.697025, -0.726046>, <-2.0, 0.697025, -0.726046>, <-1.0, 0.697025, -0.726046>, <0.0, 0.697025, -0.726046>, 
      <-3.0, 1.466793, -1.364370>, <-2.0, 1.466793, -1.364370>, <-1.0, 1.466793, -1.364370>, <0.0, 1.466793, -1.364370>, 
      <-3.0, 2.236561, -2.002693>, <-2.0, 2.236561, -2.002693>, <-1.0, 2.236561, -2.002693>, <0.0, 2.236561, -2.002693>
    }
  }
  object { bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.0, -3.0, 0.0>, <1.0, -3.0, 0.0>, <2.0, -3.0, 0.0>, <3.0, -3.0, 0.0>, 
      <0.0, -2.0, 0.0>, <1.0, -2.0, 0.0>, <2.0, -2.0, 0.0>, <3.0, -2.0, 0.0>, 
      <0.0, -1.0, 0.0>, <1.0, -1.0, 0.0>, <2.0, -1.0, 0.0>, <3.0, -1.0, 0.0>, 
      <0.0, -0.147380, -0.359035>, <1.0, -0.151488, -0.363023>, <2.0, -0.151488, -0.363023>, <3.0, -0.151488, -0.363023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.0, -0.147380, -0.359035>, <1.0, -0.151488, -0.363023>, <2.0, -0.151488, -0.363023>, <3.0, -0.151488, -0.363023>, 
      <0.0, 0.697025, -0.726046>, <1.0, 0.697025, -0.726046>, <2.0, 0.697025, -0.726046>, <3.0, 0.697025, -0.726046>, 
      <0.0, 1.466793, -1.364370>, <1.0, 1.466793, -1.364370>, <2.0, 1.466793, -1.364370>, <3.0, 1.466793, -1.364370>, 
      <0.0, 2.236561, -2.002693>, <1.0, 2.236561, -2.002693>, <2.0, 2.236561, -2.002693>, <3.0, 2.236561, -2.002693>
    }
  }
  material {
    High_Sky
  }
  //translate  <0.313952, 0.422786, 0.0>
} 


// ********  Cloud_Plane2  ******* //
//
#declare Cloud_Plane2 = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.0, -3.0, 0.0>, <-2.0, -3.0, 0.0>, <-1.0, -3.0, 0.0>, <0.0, -3.0, 0.0>, 
      <-3.0, -2.0, 0.0>, <-2.0, -2.0, 0.0>, <-1.0, -2.0, 0.0>, <0.0, -2.0, 0.0>, 
      <-3.0, -1.0, 0.0>, <-2.0, -1.0, 0.0>, <-1.0, -1.0, 0.0>, <0.0, -1.0, 0.0>, 
      <-3.0, 0.0, 0.0>, <-2.0, 0.0, 0.0>, <-1.0, 0.0, 0.0>, <0.0, 0.0, 0.0>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.0, 0.0, 0.0>, <-2.0, 0.0, 0.0>, <-1.0, 0.0, 0.0>, <0.0, 0.0, 0.0>, 
      <-3.0, 1.0, 0.0>, <-2.0, 1.0, 0.0>, <-1.0, 1.0, 0.0>, <0.0, 1.0, 0.0>, 
      <-3.0, 2.0, 0.0>, <-2.0, 2.0, 0.0>, <-1.0, 2.0, 0.0>, <0.0, 2.0, 0.0>, 
      <-3.0, 3.0, 0.0>, <-2.0, 3.0, 0.0>, <-1.0, 3.0, 0.0>, <0.0, 3.0, 0.0>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.0, -3.0, 0.0>, <1.0, -3.0, 0.0>, <2.0, -3.0, 0.0>,
       <3.0, -3.0, 0.0>, <0.0, -2.0, 0.0>, <1.0, -2.0, 0.0>,
        <2.0, -2.0, 0.0>, <3.0, -2.0, 0.0>, <0.0, -1.0, 0.0>,
         <1.0, -1.0, 0.0>, <2.0, -1.0, 0.0>, <3.0, -1.0, 0.0>,
          <0.0, 0.0, 0.0>, <1.0, 0.0, 0.0>, <2.0, 0.0, 0.0>,
           <3.0, 0.0, 0.0>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.0, 0.0, 0.0>, <1.0, 0.0, 0.0>, <2.0, 0.0, 0.0>, <3.0, 0.0, 0.0>, 
      <0.0, 1.0, 0.0>, <1.0, 1.0, 0.0>, <2.0, 1.0, 0.0>, <3.0, 1.0, 0.0>, 
      <0.0, 2.0, 0.0>, <1.0, 2.0, 0.0>, <2.0, 2.0, 0.0>, <3.0, 2.0, 0.0>, 
      <0.0, 3.0, 0.0>, <1.0, 3.0, 0.0>, <2.0, 3.0, 0.0>, <3.0, 3.0, 0.0>
    }
  }
  material {  High_Sky_2 }
} //  end Cloud_Plane2

//             //
//  LIGHTNIN'  //
//             //
//  Fractint used to create "Lightning"
#declare Litenin_Disc = disc 
        { <0,0,0>, <0,0,1>, 1.0 
          material { Litenin2 // semi-transperent .gif file
          }
          rotate 180.0*y
          hollow
        }  // end Litenin_Disc

#declare Lightning_OBJ = union 
        {      //  union light and Litenin_OBJ
        light_source { < 0, 0, 0>
             rgbt <1.0, 1.0, 1.0, 1.0>
             shadowless
             }  // end light_source
        object { Litenin_Disc }
        }  //  end Lightning_OBJ = union    

//                              //
//  SMOKE, CLOUDS, LIGHTNING    //
//  now, it gets interesting... //
#declare Volcano = union {
    object { Mt_Rainier 
        scale <1500, 1500, 200>
        rotate <-90, 0, 0>
        translate <1, 130, 1500>
      }
    object { Cloud7_Blb
        scale 10
        translate <200, 400, 1600>
      }
    object { Cloud4  // now with new, improved T_Cloud1
            scale <30,20,10> // Cloud4 is the low effluvium
            translate <-550, 200, 1550>
            } 
    object { Cloud4
            scale <20,18,10>
            rotate <90, 0, 5>
            translate <-1150, 200, 1300>
            }
        }  //  end union Volcano

//  Ejecta Cloud over Mt. Rainier 
//  union of overlapping cones; each with a cloud-like material
//
/* No longer used
#declare Cone_Cloud = union {
   cone  { 
    <1, 0, 0>, 1.0, <-2.5, 0, 0>, 2.0  // dragged by prevailing winds 
    material {  T_Cloud1
         scale <0.1, 1, 1.0 > // <0.40, 0.10, 10.1>
         rotate 90*x
         }
    scale <700, 50, 50> 
    rotate 6*z 
    translate <-700, 250, 1450>  
    }  
   cone  { <0, 0, 0>, 1.0, <0, 1, 0>, 2.0 //  high ejecta
      material { White_Cloud
        rotate 93*y
        }
    scale <80, 200, 80>  //  
    rotate <10, 0, 17>  // 
    translate <150, 300, 1450> 
    }

   cone { <0, 0, 0>, 1.0, <0, 2, 0>, 1.5 //  high high ejecta
      material { White_Cloud
        rotate 71*y
        }
    scale <50, 200, 50>  // 
    rotate <15, 0, 15> //
    translate <200, 250, 1450> 
    }

   cone { <0, 0, 0>, 1.0, <0, 2, 0>, 2.5   //  Low efluvium
      material {  White_Cloud
        rotate <0, 45, 0>
        }
    scale <50, 130, 50>  
    rotate <15, 25, 60>  
    translate <200, 300, 1450>   
   }
}  // end declare Cone_Cloud
*/ // end edit Cone_Cloud - no longer used
        
//
// end MyCity.Inc
//