/*************************************************************************
 CITY GENERATOR: MACRO FILE TEMPLATE

 This file includes basic examples of the macros required by the
 City Generator include file, including the required parameters for each
 macro.  See CTDesign.htm for more information, and City.mcr and the other
 sample files packaged with the City Include File for more examples.

**************************************************************************/

#macro city_base (Corner1, Corner2)
   polygon {5, Corner1, Corner1 * x + Corner2 * z, Corner2, Corner1 * z + Corner2 * x, Corner1
      pigment {rgb <0, 0, 1>}}
#end

#macro city_street (From, To, Direction)
   cylinder {Corner1, Corner2, street_width * .1 pigment {rgb <1, 1, 0>}}
#end

#macro city_pavement (Corner1, Corner2)
   box {Corner1, Corner2 + y pigment {rgb <0, 1, 0>}}
#end

#macro city_building (Corner1, Corner2, Direction)
   box {Corner1, Corner2 + y * 10 pigment {rgb <1, 0, 0>}}
#end

#macro city_finish ()
#end
