//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 36 materials and 3224 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1991-1999 Lutz + Kretzschmar
//

//  Date : 01/23/2000    (23.01.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.419608,0.419608,0.494118>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <    -41.246,     -18.847,       6.577>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34232,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         24.39576    // Vertical      18.297
  look_at   <     -1.840,       1.234,       2.117>
}

//
// *******  L I G H T S *******
//

light_source {   // Light004
  <0.0, 0.0, 0.0>
  color rgb <0.857, 0.829, 0.843>*2.3885
  translate  <-42.578736, -69.6653, 54.679033>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <0.429, 0.586, 0.957>*0.0617
  translate  <-565.494378, -402.503193, 472.596804>
}


//
// ********  MATERIALS  *******
//

#include "ng_loco_rusty.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Group221 = union {
  cylinder { // Cylndr901
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <-6.475071, -0.0, -0.0>
    translate  <-11.581437, -7.406063, -1.335849>
  }
  cylinder { // Cylndr902
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <0.130054, 5.046848, 0.011377>
    translate  <-11.581437, -7.406063, -1.359099>
  }
  cylinder { // Cylndr903
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <1.966705, -10.962799, 16.44072>
    translate  <-11.581437, -7.406063, -1.405599>
  }
  material {
    grass_green
  }
  scale <1.0, 0.9845, 0.659002>
  translate  <0.0, -0.116249, -0.402997>
}
#declare Group233 = union {
  object { // Group232->Group221
    Group221
    translate  <0.203355, 0.006779, -0.075874>
  }
  object { // Group231->Group221
    Group221
    rotate 10.786494*y
    translate  <0.21963, -0.081342, -2.243702>
  }
  object { // Group230->Group221
    Group221
    translate  <0.108456, -0.115235, 0.0>
  }
  object { // Group229->Group221
    Group221
    translate  <0.061007, -0.18302, 0.0>
  }
  object { // Group228->Group221
    Group221
    translate  <0.128792, 0.054228, 0.0>
  }
  object { // Group227->Group221
    Group221
    translate  <0.291476, -0.101678, 0.0>
  }
  object { // Group226->Group221
    Group221
    scale <1.0, 0.899251, 1.0775>
    translate  <0.172884, -0.952354, 0.158034>
  }
  object { // Group225->Group221
    Group221
    rotate -4.00393*z
    translate  <0.77275, -1.030334, 0.0>
  }
  object { // Group223->Group221
    Group221
    rotate 5.386655*x
    translate  <0.291476, -0.375754, 0.658745>
  }
  object { // Group222->Group221
    Group221
    translate  <0.020336, -0.101678, 0.0>
  }
  object { Group221 }
  translate  -0.201499*z
}
#declare Group256 = union {
  cylinder { // Cylndr904
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <-6.475071, -0.0, -0.0>
    translate  <-11.581437, -7.406063, -1.335849>
  }
  cylinder { // Cylndr905
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <0.130054, 5.046848, 0.011377>
    translate  <-11.581437, -7.406063, -1.359099>
  }
  cylinder { // Cylndr906
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <1.966705, -10.962799, 16.44072>
    translate  <-11.581437, -7.406063, -1.405599>
  }
  material {
    grass_green
  }
  scale <1.0, 0.9845, 0.659002>
  translate  <0.0, -0.116249, -0.402997>
}
#declare Group257 = union {
  object { // Group246->Group256
    Group256
    translate  <0.203355, 0.006779, -0.075874>
  }
  object { // Group247->Group256
    Group256
    rotate 10.786494*y
    translate  <0.21963, -0.081342, -2.243702>
  }
  object { // Group248->Group256
    Group256
    translate  <0.108456, -0.115235, 0.0>
  }
  object { // Group249->Group256
    Group256
    translate  <0.061007, -0.18302, 0.0>
  }
  object { // Group250->Group256
    Group256
    translate  <0.128792, 0.054228, 0.0>
  }
  object { // Group251->Group256
    Group256
    translate  <0.291476, -0.101678, 0.0>
  }
  object { // Group252->Group256
    Group256
    scale <1.0, 0.899251, 1.0775>
    translate  <0.172884, -0.952354, 0.158034>
  }
  object { // Group253->Group256
    Group256
    rotate -4.00393*z
    translate  <0.77275, -1.030334, 0.0>
  }
  object { // Group254->Group256
    Group256
    rotate 5.386655*x
    translate  <0.291476, -0.375754, 0.658745>
  }
  object { // Group255->Group256
    Group256
    translate  <0.020336, -0.101678, 0.0>
  }
  object { Group256 }
  rotate 72.504646*z
  translate  <-16.754086, 6.962737, -0.201499>
}
#declare Group300 = union {
  cylinder { // Cylndr908
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <-6.475071, -0.0, -0.0>
    translate  <-11.581437, -7.406063, -1.335849>
  }
  cylinder { // Cylndr909
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <0.130054, 5.046848, 0.011377>
    translate  <-11.581437, -7.406063, -1.359099>
  }
  cylinder { // Cylndr910
    <0,0,1>, <0,0,0>, 1 
    scale <0.012204, 0.00339, 0.606505>
    rotate <1.966705, -10.962799, 16.44072>
    translate  <-11.581437, -7.406063, -1.405599>
  }
  material {
    grass_green
  }
  scale <1.0, 0.9845, 0.659002>
  translate  <0.0, -0.116249, -0.402997>
}
#declare Group301 = union {
  object { // Group290->Group300
    Group300
    translate  <0.203355, 0.006779, -0.075874>
  }
  object { // Group291->Group300
    Group300
    rotate 10.786494*y
    translate  <0.21963, -0.081342, -2.243702>
  }
  object { // Group292->Group300
    Group300
    translate  <0.108456, -0.115235, 0.0>
  }
  object { // Group293->Group300
    Group300
    translate  <0.061007, -0.18302, 0.0>
  }
  object { // Group294->Group300
    Group300
    translate  <0.128792, 0.054228, 0.0>
  }
  object { // Group295->Group300
    Group300
    translate  <0.291476, -0.101678, 0.0>
  }
  object { // Group296->Group300
    Group300
    scale <1.0, 0.899251, 1.0775>
    translate  <0.172884, -0.952354, 0.158034>
  }
  object { // Group297->Group300
    Group300
    rotate -4.00393*z
    translate  <0.77275, -1.030334, 0.0>
  }
  object { // Group298->Group300
    Group300
    rotate 5.386655*x
    translate  <0.291476, -0.375754, 0.658745>
  }
  object { // Group299->Group300
    Group300
    translate  <0.020336, -0.101678, 0.0>
  }
  object { Group300 }
  rotate -3.944891*z
  translate  <0.482699, 10.505723, -0.201499>
}
#declare CSG438 = union {
  box { // Cube945
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube946
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube986
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube987
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube988
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube989
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG439 = difference {
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG438 }
}
#declare nut127 = union {
  object { CSG439 }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG440 = union {
  box { // Cube990
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube991
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube992
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube993
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube994
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube995
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG441 = difference {
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG440 }
}
#declare nut132 = union {
  object { CSG441 }
  cylinder { // Cylndr755
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare CSG446 = union {
  box { // Cube1008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG447 = difference {
  cylinder { // Cylndr808
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG446 }
}
#declare nut138 = union {
  object { CSG447 }
  cylinder { // Cylndr809
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG448 = union {
  box { // Cube1014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG449 = difference {
  cylinder { // Cylndr810
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG448 }
}
#declare nut143 = union {
  object { CSG449 }
  cylinder { // Cylndr811
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare CSG001 = union {
  cone { // Cone001
    <0,0,0>, 0.952, <0,0,1>, 0.97
    scale <1.0, 1.0, 0.184541>
    rotate <180.0, 0.0, 180.0>
    translate  0.207207*z
  }
  superellipsoid { // SuperQ001
    <1.0, 0.154>
    material {
      Wheel_stl
    }
    scale <1.007, 1.007, 0.02311>
  }
}
#declare wheel_rim = difference {
  object { CSG001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.774885, 0.774885, 0.254257>
    translate  -0.040105*z
  }
  material {
    chassis_black
  }
}
#declare Outer_wheel = union {
  cone { // Cone006
    <0,0,0>, 0.952, <0,0,1>, 0.971
    open
    material {
      Wheel_stl
    }
    scale <1.0, 1.0, 0.184541>
    rotate <-180.0, 0.0, -180.0>
    translate  0.207207*z
  }
  object { wheel_rim }
}
#declare wheel_spoke = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone002
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone003
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke1 = union {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone004
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone005
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 36.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke2 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone007
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone008
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 72.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke3 = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone009
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone010
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -36.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke4 = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone012
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -72.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke5 = union {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone013
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone014
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 108.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke6 = union {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone016
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -108.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke7 = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone017
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone018
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 144.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke8 = union {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone019
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone020
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -144.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke9 = union {
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone021
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone022
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -180.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare Spoke_ring = union {
  object { wheel_spoke }
  object { wheel_spoke1 }
  object { wheel_spoke2 }
  object { wheel_spoke3 }
  object { wheel_spoke4 }
  object { wheel_spoke5 }
  object { wheel_spoke6 }
  object { wheel_spoke7 }
  object { wheel_spoke8 }
  object { wheel_spoke9 }
  scale <1.0, 1.0, 1.826589>
}
#declare Inner_rim = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.81632, 0.81632, 0.230229>
    translate  -0.021293*z
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.766155, 0.766155, 0.277396>
    translate  -0.052647*z
  }
  material {
    chassis_black_2
  }
  scale <0.95, 0.95, 1.0>
}
#declare CSG002 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.730687, 1.019744, 0.104602>
    translate  <-0.499322, -0.014962, 0.11256>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.565725, 1.081908, 0.195183>
    translate  <-0.052366, 0.0, 0.01876>
  }
}
#declare counter_wt = difference {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.85, 0.85, 0.157663>
    translate  0.03752*z
  }
  object { CSG002 }
  scale <1.0, 1.0, 0.936944>
  translate  0.006921*z
}
#declare CSG003 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175893, 0.087163, 0.134687>
    rotate 22.243254*z
    translate  <-0.267467, 0.101051, 0.112867>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.285143, 0.285143, 0.26006>
    translate  -0.012541*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.131103, 0.131103, 0.259732>
    translate  <-0.400504, 0.0, -0.012541>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175893, 0.087163, 0.134687>
    rotate -22.54694*z
    translate  <-0.267467, -0.101105, 0.112867>
  }
}
#declare Wheel_hub = difference {
  object { CSG003 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      chassis_black
    }
    scale <0.121682, 0.121682, 0.039147>
    translate  0.224815*z
  }
  scale <0.932672, 0.932672, 0.77752>
  translate  0.025376*z
}
#declare CSG005 = difference {
  torus { // Torus001
    1.95, 0.05  rotate -x*90
    scale 0.13826
    translate  0.217957*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.09418, 0.280006, 0.019565>
    translate  <-0.224414, -0.008171, 0.214395>
  }
}
#declare CSG004 = difference {
  torus { // Torus002
    1.8965, 0.1035  rotate -x*90
    scale 0.064983
    translate  <-0.373298, 0.0, 0.217957>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.092045, 0.15616, 0.019565>
    translate  <-0.326907, -0.001766, 0.214395>
  }
}
#declare hub_chamfer = union {
  object { CSG005 }
  object { CSG004 }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.008579, 0.008579, 0.325>
    rotate <-90.0, 0.0, -67.152626>
    translate  <-0.433318, 0.105453, 0.21595>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.008579, 0.008579, 0.325>
    rotate <-90.0, 0.0, 67.152634>
    translate  <-0.133309, -0.232057, 0.21595>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.399465, 0.297964, 0.002966>
    translate  <-0.120258, 0.002603, 0.218545>
  }
  material {
    Wheel_rim_hubface
  }
}
#declare CSG007 = difference {
  object { Wheel_hub }
  object { hub_chamfer }
}
#declare Inner_wheel = union {
  object { Spoke_ring }
  object { Inner_rim }
  object { counter_wt }
  object { CSG007 }
  material {
    chassis_black_2
  }
}
#declare Drive_wheel = union {
  object { Outer_wheel }
  object { Inner_wheel }
  rotate 90.0*x
}
#declare CSG006 = union {
  cone { // Cone015
    <0,0,0>, 0.952, <0,0,1>, 0.97
    scale <1.0, 1.0, 0.184541>
    rotate <180.0, 0.0, 180.0>
    translate  0.207207*z
  }
  superellipsoid { // SuperQ002
    <1.0, 0.154>
    material {
      Wheel_stl
    }
    scale <1.007, 1.007, 0.02311>
  }
}
#declare wheel_rim1 = difference {
  object { CSG006 }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.774885, 0.774885, 0.254257>
    translate  -0.040105*z
  }
  material {
    chassis_black
  }
}
#declare Outer_wheel1 = union {
  cone { // Cone011
    <0,0,0>, 0.952, <0,0,1>, 0.971
    open
    material {
      Wheel_stl
    }
    scale <1.0, 1.0, 0.184541>
    rotate <-180.0, 0.0, -180.0>
    translate  0.207207*z
  }
  object { wheel_rim1 }
}
#declare wheel_spoke10 = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone023
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone024
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke11 = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone025
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone026
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 36.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke12 = union {
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone027
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone028
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 72.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke13 = union {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone029
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone030
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -36.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke14 = union {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone031
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -72.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke15 = union {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone032
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone033
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 108.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke16 = union {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone034
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -108.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke17 = union {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone035
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone036
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, 0.0, 144.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke18 = union {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone037
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone038
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -144.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare wheel_spoke19 = union {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.054332, 0.054332, 0.260001>
    rotate -90.0*x
    translate  <0.0, 0.405175, 0.09546>
  }
  cone { // Cone039
    <0,0,0>, 0.054, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.126367>
    rotate -90.0*x
    translate  <-0.000361, 0.662369, 0.096742>
  }
  cone { // Cone040
    <0,0,0>, 0.054, <0,0,1>, 0.064
    scale <1.0, 1.0, 0.179392>
    rotate 90.0*x
    translate  <-0.000361, 0.40482, 0.095438>
  }
  scale <0.753742, 1.0, 0.718809>
  rotate <0.0, -0.0, -180.0>
  translate  <0.0, -0.011888, -0.005878>
}
#declare Spoke_ring1 = union {
  object { wheel_spoke10 }
  object { wheel_spoke11 }
  object { wheel_spoke12 }
  object { wheel_spoke13 }
  object { wheel_spoke14 }
  object { wheel_spoke15 }
  object { wheel_spoke16 }
  object { wheel_spoke17 }
  object { wheel_spoke18 }
  object { wheel_spoke19 }
  scale <1.0, 1.0, 1.826589>
}
#declare Inner_rim1 = difference {
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.81632, 0.81632, 0.230229>
    translate  -0.021293*z
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.766155, 0.766155, 0.277396>
    translate  -0.052647*z
  }
  material {
    chassis_black_2
  }
  scale <0.95, 0.95, 1.0>
}
#declare CSG008 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.730687, 1.019744, 0.104602>
    translate  <-0.499322, -0.014962, 0.11256>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.565725, 1.081908, 0.195183>
    translate  <-0.052366, 0.0, 0.01876>
  }
}
#declare counter_wt1 = difference {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.85, 0.85, 0.157663>
    translate  0.03752*z
  }
  object { CSG008 }
  scale <1.0, 1.0, 0.936944>
  translate  0.006921*z
}
#declare CSG009 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175893, 0.087163, 0.134687>
    rotate 22.243254*z
    translate  <-0.267467, 0.101051, 0.112867>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.285143, 0.285143, 0.26006>
    translate  -0.012541*z
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.131103, 0.131103, 0.259732>
    translate  <-0.400504, 0.0, -0.012541>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.175893, 0.087163, 0.134687>
    rotate -22.54694*z
    translate  <-0.267467, -0.101105, 0.112867>
  }
}
#declare Wheel_hub1 = difference {
  object { CSG009 }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      chassis_black
    }
    scale <0.121682, 0.121682, 0.039147>
    translate  0.224815*z
  }
  scale <0.932672, 0.932672, 0.77752>
  translate  0.025376*z
}
#declare CSG010 = difference {
  torus { // Torus003
    1.95, 0.05  rotate -x*90
    scale 0.13826
    translate  0.217957*z
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.09418, 0.280006, 0.019565>
    translate  <-0.224414, -0.008171, 0.214395>
  }
}
#declare CSG011 = difference {
  torus { // Torus004
    1.8965, 0.1035  rotate -x*90
    scale 0.064983
    translate  <-0.373298, 0.0, 0.217957>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.092045, 0.15616, 0.019565>
    translate  <-0.326907, -0.001766, 0.214395>
  }
}
#declare hub_chamfer1 = union {
  object { CSG010 }
  object { CSG011 }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.008579, 0.008579, 0.325>
    rotate <-90.0, 0.0, -67.152626>
    translate  <-0.433318, 0.105453, 0.21595>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.008579, 0.008579, 0.325>
    rotate <-90.0, 0.0, 67.152634>
    translate  <-0.133309, -0.232057, 0.21595>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.399465, 0.297964, 0.002966>
    translate  <-0.120258, 0.002603, 0.218545>
  }
  material {
    Wheel_rim_hubface
  }
}
#declare CSG012 = difference {
  object { Wheel_hub1 }
  object { hub_chamfer1 }
}
#declare Inner_wheel1 = union {
  object { Spoke_ring1 }
  object { Inner_rim1 }
  object { counter_wt1 }
  object { CSG012 }
  material {
    chassis_black_2
  }
}
#declare Drive_wheel1 = union {
  object { Outer_wheel1 }
  object { Inner_wheel1 }
  rotate <-90.0, -90.0, -0.0>
  translate  2.000636*y
}
#declare Group001 = union {
  object { Drive_wheel }
  object { Drive_wheel1 }
  cylinder { // Axle
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_stl
    }
    scale <0.100091, 0.100091, 2.135461>
    rotate -90.0*x
    translate  -0.078283*y
  }
}
#declare BezPtch015 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -76.06208>
}
#declare BezPtch016 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch017 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 56.643337>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant4 = union {
  object { BezPtch015 }
  object { BezPtch016 }
  object { BezPtch017 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch018 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <108.056717, -260.997742, 71.643974>
  translate  <0.372041, 0.649665, 0.0>
}
#declare BezPtch019 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-122.805573, -259.486572, -294.203705>
  translate  <0.364892, 0.474233, 0.0>
}
#declare BezPtch020 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 39.375076>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant5 = union {
  object { BezPtch018 }
  object { BezPtch019 }
  object { BezPtch020 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant6 = union {
  object { ngplant4 }
  object { ngplant5 }
  scale 0.555056
  translate  <-0.951709, -4.892582, -0.638398>
}
#declare plant9 = object {
  object { // plant9->plant6
    plant6
    scale 2.808795
    rotate <-0.0, -0.0, 0.0>
    translate  <16.413873, 2.935039, 2.514903>
  }
}
#declare BezPtch009 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch010 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch011 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant2 = union {
  object { BezPtch009 }
  object { BezPtch010 }
  object { BezPtch011 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch012 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch013 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch014 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant3 = union {
  object { BezPtch012 }
  object { BezPtch013 }
  object { BezPtch014 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant3 = union {
  object { ngplant2 }
  object { ngplant3 }
  scale 1.000015
  rotate -0.233884*z
  translate  <13.388714, -1.904797, 0.0>
  scale 1.337026
  rotate -73.362717*z
  translate  <-11.833827, -0.377675, 0.396581>
}
#declare BezPtch003 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch004 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch005 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant = union {
  object { BezPtch003 }
  object { BezPtch004 }
  object { BezPtch005 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch006 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch007 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch008 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant1 = union {
  object { BezPtch006 }
  object { BezPtch007 }
  object { BezPtch008 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant = union {
  object { ngplant }
  object { ngplant1 }
}
#declare plant1 = object {
  object { // plant1->plant
    plant
    scale 0.808775
    rotate 68.37188*z
    translate  <-7.724691, 10.953665, -0.250091>
  }
}
#declare BezPtch045 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -76.06208>
}
#declare BezPtch046 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch047 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 56.643337>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant14 = union {
  object { BezPtch045 }
  object { BezPtch046 }
  object { BezPtch047 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch048 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <108.056717, -260.997742, 71.643974>
  translate  <0.372041, 0.649665, 0.0>
}
#declare BezPtch049 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-122.805573, -259.486572, -294.203705>
  translate  <0.364892, 0.474233, 0.0>
}
#declare BezPtch050 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 39.375076>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant15 = union {
  object { BezPtch048 }
  object { BezPtch049 }
  object { BezPtch050 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant14 = union {
  object { ngplant14 }
  object { ngplant15 }
  scale -1.218245
  rotate <-0.0, 0.0, 10.420547>
  translate  <-16.401796, -0.656024, 0.0>
  scale -0.662331
  rotate <0.0, -0.0, 71.378166>
  translate  <-6.076865, -2.589547, -0.266656>
}
#declare BezPtch051 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -76.06208>
}
#declare BezPtch052 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch053 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 56.643337>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant16 = union {
  object { BezPtch051 }
  object { BezPtch052 }
  object { BezPtch053 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch054 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <108.056717, -260.997742, 71.643974>
  translate  <0.372041, 0.649665, 0.0>
}
#declare BezPtch055 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-122.805573, -259.486572, -294.203705>
  translate  <0.364892, 0.474233, 0.0>
}
#declare BezPtch056 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 39.375076>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant17 = union {
  object { BezPtch054 }
  object { BezPtch055 }
  object { BezPtch056 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant17 = union {
  object { ngplant16 }
  object { ngplant17 }
  scale 0.555056
  rotate -2.088957*z
  translate  <1.155974, -7.602461, -0.638398>
}
#declare plant18 = object {
  object { // plant18->plant17
    plant17
    scale 1.208559
    rotate <0.0, 0.0, -0.0>
    translate  <0.344112, -1.745759, 0.341278>
  }
}


#declare CSG532 = difference {
  cylinder { // Cylndr868
    <0,0,1>, <0,0,0>, 1 
    scale <10.20547, 11.652459, 0.227052>
    rotate <0.0, -90.0, 0.0>
    translate  <-18.5128, 21.967314, 4.55107>
  }
  cylinder { // Cylndr869
    <0,0,1>, <0,0,0>, 1 
    scale <8.713902, 9.949408, 0.85872>
    rotate <0.0, -90.0, 0.0>
    translate  <-18.217881, 21.967314, 4.55107>
  }
  box { // Cube1112
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 12.089528, 5.202347>
    translate  <-18.700776, 21.960979, -0.642025>
  }
  material {
    eave_colour
  }
}
#declare CSG533 = union {
  box { // Cube1113
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.216218, 0.561284, 19.530573>
    translate  <-18.542665, 22.569946, -4.387841>
  }
  box { // Cube1114
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.10604, 0.845961, 19.530573>
    translate  <-18.619648, 24.013674, -4.387841>
  }
  box { // Cube1115
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.10604, 0.845961, 19.530573>
    translate  <-18.619648, 25.752969, -4.387841>
  }
  box { // Cube1116
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.10604, 0.845961, 19.530573>
    translate  <-18.619648, 27.492263, -4.387841>
  }
  box { // Cube1117
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.10604, 0.845961, 19.530573>
    translate  <-18.619648, 29.256135, -4.387841>
  }
  box { // Cube1118
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.10604, 0.845961, 19.530573>
    translate  <-18.619648, 31.00336, -4.387841>
  }
  box { // Cube1119
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.115039, 0.845961, 19.530573>
    translate  <-18.625048, 32.7645, -4.387841>
  }
}
#declare CSG534 = difference {
  box { // Cube1120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.251976, 6.970228, 5.45777>
    translate  <-18.632905, 27.737945, 10.029983>
  }
  cylinder { // Cylndr870
    <0,0,1>, <0,0,0>, 1 
    scale <10.210197, 11.657857, 0.924977>
    rotate <-0.0, -90.0, 0.0>
    translate  <-18.19732, 21.967314, 4.55107>
  }
}
#declare CSG535 = difference {
  object { CSG533 }
  object { CSG534 }
}
#declare CSG536 = union {
  object { CSG532 }
  object { CSG535 }
}
#declare CSG537 = difference {
  object { CSG536 }
  box { // Cube1121
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 11.316885, 6.120188>
    rotate -90.0*x
    translate  <-18.700776, 15.815152, 4.533474>
  }
  material {
    eave_colour
  }
}
#declare hinge = union {
  cylinder { // Cylndr871
    <0,0,1>, <0,0,0>, 1 
    scale <0.176551, 0.176551, 0.878905>
    translate  <-18.1139, 33.983109, 2.036296>
  }
  sphere { // Sphere620
    <0,0,0>,1
    scale <0.072396, 0.174414, 0.174414>
    translate  <-18.192418, 28.372809, 2.470463>
  }
  cylinder { // Cylndr872
    <0,0,1>, <0,0,0>, 1 
    scale <0.092621, 0.333311, 6.411612>
    rotate -90.0*x
    translate  <-18.2807, 27.553663, 2.462551>
  }
  sphere { // Sphere621
    <0,0,0>,1
    scale <0.072396, 0.174414, 0.174414>
    translate  <-18.192418, 29.848251, 2.470463>
  }
  sphere { // Sphere622
    <0,0,0>,1
    scale <0.072396, 0.174414, 0.174414>
    translate  <-18.192418, 31.427841, 2.470463>
  }
  sphere { // Sphere623
    <0,0,0>,1
    scale <0.072396, 0.174414, 0.174414>
    translate  <-18.192418, 32.868566, 2.470463>
  }
  material {
    rough_black
  }
}
#declare hinges = union {
  object { // hinge2->hinge
    hinge
    translate  -25.497627*z
  }
  object { // hinge1->hinge
    hinge
    translate  -12.735414*z
  }
  object { hinge }
}
#declare sheddoor = union {
  object { CSG537 }
  box { // Cube1122
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.115039, 0.845961, 5.761714>
    rotate <-90.0, -0.0, 0.0>
    translate  <-18.400736, 27.784587, -23.069784>
  }
  box { // Cube1123
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.115039, 0.845961, 5.761714>
    rotate <-90.0, -0.0, 0.0>
    translate  <-18.400736, 27.784587, 2.447706>
  }
  box { // Cube1124
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.115039, 0.845961, 5.761714>
    rotate <-90.0, -0.0, 0.0>
    translate  <-18.400736, 27.784587, -10.298337>
  }
  box { // Cube1125
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.102159, 0.845961, 7.85>
    rotate <-39.493099, -0.0, -0.0>
    translate  <-18.413617, 27.784587, -16.729349>
  }
  box { // Cube1126
    <-1, -1, -1>, <1, 1, 1>
    material {
      eave_colour
    }
    scale <0.102159, 0.845961, 7.85>
    rotate <39.493099, -0.0, -0.0>
    translate  <-18.413617, 27.784587, -3.930595>
  }
  object { hinges }
  scale 0.25
  rotate 180.0*z
  translate  <5.597324, 6.403598, 5.077903>
}
#declare CSG403 = difference {
  superellipsoid { // SuperQ048
    <0.1, 0.1>
    scale <1.411567, 2.252924, 1.67889>
    translate  <-18.173298, 21.952151, 16.346877>
  }
  box { // Cube871
    <-1, -1, -1>, <1, 1, 1>
    scale <1.518838, 0.328759, 1.93751>
    rotate 7.405995*x
    translate  <-18.186458, 19.572616, 16.09304>
  }
  box { // Cube873
    <-1, -1, -1>, <1, 1, 1>
    scale <1.518838, 0.328759, 1.93751>
    rotate -7.406*x
    translate  <-18.186458, 24.291219, 16.09304>
  }
  material {
    RoughStone_1
  }
  translate  -0.131989*z
}
#declare CSG410 = object {
  object { // CSG410->CSG403
    CSG403
    scale <1.0, 0.736022, 0.802017>
    rotate 14.475951*x
    translate  <0.0, 5.992946, -1.142702>
  }
}
#declare Group178 = union {
  object { // CSG405->CSG410
    CSG410
    rotate 72.845627*x
    translate  <0.0, 18.290575, -17.716432>
  }
  object { // CSG406->CSG410
    CSG410
    rotate 55.868748*x
    translate  <0.0, 12.057016, -16.349423>
  }
  object { // CSG407->CSG410
    CSG410
    rotate 41.200573*x
    translate  <0.0, 7.337158, -13.45976>
  }
  object { // CSG408->CSG410
    CSG410
    rotate 27.127686*x
    translate  <0.0, 3.681749, -9.534172>
  }
  object { // CSG409->CSG410
    CSG410
    rotate 13.112891*x
    translate  <0.0, 1.127311, -4.869024>
  }
  object { CSG410 }
  material {
    RoughStone
  }
}
#declare SuperQ049 = object {
  superellipsoid { // SuperQ049
    <0.1, 0.1>
    scale <1.411567, 1.563807, 1.67889>
    translate  <-18.173298, 10.262441, -22.181707>
  }
}
#declare Group183 = union {
  object { SuperQ049 }
  object { // SuperQ050->SuperQ049
    SuperQ049
    scale <1.0, 0.568167, 0.625744>
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 5.095635, -5.585046>
  }
  material {
    RoughStone_1
  }
}
#declare Group184 = union {
  object { // Group179->Group183
    Group183
    translate  21.636492*z
  }
  object { // Group180->Group183
    Group183
    translate  16.192916*z
  }
  object { // Group181->Group183
    Group183
    translate  10.74934*z
  }
  object { // Group182->Group183
    Group183
    translate  5.37467*z
  }
  object { Group183 }
  translate  -1.580185*y
}
#declare CSG478 = difference {
  superellipsoid { // SuperQ067
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 71.911987*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  box { // Cube954
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube955
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -71.911987*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG479 = difference {
  superellipsoid { // SuperQ068
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 96.705101*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  box { // Cube956
    <-1, -1, -1>, <1, 1, 1>
    scale <0.387382, 0.583655, 0.233325>
    rotate 7.34592*z
    translate  <0.368401, 2.264692, 0.0>
  }
  box { // Cube957
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -96.705101*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG480 = difference {
  superellipsoid { // SuperQ069
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 47.252335*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  box { // Cube958
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube959
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -47.252335*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG481 = difference {
  superellipsoid { // SuperQ070
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 22.534182*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  box { // Cube960
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube961
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -22.534182*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG482 = union {
  object { CSG478 }
  object { CSG479 }
  object { CSG480 }
  object { CSG481 }
}
#declare CSG493 = difference {
  superellipsoid { // SuperQ075
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 71.911987*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  box { // Cube973
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube974
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -71.911987*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG494 = difference {
  superellipsoid { // SuperQ076
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 96.705101*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  box { // Cube975
    <-1, -1, -1>, <1, 1, 1>
    scale <0.387382, 0.583655, 0.233325>
    rotate 7.34592*z
    translate  <0.368401, 2.264692, 0.0>
  }
  box { // Cube976
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -96.705101*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG495 = difference {
  superellipsoid { // SuperQ077
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 47.252335*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  box { // Cube977
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube978
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -47.252335*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG496 = difference {
  superellipsoid { // SuperQ078
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <-0.178836, -0.28502, 0.0>
      rotate 22.534182*z
      scale <1.0/0.821164, 1.0/0.843519, 1.0/1.0>
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  box { // Cube979
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -13.152984*z
    translate  <0.603571, 2.246625, 0.0>
  }
  box { // Cube980
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 13.15298*z
    translate  <-0.603571, 2.246625, 0.0>
  }
  scale <0.821164, 0.843519, 1.0>
  rotate -22.534182*z
  translate  <0.178836, 0.28502, 0.0>
}
#declare CSG497 = union {
  object { CSG493 }
  object { CSG494 }
  object { CSG495 }
  object { CSG496 }
}
#declare Group224 = union {
  superellipsoid { // SuperQ095
    <0.1, 0.1>
    scale <0.236834, 0.039927, 0.133071>
    translate  <-11.274804, 5.095585, 2.041439>
  }
  torus { // Torus102
    1.5, 0.5  rotate -x*90
    scale 0.062639
    translate  <-11.274961, 5.010418, 2.114872>
  }
  torus { // Torus113
    1.5, 0.5  rotate -x*90
    scale 0.062639
    translate  <-11.274961, 5.010418, 1.962277>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.041313
    translate  <-11.0925, 5.055469, 2.038596>
  }
  sphere { // Sphere624
    <0,0,0>,1
    scale 0.041313
    translate  <-11.449804, 5.055469, 2.038596>
  }
  translate  -1.810122*z
}


#declare Rail = union {
  box { // Cube797
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    translate  <-1.326996, -0.117646, -1.122423>
  }
  cylinder { // Cylndr689
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.036589, 0.083815, 16.548485>
    rotate 90.0*y
    translate  <-9.597166, -0.121538, -1.004851>
  }
  box { // Cube798
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    rotate -90.0*x
    translate  <-1.326996, -0.117646, -1.211548>
  }
}
#declare Rail1 = union {
  box { // Cube799
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    translate  <-1.326996, -0.117646, -1.122423>
  }
  cylinder { // Cylndr690
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.036589, 0.083815, 16.548485>
    rotate 90.0*y
    translate  <-9.597166, -0.121538, -1.004851>
  }
  box { // Cube800
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    rotate -90.0*x
    translate  <-1.326996, -0.117646, -1.211548>
  }
  translate  2.242396*y
}
#declare Rails = union {
  object { Rail }
  object { Rail1 }
  material {
    chassis_black
  }
}
#declare SuperQ028 = object {
  superellipsoid { // SuperQ028
    <0.068, 0.05>
    scale <0.430396, 1.817052, 0.064077>
    translate  <-8.719325, 1.003216, -1.314844>
  }
}
#declare sleepers = union {
  object { // SuperQ035->SuperQ028
    SuperQ028
    translate  <14.0, 0.0, 0.0>
  }
  object { // SuperQ034->SuperQ028
    SuperQ028
    translate  <12.0, 0.0, 0.0>
  }
  object { // SuperQ033->SuperQ028
    SuperQ028
    translate  <10.0, 0.0, 0.0>
  }
  object { // SuperQ032->SuperQ028
    SuperQ028
    translate  <8.0, 0.0, 0.0>
  }
  object { // SuperQ031->SuperQ028
    SuperQ028
    translate  <6.0, 0.0, 0.0>
  }
  object { // SuperQ030->SuperQ028
    SuperQ028
    translate  <4.0, 0.0, 0.0>
  }
  object { // SuperQ029->SuperQ028
    SuperQ028
    translate  <2.0, 0.0, 0.0>
  }
  object { SuperQ028 }
  material {
    Sleeper_Colour
  }
}
#declare CSG372 = union {
  superellipsoid { // SuperQ037
    <1.0, 0.1>
    scale <0.057876, 0.075919, 0.07231>
    rotate <90.0, -76.648361, -90.0>
    translate  <-8.719939, -0.220126, -1.130313>
  }
  superellipsoid { // SuperQ036
    <0.1, 0.1>
    scale <0.226337, 0.205306, 0.012152>
    translate  <-8.727804, -0.130412, -1.237225>
  }
  superellipsoid { // SuperQ038
    <0.1, 0.1>
    scale <0.080691, 0.044091, 0.057073>
    translate  <-8.719939, -0.250759, -1.183095>
  }
  superellipsoid { // SuperQ039
    <0.1, 0.1>
    scale <0.080691, 0.01241, 0.059336>
    rotate <66.28595, 0.0, 0.0>
    translate  <-8.719939, -0.015417, -1.189884>
  }
  material {
    Wheel_stl
  }
}
#declare CSG373 = union {
  box { // Cube801
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube802
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube803
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube804
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube805
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube806
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG374 = difference {
  cylinder { // Cylndr692
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG373 }
}
#declare nut104 = union {
  object { CSG374 }
  cylinder { // Cylndr693
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, -0.17599, -2.140404>
}
#declare CSG375 = union {
  box { // Cube807
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube808
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube809
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube810
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube811
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube812
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG376 = difference {
  cylinder { // Cylndr694
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG375 }
}
#declare nut105 = union {
  object { CSG376 }
  cylinder { // Cylndr695
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, -0.17599, -2.140404>
}
#declare CSG377 = union {
  box { // Cube813
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube814
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube815
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube816
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube817
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube818
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG378 = difference {
  cylinder { // Cylndr696
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG377 }
}
#declare nut106 = union {
  object { CSG378 }
  cylinder { // Cylndr697
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, 0.102347, -2.140404>
}
#declare CSG379 = union {
  box { // Cube819
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube820
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube821
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube822
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube823
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube824
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG380 = difference {
  cylinder { // Cylndr698
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG379 }
}
#declare nut107 = union {
  object { CSG380 }
  cylinder { // Cylndr699
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, 0.10461, -2.140404>
}
#declare CSG381 = union {
  box { // Cube825
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube826
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube827
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube828
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube829
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube830
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG382 = difference {
  cylinder { // Cylndr700
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG381 }
}
#declare nut108 = union {
  object { CSG382 }
  cylinder { // Cylndr701
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.484246
  rotate <-25.911886, -0.0, -0.0>
  translate  <-5.358172, -0.213223, -1.754731>
}
#declare Group149 = union {
  object { nut104 }
  object { nut105 }
  object { nut106 }
  object { nut107 }
  object { nut108 }
}
#declare Group158 = union {
  object { CSG372 }
  object { Group149 }
}
#declare Group150 = union {
  object { // Group165->Group158
    Group158
    translate  14.0*x
  }
  object { // Group164->Group158
    Group158
    translate  12.0*x
  }
  object { // Group163->Group158
    Group158
    translate  10.0*x
  }
  object { // Group162->Group158
    Group158
    translate  8.0*x
  }
  object { // Group161->Group158
    Group158
    translate  6.0*x
  }
  object { // Group160->Group158
    Group158
    translate  4.0*x
  }
  object { // Group159->Group158
    Group158
    translate  2.0*x
  }
  object { Group158 }
}
#declare CSG383 = union {
  superellipsoid { // SuperQ040
    <1.0, 0.1>
    scale <0.057876, 0.075919, 0.07231>
    rotate <90.0, -76.648361, -90.0>
    translate  <-8.719939, -0.220126, -1.130313>
  }
  superellipsoid { // SuperQ041
    <0.1, 0.1>
    scale <0.226337, 0.205306, 0.012152>
    translate  <-8.727804, -0.130412, -1.237225>
  }
  superellipsoid { // SuperQ042
    <0.1, 0.1>
    scale <0.080691, 0.044091, 0.057073>
    translate  <-8.719939, -0.250759, -1.183095>
  }
  superellipsoid { // SuperQ043
    <0.1, 0.1>
    scale <0.080691, 0.01241, 0.059336>
    rotate <66.28595, 0.0, 0.0>
    translate  <-8.719939, -0.015417, -1.189884>
  }
  material {
    Wheel_stl
  }
}
#declare CSG384 = union {
  box { // Cube831
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube832
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube833
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube834
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube835
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube836
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG385 = difference {
  cylinder { // Cylndr702
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG384 }
}
#declare nut109 = union {
  object { CSG385 }
  cylinder { // Cylndr703
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, -0.17599, -2.140404>
}
#declare CSG386 = union {
  box { // Cube837
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube838
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube839
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube840
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube841
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube842
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG387 = difference {
  cylinder { // Cylndr704
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG386 }
}
#declare nut110 = union {
  object { CSG387 }
  cylinder { // Cylndr705
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, -0.17599, -2.140404>
}
#declare CSG388 = union {
  box { // Cube843
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube844
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube845
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube846
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube847
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube848
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG389 = difference {
  cylinder { // Cylndr706
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG388 }
}
#declare nut111 = union {
  object { CSG389 }
  cylinder { // Cylndr707
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, 0.102347, -2.140404>
}
#declare CSG390 = union {
  box { // Cube849
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube850
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube851
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube852
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube853
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube854
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG391 = difference {
  cylinder { // Cylndr708
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG390 }
}
#declare nut112 = union {
  object { CSG391 }
  cylinder { // Cylndr709
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, 0.10461, -2.140404>
}
#declare CSG392 = union {
  box { // Cube855
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube856
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube857
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube858
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube859
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube860
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG393 = difference {
  cylinder { // Cylndr710
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG392 }
}
#declare nut113 = union {
  object { CSG393 }
  cylinder { // Cylndr711
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.484246
  rotate <-25.911886, -0.0, -0.0>
  translate  <-5.358172, -0.213223, -1.754731>
}
#declare Group151 = union {
  object { nut109 }
  object { nut110 }
  object { nut111 }
  object { nut112 }
  object { nut113 }
}
#declare Group175 = union {
  object { CSG383 }
  object { Group151 }
}
#declare Group152 = union {
  object { // Group168->Group175
    Group175
    translate  14.0*x
  }
  object { // Group169->Group175
    Group175
    translate  12.0*x
  }
  object { // Group170->Group175
    Group175
    translate  10.0*x
  }
  object { // Group171->Group175
    Group175
    translate  8.0*x
  }
  object { // Group172->Group175
    Group175
    translate  6.0*x
  }
  object { // Group173->Group175
    Group175
    translate  4.0*x
  }
  object { // Group174->Group175
    Group175
    translate  2.0*x
  }
  object { Group175 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.0066*y
}
#declare Track = union {
  object { Rails }
  object { sleepers }
  object { Group150 }
  object { Group152 }
  translate  4.656552*x
}
#declare SuperQ058 = object {
  superellipsoid { // SuperQ058
    <0.068, 0.05>
    scale <0.430396, 1.817052, 0.064077>
    translate  <-8.719325, 1.003216, -1.314844>
  }
}
#declare CSG411 = union {
  superellipsoid { // SuperQ059
    <1.0, 0.1>
    scale <0.057876, 0.075919, 0.07231>
    rotate <90.0, -76.648361, -90.0>
    translate  <-8.719939, -0.220126, -1.130313>
  }
  superellipsoid { // SuperQ060
    <0.1, 0.1>
    scale <0.226337, 0.205306, 0.012152>
    translate  <-8.727804, -0.130412, -1.237225>
  }
  superellipsoid { // SuperQ061
    <0.1, 0.1>
    scale <0.080691, 0.044091, 0.057073>
    translate  <-8.719939, -0.250759, -1.183095>
  }
  superellipsoid { // SuperQ062
    <0.1, 0.1>
    scale <0.080691, 0.01241, 0.059336>
    rotate <66.28595, 0.0, 0.0>
    translate  <-8.719939, -0.015417, -1.189884>
  }
  material {
    Wheel_stl
  }
}
#declare CSG412 = union {
  box { // Cube878
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube879
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube880
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube881
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube882
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube883
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG413 = difference {
  cylinder { // Cylndr729
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG412 }
}
#declare nut114 = union {
  object { CSG413 }
  cylinder { // Cylndr730
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, -0.17599, -2.140404>
}
#declare CSG414 = union {
  box { // Cube884
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube885
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube886
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube887
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube888
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube889
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG415 = difference {
  cylinder { // Cylndr731
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG414 }
}
#declare nut115 = union {
  object { CSG415 }
  cylinder { // Cylndr732
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, -0.17599, -2.140404>
}
#declare CSG416 = union {
  box { // Cube890
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube891
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube892
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube893
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube894
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube895
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG417 = difference {
  cylinder { // Cylndr733
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG416 }
}
#declare nut116 = union {
  object { CSG417 }
  cylinder { // Cylndr734
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, 0.102347, -2.140404>
}
#declare CSG418 = union {
  box { // Cube896
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube897
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube898
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube899
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube900
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube901
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG419 = difference {
  cylinder { // Cylndr735
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG418 }
}
#declare nut117 = union {
  object { CSG419 }
  cylinder { // Cylndr736
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, 0.10461, -2.140404>
}
#declare CSG420 = union {
  box { // Cube902
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube903
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube904
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube905
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube906
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube907
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG421 = difference {
  cylinder { // Cylndr737
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG420 }
}
#declare nut118 = union {
  object { CSG421 }
  cylinder { // Cylndr738
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.484246
  rotate <-25.911886, -0.0, -0.0>
  translate  <-5.358172, -0.213223, -1.754731>
}
#declare Group198 = union {
  object { nut114 }
  object { nut115 }
  object { nut116 }
  object { nut117 }
  object { nut118 }
}
#declare Group199 = union {
  object { CSG411 }
  object { Group198 }
}
#declare CSG422 = union {
  superellipsoid { // SuperQ063
    <1.0, 0.1>
    scale <0.057876, 0.075919, 0.07231>
    rotate <90.0, -76.648361, -90.0>
    translate  <-8.719939, -0.220126, -1.130313>
  }
  superellipsoid { // SuperQ064
    <0.1, 0.1>
    scale <0.226337, 0.205306, 0.012152>
    translate  <-8.727804, -0.130412, -1.237225>
  }
  superellipsoid { // SuperQ065
    <0.1, 0.1>
    scale <0.080691, 0.044091, 0.057073>
    translate  <-8.719939, -0.250759, -1.183095>
  }
  superellipsoid { // SuperQ082
    <0.1, 0.1>
    scale <0.080691, 0.01241, 0.059336>
    rotate <66.28595, 0.0, 0.0>
    translate  <-8.719939, -0.015417, -1.189884>
  }
  material {
    Wheel_stl
  }
}
#declare CSG423 = union {
  box { // Cube908
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube909
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube910
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube911
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube912
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube913
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG424 = difference {
  cylinder { // Cylndr739
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG423 }
}
#declare nut119 = union {
  object { CSG424 }
  cylinder { // Cylndr740
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, -0.17599, -2.140404>
}
#declare CSG425 = union {
  box { // Cube914
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube915
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube916
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube917
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube918
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube919
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG426 = difference {
  cylinder { // Cylndr741
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG425 }
}
#declare nut120 = union {
  object { CSG426 }
  cylinder { // Cylndr742
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, -0.17599, -2.140404>
}
#declare CSG427 = union {
  box { // Cube920
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube921
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube922
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube923
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube924
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube925
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG428 = difference {
  cylinder { // Cylndr743
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG427 }
}
#declare nut121 = union {
  object { CSG428 }
  cylinder { // Cylndr744
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.833465, 0.102347, -2.140404>
}
#declare CSG429 = union {
  box { // Cube926
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube927
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube928
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube929
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube930
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube931
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG430 = difference {
  cylinder { // Cylndr745
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG429 }
}
#declare nut122 = union {
  object { CSG430 }
  cylinder { // Cylndr746
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.726188
  translate  <-3.530282, 0.10461, -2.140404>
}
#declare CSG431 = union {
  box { // Cube932
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube933
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube934
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube935
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube936
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube937
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG432 = difference {
  cylinder { // Cylndr747
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG431 }
}
#declare nut123 = union {
  object { CSG432 }
  cylinder { // Cylndr748
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  material {
    chassis_black
  }
  scale 0.484246
  rotate <-25.911886, -0.0, -0.0>
  translate  <-5.358172, -0.213223, -1.754731>
}
#declare Group208 = union {
  object { nut119 }
  object { nut120 }
  object { nut121 }
  object { nut122 }
  object { nut123 }
}
#declare Group209 = union {
  object { CSG422 }
  object { Group208 }
}


#declare Torus030 = object {
  torus { // Torus030
    1.9185, 0.0435  rotate -x*90
    scale 0.468914
    rotate <180.0, -83.93866, 180.0>
    translate  <4.099872, 0.0, 1.96598>
  }
}
#declare Torus044 = object {
  torus { // Torus044
    1.9185, 0.0435  rotate -x*90
    scale 0.468914
    rotate <180.0, -83.93866, 180.0>
    translate  <4.099872, 0.0, 1.96598>
  }
}
#declare Sphere616 = object {
  sphere { // Sphere616
    <0,0,0>,1
    scale 0.032681
    translate  <-7.667985, 2.336266, 1.414264>
  }
}
#declare Sphere619 = object {
  sphere { // Sphere619
    <0,0,0>,1
    scale 0.032681
    translate  <-7.667985, 2.336266, 1.414264>
  }
}
#declare CSG060 = union {
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG061 = difference {
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG060 }
}
#declare nut12 = union {
  object { CSG061 }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG052 = union {
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG053 = difference {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG052 }
}
#declare nut = union {
  object { CSG053 }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare CSG062 = union {
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG063 = difference {
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG062 }
}
#declare nut19 = union {
  object { CSG063 }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG054 = union {
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG055 = difference {
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG054 }
}
#declare nut9 = union {
  object { CSG055 }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare CSG097 = union {
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG098 = difference {
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG097 }
}
#declare nut33 = union {
  object { CSG098 }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG099 = union {
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG100 = difference {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG099 }
}
#declare nut38 = union {
  object { CSG100 }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare CSG105 = union {
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG106 = difference {
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG105 }
}
#declare nut44 = union {
  object { CSG106 }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 1.155271>
}
#declare CSG107 = union {
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG108 = difference {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG107 }
}
#declare nut49 = union {
  object { CSG108 }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
}
#declare Sphere124 = object {
  sphere { // Sphere124
    <0,0,0>,1
    scale 0.031479
    translate  <4.173418, -1.135586, 6.518639>
  }
}
#declare Sphere110 = object {
  sphere { // Sphere110
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 1.192858>
  }
}
#declare Sphere083 = object {
  sphere { // Sphere083
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 4.490262>
  }
}
#declare Sphere078 = object {
  sphere { // Sphere078
    <0,0,0>,1
    scale 0.031479
    translate  <-0.062231, -1.135586, 6.313388>
  }
}
#declare Sphere103 = object {
  sphere { // Sphere103
    <0,0,0>,1
    scale 0.031479
    translate  <-0.062231, -1.135586, 6.313388>
  }
}
#declare Sphere109 = object {
  sphere { // Sphere109
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 4.490262>
  }
}
#declare Sphere123 = object {
  sphere { // Sphere123
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 1.192858>
  }
}
#declare Sphere186 = object {
  sphere { // Sphere186
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 2.74897>
  }
}
#declare Sphere180 = object {
  sphere { // Sphere180
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 3.154765>
  }
}
#declare Sphere185 = object {
  sphere { // Sphere185
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 3.154765>
  }
}
#declare Sphere189 = object {
  sphere { // Sphere189
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 2.74897>
  }
}
#declare Sphere015 = object {
  sphere { // Sphere015
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 3.054691, 6.610479>
  }
}
#declare Sphere042 = object {
  sphere { // Sphere042
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 3.054691, 6.610479>
  }
}
#declare Sphere063 = object {
  sphere { // Sphere063
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 3.054691, 6.610479>
  }
}
#declare Sphere077 = object {
  sphere { // Sphere077
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 3.054691, 6.610479>
  }
}
#declare Sphere359 = object {
  sphere { // Sphere359
    <0,0,0>,1
    scale 0.031479
    translate  <4.217347, -0.739096, 4.125396>
  }
}
#declare Sphere382 = object {
  sphere { // Sphere382
    <0,0,0>,1
    scale 0.031479
    translate  <4.217347, -0.739096, 4.125396>
  }
}
#declare Sphere383 = object {
  sphere { // Sphere383
    <0,0,0>,1
    scale 0.031479
    translate  <4.241564, 0.125686, 3.34184>
  }
}
#declare Sphere400 = object {
  sphere { // Sphere400
    <0,0,0>,1
    scale 0.031479
    translate  <4.241564, 0.125686, 3.34184>
  }
}
#declare Sphere133 = object {
  sphere { // Sphere133
    <0,0,0>,1
    scale 0.031479
    translate  <4.173418, -1.135586, 6.518639>
  }
}
#declare Sphere140 = object {
  sphere { // Sphere140
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 1.192858>
  }
}
#declare Sphere145 = object {
  sphere { // Sphere145
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 4.490262>
  }
}
#declare Sphere156 = object {
  sphere { // Sphere156
    <0,0,0>,1
    scale 0.031479
    translate  <-0.062231, -1.135586, 6.313388>
  }
}
#declare Sphere167 = object {
  sphere { // Sphere167
    <0,0,0>,1
    scale 0.031479
    translate  <-0.062231, -1.135586, 6.313388>
  }
}
#declare Sphere172 = object {
  sphere { // Sphere172
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 4.490262>
  }
}
#declare Sphere179 = object {
  sphere { // Sphere179
    <0,0,0>,1
    scale 0.031479
    translate  <0.104265, -1.135586, 1.192858>
  }
}
#declare Sphere191 = object {
  sphere { // Sphere191
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 2.74897>
  }
}
#declare Sphere194 = object {
  sphere { // Sphere194
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 3.154765>
  }
}
#declare Sphere197 = object {
  sphere { // Sphere197
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 3.154765>
  }
}
#declare Sphere199 = object {
  sphere { // Sphere199
    <0,0,0>,1
    scale 0.031479
    translate  <2.833173, -1.135586, 2.74897>
  }
}
#declare Sphere237 = object {
  sphere { // Sphere237
    <0,0,0>,1
    scale 0.03419
    translate  <-7.434048, 0.133831, -0.57348>
  }
}
#declare Sphere256 = object {
  sphere { // Sphere256
    <0,0,0>,1
    scale 0.03419
    translate  <-7.434048, 0.133831, -0.57348>
  }
}
#declare Sphere257 = object {
  object { // Sphere257->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <-0.134444, -0.662769, 1.98981>
  }
}
#declare Sphere326 = object {
  object { // Sphere326->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <-0.134444, -0.662769, 1.98981>
  }
}
#declare Sphere401 = object {
  sphere { // Sphere401
    <0,0,0>,1
    scale 0.036001
    translate  <4.007347, 0.139656, 0.956131>
  }
}
#declare Sphere429 = object {
  sphere { // Sphere429
    <0,0,0>,1
    scale 0.036001
    translate  <4.007347, 0.139656, 0.956131>
  }
}
#declare Sphere495 = object {
  sphere { // Sphere495
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere506 = object {
  sphere { // Sphere506
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere512 = object {
  sphere { // Sphere512
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere518 = object {
  sphere { // Sphere518
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere524 = object {
  sphere { // Sphere524
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere530 = object {
  sphere { // Sphere530
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere536 = object {
  sphere { // Sphere536
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere542 = object {
  sphere { // Sphere542
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere548 = object {
  sphere { // Sphere548
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere554 = object {
  sphere { // Sphere554
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere560 = object {
  sphere { // Sphere560
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere566 = object {
  sphere { // Sphere566
    <0,0,0>,1
    scale 0.029461
    translate  <0.332647, 0.108674, 0.245755>
  }
}
#declare Sphere477 = object {
  sphere { // Sphere477
    <0,0,0>,1
    scale 0.019173
    translate  <-3.200992, 2.418258, 1.30728>
  }
}
#declare Sphere469 = object {
  sphere { // Sphere469
    <0,0,0>,1
    scale 0.019173
    translate  <-3.38472, 2.474511, 1.306628>
  }
}
#declare Sphere483 = object {
  sphere { // Sphere483
    <0,0,0>,1
    scale 0.019173
    translate  <-3.200992, 2.53233, 1.30728>
  }
}
#declare Sphere494 = object {
  sphere { // Sphere494
    <0,0,0>,1
    scale 0.019173
    translate  <-3.38472, 2.474511, 1.306628>
  }
}
#declare Sphere597 = object {
  sphere { // Sphere597
    <0,0,0>,1
    scale 0.032681
    translate  <-7.667985, 2.336266, 1.414264>
  }
}




//
// ********  OBJECTS  *******
//

#declare HgtFld002 = object { 
  height_field {
    tga "D:\Graphics\Models\Moray\ngloco\rubble2.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    dirt_floor
  }
  scale <9.467161, 1.170395, 0.326277>
  translate  <-4.800462, 4.060434, -1.150164>
}
#declare HgtFld001 = object { 
  height_field {
    tga "D:\Graphics\Models\Moray\ngloco\rubble.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    SandstP
  }
  scale <1.960092, 2.016882, 0.697872>
  rotate -87.832954*z
  translate  <3.056373, -3.722961, -0.862537>
}
#declare HgtFld003 = object { 
  height_field {
    tga "D:\Graphics\Models\Moray\ngloco\rubble2.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    dirt_floor
  }
  scale <4.300287, 1.170395, 0.326277>
  rotate <-0.0, 0.0, -90.0>
  translate  <7.981571, -6.300974, -1.347183>
}
#declare dirt_mounds = union {
  object { HgtFld002 }
  object { HgtFld001 }
  object { HgtFld003 }
}
#declare grass_group = union {
  object { // Group287->Group233
    Group233
    translate  <12.179462, 5.356028, 0.0>
  }
  object { // Group286->Group233
    Group233
    translate  <12.344545, 5.649509, 0.0>
  }
  object { // Group285->Group233
    Group233
    translate  <-0.348509, 4.640668, 0.0>
  }
  object { // Group284->Group233
    Group233
    translate  <0.07337, 4.750724, 0.0>
  }
  object { // Group283->Group233
    Group233
    translate  <-2.164422, 5.08089, 0.0>
  }
  object { // Group282->Group233
    Group233
    translate  <20.433615, 3.50343, -0.11884>
  }
  object { // Group281->Group233
    Group233
    translate  <19.938366, 6.346527, 0.0>
  }
  object { // Group280->Group233
    Group233
    scale 1.11884
    translate  <21.75428, 3.365392, 0.277294>
  }
  object { // Group279->Group233
    Group233
    translate  <20.172487, 3.293562, 0.0>
  }
  object { // Group278->Group233
    Group233
    scale <1.0, 1.17826, 1.376327>
    translate  <19.989039, 4.100915, 0.633814>
  }
  object { // Group277->Group233
    Group233
    translate  <-2.339229, 8.301969, 0.0>
  }
  object { // Group276->Group233
    Group233
    translate  <-1.843828, 5.265809, 0.0>
  }
  object { // Group275->Group233
    Group233
    translate  <3.394175, 5.779271, 0.0>
  }
  object { // Group274->Group233
    Group233
    translate  <3.027237, 6.054475, 0.0>
  }
  object { // Group273->Group233
    Group233
    translate  <3.348308, 6.237944, 0.0>
  }
  object { // Group272->Group233
    Group233
    translate  <-0.366938, 8.94411, 0.0>
  }
  object { // Group271->Group233
    Group233
    translate  <-0.137602, 9.265181, 0.17826>
  }
  object { // Group270->Group233
    Group233
    rotate 6.77786*x
    translate  <2.98137, 11.851462, 1.307241>
  }
  object { // Group269->Group233
    Group233
    translate  <1.742955, 12.45608, 0.53478>
  }
  object { // Group268->Group233
    Group233
    translate  <1.33015, 12.470678, 0.594201>
  }
  object { // Group267->Group257
    Group257
    rotate -0.0*z
    translate  <-1.70442, -0.036264, 0.0>
  }
  object { // Group266->Group257
    Group257
    rotate -0.0*z
    translate  <1.232985, -1.849477, 0.0>
  }
  object { // Group265->Group257
    Group257
    rotate -0.0*z
    translate  <-0.217586, -1.486834, 0.0>
  }
  object { // Group264->Group257
    Group257
    rotate -0.0*z
    translate  <6.019867, -2.139591, 0.0>
  }
  object { // Group263->Group257
    Group257
    rotate -0.0*z
    translate  <1.232985, 2.502234, 0.0>
  }
  object { // Group262->Group257
    Group257
    rotate -0.0*z
    translate  <-2.21212, 2.030798, 0.0>
  }
  object { // Group261->Group257
    Group257
    rotate -0.0*z
    translate  <1.378042, 3.698954, 0.0>
  }
  object { // Group260->Group257
    Group257
    rotate -0.0*z
    translate  <3.082462, 2.502234, 0.0>
  }
  object { // Group259->Group257
    Group257
    rotate -0.0*z
    translate  <2.357177, -1.45057, 0.0>
  }
  object { // Group258->Group257
    Group257
    rotate -0.0*z
    translate  <-1.631892, -0.290114, 0.0>
  }
  object { Group233 }
  object { // Group234->Group233
    Group233
    translate  <-1.810186, 1.000374, 0.0>
  }
  object { // Group235->Group233
    Group233
    translate  <3.276263, -0.758884, 0.0>
  }
  object { // Group236->Group233
    Group233
    translate  <2.346534, 1.702039, 0.0>
  }
  object { // Group237->Group233
    Group233
    translate  <0.780553, 1.005413, 0.0>
  }
  object { // Group238->Group233
    Group233
    translate  <1.269012, -1.121851, 0.0>
  }
  object { // Group239->Group233
    Group233
    translate  <0.339771, 0.984899, 0.0>
  }
  object { // Group240->Group233
    Group233
    translate  <1.764606, -1.148965, 0.0>
  }
  object { // Group241->Group233
    Group233
    translate  <2.757129, 1.042557, 0.0>
  }
  object { // Group242->Group233
    Group233
    translate  <2.3485, 1.32623, 0.0>
  }
  object { // Group243->Group233
    Group233
    translate  <2.023262, -0.214994, 0.0>
  }
  object { // Group244->Group233
    Group233
    translate  <2.233265, 0.061185, 0.0>
  }
  object { // Group245->Group233
    Group233
    translate  <-1.2543, 0.260038, 0.0>
  }
  object { Group257 }
  object { // Group306->Group301
    Group301
    scale <1.0, 1.029404, 1.264636>
    rotate <0.0, 0.0, -0.0>
    translate  <1.015226, -0.107815, 0.59788>
  }
  object { // Group305->Group301
    Group301
    rotate <0.0, 0.0, -0.0>
    translate  <1.114272, -0.393606, 0.14702>
  }
  object { // Group304->Group301
    Group301
    rotate <0.0, 0.0, -0.0>
    translate  <-0.916179, 0.803719, 0.264636>
  }
  object { // Group303->Group301
    Group301
    rotate <0.0, 0.0, -0.0>
    translate  <-0.420947, -0.482851, -0.078411>
  }
  object { // Group302->Group301
    Group301
    rotate <0.0, 0.0, -0.0>
    translate  <0.643802, -0.0, 0.196026>
  }
  object { // Group289->Group233
    Group233
    rotate 11.624031*x
    translate  <0.29711, 10.891929, 1.676026>
  }
  object { Group301 }
}
#declare Rail4 = union {
  box { // Cube940
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    translate  <-1.326996, -0.117646, -1.122423>
  }
  cylinder { // Cylndr754
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.036589, 0.083815, 16.548485>
    rotate 90.0*y
    translate  <-9.597166, -0.121538, -1.004851>
  }
  box { // Cube941
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    rotate -90.0*x
    translate  <-1.326996, -0.117646, -1.211548>
  }
  material {
    chassis_black
  }
  scale <0.277335, 1.0, 1.0>
  rotate -12.915846*z
  translate  <-7.543583, -8.585295, -0.047134>
}
#declare leaflet = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.022487>, <-1.000000, -2.000000, 0.022487>, <0.134612, -1.963286, 0.022487>, <1.107548, -1.982292, -0.000172>, 
      <-2.000000, -1.000000, 0.000000>, <-1.008579, -0.998489, 0.015684>, <0.126849, -1.012981, 0.021926>, <1.096182, -1.004267, 0.018449>, 
      <-2.000000, 0.000000, 0.000000>, <-0.994087, 0.000000, 0.015684>, <0.112357, 0.000000, 0.021926>, <1.077505, 0.011244, 0.018449>, 
      <-2.000000, 0.998469, 0.021575>, <-1.000000, 0.998469, 0.021575>, <0.086951, 1.012961, 0.021575>, <1.077505, 0.998469, 0.032647>
    }
  }
  material {
    notice
  }
  scale 0.510406
  rotate <-89.995659, -180.207245, 91.193275>
  translate  <10.121252, -0.690972, 3.876411>
}
#declare CSG506 = union {
  box { // Cube1082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG507 = difference {
  cylinder { // Cylndr841
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.3829, 1.25991>
  }
  object { CSG506 }
}
#declare nut154 = union {
  object { CSG507 }
  cylinder { // Cylndr842
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.382248, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.710419, -5.197479>
}
#declare CSG508 = union {
  box { // Cube1088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG509 = difference {
  cylinder { // Cylndr843
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG508 }
}
#declare nut155 = union {
  object { CSG509 }
  cylinder { // Cylndr844
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.510058, -5.648904>
}
#declare CSG510 = union {
  box { // Cube1094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1099
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG511 = difference {
  cylinder { // Cylndr845
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG510 }
}
#declare nut156 = union {
  object { CSG511 }
  cylinder { // Cylndr846
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.73148, -5.428998>
}
#declare CSG512 = union {
  box { // Cube1100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1101
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1102
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG513 = difference {
  cylinder { // Cylndr847
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG512 }
}
#declare nut157 = union {
  object { CSG513 }
  cylinder { // Cylndr848
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.284883, -5.428998>
}
#declare lower_flange2 = union {
  object { nut154 }
  object { nut155 }
  object { nut156 }
  object { nut157 }
  cylinder { // Cylndr849
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.869019, 2.402681, 0.096005>
  }
  cylinder { // Cylndr850
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.820024, 2.402681, 0.096005>
  }
  cylinder { // Cylndr851
    <0,0,1>, <0,0,0>, 1 
    scale <0.154747, 0.154747, 0.024414>
    rotate -90.0*y
    translate  <-5.798249, 2.402681, 0.096005>
  }
  material {
    chassis_black
  }
  rotate <90.0, -84.929138, -90.0>
  translate  <-6.29467, -5.179298, 4.404541>
}
#declare CSG514 = union {
  box { // Cube1106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr852
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG515 = difference {
  object { CSG514 }
  cylinder { // Cylndr853
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr854
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG516 = union {
  object { CSG515 }
}
#declare CSG517 = union {
  cylinder { // Cylndr855
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr856
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.105466>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG518 = union {
  box { // Cube1107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr857
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG519 = difference {
  object { CSG518 }
  cylinder { // Cylndr858
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr859
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG520 = union {
  object { CSG517 }
  object { CSG519 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG521 = union {
  object { CSG516 }
  object { CSG520 }
  box { // Cube1108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG522 = difference {
  object { CSG521 }
}
#declare CSG523 = union {
  box { // Cube1109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr860
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG524 = difference {
  object { CSG523 }
  cylinder { // Cylndr861
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr862
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG525 = union {
  object { CSG524 }
}
#declare CSG526 = union {
  cylinder { // Cylndr863
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr864
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.107272>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG527 = union {
  box { // Cube1110
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr865
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG528 = difference {
  object { CSG527 }
  cylinder { // Cylndr866
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr867
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG529 = union {
  object { CSG526 }
  object { CSG528 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG530 = union {
  object { CSG525 }
  object { CSG529 }
  box { // Cube1111
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG531 = difference {
  object { CSG530 }
  translate  -2.213783*x
}
#declare Main_conn_rod2 = union {
  object { CSG522 }
  object { CSG531 }
  material {
    chassis_black
  }
  scale -1.0
  rotate <-90.0, 0.0, -160.250626>
  translate  <-3.04005, -1.502359, -3.559825>
}
#declare Group177 = union {
  object { // nut124->nut127
    nut127
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut125->nut127
    nut127
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut126->nut127
    nut127
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut127 }
}
#declare Group188 = union {
  object { // nut128->nut132
    nut132
    translate  0.899748*x
  }
  object { // nut129->nut132
    nut132
    translate  0.687279*x
  }
  object { // nut130->nut132
    nut132
    translate  0.468577*x
  }
  object { // nut131->nut132
    nut132
    translate  0.237405*x
  }
  object { nut132 }
}
#declare CSG442 = union {
  box { // Cube996
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube997
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube998
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube999
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1000
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG443 = difference {
  cylinder { // Cylndr756
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG442 }
}
#declare nut133 = union {
  object { CSG443 }
  cylinder { // Cylndr757
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  -0.259718*y
}
#declare CSG444 = union {
  box { // Cube1002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG445 = difference {
  cylinder { // Cylndr758
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG444 }
}
#declare nut134 = union {
  object { CSG445 }
  cylinder { // Cylndr807
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  <0.900355, -0.259718, 0.0>
}
#declare Group189 = union {
  object { // nut135->nut138
    nut138
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut136->nut138
    nut138
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut137->nut138
    nut138
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut138 }
  translate  -0.423946*z
}
#declare Group197 = union {
  object { // nut139->nut143
    nut143
    translate  0.899748*x
  }
  object { // nut140->nut143
    nut143
    translate  0.687279*x
  }
  object { // nut141->nut143
    nut143
    translate  0.468577*x
  }
  object { // nut142->nut143
    nut143
    translate  0.237405*x
  }
  object { nut143 }
  translate  -0.519435*y
}
#declare CSG450 = union {
  box { // Cube1020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1025
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG451 = difference {
  cylinder { // Cylndr812
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG450 }
}
#declare nut144 = union {
  object { CSG451 }
  cylinder { // Cylndr813
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 0.949569>
}
#declare CSG452 = union {
  box { // Cube1026
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG453 = difference {
  cylinder { // Cylndr814
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG452 }
}
#declare nut145 = union {
  object { CSG453 }
  cylinder { // Cylndr815
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-1.682828, 0.037172, 0.949569>
}
#declare CSG454 = union {
  box { // Cube1032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1037
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG455 = difference {
  cylinder { // Cylndr816
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG454 }
}
#declare nut146 = union {
  object { CSG455 }
  cylinder { // Cylndr817
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG456 = union {
  box { // Cube1038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG457 = difference {
  cylinder { // Cylndr818
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG456 }
}
#declare nut147 = union {
  object { CSG457 }
  cylinder { // Cylndr819
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group211 = union {
  object { nut146 }
  object { nut147 }
}
#declare CSG458 = union {
  box { // Cube1044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG459 = difference {
  cylinder { // Cylndr820
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG458 }
}
#declare nut148 = union {
  object { CSG459 }
  cylinder { // Cylndr821
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG460 = union {
  box { // Cube1050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG461 = difference {
  cylinder { // Cylndr822
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG460 }
}
#declare nut149 = union {
  object { CSG461 }
  cylinder { // Cylndr823
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group212 = union {
  object { nut148 }
  object { nut149 }
  rotate 60.0*x
  translate  <0.0, -0.110588, 0.394362>
}
#declare CSG462 = union {
  box { // Cube1056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG463 = difference {
  cylinder { // Cylndr824
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG462 }
}
#declare nut150 = union {
  object { CSG463 }
  cylinder { // Cylndr825
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG464 = union {
  box { // Cube1062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1067
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG465 = difference {
  cylinder { // Cylndr826
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG464 }
}
#declare nut151 = union {
  object { CSG465 }
  cylinder { // Cylndr827
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group213 = union {
  object { nut150 }
  object { nut151 }
  rotate -60.0*x
  translate  <0.0, -0.275427, -0.298379>
}
#declare Group214 = union {
  object { Group211 }
  object { Group212 }
  object { Group213 }
}
#declare CSG466 = union {
  box { // Cube1068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG467 = difference {
  cylinder { // Cylndr828
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG466 }
}
#declare nut152 = union {
  object { CSG467 }
  cylinder { // Cylndr829
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.215533, 6.451218>
}
#declare CSG468 = union {
  box { // Cube1074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube1075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube1076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube1077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube1078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube1079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG469 = difference {
  cylinder { // Cylndr830
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG468 }
}
#declare nut153 = union {
  object { CSG469 }
  cylinder { // Cylndr831
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.507222, 6.451218>
}
#declare cylinder_nuts2 = union {
  object { Group177 }
  object { Group188 }
  object { nut133 }
  object { nut134 }
  object { Group189 }
  object { Group197 }
  object { nut144 }
  object { nut145 }
  object { Group214 }
  object { nut152 }
  object { nut153 }
}
#declare CSG470 = difference {
  cylinder { // Cylndr833
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.056158>
    rotate -90.0*y
    translate  <-7.085441, -0.302981, 0.095172>
  }
  cylinder { // Cylndr834
    <0,0,1>, <0,0,0>, 1 
    scale <0.176949, 0.176949, 0.069589>
    rotate -90.0*y
    translate  <-7.126162, -0.302981, 0.095172>
  }
}
#declare CSG471 = union {
  cylinder { // Cylndr832
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.073238>
    rotate -90.0*y
    translate  <-7.003999, -0.302981, 0.095172>
  }
  object { CSG470 }
  scale <1.520248, 1.883057, 1.883057>
  translate  <9.687473, 0.364152, -0.182985>
}
#declare CSG472 = union {
  superellipsoid { // SuperQ015
    <0.1, 0.035>
    scale <1.0, 0.770644, 1.344475>
    translate  <0.0, -0.200687, 1.179741>
  }
  superellipsoid { // SuperQ085
    <1.0, 0.033>
    scale <0.768547, 0.768547, 1.003828>
    rotate 90.0*y
    translate  <-0.0, -0.200687, 0.0>
  }
  box { // Cube1080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.914062, 0.726125, 0.068709>
    translate  <-0.012085, -0.203101, 2.529974>
  }
  box { // Cube1081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.731697, 0.567435, 0.053679>
    rotate -90.0*x
    translate  <0.007695, -0.976504, 1.69585>
  }
  object { CSG471 }
  scale <0.559141, 0.451411, 0.451411>
  translate  <-6.469638, -0.301853, 0.095099>
}
#declare CSG503 = union {
  cylinder { // Cylndr835
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr836
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr837
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.303179>
  translate  <3.444236, 0.108797, -0.348024>
}
#declare CSG504 = union {
  cylinder { // Cylndr838
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr839
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr840
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.304373>
  translate  <3.386265, 0.108797, -0.348024>
}
#declare CSG505 = union {
  sphere { // Sphere613
    <0,0,0>,1
    scale <0.042176, 0.109883, 0.109883>
    translate  <-7.132483, -0.46555, 0.794407>
  }
  object { CSG503 }
  object { CSG504 }
  translate  0.136717*z
}
#declare Cylinder2 = union {
  object { cylinder_nuts2 }
  object { CSG472 }
  object { CSG505 }
  material {
    chassis_black
  }
  rotate <-90.0, -0.0, 8.095013>
  translate  <3.291647, -2.713031, -1.313735>
}
#declare CSG433 = union {
  cylinder { // Cylndr749
    <0,0,1>, <0,0,0>, 1 
    scale <0.045629, 0.045629, 0.218836>
    rotate -90.0*x
    translate  <-0.007489, -1.143786, 1.90081>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale <0.074611, 0.014733, 0.070334>
    translate  <0.0, -1.139351, 1.900889>
  }
  material {
    bucket_metal
  }
}
#declare CSG434 = union {
  torus { // Torus098
    1.986, 0.014  rotate -x*90
    scale <0.706583, 0.567632, 1.0>
    rotate <0.0, -90.0, 0.0>
    translate  <0.028902, 0.0, 1.977>
  }
  cylinder { // Cylndr750
    <0,0,1>, <0,0,0>, 1 
    scale <1.416862, 1.119104, 0.054255>
    rotate <0.0, -90.0, 0.0>
    translate  <0.018544, 0.0, 1.950321>
  }
  torus { // Torus099
    1.986, 0.014  rotate -x*90
    scale <0.706583, 0.567632, 1.0>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.043352, 0.0, 1.977>
  }
}
#declare CSG435 = difference {
  object { CSG434 }
  box { // Cube938
    <-1, -1, -1>, <1, 1, 1>
    scale <0.165519, 1.34991, 0.804051>
    translate  <0.0, -0.007204, 1.022455>
  }
  cylinder { // Cylndr751
    <0,0,1>, <0,0,0>, 1 
    scale <1.414878, 1.109578, 0.202607>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.101693, 0.0, 1.950321>
  }
  material {
    bucket_metal
  }
  rotate -19.620768*y
  translate  <0.646347, 0.0, 0.165025>
}
#declare CSG436 = difference {
  cone { // Cone069
    <0,0,0>, 0.721, <0,0,1>, 1.0
    material {
      bucket_red
    }
    scale <1.0, 1.0, 1.998818>
  }
  cone { // Cone072
    <0,0,0>, 0.721, <0,0,1>, 1.033
    material {
      bucket_metal
    }
    scale <0.972614, 0.972614, 2.044494>
  }
}
#declare CSG437 = union {
  cylinder { // Cylndr753
    <0,0,1>, <0,0,0>, 1 
    scale <0.045629, 0.045629, 0.218836>
    rotate -90.0*x
    translate  <-0.007489, -1.143786, 1.90081>
  }
  sphere { // Sphere044
    <0,0,0>,1
    scale <0.074611, 0.014733, 0.070334>
    translate  <0.0, -1.139351, 1.900889>
  }
  material {
    bucket_metal
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
}
#declare ngbucket = union {
  object { CSG433 }
  object { CSG435 }
  object { CSG436 }
  cylinder { // Cylndr752
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_red
    }
    scale <0.727934, 0.727934, 0.067339>
    translate  -0.06691*z
  }
  torus { // Torus100
    1.95, 0.05  rotate -x*90
    material {
      bucket_metal
    }
    scale 0.524811
    translate  1.999476*z
  }
  torus { // Torus101
    1.947, 0.053  rotate -x*90
    material {
      bucket_red
    }
    scale 0.371283
    translate  0.006329*z
  }
  object { CSG437 }
  scale 0.417834
  rotate <0.0, -73.206253, 107.607895>
  translate  <-11.383953, -3.172428, -1.061652>
}
#declare clutter = union {
  superellipsoid { // SuperQ083
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.217245, 1.890101, 0.062749>
    rotate <6.451542, -1.850846, 18.832647>
    translate  <-12.69685, -0.972463, -0.97904>
  }
  superellipsoid { // SuperQ084
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.177572, 0.041722>
    rotate <0.0, -0.0, 98.459702>
    translate  <-1.839832, -5.801887, -1.262639>
  }
  object { Rail4 }
  object { leaflet }
  object { lower_flange2 }
  object { Main_conn_rod2 }
  object { Cylinder2 }
  superellipsoid { // SuperQ086
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.217245, 1.890101, 0.062749>
    rotate <10.190185, 3.178132, -25.774269>
    translate  <-13.462956, -0.769494, -0.934329>
  }
  superellipsoid { // SuperQ087
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.177572, 0.041722>
    rotate <73.11615, 0.019275, -90.25985>
    translate  <8.430433, -3.277765, 0.641477>
  }
  object { ngbucket }
  object { // spare_wheels->Group001
    Group001
    translate  -10.626731*x
  }
}
#declare BezPtch027 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch028 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch029 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant8 = union {
  object { BezPtch027 }
  object { BezPtch028 }
  object { BezPtch029 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch030 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch031 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch032 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant9 = union {
  object { BezPtch030 }
  object { BezPtch031 }
  object { BezPtch032 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant11 = union {
  object { ngplant8 }
  object { ngplant9 }
  rotate -0.0*z
  translate  <13.441546, -1.755631, 0.0>
  rotate <-1.122204, 9.375615, -96.856613>
  translate  <-0.713225, -5.021638, -0.058126>
}
#declare BezPtch021 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch022 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch023 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant6 = union {
  object { BezPtch021 }
  object { BezPtch022 }
  object { BezPtch023 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch024 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -36.452839>
}
#declare BezPtch025 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch026 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 86.938774>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant7 = union {
  object { BezPtch024 }
  object { BezPtch025 }
  object { BezPtch026 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant10 = union {
  object { ngplant6 }
  object { ngplant7 }
  scale 0.780546
  translate  <19.411682, -6.03498, -0.159701>
}
#declare BezPtch033 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -76.06208>
}
#declare BezPtch034 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch035 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 56.643337>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant10 = union {
  object { BezPtch033 }
  object { BezPtch034 }
  object { BezPtch035 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch036 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <108.056717, -260.997742, 71.643974>
  translate  <0.372041, 0.649665, 0.0>
}
#declare BezPtch037 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-122.805573, -259.486572, -294.203705>
  translate  <0.364892, 0.474233, 0.0>
}
#declare BezPtch038 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 39.375076>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant11 = union {
  object { BezPtch036 }
  object { BezPtch037 }
  object { BezPtch038 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant12 = union {
  object { ngplant10 }
  object { ngplant11 }
  scale 0.555056
  translate  <3.38759, -4.209228, -0.638398>
}
#declare BezPtch039 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, -76.06208>
}
#declare BezPtch040 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-0.0, 89.464272, -158.0784>
  translate  <0.140442, -0.23407, 0.0>
}
#declare BezPtch041 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 56.643337>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant12 = union {
  object { BezPtch039 }
  object { BezPtch040 }
  object { BezPtch041 }
  scale 0.085625
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare BezPtch042 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.219522, -0.016222, -5.320814>, <-3.124581, -0.468510, -2.253521>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-3.219522, -0.007207, -5.320814>, <-3.124581, -0.234255, -2.253521>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-3.219522, 0.001809, -5.320814>, <-3.124581, 0.000000, -2.253521>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-3.219522, 0.010824, -5.320814>, <-3.124581, 0.234255, -2.253521>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <108.056717, -260.997742, 71.643974>
  translate  <0.372041, 0.649665, 0.0>
}
#declare BezPtch043 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.674704, 0.453395, -3.948814>, <-2.436006, -0.452525, -2.312257>, <-0.375587, -0.468510, -1.001565>, <4.690952, -0.244902, 0.000000>, 
      <-3.674704, 0.462697, -3.946320>, <-2.436006, -0.226263, -2.251590>, <-0.375587, -0.234255, -1.001565>, <4.690952, -0.168207, 0.000000>, 
      <-3.674704, 0.472000, -3.943826>, <-2.436006, 0.000000, -2.190923>, <-0.375587, 0.000000, -1.001565>, <4.690952, -0.091511, 0.000000>, 
      <-3.674704, 0.481302, -3.941331>, <-2.436006, 0.226263, -2.130256>, <-0.375587, 0.234255, -1.001565>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <-122.805573, -259.486572, -294.203705>
  translate  <0.364892, 0.474233, 0.0>
}
#declare BezPtch044 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.681587, -0.331491, -4.230695>, <-4.126146, -0.510568, -3.305585>, <0.000000, -0.468510, 0.000000>, <4.690952, -0.244902, 0.000000>, 
      <-5.681587, -0.326701, -4.231431>, <-4.126146, -0.279025, -3.341122>, <0.000000, -0.234255, 0.000000>, <4.690952, -0.168207, 0.000000>, 
      <-5.681587, -0.321911, -4.232166>, <-4.126146, -0.047481, -3.376659>, <0.000000, 0.000000, 0.000000>, <4.690952, -0.091511, 0.000000>, 
      <-5.681587, -0.317121, -4.232901>, <-4.126146, 0.184062, -3.412196>, <0.000000, 0.234255, 0.000000>, <4.690952, -0.014816, 0.000000>
    }
  }
  material {
    plant_green
  }
  rotate <0.0, 89.464272, 39.375076>
  translate  <-0.020783, -0.287812, 0.0>
}
#declare ngplant13 = union {
  object { BezPtch042 }
  object { BezPtch043 }
  object { BezPtch044 }
  scale 0.085625
  rotate -68.331779*z
  translate  <-13.385296, 1.841558, -0.924011>
}
#declare plant13 = union {
  object { ngplant12 }
  object { ngplant13 }
  scale 0.555056
  translate  <5.02764, -4.858414, -0.638398>
}
#declare plants = union {
  object { plant9 }
  object { // plant8->plant6
    plant6
    rotate <-0.0, -0.0, 0.0>
    translate  <1.586181, 3.004072, 0.038691>
  }
  object { // plant7->plant6
    plant6
    scale 1.222472
    rotate <-0.0, -0.0, 0.0>
    translate  <5.07578, 4.234397, 0.338545>
  }
  object { // plant5->plant3
    plant3
    scale 0.678288
    rotate <-7.023729, 6.033687, 130.469376>
    translate  <-18.343243, 3.272702, -1.305045>
  }
  object { // plant4->plant3
    plant3
    rotate <0.0, -0.0, -50.267155>
    translate  <-3.52497, -8.236919, 0.0>
  }
  object { // plant2->plant1
    plant1
    scale 0.864152
    rotate <-3.693866, 6.581802, -29.389996>
    translate  <-4.390004, -5.462589, -1.449261>
  }
  object { plant1 }
  object { plant }
  object { plant11 }
  object { plant3 }
  object { plant6 }
  object { plant10 }
  object { // plant16->plant14
    plant14
    rotate <0.0, -0.0, 0.0>
    translate  <-0.615019, -0.820025, 0.0>
  }
  object { // plant15->plant14
    plant14
    rotate <0.0, -0.0, 0.0>
    translate  <1.879224, -0.034168, 0.0>
  }
  object { plant14 }
  object { plant12 }
  object { plant13 }
  object { // plant22->plant9
    plant9
    rotate <0.0, 0.0, 48.136532>
    translate  <-3.309405, 7.796733, 0.0>
  }
  object { // plant21->plant9
    plant9
    rotate <0.0, 0.0, 18.09536>
    translate  <-0.958389, 1.277852, 0.0>
  }
  object { // plant20->plant9
    plant9
    rotate <-0.0, 0.0, -26.255026>
    translate  <3.537411, -4.645293, 0.0>
  }
  object { // plant19->plant9
    plant9
    rotate <-0.0, 0.0, -0.0>
    translate  <-2.131197, 12.296355, 0.106198>
  }
  object { plant18 }
  object { plant17 }
  object { // plant26->plant9
    plant9
    scale <0.972592, 0.967994, 0.494348>
    rotate <-15.485415, -17.394354, 42.957073>
    translate  <8.646092, 6.708761, -0.564086>
  }
  object { // plant25->plant18
    plant18
    rotate <-0.0, 0.0, 60.907566>
    translate  <-10.376947, 8.638107, 0.0>
  }
  object { // plant24->plant18
    plant18
    rotate <-0.0, 0.0, -19.258694>
    translate  <5.048245, 3.533771, 0.0>
  }
  object { // plant23->plant9
    plant9
    rotate <-0.0, 0.0, -55.152283>
    translate  <8.918565, -4.87997, 0.0>
  }
  object { // plant27->plant9
    plant9
    scale 0.788236
    rotate <-0.0, 0.0, -102.019653>
    translate  <-5.293356, -2.020109, -0.111974>
  }
}
union { // scenic_base
  object { dirt_mounds }
  object { grass_group }
  plane { // Plane001
    z,0
    material {
      dirt_floor
    }
    scale 11.125859
    translate  <0.835549, 1.730725, -1.269697>
  }
  object { clutter }
  object { plants }
}


#declare CSG402 = union {
  box { // Cube872
    <-1, -1, -1>, <1, 1, 1>
    scale <2.052502, 11.975813, 14.574482>
    translate  <-18.678632, 22.020509, -10.100726>
  }
  cylinder { // Cylndr726
    <0,0,1>, <0,0,0>, 1 
    scale <10.276527, 11.733591, 3.846057>
    rotate <0.0, -90.0, 0.0>
    translate  <-16.700392, 21.967314, 4.55107>
  }
  material {
    stone_face
  }
  scale 0.25
  translate  <14.361219, -4.572178, 4.694921>
}
#declare CSG404 = difference {
  box { // Cube981
    <-1, -1, -1>, <1, 1, 1>
    material {
      stone_face
    }
    scale <5.339251, 0.303796, 5.731121>
    rotate -90.0*z
    translate  <9.709193, -0.141068, 4.2933>
  }
  object { CSG402 }
}
#declare Group187 = union {
  object { CSG403 }
  object { Group178 }
  object { Group184 }
  object { // Group185->Group184
    Group184
    scale -1.0
    rotate <180.0, 0.0, 180.0>
    translate  43.9739*y
  }
  object { // Group186->Group178
    Group178
    material {
      RoughStone
    }
    scale -1.0
    rotate <180.0, 0.0, 180.0>
    translate  43.887199*y
  }
  scale 0.25
  translate  <14.207516, -4.546467, 4.649502>
}
#declare end_wall = union {
  object { CSG404 }
  object { Group187 }
  translate  -0.063652*x
}
#declare CSG473 = union {
  box { // Cube948
    <-1, -1, -1>, <1, 1, 1>
    scale <6.797403, 1.995996, 8.908713>
    translate  <2.836228, 1.593593, -3.981628>
  }
  cylinder { // Cylndr759
    <0,0,1>, <0,0,0>, 1 
    scale <6.797337, 6.797337, 4.058349>
    rotate -90.0*x
    translate  <2.832892, -0.398398, 4.697186>
  }
  material {
    stone_face
  }
}
#declare CSG474 = difference {
  box { // Cube947
    <-1, -1, -1>, <1, 1, 1>
    material {
      stone_face
    }
    scale <21.490156, 1.287411, 23.079214>
    translate  <2.046234, 1.741782, -0.757206>
  }
  object { CSG473 }
  scale 0.25
  translate  <-18.075933, 4.942854, 4.462266>
}
#declare CSG475 = union {
  torus { // Torus103
    1.935, 0.065  rotate -x*90
  }
  torus { // Torus104
    1.8645, 0.1355  rotate -x*90
    scale 0.457347
  }
}
#declare CSG476 = difference {
  object { CSG475 }
  box { // Cube949
    <-1, -1, -1>, <1, 1, 1>
    scale <2.24203, 1.051042, 0.13144>
    translate  <0.017014, -1.054875, 0.0>
  }
}
#declare frame1 = union {
  object { CSG476 }
  cylinder { // Cylndr760
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <1.934685, -5.027671, 0.0>
  }
  cylinder { // Cylndr761
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <0.850092, -5.027671, 0.0>
  }
  cylinder { // Cylndr762
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <-0.851125, -5.027671, 0.0>
  }
  cylinder { // Cylndr763
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <-1.933433, -5.027671, 0.0>
  }
  cylinder { // Cylndr764
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -5.027671, 0.0>
  }
  cylinder { // Cylndr765
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -0.060856, 0.0>
  }
  cylinder { // Cylndr766
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -3.911432, 0.0>
  }
  cylinder { // Cylndr767
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -1.43976, 0.0>
  }
  cylinder { // Cylndr768
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -2.695529, 0.0>
  }
  cylinder { // Cylndr769
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate -90.0*x
    translate  <-0.000277, 0.861091, 0.0>
  }
  cylinder { // Cylndr770
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, -0.0, -30.0>
    translate  <0.417142, 0.746505, 0.0>
  }
  cylinder { // Cylndr771
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, -60.0>
    translate  <0.74453, 0.427302, 0.0>
  }
  cylinder { // Cylndr772
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, 30.0>
    translate  <-0.425881, 0.73832, 0.0>
  }
  cylinder { // Cylndr773
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, 60.0>
    translate  <-0.745084, 0.427302, 0.0>
  }
}
#declare window_frame1 = difference {
  object { frame1 }
  box { // Cube950
    <-1, -1, -1>, <1, 1, 1>
    scale <2.089187, 3.668508, 0.123457>
    translate  <0.0, -1.552091, 0.154438>
  }
  material {
    window_col
  }
}
#declare window_glass1 = merge {
  box { // Cube951
    <-1, -1, -1>, <1, 1, 1>
    scale <1.931946, 1.338194, 0.017045>
    translate  <0.0, -1.346067, -0.0>
  }
  cylinder { // Cylndr774
    <0,0,1>, <0,0,0>, 1 
    scale <1.948759, 1.948759, 0.033746>
    translate  -0.016891*z
  }
  material {
    T_Old_Glass
  }
}
#declare CSG477 = difference {
  superellipsoid { // SuperQ066
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  box { // Cube952
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -8.855103*z
    translate  <0.637103, 2.246625, 0.0>
  }
  box { // Cube953
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 8.8551*z
    translate  <-0.642691, 2.246625, 0.0>
  }
}
#declare CSG484 = union {
  object { CSG477 }
  object { CSG482 }
  object { // CSG483->CSG482
    CSG482
    scale -1.0
    rotate -180.0*x
  }
}
#declare arch1 = difference {
  object { CSG484 }
  cylinder { // Cylndr775
    <0,0,1>, <0,0,0>, 1 
    scale <1.986791, 1.986791, 0.611945>
    translate  -0.320797*z
  }
}
#declare window_arch1 = union {
  object { arch1 }
  superellipsoid { // SuperQ071
    <0.1, 0.1>
    scale <0.358635, 0.298955, 0.183201>
    translate  <-2.284006, -0.21609, 0.0>
  }
  superellipsoid { // SuperQ072
    <0.1, 0.1>
    scale <0.358635, 0.298955, 0.183201>
    translate  <2.295848, -0.21609, 0.0>
  }
  superellipsoid { // SuperQ073
    <0.1, 0.1>
    scale <2.478416, 0.278173, 0.183201>
    translate  <0.003312, -5.358008, 0.0>
    material {
      RoughStone
      // Transform to world space
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-10.799401, -0.096423, 0.0>
    }
  }
  material {
    RoughStone
  }
  scale <1.0, 1.0, 1.807768>
  translate  <-0.0, -0.0, -0.140481>
}
#declare ngwindow4 = union {
  object { window_frame1 }
  object { window_glass1 }
  object { window_arch1 }
  scale <0.863742, 0.863742, 1.07835>
  rotate 90.0*x
  translate  <-17.362396, 5.235396, 5.621356>
}
#declare side_wall = union {
  object { CSG474 }
  object { ngwindow4 }
  translate  <10.799401, 0.096423, 0.0>
}
#declare CSG488 = union {
  box { // Cube967
    <-1, -1, -1>, <1, 1, 1>
    scale <6.797403, 1.995996, 8.908713>
    translate  <2.836228, 1.593593, -3.981628>
  }
  cylinder { // Cylndr783
    <0,0,1>, <0,0,0>, 1 
    scale <6.797337, 6.797337, 4.058349>
    rotate -90.0*x
    translate  <2.832892, -0.398398, 4.697186>
  }
  material {
    stone_face
  }
}
#declare CSG489 = difference {
  box { // Cube966
    <-1, -1, -1>, <1, 1, 1>
    material {
      stone_face
    }
    scale <21.490156, 1.287411, 23.079214>
    translate  <2.046234, 1.741782, -0.757206>
  }
  object { CSG488 }
  scale 0.25
  translate  <-18.075933, 4.942854, 4.462266>
}
#declare CSG490 = union {
  torus { // Torus108
    1.935, 0.065  rotate -x*90
  }
  torus { // Torus109
    1.8645, 0.1355  rotate -x*90
    scale 0.457347
  }
}
#declare CSG491 = difference {
  object { CSG490 }
  box { // Cube968
    <-1, -1, -1>, <1, 1, 1>
    scale <2.24203, 1.051042, 0.13144>
    translate  <0.017014, -1.054875, 0.0>
  }
}
#declare frame2 = union {
  object { CSG491 }
  cylinder { // Cylndr784
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <1.934685, -5.027671, 0.0>
  }
  cylinder { // Cylndr785
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <0.850092, -5.027671, 0.0>
  }
  cylinder { // Cylndr786
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <-0.851125, -5.027671, 0.0>
  }
  cylinder { // Cylndr787
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 5.027482>
    rotate -90.0*x
    translate  <-1.933433, -5.027671, 0.0>
  }
  cylinder { // Cylndr788
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -5.027671, 0.0>
  }
  cylinder { // Cylndr789
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -0.060856, 0.0>
  }
  cylinder { // Cylndr790
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -3.911432, 0.0>
  }
  cylinder { // Cylndr791
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -1.43976, 0.0>
  }
  cylinder { // Cylndr792
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 3.998059>
    rotate <-90.0, -0.0, -90.0>
    translate  <-1.998962, -2.695529, 0.0>
  }
  cylinder { // Cylndr793
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate -90.0*x
    translate  <-0.000277, 0.861091, 0.0>
  }
  cylinder { // Cylndr794
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, -0.0, -30.0>
    translate  <0.417142, 0.746505, 0.0>
  }
  cylinder { // Cylndr795
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, -60.0>
    translate  <0.74453, 0.427302, 0.0>
  }
  cylinder { // Cylndr796
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, 30.0>
    translate  <-0.425881, 0.73832, 0.0>
  }
  cylinder { // Cylndr797
    <0,0,1>, <0,0,0>, 1 
    scale <0.065041, 0.065041, 1.05418>
    rotate <-90.0, 0.0, 60.0>
    translate  <-0.745084, 0.427302, 0.0>
  }
}
#declare window_frame2 = difference {
  object { frame2 }
  box { // Cube969
    <-1, -1, -1>, <1, 1, 1>
    scale <2.089187, 3.668508, 0.123457>
    translate  <0.0, -1.552091, 0.154438>
  }
  material {
    window_col
  }
}
#declare window_glass2 = merge {
  box { // Cube970
    <-1, -1, -1>, <1, 1, 1>
    scale <1.931946, 2.517384, 0.017045>
    translate  -2.525257*y
  }
  cylinder { // Cylndr798
    <0,0,1>, <0,0,0>, 1 
    scale <1.948759, 1.948759, 0.033746>
    translate  -0.016891*z
  }
  material {
    T_Old_Glass
  }
}
#declare CSG492 = difference {
  superellipsoid { // SuperQ074
    <0.1, 0.1>
    scale <0.607607, 0.431625, 0.186182>
    translate  2.305009*y
    material {
      RoughStone
      // Transform to world space
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  box { // Cube971
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate -8.855103*z
    translate  <0.637103, 2.246625, 0.0>
  }
  box { // Cube972
    <-1, -1, -1>, <1, 1, 1>
    scale <0.108262, 0.561122, 0.233325>
    rotate 8.8551*z
    translate  <-0.642691, 2.246625, 0.0>
  }
}
#declare CSG499 = union {
  object { CSG492 }
  object { CSG497 }
  object { // CSG498->CSG497
    CSG497
    scale -1.0
    rotate -180.0*x
  }
}
#declare arch2 = difference {
  object { CSG499 }
  cylinder { // Cylndr799
    <0,0,1>, <0,0,0>, 1 
    scale <1.986791, 1.986791, 0.611945>
    translate  -0.320797*z
  }
}
#declare window_arch2 = union {
  object { arch2 }
  superellipsoid { // SuperQ079
    <0.1, 0.1>
    scale <0.358635, 0.298955, 0.183201>
    translate  <-2.284006, -0.21609, 0.0>
  }
  superellipsoid { // SuperQ080
    <0.1, 0.1>
    scale <0.358635, 0.298955, 0.183201>
    translate  <2.295848, -0.21609, 0.0>
  }
  superellipsoid { // SuperQ081
    <0.1, 0.1>
    scale <2.478416, 0.278173, 0.183201>
    translate  <0.003312, -5.358008, 0.0>
    material {
      RoughStone
      // Transform to world space
      translate  <0.0, 0.0, 0.140481>
      scale <1.0/1.0, 1.0/1.0, 1.0/1.807768>
      translate  <17.362396, -5.235396, -5.621356>
      rotate -90.0*x
      scale <1.0/0.863742, 1.0/0.863742, 1.0/1.07835>
      translate  <-21.530541, -0.096423, 0.0>
    }
  }
  material {
    RoughStone
  }
  scale <1.0, 1.0, 1.807768>
  translate  <-0.0, -0.0, -0.140481>
}
#declare ngwindow5 = union {
  object { window_frame2 }
  object { window_glass2 }
  object { window_arch2 }
  scale <0.863742, 0.863742, 1.07835>
  rotate 90.0*x
  translate  <-17.362396, 5.235396, 5.621356>
}
#declare side_wall2 = union {
  object { CSG489 }
  object { ngwindow5 }
  translate  <21.530541, 0.096423, 0.0>
}
#declare Group220 = union {
  cylinder { // Cylndr897
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr898
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr899
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr900
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ094
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  rotate -42.389858*y
  translate  <1.695112, -0.080431, 3.856379>
}
#declare Group215 = union {
  cylinder { // Cylndr877
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr878
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr879
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr880
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ089
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  rotate -0.944184*y
  translate  <0.084756, 0.0, -0.487345>
}
#declare Group216 = union {
  cylinder { // Cylndr881
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr882
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr883
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr884
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ090
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  translate  -1.250145*z
}
#declare Group217 = union {
  cylinder { // Cylndr885
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr886
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr887
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr888
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ091
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  rotate -3.477032*y
  translate  <0.296645, 0.0, -1.546789>
}
#declare Group218 = union {
  cylinder { // Cylndr889
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr890
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr891
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr892
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ092
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  rotate -1.232248*y
  translate  <0.148322, 0.0, -2.436723>
}
#declare Group219 = union {
  cylinder { // Cylndr893
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr894
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr895
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr896
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ093
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  translate  <0.021189, 0.0, -3.241901>
}
#declare Group176 = union {
  cylinder { // Cylndr873
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.653444, 5.058396, 4.907577>
  }
  cylinder { // Cylndr876
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.553631, 5.058396, 4.729566>
  }
  cylinder { // Cylndr875
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-4.631511, 5.058396, 4.91314>
  }
  cylinder { // Cylndr874
    <0,0,1>, <0,0,0>, 1 
    material {
      bucket_metal
    }
    scale <0.017663, 0.017663, 0.008965>
    rotate -90.0*x
    translate  <-8.686822, 5.058396, 4.735129>
  }
  superellipsoid { // SuperQ088
    <0.068, 0.05>
    material {
      Sleeper_Colour_1
    }
    scale <0.160006, 2.15016, 0.041722>
    rotate <90.0, -90.0, 0.0>
    translate  <-6.636974, 5.103369, 4.81933>
  }
  rotate 1.376559*y
  translate  <-0.084756, 0.0, -0.169511>
}
#declare window_boards = union {
  object { Group220 }
  object { Group215 }
  object { Group216 }
  object { Group217 }
  object { Group218 }
  object { Group219 }
  object { Group176 }
  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Tempog.ttf",
    "KEEP OUT",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      white_paint
    }
    scale <0.312886, 0.312886, 0.014138>
    rotate <90.0, -41.482967, -0.0>
    translate  <-6.787267, 4.994482, 2.516824>
  }

}
#declare BezPtch057 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.629108, -1.158061, -8.701095>, <-3.629108, -1.333333, -8.701095>, <-2.943662, -1.333333, -8.638498>, <-2.943662, -1.158060, -8.638498>, 
      <-5.945227, -1.158061, -2.820031>, <-5.945227, -1.333333, -2.820031>, <-5.948357, -1.333333, -2.820031>, <-5.948357, -1.158060, -2.820031>, 
      <7.951487, -1.158061, -0.006260>, <7.951487, -1.333333, -0.006260>, <8.010955, -1.333333, 0.181534>, <8.010955, -1.158060, 0.181534>, 
      <8.201878, -1.158061, 7.752739>, <8.201878, -1.333333, 7.752739>, <8.699531, -1.333333, 7.690141>, <8.699531, -1.158060, 7.690141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.943662, -1.158060, -8.638498>, <-2.943662, -0.982786, -8.638498>, <-3.629108, -0.982789, -8.701095>, <-3.629108, -1.158061, -8.701095>, 
      <-5.948357, -1.158060, -2.820031>, <-5.948357, -0.982786, -2.820031>, <-5.945227, -0.982789, -2.820031>, <-5.945227, -1.158061, -2.820031>, 
      <8.010955, -1.158060, 0.181534>, <8.010955, -0.982786, 0.181534>, <7.951487, -0.982789, -0.006260>, <7.951487, -1.158061, -0.006260>, 
      <8.699531, -1.158060, 7.690141>, <8.699531, -0.982786, 7.690141>, <8.201878, -0.982789, 7.752739>, <8.201878, -1.158061, 7.752739>
    }
  }
  material {
    lampglass
  }
  scale <0.058612, 0.16218, 0.073297>
  rotate <180.0, 0.0, 180.0>
  translate  <-7.618076, 5.511311, 4.937997>
}
#declare BezPtch058 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.441315, -1.158061, -0.625978>, <-3.441315, -1.333333, -0.625978>, <-2.755869, -1.333333, -0.563380>, <-2.755869, -1.158060, -0.563380>, 
      <13.522692, -1.158061, -3.633803>, <13.522692, -1.333333, -3.633803>, <13.519562, -1.333333, -3.633803>, <13.519562, -1.158060, -3.633803>, 
      <-3.629108, -1.158061, 3.248826>, <-3.629108, -1.333333, 3.248826>, <-3.569640, -1.333333, 3.436620>, <-3.569640, -1.158060, 3.436620>, 
      <14.962441, -1.158061, 8.128326>, <14.962441, -1.333333, 8.128326>, <15.460094, -1.333333, 8.065728>, <15.460094, -1.158060, 8.065728>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.755869, -1.158060, -0.563380>, <-2.755869, -0.982786, -0.563380>, <-3.441315, -0.982789, -0.625978>, <-3.441315, -1.158061, -0.625978>, 
      <13.519562, -1.158060, -3.633803>, <13.519562, -0.982786, -3.633803>, <13.522692, -0.982789, -3.633803>, <13.522692, -1.158061, -3.633803>, 
      <-3.569640, -1.158060, 3.436620>, <-3.569640, -0.982786, 3.436620>, <-3.629108, -0.982789, 3.248826>, <-3.629108, -1.158061, 3.248826>, 
      <15.460094, -1.158060, 8.065728>, <15.460094, -0.982786, 8.065728>, <14.962441, -0.982789, 8.128326>, <14.962441, -1.158061, 8.128326>
    }
  }
  material {
    lampglass
  }
  scale <0.058612, 0.16218, 0.073297>
  rotate <180.0, 0.0, 180.0>
  translate  <-5.605548, 5.515034, 6.213431>
}
#declare BezPtch059 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.629108, -1.158061, -8.701095>, <-3.629108, -1.333333, -8.701095>, <-2.943662, -1.333333, -8.638498>, <-2.943662, -1.158060, -8.638498>, 
      <-5.945227, -1.158061, -2.820031>, <-5.945227, -1.333333, -2.820031>, <-5.948357, -1.333333, -2.820031>, <-5.948357, -1.158060, -2.820031>, 
      <7.951487, -1.158061, -0.006260>, <7.951487, -1.333333, -0.006260>, <8.010955, -1.333333, 0.181534>, <8.010955, -1.158060, 0.181534>, 
      <8.201878, -1.158061, 7.752739>, <8.201878, -1.333333, 7.752739>, <8.699531, -1.333333, 7.690141>, <8.699531, -1.158060, 7.690141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.943662, -1.158060, -8.638498>, <-2.943662, -0.982786, -8.638498>, <-3.629108, -0.982789, -8.701095>, <-3.629108, -1.158061, -8.701095>, 
      <-5.948357, -1.158060, -2.820031>, <-5.948357, -0.982786, -2.820031>, <-5.945227, -0.982789, -2.820031>, <-5.945227, -1.158061, -2.820031>, 
      <8.010955, -1.158060, 0.181534>, <8.010955, -0.982786, 0.181534>, <7.951487, -0.982789, -0.006260>, <7.951487, -1.158061, -0.006260>, 
      <8.699531, -1.158060, 7.690141>, <8.699531, -0.982786, 7.690141>, <8.201878, -0.982789, 7.752739>, <8.201878, -1.158061, 7.752739>
    }
  }
  material {
    lampglass
  }
  scale <0.044653, 0.16218, 0.029007>
  rotate <0.0, -89.05896, -0.0>
  translate  <-6.480834, 5.511311, 5.897936>
}
#declare window_cracks = union {
  object { BezPtch057 }
  object { BezPtch058 }
  object { BezPtch059 }
}
#declare CSG485 = difference {
  torus { // Torus105
    1.747, 0.253  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 1.740669, 2.880743>
  }
  box { // Cube962
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 2.209351, 1.19095>
    translate  <0.0, 1.72718, 1.693375>
  }
}
#declare CSG486 = difference {
  torus { // Torus106
    1.747, 0.253  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 1.740669, 2.880743>
  }
  box { // Cube963
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 2.209351, 1.19095>
    translate  <0.0, 1.72718, 4.070265>
  }
  box { // Cube964
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 1.047587, 1.203309>
    translate  <0.0, 2.796395, 1.976706>
  }
  translate  <0.0, 3.491326, 0.004992>
}
#declare lamp_brkt1 = union {
  object { CSG485 }
  object { CSG486 }
  cylinder { // Cylndr776
    <0,0,1>, <0,0,0>, 1 
    scale <0.257178, 0.257178, 1.413326>
    translate  <0.0, -0.000986, 1.472211>
  }
  cylinder { // Cylndr777
    <0,0,1>, <0,0,0>, 1 
    scale <0.415896, 0.415896, 0.0992>
    rotate -90.0*x
    translate  <0.0, 5.234998, 1.140249>
  }
  cylinder { // Cylndr778
    <0,0,1>, <0,0,0>, 1 
    scale <0.799972, 0.799972, 0.275136>
    rotate -90.0*x
    translate  <0.0, 5.323942, 1.140249>
  }
  material {
    window_col
  }
}
#declare lamp_body1 = union {
  torus { // Torus107
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.350012>
  }
  cylinder { // Cylndr779
    <0,0,1>, <0,0,0>, 1 
    scale <1.536663, 1.536663, 0.274431>
    translate  -0.389508*z
  }
  sphere { // Sphere625
    <0,0,0>,1
    scale <0.415428, 1.502263, 1.502263>
    rotate -90.0*y
    translate  0.156357*z
  }
  cylinder { // Cylndr780
    <0,0,1>, <0,0,0>, 1 
    scale <0.657415, 0.657415, 0.687236>
    translate  0.458255*z
  }
  cylinder { // Cylndr781
    <0,0,1>, <0,0,0>, 1 
    scale <0.415896, 0.415896, 0.434761>
    translate  1.122433*z
  }
  material {
    window_col
  }
}
#declare CSG487 = difference {
  sphere { // Sphere626
    <0,0,0>,1
    hollow
    scale 1.502263
    rotate -90.0*y
    translate  -3.01358*z
  }
  box { // Cube965
    <-1, -1, -1>, <1, 1, 1>
    scale <1.649988, 1.845037, 0.911365>
    translate  -2.098458*z
  }
}
#declare lamp_glass1 = merge {
  cylinder { // Cylndr782
    <0,0,1>, <0,0,0>, 1 
    scale <1.502731, 1.502731, 2.916563>
    translate  -3.01358*z
  }
  object { CSG487 }
  material {
    lampglass_outer
  }
  hollow
}
#declare lamp_bulb1 = merge {
  cone { // Cone070
    <0,0,0>, 0.228, <0,0,1>, 0.512
    hollow
    rotate <180.0, 0.0, 180.0>
    translate  -0.481082*z
  }
  sphere { // Sphere627
    <0,0,0>,1
    hollow
    scale 0.516962
    rotate <0.0, -90.0, 0.0>
    translate  -1.479304*z
  }
  material {
    lampglass
  }
  translate  0.105064*z
}
#declare nglamp1 = union {
  object { lamp_brkt1 }
  object { lamp_body1 }
  object { lamp_glass1 }
  object { lamp_bulb1 }
  scale 0.151516
  translate  <-10.494987, 4.295538, 7.038393>
}
#declare CSG500 = difference {
  torus { // Torus110
    1.747, 0.253  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 1.740669, 2.880743>
  }
  box { // Cube982
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 2.209351, 1.19095>
    translate  <0.0, 1.72718, 1.693375>
  }
}
#declare CSG501 = difference {
  torus { // Torus111
    1.747, 0.253  rotate -x*90
    rotate -90.0*y
    translate  <0.0, 1.740669, 2.880743>
  }
  box { // Cube983
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 2.209351, 1.19095>
    translate  <0.0, 1.72718, 4.070265>
  }
  box { // Cube984
    <-1, -1, -1>, <1, 1, 1>
    scale <0.396203, 1.047587, 1.203309>
    translate  <0.0, 2.796395, 1.976706>
  }
  translate  <0.0, 3.491326, 0.004992>
}
#declare lamp_brkt2 = union {
  object { CSG500 }
  object { CSG501 }
  cylinder { // Cylndr800
    <0,0,1>, <0,0,0>, 1 
    scale <0.257178, 0.257178, 1.413326>
    translate  <0.0, -0.000986, 1.472211>
  }
  cylinder { // Cylndr801
    <0,0,1>, <0,0,0>, 1 
    scale <0.415896, 0.415896, 0.0992>
    rotate -90.0*x
    translate  <0.0, 5.234998, 1.140249>
  }
  cylinder { // Cylndr802
    <0,0,1>, <0,0,0>, 1 
    scale <0.799972, 0.799972, 0.275136>
    rotate -90.0*x
    translate  <0.0, 5.323942, 1.140249>
  }
  material {
    window_col
  }
}
#declare lamp_body2 = union {
  torus { // Torus112
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.350012>
  }
  cylinder { // Cylndr803
    <0,0,1>, <0,0,0>, 1 
    scale <1.536663, 1.536663, 0.274431>
    translate  -0.389508*z
  }
  sphere { // Sphere628
    <0,0,0>,1
    scale <0.415428, 1.502263, 1.502263>
    rotate -90.0*y
    translate  0.156357*z
  }
  cylinder { // Cylndr804
    <0,0,1>, <0,0,0>, 1 
    scale <0.657415, 0.657415, 0.687236>
    translate  0.458255*z
  }
  cylinder { // Cylndr805
    <0,0,1>, <0,0,0>, 1 
    scale <0.415896, 0.415896, 0.434761>
    translate  1.122433*z
  }
  material {
    window_col
  }
}
#declare CSG502 = difference {
  sphere { // Sphere629
    <0,0,0>,1
    hollow
    scale 1.502263
    rotate -90.0*y
    translate  -3.01358*z
  }
  box { // Cube985
    <-1, -1, -1>, <1, 1, 1>
    scale <1.649988, 1.845037, 0.911365>
    translate  -2.098458*z
  }
}
#declare lamp_glass2 = merge {
  cylinder { // Cylndr806
    <0,0,1>, <0,0,0>, 1 
    scale <1.502731, 1.502731, 2.916563>
    translate  -3.01358*z
  }
  object { CSG502 }
  material {
    lampglass_outer
  }
  hollow
}
#declare lamp_bulb2 = merge {
  cone { // Cone071
    <0,0,0>, 0.228, <0,0,1>, 0.512
    hollow
    rotate <180.0, 0.0, 180.0>
    translate  -0.481082*z
  }
  sphere { // Sphere630
    <0,0,0>,1
    hollow
    scale 0.516962
    rotate <0.0, -90.0, 0.0>
    translate  -1.479304*z
  }
  material {
    lampglass
  }
  translate  0.105064*z
}
#declare nglamp2 = union {
  object { lamp_brkt2 }
  object { lamp_body2 }
  object { lamp_glass2 }
  object { lamp_bulb2 }
  scale 0.151516
  rotate -90.0*z
  translate  <8.493949, -3.499504, 7.02248>
}
#declare lamps = union {
  object { nglamp1 }
  object { nglamp2 }
  translate  0.95935*z
}
#declare CSG538 = difference {
  torus { // Torus114
    1.5, 0.5  rotate -x*90
    scale 0.204569
    rotate <0.0, -90.0, 0.0>
    translate  <-11.27354, 4.727469, -0.431757>
  }
  box { // Cube1128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.165559, 0.458569, 0.222887>
    translate  <-11.271504, 4.729927, -0.210414>
  }
  box { // Cube1129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.165559, 0.458488, 0.256718>
    rotate <89.863228, 0.0, 0.0>
    translate  <-11.271504, 4.549494, -0.427498>
  }
  torus { // Torus115
    1.566, 0.434  rotate -x*90
    material {
      chassis_black
    }
    scale 0.196111
    rotate <-0.0, -90.0, 0.0>
    translate  <-11.27354, 4.727469, -0.431757>
  }
  translate  <-0.00122, -0.025629, 0.0>
}
#declare grid = union {
  box { // Cube1130
    <-1, -1, -1>, <1, 1, 1>
    material {
      chassis_black
    }
    scale <0.64215, 0.046092, 0.006424>
    translate  <-11.274235, 4.98328, -0.899376>
  }
  superellipsoid { // SuperQ096
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    translate  <-12.0111, 4.906571, -1.040057>
  }
  superellipsoid { // SuperQ097
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    translate  <-12.01705, 4.313694, -1.040057>
  }
  superellipsoid { // SuperQ098
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    rotate -90.0*z
    translate  <-11.563848, 4.166491, -1.040057>
  }
  superellipsoid { // SuperQ099
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    rotate -90.0*z
    translate  <-10.968858, 4.166491, -1.040057>
  }
  superellipsoid { // SuperQ100
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    translate  <-10.523625, 4.906571, -1.040057>
  }
  superellipsoid { // SuperQ101
    <0.1, 0.1>
    material {
      RoughStone
    }
    scale <0.151554, 0.293593, 0.258048>
    translate  <-10.523625, 4.313694, -1.040057>
  }
  box { // Cube1131
    <-1, -1, -1>, <1, 1, 1>
    material {
      chassis_black
    }
    scale <0.64215, 0.046092, 0.006424>
    translate  <-11.274235, 4.799817, -0.899376>
  }
  box { // Cube1132
    <-1, -1, -1>, <1, 1, 1>
    material {
      chassis_black
    }
    scale <0.64215, 0.046092, 0.006424>
    translate  <-11.274235, 4.611396, -0.899376>
  }
  box { // Cube1133
    <-1, -1, -1>, <1, 1, 1>
    material {
      chassis_black
    }
    scale <0.64215, 0.046092, 0.006424>
    translate  <-11.274235, 4.413057, -0.899376>
  }
  translate  <-0.00122, -0.025629, 0.0>
}
#declare drainpipe = union {
  object { // Group288->Group224
    Group224
    translate  4.698182*z
  }
  object { Group224 }
  cylinder { // Cylndr907
    <0,0,1>, <0,0,0>, 1 
    scale <0.102224, 0.102224, 11.597643>
    translate  <-11.274884, 5.00874, -0.432075>
  }
  object { CSG538 }
  object { grid }
  material {
    window_col
  }
  translate  <0.00122, 0.025629, 0.0>
}
union { // Building
  object { // sheddoor1->sheddoor
    sheddoor
    scale -1.0
    rotate <-180.0, 0.0, -180.0>
    translate  <0.003844, 1.877513, 0.0>
  }
  object { end_wall }
  object { side_wall }
  object { side_wall2 }
  object { sheddoor }
  object { window_boards }
  object { window_cracks }
  object { lamps }
  object { drainpipe }
}


union { // black_outs
  box { // Cube939
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackout
    }
    scale <13.279409, 0.177064, 7.266422>
    rotate -90.0*x
    translate  <-3.155811, 12.587425, 10.274321>
  }
  box { // Cube942
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackout
    }
    scale <13.279409, 0.177064, 9.803951>
    rotate -90.0*x
    translate  <23.06533, 4.46733, 10.274321>
  }
  box { // Cube943
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackout
    }
    scale <13.279409, 0.177064, 7.266422>
    translate  <23.06533, -5.259218, 5.836442>
  }
  box { // Cube944
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackout
    }
    scale <30.456511, -0.230962, 7.266422>
    translate  <12.391131, 8.788333, 5.96112>
  }
  box { // Cube1127
    <-1, -1, -1>, <1, 1, 1>
    material {
      blackout
    }
    no_shadow
    scale <-30.456511, -0.230962, -7.266422>
    rotate <-180.0, 0.0, -180.0>
    translate  <18.103494, -28.454433, 5.96112>
  }
}




#declare Rail2 = union {
  box { // Cube874
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    translate  <-1.326996, -0.117646, -1.122423>
  }
  cylinder { // Cylndr727
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.036589, 0.083815, 16.548485>
    rotate 90.0*y
    translate  <-9.597166, -0.121538, -1.004851>
  }
  box { // Cube875
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    rotate -90.0*x
    translate  <-1.326996, -0.117646, -1.211548>
  }
}
#declare Rail3 = union {
  box { // Cube876
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    translate  <-1.326996, -0.117646, -1.122423>
  }
  cylinder { // Cylndr728
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.036589, 0.083815, 16.548485>
    rotate 90.0*y
    translate  <-9.597166, -0.121538, -1.004851>
  }
  box { // Cube877
    <-1, -1, -1>, <1, 1, 1>
    scale <8.263393, 0.013866, 0.085167>
    rotate -90.0*x
    translate  <-1.326996, -0.117646, -1.211548>
  }
  translate  2.242396*y
}
#declare Rails1 = union {
  object { Rail2 }
  object { Rail3 }
  material {
    chassis_black
  }
}
#declare sleepers1 = union {
  object { // SuperQ051->SuperQ058
    SuperQ058
    translate  <14.0, 0.0, 0.0>
  }
  object { // SuperQ052->SuperQ058
    SuperQ058
    translate  <12.0, 0.0, 0.0>
  }
  object { // SuperQ053->SuperQ058
    SuperQ058
    translate  <10.0, 0.0, 0.0>
  }
  object { // SuperQ054->SuperQ058
    SuperQ058
    translate  <8.0, 0.0, 0.0>
  }
  object { // SuperQ055->SuperQ058
    SuperQ058
    translate  <6.0, 0.0, 0.0>
  }
  object { // SuperQ056->SuperQ058
    SuperQ058
    translate  <4.0, 0.0, 0.0>
  }
  object { // SuperQ057->SuperQ058
    SuperQ058
    translate  <2.0, 0.0, 0.0>
  }
  object { SuperQ058 }
  material {
    Sleeper_Colour
  }
}
#declare Group200 = union {
  object { // Group190->Group199
    Group199
    translate  14.0*x
  }
  object { // Group191->Group199
    Group199
    translate  12.0*x
  }
  object { // Group192->Group199
    Group199
    translate  10.0*x
  }
  object { // Group193->Group199
    Group199
    translate  8.0*x
  }
  object { // Group194->Group199
    Group199
    translate  6.0*x
  }
  object { // Group195->Group199
    Group199
    translate  4.0*x
  }
  object { // Group196->Group199
    Group199
    translate  2.0*x
  }
  object { Group199 }
}
#declare Group210 = union {
  object { // Group201->Group209
    Group209
    translate  14.0*x
  }
  object { // Group202->Group209
    Group209
    translate  12.0*x
  }
  object { // Group203->Group209
    Group209
    translate  10.0*x
  }
  object { // Group204->Group209
    Group209
    translate  8.0*x
  }
  object { // Group205->Group209
    Group209
    translate  6.0*x
  }
  object { // Group206->Group209
    Group209
    translate  4.0*x
  }
  object { // Group207->Group209
    Group209
    translate  2.0*x
  }
  object { Group209 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.0066*y
}
#declare Track4 = union {
  object { Rails1 }
  object { sleepers1 }
  object { Group200 }
  object { Group210 }
  translate  <-17.236998, -6.770918, 0.0>
}
union { // tracks
  object { // Track3->Track
    Track
    translate  <-5.931535, -6.770904, 0.0>
  }
  object { // Track2->Track
    Track
    translate  15.975267*x
  }
  object { Track4 }
  object { Track }
  object { // Track1->Track
    Track
    translate  -16.060488*x
  }
}


sphere { // World_Sphere
  <0,0,0>,1
  material {
    SkyCol
  }
  no_shadow
  hollow
  scale 5000.0
}




#declare CSG087 = union {
  cone { // Cone042
    <0,0,0>, 0.466, <0,0,1>, 0.565
    scale <0.618976, 0.619266, 2.515688>
    rotate -0.0*z
    translate  <-6.842858, 0.983379, 4.317639>
  }
  torus { // Torus013
    1.8275, 0.1725  rotate -x*90
    scale 0.183385
    translate  <-6.840003, 0.984336, 6.569832>
  }
  torus { // Torus014
    1.6925, 0.3075  rotate -x*90
    scale 0.19166
    translate  <-6.840003, 0.984336, 6.832864>
  }
  torus { // Torus015
    1.8595, 0.1405  rotate -x*90
    scale 0.164862
    translate  <-6.840003, 0.984336, 6.878962>
  }
  torus { // Torus016
    1.8275, 0.1725  rotate -x*90
    scale <0.156764, 0.156764, 0.321302>
    translate  <-6.840003, 0.984336, 4.317907>
  }
  cone { // Cone041
    <0,0,0>, 0.461, <0,0,1>, 0.478
    scale <0.618976, 0.619266, 0.48892>
    rotate <180.0, 0.12767, 180.0>
    translate  <-6.842858, 0.983379, 4.317639>
  }
}
#declare Chimney_pipe = difference {
  object { CSG087 }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.286976, 0.286976, 0.398214>
    translate  <-6.842948, 0.98007, 6.515559>
  }
}
#declare CSG135 = difference {
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <1.191881, 1.191881, 0.751005>
    rotate -90.0*y
    translate  <-6.455733, 0.988032, 2.828002>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <-20.047533, -0.0, -0.0>
    translate  <-6.839801, 1.830736, 2.493077>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <20.047529, -0.0, -0.0>
    translate  <-6.839801, 0.144201, 2.493077>
  }
}
#declare Group050 = union {
  object { CSG135 }
  sphere { // Sphere219
    <0,0,0>,1
    scale 0.031479
    translate  <-7.134968, 1.44969, 3.91635>
  }
  sphere { // Sphere220
    <0,0,0>,1
    scale 0.031479
    translate  <-6.523776, 1.44969, 3.9175>
  }
  sphere { // Sphere221
    <0,0,0>,1
    scale 0.031479
    translate  <-7.134968, 0.511614, 3.910993>
  }
  sphere { // Sphere222
    <0,0,0>,1
    scale 0.031479
    translate  <-6.523776, 0.511614, 3.910529>
  }
}
#declare Chimney = union {
  object { Chimney_pipe }
  object { Group050 }
}
#declare CSG095 = union {
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019041, 0.218053, 0.244056>
    rotate <28.713917, 10.06731, 89.527283>
    translate  <-7.41979, 0.277751, 1.622059>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019041, 0.218053, 0.244056>
    rotate <28.713917, -10.067306, 89.527283>
    translate  <-7.41979, 1.693007, 1.622059>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    scale <0.018544, 0.231086, 0.142492>
    rotate <28.713917, 0.0, 89.527283>
    translate  <-7.397204, 1.001461, 1.509132>
  }
}
#declare CSG096 = difference {
  object { CSG095 }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    scale <0.237367, 0.818903, 0.36964>
    translate  <-7.26922, 0.987788, 1.626805>
  }
}
#declare Boiler_support_fr = union {
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019041, 0.682202, 0.217019>
    translate  <-7.472489, 0.987788, 1.724676>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019041, 0.218053, 0.244056>
    rotate <-25.941195, 0.0, -0.0>
    translate  <-7.472489, 0.416525, 1.634476>
  }
  object { CSG096 }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <0.019041, 0.218053, 0.244056>
    rotate <25.941191, 0.0, -0.0>
    translate  <-7.472489, 1.569072, 1.634476>
  }
}
#declare Group039 = union {
  sphere { // Sphere202
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 3.59636>
  }
  sphere { // Sphere203
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 2.096476>
  }
}
#declare Group040 = union {
  sphere { // Sphere204
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 3.59636>
  }
  sphere { // Sphere205
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 2.096476>
  }
  rotate 60.0*x
  translate  <0.063169, 2.954863, 0.556541>
}
#declare Group041 = union {
  sphere { // Sphere206
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 3.59636>
  }
  sphere { // Sphere207
    <0,0,0>,1
    scale 0.024978
    translate  <-7.673028, 0.988437, 2.096476>
  }
  rotate -60.0*x
  translate  <0.0, -1.966443, 2.269449>
}
#declare smokebox_rivets = union {
  object { Group039 }
  object { Group040 }
  object { Group041 }
}
#declare CSG088 = union {
  sphere { // Sphere201
    <0,0,0>,1
    scale <0.070081, 0.715858, 0.715858>
    translate  <-7.661458, 0.986583, 2.849114>
  }
  superellipsoid { // SuperQ007
    <1.0, 0.271>
    scale <1.094714, 1.094714, 0.218107>
    rotate <0.0, -90.0, 0.0>
    translate  <-7.413053, 0.989151, 2.834133>
  }
  torus { // Torus017
    1.961, 0.039  rotate -x*90
    scale <0.568401, 0.568401, 0.684487>
    rotate -90.0*y
    translate  <-7.504258, 0.99168, 2.82935>
  }
  superellipsoid { // SuperQ008
    <1.0, 0.271>
    scale <0.888065, 0.888065, 0.176935>
    rotate <0.0, -90.0, 0.0>
    translate  <-7.507767, 0.989151, 2.834133>
  }
}
#declare CSG089 = union {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.012081, 0.012081, 0.107628>
    rotate <90.0, 0.0, 180.0>
    translate  <-7.856407, 0.9403, 2.840404>
  }
  cone { // Cone043
    <0,0,0>, 0.107, <0,0,1>, 0.147
    scale <0.193032, 0.193032, 0.310493>
    rotate 180.0*x
    translate  <-7.857882, 0.993857, 2.811692>
  }
}
#declare smokebox_handle = union {
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale 0.171777
    rotate <0.0, -90.0, 0.0>
    translate  <-7.609674, 0.993569, 2.840404>
  }
  object { CSG089 }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_rim_hubface
    }
    scale <0.040474, 0.040474, 0.055462>
    rotate <0.0, -90.0, 0.0>
    translate  <-7.830517, 0.993569, 2.840404>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale 0.060169
    rotate <0.0, -90.0, 0.0>
    translate  <-7.76645, 0.993569, 2.840404>
  }
  sphere { // Sphere211
    <0,0,0>,1
    scale 0.024978
    translate  <-7.780451, 1.116529, 2.840615>
  }
  sphere { // Sphere210
    <0,0,0>,1
    scale 0.024978
    translate  <-7.780451, 0.873478, 2.840615>
  }
  sphere { // Sphere209
    <0,0,0>,1
    scale 0.024978
    translate  <-7.780451, 0.994129, 2.722982>
  }
  sphere { // Sphere208
    <0,0,0>,1
    scale 0.024978
    translate  <-7.780451, 0.994129, 2.957481>
  }
  translate  -0.005692*y
}
#declare CSG094 = union {
  superellipsoid { // SuperQ011
    <1.0, 0.1>
    scale <0.054344, 0.054344, 0.028551>
    translate  <-7.680106, 0.276429, 3.189707>
  }
  sphere { // Sphere216
    <0,0,0>,1
    scale <0.056627, 0.056319, 0.02556>
    translate  <-7.679899, 0.276423, 3.209992>
  }
}
#declare Group044 = union {
  object { CSG094 }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.024562, 0.024562, 0.542332>
    translate  <-7.67991, 0.277267, 2.550995>
  }
  sphere { // Sphere217
    <0,0,0>,1
    scale <0.056627, 0.056319, 0.02556>
    translate  <-7.679899, 0.276321, 2.450283>
  }
  superellipsoid { // SuperQ012
    <1.0, 0.1>
    scale <0.054344, 0.054344, 0.028551>
    translate  <-7.680106, 0.276451, 2.470386>
  }
  translate  -0.176182*y
}
#declare CSG090 = difference {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.070797, 0.861656, 0.101238>
    translate  <-7.677181, 0.989809, 3.059234>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <0.100513, 0.482356, 0.088282>
    translate  <-7.669951, 1.441345, 3.113952>
  }
}
#declare CSG091 = union {
  object { CSG090 }
  sphere { // Sphere212
    <0,0,0>,1
    scale 0.024978
    translate  <-7.739578, 0.873117, 3.114138>
  }
  sphere { // Sphere213
    <0,0,0>,1
    scale 0.024978
    translate  <-7.731357, 0.622612, 3.114138>
  }
  superellipsoid { // SuperQ009
    <1.0, 0.1>
    scale 0.054344
    translate  <-7.680106, 0.110335, 3.110609>
  }
  translate  -0.00976*y
}
#declare CSG092 = difference {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.070797, 0.837778, 0.101238>
    translate  <-7.677181, 0.989809, 3.059234>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <0.100513, 0.475321, 0.088282>
    translate  <-7.669951, 1.424773, 3.113952>
  }
}
#declare CSG093 = union {
  object { CSG092 }
  sphere { // Sphere214
    <0,0,0>,1
    scale 0.024978
    translate  <-7.739578, 0.873117, 3.114138>
  }
  sphere { // Sphere215
    <0,0,0>,1
    scale 0.024978
    translate  <-7.731357, 0.622612, 3.114138>
  }
  superellipsoid { // SuperQ010
    <1.0, 0.1>
    scale 0.054344
    translate  <-7.680106, 0.110335, 3.110609>
  }
  translate  <0.0, -0.00976, -0.560441>
}
#declare smokebox_hinge = union {
  object { Group044 }
  object { CSG091 }
  object { CSG093 }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <0.036795, 0.02241, 0.025472>
    translate  <-7.614953, 0.098988, 3.191022>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <0.036795, 0.02241, 0.025472>
    translate  <-7.614953, 0.098988, 2.469158>
  }
}
#declare Smokebox_door = union {
  object { smokebox_rivets }
  object { CSG088 }
  object { smokebox_handle }
  object { smokebox_hinge }
}
#declare boiler_bands = union {
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <1.12, 1.12, 0.135936>
    rotate -90.0*y
    translate  <-6.141514, 0.988032, 2.833858>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <1.12, 1.12, 0.135936>
    rotate -90.0*y
    translate  <-3.754437, 0.988032, 2.833858>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <1.12, 1.12, 0.135936>
    rotate -90.0*y
    translate  <-0.91716, 0.988032, 2.833858>
  }
  material {
    Polished_Brass
  }
  translate  <-0.026599, 0.0, 0.319189>
}
#declare CSG394 = union {
  cylinder { // Cylndr713
    <0,0,1>, <0,0,0>, 1 
    scale <0.444149, 0.444149, 0.897131>
    translate  <-2.312023, 0.973197, 3.8868>
  }
  box { // Cube861
    <-1, -1, -1>, <1, 1, 1>
    scale <0.173246, 0.781265, 0.117456>
    translate  <-2.316886, 0.962699, 4.109802>
  }
  cylinder { // Cylndr712
    <0,0,1>, <0,0,0>, 1 
    scale <0.172805, 0.234341, 1.513519>
    rotate -90.0*x
    translate  <-2.315992, 0.211393, 4.227515>
  }
}
#declare CSG395 = difference {
  superellipsoid { // SuperQ006
    <1.0, 0.079>
    scale <0.473532, 0.473532, 0.5772>
    translate  <-2.311963, 0.985981, 4.300988>
  }
  object { CSG394 }
  translate  <-0.026599, 0.0, 0.319189>
}
#declare Boiler_assy = union {
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <1.113154, 1.113154, 1.307261>
    rotate -90.0*y
    translate  <-6.220827, 0.988032, 3.151599>
  }
  cylinder { // Boiler
    <0,0,1>, <0,0,0>, 1 
    scale <1.115922, 1.115922, 6.036515>
    rotate -90.0*y
    translate  <-0.20137, 0.988032, 3.151599>
    material {
      chassis_black
      // Transform to world space
      translate  <-0.026599, 0.0, 0.319189>
    }
  }
  object { boiler_bands }
  superellipsoid { // SuperQ003
    <1.0, 0.206>
    scale <0.650477, 0.650477, 0.933595>
    translate  <-4.453542, 0.985981, 4.626066>
  }
  object { CSG395 }
  translate  <0.026599, 0.0, -0.319189>
}
#declare CSG136 = difference {
  torus { // Torus021
    1.592, 0.408  rotate -x*90
    scale 2.208534
    rotate -90.0*x
    translate  <5.760138, 0.0, 5.473759>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <2.342022, 1.0, 2.400371>
    translate  <3.403338, 0.0, 3.156863>
  }
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <4.967717, 1.172111, 2.458719>
    translate  <5.659832, 0.0, 7.935434>
  }
}
#declare CSG137 = difference {
  cone { // Cone044
    <0,0,0>, 0.874, <0,0,1>, 1.0
    scale 0.891685
    rotate <180.0, 0.0, 180.0>
    translate  <9.275553, 0.0, 6.368559>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    scale <0.732771, 0.732771, 1.223238>
    translate  <9.271396, 0.0, 5.418981>
  }
}
#declare CSG138 = union {
  object { // Torus022->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.8, -0.0, 0.0>
  }
  object { // Torus023->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.7, -0.0, 0.0>
  }
  object { // Torus024->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.6, -0.0, 0.0>
  }
  object { // Torus025->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.5, -0.0, 0.0>
  }
  object { // Torus026->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.4, -0.0, 0.0>
  }
  object { // Torus027->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.3, -0.0, 0.0>
  }
  object { // Torus028->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.2, -0.0, 0.0>
  }
  object { // Torus029->Torus030
    Torus030
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.1, -0.0, 0.0>
  }
  object { Torus030 }
  material {
    Streaky_Steel_Metal
  }
}
#declare CSG139 = difference {
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    scale <0.894129, 0.894129, 1.618535>
    rotate -90.0*y
    translate  <4.141075, 0.0, 1.962835>
  }
  object { CSG138 }
}
#declare Safety_Valve = union {
  sphere { // Sphere224
    <0,0,0>,1
    scale <0.940598, 0.110428, 0.940598>
    rotate -90.0*x
    translate  8.193771*z
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.889214, 0.889214, 2.282339>
    translate  5.919735*z
  }
  torus { // Torus018
    1.5, 0.5  rotate -x*90
    scale 0.589906
    translate  5.776495*z
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <1.177007, 1.177007, 5.773748>
  }
  torus { // Torus019
    1.833, 0.167  rotate -x*90
    scale 0.481597
    rotate -90.0*y
    translate  <2.548695, 0.0, 1.977569>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale <0.895855, 0.895855, 2.582827>
    rotate -90.0*y
    translate  <2.553211, 0.0, 1.962835>
  }
  torus { // Torus020
    1.833, 0.167  rotate -x*90
    scale 0.481597
    rotate -90.0*y
    translate  <4.133958, 0.0, 1.977569>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    scale <0.894129, 0.894129, 1.618535>
    rotate -90.0*y
    translate  <5.768457, 0.0, 1.962835>
  }
  object { CSG136 }
  object { CSG137 }
  object { CSG139 }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.191705, 0.191705, 0.725905>
    rotate -90.0*x
    translate  <-0.918081, -0.379358, 7.736894>
  }
  torus { // Torus031
    1.897, 0.103  rotate -x*90
    scale <0.297938, 0.756979, 2.305707>
    rotate -90.0*x
    translate  <-0.918081, 0.0, 6.318555>
  }
  cone { // Cone045
    <0,0,0>, 1.18, <0,0,1>, 1.555
    scale <1.0, 1.0, 0.441305>
    rotate <180.0, 0.0, 180.0>
  }
  scale 0.087539
  rotate 180.0*z
  translate  <-4.431535, 1.219751, 5.26701>
}
#declare CSG140 = difference {
  torus { // Torus035
    1.592, 0.408  rotate -x*90
    scale 2.208534
    rotate -90.0*x
    translate  <5.760138, 0.0, 5.473759>
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <2.342022, 1.0, 2.400371>
    translate  <3.403338, 0.0, 3.156863>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <4.967717, 1.172111, 2.458719>
    translate  <5.659832, 0.0, 7.935434>
  }
}
#declare CSG141 = difference {
  cone { // Cone046
    <0,0,0>, 0.874, <0,0,1>, 1.0
    scale 0.891685
    rotate <180.0, 0.0, 180.0>
    translate  <9.275553, 0.0, 6.368559>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    scale <0.732771, 0.732771, 1.223238>
    translate  <9.271396, 0.0, 5.418981>
  }
}
#declare CSG142 = union {
  object { // Torus036->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.8, -0.0, 0.0>
  }
  object { // Torus037->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.7, -0.0, 0.0>
  }
  object { // Torus038->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.6, -0.0, 0.0>
  }
  object { // Torus039->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.5, -0.0, 0.0>
  }
  object { // Torus040->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.4, -0.0, 0.0>
  }
  object { // Torus041->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.3, -0.0, 0.0>
  }
  object { // Torus042->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.2, -0.0, 0.0>
  }
  object { // Torus043->Torus044
    Torus044
    rotate <-0.0, 0.0, 0.0>
    translate  <-0.1, -0.0, 0.0>
  }
  object { Torus044 }
  material {
    Streaky_Steel_Metal
  }
}
#declare CSG143 = difference {
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    scale <0.894129, 0.894129, 1.618535>
    rotate -90.0*y
    translate  <4.141075, 0.0, 1.962835>
  }
  object { CSG142 }
}
#declare Safety_Valve1 = union {
  sphere { // Sphere225
    <0,0,0>,1
    scale <0.940598, 0.110428, 0.940598>
    rotate -90.0*x
    translate  8.193771*z
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <0.889214, 0.889214, 2.282339>
    translate  5.919735*z
  }
  torus { // Torus032
    1.5, 0.5  rotate -x*90
    scale 0.589906
    translate  5.776495*z
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <1.177007, 1.177007, 5.773748>
  }
  torus { // Torus033
    1.833, 0.167  rotate -x*90
    scale 0.481597
    rotate -90.0*y
    translate  <2.548695, 0.0, 1.977569>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <0.895855, 0.895855, 2.582827>
    rotate -90.0*y
    translate  <2.553211, 0.0, 1.962835>
  }
  torus { // Torus034
    1.833, 0.167  rotate -x*90
    scale 0.481597
    rotate -90.0*y
    translate  <4.133958, 0.0, 1.977569>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    scale <0.894129, 0.894129, 1.618535>
    rotate -90.0*y
    translate  <5.768457, 0.0, 1.962835>
  }
  object { CSG140 }
  object { CSG141 }
  object { CSG143 }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.191705, 0.191705, 0.725905>
    rotate -90.0*x
    translate  <-0.918081, -0.379358, 7.736894>
  }
  torus { // Torus045
    1.897, 0.103  rotate -x*90
    scale <0.297938, 0.756979, 2.305707>
    rotate -90.0*x
    translate  <-0.918081, 0.0, 6.318555>
  }
  cone { // Cone047
    <0,0,0>, 1.18, <0,0,1>, 1.555
    scale <1.0, 1.0, 0.441305>
    rotate <180.0, 0.0, 180.0>
  }
  scale 0.087539
  rotate 180.0*z
  translate  <-4.431535, 0.742678, 5.26701>
}
#declare Group064 = union {
  sphere { // Sphere265
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.084512, 3.168472>
  }
  sphere { // Sphere318
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.128026, 2.989971>
  }
  sphere { // Sphere319
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.154643, 2.828884>
  }
  sphere { // Sphere320
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.123672, 2.667798>
  }
  sphere { // Sphere321
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.083296, 2.498004>
  }
  sphere { // Sphere322
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.019679, 2.332564>
  }
  translate  0.045317*x
}
#declare CSG167 = difference {
  torus { // Torus056
    1.636, 0.364  rotate -x*90
    scale 0.263855
    rotate -90.0*x
    translate  <-6.906103, -0.036625, 1.479776>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    translate  <-6.87203, -0.049512, 1.176732>
  }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    rotate -61.113281*y
    translate  <-7.180568, -0.049512, 1.588496>
  }
}
#declare CSG166 = difference {
  torus { // Torus057
    1.636, 0.364  rotate -x*90
    scale 0.263855
    rotate -90.0*x
    translate  <-6.475106, -0.036625, 2.22565>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    translate  <-6.469919, -0.049512, 2.527217>
  }
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    rotate -61.113281*y
    translate  <-6.237251, -0.049512, 2.043716>
  }
}
#declare CSG168 = union {
  object { CSG167 }
  object { CSG166 }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    scale <0.096206, 0.096206, 0.397471>
    translate  <-6.476117, -0.03729, 1.081814>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale <0.096206, 0.096206, 0.598377>
    translate  <-6.904626, -0.03729, 2.226002>
  }
  translate  -0.017758*y
}
#declare CSG172 = difference {
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <1.191881, 1.191881, 0.751005>
    rotate -90.0*y
    translate  <-6.455733, 0.988032, 2.828002>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <63.597084, -0.0, -0.0>
    translate  <-6.839801, 1.031766, 3.484788>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <123.887947, -0.0, -0.0>
    translate  <-6.839801, 1.28734, 2.246862>
  }
  scale <0.497242, 0.958141, 0.958141>
  translate  <-3.505123, 0.041514, 0.121761>
}
#declare Group066 = union {
  sphere { // Sphere327
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.086072, 3.168472>
  }
  sphere { // Sphere328
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.128026, 2.989971>
  }
  sphere { // Sphere329
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.154643, 2.828884>
  }
  sphere { // Sphere330
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.123672, 2.667798>
  }
  sphere { // Sphere331
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.084085, 2.498004>
  }
  sphere { // Sphere332
    <0,0,0>,1
    scale 0.031479
    translate  <-7.08373, -0.019679, 2.332564>
  }
  translate  0.317218*x
}
#declare Group065 = union {
  object { Group064 }
  object { CSG168 }
  object { CSG172 }
  object { Group066 }
}
#declare CSG169 = difference {
  torus { // Torus058
    1.636, 0.364  rotate -x*90
    scale 0.263855
    rotate -90.0*x
    translate  <-6.906103, -0.036625, 1.479776>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    translate  <-6.87203, -0.049512, 1.176732>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    rotate -61.113281*y
    translate  <-7.180568, -0.049512, 1.588496>
  }
}
#declare CSG170 = difference {
  torus { // Torus059
    1.636, 0.364  rotate -x*90
    scale 0.263855
    rotate -90.0*x
    translate  <-6.475106, -0.036625, 2.22565>
  }
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    translate  <-6.469919, -0.049512, 2.527217>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    scale <0.629422, 0.147611, 0.30137>
    rotate -61.113281*y
    translate  <-6.237251, -0.049512, 2.043716>
  }
}
#declare CSG171 = union {
  object { CSG169 }
  object { CSG170 }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    scale <0.096206, 0.096206, 0.397471>
    translate  <-6.476117, -0.03729, 1.081814>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    scale <0.096206, 0.096206, 0.598377>
    translate  <-6.904626, -0.03729, 2.226002>
  }
  translate  -0.017758*y
}
#declare CSG173 = difference {
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    scale <1.191881, 1.191881, 0.751005>
    rotate -90.0*y
    translate  <-6.455733, 0.988032, 2.828002>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <63.597084, -0.0, -0.0>
    translate  <-6.839801, 1.031766, 3.484788>
  }
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    scale <0.456495, 0.733155, 1.336336>
    rotate <123.887947, -0.0, -0.0>
    translate  <-6.839801, 1.28734, 2.246862>
  }
  scale <0.497242, 0.958141, 0.958141>
  translate  <-3.505123, 0.041514, 0.121761>
}
#declare Group067 = union {
  sphere { // Sphere323
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.061749, 3.170883>
  }
  sphere { // Sphere333
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.105839, 2.991586>
  }
  sphere { // Sphere334
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.123474, 2.829924>
  }
  sphere { // Sphere335
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.09996, 2.668263>
  }
  sphere { // Sphere336
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.055871, 2.497784>
  }
  sphere { // Sphere337
    <0,0,0>,1
    scale 0.03148
    translate  <-6.771491, 2.011781, 2.336122>
  }
  scale -1.0
  rotate <180.0, -0.0, 180.0>
  translate  <0.0, 1.976842, 0.0>
}
#declare Group068 = union {
  sphere { // Sphere338
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.061749, 3.170883>
  }
  sphere { // Sphere339
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.105839, 2.991586>
  }
  sphere { // Sphere340
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.123474, 2.829924>
  }
  sphere { // Sphere341
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.09996, 2.668263>
  }
  sphere { // Sphere342
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.055871, 2.497784>
  }
  sphere { // Sphere343
    <0,0,0>,1
    scale 0.03148
    translate  <-7.037627, 2.011781, 2.336122>
  }
  scale -1.0
  rotate <180.0, -0.0, 180.0>
  translate  <0.0, 1.976842, 0.0>
}
#declare Group069 = union {
  object { CSG171 }
  object { CSG173 }
  object { Group067 }
  object { Group068 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.976842*y
}
#declare Cylinder_pipes = union {
  object { Group065 }
  object { Group069 }
}
#declare valve_body = union {
  cone { // Cone050
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.992683>
    translate  0.552011*z
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    scale <0.467623, 0.467623, 0.340119>
    translate  1.514446*z
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    scale <0.206964, 0.206964, 0.88225>
    translate  1.795156*z
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    scale <0.317243, 0.317243, 0.230742>
    translate  2.617235*z
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.071835, 0.071835, 0.314193>
    translate  2.832955*z
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.747213>
    translate  -0.707636*z
  }
}
#declare handwheel = union {
  sphere { // Sphere260
    <0,0,0>,1
    scale 0.173036
    translate  3.199846*z
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate -90.0*x
    translate  <0.0, -0.643528, 3.196673>
  }
  torus { // Torus060
    1.6875, 0.3125  rotate -x*90
    scale 0.393877
    translate  3.200332*z
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate <-90.0, -0.0, -90.0>
    translate  <-0.662748, 0.000318, 3.196673>
  }
  material {
    Brushed_Aluminum
  }
}
#declare valve_nut = union {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut1 = union {
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut2 = union {
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut3 = union {
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts = union {
  object { valve_nut }
  object { valve_nut1 }
  object { valve_nut2 }
  object { valve_nut3 }
  material {
    Silver_Texture
  }
}
#declare valve_assy = union {
  object { valve_body }
  object { handwheel }
  object { valve_nuts }
  scale 0.146741
  rotate 90.0*x
  translate  <-4.414364, -0.185327, 2.829775>
}
#declare valve_body1 = union {
  cone { // Cone051
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.992683>
    translate  0.552011*z
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    scale <0.467623, 0.467623, 0.340119>
    translate  1.514446*z
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <0.206964, 0.206964, 0.88225>
    translate  1.795156*z
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <0.317243, 0.317243, 0.230742>
    translate  2.617235*z
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.071835, 0.071835, 0.314193>
    translate  2.832955*z
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.747213>
    translate  -0.707636*z
  }
}
#declare handwheel1 = union {
  sphere { // Sphere261
    <0,0,0>,1
    scale 0.173036
    translate  3.199846*z
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate -90.0*x
    translate  <0.0, -0.643528, 3.196673>
  }
  torus { // Torus061
    1.6875, 0.3125  rotate -x*90
    scale 0.393877
    translate  3.200332*z
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate <-90.0, -0.0, -90.0>
    translate  <-0.662748, 0.000318, 3.196673>
  }
  material {
    Brushed_Aluminum
  }
}
#declare valve_nut4 = union {
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut5 = union {
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut6 = union {
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut7 = union {
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts1 = union {
  object { valve_nut4 }
  object { valve_nut5 }
  object { valve_nut6 }
  object { valve_nut7 }
  material {
    Silver_Texture
  }
}
#declare valve_assy1 = union {
  object { valve_body1 }
  object { handwheel1 }
  object { valve_nuts1 }
  scale 0.146741
  rotate -90.0*x
  translate  <-4.414364, 2.142843, 2.829775>
}
#declare Valve_cap = union {
  torus { // Torus092
    1.5, 0.5  rotate -x*90
    scale 0.035726
    translate  <-2.307278, 1.000456, 4.995282>
  }
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    scale <0.413416, 0.413416, 0.0285>
    translate  <-2.307505, 1.000504, 4.876208>
  }
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    scale <0.413416, 0.413416, 0.024532>
    translate  <-2.307505, 1.000504, 4.907953>
  }
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.048341, 0.048341, 0.046519>
    translate  <-2.307505, 1.000504, 4.931762>
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    scale <0.052081, 0.052081, 0.016849>
    translate  <-2.307505, 1.000504, 5.048933>
  }
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.017062, 0.017062, 0.016418>
    translate  <-2.307505, 1.000504, 5.064692>
  }
  torus { // Torus093
    1.5, 0.5  rotate -x*90
    scale 0.035726
    translate  <-2.307278, 1.000762, 5.031218>
  }
}
#declare Boiler_group = union {
  object { Chimney }
  object { Boiler_support_fr }
  object { Smokebox_door }
  object { Boiler_assy }
  object { Safety_Valve }
  object { Safety_Valve1 }
  object { Cylinder_pipes }
  object { valve_assy }
  object { valve_assy1 }
  object { Valve_cap }
}
#declare CSG153 = union {
  superellipsoid { // SuperQ020
    <0.1, 0.346>
    scale <1.448623, 0.323954, 0.825368>
    translate  <-1.140245, 0.0, -0.154087>
  }
  superellipsoid { // SuperQ021
    <1.0, 0.492>
    scale <0.944016, 0.96347, 0.321571>
    rotate -90.0*x
  }
}
#declare CSG154 = union {
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    scale <0.429503, 0.429503, 0.653437>
    rotate -20.191557*y
    translate  <-0.235816, 0.0, 0.684626>
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    scale <0.458826, 0.458826, 0.813459>
    rotate -90.0*x
    translate  -0.40089*y
  }
  translate  <-0.04109, 0.0, 0.092452>
}
#declare hook1 = difference {
  object { CSG153 }
  object { CSG154 }
  material {
    Silver_Texture
  }
  scale 0.114337
  rotate 180.0*z
  translate  <-7.787878, 0.337973, 0.576604>
}
#declare CSG146 = union {
  superellipsoid { // SuperQ018
    <0.1, 0.346>
    scale <1.448623, 0.323954, 0.825368>
    translate  <-1.140245, 0.0, -0.154087>
  }
  superellipsoid { // SuperQ019
    <1.0, 0.492>
    scale <0.944016, 0.96347, 0.321571>
    rotate -90.0*x
  }
}
#declare CSG147 = union {
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.429503, 0.429503, 0.653437>
    rotate -20.191557*y
    translate  <-0.235816, 0.0, 0.684626>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale <0.458826, 0.458826, 0.813459>
    rotate -90.0*x
    translate  -0.40089*y
  }
  translate  <-0.04109, 0.0, 0.092452>
}
#declare hook = difference {
  object { CSG146 }
  object { CSG147 }
  scale 0.737632
  translate  <-0.341078, 0.0, 0.131184>
}
#declare CSG148 = difference {
  torus { // Torus049
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
}
#declare main_link = union {
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.322028>
    translate  <-1.446357, -0.468678, -2.900471>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.322028>
    translate  <-1.446357, 0.469286, -2.900471>
  }
  object { CSG148 }
  translate  0.35568*z
}
#declare pin = union {
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    scale <0.265371, 0.265371, 1.362155>
    rotate -90.0*x
    translate  <-1.445617, -0.673978, 0.099473>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    scale <0.29886, 0.29886, 0.1254>
    rotate -90.0*x
    translate  <-1.445617, -0.795378, 0.099473>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    scale <0.29886, 0.29886, 0.1254>
    rotate -90.0*x
    translate  <-1.445617, 0.68235, 0.099473>
  }
  torus { // Torus050
    1.332, 0.668  rotate -x*90
    scale 0.24431
    rotate -90.0*x
    translate  <-1.446498, 0.466905, 0.100056>
  }
  torus { // Torus051
    1.332, 0.668  rotate -x*90
    scale 0.24431
    rotate -90.0*x
    translate  <-1.446498, -0.468317, 0.100056>
  }
}
#declare CSG149 = difference {
  torus { // Torus052
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  translate  <0.093184, 0.001247, -2.119938>
}
#declare CSG150 = difference {
  torus { // Torus053
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  rotate 180.0*x
  translate  <0.093184, 0.001247, -5.812246>
}
#declare mid_link = union {
  object { CSG149 }
  object { CSG150 }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.124767>
    translate  <-1.356281, -0.468678, -5.031748>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.117544>
    translate  <-1.352678, 0.469286, -5.026193>
  }
  rotate -90.0*z
  translate  <-1.445041, -1.35265, -0.305756>
}
#declare CSG151 = difference {
  torus { // Torus054
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  translate  <0.093184, 0.001247, -2.119938>
}
#declare CSG152 = difference {
  torus { // Torus055
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  rotate 180.0*x
  translate  <0.093184, 0.001247, -5.812246>
}
#declare end_link1 = union {
  object { CSG151 }
  object { CSG152 }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.124767>
    translate  <-1.356281, -0.468678, -5.031748>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.117544>
    translate  <-1.352678, 0.469286, -5.026193>
  }
  translate  <-0.090315, -0.000814, -3.102086>
}
#declare hook_link_assy = union {
  object { hook }
  object { main_link }
  object { pin }
  object { mid_link }
  object { end_link1 }
  material {
    Silver_Texture
  }
  scale 0.156643
  rotate 180.0*z
  translate  <-7.843592, 1.686524, 0.556736>
}
#declare buffer_body = union {
  cone { // Cone049
    <0,0,0>, 0.844, <0,0,1>, 0.895
    scale <1.0, 1.0, 1.185028>
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, -0.0, 1.257251>
  }
  superellipsoid { // SuperQ016
    <1.0, 0.111>
    scale <1.077686, 1.077686, 0.106513>
  }
  torus { // Torus048
    1.84, 0.16  rotate -x*90
    scale 0.420884
    translate  <0.0, -0.0, 1.272681>
  }
}
#declare Group052 = union {
  sphere { // Sphere226
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere229
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate -45.360439*z
}
#declare Group053 = union {
  sphere { // Sphere230
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere231
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate -89.683098*z
}
#declare Group054 = union {
  sphere { // Sphere232
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere233
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
}
#declare Group055 = union {
  sphere { // Sphere234
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere235
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate 45.00209*z
}
#declare buffer_rivets = union {
  object { Group052 }
  object { Group053 }
  object { Group054 }
  object { Group055 }
}
#declare buffer_plate = difference {
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    scale <0.212837, 1.98853, 2.188257>
    rotate -90.0*y
    translate  <1.096065, -0.0, 2.252129>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale <0.212837, 1.98853, 2.379093>
    rotate -90.0*y
    translate  <1.234854, -0.0, 2.111618>
  }
  material {
    Streaky_Steel_Metal
  }
  scale <0.826513, 1.0, 1.0>
}
#declare buffer_nut = union {
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  0.070437*x
}
#declare buffer_nut1 = union {
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  <0.0805, 0.0, -1.670093>
}
#declare buffer_nut2 = union {
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  <2.436027, 0.0, -1.670093>
}
#declare buffer_nut3 = union {
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  2.436027*x
}
#declare Group051 = union {
  object { buffer_nut }
  object { buffer_nut1 }
  object { buffer_nut2 }
  object { buffer_nut3 }
  material {
    Silver_Texture
  }
  scale 0.978601
  rotate <-90.0, 0.0, 90.0>
  translate  <-0.042299, 0.011895, -0.019158>
}
#declare buffer_assy = union {
  object { buffer_body }
  object { buffer_rivets }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.766941, 0.766941, 1.031133>
    translate  <0.0, 0.002797, 1.286738>
  }
  object { buffer_plate }
  superellipsoid { // SuperQ017
    <0.1, 0.1>
    material {
      Black_paint
    }
    scale <1.462857, 0.136176, 1.128423>
    rotate <-90.0, 0.0, 90.0>
    translate  <0.0, -0.0, -0.215956>
  }
  object { Group051 }
  scale 0.247387
  rotate <-180.0, 90.0, 0.0>
  translate  <-7.672069, 1.001209, 0.578682>
}
#declare CSG155 = union {
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG156 = difference {
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG155 }
}
#declare nut60 = union {
  object { CSG156 }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 6.355609>
}
#declare CSG157 = union {
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG158 = difference {
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG157 }
}
#declare nut61 = union {
  object { CSG158 }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 5.840821>
}
#declare Group057 = union {
  object { nut60 }
  object { nut61 }
  material {
    buffer_red
  }
  translate  <0.052204, -0.078027, 0.0>
}
#declare CSG159 = union {
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG160 = difference {
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG159 }
}
#declare nut62 = union {
  object { CSG160 }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 6.355609>
}
#declare CSG161 = union {
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG162 = difference {
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG161 }
}
#declare nut63 = union {
  object { CSG162 }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 5.840821>
}
#declare Group058 = union {
  object { nut62 }
  object { nut63 }
  material {
    buffer_red
  }
  translate  <0.052204, 1.54485, 0.0>
}
#declare Group154 = union {
  object { // Sphere607->Sphere616
    Sphere616
    rotate 0.0*z
    translate  -2.7*y
  }
  object { // Sphere608->Sphere616
    Sphere616
    rotate 0.0*z
    translate  -2.4*y
  }
  object { // Sphere609->Sphere616
    Sphere616
    rotate 0.0*z
    translate  -2.1*y
  }
  object { // Sphere614->Sphere616
    Sphere616
    rotate 0.0*z
    translate  -0.6*y
  }
  object { // Sphere615->Sphere616
    Sphere616
    rotate 0.0*z
    translate  -0.3*y
  }
  object { Sphere616 }
  material {
    buffer_red
  }
  translate  <0.08321, 0.0, -0.587643>
}
#declare Group155 = union {
  object { // Sphere610->Sphere619
    Sphere619
    rotate 0.0*z
    translate  -2.7*y
  }
  object { // Sphere611->Sphere619
    Sphere619
    rotate 0.0*z
    translate  -2.4*y
  }
  object { // Sphere612->Sphere619
    Sphere619
    rotate 0.0*z
    translate  -2.1*y
  }
  object { // Sphere617->Sphere619
    Sphere619
    rotate 0.0*z
    translate  -0.6*y
  }
  object { // Sphere618->Sphere619
    Sphere619
    rotate 0.0*z
    translate  -0.3*y
  }
  object { Sphere619 }
  material {
    buffer_red
  }
  translate  <0.08321, 0.0, -1.076093>
}
#declare Buffer_beam = union {
  object { hook1 }
  object { hook_link_assy }
  object { buffer_assy }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <0.112974, 1.537095, 0.306225>
    translate  <-7.407189, 1.00542, 0.580044>
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    material {
      buffer_red
    }
    scale <0.033122, 1.537095, 0.306225>
    translate  <-7.551904, 1.00542, 0.580044>
  }
  object { Group057 }
  object { Group058 }
  object { Group154 }
  object { Group155 }
  translate  -0.18527*x
}
#declare wheel_set = union {
  object { // Group003->Group001
    Group001
    translate  -2.217436*x
  }
  object { // Group002->Group001
    Group001
    translate  -4.431504*x
  }
  object { Group001 }
}
#declare Group032 = union {
  object { // nut15->nut12
    nut12
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut14->nut12
    nut12
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut13->nut12
    nut12
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut12 }
}
#declare Group030 = union {
  object { // nut4->nut
    nut
    translate  0.899748*x
  }
  object { // nut3->nut
    nut
    translate  0.687279*x
  }
  object { // nut2->nut
    nut
    translate  0.468577*x
  }
  object { // nut1->nut
    nut
    translate  0.237405*x
  }
  object { nut }
}
#declare CSG056 = union {
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG057 = difference {
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG056 }
}
#declare nut10 = union {
  object { CSG057 }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  -0.259718*y
}
#declare CSG058 = union {
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG059 = difference {
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG058 }
}
#declare nut11 = union {
  object { CSG059 }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  <0.900355, -0.259718, 0.0>
}
#declare Group033 = union {
  object { // nut16->nut19
    nut19
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut17->nut19
    nut19
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut18->nut19
    nut19
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut19 }
  translate  -0.423946*z
}
#declare Group031 = union {
  object { // nut5->nut9
    nut9
    translate  0.899748*x
  }
  object { // nut6->nut9
    nut9
    translate  0.687279*x
  }
  object { // nut7->nut9
    nut9
    translate  0.468577*x
  }
  object { // nut8->nut9
    nut9
    translate  0.237405*x
  }
  object { nut9 }
  translate  -0.519435*y
}
#declare CSG064 = union {
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG065 = difference {
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG064 }
}
#declare nut20 = union {
  object { CSG065 }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 0.949569>
}
#declare CSG066 = union {
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG067 = difference {
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG066 }
}
#declare nut21 = union {
  object { CSG067 }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-1.682828, 0.037172, 0.949569>
}
#declare CSG068 = union {
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG069 = difference {
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG068 }
}
#declare nut22 = union {
  object { CSG069 }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG070 = union {
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG071 = difference {
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG070 }
}
#declare nut23 = union {
  object { CSG071 }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group034 = union {
  object { nut22 }
  object { nut23 }
}
#declare CSG072 = union {
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG073 = difference {
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG072 }
}
#declare nut24 = union {
  object { CSG073 }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG074 = union {
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG075 = difference {
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG074 }
}
#declare nut25 = union {
  object { CSG075 }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group035 = union {
  object { nut24 }
  object { nut25 }
  rotate 60.0*x
  translate  <0.0, -0.110588, 0.394362>
}
#declare CSG076 = union {
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG077 = difference {
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG076 }
}
#declare nut26 = union {
  object { CSG077 }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG078 = union {
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG079 = difference {
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG078 }
}
#declare nut27 = union {
  object { CSG079 }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group036 = union {
  object { nut26 }
  object { nut27 }
  rotate -60.0*x
  translate  <0.0, -0.275427, -0.298379>
}
#declare Group037 = union {
  object { Group034 }
  object { Group035 }
  object { Group036 }
}
#declare CSG083 = union {
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG084 = difference {
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG083 }
}
#declare nut28 = union {
  object { CSG084 }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.215533, 6.451218>
}
#declare CSG085 = union {
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG086 = difference {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG085 }
}
#declare nut29 = union {
  object { CSG086 }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.507222, 6.451218>
}
#declare cylinder_nuts = union {
  object { Group032 }
  object { Group030 }
  object { nut10 }
  object { nut11 }
  object { Group033 }
  object { Group031 }
  object { nut20 }
  object { nut21 }
  object { Group037 }
  object { nut28 }
  object { nut29 }
}
#declare CSG050 = difference {
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.056158>
    rotate -90.0*y
    translate  <-7.085441, -0.302981, 0.095172>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.176949, 0.176949, 0.069589>
    rotate -90.0*y
    translate  <-7.126162, -0.302981, 0.095172>
  }
}
#declare CSG051 = union {
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.073238>
    rotate -90.0*y
    translate  <-7.003999, -0.302981, 0.095172>
  }
  object { CSG050 }
  scale <1.520248, 1.883057, 1.883057>
  translate  <9.687473, 0.364152, -0.182985>
}
#declare CSG049 = union {
  superellipsoid { // SuperQ004
    <0.1, 0.035>
    scale <1.0, 0.770644, 1.344475>
    translate  <0.0, -0.200687, 1.179741>
  }
  superellipsoid { // SuperQ005
    <1.0, 0.033>
    scale <0.768547, 0.768547, 1.003828>
    rotate 90.0*y
    translate  <-0.0, -0.200687, 0.0>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.914062, 0.726125, 0.068709>
    translate  <-0.012085, -0.203101, 2.529974>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.731697, 0.567435, 0.053679>
    rotate -90.0*x
    translate  <0.007695, -0.976504, 1.69585>
  }
  object { CSG051 }
  scale <0.559141, 0.451411, 0.451411>
  translate  <-6.469638, -0.301853, 0.095099>
}
#declare CSG080 = union {
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.303179>
  translate  <3.444236, 0.108797, -0.348024>
}
#declare CSG081 = union {
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.304373>
  translate  <3.386265, 0.108797, -0.348024>
}
#declare CSG082 = union {
  sphere { // Sphere200
    <0,0,0>,1
    scale <0.042176, 0.109883, 0.109883>
    translate  <-7.132483, -0.46555, 0.794407>
  }
  object { CSG080 }
  object { CSG081 }
  translate  0.136717*z
}
#declare Cylinder = union {
  object { cylinder_nuts }
  object { CSG049 }
  object { CSG082 }
}
#declare Group038 = union {
  object { // nut30->nut33
    nut33
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut31->nut33
    nut33
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut32->nut33
    nut33
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut33 }
}
#declare Group042 = union {
  object { // nut34->nut38
    nut38
    translate  0.899748*x
  }
  object { // nut35->nut38
    nut38
    translate  0.687279*x
  }
  object { // nut36->nut38
    nut38
    translate  0.468577*x
  }
  object { // nut37->nut38
    nut38
    translate  0.237405*x
  }
  object { nut38 }
}
#declare CSG101 = union {
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG102 = difference {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG101 }
}
#declare nut39 = union {
  object { CSG102 }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  -0.259718*y
}
#declare CSG103 = union {
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG104 = difference {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG103 }
}
#declare nut40 = union {
  object { CSG104 }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  translate  <0.900355, -0.259718, 0.0>
}
#declare Group043 = union {
  object { // nut41->nut44
    nut44
    translate  <0.725428, -0.0, 0.0>
  }
  object { // nut42->nut44
    nut44
    translate  <0.515394, -0.0, 0.0>
  }
  object { // nut43->nut44
    nut44
    translate  <0.245154, -0.0, 0.0>
  }
  object { nut44 }
  translate  -0.423946*z
}
#declare Group045 = union {
  object { // nut45->nut49
    nut49
    translate  0.899748*x
  }
  object { // nut46->nut49
    nut49
    translate  0.687279*x
  }
  object { // nut47->nut49
    nut49
    translate  0.468577*x
  }
  object { // nut48->nut49
    nut49
    translate  0.237405*x
  }
  object { nut49 }
  translate  -0.519435*y
}
#declare CSG109 = union {
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG110 = difference {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG109 }
}
#declare nut50 = union {
  object { CSG110 }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-2.407801, 0.037172, 0.949569>
}
#declare CSG111 = union {
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG112 = difference {
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG111 }
}
#declare nut51 = union {
  object { CSG112 }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.637001
  rotate 90.0*x
  translate  <-1.682828, 0.037172, 0.949569>
}
#declare CSG113 = union {
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG114 = difference {
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG113 }
}
#declare nut52 = union {
  object { CSG114 }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG115 = union {
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG116 = difference {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG115 }
}
#declare nut53 = union {
  object { CSG116 }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group046 = union {
  object { nut52 }
  object { nut53 }
}
#declare CSG117 = union {
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG118 = difference {
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG117 }
}
#declare nut54 = union {
  object { CSG118 }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG119 = union {
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG120 = difference {
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG119 }
}
#declare nut55 = union {
  object { CSG120 }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group047 = union {
  object { nut54 }
  object { nut55 }
  rotate 60.0*x
  translate  <0.0, -0.110588, 0.394362>
}
#declare CSG121 = union {
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG122 = difference {
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG121 }
}
#declare nut56 = union {
  object { CSG122 }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.868544>
}
#declare CSG123 = union {
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG124 = difference {
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG123 }
}
#declare nut57 = union {
  object { CSG124 }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.119873, -0.288903, 5.357335>
}
#declare Group048 = union {
  object { nut56 }
  object { nut57 }
  rotate -60.0*x
  translate  <0.0, -0.275427, -0.298379>
}
#declare Group049 = union {
  object { Group046 }
  object { Group047 }
  object { Group048 }
}
#declare CSG125 = union {
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG126 = difference {
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG125 }
}
#declare nut58 = union {
  object { CSG126 }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.215533, 6.451218>
}
#declare CSG127 = union {
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG128 = difference {
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG127 }
}
#declare nut59 = union {
  object { CSG128 }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.129955, -0.507222, 6.451218>
}
#declare cylinder_nuts1 = union {
  object { Group038 }
  object { Group042 }
  object { nut39 }
  object { nut40 }
  object { Group043 }
  object { Group045 }
  object { nut50 }
  object { nut51 }
  object { Group049 }
  object { nut58 }
  object { nut59 }
}
#declare CSG129 = difference {
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.056158>
    rotate -90.0*y
    translate  <-7.085441, -0.302981, 0.095172>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale <0.176949, 0.176949, 0.069589>
    rotate -90.0*y
    translate  <-7.126162, -0.302981, 0.095172>
  }
}
#declare CSG130 = union {
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <0.350141, 0.350141, 0.073238>
    rotate -90.0*y
    translate  <-7.003999, -0.302981, 0.095172>
  }
  object { CSG129 }
  scale <1.520248, 1.883057, 1.883057>
  translate  <9.687473, 0.364152, -0.182985>
}
#declare CSG131 = union {
  superellipsoid { // SuperQ013
    <0.1, 0.035>
    scale <1.0, 0.770644, 1.344475>
    translate  <0.0, -0.200687, 1.179741>
  }
  superellipsoid { // SuperQ014
    <1.0, 0.033>
    scale <0.768547, 0.768547, 1.003828>
    rotate 90.0*y
    translate  <-0.0, -0.200687, 0.0>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <0.914062, 0.726125, 0.068709>
    translate  <-0.012085, -0.203101, 2.529974>
  }
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    scale <0.731697, 0.567435, 0.053679>
    rotate -90.0*x
    translate  <0.007695, -0.976504, 1.69585>
  }
  object { CSG130 }
  scale <0.559141, 0.451411, 0.451411>
  translate  <-6.469638, -0.301853, 0.095099>
}
#declare CSG132 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.303179>
  translate  <3.444236, 0.108797, -0.348024>
}
#declare CSG133 = union {
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.10981, 0.10981, 0.036469>
    rotate -90.0*y
    translate  <-7.020875, -0.389157, 0.877934>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.442959, 0.877934>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <0.094605, 0.079649, 0.036289>
    rotate -90.0*y
    translate  <-7.020875, -0.336399, 0.877934>
  }
  scale <1.490561, 1.475218, 1.304373>
  translate  <3.386265, 0.108797, -0.348024>
}
#declare CSG134 = union {
  sphere { // Sphere218
    <0,0,0>,1
    scale <0.042176, 0.109883, 0.109883>
    translate  <-7.132483, -0.46555, 0.794407>
  }
  object { CSG132 }
  object { CSG133 }
  translate  0.136717*z
}
#declare Cylinder1 = union {
  object { cylinder_nuts1 }
  object { CSG131 }
  object { CSG134 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.011276*y
}
#declare brake_rod_l = union {
  box { // Cube753
    <-1, -1, -1>, <1, 1, 1>
    scale <0.497961, 0.010264, 0.049412>
    rotate 8.209605*y
    translate  <3.328826, 0.175395, -0.244442>
  }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    scale <0.108959, 0.108959, 0.023226>
    rotate -90.0*x
    translate  <2.845954, 0.161663, -0.235386>
  }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    scale <0.066926, 0.066926, 0.023226>
    rotate -90.0*x
    translate  <3.825017, 0.161663, -0.332935>
  }
  box { // Cube754
    <-1, -1, -1>, <1, 1, 1>
    scale <0.497961, 0.010264, 0.049412>
    rotate <-0.0, 2.861063, -0.0>
    translate  <3.332904, 0.175395, -0.317857>
  }
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.072252, 0.072252, 0.086394>
    rotate -90.0*x
    translate  <2.845954, 0.155816, -0.235386>
  }
  box { // Cube755
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    translate  <3.826415, 0.146163, -0.317857>
  }
  box { // Cube756
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    translate  <3.826415, 0.196832, -0.317857>
  }
  box { // Cube757
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.028691>
    rotate <-30.0, -0.0, -0.0>
    translate  <3.826415, 0.159675, -0.210431>
  }
  box { // Cube758
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.028691>
    rotate <30.0, -0.0, -0.0>
    translate  <3.826415, 0.183698, -0.210431>
  }
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.033295, 0.033295, 0.070809>
    rotate -90.0*x
    translate  <3.825017, 0.136072, -0.332935>
  }
  cylinder { // Cylndr667
    <0,0,1>, <0,0,0>, 1 
    material {
      chassis_black
    }
    scale <0.013878, 0.013878, 1.276415>
    translate  <3.825017, 0.171702, -0.207152>
  }
  sphere { // Sphere567
    <0,0,0>,1
    scale 0.019574
    translate  <2.664659, 0.221627, -0.390959>
  }
  box { // Cube759
    <-1, -1, -1>, <1, 1, 1>
    scale <0.126155, 0.010264, 0.0681>
    rotate -45.0*y
    translate  <2.762451, 0.233005, -0.292989>
  }
  box { // Cube760
    <-1, -1, -1>, <1, 1, 1>
    scale <0.158519, 0.010264, 0.057312>
    translate  <2.78133, 0.233005, -0.387384>
  }
  sphere { // Sphere568
    <0,0,0>,1
    scale 0.019574
    translate  <2.783328, 0.221627, -0.390959>
  }
  sphere { // Sphere569
    <0,0,0>,1
    scale 0.019574
    translate  <2.8993, 0.221627, -0.390959>
  }
  cone { // Cone067
    <0,0,0>, 0.828, <0,0,1>, 1.775
    scale <0.036624, 0.009782, 0.405187>
    rotate 4.936576*y
    translate  <2.807865, 0.268139, -0.678873>
  }
  box { // Cube761
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    rotate <0.0, -90.0, 0.0>
    translate  <2.775612, 0.241717, -0.651436>
  }
  box { // Cube762
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    rotate <0.0, -90.0, 0.0>
    translate  <2.775612, 0.296797, -0.650799>
  }
  box { // Cube763
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.033952>
    rotate <-90.0, -90.0, 0.0>
    translate  <2.693014, 0.268888, -0.651436>
  }
  cylinder { // Cylndr668
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.029239, 0.029239, 0.076376>
    rotate -90.0*x
    translate  <2.811969, 0.230542, -0.648706>
  }
  cylinder { // Cylndr669
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_stl
    }
    scale <0.029239, 0.029239, 8.500223>
    rotate <90.0, 0.0, -90.0>
    translate  <2.702037, 0.270755, -0.65009>
  }
  box { // Cube764
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047689, 0.006366, 0.0547>
    rotate -90.0*y
    translate  <-5.733438, 0.230533, -0.651436>
  }
  box { // Cube765
    <-1, -1, -1>, <1, 1, 1>
    scale <0.466618, 0.006366, 0.0547>
    rotate -90.0*y
    translate  <-5.733438, 0.168969, -0.049226>
  }
  box { // Cube766
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072577, 0.006366, 0.0547>
    rotate <90.0, -55.819557, -90.0>
    translate  <-5.733438, 0.209575, -0.571534>
  }
  cylinder { // Cylndr670
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_stl
    }
    scale <0.039712, 0.039712, 0.136069>
    rotate <90.0, 0.0, -90.0>
    translate  <-5.666064, 0.271139, -0.6514>
  }
  sphere { // Sphere570
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.438088>
  }
  sphere { // Sphere571
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.2967>
  }
  sphere { // Sphere572
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.129129>
  }
  sphere { // Sphere573
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, 0.206014>
  }
  sphere { // Sphere574
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, 0.347403>
  }
  material {
    Wheel_stl
  }
  translate  -0.03313*y
}
#declare brake_rod_r = union {
  box { // Cube767
    <-1, -1, -1>, <1, 1, 1>
    scale <0.497961, 0.010264, 0.049412>
    rotate 8.209605*y
    translate  <3.328826, 0.175395, -0.244442>
  }
  cylinder { // Cylndr671
    <0,0,1>, <0,0,0>, 1 
    scale <0.108959, 0.108959, 0.023226>
    rotate -90.0*x
    translate  <2.845954, 0.161663, -0.235386>
  }
  cylinder { // Cylndr672
    <0,0,1>, <0,0,0>, 1 
    scale <0.066926, 0.066926, 0.023226>
    rotate -90.0*x
    translate  <3.825017, 0.161663, -0.332935>
  }
  box { // Cube768
    <-1, -1, -1>, <1, 1, 1>
    scale <0.497961, 0.010264, 0.049412>
    rotate <-0.0, 2.861063, -0.0>
    translate  <3.332904, 0.175395, -0.317857>
  }
  cylinder { // Cylndr673
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.072252, 0.072252, 0.086394>
    rotate -90.0*x
    translate  <2.845954, 0.155816, -0.235386>
  }
  box { // Cube769
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    translate  <3.826415, 0.146163, -0.317857>
  }
  box { // Cube770
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    translate  <3.826415, 0.196832, -0.317857>
  }
  box { // Cube771
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.028691>
    rotate <-30.0, -0.0, -0.0>
    translate  <3.826415, 0.159675, -0.210431>
  }
  box { // Cube772
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.028691>
    rotate <30.0, -0.0, -0.0>
    translate  <3.826415, 0.183698, -0.210431>
  }
  cylinder { // Cylndr674
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.033295, 0.033295, 0.070809>
    rotate -90.0*x
    translate  <3.825017, 0.136072, -0.332935>
  }
  cylinder { // Cylndr675
    <0,0,1>, <0,0,0>, 1 
    material {
      chassis_black
    }
    scale <0.013878, 0.013878, 1.276415>
    translate  <3.825017, 0.171702, -0.207152>
  }
  sphere { // Sphere575
    <0,0,0>,1
    scale 0.019574
    translate  <2.664659, 0.221627, -0.390959>
  }
  box { // Cube773
    <-1, -1, -1>, <1, 1, 1>
    scale <0.126155, 0.010264, 0.0681>
    rotate -45.0*y
    translate  <2.762451, 0.233005, -0.292989>
  }
  box { // Cube774
    <-1, -1, -1>, <1, 1, 1>
    scale <0.158519, 0.010264, 0.057312>
    translate  <2.78133, 0.233005, -0.387384>
  }
  sphere { // Sphere576
    <0,0,0>,1
    scale 0.019574
    translate  <2.783328, 0.221627, -0.390959>
  }
  sphere { // Sphere577
    <0,0,0>,1
    scale 0.019574
    translate  <2.8993, 0.221627, -0.390959>
  }
  cone { // Cone068
    <0,0,0>, 0.828, <0,0,1>, 1.775
    scale <0.036624, 0.009782, 0.405187>
    rotate 4.936576*y
    translate  <2.807865, 0.268139, -0.678873>
  }
  box { // Cube775
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    rotate <0.0, -90.0, 0.0>
    translate  <2.775612, 0.241717, -0.651436>
  }
  box { // Cube776
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.08612>
    rotate <0.0, -90.0, 0.0>
    translate  <2.775612, 0.296797, -0.650799>
  }
  box { // Cube777
    <-1, -1, -1>, <1, 1, 1>
    scale <0.041157, 0.006366, 0.033952>
    rotate <-90.0, -90.0, 0.0>
    translate  <2.693014, 0.268888, -0.651436>
  }
  cylinder { // Cylndr676
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.029239, 0.029239, 0.076376>
    rotate -90.0*x
    translate  <2.811969, 0.230542, -0.648706>
  }
  cylinder { // Cylndr677
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_stl
    }
    scale <0.029239, 0.029239, 8.500223>
    rotate <90.0, 0.0, -90.0>
    translate  <2.702037, 0.270755, -0.65009>
  }
  box { // Cube778
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047689, 0.006366, 0.0547>
    rotate -90.0*y
    translate  <-5.733438, 0.230533, -0.651436>
  }
  box { // Cube779
    <-1, -1, -1>, <1, 1, 1>
    scale <0.466618, 0.006366, 0.0547>
    rotate -90.0*y
    translate  <-5.733438, 0.168969, -0.049226>
  }
  box { // Cube780
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072577, 0.006366, 0.0547>
    rotate <90.0, -55.819557, -90.0>
    translate  <-5.733438, 0.209575, -0.571534>
  }
  cylinder { // Cylndr678
    <0,0,1>, <0,0,0>, 1 
    material {
      Wheel_stl
    }
    scale <0.039712, 0.039712, 0.136069>
    rotate <90.0, 0.0, -90.0>
    translate  <-5.666064, 0.271139, -0.6514>
  }
  sphere { // Sphere578
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.438088>
  }
  sphere { // Sphere579
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.2967>
  }
  sphere { // Sphere580
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, -0.129129>
  }
  sphere { // Sphere581
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, 0.206014>
  }
  sphere { // Sphere582
    <0,0,0>,1
    scale 0.019574
    translate  <-5.734862, 0.163067, 0.347403>
  }
  material {
    Wheel_stl
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.12592*y
}
#declare Running_gear = union {
  object { wheel_set }
  object { Cylinder }
  object { Cylinder1 }
  object { brake_rod_l }
  object { brake_rod_r }
}
#declare CSG035 = union {
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <0.437122, 0.463827, 0.130077>
    rotate -90.0*x
    translate  <3.634556, -1.178315, 6.17947>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <0.437122, 0.463827, 0.130077>
    rotate -90.0*x
    translate  <2.281512, -1.178315, 6.17947>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.116077, -1.231228, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <2.96154, -1.111677, 4.948178>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.671014, -0.364784, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <2.96154, -1.111677, 6.276726>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.839891, -1.40602, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <3.233439, -1.111677, 2.384564>
  }
}
#declare CSG036 = difference {
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <2.233481, 2.811945, 0.019109>
    rotate -90.0*x
    translate  <2.062167, -1.114969, 3.885282>
  }
  object { CSG035 }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.059078, -0.35473, -0.070174>
    rotate <90.0, 0.0, 180.0>
    translate  <0.838043, -1.111677, 4.051457>
  }
}
#declare CSG037 = union {
  object { CSG036 }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15813, 1.211258, 0.019109>
    rotate -90.0*x
    translate  <2.466971, -1.114969, 2.300465>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    scale <0.22619, 0.226529, 0.041863>
    rotate -90.0*x
    translate  <2.412007, -1.137342, 3.490091>
  }
}
#declare Group014 = union {
  object { // Sphere128->Sphere124
    Sphere124
    rotate -0.0*z
    translate  -5.322519*z
  }
  object { // Sphere127->Sphere124
    Sphere124
    rotate -0.0*z
    translate  -0.920111*z
  }
  object { // Sphere126->Sphere124
    Sphere124
    rotate -0.0*z
    translate  -0.8*z
  }
  object { // Sphere125->Sphere124
    Sphere124
    rotate -0.0*z
    translate  -0.4*z
  }
  object { Sphere124 }
}
#declare Group012 = union {
  object { // Sphere116->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <2.4, 0.0, -0.0>
  }
  object { // Sphere115->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <2.0, 0.0, -0.0>
  }
  object { // Sphere114->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere113->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere112->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere111->Sphere110
    Sphere110
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere110 }
}
#declare Group010 = union {
  object { // Sphere104->Sphere083
    Sphere083
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere098->Sphere083
    Sphere083
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere097->Sphere083
    Sphere083
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere084->Sphere083
    Sphere083
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere083 }
}
#declare Group008 = union {
  object { // Sphere090->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.8>
  }
  object { // Sphere089->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.4>
  }
  object { // Sphere088->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.0>
  }
  object { // Sphere087->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.6>
  }
  object { // Sphere086->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.2>
  }
  object { // Sphere085->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -2.8>
  }
  object { // Sphere082->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.6>
  }
  object { // Sphere081->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.2>
  }
  object { // Sphere080->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.8>
  }
  object { // Sphere079->Sphere078
    Sphere078
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.4>
  }
  object { Sphere078 }
}
#declare Group009 = union {
  object { // Sphere091->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.8>
  }
  object { // Sphere092->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.4>
  }
  object { // Sphere093->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.0>
  }
  object { // Sphere094->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.6>
  }
  object { // Sphere095->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.2>
  }
  object { // Sphere096->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -2.8>
  }
  object { // Sphere099->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.6>
  }
  object { // Sphere100->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.2>
  }
  object { // Sphere101->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.8>
  }
  object { // Sphere102->Sphere103
    Sphere103
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.4>
  }
  object { Sphere103 }
  translate  1.841723*x
}
#declare Group011 = union {
  object { // Sphere105->Sphere109
    Sphere109
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere106->Sphere109
    Sphere109
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere107->Sphere109
    Sphere109
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere108->Sphere109
    Sphere109
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere109 }
  translate  1.165469*z
}
#declare Group013 = union {
  object { // Sphere117->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <2.4, 0.0, -0.063249>
  }
  object { // Sphere118->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <2.0, 0.0, -0.0>
  }
  object { // Sphere119->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere120->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere121->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere122->Sphere123
    Sphere123
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere123 }
  translate  2.440079*z
}
#declare Group024 = union {
  object { // Sphere187->Sphere186
    Sphere186
    translate  0.257423*x
  }
  object { Sphere186 }
}
#declare Group022 = union {
  object { // Sphere182->Sphere180
    Sphere180
    rotate 0.0*z
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere181->Sphere180
    Sphere180
    rotate 0.0*z
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere180 }
  translate  -0.065805*x
}
#declare Group023 = union {
  object { // Sphere183->Sphere185
    Sphere185
    rotate 0.0*z
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere184->Sphere185
    Sphere185
    rotate 0.0*z
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere185 }
  translate  <-0.065805, 0.0, -1.71092>
}
#declare Group025 = union {
  object { // Sphere188->Sphere189
    Sphere189
    translate  0.257423*x
  }
  object { Sphere189 }
  translate  -0.153544*z
}
#declare side_rivets = union {
  object { Group014 }
  object { Group012 }
  object { Group010 }
  object { Group008 }
  object { Group009 }
  object { Group011 }
  object { Group013 }
  object { Group024 }
  object { Group022 }
  object { Group023 }
  object { Group025 }
}
#declare CSG038 = union {
  torus { // Torus005
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 3.192466>
  }
  torus { // Torus006
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 2.20259>
  }
}
#declare CSG039 = difference {
  object { CSG038 }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072968, 0.255184, 0.489169>
    translate  <2.546249, -1.119281, 2.696591>
  }
}
#declare handrail1 = union {
  object { CSG039 }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <0.02984, 0.02984, 0.988189>
    rotate -90.0*z
    translate  <2.545897, -1.326722, 2.202871>
  }
  material {
    handle_colour
  }
}
#declare CSG040 = union {
  torus { // Torus007
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 3.192466>
  }
  torus { // Torus008
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 2.20259>
  }
}
#declare CSG041 = difference {
  object { CSG040 }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072968, 0.255184, 0.489169>
    translate  <2.546249, -1.119281, 2.696591>
  }
}
#declare handrail2 = union {
  object { CSG041 }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.02984, 0.02984, 0.988189>
    rotate -90.0*z
    translate  <2.545897, -1.326722, 2.202871>
  }
  material {
    handle_colour
  }
  translate  1.650987*x
}
#declare cab_left = union {
  object { CSG037 }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 1.582177, 0.019109>
    rotate -90.0*x
    translate  <1.783913, -1.079034, 5.090017>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 1.582177, 0.019109>
    rotate -90.0*x
    translate  <-0.063114, -1.079034, 5.090017>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 0.864365, 0.019109>
    rotate <90.0, -90.0, 0.0>
    translate  <0.860623, -1.079034, 3.757092>
  }
  object { side_rivets }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.822226, 1.271486, 0.019109>
    rotate -90.0*x
    translate  <3.313408, -1.075931, 2.34542>
  }
  object { handrail1 }
  object { handrail2 }
  box { // Cube794
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.919765, -0.013035, -0.276573>
    rotate <90.0, 0.0, 180.0>
    translate  <0.881584, -0.793078, 4.423152>
  }
  box { // Cube795
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.578772, -0.013035, -0.276573>
    rotate <-90.0, 90.0, 0.0>
    translate  <1.76954, -0.793078, 3.845198>
  }
  box { // Cube796
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.919765, -0.013035, -0.611786>
    rotate <0.0, -0.0, -180.0>
    translate  <0.881584, -0.527219, 3.833639>
  }
}
#declare CSG013 = union {
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.180287, 2.118213, 0.03662>
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.135607, 0.992107, 6.716344>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <2.819539, 2.129197, 0.019109>
    rotate -90.0*y
    translate  <-0.154041, 0.992944, 3.891427>
  }
}
#declare CSG015 = union {
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <0.423537, 0.423537, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.42354, 0.42354, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.422074, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale 1.02
  translate  <-0.016573, -0.04967, 0.051892>
}
#declare CSG014 = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.520445, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  translate  0.168651*z
}
#declare CSG020 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.520445, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  translate  <0.0, -2.462939, 0.168651>
}
#declare CSG021 = union {
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.423537, 0.423537, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.42354, 0.42354, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.422074, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale 1.02
  translate  <-0.016573, -2.512609, 0.051892>
}
#declare CSG017 = union {
  object { CSG013 }
  object { CSG015 }
  object { CSG014 }
  object { CSG020 }
  object { CSG021 }
}
#declare CSG016 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale <5.855895, 1.0, 1.0>
  translate  <0.854925, 0.0, 0.155677>
}
#declare CSG022 = union {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale <5.855895, 1.0, 1.0>
  translate  <0.854925, -2.462939, 0.155677>
}
#declare CSG018 = difference {
  object { CSG017 }
  object { CSG016 }
  object { CSG022 }
}
#declare CSG019 = merge {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  material {
    Glass
  }
  scale <0.957594, 1.0, 1.0>
  translate  <-0.009755, 0.0, 0.155677>
}
#declare CSG023 = merge {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  material {
    Glass
  }
  scale <0.957594, 1.0, 1.0>
  translate  <-0.009755, -2.462939, 0.155677>
}
#declare window_rivets = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 6.312933>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.165116, 6.312933>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.701035, 5.470018>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 1.754124, 5.475491>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 4.616157>
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.153688, 4.62163>
  }
}
#declare Group004 = union {
  object { // Sphere028->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -5.2>
  }
  object { // Sphere027->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.8>
  }
  object { // Sphere026->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.4>
  }
  object { // Sphere025->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.0>
  }
  object { // Sphere024->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.6>
  }
  object { // Sphere023->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.2>
  }
  object { // Sphere022->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.8>
  }
  object { // Sphere021->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.4>
  }
  object { // Sphere020->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.0>
  }
  object { // Sphere019->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.6>
  }
  object { // Sphere018->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.2>
  }
  object { // Sphere017->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.8>
  }
  object { // Sphere016->Sphere015
    Sphere015
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.4>
  }
  object { Sphere015 }
}
#declare Group005 = union {
  object { // Sphere029->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -5.2>
  }
  object { // Sphere030->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.8>
  }
  object { // Sphere031->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.4>
  }
  object { // Sphere032->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.0>
  }
  object { // Sphere033->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.6>
  }
  object { // Sphere034->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.2>
  }
  object { // Sphere035->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.8>
  }
  object { // Sphere036->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.4>
  }
  object { // Sphere037->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.0>
  }
  object { // Sphere038->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.6>
  }
  object { // Sphere039->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.2>
  }
  object { // Sphere040->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.8>
  }
  object { // Sphere041->Sphere042
    Sphere042
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.4>
  }
  object { Sphere042 }
  translate  -4.121887*y
}
#declare cab_rivets = union {
  object { Group004 }
  object { Group005 }
}
#declare window_rivets1 = union {
  sphere { // Sphere008
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 6.312933>
  }
  sphere { // Sphere010
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.165116, 6.312933>
  }
  sphere { // Sphere011
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.701035, 5.470018>
  }
  sphere { // Sphere012
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 1.754124, 5.475491>
  }
  sphere { // Sphere013
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 4.616157>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.153688, 4.62163>
  }
  translate  -2.465485*y
}
#declare cab_front = union {
  object { CSG018 }
  object { CSG019 }
  object { CSG023 }
  object { window_rivets }
  object { cab_rivets }
  object { window_rivets1 }
}
#declare CSG024 = union {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.180287, 2.118213, 0.03662>
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.135607, 0.992107, 6.716344>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <2.819539, 2.129197, 0.019109>
    rotate -90.0*y
    translate  <-0.154041, 0.992944, 3.891427>
  }
}
#declare CSG025 = union {
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.423537, 0.423537, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.42354, 0.42354, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.422074, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale 1.02
  translate  <-0.016573, -0.04967, 0.051892>
}
#declare CSG026 = union {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.520445, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  translate  0.168651*z
}
#declare CSG027 = union {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.520445, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.520445, 0.520445, 0.020319>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  translate  <0.0, -2.462939, 0.168651>
}
#declare CSG028 = union {
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <0.423537, 0.423537, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.42354, 0.42354, 0.016536>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.422074, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale 1.02
  translate  <-0.016573, -2.512609, 0.051892>
}
#declare CSG029 = union {
  object { CSG024 }
  object { CSG025 }
  object { CSG026 }
  object { CSG027 }
  object { CSG028 }
}
#declare CSG030 = union {
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale <5.855895, 1.0, 1.0>
  translate  <0.854925, 0.0, 0.155677>
}
#declare CSG031 = union {
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  scale <5.855895, 1.0, 1.0>
  translate  <0.854925, -2.462939, 0.155677>
}
#declare CSG032 = difference {
  object { CSG029 }
  object { CSG030 }
  object { CSG031 }
}
#declare CSG033 = merge {
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  material {
    Glass
  }
  scale <0.957594, 1.0, 1.0>
  translate  <-0.009755, 0.0, 0.155677>
}
#declare CSG034 = merge {
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <0.395963, 0.395963, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 5.682724>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.395966, 0.395966, 0.015459>
    rotate -90.0*y
    translate  <-0.166709, 2.22993, 4.915436>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00952, 0.394499, 0.376579>
    translate  <-0.177205, 2.22993, 5.293293>
  }
  material {
    Glass
  }
  scale <0.957594, 1.0, 1.0>
  translate  <-0.009755, -2.462939, 0.155677>
}
#declare window_rivets2 = union {
  sphere { // Sphere043
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 6.312933>
  }
  sphere { // Sphere045
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.165116, 6.312933>
  }
  sphere { // Sphere046
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.701035, 5.470018>
  }
  sphere { // Sphere047
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 1.754124, 5.475491>
  }
  sphere { // Sphere048
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.285051, 4.616157>
  }
  sphere { // Sphere049
    <0,0,0>,1
    scale 0.031479
    translate  <-0.180287, 2.153688, 4.62163>
  }
}
#declare Group006 = union {
  object { // Sphere050->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -5.2>
  }
  object { // Sphere051->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.8>
  }
  object { // Sphere052->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.4>
  }
  object { // Sphere053->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.0>
  }
  object { // Sphere054->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.6>
  }
  object { // Sphere055->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.2>
  }
  object { // Sphere056->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.8>
  }
  object { // Sphere057->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.4>
  }
  object { // Sphere058->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.0>
  }
  object { // Sphere059->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.6>
  }
  object { // Sphere060->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.2>
  }
  object { // Sphere061->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.8>
  }
  object { // Sphere062->Sphere063
    Sphere063
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.4>
  }
  object { Sphere063 }
}
#declare Group007 = union {
  object { // Sphere064->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -5.2>
  }
  object { // Sphere065->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.8>
  }
  object { // Sphere066->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.4>
  }
  object { // Sphere067->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -4.0>
  }
  object { // Sphere068->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.6>
  }
  object { // Sphere069->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -3.2>
  }
  object { // Sphere070->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.8>
  }
  object { // Sphere071->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.4>
  }
  object { // Sphere072->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -2.0>
  }
  object { // Sphere073->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.6>
  }
  object { // Sphere074->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -1.2>
  }
  object { // Sphere075->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.8>
  }
  object { // Sphere076->Sphere077
    Sphere077
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, -0.4>
  }
  object { Sphere077 }
  translate  -4.121887*y
}
#declare cab_rivets1 = union {
  object { Group006 }
  object { Group007 }
}
#declare Group091 = union {
  object { // Sphere370->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 3.3, 0.0>
  }
  object { // Sphere369->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 3.0, 0.0>
  }
  object { // Sphere368->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 2.7, 0.0>
  }
  object { // Sphere367->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 2.4, 0.0>
  }
  object { // Sphere366->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 2.1, 0.0>
  }
  object { // Sphere365->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 1.8, 0.0>
  }
  object { // Sphere364->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 1.5, 0.0>
  }
  object { // Sphere363->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 1.2, 0.0>
  }
  object { // Sphere362->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 0.9, 0.0>
  }
  object { // Sphere361->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 0.6, 0.0>
  }
  object { // Sphere360->Sphere359
    Sphere359
    rotate 0.0*y
    translate  <0.0, 0.3, 0.0>
  }
  object { Sphere359 }
  translate  <0.0, 0.047607, -0.374055>
}
#declare Group092 = union {
  object { // Sphere371->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 3.3, 0.0>
  }
  object { // Sphere372->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 3.0, 0.0>
  }
  object { // Sphere373->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 2.7, 0.0>
  }
  object { // Sphere374->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 2.4, 0.0>
  }
  object { // Sphere375->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 2.1, 0.0>
  }
  object { // Sphere376->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 1.8, 0.0>
  }
  object { // Sphere377->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 1.5, 0.0>
  }
  object { // Sphere378->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 1.2, 0.0>
  }
  object { // Sphere379->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 0.9, 0.0>
  }
  object { // Sphere380->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 0.6, 0.0>
  }
  object { // Sphere381->Sphere382
    Sphere382
    rotate 0.0*y
    translate  <0.0, 0.3, 0.0>
  }
  object { Sphere382 }
  translate  <0.0, 0.047607, -0.54408>
}
#declare Group094 = union {
  object { // Sphere391->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -2.4>
  }
  object { // Sphere390->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -2.1>
  }
  object { // Sphere389->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -1.8>
  }
  object { // Sphere388->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -1.5>
  }
  object { // Sphere387->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -1.2>
  }
  object { // Sphere386->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -0.9>
  }
  object { // Sphere385->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -0.6>
  }
  object { // Sphere384->Sphere383
    Sphere383
    rotate -0.0*z
    translate  <0.0, 0.0, -0.3>
  }
  object { Sphere383 }
}
#declare CSG241 = union {
  box { // Cube476
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054095, 0.020655, 1.30736>
    translate  <4.261945, 0.231234, 2.186092>
  }
  box { // Cube477
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054095, 0.020655, 1.30736>
    translate  <4.261945, 0.013602, 2.186092>
  }
  box { // Cube478
    <-1, -1, -1>, <1, 1, 1>
    scale <0.092686, 0.008376, 1.30736>
    rotate -90.0*z
    translate  <4.233879, 0.120724, 2.186092>
  }
}
#declare Group095 = union {
  object { Group094 }
  object { CSG241 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.01336, 0.0, -0.0>
}
#declare Group096 = union {
  object { // Sphere392->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -2.4>
  }
  object { // Sphere393->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -2.1>
  }
  object { // Sphere394->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -1.8>
  }
  object { // Sphere395->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -1.5>
  }
  object { // Sphere396->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -1.2>
  }
  object { // Sphere397->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -0.9>
  }
  object { // Sphere398->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -0.6>
  }
  object { // Sphere399->Sphere400
    Sphere400
    rotate -0.0*z
    translate  <0.0, 0.0, -0.3>
  }
  object { Sphere400 }
}
#declare CSG242 = union {
  box { // Cube479
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054095, 0.020655, 1.30736>
    translate  <4.261945, 0.231234, 2.186092>
  }
  box { // Cube480
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054095, 0.020655, 1.30736>
    translate  <4.261945, 0.013602, 2.186092>
  }
  box { // Cube481
    <-1, -1, -1>, <1, 1, 1>
    scale <0.092686, 0.008376, 1.30736>
    rotate -90.0*z
    translate  <4.233879, 0.120724, 2.186092>
  }
}
#declare Group097 = union {
  object { Group096 }
  object { CSG242 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.01336, 1.720654, -0.0>
}
#declare Group093 = union {
  object { Group091 }
  object { Group092 }
  box { // Cube474
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014204, 2.040554, 0.081688>
    translate  <4.202719, 0.986146, 3.747354>
  }
  box { // Cube475
    <-1, -1, -1>, <1, 1, 1>
    scale <0.014204, 2.040554, 0.083036>
    translate  <4.202719, 0.986146, 3.578133>
  }
  object { Group095 }
  object { Group097 }
  scale 1.020408
  rotate <0.0, 0.0, 180.0>
  translate  <4.111305, 2.002181, -0.004507>
}
#declare CSG223 = union {
  superellipsoid { // SuperQ022
    <0.1, 0.346>
    scale <1.448623, 0.323954, 0.825368>
    translate  <-1.140245, 0.0, -0.154087>
  }
  superellipsoid { // SuperQ023
    <1.0, 0.492>
    scale <0.944016, 0.96347, 0.321571>
    rotate -90.0*x
  }
}
#declare CSG224 = union {
  box { // Cube439
    <-1, -1, -1>, <1, 1, 1>
    scale <0.429503, 0.429503, 0.653437>
    rotate -20.191557*y
    translate  <-0.235816, 0.0, 0.684626>
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    scale <0.458826, 0.458826, 0.813459>
    rotate -90.0*x
    translate  -0.40089*y
  }
  translate  <-0.04109, 0.0, 0.092452>
}
#declare hook2 = difference {
  object { CSG223 }
  object { CSG224 }
  material {
    Silver_Texture
  }
  scale 0.114337
  rotate 180.0*z
  translate  <-7.787878, 0.337973, 0.576604>
}
#declare CSG225 = union {
  superellipsoid { // SuperQ024
    <0.1, 0.346>
    scale <1.448623, 0.323954, 0.825368>
    translate  <-1.140245, 0.0, -0.154087>
  }
  superellipsoid { // SuperQ025
    <1.0, 0.492>
    scale <0.944016, 0.96347, 0.321571>
    rotate -90.0*x
  }
}
#declare CSG226 = union {
  box { // Cube440
    <-1, -1, -1>, <1, 1, 1>
    scale <0.429503, 0.429503, 0.653437>
    rotate -20.191557*y
    translate  <-0.235816, 0.0, 0.684626>
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    scale <0.458826, 0.458826, 0.813459>
    rotate -90.0*x
    translate  -0.40089*y
  }
  translate  <-0.04109, 0.0, 0.092452>
}
#declare hook3 = difference {
  object { CSG225 }
  object { CSG226 }
  scale 0.737632
  translate  <-0.341078, 0.0, 0.131184>
}
#declare CSG227 = difference {
  torus { // Torus080
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube441
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
}
#declare main_link1 = union {
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.322028>
    translate  <-1.446357, -0.468678, -2.900471>
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.322028>
    translate  <-1.446357, 0.469286, -2.900471>
  }
  object { CSG227 }
  translate  0.35568*z
}
#declare pin1 = union {
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    scale <0.265371, 0.265371, 1.362155>
    rotate -90.0*x
    translate  <-1.445617, -0.673978, 0.099473>
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    scale <0.29886, 0.29886, 0.1254>
    rotate -90.0*x
    translate  <-1.445617, -0.795378, 0.099473>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    scale <0.29886, 0.29886, 0.1254>
    rotate -90.0*x
    translate  <-1.445617, 0.68235, 0.099473>
  }
  torus { // Torus081
    1.332, 0.668  rotate -x*90
    scale 0.24431
    rotate -90.0*x
    translate  <-1.446498, 0.466905, 0.100056>
  }
  torus { // Torus082
    1.332, 0.668  rotate -x*90
    scale 0.24431
    rotate -90.0*x
    translate  <-1.446498, -0.468317, 0.100056>
  }
}
#declare CSG228 = difference {
  torus { // Torus083
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube442
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  translate  <0.093184, 0.001247, -2.119938>
}
#declare CSG229 = difference {
  torus { // Torus084
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube443
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  rotate 180.0*x
  translate  <0.093184, 0.001247, -5.812246>
}
#declare mid_link1 = union {
  object { CSG228 }
  object { CSG229 }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.124767>
    translate  <-1.356281, -0.468678, -5.031748>
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.117544>
    translate  <-1.352678, 0.469286, -5.026193>
  }
  rotate -90.0*z
  translate  <-1.445041, -1.35265, -0.305756>
}
#declare CSG230 = difference {
  torus { // Torus085
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube444
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  translate  <0.093184, 0.001247, -2.119938>
}
#declare CSG231 = difference {
  torus { // Torus086
    1.5835, 0.4165  rotate -x*90
    scale 0.29944
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.446498, 0.00388, -2.902599>
  }
  box { // Cube445
    <-1, -1, -1>, <1, 1, 1>
    scale <0.292184, 0.676347, 0.337918>
    translate  <-1.469259, 0.0, -2.570228>
  }
  rotate 180.0*x
  translate  <0.093184, 0.001247, -5.812246>
}
#declare end_link2 = union {
  object { CSG230 }
  object { CSG231 }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.124767>
    translate  <-1.356281, -0.468678, -5.031748>
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    scale <0.121633, 0.121633, 2.117544>
    translate  <-1.352678, 0.469286, -5.026193>
  }
  translate  <-0.090315, -0.000814, -3.102086>
}
#declare hook_link_assy1 = union {
  object { hook3 }
  object { main_link1 }
  object { pin1 }
  object { mid_link1 }
  object { end_link2 }
  material {
    Silver_Texture
  }
  scale 0.156643
  rotate 180.0*z
  translate  <-7.843592, 1.686524, 0.556736>
}
#declare buffer_body1 = union {
  cone { // Cone062
    <0,0,0>, 0.844, <0,0,1>, 0.895
    scale <1.0, 1.0, 1.185028>
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, -0.0, 1.257251>
  }
  superellipsoid { // SuperQ026
    <1.0, 0.111>
    scale <1.077686, 1.077686, 0.106513>
  }
  torus { // Torus087
    1.84, 0.16  rotate -x*90
    scale 0.420884
    translate  <0.0, -0.0, 1.272681>
  }
}
#declare Group084 = union {
  sphere { // Sphere351
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere352
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate -45.360439*z
}
#declare Group085 = union {
  sphere { // Sphere353
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere354
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate -89.683098*z
}
#declare Group086 = union {
  sphere { // Sphere355
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere356
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
}
#declare Group087 = union {
  sphere { // Sphere357
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, 0.970329, 0.097838>
  }
  sphere { // Sphere358
    <0,0,0>,1
    scale 0.053639
    translate  <0.0, -0.964453, 0.097838>
  }
  rotate 45.00209*z
}
#declare buffer_rivets1 = union {
  object { Group084 }
  object { Group085 }
  object { Group086 }
  object { Group087 }
}
#declare buffer_plate1 = difference {
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    scale <0.212837, 1.98853, 2.188257>
    rotate -90.0*y
    translate  <1.096065, -0.0, 2.252129>
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    scale <0.212837, 1.98853, 2.379093>
    rotate -90.0*y
    translate  <1.234854, -0.0, 2.111618>
  }
  material {
    Streaky_Steel_Metal
  }
  scale <0.826513, 1.0, 1.0>
}
#declare buffer_nut4 = union {
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  0.070437*x
}
#declare buffer_nut5 = union {
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  <0.0805, 0.0, -1.670093>
}
#declare buffer_nut6 = union {
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  <2.436027, 0.0, -1.670093>
}
#declare buffer_nut7 = union {
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    scale 0.133442
    rotate 90.0*x
    translate  <-1.260448, 0.085385, 0.850802>
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    scale 0.086481
    rotate 90.0*x
    translate  <-1.260448, -0.025615, 0.850802>
  }
  translate  2.436027*x
}
#declare Group088 = union {
  object { buffer_nut4 }
  object { buffer_nut5 }
  object { buffer_nut6 }
  object { buffer_nut7 }
  material {
    Silver_Texture
  }
  scale 0.978601
  rotate <-90.0, 0.0, 90.0>
  translate  <-0.042299, 0.011895, -0.019158>
}
#declare buffer_assy1 = union {
  object { buffer_body1 }
  object { buffer_rivets1 }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.766941, 0.766941, 1.031133>
    translate  <0.0, 0.002797, 1.286738>
  }
  object { buffer_plate1 }
  superellipsoid { // SuperQ027
    <0.1, 0.1>
    material {
      Black_paint
    }
    scale <1.462857, 0.136176, 1.128423>
    rotate <-90.0, 0.0, 90.0>
    translate  <0.0, -0.0, -0.215956>
  }
  object { Group088 }
  scale 0.247387
  rotate <-180.0, 90.0, 0.0>
  translate  <-7.672069, 1.001209, 0.578682>
}
#declare CSG232 = union {
  box { // Cube448
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube449
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube450
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube451
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube452
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube453
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG233 = difference {
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG232 }
}
#declare nut76 = union {
  object { CSG233 }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 6.355609>
}
#declare CSG234 = union {
  box { // Cube454
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube455
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube456
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube457
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube458
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube459
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG235 = difference {
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG234 }
}
#declare nut77 = union {
  object { CSG235 }
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 5.840821>
}
#declare Group089 = union {
  object { nut76 }
  object { nut77 }
  material {
    buffer_red
  }
  translate  <0.052204, -0.078027, 0.0>
}
#declare CSG236 = union {
  box { // Cube460
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube461
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube462
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube463
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube464
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube465
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG237 = difference {
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG236 }
}
#declare nut78 = union {
  object { CSG237 }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 6.355609>
}
#declare CSG238 = union {
  box { // Cube466
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube467
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube468
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube469
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube470
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube471
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG239 = difference {
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG238 }
}
#declare nut79 = union {
  object { CSG239 }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate -90.0*y
  translate  <-6.63543, 0.36993, 5.840821>
}
#declare Group090 = union {
  object { nut78 }
  object { nut79 }
  material {
    buffer_red
  }
  translate  <0.052204, 1.54485, 0.0>
}
#declare Buffer_beam1 = union {
  object { hook2 }
  object { hook_link_assy1 }
  object { buffer_assy1 }
  box { // Cube446
    <-1, -1, -1>, <1, 1, 1>
    scale <0.112974, 2.084863, 0.306225>
    translate  <-7.407189, 1.00542, 0.580044>
  }
  box { // Cube447
    <-1, -1, -1>, <1, 1, 1>
    material {
      buffer_red
    }
    scale <0.033122, 2.084863, 0.306225>
    translate  <-7.551904, 1.00542, 0.580044>
  }
  object { Group089 }
  object { Group090 }
  scale 1.020408
  rotate <-0.0, -0.0, 0.0>
  translate  <7.30598, -0.023412, -0.004507>
}
#declare cab_rear = union {
  object { CSG032 }
  object { CSG033 }
  object { CSG034 }
  object { window_rivets2 }
  object { cab_rivets1 }
  object { Group093 }
  object { Buffer_beam1 }
  rotate 180.0*z
  translate  <4.124938, 1.985935, 0.004507>
}
#declare Roof = difference {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <-0.331047, -2.286919, -4.681493>
    rotate <-180.0, 90.0, 0.0>
    translate  <-0.288217, 0.992107, 6.64605>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <-0.260752, -2.195536, -4.919349>
    rotate <-180.0, 90.0, 0.0>
    translate  <-0.421647, 0.992107, 6.64605>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <2.477499, 2.44806, 0.240823>
    translate  <2.033734, 0.97006, 6.410829>
  }
}
#declare CSG042 = union {
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.437122, 0.463827, 0.130077>
    rotate -90.0*x
    translate  <3.634556, -1.178315, 6.17947>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.437122, 0.463827, 0.130077>
    rotate -90.0*x
    translate  <2.281512, -1.178315, 6.17947>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.116077, -1.231228, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <2.96154, -1.111677, 4.948178>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.671014, -0.364784, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <2.96154, -1.111677, 6.276726>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.839891, -1.40602, -0.070174>
    rotate <90.0, 0.0, -180.0>
    translate  <3.233439, -1.111677, 2.384564>
  }
}
#declare CSG043 = difference {
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <2.233481, 2.811945, 0.019109>
    rotate -90.0*x
    translate  <2.062167, -1.114969, 3.885282>
  }
  object { CSG042 }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.059078, -0.35473, -0.070174>
    rotate <90.0, 0.0, 180.0>
    translate  <0.838043, -1.111677, 4.051457>
  }
}
#declare CSG044 = union {
  object { CSG043 }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15813, 1.211258, 0.019109>
    rotate -90.0*x
    translate  <2.466971, -1.114969, 2.300465>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.22619, 0.226529, 0.041863>
    rotate -90.0*x
    translate  <2.412007, -1.137342, 3.490091>
  }
}
#declare CSG045 = union {
  torus { // Torus009
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 3.192466>
  }
  torus { // Torus010
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 2.20259>
  }
}
#declare CSG046 = difference {
  object { CSG045 }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072968, 0.255184, 0.489169>
    translate  <2.546249, -1.119281, 2.696591>
  }
}
#declare handrail3 = union {
  object { CSG046 }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.02984, 0.02984, 0.988189>
    rotate -90.0*z
    translate  <2.545897, -1.326722, 2.202871>
  }
  material {
    handle_colour
  }
}
#declare CSG047 = union {
  torus { // Torus011
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 3.192466>
  }
  torus { // Torus012
    1.9025, 0.2645  rotate -x*90
    scale 0.112495
    rotate -90.0*y
    translate  <2.545483, -1.11282, 2.20259>
  }
}
#declare CSG048 = difference {
  object { CSG047 }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.072968, 0.255184, 0.489169>
    translate  <2.546249, -1.119281, 2.696591>
  }
}
#declare handrail4 = union {
  object { CSG048 }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <0.02984, 0.02984, 0.988189>
    rotate -90.0*z
    translate  <2.545897, -1.326722, 2.202871>
  }
  material {
    handle_colour
  }
  translate  1.650987*x
}
#declare Group015 = union {
  object { // Sphere129->Sphere133
    Sphere133
    rotate -0.0*z
    translate  -5.322519*z
  }
  object { // Sphere130->Sphere133
    Sphere133
    rotate -0.0*z
    translate  -0.920111*z
  }
  object { // Sphere131->Sphere133
    Sphere133
    rotate -0.0*z
    translate  -0.8*z
  }
  object { // Sphere132->Sphere133
    Sphere133
    rotate -0.0*z
    translate  -0.4*z
  }
  object { Sphere133 }
}
#declare Group016 = union {
  object { // Sphere134->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <2.4, 0.0, -0.0>
  }
  object { // Sphere135->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <2.0, 0.0, -0.0>
  }
  object { // Sphere136->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere137->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere138->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere139->Sphere140
    Sphere140
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere140 }
}
#declare Group017 = union {
  object { // Sphere141->Sphere145
    Sphere145
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere142->Sphere145
    Sphere145
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere143->Sphere145
    Sphere145
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere144->Sphere145
    Sphere145
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere145 }
}
#declare Group018 = union {
  object { // Sphere146->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.8>
  }
  object { // Sphere147->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.4>
  }
  object { // Sphere148->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.0>
  }
  object { // Sphere149->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.6>
  }
  object { // Sphere150->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.2>
  }
  object { // Sphere151->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -2.8>
  }
  object { // Sphere152->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.6>
  }
  object { // Sphere153->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.2>
  }
  object { // Sphere154->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.8>
  }
  object { // Sphere155->Sphere156
    Sphere156
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.4>
  }
  object { Sphere156 }
}
#declare Group019 = union {
  object { // Sphere157->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.8>
  }
  object { // Sphere158->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.4>
  }
  object { // Sphere159->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -4.0>
  }
  object { // Sphere160->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.6>
  }
  object { // Sphere161->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -3.2>
  }
  object { // Sphere162->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -2.8>
  }
  object { // Sphere163->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.6>
  }
  object { // Sphere164->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -1.2>
  }
  object { // Sphere165->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.8>
  }
  object { // Sphere166->Sphere167
    Sphere167
    rotate 0.0*x
    translate  <-0.0, 0.0, -0.4>
  }
  object { Sphere167 }
  translate  1.841723*x
}
#declare Group020 = union {
  object { // Sphere168->Sphere172
    Sphere172
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere169->Sphere172
    Sphere172
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere170->Sphere172
    Sphere172
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere171->Sphere172
    Sphere172
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere172 }
  translate  1.165469*z
}
#declare Group021 = union {
  object { // Sphere173->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <2.4, 0.0, -0.063249>
  }
  object { // Sphere174->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <2.0, 0.0, -0.0>
  }
  object { // Sphere175->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <1.6, 0.0, -0.0>
  }
  object { // Sphere176->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <1.2, 0.0, -0.0>
  }
  object { // Sphere177->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere178->Sphere179
    Sphere179
    rotate <-0.0, 0.0, 0.0>
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere179 }
  translate  2.440079*z
}
#declare Group026 = union {
  object { // Sphere190->Sphere191
    Sphere191
    translate  0.257423*x
  }
  object { Sphere191 }
}
#declare Group027 = union {
  object { // Sphere192->Sphere194
    Sphere194
    rotate 0.0*z
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere193->Sphere194
    Sphere194
    rotate 0.0*z
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere194 }
  translate  -0.065805*x
}
#declare Group028 = union {
  object { // Sphere195->Sphere197
    Sphere197
    rotate 0.0*z
    translate  <0.8, 0.0, -0.0>
  }
  object { // Sphere196->Sphere197
    Sphere197
    rotate 0.0*z
    translate  <0.4, 0.0, -0.0>
  }
  object { Sphere197 }
  translate  <-0.065805, 0.0, -1.71092>
}
#declare Group029 = union {
  object { // Sphere198->Sphere199
    Sphere199
    translate  0.257423*x
  }
  object { Sphere199 }
  translate  -0.153544*z
}
#declare side_rivets1 = union {
  object { Group015 }
  object { Group016 }
  object { Group017 }
  object { Group018 }
  object { Group019 }
  object { Group020 }
  object { Group021 }
  object { Group026 }
  object { Group027 }
  object { Group028 }
  object { Group029 }
  scale -1.020408
  rotate <180.0, -0.0, 180.0>
  translate  <-0.000102, -2.290578, -0.08701>
}
#declare cab_right = union {
  object { CSG044 }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 1.582177, 0.019109>
    rotate -90.0*x
    translate  <1.783913, -1.079034, 5.090017>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 1.582177, 0.019109>
    rotate -90.0*x
    translate  <-0.063114, -1.079034, 5.090017>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.057882, 0.864365, 0.019109>
    rotate <90.0, -90.0, 0.0>
    translate  <0.860623, -1.079034, 3.757092>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.822226, 1.271486, 0.019109>
    rotate -90.0*x
    translate  <3.313408, -1.075931, 2.34542>
  }
  object { handrail3 }
  object { handrail4 }
  object { side_rivets1 }
  box { // Cube790
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.90137, -0.012774, -0.203075>
    rotate <90.0, 0.0, -180.0>
    translate  <0.863953, -0.847722, 4.424787>
  }
  box { // Cube791
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.90137, -0.012774, -0.272719>
    rotate <153.692886, -0.0, 180.0>
    translate  <0.863953, -0.534321, 4.174066>
  }
  box { // Cube792
    <-1, -1, -1>, <1, 1, 1>
    scale <0.919765, 0.013035, 0.52062>
    rotate <180.0, -0.0, 180.0>
    translate  <0.881584, -0.42065, 3.414702>
  }
  box { // Cube793
    <-1, -1, -1>, <1, 1, 1>
    scale <0.752131, 0.013035, 0.291036>
    rotate <90.0, -90.0, 0.0>
    translate  <1.76954, -0.742821, 3.658574>
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.985312*y
}
#declare CSG144 = union {
  cone { // Cone048
    <0,0,0>, 0.566, <0,0,1>, 0.666
    scale <1.0, 1.0, 0.286121>
    rotate <180.0, 0.0, 180.0>
    translate  -0.096197*z
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    scale <0.565012, 0.565012, 0.633694>
    translate  1.829195*z
  }
  torus { // Torus046
    1.5, 0.5  rotate -x*90
    scale <0.33699, 0.33699, 0.203358>
    translate  1.778283*z
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    scale <0.565012, 0.565012, 1.889424>
    translate  -0.11256*z
  }
}
#declare CSG145 = union {
  torus { // Torus047
    1.5, 0.5  rotate -x*90
    scale <0.359573, 0.359573, 0.252867>
    translate  2.590278*z
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    scale <0.641015, 0.641015, 0.792753>
    translate  3.511657*z
  }
  sphere { // Sphere227
    <0,0,0>,1
    scale <0.673721, 0.673721, 0.449401>
    rotate -11.842197*z
    translate  4.221789*z
  }
  sphere { // Sphere228
    <0,0,0>,1
    scale <1.0, 1.0, 0.667043>
    translate  3.246329*z
  }
  material {
    Pipe_copper
  }
}
#declare Whistle = union {
  object { CSG144 }
  object { CSG145 }
  scale 0.109359
  rotate <0.0, 0.0, -39.413914>
  translate  <0.738161, 1.003129, 7.008101>
}
#declare Cab = union {
  object { cab_left }
  object { cab_front }
  object { cab_rear }
  object { Roof }
  object { cab_right }
  object { Whistle }
  cylinder { // Cylndr688
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_paint
    }
    scale <0.005352, 0.005352, 4.274524>
    rotate <-180.0, 89.046783, 0.0>
    translate  <-0.138241, 0.740651, 5.917608>
  }
  scale 0.98
  translate  0.015921*y
}
#declare Group056 = union {
  sphere { // Sphere223
    <0,0,0>,1
    scale 0.03419
    translate  <-7.52729, 0.198074, -0.57348>
  }
  sphere { // Sphere236
    <0,0,0>,1
    scale 0.03419
    translate  <-7.52729, 1.81108, -0.57348>
  }
}
#declare Group059 = union {
  object { // Sphere246->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 1.8>
  }
  object { // Sphere245->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 1.6>
  }
  object { // Sphere244->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 1.4>
  }
  object { // Sphere243->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 1.2>
  }
  object { // Sphere242->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 1.0>
  }
  object { // Sphere241->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 0.8>
  }
  object { // Sphere240->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 0.6>
  }
  object { // Sphere239->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 0.4>
  }
  object { // Sphere238->Sphere237
    Sphere237
    rotate -0.0*z
    translate  <0.0, 0.0, 0.2>
  }
  object { Sphere237 }
}
#declare Group060 = union {
  object { // Sphere247->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 1.8>
  }
  object { // Sphere248->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 1.6>
  }
  object { // Sphere249->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 1.4>
  }
  object { // Sphere250->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 1.2>
  }
  object { // Sphere251->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 1.0>
  }
  object { // Sphere252->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 0.8>
  }
  object { // Sphere253->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 0.6>
  }
  object { // Sphere254->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 0.4>
  }
  object { // Sphere255->Sphere256
    Sphere256
    rotate -0.0*z
    translate  <0.0, 0.0, 0.2>
  }
  object { Sphere256 }
  translate  1.732601*y
}
#declare Group061 = union {
  object { // Sphere291->Sphere257
    Sphere257
    translate  6.8*x
  }
  object { // Sphere290->Sphere257
    Sphere257
    translate  6.6*x
  }
  object { // Sphere289->Sphere257
    Sphere257
    translate  6.4*x
  }
  object { // Sphere288->Sphere257
    Sphere257
    translate  6.2*x
  }
  object { // Sphere287->Sphere257
    Sphere257
    translate  6.0*x
  }
  object { // Sphere286->Sphere257
    Sphere257
    translate  5.8*x
  }
  object { // Sphere285->Sphere257
    Sphere257
    translate  5.6*x
  }
  object { // Sphere284->Sphere257
    Sphere257
    translate  5.4*x
  }
  object { // Sphere283->Sphere257
    Sphere257
    translate  5.2*x
  }
  object { // Sphere282->Sphere257
    Sphere257
    translate  5.0*x
  }
  object { // Sphere281->Sphere257
    Sphere257
    translate  4.8*x
  }
  object { // Sphere280->Sphere257
    Sphere257
    translate  4.6*x
  }
  object { // Sphere279->Sphere257
    Sphere257
    translate  4.4*x
  }
  object { // Sphere278->Sphere257
    Sphere257
    translate  4.2*x
  }
  object { // Sphere277->Sphere257
    Sphere257
    translate  4.0*x
  }
  object { // Sphere276->Sphere257
    Sphere257
    translate  3.8*x
  }
  object { // Sphere275->Sphere257
    Sphere257
    translate  3.6*x
  }
  object { // Sphere274->Sphere257
    Sphere257
    translate  3.4*x
  }
  object { // Sphere273->Sphere257
    Sphere257
    translate  3.2*x
  }
  object { // Sphere272->Sphere257
    Sphere257
    translate  3.0*x
  }
  object { // Sphere271->Sphere257
    Sphere257
    translate  2.8*x
  }
  object { // Sphere270->Sphere257
    Sphere257
    translate  2.6*x
  }
  object { // Sphere269->Sphere257
    Sphere257
    translate  2.4*x
  }
  object { // Sphere268->Sphere257
    Sphere257
    translate  2.2*x
  }
  object { // Sphere267->Sphere257
    Sphere257
    translate  2.0*x
  }
  object { // Sphere266->Sphere257
    Sphere257
    translate  1.8*x
  }
  object { // Sphere259->Sphere257
    Sphere257
    translate  0.4*x
  }
  object { // Sphere258->Sphere257
    Sphere257
    translate  0.2*x
  }
  object { Sphere257 }
}
#declare Group062 = union {
  object { // Sphere292->Sphere326
    Sphere326
    translate  6.8*x
  }
  object { // Sphere293->Sphere326
    Sphere326
    translate  6.6*x
  }
  object { // Sphere294->Sphere326
    Sphere326
    translate  6.4*x
  }
  object { // Sphere295->Sphere326
    Sphere326
    translate  6.2*x
  }
  object { // Sphere296->Sphere326
    Sphere326
    translate  6.0*x
  }
  object { // Sphere297->Sphere326
    Sphere326
    translate  5.8*x
  }
  object { // Sphere298->Sphere326
    Sphere326
    translate  5.6*x
  }
  object { // Sphere299->Sphere326
    Sphere326
    translate  5.4*x
  }
  object { // Sphere300->Sphere326
    Sphere326
    translate  5.2*x
  }
  object { // Sphere301->Sphere326
    Sphere326
    translate  5.0*x
  }
  object { // Sphere302->Sphere326
    Sphere326
    translate  4.8*x
  }
  object { // Sphere303->Sphere326
    Sphere326
    translate  4.6*x
  }
  object { // Sphere304->Sphere326
    Sphere326
    translate  4.4*x
  }
  object { // Sphere305->Sphere326
    Sphere326
    translate  4.2*x
  }
  object { // Sphere306->Sphere326
    Sphere326
    translate  4.0*x
  }
  object { // Sphere307->Sphere326
    Sphere326
    translate  3.8*x
  }
  object { // Sphere308->Sphere326
    Sphere326
    translate  3.6*x
  }
  object { // Sphere309->Sphere326
    Sphere326
    translate  3.4*x
  }
  object { // Sphere310->Sphere326
    Sphere326
    translate  3.2*x
  }
  object { // Sphere311->Sphere326
    Sphere326
    translate  3.0*x
  }
  object { // Sphere312->Sphere326
    Sphere326
    translate  2.8*x
  }
  object { // Sphere313->Sphere326
    Sphere326
    translate  2.6*x
  }
  object { // Sphere314->Sphere326
    Sphere326
    translate  2.4*x
  }
  object { // Sphere315->Sphere326
    Sphere326
    translate  2.2*x
  }
  object { // Sphere316->Sphere326
    Sphere326
    translate  2.0*x
  }
  object { // Sphere317->Sphere326
    Sphere326
    translate  1.8*x
  }
  object { // Sphere324->Sphere326
    Sphere326
    translate  0.4*x
  }
  object { // Sphere325->Sphere326
    Sphere326
    translate  0.2*x
  }
  object { Sphere326 }
  translate  3.029446*y
}
#declare CSG164 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <3.579511, 1.567593, 0.016991>
    translate  <-4.169291, 0.988032, 1.495452>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <3.497991, 1.513354, 0.063341>
    translate  <-4.169291, 0.988032, 1.414406>
  }
}
#declare CSG163 = union {
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    scale <0.542106, 0.454864, 0.185114>
    translate  <-6.476117, -0.247558, 1.416148>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    scale <0.542106, 0.454864, 0.185114>
    translate  <-6.476117, 2.238101, 1.416148>
  }
}
#declare CSG165 = difference {
  object { CSG164 }
  object { CSG163 }
}
#declare CSG240 = union {
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    scale <0.643568, 0.698404, 0.075058>
    rotate -90.0*y
    translate  <4.138722, -0.397558, 0.160706>
  }
  box { // Cube472
    <-1, -1, -1>, <1, 1, 1>
    scale <0.037829, 1.366586, 0.752828>
    translate  <4.101, 0.965818, 0.270185>
  }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    scale <0.643568, 0.698404, 0.075058>
    rotate -90.0*y
    translate  <4.138722, 2.330515, 0.160706>
  }
  box { // Cube473
    <-1, -1, -1>, <1, 1, 1>
    scale <0.037829, 2.057908, 0.42971>
    translate  <4.101, 0.965818, 0.593303>
  }
}
#declare Group099 = union {
  sphere { // Sphere408
    <0,0,0>,1
    scale 0.036001
    translate  <1.641189, 0.139656, -0.40441>
  }
  sphere { // Sphere409
    <0,0,0>,1
    scale 0.036001
    translate  <1.469643, 0.139656, -0.40441>
  }
  sphere { // Sphere410
    <0,0,0>,1
    scale 0.036001
    translate  <1.28035, 0.139656, -0.40441>
  }
}
#declare Group098 = union {
  object { // Sphere407->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -1.2*z
  }
  object { // Sphere406->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -1.0*z
  }
  object { // Sphere405->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -0.8*z
  }
  object { // Sphere404->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -0.6*z
  }
  object { // Sphere403->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -0.4*z
  }
  object { // Sphere402->Sphere401
    Sphere401
    rotate 0.0*y
    translate  -0.2*z
  }
  object { Sphere401 }
  translate  -0.059154*z
}
#declare CSG243 = union {
  box { // Cube482
    <-1, -1, -1>, <1, 1, 1>
    scale <0.324517, 0.015722, 0.234751>
    translate  <3.729268, 0.18256, -0.238186>
  }
  box { // Cube483
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06424, 0.015722, 0.755306>
    translate  <4.001376, 0.149378, 0.282368>
  }
  box { // Cube484
    <-1, -1, -1>, <1, 1, 1>
    scale <0.810543, 0.015722, 0.073537>
    translate  <2.621931, 0.222014, -0.403817>
  }
}
#declare Group100 = union {
  object { Group099 }
  object { Group098 }
  sphere { // Sphere419
    <0,0,0>,1
    scale 0.036001
    translate  <3.593731, 0.139656, 0.967962>
  }
  sphere { // Sphere411
    <0,0,0>,1
    scale 0.036001
    translate  <1.670766, 0.139656, 0.967962>
  }
  sphere { // Sphere412
    <0,0,0>,1
    scale 0.036001
    translate  <1.473891, 0.139656, 0.967962>
  }
  sphere { // Sphere413
    <0,0,0>,1
    scale 0.036001
    translate  <1.281595, 0.139656, 0.967962>
  }
  sphere { // Sphere414
    <0,0,0>,1
    scale 0.036001
    translate  <1.08472, 0.139656, 0.967962>
  }
  sphere { // Sphere415
    <0,0,0>,1
    scale 0.036001
    translate  <0.892424, 0.139656, 0.967962>
  }
  sphere { // Sphere416
    <0,0,0>,1
    scale 0.036001
    translate  <0.704706, 0.139656, 0.967962>
  }
  sphere { // Sphere417
    <0,0,0>,1
    scale 0.036001
    translate  <0.516988, 0.139656, 0.967962>
  }
  sphere { // Sphere418
    <0,0,0>,1
    scale 0.036001
    translate  <3.410591, 0.139656, 0.967962>
  }
  box { // Cube487
    <-1, -1, -1>, <1, 1, 1>
    scale <2.295383, 0.015722, 0.061707>
    translate  <1.642859, 0.15022, 0.97447>
  }
  object { CSG243 }
}
#declare Group101 = union {
  sphere { // Sphere420
    <0,0,0>,1
    scale 0.036001
    translate  <1.641189, 0.139656, -0.40441>
  }
  sphere { // Sphere421
    <0,0,0>,1
    scale 0.036001
    translate  <1.469643, 0.139656, -0.40441>
  }
  sphere { // Sphere422
    <0,0,0>,1
    scale 0.036001
    translate  <1.28035, 0.139656, -0.40441>
  }
}
#declare Group102 = union {
  object { // Sphere423->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -1.2*z
  }
  object { // Sphere424->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -1.0*z
  }
  object { // Sphere425->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -0.8*z
  }
  object { // Sphere426->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -0.6*z
  }
  object { // Sphere427->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -0.4*z
  }
  object { // Sphere428->Sphere429
    Sphere429
    rotate 0.0*y
    translate  -0.2*z
  }
  object { Sphere429 }
  translate  -0.059154*z
}
#declare CSG245 = union {
  box { // Cube489
    <-1, -1, -1>, <1, 1, 1>
    scale <0.324517, 0.015722, 0.234751>
    translate  <3.729268, 0.18256, -0.238186>
  }
  box { // Cube490
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06424, 0.015722, 0.755306>
    translate  <4.001376, 0.149378, 0.282368>
  }
  box { // Cube491
    <-1, -1, -1>, <1, 1, 1>
    scale <0.810543, 0.015722, 0.073537>
    translate  <2.621931, 0.222014, -0.403817>
  }
}
#declare Group103 = union {
  object { Group101 }
  object { Group102 }
  sphere { // Sphere430
    <0,0,0>,1
    scale 0.036001
    translate  <3.593731, 0.139656, 0.967962>
  }
  sphere { // Sphere431
    <0,0,0>,1
    scale 0.036001
    translate  <1.670766, 0.139656, 0.967962>
  }
  sphere { // Sphere432
    <0,0,0>,1
    scale 0.036001
    translate  <1.473891, 0.139656, 0.967962>
  }
  sphere { // Sphere433
    <0,0,0>,1
    scale 0.036001
    translate  <1.281595, 0.139656, 0.967962>
  }
  sphere { // Sphere434
    <0,0,0>,1
    scale 0.036001
    translate  <1.08472, 0.139656, 0.967962>
  }
  sphere { // Sphere435
    <0,0,0>,1
    scale 0.036001
    translate  <0.892424, 0.139656, 0.967962>
  }
  sphere { // Sphere436
    <0,0,0>,1
    scale 0.036001
    translate  <0.704706, 0.139656, 0.967962>
  }
  sphere { // Sphere437
    <0,0,0>,1
    scale 0.036001
    translate  <0.516988, 0.139656, 0.967962>
  }
  sphere { // Sphere438
    <0,0,0>,1
    scale 0.036001
    translate  <3.410591, 0.139656, 0.967962>
  }
  box { // Cube488
    <-1, -1, -1>, <1, 1, 1>
    scale <1.851652, 0.015722, 0.061707>
    translate  <2.071799, 0.15022, 0.97447>
  }
  object { CSG245 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.001648*y
}
#declare CSG244 = union {
  box { // Cube485
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06424, 0.015722, 0.506859>
    translate  <3.350682, 0.222714, 0.483492>
  }
  box { // Cube486
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047316, 0.00444, 0.506859>
    rotate 90.0*z
    translate  <3.299912, 0.188866, 0.483492>
  }
  box { // Cube492
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015811, 0.015722, 0.377114>
    rotate 90.0*y
    translate  <3.682938, 0.221772, -0.004607>
  }
  translate  <0.0, -1.228629, 0.036736>
}
#declare CSG246 = union {
  box { // Cube493
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06424, 0.015722, 0.506859>
    translate  <3.350682, 0.222714, 0.483492>
  }
  box { // Cube494
    <-1, -1, -1>, <1, 1, 1>
    scale <0.047316, 0.00444, 0.506859>
    rotate 90.0*z
    translate  <3.299912, 0.188866, 0.483492>
  }
  box { // Cube495
    <-1, -1, -1>, <1, 1, 1>
    scale <0.015811, 0.015722, 0.377114>
    rotate 90.0*y
    translate  <3.682938, 0.221772, -0.004607>
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  <0.0, 3.205595, 0.036736>
}
#declare CSG361 = difference {
  box { // Cube696
    <-1, -1, -1>, <1, 1, 1>
    scale <0.28578, 0.785641, 0.169769>
    translate  <-0.702285, 0.999059, 1.182905>
  }
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    scale <0.242706, 0.309368, 1.796153>
    rotate -90.0*x
    translate  <-0.415044, 0.11446, 1.351389>
  }
}
#declare Group104 = union {
  sphere { // Sphere448
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere449
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  0.474191*y
}
#declare Group109 = union {
  sphere { // Sphere450
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere451
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  -0.502085*y
}
#declare Group110 = union {
  box { // Cube710
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -2.191119>
  }
  box { // Cube711
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    rotate <0.0, -90.0, 0.0>
    translate  <-12.748897, 0.0, -1.437788>
  }
  object { Group104 }
  object { Group109 }
}
#declare Group111 = union {
  sphere { // Sphere452
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere453
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  0.474191*y
}
#declare Group112 = union {
  sphere { // Sphere454
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere455
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  -0.502085*y
}
#declare Group113 = union {
  box { // Cube712
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -2.191119>
  }
  box { // Cube713
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    rotate <0.0, -90.0, 0.0>
    translate  <-12.748897, 0.0, -1.437788>
  }
  object { Group111 }
  object { Group112 }
  translate  25.684117*x
}
#declare spring = union {
  sphere { // Sphere443
    <0,0,0>,1
    scale 0.30266
    translate  -12.459357*x
  }
  box { // Cube697
    <-1, -1, -1>, <1, 1, 1>
    scale <0.776851, 0.776851, 0.274766>
    translate  <-12.748897, 0.0, -0.585766>
  }
  box { // Cube698
    <-1, -1, -1>, <1, 1, 1>
    scale <0.860532, 0.860532, 0.944962>
    translate  <0.0, -0.027894, 0.507328>
  }
  box { // Cube699
    <-1, -1, -1>, <1, 1, 1>
    scale <12.961769, 0.727169, 0.106396>
  }
  box { // Cube700
    <-1, -1, -1>, <1, 1, 1>
    scale <11.876629, 0.727169, 0.106396>
    translate  0.257796*z
  }
  box { // Cube701
    <-1, -1, -1>, <1, 1, 1>
    scale <10.045282, 0.727169, 0.106396>
    translate  0.510395*z
  }
  box { // Cube702
    <-1, -1, -1>, <1, 1, 1>
    scale <8.150785, 0.727169, 0.106396>
    translate  0.762995*z
  }
  box { // Cube703
    <-1, -1, -1>, <1, 1, 1>
    scale <5.81424, 0.727169, 0.106396>
    translate  0.98402*z
  }
  box { // Cube704
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  1.205044*z
  }
  box { // Cube705
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  <10.103983, 0.0, -0.215828>
  }
  box { // Cube706
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  <-9.972319, 0.0, -0.215828>
  }
  box { // Cube707
    <-1, -1, -1>, <1, 1, 1>
    scale <0.776851, 0.776851, 0.274766>
    translate  <12.917756, 0.0, -0.585766>
  }
  box { // Cube708
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <12.917756, 0.0, -0.9657>
  }
  box { // Cube709
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -0.9657>
  }
  sphere { // Sphere444
    <0,0,0>,1
    scale 0.30266
    translate  12.425203*x
  }
  sphere { // Sphere445
    <0,0,0>,1
    scale 0.30266
    translate  <10.971421, 0.0, 0.261943>
  }
  sphere { // Sphere446
    <0,0,0>,1
    scale 0.30266
    translate  <-10.966283, 0.0, 0.261943>
  }
  sphere { // Sphere447
    <0,0,0>,1
    scale 0.30266
    translate  <9.150919, 0.0, 0.523885>
  }
  object { Group110 }
  object { Group113 }
  scale 0.085756
  translate  <-3.329056, 0.351576, 1.711394>
}
#declare Group114 = union {
  sphere { // Sphere461
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere462
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  0.474191*y
}
#declare Group115 = union {
  sphere { // Sphere463
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere464
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  -0.502085*y
}
#declare Group116 = union {
  box { // Cube727
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -2.191119>
  }
  box { // Cube728
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    rotate <0.0, -90.0, 0.0>
    translate  <-12.748897, 0.0, -1.437788>
  }
  object { Group114 }
  object { Group115 }
}
#declare Group117 = union {
  sphere { // Sphere465
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere466
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  0.474191*y
}
#declare Group118 = union {
  sphere { // Sphere467
    <0,0,0>,1
    scale 0.182127
    translate  <-12.238379, 0.0, -2.129417>
  }
  sphere { // Sphere468
    <0,0,0>,1
    scale 0.182127
    translate  <-13.242821, 0.0, -2.129417>
  }
  translate  -0.502085*y
}
#declare Group119 = union {
  box { // Cube729
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -2.191119>
  }
  box { // Cube730
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    rotate <0.0, -90.0, 0.0>
    translate  <-12.748897, 0.0, -1.437788>
  }
  object { Group117 }
  object { Group118 }
  translate  25.684117*x
}
#declare spring1 = union {
  sphere { // Sphere456
    <0,0,0>,1
    scale 0.30266
    translate  -12.459357*x
  }
  box { // Cube714
    <-1, -1, -1>, <1, 1, 1>
    scale <0.776851, 0.776851, 0.274766>
    translate  <-12.748897, 0.0, -0.585766>
  }
  box { // Cube715
    <-1, -1, -1>, <1, 1, 1>
    scale <0.860532, 0.860532, 0.944962>
    translate  <0.0, -0.027894, 0.507328>
  }
  box { // Cube716
    <-1, -1, -1>, <1, 1, 1>
    scale <12.961769, 0.727169, 0.106396>
  }
  box { // Cube717
    <-1, -1, -1>, <1, 1, 1>
    scale <11.876629, 0.727169, 0.106396>
    translate  0.257796*z
  }
  box { // Cube718
    <-1, -1, -1>, <1, 1, 1>
    scale <10.045282, 0.727169, 0.106396>
    translate  0.510395*z
  }
  box { // Cube719
    <-1, -1, -1>, <1, 1, 1>
    scale <8.150785, 0.727169, 0.106396>
    translate  0.762995*z
  }
  box { // Cube720
    <-1, -1, -1>, <1, 1, 1>
    scale <5.81424, 0.727169, 0.106396>
    translate  0.98402*z
  }
  box { // Cube721
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  1.205044*z
  }
  box { // Cube722
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  <10.103983, 0.0, -0.215828>
  }
  box { // Cube723
    <-1, -1, -1>, <1, 1, 1>
    scale <3.603993, 0.727169, 0.106396>
    translate  <-9.972319, 0.0, -0.215828>
  }
  box { // Cube724
    <-1, -1, -1>, <1, 1, 1>
    scale <0.776851, 0.776851, 0.274766>
    translate  <12.917756, 0.0, -0.585766>
  }
  box { // Cube725
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <12.917756, 0.0, -0.9657>
  }
  box { // Cube726
    <-1, -1, -1>, <1, 1, 1>
    scale <0.861281, 0.861281, 0.117417>
    translate  <-12.748897, 0.0, -0.9657>
  }
  sphere { // Sphere457
    <0,0,0>,1
    scale 0.30266
    translate  12.425203*x
  }
  sphere { // Sphere458
    <0,0,0>,1
    scale 0.30266
    translate  <10.971421, 0.0, 0.261943>
  }
  sphere { // Sphere459
    <0,0,0>,1
    scale 0.30266
    translate  <-10.966283, 0.0, 0.261943>
  }
  sphere { // Sphere460
    <0,0,0>,1
    scale 0.30266
    translate  <9.150919, 0.0, 0.523885>
  }
  object { Group116 }
  object { Group119 }
  scale 0.085756
  translate  <-3.329056, 1.638963, 1.711394>
}
#declare Group120 = union {
  object { spring }
  object { spring1 }
}
#declare Group121 = union {
  object { // Sphere500->Sphere495
    Sphere495
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere499->Sphere495
    Sphere495
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere498->Sphere495
    Sphere495
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere497->Sphere495
    Sphere495
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere496->Sphere495
    Sphere495
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere495 }
}
#declare CSG364 = union {
  box { // Cube741
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube742
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group122 = union {
  object { // Sphere501->Sphere506
    Sphere506
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere502->Sphere506
    Sphere506
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere503->Sphere506
    Sphere506
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere504->Sphere506
    Sphere506
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere505->Sphere506
    Sphere506
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere506 }
  translate  -0.664749*x
}
#declare Group123 = union {
  object { Group121 }
  object { CSG364 }
  object { Group122 }
}
#declare Group124 = union {
  object { // Sphere507->Sphere512
    Sphere512
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere508->Sphere512
    Sphere512
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere509->Sphere512
    Sphere512
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere510->Sphere512
    Sphere512
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere511->Sphere512
    Sphere512
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere512 }
}
#declare CSG365 = union {
  box { // Cube743
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube744
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group125 = union {
  object { // Sphere513->Sphere518
    Sphere518
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere514->Sphere518
    Sphere518
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere515->Sphere518
    Sphere518
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere516->Sphere518
    Sphere518
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere517->Sphere518
    Sphere518
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere518 }
  translate  -0.664749*x
}
#declare Group126 = union {
  object { Group124 }
  object { CSG365 }
  object { Group125 }
  translate  -2.22281*x
}
#declare Group127 = union {
  object { // Sphere519->Sphere524
    Sphere524
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere520->Sphere524
    Sphere524
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere521->Sphere524
    Sphere524
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere522->Sphere524
    Sphere524
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere523->Sphere524
    Sphere524
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere524 }
}
#declare CSG366 = union {
  box { // Cube745
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube746
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group128 = union {
  object { // Sphere525->Sphere530
    Sphere530
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere526->Sphere530
    Sphere530
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere527->Sphere530
    Sphere530
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere528->Sphere530
    Sphere530
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere529->Sphere530
    Sphere530
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere530 }
  translate  -0.664749*x
}
#declare Group129 = union {
  object { Group127 }
  object { CSG366 }
  object { Group128 }
  translate  -4.428908*x
}
#declare Group130 = union {
  object { Group123 }
  object { Group126 }
  object { Group129 }
}
#declare Group131 = union {
  object { // Sphere531->Sphere536
    Sphere536
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere532->Sphere536
    Sphere536
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere533->Sphere536
    Sphere536
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere534->Sphere536
    Sphere536
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere535->Sphere536
    Sphere536
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere536 }
}
#declare CSG367 = union {
  box { // Cube747
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube748
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group132 = union {
  object { // Sphere537->Sphere542
    Sphere542
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere538->Sphere542
    Sphere542
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere539->Sphere542
    Sphere542
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere540->Sphere542
    Sphere542
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere541->Sphere542
    Sphere542
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere542 }
  translate  -0.664749*x
}
#declare Group133 = union {
  object { Group131 }
  object { CSG367 }
  object { Group132 }
}
#declare Group134 = union {
  object { // Sphere543->Sphere548
    Sphere548
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere544->Sphere548
    Sphere548
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere545->Sphere548
    Sphere548
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere546->Sphere548
    Sphere548
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere547->Sphere548
    Sphere548
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere548 }
}
#declare CSG368 = union {
  box { // Cube749
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube750
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group135 = union {
  object { // Sphere549->Sphere554
    Sphere554
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere550->Sphere554
    Sphere554
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere551->Sphere554
    Sphere554
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere552->Sphere554
    Sphere554
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere553->Sphere554
    Sphere554
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere554 }
  translate  -0.664749*x
}
#declare Group136 = union {
  object { Group134 }
  object { CSG368 }
  object { Group135 }
  translate  -2.22281*x
}
#declare Group137 = union {
  object { // Sphere555->Sphere560
    Sphere560
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere556->Sphere560
    Sphere560
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere557->Sphere560
    Sphere560
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere558->Sphere560
    Sphere560
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere559->Sphere560
    Sphere560
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere560 }
}
#declare CSG369 = union {
  box { // Cube751
    <-1, -1, -1>, <1, 1, 1>
    scale <0.404071, 0.021564, 0.404071>
    translate  <0.0, 0.132602, -0.087637>
  }
  box { // Cube752
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.252785, -0.01349, -0.305367>
    translate  <0.0, 0.091802, -0.087637>
  }
}
#declare Group138 = union {
  object { // Sphere561->Sphere566
    Sphere566
    rotate 0.0*z
    translate  <0.0, 0.0, -0.645816>
  }
  object { // Sphere562->Sphere566
    Sphere566
    rotate 0.0*z
    translate  <0.0, 0.0, -0.49864>
  }
  object { // Sphere563->Sphere566
    Sphere566
    rotate 0.0*z
    translate  <0.0, 0.0, -0.368619>
  }
  object { // Sphere564->Sphere566
    Sphere566
    rotate 0.0*z
    translate  <0.0, 0.0, -0.247176>
  }
  object { // Sphere565->Sphere566
    Sphere566
    rotate 0.0*z
    translate  <0.0, 0.0, -0.121444>
  }
  object { Sphere566 }
  translate  -0.664749*x
}
#declare Group139 = union {
  object { Group137 }
  object { CSG369 }
  object { Group138 }
  translate  -4.428908*x
}
#declare Group140 = union {
  object { Group133 }
  object { Group136 }
  object { Group139 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  2.01868*y
}
#declare chassis_plate = union {
  box { // Cube731
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087846, 0.054476, 0.498092>
    translate  <-3.337655, 2.404193, 0.879302>
  }
  box { // Cube732
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.353172>
    rotate 11.545184*y
    translate  <-3.247063, 2.404193, 1.032612>
  }
  box { // Cube733
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.353172>
    rotate -11.54518*y
    translate  <-3.421278, 2.404193, 1.032612>
  }
  box { // Cube734
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.2138>
    translate  <-3.344623, 2.460988, 1.143785>
  }
  box { // Cube735
    <-1, -1, -1>, <1, 1, 1>
    scale <0.155615, 0.015156, 0.250284>
    rotate 90.0*y
    translate  <-3.074358, 2.404193, 1.208991>
  }
  cone { // Cone065
    <0,0,0>, 0.376, <0,0,1>, 0.539
    scale <0.147501, 0.147501, 0.184282>
    rotate 90.0*x
    translate  <-2.908651, 2.59178, 1.134702>
  }
}
#declare Group141 = union {
  object { // Sphere481->Sphere477
    Sphere477
    rotate -0.0*z
    translate  <0.112855, 0.0, -0.197497>
  }
  object { Sphere477 }
  object { // Sphere478->Sphere477
    Sphere477
    rotate -0.0*z
    translate  <0.158793, 0.0, -0.0>
  }
  object { // Sphere479->Sphere477
    Sphere477
    rotate -0.0*z
    translate  <0.324935, 0.0, -0.0>
  }
  object { // Sphere480->Sphere477
    Sphere477
    rotate -0.0*z
    translate  <-0.0, 0.0, -0.202101>
  }
  object { // Sphere476->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.32542>
  }
  object { // Sphere470->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  0.07831*x
  }
  object { // Sphere471->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.100932>
  }
  object { // Sphere472->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.201865>
  }
  object { // Sphere473->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.32542>
  }
  object { // Sphere474->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.100932>
  }
  object { // Sphere475->Sphere469
    Sphere469
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.201865>
  }
  object { Sphere469 }
}
#declare Group142 = union {
  object { // Sphere482->Sphere483
    Sphere483
    rotate -0.0*z
    translate  <0.112855, 0.0, -0.197497>
  }
  object { Sphere483 }
  object { // Sphere484->Sphere483
    Sphere483
    rotate -0.0*z
    translate  <0.158793, 0.0, -0.0>
  }
  object { // Sphere485->Sphere483
    Sphere483
    rotate -0.0*z
    translate  <0.324935, 0.0, -0.0>
  }
  object { // Sphere486->Sphere483
    Sphere483
    rotate -0.0*z
    translate  <-0.0, 0.0, -0.202101>
  }
  object { // Sphere487->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.32542>
  }
  object { // Sphere488->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  0.07831*x
  }
  object { // Sphere489->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.100932>
  }
  object { // Sphere490->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.201865>
  }
  object { // Sphere491->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, 0.0, -0.32542>
  }
  object { // Sphere492->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.100932>
  }
  object { // Sphere493->Sphere494
    Sphere494
    rotate <0.0, -0.0, -0.0>
    translate  <0.07831, 0.0, -0.201865>
  }
  object { Sphere494 }
  translate  -2.983148*y
}
#declare chassis_plate2 = union {
  box { // Cube736
    <-1, -1, -1>, <1, 1, 1>
    scale <0.087846, 0.054476, 0.498092>
    translate  <-3.337655, 2.404193, 0.879302>
  }
  box { // Cube737
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.353172>
    rotate 11.545184*y
    translate  <-3.247063, 2.404193, 1.032612>
  }
  box { // Cube738
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.353172>
    rotate -11.54518*y
    translate  <-3.421278, 2.404193, 1.032612>
  }
  box { // Cube739
    <-1, -1, -1>, <1, 1, 1>
    scale <0.074774, 0.015156, 0.2138>
    translate  <-3.344623, 2.460988, 1.143785>
  }
  box { // Cube740
    <-1, -1, -1>, <1, 1, 1>
    scale <0.155615, 0.015156, 0.250284>
    rotate 90.0*y
    translate  <-3.074358, 2.404193, 1.208991>
  }
  cone { // Cone066
    <0,0,0>, 0.376, <0,0,1>, 0.539
    scale <0.147501, 0.147501, 0.184282>
    rotate 90.0*x
    translate  <-2.978541, 2.54911, 1.194951>
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.969584*y
}
#declare Group143 = union {
  object { chassis_plate }
  object { Group141 }
  object { Group142 }
  object { chassis_plate2 }
}
#declare cab_brkt = union {
  box { // Cube781
    <-1, -1, -1>, <1, 1, 1>
    scale <0.013703, 0.693697, 0.263847>
    rotate -37.33255*x
    translate  <1.799727, -0.247098, 0.833006>
  }
  sphere { // Sphere583
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.757373>
  }
  box { // Cube782
    <-1, -1, -1>, <1, 1, 1>
    scale <0.013703, 0.079064, 0.332929>
    rotate 90.0*z
    translate  <1.718434, 0.128272, 0.534524>
  }
  sphere { // Sphere584
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.530137>
  }
  sphere { // Sphere585
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.294786>
  }
}
#declare cab_brkt1 = union {
  box { // Cube783
    <-1, -1, -1>, <1, 1, 1>
    scale <0.013703, 0.693697, 0.263847>
    rotate -37.33255*x
    translate  <1.799727, -0.247098, 0.833006>
  }
  sphere { // Sphere586
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.757373>
  }
  box { // Cube784
    <-1, -1, -1>, <1, 1, 1>
    scale <0.013703, 0.079064, 0.332929>
    rotate 90.0*z
    translate  <1.718434, 0.128272, 0.534524>
  }
  sphere { // Sphere587
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.530137>
  }
  sphere { // Sphere588
    <0,0,0>,1
    scale 0.036638
    translate  <1.720501, 0.110249, 0.294786>
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.99921*y
}
#declare Group144 = union {
  object { cab_brkt }
  object { cab_brkt1 }
}
#declare Group153 = union {
  object { // Sphere606->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -2.7*y
  }
  object { // Sphere605->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -2.4*y
  }
  object { // Sphere604->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -2.1*y
  }
  object { // Sphere603->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -1.8*y
  }
  object { // Sphere602->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -1.5*y
  }
  object { // Sphere601->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -1.2*y
  }
  object { // Sphere600->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -0.9*y
  }
  object { // Sphere599->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -0.6*y
  }
  object { // Sphere598->Sphere597
    Sphere597
    rotate 0.0*z
    translate  -0.3*y
  }
  object { Sphere597 }
}
#declare chassis = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <4.332532, 0.035764, 0.767137>
    translate  <-2.488043, 0.176919, 0.246876>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <4.332532, 0.035764, 0.767137>
    translate  <-2.488043, 1.824524, 0.251881>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      chassis_black
    }
    scale <2.233481, 2.074823, 0.040488>
    translate  <2.062167, 0.992944, 1.07654>
  }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    scale <0.054587, 0.858075, 1.029918>
    translate  <-7.436363, 1.000945, 0.384409>
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    scale <0.024063, 1.663805, 0.071198>
    translate  <-7.50504, 1.000945, -0.57082>
  }
  object { Group056 }
  object { Group059 }
  object { Group060 }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.734727, 0.035764, 0.959449>
    translate  <-6.652388, 0.176919, 0.450843>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    scale <0.734727, 0.035764, 0.959449>
    translate  <-6.652388, 1.825788, 0.450843>
  }
  object { Group061 }
  object { Group062 }
  object { CSG165 }
  object { CSG240 }
  object { Group100 }
  object { Group103 }
  object { CSG244 }
  object { CSG246 }
  object { CSG361 }
  object { Group120 }
  object { Group130 }
  object { Group140 }
  object { Group143 }
  object { Group144 }
  box { // Cube789
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0143, 0.825956, 0.282258>
    translate  <-0.660323, 1.00406, 1.196237>
  }
  object { Group153 }
}
#declare Group074 = union {
  sphere { // Sphere263
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.387753, 2.67641>
  }
  sphere { // Sphere264
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.387753, 2.933433>
  }
  sphere { // Sphere344
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.554294, 2.933433>
  }
  sphere { // Sphere345
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.554294, 2.673787>
  }
  translate  -0.002511*x
}
#declare CSG182 = difference {
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    scale <0.271654, 0.010915, 0.145693>
    translate  <-0.397855, 2.719135, 2.803384>
  }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    scale <0.311684, 0.018411, 0.119243>
    rotate <-0.0, 16.298492, -0.0>
    translate  <-0.428861, 2.719135, 2.628976>
  }
  translate  -0.299837*y
}
#declare CSG183 = difference {
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    scale <0.271654, 0.010915, 0.145693>
    translate  <-0.397855, 2.719135, 2.803384>
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    scale <0.311684, 0.018411, 0.119243>
    rotate <-0.0, 16.298492, -0.0>
    translate  <-0.428861, 2.719135, 2.628976>
  }
  translate  -0.194894*y
}
#declare CSG184 = union {
  object { CSG182 }
  object { CSG183 }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    scale <0.102251, 0.010915, 0.165071>
    rotate -90.0*z
    translate  <-0.180815, 2.472603, 2.803384>
  }
}
#declare valve_brkt = union {
  object { Group074 }
  object { CSG184 }
}
#declare CSG180 = difference {
  torus { // Torus068
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.376505, -3.085111>
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -119.72979, -0.0>
    translate  <-1.162991, 0.376505, -3.524967>
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -240.801254, -0.0>
    translate  <-1.128042, 0.376505, -2.639875>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.584248, 2.224249, 2.522208>
}
#declare CSG181 = difference {
  torus { // Torus069
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate -90.0*y
    translate  <-1.410998, -0.0, -3.582199>
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <0.0, 60.273178, 0.0>
    translate  <-1.599406, -0.0, -2.633236>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.296187, 2.30107, 2.37082>
}
#declare CSG179 = difference {
  torus { // Torus067
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -240.801254, -0.0>
    translate  <-1.60548, 0.0, -3.530703>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.905618, 2.30103, 2.705322>
}
#declare valve_extra_pipe = union {
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.36711>
    rotate <0.0, -0.0, -90.0>
    translate  <-4.416601, 2.301382, 2.421097>
  }
  object { CSG180 }
  object { CSG181 }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.36711>
    rotate <60.183788, 0.0, -90.0>
    translate  <-4.025404, 2.301382, 2.117481>
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.174>
    rotate 59.55545*y
    translate  <-3.885882, 2.301382, 2.118836>
  }
  object { CSG179 }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.026893, 0.026893, -1.4>
    rotate <-16.847162, -17.9669, -90.0>
    translate  <-0.766235, 2.193805, 2.879195>
  }
  rotate 17.9669*x
  translate  <0.001902, 0.969733, -0.605211>
}
#declare valve_body2 = union {
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.475308>
    translate  0.552011*z
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    scale <0.467623, 0.467623, 0.340119>
    translate  <0.0, -0.0, 0.931023>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    scale <0.206964, 0.206964, 0.88225>
    translate  <0.0, -0.0, 0.997078>
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    scale <0.317243, 0.317243, 0.230742>
    translate  <0.0, -0.0, 1.758614>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.071835, 0.071835, 0.314193>
    translate  <0.0, -0.0, 1.880766>
  }
}
#declare handwheel2 = union {
  sphere { // Sphere262
    <0,0,0>,1
    scale 0.173036
    translate  3.199846*z
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate -90.0*x
    translate  <0.0, -0.643528, 3.196673>
  }
  torus { // Torus062
    1.6875, 0.3125  rotate -x*90
    scale 0.393877
    translate  3.200332*z
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate <-90.0, -0.0, -90.0>
    translate  <-0.662748, 0.000318, 3.196673>
  }
  material {
    Brushed_Aluminum
  }
  translate  <0.0, -0.0, -0.935678>
}
#declare valve_nut8 = union {
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut9 = union {
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut10 = union {
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut11 = union {
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts2 = union {
  object { valve_nut8 }
  object { valve_nut9 }
  object { valve_nut10 }
  object { valve_nut11 }
  material {
    Silver_Texture
  }
}
#declare Group063 = union {
  object { valve_nuts2 }
  cone { // Cone052
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate -90.0*x
  translate  <0.0, 0.969518, -0.0>
}
#declare valve_nut12 = union {
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut13 = union {
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut14 = union {
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut15 = union {
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts3 = union {
  object { valve_nut12 }
  object { valve_nut13 }
  object { valve_nut14 }
  object { valve_nut15 }
  material {
    Silver_Texture
  }
}
#declare Group070 = union {
  object { valve_nuts3 }
  cone { // Cone053
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate 90.0*x
  translate  <0.0, -0.99608, 0.0>
}
#declare valve_nut16 = union {
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut17 = union {
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut18 = union {
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut19 = union {
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts4 = union {
  object { valve_nut16 }
  object { valve_nut17 }
  object { valve_nut18 }
  object { valve_nut19 }
  material {
    Silver_Texture
  }
}
#declare Group071 = union {
  object { valve_nuts4 }
  cone { // Cone054
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  scale 0.609762
  rotate <0.0, 90.0, 0.0>
  translate  <-1.382592, -2.126948, 0.002142>
}
#declare valve_nut20 = union {
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut21 = union {
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut22 = union {
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut23 = union {
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts5 = union {
  object { valve_nut20 }
  object { valve_nut21 }
  object { valve_nut22 }
  object { valve_nut23 }
  material {
    Silver_Texture
  }
}
#declare Group072 = union {
  object { valve_nuts5 }
  cone { // Cone055
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate -90.0*x
  translate  <0.0, -4.729504, 0.003553>
}
#declare valve_nut24 = union {
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut25 = union {
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut26 = union {
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut27 = union {
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts6 = union {
  object { valve_nut24 }
  object { valve_nut25 }
  object { valve_nut26 }
  object { valve_nut27 }
  material {
    Silver_Texture
  }
}
#declare Group073 = union {
  object { valve_nuts6 }
  cone { // Cone056
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate <90.0, -0.0, -0.0>
  translate  <0.0, -4.343738, 0.003553>
}
#declare CSG174 = difference {
  torus { // Torus063
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
  material {
    Pipe_copper
  }
}
#declare CSG175 = union {
  object { CSG174 }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    scale <0.168101, 0.168101, 1.000085>
    translate  <-2.076124, 0.003536, -4.086523>
  }
  rotate -72.926178*x
  translate  <0.0, 0.180662, 0.70787>
}
#declare CSG177 = difference {
  torus { // Torus065
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <0.0, 59.377525, -0.0>
    translate  <-1.642762, -0.0, -2.643991>
  }
  material {
    Pipe_copper
  }
  scale 1.287116
  rotate <90.0, -0.0, -90.0>
  translate  <-4.853577, 2.223944, -0.004707>
}
#declare CSG176 = difference {
  torus { // Torus064
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
  material {
    Pipe_copper
  }
  scale 1.352749
  rotate <90.0, 90.0, 0.0>
  translate  <-0.005673, -9.963291, -2.798299>
}
#declare CSG178 = difference {
  torus { // Torus066
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
  material {
    Pipe_copper
  }
  scale 1.318091
  rotate <150.0, -90.0, -180.0>
  translate  <-7.718165, 9.00077, 2.751003>
}
#declare valve_pipe_assy = union {
  object { valve_body2 }
  object { handwheel2 }
  object { Group063 }
  object { Group070 }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 1.982352>
    rotate -90.0*x
    translate  <0.0, -0.999819, 0.0>
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.215723, 0.215723, 2.497064>
    rotate -90.0*x
    translate  <0.0, 1.512645, -0.001973>
  }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 2.651003>
    rotate -90.0*x
    translate  <0.0, -4.189836, 0.001515>
  }
  object { Group071 }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    scale <0.320185, 0.320185, 0.810986>
    rotate <180.0, 90.0, 0.0>
    translate  <-0.228904, -2.12626, -0.001043>
  }
  object { Group072 }
  object { Group073 }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    scale <0.220031, 0.220031, 0.90093>
    rotate -90.0*x
    translate  <0.0, -5.788455, 0.003639>
  }
  object { CSG175 }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.214676, 0.214676, 4.370183>
    rotate <-30.285709, -90.0, 0.0>
    translate  <-0.443577, 4.7819, 0.00008>
  }
  object { CSG177 }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.213631, 0.213631, 3.272275>
    rotate <0.0, -0.0, -90.0>
    translate  <-4.974137, 7.427259, 0.86686>
  }
  object { CSG176 }
  object { CSG178 }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.237875, 0.237875, 18.803436>
    rotate <0.0, 0.0, -180.0>
    translate  <-0.010703, -6.715235, -19.736011>
  }
  scale 0.148521
  rotate <90.0, 0.0, 90.0>
  translate  <-0.734115, 2.474484, 3.221851>
}
#declare side_valve = union {
  object { valve_brkt }
  object { valve_extra_pipe }
  object { valve_pipe_assy }
}
#declare Group075 = union {
  sphere { // Sphere346
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.387753, 2.67641>
  }
  sphere { // Sphere347
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.387753, 2.933433>
  }
  sphere { // Sphere348
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.554294, 2.933433>
  }
  sphere { // Sphere349
    <0,0,0>,1
    scale 0.013485
    translate  <-0.190014, 2.554294, 2.673787>
  }
  translate  -0.002511*x
}
#declare CSG185 = difference {
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    scale <0.271654, 0.010915, 0.145693>
    translate  <-0.397855, 2.719135, 2.803384>
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    scale <0.311684, 0.018411, 0.119243>
    rotate <-0.0, 16.298492, -0.0>
    translate  <-0.428861, 2.719135, 2.628976>
  }
  translate  -0.299837*y
}
#declare CSG186 = difference {
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    scale <0.271654, 0.010915, 0.145693>
    translate  <-0.397855, 2.719135, 2.803384>
  }
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    scale <0.311684, 0.018411, 0.119243>
    rotate <-0.0, 16.298492, -0.0>
    translate  <-0.428861, 2.719135, 2.628976>
  }
  translate  -0.194894*y
}
#declare CSG187 = union {
  object { CSG185 }
  object { CSG186 }
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    scale <0.102251, 0.010915, 0.165071>
    rotate -90.0*z
    translate  <-0.180815, 2.472603, 2.803384>
  }
}
#declare valve_brkt1 = union {
  object { Group075 }
  object { CSG187 }
}
#declare CSG188 = difference {
  torus { // Torus070
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.376505, -3.085111>
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -119.72979, -0.0>
    translate  <-1.162991, 0.376505, -3.524967>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -240.801254, -0.0>
    translate  <-1.128042, 0.376505, -2.639875>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.584248, 2.224249, 2.522208>
}
#declare CSG189 = difference {
  torus { // Torus071
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate -90.0*y
    translate  <-1.410998, -0.0, -3.582199>
  }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <0.0, 60.273178, 0.0>
    translate  <-1.599406, -0.0, -2.633236>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.296187, 2.30107, 2.37082>
}
#declare CSG190 = difference {
  torus { // Torus072
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <-0.0, -240.801254, -0.0>
    translate  <-1.60548, 0.0, -3.530703>
  }
  material {
    Pipe_copper
  }
  scale 0.204037
  rotate <0.0, -90.0, 0.0>
  translate  <-4.905618, 2.30103, 2.705322>
}
#declare valve_extra_pipe1 = union {
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.36711>
    rotate <0.0, -0.0, -90.0>
    translate  <-4.416601, 2.301382, 2.421097>
  }
  object { CSG188 }
  object { CSG189 }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.36711>
    rotate <60.183788, 0.0, -90.0>
    translate  <-4.025404, 2.301382, 2.117481>
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.03533, 0.03533, 0.174>
    rotate 59.55545*y
    translate  <-3.885882, 2.301382, 2.118836>
  }
  object { CSG190 }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.026893, 0.026893, -1.4>
    rotate <-16.847162, -17.9669, -90.0>
    translate  <-0.766235, 2.193805, 2.879195>
  }
  rotate 17.9669*x
  translate  <0.001902, 0.969733, -0.605211>
}
#declare valve_body3 = union {
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 0.475308>
    translate  0.552011*z
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    scale <0.467623, 0.467623, 0.340119>
    translate  <0.0, -0.0, 0.931023>
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    scale <0.206964, 0.206964, 0.88225>
    translate  <0.0, -0.0, 0.997078>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    scale <0.317243, 0.317243, 0.230742>
    translate  <0.0, -0.0, 1.758614>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.071835, 0.071835, 0.314193>
    translate  <0.0, -0.0, 1.880766>
  }
}
#declare handwheel3 = union {
  sphere { // Sphere350
    <0,0,0>,1
    scale 0.173036
    translate  3.199846*z
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate -90.0*x
    translate  <0.0, -0.643528, 3.196673>
  }
  torus { // Torus073
    1.6875, 0.3125  rotate -x*90
    scale 0.393877
    translate  3.200332*z
  }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    scale <0.091284, 0.091284, 1.286139>
    rotate <-90.0, -0.0, -90.0>
    translate  <-0.662748, 0.000318, 3.196673>
  }
  material {
    Brushed_Aluminum
  }
  translate  <0.0, -0.0, -0.935678>
}
#declare valve_nut28 = union {
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut29 = union {
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut30 = union {
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut31 = union {
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts7 = union {
  object { valve_nut28 }
  object { valve_nut29 }
  object { valve_nut30 }
  object { valve_nut31 }
  material {
    Silver_Texture
  }
}
#declare Group076 = union {
  object { valve_nuts7 }
  cone { // Cone057
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate -90.0*x
  translate  <0.0, 0.969518, -0.0>
}
#declare valve_nut32 = union {
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut33 = union {
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut34 = union {
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut35 = union {
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts8 = union {
  object { valve_nut32 }
  object { valve_nut33 }
  object { valve_nut34 }
  object { valve_nut35 }
  material {
    Silver_Texture
  }
}
#declare Group077 = union {
  object { valve_nuts8 }
  cone { // Cone058
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate 90.0*x
  translate  <0.0, -0.99608, 0.0>
}
#declare valve_nut36 = union {
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut37 = union {
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut38 = union {
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut39 = union {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts9 = union {
  object { valve_nut36 }
  object { valve_nut37 }
  object { valve_nut38 }
  object { valve_nut39 }
  material {
    Silver_Texture
  }
}
#declare Group078 = union {
  object { valve_nuts9 }
  cone { // Cone059
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  scale 0.609762
  rotate <0.0, 90.0, 0.0>
  translate  <-1.382592, -2.126948, 0.002142>
}
#declare valve_nut40 = union {
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut41 = union {
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut42 = union {
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut43 = union {
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts10 = union {
  object { valve_nut40 }
  object { valve_nut41 }
  object { valve_nut42 }
  object { valve_nut43 }
  material {
    Silver_Texture
  }
}
#declare Group079 = union {
  object { valve_nuts10 }
  cone { // Cone060
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    scale <0.857577, 0.857577, 0.025184>
    translate  0.189496*z
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate -90.0*x
  translate  <0.0, -4.729504, 0.003553>
}
#declare valve_nut44 = union {
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
}
#declare valve_nut45 = union {
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  1.571424*x
}
#declare valve_nut46 = union {
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, 0.785712, 0.0>
}
#declare valve_nut47 = union {
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    scale 0.069737
    translate  <-0.794547, 0.0, 0.490939>
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    scale 0.121415
    translate  <-0.794547, 0.0, 0.394043>
  }
  translate  <0.793195, -0.808161, 0.0>
}
#declare valve_nuts11 = union {
  object { valve_nut44 }
  object { valve_nut45 }
  object { valve_nut46 }
  object { valve_nut47 }
  material {
    Silver_Texture
  }
}
#declare Group080 = union {
  object { valve_nuts11 }
  cone { // Cone061
    <0,0,0>, 0.75, <0,0,1>, 0.846
    scale <0.71929, 0.71929, 0.148992>
    rotate <180.0, 0.0, 180.0>
    translate  0.543772*z
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.183083>
    translate  0.214213*z
  }
  rotate <90.0, -0.0, -0.0>
  translate  <0.0, -4.343738, 0.003553>
}
#declare CSG191 = difference {
  torus { // Torus074
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
}
#declare CSG192 = union {
  object { CSG191 }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    scale <0.168101, 0.168101, 1.000085>
    translate  <-2.076124, 0.003536, -4.086523>
  }
  rotate -72.926178*x
  translate  <0.0, 0.180662, 0.70787>
}
#declare CSG193 = difference {
  torus { // Torus075
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate <0.0, 59.377525, -0.0>
    translate  <-1.642762, -0.0, -2.643991>
  }
  material {
    Pipe_copper
  }
  scale 1.287116
  rotate <90.0, -0.0, -90.0>
  translate  <-4.853577, 2.223944, -0.004707>
}
#declare CSG194 = difference {
  torus { // Torus076
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
  material {
    Pipe_copper
  }
  scale 1.352749
  rotate <90.0, 90.0, 0.0>
  translate  <-0.005673, -9.963291, -2.798299>
}
#declare CSG195 = difference {
  torus { // Torus077
    1.5995, 0.4005  rotate -x*90
    scale 0.428431
    rotate -90.0*x
    translate  <-1.38983, 0.0, -3.085111>
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    translate  <-0.886368, 0.0, -3.105263>
  }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    scale <0.500302, 0.345168, 0.982154>
    rotate 90.0*y
    translate  <-1.350373, 0.0, -3.593063>
  }
  material {
    Pipe_copper
  }
  scale 1.318091
  rotate <150.0, -90.0, -180.0>
  translate  <-7.718165, 9.00077, 2.751003>
}
#declare valve_pipe_assy1 = union {
  object { valve_body3 }
  object { handwheel3 }
  object { Group076 }
  object { Group077 }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 1.982352>
    rotate -90.0*x
    translate  <0.0, -0.999819, 0.0>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.215723, 0.215723, 2.497064>
    rotate -90.0*x
    translate  <0.0, 1.512645, -0.001973>
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    scale <0.537801, 0.537801, 2.651003>
    rotate -90.0*x
    translate  <0.0, -4.189836, 0.001515>
  }
  object { Group078 }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    scale <0.320185, 0.320185, 0.810986>
    rotate <180.0, 90.0, 0.0>
    translate  <-0.228904, -2.12626, -0.001043>
  }
  object { Group079 }
  object { Group080 }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    scale <0.220031, 0.220031, 0.90093>
    rotate -90.0*x
    translate  <0.0, -5.788455, 0.003639>
  }
  object { CSG192 }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.214676, 0.214676, 4.370183>
    rotate <-30.285709, -90.0, 0.0>
    translate  <-0.443577, 4.7819, 0.00008>
  }
  object { CSG193 }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.213631, 0.213631, 3.272275>
    rotate <0.0, -0.0, -90.0>
    translate  <-4.974137, 7.427259, 0.86686>
  }
  object { CSG194 }
  object { CSG195 }
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.237875, 0.237875, 18.803436>
    rotate <0.0, 0.0, -180.0>
    translate  <-0.010703, -6.715235, -19.736011>
  }
  scale 0.148521
  rotate <90.0, 0.0, 90.0>
  translate  <-0.734115, 2.474484, 3.221851>
}
#declare side_valve1 = union {
  object { valve_brkt1 }
  object { valve_extra_pipe1 }
  object { valve_pipe_assy1 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.980471*y
}
#declare CSG221 = difference {
  torus { // Torus078
    1.796, 0.206  rotate -x*90
    scale 0.504438
    rotate -90.0*x
    translate  <-5.495119, 2.033145, 3.002719>
  }
  box { // Cube435
    <-1, -1, -1>, <1, 1, 1>
    scale <0.534768, 0.208087, 1.077539>
    translate  <-4.962662, 2.02522, 3.002862>
  }
  box { // Cube436
    <-1, -1, -1>, <1, 1, 1>
    scale <0.534768, 0.208087, 1.077539>
    rotate <0.0, -90.0, 0.0>
    translate  <-5.467334, 2.02522, 2.460101>
  }
  rotate 15.340764*x
  translate  <0.0, 1.107206, -0.398155>
}
#declare CSG196 = union {
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    scale <0.197315, 0.197315, 0.04553>
    rotate -90.0*y
    translate  <-3.899261, 2.03347, 3.908111>
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    scale <0.172752, 0.172752, 0.012792>
    rotate -90.0*y
    translate  <-3.944731, 2.03347, 3.908111>
  }
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    scale <0.197315, 0.197315, 0.04553>
    rotate -90.0*y
    translate  <-3.959281, 2.03347, 3.908111>
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    scale <0.173668, 0.173668, 0.67249>
    rotate -90.0*y
    translate  <-4.002933, 2.03347, 3.908111>
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    scale <0.147006, 0.147006, 0.011071>
    rotate -90.0*y
    translate  <-4.676498, 2.03347, 3.908111>
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    scale <0.181359, 0.181359, 0.041848>
    rotate -90.0*y
    translate  <-4.689898, 2.03347, 3.908111>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    scale <0.089462, 0.089462, 0.087646>
    rotate -90.0*y
    translate  <-3.816942, 2.03347, 3.908111>
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.031053, 0.031053, 3.749132>
    rotate -90.0*y
    translate  <-0.084301, 2.03347, 3.908111>
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    scale <0.197315, 0.197315, 0.04553>
    rotate <-90.0, -90.0, 0.0>
    translate  <-4.313863, 1.667419, 3.908111>
  }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    scale <0.181487, 0.181487, 0.00855>
    rotate <-90.0, -90.0, 0.0>
    translate  <-4.313863, 1.711464, 3.908111>
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    scale <0.15538, 0.15538, 0.143908>
    rotate <-90.0, -90.0, 0.0>
    translate  <-4.313863, 1.523665, 3.908111>
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    scale <0.197315, 0.197315, 0.04553>
    rotate <-90.0, -90.0, 0.0>
    translate  <-4.313863, 1.721045, 3.908111>
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    scale <0.15538, 0.15538, 0.255187>
    rotate <-90.0, -90.0, 0.0>
    translate  <-4.313863, 1.760958, 3.908111>
  }
}
#declare CSG197 = union {
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG198 = difference {
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG197 }
}
#declare nut64 = union {
  object { CSG198 }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, 0.0>
  translate  <1.971804, 0.643723, 3.899879>
}
#declare CSG199 = union {
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG200 = difference {
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG199 }
}
#declare nut65 = union {
  object { CSG200 }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, 0.0>
  translate  <1.971804, 0.643723, 3.687352>
}
#declare CSG201 = union {
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG202 = difference {
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG201 }
}
#declare nut66 = union {
  object { CSG202 }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, 0.0>
  translate  <1.757535, 0.643723, 3.899879>
}
#declare CSG203 = union {
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG204 = difference {
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG203 }
}
#declare nut67 = union {
  object { CSG204 }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, 0.0>
  translate  <1.757535, 0.643723, 3.687352>
}
#declare CSG205 = union {
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG206 = difference {
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG205 }
}
#declare nut68 = union {
  object { CSG206 }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.040848, 3.902294>
}
#declare CSG207 = union {
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG208 = difference {
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG207 }
}
#declare nut69 = union {
  object { CSG208 }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.249721, 3.902294>
}
#declare CSG209 = union {
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG210 = difference {
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG209 }
}
#declare nut70 = union {
  object { CSG210 }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.253343, 3.686178>
}
#declare CSG211 = union {
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG212 = difference {
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG211 }
}
#declare nut71 = union {
  object { CSG212 }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.038434, 3.686178>
}
#declare Group082 = union {
  object { nut68 }
  object { nut69 }
  object { nut70 }
  object { nut71 }
}
#declare CSG213 = union {
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG214 = difference {
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG213 }
}
#declare nut72 = union {
  object { CSG214 }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.040848, 3.902294>
}
#declare CSG215 = union {
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube420
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube421
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube422
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG216 = difference {
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG215 }
}
#declare nut73 = union {
  object { CSG216 }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.249721, 3.902294>
}
#declare CSG217 = union {
  box { // Cube423
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube424
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube425
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube426
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube427
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube428
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG218 = difference {
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG217 }
}
#declare nut74 = union {
  object { CSG218 }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.253343, 3.686178>
}
#declare CSG219 = union {
  box { // Cube429
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube430
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube431
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube432
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube433
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube434
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG220 = difference {
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG219 }
}
#declare nut75 = union {
  object { CSG220 }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.890131
  rotate <-90.0, -0.0, -90.0>
  translate  <-5.022756, -4.038434, 3.686178>
}
#declare Group083 = union {
  object { nut72 }
  object { nut73 }
  object { nut74 }
  object { nut75 }
  rotate <180.0, 0.0, 180.0>
  translate  <-8.629875, 0.0, 7.820223>
}
#declare Group081 = union {
  object { CSG196 }
  object { nut64 }
  object { nut65 }
  object { nut66 }
  object { nut67 }
  object { Group082 }
  object { Group083 }
}
#declare CSG222 = difference {
  torus { // Torus079
    1.796, 0.206  rotate -x*90
    scale 0.504438
    rotate -90.0*x
    translate  <-5.495119, 2.033145, 3.002719>
  }
  box { // Cube437
    <-1, -1, -1>, <1, 1, 1>
    scale <0.534768, 0.208087, 1.077539>
    translate  <-4.962662, 2.02522, 3.002862>
  }
  box { // Cube438
    <-1, -1, -1>, <1, 1, 1>
    scale <0.534768, 0.208087, 1.077539>
    rotate <0.0, -32.504002, 0.0>
    translate  <-5.89946, 2.02522, 2.698528>
  }
  rotate <-0.0, -74.433533, -90.0>
  translate  <-8.428327, -2.961969, 7.275368>
}
#declare pipework = union {
  object { CSG221 }
  object { Group081 }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    scale <0.103384, 0.103384, 0.789751>
    rotate -90.0*y
    translate  <-4.705511, 2.03347, 3.908111>
  }
  object { CSG222 }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    scale <0.103384, 0.103384, 1.22328>
    rotate <-164.020187, 0.0, 180.0>
    translate  <-6.398519, 2.280621, 2.567448>
  }
}
#declare CSG310 = difference {
  box { // Cube619
    <-1, -1, -1>, <1, 1, 1>
    scale <0.293999, 0.0655, 0.358572>
    translate  <-4.41683, 2.404664, 0.205123>
  }
  box { // Cube620
    <-1, -1, -1>, <1, 1, 1>
    material {
      conn_rods
    }
    scale <0.262475, 0.047824, 0.26324>
    translate  <-4.315955, 2.404664, 0.047505>
  }
  box { // Cube621
    <-1, -1, -1>, <1, 1, 1>
    material {
      conn_rods
    }
    scale <0.120771, 0.085386, 0.229976>
    rotate 30.86064*y
    translate  <-4.107898, 2.404664, -0.053371>
  }
  translate  -0.461978*x
}
#declare slide_bar1 = union {
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.04653, 0.04653, 1.702039>
    rotate -90.0*y
    translate  <-4.67191, 2.405768, 0.097229>
  }
  box { // Cube618
    <-1, -1, -1>, <1, 1, 1>
    scale <1.362779, 0.021349, 0.060254>
    translate  <-4.600853, 2.404664, 0.468121>
  }
  object { CSG310 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  <0.0, 2.011934, 0.0>
}
#declare CSG311 = union {
  box { // Cube622
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG312 = difference {
  object { CSG311 }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG313 = union {
  object { CSG312 }
}
#declare CSG314 = union {
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.105466>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG315 = union {
  box { // Cube623
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG316 = difference {
  object { CSG315 }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG317 = union {
  object { CSG314 }
  object { CSG316 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG318 = union {
  object { CSG313 }
  object { CSG317 }
  box { // Cube624
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG319 = difference {
  object { CSG318 }
}
#declare CSG320 = union {
  box { // Cube625
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG321 = difference {
  object { CSG320 }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG322 = union {
  object { CSG321 }
}
#declare CSG323 = union {
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.107272>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG324 = union {
  box { // Cube626
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG325 = difference {
  object { CSG324 }
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG326 = union {
  object { CSG323 }
  object { CSG325 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG327 = union {
  object { CSG322 }
  object { CSG326 }
  box { // Cube627
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG328 = difference {
  object { CSG327 }
  translate  -2.213783*x
}
#declare Main_conn_rod1 = union {
  object { CSG319 }
  object { CSG328 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  <-0.374969, 2.06508, 0.373447>
}
#declare CSG329 = union {
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.241552>
    rotate -90.0*x
    translate  <0.0, 2.161715, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG330 = union {
  box { // Cube628
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG331 = difference {
  object { CSG330 }
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG332 = union {
  object { CSG329 }
  object { CSG331 }
}
#declare CSG333 = union {
  object { CSG332 }
  box { // Cube629
    <-1, -1, -1>, <1, 1, 1>
    scale <2.116251, 0.040851, 0.088985>
    translate  <-2.307742, 2.355151, -0.373958>
  }
  translate  -0.027353*y
}
#declare drive_rod1 = difference {
  object { CSG333 }
  scale -1.0
  rotate <-180.0, -1.32121, -180.0>
  translate  <-0.347005, 1.937002, 0.371479>
}
#declare CSG334 = union {
  torus { // Torus090
    1.674, 0.326  rotate -x*90
    scale 0.039785
    rotate <-90.0, -0.0, 0.0>
    translate  <-4.433008, 3.458944, -1.285912>
  }
  sphere { // Sphere441
    <0,0,0>,1
    scale <0.068703, 0.020372, 0.068703>
    translate  <-4.432444, 3.471788, -1.286846>
  }
  material {
    Silver_Texture
  }
}
#declare CSG335 = union {
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    scale <0.142555, 0.142555, 0.061952>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, 0.094571>
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    scale <0.079508, 0.079508, 0.061803>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, -0.283713>
  }
  box { // Cube630
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate <0.0, 9.809636, 0.0>
    translate  <-4.386896, 3.427037, -0.085579>
  }
  box { // Cube631
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate -9.80964*y
    translate  <-4.478408, 3.427037, -0.085579>
  }
  translate  -1.387043*z
}
#declare CSG336 = union {
  object { CSG334 }
  object { CSG335 }
}
#declare CSG337 = union {
  box { // Cube632
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube633
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube634
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube635
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube636
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube637
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG338 = difference {
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG337 }
}
#declare nut96 = union {
  object { CSG338 }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.466057, 2.720876, 2.779743>
}
#declare CSG339 = union {
  box { // Cube638
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube639
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube640
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube641
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube642
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube643
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG340 = difference {
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG339 }
}
#declare nut97 = union {
  object { CSG340 }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.66613>
}
#declare CSG341 = union {
  box { // Cube644
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube645
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube646
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube647
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube648
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube649
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG342 = difference {
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG341 }
}
#declare nut98 = union {
  object { CSG342 }
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.245403, 2.720714, 2.779743>
}
#declare CSG343 = union {
  box { // Cube650
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube651
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube652
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube653
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube654
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube655
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG344 = difference {
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG343 }
}
#declare nut99 = union {
  object { CSG344 }
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.887723>
}
#declare Group107 = union {
  object { nut96 }
  object { nut97 }
  object { nut98 }
  object { nut99 }
  material {
    Silver_Texture
  }
  rotate 180.0*x
  translate  <-0.155981, 5.44149, -2.578988>
}
#declare down_link4 = union {
  object { CSG336 }
  object { Group107 }
  scale -1.0
  rotate <-180.0, -21.079521, -180.0>
  translate  <-0.122817, 2.929682, -0.292133>
}
#declare CSG302 = union {
  box { // Cube594
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube595
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube596
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube597
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube598
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube599
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG303 = difference {
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.3829, 1.25991>
  }
  object { CSG302 }
}
#declare nut92 = union {
  object { CSG303 }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.382248, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.710419, -5.197479>
}
#declare CSG304 = union {
  box { // Cube600
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube601
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube602
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube603
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube604
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube605
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG305 = difference {
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG304 }
}
#declare nut93 = union {
  object { CSG305 }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.510058, -5.648904>
}
#declare CSG306 = union {
  box { // Cube606
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube607
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube608
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube609
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube610
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube611
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG307 = difference {
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG306 }
}
#declare nut94 = union {
  object { CSG307 }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.73148, -5.428998>
}
#declare CSG308 = union {
  box { // Cube612
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube613
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube614
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube615
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube616
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube617
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG309 = difference {
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG308 }
}
#declare nut95 = union {
  object { CSG309 }
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.284883, -5.428998>
}
#declare lower_flange1 = union {
  object { nut92 }
  object { nut93 }
  object { nut94 }
  object { nut95 }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.869019, 2.402681, 0.096005>
  }
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.820024, 2.402681, 0.096005>
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    scale <0.154747, 0.154747, 0.024414>
    rotate -90.0*y
    translate  <-5.798249, 2.402681, 0.096005>
  }
  translate  -2.794615*y
}
#declare CSG345 = union {
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.141983, 3.425532, -2.368722>
  }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    scale <0.042308, 0.042308, 0.025658>
    rotate -90.0*x
    translate  <-5.141983, 3.459863, -2.368722>
  }
  box { // Cube658
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.108116, -0.013084, -0.050518>
    rotate <90.0, -78.995392, 90.0>
    translate  <-5.143163, 3.390747, -2.216463>
  }
  box { // Cube659
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.108116, -0.013084, -0.050518>
    rotate <90.0, 78.995392, 90.0>
    translate  <-5.143163, 3.431909, -2.216463>
  }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    scale <0.042308, 0.042308, 0.025658>
    rotate -90.0*x
    translate  <-5.141983, 3.343882, -2.368722>
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.141983, 3.357641, -2.368722>
  }
  rotate 90.0*y
  translate  <-3.430259, 0.117261, -6.321086>
}
#declare down_link5 = union {
  box { // Cube656
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.701567, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.031015, 3.530917, -1.176501>
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  box { // Cube657
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  object { CSG345 }
  scale -1.0
  rotate <180.0, 73.530151, 180.0>
  translate  <-5.076815, 2.976056, 5.691359>
}
#declare CSG346 = union {
  torus { // Torus091
    1.674, 0.326  rotate -x*90
    scale 0.039785
    rotate <-90.0, -0.0, 0.0>
    translate  <-4.433008, 3.458944, -1.285912>
  }
  sphere { // Sphere442
    <0,0,0>,1
    scale <0.068703, 0.020372, 0.068703>
    translate  <-4.432444, 3.471788, -1.286846>
  }
  material {
    Silver_Texture
  }
}
#declare CSG347 = union {
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    scale <0.142555, 0.142555, 0.061952>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, 0.094571>
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    scale <0.079508, 0.079508, 0.061803>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, -0.283713>
  }
  box { // Cube660
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate <0.0, 9.809636, 0.0>
    translate  <-4.386896, 3.427037, -0.085579>
  }
  box { // Cube661
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate -9.80964*y
    translate  <-4.478408, 3.427037, -0.085579>
  }
  translate  -1.387043*z
}
#declare CSG348 = union {
  object { CSG346 }
  object { CSG347 }
}
#declare CSG349 = union {
  box { // Cube662
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube663
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube664
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube665
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube666
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube667
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG350 = difference {
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG349 }
}
#declare nut100 = union {
  object { CSG350 }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.466057, 2.720876, 2.779743>
}
#declare CSG351 = union {
  box { // Cube668
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube669
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube670
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube671
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube672
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube673
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG352 = difference {
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG351 }
}
#declare nut101 = union {
  object { CSG352 }
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.66613>
}
#declare CSG353 = union {
  box { // Cube674
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube675
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube676
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube677
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube678
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube679
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG354 = difference {
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG353 }
}
#declare nut102 = union {
  object { CSG354 }
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.245403, 2.720714, 2.779743>
}
#declare CSG355 = union {
  box { // Cube680
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube681
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube682
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube683
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube684
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube685
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG356 = difference {
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG355 }
}
#declare nut103 = union {
  object { CSG356 }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.887723>
}
#declare Group108 = union {
  object { nut100 }
  object { nut101 }
  object { nut102 }
  object { nut103 }
  material {
    Silver_Texture
  }
  rotate 180.0*x
  translate  <-0.155981, 5.44149, -2.578988>
}
#declare down_link6 = union {
  object { CSG348 }
  object { Group108 }
  scale -1.0
  rotate <180.0, 61.870739, 180.0>
  translate  <0.585484, 2.951433, 4.515622>
}
#declare cross_link2 = union {
  box { // Cube686
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.441375, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.771682, 3.530917, -1.181174>
  }
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.135224, 3.510396, -1.181087>
  }
  box { // Cube687
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  box { // Cube688
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.134639, 3.530917, -1.181174>
  }
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  scale -1.0
  rotate <-180.0, -4.194773, -180.0>
  translate  <-0.378593, 2.976924, 0.59824>
}
#declare top_link1 = union {
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    scale <0.053997, 0.053997, 0.06946>
    rotate -90.0*x
    translate  <-5.130207, 3.639359, 0.937798>
  }
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.0313, 0.0313, 2.330039>
    rotate <0.0, -90.0, 0.0>
    translate  <-2.771162, 3.674406, 0.936086>
  }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    scale <0.053997, 0.053997, 0.06946>
    rotate -90.0*x
    translate  <-2.759032, 3.639359, 0.937798>
  }
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.032227, 0.032227, 0.041455>
    rotate -90.0*x
    translate  <-5.130207, 3.67332, 0.937798>
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  <-0.101434, 3.069739, 0.05376>
}
#declare top_rod1 = union {
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.032854, 0.032854, 0.759342>
    rotate -90.0*y
    translate  <-5.183121, 2.561444, 1.116009>
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    scale <0.068464, 0.068464, 0.258992>
    rotate -90.0*y
    translate  <-5.677056, 2.561444, 1.116009>
  }
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    scale <0.089227, 0.089227, 0.045364>
    rotate -90.0*y
    translate  <-5.584875, 2.561444, 1.116009>
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    scale <0.060379, 0.060379, 0.043268>
    rotate -90.0*y
    translate  <-5.630969, 2.561444, 1.116009>
  }
  translate  -3.093378*y
}
#declare cross_link3 = union {
  box { // Cube689
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.41055, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.733008, 3.530917, -1.181174>
  }
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-7.068743, 3.510396, -1.181087>
  }
  box { // Cube690
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  box { // Cube691
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-7.068158, 3.530917, -1.181174>
  }
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  scale -1.0
  rotate <-0.0, -167.89151, -0.0>
  translate  <4.526457, 2.997598, 0.049297>
}
#declare CSG359 = union {
  cone { // Cone064
    <0,0,0>, 0.193, <0,0,1>, 1.56
    scale <0.097041, 0.025672, 0.114231>
    rotate 180.0*x
    translate  <-2.352603, 2.61282, 1.051072>
  }
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.108459>
    rotate <90.0, -90.0, 0.0>
    translate  <-2.352929, 2.662949, 1.010592>
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.301856>
    rotate <-0.0, -90.0, 0.0>
    translate  <-2.200813, 2.609862, 0.936086>
  }
  translate  <0.184244, 0.0, 0.000032>
}
#declare CSG360 = union {
  object { CSG359 }
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.0313, 0.0313, 0.689493>
    rotate <-0.0, -90.0, 0.0>
    translate  <-1.944794, 2.611374, 0.936086>
  }
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.301856>
    rotate <-0.0, -90.0, 0.0>
    translate  <-2.588864, 2.609862, 0.936086>
  }
  rotate <-0.0, 18.722126, -0.0>
  translate  <-0.502532, 0.515038, -2.858145>
}
#declare swing_link1 = union {
  box { // Cube694
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066074, 0.0178, 0.307449>
    translate  <-2.800516, 3.121259, -1.414448>
  }
  cylinder { // Cylndr647
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.057705>
    rotate -90.0*x
    translate  <-2.80041, 3.082224, -1.721636>
  }
  cylinder { // Cylndr648
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.060723>
    rotate -90.0*x
    translate  <-2.799607, 3.095302, -1.093976>
  }
  cylinder { // Cylndr649
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.025175>
    rotate -90.0*x
    translate  <-2.800291, 3.150813, -1.093485>
  }
  cylinder { // Cylndr650
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.097608>
    rotate -90.0*x
    translate  <-2.80041, 3.049656, -1.721636>
  }
  box { // Cube695
    <-1, -1, -1>, <1, 1, 1>
    scale <0.063047, 0.0178, 0.135763>
    rotate <0.0, -14.783519, 0.0>
    translate  <-2.84003, 3.121259, -0.958917>
  }
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.036579>
    rotate -90.0*x
    translate  <-2.869832, 3.10335, -0.845169>
  }
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.025175>
    rotate -90.0*x
    translate  <-2.869777, 3.124101, -0.8444>
  }
  object { CSG360 }
  scale -1.0
  rotate <180.0, 18.701729, 180.0>
  translate  <-0.532565, 2.521014, 2.91584>
}
#declare Group145 = union {
  sphere { // Sphere589
    <0,0,0>,1
    scale 0.039718
    translate  <-5.104059, -0.460295, 0.486327>
  }
  sphere { // Sphere590
    <0,0,0>,1
    scale 0.039718
    translate  <-4.948616, -0.460295, 0.486327>
  }
  sphere { // Sphere592
    <0,0,0>,1
    scale 0.039718
    translate  <-4.648267, -0.460295, 0.486327>
  }
  sphere { // Sphere591
    <0,0,0>,1
    scale 0.039718
    translate  <-4.787902, -0.460295, 0.486327>
  }
  translate  0.008673*y
}
#declare CSG371 = union {
  box { // Cube788
    <-1, -1, -1>, <1, 1, 1>
    scale <0.520673, 0.035634, 0.070897>
    translate  <-1.736952, 4.224503, 1.018491>
  }
  cylinder { // Cylndr686
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-1.210669, 4.188959, 1.018328>
  }
  cylinder { // Cylndr687
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-2.254716, 4.18888, 1.018328>
  }
}
#declare Group148 = union {
  object { CSG371 }
  cylinder { // Cylndr691
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045852, 0.045852, 0.803849>
    rotate -90.0*x
    translate  <-1.210669, 4.17396, 1.018328>
  }
  material {
    chassis_black
  }
  translate  -4.739909*y
}
#declare Conn_rods_L = union {
  object { slide_bar1 }
  object { Main_conn_rod1 }
  object { drive_rod1 }
  object { down_link4 }
  object { lower_flange1 }
  object { down_link5 }
  object { down_link6 }
  object { cross_link2 }
  object { top_link1 }
  object { top_rod1 }
  object { cross_link3 }
  object { swing_link1 }
  object { Group145 }
  object { Group148 }
  material {
    conn_rods
  }
}
#declare top_rod = union {
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.032854, 0.032854, 0.759342>
    rotate -90.0*y
    translate  <-5.183121, 2.561444, 1.116009>
  }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    scale <0.068464, 0.068464, 0.258992>
    rotate -90.0*y
    translate  <-5.677056, 2.561444, 1.116009>
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    scale <0.089227, 0.089227, 0.045364>
    rotate -90.0*y
    translate  <-5.584875, 2.561444, 1.116009>
  }
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    scale <0.060379, 0.060379, 0.043268>
    rotate -90.0*y
    translate  <-5.630969, 2.561444, 1.116009>
  }
}
#declare top_link = union {
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    scale <0.053997, 0.053997, 0.06946>
    rotate -90.0*x
    translate  <-5.130207, 3.639359, 0.937798>
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.0313, 0.0313, 2.330039>
    rotate <0.0, -90.0, 0.0>
    translate  <-2.771162, 3.674406, 0.936086>
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    scale <0.053997, 0.053997, 0.06946>
    rotate -90.0*x
    translate  <-2.759032, 3.639359, 0.937798>
  }
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.032227, 0.032227, 0.041455>
    rotate -90.0*x
    translate  <-5.130207, 3.67332, 0.937798>
  }
  translate  -1.064275*y
}
#declare CSG270 = difference {
  box { // Cube499
    <-1, -1, -1>, <1, 1, 1>
    scale <0.293999, 0.0655, 0.358572>
    translate  <-4.41683, 2.404664, 0.205123>
  }
  box { // Cube505
    <-1, -1, -1>, <1, 1, 1>
    material {
      conn_rods
    }
    scale <0.262475, 0.047824, 0.26324>
    translate  <-4.315955, 2.404664, 0.047505>
  }
  box { // Cube507
    <-1, -1, -1>, <1, 1, 1>
    material {
      conn_rods
    }
    scale <0.120771, 0.085386, 0.229976>
    rotate 30.86064*y
    translate  <-4.107898, 2.404664, -0.053371>
  }
}
#declare slide_bar = union {
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.04653, 0.04653, 1.702039>
    rotate -90.0*y
    translate  <-4.285005, 2.405768, 0.097229>
  }
  box { // Cube503
    <-1, -1, -1>, <1, 1, 1>
    scale <1.392174, 0.021349, 0.060254>
    translate  <-4.620869, 2.404664, 0.468121>
  }
  object { CSG270 }
  translate  0.0*z
}
#declare cross_link = union {
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.441375, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.771682, 3.530917, -1.181174>
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.135224, 3.510396, -1.181087>
  }
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.134639, 3.530917, -1.181174>
  }
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  translate  <0.004927, -0.966512, 0.894925>
}
#declare CSG249 = union {
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube572
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube573
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube574
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube575
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG295 = difference {
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.3829, 1.25991>
  }
  object { CSG249 }
}
#declare nut88 = union {
  object { CSG295 }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.382248, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.710419, -5.197479>
}
#declare CSG296 = union {
  box { // Cube576
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube577
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube578
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube579
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube580
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube581
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG297 = difference {
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG296 }
}
#declare nut89 = union {
  object { CSG297 }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.510058, -5.648904>
}
#declare CSG298 = union {
  box { // Cube582
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube583
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube584
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube585
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube586
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube587
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG299 = difference {
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG298 }
}
#declare nut90 = union {
  object { CSG299 }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.73148, -5.428998>
}
#declare CSG300 = union {
  box { // Cube588
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube589
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube590
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube591
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube592
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube593
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG301 = difference {
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG300 }
}
#declare nut91 = union {
  object { CSG301 }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.795186
  rotate <-0.0, 90.0, 0.0>
  translate  <-6.819966, 2.284883, -5.428998>
}
#declare lower_flange = union {
  object { nut88 }
  object { nut89 }
  object { nut90 }
  object { nut91 }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.869019, 2.402681, 0.096005>
  }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    scale <0.275516, 0.275516, 0.043468>
    rotate -90.0*y
    translate  <-5.820024, 2.402681, 0.096005>
  }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    scale <0.154747, 0.154747, 0.024414>
    rotate -90.0*y
    translate  <-5.798249, 2.402681, 0.096005>
  }
}
#declare CSG272 = union {
  torus { // Torus088
    1.674, 0.326  rotate -x*90
    scale 0.039785
    rotate <-90.0, -0.0, 0.0>
    translate  <-4.433008, 3.458944, -1.285912>
  }
  sphere { // Sphere439
    <0,0,0>,1
    scale <0.068703, 0.020372, 0.068703>
    translate  <-4.432444, 3.471788, -1.286846>
  }
  material {
    Silver_Texture
  }
}
#declare CSG271 = union {
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    scale <0.142555, 0.142555, 0.061952>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, 0.094571>
  }
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    scale <0.079508, 0.079508, 0.061803>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, -0.283713>
  }
  box { // Cube508
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate <0.0, 9.809636, 0.0>
    translate  <-4.386896, 3.427037, -0.085579>
  }
  box { // Cube509
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate -9.80964*y
    translate  <-4.478408, 3.427037, -0.085579>
  }
  translate  -1.387043*z
}
#declare CSG282 = union {
  object { CSG272 }
  object { CSG271 }
}
#declare CSG280 = union {
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube532
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube533
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG281 = difference {
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG280 }
}
#declare nut83 = union {
  object { CSG281 }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.466057, 2.720876, 2.779743>
}
#declare CSG278 = union {
  box { // Cube522
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube523
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube524
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG279 = difference {
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG278 }
}
#declare nut82 = union {
  object { CSG279 }
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.66613>
}
#declare CSG276 = union {
  box { // Cube516
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube517
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube518
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube519
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube521
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG277 = difference {
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG276 }
}
#declare nut81 = union {
  object { CSG277 }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.245403, 2.720714, 2.779743>
}
#declare CSG273 = union {
  box { // Cube510
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube511
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube512
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube513
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube514
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube515
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG275 = difference {
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG273 }
}
#declare nut80 = union {
  object { CSG275 }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.887723>
}
#declare Group105 = union {
  object { nut83 }
  object { nut82 }
  object { nut81 }
  object { nut80 }
  material {
    Silver_Texture
  }
  rotate 180.0*x
  translate  <-0.155981, 5.44149, -2.578988>
}
#declare down_link1 = union {
  object { CSG282 }
  object { Group105 }
  rotate 7.558569*y
  translate  <0.211043, -0.917428, 0.785341>
}
#declare CSG247 = union {
  box { // Cube496
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG248 = difference {
  object { CSG247 }
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG250 = union {
  object { CSG248 }
}
#declare CSG251 = union {
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.105466>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG252 = union {
  box { // Cube498
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG253 = difference {
  object { CSG252 }
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG254 = union {
  object { CSG251 }
  object { CSG253 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG255 = union {
  object { CSG250 }
  object { CSG254 }
  box { // Cube497
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG256 = difference {
  object { CSG255 }
}
#declare CSG258 = union {
  box { // Cube500
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG259 = difference {
  object { CSG258 }
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG260 = union {
  object { CSG259 }
}
#declare CSG261 = union {
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.107272>
    rotate -90.0*x
    translate  <0.0, 2.299005, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG262 = union {
  box { // Cube501
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG263 = difference {
  object { CSG262 }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG264 = union {
  object { CSG261 }
  object { CSG263 }
  rotate <180.0, 0.0, 180.0>
  translate  <-2.214666, 0.0, -0.748583>
}
#declare CSG265 = union {
  object { CSG260 }
  object { CSG264 }
  box { // Cube502
    <-1, -1, -1>, <1, 1, 1>
    scale <0.903122, 0.040851, 0.088985>
    translate  <-1.109778, 2.355151, -0.373958>
  }
}
#declare CSG266 = difference {
  object { CSG265 }
  translate  -2.213783*x
}
#declare Main_conn_rod = union {
  object { CSG256 }
  object { CSG266 }
  translate  -0.068457*y
}
#declare CSG257 = union {
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    scale <0.078266, 0.078266, 0.00902>
    rotate -90.0*x
    translate  <0.0, 2.403527, -0.374282>
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    scale <0.068894, 0.068894, 0.241552>
    rotate -90.0*x
    translate  <0.0, 2.161715, -0.374282>
  }
  material {
    Silver_Texture
  }
}
#declare CSG267 = union {
  box { // Cube504
    <-1, -1, -1>, <1, 1, 1>
    scale <0.067538, 0.040851, 0.103399>
    translate  <-0.133683, 2.355151, -0.373958>
  }
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    scale <0.13852, 0.13852, 0.083427>
    rotate -90.0*x
    translate  <0.0, 2.312155, -0.374282>
  }
}
#declare CSG268 = difference {
  object { CSG267 }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.254731>
  }
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    scale <0.130889, 0.029991, 0.09397>
    rotate -90.0*x
    translate  <-0.199252, 2.307469, -0.492985>
  }
}
#declare CSG269 = union {
  object { CSG257 }
  object { CSG268 }
}
#declare CSG274 = union {
  object { CSG269 }
  box { // Cube506
    <-1, -1, -1>, <1, 1, 1>
    scale <2.116251, 0.040851, 0.088985>
    translate  <-2.307742, 2.355151, -0.373958>
  }
  translate  -0.027353*y
}
#declare drive_rod = difference {
  object { CSG274 }
  rotate 5.880184*y
  translate  <0.034465, 0.078562, -0.016344>
}
#declare CSG283 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.141983, 3.425532, -2.368722>
  }
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    scale <0.042308, 0.042308, 0.025658>
    rotate -90.0*x
    translate  <-5.141983, 3.459863, -2.368722>
  }
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.108116, -0.013084, -0.050518>
    rotate <90.0, -78.995392, 90.0>
    translate  <-5.143163, 3.390747, -2.216463>
  }
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.108116, -0.013084, -0.050518>
    rotate <90.0, 78.995392, 90.0>
    translate  <-5.143163, 3.431909, -2.216463>
  }
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    scale <0.042308, 0.042308, 0.025658>
    rotate -90.0*x
    translate  <-5.141983, 3.343882, -2.368722>
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-5.141983, 3.357641, -2.368722>
  }
  rotate 90.0*y
  translate  <-3.430259, 0.117261, -6.321086>
}
#declare down_link2 = union {
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.701567, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.031015, 3.530917, -1.176501>
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  object { CSG283 }
  rotate -90.0*y
  translate  <-6.303615, -0.969408, 5.50571>
}
#declare CSG284 = union {
  torus { // Torus089
    1.674, 0.326  rotate -x*90
    scale 0.039785
    rotate <-90.0, -0.0, 0.0>
    translate  <-4.433008, 3.458944, -1.285912>
  }
  sphere { // Sphere440
    <0,0,0>,1
    scale <0.068703, 0.020372, 0.068703>
    translate  <-4.432444, 3.471788, -1.286846>
  }
  material {
    Silver_Texture
  }
}
#declare CSG285 = union {
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    scale <0.142555, 0.142555, 0.061952>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, 0.094571>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    scale <0.079508, 0.079508, 0.061803>
    rotate -90.0*x
    translate  <-4.433217, 3.396512, -0.283713>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate <0.0, 9.809636, 0.0>
    translate  <-4.386896, 3.427037, -0.085579>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065366, 0.031077, 0.193004>
    rotate -9.80964*y
    translate  <-4.478408, 3.427037, -0.085579>
  }
  translate  -1.387043*z
}
#declare CSG286 = union {
  object { CSG284 }
  object { CSG285 }
}
#declare CSG287 = union {
  box { // Cube543
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube545
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG288 = difference {
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG287 }
}
#declare nut84 = union {
  object { CSG288 }
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.466057, 2.720876, 2.779743>
}
#declare CSG289 = union {
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube550
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube551
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube552
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube553
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube554
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG290 = difference {
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG289 }
}
#declare nut85 = union {
  object { CSG290 }
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.66613>
}
#declare CSG291 = union {
  box { // Cube555
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube556
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube557
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube558
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube559
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube560
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG292 = difference {
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG291 }
}
#declare nut86 = union {
  object { CSG292 }
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.245403, 2.720714, 2.779743>
}
#declare CSG293 = union {
  box { // Cube561
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.169363, 1.277036>
  }
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    translate  <-6.940111, -0.092793, 1.277036>
  }
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.908237, -0.111135, 1.277036>
  }
  box { // Cube564
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.908415, -0.150488, 1.277036>
  }
  box { // Cube565
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate 60.0*z
    translate  <-6.973944, -0.112559, 1.277036>
  }
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.022284, 0.008796, 0.020427>
    rotate -60.0*z
    translate  <-6.972876, -0.150844, 1.277036>
  }
}
#declare CSG294 = difference {
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    scale 0.033713
    translate  <-6.940598, -0.130932, 1.25991>
  }
  object { CSG293 }
}
#declare nut87 = union {
  object { CSG294 }
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    scale 0.015028
    translate  <-6.940598, -0.130932, 1.286906>
  }
  scale 0.585799
  rotate <90.0, -90.0, 0.0>
  translate  <-4.357138, 2.720876, 2.887723>
}
#declare Group106 = union {
  object { nut84 }
  object { nut85 }
  object { nut86 }
  object { nut87 }
  material {
    Silver_Texture
  }
  rotate 180.0*x
  translate  <-0.155981, 5.44149, -2.578988>
}
#declare down_link3 = union {
  object { CSG286 }
  object { Group106 }
  rotate <180.0, -21.945618, 180.0>
  translate  <-4.596253, -0.941353, 0.079665>
}
#declare cross_link1 = union {
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    scale <-1.41055, -0.013084, -0.050518>
    rotate <-180.0, 0.0, -180.0>
    translate  <-5.733008, 3.530917, -1.181174>
  }
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-4.408347, 3.510396, -1.181087>
  }
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    scale <0.065672, 0.065672, 0.039828>
    rotate -90.0*x
    translate  <-7.068743, 3.510396, -1.181087>
  }
  box { // Cube568
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-4.41025, 3.530917, -1.181174>
  }
  box { // Cube569
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.012841, -0.013084, -0.071869>
    rotate <-180.0, 0.0, -180.0>
    translate  <-7.068158, 3.530917, -1.181174>
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.042796, 0.042796, 0.025955>
    rotate -90.0*x
    translate  <-4.408347, 3.53301, -1.181087>
  }
  rotate 8.32578*y
  translate  <4.673979, -0.990946, 0.503384>
}
#declare CSG357 = union {
  cone { // Cone063
    <0,0,0>, 0.193, <0,0,1>, 1.56
    scale <0.097041, 0.025672, 0.114231>
    rotate 180.0*x
    translate  <-2.352603, 2.61282, 1.051072>
  }
  cylinder { // Cylndr646
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.108118>
    rotate <90.0, -90.0, 0.0>
    translate  <-2.352929, 2.660436, 1.010592>
  }
  cylinder { // Cylndr645
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.301856>
    rotate <-0.0, -90.0, 0.0>
    translate  <-2.200813, 2.609862, 0.936086>
  }
  translate  0.09333*x
}
#declare CSG358 = union {
  object { CSG357 }
  cylinder { // Cylndr644
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.0313, 0.0313, 0.689493>
    rotate <-0.0, -90.0, 0.0>
    translate  <-1.944794, 2.611374, 0.936086>
  }
  cylinder { // Cylndr643
    <0,0,1>, <0,0,0>, 1 
    scale <0.04568, 0.04568, 0.301856>
    rotate <-0.0, -90.0, 0.0>
    translate  <-2.588864, 2.609862, 0.936086>
  }
  rotate 23.722225*y
  translate  <-0.664281, 0.515038, -3.050418>
}
#declare swing_link = union {
  box { // Cube692
    <-1, -1, -1>, <1, 1, 1>
    scale <0.066074, 0.0178, 0.307449>
    translate  <-2.800516, 3.121259, -1.414448>
  }
  cylinder { // Cylndr637
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.057705>
    rotate -90.0*x
    translate  <-2.80041, 3.082224, -1.721636>
  }
  cylinder { // Cylndr638
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.060723>
    rotate -90.0*x
    translate  <-2.799607, 3.095302, -1.093976>
  }
  cylinder { // Cylndr640
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.025175>
    rotate -90.0*x
    translate  <-2.800291, 3.149814, -1.093485>
  }
  cylinder { // Cylndr639
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.097608>
    rotate -90.0*x
    translate  <-2.80041, 3.049656, -1.721636>
  }
  box { // Cube693
    <-1, -1, -1>, <1, 1, 1>
    scale <0.063047, 0.0178, 0.135763>
    rotate <0.0, -14.783519, 0.0>
    translate  <-2.84003, 3.121259, -0.958917>
  }
  cylinder { // Cylndr641
    <0,0,1>, <0,0,0>, 1 
    scale <0.065777, 0.065777, 0.036579>
    rotate -90.0*x
    translate  <-2.869832, 3.10335, -0.845169>
  }
  cylinder { // Cylndr642
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045271, 0.045271, 0.025175>
    rotate -90.0*x
    translate  <-2.869777, 3.124101, -0.8444>
  }
  object { CSG358 }
  rotate -23.722225*y
  translate  <-0.619038, -0.515038, 3.05992>
}
#declare Group146 = union {
  sphere { // Sphere593
    <0,0,0>,1
    scale 0.039718
    translate  <-5.104059, -0.460295, 0.486327>
  }
  sphere { // Sphere594
    <0,0,0>,1
    scale 0.039718
    translate  <-4.948616, -0.460295, 0.486327>
  }
  sphere { // Sphere595
    <0,0,0>,1
    scale 0.039718
    translate  <-4.648267, -0.460295, 0.486327>
  }
  sphere { // Sphere596
    <0,0,0>,1
    scale 0.039718
    translate  <-4.787902, -0.460295, 0.486327>
  }
  translate  <0.46067, 2.921879, 0.0>
}
#declare CSG362 = union {
  box { // Cube785
    <-1, -1, -1>, <1, 1, 1>
    scale <0.520673, 0.035634, 0.070897>
    translate  <-1.736952, 4.224503, 1.018491>
  }
  cylinder { // Cylndr679
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-1.210669, 4.188959, 1.018328>
  }
  cylinder { // Cylndr680
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-2.254716, 4.18888, 1.018328>
  }
}
#declare CSG363 = union {
  box { // Cube786
    <-1, -1, -1>, <1, 1, 1>
    scale <0.418647, 0.035634, 0.070897>
    translate  <-1.838977, 4.224503, 1.018491>
  }
  cylinder { // Cylndr681
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-1.427473, 4.188959, 1.018328>
  }
  cylinder { // Cylndr682
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-2.254716, 4.18888, 1.018328>
  }
  rotate -85.965569*y
  translate  <-0.03826, 0.072329, 3.197665>
}
#declare CSG370 = union {
  box { // Cube787
    <-1, -1, -1>, <1, 1, 1>
    scale <0.652381, 0.035634, 0.070897>
    translate  <-1.605243, 4.224503, 1.018491>
  }
  cylinder { // Cylndr684
    <0,0,1>, <0,0,0>, 1 
    scale 0.070912
    rotate -90.0*x
    translate  <-2.254716, 4.18888, 1.018328>
  }
  rotate -15.361293*y
  translate  <1.281965, 0.0, 1.466358>
}
#declare Group147 = union {
  object { CSG362 }
  object { CSG363 }
  object { CSG370 }
  cylinder { // Cylndr683
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.045852, 0.045852, 0.770974>
    rotate -90.0*x
    translate  <-1.210669, 3.56525, 1.018328>
  }
  cylinder { // Cylndr685
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale 0.043767
    rotate -90.0*x
    translate  <-1.158082, 4.295864, 1.848173>
  }
  material {
    chassis_black
  }
  translate  -1.694357*y
}
#declare conn_rods_r = union {
  object { top_rod }
  object { top_link }
  object { slide_bar }
  object { cross_link }
  object { lower_flange }
  object { down_link1 }
  object { Main_conn_rod }
  object { drive_rod }
  object { down_link2 }
  object { down_link3 }
  object { cross_link1 }
  object { swing_link }
  object { Group146 }
  object { Group147 }
  material {
    conn_rods
  }
}
#declare CSG396 = difference {
  torus { // Torus094
    1.747, 0.253  rotate -x*90
    scale 0.149721
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.307473, 1.571128, 3.796314>
  }
  box { // Cube863
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    rotate <-60.672535, 0.0, -0.0>
    translate  <-2.304622, 1.634396, 3.640476>
  }
  box { // Cube862
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    translate  <-2.304622, 1.40155, 3.785001>
  }
}
#declare CSG397 = difference {
  torus { // Torus095
    1.747, 0.253  rotate -x*90
    scale 0.149721
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.307473, 1.571128, 3.796314>
  }
  box { // Cube864
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    rotate <-30.783701, 0.0, -0.0>
    translate  <-2.304622, 1.700739, 3.691424>
  }
  box { // Cube865
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    translate  <-2.304622, 1.40155, 3.785001>
  }
  rotate -59.024517*x
  translate  <0.0, -2.038204, 2.414637>
}
#declare Group156 = union {
  object { CSG396 }
  cylinder { // Cylndr720
    <0,0,1>, <0,0,0>, 1 
    scale <0.037637, 0.037637, 0.894199>
    rotate <30.408098, 0.0, 0.0>
    translate  <-2.307505, 2.24965, 3.156437>
  }
  object { CSG397 }
  cylinder { // Cylndr721
    <0,0,1>, <0,0,0>, 1 
    scale <0.037637, 0.037637, 1.526965>
    translate  <-2.307505, 2.286376, 1.499292>
  }
  material {
    Pipe_copper
  }
}
#declare CSG398 = difference {
  torus { // Torus096
    1.747, 0.253  rotate -x*90
    scale 0.149721
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.307473, 1.571128, 3.796314>
  }
  box { // Cube866
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    rotate <-60.672535, 0.0, -0.0>
    translate  <-2.304622, 1.634396, 3.640476>
  }
  box { // Cube867
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    translate  <-2.304622, 1.40155, 3.785001>
  }
}
#declare CSG399 = difference {
  torus { // Torus097
    1.747, 0.253  rotate -x*90
    scale 0.149721
    rotate <-90.0, 0.0, -90.0>
    translate  <-2.307473, 1.571128, 3.796314>
  }
  box { // Cube868
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    rotate <-30.783701, 0.0, -0.0>
    translate  <-2.304622, 1.700739, 3.691424>
  }
  box { // Cube869
    <-1, -1, -1>, <1, 1, 1>
    scale <0.068155, 0.168848, 0.335893>
    translate  <-2.304622, 1.40155, 3.785001>
  }
  rotate -59.024517*x
  translate  <0.0, -2.038204, 2.414637>
}
#declare Group157 = union {
  object { CSG398 }
  cylinder { // Cylndr722
    <0,0,1>, <0,0,0>, 1 
    scale <0.037637, 0.037637, 0.894199>
    rotate <30.408098, 0.0, 0.0>
    translate  <-2.307505, 2.24965, 3.156437>
  }
  object { CSG399 }
  cylinder { // Cylndr723
    <0,0,1>, <0,0,0>, 1 
    scale <0.037637, 0.037637, 1.526965>
    translate  <-2.307505, 2.286376, 1.499292>
  }
  material {
    Pipe_copper
  }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.899641*y
}
#declare valve_lever = union {
  box { // Cube870
    <-1, -1, -1>, <1, 1, 1>
    scale <1.250892, 0.004321, 0.035529>
    translate  <-1.058852, 0.245209, 4.173809>
  }
  cylinder { // Cylndr724
    <0,0,1>, <0,0,0>, 1 
    scale <0.035429, 0.035429, 0.008667>
    rotate -90.0*x
    translate  <-2.308744, 0.240858, 4.173866>
  }
  cylinder { // Cylndr725
    <0,0,1>, <0,0,0>, 1 
    material {
      Silver_Texture
    }
    scale <0.017495, 0.017495, 0.724069>
    rotate -90.0*x
    translate  <-2.308744, 0.237132, 4.173866>
  }
}
#declare valve3 = union {
  cylinder { // Cylndr714
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.048341, 0.048341, 0.597368>
    translate  <-2.307505, 1.000504, 3.935749>
  }
  cylinder { // Cylndr715
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.08357, 0.08357, 0.56192>
    rotate 90.0*y
    translate  <-2.589335, 1.000504, 4.067057>
  }
  cylinder { // Cylndr716
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.125204, 0.125204, 0.026159>
    rotate 90.0*y
    translate  <-2.461231, 1.000504, 4.067057>
  }
  cylinder { // Cylndr717
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.125204, 0.125204, 0.026159>
    rotate 90.0*y
    translate  <-2.195414, 1.000504, 4.067057>
  }
  cylinder { // Cylndr718
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.073962, 0.073962, 0.020861>
    translate  <-2.307505, 1.000504, 4.29124>
  }
  cylinder { // Cylndr719
    <0,0,1>, <0,0,0>, 1 
    material {
      Pipe_copper
    }
    scale <0.037637, 0.037637, 1.240372>
    rotate <90.0, 0.0, -0.0>
    translate  <-2.307505, 1.57114, 4.057449>
  }
  object { Group156 }
  object { Group157 }
  object { valve_lever }
}
#declare CSG400 = difference {
  superellipsoid { // SuperQ044
    <1.0, 0.043>
    scale <0.97462, 0.56001, 0.039351>
    translate  <0.494984, 0.363835, 0.005985>
  }
  superellipsoid { // SuperQ045
    <1.0, 0.009>
    material {
      chassis_black
    }
    scale <0.898469, 0.516254, 0.066623>
    translate  <0.494984, 0.363835, 0.062846>
  }
}
#declare Group166 = union {
  object { CSG400 }
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Arialbd.ttf",
    "10",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <1.0, 1.0, 0.042999>
  }

  material {
    Pipe_copper
  }
  scale 0.384868
  rotate 90.0*x
  translate  <0.68104, -1.109684, 2.306747>
}
#declare CSG401 = difference {
  superellipsoid { // SuperQ046
    <1.0, 0.043>
    scale <0.97462, 0.56001, 0.039351>
    translate  <0.494984, 0.363835, 0.005985>
  }
  superellipsoid { // SuperQ047
    <1.0, 0.009>
    material {
      buffer_red
    }
    scale <0.898469, 0.516254, 0.066623>
    translate  <0.494984, 0.363835, 0.062846>
  }
}
#declare Group167 = union {
  object { CSG401 }
  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Arialbd.ttf",
    "10",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <1.0, 1.0, 0.042999>
  }

  material {
    Pipe_copper
  }
  scale 0.384868
  rotate <90.0, -0.0, 180.0>
  translate  <1.064526, 3.085293, 2.306747>
}
#declare nameplates = union {
  object { Group166 }
  object { Group167 }
}
#declare BezPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.353008, 0.305615>, <-1.000000, -2.353008, 0.305615>, <0.000000, -2.353008, 0.305615>, <1.000000, -2.353008, 0.305615>, 
      <-2.000000, -2.577503, -0.441260>, <-1.000000, -2.577503, -0.441260>, <0.000000, -2.577503, -0.441260>, <1.000000, -2.577503, -0.441260>, 
      <-2.000000, 1.290684, 0.364039>, <-1.000000, 1.290684, 0.364039>, <0.000000, 1.290684, 0.364039>, <1.000000, 1.290684, 0.364039>, 
      <-2.000000, 0.845559, -0.330945>, <-1.000000, 0.845559, -0.330945>, <0.000000, 0.845559, -0.330945>, <1.000000, 0.845559, -0.330945>
    }
  }
  material {
    step_colour
  }
  scale <0.202777, 0.071997, 0.154479>
  translate  <3.843692, 3.057709, 0.061815>
}
#declare BezPtch002 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.353008, 0.305615>, <-1.000000, -2.353008, 0.305615>, <0.000000, -2.353008, 0.305615>, <1.000000, -2.353008, 0.305615>, 
      <-2.000000, -2.577503, -0.441260>, <-1.000000, -2.577503, -0.441260>, <0.000000, -2.577503, -0.441260>, <1.000000, -2.577503, -0.441260>, 
      <-2.000000, 1.290684, 0.364039>, <-1.000000, 1.290684, 0.364039>, <0.000000, 1.290684, 0.364039>, <1.000000, 1.290684, 0.364039>, 
      <-2.000000, 0.845559, -0.330945>, <-1.000000, 0.845559, -0.330945>, <0.000000, 0.845559, -0.330945>, <1.000000, 0.845559, -0.330945>
    }
  }
  material {
    step_colour
  }
  scale <0.202777, 0.071997, 0.154479>
  rotate 180.0*z
  translate  <3.635555, -1.078597, 0.061815>
}
#declare steps = union {
  object { BezPtch001 }
  object { BezPtch002 }
}
union { // ngloco
  object { Boiler_group }
  object { Buffer_beam }
  object { Running_gear }
  object { Cab }
  object { chassis }
  object { side_valve }
  object { side_valve1 }
  object { pipework }
  object { Conn_rods_L }
  object { conn_rods_r }
  object { valve3 }
  object { nameplates }
  object { steps }
  material {
    chassis_black
  }
}


