 bvillage.inc    @ 8" D  P&+txP   @TEXTMPS  @       J+  o f                         // bvillage.inc

#debug "\rbvillage.inc - Build the village.\r"

// Define the LandForm variables
// Central area only:
//#declare LandFormMin=<-1360,    0,-1360>*ft;
//#declare LandFormMax=< 1360,   20, 1360>*ft;

// Central area and surrounding blocks:
#declare LandFormMin=<-4080,    0,-4080>*ft;
#declare LandFormMax=< 1360,   20, 4080>*ft;

#declare LandFormScl=80*ft;
#declare LandFormSeed=seed(4457);

#include "landforms.mcr"

//=======================================================================
// Now define and build the landscape from large, half-mile square blocks.
#include "vill_ll.inc"
#include "vill_lm.inc"
//#include "vill_ln.inc"
#include "vill_ml.inc"
#include "vill_mm.inc"
//#include "vill_mn.inc"
#include "vill_nl.inc"
#include "vill_nm.inc"
//#include "vill_nn.inc"
#debug "\r----\rEnd of landscape building\r----\r"
// To write out the next block along:
//LandFormBlockWrite("vill_ll.inc",<-4080,    0, 1360>,< -1360,  200, 4080>)
//LandFormBlockWrite("vill_lm.inc",<-1360,    0, 1360>,<  1360,  200, 4080>)
//LandFormBlockWrite("vill_ln.inc",< 1360,    0, 1360>,<  4080,  200, 4080>)
//
//LandFormBlockWrite("vill_ml.inc",<-4080,    0,-1360>,< -1360,  200, 1360>)
//LandFormBlockWrite("vill_mn.inc",< 1360,    0,-1360>,<  4080,  200, 1360>)
//
//LandFormBlockWrite("vill_nl.inc",<-4080,    0,-4080>,< -1360,  200,-1360>)
//LandFormBlockWrite("vill_nm.inc",<-1360,    0,-4080>,<  1360,  200,-1360>)
//LandFormBlockWrite("vill_nn.inc",< 1360,    0,-4080>,<  4080,  200,-1360>)
//

#include "rtdhc.inc"

// Build
LandFormNormalise()
LandFormDraw(3)
/*
box{
	<LandFormMin.x,   -3*ft,LandFormMin.z>,<LandFormMax.x,    0,LandFormMax.z>
	texture{Ground}
}
*/
box{
	<LandFormMin.x,  180*ft,LandFormMin.z>,<LandFormMax.x,  190*ft,LandFormMax.z>
	texture{Stream}
}

#declare RoundTower=
union{
  difference{
	  union{
			cylinder{<0,0,0>,<0,32,0>*ft,10*ft}
			cylinder{<0,29,0>*ft,<0,32,0>*ft,11*ft}
			cone{<0,26,0>*ft,10*ft,<0,29,0>*ft,11*ft}
		}
		cylinder{<0,-1,0>,<0,33,0>*ft,8.5*ft}
		#local Rotn=-30;//windows
		#while (Rotn<=120)
			box{<8,4,-0.5>*ft,<10.5,6,0.5>*ft rotate y*Rotn}
			box{<8,11,-0.75>*ft,<10.5,14.5,0.75>*ft rotate y*Rotn}
			box{<8,19,-0.75>*ft,<10.5,22.5,0.75>*ft rotate y*Rotn}
			#local Rotn=Rotn+30;
		#end
		#local Rotn=0;//crenellations
		#while (Rotn<=180)
			box{<-11.5,30,-0.75>*ft,<11.5,33,0.75>*ft rotate y*Rotn}
			#local Rotn=Rotn+30;
		#end
	}
	texture{WallStone}
}

#declare SquareTower=
union{
	difference{
		union{
			box{<-15,0,-10>*ft,<0,30,10>*ft}
			box{<-15.5,27,-11>*ft,<0.5,30,11>*ft}
		}
		box{<-13.5,-1,-8.5>*ft,<-1.5,31,8.5>*ft}
		//windows
		box{<-15.5,  4,-6.5 >*ft,<-13,  6  ,-5.5 >*ft}
		box{<-15.5,  4,-0.5 >*ft,<-13,  6  , 0.5 >*ft}
		box{<-15.5,  4, 6.5 >*ft,<-13,  6  , 5.5 >*ft}
		box{<-15.5, 11,-6.75>*ft,<-13, 14.5,-5.25>*ft}
		box{<-15.5, 11,-0.75>*ft,<-13, 14.5, 0.75>*ft}
		box{<-15.5, 11, 6.75>*ft,<-13, 14.5, 5.25>*ft}
		box{<-15.5, 19,-6.75>*ft,<-13, 22.5,-5.25>*ft}
		box{<-15.5, 19,-0.75>*ft,<-13, 22.5, 0.75>*ft}
		box{<-15.5, 19, 6.75>*ft,<-13, 22.5, 5.25>*ft}
		#local ZZ=-9;//crenellations
		#while (ZZ<=9)
		  box{<-16,28,ZZ-0.5>*ft,<-13,31,ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
	texture{WallStone}
}

#declare Barbican=
union{
	difference{
		union{
			box{<-5,0,7.5>*ft,<10,35,20>*ft}
			box{<-5.5,31,7.5>*ft,<10.5,35,20.5>*ft}
			box{<-10,0,9>*ft,<5,35,-9>*ft}
			box{<-10.5,31,9>*ft,<5.5,35,-9>*ft}
			box{<-5,0,-7.5>*ft,<10,35,-20>*ft}
			box{<-5.5,31,-7.5>*ft,<10.5,35,-20.5>*ft}
		}
		//hollow out each tower separately
		box{<-3.5,-1,9>*ft,<8.5,36,18.5>*ft}
		box{<-8.5,-1,7.5>*ft,<3.5,36,-7.5>*ft}
		box{<-3.5,-1,-9>*ft,<8.5,36,-18.5>*ft}
		//cut out remaining inner walls
		box{<-3.49,-1,11>*ft,<3.49,36,-11>*ft}
		//windows [7.5] 9.75 13.75 17.75 [20]
		box{<  0,  4,  9.25>*ft,< 11,  6, 10.25>*ft}
		box{<  0,  4, 13.25>*ft,< 11,  6, 14.25>*ft}
		box{<  0,  4, 17.25>*ft,< 11,  6, 18.25>*ft}
		box{<  0,  4,- 9.25>*ft,< 11,  6,-10.25>*ft}
		box{<  0,  4,-13.25>*ft,< 11,  6,-14.25>*ft}
		box{<  0,  4,-17.25>*ft,< 11,  6,-18.25>*ft}
		box{<-11, 11,  9.00>*ft,< 11,14.5, 10.50>*ft}
		box{<-11, 11, 13.00>*ft,< 11,14.5, 14.50>*ft}
		box{<-11, 11, 17.00>*ft,< 11,14.5, 18.50>*ft}
		box{<-11, 11,- 9.00>*ft,< 11,14.5,-10.50>*ft}
		box{<-11, 11,-13.00>*ft,< 11,14.5,-14.50>*ft}
		box{<-11, 11,-17.00>*ft,< 11,14.5,-18.50>*ft}
		box{<-11, 19,  9.00>*ft,< 11,22.5, 10.50>*ft}
		box{<-11, 19, 13.00>*ft,< 11,22.5, 14.50>*ft}
		box{<-11, 19, 17.00>*ft,< 11,22.5, 18.50>*ft}
		box{<-11, 19,- 9.00>*ft,< 11,22.5,-10.50>*ft}
		box{<-11, 19,-13.00>*ft,< 11,22.5,-14.50>*ft}
		box{<-11, 19,-17.00>*ft,< 11,22.5,-18.50>*ft}
		box{<-11, 27,  9.00>*ft,< 11,30.5, 10.50>*ft}
		box{<-11, 27, 13.00>*ft,< 11,30.5, 14.50>*ft}
		box{<-11, 27, 17.00>*ft,< 11,30.5, 18.50>*ft}
		box{<-11, 27,- 9.00>*ft,< 11,30.5,-10.50>*ft}
		box{<-11, 27,-13.00>*ft,< 11,30.5,-14.50>*ft}
		box{<-11, 27,-17.00>*ft,< 11,30.5,-18.50>*ft}
		//central windows [9] 6 3 0 -3 -6 [-9]
		box{<-11, 19,- 6.75>*ft,< 11,22.5,- 5.25>*ft}
		box{<-11, 19,- 3.75>*ft,< 11,22.5,- 2.25>*ft}
		box{<-11, 19,- 0.75>*ft,< 11,22.5,  0.75>*ft}
		box{<-11, 19,  2.25>*ft,< 11,22.5,  3.75>*ft}
		box{<-11, 19,  5.25>*ft,< 11,22.5,  6.75>*ft}
		box{<-11, 27,- 6.75>*ft,< 11,30.5,- 5.25>*ft}
		box{<-11, 27,- 3.75>*ft,< 11,30.5,- 2.25>*ft}
		box{<-11, 27,- 0.75>*ft,< 11,30.5,  0.75>*ft}
		box{<-11, 27,  2.25>*ft,< 11,30.5,  3.75>*ft}
		box{<-11, 27,  5.25>*ft,< 11,30.5,  6.75>*ft}
		//gateway
		box{<-11,-1,5>*ft,<6,9,-5>*ft}
		cylinder{
			<-11,0,0>*ft,<6,0,0>*ft,5*ft
			scale <1,0.5,1>
			translate <0,9,0>*ft
		}
		box{<4.5,-1,6>*ft,<6,9,-6>*ft}
		cylinder{
			<4.5,0,0>*ft,<6,0,0>*ft,6*ft
			scale <1,0.5,1>
			translate <0,9,0>*ft
		}
		//crenellations
		#local ZZ=-16.5;
		#while (ZZ<=16.5)
		  box{<-11,33,ZZ-0.5>*ft,<11,36,ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
	texture{WallStone}
}

#declare EastWallC=
union{
	difference{
		union{
			box{<-5,0,20>*ft,<5,20,35>*ft}
			box{<4,19,20>*ft,<6,22,35>*ft}
			box{<-5,0,-35>*ft,<5,20,-20>*ft}
			box{<4,19,-20>*ft,<6,22,-35>*ft}
		}
		box{<-3.5,-1,20>*ft,<3.5,19,35>*ft}
		box{<-3.5,-1,-20>*ft,<3.5,19,-35>*ft}
		//crenellations and arrowslits
		#local ZZ=21.5;
		#while (ZZ<=33.5)
		  box{<3,21,ZZ-0.5>*ft,<7,23,ZZ+0.5>*ft}
		  box{<3,21,-ZZ-0.5>*ft,<7,23,-ZZ+0.5>*ft}
			box{<3,4,ZZ-0.5>*ft,<7,6,ZZ+0.5>*ft}
			box{<3,4,-ZZ-0.5>*ft,<7,6,-ZZ+0.5>*ft}
			box{<3,12,ZZ-0.5>*ft,<7,14,ZZ+0.5>*ft}
			box{<3,12,-ZZ-0.5>*ft,<7,14,-ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
	texture{WallStone}
}

#declare SouthWallC=
union{
	difference{
		union{
			box{<-42.5,0,0>*ft,<-10,20,-10>*ft}
			box{<-42.5,19,-9>*ft,<-10,22,-11>*ft}
			box{<10,0,0>*ft,<45,20,-10>*ft}
			box{<10,19,-9>*ft,<45,22,-11>*ft}
		}
		box{<-42.5,-1,-1.5>*ft,<-10,19,-8.5>*ft}
		box{<10,-1,-1.5>*ft,<45,19,-8.5>*ft}
		//crenellations [-42.5] -40.75 -37.75 -34.75 -31.75 -28.75 -25.75 -22.75 -19.75 -16.75 -13.75 -10.75 1.25 10.25 13.25 16.25 19.25 22.25 25.25 28.25 31.25 34.25 37.25 40.25 43.25 [45]
		#local XX=-40.75;
		#while (XX<=43.25)
		  box{<XX-0.5,21,-8>*ft,<XX+0.5,23,-12>*ft}
		  box{<XX-0.5,4,-8>*ft,<XX+0.5,6,-12>*ft}
		  box{<XX-0.5,12,-8>*ft,<XX+0.5,14,-12>*ft}
			#local XX=XX+3;
		#end
	}
	texture{WallStone}
}

#declare NorthWallC=
union{
	difference{
		union{
			box{<-42.5,0,0>*ft,<-10,20,10>*ft}
			box{<-42.5,19,9>*ft,<-10,22,11>*ft}
			box{<10,0,0>*ft,<45,20,10>*ft}
			box{<10,19,9>*ft,<45,22,11>*ft}
		}
		box{<-42.5,-1,1.5>*ft,<-10,19,8.5>*ft}
		box{<10,-1,1.5>*ft,<45,19,8.5>*ft}
		//crenellations [-42.5] -40.75 -37.75 -34.75 -31.75 -28.75 -25.75 -22.75 -19.75 -16.75 -13.75 -10.75 1.25 10.25 13.25 16.25 19.25 22.25 25.25 28.25 31.25 34.25 37.25 40.25 43.25 [45]
		#local XX=-40.75;
		#while (XX<=43.25)
		  box{<XX-0.5,21,8>*ft,<XX+0.5,23,12>*ft}
		  box{<XX-0.5,4,8>*ft,<XX+0.5,6,12>*ft}
		  box{<XX-0.5,12,8>*ft,<XX+0.5,14,12>*ft}
			#local XX=XX+3;
		#end
	}
	texture{WallStone}
}

#declare WestWallC=
union{
	difference{
		union{
			box{<-10,0,-35>*ft,<0,20,-10>*ft}
			box{<-11,19,-35>*ft,<-9,22,-10>*ft}
			box{<-10,0,10>*ft,<0,20,35>*ft}
			box{<-11,19,35>*ft,<-9,22,10>*ft}
		}
		box{<-8.5,-1,-35>*ft,<-1.5,19,-10>*ft}
		box{<-8.5,-1,35>*ft,<-1.5,19,10>*ft}
		//crenellations & arrowslits
		#local ZZ=10.5;
		#while (ZZ<=34.5)
		  box{<-12,21,ZZ-0.5>*ft,<-8,23,ZZ+0.5>*ft}
		  box{<-12,21,-ZZ-0.5>*ft,<-8,23,-ZZ+0.5>*ft}
			box{<-11,4,ZZ-0.5>*ft,<1,6,ZZ+0.5>*ft}
			box{<-11,4,-ZZ-0.5>*ft,<1,6,-ZZ+0.5>*ft}
			box{<-11,12,ZZ-0.5>*ft,<1,14,ZZ+0.5>*ft}
			box{<-11,12,-ZZ-0.5>*ft,<1,14,-ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
	texture{WallStone}
}

#declare Ruination=
union{
	blob{
		threshold 1
		sphere  {< 45, 32,-35>*ft,                 10*ft,10*ft}
		cylinder{< 45, 25,-35>*ft,<  5, 25,-30>*ft,10*ft,10*ft}
		sphere  {<-50, 32,-40>*ft,                 12*ft,15*ft}
		cylinder{<-50, 25,-32>*ft,<  5, 20,-30>*ft,12*ft,11*ft}
		sphere  {<-50, 22,-40>*ft,                 10*ft,11*ft}
		cylinder{<-55, 22,-40>*ft,<-55, 22, 40>*ft,10*ft,11*ft}
		cylinder{<-45, 25,-40>*ft,<-45, 25, 40>*ft,10*ft,11*ft}
		cylinder{<-50, 40, 40>*ft,<-50,  5, 40>*ft,15*ft,20*ft}
		sphere  {< 50, 32, 40>*ft,                 12*ft,15*ft}
		cylinder{< 40, 32, 30>*ft,< 40, 10, 30>*ft,10*ft,10*ft}
		cylinder{<  0, 30,-45>*ft,<  0, -1,-50>*ft,10*ft,15*ft}
		cylinder{<  0, 30,-45>*ft,<  0, 11,-45>*ft,15*ft,15*ft}
		cylinder{< 55, 32, 35>*ft,< 55, 32,-35>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-32,0>*ft}
		cylinder{< 57, 21, 30>*ft,< 58, 23,-30>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-22,0>*ft}
		cylinder{< 60, 10, 35>*ft,< 60, 12,-35>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-11,0>*ft}
		sphere  {<  0,  8, 40>*ft,                 15*ft,14*ft}
		sphere  {<  0, 16, 40>*ft,                 15*ft,15*ft}
		sphere  {<  0, 24, 40>*ft,                 15*ft,16*ft}
		sphere  {<  0, 32, 40>*ft,                 15*ft,17*ft}
		sphere  {<  0, 40, 40>*ft,                 15*ft,18*ft}
		cylinder{<-50, 24, 40>*ft,< 50, 24, 40>*ft,15*ft,16*ft}
		cylinder{<-50, 24,-40>*ft,< 40, 24,-40>*ft,15*ft,16*ft}
		cylinder{<-50,  0,-40>*ft,< 40, 24,-40>*ft,15*ft,16*ft}
		cylinder{<-50,  8,-40>*ft,<-50, 16, 40>*ft,15*ft,16*ft}
	}
	box{<45,8,20>*ft,<60,18,24>*ft}
	box{<45,4,30>*ft,<60,10,34>*ft}
	box{<45,9,45>*ft,<60,16,49>*ft}
	texture{WallStone}
}

#declare Castle=
union{
	union{//building
		//gatehouse
		object{Barbican translate <50,0,0>*ft}
		//towers
		object{RoundTower rotate y*0 translate < 50,0,-40>*ft}
		object{SquareTower rotate y*-90 translate <0,0,-35>*ft}
		object{RoundTower rotate y*90 translate <-50,0,-40>*ft}
		object{SquareTower rotate y*0 translate <-42.5,0,0>*ft}
		object{RoundTower rotate y*180 translate <-50,0, 40>*ft}
		object{SquareTower rotate y*90 translate <0,0,35>*ft}
		object{RoundTower rotate y*270 translate < 50,0, 40>*ft}
		//walls
		object{EastWallC translate <50,0,0>*ft}
		object{SouthWallC translate <0,0,-35>*ft}
		object{NorthWallC translate <0,0,35>*ft}
		object{WestWallC translate <-42.5,0,0>*ft}
		texture{WallStone}
	}
}

#declare CastleMound=
union{
	prism{
		conic_sweep quadratic_spline
		0.9,1,16
		// the <u,v> points
		< 71,-30>*ft,
		< 71,-51>*ft,< 61,-61>*ft,
		< 21,-61>*ft,<-21,-61>*ft,
		<-61,-61>*ft,<-71,-51>*ft,
		<-71,-21>*ft,<-71, 21>*ft,
		<-71, 51>*ft,<-61, 61>*ft,
		<-21, 61>*ft,< 21, 61>*ft,
		< 61, 61>*ft,< 71, 51>*ft,
		< 71,-51>*ft
		translate <0,-0.9,0>
		scale <1,-150*ft,1>
	}
	box{
		<60,0,-8>*ft,<80,-150,8>*ft
	}
	box{
		<60,0,0>*ft,<80,-150,20>*ft
		rotate x*10
		translate <0,0,8>*ft
	}
	texture{Ground}
}

// Add the buildings, street by street
// special buildings first
#if (Year<1700)
	//full castle
	union{
		object{Castle}
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)
	}
#else
	//ruined castle
	difference{
	//union{
		object{Castle}
		object{Ruination}
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)
	}
#end
object{CastleMound translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)}

#include "simple1.cst"

object{
  RTDH2(
		0,<0,50,0>,
		array[4]{1,1,1,1},
		array[9]{<15,5,0>,
			<0,0,0>,<20,0,0>,<-10,0,0>,<0,0,0>,
			<15,0,0>,<-10,0,0>,<0,10,0>,<0,0,0>
		},
		array[1]{0},
    <0,0,0>,<0,10,0>,<0,0,2>
	)
	scale <1.05,1.1,1.05>
	translate <-64*ft, 310*ft, 1000*ft>
}

#include "simple2.cst"

object{
  RTDH2(
		0,<0,-140,0>,
		array[4]{1,1,1,1},
		array[9]{<0,0,0>,
			<-20,0,-2>,<30,0,0>,<0,0,0>,<0,0,0>,
			<0,0,0>,<0,0,0>,<-10,0,0>,<-20,0,0>
		},
		array[1]{0},
		<0,0,0>,<0,-7,0>,<0,0,-6>
	)
	scale 0.95
	translate <-66*ft, 310*ft, 995*ft>
}

#include "simple3.cst"

object{
  RTDH2(
		0,<0,-170,0>,
		array[4]{1,1,1,1},
		array[9]{<-5,2,0>,
			<35,0,0>,<0,0,100>,<25,0,0>,<0,0,-100>,
			<0,0,-10>,<0,0,-6>,<0,0,0>,<0,0,0>
		},
		array[1]{0},
		<0,0,0>,<0,4,0>,<0,0,3>
	)
	translate <-75, 310, 1004>*ft
}

#declare ChurchRoof=
box{
	<-.5,-.5,-.5>*ft,<.5,.5,.5>*ft
	rotate x*45
}

#declare ChurchDoorCut=
union{
	box{
		<-3,.25,-.5>*ft,<3,6,1>*ft
	}
	intersection{
	  cylinder{
		  <-3,6,-.5>*ft,<-3,6,1.1>*ft,6*ft
		}
	  cylinder{
		  <3,6,-1>*ft,<3,6,1>*ft,6*ft
		}
	}
}

#declare ChurchWindow1Cut=
union{
	box{
		<-3,3,-.5>*ft,<3,6,1>*ft
	}
	intersection{
	  cylinder{
		  <-3,6,-.5>*ft,<-3,6,1.1>*ft,6*ft
		}
	  cylinder{
		  <3,6,-1>*ft,<3,6,1>*ft,6*ft
		}
		box{
			<-3,4,-1.5>*ft,<3,12,1.2>*ft
		}
	}
}

union{// church
	difference{
		union{
			box{
				<-20,0,-15>*ft,<20,18,15>*ft
			}
			object{
				ChurchRoof
				scale <1,1,1/sqrt(2)>*<40,18,30>
				translate <0,18,0>*ft
			}
			box{
				<-10,0,-25>*ft,<0,18,25>*ft
			}
			object{
				ChurchRoof rotate y*90
				scale <1/sqrt(2),1,1>*<10,12,50>
				translate <-5,18,0>*ft
			}
		}
		box{
			<-19.5,-1,-14.5>*ft,<19.5,31,14.5>*ft
		}
		box{
			<-9.5,-1,-24.5>*ft,<-0.5,27,24.5>*ft
		}
		object{ChurchDoorCut rotate y*0 translate <-5,0,-25>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <-15,0,-15>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <5,0,-15>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <15,0,-15>*ft}
		object{ChurchDoorCut rotate y*180 translate <-5,0,25>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <-15,0,15>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <5,0,15>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <15,0,15>*ft}
		object{ChurchWindow1Cut rotate y*-90 scale <1,2,1> translate <20,0,0>*ft}
	}
	object{
		ChurchRoof
		scale <1,1,1/sqrt(2)>*<39,17.5,29>
		translate <0,18,0>*ft
		texture{RoofLead}
	}
	object{
		ChurchRoof rotate y*90
		scale <1/sqrt(2),1,1>*<9,11.5,49>
		translate <-5,18,0>*ft
		texture{RoofLead}
	}
	difference{
		union{
			box{
				<-35,0,-10>*ft,<-20,54,10>*ft
			}
			box{
				<-36,48,-11>*ft,<-19,54,11>*ft
			}
		}
		box{
			<-34.5,-1,-9.5>*ft,<-20.5,55,9.5>*ft
		}
	}
	texture{WallStone}
	translate LandFormGet(<-  60*ft,  230*ft,  660*ft>)
}

/*#include "simple3.cst"

object{
  RTDH2(
		0,<0,-90,0>,
		array[4]{1,1,1,1},array[1]{<0,0,0>},array[1]{0},
		<0,0,0>,<0,0,0>,<0,0,0>
	)
	translate <-65, 230.25, 690>*ft
}*/

// Roads and streets
#local RoadStr=10*ft;#local Offset=<5,0,0>*ft;
blob{
  threshold 0.6
	// near the castle
	cylinder{
		LandFormGet(<80,300,1360>*ft)-Offset,LandFormGet(<85,300,960>*ft)-Offset,RoadStr,5*ft
	}
	cylinder{
		LandFormGet(<80,300,1360>*ft),LandFormGet(<90,300,960>*ft),RoadStr,5*ft
	}
	cylinder{
		LandFormGet(<80,300,1360>*ft)+Offset,LandFormGet(<90,300,960>*ft)+Offset,RoadStr,5*ft
	}
	//
	cylinder{
		LandFormGet(<90,300,960>*ft)-Offset,LandFormGet(<0,300,820>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<90,300,960>*ft),LandFormGet(<0,300,820>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<90,300,960>*ft)+Offset,LandFormGet(<0,300,820>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<0,300,820>*ft)-Offset,LandFormGet(<-80,300,760>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<0,300,820>*ft),LandFormGet(<-80,300,760>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<0,300,820>*ft)+Offset,LandFormGet(<-80,300,760>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-80,300,760>*ft)-Offset,LandFormGet(<-240,300,720>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-80,300,760>*ft),LandFormGet(<-240,300,720>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-80,300,760>*ft)+Offset,LandFormGet(<-240,300,720>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-240,300,720>*ft)-Offset,LandFormGet(<-240,300,630>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,720>*ft),LandFormGet(<-240,300,630>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,720>*ft)+Offset,LandFormGet(<-240,300,630>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-240,300,630>*ft)-Offset,LandFormGet(<-240,300,540>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,630>*ft),LandFormGet(<-240,300,540>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,630>*ft)+Offset,LandFormGet(<-240,300,540>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-240,300,540>*ft)-Offset,LandFormGet(<-200,300,360>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,540>*ft),LandFormGet(<-200,300,360>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-240,300,540>*ft)+Offset,LandFormGet(<-200,300,360>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-200,300,360>*ft)-Offset,LandFormGet(<-160,300,80>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-200,300,360>*ft),LandFormGet(<-160,300,80>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-200,300,360>*ft)+Offset,LandFormGet(<-160,300,80>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<-160,300,80>*ft)-Offset,LandFormGet(<0,300,-240>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-160,300,80>*ft),LandFormGet(<0,300,-240>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<-160,300,80>*ft)+Offset,LandFormGet(<0,300,-240>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<0,300,-240>*ft)-Offset,LandFormGet(<160,300,-400>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<0,300,-240>*ft),LandFormGet(<160,300,-400>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<0,300,-240>*ft)+Offset,LandFormGet(<160,300,-400>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<160,300,-400>*ft)-Offset,LandFormGet(<330,300,-560>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<160,300,-400>*ft),LandFormGet(<330,300,-560>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<160,300,-400>*ft)+Offset,LandFormGet(<330,300,-560>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<330,300,-560>*ft)-Offset,LandFormGet(<430,300,-720>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<330,300,-560>*ft),LandFormGet(<430,300,-720>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<330,300,-560>*ft)+Offset,LandFormGet(<430,300,-720>*ft)+Offset,RoadStr,10*ft
	}
	//
	cylinder{
		LandFormGet(<430,300,-720>*ft)-Offset,LandFormGet(<480,300,-880>*ft)-Offset,RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<430,300,-720>*ft),LandFormGet(<480,300,-880>*ft),RoadStr,10*ft
	}
	cylinder{
		LandFormGet(<430,300,-720>*ft)+Offset,LandFormGet(<480,300,-880>*ft)+Offset,RoadStr,10*ft
	}
	texture{RoadTar}
}

/*
*/

// Houses

// Add the details

                                                                                          n   n   >                              bvillage.inc-1093xt12 1999egmlm TEXTMPS                      o  J+   s t        iM
U                            TEXTMPS                                                              H 	Monaco  Buzthe village.\r"   G ~ F } f  /  /  ,     G ~ F }  ,               n   n   >(E    >  MPSR  
           L                                                                                    