 
landforms.mcr   @ 8" D  P&+t   @TEXTMPS  @         oؒS                       s@  // landforms.mcr

#debug "\rlandforms.mcr - macros to build landscapes.\r"

// Define the LandForm variables in the main file - use these samples:
//#declare LandFormMin=<-4080,    0,-4080>*ft;
//#declare LandFormMax=< 1360,   20, 4080>*ft;
//#declare LandFormScl=80*ft;
//#declare LandFormSeed=seed(4457);

// Calculate what's needed:
#declare LandFormXXX=(LandFormMax.x-LandFormMin.x)/LandFormScl;
#declare LandFormZZZ=(LandFormMax.z-LandFormMin.z)/LandFormScl;
// one boolean for every point in the area
#write(DebugFile,"Xsize=",LandFormXXX,", Zsize=",LandFormZZZ,"\n")
#declare LandFormInt=array[1+LandFormXXX][1+LandFormZZZ]
#declare LandFormHgt=array[1+LandFormXXX][1+LandFormZZZ]
#declare LandFormNrm=array[1+LandFormXXX][1+LandFormZZZ]
#local Xc=0;
#while (Xc<=LandFormXXX)
	#local Zc=0;
	#while (Zc<=LandFormZZZ)
		#declare LandFormInt[Xc][Zc]=0;
		#declare LandFormHgt[Xc][Zc]=<0,0,0>;
		#local Zc=Zc+1;
	#end
	#local Xc=Xc+1;
#end
/*
#declare LandForm
*/

// Define the LandForm macros
#macro LandFormSet(CoordHeight)
	#local XValue=floor(0.5+(CoordHeight.x-LandFormMin.x)/LandFormScl);
	#local ZValue=floor(0.5+(CoordHeight.z-LandFormMin.z)/LandFormScl);
	//#write(DebugFile,"XValue=",XValue,", ZValue=",ZValue,"\n")
	#declare LandFormInt[XValue][ZValue]=1;
	#declare LandFormHgt[XValue][ZValue]=CoordHeight;
#end

#macro LandFormGet(Coordinate)
	#local XValue=(Coordinate.x-LandFormMin.x)/LandFormScl;
	#local XValueR=floor(0.5+XValue);
	#local ZValue=(Coordinate.z-LandFormMin.z)/LandFormScl;
	#local ZValueR=floor(0.5+ZValue);
	#if ((XValue=XValueR)&(ZValue=ZValueR)) //It's exactly on a ref. point
		#local YValue=LandFormHgt[XValue][ZValue];
	#else //Average the nearest four - temporarily
		#local YValue=(LandFormHgt[XValue][ZValue]+LandFormHgt[XValue][ZValue+1]+
			LandFormHgt[XValue+1][ZValue]+LandFormHgt[XValue+1][ZValue+1])/4;
	#end
  <Coordinate.x,YValue.y,Coordinate.z>
  //<Coordinate.x,Coordinate.y,Coordinate.z>
#end

#macro LandFormAdjust(CoordHeight,Radius)
	//Find coordinate of centre
	#local XValue=floor(0.5+(CoordHeight.x-LandFormMin.x)/LandFormScl);
	#local ZValue=floor(0.5+(CoordHeight.z-LandFormMin.z)/LandFormScl);
	//#write(DebugFile,"XValue=",XValue,", ZValue=",ZValue,"\n")
	#local Direction=CoordHeight.y-LandFormHgt[XValue][ZValue].y;
	#if (Direction=0) //There's nothing to do, stop now.
		#debug "\rNo change in LandFormAdjust\r"
		#write(DebugFile,"\nNo change: LandFormAdjust(",CoordHeight,",",Radius,")\n")
	#else
		#local YY=1;//raise each layer recursively
		#while (YY<=Radius)
			#local ZZ=ZValue-Radius+YY;
			#while (ZZ<=ZValue+Radius-YY)
				#local XX=XValue-Radius+YY;
				#while (XX<=XValue+Radius-YY)
					#write(DebugFile,"\nAdjust: (",XX,",",ZZ,") -> ",YY)
					#local NewHeight=Direction/(Radius+1)*(0.5+rand(LandFormSeed))*YY;
					#if ((XX>=0)&(XX<=LandFormXXX)&(ZZ>=0)&(ZZ<=LandFormZZZ))
						#declare LandFormInt[XX][ZZ]=1;
						#if (Direction>0)
							#declare LandFormHgt[XX][ZZ]=LandFormHgt[XX][ZZ]+max(0,NewHeight);
						#else
							#declare LandFormHgt[XX][ZZ]=LandFormHgt[XX][ZZ]+min(0,NewHeight);
						#end
					#end
					#local XX=XX+1;
				#end
				#local ZZ=ZZ+1;
			#end
			#local YY=YY+1;
		#end
	#end
#end

/* Write out a file of LandFormSet values as the basis for editing.
  Filename: To be created; any existing file of this name will be overwritten.
	Minxz:    vector <least X value,ignored,least Z value> (will be multiplied by ft)
	Maxxz:    vector <biggest X value,standard Y value,biggest Z value> (will be multiplied by ft)
// Used:
	LandFormScl: Spacing between points.
*/
#macro LandFormBlockWrite(Filename,Minxz,Maxxz)
	#local Minx=Minxz.x;#local Minz=Minxz.z;
	#local Maxx=Maxxz.x;#local YY=Maxxz.y;#local Maxz=Maxxz.z;
	#local Inc=LandFormScl/ft;
  #fopen LandFormFile Filename write
	// Header
	#write(LandFormFile,"// ",Filename,"\n\n#debug \"\\r",Filename," - Build ? for the village.\\r\"\n\n")
	#write(LandFormFile,"// N-S scale: position ?; E-W scale: position ?.\n")
	#write(LandFormFile,"// <",Minx,",    ?,",Minz,">*ft to <",Maxx,",    ?,",Maxz,">*ft\n\n//\n")
	// Body of file
	#local ZZ=Minz;
	#while (ZZ<=Maxz)
		#local XX=Minx;
		#while (XX<=Maxx)
			#write(LandFormFile,"LandFormSet(<",str(XX,6,0),",",str(YY,6,0),",",str(ZZ,6,0),">*ft)\n")
			#local XX=XX+Inc;
		#end
		#write(LandFormFile,"//\n")
		#local ZZ=ZZ+Inc;
	#end
	#fclose LandFormFile
#end


/*
	Dstyle: Drawing style: 0 height points, 1 lines only, 2 triangle, 3 smooth_triangle
*/
#macro LandFormDraw(Dstyle)
	#if (Dstyle=0)
		#local Xc=0;
		#while (Xc<=LandFormXXX)
			#local Zc=0;
			#while (Zc<=LandFormZZZ)
				#if (LandFormInt[Xc][Zc]=1)
					cylinder{
						LandFormHgt[Xc][Zc]*<1,0,1>-<0,10,0>,LandFormHgt[Xc][Zc],5*yd
						texture{Ground}
					}
				#else
					cylinder{
						<Xc*LandFormScl,0,Zc*LandFormScl>,<Xc*LandFormScl,500*ft,Zc*LandFormScl>,5*yd
						texture{pigment{colour rgb <1,.25,.25>}}
					}
				#end
				#local Zc=Zc+1;
			#end
			#local Xc=Xc+1;
		#end
	#end
	#local Xc=0;
	#while (Xc<LandFormXXX)
		#local Zc=0;
		#while (Zc<LandFormZZZ)
		  #if ((LandFormInt[Xc][Zc]=1)&(LandFormInt[Xc][Zc+1]=1)&(LandFormInt[Xc+1][Zc]=1)&(LandFormInt[Xc+1][Zc+1]=1))
				#if (Dstyle=1)
					cylinder{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc][Zc+1],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc+1][Zc],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc+1],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc+1][Zc],LandFormHgt[Xc+1][Zc+1],1*yd
						texture{Ground}
					}
				#end
				#if (Dstyle=2)
					triangle{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc]
						texture{Ground}
					}
					triangle{
						LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc],LandFormHgt[Xc+1][Zc+1]
						texture{Ground}
					}
				#end
				#if (Dstyle=3)
					smooth_triangle{
						LandFormHgt[Xc][Zc],LandFormNrm[Xc][Zc],
						LandFormHgt[Xc][Zc+1],LandFormNrm[Xc][Zc+1],
						LandFormHgt[Xc+1][Zc],LandFormNrm[Xc+1][Zc]
						texture{Ground}
					}
					smooth_triangle{
						LandFormHgt[Xc][Zc+1],LandFormNrm[Xc][Zc+1],
						LandFormHgt[Xc+1][Zc],LandFormNrm[Xc+1][Zc],
						LandFormHgt[Xc+1][Zc+1],LandFormNrm[Xc+1][Zc+1]
						texture{Ground}
					}
				#end
			#end
			#local Zc=Zc+1;
		#end
		#local Xc=Xc+1;
	#end
#end

// This assumes all points exist, and doesn't check.
#macro LandFormNormalise()
	#local Xc=1;
	#while (Xc<=LandFormXXX-1)
		#local Zc=1;
		#while (Zc<=LandFormZZZ-1)
			#declare LandFormNrm[Xc][Zc]=vcross(
				(LandFormHgt[Xc+1][Zc+1]-LandFormHgt[Xc-1][Zc-1]),
				(LandFormHgt[Xc-1][Zc+1]-LandFormHgt[Xc+1][Zc-1])
			);
			#local Zc=Zc+1;
		#end
		#local Xc=Xc+1;
	#end
	//patch the edges - copy the adjacent normals over.
	#local Xc=1;
	#while (Xc<=LandFormXXX-1)
		#declare LandFormNrm[Xc][0]=LandFormNrm[Xc][1];
		#declare LandFormNrm[Xc][LandFormZZZ]=LandFormNrm[Xc][LandFormZZZ-1];
		#local Xc=Xc+1;
	#end
	#local Zc=1;
	#while (Zc<=LandFormZZZ-1)
		#declare LandFormNrm[0][Zc]=LandFormNrm[1][Zc];
		#declare LandFormNrm[LandFormXXX][Zc]=LandFormNrm[LandFormXXX-1][Zc];
		#local Zc=Zc+1;
	#end
	//patch the corners
		#declare LandFormNrm[0][0]=(LandFormNrm[1][0]+LandFormNrm[0][1])/2;
		#declare LandFormNrm[LandFormXXX][0]=(LandFormNrm[LandFormXXX-1][0]+LandFormNrm[0][1])/2;
		#declare LandFormNrm[0][LandFormZZZ]=(LandFormNrm[1][LandFormZZZ]+LandFormNrm[0][LandFormZZZ-1])/2;
		#declare LandFormNrm[LandFormXXX][LandFormZZZ]=(LandFormNrm[LandFormXXX-1][LandFormZZZ]+LandFormNrm[LandFormXXX][LandFormZZZ-1])/2;
#end

#debug "\r----\rEnd of landscape building\r----\r"
                                                                 n   n   >                              
landforms.mcr-413xt12 1999obsom TEXTMPS  9 B                  o     s t        iM
U                            TEXTMPS                                                              H 	Monaco  Buthe village.\r"    0L H ؒS  [  [        0L H                  n   n   >DN    >  MPSR  
           L<                                                                                    