 pdmruinc.pov* M@ 8" +t   @TEXTPOV3        $  !l                       P  // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/* Without anti-aliasing:
Time For Parse:    0 hours  0 minutes  59.0 seconds (59 seconds)
Time For Trace:    0 hours 23 minutes  44.0 seconds (1424 seconds)
    Total Time:    0 hours 24 minutes  43.0 seconds (1483 seconds)
   With anti-aliasing:
About 50 minutes (I forgot to check)
   Using Megapov without anti-aliasing:
Time For Parse:    0 hours  0 minutes  49.0 seconds (49 seconds)
Time For Trace:    0 hours 19 minutes  49.0 seconds (1189 seconds)
    Total Time:    0 hours 20 minutes  38.0 seconds (1238 seconds)
*/

// Units
#declare in = 1;// Redefine only this to change scale.
#declare ft = 12*in;
#declare yd = 36*in;
#declare mi = 5280*ft;

#fopen DebugFile "bvillage.debug" write

// Define some variables which will later control the village
#declare Year=2000;#declare Month=2;#declare Day=26;

#declare Toning=0;
#macro ColourTone(AColour)
  #switch (Toning)
    #case (0)//no change
      rgb AColour
    #break
    #case (1)//greyscale <0.8, 1.3, 0.9>
      #local Temp=(0.8*AColour.red+1.3*AColour.green+0.9*AColour.blue)/3;
      rgb <Temp,Temp,Temp>
    #break
    #case (2)//sepia
      #local Temp=(0.8*AColour.red+1.3*AColour.green+0.9*AColour.blue);
      rgb <Temp,Temp,Temp>*<0.5,0.4,0.1>
    #break
    #case (3)//old b&w film <0.3, 1.8, 0.9>
      #local Temp=(0.3*AColour.red+1.8*AColour.green+0.9*AColour.blue)/3;
      rgb <Temp,Temp,Temp>
    #break
    #case (4)//pastel
      //#local Min=min(min(AColour.red,AColour.green),AColour.blue);
      //#local Max=max(max(AColour.red,AColour.green),AColour.blue);
      #local Temp=1-((1-AColour)/2);
      rgb Temp
    #break
    #case (5)//old version of pastel
      //#local Min=min(min(AColour.red,AColour.green),AColour.blue);
      #local Max=max(max(AColour.red,AColour.green),AColour.blue);
      #local Temp=Max+(AColour-Max)/2;
      rgb Temp
    #break
    #else
      rgb AColour
  #end
#end

//background{colour ColourTone(<.55,.55,.75>)}
sky_sphere {
  pigment {
    gradient y
    colour_map {
      [0.500 colour rgb <0.75, 0.75, 1.0>]
      [1.000 colour rgb <0.0, 0.0, 0.6>]
    }
    scale 2
    translate -1
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.8
    lambda 2
    colour_map {
      [0.0 0.1 colour rgb <0.88, 0.88, 0.93>
               colour rgb <0.90, 0.90, 0.90>]
      [0.1 0.3 colour rgb <0.90, 0.90, 0.90>
               colour rgbt <1, 1, 1, 1>]
      [0.3 1.0 colour rgbt <1, 1, 1, 1>
               colour rgbt <1, 1, 1, 1>]
    }
    scale <0.2, 0.5, 0.2>
    rotate 80*z
    rotate y*57
  }
}

#declare Detailed=1;
#declare DetailTx=0;

// Textures
#declare ChimneyMaterial=
texture{
  pigment{
    marble
    colour_map{
      [0.0 {colour ColourTone(< 0.56, 0.14, 0.14>)]
	  [0.8 {colour ColourTone(< 0.49, 0.21, 0.21>)]
      [0.9 {colour ColourTone(< 0.49, 0.14, 0.14>)]
      [1.0 {colour ColourTone(< 0.49, 0.28, 0.28>)]
	}
    turbulence 2.3
  }
  normal{
    dents 0.4 scale .25*in
  }
  finish{
    roughness 0.40 ambient 0.25 diffuse 0.33 reflection 0.05
  }
}

#declare Curtain=
texture{
  pigment{
    colour ColourTone(<.85,.9,.9>*1.2)
  }
  normal{
    gradient x+z,in sine_wave
  }
  finish{
    roughness 0.2
  }
}

#declare DoorWood=
texture{
  pigment{
    wood
    turbulence 0.3
    colour_map{
      [0.0, 0.8 colour ColourTone(<0.50, 0.35, 0.18>)
                colour ColourTone(<0.50, 0.35, 0.18>)]
      [0.8, 1.0 colour ColourTone(<0.33, 0.14, 0.05>)
                colour ColourTone(<0.16, 0.07, 0.02>)]
    }
  }
  normal{
    dents .4 scale .1*in
  }
  finish{
    roughness 0.20 ambient 0.25 diffuse 0.33 reflection 0.05
  }
}

#declare Ground=
texture{
  pigment{
    gradient y turbulence 0.8 octaves 4 scale 3
    colour_map{
      [0.00 colour ColourTone(<0.40,0.60,0.40>)]
      [0.75 colour ColourTone(<0.40,0.70,0.40>)]
      [0.75 colour ColourTone(<0.40,0.80,0.40>)]
      [1.00 colour ColourTone(<0.40,0.90,0.40>)]
    }
    scale <1,200*ft,1>
  }
  normal{
    wrinkles .4 scale 3*in
  }
  finish{ 
    ambient 0.20 diffuse 0.40
  }
}

#declare Lawn=
texture{
  pigment{
    colour ColourTone(<.3,.8,.5>)
  }
  normal{
    bumps 4*in scale <0.1,1,0.1> frequency 3
    turbulence 1  omega .4  lambda .5 octaves 3
  }
}

#declare PicketTex=
texture{
  pigment{
    gradient x+z
	colour_map{
      [0.00 colour ColourTone(< 1, 1, 1>) transmit 1]
      [0.60 colour ColourTone(< 1, 1, 1>) transmit 1]
      [0.61 colour ColourTone(<.8,.8,.8>) transmit 0]
      [1.00 colour ColourTone(<.8,.8,.8>) transmit 0]
	}
	scale 6*in
  }
  finish {
    roughness 0.2
  }
}
/*
texture{
  pigment{
    gradient y
	colour_map{
      [0.00 colour ColourTone(< 1, 1, 1>) transmit 1]
      [0.69 colour ColourTone(< 1, 1, 1>) transmit 1]
      [0.80 colour ColourTone(<.8,.8,.8>) transmit 0]
      [1.00 colour ColourTone(<.8,.8,.8>) transmit 0]
	}
	scale <1,2*ft,1>
  }
  finish {
    roughness 0.2
  }
}
*/

#declare RoadTar=
texture{
  pigment{
    colour ColourTone(<.15,.15,.15>)
  }
  normal{
    bumps 1*in frequency 3
    turbulence 1  omega .4  lambda .5 octaves 3
  }
}

#declare Roof=
texture{
  #if (DetailTx)
    pigment{
      brick colour ColourTone(< 0.15, 0.15, 0.15>),
      colour ColourTone(< 0.30, 0.15, 0.05>*1.5)
      brick_size <3.8*in,5.8*in,10*ft> mortar 0.5*in
    }
  #else
    pigment{
      colour ColourTone(< 0.30, 0.15, 0.05>*1.5)
    }
  #end
}

#declare RoofLead=
texture{
  #if (DetailTx)
    pigment{
      brick colour ColourTone(< 0.10, 0.10, 0.10>),
      colour ColourTone(< 0.30, 0.30, 0.30>)
      brick_size <3.8*in,5.8*in,10*ft> mortar 0.5*in
    }
  #else
    pigment{
      colour ColourTone(< 0.30, 0.30, 0.30>)
    }
  #end
  finish{Metal}
}

#declare Sketched=
texture{
  pigment{
    colour ColourTone(<.85,.3,.3>) filter .9
  }
}

#declare Sketch2=
texture{
  pigment{
    colour ColourTone(<1.5,0,0>) filter .9
  }
}

#declare Stream=
texture{
  pigment{
    colour ColourTone(<.7,.7,.8>) filter .9
  }
  finish{
    reflection 0.3
  }
  normal{
    waves .2 frequency 20
    turbulence 1  omega .8  lambda 1.5 octaves 3
    scale .1  translate <0,0,-50>
  }
}

#declare WallStone=
texture{
  pigment{
    brick colour rgb < 0.2, 0.2, 0.2>, colour ColourTone(<.92,.80,.40>)
    brick_size <2*ft,2*ft,2*ft> mortar .25*in
  }
  /*normal{
    bumps .1 scale <0.125,1,0.125> frequency 3
    turbulence 1 omega .4 lambda .5 octaves 3
  }*/
  rotate y*45
}

/*texture{
  pigment{
    wrinkles turbulence 0.8 octaves 4 scale 3
    colour_map{
      [0.00 colour ColourTone(<.80,.92,.40>)]
      [0.75 colour ColourTone(<.92,.80,.40>)]
      [0.75 colour ColourTone(<.80,.80,.40>)]
      [1.00 colour ColourTone(<.80,.80,.50>)]
    }
  }
  normal{
    wrinkles .4 scale 1*in
  }
  finish{ 
    ambient 0.20 diffuse 0.40
  }
}*/

//#declare LookAt    = <-880.0, 1.000, 880.0>*yd;//overview (LL)
//#declare LookAt    = < 0.000, 1.000, 880.0>*yd;//overview (LM)
//#declare LookAt    = < 880.0, 1.000, 880.0>*yd;//overview (LN)
//#declare LookAt    = <-880.0, 1.000, 0.000>*yd;//overview (ML)
//#declare LookAt    = <-440.0, 1.000, 0.000>*yd;//overview (ML-MM)
//#declare LookAt    = < 0.000, 1.000, 440.0>*yd;//overview (LM-MM)
//#declare LookAt    = < 0.000, 1.000, 0.000>*yd;//overview (MM)
//#declare LookAt    = < 880.0, 1.000, 0.000>*yd;//overview (MN)
//#declare LookAt    = <-880.0, 1.000,-880.0>*yd;//overview (NL)
//#declare LookAt    = < 0.000, 1.000,-880.0>*yd;//overview (NM)
//#declare LookAt    = < 880.0, 1.000,-880.0>*yd;//overview (NN)
//#declare ViewPoint = < 0.000, 15.0,-50.0>*yd;
//#declare ViewPoint = < 0.000, 100.0,-200.0>*yd *<1,2,1>;
//#declare ViewPoint = < 0.000, 375.0,-750.0>*yd;
//#declare ViewPoint = < 0.000, 375.0,-750.0>*yd*1.25;
//#declare LookAt    = <-120,320,1000>*ft;//castle
//#declare LookAt    = <-60,230,660>*ft;//church
//#declare ViewPoint = LookAt+<120,80,-125>*ft;//from the air
//#declare ViewPoint = <20,330,1000>*ft;//castle front
//#declare ViewPoint = <-20,330,1000>*ft;//castle gate
#declare LookAt    = <-120,320,950>*ft;//--image
#declare ViewPoint = <-40,330,1030>*ft;//--image
//#declare ViewPoint = LookAt+<0,180,0>*ft;//plan
//#declare ViewPoint = LookAt+< 0.000, 375.0,-750.0>*yd*<1,2,1>;//view -Z
//#declare ViewPoint = LookAt+< 0.000, 200.0,-400.0>*yd*<1,2,1>;//closer -Z
//#declare ViewPoint = LookAt+< 0.000, 375.0, 750.0>*yd*<1,1,1>;//view Z
//#declare ViewPoint = LookAt+<-750.0, 375.0, 0.000>*yd*<1,1,1>;//view -X
//#declare ViewPoint = LookAt+<-400.0, 200.0, 0.000>*yd*<1,1,1>;//closer -X
//#declare ViewPoint = LookAt+< 750.0, 375.0, 0.000>*yd*<1,1,1>;//view X
//#declare ViewPoint = LookAt+< 400.0, 200.0, 0.000>*yd*<1,1,1>;//closer X

camera {
  location  ViewPoint // position of camera <X Y Z>
  look_at   LookAt // point center of view at this point <X Y Z>
}

// Files should define SamplerName and SamplerBBox[2]
//#include "unbtex.inc"
#include "rhouse.mcr"
#include "bvillage.inc"


/*
#local HouseN=-3;
#while (HouseN<3)
  object{
    RHouse(
      <HouseN*45,0,0>*ft,<0,0,0>,
      <37*ft,2,50*ft>,<45*ft,1*ft,120*ft>,<4*ft,0,20*ft>,
      2,WallStone,ChimneyMaterial,DoorWood,Roof,Lawn,PicketTex,WallStone
    )
  }
  #local HouseN=HouseN+1;
#end
*/

/*
light_source {
  ViewPoint
  colour rgb <1,1,1>*.25
}
*/

light_source {
  <1000,1000,-1000>*yd
  colour rgb <1,1,1>
}

light_source {
  <-250,400,1500>*yd
  colour rgb .4
  shadowless
}

#fclose DebugFile
                        l  l     Icon
           @         pdmruinc.pov2vcttc 12 1999egmlm TEXTPOV3                    l  $  !  
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         P  P   H 	Monaco 
 !E             
   < $@ < $@l           < $@ < $@                6           G'kar                      BD    @obvillage.inc                                                     PoTEXTMPS                    avillage    @o    <`  <  @G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:bvillage.inc            G'kar                      BD    </
colors.inc                                                       <6jTEXTR*ch                   Include     </  <  %G'kar:POV-Ray 3.1g:Include:colors.inc             G'kar                      BD    </
finish.inc                                                       <;hTEXTR*ch                   Include     </  <  %G'kar:POV-Ray 3.1g:Include:finish.inc                G'kar                      BD    @o
landforms.mcr                                                    OooTEXTMPS                    avillage    @o    <`  <  AG'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:landforms.mcr    }          G'kar                      BD    @o
rhouse.mcr                                                       @qlTEXTMPS                    avillage    @o    <`  <  >G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:rhouse.mcr               G'kar                      BD    @o	rtdhc.inc                                                        PܯlTEXTMPS                    avillage    @o    <`  <  =G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:rtdhc.inc                G'kar                      BD    @osimple1.cst                                                      PݯlTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:simple1.cst   la |        G'kar                      BD    @osimple2.cst                                                      PޯlTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:simple2.cst      |        G'kar                      BD    @osimple3.cst                                                      P߯lTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:simple3.cst      z        G'kar                      BD    </textures.inc                                                     <ZǾTEXTNPOV                   Include     </  <  'G'kar:POV-Ray 3.1g:Include:textures.inc      zp        G'kar                      BD    @o
unbtex.inc                                                       @vITEXTMPS                    avillage    @o    <`  <  >G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:unbtex.inc            G'kar                      BD    @ovill_ll.inc                                                      I޴eTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_ll.inc   ve V        G'kar                      BD    @ovill_lm.inc                                                      IFTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_lm.inc   MP V         G'kar                      BD    @ovill_ml.inc                                                      IfTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_ml.inc      U        G'kar                      BD    @ovill_mm.inc                                                      OboTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_mm.inc      U        G'kar                      BD    @ovill_nl.inc                                                      Ih/TEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_nl.inc      T0        G'kar                      BD    @ovill_nm.inc                                                      IӴTEXTMPS                    avillage    @o    <`  <  ?G'kar:POV-Ray 3.1g:PPC Application:POVwork:avillage:vill_nm.inc    A f@         
 
    
         $  6 , 7                          X   M#ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  =   b      d     F       l  l    E     MPSR  2SELc   JNwPM   Vstyl   bNwPo   nFPRF   z          X               z      b       |    6     POV-Ray File Prefs                                                                                               