 	rtdhc.inc      @ 8" D  P&+t(   @TEXTMPS         F  l                       q  // Persistence Of Vision INCLUDE file
// File:        rtdhc.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Simplified humans that can wear clothes
// Uses:		.cst costume files
// Auth:        Peter Murray

#debug "\r  rtdhc.inc - define Render Test Dummy - Human, costumable\r"

/*
Macros:
  (all figures share the basic textures)
        ("HFlesh" = skin)
  RTDH1 Spacestation personnel uniform
        ("Uniform" = jacket, "Uniform2" = trousers, "UniformF" = shoes/belt)
  RTDH2 Costumable
*/

// Measurements might already be defined.
#ifndef(in)
  #declare in = 1;
  #declare ft = 12;
#end

#declare HFlesh=
texture{
  pigment{
    colour rgb <.97,.82,.75>//<.76,.58,.45>
  }
}

#declare HEyes=
texture{
  pigment{colour rgb<.9,.9,.9>}
}

/*#declare JacketTorso=
union{
	difference{//collar
	  cone{// clothing
		<0,13*in,0>,2.5*in,<0,15*in,0>,2.25*in
	  }
	  box{
		<-.5,12.5,-3.5>*in,<.5,15.5,-2>*in
	  }
	}
	cone{// clothing
	  <0,11*in,0>,5.25*in,<0,14.1*in,0>,2.25*in
	}
	cone{// clothing
	  <0,7*in,0>,5.75*in,<0,11*in,0>,5.25*in
	}
	cone{// clothing
	  <0,0,0>,5.25*in,<0,7*in,0>,5.75*in
	}
    texture{Uniform}
}
*/

// To be replaced later by a macro
#declare RHand=
sphere{
  <0,-1,0>*in,1*in
  scale <1.25,2.5,1.75>
}
//box{<-1.25*in,0,-1.75*in>,<1.25*in,-5*in,1.75*in>}

#declare LHand=
sphere{
  <0,-1,0>*in,1*in
  scale <1.25,2.5,1.75>
}
//box{<-1.25*in,0,-1.75*in>,<1.25*in,-5*in,1.75*in>}

/*
  Parameters for all macros:
    plocn:  Origin of dummy in scene (groundlevel, between feet)
	prtn:   Rotation of whole figure
	psize:  Array of size data
	        ...more information...
	prtns:  Array[9] of rotation data
	        0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
			5 right u leg 6 right l leg 7 left u leg 8 left l leg
	pclths: Array of clothing data
	        ...more information...
	prhead: Rotation of head relative to torso
	prtorso:Rotation of torso about waist
	prhips: Rotation of hips about waist
*/

#macro RTDH0 (plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips)
  object{
    #local Waist=<0,3*ft+5*in,0>;
    union{
	  // Head
	  union{
	    // Neck
		cylinder{
		  <0,0,0>,<0,3,0>,2*in
		  scale <1,1,.5>
		}
	    // Outline
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,8,6>
		  translate <0,5*in,-1*in>
		}
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,7,8>
		  translate <0,5.5*in,0>
		}
		// Eyes
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <-2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		// Nose
		cone{
		  <0,0,0>*in,0,<0,-1.5,-0.3>*in,0.5*in
		  scale <1.5,1,1>
		  translate <0,5,-4>*in
		}
		rotate prhead+prtorso
		translate Waist+(vrotate(<0,1*ft+2*in,0>,prtorso))
	  }
	  // Torso
      union{
	    cone{
		  <0,11*in,0>,5*in,<0,14*in,0>,2*in
		}
	    cone{
		  <0,7*in,0>,5.5*in,<0,11*in,0>,5*in
		}
	    cone{
		  <0,0,0>,5*in,<0,7*in,0>,5.5*in
		}
		// Upper shoulders
		cone{
		  <0,10*in,0>,8*in,<0,11*in,0>,5*in
		  scale <1,1,.5>
		  #local Rshld=vrotate(<-7*in,10*in,0>,prtorso);
		  #local Lshld=vrotate(<7*in,10*in,0>,prtorso);
		}
		scale <1,1,.5>
		rotate prtorso
		translate Waist
	  }
	  // Right arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate <-15,0,0>+prtorso
		  translate Rshld+Waist
		  #local Relbw=Rshld+vrotate(<0,-9.5*in,0>,<-15,0,0>+prtorso);
		}
		sphere{
		  <0,0,0>,1*in
		  rotate <-10,0,0>+prtorso
		  translate Rshld+Waist
		}
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate <15,0,0>+prtorso
		  translate Relbw+Waist
		  #local Rwrst=Relbw+vrotate(<0,-9.5*in,0>,<15,0,0>+prtorso);
		}
		object{
		  RHand
		  rotate <10,0,0>
		  translate Rwrst+Waist
		}
	  }
	  // Left arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate <-10,0,0>+prtorso
		  translate Lshld+Waist
		  #local Lelbw=Lshld+vrotate(<0,-9.5*in,0>,<-10,0,0>+prtorso);
		}
		sphere{
		  <0,0,0>,1*in
		  rotate <-10,0,0>+prtorso
		  translate Lshld+Waist
		}
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate <15,0,0>+prtorso
		  translate Lelbw+Waist
		  #local Lwrst=Lelbw+vrotate(<0,-9.5*in,0>,<15,0,0>+prtorso);
		}
		object{
		  LHand
		  rotate <10,0,0>
		  translate Lwrst+Waist
		}
	  }
	  // Hips
	  difference{
		cone{
		  <0,0.1,0>,5*in,<0,-8*in,0>,6*in
		  scale <1,1,.5>
		  rotate prhips
		  translate Waist
		  #local Rhip=vrotate(<-3*in,-8*in,0>,prhips);
		  #local Lhip=vrotate(<3*in,-8*in,0>,prhips);
		}
		sphere{//navel :-)
		  <0,-1,-5.125*0.5>*in,.25*in
		  scale <1,1,1>
		}
	  }
	  // Right leg
	  union{
	    sphere{
		  <0.4,0,0.35*in>,3.1*in
		  translate Rhip+Waist
		}
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate <10,0,0>
		  translate Rhip+Waist
		  #local Rknee=Rhip+vrotate(<0,-14*in,0>,<10,0,0>);
		}
	    sphere{
		  <0,0,0>,1.5*in
		  translate Rknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate <0,0,0>
		  translate Rknee+Waist
		  #local Rankl=Rknee+vrotate(<0,-16*in,0>,<0,0,0>);
		}
		object{
		  box{
            <-2*in,0,1.5*in>,<2*in,-3*in,-6*in>
          }
		  rotate <0,0,0>
		  translate Rankl+Waist
		}
	  }
	  // Left leg
	  union{
	    sphere{
		  <-0.4,0,0.35*in>,3.1*in
		  translate Lhip+Waist
		}
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate <0,0,0>
		  translate Lhip+Waist
		  #local Lknee=Lhip+vrotate(<0,-14*in,0>,<0,0,0>);
		}
	    sphere{
		  <0,0,0>,1.5*in
		  translate Rknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate <-10,0,0>
		  translate Lknee+Waist
		  #local Lankl=Lknee+vrotate(<0,-16*in,0>,<-10,0,0>);
		}
		object{
		  box{
            <-2*in,0,1.5*in>,<2*in,-3*in,-6*in>
          }
		  rotate <0,0,0>
		  translate Lankl+Waist
		}
	  }
	  texture{HFlesh}
    }//-union
	rotate prtn
	translate plocn
  }//-object RTDH0
#end

#macro RTDH1 (plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips)
  object{
    #local Waist=<0,3*ft+5*in,0>;
    union{
	  // Head
	  union{
	    // Neck
		cylinder{
		  <0,0,0>,<0,3,0>,2*in
		  scale <1,1,.5>
		}
	    // Outline
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,8,6>
		  translate <0,5*in,-1*in>
		}
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,7,8>
		  translate <0,5.5*in,0>
		}
		// Eyes
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <-2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		// Nose
		cone{
		  <0,0,0>*in,0,<0,-1.5,-0.3>*in,0.5*in
		  scale <1.5,1,1>
		  translate <0,5,-4>*in
		}
		rotate prhead+prtorso
		translate Waist+(vrotate(<0,1*ft+2*in,0>,prtorso))
	  }
	  // Torso
      union{
	    cone{
		  <0,11*in,0>,5*in,<0,14*in,0>,2*in
		}
	    cone{
		  <0,7*in,0>,5.5*in,<0,11*in,0>,5*in
		}
	    cone{
		  <0,0,0>,5*in,<0,7*in,0>,5.5*in
		}
	  	#ifdef (TorsoClothing)
			object{TorsoClothing}
		#end
		// Upper shoulders
		cone{
		  <0,10*in,0>,8*in,<0,11*in,0>,5*in
		  scale <1,1,.25>
		  #local Rshld=vrotate(<-7*in,10*in,0>,prtorso);
		  #local Lshld=vrotate(<7*in,10*in,0>,prtorso);
		}
		cone{// clothing
		  <0,10*in,0>,8.5*in,<0,12.5*in,0>,5.5*in
		  texture{Uniform}
		  scale <1,1,.25>
		}
		scale <1,1,.5>
		rotate prtorso
		translate Waist
	  }
	  // Right arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate <-15,0,0>+prtorso
		  translate Rshld+Waist
		  #local Relbw=Rshld+vrotate(<0,-9.5*in,0>,<-15,0,0>+prtorso);
		}
		sphere{// clothing
		  <0,0,0>,1.25*in
		  texture{Uniform}
		  rotate <-15,0,0>+prtorso
		  translate Rshld+Waist
		}
	    cone{// clothing
		  <0,0,0>,1.25*in,<0,-9.5*in,0>,1.25*in
		  texture{Uniform}
		  rotate <-15,0,0>+prtorso
		  translate Rshld+Waist
		}
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate <15,0,0>+prtorso
		  translate Relbw+Waist
		  #local Rwrst=Relbw+vrotate(<0,-9.5*in,0>,<15,0,0>+prtorso);
		}
		sphere{// clothing
		  <0,0,0>,1.25*in
		  texture{Uniform}
		  rotate <15,0,0>+prtorso
		  translate Relbw+Waist
		}
	    cone{// clothing
		  <0,0,0>,1.25*in,<0,-8.5*in,0>,1.5*in
		  texture{Uniform}
		  rotate <15,0,0>+prtorso
		  translate Relbw+Waist
		}
		object{
		  RHand
		  rotate <10,0,0>
		  translate Rwrst+Waist
		}
	  }
	  // Left arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate <-10,0,0>+prtorso
		  translate Lshld+Waist
		  #local Lelbw=Lshld+vrotate(<0,-9.5*in,0>,<-10,0,0>+prtorso);
		}
		sphere{// clothing
		  <0,0,0>,1.25*in
		  texture{Uniform}
		  rotate <-10,0,0>+prtorso
		  translate Lshld+Waist
		}
	    cone{// clothing
		  <0,0,0>,1.25*in,<0,-9.5*in,0>,1.25*in
		  texture{Uniform}
		  rotate <-10,0,0>+prtorso
		  translate Lshld+Waist
		}
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate <15,0,0>+prtorso
		  translate Lelbw+Waist
		  #local Lwrst=Lelbw+vrotate(<0,-9.5*in,0>,<15,0,0>+prtorso);
		}
		sphere{// clothing
		  <0,0,0>,1.25*in
		  texture{Uniform}
		  rotate <15,0,0>+prtorso
		  translate Lelbw+Waist
		}
	    cone{// clothing
		  <0,0,0>,1.25*in,<0,-8.5*in,0>,1.5*in
		  texture{Uniform}
		  rotate <15,0,0>+prtorso
		  translate Lelbw+Waist
		}
		object{
		  LHand
		  rotate <10,0,0>
		  translate Lwrst+Waist
		}
	  }
	  // Hips
	  cone{
        <0,0,0>,5*in,<0,-8*in,0>,6*in
		scale <1,1,.5>
		rotate prhips
		translate Waist
		#local Rhip=vrotate(<-3*in,-8*in,0>,prhips);
		#local Lhip=vrotate(<3*in,-8*in,0>,prhips);
	  }
	  cone{// clothing - belt
        <0,0,0>,5.25*in,<0,-1*in,0.0625>,5.5*in
		texture{UniformF}
		scale <1,1,.5>
		rotate prhips
		translate Waist
	  }
	  cone{// clothing
        <0,0,0>,5.25*in,<0,-8*in,0.5*in>,7*in
		texture{Uniform2}
		scale <1,1,.5>
		rotate prhips
		translate Waist
	  }
	  // Right leg
	  union{
	    sphere{
		  <0,0,0.25*in>,2.9*in
		  translate Rhip+Waist
		}
	    sphere{// clothing
		  <0,0,0.25*in>,3.1*in
		  texture{Uniform2}
		  translate Rhip+Waist
		}
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate <10,0,0>
		  translate Rhip+Waist
		  #local Rknee=Rhip+vrotate(<0,-14*in,0>,<10,0,0>);
		}
	    cone{// clothing
		  <0,0,0>,3.25*in,<0,-14*in,0>,2*in
		  texture{Uniform2}
		  rotate <10,0,0>
		  translate Rhip+Waist
		}
	    sphere{
		  <0,0,0>,1.5*in
		  translate Rknee+Waist
		}
	    sphere{// clothing
		  <0,0,0>,2*in
		  texture{Uniform2}
		  translate Rknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate <0,0,0>
		  translate Rknee+Waist
		  #local Rankl=Rknee+vrotate(<0,-16*in,0>,<0,0,0>);
		}
	    cone{// clothing
		  <0,0,0>,2*in,<0,-14*in,0>,2.25*in
		  texture{Uniform2}
		  rotate <0,0,0>
		  translate Rknee+Waist
		}
		object{
		  box{
            <-2*in,0,1.5*in>,<2*in,-3*in,-6*in>
          }
		  rotate <0,0,0>
		  translate Rankl+Waist
		}
		object{// clothing
		  box{
            <-2.1*in,0.1*in,1.6*in>,<2.1*in,-3.1*in,-6.1*in>
          }
		  texture{UniformF}
		  rotate <0,0,0>
		  translate Rankl+Waist
		}
	  }
	  // Left leg
	  union{
	    sphere{
		  <0,0,0.25*in>,2.9*in
		  translate Lhip+Waist
		}
	    sphere{// clothing
		  <0,0,0.25*in>,3.1*in
		  texture{Uniform2}
		  translate Lhip+Waist
		}
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate <0,0,0>
		  translate Lhip+Waist
		  #local Lknee=Lhip+vrotate(<0,-14*in,0>,<0,0,0>);
		}
	    cone{// clothing
		  <0,0,0>,3.25*in,<0,-14*in,0>,2*in
		  texture{Uniform2}
		  rotate <0,0,0>
		  translate Lhip+Waist
		}
	    sphere{
		  <0,0,0>,1.5*in
		  translate Rknee+Waist
		}
	    sphere{// clothing
		  <0,0,0>,2*in
		  texture{Uniform2}
		  translate Rknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate <-10,0,0>
		  translate Lknee+Waist
		  #local Lankl=Lknee+vrotate(<0,-16*in,0>,<-10,0,0>);
		}
	    cone{// clothing
		  <0,0,0>,2*in,<0,-14*in,0>,2.25*in
		  texture{Uniform2}
		  rotate <-10,0,0>
		  translate Lknee+Waist
		}
		object{
		  box{
            <-2*in,0,1.5*in>,<2*in,-3*in,-6*in>
          }
		  rotate <0,0,0>
		  translate Lankl+Waist
		}
		object{// clothing
		  box{
            <-2.1*in,0.1*in,1.6*in>,<2.1*in,-3.1*in,-6.1*in>
          }
		  texture{UniformF}
		  rotate <0,0,0>
		  translate Lankl+Waist
		}
	  }
	  texture{HFlesh}
    }//-union
	rotate prtn
	translate plocn
  }//-object RTDH1
#end

#macro RTDH2 (plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips)
  object{
    #local Waist=<0,3*ft+5*in,0>;
    union{
	  // Head
	  union{
	    // Neck
		cylinder{
		  <0,0,0>,<0,3,0>,2*in
		  scale <1,1,.5>
		}
	    // Outline
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,8,6>
		  translate <0,5*in,-1*in>
		}
  	    sphere{
	      <0,0,0>,.5*in
		  scale <6,7,8>
		  translate <0,5.5*in,0>
		}
		// Eyes
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <-2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		sphere{
		  <0,0,0>,.5*in
		  scale <1.5,1,1>
		  translate <2*in,5*in,-3.5*in>
		  texture{HEyes}
		}
		// Nose
		cone{
		  <0,0,0>*in,0,<0,-1.5,-0.3>*in,0.5*in
		  scale <1.5,1,1>
		  translate <0,5,-4>*in
		}
	  	#ifdef (HeadClothing)
			object{HeadClothing}
		#end
		rotate prtns[0]
		rotate prhead+prtorso
		translate Waist+(vrotate(<0,1*ft+2*in,0>,prtorso))
	  }
	  // Torso
      union{
	    cone{
		  <0,11*in,0>,5*in,<0,14*in,0>,2*in
		}
	    cone{
		  <0,7*in,0>,5.5*in,<0,11*in,0>,5*in
		}
	    cone{
		  <0,0,0>,5*in,<0,7*in,0>,5.5*in
		}
	  	#ifdef (TorsoClothing)
			object{TorsoClothing}
		#end
		// Upper shoulders
		cone{
		  <0,10*in,0>,8*in,<0,11*in,0>,5*in
		  scale <1,1,.25>
		  #local Rshld=vrotate(<-7*in,10*in,0>,prtorso);
		  #local Lshld=vrotate(<7*in,10*in,0>,prtorso);
		}
	  	#ifdef (ShoulderClothing)
			object{ShoulderClothing}
		#end
		scale <1,1,.5>
		rotate prtorso
		translate Waist
	  }
	  // Right arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate prtns[1]+prtorso
		  translate Rshld+Waist
		  #local Relbw=Rshld+vrotate(<0,-9.5*in,0>,prtns[1]+prtorso);
		}
	  	#ifdef (RuSleeveClothing)
		  object{
			RuSleeveClothing
			rotate prtns[1]+prtorso
			translate Rshld+Waist
		  }
		#end
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate prtns[2]+prtorso
		  translate Relbw+Waist
		  #local Rwrst=Relbw+vrotate(<0,-9.5*in,0>,prtns[2]+prtorso);
		}
	  	#ifdef (RlSleeveClothing)
	  	  object{
			RlSleeveClothing
			rotate prtns[2]+prtorso
			translate Relbw+Waist
		  }
		#end
		object{
		  RHand
		  rotate prtns[2]
		  translate Rwrst+Waist
		}
	  }
	  // Left arm
	  union{
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1*in
		  rotate prtns[3]+prtorso
		  translate Lshld+Waist
		  #local Lelbw=Lshld+vrotate(<0,-9.5*in,0>,prtns[3]+prtorso);
		}
	  	#ifdef (LuSleeveClothing)
	 	  object{
			LuSleeveClothing
			rotate prtns[3]+prtorso
			translate Lshld+Waist
		  }
		#end
	    cone{
		  <0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
		  rotate prtns[4]+prtorso
		  translate Lelbw+Waist
		  #local Lwrst=Lelbw+vrotate(<0,-9.5*in,0>,prtns[4]+prtorso);
		}
	  	#ifdef (LlSleeveClothing)
	  	  object{
			LlSleeveClothing
			rotate prtns[4]+prtorso
			translate Lelbw+Waist
		  }
		#end
		object{
		  LHand
		  rotate prtns[4]
		  translate Lwrst+Waist
		}
	  }
	  // Hips
	  cone{
        <0,0,0>,5*in,<0,-8*in,0>,6*in
		scale <1,1,.5>
		rotate prhips
		translate Waist
		#local Rhip=vrotate(<-3*in,-8*in,0>,prhips);
		#local Lhip=vrotate(<3*in,-8*in,0>,prhips);
	  }
	  #ifdef (HipsClothing)
		object{
		  HipsClothing
		  rotate prhips
		  translate Waist
		}
	  #end
	  // Right leg
	  union{
	    sphere{
		  <0,0,0.25*in>,2.9*in
		  translate Rhip+Waist
		}
		#ifdef (RHipsClothing)
		  object{
			RHipsClothing
			translate Rhip+Waist
		  }
		#end
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate prtns[5]
		  translate Rhip+Waist
		  #local Rknee=Rhip+vrotate(<0,-14*in,0>,prtns[5]);
		}
		#ifdef (RThighClothing)
		  object{
			RThighClothing
			rotate prtns[5]
			translate Rhip+Waist
		  }
		#end
	    sphere{
		  <0,0,0>,1.5*in
		  translate Rknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate prtns[6]
		  translate Rknee+Waist
		  #local Rankl=Rknee+vrotate(<0,-16*in,0>,prtns[6]);
		}
		#ifdef (RCalfClothing)
		  object{
			RCalfClothing
			rotate prtns[6]
			translate Rknee+Waist
		  }
		#end
		union{
		  cylinder{
            <0,0,0>*in,<0,-3,0>*in,2*in
			scale <1,1,0.75>
		  }
		  intersection{
			  box{
				<-2,0,0>*in,<2,-3,-6.1>*in
			  }
			  sphere{
			    <0,0,0>*in,1*in scale <2,2.5,-6> translate <0,-3,0>*in
			  }
		  }
		  rotate <0,0,0>
		  translate Rankl+Waist
		}
		#ifdef (RFootClothing)
		  object{
			RFootClothing
			rotate <0,0,0>
			translate Rankl+Waist
		  }
		#end
	  }
	  // Left leg
	  union{
	    sphere{
		  <0,0,0.25*in>,2.9*in
		  translate Lhip+Waist
		}
		#ifdef (LHipsClothing)
		  object{
			LHipsClothing
			translate Lhip+Waist
		  }
		#end
	    cone{
		  <0,0,0>,3*in,<0,-14*in,0>,1.5*in
		  rotate prtns[7]
		  translate Lhip+Waist
		  #local Lknee=Lhip+vrotate(<0,-14*in,0>,prtns[7]);
		}
		#ifdef (LThighClothing)
		  object{
			LThighClothing
			rotate prtns[7]
			translate Lhip+Waist
		  }
		#end
	    sphere{
		  <0,0,0>,1.5*in
		  translate Lknee+Waist
		}
	    cone{
		  <0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
		  rotate prtns[8]
		  translate Lknee+Waist
		  #local Lankl=Lknee+vrotate(<0,-16*in,0>,prtns[8]);
		}
		#ifdef (LCalfClothing)
		  object{
			LCalfClothing
			rotate prtns[8]
			translate Lknee+Waist
		  }
		#end
		union{
		  cylinder{
            <0,0,0>*in,<0,-3,0>*in,2*in
			scale <1,1,0.75>
		  }
		  intersection{
			  box{
				<-2,0,0>*in,<2,-3,-6.1>*in
			  }
			  sphere{
			    <0,0,0>*in,1*in scale <2,2.5,-6> translate <0,-3,0>*in
			  }
		  }
		  rotate <0,0,0>
		  translate Lankl+Waist
		}
		#ifdef (LFootClothing)
		  object{
			LFootClothing
			rotate <0,0,0>
			translate Lankl+Waist
		  }
		#end
	  }
	  texture{HFlesh}
    }//-union
	rotate prtn
	translate plocn
  }//-object RTDH2
#end

#declare SamplerName=object{
  RTDH2(<0,0,0>,<0,0,0>,array[4]{1,1,1,1},array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare SamplerBBox=array[2]
  {<-12*in,0,-8*in>,<12*in,5*ft+8*in,8*in>}
                                                                                  e  Icon
           @         	rtdhc.incpictct)t.mcrngtfacesil TEXTMPS    B                  l  F    
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR     H 	Monaco 
 !             
   ]h ]h          ( ]h ]h  9G                          e(Eh    R MPSR  FPRF   *          D,          POV-Ray File Prefs 