#include "metals.inc"

#declare BOATW = texture{
pigment{White}
finish{ambient 0.3
       diffuse 0.4
       reflection 0
       specular 0.3
       roughness 2}
}

#declare BOATB = texture{
pigment{Black}
finish{ambient 0.3
       diffuse 0.4
       reflection 0
       specular 0.3
       roughness 2}
}

#declare BOATM = texture{
pigment{Black}
finish{ambient 0.3
       diffuse 0.4
       specular 0.3
       roughness 2}
normal{bumps scale 0.01 bump_size 0.005 turbulence 0.5 scale 0.01}
}



#declare rumpf_b = object{
 difference{
  sphere{0,1 scale <3,2,2>}
  box {<0,-3,-3>,<-3,3,3>}
  box {<-1,0,-3>,<4,3,3>}
 }
}

#declare rumpf_s = object{
 difference{
  sphere{0,1 scale <9.5,2,2>}
  box {<0,-3,-3>,<10,3,3>}
  box {<1,0,-3>,<-10,3,3>}
 }
}

#declare rumpfshape = object{
 difference{
  union{
   object{rumpf_s}
   object{rumpf_b}
  }
  box{<0,-4,-3>,<-4,4,3> rotate<0,0,20> translate <-7.5,0,0> pigment{Gray90}}
  sphere{0,1 scale 1.98}
 }
}
   
#declare rumpf = object{
 difference{
  object{rumpfshape}
  object{rumpfshape scale 0.99 translate <0,0.001,0>}
 }
}

#declare frontpart = object{
 intersection{
  box{<1,-3,-3>,<4,1,3>}
  object{rumpf_b}
 }
}

#declare machine = object{
 union{
  cylinder{<-4,0,0>,0,0.8 translate y*-0.5}
  cylinder{<0,-1,0>,<0,1,0>,0.5}
  torus{0.125,0.375 translate y}
  cylinder{y,y*3,0.125}
  difference{
   intersection{
    torus{0.4,0.3 translate <0,3,0>}
    cylinder{y*3,y*3.5,0.2}
   }
   torus{0.4,0.275 translate <0,3,0>}
   #declare j = 0;
   #while (j < 4)
    union{
     cylinder{<-1,0,0>,<1,0,0>,0.04 rotate z*j*45}
     box{<-1,0,-0.03><1,1,0.03> rotate y*j*45}
     translate <0,3,0>
    }
    #declare j = j + 1;
   #end
  }
  torus{0.125,0.05 translate <0,3,0>}
  texture{BOATM}
 }
}

#declare wheels = object{
 union{
  difference{
   cylinder{<-1.5,-0.5,-2.5>,<-1.5,-0.5,2.5>,1}
   cylinder{<-1.5,-0.5,-2.45>,<-1.5,-0.5,-1.8>,0.95}
   cylinder{<-1.5,-0.5,2.45>,<-1.5,-0.5,1.8>,0.95}
   box{<-3,-0.8,-3>,<0,-2,3>}
   box{<-3,2,1.7>,<0,-2,-1.7>}
  }
  #declare j = 0;
  #while (j < 4)
   box{<-0.9,-0.03,0>,<0.9,0.03,0.4> 
       pigment{Red} 
       rotate z*j*45
       translate <-1.5,-0.5,2>}    
   box{<-0.9,-0.03,0>,<0.9,0.03,-0.4> 
       pigment{Red} 
       rotate z*j*45
       translate <-1.5,-0.5,-2>}
   #declare j = j + 1;
  #end
 } 
}

#declare writing = object{
box{0,<1,1,0.001> 
    pigment{image_map{gif "schuiten.gif" interpolate 2
                      transmit 1,1.0
                      transmit 2,1.0}}
   }
 translate <-0.5,-0.5,0>
 rotate <0,180,0>
 scale 2 
 translate <-1.5,-0.5,-2.5001>
}

#declare captain = object{
box{0,<1,1,0.001> pigment{image_map{gif "captain.gif" interpolate 2
                                    transmit 1, 1.0}}
    finish {ambient 0.5 diffuse 0.3}
    translate <-0.5,-0.5,0>
    scale <0.4467,1,1>
    scale 3
    rotate <0,45,0>
    translate <-5,0.3,0>
   }
}

#declare lady = object{
box{0,<1,1,0.001> 
    pigment{image_map{gif "lady.gif" interpolate 2
                                    transmit 220, 1.0}}
    finish {ambient 0.5 diffuse 0.3}
    translate <-0.5,-0.5,0>
    scale <0.4362,1,1>
    scale 3
    rotate <0,45,0>
    translate <2.2,1.3,0>
   }
}

#declare mseed = seed(43254);

#declare smoke = object{
 union{
 #declare j = 0;
 #while (j < 40)
  sphere{0,1
         hollow 
         scale 0.25 + (rand(mseed)+1)*j*0.05
         translate <-j*0.7,3.1+sqrt(j*0.4),j*0.1>
         pigment{rgbf 1.0}
         interior{media{
         absorption 0.99
         intervals 10
         variance 1/100
         confidence 0.9
         samples 1,30
/*         density{spherical 
                 density_map{[0.0 spherical]
                             [0.1 crackle turbulence 1.6]}
                 turbulence 0.2} */
		density {spherical
                 scale 0.25 + (rand(mseed)+1)*j*0.05 
                 translate <-j*0.7,3.1+sqrt(j*0.4),j*0.1>}
		density {crackle turbulence 1.6}
         }
        }
       }
       #declare j = j +1;
      #end
 }  
}

#declare shipname = object{
 union{ 
  text{ttf "DOLPHIN.TTF" "Giavanni Battista" 0.2, 0
       texture{T_Gold_4A} translate <-3.3,0,0>
       scale 0.3}
  text{ttf "DOLPHIN.TTF" "PIRANESI" 0.2, 0
       texture{T_Gold_4A}
	   translate <-2,-1,0>
       scale 0.3}
 rotate <0,90,0>
 rotate<0,0,20> translate <-7.6,-0.3,0>
 }
}

#declare ship = object{
 union{
  object{rumpf texture{BOATB}}
  object{frontpart texture{BOATW}}
  object{machine texture{BOATM}}
  object{wheels texture{BOATW}}
  object{writing}
  object{captain}
  object{lady}
  object{smoke}
  object{shipname}
 }
}
