#include "kolors.inc"

// *********************************************************************

camera {//location <0, 0, 0>
        location <-10,4,0>
        angle 60
        look_at <0, 4, 0>}

global_settings {max_trace_level 20}

// *********************************************************************

light_source {<0,2,-10> LightGldnrod1*0.7 shadowless} //White}

light_source {<-20000,30000,10000> LightGldnrod1*2} //White}

// *********************************************************************

background {White}

// *********************************************************************

#declare mseed = seed(34785);

#declare leaf = pigment{
spherical color_map{[0 rgb <0.02,1.0,0.02>]
                    [1 rgb <0.3,1.0,0.4>]}}


#declare PTEX = texture{
pigment{granite turbulence 1.8
        pigment_map{[0.5 rgbt 1.0]
                  [0.6 rgb<0.5,0.8,0.6>]
                  [0.7 rgb<0.4,0.7,0.5>]
                  [0.8 rgb<0.3,0.6,0.4>]
                  [0.9 rgb<0.2,0.5,0.3>]}}
finish{ambient 0.3
       diffuse 0.3}
}

/*
#declare bush = blob{
threshold 1.0
#declare j = 0;
#while (j < 10)
 sphere{0,rand(mseed) + 1,2
        scale <1+rand(mseed),1+rand(mseed),1+rand(mseed)> 
        translate <rand(mseed)*3,0,rand(mseed)*3>}
 sphere{0,rand(mseed) + 0.5,2
        scale <1+rand(mseed),1+rand(mseed),1+rand(mseed)> 
        translate <rand(mseed)+2,rand(mseed)+1,rand(mseed)+2>}
 #declare j = j + 1;
#end
}

#declare i =0;
#while (i < 5)
 sphere {0,2-i*0.1 texture{PTEX scale 2-i*0.1 
         rotate <rand(mseed)*180,rand(mseed)*180,rand(mseed)*180>}}
 sphere {0,1-i*0.1 texture{PTEX scale 2-i*0.1 
         rotate <rand(mseed)*180,rand(mseed)*180,rand(mseed)*180>}
         scale <1.2,0.5,1.5>
         translate <1.5,-0.2,-1.4>}
 sphere {0,1.2-i*0.1 texture{PTEX scale 2-i*0.1 
         rotate <rand(mseed)*180,rand(mseed)*180,rand(mseed)*180>}
         scale <1,0.5,1.5>
         translate <-1,0.2,-1>}
  sphere {0,1.2-i*0.1 texture{PTEX scale 2-i*0.1 
         rotate <0,rand(mseed)*180,0>}
         scale <1,0.5,1.5>
         translate <0,-0.3,-0.1>
         rotate <0,90,0>}
 object{bush scale 1-i*.01 texture{PTEX} }
 #declare i = i + 1;
#end
object{bush scale 1-(i+1)*.01 pigment{DarkGreen} }

plane {y,1 pigment{DarkBrown}}
*/

// ************************************************* vine

#declare e = 2.718281828;

#declare lengthbits = array[5]

#declare i = 0;
#declare lsum = 0;
#while (i<5)
 #declare lengthbits[i] = 1/(log(i + 1 + e));
 #declare lsum = lsum + lengthbits[i];
 #declare  i = i + 1;
#end

#declare i = 0;
#while (i<5)
 #declare lengthbits[i] = lengthbits[i]/lsum;
 #declare i = i + 1;
#end

#macro vine(inilength,branches,thick,subbr)
 union{
 #local curbranch = <0,0,0>;
 #local i = 0;
 #while (i < branches)
  #local changle = rand(mseed)*60-30;
  cone{<0,0,0>, thick/log(i + e), <0,inilength,0>, thick/log(i + 1 + e)
       scale 1/(log(i + e))
	   rotate x*changle
	   translate curbranch
       pigment{DarkBrown}}

   #local j = 0;
   #local bbranch = curbranch;
   #while (j < subbr) 
    #local brangle = -rand(mseed)*90-0;
	cone{<0,0,0>, 0.8*thick/log(i + e)/log(j + e),
         <0,0,inilength>, 0.8*thick/log(i + e)/log(j + 1 + e)
         scale 1/log(i + e)/log(j + e)
         rotate x*brangle
         translate bbranch
         pigment{DarkBrown}}
    #local dfbbranch = vrotate(<0,0,inilength> * 1/log(i+e)/log(j+e),
                               x*brangle);
    #local bbranch = bbranch + dfbbranch;
    #if (j>0)
     sphere{0,1 
            scale 1/log(i+e)/log(j+e) 
            scale <0.03,0.3,0.15>
            rotate<rand(mseed)*30-15,rand(mseed)*10-5,rand(mseed)*20-5>
            translate bbranch
            translate <0,-0.3/log(i + e)/log(j + 1 + e),0>
            pigment{DarkGreen}
           }
    #end
    #local j = j + 1;
   #end	

  #local difbranch = vrotate(<0,inilength,0> * 1/(log(i + e)),x*changle);
  #local curbranch = curbranch + difbranch;
  #local i = i + 1;
 #end
}
#end

object{vine(0.4,50,0.04,20)}
