#include "kolors.inc"
#include "arch.inc"
#include "13_COL.INC"
#include "boat.inc"
#include "plants.inc"
// *********************************************************************

camera {//location <-6, -10, -24>
        location <-12,-10,-36>
        angle 60
        look_at <6, 0, 0>}

global_settings {max_trace_level 70}

// *********************************************************************


sky_sphere {pigment{cylindrical color_map{[0    AliceBlue]
                                     [0.3 LightBlue3]
                                     [0.5 CornflowerBlue1] 
                                     [0.8 RoyalBlue2]} 
                   }
           }

#declare i = 0;
#while (i < 10)
 sphere {0,30000 + i*10 
        hollow
        pigment{leopard color_map{[0.01 rgbt<1,1,1,1>]
                                  [0.1 rgbt <1,1,1,0.98>]
                                  [0.4 rgbt <1,1,1,0.94>]
                                  [0.6 rgbt <1,1,1,0.90>]
                                  [0.7 rgbt <1,1,1,0.80>]}
                turbulence 2.5
                scale 4000}
        finish{ambient 1.2
               diffuse 0.3
               reflection 0
               specular 0}
        scale <2,0.2,2>}
 #declare i = i + 1;
#end


fog {fog_type 1 distance 25000 color CornflowerBlue1}

// *********************************************************************


light_source {<0,2,-10> LightGldnrod1*0.7 shadowless} //White}

light_source {<-20000,30000,10000> 
              LightGldnrod1*2 
              media_attenuation off}//White}

// *********************************************************************
/*
#declare WALLTEX = texture{
 pigment{Sienna4}
 normal{granite bump_size 0.1 turbulence 0.4 scale 0.1}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.1
        roughness 1.0}
//pigment{White}
} 

#declare WALLTEX2 = texture{
 pigment{Sienna4}
 normal{granite bump_size 1 turbulence 0.4 scale 0.1}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.1
        roughness 1.0}
} 

#declare WBRICK = texture{
 pigment{brick Sienna4, Sienna5 brick_size <0.5,0.3,0.5> mortar 0.1 scale 4}
 normal {granite bump_size 1 turbulence 0.4 scale 0.1}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.1
        roughness 1.0}
}

#declare WALL = texture{
 bozo turbulence 1.0 
 scale 20
 texture_map{
 [0.3 WALLTEX]
 [0.5 WALLTEX2]
 [0.7 WBRICK]}
}
*/
#declare WALLTEX = texture{
 pigment{Sienna4}
 normal{granite bump_size 0.1 turbulence 0.4 scale 0.1}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.1
        roughness 1.0}
//pigment{White}
} 

#declare WALLTEX2 = texture{
 pigment{Sienna4}
 normal{granite bump_size 0.2 turbulence 0.6 scale 0.1}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.1
        roughness 1.0}
} 

#declare WBRICK = texture{
 pigment{brick Sienna4, Sienna5  brick_size <0.5,0.3,0.5> mortar 0.1 scale 4}
 normal{brick brick_size <0.5,0.3,0.5> mortar 0.02 scale 4 turbulence 0.05}
 finish{ambient 0.4
        diffuse 0.5
        specular 0.2
        roughness 1.0}
 scale 0.05
}

#declare WALL = texture{
 granite
 turbulence 0.2
 scale 2
 texture_map{
 [0.5 WBRICK]
 [0.5 WALLTEX2]
 [0.7 WALLTEX]}
}

//******************************************************** structures

object{roof(12, 0.3) translate <0,0,6> texture{WALL} }

object{arch(5,1.8,1) texture{WALL}}
difference{
 object{arch(5,1.8,1)  translate <0,8.3,0>}
 box{<-7,8.3,-2>,<0,18,2>}
 box{<-7,8.3,-2>,<0,25,2>
     texture{WBRICK} 
     rotate<0,0,-15> 
     translate <-1.5,0,0>}
 box{<-7,8.3,-2>,<0,20,2> 
     texture{WBRICK} 
     rotate<6,0,15> 
     translate <4.5,6,0>}
 box{<-7,8.3,-2>,<0,20,2>
     texture{WBRICK} 
     rotate<6,0,15> 
     translate <5.5,6.5,0>}
 box{<-7,8.3,-2>,<0,20,2>
     texture{WBRICK} 
     rotate<-15,-15,15> 
     translate <4.5,5.5,0>}
 box{<-7,8.3,-4>,<0,10,4>
     texture{WBRICK} 
     rotate<5,5,5> 
     translate <5.5,1.5,2>}
 texture{WALL}
}


object{arch(5,1.8,1) translate <0,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate <13,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate <26,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate <39,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate <52,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate <-13,0,12.5> texture{WALL}}
object{arch(5,1.8,1) translate<-13,0,0> texture{WALL}}
object{arch(5,1.8,1) translate<13,0,0> texture{WALL}}
object{arch(5,1.8,1) translate<13,0,-12.5> texture{WALL}}
object{arch(5,1.8,1) translate<26,0,0> texture{WALL}}
object{arch(5,1.8,1) translate<26,0,-12.5> texture{WALL}}
object{arch(5,1.8,1) translate<39,0,0> texture{WALL}}

object{archn(5,3,1) rotate <0,90,0> translate<6.5,0,6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<19.5,0,6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<32.5,0,6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<45.5,0,6> texture{WALL}}
object{archn(5,3,1) rotate <0,-90,0> translate<-6.5,0,6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<6.5,0,-6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<19.5,0,-6> texture{WALL}}
object{archn(5,3,1) rotate <0,90,0> translate<32.5,0,-6> texture{WALL}}

//********************************************************** columns

object{column_corinthian scale 2 translate < 5.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 5.5, -14,  0.5>}
object{column_corinthian scale 2 translate < 7.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 7.5, -14,  0.5>}

object{column_corinthian scale 2 translate < 18.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 18.5, -14,  0.5>}
object{column_corinthian scale 2 translate < 20.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 20.5, -14,  0.5>}

object{column_corinthian scale 2 translate < 31.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 31.5, -14,  0.5>}
object{column_corinthian scale 2 translate < 33.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 33.5, -14,  0.5>}

object{column_corinthian scale 2 translate < 44.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 44.5, -14,  0.5>}
object{column_corinthian scale 2 translate < 46.5, -14, -0.5>}
object{column_corinthian scale 2 translate < 46.5, -14,  0.5>}

object{column_corinthian scale 2 translate <-7.5, -14, -0.5>}
object{column_corinthian scale 2 translate <-7.5, -14,  0.5>}
object{column_corinthian scale 2 translate <-5.5, -14, -0.5>}
object{column_corinthian scale 2 translate <-5.5, -14,  0.5>}
//----------------------------------------------------------------
object{column_corinthian scale 2 translate < 5.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 7.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 5.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate < 7.5, -14,  0.5 +12>}

object{column_corinthian scale 2 translate < 18.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 20.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 18.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate < 20.5, -14,  0.5 +12>}

object{column_corinthian scale 2 translate < 31.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 33.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 31.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate < 33.5, -14,  0.5 +12>}

object{column_corinthian scale 2 translate < 44.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 46.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 44.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate < 46.5, -14,  0.5 +12>}

object{column_corinthian scale 2 translate < 57.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 59.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate < 57.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate < 59.5, -14,  0.5 +12>}

//object{column_corinthian scale 2 translate < 80.5, -14, -0.5 +12>}
//object{column_corinthian scale 2 translate < 82.5, -14, -0.5 +12>}
//object{column_corinthian scale 2 translate < 80.5, -14,  0.5 +12>}
//object{column_corinthian scale 2 translate < 82.5, -14,  0.5 +12>}

object{column_corinthian scale 2 translate <-5.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate <-5.5, -14,  0.5 +12>}
object{column_corinthian scale 2 translate <-7.5, -14, -0.5 +12>}
object{column_corinthian scale 2 translate <-7.5, -14,  0.5 +12>}
//----------------------------------------------------------------
object{column_corinthian scale 2 translate < 5.5, -14, -0.5 -12>}
object{column_corinthian scale 2 translate < 5.5, -14,  0.5 -12>}
object{column_corinthian scale 2 translate < 7.5, -14, -0.5 -12>}
object{column_corinthian scale 2 translate < 7.5, -14,  0.5 -12>}

object{column_corinthian scale 2 translate < 18.5, -14, -0.5 -12>}
object{column_corinthian scale 2 translate < 18.5, -14,  0.5 -12>}
object{column_corinthian scale 2 translate < 20.5, -14, -0.5 -12>}
object{column_corinthian scale 2 translate < 20.5, -14,  0.5 -12>}

// ***************************************************** ornaments

object{orna1 scale <2,1.5,1.5> translate <6.5,-3.4,0> texture{WALL} } 
object{orna1 scale <2,1.5,1.5> translate <19.5,-3.4,0> texture{WALL} } 
object{orna1 scale <2,1.5,1.5> translate <32.5,-3.4,0> texture{WALL} } 
object{orna1 scale <2,1.5,1.5> translate <-6.5,-3.4,0> texture{WALL} } 
			
object{orna1 scale <2,1.5,1.5> translate <6.5,-3.4,12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <19.5,-3.4,12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <32.5,-3.4,12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <45.5,-3.4,12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <58.5,-3.4,12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <-6.5,-3.4,12> texture{WALL}}
 			
object{orna1 scale <2,1.5,1.5> translate <6.5,-3.4,-12> texture{WALL}} 
object{orna1 scale <2,1.5,1.5> translate <19.5,-3.4,-12> texture{WALL}} 
			
object{orna2 translate <5.75,0,-13>  texture{WALL}}
object{orna2 translate <7.75,0,-13>  texture{WALL}}
object{orna2 translate <19.25,0,-13>  texture{WALL}}
object{orna2 translate <21.25,0,-13>  texture{WALL}}
			
object{orna3 rotate<0,90,0> translate <6.5,0,-18> texture{WALL}}
object{orna3 rotate<0,90,0> translate <19.5,0,-18> texture{WALL}}
			
object{roof2 translate <6.5,0,-13.5> texture{WALL}}
// ********************************************************************** water

plane {y,-12
       hollow 
       texture{pigment{Blue*0.3} //Blue4}
               normal{bumps 
                      scale <1,1,0.3>
                      rotate<0,35,0> 
                      bump_size 0.2}
               finish{ambient 0.2
               diffuse 0.1
               reflection 0.5
               specular 0.9
               roughness 0.001}
              }
      }              

// *******************************************************************

object{ship scale 0.8 rotate <0,-45,0> translate <-2.5,-11.1,-3>}


// *******************************************************************

object{abush rotate y*50 translate <2.5,8.5,-1.5>}