// Persistence of Vision Raytracer Version 2.0

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "woods.inc"

camera {
   location  <10, 5, 10>
   direction <0, 0, 1>
   up        <0, 1, 0>
   right   <4/3, 0, 0>
   look_at   <0, 7, 0>
   // ultra_wide_angle
   // angle 240
}

light_source
{
    0*x color Gray95
    area_light <20, 0, 0>, <0, 0, 20>, 5, 5
    adaptive 1
    jitter

    translate <40, 100, 100>
}


#declare Sky = sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.2  color Gray95]
      [1.0  color Gray70]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49976
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.8, .8, .8, 0.1>]
      [0.6 color rgbf<.9, .9, .9, .95>]
      [0.9 color rgbf<1, 1, 1, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5113
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.5, .5, .5, 0.2>]
      [0.5 color rgbf<.6, .6, .6, .9>]
      [0.7 color rgbf<.7, .7, .7, 1>]
    }
    scale 4/10
    scale <1, 0.3, 0.3>
  }
}

sky_sphere { Sky rotate -75 }

// fog { distance 500.0 color rgbt<0.9, 0.9, 0.9, 0.5> }
fog { distance 100.0 fog_type 2 fog_offset 5 fog_alt 10 color rgbt<0.8, 0.8, 0.8, 0.3> }

plane
{   y, 0
    pigment { color rgb <0.3, 0.21, 0.12> }
    normal { bumps 0.9 scale 1.75 }
    finish { ambient .1 diffuse .3 }
}

#include "tree1.pov"

object {   Tree1 rotate y*-66
    texture { T_Wood31 }
    normal { bumps 0.7 scale 0.2 }
}
