// ==== Standard POV-Ray Includes ====  
 
 
 #declare A=seed(234624);   

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions   
#include "glass.inc" 
#include "stoneold.inc"  

      
 
/*
camera
{
  location  <0.0 , 3.0 ,0>
  look_at   <-10.0 , 3.0 , 0.0>
}
*/
  
 #declare camera_location = <0, 3, 0>;
#declare camera_look_at = <-10, 3, 0>;
#declare effect_always_on_top = false;     


#declare effect_scale =<.2,.2,.2> ;

#declare glow_type = 4;
#declare effect_location = <5, 13.7, 0>; #include "LNSEFCTS.INC"
   
#declare glow_type = 4;
#declare effect_location = <-14, 13.7, 0>; #include "LNSEFCTS.INC"
#declare glow_type = 4;
#declare effect_location = <-39, 13.7, 0>; #include "LNSEFCTS.INC"
#declare effect_scale =<.2,.2,.2>*.5 ;

#declare glow_type = 4;
#declare effect_location = <-69, 13.7, 0>; #include "LNSEFCTS.INC"



   
   
// create a regular point light source
 light_source{ 0*x Gray30+Orange*.3  
        area_light<1,0,0>,<0,1,0>,2,2
         adaptive 1
        jitter
        translate <-40.0 , 14.0-1.5 ,.0> 
        fade_distance 20  fade_power 2}                                             
 /*light_source{0*x Gray90  translate <-20.0 , 8.0 ,.0> shadowless fade_distance 4  fade_power 2 }                  
light_source{0*x Gray90  translate <-40.0 , 8.0 ,.0> shadowless fade_distance 4  fade_power 2 }                  
light_source{0*x Orange*.3  translate <-20.0 , 8.0 ,.0> shadowless }                  
*/   
//light_source{0*x Gray30  translate <0.0 , -10.0 ,.0> shadowless fade_distance 20  fade_power 2 }                  
  
   
   
  #declare suciedad_alcantarilla=
 texture{
  pigment{
  bozo
   turbulence 1
   color_map{
    [0.00 Brown]
    [0.35   Brown*.80]
    [0.7   Brown*.95  ]
    [1.00  Aquamarine*.2 filter .5]
   }
  }
  normal{granite scale .3 scale 3}
 scale 4
 } 
  texture{pigment{Aquamarine filter 0.8} 
 normal{bozo 1  scale 1*<3, 1, 3> triangle_wave turbulence .6}
   finish{phong .3 phong_size 40  }}

#declare suciedad_baldosa=
 texture{
  pigment{
  bozo
   turbulence 1
   color_map{
    [0.00 Gray30]
    [0.35  Gray30*.7]
    [0.7  Gray30*.90 ]
    [1.00 Aquamarine*.2 filter .5]
   }
  }   
  normal{granite scale .3 scale 3}
 scale 4
 }    
 texture{pigment{Aquamarine filter 0.9} 
 normal{bozo 1  scale 1*<3, 1, 3> triangle_wave turbulence .6}
   finish{phong .4 phong_size 40  }}

#declare textura_alcantarilla=texture{pigment{Brown}} texture{suciedad_alcantarilla}
#declare textura_baldosa=texture{pigment{Gray30} finish{phong 1 phong_size 100}} texture{suciedad_baldosa scale .5}
#declare textura_bordillo=texture{pigment{Gray15} finish{phong 1 phong_size 100}} texture{suciedad_baldosa scale .5}
#declare textura_agua=
 material{
  texture{
   //pigment {rgbf <0.01, .2, .5,.99>}   
   //pigment{Aquamarine*.6+Gray30 filter 0.99}
   //pigment{White+Aquamarine*.1 filter .99}
   pigment{Aquamarine*.6 +DarkOliveGreen*.8 filter .99}
  normal{bozo 1  scale .5*<3, 2, 3> triangle_wave turbulence .2}
  finish{phong 1 phong_size 150 reflection .5}
    
  }
  interior{
   ior 1.3 
          
  }
 } 
     
     
#include "rocas.inc"     
 
#include "objetos.pov"
     
#declare largo_tunel=40;
    
 

#declare pared_alcantarilla_1=union{
  #declare n_piedras=5;
  #while (n_piedras>=0)
   #declare m_piedras=largo_tunel;
        #while (m_piedras>=0)  
        #declare c=int(4*rand(A));
#switch (c)
#case(0) 
#declare superficie=object{superficie_1}
#break
#case (1) 
#declare superficie=object{superficie_2} 
#break
#case (2) 
#declare superficie=object{superficie_3} 
#break
#case (3) 
#declare superficie=object{superficie_4} 
#break
#end  

#declare cuanto_rota=int(4*rand(A));
#declare piedra=object{box{<0,-.5,0>,<1,0,1>}}
#declare piedra_alcantarilla= union{object{piedra translate <-.5,-.5,-.5> } 
                                object{superficie translate <-.5,-.5,-.5> scale <1.06,1,1.06>}
                                  }
                                   
                              
        #if(pow(-1,n_piedras)=1)
        object{piedra_alcantarilla rotate(90*cuanto_rota)*y scale <2,1,1>
               rotate -90*x translate <-2.2*m_piedras,1*n_piedras, (.01-.02*rand(A))>   }
        #else
        object{piedra_alcantarilla    rotate(90*cuanto_rota)*y scale <2,1,1>
               rotate -90*x translate <-2.2*m_piedras,1*n_piedras, (.01-.02*rand(A))> translate 1*x  } 
        #end
         #declare m_piedras=m_piedras-1;
        #end
        #declare n_piedras=n_piedras-1;
        #end
        }
        
/* #declare pared_lisa_alcantarilla=union{
 object{pared_alcantarilla_1 translate 10*z texture{textura_alcantarilla}} 
 difference {
        object{pared_alcantarilla_1  }  
             object{cylinder{<-0,0,-20>,<-0,0,15>,5  } scale <.7,1,1> translate -20*x}
             translate .5*z scale -1*z translate -9.5*z texture{textura_alcantarilla}}
             } */
 #declare pared_lisa_alcantarilla=union{
        object{pared_alcantarilla_1 translate 10*z texture{textura_alcantarilla}} 
        object{pared_alcantarilla_1 translate 1*x   
             translate .5*z scale <1,1,-1> translate -9.5*z texture{textura_alcantarilla}}
             }
 #declare alcantarilla=union{
#declare n_piedras=31;
#while (n_piedras>=0) 
 #declare m_piedras=largo_tunel;
#while (m_piedras>=0)  
 
#declare c=int(4*rand(A));
#switch (c)
#case(0) 
#declare superficie=object{superficie_1}
#break
#case (1) 
#declare superficie=object{superficie_2} 
#break
#case (2) 
#declare superficie=object{superficie_3} 
#break
#case (3) 
#declare superficie=object{superficie_4} 
#break
#end  

#declare cuanto_rota=int(4*rand(A));
//#declare piedra=object{box{<0,-.5,0>,<1,0,1>}}
#declare piedra_alcantarilla=//union{object{piedra translate <-.5,-.5,-.5> } 
                                   object{superficie translate <-.5,-.5,-.5> scale <1.06,1,1.06>}
                               //    }
                                   
#if(pow(-1,n_piedras)=1)
object{piedra_alcantarilla     rotate(90*cuanto_rota)*y scale <2,1,1>
       rotate -90*x translate <-2.2*m_piedras,0,.01-.02*rand(A)> translate 10*z rotate -5.8*n_piedras*x}
#else
object{piedra_alcantarilla    rotate(90*cuanto_rota)*y scale <2,1,1>
       rotate -90*x translate <-2.2*m_piedras,0,.01-.02*rand(A)> translate 1*x translate 10*z rotate -5.8*n_piedras*x } 
#end
 #declare m_piedras=m_piedras-1;
#end
#declare n_piedras=n_piedras-1;
#end
}

#declare fila_baldosa=union{
#declare n_baldosas=6;//numero de baldosas a lo ancho
#while (n_baldosas>=0) 
 #declare m_baldosas=largo_tunel;//numero de baldosas a lo largo
#while (m_baldosas>=0)  

#declare b=int(4*rand(A));
#switch (b)
#case(0) 
#declare superficie=object{superficie_1 scale<1,.8,1>}
#break
#case (1) 
#declare superficie=object{superficie_2 scale<1,.8,1>} 
#break
#case (2) 
#declare superficie=object{superficie_3 scale<1,.8,1>} 
#break
#case (3) 
#declare superficie=object{superficie_4 scale<1,.8,1>} 
#break
#end  
#declare g=rand(A);
//#declare baldosa=object{box{<0,-20,0>,<1,1,1>}}
#declare piedra_baldosa=//union{object{baldosa translate <-.5,-.5,-.5> } 
                              object{superficie translate <-.5,-.5,-.5> scale <1.07,1,1.07> translate 1*y}
                          //    }
                              
#if(pow(-1,n_baldosas)=1)
object{piedra_baldosa  scale <2,1,1>
translate <-2.2*m_baldosas,.01-.02*g,3.03-1.03*n_baldosas>}
#else
object{piedra_baldosa  scale <2,1,1>
     translate <-2.2*m_baldosas,.01-.02*g,3.03-1.03*n_baldosas> translate 1*x} 
#end
 #declare m_baldosas=m_baldosas-1;
#end
#declare n_baldosas=n_baldosas-1;
#end
}
        
#declare bordillo=union{
#declare m_bordillo=largo_tunel;//numero de bordillos a lo largo
#while (m_bordillo>=0)  
#declare d=int(4*rand(A));
#switch (d)
#case(0) 
#declare superficie=object{superficie_1 scale<1,.8,1>}
#break
#case (1) 
#declare superficie=object{superficie_2 scale<1,.8,1>} 
#break
#case (2) 
#declare superficie=object{superficie_3 scale<1,.8,1>} 
#break
#case (3) 
#declare superficie=object{superficie_4 scale<1,.8,1>} 
#break
#end  
#declare h=rand(A);
#declare baldosa_bordillo=object{box{<0,-20,0>,<1,1.1,1>}}
#declare piedra_bordillo=union{
        object{baldosa_bordillo translate <-.5,-.5,-.5>} 
        object{superficie translate <-.5,-.5,-.5> scale <1.07,1,1.07> translate 1.1*y}
        object{superficie translate <-.5,0,-.5> rotate -90*x scale <1.07,1.07,1.07> translate <0,0,-.5>}
        object{superficie translate <-.5,0,-.5> rotate 90*x scale <1.07,1.07,1.07> translate <0,0,-.5>}
         }               

object{piedra_bordillo  scale <2,1,1>
translate <-2.1*m_bordillo,.01-.02*h,0>}
#declare m_bordillo=m_bordillo-1;
#end
}
 /*
 #declare agua=object{box{<50,-3.,-10>,<-100,0,10> hollow on}}
 union{object{agua}  
        #declare n_aguas=0;
        #while(n_aguas<=100)
        object{superficie_6 hollow on translate <-.5,0,-.5> scale <10,2,8> translate -5*n_aguas*x}
        object{superficie_8 hollow on translate <-.5,0,-.5> scale <14,2,8> translate -7*n_aguas*x} 
 
        #declare n_aguas=n_aguas+1;
        #end
 material{textura_agua}}   
*/

#declare agua_1=object{superficie_6 hollow translate <-.5,0,-.5> scale <10,4,10>}
#declare agua_2=object{superficie_7 hollow translate <-.5,0,-.5> scale <10,4,10>} 
#declare agua_3=object{superficie_8 hollow translate <-.5,0,-.5> scale <10,4,10>}
#declare agua_4=object{superficie_5 hollow translate <-.5,0,-.5> scale <10,4,10>}

#declare agua=union{object{agua_2 translate -10*x*1}
                    object{agua_1 translate -10*x*2}
                    object{agua_2 translate -10*x*3}
                    object{agua_3 translate -10*x*4}
                    object{agua_4 translate -10*x*5}
                    object{agua_1 translate -10*x*6}
                    object{agua_2 translate -10*x*7}
                    object{agua_3 translate -10*x*8}
                    object{agua_4 translate -10*x*9}
                    material{textura_agua}
}      

 object{agua}
plane{y,0 material{textura_agua}}




object{bordillo translate 20.5*x translate 4*z texture{textura_bordillo} }
object{bordillo translate 20.5*x translate -4*z texture{textura_bordillo}} 

// object{fila_baldosa rotate -90*y translate <-20,0,-13> texture{textura_baldosa} }

object{fila_baldosa translate 20*x translate 8*z texture{textura_baldosa}  }
object{fila_baldosa translate 20*x translate -8*z texture{textura_baldosa} }
#declare total_alcantarilla=union{
object{alcantarilla translate 6*y texture{textura_alcantarilla}}  
object{pared_lisa_alcantarilla}
}       


 object{total_alcantarilla}
 #include "tuberias.inc"//Tuberias derecha  
 #include "cableado.inc"//cables 

                   
#declare tubos_luz_finos=union{object{cylinder{10*x,-2*largo_tunel*x,.1}}   
                               object{cylinder{10*x,-2*largo_tunel*x,.1}translate .3*y}
                               texture{pigment{Black} finish{phong 1 phong_size 60}}
                               } 
object{tubos_luz_finos translate <0,5,-10.3>}
 object{tubos_luz_finos translate <0,3,-10.3>}
 object{tubos_luz_finos rotate 90*z translate <-28,0,-10.5>}

   
   
   
   
   
//////////////////cosas_nuevas///////////////

#declare tuberia_curva=union{
                               difference{object{torus{1,.35}}
                                  object{box{<-2,-2,-2>,<2,2,0>}}      
                                  object{box{<-2,-2,-2>,<0,2,2>}}
                               }
                             object{cylinder{<1,0,-2>,<1,0,0>,.35}}   
                             translate <-1,0,2> rotate -90*x rotate -90*y }
#declare tuberia_larga=object{cylinder{20*x,-2*largo_tunel*x,.5}}
#declare cuantas_tuberias_curvas=union{
        #declare n_tuberias_curvas=largo_tunel/5;
        #while (n_tuberias_curvas>=0)
        object{tuberia_curva translate -8*x*n_tuberias_curvas translate 1*z}
        #declare n_tuberias_curvas=n_tuberias_curvas-1;
        #end
}

union{object{cuantas_tuberias_curvas translate 1*z}  
      object{tuberia_larga translate 3*y}
      texture{textura_baldosa finish{phong .3}}
      translate 0*y translate -10*z scale <1,1,-1>}   


 


//#include "hombre.pov" 
 
 
 
//////////////////TROZO CURVO DE ALCANTARILLA////////////// 
 

 #declare alcantarilla_curva=union{
#declare n_piedras=31;
#while (n_piedras>=0) 

#declare c=int(4*rand(A));
#switch (c)
#case(0) 
#declare superficie=object{superficie_1}
#break
#case (1) 
#declare superficie=object{superficie_2} 
#break
#case (2) 
#declare superficie=object{superficie_3} 
#break
#case (3) 
#declare superficie=object{superficie_4} 
#break
#end  
                       
#declare cuanto_rota=int(4*rand(A));
//#declare piedra=object{box{<0,-.5,0>,<1,0,1>}}
#declare piedra_alcantarilla=//union{object{piedra translate <-.5,-.5,-.5> } 
                                   object{superficie translate <-.5,-.5,-.5> scale <1.06,1,1.06>}
                               //    }                                 
 object{piedra_alcantarilla rotate(90*cuanto_rota)*y scale <2,1,1>
       rotate -90*x  translate 10*z rotate -5.8*n_piedras*x }
#declare n_piedras=n_piedras-1;
#end
 }      
 

#declare pared_alcantarilla_curva=union{
  #declare n_piedras=5;
  #while (n_piedras>=0)
        #declare c=int(4*rand(A));
#switch (c)
#case(0) 
#declare superficie=object{superficie_1}
#break
#case (1) 
#declare superficie=object{superficie_2} 
#break
#case (2) 
#declare superficie=object{superficie_3} 
#break
#case (3) 
#declare superficie=object{superficie_4} 
#break
#end  

#declare cuanto_rota=int(4*rand(A));
//#declare piedra=object{box{<0,-.5,0>,<1,0,1>}}
#declare piedra_alcantarilla=//union{object{piedra translate <-.5,-.5,-.5> } 
                                object{superficie translate <-.5,-.5,-.5> scale <1.06,1,1.06>}
                               //    }
                         
          object{piedra_alcantarilla  scale <2,1,1> rotate -90*x translate 1*n_piedras*y translate 10*z }                   
        #declare n_piedras=n_piedras-1;
        #end
        }


 #declare total_alcantarilla_curva=union{ 
object{alcantarilla_curva translate 6*y}
object{pared_alcantarilla_curva  } 
 } 
 
#declare fondo=union{ 
#declare n_arcos=30;
#while (n_arcos>=0) 
object{total_alcantarilla_curva translate 20*z rotate -3*n_arcos*y translate -20*z} 
#declare n_arcos=n_arcos-1;
#end }

 object{fondo texture{textura_alcantarilla} translate -2*largo_tunel*x}
  
  
fog
{
  fog_type   2
  distance   70
  color      rgbt <1,.9,.9,.7> // gray
  fog_offset 0
  fog_alt    2
  turbulence 0.8
}
     
/////////////////LUCES techo//////////////////     
 #include "lampara_techo"//lamparas
 object{luces_techo scale .6 translate <5,14,0>}
object{luces_techo scale .6 translate <-14,14,0>}
 object{luces_techo scale .6 translate <-40,14,0>} 
 object{luces_techo scale .6 translate <-70,14,0>} 


//////////////////////OBJETOS/////////////
object{bote scale .05 rotate 10*z translate <-7,-.2,3>}
object{caja  scale .5 rotate -60*y rotate -45*x rotate 30*z translate <-7,0,-1>}  
object{caja  scale .5 rotate -60*y rotate -45*x rotate -30*z translate <-17,-.5,2>}
object{caja scale <.5,.5,.25> translate <-16,1,-6>}
object{caja scale <.5,.5,.25> translate <-14,1,-6.5>}
object{placa translate <-2.2,0,-.5>scale .5 rotate 180*y translate<-17,2.8,-10.3>}   
object{tablon rotate -10*z rotate 10*y translate <-11,0,2>}
 object{periodico  scale .5 rotate 10*y translate <-7,.69,4>}  
//object{tapa_alcantarilla translate <-11,1.3,-6>}
object{entrada_alcantarilla}     
object{rata_alcantarilla scale .02 translate <-12,0.5,-6>}  
object{rata_alcantarilla rotate 85*y scale .02 translate <-14,1.5,-6.5>}
object{rata_alcantarilla rotate -85*y scale .02 translate <-14,.6,-5>}
object{rata_alcantarilla rotate 45*y scale .02 translate <-10,.6,-5>}  
object{rata_alcantarilla scale .02 translate <-12,0.5,6>}  
object{rata_alcantarilla rotate 85*y scale .02 translate <-13,.6,6.5>}
object{rata_alcantarilla rotate -85*y scale .02 translate <-15,.6,5>}
object{rata_alcantarilla rotate 45*y scale .02 translate <-12,.6,4>} 
object{rata_alcantarilla scale .02 translate <-22,0.5,6>}  
object{rata_alcantarilla rotate 85*y scale .02 translate <-24,1.5,-5>}
object{rata_alcantarilla rotate -85*y scale .02 translate <-18,.6,-8>}
object{rata_alcantarilla rotate 45*y scale .02 translate <-20,.6,-4>}  
object{rata_alcantarilla scale .02 translate <-12,0.5,6>}  
object{rata_alcantarilla rotate 85*y scale .02 translate <-16,.6,7>}
object{rata_alcantarilla rotate -85*y scale .02 translate <-25,.6,6>}
object{rata_alcantarilla rotate 45*y scale .02 translate <-32,.6,7>}
object{rata_alcantarilla rotate 45*y scale .02 translate <-8,.6,5>}

