   // ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "glass.inc"

 /*
 // create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
} 

camera
{
  location  <0.0 , -2.0 ,-8.0>
  look_at   <0.0 , 0.0 , 0.0>
}
 */  
#declare cuerpo_lampara=union{
        object{cone {0*y,1.5,1*y,.8 open} }
        object{cone {1*y,.8,2*y,.5}}
        object{cylinder{2*y,5*y,.5}} 
        object{cone{0*y,1.5,.1*y,1.4}texture{T_Old_Glass normal{bumps 1 scale .05} }}    
       texture{textura_baldosa}
        }    
#declare pantalla_lampara=difference{
        object{sphere{0,1.4}}
        object{box{<-2,0,-2>,<2,2,2>}}
        scale <1,.3,1>}      
 
#declare lampara_techo=union{
object{cuerpo_lampara}                
object{pantalla_lampara texture{T_Old_Glass normal{bumps 1 scale .05}}}
} 
 
#declare bombilla=union{merge{sphere{0,1} cylinder{<0,0,1>,<0,0,0>,1 scale <.35,.35,1> translate .5*z}
                              texture{pigment{White} finish{ ambient 1 phong 1 phong_size 100}}}
                        cylinder{<0,0,1>,<0,0,0>,1 scale <.4,.4,.5> texture{Brass_Texture} translate 1.5*z
} rotate -90*x scale .5}
 

#declare luz= 
light_source
{
  0*x // light's position (translated below)
  Orange*.4+Red*.4  // light's color
  /*area_light<1,0,0>,<0,1,0>,2,2
  adaptive 1
  jitter */
  looks_like{bombilla}  fade_distance 15  fade_power 2
  translate .45*y
} 


#declare luces_techo=union{object{lampara_techo}   
                           light_source{luz}
}                 