// Persistence of Vision Ray Tracer Scene Description File
// File: BuildingHF.pov
// Vers: 3.1
// Desc: Heightfield generator for buildings


#version 3.1;

#include "colors.inc"  

global_settings
{
  assumed_gamma 1.0 
}

#declare abw = seed(123) ;

camera
{
  location  <0, 2000, 0>
  look_at   <0.0, 0.0,  0.0> 
  orthographic
}

plane { y, 0 pigment {color rgb <0,0,0>}} 
 
#declare loop = 0;

#while (loop <5000)    // loop to generate buildings

   #declare boxx = (3000 * rand(abw) - 1500);
   #declare boxz = (3000 * rand(abw) - 1500);
   #declare height = 10 + rand(abw) * 65; 

   box
   {
     <boxx, 0, boxz>  
     <boxx + 45 * rand(abw) + 15  , height ,  boxz + 45 * rand(abw) + 15>  
     pigment {rgb (height / 75)}
     finish {ambient 1}
   }   
      
   #declare loop = loop + 1; 
   
#end    

