//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 5 materials and 6 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/23/2000    (23.04.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      7.780,       0.000,      30.700>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.500,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <10.77683, -17.817351, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "abwaerial.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

object {   // Roads
  height_field {
    png "C:\Program Files\Moray For Windows\PovScn\Roads_only.png"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    RoadTex
  }
  scale <12.2, 8.8, 0.3>
  rotate -270.0*z
  translate  -0.27*z
}


object {   // Green_areas
  height_field {
    png "C:\Program Files\Moray For Windows\PovScn\Green.png"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    GreenTex
  }
  scale <12.2, 8.8, 0.3>
  rotate -270.0*z
  translate  -0.28*z
}


object {   // River
  height_field {
    png "C:\Program Files\Moray For Windows\PovScn\River.png"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    RiverTex
  }
  scale <12.2, 8.8, 0.3>
  rotate -270.0*z
  translate  -0.28*z
}


plane { // Land
  z,0
  material {
    LandTex
  }
  scale <10.0, 10.0, 1.0>
}


object {   // Buildings
  height_field {
    png "C:\Program Files\Moray For Windows\PovScn\MapHF.png"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    BuildingTex
  }
  no_shadow
  scale <12.2, 8.8, 0.6>
  rotate -270.0*z
  translate  -0.006385*z
}




