// Persistence of Vision Ray Tracer Scene Description File
// File: bath.pov
// Vers: 3.1
// Desc: Bath house & bathers
// Date: 3-22-2000
// Auth: Kane Wagner
// Contributing files: 13_col.inc, lady.inc, John VanSickle's AxisRotate Macro
// Mesh objects: Torch, Curtains, Dome, Dolphin : converted by Crossroads,3ds2pov and 3DWin Converter
// Special Thanks go to my loving wife Annie, Balsam Fir , Juneau , the makers of the above include files and meshes.   


// ==== Includes Files ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"   // Standard Stone Textures
#include "woods.inc"
#include "13_col.inc" // columns

////////// Global Settings ///////////////////

global_settings { ambient_light rgb <1,1,1> } 

/////////// Macros //////////////////////////

#macro AxisRotate(Axis,Angle)
  #local vX=vnormalize(Axis);
  #local vY=vnormalize(vcross(vX,<vX.y,vX.z,-vX.x>));                                                 
  #local vZ=vnormalize(vcross(vX,vY));
  matrix < vX.x,vY.x,vZ.x, vX.y,vY.y,vZ.y, vX.z,vY.z,vZ.z, 0,0,0 >
  rotate y*(Angle)
  matrix < vX.x,vX.y,vX.z, vY.x,vY.y,vY.z, vZ.x,vZ.y,vZ.z, 0,0,0 >
#end 

////////////// Light Sources///////////

//  light_source {< -1000, 100, -1000>  color White }
//  light_source {< 0, 4, 0>  color White }
  light_source {<20,1000,0> color White}

///////// Cameras /////////////////

camera {location  <-10.0, 15.0, 0.0> look_at   <5.0, 0.0,  40.0>} //good view
//camera {location  <0.0, 5.0, 30.0> look_at   <-10.0, 3.0,  40.0>} // good view of toweling bather & a dolphin
//camera {location  <0.0, 200.0, 0.0> look_at   <0.0, 3.0,  0.0>} // standard
  
//////// Texture Declarations /////////////////

#declare Fire =
  texture {
    pigment {
        wood
        color_map {
            [ 0.000 rgb <1.000, 1.000, 1.000> ] 
            [ 0.080 rgbf <0.980,1.000,0.016,0.08> ] 
            [ 0.290 rgbf <1.000,0.737,0.012,0.40> ] 
            [ 0.530 rgbf <1.000,0.157,0.008,0.67> ] 
            [ 0.790 rgbf <1.000,1.000,1.000,1.00> ] 
            [ 1.000 rgbf <1.000,1.000,1.000,1.00> ] 
        }
        turbulence <0.200, 0.200, 0.200>
        omega 0.800
        scale <3.000, 7.500, 3.000>
    }
    finish {
        ambient <1.000, 1.000, 1.000 >
    }
    translate <0.000, 0.000, -6.000>
}

#declare Water =
  texture {
    pigment{ color Clear 0.9}//rgbf <0.0, 0.0, 1.0, 0.9> }
    normal {
        ripples 0.1//75
        frequency 5
    }
    finish {
        reflection 0.3
  #version -1.0;
        refraction 0.5
        ior 1.33
    }
#version 3.1;
}

#declare Gold_Texture =
  texture {
    pigment {
        rgb <0.850,0.850,0.100>
    }
    finish {
        roughness 0.1
        specular 0.8
        brilliance 8
        reflection 0.15
        diffuse 0.7
        ambient 0.3
    }
}

#declare Cloth_Texture = texture {
    pigment {
        color rgb < 0.900, 0.300, 0.200 >
    }
    finish {
        ambient < 0.200, 0.200, 0.200 >
        diffuse 0.6
        phong .40
        phong_size 15
    }
  }
  texture {
    pigment {
        marble
        color_map {
            [0.00 color White]//[ 0.00 rgb < 0.900, 0.680, 0.400 > ]
            [0.30 color White]//[ 0.30 rgb < 0.900, 0.500, 0.500 > ]
            [0.30 color White]//[ 0.30 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
            [1.00 color White]//[ 1.00 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
        }
        rotate < 45.000, 0.000, 0.000 >
        scale < 0.100, 0.100, 5.000 >
        turbulence < 0.200, 0.200, 0.200 >
    }
    normal {
        bumps .6
        scale < 0.050, 0.050, 0.050 >
    }
  }
  texture {
    pigment {
        marble
        color_map {
            [0.00 color White]//[ 0.00 rgb < 0.900, 0.680, 0.400 > ]
            [0.30 color White]//[ 0.30 rgb < 0.900, 0.500, 0.500 > ]
            [0.30 color White]//[ 0.30 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
            [1.00 color White]//[ 1.00 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
        }
        rotate < -45.000, 0.000, 0.000 >
        scale < 0.100, 0.100, 5.000 >
        turbulence < 0.200, 0.200, 0.200 >
    }
    normal {
        bumps .6
        scale < 0.050, 0.050, 0.050 >
    }
}

#declare floor_texture = texture{T_Grnt10}
#declare ceiling_texture = texture{T_Stone23}
#declare marble_texture = texture{T_Stone17}  
#declare Material__17 = texture {Cloth_Texture}
#declare Material__12 = texture {P_WoodGrain18B}
#declare Material__15 = texture {Gold_Texture}
#declare dome_texture = texture{P_WoodGrain18B}
#declare glass_texture = pigment {color Clear}

//////////// Object Declarations ///////////////
#declare dome = union {
  #include "dome.inc"}

////////// Curtains //////////////
#declare curtains = union {
  #include "curtain1.inc"}


//////// Door Ways  /////////////////
#declare door_way = union {
  box { <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate <0.0, 0.0, 10.0>
    translate <5.0, 0.0, 0.0>}
  box { <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 6.0, 1.0>
    rotate <0.0, 0.0, -10.0>
    translate <-5.0, 0.0, 0.0>}
  box { <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 1.0, 1.0>
    translate <0.0, 5.0, 0.0>}
  box { <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 1.0, 1.0>
    translate <0.0, -6.0, 0.0>}
  }
#declare door_hole =         // negative for door way
box { <-1, -1, -1>, <1, 1, 1>
  scale <5.0, 5.5, 2.0>}  

#declare border1 = 
box {<-1,-1,-1><1,1,1> 
  scale <10,1,5> 
  texture {floor_texture}
  translate <0,-.5,-15.5>}

#declare border = union {
  object {border1}
  object {border1
    AxisRotate(/*x+y+z*/x,45)}
  object {border1
    AxisRotate(/*x+y+z*/x,90)}
  object {border1
    AxisRotate(/*x+y+z*/x,135)}
  object {border1
    AxisRotate(/*x+y+z*/x,180)}
  object {border1
    AxisRotate(/*x+y+z*/x,225)}
  object {border1
    AxisRotate(/*x+y+z*/x,270)}
  object {border1
    AxisRotate(/*x+y+z*/x,315)}  
}

#declare border2 =       // border around small_bath_ceiling
box {<-1,-1,-1><1,1,1> 
  scale <10,1,5> 
  texture {ceiling_texture}
  translate <0,-.5,-15.5>}

#declare border3 = union {
  object {border2}
  object {border2
    AxisRotate(/*x+y+z*/x,45)}
  object {border2
    AxisRotate(/*x+y+z*/x,90)}
  object {border2
    AxisRotate(/*x+y+z*/x,135)}
  object {border2
    AxisRotate(/*x+y+z*/x,180)}
  object {border2
    AxisRotate(/*x+y+z*/x,225)}
  object {border2
    AxisRotate(/*x+y+z*/x,270)}
  object {border2
    AxisRotate(/*x+y+z*/x,315)}  
}

///////////  Dolphin Fountain /////////////
#declare dolphin1 = union {
#include "dolphin1.inc"}

#declare dolphin = union {
  object {dolphin1
    rotate <0,-65,0>
    scale .014125
    translate <22,1,45>}
  sphere { <0, .75, 0> 1.5 texture {marble_texture} translate <20,1.5,47>}
}
////////////////  Small Baths  ///////////////

#declare side = box {<-1,-1,-1><1,1,1> scale <5,1,1> translate <0,0,-11>}
#declare step1 = union {
  object {side}
  object {side
    AxisRotate(/*x+y+z*/x,45)}
  object {side
    AxisRotate(/*x+y+z*/x,90)}
  object {side
    AxisRotate(/*x+y+z*/x,135)}
  object {side
    AxisRotate(/*x+y+z*/x,180)}
  object {side
    AxisRotate(/*x+y+z*/x,225)}
  object {side
    AxisRotate(/*x+y+z*/x,270)}
  object {side
    AxisRotate(/*x+y+z*/x,315)}  
}          
#declare step2 = union {
  object {step1}
  object {step1
    translate <0,-1,0>
    scale .85}
  box {<-1,-1,-1><1,1,1> scale <10,1,10> translate <0,-2.5,0>}
    texture {marble_texture}
}

#declare step3 = union {
  object {step1}
  object {step1 translate <0,-1,0> scale .85}
  box {<-1,-1,-1><1,1,1> scale <10,1,10> translate <0,-2.5,0>}
    texture {marble_texture}
}

#declare small_bath_ceiling = union {
  object {step3}
  object {border3}
}  
 
#declare small_bath = union {
object {step2}
object {border}
}

//////////  Columns  /////////////
#include "torch.inc"  
#declare column = union {
  object {column_doric
    scale 10}
  object {torch
    rotate <-90,-90,0> scale .009375 translate <0,15,-4>}  
//  light_source {< 0, 15, -4.5>  color White fade_distance 1 fade_power 2}
//  light_source {< 0, 16, -5>  color Yellow fade_distance .5 fade_power 1}
//  light_source {< 0, 16, -5>  color Blue fade_distance .5 fade_power 1}    
}    
#declare dome_rim = union {
  box {<-1,-1,-1><1,1,1> scale <23,1,2> translate <0,25.5,54.85> texture {marble_texture}}
  box {<-1,-1,-1><1,1,1> scale <30,1,3> translate <0,27.5,60> texture {marble_texture}}
}    
// SPRAY OPTIONS
   #declare spray_location = <1, 1, 1>;
   #declare spray_direction = -z -(x/2);
   #declare spray_strength = 2;
   #declare spray_angle = 0;
   #declare spray_loop = true;

   #declare particle_life = 1.5;
   #declare particle_count = 300;
   #declare particle_size = 1;
   #declare particle_stretch = 1;
   #declare particle_dist = 18;
   #declare particle_sep = 1.5;

   #declare nozzle_width = .0025;
   #declare nozzle_angle = 0;

   #declare spray_turb = .1;
   #declare spin_turb = 10;

   #declare use_blob = true;
   #declare spray_texture = texture {//Water}
      pigment {rgbt <.9, .9, 1, .6>}
      finish {phong .2 phong_size 1}}

// CREATE SPRAY OBJECT
#declare water_fall = union { // water spouting out of dolphins
   #include "Spray.inc"}
   
#declare bnch = difference {  // cylinders for bench makings
  cylinder {<0,0,0>,<0,1,0>, 10 texture {marble_texture}}
  cylinder {<0,-.5,0>,<0,1.5,0>, 5 texture {marble_texture}}
}

#declare negative = union {       // negative to bench makings
box {<-1,-1,-1><1,1,1> scale <5,2,10> translate <5,0,0>} 
box {<-1,-1,-1><1,1,1> scale <10,2,5> translate <0,0,5>}
}
#declare bnch_top = difference {    // bench makings
object {bnch}
object {negative}
}

#declare bench = union {  // benches
object {bnch_top}
box {<-1,-1,-1><1,1,1> scale <.25,1,2> texture{marble_texture} translate <0,-.5,-7.5> rotate <0,22.5,0>}
box {<-1,-1,-1><1,1,1> scale <.25,1,2> texture{marble_texture} translate <0,-.5,-7.5> rotate <0,67.5,0>} 
rotate <0,135,0>}
/////////  Walls //////////////
#declare walls = union {          // outer walls
  box {<-1,-1,-1><1,1,1> scale <45,1,2> texture {marble_texture} translate <0,0,100>}
  difference {
     box {<-1,-1,-1><1,1,1> scale <45,15,1> texture {ceiling_texture} translate <0,15,100>}
     object {door_hole translate <0,6.5,100>}}
  object{door_way translate <0,6.25,99> texture {Gold_Texture}}   
}

#declare ceiling = union {
  object {small_bath_ceiling translate <0,0,-80>}
  box{<-1,-1,-1><1,1,1> scale <15,1,20> translate <26,-.5,-80> texture {ceiling_texture}} // ceiling filler
  box{<-1,-1,-1><1,1,1> scale <15,1,20> translate <-26,-.5,-80> texture {ceiling_texture}}// ceiling filler
  box {<-1,-1,-1><1,1,1> scale <30,1,10> translate <0,-.5,-57> texture {ceiling_texture}}  // ceiling around outside of bath
  box {<-1,-1,-1><1,1,1> scale <25,3,25> translate <0,-2.75,-80> texture {ceiling_texture}}  
}
                    
#declare all_curtains = union {
  object {curtains scale <.086,.05,.075> rotate <-90,0,0>translate <0,12.20,55>}  // Inner ring of curtains
  object {curtains scale <.097,.05,.075> rotate <-90,22.5,0>translate <21,12.20,51>} // Inner ring of curtains - angled
  object {curtains scale <.15,.05,.075> rotate <-90,0,0>translate <0,12.20,95>}  // Outer ring of curtains
  object {curtains scale <.065,.05,.075> rotate <-90,0,0>translate <22,12.20,95>}  // Outer ring of curtains  
  object {curtains scale <.065,.05,.075> rotate <-90,0,0>translate <-22,12.20,95>}  // Outer ring of curtains  
  object {curtains scale <.0675,.05,.075> rotate <-90,22.5,0>translate <38,12.20,92>} // Outer ring of curtains - angled
}


//////// All columns along one side of room /////////////////
#declare bath_columns = union { 
  object {column translate <10.5,.5,55>} // inner column
  object {column translate <-10.5,.5,55>}// inner column
  object {column translate <15,.5,95>} // outer column
  object {column translate <-15,.5,95>}// outer column
  object {column translate <30,.5,95>} // outer column
  object {column translate <-30,.5,95>}// outer column 
}

// bath rim
#declare rim = union {
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,0,47> texture {marble_texture}} //original rim around bath
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,-1,46> texture {marble_texture}} // step
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,-2,45> texture {marble_texture}} // step
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,-3,44> texture {marble_texture}} // step
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,-4,43> texture {marble_texture}} // step
  box {<-1,-1,-1><1,1,1> scale <20,1,1> translate <0,-5,42> texture {marble_texture}} // step
  box {<-1,-1,-1><1,1,1> scale <30,1,10> translate <0,-.5,57> texture {floor_texture}}  // floor around outside of bath
  object {dolphin} // dolphins around central pool
  object {dome_rim} // rim around top of columns, below dome
  object {all_curtains} // All curtains on one side of room
  object {bath_columns}   //////// All columns on one side of room
  object {water_fall scale .25 translate <18,2.75,43> } // water spouting from dolphins     
  box{<-1,-1,-1><1,1,1> scale <15,1,20> translate <26,-.5,80> texture {floor_texture}} // floor filler
  box{<-1,-1,-1><1,1,1> scale <15,1,20> translate <-26,-.5,80> texture {floor_texture}}//floor filler  
  object {small_bath translate <0,0,80>} // outer ring of baths
  box {<-1,-1,-1><1,1,1> scale <12,3,12> translate <0,-2.75,80> texture {Water}} //water in small baths 
  object {bench translate <15,2.25,55>}  // benches
  object {bench translate <-15,2.25,55>} // benches 
  object {walls} // outer walls
  object {ceiling  rotate <180,0,0> translate <0,27,0>} // ceiling 
light_source {< 10, 17, 53>  color Orange fade_distance 5 fade_power 2}
light_source {< -10, 17, 53>  color Orange fade_distance 5 fade_power 2}
light_source {< 15, 17, 93>  color Orange fade_distance 5 fade_power 2}
light_source {< -15, 17, 93>  color Orange fade_distance 5 fade_power 2}
light_source {< 30, 17, 93>  color Orange fade_distance 5 fade_power 2}
light_source {< -30, 17, 93>  color Orange fade_distance 5 fade_power 2}
light_source {< -50, 17, 43>  color Orange fade_distance 5 fade_power 2}
}

  
#declare central_bath = union {
  object {rim}
  object {rim
    AxisRotate(x,45)}
//  object {rim
//    AxisRotate(x,90)}
//  object {rim
//    AxisRotate(x,135)}
//  object {rim
//    AxisRotate(x,180)}
//  object {rim
//    AxisRotate(x,225)}
//  object {rim
//    AxisRotate(x,270)}
  object {rim
    AxisRotate(x,315)}  
}



/////////////// objects in scene //////////////////
object {central_bath}  // central pool
box {<-1,-1,-1><1,1,1> scale <60,1,60> translate <0,-1,0> texture {Water}} // water in large pool
box {<-1,-1,-1><1,1,1> scale <60,1,60> translate <0,-7,0> texture {marble_texture}}  // pool floor
object {dome rotate <-90,0,0> scale <.52,.25,.52> translate <0,26.5,0>} // Large wood and glass dome over central pool

#include "skies.inc"
  sky_sphere{S_Cloud5}

//////  Bathing People ///////////////
#include "bh_people.inc"
object{bather1 translate <0,-.75,44>} // relaxing bather
object{bather0 translate <10,1.5,48>} // face down and leg up
object{bather2 translate <12,-.175,30>} // out in middle, model pose
object {bather3 translate <-15,7,48>} // towling off
