// Persistence of Vision Ray Tracer Scene Description File
// File: ladyinc_sample.pov
// Vers: 3.1
// Desc: Pose Examples of Lady.inc
// Date: july/15/1999
// Auth: Yasunari Iwanaga
//

//#version 3.1;
//#include "colors.inc"
//#include "corel.inc"
global_settings { assumed_gamma 1.8}

//----------------------------------------------
//light_source
//{
// 0*x // light's position (translated below)
//  color red 1.0  green 1.0  blue 1.0  // light's color
//  translate <2, 10, -30>
//}

//--------- Body pats angle---------------------
//#declare Sample_Num = 4 ; // Smaple Pose Number ( 0 ~ 4 )
#declare C70Black  = color red 0.3  green 0.3  blue 0.3
//#switch ( Sample_Num )
//	#case (0) // prone
	#declare bather0 = union {
		#declare LadyTexture2 =
	          texture{pigment {color Tan}}
                #declare BreastTexture =
	          texture{pigment {color DarkTan}}
                #declare Material__6 = texture {
                  finish {ambient 0.10}
                  pigment { color White }}
                #declare liptex = texture{pigment{color Pink}}
		#declare Head_angle =
		array[1][3]
		{
			{0, -80, 0}
		}
		
		#declare Neck_angle =
		array[1][3]
		{
			{-50, 0, 0}
		}
		
		#declare Body_angle =
		array[2][3]
		{
			{ 30, 0, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_L_angle =
		array[3][3]
		{
			{ 0, 80, 0},
			{ -90, 95, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_R_angle =
		array[3][3]
		{
			{ 0, 80, 0},
			{ -90, 95, 0},
			{ 0, 0, 0}
		}
		#declare HandFinger_L_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0, 0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare HandFinger_R_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0, 0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare Leg_L_angle =
		array[3][3]
		{
			{5, 0, 0}, // Upper Leg angle[-150 < X < 90]{Y][Z]
			{0, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{-70, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare Leg_R_angle =
		array[3][3]
		{
			{5, 0, 0}, // Upper Leg angle[X]{Y][Z]
			{90, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{-50, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare FootFinger_L_angle = 0;
		#declare FootFinger_R_angle = 0;
		
		object { #include "lady.inc" rotate <-90,90,-2>}}
//	object {bather0}
//		camera {
//			location  <10.0, 0.0,0.0>
//			look_at   <0.0, 0.0,  0.0>
			//angle 30
			//right 4/3*x
//		}
//	#break
//	#case (1) // Relaxing
	#declare bather1 = union {
		#declare LadyTexture2 =
	          texture{pigment {color Tan}}
                #declare BreastTexture =
	          texture{pigment {color DarkTan}}
                #declare Material__6 = texture {
                  finish {ambient 0.10}
                  pigment { color C70Black }}
                #declare liptex = texture{pigment{color Pink}}
		#declare Head_angle =
		array[1][3]
		{
			{-10, 0, 0}
		}
		
		#declare Neck_angle =
		array[1][3]
		{
			{-20, 0, 0}
		}
		
		#declare Body_angle =
		array[2][3]
		{
			{ -30, 0, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_L_angle =
		array[3][3]
		{
			{ -20, -40, 0},
			{ -90, 95, 0},
			{ 0, 40, 0}
		}
		
		#declare Arm_R_angle =
		array[3][3]
		{
			{ -20, -40, 0},
			{ -90, 95, 0},
			{ 0, 40, 0}
		}
		#declare HandFinger_L_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 40, 0, 0}, // 2nd finger
			{0, 40, 0, 0}, // 3rd finger
			{0, 40, 0, 0}, // 4th finger
			{0, 40, 0, 0}  // 5th finger
		}
		
		#declare HandFinger_R_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 40, 0, 0}, // 2nd finger
			{0, 40, 0, 0}, // 3rd finger
			{0, 40, 0, 0}, // 4th finger
			{0, 40, 0, 0}  // 5th finger
		}
		
		#declare Leg_L_angle =
		array[3][3]
		{
			{20, 0, 5}, // Upper Leg angle[-150 < X < 90]{Y][Z]
			{30, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare Leg_R_angle =
		array[3][3]
		{
			{20, 0, 5}, // Upper Leg angle[X]{Y][Z]
			{30, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare FootFinger_L_angle = 0;
		#declare FootFinger_R_angle = 0;
		
		object { #include "lady.inc" rotate <50,0,0>}}
//	object {bather1}
//		camera {
//			location  <10.0, 10.0,-10.0>
//			look_at   <0.0, 0.0,  0.0>
			//angle 30
			//right 4/3*x
//		}
//	#break
//	#case (2) // Model Pose
	#declare bather2 = union {
		#declare LadyTexture2 =
	          texture{pigment {color Tan}}
                #declare BreastTexture =
	          texture{pigment {color DarkTan}}
                #declare Material__6 = texture {
                  finish {ambient 0.10}
                  pigment { color DarkBrown }}
                #declare liptex = texture{pigment{color Pink}}		
		#declare Head_angle =
		array[1][3]
		{
			{20, 0, 0}
		}
		
		#declare Neck_angle =
		array[1][3]
		{
			{10, 0, 0}
		}
		
		#declare Body_angle =
		array[2][3]
		{
			{ 0, 0, 15},
			{ 0, 0, -10}
		}
		
		#declare Arm_L_angle =
		array[3][3]
		{
			{ 90, 10, 0},
			{ -45, 150, 0},
			{ 0, -15, 0}
		}
		
		#declare Arm_R_angle =
		array[3][3]
		{
			{ 90, 10, 0},
			{ -45, 150, 0},
			{ 0, -15, 0}
		}
		#declare HandFinger_L_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0, 0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare HandFinger_R_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0, 0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare Leg_L_angle =
		array[3][3]
		{
			{30, -15, 15}, // Upper Leg angle[-150 < X < 90]{Y][Z]
			{50, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, -10, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare Leg_R_angle =
		array[3][3]
		{
			{0, 0, -15}, // Upper Leg angle[X]{Y][Z]
			{0, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare FootFinger_L_angle = 30;
		#declare FootFinger_R_angle = 0;
		
		object { #include "lady.inc"  rotate <0,45,0>}}
//	object{bather2}	
//		camera {
//			location  <0.0, 0.0, -30.0>
//			look_at   <0.0, -0.5,  0.0>
			//angle 30
			//right 4/3*x
//		}
//	#break
//	#case (3) // Toweling off
	#declare bather3 = union {
		#declare LadyTexture2 =
	          texture{pigment {color Tan}}
                #declare BreastTexture =
	          texture{pigment {color DarkTan}}
                #declare Material__6 = texture {
                  finish {ambient 0.10}
                  pigment { color Yellow }}
                #declare liptex = texture{pigment{color Pink}}
                #declare towel = cylinder {<0,0,0>, <1,0,0>, 1 
                   scale <1.5,1.75,.5> 
                   pigment {color White} 
                   translate <-2,-1.25,.5> 
                   rotate <0,-90,0>}		
		#declare Head_angle =
		array[1][3]
		{
			{0, 0, 0}
		}
		
		#declare Neck_angle =
		array[1][3]
		{
			{0, 0, 0}
		}
		
		#declare Body_angle =
		array[2][3]
		{
			{ -60, 0, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_L_angle =
		array[3][3]
		{
			{ -40, 80, -40},
			{ -30, 50, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_R_angle =
		array[3][3]
		{
			{ 0, 60, -40},
			{ -30, 50, 0},
			{ 0, 0, 0}
		}
		#declare HandFinger_L_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0, 0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare HandFinger_R_angle =
		array[5][4]
		{
			{0, 0, 0, 0}, // 1st finger
			{0, 0, 0, 0}, // 2nd finger
			{0, 0, 0, 0}, // 3rd finger
			{0,0, 0, 0}, // 4th finger
			{0, 0, 0, 0}  // 5th finger
		}
		
		#declare Leg_L_angle =
		array[3][3]
		{
			{0, 0, 0}, // Upper Leg angle[-150 < X < 90]{Y][Z]
			{0, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare Leg_R_angle =
		array[3][3]
		{
			{95, 0, 0}, // Upper Leg angle[X]{Y][Z]
			{85, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{0, 0, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare FootFinger_L_angle = 0;
		#declare FootFinger_R_angle = 0;
		object {towel rotate <-10,-8,0> translate <-.25,0,0>}
		object { #include "lady.inc" }rotate <0,45,0>}
//	object {bather3}
	
//		camera {
//			location  <10.0, 0.0, -10.0>
//			look_at   <0.0, 0.0,  0.0>
			//angle 30
			//right 4/3*x
//		}
//	#break
//	#case (4) // Miroku Pose
	#declare bather4 = union {
		#declare LadyTexture2 =
	          texture{pigment {color Tan}}
                #declare BreastTexture =
	          texture{pigment {color DarkTan}}
                #declare Material__6 = texture {
                  finish {ambient 0.10}
                  pigment { color White }}
                #declare liptex = texture{pigment{color Pink}}
	        #declare Left_eye_angle = -90
	        #declare Right_eye_angle = 90
		#declare Head_angle =
		array[1][3]
		{
			{0, 0, 0}
		}
		
		#declare Neck_angle =
		array[1][3]
		{
			{-5, 0, 0}
		}
		
		#declare Body_angle =
		array[2][3]
		{
			{ -20, 0, 0},
			{ 0, 0, 0}
		}
		
		#declare Arm_L_angle =
		array[3][3]
		{
			{ 0, 30, -85},
			{ 0, 25, 0},
			{ 0, 20, 0}
		}
		
		#declare Arm_R_angle =
		array[3][3]
		{
			{ 0, 30, -85},
			{ 0, 25, 0},
			{ 0, 20, 0}
		}
		#declare HandFinger_L_angle =
		array[5][4]
		{
			{0, 0, 45, 0}, // 1st finger
			{40, 60, 15, 0}, // 2nd finger
			{5, 0, 15, 0}, // 3rd finger
			{5, 0, 20, 0}, // 4th finger
			{10, 0, 0, 0}  // 5th finger
		}
		
		#declare HandFinger_R_angle =
		array[5][4]
		{
			{0, 0, 45, 0}, // 1st finger
			{40, 60, 15, 0}, // 2nd finger
			{30, 15, 5, 0}, // 3rd finger
			{45, 20, 0, -5}, // 4th finger
			{20, 0, 0, -5}  // 5th finger
		}
		
		#declare Leg_L_angle =
		array[3][3]
		{
			{80, 40, 0}, // Upper Leg angle[-150 < X < 90]{Y][Z]
			{150, -105, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{-30, -60, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare Leg_R_angle =
		array[3][3]
		{
			{80, 40, 0}, // Upper Leg angle[X]{Y][Z]
			{150, 105, 0}, // Lower Leg angle[X]{Y not used][Z not used]
			{-30, -60, 0}  // Foot angle[X][Y][Z]
		}
		
		#declare FootFinger_L_angle = 0;
		#declare FootFinger_R_angle = 0;
		
		object { #include "lady.inc"}
		}
//		object {bather4}
//		camera {
//			location  <0.0, 0.0, -15.0>
//			look_at   <0.0, -0.5,  0.0>
			//angle 30
			//right 4/3*x
//		}
//	#break
//	#else
//#end
