// Persistence of Vision Ray Tracer Scene Description File
// File: lady.inc (ver 0.1a)
// Vers: 3.1
// Desc: object of lady`s body
// Date: July/19/1999
// Auth: Yasunari Iwanaga (Japan)
// E-Mail: iwaentcl@po.saganet.ne.jp
// Home Page: http://yasucg.site.ne.jp/

// Using include files: hand.inc, headparts.inc

#ifndef (Left_eye_angle) #declare Left_eye_angle = -65  #end
#ifndef (Right_eye_angle) #declare Right_eye_angle = 65 #end


//#include "eyeball.inc"
#version 3.1;

//--------- Texture Check ---------------------------

/*#declare LadyTexture2 =
	texture{
	      pigment {image_map {tga "asia.tga" }
	      rotate <0,0,0>
	      translate <0,.5,0>
}	      scale 7}
#declare LadyTexture =
	texture{
		pigment { color Flesh }
		finish  {
			ambient color rgb < 0.457771, 0.457771, 0.457771 > 
			phong 0.0
			phong_size 40
		}
	}
 



#declare LadyTextur1 =
	texture{
		  pigment { rgb 1      }
  finish  { ambient .4 diffuse .3 reflection .18}
  translate <-7,0,-4.6>}

*/	
//--------- Check body parts angle---------------------
#ifndef (Head_angle)
	#declare Head_angle =
	array[1][3]
	{
		{0, 0, 0} // Head angle [-10 < X < 30][-90 < Y < 90][-10 < Z < 10]
	}
#end 

#ifndef (Neck_angle)
	#declare Neck_angle =
	array[1][3]
	{
		{0, 0, 0} // Neck angle [-40 < X < 30][Y not used][-40 < Z < 40]
	}
#end 

#ifndef ( Body_angle )
	#declare Body_angle =
	array[2][3]
	{
		// Upper Body angle [-40 < X <40][-45 < Y < 45][-45 < Z < 45]
		{ 0, 0, 0},
		// Lower Body angle(lumber) [-150 < X < 20][-45 < Y < 45][-10 <Z< 10]
		{ 0, 0, 0}
	}
#end

#ifndef ( Arm_L_angle )
	#declare Arm_L_angle =
	array[3][3]
	{
		{ 0, 0, -85}, // Upper Arm angle [-90 < X < 90][-45 < Y < 135][-135 < Z < 90]
		{ 0, 0, 0}  // Lower Arm angle [-45 < X 45][0 < Y < 150][Z not used]
		{ 0, 0, 0} // Hand angle[X not used][-60 < Y < 90][-45< Z < 30]
	}
#end

#ifndef ( Arm_R_angle )
	#declare Arm_R_angle =
	array[3][3]
	{
		{ 0, 0, -85}, // Upper Arm angle [X][Y][Z]
		{ 0, 0, 0},  // Lower Arm angle [X][Y][Z]
		{ 0, 0, 0}  // Hand angle [X][Y][Z]
	}
#end

#ifndef ( Leg_L_angle )
	#declare Leg_L_angle =
	array[3][3]
	{
		{0, 0, 0}, // Upper Leg angle[-90 < X < 150]{-90 < Y < 10][-30 < Z < 90]
		{0, 0, 0}, // Lower Leg angle[0 < X < 150]{-45 < Y < 45][0 < Z < 90]
		{0, 0, 0}  // Foot angle[-45 < X < 10][-45 < Y < 45][-45 < Z < 60]
	}
#end

#ifndef ( Leg_R_angle )
	#declare Leg_R_angle =
	array[3][3]
	{
		{0, 0, 0}, // Upper Leg angle[X]{Y][Z]
		{0, 0, 0}, // Lower Leg angle[X]{Y not used][Z not used]
		{0, 0, 0}  // Foot angle[X][Y][Z]
	}
#end

#ifndef ( FootFinger_L_angle )
	#declare FootFinger_L_angle = 0; // -45 ~ 90
#end
#ifndef ( FootFinger_R_angle )
	#declare FootFinger_R_angle = 0;
#end

//-------------------------------------------------------------
//------------ Head & Neck ------------------------------------
#declare hair = union {
#include "Femhar.inc"}
#declare hair1 = union {object {hair
   translate <0,-.66,0>
   rotate <5,180,0>
   scale 3}}	
 
   
#include "headparts.inc"
#declare lips = union {
  object {LipUpper}
  object {LipLower}
  }
#declare Head =
union {
	union{
		object { HeadFront }
		object { HeadBack }
		object { Nose }
		object {lips}
		object { Ear }
		object {hair1}
		//object {Left_eye
                //  translate <-1.75,0,-5>
                //  scale .015}
                //object {Right_eye
                //  translate <1.75,0,-5>
                //  scale .015}
	}
	union{
		object { HeadFront }
		object { HeadBack }
		object { Nose }
		object {lips}
		object { Ear }
		object {hair1}
		matrix <
			-1.0, 0.0, 	0.0, 
			0.0, 	1.0, 	0.0, 
			0.0, 	0.0, 	1.0, 
			0.0, 	0.0, 	0.0
		>
	}
	scale 6.8
}



#declare Neck =
blob {
	threshold 0.5
	cylinder { <0,0,0>, <0,0.6,0>, 0.6, 1
		scale <1, 1, 0.7> rotate -5*x translate 0.15*z}
	cylinder { <0,0,0>, <0,0.6,0>, 0.4, 1
		scale <1, 1, 0.8> translate -0.15*z }
}

// ----------------- Body parts-----------------------
// Upper Body 
#declare breast = union {
sphere { 0.0, 1 texture { BreastTexture}} 
sphere { 0.0, 1 texture { BreastTexture}
  scale .25
  translate <0,0,-1>}
sphere { 0.0, 1 texture { BreastTexture}
  scale 5
  translate <0,0,4.5>}}


#declare Body1 =
union {
	#declare Body1a=
	difference {
		blob{
			threshold 0.5
			// Upper chest		
			cylinder { <0,0,0>, <0,1.0,0>, 1, 1
				scale <1.3,0.95,0.8> rotate <10,-10, 0 > }
			// Rib
			cylinder { <0,0,0>, <0,0.7,0>, 1, 1
				scale <0.7,0.6,0.5> rotate <10,0,-15> translate <0.3, 0.2, -0.20> }
			// Lower chest
			cylinder { <0,0,0>, <0,1.0,0>, 1, 1
				scale <0.55,0.5,0.6> translate <0.2,-0.6, -0.10> }
			//manma
//			sphere { <0,0,0>, 1, 1
//				scale <0.48,0.6,0.4> rotate <20,-5,0> translate <0.38, 0.35, -0.50> }
			sphere { <0,0,0>, 1, 1
				scale <0.45,0.6,0.4> rotate <20,-5,0> translate <0.38, 0.35, -0.50> }
			sphere { <0,0,0>, 0.42, 1
				scale <1,1,0.5> rotate <0,-15,0> translate <0.4, 0.25, -0.52> }

                        // sholder1
			sphere { <0,0,0>, 1, 1
				scale <0.6, 0.5, 0.4>
				translate < 0.7, 0.9, 0.2 >
			}
			// sholder2
			cylinder { <0, 0, 0>, <0, 0.4, 0>, 0.3, 1
				scale <0.7, 1, 0.6>
				rotate <0,0,70>
				rotate <Head_angle[0][0]/3,0,70>
			}
			// armpit
			sphere { <0,0,0>, 1, -1
				scale <0.5, 1.0, 0.7>
				rotate -0*z
				translate < 1.1, 0.8, 0.3 >
			}
			// clavicle
			cylinder { <0, 0, 0>, <0.35, 0, 0 >, 0.3, -1
				scale <1, 0.5, 1.4> rotate <-25,-5, 5> translate <0.0, 1.2, -0.25 > }
		}
		plane { x, 0 }
	}
	//
	object { Body1a }
	object {breast
	  scale .025
	  translate <0.38,0.3,-.75>}
	object {breast
	  scale .025
	  translate <-0.38,0.3,-.75>}	  
	object { Body1a
		matrix 
    <-1, 0, 0,
    0, 1, 0,
    0, 0, 1,
    0, 0, 0 >
	}
	scale <1.1,1.0,1.1>
}

#declare Body2 =
blob{
	threshold 0.5
	// main 
	cylinder { <0,0.5,0>, <0,0.95,0>, 1, 1 scale <1.05, 0.95, 0.85> }
	sphere { <0,0,0>, 1, 1 scale < 1.0, 0.75, 0.7> translate <0, 0.4, 0.10> }
	sphere { <0,0,0>, 1, 1 scale <0.5, 0.8, 0.5 > translate <0, 0, 0 > texture {Material__6}}
	scale <1.15, 1.2, 1.0>
	
}


//------------------- Arm Parts -------------------
// Left Arm
#declare Arm_Upper_L =
blob {
	threshold 0.5
	sphere { <0, 0, 0> 0.6, 1 // sholder joint
		scale <1.0, 0.8, 0.9>
		rotate 45*z
		translate <0,-0,0>
	}
	cylinder { <0.0, 0, 0>, <1.55, 0, 0>, 0.35, 1
		scale <1, 1, 1>
	}
	sphere { <0, 0, 0>, 0.4, 1
		scale <2.0, 1, 1> translate 0.6*x
	}
}

#declare Arm_Lower_L =
blob {
	threshold 0.5
	cylinder { <0, 0, 0 >, <1.5, 0, 0>, 0.28, 1
		scale <1, 1, 0.7>}
	sphere { <0, 0, 0>, 0.4, 1 scale <2.0, 1, 1> translate 0.6*x }
	cylinder { <0,0,0>, <0.6, 0, 0>, 0.24, 1 }
}

#declare Arm_L =
union {
	#ifdef ( HandFinger_L_angle )
		#declare Finger_Joint_angle = HandFinger_L_angle
	#end
	#include "hand.inc"
	object { Arm_Upper_L }
	union {
		object { Arm_Lower_L }
		object { Hand scale 0.45
			rotate <-90,-90,0>
			rotate <90, Arm_L_angle[2][1], Arm_L_angle[2][2]>
			translate <1.625, 0.03, 0>
		}
		rotate <Arm_L_angle[1][0], Arm_L_angle[1][1], 0>
		translate 1.6*x
	}
	#declare Arm_L_Rotate =
		<Arm_L_angle[0][0], Arm_L_angle[0][1], Arm_L_angle[0][2]>;
	rotate Arm_L_Rotate
	// joint slide
	#declare Global_P = vrotate(<1, 0, 0>, Arm_L_Rotate);
	#if (Global_P.y <= 0)
		translate < 0.1, 0.11, 0>*<1-Global_P.x, Global_P.y, 0>
	#else
		translate <-0.1, 0.11, 0>*<1-Global_P.x, Global_P.y, 0>
	#end
	// sholder joint position
	translate < 0.86, 1.06, 0.2>
}

// Right Arm
#declare Arm_Upper_R =
blob {
	threshold 0.5
	sphere { <0, 0, 0> 0.6, 1 // sholder joint
		scale <1.0, 0.8, 0.9>
		rotate 45*z
		translate <0,-0,0>
	}
	cylinder { <0.0, 0, 0>, <1.55, 0, 0>, 0.35, 1
		scale <1, 1, 1>
	}
	sphere { <0, 0, 0>, 0.4, 1
		scale <2.0, 1, 1> translate 0.6*x
	}
}

#declare Arm_Lower_R =
blob {
	threshold 0.5
	cylinder { <0, 0, 0 >, <1.5, 0, 0>, 0.28, 1
		scale <1, 1, 0.7>}
	sphere { <0, 0, 0>, 0.4, 1 scale <2.0, 1, 1> translate 0.6*x }
	cylinder { <0,0,0>, <0.6, 0, 0>, 0.24, 1 }
}

#declare Arm_R =
union {
	#ifdef ( HandFinger_R_angle )
		#declare Finger_Joint_angle = HandFinger_R_angle
	#end
	#include "hand.inc"
	object { Arm_Upper_R }
	union {
		object { Arm_Lower_R }
		object { Hand scale 0.45
			rotate <-90,-90,0>
			rotate <90, Arm_R_angle[2][1], Arm_R_angle[2][2]>
			translate <1.625, 0.03, 0>
		}
		rotate <Arm_R_angle[1][0], Arm_R_angle[1][1], 0>
		translate 1.6*x
	}
	#declare Arm_R_Rotate =
		<Arm_R_angle[0][0], Arm_R_angle[0][1], Arm_R_angle[0][2]>;
	rotate Arm_R_Rotate
	// joint slide
	#declare Global_P = vrotate(<1, 0, 0>, Arm_R_Rotate);
	#if (Global_P.y <= 0)
		translate < 0.1, 0.11, 0>*<1-Global_P.x, Global_P.y, 0>
	#else
		translate <-0.1, 0.11, 0>*<1-Global_P.x, Global_P.y, 0>
	#end
	// sholder joint position
	translate < 0.86, 1.06, 0.2>
	matrix < // mirror Y axis
		-1.0, 0.0, 	0.0, 
		0.0, 	1.0, 	0.0, 
		0.0, 	0.0, 	1.0, 
		0.0, 	0.0, 	0.0
	>
}


// -- ----------------- Leg Patrs ----------------------------
// -----Lower leg

#declare FJoint_Y = -3.05 ;
#declare Foot_L_angle =
<Leg_L_angle[2][0], Leg_L_angle[2][1], -Leg_L_angle[2][2]>;
#declare Foot_R_angle =
<Leg_R_angle[2][0], Leg_R_angle[2][1], -Leg_R_angle[2][2]>;


#declare Leg_Lower_L =
union {
	blob{
		threshold 0.5
		// main
		cylinder {<0,0,0>, <0, -2.7, 0>, 0.36, 1}
		// musle swelling
		sphere { <0, 0, 0>, 0.59, 1
			scale <1, 2.4, 1>
			translate <-0.02, -0.95, 0.12>
		}
		
		// Foot
		sphere { <0,0,0>, 0.36, 1 // joint
			scale <1., 0.8, 1>
			rotate <0, 0, 0>
			translate <0.0, FJoint_Y+0.08, -0.05>
		}
		cylinder { <0, 0, -0.1>, <0, 0, -0.3>, 0.4, 1 //
			scale <0.6,0.6, 1>
			rotate Foot_L_angle
			translate <-0.01, FJoint_Y, 0>
		}
		cylinder { <0, 0, -0.05>, <0, 0, -0.48>, 0.3, 1
			scale <0.9,0.7, 1>
			rotate Foot_L_angle
			translate <0.05, FJoint_Y-0.08, 0>
		}
		cylinder { <0, 0, -0.5>, <0, 0, -0.75>, 0.3, 1 // side
			scale <0.9, 0.5, 1>
			rotate Foot_L_angle
			translate <0.15, FJoint_Y-0.15, 0>
		}
		cylinder { <0, 0, -0.05>, <0, 0, -0.65>, 0.5, 1 // bottom & heel
			scale <0.9,0.5, 1>
			rotate Foot_L_angle
			translate <0.05, FJoint_Y-0.18,0>
		}
	}
			// ---- Foot finger
	union {
		// 1st finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.2>, 0.16, 1
				rotate <FootFinger_L_angle, -5, 0>
				translate <-0.12, 0, -0.8>}
			sturm
		}
		// 2nd finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.19>, 0.14, 1
				rotate FootFinger_L_angle*x
				translate <0.01, 0.01, -0.8>}
			sturm
		}
		// 3rd finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.17>, 0.13, 1
				rotate FootFinger_L_angle*x
				translate <0.12, 0.005, -0.8>}
			sturm
		}
		// 4th finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.16>, 0.12, 1
				rotate <FootFinger_L_angle, 5, 0>
				translate <0.22, 0, -0.8>}
			sturm
		}
		// 5th finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.15>, 0.11, 1
				rotate <FootFinger_L_angle, 10, 0>
				translate <0.3, 0,-0.8>}
			sturm
		}
		rotate Foot_L_angle
		translate <0, FJoint_Y-0.18, 0>
	}
	rotate 5*z
}

#declare Leg_Lower_R =
union {
	blob{
		threshold 0.5
		// main
		cylinder {<0,0,0>, <0, -2.7, 0>, 0.36, 1}
		// musle swelling
		sphere { <0, 0, 0>, 0.59, 1
			scale <1, 2.4, 1>
			translate <-0.02, -0.95, 0.12>
		}
		
		// Foot
		sphere { <0,0,0>, 0.36, 1 // joint
			scale <1., 0.8, 1>
			rotate <0, 0, 0>
			translate <0.0, FJoint_Y+0.08, -0.05>
		}
		cylinder { <0, 0, -0.1>, <0, 0, -0.3>, 0.4, 1 //
			scale <0.6,0.6, 1>
			rotate Foot_R_angle
			translate <-0.01, FJoint_Y, 0>
		}
		cylinder { <0, 0, -0.05>, <0, 0, -0.48>, 0.3, 1
			scale <0.9,0.7, 1>
			rotate Foot_R_angle
			translate <0.05, FJoint_Y-0.08, 0>
		}
		cylinder { <0, 0, -0.5>, <0, 0, -0.75>, 0.3, 1 // side
			scale <0.9, 0.5, 1>
			rotate Foot_R_angle
			translate <0.2, FJoint_Y-0.15, 0>
		}
		cylinder { <0, 0, -0.05>, <0, 0, -0.65>, 0.5, 1 // bottom & heel
			scale <0.9,0.5, 1>
			rotate Foot_R_angle
			translate <0.05, FJoint_Y-0.18,0>
		}
	}
			// ---- Foot finger
	union {
		// 1st finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.2>, 0.16, 1
				rotate <FootFinger_R_angle, -5, 0>
				translate <-0.12-0.1, 0, -0.8>}
			sturm
		}
		// 2nd finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.19>, 0.14, 1
				rotate FootFinger_R_angle*x
				translate <0.01-0.1, 0.01, -0.8>}
			sturm
		}
		// 3rd finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.17>, 0.13, 1
				rotate FootFinger_R_angle*x
				translate <0.12-0.1, 0.005, -0.8>}
			sturm
		}
		// 4th finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.16>, 0.12, 1
				rotate <FootFinger_R_angle, 5, 0>
				translate <0.22-0.1, 0, -0.8>}
			sturm
		}
		// 5th finger
		blob {
			threshold 0.5
			cylinder { <0, 0, 0>, <0, 0, -0.15>, 0.11, 1
				rotate <FootFinger_R_angle, 10, 0>
				translate <0.3-0.1, 0, -0.8>}
			sturm
		}
		rotate Foot_R_angle*<1, 1, 0.9>
		translate <0+0.1, FJoint_Y-0.18, 0>
	}
	rotate 5*z
	matrix 
    <-1, 0, 0,
    0, 1, 0,
    0, 0, 1,
    0, 0, 0 >
}

//-------- Upper & Lower Leg, and Foot ------------------------
#declare StandPx = -5;
#declare StandPz = -8;
#declare Leg_L_angle[0][1] = Leg_L_angle[0][1]+Body_angle[1][1];
// Leg left
#declare Leg_L =
union {
	blob{
		threshold 0.5
				// --Upper Leg
		// hip
		sphere { <0,0,0>, 1, 1
			scale <0.9, 1.4, 1.1> translate <-0.15, 0.25, 0.15>}
		sphere { <0,0,0>, 1, 1
			scale <0.7, 0.8, 0.7> translate <-0.45, 0.40, 0.20>}
		// upper leg main
		cylinder {<0, -0.2, 0>, <0, -2.1, 0>, 0.49, 1
			rotate <Leg_L_angle[0][0]+StandPx,
						-Leg_L_angle[0][1],
						 Leg_L_angle[0][2]+StandPz>
		}
		// musle swelling
		sphere { <0, 0, 0>, 0.60, 1 scale <1.2, 2.2, 1.1> translate <-0.05, -0.95, 0.05>
			rotate <Leg_L_angle[0][0]+StandPx,
						-Leg_L_angle[0][1],
						 Leg_L_angle[0][2]+StandPz>
		}
		// nee
		sphere { <0, 0, 0>, 0.3, 1 scale <1,1,1> translate <0, -2.3, 0.0>
			rotate <Leg_L_angle[0][0]+StandPx, 
						-Leg_L_angle[0][1],
						 Leg_L_angle[0][2]+StandPz>
		}
	}
				// --Lower Leg
	object { Leg_Lower_L
		rotate <-Leg_L_angle[1][0], Leg_L_angle[1][1],  Leg_L_angle[1][2]>
		translate <0.05, -2.4+0.1*Leg_L_angle[1][0]/180, 0.2*Leg_L_angle[1][0]/180>
		rotate <Leg_L_angle[0][0]+StandPx,
					-Leg_L_angle[0][1],
					 Leg_L_angle[0][2]+StandPz>
	}
	
	#declare Leg_L_Rotate =
		<Leg_L_angle[0][0], Leg_L_angle[0][1], Leg_L_angle[0][2]>;
	// joint slide
	#declare Global_P = vrotate(<0, -1, 0>, Leg_L_Rotate);
	#if (Global_P.z < 0)
//		#declare Hosei_Y = (Global_P.y + 1)*0.15;
		#declare Hosei_YL = Leg_L_angle[0][0]/90*0.15;
	#else
//		#declare Hosei_Y = (Global_P.y + 1)*0.4;
		#declare Hosei_YL = -Leg_L_angle[0][0]/90*0.4;
	#end
	#declare Hosei_ZL = Global_P.z*0.1;
	translate <  0.65, -0.2+Hosei_YL, 0.05+Hosei_ZL>
}

// Leg Right
#declare Leg_R_angle[0][1] = Leg_R_angle[0][1]-Body_angle[1][1];
#declare Leg_R =
union {
	blob{
		threshold 0.5
				// --Upper Leg
		// hip
		sphere { <0,0,0>, 1, 1
			scale <0.9, 1.4, 1.1> translate <0.15, 0.25, 0.15>}
		sphere { <0,0,0>, 1, 1
			scale <0.7, 0.8, 0.6> translate <0.45, 0.40, 0.25>}
		// upper leg main
		cylinder {<0,-0.2,0>, <0, -2.1, 0>, 0.49, 1
			rotate <Leg_R_angle[0][0]+StandPx,
						 Leg_R_angle[0][1],
						-Leg_R_angle[0][2]-StandPz>}
		// musle swelling
		sphere { <0, 0, 0>, 0.60, 1 scale <1.2, 2.2, 1.1> translate <0.05, -0.95, 0.05>
			rotate <Leg_R_angle[0][0]+StandPx,
						 Leg_R_angle[0][1],
						-Leg_R_angle[0][2]-StandPz>}
		// nee
		sphere { <0, 0, 0>, 0.3, 1 scale <1,1,1> translate <0, -2.3, 0.0>
			rotate <Leg_R_angle[0][0]+StandPx,
						 Leg_R_angle[0][1],
						-Leg_R_angle[0][2]-StandPz>}
	}
				// --Lower Leg
	object { Leg_Lower_R
		rotate <-Leg_R_angle[1][0], Leg_R_angle[1][1], Leg_R_angle[1][2] >
		translate <-0.05,-2.4, 0>
		rotate <Leg_R_angle[0][0]+StandPx,
						 Leg_R_angle[0][1],
						-Leg_R_angle[0][2]-StandPz>
	}
	
	#declare Leg_R_Rotate =
		<Leg_R_angle[0][0], Leg_R_angle[0][1], Leg_R_angle[0][2]>;
	// joint slide
	#declare Global_P = vrotate(<0, -1, 0>, Leg_R_Rotate);
	#if (Global_P.z < 0)
//		#declare Hosei_Y = (Global_P.y + 1)*0.15;
		#declare Hosei_YR = Leg_L_angle[0][0]/90*0.15;
	#else
//		#declare Hosei_Y = (Global_P.y + 1)*0.4;
		#declare Hosei_YR = -Leg_L_angle[0][0]/90*0.4;
	#end
	#declare Hosei_ZR = Global_P.z*0.1;
	translate < -0.65, -0.2+Hosei_YR, 0.05+Hosei_ZR>
}


//------------------- Main -------------------
union{
	union {
		object { Body2 }
		object {
			union {
				object { Body1 }
				union { 
					object { Neck }
					object { Head
						rotate 10*x
						rotate < Head_angle[0][0], Head_angle[0][1],Head_angle[0][2]>
						translate <0, 1.0, 0>
					}
					rotate < Neck_angle[0][0]-10, 0,Neck_angle[0][2]>
					translate <0, 1.2, 0.2>
				}
				// Arm parts
				object { Arm_L }
				object { Arm_R }
			}
			translate 0.6*y
			rotate <Body_angle[0][0],Body_angle[0][1],Body_angle[0][2]> // abdominal Joint angle
			translate -0.6*y
			translate <0, 2.1, 0.05>
		}
		translate -0.3*y
		rotate <Body_angle[1][0], Body_angle[1][1], Body_angle[1][2]>
		translate 0.3*y
	}
	// Legs parts
	union {
		object { Leg_L }
		object { Leg_R }
		rotate < 0, Body_angle[1][1], Body_angle[1][2]>
	}
	//
	texture{ LadyTexture2 }
}
