///////////////////////////////////////////////////////////////////////////////
//
// BLDGVIEW.INC
//
// Written By : Jeffrey C. Loper
// Finished on : 4-29-00
//
// Desc : A view of three buildings, one under construction.
// For submission to IRTC April,2000
//
// Notice : Copywrite(C) J.C. Loper 4/29/00. Not for use in commercial productions.
//
///////////////////////////////////////////////////////////////////////////////



/////////////////
// Declerations 
/////////////////

//globals
#declare QUICK_RENDER = 0;    // 1 = True
#declare R1 = seed(110);
#declare Epsilon=0.001; 

//Street Dimensions 
#declare Edge = 500;
#declare street_A_width = 40; 
#declare street_B_width = 40; 
#declare sw_width = 6;
#declare sw_height = 1;     
#declare sw_bottom_width = 1;
#declare BC_spacer = -1;
                                         
//Building A Dimensions 
#declare BA_num_floors = 14;                     
#declare BA_num_windows = 20;                      // even only
#declare BA_wall_thickness = 1;                    // depth of wall
#declare BA_wall_width = 12/12;                    // interwindow gap          
#declare BA_wall_height = 12;                      // total height of each floor
#declare BA_window_thickness = BA_wall_thickness;  // window depth                       
#declare BA_window_width = 6;                      // window width
#declare BA_window_height = BA_wall_height-2;      // window height
#declare BA_window_sill_width = 2/12;              // window sill width
#declare BA_window_sill_offset = 2/12;
#declare BA_window_inset = 4/12;
#declare BA_face_A_width = BA_num_windows*(BA_window_width+BA_wall_width)+BA_wall_width;
#declare BA_top_first = 25;                        // top height of first floor
#declare BA_bottom_first = 3;                      // height where curtain begins on first floor   
#declare BA_divider_size = 1;                      // diagonal divider size (size of each side of square)

#declare BA_window_sill_material = material { texture {pigment{Gray30} finish{ambient .2 diffuse.6}}}
#declare BA_divider_material = material{ texture {pigment{White_Marble} scale .25}}

//Building B Dimensions 
#declare BB_num_floors = 10; 
#declare BB_curve_window_cnt = 14; 
#declare BB_face_A_window_cnt = 3; //east-west facade                         
#declare BB_face_B_window_cnt = 12; //north-south facade

#declare BB_wall_width = 12/12;    //arc length
#declare BB_column_wall_width = 6/12;
#declare BB_wall_divider_height = 12/12;  
#declare BB_wall_thickness = 12/12;  

#declare BB_window_width = 8;   //arc length
#declare BB_window_height = 10;             
#declare BB_window_thickness = 2/12;
#declare BB_window_inset = 2/12; 
#declare BB_window_sill_offset = 3/12; 
#declare BB_window_sill_height = 8/12;
#declare BB_column_radius = 12/12;     

#declare BB_top_first = 20;
#declare BB_bottom_divider_height = 3; 
#declare BB_shelf_thickness = 8;
#declare BB_shelf_height = 1;
#declare BB_window_height_1st = BB_top_first-BB_bottom_divider_height-BB_shelf_height;

#declare BB_floor_height = BB_window_height+BB_wall_divider_height;
#declare BB_face_segment_width = 2*BB_column_wall_width+2*BB_column_radius+2*BB_window_width+BB_wall_width;
#declare BB_face_A_width = BB_face_segment_width*BB_face_A_window_cnt+BB_column_wall_width+2*BB_column_radius;  //east-west facade
#declare BB_face_B_width = BB_face_segment_width*BB_face_B_window_cnt+BB_column_wall_width+2*BB_column_radius;  //north-south facade
                           
#declare BB_curve_length = BB_curve_window_cnt*BB_window_width + (BB_curve_window_cnt+1)*BB_wall_width;
#declare BB_curve_radius = BB_curve_length/pi;
#declare BB_theta_wall = degrees(BB_wall_width/BB_curve_radius);                      
#declare BB_theta_window = degrees(BB_window_width/BB_curve_radius);                  

#declare BB_door_radius = BB_curve_radius*cos(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)));
#declare BB_door_wall_width = BB_wall_width;
#declare BB_door_wall_thickness = .5; 
#declare BB_door_thickness = 2/12;
#declare BB_door_frame_width = 2/12;
#declare BB_door_angle = 60;
#declare BB_door_x = BB_door_radius - BB_door_radius*cos(radians(BB_door_angle));
#declare BB_door_z = BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window))) - BB_door_radius*sin(radians(BB_door_angle));

#declare BB_fountain_major_radius = 0.75*BB_face_A_width/2;
#declare BB_fountain_minor_radius = 0.75*BB_curve_radius/2;
#declare BB_fountain_height_bottom = 2;
#declare BB_fountain_width_bottom = 1; 
#declare BB_fountain_height_top = 1;
#declare BB_fountain_water_height = .5;
#declare BB_fountain_width_top = 2.5; 
#declare BB_fountain_nozzle_radius = 3/12; 
#declare BB_fountain_nozzle_heigth = 2; 
#declare BB_num_spouts=8; 
#declare BB_spout_radius_factor=0.6;   
#declare BB_fountain_spout_height = 25; 
#declare BB_fountain_spout_radius = .2*BB_fountain_minor_radius; 
                           
//Building C Dimensions                            
#declare BC_num_floors = 11;                           
#declare BC_num_seg_x = 5;
#declare BC_num_seg_z = 4;
#declare BC_num_smaller_cross_beams = 3;
#declare BC_floor_height = 16;

#declare BC_beam_width = 12/12;
#declare BC_beam_thickness = 2/12;
#declare BC_beam_height = 18/12;
#declare BC_beam_length = 30;  
#declare BC_sq_beam_width = 1;
#declare BC_first_floor_height = BC_floor_height*2;
#declare BC_base_height = 2;

#declare BC_floor_length_x = (BC_num_seg_x-1)*(BC_beam_length+BC_beam_width)+BC_beam_width;
#declare BC_floor_length_z = (BC_num_seg_z-1)*(BC_beam_length+BC_beam_width)+BC_beam_width;

#declare BC_platform_radius = 4/12;  
#declare BC_platform_length = BC_beam_length+2*BC_beam_width; 
#declare BC_platform_width = BC_beam_length; 

//Buildings        
#declare BA_anchor = <-street_A_width/2-sw_width, sw_height, street_B_width/2+sw_width>; 
#declare BB_anchor = <street_A_width/2+sw_width+BB_face_A_width, sw_height, 0>;                          
#declare BC_anchor = <-street_A_width/2-sw_width, sw_height, -(street_B_width/2+sw_width)>;                           










/////////////
// Materials
///////////// 

#declare Stop_Light_Material = material { 
   texture{ 
      pigment{Yellow}
      finish{ambient .4 diffuse .4}
   }
}

#declare BC_concrete_material = material {
   texture {
      pigment{Gray50} 
      finish{ambient .2 diffuse.6}
      normal {granite turbulence .7 bump_size .4 } 
   }      
}
                                                                                                       
#declare BC_platform_material = material {
   texture {
      pigment{color Silver}  
      finish{ambient .6 diffuse.6 specular .1}
   }
}                                                                                                             

#declare Lamp_Glass = material {texture {pigment{rgb <.8,.9,.5>} finish{ambient .6 diffuse.2}}}   
   
#declare Post_Material = material { 
   texture{ 
      pigment{Silver}
      finish{ambient .3 diffuse .6 specular .5}
   }
}

#declare Street_line_texture = material { 
   texture{ 
      pigment{White}
      finish{ambient .6 diffuse .2 specular .1}
   }
}


#if (!QUICK_RENDER)
//Detailed Render Materials

#declare BA_wall_material = material  // BA_wall_texture
{   
   texture  // T_Grnt5
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.804, 0.569, 0.494, 0.0, 0.0> ]
            [ 0.178   rgbft <0.855, 0.729, 0.584, 0.0, 0.0> ]
            [ 0.356   rgbft <0.667, 0.502, 0.478, 0.0, 0.0> ]
            [ 0.525   rgbft <0.859, 0.624, 0.545, 0.0, 0.0> ]
            [ 0.729   rgbft <0.855, 0.729, 0.584, 0.0, 0.0> ]
            [ 1.0     rgbft <0.804, 0.569, 0.494, 0.0, 0.0> ]
         }
         turbulence 0.5
         ramp_wave
      }
   }
   texture  // T_Grnt0a
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.729, 0.502, 0.451, 0.306, 0.0> ]
            [ 0.153   rgbft <0.769, 0.686, 0.592, 0.792, 0.0> ]
            [ 0.398   rgbft <0.843, 0.753, 0.718, 0.396, 0.0> ]
            [ 0.559   rgbft <0.78, 0.667, 0.561, 0.976, 0.0> ]
            [ 0.729   rgbft <0.741, 0.659, 0.576, 0.82, 0.0> ]
            [ 1.0     rgbft <0.729, 0.502, 0.451, 0.306, 0.0> ]
         }
         turbulence 0.6
         ramp_wave
      }   
      finish
      {
         ambient 0.1
         phong 1.0
         phong_size 90.0
      }
   }
}

#declare BA_window_material = material {
   texture {
      pigment{ Gray40 }
      normal { bumps turbulence .05 bump_size .015 } 
      finish {
         ambient 0.1
         diffuse 0.5
         phong 1.0
         phong_size 100.0
         specular 0.8
         roughness 0.0003
         reflection 0.5
      }                 
   }
}

#declare BB_wall_material = material  // BB_wall_texture
{   
   texture
   {      
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.7604, 0.7604, 0.406233, 0.0, 0.0> ]
         }
         turbulence 0.75
         octaves 1
         frequency 2.0
         sine_wave
         scale  0.1
      }
   }
}

#declare BB_window_material =  material  // BB_window_texture
{   
   texture
   {      
      pigment {
         color rgb <0.5, .8, 0.6>
      }      
      finish
      {
         ambient 0.1079
         diffuse 0.65
         phong_size 59.6
         specular 0.676233
         roughness 0.075167
         reflection 0.4
      }
   }
}


#declare BB_column_material = BB_wall_material

#declare BB_divider_material = BB_wall_material

#declare BB_window_sill_material = BB_wall_material

#declare BB_floor_material = material{ texture{ pigment{Tan} finish{ambient .7 diffuse.4}}}

#declare BC_beam_material_horizontal = material {
   texture { 
       pigment {
           gradient y
           color_map {
               [0.0 rgb <0.137255,0.419608,0.556863>]
               [0.5 rgb <0.70, 0.13, 0.00>]
               [0.6 rgb <0.69, 0.41, 0.08>]
               [0.7 rgb <0.49, 0.31, 0.28>]
               [1.0 rgb <0.89, 0.51, 0.28>]
           }
           turbulence .3
       }
       finish { ambient 0.2 diffuse 0.4 }       
   }          
}   

#declare BC_beam_material_individual = material {
   texture { 
       pigment {
           //gradient y
           bozo
           color_map {
               [0.0 rgb <0.137255,0.419608,0.556863>]
               [0.5 rgb <0.137255,0.419608,0.556863>]
               [0.8 rgb <0.70, 0.13, 0.00>]
               [0.85 rgb <0.69, 0.41, 0.08>]
               [0.9 rgb <0.49, 0.31, 0.28>]
               [1.0 rgb <0.89, 0.51, 0.28>]
           }
           turbulence .7 
           scale <.5,.2,.5>
       }
       finish { ambient 0.2 diffuse 0.4 }       
   }          
} 

#declare BC_beam_material_vertical = material {
   texture { 
       pigment {
           granite
           color_map {
               [0.0 rgb <0.137255,0.419608,0.556863>]
               [0.8 rgb <0.70, 0.13, 0.00>]
               [0.85 rgb <0.69, 0.41, 0.08>]
               [0.90 rgb <0.49, 0.31, 0.28>]
               [1.0 rgb <0.89, 0.51, 0.28>]
           }
           turbulence .4
       }
       finish { ambient 0.2 diffuse 0.4 }
   }          
}   

#declare BB_fountain_water_material = material {
   texture {
      pigment { rgb <.7,.8,.95> }   	
   	normal { 
   		bumps 5 
   		turbulence 2.0 
   		bump_size 1.0
   		scale 1
   	}
   	finish {
   		ambient 0.1
   		diffuse 0.6
   		brilliance 0.1
   		phong 0.0
   		phong_size 40
   		specular 0.0
   		roughness 0.05
   		reflection 0.3
   	}
   	scale <5.0,1.0,5.0> 	
   }
}  

#declare BB_fountain_falling_water_material = material{
   texture {
      pigment {color rgbt<1, 1, 1, .99>}
   }
   interior{
       media {
         emission .8 
         density { 
            spherical 
            turbulence .05
            octaves 5
            omega .2
            lambda 2                       
            color_map {                 
               [0.0 color rgb <0,0,0>]
               [0.20 color rgb <0,0,0>]
               [0.3 color rgb <.75,.85,.95>]
               [0.35 color rgb <0,0,0>]  
               [1.0 color rgb <0,0,0>]                                              
            }                                 
         }  
      }                                  
   }
}

#declare BB_fountain_shooting_water_material = material{
   texture {
      pigment {color rgbt<1, 1, 1, .99>}
   }
   interior{
       media {
         emission 1.2 
         density { 
            cylindrical                   
            turbulence .05
            octaves 5
            omega .2
            lambda 2                       
            color_map {                 
               [0.0 color rgb <0,0,0>] 
               [0.9 color rgb <0,0,0>]
               [0.9 color rgb <1,1,1>]  
               [1.0 color rgb <1,1,1>]                                              
            }                                 
         }  
      }                                  
   }
}

#declare SW_Material = material { 
   texture{ 
      pigment{
         bozo
         turbulence .3
         scale .1                    
         color_map {
            [0.00 color Gray90]
            [0.50 color Gray95]
            [1.00 color White]
         }      
      }
      finish{ambient .3 diffuse.4}
   }
}

#declare SW_Material_Yellow = material { 
   texture{ 
      pigment{
         bozo
         turbulence .3
         scale .1                    
         color_map {
            [0.00 color rgb <1,1,0>]
            [0.70 color rgb <.8,.8,.1>]
            [0.95 color rgb <0.557,0.137,0.137>]           
            [1.00 color rgb <0,0,0>]
         }      
      }
      finish{ambient .2 diffuse.5}
   }
}

#declare Street_Material = material { 
   texture{ 
      pigment{
         bozo
         turbulence .6
         scale .2                    
         color_map {
            [0.00 color Gray50]
            [1.00 color Gray30]
         }      
      }
      finish{ambient .3 diffuse.2 specular .1}
   }
}

#declare P_WoodGrain7A =
pigment {
    wood
    turbulence <0.05, 0.08, 1000>
    octaves 4
    scale <0.15, .15, 1>
}

#declare P_WoodGrain7B =
pigment {
    bozo
    scale <0.01, 0.01, 100000>
}
#declare M_Wood7A = 
color_map { 
    [0.0, 0.1 color rgb <0.60, 0.35, 0.20>
              color rgb <0.60, 0.35, 0.20>]
    [0.1, 0.9 color rgb <0.60, 0.35, 0.20>
              color rgb <0.90, 0.65, 0.30>]
    [0.9, 1.0 color rgb <0.90, 0.65, 0.30>
              color rgb <0.60, 0.35, 0.20>]
}
#declare M_Wood7B = 
color_map { 
    [0.0, 0.1 color rgbf <0.90, 0.65, 0.30, 0.00>
              color rgbf <0.90, 0.65, 0.30, 0.30>]
    [0.1, 1.0 color rgbf <0.90, 0.65, 0.30, 0.30>
              color rgbf <1.00, 1.00, 1.00, 1.00> ] 
} 
#declare T_Wood7   =         
    texture { pigment { P_WoodGrain7A  color_map { M_Wood7A }}} 
    texture { pigment { P_WoodGrain7B  color_map { M_Wood7B }}}
#declare Wood_Material = material {texture {T_Wood7}}   
                                                        
#else 
//Quick Render Materials                                                       

   #declare BA_wall_material =            material {texture {pigment{White_Marble}}}
   #declare BA_divider_material =         material {texture {pigment{White_Marble}}}
   #declare BA_window_material =          material {texture {pigment{SteelBlue}}}
   #declare BA_window_sill_material =     material {texture {pigment{Gray30}}} 
   
   #declare BB_floor_material =           material {texture {pigment{Tan}}}
   #declare BB_window_material =          material {texture {pigment{SteelBlue}}}
   #declare BB_wall_material =            material {texture {pigment{Brown}}}
   #declare BB_column_material =          material {texture {pigment{Brown}}}
   #declare BB_window_sill_material =     material {texture {pigment{Brown}}} 
   #declare BB_divider_material =         material {texture {pigment{Magenta}}}
   #declare BB_fountain_water_material =  material {texture {pigment{Blue}}} 
   #declare BB_fountain_falling_water_material = material {texture {pigment{White_Marble}}}   
   #declare BB_fountain_shooting_water_material = material {texture {pigment{White_Marble}}}  
       
   #declare BC_beam_material_horizontal = material {texture {pigment{SteelBlue}}}
   #declare BC_beam_material_vertical = material {texture {pigment{SteelBlue}}}

   #declare Street_Material = material { texture{ pigment{Black} finish{ambient .3 diffuse.6}}}
   #declare SW_Material = material { texture{ pigment{Gray90} finish{ambient .4 diffuse.6}}}
   
   #declare Wood_Material = material {texture {pigment{rgb <.8,.9,.5>} finish{ambient .2 diffuse.7}}}      
#end
       












/////////////////////
// Buildings A,B,C 
/////////////////////


/////////////////
// Building A
/////////////////  
#declare Floor_A =
   object {
      union {
         difference {
            // make wall and window sills and subtract window holes
            union{
               box{<0,0,0>,<BA_face_A_width,BA_wall_height,BA_wall_thickness> material {BA_wall_material}}    
               //window sills              
               #local cnt=0;
               #while (cnt<BA_num_windows)
                  box{<BA_wall_width+(BA_wall_width+BA_window_width)*cnt-BA_window_sill_width,(BA_wall_height-BA_window_height)/2-BA_window_sill_width,-BA_window_sill_offset>, <BA_wall_width+(BA_wall_width+BA_window_width)*cnt+BA_window_width+BA_window_sill_width,BA_wall_height-(BA_wall_height-BA_window_height)/2+BA_window_sill_width,BA_wall_thickness-Epsilon> material {BA_window_sill_material} }                      
                  #local cnt=cnt+1;
               #end         
            } 
            //window holes
            #local cnt=0;
            #while (cnt<BA_num_windows)
               box{<BA_wall_width+(BA_wall_width+BA_window_width)*cnt,(BA_wall_height-BA_window_height)/2,-BA_window_sill_offset-Epsilon>, <BA_wall_width+(BA_wall_width+BA_window_width)*cnt+BA_window_width,BA_wall_height-(BA_wall_height-BA_window_height)/2,BA_window_thickness+BA_wall_thickness+Epsilon> material {BA_window_sill_material}}    
               #local cnt=cnt+1;
            #end         
         }     
         //put in windows
         #local cnt=0;
         #while (cnt<BA_num_windows)            
            box{<BA_wall_width+(BA_wall_width+BA_window_width)*cnt-Epsilon,(BA_wall_height-BA_window_height)/2-Epsilon,BA_window_inset-Epsilon>, <BA_wall_width+(BA_wall_width+BA_window_width)*cnt+BA_window_width+Epsilon,BA_wall_height-(BA_wall_height-BA_window_height)/2+Epsilon,BA_window_inset+BA_window_thickness+Epsilon> material {BA_window_material} }    
            #local cnt=cnt+1;
         #end         
      }   
   }

#declare Make_Facade_A =     
difference {
   //Floors 2..n
   #local cnt=0;             
   union {      
      //make floors 
      #while (cnt<BA_num_floors)
         object { Floor_A translate<0,BA_top_first+BA_wall_height*cnt,0> }         
         #local cnt=cnt+1;
      #end   
      
      //make divider above 1st floor
      box {<-sqrt(2)*BA_divider_size,-BA_divider_size,-BA_divider_size>,<BA_face_A_width+sqrt(2)*BA_divider_size,BA_divider_size,BA_divider_size> 
         rotate <45,0,0>
         material {BA_divider_material}      
         translate <0,BA_top_first-(BA_wall_height-BA_window_height)/2,0>       
      }   
      
      //make 1st floor
      #declare BA_wall_width_1st = BA_wall_width*2;
      #declare BA_wall_height_1st = BA_top_first-BA_bottom_first;  
      #declare BA_window_width_1st = BA_window_width*2;
      #declare BA_window_height_1st = BA_wall_height_1st-8;
      #declare BA_num_windows_1st = BA_num_windows/2;
      union {
         difference { 
            union {
               box{<0,0,0>,<BA_face_A_width,BA_top_first,BA_wall_thickness> material {BA_wall_material}}    
               //window sills              
               #local cnt=0;
               #while (cnt<BA_num_windows_1st)
                  box{<BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt-BA_window_sill_width,BA_bottom_first+(BA_wall_height_1st-BA_window_height_1st)/2-BA_window_sill_width,-BA_window_sill_offset>, <BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt+BA_window_width_1st+BA_window_sill_width,BA_bottom_first+BA_wall_height_1st-(BA_wall_height_1st-BA_window_height_1st)/2+BA_window_sill_width,BA_wall_thickness-Epsilon> material {BA_window_sill_material} }                                      
                  #local cnt=cnt+1;
               #end         
            }
            //window holes                
            #local cnt=0;
            #while (cnt<BA_num_windows_1st)
               box{<BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt,BA_bottom_first+(BA_wall_height_1st-BA_window_height_1st)/2,-BA_window_sill_offset-Epsilon>, <BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt+BA_window_width_1st,BA_bottom_first+BA_wall_height_1st-(BA_wall_height_1st-BA_window_height_1st)/2,BA_window_thickness+BA_wall_thickness+Epsilon> material {BA_window_sill_material}}    
               #local cnt=cnt+1;
            #end         
         }
         //put in windows
         #local cnt=0;
         #while (cnt<BA_num_windows_1st)
            box{<BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt-Epsilon,BA_bottom_first+(BA_wall_height_1st-BA_window_height_1st)/2-Epsilon,BA_window_inset-Epsilon>,<BA_wall_width_1st+(BA_wall_width_1st+BA_window_width_1st)*cnt+BA_window_width_1st+Epsilon,BA_bottom_first+BA_wall_height_1st-(BA_wall_height_1st-BA_window_height_1st)/2+Epsilon,BA_window_inset+BA_window_thickness+Epsilon> material {BA_window_material} }            
            #local cnt=cnt+1;
         #end         
      }   
      
      //make divider and curtain below 1st floor      
      union {
         //diagonal part
         box {<-sqrt(2)*BA_divider_size,-BA_divider_size,-BA_divider_size>,<BA_face_A_width+sqrt(2)*BA_divider_size,BA_divider_size,BA_divider_size> 
            rotate <45,0,0>
            material {BA_divider_material}      
         } 
         //bottom curtain
         box {<-sqrt(2)*BA_divider_size,-BA_bottom_first,-sqrt(2)*BA_divider_size>,<BA_face_A_width+sqrt(2)*BA_divider_size,0,sqrt(2)*BA_divider_size>       
            material {BA_divider_material}      
         } 
         translate <0,BA_bottom_first,0>       
      }         
   } 
   
   //cut off ends  
   box {-BA_divider_size*<2,2+BA_bottom_first,2>,BA_divider_size*<2,2,2>+<0,BA_top_first+BA_wall_height*BA_num_floors,0>              
      rotate<0,45,0>
      translate <-sqrt(2)*BA_divider_size,0,sqrt(2)*BA_divider_size>   
      material {BA_divider_material}                  
   }
   box {-BA_divider_size*<2,2+BA_bottom_first,2>,BA_divider_size*<2,2,2>+<0,BA_top_first+BA_wall_height*BA_num_floors,0>           
      rotate<0,-45,0>
      translate <BA_face_A_width+sqrt(2)*BA_divider_size,0,sqrt(2)*BA_divider_size>   
      material {BA_divider_material}      
   }
}


#declare Building_A = object {
// anchor is located at street level and corner
   union{
      object{Make_Facade_A}
      object{Make_Facade_A  rotate <0,90,0>  translate <0,0,BA_face_A_width>}
   }
}  //end Building_A declaration

  
  
  
  
/////////////////
// Building B 
/////////////////  
  

#macro Curve_Segment (theta_max, theta_min, radius_max, radius_min, height, seg_material) 
object{ 
   difference{
      cylinder {<0,0,0>,<0,height,0>,radius_max } 
      cylinder {<0,-Epsilon,0>,<0,height+Epsilon,0>,radius_min }      
      box{<-radius_max-Epsilon,-Epsilon,0>, <radius_max+Epsilon,height+Epsilon,-radius_max-Epsilon>
         rotate<0,theta_min,0>
      }
      box{<-radius_max-Epsilon,-Epsilon,0>, <radius_max+Epsilon,height+Epsilon,-radius_max-Epsilon>
         rotate<0,-180+theta_max+Epsilon,0>
      }      
   }     
   material {seg_material}
}
#end
 
#declare BB_Door = object{
   union{
      difference {
         box{<0,0,0>,<BB_door_x,  BB_top_first-BB_shelf_height-2*BB_bottom_divider_height,  BB_door_thickness>}
         box{<BB_door_frame_width,  BB_door_frame_width*5,  -Epsilon>,<BB_door_x-BB_door_frame_width,  BB_top_first-BB_shelf_height-2*BB_bottom_divider_height-BB_door_frame_width,  BB_door_thickness+Epsilon>}
         material{BB_wall_material}    
      }                          
      box{<BB_door_frame_width,  BB_door_frame_width*5,  0>,<BB_door_x-BB_door_frame_width,  BB_top_first-BB_shelf_height-2*BB_bottom_divider_height-BB_door_frame_width,  BB_door_thickness>
         material{BB_window_material}
      }      
   }
}
   
#declare BB_Curve_Floor = object{
   union {
      //wall divider above
      object {Curve_Segment(180,  0  ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_wall_divider_height,  BB_wall_material)
         translate <0,BB_window_height,0>
      }        
      //first wall segment
      Curve_Segment(0+BB_theta_wall,  0  ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height,  BB_wall_material)
      #declare cnt = 0;
      #while (cnt<BB_curve_window_cnt)
         //window segment
         Curve_Segment(BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_window_thickness+BB_window_inset  ,BB_curve_radius+BB_window_inset  ,BB_window_height,   BB_window_material)
         //window sill segment
         //Curve_Segment(BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_window_thickness+BB_window_inset  ,BB_curve_radius-BB_window_sill_offset  ,BB_window_sill_height,   BB_window_sill_material)
         //wall segment
         Curve_Segment((cnt+1)*(BB_theta_wall+BB_theta_window)+BB_theta_wall,  (cnt+1)*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height,  BB_wall_material)
         #declare cnt=cnt+1;
      #end      
   }
   material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings
}   

#declare BB_Curve_First_Floor = object{
   union{
      //shelf north                                      
      object {Curve_Segment((BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)),  0   ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius-BB_shelf_thickness,  BB_shelf_height,  BB_wall_material)
         translate <0,BB_top_first-BB_shelf_height,0>
      }            
      //shelf south
      object {Curve_Segment(180,  BB_theta_wall+(BB_curve_window_cnt-(BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_wall_thickness,  BB_curve_radius-BB_shelf_thickness,  BB_shelf_height,  BB_wall_material)
         translate <0,BB_top_first-BB_shelf_height,0>
      }               
      //first wall segment north
      object {Curve_Segment(0+BB_theta_wall,  0  ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height_1st,  BB_wall_material)
         translate <0,BB_bottom_divider_height,0>
      }  
      //first wall segment south
      object {Curve_Segment(BB_theta_wall+(BB_curve_window_cnt-(BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window),  BB_theta_wall+(BB_curve_window_cnt-(BB_curve_window_cnt-3)/2-1)*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height_1st,  BB_wall_material)
         translate <0,BB_bottom_divider_height,0>
      }      
      //bottom wall divider north 
      Curve_Segment((BB_curve_window_cnt-3)/2*(BB_theta_wall+BB_theta_window)+BB_theta_wall,  0  ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius-BB_window_sill_offset,  BB_bottom_divider_height,  BB_wall_material)           
      //bottom wall divider south
      Curve_Segment(180,  180-((BB_curve_window_cnt-3)/2*(BB_theta_wall+BB_theta_window)+BB_theta_wall)  ,BB_curve_radius+BB_wall_thickness,  BB_curve_radius-BB_window_sill_offset,  BB_bottom_divider_height,  BB_wall_material)           

      
      //windows
      #declare cnt = 0;
      #while (cnt<(BB_curve_window_cnt-3)/2)         
         //window segment north
         object {Curve_Segment(BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_theta_wall+cnt*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_window_thickness+BB_window_inset  ,BB_curve_radius+BB_window_inset  ,BB_window_height_1st,   BB_window_material)
            translate <0,BB_bottom_divider_height,0>
         }         
         //wall segment north
         object {Curve_Segment((cnt+1)*(BB_theta_wall+BB_theta_window)+BB_theta_wall,  (cnt+1)*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height_1st,  BB_wall_material)
            translate <0,BB_bottom_divider_height,0>
         } 
         //window segment south
         object {Curve_Segment(BB_theta_wall+(BB_curve_window_cnt-cnt-1)*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_theta_wall+(BB_curve_window_cnt-cnt-1)*(BB_theta_wall+BB_theta_window),  BB_curve_radius+BB_window_thickness+BB_window_inset  ,BB_curve_radius+BB_window_inset  ,BB_window_height_1st,   BB_window_material)
            translate <0,BB_bottom_divider_height,0>
         }         
         //wall segment south
         object {Curve_Segment(BB_theta_wall+(BB_curve_window_cnt-cnt)*(BB_theta_wall+BB_theta_window),  BB_theta_wall+(BB_curve_window_cnt-cnt-1)*(BB_theta_wall+BB_theta_window)+BB_theta_window,  BB_curve_radius+BB_wall_thickness,  BB_curve_radius,  BB_window_height_1st,  BB_wall_material)
            translate <0,BB_bottom_divider_height,0>
         }                 
         #declare cnt=cnt+1;
      #end            
      
      //columns
      #declare cnt = 1;
      #while (cnt<(BB_curve_window_cnt-4)/2)         
         cylinder{<0,  0,  0>,  <0,  BB_top_first-BB_shelf_height, 0>, BB_column_radius
            translate<BB_curve_radius-BB_shelf_thickness+BB_column_radius,0,0>
            rotate<0,180+180/(BB_curve_window_cnt+1)*cnt,0> 
            material{BB_column_material}
         }
         cylinder{<0,  0,  0>,  <0,  BB_top_first-BB_shelf_height, 0>, BB_column_radius
            translate<BB_curve_radius-BB_shelf_thickness+BB_column_radius,0,0>
            rotate<0,-180/(BB_curve_window_cnt+1)*cnt,0> 
            material{BB_column_material}
         }         
         #declare cnt=cnt+1;
      #end            
      
      //doorway walls 
      union {                                                                                                                              
         //top shelf
         cylinder {<0,  BB_top_first+Epsilon,  BB_curve_radius>,  <0,  BB_top_first-BB_shelf_height,  BB_curve_radius>, BB_door_radius*1.5}         
         sphere {<0,0,0>, BB_door_radius*1.5  scale <1,0.2,1>  translate<0, BB_top_first-BB_shelf_height-Epsilon, BB_curve_radius>}         
         //north base board
         object{Curve_Segment (0, -BB_door_angle, BB_door_radius, BB_door_radius-BB_door_wall_thickness, BB_bottom_divider_height, BB_wall_material)        
           translate<0,0,BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)))>
         }
         //south base board
         object{Curve_Segment (180+BB_door_angle, 180, BB_door_radius, BB_door_radius-BB_door_wall_thickness, BB_bottom_divider_height, BB_wall_material)        
           translate<0,0,BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)))>
         }                
         //middle area over door
         object{Curve_Segment (-BB_door_angle, -180+BB_door_angle, BB_door_radius, BB_door_radius-BB_door_wall_thickness, 2*BB_bottom_divider_height, BB_wall_material)        
           translate<0,  BB_top_first-2*BB_bottom_divider_height-BB_shelf_height,  BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)))>
         }                      
         //columns
         cylinder{<-BB_door_x,  0,  BB_door_z>,  <-BB_door_x,  BB_top_first-BB_shelf_height,  BB_door_z>, BB_column_radius}                    
         cylinder{<BB_door_x,  0,  BB_door_z>,  <BB_door_x,  BB_top_first-BB_shelf_height,  BB_door_z>, BB_column_radius}                                
         material{BB_wall_material}        
      }
      //doorway windows
      //north base board
      object{Curve_Segment (0, -BB_door_angle, BB_door_radius, BB_door_radius-BB_door_wall_thickness, BB_top_first-BB_bottom_divider_height, BB_window_material)        
        translate<0,BB_bottom_divider_height,BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)))>
      }
      //south base board
      object{Curve_Segment (180+BB_door_angle, 180, BB_door_radius, BB_door_radius-BB_door_wall_thickness, BB_top_first-BB_bottom_divider_height, BB_window_material)        
        translate<0,BB_bottom_divider_height,BB_curve_radius*sin(radians(BB_theta_wall+((BB_curve_window_cnt-3)/2)*(BB_theta_wall+BB_theta_window)))>
      }  
      //doors                
      object{BB_Door                          
         rotate<0,0,0>
         translate<-BB_door_x,  0,  BB_door_z>
      }
      object{BB_Door    
         rotate<0,180,0>      
         translate<BB_door_x,  0,  BB_door_z>
      } 
      
      //floors     
      //foyer       
//      cylinder {<0,  0,  BB_curve_radius>,  <0,  Epsilon,  BB_curve_radius>, BB_door_radius+Epsilon
//         material{BB_floor_material}
//      } 

   } 
   material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings
}
   
#declare BB_Window = object{         
   box{ <-Epsilon,  0,  BB_window_inset>, <BB_window_width+Epsilon,  BB_window_height,  BB_window_inset+BB_window_thickness> 
      material{BB_window_material}
   }
} 
#declare BB_Window_Sill = object{
   box{ <0,  0,  -BB_window_sill_offset>, <BB_window_width,  BB_window_sill_height,  BB_window_thickness+BB_window_inset> 
      material{BB_window_sill_material}
   }                                  
}    
#declare BB_Wall = object{
   box{ <0,  0,  0>, <BB_wall_width,  BB_window_height,  BB_window_thickness> 
      material{BB_wall_material}
   }                                  
}    
#declare BB_Column_Wall = object{
   box{ <0,  0,  0>, <BB_column_wall_width,  BB_window_height,  BB_window_thickness> 
      material{BB_wall_material}
   }                                  
}                                  
#declare BB_Column = object{
   cylinder{ <0,  0,  0>, <0,  BB_window_height+BB_wall_divider_height,  0>,BB_column_radius
      material{BB_column_material}
   }                                  
}                                  

#macro BB_Floor (Num_Windows)
   object {
      union {
         //wall divider above
         box{<0,0,0>,<BB_face_segment_width*Num_Windows+BB_column_wall_width+2*BB_column_radius,  BB_wall_divider_height,  BB_wall_thickness>
            translate<0,BB_window_height,0>                                           
            material{BB_wall_material}
         }
         #local cnt=0;
         #while (cnt<Num_Windows)
            //wall
            object{BB_Column_Wall translate<BB_face_segment_width*cnt,0,0>}
            //column                        
            object{BB_Column translate<BB_face_segment_width*cnt+BB_column_wall_width+BB_column_radius,0,0>}
            //wall                          
            object{BB_Column_Wall translate<BB_face_segment_width*cnt+BB_column_wall_width+2*BB_column_radius,0,0>}
            //window    
            object{BB_Window translate<BB_face_segment_width*cnt+2*BB_column_wall_width+2*BB_column_radius,0,0>}
            //window sill segment
            object{BB_Window_Sill translate<BB_face_segment_width*cnt+2*BB_column_wall_width+2*BB_column_radius,0,0>}
            //wall                                                                            
            object{BB_Wall translate<BB_face_segment_width*cnt+2*BB_column_wall_width+2*BB_column_radius+BB_window_width,0,0>} 
            //window    
            object{BB_Window translate<BB_face_segment_width*cnt+2*BB_column_wall_width+2*BB_column_radius+BB_window_width+BB_wall_width,0,0>}
            //window sill segment
            object{BB_Window_Sill translate<BB_face_segment_width*cnt+2*BB_column_wall_width+2*BB_column_radius+BB_window_width+BB_wall_width,0,0>}
   
            #local cnt=cnt+1;
         #end                  
         //wall
         object{BB_Column_Wall translate<BB_face_segment_width*cnt,0,0>}
         //column                        
         object{BB_Column translate<BB_face_segment_width*cnt+BB_column_wall_width+BB_column_radius,0,0>}                
      }     
   }      
#end
       
#macro BB_First_Floor (Num_Windows)
   object{
      union {
         object {BB_Floor(Num_Windows) 
            scale<1,BB_top_first/(BB_wall_divider_height+BB_window_height),1>    
         }    
         //bottom divider
         box {<0,-Epsilon,-BB_window_sill_offset>, <BB_face_A_width,  BB_bottom_divider_height,  BB_wall_thickness>
            material{BB_wall_material}
         }
      }            
   }  
#end

#macro BB_First_Floor_Shelf (Num_Windows)
   object{
      union {
         //shelf
         box { <0,  BB_top_first,  -BB_window_sill_offset>,  <BB_face_A_width-BB_column_radius+BB_wall_width,  BB_top_first-BB_shelf_height,  -BB_shelf_thickness>
            material{BB_wall_material}
         }
         //columns  
         #local cnt=0;
         #while (cnt<Num_Windows*2+1)
            //column                        
            cylinder{ <(BB_face_segment_width/2)*cnt+BB_column_wall_width+BB_column_radius,  0,  -BB_shelf_thickness+BB_column_radius>, <(BB_face_segment_width/2)*cnt+BB_column_wall_width+BB_column_radius,  BB_top_first-Epsilon,  -BB_shelf_thickness+BB_column_radius>,  BB_column_radius
               material{BB_column_material}
            }     
            #local cnt=cnt+1;
         #end         
      }            
   }
#end  
    

#declare BB_Fountain = object{ 
   union {
      difference {   
         union {
            cylinder {<0,Epsilon,0>,<0,1,0>,1 scale<BB_fountain_minor_radius, BB_fountain_height_bottom, BB_fountain_major_radius> }
            cylinder {<0,Epsilon,0>,<0,1,0>,1 scale<BB_fountain_minor_radius+BB_fountain_width_bottom, BB_fountain_height_top, BB_fountain_major_radius+BB_fountain_width_bottom> translate<0,BB_fountain_height_bottom,0>}
            material{BB_column_material}      
         }
         cylinder {<0,0,0>,<0,1+Epsilon,0>,1 scale<BB_fountain_minor_radius-BB_fountain_width_bottom, BB_fountain_height_bottom+BB_fountain_height_top, BB_fountain_major_radius-BB_fountain_width_bottom> }      
      }  
      cylinder {<0,0,0>,<0,1+Epsilon,0>,1 scale<BB_fountain_minor_radius-BB_fountain_width_bottom, 0.8*(BB_fountain_height_bottom+BB_fountain_water_height), BB_fountain_major_radius-BB_fountain_width_bottom> 
         material {BB_fountain_water_material}
      } 
      union { 
         //main spout 
         sphere {<0, 0, 0>,1  scale<BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>  hollow  material {BB_fountain_falling_water_material  scale <BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>} }  //outer radius falling water
         sphere {<0, 0, 0>,1+Epsilon scale<BB_fountain_spout_radius, 0.75*BB_fountain_spout_height, BB_fountain_spout_radius> hollow  material {BB_fountain_shooting_water_material scale <BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>} }  //inner shooting water                                  
         cylinder {<0,Epsilon,0>,<0,1,0>,1 scale<2*BB_fountain_nozzle_radius, 2*BB_fountain_nozzle_heigth, 2*BB_fountain_nozzle_radius> material{BB_column_material} }
         
         //ring spouts         
         #declare cnt=0;   
         #while (cnt<BB_num_spouts)                               
            #declare theta = cnt*2*pi/BB_num_spouts;
            #declare rad = 1/sqrt( pow(cos(theta),2) / pow(BB_fountain_minor_radius,2) + pow(sin(theta),2) / pow(BB_fountain_major_radius,2) );            
            union {
               sphere {<0, 0, 0>,1         scale 0.6*<BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>      hollow  material {BB_fountain_falling_water_material  scale 0.6*<BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>} }  //outer radius falling water
               sphere {<0, 0, 0>,1+Epsilon scale 0.6*<BB_fountain_spout_radius, 0.75*BB_fountain_spout_height, BB_fountain_spout_radius> hollow  material {BB_fountain_shooting_water_material scale 0.6*<BB_fountain_spout_radius, BB_fountain_spout_height, BB_fountain_spout_radius>} }  //inner shooting water                                  
               cylinder {<0,Epsilon,0>,<0,1,0>,1 scale<BB_fountain_nozzle_radius, BB_fountain_nozzle_heigth, BB_fountain_nozzle_radius>  material{BB_column_material} }
               translate<BB_spout_radius_factor*rad*cos(theta), 0, BB_spout_radius_factor*rad*sin(theta)>
            }
            #declare cnt=cnt+1;
         #end

         translate <0, BB_fountain_height_bottom+BB_fountain_height_top, 0>         
      }
   }
}
 
  
#declare  Building_B = object{ 
// Center is located at streetlevel & center of semicircle interior region
   union{
             
      //curve section
      #declare cnt = 0;
      #while (cnt<BB_num_floors)
         object{BB_Curve_Floor translate <0,cnt*BB_floor_height+BB_top_first,0>}
         #declare cnt=cnt+1;
      #end 
      //curve first floor
      object{BB_Curve_First_Floor}
                       
      //Face A South
      object{
         difference { 
            union{                      
               //first floor
               object{BB_First_Floor (BB_face_A_window_cnt)}
               //first floor shelf
               object{BB_First_Floor_Shelf (BB_face_A_window_cnt)}
               //floors 2..n
               #declare cnt=0;   
               #while (cnt<BB_num_floors)
                  object{BB_Floor(BB_face_A_window_cnt) translate<0,  BB_top_first+cnt*(BB_window_height+BB_wall_divider_height),  0>}
                  #declare cnt=cnt+1;
               #end      
            }
            //cut off ends  
            box {<0,  -Epsilon,  -BB_column_radius>, <BB_column_radius+BB_wall_thickness,  BB_top_first+BB_num_floors*(BB_window_height+BB_wall_divider_height)+Epsilon,  BB_column_radius+BB_wall_thickness>
               rotate<0,-45,0>
               translate <BB_face_A_width-BB_column_radius,  0,  0>   
               pigment{Black}
            }   
         }      
         rotate<0,90,0>      
         translate<BB_curve_radius,0,Epsilon>
         material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings    
      } 
            
      //Face B South
      object{
         difference { 
            union{                      
               //first floor
               object {BB_First_Floor(BB_face_B_window_cnt)}                      
               //floors 2..n
               #declare cnt=0;   
               #while (cnt<BB_num_floors)
                  object {BB_Floor(BB_face_B_window_cnt) translate<0,  BB_top_first+cnt*(BB_window_height+BB_wall_divider_height),  0>}
                  #declare cnt=cnt+1;
               #end      
            }
            //cut off ends  
            box {<0,  -Epsilon,  -BB_column_radius>,  <2*(BB_column_radius+BB_wall_thickness),  BB_top_first+BB_num_floors*(BB_window_height+BB_wall_divider_height)+Epsilon,  BB_column_radius+BB_wall_thickness>
               rotate<0,-45,0>
               translate <BB_face_B_width-BB_column_radius,  0,  0>   
               pigment{Black}
            }   
         }      
         rotate<0,0,0>      
         translate<BB_curve_radius-2*BB_column_radius,0,-BB_face_A_width+BB_column_radius-Epsilon>
         material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings       
      } 
                  
      //Face A North 
      object{
         difference { 
            union{                      
               //first floor
               object {BB_First_Floor(BB_face_A_window_cnt)}
               //first floor shelf
               object{BB_First_Floor_Shelf(BB_face_A_window_cnt)}         
               //floors 2..n
               #declare cnt=0;   
               #while (cnt<BB_num_floors)
                  object {BB_Floor(BB_face_A_window_cnt) translate<0,  BB_top_first+cnt*(BB_window_height+BB_wall_divider_height),  0>}
                  #declare cnt=cnt+1;
               #end      
            }
            //cut off ends  
            box {<0,  -Epsilon,  -BB_column_radius>,  <2*(BB_column_radius+BB_wall_thickness),  BB_top_first+BB_num_floors*(BB_window_height+BB_wall_divider_height)+Epsilon,  BB_column_radius+BB_wall_thickness>
               rotate<0,-45,0>
               translate <BB_face_A_width-BB_column_radius,  0,  0>   
               pigment{Black}
            }   
         }      
         rotate<0,-90,0>      
         translate<-BB_curve_radius,0,-BB_face_A_width-Epsilon>
         material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings    
      }
            
      //Face B North
      object{
         difference { 
            union{                      
               //first floor
               object {BB_First_Floor(BB_face_B_window_cnt)}
               //floors 2..n
               #declare cnt=0;   
               #while (cnt<BB_num_floors)
                  object {BB_Floor(BB_face_B_window_cnt) translate<0,  BB_top_first+cnt*(BB_window_height+BB_wall_divider_height),  0>}
                  #declare cnt=cnt+1;
               #end      
            }
            //cut off ends  
            box {<0,  -Epsilon,  -BB_column_radius>, <BB_column_radius+BB_wall_thickness,  BB_top_first+BB_num_floors*(BB_window_height+BB_wall_divider_height)+Epsilon,  BB_column_radius+BB_wall_thickness>
               rotate<0,-45,0>
               translate <BB_face_B_width-BB_column_radius,  0,  0>   
               pigment{Black}
            }   
         }      
         rotate<0,0,0>       
         translate<-BB_curve_radius-BB_face_B_width+2*BB_column_radius,0,-BB_face_A_width+BB_column_radius-Epsilon>         
         material{texture{pigment{White}}} //added to get rid of annoying "No Pigment" compiler warnings    
      } 
   
      object{ BB_Fountain
         translate<0,0,-BB_face_A_width/2>               
      }
   
   }
}  //end Building_B declaration





/////////////////
// Building C 
/////////////////                                    


// I-Beam <0,0,0> - <length,height,width>
#declare BC_ib = object { 
   union{
      box{<0, 0, 0>, <BC_beam_length, BC_beam_thickness, BC_beam_width>} 
      box{<0, Epsilon, BC_beam_width/2-BC_beam_thickness/2>, <BC_beam_length, BC_beam_height-Epsilon ,BC_beam_width/2+BC_beam_thickness/2>}
      box{<0, BC_beam_height-BC_beam_thickness, 0>, <BC_beam_length, BC_beam_height, BC_beam_width>}      
      material{BC_beam_material_horizontal}
   }
} 

// Samller Cross I-Beam <0,0,0> - <length,height,width>
#declare BC_ib_smaller = object { 
   union{
      box{<0, 0, 0>, <BC_beam_length+BC_beam_width, BC_beam_thickness, BC_beam_width>}
      box{<0, Epsilon, BC_beam_width/2-BC_beam_thickness/2>, <BC_beam_length+BC_beam_width, BC_beam_height-2*BC_beam_thickness-Epsilon ,BC_beam_width/2+BC_beam_thickness/2>}
      box{<0, BC_beam_height-3*BC_beam_thickness, 0>, <BC_beam_length+BC_beam_width, BC_beam_height-2*BC_beam_thickness, BC_beam_width>}      
      material{BC_beam_material_horizontal}
   }
} 
 
// I-Beams for use in construction area
#declare BC_ib_individual = object { 
   union{
      box{<0, 0, 0>, <BC_beam_length+BC_beam_width, BC_beam_thickness, BC_beam_width>}
      box{<0, Epsilon, BC_beam_width/2-BC_beam_thickness/2>, <BC_beam_length+BC_beam_width, BC_beam_height-2*BC_beam_thickness-Epsilon ,BC_beam_width/2+BC_beam_thickness/2>}
      box{<0, BC_beam_height-3*BC_beam_thickness, 0>, <BC_beam_length+BC_beam_width, BC_beam_height-2*BC_beam_thickness, BC_beam_width>}            
   }
}  
 
//corragated platform
#declare BC_platform = object{
   union {                                                         
      #local cnt = 0;
      #while (cnt<BC_platform_width/(4*BC_platform_radius)) 
         object { Curve_Segment (180, 0, BC_platform_radius+Epsilon, BC_platform_radius, BC_platform_length, BC_concrete_material) translate <0,-BC_platform_length/2,0> rotate<-90,0,0> translate<4*cnt*BC_platform_radius,0,BC_platform_length/2> material{BC_platform_material}}
         object { Curve_Segment (180, 0, BC_platform_radius+Epsilon, BC_platform_radius, BC_platform_length, BC_concrete_material) translate <0,-BC_platform_length/2,0> rotate<90,0,0> translate<4*cnt*BC_platform_radius+2*BC_platform_radius,0,BC_platform_length/2> material{BC_platform_material}}
         #local cnt=cnt+1;
      #end
      translate<0,2*BC_platform_radius,0>        
   }                                          
}


#declare  Building_C = object{
   union{ 
      //vertical beams
      #local cntx = 0;
      #while (cntx < BC_num_seg_x)
         #local cntz = 0;
         #while (cntz < BC_num_seg_z)
            box{<0, 0, 0>,<BC_sq_beam_width, BC_floor_height*BC_num_floors+BC_first_floor_height, BC_sq_beam_width> 
               translate <cntx*(BC_beam_length+BC_sq_beam_width), 0, cntz*(BC_beam_length+BC_sq_beam_width)>
               material {BC_beam_material_vertical}
            }         
            #local cntz=cntz+1;
         #end
         #local cntx=cntx+1;   
      #end   
      
      //horizontal beams
      #local cnty = 0;
      #while (cnty <= BC_num_floors)       
      
         #local cntx = 0;
         #while (cntx < BC_num_seg_x-1)
         
            #local cntz = 0;
            #while (cntz < BC_num_seg_z)
            
               //larger cross beams
               object{BC_ib translate <cntx*(BC_beam_length+BC_sq_beam_width)+BC_sq_beam_width, BC_first_floor_height+cnty*BC_floor_height, cntz*(BC_beam_length+BC_sq_beam_width) > } 
               object{BC_ib rotate<0,-90,0> translate <cntz*(BC_beam_length+BC_sq_beam_width)+BC_sq_beam_width, BC_first_floor_height+cnty*BC_floor_height, cntx*(BC_beam_length+BC_sq_beam_width)+BC_sq_beam_width > }

               //smaller cross beams               
               #local cntz_small = 0;
               #while ((cntz_small < BC_num_smaller_cross_beams) & (cntz != BC_num_seg_z-1))
               
                  #local cntz_small=cntz_small+1;
                  object{BC_ib_smaller translate <cntx*(BC_beam_length+BC_sq_beam_width)+BC_sq_beam_width-BC_beam_width/2, BC_first_floor_height+cnty*BC_floor_height+BC_beam_thickness, cntz*(BC_beam_length+BC_sq_beam_width)+cntz_small*BC_beam_length/(BC_num_smaller_cross_beams+1)>}
                                    
               #end               

               #local cntz=cntz+1;
            #end

            #local cntx=cntx+1;   
         #end

         #local cnty=cnty+1;   
      #end   
      
      //base slab
      box{<-1, 0, -1>, <BC_num_seg_x*BC_sq_beam_width+(BC_num_seg_x-1)*BC_beam_length+1, BC_base_height, BC_num_seg_z*BC_sq_beam_width+(BC_num_seg_z-1)*BC_beam_length+1>
         material {BC_concrete_material}
      }
             
      //corragated platform
      //object{BC_platform translate<BC_sq_beam_width, BC_first_floor_height+BC_beam_height, 0> }
   }
}  //end Building_C declaration













/////////////
// Objects   
/////////////
#macro StopLight (which_light,stop_light_angle)
   object{
      union{
         union{ //post
            cone{<0,0,0>,1,<0,3,0>, 0.7}           //base cone
            cone{<0,3,0>,.5,<0,25,0>,0.3}          //main post
            cylinder{<0,24.9,0>,<0,25.1,0>,0.35}   //top cap of main post
            difference{                            //arc 
               torus{30,.3}
               box{<-100,2,-25>,<100,-2,100>}
               box{<0,2,-100>,<100,-2,100>}
               box{<-16,2,-100>,<-100,-2,100>}
               rotate<90,0,0> 
               translate<16,-6,0>
            }                       
            cylinder{<-.1,0,0>,<.1,0,0>,0.35 translate<16,24,0>}     //cap of arc
            cylinder{<0,0,0>,<0,-1,0>,0.1 translate<16,24,0>}        //wire 
            material {Post_Material}
         } 
         union { //stop_light           
            box {<-.8,0,-.2>,<.8,-4.6,.2>} 
            difference {
               cylinder {<0,-.2,0>,<0,-4.4,0>,0.7}
               box{<-5,-5,0>,<5,5,-5>} 
            }       
            cylinder{<0,-0.8,0>,<0,-0.8,-1>,.6 open}
            cylinder{<0,-2.2,0>,<0,-2.2,-1>,.6 open}
            cylinder{<0,-3.6,0>,<0,-3.6,-1>,.6 open}                              
            #switch (which_light)
               #case (1)
                  cylinder{<0,-0.8,0>,<0,-0.8,-1>,.599 pigment{rgb <1,0,0>} finish{ambient 0.9}}         
                  cylinder{<0,-2.2,0>,<0,-2.2,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}
                  cylinder{<0,-3.6,0>,<0,-3.6,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}
               #break
               #case (2)
                  cylinder{<0,-0.8,0>,<0,-0.8,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}         
                  cylinder{<0,-2.2,0>,<0,-2.2,-1>,.599 pigment{rgb <1,1,0>} finish{ambient 0.9}}
                  cylinder{<0,-3.6,0>,<0,-3.6,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}
               #break
               #case (3)
                  cylinder{<0,-0.8,0>,<0,-0.8,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}         
                  cylinder{<0,-2.2,0>,<0,-2.2,-1>,.599 pigment{rgb <0,0,0>} finish{ambient 0.9}}
                  cylinder{<0,-3.6,0>,<0,-3.6,-1>,.599 pigment{rgb <0,1,0>} finish{ambient 0.9}}
               #break
            #end   
            rotate stop_light_angle
            material {Stop_Light_Material}
            translate<16,23,0>      
         }                            
      }
   }
#end


#macro Cross_Walk_Light (left_right,walk) 
//left_right (0 = left / 1 = right) is whether the holder bars come off left or right of the sign, as your looking at it
//walk (0 = don't walk / 1 = walk) tells what is displayed on crosswalk
//the origin is always at end extension of bottom holder bar, and other corner is at <+/-2.5, 1.5, 1>
#if (left_right!=1)
   #declare left_right = -1;
#end

   object{   
      union{
         difference{
            box{<left_right*1,0,0>,<left_right*(1+1.5),1.5,1>}
            box{<left_right*(1+1/12),1/12,1/12>,<left_right*(1+1.5-1/12),1.5-1/12,1+Epsilon>}
            material{Stop_Light_Material}
         }
         box{<left_right*(1+1/12),1/12,1/12>,<left_right*(1+1.5-1/12),1.5-1/12,1-4/12> pigment{rgb <0,0,0>} finish{ambient 0.9}}      
         cylinder{<0,1/12,0>,<left_right*1,1/12,0>,1/12 material{Stop_Light_Material}}
         cylinder{<0,1.5-1/12,0>,<left_right*1,1.5-1/12,0>,1/12 material{Stop_Light_Material}}

         #if(walk)
            text { ttf "c:\windows\fonts\arialn.ttf" "WALK" 4*Epsilon, 0      
               pigment {Green} finish {ambient .8 diffuse .1} 
               scale <0.5,0.5,1>
               rotate<0,180,0>
               translate <left_right*(21/12)+7/12, 2/12, 1-4/12+Epsilon>
            }              
         #else      
            text { ttf "c:\windows\fonts\arialn.ttf" "DON'T" 4*Epsilon, 0      
               pigment {Red} finish {ambient .8 diffuse .1}                                  
               scale <0.5,0.5,1>
               rotate<0,180,0>
               translate <left_right*(21/12)+7/12, 1.5/2+1/12, 1-4/12+Epsilon>                                             
            }      
            text { ttf "c:\windows\fonts\arialn.ttf" "WALK" 4*Epsilon, 0      
               pigment {Red} finish {ambient .8 diffuse .1} 
               scale <0.5,0.5,1>
               rotate<0,180,0>     
               translate <left_right*(21/12)+7/12, 2/12, 1-4/12+Epsilon>               
            }    
         #end
         
      }
   }
#end


// two by four board
#declare twobyfour = object{
   box{<0,0,0>,<4/12,1,2/12>  material{Wood_Material}}
}

//plywood
#declare plywood = object{
   box{<0,0,0>,<8,2/12,4>  material{Wood_Material}}
}

         
//mailbox
#declare mail_box = object {
   union { 
      box {<0,1,0>,<3,4,3> }         
      cylinder {<0,4,3/2>,<3,4,3/2>,3/2}
      box {<0,0,0>,<3/12,1,3/12>}
      box {<3,0,0>,<3-3/12,1,3/12>}
      box {<0,0,3>,<3/12,1,3-3/12>}
      box {<3,0,3>,<3-3/12,1,3-3/12>}      
      box {<0,4-3/2-5/12,3/2-4/12>,<-Epsilon,4-3/2+5/12,3/2+4/12> pigment {White} finish {ambient .6 diffuse .1}}
      box {<3,4-3/2-5/12,3/2-4/12>,<3+Epsilon,4-3/2+5/12,3/2+4/12> pigment {White} finish {ambient .6 diffuse .1}}
   } 
   pigment {DarkSlateBlue} finish {ambient .3 diffuse .5}
}
         

//one_way sign
#declare one_way_sign_right = object {
   union{
      box {<0, 0, 0>,<4, 1.3, 1/12> pigment {White} finish {ambient .8 diffuse .1} }
      box {<2/12, 2/12, -Epsilon>,<4-2/12, 1.3-2/12, 1/12+Epsilon> pigment {Black} finish {ambient .8 diffuse .1} }
      prism {
         linear_sweep
         linear_spline
         0, // sweep the following shape from here ...
         3*Epsilon, // ... up through here
         8, // the number of points making up the shape ...
         <4-5/12, 5/12>, <12/12, 5/12>, <12/12, 2/12>, <2/12, 1.3/2>,
         <12/12, 1.3-2/12>, <12/12, 1.3-5/12>, <4-5/12, 1.3-5/12>, 
         <4-5/12, 5/12>
         rotate<-90,0,0>
         pigment {White} finish {ambient .8 diffuse .1}
      }
      text { ttf "c:\windows\fonts\arialn.ttf" "ONE WAY" 4*Epsilon, 0      
         pigment {Black} finish {ambient .8 diffuse .1} 
         scale <0.8,0.5,1>
         translate <6/12, 5.5/12, -4*Epsilon>
      }
   }
} 


//silly sewer grating
#declare sewer = object {
   union { 
      box{<0,0,0>,<3,Epsilon,4> pigment {Black} finish {ambient .8 diffuse .1}}
      box{<0,-Epsilon,0>,<2/12,2*Epsilon,4> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<3/2-1/12,-Epsilon,0>,<3/2+1/12,2*Epsilon,4> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<3-2/12,-Epsilon,0>,<3,2*Epsilon,4> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,0.0>,<3,2*Epsilon,2/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,0.5-1/12>,<3,2*Epsilon,0.5+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,1.0-1/12>,<3,2*Epsilon,1.0+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,1.5-1/12>,<3,2*Epsilon,1.5+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,2.0-1/12>,<3,2*Epsilon,2.0+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,2.5-1/12>,<3,2*Epsilon,2.5+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,3.0-1/12>,<3,2*Epsilon,3.0+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,3.5-1/12>,<3,2*Epsilon,3.5+1/12> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
      box{<0,-Epsilon,4.0-2/12>,<3,2*Epsilon,4.0> pigment {Gray30} finish {ambient .2 diffuse .6 specular .4}}
   }
} 


// Generated by SPatch
#declare lamp_fixture = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, 0.120> <0.000, 0.928, 0.272> <0.000, 0.898, 0.388> 
		<0.000, 0.998, -0.064> <0.000, 0.998, 0.056> <0.212, 0.928, 0.272> <0.212, 0.898, 0.388> 
		<0.000, 0.928, -0.132> <0.167, 0.928, -0.132> <0.388, 0.898, 0.045> <0.388, 0.898, 0.212> 
		<0.000, 0.898, -0.188> <0.167, 0.898, -0.188> <0.388, 0.898, -0.167> <0.388, 0.898, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> 
		<0.120, 0.998, -0.000> <0.120, 0.998, -0.064> <0.120, 0.998, -0.064> <0.000, 0.998, -0.064> 
		<0.303, 0.983, -0.000> <0.303, 0.983, -0.167> <0.167, 0.928, -0.132> <0.000, 0.928, -0.132> 
		<0.388, 0.898, 0.000> <0.388, 0.898, -0.167> <0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.064> <0.000, 0.928, -0.132> <0.000, 0.898, -0.188> 
		<0.000, 0.998, 0.120> <0.000, 0.998, 0.056> <-0.167, 0.928, -0.132> <-0.167, 0.898, -0.188> 
		<0.000, 0.928, 0.272> <-0.212, 0.928, 0.272> <-0.388, 0.898, 0.045> <-0.388, 0.898, -0.167> 
		<0.000, 0.898, 0.388> <-0.212, 0.898, 0.388> <-0.388, 0.898, 0.212> <-0.388, 0.898, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> 
		<-0.120, 0.998, -0.000> <-0.120, 0.998, -0.064> <-0.120, 0.998, -0.064> <0.000, 0.998, -0.064> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, -0.167> <-0.167, 0.928, -0.132> <0.000, 0.928, -0.132> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, -0.167> <-0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.064> <0.000, 0.928, -0.132> <0.000, 0.898, -0.188> 
		<-0.120, 0.998, -0.000> <-0.120, 0.998, -0.064> <0.000, 0.928, 0.041> <0.000, 0.898, -0.015> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, 0.212> <-0.212, 0.898, 0.215> <0.000, 0.898, 0.215> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, 0.212> <-0.212, 0.898, 0.388> <0.000, 0.898, 0.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.064> <0.000, 0.928, -0.132> <0.000, 0.898, -0.188> 
		<0.120, 0.998, -0.000> <0.120, 0.998, -0.064> <0.000, 0.928, 0.041> <0.000, 0.898, -0.015> 
		<0.303, 0.983, -0.000> <0.303, 0.983, 0.212> <0.212, 0.898, 0.215> <0.000, 0.898, 0.215> 
		<0.388, 0.898, 0.000> <0.388, 0.898, 0.212> <0.212, 0.898, 0.388> <0.000, 0.898, 0.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> 
		<0.000, 0.998, 0.120> <0.000, 0.998, 0.056> <0.000, 0.998, 0.056> <0.000, 0.998, -0.064> 
		<0.000, 0.928, 0.272> <0.000, 0.928, 0.099> <0.000, 0.928, 0.041> <0.000, 0.928, -0.132> 
		<0.000, 0.898, 0.388> <0.000, 0.898, 0.215> <0.000, 0.898, -0.015> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> 
		<-0.120, 0.998, -0.000> <-0.120, 0.998, 0.120> <-0.120, 0.998, 0.120> <0.000, 0.998, 0.120> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, 0.212> <-0.212, 0.928, 0.272> <0.000, 0.928, 0.272> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, 0.212> <-0.212, 0.898, 0.388> <0.000, 0.898, 0.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> <0.000, 0.998, -0.000> 
		<0.000, 0.998, 0.120> <0.120, 0.998, 0.120> <0.120, 0.998, 0.120> <0.120, 0.998, -0.000> 
		<0.000, 0.928, 0.272> <0.212, 0.928, 0.272> <0.303, 0.983, 0.212> <0.303, 0.983, -0.000> 
		<0.000, 0.898, 0.388> <0.212, 0.898, 0.388> <0.388, 0.898, 0.212> <0.388, 0.898, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, 0.120> <0.000, 0.928, 0.272> <0.000, 0.898, 0.388> 
		<0.120, 0.998, -0.000> <0.120, 0.998, 0.120> <0.000, 0.928, 0.099> <0.000, 0.898, 0.215> 
		<0.303, 0.983, -0.000> <0.303, 0.983, -0.167> <0.167, 0.898, -0.015> <0.000, 0.898, -0.015> 
		<0.388, 0.898, 0.000> <0.388, 0.898, -0.167> <0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.000, 0.998, 0.120> <0.000, 0.928, 0.272> <0.000, 0.898, 0.388> 
		<-0.120, 0.998, -0.000> <-0.120, 0.998, 0.120> <0.000, 0.928, 0.099> <0.000, 0.898, 0.215> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, -0.167> <-0.167, 0.898, -0.015> <0.000, 0.898, -0.015> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, -0.167> <-0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.120, 0.998, -0.000> <0.303, 0.983, -0.000> <0.388, 0.898, 0.000> 
		<-0.120, 0.998, -0.000> <0.000, 0.998, -0.000> <0.303, 0.983, 0.212> <0.388, 0.898, 0.212> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, 0.212> <0.000, 0.898, 0.388> <0.212, 0.898, 0.388> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, 0.212> <-0.212, 0.898, 0.388> <0.000, 0.898, 0.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.998, -0.000> <0.120, 0.998, -0.000> <0.303, 0.983, -0.000> <0.388, 0.898, 0.000> 
		<-0.120, 0.998, -0.000> <0.000, 0.998, -0.000> <0.303, 0.983, -0.167> <0.388, 0.898, -0.167> 
		<-0.303, 0.983, -0.000> <-0.303, 0.983, -0.167> <0.000, 0.898, -0.188> <0.167, 0.898, -0.188> 
		<-0.388, 0.898, 0.000> <-0.388, 0.898, -0.167> <-0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.388, 0.898, 0.000> <-0.388, 0.898, 0.000> <-0.388, 0.898, 0.000> <-0.388, 0.898, 0.000> 
		<-0.388, 0.898, 0.212> <-0.388, 0.898, 0.045> <-0.388, 0.898, 0.045> <-0.388, 0.898, -0.167> 
		<-0.212, 0.898, 0.388> <-0.212, 0.898, 0.215> <-0.167, 0.898, -0.015> <-0.167, 0.898, -0.188> 
		<0.000, 0.898, 0.388> <0.000, 0.898, 0.215> <0.000, 0.898, -0.015> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.388, 0.898, 0.000> <-0.388, 0.898, -0.167> <-0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
		<-0.476, 0.811, 0.000> <-0.476, 0.811, -0.166> <-0.167, 0.779, -0.221> <0.000, 0.779, -0.221> 
		<-0.481, 0.624, 0.000> <-0.481, 0.624, -0.224> <-0.224, 0.621, -0.265> <0.000, 0.621, -0.265> 
		<-0.498, 0.502, 0.000> <-0.498, 0.502, -0.224> <-0.224, 0.502, -0.298> <0.000, 0.502, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.388, 0.898, 0.000> <-0.476, 0.811, 0.000> <-0.481, 0.624, 0.000> <-0.498, 0.502, 0.000> 
		<-0.388, 0.898, 0.212> <-0.476, 0.811, 0.212> <-0.481, 0.624, 0.272> <-0.498, 0.502, 0.272> 
		<-0.212, 0.898, 0.388> <-0.212, 0.779, 0.421> <-0.272, 0.621, 0.465> <-0.272, 0.502, 0.498> 
		<0.000, 0.898, 0.388> <0.000, 0.779, 0.421> <0.000, 0.621, 0.465> <0.000, 0.502, 0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.898, 0.388> <0.000, 0.898, 0.388> <0.000, 0.898, 0.388> <0.000, 0.898, 0.388> 
		<0.212, 0.898, 0.388> <0.212, 0.898, 0.215> <0.212, 0.898, 0.215> <0.000, 0.898, 0.215> 
		<0.388, 0.898, 0.212> <0.388, 0.898, 0.045> <0.167, 0.898, -0.015> <0.000, 0.898, -0.015> 
		<0.388, 0.898, 0.000> <0.388, 0.898, -0.167> <0.167, 0.898, -0.188> <0.000, 0.898, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.898, 0.388> <0.000, 0.779, 0.421> <0.000, 0.621, 0.465> <0.000, 0.502, 0.498> 
		<0.212, 0.898, 0.388> <0.212, 0.779, 0.421> <0.272, 0.621, 0.465> <0.272, 0.502, 0.498> 
		<0.388, 0.898, 0.212> <0.476, 0.811, 0.212> <0.481, 0.624, 0.272> <0.498, 0.502, 0.272> 
		<0.388, 0.898, 0.000> <0.476, 0.811, 0.000> <0.481, 0.624, 0.000> <0.498, 0.502, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.388, 0.898, 0.000> <0.476, 0.811, 0.000> <0.481, 0.624, 0.000> <0.498, 0.502, 0.000> 
		<0.388, 0.898, -0.167> <0.476, 0.811, -0.166> <0.481, 0.624, -0.224> <0.498, 0.502, -0.224> 
		<0.167, 0.898, -0.188> <0.167, 0.779, -0.221> <0.224, 0.621, -0.265> <0.224, 0.502, -0.298> 
		<0.000, 0.898, -0.188> <0.000, 0.779, -0.221> <0.000, 0.621, -0.265> <0.000, 0.502, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.498, 0.502, 0.000> <-0.498, 0.502, 0.000> <-0.498, 0.502, 0.000> <-0.498, 0.502, 0.000> 
		<-0.498, 0.502, 0.272> <-0.498, 0.502, 0.048> <-0.498, 0.502, 0.048> <-0.498, 0.502, -0.224> 
		<-0.272, 0.502, 0.498> <-0.272, 0.502, 0.259> <-0.224, 0.502, -0.059> <-0.224, 0.502, -0.298> 
		<0.000, 0.502, 0.498> <0.000, 0.502, 0.259> <0.000, 0.502, -0.059> <0.000, 0.502, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.498, 0.502, 0.000> <-0.498, 0.502, -0.224> <-0.224, 0.502, -0.298> <0.000, 0.502, -0.298> 
		<-0.515, 0.383, 0.000> <-0.515, 0.383, -0.224> <-0.224, 0.382, -0.298> <0.000, 0.382, -0.298> 
		<-0.512, 0.221, 0.000> <-0.512, 0.221, -0.224> <-0.224, 0.221, -0.312> <0.000, 0.221, -0.312> 
		<-0.498, 0.102, 0.000> <-0.498, 0.102, -0.224> <-0.224, 0.102, -0.298> <0.000, 0.102, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.498, 0.502, 0.000> <-0.515, 0.383, 0.000> <-0.512, 0.221, 0.000> <-0.498, 0.102, 0.000> 
		<-0.498, 0.502, 0.272> <-0.515, 0.383, 0.272> <-0.512, 0.221, 0.272> <-0.498, 0.102, 0.272> 
		<-0.272, 0.502, 0.498> <-0.272, 0.382, 0.498> <-0.272, 0.221, 0.512> <-0.272, 0.102, 0.498> 
		<0.000, 0.502, 0.498> <0.000, 0.382, 0.498> <0.000, 0.221, 0.512> <0.000, 0.102, 0.498> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.502, 0.498> <0.000, 0.502, 0.498> <0.000, 0.502, 0.498> <0.000, 0.502, 0.498> 
		<0.272, 0.502, 0.498> <0.272, 0.502, 0.259> <0.272, 0.502, 0.259> <0.000, 0.502, 0.259> 
		<0.498, 0.502, 0.272> <0.498, 0.502, 0.048> <0.224, 0.502, -0.059> <0.000, 0.502, -0.059> 
		<0.498, 0.502, 0.000> <0.498, 0.502, -0.224> <0.224, 0.502, -0.298> <0.000, 0.502, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.502, 0.498> <0.000, 0.382, 0.498> <0.000, 0.221, 0.512> <0.000, 0.102, 0.498> 
		<0.272, 0.502, 0.498> <0.272, 0.382, 0.498> <0.272, 0.221, 0.512> <0.272, 0.102, 0.498> 
		<0.498, 0.502, 0.272> <0.515, 0.383, 0.272> <0.512, 0.221, 0.272> <0.498, 0.102, 0.272> 
		<0.498, 0.502, 0.000> <0.515, 0.383, 0.000> <0.512, 0.221, 0.000> <0.498, 0.102, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.498, 0.502, 0.000> <0.515, 0.383, 0.000> <0.512, 0.221, 0.000> <0.498, 0.102, 0.000> 
		<0.498, 0.502, -0.224> <0.515, 0.383, -0.224> <0.512, 0.221, -0.224> <0.498, 0.102, -0.224> 
		<0.224, 0.502, -0.298> <0.224, 0.382, -0.298> <0.224, 0.221, -0.312> <0.224, 0.102, -0.298> 
		<0.000, 0.502, -0.298> <0.000, 0.382, -0.298> <0.000, 0.221, -0.312> <0.000, 0.102, -0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.498, 0.102, 0.000> <-0.498, 0.102, -0.224> <-0.224, 0.102, -0.298> <0.000, 0.102, -0.298> 
		<-0.484, -0.021, 0.000> <-0.484, -0.021, -0.224> <-0.224, -0.021, -0.284> <0.000, -0.021, -0.284> 
		<-0.449, -0.183, 0.000> <-0.449, -0.183, -0.176> <-0.176, -0.176, -0.223> <0.000, -0.176, -0.223> 
		<-0.406, -0.298, 0.000> <-0.406, -0.298, -0.176> <-0.176, -0.298, -0.206> <0.000, -0.298, -0.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.498, 0.102, 0.000> <-0.484, -0.021, 0.000> <-0.449, -0.183, 0.000> <-0.406, -0.298, 0.000> 
		<-0.498, 0.102, 0.272> <-0.484, -0.021, 0.272> <-0.449, -0.183, 0.222> <-0.406, -0.298, 0.222> 
		<-0.272, 0.102, 0.498> <-0.272, -0.021, 0.484> <-0.222, -0.183, 0.449> <-0.222, -0.298, 0.406> 
		<0.000, 0.102, 0.498> <0.000, -0.021, 0.484> <0.000, -0.183, 0.449> <0.000, -0.298, 0.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.102, 0.498> <0.000, -0.021, 0.484> <0.000, -0.183, 0.449> <0.000, -0.298, 0.406> 
		<0.272, 0.102, 0.498> <0.272, -0.021, 0.484> <0.222, -0.183, 0.449> <0.222, -0.298, 0.406> 
		<0.498, 0.102, 0.272> <0.484, -0.021, 0.272> <0.449, -0.183, 0.222> <0.406, -0.298, 0.222> 
		<0.498, 0.102, 0.000> <0.484, -0.021, 0.000> <0.449, -0.183, 0.000> <0.406, -0.298, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.498, 0.102, 0.000> <0.484, -0.021, 0.000> <0.449, -0.183, 0.000> <0.406, -0.298, 0.000> 
		<0.498, 0.102, -0.224> <0.484, -0.021, -0.224> <0.449, -0.183, -0.176> <0.406, -0.298, -0.176> 
		<0.224, 0.102, -0.298> <0.224, -0.021, -0.284> <0.176, -0.176, -0.223> <0.176, -0.298, -0.206> 
		<0.000, 0.102, -0.298> <0.000, -0.021, -0.284> <0.000, -0.176, -0.223> <0.000, -0.298, -0.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, -0.698, 0.000> <-0.262, -0.578, 0.000> <-0.359, -0.425, 0.000> <-0.406, -0.298, 0.000> 
		<-0.200, -0.698, -0.107> <-0.262, -0.578, -0.107> <-0.359, -0.425, -0.176> <-0.406, -0.298, -0.176> 
		<-0.107, -0.698, -0.191> <-0.107, -0.578, -0.196> <-0.176, -0.417, -0.190> <-0.176, -0.298, -0.206> 
		<0.000, -0.698, -0.191> <0.000, -0.578, -0.196> <0.000, -0.417, -0.190> <0.000, -0.298, -0.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, -0.698, 0.000> <-0.200, -0.698, 0.109> <-0.109, -0.698, 0.200> <0.000, -0.698, 0.200> 
		<-0.262, -0.578, 0.000> <-0.262, -0.578, 0.109> <-0.109, -0.578, 0.262> <0.000, -0.578, 0.262> 
		<-0.359, -0.425, 0.000> <-0.359, -0.425, 0.222> <-0.222, -0.425, 0.359> <0.000, -0.425, 0.359> 
		<-0.406, -0.298, 0.000> <-0.406, -0.298, 0.222> <-0.222, -0.298, 0.406> <0.000, -0.298, 0.406> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.698, 0.200> <0.109, -0.698, 0.200> <0.200, -0.698, 0.109> <0.200, -0.698, 0.000> 
		<0.000, -0.578, 0.262> <0.109, -0.578, 0.262> <0.262, -0.578, 0.109> <0.262, -0.578, 0.000> 
		<0.000, -0.425, 0.359> <0.222, -0.425, 0.359> <0.359, -0.425, 0.222> <0.359, -0.425, 0.000> 
		<0.000, -0.298, 0.406> <0.222, -0.298, 0.406> <0.406, -0.298, 0.222> <0.406, -0.298, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.200, -0.698, 0.000> <0.200, -0.698, -0.107> <0.107, -0.698, -0.191> <0.000, -0.698, -0.191> 
		<0.262, -0.578, 0.000> <0.262, -0.578, -0.107> <0.107, -0.578, -0.196> <0.000, -0.578, -0.196> 
		<0.359, -0.425, 0.000> <0.359, -0.425, -0.176> <0.176, -0.417, -0.190> <0.000, -0.417, -0.190> 
		<0.406, -0.298, 0.000> <0.406, -0.298, -0.176> <0.176, -0.298, -0.206> <0.000, -0.298, -0.206> 
	}
}

#declare streetlight = object{
   union{
      union{
         cone{<0,0,0>,1,<0,3,0>, 0.7 }
         cone{<0,3,0>,.5,<0,16,0>,0.3}
         difference{
            torus{6,.3}
            box{<-10,2,0>,<10,-2,10>}
            box{<0,2,-10>,<10,-2,10>}
            rotate<90,0,0> 
            translate<6,16,0>            
         }
         object {lamp_fixture
            scale 1.5
            rotate <180,270,90>
            translate <6,16+6,0>                
         }      
         material {Post_Material}
      }
      difference{
         sphere{<0,0,0>,0.5 scale<1.5,1,1>}
         box{<-4,0,-4>,<4,4,4>}
         material {Lamp_Glass}
         translate<6+.8,16+6-0.3,0>
      }                              
      pigment{White} //dummy pigment to get rid of "no pigment statements"
   }
}