///////////////////////////////////////////////////////////////////////////////
//
// BLDGVIEW.POV
//
// Written By : Jeffrey C. Loper
// Finished on : 4-29-00
//
// Inc : BLDGVIEW.INC, COLORS.INC, TEXTURES.INC
//
// Desc : A view of three buildings, one under construction.
// For submission to IRTC April,2000
//
// Notice : Copywrite(C) J.C. Loper 4/29/00. Not for use in commercial productions.
//
///////////////////////////////////////////////////////////////////////////////

//global setting
global_settings { ambient_light 1}
global_settings { max_trace_level 12 }                                         
global_settings { adc_bailout 1/255 }

//includes
#include "colors.inc"                  
#include "textures.inc" 
#include "bldgview.inc"

//camera
camera {  
   location <-110,58,14>   
   look_at <0,25,0> 
}       

//lightsource                                  
light_source { <-10000, 20000, -10000> White}
light_source { <-100, 200, -100> White shadowless }    

//background
background {SkyBlue} 








                                          
//street layer under sidewalk 
box {<-Edge, 0, -Edge>, <Edge, -Epsilon, Edge>
   material {Street_Material}
}



//street lines
difference{
   box {<-street_A_width/2-sw_bottom_width,Epsilon,-street_B_width/2-sw_bottom_width>,<street_A_width/2+sw_bottom_width,0,street_B_width/2+sw_bottom_width>}
   box {<-(street_A_width/2-.5)-sw_bottom_width,1,-(street_B_width/2-.5)-sw_bottom_width>,<(street_A_width/2-.5)+sw_bottom_width,-1,(street_B_width/2-.5)+sw_bottom_width>}
   material {Street_line_texture}
}
difference{
   box {<-street_A_width/2-sw_width,Epsilon,-street_B_width/2-sw_width>,<street_A_width/2+sw_width,0,street_B_width/2+sw_width>}
   box {<-(street_A_width/2-.5)-sw_width,1,-(street_B_width/2-.5)-sw_width>,<(street_A_width/2-.5)+sw_width,-1,(street_B_width/2-.5)+sw_width>}
   material {Street_line_texture}
}
#declare cnt=0;
#while (cnt<4)
   box {<-street_A_width/2-sw_width-10-20*cnt, Epsilon, street_B_width/2-street_B_width/3+0.3>, <-street_A_width/2-sw_width-20-20*cnt, Epsilon, street_B_width/2-street_B_width/3-0.3> material {Street_line_texture}}
   box {<-street_A_width/2-sw_width-10-20*cnt, Epsilon, street_B_width/2-street_B_width*2/3+0.3>, <-street_A_width/2-sw_width-20-20*cnt, Epsilon, street_B_width/2-street_B_width*2/3-0.3> material {Street_line_texture}}
   
   box {<street_A_width/2-street_B_width/3+0.3, Epsilon, -street_B_width/2-sw_width-10-20*cnt>, <street_A_width/2-street_B_width/3-0.3, Epsilon, -street_B_width/2-sw_width-20-20*cnt> material {Street_line_texture}}
   box {<street_A_width/2-street_B_width*2/3+0.3, Epsilon, -street_B_width/2-sw_width-10-20*cnt>, <street_A_width/2-street_B_width*2/3-0.3, Epsilon, -street_B_width/2-sw_width-20-20*cnt> material {Street_line_texture}}
   
   box {<street_A_width/2-street_B_width/3+0.3, Epsilon, street_B_width/2+sw_width+10+20*cnt>, <street_A_width/2-street_B_width/3-0.3, Epsilon, street_B_width/2+sw_width+20+20*cnt> material {Street_line_texture}}
   box {<street_A_width/2-street_B_width*2/3+0.3, Epsilon, street_B_width/2+sw_width+10+20*cnt>, <street_A_width/2-street_B_width*2/3-0.3, Epsilon, street_B_width/2+sw_width+20+20*cnt> material {Street_line_texture}}

   #declare cnt=cnt+1;
#end



//sidewalk BA
box {<-street_A_width/2, 0, street_B_width/2>, <-Edge, sw_height, Edge>       
   material {SW_Material}
} 
box {<-street_A_width/2+Epsilon, 0, street_B_width/2-Epsilon>, <-Edge, sw_height-Epsilon, Edge>       
   material {SW_Material_Yellow}
} 
box {<-street_A_width/2+sw_bottom_width, Epsilon, street_B_width/2-sw_bottom_width>, <-Edge, Epsilon, Edge>       
   material {SW_Material_Yellow}
}          

//sidewalk BB
box {<street_A_width/2, 0, -Edge>, <Edge, sw_height, Edge>
   material {SW_Material}
} 
box {<street_A_width/2-Epsilon, 0, -Edge>, <Edge, sw_height-Epsilon, Edge>
   material {SW_Material_Yellow}
}
box {<street_A_width/2-sw_bottom_width, Epsilon, -Edge>, <Edge, Epsilon, Edge>
   material {SW_Material_Yellow}
}            

//sidewalk BC
box {<-street_A_width/2, 0, -street_B_width/2>, <-Edge,sw_height,-Edge>       
   material {SW_Material}
}   
box {<-street_A_width/2+Epsilon, 0, -street_B_width/2+Epsilon>, <-Edge,sw_height-Epsilon,-Edge>       
   material {SW_Material_Yellow}
} 
box {<-street_A_width/2+sw_bottom_width, Epsilon, -street_B_width/2+sw_bottom_width>, <-Edge, Epsilon ,-Edge>       
   material {SW_Material_Yellow}
}             



// buildings A,B,C                     
object{Building_A 
   rotate<0,-90,0>
   translate BA_anchor
}     
object{Building_B 
   rotate<0,90,0>
   translate BB_anchor
} 
object{Building_C
   rotate<0,180,0>
   translate BC_anchor+<2*BC_spacer,0,2*BC_spacer>
}     

//buildings beside and behind BA and BC (used for relections and shadowns only)     
box {<0,0,0>,<-300,200,-2*BC_floor_length_z>
   translate BC_anchor-<BC_floor_length_x+20,0,0>
   pigment {Brown}
} 
object{Building_A 
   rotate<0,-180,0>
   translate BC_anchor-<0,50,BC_floor_length_z+12>
} 
box {<0,0,0>,<-280,200,200>
   translate BA_anchor-<BA_face_A_width+8,0,0>
   pigment {Brown}
}
box {<0,0,0>,<-300,170,200>
   translate BA_anchor-<BA_face_A_width+8+280,0,0>
   pigment {Gray30}
}    
box {<0,0,0>,<200,1000,200>
   translate <-1000,0,-100>
   pigment {Gray30}
}  
 

      
//stoplights
object{StopLight(3,<0,0,0>) translate <-street_A_width/2-1, sw_height, -(street_B_width/2+1)>}
object{StopLight(1,<0,0,0>) rotate<0,90,0> translate <-street_A_width/2-1, sw_height, street_B_width/2+1> }

            
            
//streetlights                                                                                  
object{streetlight rotate<0,90,0>  translate <-street_A_width/2-.5-40, sw_height, street_B_width/2+.8> }
object{streetlight rotate<0,-90,0> translate <-street_A_width/2-.5-40, sw_height, -(street_B_width/2+.8)>}
object{streetlight translate <-street_A_width/2-.5, sw_height, -(street_B_width/2+.5+40)>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height, -street_B_width/2-sw_width-1>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height,  street_B_width/2+sw_width+1>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height,  60>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height, -60>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height,  90>}
object{streetlight rotate<0,-180,0> translate <street_A_width/2+.8, sw_height, -90>}
      
              
              
//one_way sign
object{one_way_sign_right rotate<0,90,0> translate <-street_A_width/2-1-0.45, sw_height+12, -(street_B_width/2+1)+4/2> }   
object{one_way_sign_right rotate<0,90,0> translate <-street_A_width/2-1-0.45, sw_height+12, street_B_width/2+1+4/2> }   



//crosswalk light
object {Cross_Walk_Light(1,1) rotate<0,180,0> translate <-(street_A_width/2+1), sw_height+8, (street_B_width/2+1)>}
object {Cross_Walk_Light(0,0) rotate<0,90,0> translate <-(street_A_width/2+1), sw_height+8, (street_B_width/2+1)>}
object {Cross_Walk_Light(0,1) rotate<0,0,0> translate <-(street_A_width/2+1), sw_height+8, -(street_B_width/2+1)>}
object {Cross_Walk_Light(1,0) rotate<0,90,0> translate <-(street_A_width/2+1), sw_height+8, -(street_B_width/2+1)>}
object {Cross_Walk_Light(1,0) rotate<0,180+90,0> translate <(street_A_width/2+1), sw_height+8, -(street_B_width/2+sw_width+1)>}
object {Cross_Walk_Light(0,0) rotate<0,180+90,0> translate <(street_A_width/2+1), sw_height+8, (street_B_width/2+sw_width+1)>}



///////////////////
//sidewalk barrier 
///////////////////
//posts
object {twobyfour scale <1,6,1> translate BC_anchor+<0,Epsilon,sw_width+BC_spacer>}
object {twobyfour scale <1,6,1> translate BC_anchor+<sw_width,Epsilon,0+BC_spacer>}
object {twobyfour scale <1,9,1> translate BC_anchor+<0,Epsilon,0+BC_spacer>}
#declare cnt = 1;
#while (cnt<BC_floor_length_x/3.5)
   object {twobyfour scale <1,6,1> translate BC_anchor+<-3.5*cnt+.5*(2*rand(R1)-1),Epsilon,sw_width+BC_spacer>}
   object {twobyfour scale <1,9,1> translate BC_anchor+<-3.5*cnt+.5*(2*rand(R1)-1),Epsilon,0+BC_spacer>}          
   object {twobyfour scale <1,6,1> translate BC_anchor+<sw_width,Epsilon,-3.5*cnt+.5*(2*rand(R1)-1)+BC_spacer>}
   object {twobyfour scale <1,9,1> translate BC_anchor+<0,Epsilon,-3.5*cnt+.5*(2*rand(R1)-1)+BC_spacer>}             
   #declare cnt=cnt+1;
#end

//front plywood   
#declare cnt = 1;
#while (cnt<BC_floor_length_x/8)  
   object {plywood  rotate <-90,0,5*(2*rand(R1)-1)>  translate BC_anchor+<-8*cnt,1*rand(R1),sw_width+2/12+BC_spacer>}
   object {plywood  rotate <-90,90,5*(2*rand(R1)-1)>  translate BC_anchor+<sw_width+2/12,1*rand(R1),-8*(cnt-1)+BC_spacer>}
   #declare cnt=cnt+1;                                                                                                        
#end

//back plywood
#declare cnt = 0;
#while (cnt<BC_floor_length_x/4)  
   object {plywood  rotate <-90,0,90+3*(2*rand(R1)-1)>  translate BC_anchor+<-4*cnt,1*rand(R1),2/12>+BC_spacer}
   object {plywood  rotate <180,0,90+3*(2*rand(R1)-1)>  translate BC_anchor+<2/12,1*rand(R1),-4*cnt+BC_spacer>}
   #declare cnt=cnt+1;                                                                                                        
#end

//top plywood
#declare cnt = 0;
#while (cnt<BC_floor_length_x/4)  
   object {plywood  rotate <-90,0,90+2*(2*rand(R1)-1)> rotate<-degrees(acos((9-6)/sw_width))+0*(2*rand(R1)-1),0,0> translate BC_anchor+<-4*cnt,6+(.3*rand(R1)),sw_width+2/12+(.5*rand(R1))+BC_spacer>}
   object {plywood  rotate <180,0,90+2*(2*rand(R1)-1)> rotate<0,0,degrees(acos((9-6)/sw_width))+0*(2*rand(R1)-1)> translate BC_anchor+<sw_width+2/12+(.5*rand(R1)),6+(.3*rand(R1)),-4*cnt+BC_spacer>}
   #declare cnt=cnt+1;                                                                                                        
#end


                      
//mailbox
object {mail_box rotate<0,90,0> translate <street_A_width/2+1, sw_height, -30>}




////////////////
//Items in construction area (for the most part all added emperically, i.e. no formulas just placement)
////////////////
//platforms
object {BC_platform scale <.4,1,.2> rotate<-78,90,0> translate<-27.5,BC_base_height,-40>}
object {BC_platform scale <.4,1,.2> rotate<-75,90,0> translate<-28.5,BC_base_height,-39>}
object {BC_platform scale <.4,1,.2> rotate<-65,90,0> translate<-30,BC_base_height,-44>}

//I-beams
object {BC_ib_individual scale<.42,1,1> rotate<0,8,0> translate<-50.4,BC_base_height+BC_beam_height,-38.5> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.47,1,1> rotate<0,12,0> translate<-50,BC_base_height+BC_beam_height,-40> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.43,1,1> rotate<0,10,0> translate<-49,BC_base_height+BC_beam_height,-42> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.41,1,1> rotate<0,12,0> translate<-50.5,BC_base_height+BC_beam_height,-43> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.42,1,1> rotate<0,15,0> translate<-51,BC_base_height+BC_beam_height,-44> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.37,1,1> rotate<0,12,0> translate<-50,BC_base_height+BC_beam_height,-46.5> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.40,1,1> rotate<0,19,0> translate<-50.2,BC_base_height+BC_beam_height,-48> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.28,1,1> rotate<0,-21,0> translate<-48,BC_base_height+2*BC_beam_height,-50> material{BC_beam_material_individual}}
object {BC_ib_individual scale<.37,1,1> rotate<0,-19,0> translate<-51,BC_base_height+2*BC_beam_height,-48> material{BC_beam_material_individual}}

//plywood
#declare cnt = 0;    
   #while (cnt<25) 
   object {plywood  rotate <0,25*(2*rand(R1)-1),0>  translate<-43,BC_base_height+cnt*2/12,-38>}
   #declare cnt=cnt+1;                                                                                                        
#end   
#declare cnt = 0;    
   #while (cnt<15) 
   object {plywood  rotate <0,25*(2*rand(R1)-1),0>  translate<-53,BC_base_height+cnt*2/12,-36>}
   #declare cnt=cnt+1;                                                                                                        
#end   
                      


//sewer
object {sewer rotate<0,90,0> translate<-45,3*Epsilon,(street_B_width/2)>}
object {sewer rotate<0,90,0> translate<-35,3*Epsilon,-(street_B_width/2-3)>}
object {sewer rotate<0,0,0> translate<(street_A_width/2-3),3*Epsilon,+40>}
object {sewer rotate<0,0,0> translate<(street_A_width/2-3),3*Epsilon,-50>}
object {sewer rotate<0,0,0> translate<-(street_A_width/2),3*Epsilon,70>}
object {sewer rotate<0,0,0> translate<-(street_A_width/2),3*Epsilon,-60>}



                      
#debug "\n\n*********************\nMy Debug Messages\n*********************\n\n"

//#debug concat("BB_curve_radius is:",str(BB_curve_radius,7,3),"\n")
//#debug concat("BB_curve_length is:",str(BB_curve_length,7,3),"\n")
//#debug concat("BB_door_radius is:",str(BB_door_radius,7,3),"\n")
//#debug concat("degrees:",str(5*BB_theta_wall+4*BB_theta_window,7,3),"\n")

#debug "\n\n*********************\nEnd Debug Messages\n*********************\n\n"
