#version unofficial MegaPov 0.4;


#macro O_Ecrou(sc)
intersection {
	box { -x-z, x+y+z }
	box { -x-3*z, x+y+3*z rotate y*60 }
	box { -x-3*z, x+y+3*z rotate y*120 }
	scale sc
}
#end


#declare haut1 = 9.3;
#declare rayon1 = 10*sqrt(1-pow(haut1/10,2));

#declare F_Top = union {
	union {
		cylinder { 0, .3*y, 11.8 }
		cylinder { .3*y, 2*y, 12 }
		difference {
			intersection {
				box { -1.1*x -1.1*z, 1.1*x + y + 1.1*z }
				sphere {0, 1 }
				scale 10
			}
			#declare tmp = 8;
			#while (tmp >0)
				#declare tmp = tmp - 1;
				torus { 15, 5.5
					rotate x*90
					rotate y*360*tmp/8
					scale <1,1.11,1>
				}
			#end
			translate 2*y
		}
		cylinder { haut1*y, 9.8*y, rayon1 translate 2*y }
		texture { T_Fer_Rouge_Rouille }
	}
	union {
		object {
			O_Ecrou(<rayon1*.8, 1, rayon1*.8>)
			translate 9.8*y
			translate 2*y
		}
		object {
			rounded_bar(<-rayon1*.4, -.2, -rayon1*.4>, <rayon1*.4, 2, rayon1*.4>, .2)
			translate 10.8*y
			translate 2*y
		}
		texture { T_Bronze_Rouille }
	}
}


#declare F_Corps = union {
	union {
		torus { 1,1/6 scale <12, 6, 12> translate 1*y }
		cylinder { 0, 1*y, 12*(1+1/6) }
		cylinder { 0, 2*y, 12 }
		cone { 2*y, 11, 3*y, 10 }
		#declare tmp = 6;
		#while (tmp > 0)
			#declare tmp = tmp - 1;
			object {
				O_Ecrou(<1, 1, 1>)
				translate 2.01*y +  11.5*x
				rotate y*360*tmp/6
				texture { T_Bronze_Rouille }
			}
		#end
		difference {
			cylinder { 3*y, 40*y, 10 }
			#declare tmp = 20;
			#while (tmp >0)
				#declare tmp = tmp - 1;
				union {
					sphere { 0, 2 }
					cylinder { 0, 19*y, 2 }
					sphere { 19*y, 2 }
					translate y*4
					translate x*11.7
					rotate y*360*tmp/20
				}
			#end
		}
		union {
			cylinder { -15*x+30*y, 15*x+30*y, 5 }
			cylinder { 30*y, 30*y-16*z, 6 }
		}
		cylinder { 38*y, 39*y, 10.5 }
		cylinder { 39*y, 40*y, 11 }
		texture { T_Fer_Rouge_Rouille scale <1,2,1>}
	}
	union {
		superellipsoid { <.2,1>
			clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
			scale <6.2, 3, 6.2>
		}
		superellipsoid { <.3,1>
			clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
			scale <3.5, 1, 3.5>
			translate 3*y
		}
		object {
			O_Ecrou(<1.7, 1, 1.7>)
			translate 4*y
		}
		rotate -90*x
		translate 30*y - 16*z
		texture { T_Bronze_Rouille }
	}
	union {
		superellipsoid { <.25,1>
			clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
			scale <5.2, 2, 5.2>
		}
		superellipsoid { <.3,1>
			translate 2*y
			scale <3, 1, 3>
		}
		object {
			O_Ecrou(<1.7, 1, 1.7>)
			translate 3*y
		}
		rotate -90*x
		rotate -90*y
		translate 30*y + 15*x
		texture { T_Bronze_Rouille }
	}
	union {
		superellipsoid { <.3,1>
			clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
			scale <5.2, 2, 5.2>
		}
		superellipsoid { <.3,1>
			translate 2*y
			scale <3, 1, 3>
		}
		object {
			O_Ecrou(<1.7, 1, 1.7>)
			translate 3*y
		}
		rotate -90*x
		rotate 90*y
		translate 30*y - 15*x
		texture { T_Bronze_Rouille }
	}
}

/* un maillon */
#declare link_object = union {
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x * .6}
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x * .6 scale <-1, 1, 1>}
   cylinder {-x*.6, x*.6, .3 translate z * .7}
   cylinder {-x*.6, x*.6, .3 translate -z * .7}
   scale .5
}



#declare link_looseness = 15;
#declare link_count = 20;
#declare link_twist = .475;

#declare camera_sky = y-.01*x;
#declare link_point1 = <10, 25.2, 0>;
#declare link_point2 = <17, 28, 0>;
#declare O_Chaine1 = object { #include "link.inc" texture { T_Bronze_Rouille } }

#declare camera_sky = y+.01*x;
#declare link_point1 = <-10, 25.2, 0>;
#declare link_point2 = <-17, 28, 0>;
#declare O_Chaine2 = object { #include "link.inc" texture { T_Bronze_Rouille } }

#declare link_looseness = 14;
#declare link_count = 22;
#declare camera_sky = y+.01*z;
#declare link_point1 = <0, 24.5, -10>;
#declare link_point2 = <0, 27, -19>;
#declare O_Chaine3 = object { #include "link.inc" texture { T_Bronze_Rouille } }



#declare O_Fireplug = union {
	object { F_Top translate y*40 }
	object { F_Corps }
	object { O_Chaine1 }
	object { O_Chaine2 }
	object { O_Chaine3 }
}

