#version unofficial MegaPov 0.4;


#include "meshes/drap.inc"
#include "meshes/oreiller.inc"

#declare T_Matelas = texture {
	pigment {
		gradient x
		translate -100*x
		scale 15
		color_map {
			[.5 color rgb .9 ]
			[.5 color rgb<150,193,220>/255 ]
		}
	}
	normal { granite .6 scale <.2,.02,.02> }
	finish { ambient .4 diffuse .6 }
}
texture { T_Crasse scale 10 }
texture { T_Crasse2 scale 5 }
texture { T_Crasse2 scale 2 }
//texture { T_Crasse2 scale 1 }


#declare T_Oreiller = texture {
	pigment {
		gradient z
		translate -100*z
		scale 10
		color_map {
			[.6 color rgb .9 ]
			[.4 color rgb<150,193,220>/255 ]
		}
	}
	normal { granite .6 scale <.2,.02,.02> }
	finish { ambient .4 diffuse .6 }
}
texture { T_Crasse2 scale 5 }
texture { T_Crasse2 scale 2 }


#declare T_Drap = texture {
	pigment { color rgb .9 }
	finish { ambient .4 diffuse .6 }
}
texture { T_Crasse scale 10 }
texture { T_Crasse2 scale 5 }
texture { T_Crasse2 scale 2 }


#declare O_Matelas = object {
	superellipsoid {<.25,.15>}
	translate x+y+z
	scale <100, 8, 23>
	texture { T_Matelas }
}

#declare O_Drap = object {
	Drap_Mesh
	scale <3,6, 2*23/17.5>
	translate 16*y
	translate 23*z
	translate 160*x
	texture { T_Drap }
}

#declare O_Oreiller = object {
	Oreiller_Mesh
	translate 6.5*z
	translate y
	rotate -15*y
	scale 42/13
	translate 15.5*y
	translate 195*x
	translate 5*z
	texture { T_Oreiller translate 1*z rotate -15*y }
}

