#version unofficial MegaPov 0.4;

#declare St = seed (8563);



#declare Use_Rad = on;
#declare Place_Pancarte = on;
#declare Place_Cartons = on;
#declare Place_Matelas = on;
#declare Place_Godet = on;
#declare Place_Fireplug = on;
#declare Place_Mesh_1 = on;
#declare Place_Mesh_2 = off;
#declare Place_Mesh_3 = on;
#declare MB_NB_Samples = 60;
#declare Place_Canette = off;
#declare Place_Megots_T = on;
#declare Place_Megots_C = on;
#declare Nb_Megots_T = 12;
#declare Nb_Megots_C = 10;


#include "my_text.inc"
#include "mur.inc"
#include "trottoir.inc"
#include "cartons.inc"

#if ((Place_Megots_T) | (Place_Megots_C) | (Place_Canette))
	#include "trash.inc"
	#include "reorient.mcr"
#end

#if ((Place_Mesh_1) | (Place_Mesh_2) | (Place_Mesh_3))

	#include "meshes/meshes.inc"

	global_settings {
		ini_option "+K0.5"
		motion_blur MB_NB_Samples, 1
	}

#end

#if (Place_Matelas)
	#include "matelas.inc"
#end

#if (Place_Fireplug)
	#include "fireplug.inc"
#end


#if (Use_Rad)
global_settings {
	ini_option "+QR"
	radiosity {
		pretrace_start 0.08
		pretrace_end   0.02
		brightness .8
		count 70
		recursion_limit 4
	}
	ambient_light .3
}

//background { color rgb<.6, .7, .8>*7 }
sky_sphere { pigment { color rgb<.6, .7, .8>*5 } }
light_source { <50000,70000,-40000> rgb 1 }

box { <-600, -2, -1100>, <600, 400, -1000> pigment {color rgb<.8, .8, .4>} finish {ambient 2} }

#else

light_source { <50000,70000,-40000> rgb 1 }
light_source { <0,200,-600> rgb .2 shadowless }

#end


camera {
	location <-100, 80, -500>
	right x*image_width/image_height
	up y
	#if (image_width/image_height > (4/3))
	angle 23
	#else
	angle 20
	#end
	look_at <0, 35, 200>
}




#declare vmin = <-180,5,0>;
#declare vmax = <200,15,297.9>;
#declare nbdx = 6;
#declare nbdz = 4;
#declare lb = 10;
#declare nbb = 5;
#declare lc = 12;
#declare nbc = 10;
#declare xbouch = 50;
#declare lbouch = 20;
#declare xgrille = 90;
#declare l1grille = 30;
#declare l2grille = 40;
#declare locb = <40, .1, -80>;
#declare rayonb = 25;
#declare epb = 5.2;

#declare crack = array[4][6] {
	{0, 0, 1, 0, 0, 0},
	{0, 1, 0, 0, 0, 0},
	{0, 0, 0, 1, 0, 0},
	{0, 0, 0, 0, 1, 0},
}

/* Mur */
object {
	/*O_Mur1()*/
	O_Mur2(<23, 8, 4>, <400, 150, 5>, <2,2,1>, true, xgrille + l1grille*.5 + 202, 10, 60, 12)
	translate <-200, 6, 296>
}
O_Gouttiere(<xgrille + l1grille*.5, vmax.y+5, vmax.z - 5 -.5>, 80, 5, 2, 2)


object {
	Affiche(70, 700/7, "image_map/image1.png", 5)
	rotate z*5
	translate <-20, 90, 295.8>
}

object {
	Affiche(60, 600/7, "image_map/image2.png", -3)
	rotate -3*z
	translate <10, 80, 295.81>
}


#declare O_Trottoir = trottoir(vmin, vmax, nbdx, nbdz, crack, lb, nbb, lc, nbc,
								xbouch, lbouch, xgrille, l1grille, l2grille,
								locb, rayonb, epb)
object { O_Trottoir }



#if (Place_Pancarte)
object {
	O_Pancarte
	rotate x*25
	translate 15*y + 45*x
	translate (295 - 50*sin(radians(25)))*z
}
#end

#if (Place_Cartons)
object {
	O_Cartons
	rotate y*8
	translate 15*y -155*x + (245 -80*sin(radians(15)))*z
}
#end

#if (Place_Godet)
object {
	O_Godet
	rotate -15*y

	#declare Start = 200*y + 55*x + 250*z;
	#declare Norm = <0,0,0>;
	#declare Intersec = trace(O_Trottoir, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))
		#if (vdot(y, Norm) < 1.0 )
			Reorient(y, Norm)
		#end
		translate Intersec
	#end
}
#end



#if (Place_Mesh_1)
motion_blur {
	Mesh_Jambe1
	#declare vclock1 = pow(clock,.35);
	rotate z*(5+15*vclock1)
	#if (15*vclock1 > 10)
		translate sin(radians(15*vclock1-10))*5*y
	#end

	translate -80*x
	translate 15*y
	translate 30*z
}

motion_blur {
	Mesh_Jambe2
	#declare vclock2 = pow(clock,.35);
	translate -100*y
	translate -10*x
	rotate -z*(17+10*vclock2)
	translate 100*y
	translate -5*x
	translate 20*z
	translate -90*(sin(radians(5+15*vclock2)))*x

	translate -80*x
	translate 15*y
	translate 30*z
}

motion_blur {
	Mesh_Veste1
	#declare vclock3 = pow(clock,.35);
	translate -80*(sin(radians(5+15*vclock3)))*x
	translate 6*vclock3*z

	translate -80*x
	translate 15*y
	translate 30*z
}
#end


#if (Place_Mesh_2)
motion_blur {
	Mesh_Jambe3
	#declare vclock1 = pow(clock,.35);
	rotate z*(5+15*vclock1)
	#if (15*vclock1 > 10)
		translate sin(radians(15*vclock1-10))*5*y
	#end

	rotate -120*y
	translate 40*x
	translate -40*z
}

motion_blur {
	Mesh_Jambe4
	#declare vclock2 = pow(clock,.35);
	translate -90*y
	rotate -z*(17+10*vclock2)
	translate 90*y
	translate -20*x
	translate 20*z
	translate -90*(sin(radians(5+15*vclock2)))*x

	rotate -120*y
	translate 40*x
	translate -40*z
}

motion_blur {
	Mesh_Veste2
	#declare vclock3 = pow(clock,.35);
	translate -80*(sin(radians(5+15*vclock3)))*x
	translate 6*vclock3*z

	rotate -120*y
	translate 40*x
	translate -40*z
}
#end

#if (Place_Mesh_3)
motion_blur {
	Mesh_Jambe3
	#declare vclock1 = pow(clock,.35);
	rotate z*(5+15*vclock1)
	#if (15*vclock1 > 10)
		translate sin(radians(15*vclock1-10))*5*y
	#end

	rotate -180*y
	translate 15*y
	translate 75*x
	translate 90*z
}

motion_blur {
	Mesh_Jambe4
	#declare vclock2 = pow(clock,.35);
	translate -90*y
	rotate -z*(17+10*vclock2)
	translate 90*y
	translate -20*x
	translate 20*z
	translate -90*(sin(radians(5+15*vclock2)))*x

	rotate -180*y
	translate 15*y
	translate 75*x
	translate 90*z
}

motion_blur {
	union {
		object { Mesh_Veste2 }
		cylinder { 0, 50*y, 1 scale<10, 1, 20> translate y*120 +10*z pigment { color rgb 0 } }
		cylinder { 0, 40*y, 7 translate 130*y - 5*x +35*z  pigment { color rgb 0 } }
		sphere { 0, 7         translate 130*y - 5*x +35*z  pigment { color rgb 0 } }
		sphere { 40*y, 7      translate 130*y - 5*x +35*z  pigment { color rgb 0 } }
		cylinder { 0, 40*y, 7 translate 130*y - 5*x -15*z  pigment { color rgb 0 } }
		sphere { 0, 7         translate 130*y - 5*x -15*z  pigment { color rgb 0 } }
		sphere { 40*y, 7      translate 130*y - 5*x -15*z  pigment { color rgb 0 } }
		sphere { 0, 10 translate 180*y + 10*z pigment { color rgb 0 } }
	}
	#declare vclock3 = pow(clock,.35);
	translate -80*(sin(radians(5+15*vclock3)))*x
	translate 6*vclock3*z

	rotate -180*y
	translate 15*y
	translate 75*x
	translate 90*z
}
#end



#if (Place_Megots_T)

#declare i = Nb_Megots_T;
#while (i > 0)

	#declare Start = (-120 + 280*rand(St))*x + (5 + 200*rand(St))*z + 30*y;
	#if (rand(St) > .3)
		#declare filtre = on;
	#else
		#declare filtre = off;
	#end
	DropMegotOn(O_Trottoir, Start, filtre)
	
	#declare i = i-1;
	#declare St = seed(326551*rand(St));
#end

#end

#if (Place_Megots_C)

#declare i = Nb_Megots_C;
#while (i > 0)

	#declare Start = (-150 + 300*rand(St))*x -(3+12*rand(St))*z + 30*y;
	#if (rand(St) > .3)
		#declare filtre = on;
	#else
		#declare filtre = off;
	#end
	DropMegotOn(O_Trottoir, Start, filtre)
	
	#declare i = i-1;
	#declare St = seed(32651*rand(St));
#end

#end


#if (Place_Matelas)
union {
	object { O_Matelas }
	object { O_Drap }
	object { O_Oreiller }
	rotate y*8
	translate (10 + 245 -80*sin(radians(15)))*z
	translate -180*x
	translate 15.5*y
}
#end

#if (Place_Fireplug)
object {
	O_Fireplug
	scale 1.1
	rotate -10*y
	translate 30*z
	translate 65*x
	translate 15*y
}
#end

