#version unofficial MegaPov 0.4;


#macro O_Megot(long, haut, rayon, filtre)

#local tex1 = texture {
	pigment {
		#if (filtre)
			gradient x
			pigment_map {
				[.7 spotted scale .1 color_map { [.9 color rgb <.9, .7, .1>*.8] [.9 color rgb <.9, .7, .1>] } ]
				[.7 color rgbt <.9,.9,.9,.1> ]
			}
			warp { reset_children }
			scale <long, 1, 1>
		#else
			color rgbt <.9,.9,.9,.1>
		#end
	}
	normal { wrinkles scale .3 }
	finish { ambient .4 diffuse .6 }
}

#local tex2 = texture {
	pigment {
		#if (filtre)
			gradient x
			pigment_map {
				[.7 wood scale rayon*.2 rotate 90*z color_map { [0 color rgb <.9, .85, .8>*.9] [1 color rgb <.9, .85, .8>] } ]
				[.7 bozo turbulence 3 scale .1 color_map {[.6 color rgb <.3,.2,0>] [.6 color rgb <.3,.2,0>*1.5] } ]
			}
			warp { reset_children }
			scale <long+.02, 1, 1>
			translate -.01*x
		#else
			bozo
			turbulence 3
			scale .1
			color_map {
				[.6 color rgb <.3,.2,0>]
				[.6 color rgb <.3,.2,0>*1.5]
			}
		#end
	}
	normal { wrinkles scale .3 }
	finish { ambient .4 diffuse .6 }
}


union {
	cylinder { 0, long*x, rayon texture { tex1 } scale <1, haut/rayon, 1> texture { T_Crasse } }
	cylinder { -.01*x, (long+.01)*x, rayon*.99 texture { tex2 } scale <1, haut/rayon, 1> texture { T_Crasse } }
	translate haut*y
	translate -x*long/2
}
#end

#macro DropMegotOn(obj, start, filtre)

	#local Start = start;
	#local Norm = <0,0,0>;
	#local Intersec = trace(obj, Start, -y, Norm);

	#if ((Norm.x != 0) | (Norm.y != 0) | (Norm.z != 0))

		object { O_Megot( 2 + rand(St), .3 + .2*rand(St), .5, filtre)
			rotate 3652*rand(St)*y
			#if (vdot(y, Norm) < 1.0 )
				Reorient(y, Norm)
			#end
			translate Intersec
		}

	#end

#end
