// Persistence of Vision Ray Tracer Scene Description File
// File: citylife.pov
// Vers: 3.1
// Desc: For IRTC... The City
// Date: 4/30/00
// Auth: Bob Franke
//

#version 3.1;

#include "colors.inc"
#include "textures.inc" 

#declare showBricks=true;
#declare showGlass=false;
#declare showIsideLights=false;  


#declare Rust =
texture { 
    pigment {
        granite
        color_map {
            [0.0 rgb <0.89, 0.51, 0.28>]
            [0.4 rgb <0.70, 0.13, 0.00>]
            [0.5 rgb <0.69, 0.41, 0.08>]
            [0.6 rgb <0.49, 0.31, 0.28>]
            [1.0 rgb <0.89, 0.51, 0.28>]
        }
    }
    finish { ambient 0.4 diffuse 0.4 }
}


#declare Rusty_Iron = 
texture {
    pigment {
        granite
        color_map {
            [0.0 rgb <0.42, 0.20, 0.20>]
            [0.5 rgb <0.50, 0.50, 0.02>]
            [0.6 rgb <0.60, 0.20, 0.20>]
            [0.6 rgb <0.30, 0.20, 0.20>]
        }
    }
    finish { ambient 0.5 diffuse 0.6 }
    normal { wrinkles 1 scale 0.1 }
}


#declare brickTexture=
texture{
  pigment{color rgb <0.727, 0.392, 0.157>*1.5} 
  finish{ ambient .3}
}

#declare Glass = 
texture {
    pigment { rgbf<1.0, 1.0, 1.0, 0.85> }
    finish  { Glass_Finish }
}

#declare test=false;  


global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <15, 5, -55>
  direction 1.5*z
  right     3/4*x
  look_at   <-8, 12,  -10>   
}



sky_sphere{
  pigment {
    gradient y
    color_map { [0.0 color blue 0.3] [1.0 color rgb .5] }
  }
}
// ----------------------------------------

  light_source{<20,25,-20>
    color rgb <1,1,.7>*.75
    fade_power 2 
    fade_distance 11 
  }  
//-----------------------------------------


  light_source{<20,25,0>
    color rgb <1,1,.7>*.75
    fade_power 2 
    fade_distance 11 
  }  
//-----------------------------------------
  light_source{<20,25,20>
    color rgb <1,1,.7>*.75
    fade_power 2 
    fade_distance 11
  }  
//-----------------------------------------

 


#declare clamp=
union{
  union{
    difference{
      cylinder{<0,-1/12,0>, <0,1/12,0> 2.75/12}
      cylinder{<0,-1,0>, <0,1,0> 2.5/12}
      box{<-1,1,0>,<1,-1,1>}
    }  
    
    box{<-2.75,-1,0>/12,<-2.5,1,2.5>/12}
    box{<2.75,-1,0>/12,<2.5,1,2.5>/12}
    
    box{<-5,-1,2.25>/12,<-2.5,1,2.5>/12}
    box{<5,-1,2.25>/12,<2.5,1,2.5>/12}
    texture{Soft_Silver}
  }
}  



#declare lamp=
union{  

  cylinder {
    <0, 3, 0>, <0, 2, 0>, .5   open   
    pigment { rgbf <1,1,1,.5> } 
  }  
/* 
  light_source{<0,2.5,0>
    color rgb <1,1,.7>*1.2 
    area_light
      <.2, 0, 0> <0, 0, .2> // lights spread out across this distance (x * z)
      3, 3                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 0          // 0,1,2,3... 
      jitter              // adds random softening of light
    fade_power 2 
    fade_distance 12
    looks_like { 
      cylinder {<0, .5, 0>, <0, -.5, 0>, .501 open  
        pigment { DarkTan*1.25 } finish{ambient .9} } 
      }
  }
*/
  cone{<0,.5,0>,2.5/12 <0,2.3,0>,.75/12 texture{New_Brass}}
}    

//-----------------------------------------

#declare wallLight=
union{         

  light_source{<0,.1,0> White*.3  + Yellow*.1    
  area_light
    <.2, 0, 0> <0, .2, 0> // lights spread out across this distance (x * z)
    3, 3                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 0          // 0,1,2,3... 
    jitter              // adds random softening of light

  fade_power 2   
  fade_distance 20

    looks_like { sphere { <0,0,0>, .15 pigment { Yellow+White }     finish{ambient .8} } }
  }  
  union{
    cone{<0,.4,0>,.15<0,.4+3/12,0>,.1  }
    cone{<0,.45,0>,.125<0,0,0>,.75 open}
    cylinder{<0,-.125,0>,<0,0,0>, .75 open}
    cylinder{<0,-.125,0>,<0,0,0>, .75 open} 
    texture{Brushed_Aluminum scale .5 }   
  }  
  union{
    cylinder{<0,-.125,0>,<0,0,0>, .75-.01 open }
    cone{<0,.45-.01,0>,.125<0,0-.01,0>,.75 open }
    pigment{White} finish{ambient .3} 

  } 
  
  torus{.75,.5/12 
    clipped_by{plane{z,0}} 
    rotate<90,0,0>  
    translate<-.75,.4+3/12,0>
    texture{Brushed_Aluminum scale .5 } 
  }
  
  box{<-1.57,.65,-.15>,<-1.43,0,.15> texture{Brushed_Aluminum scale .2 } }  
}   
   
#declare ironDeck=
union{
  box{<0,.18,-2.5>,<2,.15,2.5>     
    pigment { rgbf <1,1,1, 0.4> }
 }  

  difference{
    box{<0,0,-2.5>,<2,.15,2.5>}  
    box{<.15,-1,-2.35>,<1.85,1,2.35>} 
  }
  
  difference{
    box{<0,3,-2.5>,<2,2.85,2.5>}  
    box{<-1,-1,-2.45>,<1.95,5,2.45>} 
  } 
  
  box{<0,3,-2.5>,<.15,-1,-2.35>}
  box{<0,3,2.5>,<.15,-1,2.35>}

  box{<0,0,-2.5>,<2.25,.15,-2.35>  rotate<0,0,28> translate<0,-1,0>}
  box{<0,0,2.5>,<2.25,.15,2.35>  rotate<0,0,28> translate<0,-1,0>}
 
  box{<0,.5,-2.55>,<2,.55,-2.5>}
  box{<0,2.5,-2.55>,<2,2.45,-2.5>}
  
  #declare xx = .5;
  #while (xx < 2)
    box{<xx,.5,-2.55>,<xx+.05,2.5,-2.5>}
    box{<xx,.5,2.55>,<xx+.05,2.5,2.5>}
    box{<xx,0.15,-2.5>,<xx+.05,.1,2.5>}
    #declare xx = xx + .5;
  #end  
  
  box{<0,.5,2.55>,<2,.55,2.5>}
  box{<0,2.5,2.55>,<2,2.45,2.5>}
  
  box{<2,.5,-2.5>,<2.05,.55,2.5>}
  box{<2,2.5,-2.5>,<2.05,2.45,2.5>}
  
  #declare zz = -2;
  #while (zz < 2.5)
    box{<2,.5,zz>,<2.05,2.5,zz+.05>}
    #declare zz = zz + .5;
  #end  

  box{<1.85,0,-2.5>,<2,3,-2.45>}
  box{<2,0,-2.5>,<1.95,3,-2.35>}
  box{<1.85,0,2.5>,<2,3,2.45>}
  box{<2,0,2.5>,<1.95,3,2.35>}
  
  pigment{White*.3} 
  scale<1.5,1,1.2>
}    
   
#declare windowHole= 
  union{
    box{<-1.6,-2.6,-15>,<1.6,2.6,15> }   
     difference{   
      cylinder{<0,-3.5,-15>,<0,-3.5,15>, 6.25 }
      box{<0,20,-20>,<30,-20,20>  rotate<0,0,-13.4> translate<0,-3.5,0>}    
      box{<0,20,-20>,<-30,-20,20>  rotate<0,0,13.4> translate<0,-3.5,0>}    
      box{<30,0,-20>,<-30,-20,20>  translate<0,0,0>}    
    } 
}

#declare oneBrick=
  box{<-.1,0,0>,<.1,.35,.5> pigment{NewTan*1.5} finish{crand .08}}

#declare window=
union{  
  box{<-1.8,-2.5,-.2>,<1.8,-2.7,.8> pigment{NewTan*1.5} finish{crand .05}}
  
  box{<-1.6,-2.5,.05>,<-1.65,2.5,.8> pigment{White*.75}}
  box{<1.6,-2.5,.05>,<1.65,2.5,.8> pigment{White*.75}}

  difference{
    box{<-1.6,-2.6,.5>,<1.6,2.9,.6> }
    box{<-1.4,-2.4,.3>,<1.4,2.4,.8>}
    pigment{White*.75} 
  }
  difference{
    box{<-1.45,-.05,.55>,<1.45,2.4,.65> }
    box{<-1.25,.15,.3>,<1.25,2.25,.8>}
    pigment{White*.75} 
  }               
  #if (showGlass)
    box{<-1.45,0,.6>,<1.45,2.4,.6+.25/12> texture{Glass}}
  #end  
  
  difference{
    box{<-1.45,.15,.65>,<1.45,-2.5,.75> }
    box{<-1.25,.15,.3>,<1.25,-2.25,.8>}
    pigment{White*.75} 
  }
  #if (showGlass)
    box{<-1.45,0,.7>,<1.45,-2.4,.7+.25/12> texture{Glass} }
  #end  
  
  #declare zrot = 15;
  #while (zrot > -14.875)
    object{oneBrick translate<0,5.9,0> rotate<0,0,zrot> translate<0,-3.2,0> } 
    object{oneBrick translate<0,5.9+.4,0> rotate<0,0,zrot> translate<0,-3.2,0> } 
    #declare zrot = zrot -2.28;
  #end    
}  

#declare glassDoor=    
union{
  difference{ 
    box{<-1.4,-2.8,.1>,<1.4,2.4,.25>}
    box{<-1.1,-2,-1>,<1.1,2.1,1> }
    texture {
      pigment{White}
      finish { ambient 0.2 diffuse 0.6 }
      normal { wrinkles 1 scale 0.1 } 
    }
  }        
  #if (showGlass)
     box{<-1.1,-2,.189>,<1.1,2.1,.2>  texture{Glass} }
  #end  
  sphere{<-1.25,0.3,.15>, .125  texture{Bright_Bronze}}
}

#declare rustyDoor=
union{
  difference{ 
    box{<-1.4,-2.8,.1>,<1.4,2.4,.4>}
    box{<-1.1,2.1,-1>,<1.1,.5,.15> }
    box{<-1.1,-2,-1>,<1.1,0,.15> }
    texture {
      pigment {
        granite
        color_map {
            [0.0 rgb <0.42*1.5, 0.20, 0.20>]
            [0.5 rgb <0.50*1.5, 0.50, 0.02>]
            [0.6 rgb <0.60*1.5, 0.20, 0.20>]
            [0.6 rgb <0.30*1.5, 0.20, 0.20>]
        }
      }
      finish { ambient 0.2 diffuse 0.6 }
      normal { wrinkles 1 scale 0.1 } 
      scale<.25,2,.2>
    }
  } 
  sphere{<-1.1,0.3,.15>, .125  texture{Bright_Bronze}}
}


#declare doorWay=
union{  
  difference{
    box{<-1.6,-2.6,.05>,<1.6,2.9,.8> }
    box{<-1.4,-2.8,-1>,<1.4,2.4,1>}
    pigment{White*.5} 
  }
  
  #declare zrot = 15;
  #while (zrot > -14.875)
    object{oneBrick translate<0,5.9,0> rotate<0,0,zrot> translate<0,-3.2,0> } 
    object{oneBrick translate<0,5.9+.4,0> rotate<0,0,zrot> translate<0,-3.2,0> } 
    #declare zrot = zrot -2.28;
  #end      
}

object{
  union{   
    union{
      #declare yy = 0;
      #while (yy < 6)     
        #declare xx = -4;
        #while (xx < 0) 
          #if (showBricks)
            box{<0, -.1, 0>,<1, 0, 1> 
              rotate<-90,0,0> 
              translate<xx,yy,0>
              pigment{Black}
            } 
            height_field{
              tga "bricks2.tga"      
              smooth        
              rotate<-90,0,0> 
              translate<xx,yy,0> 
            } 
          #else
            box{<0,0,0>,<1,1,1> 
              rotate<-90,0,0> 
              translate<xx,yy,0> 
            }     
          #end  
          #declare xx = xx + 1;
        #end
        #declare yy = yy + 1;
      #end    
      scale<15,12,1.4>/2
      texture{brickTexture}      
    }

    box{<-30,30,-.4>,<0,0,0.05> pigment{White} finish{ ambient .2 crand .25}}
  

    rotate<0,-90,0>
    translate<-10,0,0>
  }     
                                                                               
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15,-4>  inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15+10,-4> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15+20,-4> inverse}} 
   
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15,-20> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15+10,-20> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-5,15+20,-20> inverse}}
   
  clipped_by{object{windowHole scale<1,1.35,1> rotate<0,-90,0> translate<-5,3.5,-4> inverse}}
  clipped_by{object{windowHole scale<1,1.35,1> rotate<0,-90,0> translate<-5,14,-12> inverse}}
  clipped_by{object{windowHole scale<1,1.35,1> rotate<0,-90,0> translate<-5,14+10,-12> inverse}}
  
  clipped_by{box{<-15,0,-26>,<-8,8,-11> inverse}}
}   

#if (showIsideLights)
  object{lamp translate<-8.5,12.5,6.5>}
  object{lamp translate<-20,12.5,6.5>}  
  object{lamp translate<-8.5,12.5+20,6.5>}
  object{lamp translate<-20,12.5+20,6.5>}  
  
  light_source{<-15,17,-10>
    color rgb <1,1,.7>*1.4
    fade_power 2 
    fade_distance 8     
  }
  light_source{<-15,17+10,-10-10>
    color rgb <1,1,.7>*1.4
    fade_power 2 
    fade_distance 8     
  }
  light_source{<-15,17+10,20>
    color rgb <1,1,.7>*1.4
    fade_power 2 
    fade_distance 16     
  }
#end

object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15,-4>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15+10,-4>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15+20,-4>}

object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15,-20>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15+10,-20>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-9.55,15+20,-20>}  

object{doorWay scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,3.5,-4>} 
object{rustyDoor scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,3.5,-4>} 

object{wallLight translate<-7.5,8.5,-4>}
object{wallLight rotate<15,0,-5> translate<-7.5,8.5,-20>}
object{doorWay scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,14,-12>}
object{glassDoor scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,14,-12>}



object{doorWay scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,14+10,-12>}  
object{glassDoor scale<1,1.35,1> rotate<0,-90,0> translate<-9.55,14+10,-12>}  

object{ironDeck translate<-9.55,14-3.6,-12>}
object{ironDeck translate<-9.55,24-3.6,-12>}

box{<-100,9,0>,<-9.75,10.5,-75> pigment{White} finish{ ambient .2}}
box{<-100,9,0>,<-5,10.5,75> pigment{White} finish{ ambient .2}} 

box{<-100,9+10,0>,<-9.75,9.5+10,-75> pigment{White} finish{ ambient .2}}
box{<-100,9+10,0>,<-5,9.5+10,75> pigment{White} finish{ ambient .2}}  

box{<-100,9+20,0>,<-9.75,9.5+20,-75> pigment{White} finish{ ambient .2}}
box{<-100,9+20,0>,<-5,9.5+20,75> pigment{White} finish{ ambient .2}}  

box{<-100,9+30,0>,<-9.75,9.5+30,-75> pigment{White} finish{ ambient .2}}
box{<-100,9+30,0>,<-5,9.5+30,75> pigment{White} finish{ ambient .2}}  



box{<-30,9,-75>,<-31,40.5,75>  pigment{White} finish{ ambient .2}} 

box{<-31,9,-15.75>,<-9.75,39,-16.25> pigment{White} finish{ ambient .2}}
box{<-31,9,8.25>,<-5,39,8.75> pigment{White} finish{ ambient .2}}
box{<-31,9,8.25+20>,<-5,39,8.75+20> pigment{White} finish{ ambient .2}}
box{<-31,9,8.25+40>,<-5,39,8.75+40> pigment{White} finish{ ambient .2}}

object{
  union{  
    union{
      #declare yy = 0;
      #while (yy < 7)     
        #declare xx = 0;
        #while (xx < 5)   
          #if (showBricks)
            box{<0, -.1, 0>,<1, 0, 1> 
              rotate<-90,0,0> 
              translate<xx,yy,0>
              pigment{Black}
            } 
            height_field{
              tga "bricks2.tga"      
              smooth        
             rotate<-90,0,0> 
             translate<xx,yy,0>   
            }  
          #else
            box{<0,0,0>,<1,1,1> 
              rotate<-90,0,0> 
              translate<xx,yy,0>  
            }     
          #end  
          #declare xx = xx + 1;
        #end
        #declare yy = yy + 1;
      #end    
      scale<15,12,1.4>/2             
      pigment{color rgb <0.727, 0.392, 0.157>*1.25} finish{ ambient .3}     
    } 
  
    box{<0,0,-.4>,<70,0,0.05> pigment{White} finish{ ambient .2 crand .25}}
  
    rotate<0,-90,0>
    translate<-5.1,0,-.459>                                     
  }   
     
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15,3.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+10,3.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+20,3.5> inverse}}
  
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15,13.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+10,13.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+20,13.5> inverse}}
  
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15,23.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+10,23.5> inverse}}
  clipped_by{object{windowHole scale<1.5,1,1> rotate<0,-90,0> translate<-4,15+20,23.5> inverse}}
} 

object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15,3.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+10,3.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+20,3.5>} 

object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15,13.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+10,13.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+20,13.5>}

object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15,23.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+10,23.5>}
object{window scale<1.5,1,1> rotate<0,-90,0> translate<-4.6,15+20,23.5>} 

object{wallLight translate<-2.5,11,8.5>}
object{wallLight translate<-2.5,11,18.5>}


object{
  union{  
    union{
      #declare yy = 0;
      #while (yy < 6)     
        #declare xx = 0;
        #while (xx < 1)
          #if (showBricks)
            box{<0, -.1, 0>,<1, 0, 1> 
              rotate<-90,0,0> 
              translate<xx,yy,0>
              pigment{Black}
            } 
            height_field{
              tga "bricks2.tga"      
              smooth         
              rotate<-90,0,0> 
              translate<xx,yy,0>    
            }  
          #else
            box{<0,0,0>,<1,1,1> 
              rotate<-90,0,0> 
              translate<xx,yy,0>    
            }     
          #end  
          #declare xx = xx + 1;
        #end
        #declare yy = yy + 1;
      #end    
      scale<15,12,1.4>/2            
      texture{brickTexture} 
    } 
    box{<0,40,-.4>,<7.5,0,0.05> pigment{White} finish{ ambient .2 crand .25}}
    translate<-10-2,0,-.05>
  }                                                        

  clipped_by{object{windowHole scale<1.25,1,1>  translate<-7,15,0> inverse}}
  clipped_by{object{windowHole scale<1.25,1,1>  translate<-7,15+10,0> inverse}}
  clipped_by{object{windowHole scale<1.25,1,1>  translate<-7,15+20,0> inverse}}
  clipped_by{box{<-10,0,-2>,<-30,100,4> inverse}}

}    

object{window scale<1.25,1,1>  translate<-7,15,-.5>}
object{window scale<1.25,1,1>  translate<-7,15+10,-.5>}
object{window scale<1.25,1,1>  translate<-7,15+20,-.5>}
 
 
union{
  object{clamp   rotate<0,-90,0>  translate<0,2,-.4>}
  object{clamp   rotate<0,-90,0>  translate<0,12,-.4>}
  object{clamp   rotate<0,-90,0>  translate<0,20,-.4>}
  object{clamp   rotate<0,-90,0>  translate<0,28,-.4>}


  cylinder{<0,1,-.4>,<0,40,-.4>,2.5/12}
  cylinder{<0,8,-.4>,<0,8.6,-.4>,3/12}
  cylinder{<0,8+8,-.4>,<0,8.6+8,-.4>,3/12}
  cylinder{<0,8+16,-.4>,<0,8.6+16,-.4>,3/12}
  cylinder{<0,8+24,-.4>,<0,8.6+24,-.4>,3/12}
  cylinder{<0,0,-.4>,<.66,0,-.4>,2.5/12 open rotate<0,0,-45> translate<0,1,0>}
  pigment{White}   
  translate<-4.3,0,0>
}  

union{
  cylinder{<0,22,0>,<0,40,0>,2.5/12}        
  object{clamp   rotate<0,-90,0>  translate<0,23,0>}
  union{
    cylinder{<0,0,0>,<0,-15,0>,2.5/12}  
    cylinder{<0,-1.5,0>,<0,-2,0>,3/12}
    cylinder{<0,-1.5-8,0>,<0,-2-8,0>,3/12}
    object{clamp rotate<0,-90,0> translate<0,-2,0>}
    object{clamp rotate<0,-90,0> translate<0,-10,0>}
    rotate<60,0,0> translate<0,22,0>
  }
  pigment{White}  
  translate<-9.35,0,-16.5>

} 

//start garage door  
difference{  
  union{
    box{<-7.5,0,0.2>,<7.5,8,-1>}
    box{<-7.5,1,0.2>,<7.5,1.1,-1.05>}
    box{<-7.5,2,0.2>,<7.5,2.1,-1.05>}
    box{<-7.5,3,0.2>,<7.5,3.1,-1.05>}
    box{<-7.5,4,0.2>,<7.5,4.1,-1.05>}
    box{<-7.5,5,0.2>,<7.5,5.1,-1.05>}
    box{<-7.5,6,0.2>,<7.5,6.1,-1.05>}
    box{<-7.5,7,0.2>,<7.5,7.1,-1.05>}
    box{<-7.5,8,0.2>,<7.5,8.1,-1.05>}
  } 
  #declare yy=0;
  #while (yy < 8) 
    box{<-7.5,yy,.01>,<7.5,yy+.03,-1.03>}
    #declare yy=yy+.333;
  #end
 texture{Brushed_Aluminum scale 1 }
 rotate<0,-90,0> 
 translate<-10.8,0,-18.5>
 }                    
 // end garage door   

height_field {
  tga "grad4e.tga"
  water_level .01 
  smooth
  translate <-.5, -.5, -.5>   
  scale <20,5,150> 
  translate<-.5,-.1,-10> 
  texture{
    pigment{
      spotted 
      color_map {
        [ 0.000  color White*.4 ]
        [ 0.200  color White*.4 ]
        [ 0.500  color White*.5  ]
        [ 0.700  color White*.5  ]
        [ 1.000  color White*.4 ]
      }      
      scale 4
    }
    finish{crand .1}
  } 
}
 

height_field {
  tga "grad4.tga"
  water_level .01 
  smooth
  translate <-.5, -.5, -.5>   
  scale <20,5,150> 
  translate<0,.05,0> 
    
  texture{
    pigment{ White*.7} 
    finish {Glossy  crand .2 }
    normal{  
      bump_map { 
        tga "test2.tga"
        bump_size 5
        interpolate 2 
      }  
      translate <-.5, .5, 0> 
      rotate<90,0,0>
      scale <10,6,10>
    } 
  }  
}



#declare wheel=
union{
  cylinder {<2/12,2.875/12,.75/12>, <2/12,2.875/12,-.75/12>, 2.875/12 pigment{White*.3}}
  box{<-.25/12,2.5/12,-.875/12>,<2.5/12,6/12,-1/12> texture{Silver2}}
  box{<-.25/12,2.5/12,.875/12>,<2.5/12,6/12,1/12> texture{Silver2}}
  box{<-.25/12,5.875/12,1/12>,<2.5/12,6/12,-1/12> texture{Silver2}}
  cylinder {<0,6/12,0>, <0,7.5/12,0>, .4375/12 texture{Silver2}}
}     


#declare dumper=                      
union{                      
  difference{                      
    box{<-3,.25,-3.5>,<3,3.5,0> }
    box{<-3+.05,.25+.05,-3.5+.05>,<3-.05,3.9,-.05> }
    box{<-4,0,1>,<4,2,-5> rotate<-10,0,0> translate<0,3.5,0>}
    box{<-2.95,-.05,-.05>,<2.95,.05,.05> rotate<45,0,0> scale<1,1.5,1> translate<0,1,-3.53>}
    box{<-2.95,-.05,-.05>,<2.95,.05,.05> rotate<45,0,0> scale<1,1.5,1> translate<0,2,-3.53>}
    pigment{Green}  
    finish{ ambient .125}  
  }             
  
  difference{
    box{<-3.1,0,-3.6>,<3.1,-.1,0>}
    box{<-3,-1,-3.4>,<3,3,0>} 
    rotate<-10,0,0>
    translate<0,3.5,0>
    pigment{Green}    
    finish{ ambient .125}  
  
  }
  difference{
    box{<3,1.8,-3>,<3.5,2.5,-.3>}
    box{<2.5,1.83,-3.5>,<3.47,2.47,1>} 
    pigment{Green}    
  }
  difference{
   box{<-3,1.8,-3>,<-3.5,2.5,-.3> }
   box{<-2.5,1.83,-3.5>,<-3.47,2.47,1>} 
    pigment{Green}    
  }   
  box{<-3.1,0,-3.6>,<3.1,.02,0>
    rotate<-8,0,0>
    translate<0,3.5,0>  
    pigment{Green*.5}
  }
  object{wheel rotate<0,30,0> translate<-2.9,-3.5/12,-.05>}
  object{wheel rotate<0,5,0> translate<-2.9,-3.5/12,-3.45>}
  object{wheel rotate<0,55,0> translate<2.9,-3.5/12,-.05>}
  object{wheel rotate<0,75,0> translate<2.9,-3.5/12,-3.35>}  
}  


object{dumper rotate<-4,0,0> rotate<0,-75,0> translate<-3,6/12,3>}



#declare glassCylinder=
union{
  difference{
    merge{
      cylinder{<0,0,0>,<0,1.5,0> 1.35}
      torus{1.27, 0.08  translate<0,1.5,0>}
      cylinder{<0,1.5,0>,<0,1.58,0> 1.27}
    }
    union{
      cylinder{<0,0,0>,<0,1.5,0> 1.35 }
      torus{1.27, 0.08  translate<0,1.5,0>}
      cylinder{<0,1.5,0>,<0,1.58,0> 1.27 }
      scale <.99,.98,.99>
    }
    #if(showGlass)
      texture{Glass3}
    #else
      pigment{Red}
    #end
  }
  difference{
    cylinder{<0,0,0>,<0,.15> 1.4}
    cylinder{<0,-1,0>,<0,2,0> 1.28}
    texture{
      pigment{White*.2}
      finish {
        ambient 0.35
        brilliance 2
        diffuse 0.3
        metallic
        specular 0.80
        roughness 1/10
        reflection 0.17
        crand 0.05
      }
    }
  }   
  scale .5
}


#declare junctionBox=
union{
  box{<-1.0,-1.8,-.7>,<1.0,1.7,1>  
    texture{Brushed_Aluminum scale .1  
    finish{roughness 1/10}
    }
  }
  object{glassCylinder  rotate<-90,0,0> translate<0,.85,-.75> }
  object{glassCylinder rotate<-90,0,0>   translate<0,-.85,-.75>}
}
                    
object{junctionBox scale .5 translate<-6,5,-1>}  
    
#declare elbow90=
torus{0.5,1/12  
  clipped_by{plane{x,0 inverse}}
  clipped_by{plane{z,0}}  
}  

 
#declare zz = 0;   
union{ 
  cylinder{<-6,4,-.5-zz>,<-6,7.75,-.5-zz>, 1/12}                  
  object{elbow90 
    translate<-.5,0,0>
    rotate<90,0,0>
    translate<-6,7.75,-.5-zz>
  }
  cylinder{<-6.5,8.25,-.5-zz>,<-10,8.25,-.5-zz>, 1/12 }                  
  cylinder{<-9.5,8.25,0>,<-9.5,8.25,-30>, 1/12 } 
  texture{Brushed_Aluminum scale .05}  
}                 


union{ 
  cylinder{<-5.8,4,-.5-zz>,<-5.8,9.5,-.5-zz>, 1/12}                  
  object{elbow90 
    translate<-.5,0,0>
    rotate<90,0,0>
    rotate<0,180,0>
    translate<-5.8,9.5,-.5-zz> 
  }
  cylinder{<-5.3,10,-.5-zz>,<-4.0,10,-.5-zz>, 1/12}                  
  cylinder{<-4.0,10,-.5-zz>,<-4.0,10,20>, 1/12}                  
  cylinder{<-4.0,10,8.5>,<-4.0,11,8.5>, 1/12}                  
  cylinder{<-4.0,10,18.5>,<-4.0,11,18.5>, 1/12}                  

  texture{Brushed_Aluminum scale .05} 
}
     
//start homeless box         
union{  
  union{     
    difference{
      box{<0,0,16/12>,<6,32/12,-16/12>}
      box{<-1,0,15.875/12>,<6,31.875/12,-15.875/12>}
    }  
    box{<0,0,16/12>,<-16/12,.125/12,-16/12>} 
    box{<0,32/12,16/12>,<-16/12,31.875/12,-16/12>} 
    box{<0,.125/12,0>,<-16/12,31.875/12,-.125/12> rotate<0,10,0> translate<0,0,16/12>} 
    box{<0,.125/12,0>,<-16/12,31.875/12,.125/12> rotate<0,10,0> translate<0,0,-16/12>} 
    pigment{Tan*.75}   
    finish{ambient 0.6}
  }    
  

  box{<0,0,16.01/12>,<1,1,0>
   texture{ pigment{Tan*.75} finish{ambient 0.6}}
      texture{
        pigment {
          image_map {
            tga "acme2.tga"
            interpolate 2
            once
            filter 2 1.0
          }                   
        } 
      }   
     scale<3.25,2.25,1> 
     translate<2.25,.5,0>
  }
 
  rotate<0,180,0>  
  rotate<0,0,-5>   
  translate<-2,0,-4>  
}     
//end homeless box         
    

#declare frontWheel=
union{
  cylinder {<2/12,2.875/12,.75/12>, <2/12,2.875/12,-.75/12>, 2.875/12 pigment{White*.3}}
  box{<-.25/12,2.5/12,-.875/12>,<2.5/12,6/12,-1/12> texture{Silver2}}
  box{<-.25/12,2.5/12,.875/12>,<2.5/12,6/12,1/12> texture{Silver2}}
  box{<-.25/12,5.875/12,1/12>,<2.5/12,6/12,-1/12> texture{Silver2}}
  cylinder {<0,6/12,0>, <0,7.5/12,0>, .4375/12 texture{Silver2}}
}   


#declare rearWheel=
union{
  cylinder {<0,2.875/12,.75/12>, <0,2.875/12,-.75/12>, 2.875/12 pigment{White*.3}}
  box{<-1/12,2.5/12,-.875/12>,<1/12,6/12,-1/12> texture{Silver2}}
  box{<-1/12,2.5/12,.875/12>,<1/12,6/12,1/12> texture{Silver2}}
  box{<-1/12,5.875/12,1/12>,<1/12,6/12,-1/12> texture{Silver2}}
  cylinder {<0,6/12,0>, <0,7.5/12,0>, .4375/12 texture{Silver2}}
}  
 
 
#declare cart= 
union{
  object{frontWheel rotate<0,30,0> translate<-.7,0,0>}   
  object{frontWheel rotate<0,70,0> translate<.7,0,0>}
  
  object{rearWheel rotate<0,90,0>  translate<-1,0,3>} 
  object{rearWheel rotate<0,90,0>  translate<1,0,3>}  
  
  cylinder{<.5,6.625/12,-.2>,<.5,6.625/12,2.9>, .625/12  }
  cylinder{<-.5,6.625/12,-.2>,<-.5,6.625/12,2.9>, .625/12  }
  cylinder{<0,6.625/12,-.2>,<0,6.625/12,2.9>, .625/12  }

  cylinder{<0,6.625/12,-.2>,<0,6.625/12,3.1>, .625/12  rotate<0,-6,0> translate<-.7,0,0>}
  cylinder{<0,6.625/12,-.2>,<0,6.625/12,3.1>, .625/12  rotate<0,6,0> translate<.7,0,0>}
  cylinder{<-.7,6.625/12,-.17>,<.7,6.625/12,-.17>, .625/12}
  cylinder{<-1,6.625/12,3>,<1,6.625/12,3>, .625/12}
                                        
  cylinder{<-1,6.625/12,3>,<-1,1.3,3>, .625/12}
  cylinder{<1,6.625/12,3>,<1,1.3,3>, .625/12}
  
  cylinder{<.9,1.7,2.5>,<1,1.3,3>, .625/12  }
  cylinder{<-.9,1.7,2.5>,<-1,1.3,3>, .625/12}
  
  cylinder{<-.9,1.7,2.502>,<-.8,1.7,1.75>, .625/12}
  cylinder{<.9,1.7,2.502>,<.8,1.7,1.75>, .625/12} 
   
  cylinder{<.9,1.760,2.5>,<.7,1.760,-.2>, .015 }  
  cylinder{<-.9,1.760,2.5>,<-.7,1.760,-.2>, .015 }  
  cylinder{<-.7,1.760,-.2>,<.7,1.760,-.2>, .015 }    
  
  cylinder{<.9,1.760,2.6>,<.7,1.760,-.2>, .015 translate<0,.6,0>}  
  cylinder{<-.9,1.760,2.6>,<-.7,1.760,-.2>, .015  translate<0,.6,0>}  
  cylinder{<-.7,1.760,-.2>,<.7,1.760,-.2>, .015 translate<0,.6,0>}    
  
  cylinder{<.9,1.760,2.7>,<.7,1.760,-.2>, .015 translate<0,1.2,0>}  
  cylinder{<-.9,1.760,2.7>,<-.7,1.760,-.2>, .015  translate<0,1.2,0>}  
  cylinder{<-.7,1.760,-.2>,<.7,1.760,-.2>, .015 translate<0,1.2,0>}    

  cylinder{<-.8,1.7,1.73>,<.8,1.7,1.73>, .625/12}
  
  #declare xx=-.7;
  #while (xx<=.7)
    cylinder{<xx,1.76,-.2>,<xx,2.96,-.2> .015}  
    #declare xx=xx+.1;    
  #end  
  
  #declare xx=.7;
  #declare zz=-.2
  #while (zz<=2.8)
    cylinder{<xx,1.76,zz>,<xx,2.96,zz> .015}  
    #declare xx=xx+(.2/29); 
    #declare zz=zz+.1;   
  #end    
  
  #declare xx=-.7;
  #declare zz=-.2
  #while (zz<=2.8)
    cylinder{<xx,1.76,zz>,<xx,2.96,zz> .015}  
    #declare xx=xx-(.2/29); 
    #declare zz=zz+.1;   
  #end 
   
  #declare xx=-.7; 
  #declare xxx=.7
  #declare zz=-.2
  #while (zz<=2.7)
    cylinder{<xx,1.76,zz>,<xxx,1.76,zz> .015}  
    #declare xx=xx-(.2/15); 
    #declare xxx=xxx+(.2/15); 
    #declare zz=zz+.2;   
  #end  
   
  #declare xx=-.6; 
  #while (xx<.8)
    cylinder{<xx,1.76,-.2>,<xx,1.76,2.7> .015}  
    #declare xx=xx+.2; 
  #end  
   
  #declare yy=1.76; 
  #while (yy<2.96)
    cylinder{<-.9,yy,2.7>,<.9,yy,2.7> .015}  
    #declare yy=yy+.3; 
  #end  
   
  #declare xx=-.6; 
  #while (xx<.8)
    cylinder{<xx,1.76,2.7>,<xx,2.96,2.7> .015}  
    #declare xx=xx+.3; 
  #end  

  cylinder{<-.9,1.76,2.7>,<-.9,3.1,2.7> .03}  
  cylinder{<.9,1.76,2.7>,<.9,3.1,2.7> .03}  
  cylinder{<-.9,3.1,2.7>,<.9,3.1,2.7> .05 pigment{Red*2}}  
  texture{Silver2}
}  


#declare sign=
union{
   box{<0,0,0>,<1,1,.125/12>  
      texture{
        pigment{Yellow*.5+White*.6} 
         finish { ambient .25} 
      }   
      texture{
        pigment {
          image_map {
            tga "vet.tga"
            interpolate 2
            once
            filter 255 1.0
            filter 57 1.0
            filter 58 1.0
            filter 59 1.0
          }                   
          
        } 
        finish { ambient .3}    
        normal{
          wrinkles .75
        scale .15
        }  
      }
      translate<-.5,2,0>
   }
   box{<-.5/12,0,.125/12>,<.5/12,2,.375/12> texture{Yellow_Pine}}
  }
   
object{cart   rotate<0,45,0> rotate<0,0,-2>translate<-4,.4,-8.75>}   
object{sign scale 1.5 rotate<30,0,0> translate<-6,.75,-6.5>}   

#include "feet.inc"  
object{feet scale 15  rotate<0,0,-90> rotate<-90,-170,0> rotate<5,0,0> translate<-1.5,.8,-4>}
   
