//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 16 materials and 139 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/24/2000    (24.04.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.875,0.875,1.000> }

camera {  //  Camera StdCam
  location  <      0.026,      -1.785,      -0.168>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.053,      -0.236,      -0.153>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <      1.342,       2.150,       0.455> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    6.57119,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle        171.64768    // Vertical     128.736
  look_at   <      1.342,       2.150,       1.455> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//
light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <0.50, 0.50, 0.50>
  area_light <10.000, 0.000, 0.000>, <0.000, 10.000, 0.000>, 15, 15
  adaptive 1
  rotate -16.431213*x
  translate  <0.539043, 24.664378, 17.727863>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <0.286, 0.314, 0.314>
  shadowless
  translate  <-0.123474, -4.348424, 0.261706>
}
  

light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.469, 0.407>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  scale 0.298774
  translate  <1.321595, 2.144216, 0.762488>
}


light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <0.560, 0.557, 0.500>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    84.439  // outer radius (in deg)
    radius     66.203  // inner radius
    tightness  0.000
  rotate -180.0*y
  translate  <1.341992, 2.149892, 0.454692>
}


//
// ********  MATERIALS  *******
//

#include "dcpad.inc"
#include "jeans1.pov"     
#include "apartCity1.pov"
#include "speaker1.pov"    
#include "poster1.pov"

//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.666667, -0.986395>,
  <-0.176871, -0.986395>,
  <-0.176871, 0.891156>,
  <-0.371429, 0.885714>,
  <-0.475374, 0.809932>,
  <-0.496599, 0.687075>,
  <-0.445816, 0.654094>,
  <-0.42381, 0.560119>,
  <-0.487833, 0.469246>,
  <-0.556259, 0.39824>,
  <-0.653493, 0.227586>,
  <-0.668027, -0.004422>,
  <-0.666667, -0.986395>
  rotate -x*90
  material {
    T_Wood1
  }
  scale <0.03, 0.04, 3.0>
  rotate 90.0*x
  translate  <1.654063, 2.901907, -0.86013>
}
#declare WindowLatch1 = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.03, 0.005, 0.005>
    rotate -30.0*z
    translate  <-0.79809, 2.975, 0.0375>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.03, 0.0125, 0.0125>
    translate  <-0.79809, 2.99, 0.0375>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      WhitePaint
    }
    scale <0.03, 0.025, 0.0125>
    translate  <-0.79809, 3.03, 0.0375>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.01, 0.01, 0.0085>
    rotate -30.0*z
    translate  <-0.780897, 2.965449, 0.0375>
  }
}
#declare WindowTrack1 = difference {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.005, 0.6>
    translate  <0.8, 2.975, 0.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.425, 0.03, 0.65>
    translate  <0.8, 2.975, 0.01>
  }
  material {
    Aluminum99
  }
}
#declare CSG006 = difference {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      BlackPaint
    }
    scale <0.15, 0.15, 0.1>
    translate  <1.5, 2.3, 0.375>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Chrome_Metal99
    }
    scale <0.15, 0.15, 0.1>
    translate  <1.5, 2.3, 0.376>
  }
}
#declare HalogenTorchiere = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackPaint
    }
    scale <0.02, 0.02, 1.3>
    translate  <1.5, 2.3, -0.9>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      BlackPaint
    }
    scale <0.15, 0.15, 0.05>
    translate  <1.5, 2.3, -0.9>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass99
    }
    scale <0.021, 0.021, 0.015>
    translate  <1.5, 2.3, -0.15>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass99
    }
    scale <0.021, 0.021, 0.015>
    translate  <1.5, 2.3, -0.85>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass99
    }
    scale <0.021, 0.021, 0.015>
    translate  <1.5, 2.3, 0.37>
  }
  object { CSG006 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass99
    }
    scale <0.00821, 0.00821, 0.015>
    rotate <-45.0, -90.0, 0.0>
    translate  <1.48881, 2.284671, -0.096378>
  }
  translate  <-0.16983, -0.16983, 0.0>
}
#declare CSG002 = difference {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.025, 0.6>
    translate  <-0.8, 3.025, 0.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.03, 0.525>
    translate  <-0.8, 3.025, 0.01>
  }
  material {
    WhitePaint
  }
}
#declare CSG003 = difference {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.025, 0.3>
    translate  <-0.8, 2.975, -0.275>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.03, 0.25>
    translate  <-0.8, 2.975, -0.275>
  }
  material {
    WhitePaint
  }
}
#declare Window1 = union {
  object { CSG002 }
  object { CSG003 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      WhitePaint
    }
    scale <0.39999, 0.025, 0.025>
    translate  <-0.8, 3.025, 0.0>
  }
}
#declare CSG001 = difference {
  box { // FrontWall
    <-1, -1, -1>, <1, 1, 1>
    material {
      WallTexture
    }
    scale <2.5, 0.1, 1.5>
    translate  3.0*y
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.25, 0.6>
    translate  <-0.8, 3.0, 0.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.25, 0.6>
    translate  <0.8, 3.0, 0.0>
  }
  material {
    WallTexture
  }
}
#declare CSG004 = difference {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.025, 0.6>
    translate  <0.8, 3.025, 0.0>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.03, 0.525>
    translate  <0.8, 3.025, 0.01>
  }
  material {
    WhitePaint
  }
}
#declare CSG005 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.025, 0.3>
    translate  <0.8, 2.975, -0.275>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.03, 0.25>
    translate  <0.8, 2.975, -0.275>
  }
  material {
    WhitePaint
  }
  translate  0.25*z
}
#declare Window2 = union {
  object { CSG004 }
  object { CSG005 }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      WhitePaint
    }
    scale <0.39999, 0.025, 0.025>
    translate  <0.8, 3.025, 0.0>
  }
}
#declare CSG007 = union {
  superellipsoid { // SuperQ008
    <0.1, 0.1>
    scale <3.75, 0.5, 2.25>
    translate  <0.0, 2.0, 0.25>
  }
  superellipsoid { // SuperQ006
    <0.5, 0.4>
    scale <1.75, 0.5, 2.0>
    translate  <-1.75, 1.5, 1.0>
  }
  superellipsoid { // SuperQ005
    <0.1, 0.1>
    scale <3.0, 1.0, 0.75>
    translate  <0.0, -0.5, -1.25>
  }
  superellipsoid { // SuperQ001
    <0.1, 0.35>
    scale <1.5, 1.5, 0.6>
    rotate <-0.498931, 0.002351, 0.449187>
    translate  <1.526793, -0.275366, 0.05>
  }
  superellipsoid { // SuperQ002
    <0.1, 0.35>
    scale <1.5, 1.5, 0.6>
    rotate <-0.49642, -0.027067, -5.195623>
    translate  <-1.5, -0.648057, 0.05>
  }
  superellipsoid { // SuperQ003
    <0.1, 0.476>
    scale <0.5, 2.0, 2.0>
    rotate -0.5*x
    translate  <-3.5, 0.5, 0.0>
  }
  superellipsoid { // SuperQ004
    <0.1, 0.476>
    scale <0.5, 2.0, 2.0>
    rotate -0.5*x
    translate  <3.5, 0.5, 0.0>
  }
  superellipsoid { // SuperQ007
    <0.5, 0.4>
    scale <1.75, 0.5, 2.0>
    translate  <1.75, 1.5, 1.0>
  }
  superellipsoid { // SuperQ009
    <0.1, 0.1>
    scale <0.5, 2.0, 1.0>
    rotate -0.5*x
    translate  <-3.5, 0.5, -1.0>
  }
  superellipsoid { // SuperQ010
    <0.1, 0.1>
    scale <0.5, 2.0, 1.0>
    rotate -0.5*x
    translate  <3.5, 0.5, -1.0>
  }
  material {
    CouchMaterial
  }
  scale <0.225, 0.2, 0.15>
  translate  <-0.457607, 2.021096, -0.6>
}
#declare WindowTrack2 = difference {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.005, 0.6>
    translate  <-0.8, 2.975, 0.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.425, 0.03, 0.65>
    translate  <-0.8, 2.975, 0.01>
  }
  material {
    Aluminum99
  }
}
#declare WindowLatch2 = union {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.03, 0.005, 0.005>
    rotate 30.0*z
    translate  <0.79809, 2.975, 0.0375>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.03, 0.0125, 0.0125>
    translate  <0.79809, 2.99, 0.0375>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.03, 0.025, 0.0125>
    translate  <0.79809, 3.03, -0.2125>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    scale <0.01, 0.01, 0.0085>
    rotate 30.0*z
    translate  <0.78, 2.963118, 0.0375>
  }
  translate  0.25*z
}
#declare CSG008 = union {
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.0125, 0.125>
    rotate -24.352283*x
    translate  <0.0, 3.042618, 0.112633>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 1.0, 0.125>
    rotate -11.146008*y
    translate  <-0.985382, 2.0, 0.117097>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <0.0125, 1.0, 0.125>
    rotate 8.065425*y
    translate  <0.975, 2.0, 0.114502>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.975, 1.0, 0.0125>
    translate  2.0*y
  }
  rotate 45.0*x
  translate  <0.0, 0.532095, -0.823733>
}
#declare CSG009 = difference {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.125>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.975, 0.975, 0.125>
    translate  0.025*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.05125, 0.05125, 3.0>
    rotate -90.0*y
    translate  <1.5, -0.5, 0.125>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.25, 0.125>
    translate  <0.0, 1.0, 0.025>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00525, 1.1, 0.125>
    translate  <0.965, -0.170478, -0.001574>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.00525, 1.1, 0.125>
    translate  <-0.970565, -0.160762, -0.001574>
  }
}
#declare PizzaBox = union {
  object { CSG008 }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.125, 0.0125>
    translate  <0.0, 1.125, -0.113166>
  }
  object { CSG009 }
  material {
    PizzaBoxTexture
  }
  scale 0.2
  rotate -35.0*z
  translate  <0.830776, 1.68772, -0.872233>
}
#declare CSG010 = difference {
  superellipsoid { // SuperQ011
    <0.7, 0.1>
    material {
      Aluminum99
    }
    scale <0.4, 0.3, 0.03>
    rotate 10.0*y
    translate  <-0.275, 0.0, 3.6>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.175, 1.0>
    translate  <-0.1, 0.0, 3.58>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.2, 1.0>
    translate  <-0.475, 0.0, 3.57>
  }
  material {
    Aluminum99
  }
}
#declare CSG011 = difference {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.76, 0.76, 3.5>
    translate  0.020464*z
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.25, 0.35, 5.0>
    translate  0.4*x
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.45>
    translate  0.020464*z
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <0.3, 0.0, 3.5>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <-0.3, 0.0, 3.5>
  }
}                    
#declare CSG1010 = union {   
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 3.0>
  }  
  sphere { // Sphere001
    <0,0,0>,1
    scale <1.0, 1.0, 0.75>
    translate  3.0*z
  }  
  material  { BLUE_METAL}
  }  

#declare CSG012 = union {
  object {CSG1010}
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Aluminum99
    }
    translate  -1.0*z
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.8, 0.8, 4.0>
  }
}
#declare CSG013 = difference {
  object { CSG012 }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    translate  4.6*z
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    translate  -1.25*z
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.78, 0.78, 1.0>
    translate  3.340084*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <1.0, 1.0, 0.75>
    translate  -0.75*z
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.5>
  }
  material {
    Aluminum99
  }
}
#declare popcan1 = union {
  object { CSG010 }
  object { CSG011 }
  object { CSG013 }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale 0.05
    translate  3.55*z
  }
  scale 0.04   
  rotate <0, 0, 180>
  translate  <0.558229, 2.16106, -0.888671>
}
#declare CSG014 = difference {
  superellipsoid { // SuperQ012
    <0.7, 0.1>
    material {
      Aluminum99
    }
    scale <0.4, 0.3, 0.03>
    rotate 10.0*y
    translate  <-0.275, 0.0, 3.6>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.175, 1.0>
    translate  <-0.1, 0.0, 3.58>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.2, 1.0>
    translate  <-0.475, 0.0, 3.57>
  }
  material {
    Aluminum99
  }
}
#declare CSG015 = difference {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.76, 0.76, 3.5>
    translate  0.020464*z
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.25, 0.35, 5.0>
    translate  0.4*x
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.45>
    translate  0.020464*z
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <0.3, 0.0, 3.5>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <-0.3, 0.0, 3.5>
  }
}
#declare CSG016 = union {
  object {CSG1010}
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Aluminum99
    }
    translate  -1.0*z
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.8, 0.8, 4.0>
  }
}
#declare CSG017 = difference {
  object { CSG016 }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    translate  4.6*z
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    translate  -1.25*z
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.78, 0.78, 1.0>
    translate  3.340084*z
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <1.0, 1.0, 0.75>
    translate  -0.75*z
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.5>
  }
  material {
    Aluminum99
  }
}
#declare popcan2 = union {
  object { CSG014 }
  object { CSG015 }
  object { CSG017 }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale 0.05
    translate  3.55*z
  }
  scale 0.04
  rotate <45.0, -90.0, 0.0>
  translate  <0.876652, 1.343684, -0.859671>
}
#declare CSG018 = difference {
  superellipsoid { // SuperQ013
    <0.7, 0.1>
    material {
      Aluminum99
    }
    scale <0.4, 0.3, 0.03>
    rotate 10.0*y
    translate  <-0.275, 0.0, 3.6>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.175, 1.0>
    translate  <-0.1, 0.0, 3.58>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.2, 1.0>
    translate  <-0.475, 0.0, 3.57>
  }
  material {
    Aluminum99
  }
}
#declare CSG019 = difference {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.76, 0.76, 3.5>
    translate  0.020464*z
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.25, 0.35, 5.0>
    translate  0.4*x
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.45>
    translate  0.020464*z
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <0.3, 0.0, 3.5>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.4, 0.4, 1.0>
    translate  <-0.3, 0.0, 3.5>
  }
}
#declare CSG020 = union {
  object {CSG1010}
  cone { // Cone005
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Aluminum99
    }
    translate  -1.0*z
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.8, 0.8, 4.0>
  }
}
#declare CSG021 = difference {
  object { CSG020 }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    translate  4.6*z
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum99
    }
    translate  -1.25*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.78, 0.78, 1.0>
    translate  3.340084*z
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale <1.0, 1.0, 0.75>
    translate  -0.75*z
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale <0.75, 0.75, 3.5>
  }
  material {
    Aluminum99
  }
}
#declare popcan3 = union {
  object { CSG018 }
  object { CSG019 }
  object { CSG021 }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum99
    }
    scale 0.05
    translate  3.55*z
  }
  scale 0.04   
  rotate <0, 0, 22.5>
  translate  <0.908951, 1.257036, -0.888671>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.666667, -0.986395>,
  <-0.176871, -0.986395>,
  <-0.176871, 0.891156>,
  <-0.371429, 0.885714>,
  <-0.475374, 0.809932>,
  <-0.496599, 0.687075>,
  <-0.445816, 0.654094>,
  <-0.42381, 0.560119>,
  <-0.487833, 0.469246>,
  <-0.556259, 0.39824>,
  <-0.653493, 0.227586>,
  <-0.668027, -0.004422>,
  <-0.666667, -0.986395>
  rotate -x*90
  material {
    T_Wood1
  }
  scale <0.03, 0.04, 3.5>
  rotate <90.0, 0.0, 90.0>
  translate  <-1.745633, 2.905746, -0.85821>
}
#declare CSG022 = union {
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyRubber
    }
    scale <0.025, 0.05, 0.025>
    translate  <-0.739863, -0.000017, 0.095591>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreyRubber
    }
    scale <0.025, 0.05, 0.025>
    translate  <-0.739863, 0.157183, 0.095591>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.539863, -0.000017, 0.095591>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.539863, 0.157183, 0.095591>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.539863, -0.157217, 0.095591>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.339863, -0.000017, 0.095591>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.339863, 0.157183, 0.095591>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.339863, -0.157217, 0.095591>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.139863, -0.000017, 0.095591>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.139863, 0.157183, 0.095591>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <-0.139863, -0.157217, 0.095591>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <0.060137, -0.157217, 0.095591>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <0.060137, 0.157183, 0.095591>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.05, 0.025>
    translate  <0.060137, -0.000017, 0.095591>
  }
  material {
    GreyRubber
  }
}
#declare CSG023 = difference {
  superellipsoid { // SuperQ015
    <0.1, 0.05>
    scale <1.0, 0.25, 0.1>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.25, 0.1>
    translate  <-0.34, 0.0, 0.19>
  }
  material {
    BlackPlastic
  }
}
#declare RemoteControl = union {
  object { CSG022 }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      GreenRubber
    }
    scale <0.025, 0.05, 0.025>
    translate  <-0.739863, -0.157217, 0.095591>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass99
    }
    scale <0.025, 0.1, 0.1>
    translate  <0.87, 0.0, 0.01>
  }
  object { CSG023 }
  scale 0.075
  rotate 138.58696*z
  translate  <-0.05937, 1.822199, -0.495189>
}
union { // CSG024
  superellipsoid { // SuperQ014
    <0.1, 0.1>
    material {
      CarpetTexture
    }
    scale <0.755558, 0.447252, 0.01>
    translate  <-0.522439, 0.985145, -0.880151>
  }
  object { TransSweep001 }
  object { WindowLatch1 }
  object { WindowTrack1 }
  object { HalogenTorchiere }
  object { Window1 }
  object { CSG001 }
  
 box { // LeftWall
    <-1, -1, -1>, <1, 1, 1>
    material {
      WallTexture
    }
    scale <0.1, 3.5, 1.5>
    translate  <-1.638508, 0.140896, 0.0>
  } 
  
  box { // Ceiling
    <-1, -1, -1>, <1, 1, 1>
    material {
      CeilingTexture
    }
    scale <2.5, 3.5, 0.1>
    translate  1.0*z
  } 
  box { // RightWall
    <-1, -1, -1>, <1, 1, 1>
    material {
      WallTexture
    }
    scale <0.1, 3.5, 1.5>
    translate  <1.75, 0.118598, 0.0>
  } 
  box { // Floor
    <-1, -1, -1>, <1, 1, 1>
    material {
      WoodFloor
      rotate <0.304139, 60.669487, -89.498848>
    }
    scale <2.5, 3.5, 0.1>
    translate  -1.0*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood1
      rotate <72.985428, 0.89251, 88.926628>
    }
    scale <0.5, 0.15, 0.025>
    translate  <0.8, 3.0, -0.59377>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood1
      rotate <68.582962, -0.0, 89.365814>
    }
    scale <0.5, 0.15, 0.025>
    translate  <-0.8, 3.0, -0.59377>
  }
  object { Window2 }
  object { CSG007 }
  object { WindowTrack2 }
  object { WindowLatch2 }
  object { PizzaBox }
  object { popcan1 }
  object { popcan2 }
  object { popcan3 }
  object { TransSweep002 }
  object { RemoteControl }
}

object 
  { 
  Jeans 
  
  rotate <110, 0, 0>
  rotate <0, 0, -170>    
  rotate <0, -2.5, 0>
  scale <.165, .165, .1525>
  translate <-.75, 2., -.315>
  
  }

object 
  {
  City
  rotate <90, 0, 0>    
  rotate <0, 0, 0>
  translate <0, 400, -15>
  }


object 
  {
  Speaker              
  scale 1.2
  translate <1.46159, 1.75192, -.6611>
  }
               
               
object
  {
  Poster99
  }               

